import{s as Tc,o as _c,n as x}from"../chunks/scheduler.6062bdaf.js";import{S as $c,i as wc,g as m,s as l,r as u,A as vc,h as d,f as i,c as r,j as v,u as g,x as _,k as j,y as o,a as c,v as h,d as f,t as b,w as y}from"../chunks/index.4bca734e.js";import{T as C}from"../chunks/Tip.b9ac1f03.js";import{D as J}from"../chunks/Docstring.def8e93d.js";import{C as R}from"../chunks/CodeBlock.cbbddafc.js";import{E as U}from"../chunks/ExampleCodeBlock.26ecf94b.js";import{H as k,E as jc}from"../chunks/index.6c92e143.js";function Jc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function xc(w){let n,T="Example of text generation:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwQXJ0aHVyJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBZ2VuX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDZG9fc2FtcGxlJTNEVHJ1ZSUyQ3RlbXBlcmF0dXJlJTNEMC45JTJDJTIwbWluX2xlbmd0aCUzRDIwJTJDbWF4X2xlbmd0aCUzRDIwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs,do_sample=<span class="hljs-literal">True</span>,temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>,max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function kc(w){let n,T="Example using <code>transformers.pipelines</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBb25ueF9nZW4lMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEFydGh1ciUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjIlMEFnZW4lMjAlM0QlMjBvbm54X2dlbih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_gen = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = onnx_gen(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Uc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Rc(w){let n,T="Example of feature extraction:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">28996</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-12vwt80"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Zc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JNYXNrZWRMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZSglMjJmaWxsLW1hc2slMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMCU1Qk1BU0slNUQuJTIyJTBBcHJlZCUyMCUzRCUyMGZpbGxfbWFza2VyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = fill_masker(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Wc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Cc(w){let n,T="Example of text generation:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ0NS1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTXklMjBuYW1lJTIwaXMlMjBFdXN0YWNoZSUyMGFuZCUyMEklMjBsaWtlJTIwdG8lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Eustache and I like to&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Ic(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19kZSUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwRXVzdGFjaGUuJTIyJTBBcHJlZCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_de&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Eustache.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_translation(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Fc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Gc(w){let n,T="Example of single-label classification:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-ykxpe4"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Vc(w){let n,T="Example using <code>transformers.pipelines</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBb25ueF9jbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9jbGFzc2lmaWVyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_classifier(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Xc(w){let n,T="Example using zero-shot-classification <code>transformers.pipelines</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLW1ubGklMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQW9ubnhfejAlMjAlM0QlMjBwaXBlbGluZSglMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXNlcXVlbmNlX3RvX2NsYXNzaWZ5JTIwJTNEJTIwJTIyV2hvJTIwYXJlJTIweW91JTIwdm90aW5nJTIwZm9yJTIwaW4lMjAyMDIwJTNGJTIyJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMkV1cm9wZSUyMiUyQyUyMCUyMnB1YmxpYyUyMGhlYWx0aCUyMiUyQyUyMCUyMnBvbGl0aWNzJTIyJTJDJTIwJTIyZWxlY3Rpb25zJTIyJTVEJTBBcHJlZCUyMCUzRCUyMG9ubnhfejAoc2VxdWVuY2VfdG9fY2xhc3NpZnklMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_z0 = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_to_classify = <span class="hljs-string">&quot;Who are you voting for in 2020?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;Europe&quot;</span>, <span class="hljs-string">&quot;public health&quot;</span>, <span class="hljs-string">&quot;politics&quot;</span>, <span class="hljs-string">&quot;elections&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_z0(sequence_to_classify, candidate_labels, multi_label=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1vtj8d2"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Nc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Sc(w){let n,T="Example of token classification:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-rtgw80"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function zc(w){let n,T="Example using <code>transformers.pipelines</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQW9ubnhfbmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9uZXIodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ner = pipeline(<span class="hljs-string">&quot;token-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ner(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Bc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function qc(w){let n,T="Example of mutliple choice:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlaGR3bnMxNTE2JTJGYmVydC1iYXNlLXVuY2FzZWRfU1dBRyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmVoZHduczE1MTYlMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFudW1fY2hvaWNlcyUyMCUzRCUyMDQlMEFmaXJzdF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUyMk1lbWJlcnMlMjBvZiUyMHRoZSUyMHByb2Nlc3Npb24lMjB3YWxrJTIwZG93biUyMHRoZSUyMHN0cmVldCUyMGhvbGRpbmclMjBzbWFsbCUyMGhvcm4lMjBicmFzcyUyMGluc3RydW1lbnRzLiUyMiU1RCUyMColMjBudW1fY2hvaWNlcyUwQXNlY29uZF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHBhc3NlcyUyMGJ5JTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBwbGF5aW5nJTIwdGhlaXIlMjBpbnN0cnVtZW50cy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBoYXMlMjBoZWFyZCUyMGFwcHJvYWNoaW5nJTIwdGhlbS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBhcnJpdmVzJTIwYW5kJTIwdGhleSdyZSUyMG91dHNpZGUlMjBkYW5jaW5nJTIwYW5kJTIwYXNsZWVwLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHR1cm5zJTIwdGhlJTIwbGVhZCUyMHNpbmdlciUyMHdhdGNoZXMlMjB0aGUlMjBwZXJmb3JtYW5jZS4lMjIlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZmlyc3Rfc2VudGVuY2UlMkMlMjBzZWNvbmRfc2VudGVuY2UlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QmslNUQlMjAlM0QlMjAlNUJ2JTVCaSUzQSUyMGklMjAlMkIlMjBudW1fY2hvaWNlcyU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4odiklMkMlMjBudW1fY2hvaWNlcyklNUQlMEFpbnB1dHMlMjAlM0QlMjBkaWN0KGlucHV0cy5jb252ZXJ0X3RvX3RlbnNvcnModGVuc29yX3R5cGUlM0QlMjJwdCUyMikpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-lfckvi"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Oc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Ec(w){let n,T="Example of question answering:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEc3RhcnRfcG9zaXRpb25zJTJDJTIwZW5kX3Bvc2l0aW9ucyUzRGVuZF9wb3NpdGlvbnMpJTBBc3RhcnRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMlMEFlbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">3</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1ml1brl"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Hc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question, text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Lc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Qc(w){let n,T="Example of image classification:",a,s,M;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1nh3zco"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Yc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,M;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW9ubnhfaW1hZ2VfY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9jbGFzc2lmaWVyKHVybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_classifier = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_classifier(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Pc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Ac(w){let n,T="Example of semantic segmentation:",a,s,M;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1wzzaup"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Dc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,M;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW9ubnhfaW1hZ2Vfc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9zZWdtZW50ZXIodXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_segmenter(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Kc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function eu(w){let n,T="Example of audio classification:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1mp8f15"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function tu(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZodWJlcnQtYmFzZS1zdXBlcmIta3MlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW9ubnhfYWMlMjAlM0QlMjBwaXBlbGluZSglMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yKSUwQSUwQXByZWQlMjAlM0QlMjBvbm54X2FjKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ac = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model, feature_extractor=feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ac(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function nu(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function su(w){let n,T="Example of audio frame classification:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME9SVE1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  ORTModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-12boqdm"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function ou(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function au(w){let n,T="Example of CTC:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCTC.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-mdyxnj"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function lu(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function ru(w){let n,T="Example of text generation:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTNEaW5wdXRzLmlucHV0X2ZlYXR1cmVzKSUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(inputs=inputs.input_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function iu(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFzcGVlY2hfcmVjb2duaXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciklMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBcHJlZCUyMCUzRCUyMHNwZWVjaF9yZWNvZ25pdGlvbihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>speech_recognition = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, tokenizer=processor.tokenizer, feature_extractor=processor.feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = speech_recognition(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function pu(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function mu(w){let n,T="Example of Audio XVector:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvWFZlY3RvciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zdiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1kzdm5c"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function du(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function cu(w){let n,T="Example of text generation:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIybmxwY29ubmVjdCUyRnZpdC1ncHQyLWltYWdlLWNhcHRpb25pbmclMjIlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function uu(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3RvX3RleHQlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS10by10ZXh0JTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJvY2Vzc29yJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTNEcHJvY2Vzc29yKSUwQXByZWQlMjAlM0QlMjBpbWFnZV90b190ZXh0KGltYWdlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=model, tokenizer=tokenizer, feature_extractor=processor, image_processor=processor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = image_to_text(image)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function gu(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function hu(w){let n,T="Example of pix2struct:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUGl4MlN0cnVjdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcGl4MnN0cnVjdC1haTJkLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclBpeDJTdHJ1Y3QuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBpeDJzdHJ1Y3QtYWkyZC1iYXNlJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHVzZV9pb19iaW5kaW5nJTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmFpMmQtZGVtby5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwbGFiZWwlMjAxNSUyMHJlcHJlc2VudCUzRiUyMCgxKSUyMGxhdmElMjAoMiklMjBjb3JlJTIwKDMpJTIwdHVubmVsJTIwKDQpJTIwYXNoJTIwY2xvdWQlMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForPix2Struct
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForPix2Struct.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/ai2d-demo.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What does the label 15 represent? (1) lava (2) core (3) tunnel (4) ash cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-11ikyn3"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function fu(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function bu(w){let n,T="Example of custom tasks(e.g. a sentence transformers taking <code>pooler_output</code> as output):",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2JlcnQtYWxsLU1pbmlMTS1MNi13aXRoLXBvb2xlciUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlcl9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I love burritos!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooler_output = outputs.pooler_output`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-6kynse"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function yu(w){let n,T="Example using <code>transformers.pipelines</code>(only if the task is supported):",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNiZXJ0LWFsbC1NaW5pTE0tTDYtd2l0aC1wb29sZXIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUwQXByZWQlMjAlM0QlMjBvbm54X2V4dHJhY3Rvcih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I love burritos!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-xxeb0k"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function Mu(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:x,d(a){a&&i(n)}}}function Tu(w){let n,T="Example of feature extraction:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBHZXJtYW55LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGUuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-12vwt80"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function _u(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,M;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9leHRyYWN0b3IodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),M=!0},p:x,i(t){M||(f(s.$$.fragment,t),M=!0)},o(t){b(s.$$.fragment,t),M=!1},d(t){t&&(i(n),i(a)),y(s,t)}}}function $u(w){let n,T,a,s,M,t,$,tl,hn,Zm="The following ORT classes are available for instantiating a base model class without a specific head.",nl,fn,sl,Z,bn,_r,bo,Wm="Base class for implementing models using ONNX Runtime.",$r,yo,Cm=`The ORTModel implements generic methods for interacting with the Hugging Face Hub as well as exporting vanilla
transformers models to ONNX using <code>optimum.exporters.onnx</code> toolchain.`,wr,Mo,Im="Class attributes:",vr,To,Fm=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;onnx_model&quot;</code>) — The name of the model type to use when
registering the ORTModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The “AutoModel” class to represented by the
current ORTModel class.</li>`,jr,_o,Gm="Common attributes:",Jr,$o,Vm=`<li>model (<code>ort.InferenceSession</code>) — The ONNX Runtime InferenceSession that is running the model.</li> <li>config (<a href="https://huggingface.co/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> — The configuration of the model.</li> <li>use_io_binding (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) — Whether to use I/O bindings with <strong>ONNX Runtime
with the CUDAExecutionProvider</strong>, this can significantly speedup inference depending on the task.</li> <li>model_save_dir (<code>Path</code>) — The directory where the model exported to ONNX is saved.
By defaults, if the loaded model is local, the directory where the original model will be used. Otherwise, the
cache directory is used.</li> <li>providers (\`List[str]) — The list of execution providers available to ONNX Runtime.</li>`,xr,at,yn,kr,wo,Xm="Returns whether this model can generate sequences with <code>.generate()</code>.",Ur,lt,Mn,Rr,vo,Nm="Instantiate a pretrained model from a pre-trained model configuration.",Zr,rt,Tn,Wr,jo,Sm=`Loads an ONNX Inference session with a given provider. Default provider is <code>CPUExecutionProvider</code> to match the
default behaviour in PyTorch/TensorFlow/JAX.`,Cr,it,_n,Ir,Jo,zm="Raises an error if IO Binding is requested although the tensor used are numpy arrays.",Fr,pt,$n,Gr,xo,Bm="Initializes attributes that may be shared among several ONNX Runtime inference sesssions.",Vr,mt,wn,Xr,ko,qm="Changes the ONNX Runtime provider according to the device.",ol,vn,al,jn,Om="The following ORT classes are available for the following natural language processing tasks.",ll,Jn,rl,F,xn,Nr,Uo,Em="ONNX model with a causal language modeling head for ONNX Runtime inference. This class officially supports bloom, codegen, falcon, gpt2, gpt_bigcode, gpt_neo, gpt_neox, gptj, llama.",Sr,Ro,Hm=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,zr,Zo,Lm='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Br,ee,kn,qr,Wo,Qm="The <code>ORTModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method.",Or,dt,Er,ct,Hr,ut,il,Un,pl,G,Rn,Lr,Co,Ym="ONNX Model with a MaskedLMOutput for masked language modeling tasks. This class officially supports albert, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.",Qr,Io,Pm=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Yr,Fo,Am='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Pr,te,Zn,Ar,Go,Dm="The <code>ORTModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method.",Dr,gt,Kr,ht,ei,ft,ml,Wn,dl,V,Cn,ti,Vo,Km="Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports bart, blenderbot, blenderbot_small, longt5, m2m_100, marian, mbart, mt5, pegasus, t5.",ni,Xo,ed=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,si,No,td='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',oi,ne,In,ai,So,nd="The <code>ORTModelForSeq2SeqLM</code> forward method, overrides the <code>__call__</code> special method.",li,bt,ri,yt,ii,Mt,cl,Fn,ul,X,Gn,pi,zo,sd=`ONNX Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks. This class officially supports albert, bart, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,mi,Bo,od=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,di,qo,ad='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ci,I,Vn,ui,Oo,ld="The <code>ORTModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method.",gi,Tt,hi,_t,fi,$t,bi,wt,gl,Xn,hl,N,Nn,yi,Eo,rd=`ONNX Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks. This class officially supports albert, bert, bloom, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, gpt2, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Mi,Ho,id=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ti,Lo,pd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',_i,se,Sn,$i,Qo,md="The <code>ORTModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method.",wi,vt,vi,jt,ji,Jt,fl,zn,bl,S,Bn,Ji,Yo,dd=`ONNX Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks. This class officially supports albert, bert, camembert, convbert, data2vec_text, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,xi,Po,cd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ki,Ao,ud='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ui,Be,qn,Ri,Do,gd="The <code>ORTModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method.",Zi,xt,Wi,kt,yl,On,Ml,z,En,Ci,Ko,hd="ONNX Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD. This class officially supports albert, bart, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, gptj, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.",Ii,ea,fd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Fi,ta,bd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Gi,oe,Hn,Vi,na,yd="The <code>ORTModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method.",Xi,Ut,Ni,Rt,Si,Zt,Tl,Ln,_l,Qn,Md="The following ORT classes are available for the following computer vision tasks.",$l,Yn,wl,B,Pn,zi,sa,Td="ONNX Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, data2vec_vision, deit, dinov2, levit, mobilenet_v1, mobilenet_v2, mobilevit, poolformer, resnet, segformer, swin, swinv2, vit.",Bi,oa,_d=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,qi,aa,$d='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Oi,ae,An,Ei,la,wd="The <code>ORTModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method.",Hi,Wt,Li,Ct,Qi,It,vl,Dn,jl,q,Kn,Yi,ra,vd="ONNX Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports maskformer, segformer.",Pi,ia,jd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ai,pa,Jd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Di,le,es,Ki,ma,xd="The <code>ORTModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method.",ep,Ft,tp,Gt,np,Vt,Jl,ts,xl,ns,kd="The following ORT classes are available for the following audio tasks.",kl,ss,Ul,O,os,sp,da,Ud=`ONNX Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting. This class officially supports audio_spectrogram_transformer, data2vec_audio, hubert, sew, sew_d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.`,op,ca,Rd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ap,ua,Zd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',lp,re,as,rp,ga,Wd="The <code>ORTModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method.",ip,Xt,pp,Nt,mp,St,Rl,ls,Zl,E,rs,dp,ha,Cd="ONNX Model with a frame classification head on top for tasks like Speaker Diarization. This class officially supports data2vec_audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",cp,fa,Id=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,up,ba,Fd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',gp,qe,is,hp,ya,Gd="The <code>ORTModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method.",fp,zt,bp,Bt,Wl,ps,Cl,H,ms,yp,Ma,Vd="ONNX Model with a language modeling head on top for Connectionist Temporal Classification (CTC). This class officially supports data2vec_audio, hubert, sew, sew_d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",Mp,Ta,Xd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Tp,_a,Nd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',_p,Oe,ds,$p,$a,Sd="The <code>ORTModelForCTC</code> forward method, overrides the <code>__call__</code> special method.",wp,qt,vp,Ot,Il,cs,Fl,L,us,jp,wa,zd="Speech Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports whisper, speech_to_text.",Jp,va,Bd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,xp,ja,qd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',kp,ie,gs,Up,Ja,Od="The <code>ORTModelForSpeechSeq2Seq</code> forward method, overrides the <code>__call__</code> special method.",Rp,Et,Zp,Ht,Wp,Lt,Gl,hs,Vl,Q,fs,Cp,xa,Ed="ONNX Model with an XVector feature extraction head on top for tasks like Speaker Verification. This class officially supports data2vec_audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",Ip,ka,Hd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Fp,Ua,Ld='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Gp,Ee,bs,Vp,Ra,Qd="The <code>ORTModelForAudioXVector</code> forward method, overrides the <code>__call__</code> special method.",Xp,Qt,Np,Yt,Xl,ys,Nl,Ms,Yd="The following ORT classes are available for the following multimodal tasks.",Sl,Ts,zl,Y,_s,Sp,Za,Pd="VisionEncoderDecoder Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports trocr and vision-encoder-decoder.",zp,Wa,Ad=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Bp,Ca,Dd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',qp,pe,$s,Op,Ia,Kd="The <code>ORTModelForVision2Seq</code> forward method, overrides the <code>__call__</code> special method.",Ep,Pt,Hp,At,Lp,Dt,Bl,ws,ql,P,vs,Qp,Fa,ec="Pix2struct model with a language modeling head for ONNX Runtime inference. This class officially supports pix2struct.",Yp,Ga,tc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Pp,Va,nc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ap,He,js,Dp,Xa,sc="The <code>ORTModelForPix2Struct</code> forward method, overrides the <code>__call__</code> special method.",Kp,Kt,em,en,Ol,Js,El,xs,oc="The following ORT classes are available for the following custom tasks.",Hl,ks,Ll,A,Us,tm,Na,ac="ONNX Model for any custom tasks. It can be used to leverage the inference acceleration for any single-file ONNX model, that may use custom inputs and outputs.",nm,Sa,lc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,sm,za,rc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',om,me,Rs,am,Ba,ic="The <code>ORTModelForCustomTasks</code> forward method, overrides the <code>__call__</code> special method.",lm,tn,rm,nn,im,sn,Ql,Zs,Yl,D,Ws,pm,qa,pc="ONNX Model for feature-extraction task.",mm,Oa,mc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,dm,Ea,dc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',cm,de,Cs,um,Ha,cc="The <code>ORTModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method.",gm,on,hm,an,fm,ln,Pl,Is,Al,Fs,Dl,De,Gs,bm,rn,Vs,ym,La,uc="Call self as a function.",Kl,Xs,er,Ke,Ns,Mm,pn,Ss,Tm,Qa,gc="Call self as a function.",tr,zs,nr,et,Bs,_m,mn,qs,$m,Ya,hc="Call self as a function.",sr,Os,or,tt,Es,wm,dn,Hs,vm,Pa,fc="Call self as a function.",ar,Ls,lr,nt,Qs,jm,cn,Ys,Jm,Aa,bc="Call self as a function.",rr,Ps,ir,st,As,xm,un,Ds,km,Da,yc="Call self as a function.",pr,Ks,mr,ot,eo,Um,gn,to,Rm,Ka,Mc="Call self as a function.",dr,no,cr,el,ur;return M=new k({props:{title:"Models",local:"models",headingTag:"h1"}}),$=new k({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),fn=new k({props:{title:"ORTModel",local:"optimum.onnxruntime.ORTModel",headingTag:"h3"}}),bn=new J({props:{name:"class optimum.onnxruntime.ORTModel",anchor:"optimum.onnxruntime.ORTModel",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L142"}}),yn=new J({props:{name:"can_generate",anchor:"optimum.onnxruntime.ORTModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L999"}}),Mn=new J({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTModel.from_pretrained",parameters:[{name:"model_id",val:": typing.Union[str, pathlib.Path]"},{name:"export",val:": bool = False"},{name:"force_download",val:": bool = False"},{name:"use_auth_token",val:": typing.Union[str, bool, NoneType] = None"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"subfolder",val:": str = ''"},{name:"config",val:": typing.Optional[ForwardRef('PretrainedConfig')] = None"},{name:"local_files_only",val:": bool = False"},{name:"revision",val:": typing.Optional[str] = None"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"provider_options",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.model_id",description:`<strong>model_id</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a model saved using <code>~OptimizedModel.save_pretrained</code>,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"model_id"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.export",description:`<strong>export</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Defines whether the provided <code>model_id</code> needs to be exported to the targeted format.`,name:"export"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
Deprecated. Please use the <code>token</code> argument instead.`,name:"use_auth_token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo either locally or on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.config",description:`<strong>config</strong> (<code>Optional[transformers.PretrainedConfig]</code>, defaults to <code>None</code>) &#x2014;
The model configuration.`,name:"config"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>Optional[bool]</code>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling. This option should only be set
to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code present on
the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model. See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a> for
possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>), &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionaries corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_io_binding",description:`<strong>use_io_binding</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
Whether to use IOBinding during inference to avoid memory copy between the host and device, or between numpy/torch tensors and ONNX Runtime ORTValue. Defaults to
<code>True</code> if the execution provider is CUDAExecutionProvider. For [~onnxruntime.ORTModelForCausalLM], defaults to <code>True</code> on CPUExecutionProvider,
in all other cases defaults to <code>False</code>.`,name:"use_io_binding"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Will be passed to the underlying model loading methods.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L659",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded ORTModel model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`,parameterGroups:[{title:"Parameters for decoder models (ORTModelForCausalLM, ORTModelForSeq2SeqLM, ORTModelForSeq2SeqLM, ORTModelForSpeechSeq2Seq, ORTModelForVision2Seq)",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_cache",description:`<strong>use_cache</strong> (<code>Optional[bool]</code>, defaults to <code>True</code>) &#x2014;
Whether or not past key/values cache should be used. Defaults to <code>True</code>.`,name:"use_cache"}]},{title:"Parameters for ORTModelForCausalLM",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_merged",description:`<strong>use_merged</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
whether or not to use a single ONNX that handles both the decoding without and with past key values reuse. This option defaults
to <code>True</code> if loading from a local repository and a merged decoder is found. When exporting with <code>export=True</code>,
defaults to <code>False</code>. This option should be set to <code>True</code> to minimize memory usage.`,name:"use_merged"}]}]}}),Tn=new J({props:{name:"load_model",anchor:"optimum.onnxruntime.ORTModel.load_model",parameters:[{name:"path",val:": typing.Union[str, pathlib.Path]"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"provider_options",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.load_model.path",description:`<strong>path</strong> (<code>Union[str, Path]</code>) &#x2014;
Path of the ONNX model.`,name:"path"},{anchor:"optimum.onnxruntime.ORTModel.load_model.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model. See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a>
for possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.load_model.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>) &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.load_model.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionary corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L357"}}),_n=new J({props:{name:"raise_on_numpy_input_io_binding",anchor:"optimum.onnxruntime.ORTModel.raise_on_numpy_input_io_binding",parameters:[{name:"use_torch",val:": bool"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.raise_on_numpy_input_io_binding.use_torch",description:`<strong>use_torch</strong> (<code>bool</code>) &#x2014;
Whether the tensor used during inference are of type torch.Tensor or not.`,name:"use_torch"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L925"}}),$n=new J({props:{name:"shared_attributes_init",anchor:"optimum.onnxruntime.ORTModel.shared_attributes_init",parameters:[{name:"model",val:": InferenceSession"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L185"}}),wn=new J({props:{name:"to",anchor:"optimum.onnxruntime.ORTModel.to",parameters:[{name:"device",val:": typing.Union[torch.device, str, int]"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.to.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code> or <code>int</code>) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run
the model on the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too.`,name:"device"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the model placed on the requested device.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`}}),vn=new k({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),Jn=new k({props:{title:"ORTModelForCausalLM",local:"optimum.onnxruntime.ORTModelForCausalLM",headingTag:"h3"}}),xn=new J({props:{name:"class optimum.onnxruntime.ORTModelForCausalLM",anchor:"optimum.onnxruntime.ORTModelForCausalLM",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_decoder.py#L123"}}),kn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"use_cache_branch",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_decoder.py#L206"}}),dt=new C({props:{$$slots:{default:[Jc]},$$scope:{ctx:w}}}),ct=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example",$$slots:{default:[xc]},$$scope:{ctx:w}}}),ut=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example-2",$$slots:{default:[kc]},$$scope:{ctx:w}}}),Un=new k({props:{title:"ORTModelForMaskedLM",local:"optimum.onnxruntime.ORTModelForMaskedLM",headingTag:"h3"}}),Rn=new J({props:{name:"class optimum.onnxruntime.ORTModelForMaskedLM",anchor:"optimum.onnxruntime.ORTModelForMaskedLM",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1210"}}),Zn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1218"}}),gt=new C({props:{$$slots:{default:[Uc]},$$scope:{ctx:w}}}),ht=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example",$$slots:{default:[Rc]},$$scope:{ctx:w}}}),ft=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example-2",$$slots:{default:[Zc]},$$scope:{ctx:w}}}),Wn=new k({props:{title:"ORTModelForSeq2SeqLM",local:"optimum.onnxruntime.ORTModelForSeq2SeqLM",headingTag:"h3"}}),Cn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSeq2SeqLM",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1066"}}),In=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of input sequence tokens in the vocabulary of shape <code>(batch_size, encoder_sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, encoder_sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1078"}}),bt=new C({props:{$$slots:{default:[Wc]},$$scope:{ctx:w}}}),yt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example",$$slots:{default:[Cc]},$$scope:{ctx:w}}}),Mt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example-2",$$slots:{default:[Ic]},$$scope:{ctx:w}}}),Fn=new k({props:{title:"ORTModelForSequenceClassification",local:"optimum.onnxruntime.ORTModelForSequenceClassification",headingTag:"h3"}}),Gn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSequenceClassification",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1410"}}),Vn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1419"}}),Tt=new C({props:{$$slots:{default:[Fc]},$$scope:{ctx:w}}}),_t=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example",$$slots:{default:[Gc]},$$scope:{ctx:w}}}),$t=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-2",$$slots:{default:[Vc]},$$scope:{ctx:w}}}),wt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-3",$$slots:{default:[Xc]},$$scope:{ctx:w}}}),Xn=new k({props:{title:"ORTModelForTokenClassification",local:"optimum.onnxruntime.ORTModelForTokenClassification",headingTag:"h3"}}),Nn=new J({props:{name:"class optimum.onnxruntime.ORTModelForTokenClassification",anchor:"optimum.onnxruntime.ORTModelForTokenClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1504"}}),Sn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1514"}}),vt=new C({props:{$$slots:{default:[Nc]},$$scope:{ctx:w}}}),jt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example",$$slots:{default:[Sc]},$$scope:{ctx:w}}}),Jt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example-2",$$slots:{default:[zc]},$$scope:{ctx:w}}}),zn=new k({props:{title:"ORTModelForMultipleChoice",local:"optimum.onnxruntime.ORTModelForMultipleChoice",headingTag:"h3"}}),Bn=new J({props:{name:"class optimum.onnxruntime.ORTModelForMultipleChoice",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1593"}}),qn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1602"}}),xt=new C({props:{$$slots:{default:[Bc]},$$scope:{ctx:w}}}),kt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.example",$$slots:{default:[qc]},$$scope:{ctx:w}}}),On=new k({props:{title:"ORTModelForQuestionAnswering",local:"optimum.onnxruntime.ORTModelForQuestionAnswering",headingTag:"h3"}}),En=new J({props:{name:"class optimum.onnxruntime.ORTModelForQuestionAnswering",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1304"}}),Hn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1312"}}),Ut=new C({props:{$$slots:{default:[Oc]},$$scope:{ctx:w}}}),Rt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example",$$slots:{default:[Ec]},$$scope:{ctx:w}}}),Zt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example-2",$$slots:{default:[Hc]},$$scope:{ctx:w}}}),Ln=new k({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),Yn=new k({props:{title:"ORTModelForImageClassification",local:"optimum.onnxruntime.ORTModelForImageClassification",headingTag:"h3"}}),Pn=new J({props:{name:"class optimum.onnxruntime.ORTModelForImageClassification",anchor:"optimum.onnxruntime.ORTModelForImageClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1691"}}),An=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1699"}}),Wt=new C({props:{$$slots:{default:[Lc]},$$scope:{ctx:w}}}),Ct=new U({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example",$$slots:{default:[Qc]},$$scope:{ctx:w}}}),It=new U({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example-2",$$slots:{default:[Yc]},$$scope:{ctx:w}}}),Dn=new k({props:{title:"ORTModelForSemanticSegmentation",local:"optimum.onnxruntime.ORTModelForSemanticSegmentation",headingTag:"h3"}}),Kn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSemanticSegmentation",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1781"}}),es=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1789"}}),Ft=new C({props:{$$slots:{default:[Pc]},$$scope:{ctx:w}}}),Gt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example",$$slots:{default:[Ac]},$$scope:{ctx:w}}}),Vt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example-2",$$slots:{default:[Dc]},$$scope:{ctx:w}}}),ts=new k({props:{title:"Audio",local:"audio",headingTag:"h2"}}),ss=new k({props:{title:"ORTModelForAudioClassification",local:"optimum.onnxruntime.ORTModelForAudioClassification",headingTag:"h3"}}),os=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioClassification",anchor:"optimum.onnxruntime.ORTModelForAudioClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1875"}}),as=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_features",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1907"}}),Xt=new C({props:{$$slots:{default:[Kc]},$$scope:{ctx:w}}}),Nt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example",$$slots:{default:[eu]},$$scope:{ctx:w}}}),St=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example-2",$$slots:{default:[tu]},$$scope:{ctx:w}}}),ls=new k({props:{title:"ORTModelForAudioFrameClassification",local:"optimum.onnxruntime.ORTModelForAudioFrameClassification",headingTag:"h3"}}),rs=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioFrameClassification",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2166"}}),is=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2174"}}),zt=new C({props:{$$slots:{default:[nu]},$$scope:{ctx:w}}}),Bt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.example",$$slots:{default:[su]},$$scope:{ctx:w}}}),ps=new k({props:{title:"ORTModelForCTC",local:"optimum.onnxruntime.ORTModelForCTC",headingTag:"h3"}}),ms=new J({props:{name:"class optimum.onnxruntime.ORTModelForCTC",anchor:"optimum.onnxruntime.ORTModelForCTC",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1989"}}),ds=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCTC.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1997"}}),qt=new C({props:{$$slots:{default:[ou]},$$scope:{ctx:w}}}),Ot=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.example",$$slots:{default:[au]},$$scope:{ctx:w}}}),cs=new k({props:{title:"ORTModelForSpeechSeq2Seq",local:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",headingTag:"h3"}}),us=new J({props:{name:"class optimum.onnxruntime.ORTModelForSpeechSeq2Seq",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1166"}}),gs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward",parameters:[{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"cache_position",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Mel features extracted from the raw speech waveform.
<code>(batch_size, feature_size, encoder_sequence_length)</code>.`,name:"input_features"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1190"}}),Et=new C({props:{$$slots:{default:[lu]},$$scope:{ctx:w}}}),Ht=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example",$$slots:{default:[ru]},$$scope:{ctx:w}}}),Lt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example-2",$$slots:{default:[iu]},$$scope:{ctx:w}}}),hs=new k({props:{title:"ORTModelForAudioXVector",local:"optimum.onnxruntime.ORTModelForAudioXVector",headingTag:"h3"}}),fs=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioXVector",anchor:"optimum.onnxruntime.ORTModelForAudioXVector",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2085"}}),bs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2093"}}),Qt=new C({props:{$$slots:{default:[pu]},$$scope:{ctx:w}}}),Yt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.example",$$slots:{default:[mu]},$$scope:{ctx:w}}}),ys=new k({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),Ts=new k({props:{title:"ORTModelForVision2Seq",local:"optimum.onnxruntime.ORTModelForVision2Seq",headingTag:"h3"}}),_s=new J({props:{name:"class optimum.onnxruntime.ORTModelForVision2Seq",anchor:"optimum.onnxruntime.ORTModelForVision2Seq",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1303"}}),$s=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Features extracted from an Image. This tensor should be of shape
<code>(batch_size, num_channels, height, width)</code>.`,name:"pixel_values"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1348"}}),Pt=new C({props:{$$slots:{default:[du]},$$scope:{ctx:w}}}),At=new U({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example",$$slots:{default:[cu]},$$scope:{ctx:w}}}),Dt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example-2",$$slots:{default:[uu]},$$scope:{ctx:w}}}),ws=new k({props:{title:"ORTModelForPix2Struct",local:"optimum.onnxruntime.ORTModelForPix2Struct",headingTag:"h3"}}),vs=new J({props:{name:"class optimum.onnxruntime.ORTModelForPix2Struct",anchor:"optimum.onnxruntime.ORTModelForPix2Struct",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1433"}}),js=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward",parameters:[{name:"flattened_patches",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.flattened_patches",description:`<strong>flattened_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length, hidden_size)</code>) &#x2014;
Flattened pixel patches. the <code>hidden_size</code> is obtained by the following formula: <code>hidden_size</code> =
<code>num_channels</code> <em> <code>patch_size</code> </em> <code>patch_size</code>
The process of flattening the pixel patches is done by <code>Pix2StructProcessor</code>.`,name:"flattened_patches"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.
Pix2StructText uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1446"}}),Kt=new C({props:{$$slots:{default:[gu]},$$scope:{ctx:w}}}),en=new U({props:{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.example",$$slots:{default:[hu]},$$scope:{ctx:w}}}),Js=new k({props:{title:"Custom Tasks",local:"custom-tasks",headingTag:"h2"}}),ks=new k({props:{title:"ORTModelForCustomTasks",local:"optimum.onnxruntime.ORTModelForCustomTasks",headingTag:"h4"}}),Us=new J({props:{name:"class optimum.onnxruntime.ORTModelForCustomTasks",anchor:"optimum.onnxruntime.ORTModelForCustomTasks",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2313"}}),Rs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward",parameters:[{name:"**model_inputs",val:": typing.Union[torch.Tensor, numpy.ndarray]"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2319"}}),tn=new C({props:{$$slots:{default:[fu]},$$scope:{ctx:w}}}),nn=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example",$$slots:{default:[bu]},$$scope:{ctx:w}}}),sn=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example-2",$$slots:{default:[yu]},$$scope:{ctx:w}}}),Zs=new k({props:{title:"ORTModelForFeatureExtraction",local:"optimum.onnxruntime.ORTModelForFeatureExtraction",headingTag:"h4"}}),Ws=new J({props:{name:"class optimum.onnxruntime.ORTModelForFeatureExtraction",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1041"}}),Cs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"position_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_features",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1049"}}),on=new C({props:{$$slots:{default:[Mu]},$$scope:{ctx:w}}}),an=new U({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example",$$slots:{default:[Tu]},$$scope:{ctx:w}}}),ln=new U({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example-2",$$slots:{default:[_u]},$$scope:{ctx:w}}}),Is=new k({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),Fs=new k({props:{title:"ORTDiffusionPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",headingTag:"h4"}}),Gs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/utils/dummy_diffusers_objects.py#L18"}}),Vs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Xs=new k({props:{title:"ORTStableDiffusionPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",headingTag:"h4"}}),Ns=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/utils/dummy_diffusers_objects.py#L62"}}),Ss=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),zs=new k({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",headingTag:"h4"}}),Bs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/utils/dummy_diffusers_objects.py#L73"}}),qs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Os=new k({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",headingTag:"h4"}}),Es=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/utils/dummy_diffusers_objects.py#L84"}}),Hs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ls=new k({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",headingTag:"h4"}}),Qs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/utils/dummy_diffusers_objects.py#L95"}}),Ys=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ps=new k({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),As=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/utils/dummy_diffusers_objects.py#L106"}}),Ds=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ks=new k({props:{title:"ORTLatentConsistencyModelPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",headingTag:"h4"}}),eo=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/utils/dummy_diffusers_objects.py#L128"}}),to=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),no=new jc({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/onnxruntime/package_reference/modeling_ort.mdx"}}),{c(){n=m("meta"),T=l(),a=m("p"),s=l(),u(M.$$.fragment),t=l(),u($.$$.fragment),tl=l(),hn=m("p"),hn.textContent=Zm,nl=l(),u(fn.$$.fragment),sl=l(),Z=m("div"),u(bn.$$.fragment),_r=l(),bo=m("p"),bo.textContent=Wm,$r=l(),yo=m("p"),yo.innerHTML=Cm,wr=l(),Mo=m("p"),Mo.textContent=Im,vr=l(),To=m("ul"),To.innerHTML=Fm,jr=l(),_o=m("p"),_o.textContent=Gm,Jr=l(),$o=m("ul"),$o.innerHTML=Vm,xr=l(),at=m("div"),u(yn.$$.fragment),kr=l(),wo=m("p"),wo.innerHTML=Xm,Ur=l(),lt=m("div"),u(Mn.$$.fragment),Rr=l(),vo=m("p"),vo.textContent=Nm,Zr=l(),rt=m("div"),u(Tn.$$.fragment),Wr=l(),jo=m("p"),jo.innerHTML=Sm,Cr=l(),it=m("div"),u(_n.$$.fragment),Ir=l(),Jo=m("p"),Jo.textContent=zm,Fr=l(),pt=m("div"),u($n.$$.fragment),Gr=l(),xo=m("p"),xo.textContent=Bm,Vr=l(),mt=m("div"),u(wn.$$.fragment),Xr=l(),ko=m("p"),ko.textContent=qm,ol=l(),u(vn.$$.fragment),al=l(),jn=m("p"),jn.textContent=Om,ll=l(),u(Jn.$$.fragment),rl=l(),F=m("div"),u(xn.$$.fragment),Nr=l(),Uo=m("p"),Uo.textContent=Em,Sr=l(),Ro=m("p"),Ro.innerHTML=Hm,zr=l(),Zo=m("p"),Zo.innerHTML=Lm,Br=l(),ee=m("div"),u(kn.$$.fragment),qr=l(),Wo=m("p"),Wo.innerHTML=Qm,Or=l(),u(dt.$$.fragment),Er=l(),u(ct.$$.fragment),Hr=l(),u(ut.$$.fragment),il=l(),u(Un.$$.fragment),pl=l(),G=m("div"),u(Rn.$$.fragment),Lr=l(),Co=m("p"),Co.textContent=Ym,Qr=l(),Io=m("p"),Io.innerHTML=Pm,Yr=l(),Fo=m("p"),Fo.innerHTML=Am,Pr=l(),te=m("div"),u(Zn.$$.fragment),Ar=l(),Go=m("p"),Go.innerHTML=Dm,Dr=l(),u(gt.$$.fragment),Kr=l(),u(ht.$$.fragment),ei=l(),u(ft.$$.fragment),ml=l(),u(Wn.$$.fragment),dl=l(),V=m("div"),u(Cn.$$.fragment),ti=l(),Vo=m("p"),Vo.textContent=Km,ni=l(),Xo=m("p"),Xo.innerHTML=ed,si=l(),No=m("p"),No.innerHTML=td,oi=l(),ne=m("div"),u(In.$$.fragment),ai=l(),So=m("p"),So.innerHTML=nd,li=l(),u(bt.$$.fragment),ri=l(),u(yt.$$.fragment),ii=l(),u(Mt.$$.fragment),cl=l(),u(Fn.$$.fragment),ul=l(),X=m("div"),u(Gn.$$.fragment),pi=l(),zo=m("p"),zo.textContent=sd,mi=l(),Bo=m("p"),Bo.innerHTML=od,di=l(),qo=m("p"),qo.innerHTML=ad,ci=l(),I=m("div"),u(Vn.$$.fragment),ui=l(),Oo=m("p"),Oo.innerHTML=ld,gi=l(),u(Tt.$$.fragment),hi=l(),u(_t.$$.fragment),fi=l(),u($t.$$.fragment),bi=l(),u(wt.$$.fragment),gl=l(),u(Xn.$$.fragment),hl=l(),N=m("div"),u(Nn.$$.fragment),yi=l(),Eo=m("p"),Eo.textContent=rd,Mi=l(),Ho=m("p"),Ho.innerHTML=id,Ti=l(),Lo=m("p"),Lo.innerHTML=pd,_i=l(),se=m("div"),u(Sn.$$.fragment),$i=l(),Qo=m("p"),Qo.innerHTML=md,wi=l(),u(vt.$$.fragment),vi=l(),u(jt.$$.fragment),ji=l(),u(Jt.$$.fragment),fl=l(),u(zn.$$.fragment),bl=l(),S=m("div"),u(Bn.$$.fragment),Ji=l(),Yo=m("p"),Yo.textContent=dd,xi=l(),Po=m("p"),Po.innerHTML=cd,ki=l(),Ao=m("p"),Ao.innerHTML=ud,Ui=l(),Be=m("div"),u(qn.$$.fragment),Ri=l(),Do=m("p"),Do.innerHTML=gd,Zi=l(),u(xt.$$.fragment),Wi=l(),u(kt.$$.fragment),yl=l(),u(On.$$.fragment),Ml=l(),z=m("div"),u(En.$$.fragment),Ci=l(),Ko=m("p"),Ko.textContent=hd,Ii=l(),ea=m("p"),ea.innerHTML=fd,Fi=l(),ta=m("p"),ta.innerHTML=bd,Gi=l(),oe=m("div"),u(Hn.$$.fragment),Vi=l(),na=m("p"),na.innerHTML=yd,Xi=l(),u(Ut.$$.fragment),Ni=l(),u(Rt.$$.fragment),Si=l(),u(Zt.$$.fragment),Tl=l(),u(Ln.$$.fragment),_l=l(),Qn=m("p"),Qn.textContent=Md,$l=l(),u(Yn.$$.fragment),wl=l(),B=m("div"),u(Pn.$$.fragment),zi=l(),sa=m("p"),sa.textContent=Td,Bi=l(),oa=m("p"),oa.innerHTML=_d,qi=l(),aa=m("p"),aa.innerHTML=$d,Oi=l(),ae=m("div"),u(An.$$.fragment),Ei=l(),la=m("p"),la.innerHTML=wd,Hi=l(),u(Wt.$$.fragment),Li=l(),u(Ct.$$.fragment),Qi=l(),u(It.$$.fragment),vl=l(),u(Dn.$$.fragment),jl=l(),q=m("div"),u(Kn.$$.fragment),Yi=l(),ra=m("p"),ra.textContent=vd,Pi=l(),ia=m("p"),ia.innerHTML=jd,Ai=l(),pa=m("p"),pa.innerHTML=Jd,Di=l(),le=m("div"),u(es.$$.fragment),Ki=l(),ma=m("p"),ma.innerHTML=xd,ep=l(),u(Ft.$$.fragment),tp=l(),u(Gt.$$.fragment),np=l(),u(Vt.$$.fragment),Jl=l(),u(ts.$$.fragment),xl=l(),ns=m("p"),ns.textContent=kd,kl=l(),u(ss.$$.fragment),Ul=l(),O=m("div"),u(os.$$.fragment),sp=l(),da=m("p"),da.textContent=Ud,op=l(),ca=m("p"),ca.innerHTML=Rd,ap=l(),ua=m("p"),ua.innerHTML=Zd,lp=l(),re=m("div"),u(as.$$.fragment),rp=l(),ga=m("p"),ga.innerHTML=Wd,ip=l(),u(Xt.$$.fragment),pp=l(),u(Nt.$$.fragment),mp=l(),u(St.$$.fragment),Rl=l(),u(ls.$$.fragment),Zl=l(),E=m("div"),u(rs.$$.fragment),dp=l(),ha=m("p"),ha.textContent=Cd,cp=l(),fa=m("p"),fa.innerHTML=Id,up=l(),ba=m("p"),ba.innerHTML=Fd,gp=l(),qe=m("div"),u(is.$$.fragment),hp=l(),ya=m("p"),ya.innerHTML=Gd,fp=l(),u(zt.$$.fragment),bp=l(),u(Bt.$$.fragment),Wl=l(),u(ps.$$.fragment),Cl=l(),H=m("div"),u(ms.$$.fragment),yp=l(),Ma=m("p"),Ma.textContent=Vd,Mp=l(),Ta=m("p"),Ta.innerHTML=Xd,Tp=l(),_a=m("p"),_a.innerHTML=Nd,_p=l(),Oe=m("div"),u(ds.$$.fragment),$p=l(),$a=m("p"),$a.innerHTML=Sd,wp=l(),u(qt.$$.fragment),vp=l(),u(Ot.$$.fragment),Il=l(),u(cs.$$.fragment),Fl=l(),L=m("div"),u(us.$$.fragment),jp=l(),wa=m("p"),wa.textContent=zd,Jp=l(),va=m("p"),va.innerHTML=Bd,xp=l(),ja=m("p"),ja.innerHTML=qd,kp=l(),ie=m("div"),u(gs.$$.fragment),Up=l(),Ja=m("p"),Ja.innerHTML=Od,Rp=l(),u(Et.$$.fragment),Zp=l(),u(Ht.$$.fragment),Wp=l(),u(Lt.$$.fragment),Gl=l(),u(hs.$$.fragment),Vl=l(),Q=m("div"),u(fs.$$.fragment),Cp=l(),xa=m("p"),xa.textContent=Ed,Ip=l(),ka=m("p"),ka.innerHTML=Hd,Fp=l(),Ua=m("p"),Ua.innerHTML=Ld,Gp=l(),Ee=m("div"),u(bs.$$.fragment),Vp=l(),Ra=m("p"),Ra.innerHTML=Qd,Xp=l(),u(Qt.$$.fragment),Np=l(),u(Yt.$$.fragment),Xl=l(),u(ys.$$.fragment),Nl=l(),Ms=m("p"),Ms.textContent=Yd,Sl=l(),u(Ts.$$.fragment),zl=l(),Y=m("div"),u(_s.$$.fragment),Sp=l(),Za=m("p"),Za.textContent=Pd,zp=l(),Wa=m("p"),Wa.innerHTML=Ad,Bp=l(),Ca=m("p"),Ca.innerHTML=Dd,qp=l(),pe=m("div"),u($s.$$.fragment),Op=l(),Ia=m("p"),Ia.innerHTML=Kd,Ep=l(),u(Pt.$$.fragment),Hp=l(),u(At.$$.fragment),Lp=l(),u(Dt.$$.fragment),Bl=l(),u(ws.$$.fragment),ql=l(),P=m("div"),u(vs.$$.fragment),Qp=l(),Fa=m("p"),Fa.textContent=ec,Yp=l(),Ga=m("p"),Ga.innerHTML=tc,Pp=l(),Va=m("p"),Va.innerHTML=nc,Ap=l(),He=m("div"),u(js.$$.fragment),Dp=l(),Xa=m("p"),Xa.innerHTML=sc,Kp=l(),u(Kt.$$.fragment),em=l(),u(en.$$.fragment),Ol=l(),u(Js.$$.fragment),El=l(),xs=m("p"),xs.textContent=oc,Hl=l(),u(ks.$$.fragment),Ll=l(),A=m("div"),u(Us.$$.fragment),tm=l(),Na=m("p"),Na.textContent=ac,nm=l(),Sa=m("p"),Sa.innerHTML=lc,sm=l(),za=m("p"),za.innerHTML=rc,om=l(),me=m("div"),u(Rs.$$.fragment),am=l(),Ba=m("p"),Ba.innerHTML=ic,lm=l(),u(tn.$$.fragment),rm=l(),u(nn.$$.fragment),im=l(),u(sn.$$.fragment),Ql=l(),u(Zs.$$.fragment),Yl=l(),D=m("div"),u(Ws.$$.fragment),pm=l(),qa=m("p"),qa.textContent=pc,mm=l(),Oa=m("p"),Oa.innerHTML=mc,dm=l(),Ea=m("p"),Ea.innerHTML=dc,cm=l(),de=m("div"),u(Cs.$$.fragment),um=l(),Ha=m("p"),Ha.innerHTML=cc,gm=l(),u(on.$$.fragment),hm=l(),u(an.$$.fragment),fm=l(),u(ln.$$.fragment),Pl=l(),u(Is.$$.fragment),Al=l(),u(Fs.$$.fragment),Dl=l(),De=m("div"),u(Gs.$$.fragment),bm=l(),rn=m("div"),u(Vs.$$.fragment),ym=l(),La=m("p"),La.textContent=uc,Kl=l(),u(Xs.$$.fragment),er=l(),Ke=m("div"),u(Ns.$$.fragment),Mm=l(),pn=m("div"),u(Ss.$$.fragment),Tm=l(),Qa=m("p"),Qa.textContent=gc,tr=l(),u(zs.$$.fragment),nr=l(),et=m("div"),u(Bs.$$.fragment),_m=l(),mn=m("div"),u(qs.$$.fragment),$m=l(),Ya=m("p"),Ya.textContent=hc,sr=l(),u(Os.$$.fragment),or=l(),tt=m("div"),u(Es.$$.fragment),wm=l(),dn=m("div"),u(Hs.$$.fragment),vm=l(),Pa=m("p"),Pa.textContent=fc,ar=l(),u(Ls.$$.fragment),lr=l(),nt=m("div"),u(Qs.$$.fragment),jm=l(),cn=m("div"),u(Ys.$$.fragment),Jm=l(),Aa=m("p"),Aa.textContent=bc,rr=l(),u(Ps.$$.fragment),ir=l(),st=m("div"),u(As.$$.fragment),xm=l(),un=m("div"),u(Ds.$$.fragment),km=l(),Da=m("p"),Da.textContent=yc,pr=l(),u(Ks.$$.fragment),mr=l(),ot=m("div"),u(eo.$$.fragment),Um=l(),gn=m("div"),u(to.$$.fragment),Rm=l(),Ka=m("p"),Ka.textContent=Mc,dr=l(),u(no.$$.fragment),cr=l(),el=m("p"),this.h()},l(e){const p=vc("svelte-u9bgzb",document.head);n=d(p,"META",{name:!0,content:!0}),p.forEach(i),T=r(e),a=d(e,"P",{}),v(a).forEach(i),s=r(e),g(M.$$.fragment,e),t=r(e),g($.$$.fragment,e),tl=r(e),hn=d(e,"P",{"data-svelte-h":!0}),_(hn)!=="svelte-uyecg"&&(hn.textContent=Zm),nl=r(e),g(fn.$$.fragment,e),sl=r(e),Z=d(e,"DIV",{class:!0});var W=v(Z);g(bn.$$.fragment,W),_r=r(W),bo=d(W,"P",{"data-svelte-h":!0}),_(bo)!=="svelte-12yueui"&&(bo.textContent=Wm),$r=r(W),yo=d(W,"P",{"data-svelte-h":!0}),_(yo)!=="svelte-zarm0s"&&(yo.innerHTML=Cm),wr=r(W),Mo=d(W,"P",{"data-svelte-h":!0}),_(Mo)!=="svelte-wz8va1"&&(Mo.textContent=Im),vr=r(W),To=d(W,"UL",{"data-svelte-h":!0}),_(To)!=="svelte-qpxha0"&&(To.innerHTML=Fm),jr=r(W),_o=d(W,"P",{"data-svelte-h":!0}),_(_o)!=="svelte-86gko0"&&(_o.textContent=Gm),Jr=r(W),$o=d(W,"UL",{"data-svelte-h":!0}),_($o)!=="svelte-1hugf7m"&&($o.innerHTML=Vm),xr=r(W),at=d(W,"DIV",{class:!0});var so=v(at);g(yn.$$.fragment,so),kr=r(so),wo=d(so,"P",{"data-svelte-h":!0}),_(wo)!=="svelte-1r2xt0l"&&(wo.innerHTML=Xm),so.forEach(i),Ur=r(W),lt=d(W,"DIV",{class:!0});var oo=v(lt);g(Mn.$$.fragment,oo),Rr=r(oo),vo=d(oo,"P",{"data-svelte-h":!0}),_(vo)!=="svelte-18vxhwp"&&(vo.textContent=Nm),oo.forEach(i),Zr=r(W),rt=d(W,"DIV",{class:!0});var ao=v(rt);g(Tn.$$.fragment,ao),Wr=r(ao),jo=d(ao,"P",{"data-svelte-h":!0}),_(jo)!=="svelte-1sb2z5w"&&(jo.innerHTML=Sm),ao.forEach(i),Cr=r(W),it=d(W,"DIV",{class:!0});var lo=v(it);g(_n.$$.fragment,lo),Ir=r(lo),Jo=d(lo,"P",{"data-svelte-h":!0}),_(Jo)!=="svelte-h8ck7o"&&(Jo.textContent=zm),lo.forEach(i),Fr=r(W),pt=d(W,"DIV",{class:!0});var ro=v(pt);g($n.$$.fragment,ro),Gr=r(ro),xo=d(ro,"P",{"data-svelte-h":!0}),_(xo)!=="svelte-1b4tey4"&&(xo.textContent=Bm),ro.forEach(i),Vr=r(W),mt=d(W,"DIV",{class:!0});var io=v(mt);g(wn.$$.fragment,io),Xr=r(io),ko=d(io,"P",{"data-svelte-h":!0}),_(ko)!=="svelte-1tdm1u4"&&(ko.textContent=qm),io.forEach(i),W.forEach(i),ol=r(e),g(vn.$$.fragment,e),al=r(e),jn=d(e,"P",{"data-svelte-h":!0}),_(jn)!=="svelte-1tlroh"&&(jn.textContent=Om),ll=r(e),g(Jn.$$.fragment,e),rl=r(e),F=d(e,"DIV",{class:!0});var ce=v(F);g(xn.$$.fragment,ce),Nr=r(ce),Uo=d(ce,"P",{"data-svelte-h":!0}),_(Uo)!=="svelte-pig4vj"&&(Uo.textContent=Em),Sr=r(ce),Ro=d(ce,"P",{"data-svelte-h":!0}),_(Ro)!=="svelte-1pmzjgn"&&(Ro.innerHTML=Hm),zr=r(ce),Zo=d(ce,"P",{"data-svelte-h":!0}),_(Zo)!=="svelte-7jrnx4"&&(Zo.innerHTML=Lm),Br=r(ce),ee=d(ce,"DIV",{class:!0});var ue=v(ee);g(kn.$$.fragment,ue),qr=r(ue),Wo=d(ue,"P",{"data-svelte-h":!0}),_(Wo)!=="svelte-1ox9av6"&&(Wo.innerHTML=Qm),Or=r(ue),g(dt.$$.fragment,ue),Er=r(ue),g(ct.$$.fragment,ue),Hr=r(ue),g(ut.$$.fragment,ue),ue.forEach(i),ce.forEach(i),il=r(e),g(Un.$$.fragment,e),pl=r(e),G=d(e,"DIV",{class:!0});var ge=v(G);g(Rn.$$.fragment,ge),Lr=r(ge),Co=d(ge,"P",{"data-svelte-h":!0}),_(Co)!=="svelte-lnzl0e"&&(Co.textContent=Ym),Qr=r(ge),Io=d(ge,"P",{"data-svelte-h":!0}),_(Io)!=="svelte-1pmzjgn"&&(Io.innerHTML=Pm),Yr=r(ge),Fo=d(ge,"P",{"data-svelte-h":!0}),_(Fo)!=="svelte-7jrnx4"&&(Fo.innerHTML=Am),Pr=r(ge),te=d(ge,"DIV",{class:!0});var he=v(te);g(Zn.$$.fragment,he),Ar=r(he),Go=d(he,"P",{"data-svelte-h":!0}),_(Go)!=="svelte-1xqof9m"&&(Go.innerHTML=Dm),Dr=r(he),g(gt.$$.fragment,he),Kr=r(he),g(ht.$$.fragment,he),ei=r(he),g(ft.$$.fragment,he),he.forEach(i),ge.forEach(i),ml=r(e),g(Wn.$$.fragment,e),dl=r(e),V=d(e,"DIV",{class:!0});var fe=v(V);g(Cn.$$.fragment,fe),ti=r(fe),Vo=d(fe,"P",{"data-svelte-h":!0}),_(Vo)!=="svelte-t6z30i"&&(Vo.textContent=Km),ni=r(fe),Xo=d(fe,"P",{"data-svelte-h":!0}),_(Xo)!=="svelte-1pmzjgn"&&(Xo.innerHTML=ed),si=r(fe),No=d(fe,"P",{"data-svelte-h":!0}),_(No)!=="svelte-7jrnx4"&&(No.innerHTML=td),oi=r(fe),ne=d(fe,"DIV",{class:!0});var be=v(ne);g(In.$$.fragment,be),ai=r(be),So=d(be,"P",{"data-svelte-h":!0}),_(So)!=="svelte-n65k7h"&&(So.innerHTML=nd),li=r(be),g(bt.$$.fragment,be),ri=r(be),g(yt.$$.fragment,be),ii=r(be),g(Mt.$$.fragment,be),be.forEach(i),fe.forEach(i),cl=r(e),g(Fn.$$.fragment,e),ul=r(e),X=d(e,"DIV",{class:!0});var ye=v(X);g(Gn.$$.fragment,ye),pi=r(ye),zo=d(ye,"P",{"data-svelte-h":!0}),_(zo)!=="svelte-ixbo5n"&&(zo.textContent=sd),mi=r(ye),Bo=d(ye,"P",{"data-svelte-h":!0}),_(Bo)!=="svelte-1pmzjgn"&&(Bo.innerHTML=od),di=r(ye),qo=d(ye,"P",{"data-svelte-h":!0}),_(qo)!=="svelte-7jrnx4"&&(qo.innerHTML=ad),ci=r(ye),I=d(ye,"DIV",{class:!0});var K=v(I);g(Vn.$$.fragment,K),ui=r(K),Oo=d(K,"P",{"data-svelte-h":!0}),_(Oo)!=="svelte-1plx9t"&&(Oo.innerHTML=ld),gi=r(K),g(Tt.$$.fragment,K),hi=r(K),g(_t.$$.fragment,K),fi=r(K),g($t.$$.fragment,K),bi=r(K),g(wt.$$.fragment,K),K.forEach(i),ye.forEach(i),gl=r(e),g(Xn.$$.fragment,e),hl=r(e),N=d(e,"DIV",{class:!0});var Me=v(N);g(Nn.$$.fragment,Me),yi=r(Me),Eo=d(Me,"P",{"data-svelte-h":!0}),_(Eo)!=="svelte-1l2d2mz"&&(Eo.textContent=rd),Mi=r(Me),Ho=d(Me,"P",{"data-svelte-h":!0}),_(Ho)!=="svelte-1pmzjgn"&&(Ho.innerHTML=id),Ti=r(Me),Lo=d(Me,"P",{"data-svelte-h":!0}),_(Lo)!=="svelte-7jrnx4"&&(Lo.innerHTML=pd),_i=r(Me),se=d(Me,"DIV",{class:!0});var Te=v(se);g(Sn.$$.fragment,Te),$i=r(Te),Qo=d(Te,"P",{"data-svelte-h":!0}),_(Qo)!=="svelte-xk2xch"&&(Qo.innerHTML=md),wi=r(Te),g(vt.$$.fragment,Te),vi=r(Te),g(jt.$$.fragment,Te),ji=r(Te),g(Jt.$$.fragment,Te),Te.forEach(i),Me.forEach(i),fl=r(e),g(zn.$$.fragment,e),bl=r(e),S=d(e,"DIV",{class:!0});var _e=v(S);g(Bn.$$.fragment,_e),Ji=r(_e),Yo=d(_e,"P",{"data-svelte-h":!0}),_(Yo)!=="svelte-1oobrgk"&&(Yo.textContent=dd),xi=r(_e),Po=d(_e,"P",{"data-svelte-h":!0}),_(Po)!=="svelte-1pmzjgn"&&(Po.innerHTML=cd),ki=r(_e),Ao=d(_e,"P",{"data-svelte-h":!0}),_(Ao)!=="svelte-7jrnx4"&&(Ao.innerHTML=ud),Ui=r(_e),Be=d(_e,"DIV",{class:!0});var Le=v(Be);g(qn.$$.fragment,Le),Ri=r(Le),Do=d(Le,"P",{"data-svelte-h":!0}),_(Do)!=="svelte-qesv8n"&&(Do.innerHTML=gd),Zi=r(Le),g(xt.$$.fragment,Le),Wi=r(Le),g(kt.$$.fragment,Le),Le.forEach(i),_e.forEach(i),yl=r(e),g(On.$$.fragment,e),Ml=r(e),z=d(e,"DIV",{class:!0});var $e=v(z);g(En.$$.fragment,$e),Ci=r($e),Ko=d($e,"P",{"data-svelte-h":!0}),_(Ko)!=="svelte-1hsozsl"&&(Ko.textContent=hd),Ii=r($e),ea=d($e,"P",{"data-svelte-h":!0}),_(ea)!=="svelte-1pmzjgn"&&(ea.innerHTML=fd),Fi=r($e),ta=d($e,"P",{"data-svelte-h":!0}),_(ta)!=="svelte-7jrnx4"&&(ta.innerHTML=bd),Gi=r($e),oe=d($e,"DIV",{class:!0});var we=v(oe);g(Hn.$$.fragment,we),Vi=r(we),na=d(we,"P",{"data-svelte-h":!0}),_(na)!=="svelte-1dng7rw"&&(na.innerHTML=yd),Xi=r(we),g(Ut.$$.fragment,we),Ni=r(we),g(Rt.$$.fragment,we),Si=r(we),g(Zt.$$.fragment,we),we.forEach(i),$e.forEach(i),Tl=r(e),g(Ln.$$.fragment,e),_l=r(e),Qn=d(e,"P",{"data-svelte-h":!0}),_(Qn)!=="svelte-1h2y3wu"&&(Qn.textContent=Md),$l=r(e),g(Yn.$$.fragment,e),wl=r(e),B=d(e,"DIV",{class:!0});var ve=v(B);g(Pn.$$.fragment,ve),zi=r(ve),sa=d(ve,"P",{"data-svelte-h":!0}),_(sa)!=="svelte-3c4m75"&&(sa.textContent=Td),Bi=r(ve),oa=d(ve,"P",{"data-svelte-h":!0}),_(oa)!=="svelte-1pmzjgn"&&(oa.innerHTML=_d),qi=r(ve),aa=d(ve,"P",{"data-svelte-h":!0}),_(aa)!=="svelte-7jrnx4"&&(aa.innerHTML=$d),Oi=r(ve),ae=d(ve,"DIV",{class:!0});var je=v(ae);g(An.$$.fragment,je),Ei=r(je),la=d(je,"P",{"data-svelte-h":!0}),_(la)!=="svelte-1azuqx"&&(la.innerHTML=wd),Hi=r(je),g(Wt.$$.fragment,je),Li=r(je),g(Ct.$$.fragment,je),Qi=r(je),g(It.$$.fragment,je),je.forEach(i),ve.forEach(i),vl=r(e),g(Dn.$$.fragment,e),jl=r(e),q=d(e,"DIV",{class:!0});var Je=v(q);g(Kn.$$.fragment,Je),Yi=r(Je),ra=d(Je,"P",{"data-svelte-h":!0}),_(ra)!=="svelte-wbsrrf"&&(ra.textContent=vd),Pi=r(Je),ia=d(Je,"P",{"data-svelte-h":!0}),_(ia)!=="svelte-1pmzjgn"&&(ia.innerHTML=jd),Ai=r(Je),pa=d(Je,"P",{"data-svelte-h":!0}),_(pa)!=="svelte-7jrnx4"&&(pa.innerHTML=Jd),Di=r(Je),le=d(Je,"DIV",{class:!0});var xe=v(le);g(es.$$.fragment,xe),Ki=r(xe),ma=d(xe,"P",{"data-svelte-h":!0}),_(ma)!=="svelte-1s27jle"&&(ma.innerHTML=xd),ep=r(xe),g(Ft.$$.fragment,xe),tp=r(xe),g(Gt.$$.fragment,xe),np=r(xe),g(Vt.$$.fragment,xe),xe.forEach(i),Je.forEach(i),Jl=r(e),g(ts.$$.fragment,e),xl=r(e),ns=d(e,"P",{"data-svelte-h":!0}),_(ns)!=="svelte-liyjdz"&&(ns.textContent=kd),kl=r(e),g(ss.$$.fragment,e),Ul=r(e),O=d(e,"DIV",{class:!0});var ke=v(O);g(os.$$.fragment,ke),sp=r(ke),da=d(ke,"P",{"data-svelte-h":!0}),_(da)!=="svelte-yleggj"&&(da.textContent=Ud),op=r(ke),ca=d(ke,"P",{"data-svelte-h":!0}),_(ca)!=="svelte-1pmzjgn"&&(ca.innerHTML=Rd),ap=r(ke),ua=d(ke,"P",{"data-svelte-h":!0}),_(ua)!=="svelte-7jrnx4"&&(ua.innerHTML=Zd),lp=r(ke),re=d(ke,"DIV",{class:!0});var Ue=v(re);g(as.$$.fragment,Ue),rp=r(Ue),ga=d(Ue,"P",{"data-svelte-h":!0}),_(ga)!=="svelte-p67kxo"&&(ga.innerHTML=Wd),ip=r(Ue),g(Xt.$$.fragment,Ue),pp=r(Ue),g(Nt.$$.fragment,Ue),mp=r(Ue),g(St.$$.fragment,Ue),Ue.forEach(i),ke.forEach(i),Rl=r(e),g(ls.$$.fragment,e),Zl=r(e),E=d(e,"DIV",{class:!0});var Re=v(E);g(rs.$$.fragment,Re),dp=r(Re),ha=d(Re,"P",{"data-svelte-h":!0}),_(ha)!=="svelte-lyybxc"&&(ha.textContent=Cd),cp=r(Re),fa=d(Re,"P",{"data-svelte-h":!0}),_(fa)!=="svelte-1pmzjgn"&&(fa.innerHTML=Id),up=r(Re),ba=d(Re,"P",{"data-svelte-h":!0}),_(ba)!=="svelte-7jrnx4"&&(ba.innerHTML=Fd),gp=r(Re),qe=d(Re,"DIV",{class:!0});var Qe=v(qe);g(is.$$.fragment,Qe),hp=r(Qe),ya=d(Qe,"P",{"data-svelte-h":!0}),_(ya)!=="svelte-18aced7"&&(ya.innerHTML=Gd),fp=r(Qe),g(zt.$$.fragment,Qe),bp=r(Qe),g(Bt.$$.fragment,Qe),Qe.forEach(i),Re.forEach(i),Wl=r(e),g(ps.$$.fragment,e),Cl=r(e),H=d(e,"DIV",{class:!0});var Ze=v(H);g(ms.$$.fragment,Ze),yp=r(Ze),Ma=d(Ze,"P",{"data-svelte-h":!0}),_(Ma)!=="svelte-xbkga4"&&(Ma.textContent=Vd),Mp=r(Ze),Ta=d(Ze,"P",{"data-svelte-h":!0}),_(Ta)!=="svelte-1pmzjgn"&&(Ta.innerHTML=Xd),Tp=r(Ze),_a=d(Ze,"P",{"data-svelte-h":!0}),_(_a)!=="svelte-7jrnx4"&&(_a.innerHTML=Nd),_p=r(Ze),Oe=d(Ze,"DIV",{class:!0});var Ye=v(Oe);g(ds.$$.fragment,Ye),$p=r(Ye),$a=d(Ye,"P",{"data-svelte-h":!0}),_($a)!=="svelte-1szjv6u"&&($a.innerHTML=Sd),wp=r(Ye),g(qt.$$.fragment,Ye),vp=r(Ye),g(Ot.$$.fragment,Ye),Ye.forEach(i),Ze.forEach(i),Il=r(e),g(cs.$$.fragment,e),Fl=r(e),L=d(e,"DIV",{class:!0});var We=v(L);g(us.$$.fragment,We),jp=r(We),wa=d(We,"P",{"data-svelte-h":!0}),_(wa)!=="svelte-135bhh9"&&(wa.textContent=zd),Jp=r(We),va=d(We,"P",{"data-svelte-h":!0}),_(va)!=="svelte-1pmzjgn"&&(va.innerHTML=Bd),xp=r(We),ja=d(We,"P",{"data-svelte-h":!0}),_(ja)!=="svelte-7jrnx4"&&(ja.innerHTML=qd),kp=r(We),ie=d(We,"DIV",{class:!0});var Ce=v(ie);g(gs.$$.fragment,Ce),Up=r(Ce),Ja=d(Ce,"P",{"data-svelte-h":!0}),_(Ja)!=="svelte-1e3zkhy"&&(Ja.innerHTML=Od),Rp=r(Ce),g(Et.$$.fragment,Ce),Zp=r(Ce),g(Ht.$$.fragment,Ce),Wp=r(Ce),g(Lt.$$.fragment,Ce),Ce.forEach(i),We.forEach(i),Gl=r(e),g(hs.$$.fragment,e),Vl=r(e),Q=d(e,"DIV",{class:!0});var Ie=v(Q);g(fs.$$.fragment,Ie),Cp=r(Ie),xa=d(Ie,"P",{"data-svelte-h":!0}),_(xa)!=="svelte-1bhc8y0"&&(xa.textContent=Ed),Ip=r(Ie),ka=d(Ie,"P",{"data-svelte-h":!0}),_(ka)!=="svelte-1pmzjgn"&&(ka.innerHTML=Hd),Fp=r(Ie),Ua=d(Ie,"P",{"data-svelte-h":!0}),_(Ua)!=="svelte-7jrnx4"&&(Ua.innerHTML=Ld),Gp=r(Ie),Ee=d(Ie,"DIV",{class:!0});var Pe=v(Ee);g(bs.$$.fragment,Pe),Vp=r(Pe),Ra=d(Pe,"P",{"data-svelte-h":!0}),_(Ra)!=="svelte-1fuxgrl"&&(Ra.innerHTML=Qd),Xp=r(Pe),g(Qt.$$.fragment,Pe),Np=r(Pe),g(Yt.$$.fragment,Pe),Pe.forEach(i),Ie.forEach(i),Xl=r(e),g(ys.$$.fragment,e),Nl=r(e),Ms=d(e,"P",{"data-svelte-h":!0}),_(Ms)!=="svelte-1gk58z"&&(Ms.textContent=Yd),Sl=r(e),g(Ts.$$.fragment,e),zl=r(e),Y=d(e,"DIV",{class:!0});var Fe=v(Y);g(_s.$$.fragment,Fe),Sp=r(Fe),Za=d(Fe,"P",{"data-svelte-h":!0}),_(Za)!=="svelte-1yhfevg"&&(Za.textContent=Pd),zp=r(Fe),Wa=d(Fe,"P",{"data-svelte-h":!0}),_(Wa)!=="svelte-1pmzjgn"&&(Wa.innerHTML=Ad),Bp=r(Fe),Ca=d(Fe,"P",{"data-svelte-h":!0}),_(Ca)!=="svelte-7jrnx4"&&(Ca.innerHTML=Dd),qp=r(Fe),pe=d(Fe,"DIV",{class:!0});var Ge=v(pe);g($s.$$.fragment,Ge),Op=r(Ge),Ia=d(Ge,"P",{"data-svelte-h":!0}),_(Ia)!=="svelte-11xalzp"&&(Ia.innerHTML=Kd),Ep=r(Ge),g(Pt.$$.fragment,Ge),Hp=r(Ge),g(At.$$.fragment,Ge),Lp=r(Ge),g(Dt.$$.fragment,Ge),Ge.forEach(i),Fe.forEach(i),Bl=r(e),g(ws.$$.fragment,e),ql=r(e),P=d(e,"DIV",{class:!0});var Ve=v(P);g(vs.$$.fragment,Ve),Qp=r(Ve),Fa=d(Ve,"P",{"data-svelte-h":!0}),_(Fa)!=="svelte-80a148"&&(Fa.textContent=ec),Yp=r(Ve),Ga=d(Ve,"P",{"data-svelte-h":!0}),_(Ga)!=="svelte-1pmzjgn"&&(Ga.innerHTML=tc),Pp=r(Ve),Va=d(Ve,"P",{"data-svelte-h":!0}),_(Va)!=="svelte-7jrnx4"&&(Va.innerHTML=nc),Ap=r(Ve),He=d(Ve,"DIV",{class:!0});var Ae=v(He);g(js.$$.fragment,Ae),Dp=r(Ae),Xa=d(Ae,"P",{"data-svelte-h":!0}),_(Xa)!=="svelte-eywb10"&&(Xa.innerHTML=sc),Kp=r(Ae),g(Kt.$$.fragment,Ae),em=r(Ae),g(en.$$.fragment,Ae),Ae.forEach(i),Ve.forEach(i),Ol=r(e),g(Js.$$.fragment,e),El=r(e),xs=d(e,"P",{"data-svelte-h":!0}),_(xs)!=="svelte-1n8n3ms"&&(xs.textContent=oc),Hl=r(e),g(ks.$$.fragment,e),Ll=r(e),A=d(e,"DIV",{class:!0});var Xe=v(A);g(Us.$$.fragment,Xe),tm=r(Xe),Na=d(Xe,"P",{"data-svelte-h":!0}),_(Na)!=="svelte-5pmyjn"&&(Na.textContent=ac),nm=r(Xe),Sa=d(Xe,"P",{"data-svelte-h":!0}),_(Sa)!=="svelte-1pmzjgn"&&(Sa.innerHTML=lc),sm=r(Xe),za=d(Xe,"P",{"data-svelte-h":!0}),_(za)!=="svelte-7jrnx4"&&(za.innerHTML=rc),om=r(Xe),me=d(Xe,"DIV",{class:!0});var Ne=v(me);g(Rs.$$.fragment,Ne),am=r(Ne),Ba=d(Ne,"P",{"data-svelte-h":!0}),_(Ba)!=="svelte-1usnw5b"&&(Ba.innerHTML=ic),lm=r(Ne),g(tn.$$.fragment,Ne),rm=r(Ne),g(nn.$$.fragment,Ne),im=r(Ne),g(sn.$$.fragment,Ne),Ne.forEach(i),Xe.forEach(i),Ql=r(e),g(Zs.$$.fragment,e),Yl=r(e),D=d(e,"DIV",{class:!0});var Se=v(D);g(Ws.$$.fragment,Se),pm=r(Se),qa=d(Se,"P",{"data-svelte-h":!0}),_(qa)!=="svelte-1rhquq6"&&(qa.textContent=pc),mm=r(Se),Oa=d(Se,"P",{"data-svelte-h":!0}),_(Oa)!=="svelte-1pmzjgn"&&(Oa.innerHTML=mc),dm=r(Se),Ea=d(Se,"P",{"data-svelte-h":!0}),_(Ea)!=="svelte-7jrnx4"&&(Ea.innerHTML=dc),cm=r(Se),de=d(Se,"DIV",{class:!0});var ze=v(de);g(Cs.$$.fragment,ze),um=r(ze),Ha=d(ze,"P",{"data-svelte-h":!0}),_(Ha)!=="svelte-iqwqsz"&&(Ha.innerHTML=cc),gm=r(ze),g(on.$$.fragment,ze),hm=r(ze),g(an.$$.fragment,ze),fm=r(ze),g(ln.$$.fragment,ze),ze.forEach(i),Se.forEach(i),Pl=r(e),g(Is.$$.fragment,e),Al=r(e),g(Fs.$$.fragment,e),Dl=r(e),De=d(e,"DIV",{class:!0});var po=v(De);g(Gs.$$.fragment,po),bm=r(po),rn=d(po,"DIV",{class:!0});var mo=v(rn);g(Vs.$$.fragment,mo),ym=r(mo),La=d(mo,"P",{"data-svelte-h":!0}),_(La)!=="svelte-1eed40t"&&(La.textContent=uc),mo.forEach(i),po.forEach(i),Kl=r(e),g(Xs.$$.fragment,e),er=r(e),Ke=d(e,"DIV",{class:!0});var co=v(Ke);g(Ns.$$.fragment,co),Mm=r(co),pn=d(co,"DIV",{class:!0});var uo=v(pn);g(Ss.$$.fragment,uo),Tm=r(uo),Qa=d(uo,"P",{"data-svelte-h":!0}),_(Qa)!=="svelte-1eed40t"&&(Qa.textContent=gc),uo.forEach(i),co.forEach(i),tr=r(e),g(zs.$$.fragment,e),nr=r(e),et=d(e,"DIV",{class:!0});var go=v(et);g(Bs.$$.fragment,go),_m=r(go),mn=d(go,"DIV",{class:!0});var ho=v(mn);g(qs.$$.fragment,ho),$m=r(ho),Ya=d(ho,"P",{"data-svelte-h":!0}),_(Ya)!=="svelte-1eed40t"&&(Ya.textContent=hc),ho.forEach(i),go.forEach(i),sr=r(e),g(Os.$$.fragment,e),or=r(e),tt=d(e,"DIV",{class:!0});var fo=v(tt);g(Es.$$.fragment,fo),wm=r(fo),dn=d(fo,"DIV",{class:!0});var gr=v(dn);g(Hs.$$.fragment,gr),vm=r(gr),Pa=d(gr,"P",{"data-svelte-h":!0}),_(Pa)!=="svelte-1eed40t"&&(Pa.textContent=fc),gr.forEach(i),fo.forEach(i),ar=r(e),g(Ls.$$.fragment,e),lr=r(e),nt=d(e,"DIV",{class:!0});var hr=v(nt);g(Qs.$$.fragment,hr),jm=r(hr),cn=d(hr,"DIV",{class:!0});var fr=v(cn);g(Ys.$$.fragment,fr),Jm=r(fr),Aa=d(fr,"P",{"data-svelte-h":!0}),_(Aa)!=="svelte-1eed40t"&&(Aa.textContent=bc),fr.forEach(i),hr.forEach(i),rr=r(e),g(Ps.$$.fragment,e),ir=r(e),st=d(e,"DIV",{class:!0});var br=v(st);g(As.$$.fragment,br),xm=r(br),un=d(br,"DIV",{class:!0});var yr=v(un);g(Ds.$$.fragment,yr),km=r(yr),Da=d(yr,"P",{"data-svelte-h":!0}),_(Da)!=="svelte-1eed40t"&&(Da.textContent=yc),yr.forEach(i),br.forEach(i),pr=r(e),g(Ks.$$.fragment,e),mr=r(e),ot=d(e,"DIV",{class:!0});var Mr=v(ot);g(eo.$$.fragment,Mr),Um=r(Mr),gn=d(Mr,"DIV",{class:!0});var Tr=v(gn);g(to.$$.fragment,Tr),Rm=r(Tr),Ka=d(Tr,"P",{"data-svelte-h":!0}),_(Ka)!=="svelte-1eed40t"&&(Ka.textContent=Mc),Tr.forEach(i),Mr.forEach(i),dr=r(e),g(no.$$.fragment,e),cr=r(e),el=d(e,"P",{}),v(el).forEach(i),this.h()},h(){j(n,"name","hf:doc:metadata"),j(n,"content",wu),j(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){o(document.head,n),c(e,T,p),c(e,a,p),c(e,s,p),h(M,e,p),c(e,t,p),h($,e,p),c(e,tl,p),c(e,hn,p),c(e,nl,p),h(fn,e,p),c(e,sl,p),c(e,Z,p),h(bn,Z,null),o(Z,_r),o(Z,bo),o(Z,$r),o(Z,yo),o(Z,wr),o(Z,Mo),o(Z,vr),o(Z,To),o(Z,jr),o(Z,_o),o(Z,Jr),o(Z,$o),o(Z,xr),o(Z,at),h(yn,at,null),o(at,kr),o(at,wo),o(Z,Ur),o(Z,lt),h(Mn,lt,null),o(lt,Rr),o(lt,vo),o(Z,Zr),o(Z,rt),h(Tn,rt,null),o(rt,Wr),o(rt,jo),o(Z,Cr),o(Z,it),h(_n,it,null),o(it,Ir),o(it,Jo),o(Z,Fr),o(Z,pt),h($n,pt,null),o(pt,Gr),o(pt,xo),o(Z,Vr),o(Z,mt),h(wn,mt,null),o(mt,Xr),o(mt,ko),c(e,ol,p),h(vn,e,p),c(e,al,p),c(e,jn,p),c(e,ll,p),h(Jn,e,p),c(e,rl,p),c(e,F,p),h(xn,F,null),o(F,Nr),o(F,Uo),o(F,Sr),o(F,Ro),o(F,zr),o(F,Zo),o(F,Br),o(F,ee),h(kn,ee,null),o(ee,qr),o(ee,Wo),o(ee,Or),h(dt,ee,null),o(ee,Er),h(ct,ee,null),o(ee,Hr),h(ut,ee,null),c(e,il,p),h(Un,e,p),c(e,pl,p),c(e,G,p),h(Rn,G,null),o(G,Lr),o(G,Co),o(G,Qr),o(G,Io),o(G,Yr),o(G,Fo),o(G,Pr),o(G,te),h(Zn,te,null),o(te,Ar),o(te,Go),o(te,Dr),h(gt,te,null),o(te,Kr),h(ht,te,null),o(te,ei),h(ft,te,null),c(e,ml,p),h(Wn,e,p),c(e,dl,p),c(e,V,p),h(Cn,V,null),o(V,ti),o(V,Vo),o(V,ni),o(V,Xo),o(V,si),o(V,No),o(V,oi),o(V,ne),h(In,ne,null),o(ne,ai),o(ne,So),o(ne,li),h(bt,ne,null),o(ne,ri),h(yt,ne,null),o(ne,ii),h(Mt,ne,null),c(e,cl,p),h(Fn,e,p),c(e,ul,p),c(e,X,p),h(Gn,X,null),o(X,pi),o(X,zo),o(X,mi),o(X,Bo),o(X,di),o(X,qo),o(X,ci),o(X,I),h(Vn,I,null),o(I,ui),o(I,Oo),o(I,gi),h(Tt,I,null),o(I,hi),h(_t,I,null),o(I,fi),h($t,I,null),o(I,bi),h(wt,I,null),c(e,gl,p),h(Xn,e,p),c(e,hl,p),c(e,N,p),h(Nn,N,null),o(N,yi),o(N,Eo),o(N,Mi),o(N,Ho),o(N,Ti),o(N,Lo),o(N,_i),o(N,se),h(Sn,se,null),o(se,$i),o(se,Qo),o(se,wi),h(vt,se,null),o(se,vi),h(jt,se,null),o(se,ji),h(Jt,se,null),c(e,fl,p),h(zn,e,p),c(e,bl,p),c(e,S,p),h(Bn,S,null),o(S,Ji),o(S,Yo),o(S,xi),o(S,Po),o(S,ki),o(S,Ao),o(S,Ui),o(S,Be),h(qn,Be,null),o(Be,Ri),o(Be,Do),o(Be,Zi),h(xt,Be,null),o(Be,Wi),h(kt,Be,null),c(e,yl,p),h(On,e,p),c(e,Ml,p),c(e,z,p),h(En,z,null),o(z,Ci),o(z,Ko),o(z,Ii),o(z,ea),o(z,Fi),o(z,ta),o(z,Gi),o(z,oe),h(Hn,oe,null),o(oe,Vi),o(oe,na),o(oe,Xi),h(Ut,oe,null),o(oe,Ni),h(Rt,oe,null),o(oe,Si),h(Zt,oe,null),c(e,Tl,p),h(Ln,e,p),c(e,_l,p),c(e,Qn,p),c(e,$l,p),h(Yn,e,p),c(e,wl,p),c(e,B,p),h(Pn,B,null),o(B,zi),o(B,sa),o(B,Bi),o(B,oa),o(B,qi),o(B,aa),o(B,Oi),o(B,ae),h(An,ae,null),o(ae,Ei),o(ae,la),o(ae,Hi),h(Wt,ae,null),o(ae,Li),h(Ct,ae,null),o(ae,Qi),h(It,ae,null),c(e,vl,p),h(Dn,e,p),c(e,jl,p),c(e,q,p),h(Kn,q,null),o(q,Yi),o(q,ra),o(q,Pi),o(q,ia),o(q,Ai),o(q,pa),o(q,Di),o(q,le),h(es,le,null),o(le,Ki),o(le,ma),o(le,ep),h(Ft,le,null),o(le,tp),h(Gt,le,null),o(le,np),h(Vt,le,null),c(e,Jl,p),h(ts,e,p),c(e,xl,p),c(e,ns,p),c(e,kl,p),h(ss,e,p),c(e,Ul,p),c(e,O,p),h(os,O,null),o(O,sp),o(O,da),o(O,op),o(O,ca),o(O,ap),o(O,ua),o(O,lp),o(O,re),h(as,re,null),o(re,rp),o(re,ga),o(re,ip),h(Xt,re,null),o(re,pp),h(Nt,re,null),o(re,mp),h(St,re,null),c(e,Rl,p),h(ls,e,p),c(e,Zl,p),c(e,E,p),h(rs,E,null),o(E,dp),o(E,ha),o(E,cp),o(E,fa),o(E,up),o(E,ba),o(E,gp),o(E,qe),h(is,qe,null),o(qe,hp),o(qe,ya),o(qe,fp),h(zt,qe,null),o(qe,bp),h(Bt,qe,null),c(e,Wl,p),h(ps,e,p),c(e,Cl,p),c(e,H,p),h(ms,H,null),o(H,yp),o(H,Ma),o(H,Mp),o(H,Ta),o(H,Tp),o(H,_a),o(H,_p),o(H,Oe),h(ds,Oe,null),o(Oe,$p),o(Oe,$a),o(Oe,wp),h(qt,Oe,null),o(Oe,vp),h(Ot,Oe,null),c(e,Il,p),h(cs,e,p),c(e,Fl,p),c(e,L,p),h(us,L,null),o(L,jp),o(L,wa),o(L,Jp),o(L,va),o(L,xp),o(L,ja),o(L,kp),o(L,ie),h(gs,ie,null),o(ie,Up),o(ie,Ja),o(ie,Rp),h(Et,ie,null),o(ie,Zp),h(Ht,ie,null),o(ie,Wp),h(Lt,ie,null),c(e,Gl,p),h(hs,e,p),c(e,Vl,p),c(e,Q,p),h(fs,Q,null),o(Q,Cp),o(Q,xa),o(Q,Ip),o(Q,ka),o(Q,Fp),o(Q,Ua),o(Q,Gp),o(Q,Ee),h(bs,Ee,null),o(Ee,Vp),o(Ee,Ra),o(Ee,Xp),h(Qt,Ee,null),o(Ee,Np),h(Yt,Ee,null),c(e,Xl,p),h(ys,e,p),c(e,Nl,p),c(e,Ms,p),c(e,Sl,p),h(Ts,e,p),c(e,zl,p),c(e,Y,p),h(_s,Y,null),o(Y,Sp),o(Y,Za),o(Y,zp),o(Y,Wa),o(Y,Bp),o(Y,Ca),o(Y,qp),o(Y,pe),h($s,pe,null),o(pe,Op),o(pe,Ia),o(pe,Ep),h(Pt,pe,null),o(pe,Hp),h(At,pe,null),o(pe,Lp),h(Dt,pe,null),c(e,Bl,p),h(ws,e,p),c(e,ql,p),c(e,P,p),h(vs,P,null),o(P,Qp),o(P,Fa),o(P,Yp),o(P,Ga),o(P,Pp),o(P,Va),o(P,Ap),o(P,He),h(js,He,null),o(He,Dp),o(He,Xa),o(He,Kp),h(Kt,He,null),o(He,em),h(en,He,null),c(e,Ol,p),h(Js,e,p),c(e,El,p),c(e,xs,p),c(e,Hl,p),h(ks,e,p),c(e,Ll,p),c(e,A,p),h(Us,A,null),o(A,tm),o(A,Na),o(A,nm),o(A,Sa),o(A,sm),o(A,za),o(A,om),o(A,me),h(Rs,me,null),o(me,am),o(me,Ba),o(me,lm),h(tn,me,null),o(me,rm),h(nn,me,null),o(me,im),h(sn,me,null),c(e,Ql,p),h(Zs,e,p),c(e,Yl,p),c(e,D,p),h(Ws,D,null),o(D,pm),o(D,qa),o(D,mm),o(D,Oa),o(D,dm),o(D,Ea),o(D,cm),o(D,de),h(Cs,de,null),o(de,um),o(de,Ha),o(de,gm),h(on,de,null),o(de,hm),h(an,de,null),o(de,fm),h(ln,de,null),c(e,Pl,p),h(Is,e,p),c(e,Al,p),h(Fs,e,p),c(e,Dl,p),c(e,De,p),h(Gs,De,null),o(De,bm),o(De,rn),h(Vs,rn,null),o(rn,ym),o(rn,La),c(e,Kl,p),h(Xs,e,p),c(e,er,p),c(e,Ke,p),h(Ns,Ke,null),o(Ke,Mm),o(Ke,pn),h(Ss,pn,null),o(pn,Tm),o(pn,Qa),c(e,tr,p),h(zs,e,p),c(e,nr,p),c(e,et,p),h(Bs,et,null),o(et,_m),o(et,mn),h(qs,mn,null),o(mn,$m),o(mn,Ya),c(e,sr,p),h(Os,e,p),c(e,or,p),c(e,tt,p),h(Es,tt,null),o(tt,wm),o(tt,dn),h(Hs,dn,null),o(dn,vm),o(dn,Pa),c(e,ar,p),h(Ls,e,p),c(e,lr,p),c(e,nt,p),h(Qs,nt,null),o(nt,jm),o(nt,cn),h(Ys,cn,null),o(cn,Jm),o(cn,Aa),c(e,rr,p),h(Ps,e,p),c(e,ir,p),c(e,st,p),h(As,st,null),o(st,xm),o(st,un),h(Ds,un,null),o(un,km),o(un,Da),c(e,pr,p),h(Ks,e,p),c(e,mr,p),c(e,ot,p),h(eo,ot,null),o(ot,Um),o(ot,gn),h(to,gn,null),o(gn,Rm),o(gn,Ka),c(e,dr,p),h(no,e,p),c(e,cr,p),c(e,el,p),ur=!0},p(e,[p]){const W={};p&2&&(W.$$scope={dirty:p,ctx:e}),dt.$set(W);const so={};p&2&&(so.$$scope={dirty:p,ctx:e}),ct.$set(so);const oo={};p&2&&(oo.$$scope={dirty:p,ctx:e}),ut.$set(oo);const ao={};p&2&&(ao.$$scope={dirty:p,ctx:e}),gt.$set(ao);const lo={};p&2&&(lo.$$scope={dirty:p,ctx:e}),ht.$set(lo);const ro={};p&2&&(ro.$$scope={dirty:p,ctx:e}),ft.$set(ro);const io={};p&2&&(io.$$scope={dirty:p,ctx:e}),bt.$set(io);const ce={};p&2&&(ce.$$scope={dirty:p,ctx:e}),yt.$set(ce);const ue={};p&2&&(ue.$$scope={dirty:p,ctx:e}),Mt.$set(ue);const ge={};p&2&&(ge.$$scope={dirty:p,ctx:e}),Tt.$set(ge);const he={};p&2&&(he.$$scope={dirty:p,ctx:e}),_t.$set(he);const fe={};p&2&&(fe.$$scope={dirty:p,ctx:e}),$t.$set(fe);const be={};p&2&&(be.$$scope={dirty:p,ctx:e}),wt.$set(be);const ye={};p&2&&(ye.$$scope={dirty:p,ctx:e}),vt.$set(ye);const K={};p&2&&(K.$$scope={dirty:p,ctx:e}),jt.$set(K);const Me={};p&2&&(Me.$$scope={dirty:p,ctx:e}),Jt.$set(Me);const Te={};p&2&&(Te.$$scope={dirty:p,ctx:e}),xt.$set(Te);const _e={};p&2&&(_e.$$scope={dirty:p,ctx:e}),kt.$set(_e);const Le={};p&2&&(Le.$$scope={dirty:p,ctx:e}),Ut.$set(Le);const $e={};p&2&&($e.$$scope={dirty:p,ctx:e}),Rt.$set($e);const we={};p&2&&(we.$$scope={dirty:p,ctx:e}),Zt.$set(we);const ve={};p&2&&(ve.$$scope={dirty:p,ctx:e}),Wt.$set(ve);const je={};p&2&&(je.$$scope={dirty:p,ctx:e}),Ct.$set(je);const Je={};p&2&&(Je.$$scope={dirty:p,ctx:e}),It.$set(Je);const xe={};p&2&&(xe.$$scope={dirty:p,ctx:e}),Ft.$set(xe);const ke={};p&2&&(ke.$$scope={dirty:p,ctx:e}),Gt.$set(ke);const Ue={};p&2&&(Ue.$$scope={dirty:p,ctx:e}),Vt.$set(Ue);const Re={};p&2&&(Re.$$scope={dirty:p,ctx:e}),Xt.$set(Re);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:e}),Nt.$set(Qe);const Ze={};p&2&&(Ze.$$scope={dirty:p,ctx:e}),St.$set(Ze);const Ye={};p&2&&(Ye.$$scope={dirty:p,ctx:e}),zt.$set(Ye);const We={};p&2&&(We.$$scope={dirty:p,ctx:e}),Bt.$set(We);const Ce={};p&2&&(Ce.$$scope={dirty:p,ctx:e}),qt.$set(Ce);const Ie={};p&2&&(Ie.$$scope={dirty:p,ctx:e}),Ot.$set(Ie);const Pe={};p&2&&(Pe.$$scope={dirty:p,ctx:e}),Et.$set(Pe);const Fe={};p&2&&(Fe.$$scope={dirty:p,ctx:e}),Ht.$set(Fe);const Ge={};p&2&&(Ge.$$scope={dirty:p,ctx:e}),Lt.$set(Ge);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:e}),Qt.$set(Ve);const Ae={};p&2&&(Ae.$$scope={dirty:p,ctx:e}),Yt.$set(Ae);const Xe={};p&2&&(Xe.$$scope={dirty:p,ctx:e}),Pt.$set(Xe);const Ne={};p&2&&(Ne.$$scope={dirty:p,ctx:e}),At.$set(Ne);const Se={};p&2&&(Se.$$scope={dirty:p,ctx:e}),Dt.$set(Se);const ze={};p&2&&(ze.$$scope={dirty:p,ctx:e}),Kt.$set(ze);const po={};p&2&&(po.$$scope={dirty:p,ctx:e}),en.$set(po);const mo={};p&2&&(mo.$$scope={dirty:p,ctx:e}),tn.$set(mo);const co={};p&2&&(co.$$scope={dirty:p,ctx:e}),nn.$set(co);const uo={};p&2&&(uo.$$scope={dirty:p,ctx:e}),sn.$set(uo);const go={};p&2&&(go.$$scope={dirty:p,ctx:e}),on.$set(go);const ho={};p&2&&(ho.$$scope={dirty:p,ctx:e}),an.$set(ho);const fo={};p&2&&(fo.$$scope={dirty:p,ctx:e}),ln.$set(fo)},i(e){ur||(f(M.$$.fragment,e),f($.$$.fragment,e),f(fn.$$.fragment,e),f(bn.$$.fragment,e),f(yn.$$.fragment,e),f(Mn.$$.fragment,e),f(Tn.$$.fragment,e),f(_n.$$.fragment,e),f($n.$$.fragment,e),f(wn.$$.fragment,e),f(vn.$$.fragment,e),f(Jn.$$.fragment,e),f(xn.$$.fragment,e),f(kn.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(ut.$$.fragment,e),f(Un.$$.fragment,e),f(Rn.$$.fragment,e),f(Zn.$$.fragment,e),f(gt.$$.fragment,e),f(ht.$$.fragment,e),f(ft.$$.fragment,e),f(Wn.$$.fragment,e),f(Cn.$$.fragment,e),f(In.$$.fragment,e),f(bt.$$.fragment,e),f(yt.$$.fragment,e),f(Mt.$$.fragment,e),f(Fn.$$.fragment,e),f(Gn.$$.fragment,e),f(Vn.$$.fragment,e),f(Tt.$$.fragment,e),f(_t.$$.fragment,e),f($t.$$.fragment,e),f(wt.$$.fragment,e),f(Xn.$$.fragment,e),f(Nn.$$.fragment,e),f(Sn.$$.fragment,e),f(vt.$$.fragment,e),f(jt.$$.fragment,e),f(Jt.$$.fragment,e),f(zn.$$.fragment,e),f(Bn.$$.fragment,e),f(qn.$$.fragment,e),f(xt.$$.fragment,e),f(kt.$$.fragment,e),f(On.$$.fragment,e),f(En.$$.fragment,e),f(Hn.$$.fragment,e),f(Ut.$$.fragment,e),f(Rt.$$.fragment,e),f(Zt.$$.fragment,e),f(Ln.$$.fragment,e),f(Yn.$$.fragment,e),f(Pn.$$.fragment,e),f(An.$$.fragment,e),f(Wt.$$.fragment,e),f(Ct.$$.fragment,e),f(It.$$.fragment,e),f(Dn.$$.fragment,e),f(Kn.$$.fragment,e),f(es.$$.fragment,e),f(Ft.$$.fragment,e),f(Gt.$$.fragment,e),f(Vt.$$.fragment,e),f(ts.$$.fragment,e),f(ss.$$.fragment,e),f(os.$$.fragment,e),f(as.$$.fragment,e),f(Xt.$$.fragment,e),f(Nt.$$.fragment,e),f(St.$$.fragment,e),f(ls.$$.fragment,e),f(rs.$$.fragment,e),f(is.$$.fragment,e),f(zt.$$.fragment,e),f(Bt.$$.fragment,e),f(ps.$$.fragment,e),f(ms.$$.fragment,e),f(ds.$$.fragment,e),f(qt.$$.fragment,e),f(Ot.$$.fragment,e),f(cs.$$.fragment,e),f(us.$$.fragment,e),f(gs.$$.fragment,e),f(Et.$$.fragment,e),f(Ht.$$.fragment,e),f(Lt.$$.fragment,e),f(hs.$$.fragment,e),f(fs.$$.fragment,e),f(bs.$$.fragment,e),f(Qt.$$.fragment,e),f(Yt.$$.fragment,e),f(ys.$$.fragment,e),f(Ts.$$.fragment,e),f(_s.$$.fragment,e),f($s.$$.fragment,e),f(Pt.$$.fragment,e),f(At.$$.fragment,e),f(Dt.$$.fragment,e),f(ws.$$.fragment,e),f(vs.$$.fragment,e),f(js.$$.fragment,e),f(Kt.$$.fragment,e),f(en.$$.fragment,e),f(Js.$$.fragment,e),f(ks.$$.fragment,e),f(Us.$$.fragment,e),f(Rs.$$.fragment,e),f(tn.$$.fragment,e),f(nn.$$.fragment,e),f(sn.$$.fragment,e),f(Zs.$$.fragment,e),f(Ws.$$.fragment,e),f(Cs.$$.fragment,e),f(on.$$.fragment,e),f(an.$$.fragment,e),f(ln.$$.fragment,e),f(Is.$$.fragment,e),f(Fs.$$.fragment,e),f(Gs.$$.fragment,e),f(Vs.$$.fragment,e),f(Xs.$$.fragment,e),f(Ns.$$.fragment,e),f(Ss.$$.fragment,e),f(zs.$$.fragment,e),f(Bs.$$.fragment,e),f(qs.$$.fragment,e),f(Os.$$.fragment,e),f(Es.$$.fragment,e),f(Hs.$$.fragment,e),f(Ls.$$.fragment,e),f(Qs.$$.fragment,e),f(Ys.$$.fragment,e),f(Ps.$$.fragment,e),f(As.$$.fragment,e),f(Ds.$$.fragment,e),f(Ks.$$.fragment,e),f(eo.$$.fragment,e),f(to.$$.fragment,e),f(no.$$.fragment,e),ur=!0)},o(e){b(M.$$.fragment,e),b($.$$.fragment,e),b(fn.$$.fragment,e),b(bn.$$.fragment,e),b(yn.$$.fragment,e),b(Mn.$$.fragment,e),b(Tn.$$.fragment,e),b(_n.$$.fragment,e),b($n.$$.fragment,e),b(wn.$$.fragment,e),b(vn.$$.fragment,e),b(Jn.$$.fragment,e),b(xn.$$.fragment,e),b(kn.$$.fragment,e),b(dt.$$.fragment,e),b(ct.$$.fragment,e),b(ut.$$.fragment,e),b(Un.$$.fragment,e),b(Rn.$$.fragment,e),b(Zn.$$.fragment,e),b(gt.$$.fragment,e),b(ht.$$.fragment,e),b(ft.$$.fragment,e),b(Wn.$$.fragment,e),b(Cn.$$.fragment,e),b(In.$$.fragment,e),b(bt.$$.fragment,e),b(yt.$$.fragment,e),b(Mt.$$.fragment,e),b(Fn.$$.fragment,e),b(Gn.$$.fragment,e),b(Vn.$$.fragment,e),b(Tt.$$.fragment,e),b(_t.$$.fragment,e),b($t.$$.fragment,e),b(wt.$$.fragment,e),b(Xn.$$.fragment,e),b(Nn.$$.fragment,e),b(Sn.$$.fragment,e),b(vt.$$.fragment,e),b(jt.$$.fragment,e),b(Jt.$$.fragment,e),b(zn.$$.fragment,e),b(Bn.$$.fragment,e),b(qn.$$.fragment,e),b(xt.$$.fragment,e),b(kt.$$.fragment,e),b(On.$$.fragment,e),b(En.$$.fragment,e),b(Hn.$$.fragment,e),b(Ut.$$.fragment,e),b(Rt.$$.fragment,e),b(Zt.$$.fragment,e),b(Ln.$$.fragment,e),b(Yn.$$.fragment,e),b(Pn.$$.fragment,e),b(An.$$.fragment,e),b(Wt.$$.fragment,e),b(Ct.$$.fragment,e),b(It.$$.fragment,e),b(Dn.$$.fragment,e),b(Kn.$$.fragment,e),b(es.$$.fragment,e),b(Ft.$$.fragment,e),b(Gt.$$.fragment,e),b(Vt.$$.fragment,e),b(ts.$$.fragment,e),b(ss.$$.fragment,e),b(os.$$.fragment,e),b(as.$$.fragment,e),b(Xt.$$.fragment,e),b(Nt.$$.fragment,e),b(St.$$.fragment,e),b(ls.$$.fragment,e),b(rs.$$.fragment,e),b(is.$$.fragment,e),b(zt.$$.fragment,e),b(Bt.$$.fragment,e),b(ps.$$.fragment,e),b(ms.$$.fragment,e),b(ds.$$.fragment,e),b(qt.$$.fragment,e),b(Ot.$$.fragment,e),b(cs.$$.fragment,e),b(us.$$.fragment,e),b(gs.$$.fragment,e),b(Et.$$.fragment,e),b(Ht.$$.fragment,e),b(Lt.$$.fragment,e),b(hs.$$.fragment,e),b(fs.$$.fragment,e),b(bs.$$.fragment,e),b(Qt.$$.fragment,e),b(Yt.$$.fragment,e),b(ys.$$.fragment,e),b(Ts.$$.fragment,e),b(_s.$$.fragment,e),b($s.$$.fragment,e),b(Pt.$$.fragment,e),b(At.$$.fragment,e),b(Dt.$$.fragment,e),b(ws.$$.fragment,e),b(vs.$$.fragment,e),b(js.$$.fragment,e),b(Kt.$$.fragment,e),b(en.$$.fragment,e),b(Js.$$.fragment,e),b(ks.$$.fragment,e),b(Us.$$.fragment,e),b(Rs.$$.fragment,e),b(tn.$$.fragment,e),b(nn.$$.fragment,e),b(sn.$$.fragment,e),b(Zs.$$.fragment,e),b(Ws.$$.fragment,e),b(Cs.$$.fragment,e),b(on.$$.fragment,e),b(an.$$.fragment,e),b(ln.$$.fragment,e),b(Is.$$.fragment,e),b(Fs.$$.fragment,e),b(Gs.$$.fragment,e),b(Vs.$$.fragment,e),b(Xs.$$.fragment,e),b(Ns.$$.fragment,e),b(Ss.$$.fragment,e),b(zs.$$.fragment,e),b(Bs.$$.fragment,e),b(qs.$$.fragment,e),b(Os.$$.fragment,e),b(Es.$$.fragment,e),b(Hs.$$.fragment,e),b(Ls.$$.fragment,e),b(Qs.$$.fragment,e),b(Ys.$$.fragment,e),b(Ps.$$.fragment,e),b(As.$$.fragment,e),b(Ds.$$.fragment,e),b(Ks.$$.fragment,e),b(eo.$$.fragment,e),b(to.$$.fragment,e),b(no.$$.fragment,e),ur=!1},d(e){e&&(i(T),i(a),i(s),i(t),i(tl),i(hn),i(nl),i(sl),i(Z),i(ol),i(al),i(jn),i(ll),i(rl),i(F),i(il),i(pl),i(G),i(ml),i(dl),i(V),i(cl),i(ul),i(X),i(gl),i(hl),i(N),i(fl),i(bl),i(S),i(yl),i(Ml),i(z),i(Tl),i(_l),i(Qn),i($l),i(wl),i(B),i(vl),i(jl),i(q),i(Jl),i(xl),i(ns),i(kl),i(Ul),i(O),i(Rl),i(Zl),i(E),i(Wl),i(Cl),i(H),i(Il),i(Fl),i(L),i(Gl),i(Vl),i(Q),i(Xl),i(Nl),i(Ms),i(Sl),i(zl),i(Y),i(Bl),i(ql),i(P),i(Ol),i(El),i(xs),i(Hl),i(Ll),i(A),i(Ql),i(Yl),i(D),i(Pl),i(Al),i(Dl),i(De),i(Kl),i(er),i(Ke),i(tr),i(nr),i(et),i(sr),i(or),i(tt),i(ar),i(lr),i(nt),i(rr),i(ir),i(st),i(pr),i(mr),i(ot),i(dr),i(cr),i(el)),i(n),y(M,e),y($,e),y(fn,e),y(bn),y(yn),y(Mn),y(Tn),y(_n),y($n),y(wn),y(vn,e),y(Jn,e),y(xn),y(kn),y(dt),y(ct),y(ut),y(Un,e),y(Rn),y(Zn),y(gt),y(ht),y(ft),y(Wn,e),y(Cn),y(In),y(bt),y(yt),y(Mt),y(Fn,e),y(Gn),y(Vn),y(Tt),y(_t),y($t),y(wt),y(Xn,e),y(Nn),y(Sn),y(vt),y(jt),y(Jt),y(zn,e),y(Bn),y(qn),y(xt),y(kt),y(On,e),y(En),y(Hn),y(Ut),y(Rt),y(Zt),y(Ln,e),y(Yn,e),y(Pn),y(An),y(Wt),y(Ct),y(It),y(Dn,e),y(Kn),y(es),y(Ft),y(Gt),y(Vt),y(ts,e),y(ss,e),y(os),y(as),y(Xt),y(Nt),y(St),y(ls,e),y(rs),y(is),y(zt),y(Bt),y(ps,e),y(ms),y(ds),y(qt),y(Ot),y(cs,e),y(us),y(gs),y(Et),y(Ht),y(Lt),y(hs,e),y(fs),y(bs),y(Qt),y(Yt),y(ys,e),y(Ts,e),y(_s),y($s),y(Pt),y(At),y(Dt),y(ws,e),y(vs),y(js),y(Kt),y(en),y(Js,e),y(ks,e),y(Us),y(Rs),y(tn),y(nn),y(sn),y(Zs,e),y(Ws),y(Cs),y(on),y(an),y(ln),y(Is,e),y(Fs,e),y(Gs),y(Vs),y(Xs,e),y(Ns),y(Ss),y(zs,e),y(Bs),y(qs),y(Os,e),y(Es),y(Hs),y(Ls,e),y(Qs),y(Ys),y(Ps,e),y(As),y(Ds),y(Ks,e),y(eo),y(to),y(no,e)}}}const wu='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"ORTModel","local":"optimum.onnxruntime.ORTModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"ORTModelForCausalLM","local":"optimum.onnxruntime.ORTModelForCausalLM","sections":[],"depth":3},{"title":"ORTModelForMaskedLM","local":"optimum.onnxruntime.ORTModelForMaskedLM","sections":[],"depth":3},{"title":"ORTModelForSeq2SeqLM","local":"optimum.onnxruntime.ORTModelForSeq2SeqLM","sections":[],"depth":3},{"title":"ORTModelForSequenceClassification","local":"optimum.onnxruntime.ORTModelForSequenceClassification","sections":[],"depth":3},{"title":"ORTModelForTokenClassification","local":"optimum.onnxruntime.ORTModelForTokenClassification","sections":[],"depth":3},{"title":"ORTModelForMultipleChoice","local":"optimum.onnxruntime.ORTModelForMultipleChoice","sections":[],"depth":3},{"title":"ORTModelForQuestionAnswering","local":"optimum.onnxruntime.ORTModelForQuestionAnswering","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"ORTModelForImageClassification","local":"optimum.onnxruntime.ORTModelForImageClassification","sections":[],"depth":3},{"title":"ORTModelForSemanticSegmentation","local":"optimum.onnxruntime.ORTModelForSemanticSegmentation","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"ORTModelForAudioClassification","local":"optimum.onnxruntime.ORTModelForAudioClassification","sections":[],"depth":3},{"title":"ORTModelForAudioFrameClassification","local":"optimum.onnxruntime.ORTModelForAudioFrameClassification","sections":[],"depth":3},{"title":"ORTModelForCTC","local":"optimum.onnxruntime.ORTModelForCTC","sections":[],"depth":3},{"title":"ORTModelForSpeechSeq2Seq","local":"optimum.onnxruntime.ORTModelForSpeechSeq2Seq","sections":[],"depth":3},{"title":"ORTModelForAudioXVector","local":"optimum.onnxruntime.ORTModelForAudioXVector","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"ORTModelForVision2Seq","local":"optimum.onnxruntime.ORTModelForVision2Seq","sections":[],"depth":3},{"title":"ORTModelForPix2Struct","local":"optimum.onnxruntime.ORTModelForPix2Struct","sections":[],"depth":3}],"depth":2},{"title":"Custom Tasks","local":"custom-tasks","sections":[{"title":"ORTModelForCustomTasks","local":"optimum.onnxruntime.ORTModelForCustomTasks","sections":[],"depth":4},{"title":"ORTModelForFeatureExtraction","local":"optimum.onnxruntime.ORTModelForFeatureExtraction","sections":[],"depth":4}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"ORTDiffusionPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTLatentConsistencyModelPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function vu(w){return _c(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wu extends $c{constructor(n){super(),wc(this,n,vu,$u,Tc,{})}}export{Wu as component};
