import{s as it,o as rt,n as Ve}from"../chunks/scheduler.6062bdaf.js";import{S as pt,i as ht,g as i,s as o,r as c,A as ct,h as r,f as a,c as n,j as lt,u as d,x as h,k as He,y as dt,a as s,v as u,d as w,t as y,w as b}from"../chunks/index.4bca734e.js";import{T as Ye}from"../chunks/Tip.b9ac1f03.js";import{C as te}from"../chunks/CodeBlock.fa01571c.js";import{H as D}from"../chunks/Heading.723dceba.js";function ut(M){let l,g=`To see a running example of a webhook server, check out the <a href="https://huggingface.co/spaces/spaces-ci-bot/webhook" rel="nofollow">Spaces CI Bot</a>
one. It is a Space that launches ephemeral environments when a PR is opened on a Space.`;return{c(){l=i("p"),l.innerHTML=g},l(p){l=r(p,"P",{"data-svelte-h":!0}),h(l)!=="svelte-18sko4t"&&(l.innerHTML=g)},m(p,f){s(p,l,f)},p:Ve,d(p){p&&a(l)}}}function wt(M){let l,g=`This is an <a href="../package_reference/environment_variables#hfhubdisableexperimentalwarning">experimental feature</a>. This
means that we are still working on improving the API. Breaking changes might be introduced in the future without prior
notice. Make sure to pin the version of <code>huggingface_hub</code> in your requirements.`;return{c(){l=i("p"),l.innerHTML=g},l(p){l=r(p,"P",{"data-svelte-h":!0}),h(l)!=="svelte-fuzk6g"&&(l.innerHTML=g)},m(p,f){s(p,l,f)},p:Ve,d(p){p&&a(l)}}}function yt(M){let l,g=`By default, the server is started at the end of your script. If you are running it in a notebook, you can start the
server manually by calling <code>decorated_function.run()</code>. Since a unique server is used, you only have to start the server
once even if you have multiple endpoints.`;return{c(){l=i("p"),l.innerHTML=g},l(p){l=r(p,"P",{"data-svelte-h":!0}),h(l)!=="svelte-1jc349n"&&(l.innerHTML=g)},m(p,f){s(p,l,f)},p:Ve,d(p){p&&a(l)}}}function bt(M){let l,g,p,f,U,ae,v,Fe=`Webhooks are a foundation for MLOps-related features. They allow you to listen for new changes on specific repos or to
all repos belonging to particular users/organizations you’re interested in following. This guide will explain how to
leverage <code>huggingface_hub</code> to create a server listening to webhooks and deploy it to a Space. It assumes you are
familiar with the concept of webhooks on the Huggingface Hub. To learn more about webhooks themselves, you can read
this <a href="https://huggingface.co/docs/hub/webhooks" rel="nofollow">guide</a> first.`,se,j,Re=`The base class that we will use in this guide is <a href="/docs/huggingface_hub/v0.21.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>. It is a class for easily configuring a server that
can receive webhooks from the Huggingface Hub. The server is based on a <a href="https://gradio.app/" rel="nofollow">Gradio</a> app. It has a UI
to display instructions for you or your users and an API to listen to webhooks.`,oe,m,ne,T,le,I,ie,W,Qe=`Implementing a webhook endpoint is as simple as decorating a function. Let’s see a first example to explain the main
concepts:`,re,$,pe,Z,Xe="Save this snippet in a file called <code>&#39;app.py&#39;</code> and run it with <code>&#39;python app.py&#39;</code>. You should see a message like this:",he,G,ce,B,xe="Good job! You just launched a webhook server! Let’s break down what happened exactly:",de,C,Le=`<li>By decorating a function with <a href="/docs/huggingface_hub/v0.21.3/en/package_reference/webhooks_server#huggingface_hub.webhook_endpoint">webhook_endpoint()</a>, a <a href="/docs/huggingface_hub/v0.21.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object has been created in the background.
As you can see, this server is a Gradio app running on <a href="http://127.0.0.1:7860" rel="nofollow">http://127.0.0.1:7860</a>. If you open this URL in your browser, you
will see a landing page with instructions about the registered webhooks.</li> <li>A Gradio app is a FastAPI server under the hood. A new POST route <code>/webhooks/trigger_training</code> has been added to it.
This is the route that will listen to webhooks and run the <code>trigger_training</code> function when triggered. FastAPI will
automatically parse the payload and pass it to the function as a <a href="/docs/huggingface_hub/v0.21.3/en/package_reference/webhooks_server#huggingface_hub.WebhookPayload">WebhookPayload</a> object. This is a <code>pydantic</code> object
that contains all the information about the event that triggered the webhook.</li> <li>The Gradio app also opened a tunnel to receive requests from the internet. This is the interesting part: you can
configure a Webhook on <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a> pointing to your local machine. This is useful for
debugging your webhook server and quickly iterating before deploying it to a Space.</li> <li>Finally, the logs also tell you that your server is currently not secured by a secret. This is not problematic for
local debugging but is to keep in mind for later.</li>`,ue,k,we,_,ye,S,Ee=`Now that you have a webhook server running, you want to configure a Webhook to start receiving messages.
Go to <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a>, click on “Add a new webhook” and configure your Webhook. Set the target
repositories you want to watch and the Webhook URL, here <code>https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training</code>.`,be,J,Ne='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/configure_webhook.png"/>',ge,H,ze=`And that’s it! You can now trigger that webhook by updating the target repository (e.g. push a commit). Check the
Activity tab of your Webhook to see the events that have been triggered. Now that you have a working setup, you can
test it and quickly iterate. If you modify your code and restart the server, your public URL might change. Make sure
to update the webhook configuration on the Hub if needed.`,fe,Y,Me,V,Pe=`Now that you have a working webhook server, the goal is to deploy it to a Space. Go to <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>
to create a Space. Give it a name, select the Gradio SDK and click on “Create Space”. Upload your code to the Space
in a file called <code>app.py</code>. Your Space will start automatically! For more details about Spaces, please refer to this
<a href="https://huggingface.co/docs/hub/spaces-overview" rel="nofollow">guide</a>.`,me,F,qe=`Your webhook server is now running on a public Space. If most cases, you will want to secure it with a secret. Go to
your Space settings &gt; Section “Repository secrets” &gt; “Add a secret”. Set the <code>WEBHOOK_SECRET</code> environment variable to
the value of your choice. Go back to the <a href="https://huggingface.co/settings/webhooks" rel="nofollow">Webhooks settings</a> and set the
secret in the webhook configuration. Now, only requests with the correct secret will be accepted by your server.`,Te,R,Ae=`And this is it! Your Space is now ready to receive webhooks from the Hub. Please keep in mind that if you run the Space
on a free ‘cpu-basic’ hardware, it will be shut down after 48 hours of inactivity. If you need a permanent Space, you
should consider setting to an <a href="https://huggingface.co/docs/hub/spaces-gpus#hardware-specs" rel="nofollow">upgraded hardware</a>.`,ke,Q,Je,X,Oe=`The guide above explained the quickest way to setup a <a href="/docs/huggingface_hub/v0.21.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>. In this section, we will see how to customize
it further.`,Ue,x,ve,L,Ke=`You can register multiple endpoints on the same server. For example, you might want to have one endpoint to trigger
a training job and another one to trigger a model evaluation. You can do this by adding multiple <code>@webhook_endpoint</code>
decorators:`,je,E,Ie,N,De="Which will create two endpoints:",We,z,$e,P,Ze,q,et=`To get more flexibility, you can also create a <a href="/docs/huggingface_hub/v0.21.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object directly. This is useful if you want to
customize the landing page of your server. You can do this by passing a <a href="https://gradio.app/docs/#blocks" rel="nofollow">Gradio UI</a>
that will overwrite the default one. For example, you can add instructions for your users or add a form to manually
trigger the webhooks. When creating a <a href="/docs/huggingface_hub/v0.21.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>, you can register new webhooks using the
<code>add_webhook()</code> decorator.`,Ge,A,tt="Here is a complete example:",Be,O,Ce,K,at=`<li>We define a custom UI using Gradio blocks. This UI will be displayed on the landing page of the server.</li> <li>We create a <a href="/docs/huggingface_hub/v0.21.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object with a custom UI and a secret. The secret is optional and can be set with
the <code>WEBHOOK_SECRET</code> environment variable.</li> <li>We register a webhook with an explicit name. This will create an endpoint at <code>/webhooks/say_hello</code>.</li> <li>We register a webhook with an implicit name. This will create an endpoint at <code>/webhooks/goodbye</code>.</li> <li>We start the server. This is optional as your server will automatically be started at the end of the script.</li>`,_e,ee,Se;return U=new D({props:{title:"Webhooks Server",local:"webhooks-server",headingTag:"h1"}}),m=new Ye({props:{$$slots:{default:[ut]},$$scope:{ctx:M}}}),T=new Ye({props:{warning:!0,$$slots:{default:[wt]},$$scope:{ctx:M}}}),I=new D({props:{title:"Create an endpoint",local:"create-an-endpoint",headingTag:"h2"}}),$=new te({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBhJTIwdHJhaW5pbmclMjBqb2IlMjBpZiUyMGElMjBkYXRhc2V0JTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger a training job if a dataset is updated</span>
        ...`,wrap:!1}}),G=new te({props:{code:"V2ViaG9vayUyMHNlY3JldCUyMGlzJTIwbm90JTIwZGVmaW5lZC4lMjBUaGlzJTIwbWVhbnMlMjB5b3VyJTIwd2ViaG9vayUyMGVuZHBvaW50cyUyMHdpbGwlMjBiZSUyMG9wZW4lMjB0byUyMGV2ZXJ5b25lLiUwQVRvJTIwYWRkJTIwYSUyMHNlY3JldCUyQyUyMHNldCUyMCU2MFdFQkhPT0tfU0VDUkVUJTYwJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTIwb3IlMjBwYXNzJTIwaXQlMjBhdCUyMGluaXRpYWxpemF0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTYwYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIod2ViaG9va19zZWNyZXQlM0QnbXlfc2VjcmV0JyUyQyUyMC4uLiklNjAlMEFGb3IlMjBtb3JlJTIwZGV0YWlscyUyMGFib3V0JTIwd2ViaG9vayUyMHNlY3JldHMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZ3ZWJob29rcyUyM3dlYmhvb2stc2VjcmV0LiUwQVJ1bm5pbmclMjBvbiUyMGxvY2FsJTIwVVJMJTNBJTIwJTIwaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTc4NjAlMEFSdW5uaW5nJTIwb24lMjBwdWJsaWMlMjBVUkwlM0ElMjBodHRwcyUzQSUyRiUyRjFmYWRiMGY1MmQ4YmY4MjVmYy5ncmFkaW8ubGl2ZSUwQSUwQVRoaXMlMjBzaGFyZSUyMGxpbmslMjBleHBpcmVzJTIwaW4lMjA3MiUyMGhvdXJzLiUyMEZvciUyMGZyZWUlMjBwZXJtYW5lbnQlMjBob3N0aW5nJTIwYW5kJTIwR1BVJTIwdXBncmFkZXMlMjAoTkVXISklMkMlMjBjaGVjayUyMG91dCUyMFNwYWNlcyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMEElMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEFHbyUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNldHRpbmdzJTJGd2ViaG9va3MlMjB0byUyMHNldHVwJTIweW91ciUyMHdlYmhvb2tzLg==",highlighted:`Webhook secret is not defined. This means your webhook endpoints will be open to everyone.
To add a secret, set \`WEBHOOK_SECRET\` as environment variable or pass it at initialization:
        \`app = WebhooksServer(webhook_secret=&#x27;my_secret&#x27;, ...)\`
For more details about webhook secrets, please refer to https://huggingface.co/docs/hub/webhooks#webhook-secret.
Running on local URL:  http://127.0.0.1:7860
Running on public URL: https://1fadb0f52d8bf825fc.gradio.live

This share link expires in 72 hours. For free permanent hosting and GPU upgrades (NEW!), check out Spaces: https://huggingface.co/spaces

Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
Go to https://huggingface.co/settings/webhooks to setup your webhooks.`,wrap:!1}}),k=new Ye({props:{warning:!0,$$slots:{default:[yt]},$$scope:{ctx:M}}}),_=new D({props:{title:"Configure a Webhook",local:"configure-a-webhook",headingTag:"h2"}}),Y=new D({props:{title:"Deploy to a Space",local:"deploy-to-a-space",headingTag:"h2"}}),Q=new D({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),x=new D({props:{title:"Multiple endpoints",local:"multiple-endpoints",headingTag:"h3"}}),E=new te({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBhJTIwdHJhaW5pbmclMjBqb2IlMjBpZiUyMGElMjBkYXRhc2V0JTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTQwd2ViaG9va19lbmRwb2ludCUwQWFzeW5jJTIwZGVmJTIwdHJpZ2dlcl9ldmFsdWF0aW9uKHBheWxvYWQlM0ElMjBXZWJob29rUGF5bG9hZCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGF5bG9hZC5yZXBvLnR5cGUlMjAlM0QlM0QlMjAlMjJtb2RlbCUyMiUyMGFuZCUyMHBheWxvYWQuZXZlbnQuYWN0aW9uJTIwJTNEJTNEJTIwJTIydXBkYXRlJTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVHJpZ2dlciUyMGFuJTIwZXZhbHVhdGlvbiUyMGpvYiUyMGlmJTIwYSUyMG1vZGVsJTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger a training job if a dataset is updated</span>
        ...

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_evaluation</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;model&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger an evaluation job if a model is updated</span>
        ...`,wrap:!1}}),z=new te({props:{code:"KC4uLiklMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEElMjAlMjAtJTIwUE9TVCUyMGh0dHBzJTNBJTJGJTJGMWZhZGIwZjUyZDhiZjgyNWZjLmdyYWRpby5saXZlJTJGd2ViaG9va3MlMkZ0cmlnZ2VyX2V2YWx1YXRpb24=",highlighted:`(...)
Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_evaluation`,wrap:!1}}),P=new D({props:{title:"Custom server",local:"custom-server",headingTag:"h3"}}),O=new te({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwUmVxdWVzdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBXZWJob29rc1NlcnZlciUyQyUyMFdlYmhvb2tQYXlsb2FkJTBBJTBBJTIzJTIwMS4lMjBEZWZpbmUlMjAlMjBVSSUwQXdpdGglMjBnci5CbG9ja3MoKSUyMGFzJTIwdWklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEElMjMlMjAyLiUyMENyZWF0ZSUyMFdlYmhvb2tzU2VydmVyJTIwd2l0aCUyMGN1c3RvbSUyMFVJJTIwYW5kJTIwc2VjcmV0JTBBYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIodWklM0R1aSUyQyUyMHdlYmhvb2tfc2VjcmV0JTNEJTIybXlfc2VjcmV0X2tleSUyMiklMEElMEElMjMlMjAzLiUyMFJlZ2lzdGVyJTIwd2ViaG9vayUyMHdpdGglMjBleHBsaWNpdCUyMG5hbWUlMEElNDBhcHAuYWRkX3dlYmhvb2soJTIyJTJGc2F5X2hlbGxvJTIyKSUwQWFzeW5jJTIwZGVmJTIwaGVsbG8ocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMm1lc3NhZ2UlMjIlM0ElMjAlMjJoZWxsbyUyMiU3RCUwQSUwQSUyMyUyMDQuJTIwUmVnaXN0ZXIlMjB3ZWJob29rJTIwd2l0aCUyMGltcGxpY2l0JTIwbmFtZSUwQSU0MGFwcC5hZGRfd2ViaG9vayUwQWFzeW5jJTIwZGVmJTIwZ29vZGJ5ZShwYXlsb2FkJTNBJTIwV2ViaG9va1BheWxvYWQpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybWVzc2FnZSUyMiUzQSUyMCUyMmdvb2RieWUlMjIlN0QlMEElMEElMjMlMjA1LiUyMFN0YXJ0JTIwc2VydmVyJTIwKG9wdGlvbmFsKSUwQWFwcC5ydW4oKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> Request
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> WebhooksServer, WebhookPayload

<span class="hljs-comment"># 1. Define  UI</span>
<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> ui:
    ...

<span class="hljs-comment"># 2. Create WebhooksServer with custom UI and secret</span>
app = WebhooksServer(ui=ui, webhook_secret=<span class="hljs-string">&quot;my_secret_key&quot;</span>)

<span class="hljs-comment"># 3. Register webhook with explicit name</span>
<span class="hljs-meta">@app.add_webhook(<span class="hljs-params"><span class="hljs-string">&quot;/say_hello&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">hello</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;hello&quot;</span>}

<span class="hljs-comment"># 4. Register webhook with implicit name</span>
<span class="hljs-meta">@app.add_webhook</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">goodbye</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;goodbye&quot;</span>}

<span class="hljs-comment"># 5. Start server (optional)</span>
app.run()`,wrap:!1}}),{c(){l=i("meta"),g=o(),p=i("p"),f=o(),c(U.$$.fragment),ae=o(),v=i("p"),v.innerHTML=Fe,se=o(),j=i("p"),j.innerHTML=Re,oe=o(),c(m.$$.fragment),ne=o(),c(T.$$.fragment),le=o(),c(I.$$.fragment),ie=o(),W=i("p"),W.textContent=Qe,re=o(),c($.$$.fragment),pe=o(),Z=i("p"),Z.innerHTML=Xe,he=o(),c(G.$$.fragment),ce=o(),B=i("p"),B.textContent=xe,de=o(),C=i("ol"),C.innerHTML=Le,ue=o(),c(k.$$.fragment),we=o(),c(_.$$.fragment),ye=o(),S=i("p"),S.innerHTML=Ee,be=o(),J=i("div"),J.innerHTML=Ne,ge=o(),H=i("p"),H.textContent=ze,fe=o(),c(Y.$$.fragment),Me=o(),V=i("p"),V.innerHTML=Pe,me=o(),F=i("p"),F.innerHTML=qe,Te=o(),R=i("p"),R.innerHTML=Ae,ke=o(),c(Q.$$.fragment),Je=o(),X=i("p"),X.innerHTML=Oe,Ue=o(),c(x.$$.fragment),ve=o(),L=i("p"),L.innerHTML=Ke,je=o(),c(E.$$.fragment),Ie=o(),N=i("p"),N.textContent=De,We=o(),c(z.$$.fragment),$e=o(),c(P.$$.fragment),Ze=o(),q=i("p"),q.innerHTML=et,Ge=o(),A=i("p"),A.textContent=tt,Be=o(),c(O.$$.fragment),Ce=o(),K=i("ol"),K.innerHTML=at,_e=o(),ee=i("p"),this.h()},l(e){const t=ct("svelte-u9bgzb",document.head);l=r(t,"META",{name:!0,content:!0}),t.forEach(a),g=n(e),p=r(e,"P",{}),lt(p).forEach(a),f=n(e),d(U.$$.fragment,e),ae=n(e),v=r(e,"P",{"data-svelte-h":!0}),h(v)!=="svelte-1si55wx"&&(v.innerHTML=Fe),se=n(e),j=r(e,"P",{"data-svelte-h":!0}),h(j)!=="svelte-lbi7qq"&&(j.innerHTML=Re),oe=n(e),d(m.$$.fragment,e),ne=n(e),d(T.$$.fragment,e),le=n(e),d(I.$$.fragment,e),ie=n(e),W=r(e,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1dl6tkz"&&(W.textContent=Qe),re=n(e),d($.$$.fragment,e),pe=n(e),Z=r(e,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-nkdywa"&&(Z.innerHTML=Xe),he=n(e),d(G.$$.fragment,e),ce=n(e),B=r(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-bjh0uv"&&(B.textContent=xe),de=n(e),C=r(e,"OL",{"data-svelte-h":!0}),h(C)!=="svelte-n6iqpe"&&(C.innerHTML=Le),ue=n(e),d(k.$$.fragment,e),we=n(e),d(_.$$.fragment,e),ye=n(e),S=r(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-febs9a"&&(S.innerHTML=Ee),be=n(e),J=r(e,"DIV",{class:!0,"data-svelte-h":!0}),h(J)!=="svelte-9ld38f"&&(J.innerHTML=Ne),ge=n(e),H=r(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1sr65c9"&&(H.textContent=ze),fe=n(e),d(Y.$$.fragment,e),Me=n(e),V=r(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-apq0kg"&&(V.innerHTML=Pe),me=n(e),F=r(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1h3f73"&&(F.innerHTML=qe),Te=n(e),R=r(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-1cxtt3c"&&(R.innerHTML=Ae),ke=n(e),d(Q.$$.fragment,e),Je=n(e),X=r(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-17a8gdb"&&(X.innerHTML=Oe),Ue=n(e),d(x.$$.fragment,e),ve=n(e),L=r(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-gotrx0"&&(L.innerHTML=Ke),je=n(e),d(E.$$.fragment,e),Ie=n(e),N=r(e,"P",{"data-svelte-h":!0}),h(N)!=="svelte-o8x9sv"&&(N.textContent=De),We=n(e),d(z.$$.fragment,e),$e=n(e),d(P.$$.fragment,e),Ze=n(e),q=r(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-7gi6k2"&&(q.innerHTML=et),Ge=n(e),A=r(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1plkp10"&&(A.textContent=tt),Be=n(e),d(O.$$.fragment,e),Ce=n(e),K=r(e,"OL",{"data-svelte-h":!0}),h(K)!=="svelte-fjzv0n"&&(K.innerHTML=at),_e=n(e),ee=r(e,"P",{}),lt(ee).forEach(a),this.h()},h(){He(l,"name","hf:doc:metadata"),He(l,"content",gt),He(J,"class","flex justify-center")},m(e,t){dt(document.head,l),s(e,g,t),s(e,p,t),s(e,f,t),u(U,e,t),s(e,ae,t),s(e,v,t),s(e,se,t),s(e,j,t),s(e,oe,t),u(m,e,t),s(e,ne,t),u(T,e,t),s(e,le,t),u(I,e,t),s(e,ie,t),s(e,W,t),s(e,re,t),u($,e,t),s(e,pe,t),s(e,Z,t),s(e,he,t),u(G,e,t),s(e,ce,t),s(e,B,t),s(e,de,t),s(e,C,t),s(e,ue,t),u(k,e,t),s(e,we,t),u(_,e,t),s(e,ye,t),s(e,S,t),s(e,be,t),s(e,J,t),s(e,ge,t),s(e,H,t),s(e,fe,t),u(Y,e,t),s(e,Me,t),s(e,V,t),s(e,me,t),s(e,F,t),s(e,Te,t),s(e,R,t),s(e,ke,t),u(Q,e,t),s(e,Je,t),s(e,X,t),s(e,Ue,t),u(x,e,t),s(e,ve,t),s(e,L,t),s(e,je,t),u(E,e,t),s(e,Ie,t),s(e,N,t),s(e,We,t),u(z,e,t),s(e,$e,t),u(P,e,t),s(e,Ze,t),s(e,q,t),s(e,Ge,t),s(e,A,t),s(e,Be,t),u(O,e,t),s(e,Ce,t),s(e,K,t),s(e,_e,t),s(e,ee,t),Se=!0},p(e,[t]){const st={};t&2&&(st.$$scope={dirty:t,ctx:e}),m.$set(st);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),T.$set(ot);const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),k.$set(nt)},i(e){Se||(w(U.$$.fragment,e),w(m.$$.fragment,e),w(T.$$.fragment,e),w(I.$$.fragment,e),w($.$$.fragment,e),w(G.$$.fragment,e),w(k.$$.fragment,e),w(_.$$.fragment,e),w(Y.$$.fragment,e),w(Q.$$.fragment,e),w(x.$$.fragment,e),w(E.$$.fragment,e),w(z.$$.fragment,e),w(P.$$.fragment,e),w(O.$$.fragment,e),Se=!0)},o(e){y(U.$$.fragment,e),y(m.$$.fragment,e),y(T.$$.fragment,e),y(I.$$.fragment,e),y($.$$.fragment,e),y(G.$$.fragment,e),y(k.$$.fragment,e),y(_.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(x.$$.fragment,e),y(E.$$.fragment,e),y(z.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),Se=!1},d(e){e&&(a(g),a(p),a(f),a(ae),a(v),a(se),a(j),a(oe),a(ne),a(le),a(ie),a(W),a(re),a(pe),a(Z),a(he),a(ce),a(B),a(de),a(C),a(ue),a(we),a(ye),a(S),a(be),a(J),a(ge),a(H),a(fe),a(Me),a(V),a(me),a(F),a(Te),a(R),a(ke),a(Je),a(X),a(Ue),a(ve),a(L),a(je),a(Ie),a(N),a(We),a($e),a(Ze),a(q),a(Ge),a(A),a(Be),a(Ce),a(K),a(_e),a(ee)),a(l),b(U,e),b(m,e),b(T,e),b(I,e),b($,e),b(G,e),b(k,e),b(_,e),b(Y,e),b(Q,e),b(x,e),b(E,e),b(z,e),b(P,e),b(O,e)}}}const gt='{"title":"Webhooks Server","local":"webhooks-server","sections":[{"title":"Create an endpoint","local":"create-an-endpoint","sections":[],"depth":2},{"title":"Configure a Webhook","local":"configure-a-webhook","sections":[],"depth":2},{"title":"Deploy to a Space","local":"deploy-to-a-space","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Multiple endpoints","local":"multiple-endpoints","sections":[],"depth":3},{"title":"Custom server","local":"custom-server","sections":[],"depth":3}],"depth":2}],"depth":1}';function ft(M){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ut extends pt{constructor(l){super(),ht(this,l,ft,bt,it,{})}}export{Ut as component};
