import{s as Gt,o as xt,n as Le}from"../chunks/scheduler.3e4cb221.js";import{S as Vt,i as Yt,g as a,s as n,r as J,A as Qt,h as p,f as t,c as M,j as vt,u as o,x as i,k as Xt,y as Et,a as s,v as c,d as m,t as T,w as d}from"../chunks/index.bc693fcb.js";import{T as Fe}from"../chunks/Tip.4df9f752.js";import{C as j}from"../chunks/CodeBlock.4b1f9331.js";import{H as Nl}from"../chunks/Heading.fa24041c.js";function Ht(f){let y,U="如果你的模型与库中的某个模型非常相似，你可以重用与该模型相同的配置。";return{c(){y=a("p"),y.textContent=U},l(w){y=p(w,"P",{"data-svelte-h":!0}),i(y)!=="svelte-1t5zcat"&&(y.textContent=U)},m(w,r){s(w,y,r)},p:Le,d(w){w&&t(y)}}}function zt(f){let y,U="此 API 是实验性的，未来的发布中可能会有一些轻微的不兼容更改。";return{c(){y=a("p"),y.textContent=U},l(w){y=p(w,"P",{"data-svelte-h":!0}),i(y)!=="svelte-k4mbd2"&&(y.textContent=U)},m(w,r){s(w,y,r)},p:Le,d(w){w&&t(y)}}}function Ft(f){let y,U="如果从库中复制模型文件，你需要将文件顶部的所有相对导入替换为从 <code>transformers</code> 包中的导入。";return{c(){y=a("p"),y.innerHTML=U},l(w){y=p(w,"P",{"data-svelte-h":!0}),i(y)!=="svelte-3nrr3e"&&(y.innerHTML=U)},m(w,r){s(w,y,r)},p:Le,d(w){w&&t(y)}}}function Lt(f){let y,U,w,r,I,Wl,Z,Se="🤗 Transformers 库设计得易于扩展。每个模型的代码都在仓库给定的子文件夹中，没有进行抽象，因此你可以轻松复制模型代码文件并根据需要进行调整。",Rl,_,qe="如果你要编写全新的模型，从头开始可能更容易。在本教程中，我们将向你展示如何编写自定义模型及其配置，以便可以在 Transformers 中使用它；以及如何与社区共享它（及其依赖的代码），以便任何人都可以使用，即使它不在 🤗 Transformers 库中。",vl,h,Pe='我们将以 ResNet 模型为例，通过将 <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm 库</a> 的 ResNet 类封装到 <code>PreTrainedModel</code> 中来进行说明。',Xl,A,Gl,$,De="在深入研究模型之前，让我们首先编写其配置。模型的配置是一个对象，其中包含构建模型所需的所有信息。我们将在下一节中看到，模型只能接受一个 <code>config</code> 来进行初始化，因此我们很需要使该对象尽可能完整。",xl,g,Ke="我们将采用一些我们可能想要调整的 ResNet 类的参数举例。不同的配置将为我们提供不同类型可能的 ResNet 模型。在确认其中一些参数的有效性后，我们只需存储这些参数。",Vl,k,Yl,N,Oe="编写自定义配置时需要记住的三个重要事项如下：",Ql,B,lt="<li>必须继承自 <code>PretrainedConfig</code>，</li> <li><code>PretrainedConfig</code> 的 <code>__init__</code> 方法必须接受任何 kwargs，</li> <li>这些 <code>kwargs</code> 需要传递给超类的 <code>__init__</code> 方法。</li>",El,W,et="继承是为了确保你获得来自 🤗 Transformers 库的所有功能，而另外两个约束源于 <code>PretrainedConfig</code> 的字段比你设置的字段多。在使用 <code>from_pretrained</code> 方法重新加载配置时，这些字段需要被你的配置接受，然后传递给超类。",Hl,R,tt="为你的配置定义 <code>model_type</code>（此处为 <code>model_type=&quot;resnet&quot;</code>）不是必须的，除非你想使用自动类注册你的模型（请参阅最后一节）。",zl,v,st="做完这些以后，就可以像使用库里任何其他模型配置一样，轻松地创建和保存配置。以下代码展示了如何创建并保存 resnet50d 配置：",Fl,X,Ll,G,nt="这行代码将在 <code>custom-resnet</code> 文件夹内保存一个名为 <code>config.json</code> 的文件。然后，你可以使用 <code>from_pretrained</code> 方法重新加载配置：",Sl,x,ql,V,Mt="你还可以使用 <code>PretrainedConfig</code> 类的任何其他方法，例如 <code>push_to_hub()</code>，直接将配置上传到 Hub。",Pl,Y,Dl,Q,at="有了 ResNet 配置后，就可以继续编写模型了。实际上，我们将编写两个模型：一个模型用于从一批图像中提取隐藏特征（类似于 <code>BertModel</code>），另一个模型适用于图像分类（类似于 <code>BertForSequenceClassification</code>）。",Kl,E,pt="正如之前提到的，我们只会编写一个松散的模型包装，以使示例保持简洁。在编写此类之前，只需要建立起块类型（block types）与实际块类（block classes）之间的映射。然后，通过将所有内容传递给ResNet类，从配置中定义模型：",Ol,H,le,z,it="对用于进行图像分类的模型，我们只需更改前向方法：",ee,F,te,L,yt="在这两种情况下，请注意我们如何继承 <code>PreTrainedModel</code> 并使用 <code>config</code> 调用了超类的初始化（有点像编写常规的torch.nn.Module）。设置 <code>config_class</code> 的那行代码不是必须的，除非你想使用自动类注册你的模型（请参阅最后一节）。",se,C,ne,S,Jt="你可以让模型返回任何你想要的内容，但是像我们为 <code>ResnetModelForImageClassification</code> 做的那样返回一个字典，并在传递标签时包含loss，可以使你的模型能够在 <code>Trainer</code> 类中直接使用。只要你计划使用自己的训练循环或其他库进行训练，也可以使用其他输出格式。",Me,q,ot="现在我们已经有了模型类，让我们创建一个：",ae,P,pe,D,ct="同样的，你可以使用 <code>PreTrainedModel</code> 的任何方法，比如 <code>save_pretrained()</code> 或者 <code>push_to_hub()</code>。我们将在下一节中使用第二种方法，并了解如何如何使用我们的模型的代码推送模型权重。但首先，让我们在模型内加载一些预训练权重。",ie,K,mt="在你自己的用例中，你可能会在自己的数据上训练自定义模型。为了快速完成本教程，我们将使用 resnet50d 的预训练版本。由于我们的模型只是它的包装，转移这些权重将会很容易：",ye,O,Je,ll,Tt="现在让我们看看，如何确保在执行 <code>save_pretrained()</code> 或 <code>push_to_hub()</code> 时，模型的代码被保存。",oe,el,ce,u,me,tl,dt="首先，确保你的模型在一个 <code>.py</code> 文件中完全定义。只要所有文件都位于同一目录中，它就可以依赖于某些其他文件的相对导入（目前我们还不为子模块支持此功能）。对于我们的示例，我们将在当前工作目录中名为 <code>resnet_model</code> 的文件夹中定义一个 <code>modeling_resnet.py</code> 文件和一个 <code>configuration_resnet.py</code> 文件。 配置文件包含 <code>ResnetConfig</code> 的代码，模型文件包含 <code>ResnetModel</code> 和 <code>ResnetModelForImageClassification</code> 的代码。",Te,sl,de,nl,wt="<code>__init__.py</code> 可以为空，它的存在只是为了让 Python 检测到 <code>resnet_model</code> 可以用作模块。",we,b,je,Ml,jt="请注意，你可以重用（或子类化）现有的配置/模型。",Ue,al,Ut="要与社区共享您的模型，请参照以下步骤：首先从新创建的文件中导入ResNet模型和配置：",re,pl,fe,il,rt="接下来，你需要告诉库，当使用 <code>save_pretrained</code> 方法时，你希望复制这些对象的代码文件，并将它们正确注册到给定的 Auto 类（特别是对于模型），只需要运行以下代码：",Ce,yl,ue,Jl,ft="请注意，对于配置（只有一个自动类 <code>AutoConfig</code>），不需要指定自动类，但对于模型来说情况不同。 你的自定义模型可能适用于许多不同的任务，因此你必须指定哪一个自动类适合你的模型。",be,ol,Ct="接下来，让我们像之前一样创建配置和模型：",Ie,cl,Ze,ml,ut="现在要将模型推送到集线器，请确保你已登录。你看可以在终端中运行以下命令：",_e,Tl,he,dl,bt="或者在笔记本中运行以下代码：",Ae,wl,$e,jl,It="然后，可以这样将模型推送到自己的命名空间（或你所属的组织）：",ge,Ul,ke,rl,Zt='除了模型权重和 JSON 格式的配置外，这行代码也会复制 <code>custom-resnet50d</code> 文件夹内的模型以及配置的 <code>.py</code> 文件并将结果上传至 Hub。你可以在此<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">模型仓库</a>中查看结果。',Ne,fl,_t='有关推推送至 Hub 方法的更多信息，请参阅<a href="model_sharing">共享教程</a>。',Be,Cl,We,ul,ht='可以使用自动类（auto-classes）和 <code>from_pretrained</code> 方法，使用模型仓库里带有自定义代码的配置、模型或分词器文件。所有上传到 Hub 的文件和代码都会进行恶意软件扫描（有关更多信息，请参阅 <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub 安全</a> 文档）, 但你仍应查看模型代码和作者，以避免在你的计算机上执行恶意代码。 设置 <code>trust_remote_code=True</code> 以使用带有自定义代码的模型：',Re,bl,ve,Il,At="我们强烈建议为 <code>revision</code> 参数传递提交哈希（commit hash），以确保模型的作者没有使用一些恶意的代码行更新了代码（除非您完全信任模型的作者）。",Xe,Zl,Ge,_l,$t="在 Hub 上浏览模型仓库的提交历史时，有一个按钮可以轻松复制任何提交的提交哈希。",xe,hl,Ve,Al,gt="如果你在编写一个扩展 🤗 Transformers 的库，你可能想要扩展自动类以包含您自己的模型。这与将代码推送到 Hub 不同，因为用户需要导入你的库才能获取自定义模型（与从 Hub 自动下载模型代码相反）。",Ye,$l,kt="只要你的配置 <code>model_type</code> 属性与现有模型类型不同，并且你的模型类有正确的 <code>config_class</code> 属性，你可以像这样将它们添加到自动类中：",Qe,gl,Ee,kl,Nt="请注意，将自定义配置注册到 <code>AutoConfig</code> 时，使用的第一个参数需要与自定义配置的 <code>model_type</code> 匹配；而将自定义模型注册到任何自动模型类时，使用的第一个参数需要与 <code>config_class</code> 匹配。",He,Bl,ze;return I=new Nl({props:{title:"共享自定义模型",local:"共享自定义模型",headingTag:"h1"}}),A=new Nl({props:{title:"编写自定义配置",local:"编写自定义配置",headingTag:"h2"}}),k=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),x=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),Y=new Nl({props:{title:"编写自定义模型",local:"编写自定义模型",headingTag:"h2"}}),H=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),C=new Fe({props:{$$slots:{default:[Ht]},$$scope:{ctx:f}}}),P=new j({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new j({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),el=new Nl({props:{title:"将代码发送到 Hub",local:"将代码发送到-hub",headingTag:"h2"}}),u=new Fe({props:{warning:!0,$$slots:{default:[zt]},$$scope:{ctx:f}}}),sl=new j({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),b=new Fe({props:{warning:!0,$$slots:{default:[Ft]},$$scope:{ctx:f}}}),pl=new j({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),yl=new j({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),cl=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),Tl=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),wl=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Ul=new j({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),Cl=new Nl({props:{title:"使用带有自定义代码的模型",local:"使用带有自定义代码的模型",headingTag:"h2"}}),bl=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Zl=new j({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),hl=new Nl({props:{title:"将自定义代码的模型注册到自动类",local:"将自定义代码的模型注册到自动类",headingTag:"h2"}}),gl=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){y=a("meta"),U=n(),w=a("p"),r=n(),J(I.$$.fragment),Wl=n(),Z=a("p"),Z.textContent=Se,Rl=n(),_=a("p"),_.textContent=qe,vl=n(),h=a("p"),h.innerHTML=Pe,Xl=n(),J(A.$$.fragment),Gl=n(),$=a("p"),$.innerHTML=De,xl=n(),g=a("p"),g.textContent=Ke,Vl=n(),J(k.$$.fragment),Yl=n(),N=a("p"),N.textContent=Oe,Ql=n(),B=a("ul"),B.innerHTML=lt,El=n(),W=a("p"),W.innerHTML=et,Hl=n(),R=a("p"),R.innerHTML=tt,zl=n(),v=a("p"),v.textContent=st,Fl=n(),J(X.$$.fragment),Ll=n(),G=a("p"),G.innerHTML=nt,Sl=n(),J(x.$$.fragment),ql=n(),V=a("p"),V.innerHTML=Mt,Pl=n(),J(Y.$$.fragment),Dl=n(),Q=a("p"),Q.innerHTML=at,Kl=n(),E=a("p"),E.textContent=pt,Ol=n(),J(H.$$.fragment),le=n(),z=a("p"),z.textContent=it,ee=n(),J(F.$$.fragment),te=n(),L=a("p"),L.innerHTML=yt,se=n(),J(C.$$.fragment),ne=n(),S=a("p"),S.innerHTML=Jt,Me=n(),q=a("p"),q.textContent=ot,ae=n(),J(P.$$.fragment),pe=n(),D=a("p"),D.innerHTML=ct,ie=n(),K=a("p"),K.textContent=mt,ye=n(),J(O.$$.fragment),Je=n(),ll=a("p"),ll.innerHTML=Tt,oe=n(),J(el.$$.fragment),ce=n(),J(u.$$.fragment),me=n(),tl=a("p"),tl.innerHTML=dt,Te=n(),J(sl.$$.fragment),de=n(),nl=a("p"),nl.innerHTML=wt,we=n(),J(b.$$.fragment),je=n(),Ml=a("p"),Ml.textContent=jt,Ue=n(),al=a("p"),al.textContent=Ut,re=n(),J(pl.$$.fragment),fe=n(),il=a("p"),il.innerHTML=rt,Ce=n(),J(yl.$$.fragment),ue=n(),Jl=a("p"),Jl.innerHTML=ft,be=n(),ol=a("p"),ol.textContent=Ct,Ie=n(),J(cl.$$.fragment),Ze=n(),ml=a("p"),ml.textContent=ut,_e=n(),J(Tl.$$.fragment),he=n(),dl=a("p"),dl.textContent=bt,Ae=n(),J(wl.$$.fragment),$e=n(),jl=a("p"),jl.textContent=It,ge=n(),J(Ul.$$.fragment),ke=n(),rl=a("p"),rl.innerHTML=Zt,Ne=n(),fl=a("p"),fl.innerHTML=_t,Be=n(),J(Cl.$$.fragment),We=n(),ul=a("p"),ul.innerHTML=ht,Re=n(),J(bl.$$.fragment),ve=n(),Il=a("p"),Il.innerHTML=At,Xe=n(),J(Zl.$$.fragment),Ge=n(),_l=a("p"),_l.textContent=$t,xe=n(),J(hl.$$.fragment),Ve=n(),Al=a("p"),Al.textContent=gt,Ye=n(),$l=a("p"),$l.innerHTML=kt,Qe=n(),J(gl.$$.fragment),Ee=n(),kl=a("p"),kl.innerHTML=Nt,He=n(),Bl=a("p"),this.h()},l(l){const e=Qt("svelte-u9bgzb",document.head);y=p(e,"META",{name:!0,content:!0}),e.forEach(t),U=M(l),w=p(l,"P",{}),vt(w).forEach(t),r=M(l),o(I.$$.fragment,l),Wl=M(l),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-9nxend"&&(Z.textContent=Se),Rl=M(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-19a103f"&&(_.textContent=qe),vl=M(l),h=p(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-y1zi09"&&(h.innerHTML=Pe),Xl=M(l),o(A.$$.fragment,l),Gl=M(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1227xwf"&&($.innerHTML=De),xl=M(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-i8hsxz"&&(g.textContent=Ke),Vl=M(l),o(k.$$.fragment,l),Yl=M(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1a7oeqv"&&(N.textContent=Oe),Ql=M(l),B=p(l,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-1s6yo4g"&&(B.innerHTML=lt),El=M(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-tl0pjo"&&(W.innerHTML=et),Hl=M(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1atr0z9"&&(R.innerHTML=tt),zl=M(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1p70ds2"&&(v.textContent=st),Fl=M(l),o(X.$$.fragment,l),Ll=M(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-o9rk46"&&(G.innerHTML=nt),Sl=M(l),o(x.$$.fragment,l),ql=M(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1gwgggl"&&(V.innerHTML=Mt),Pl=M(l),o(Y.$$.fragment,l),Dl=M(l),Q=p(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-bmcwbb"&&(Q.innerHTML=at),Kl=M(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1lbtc6j"&&(E.textContent=pt),Ol=M(l),o(H.$$.fragment,l),le=M(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-16341pc"&&(z.textContent=it),ee=M(l),o(F.$$.fragment,l),te=M(l),L=p(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-18rfxea"&&(L.innerHTML=yt),se=M(l),o(C.$$.fragment,l),ne=M(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-od54k8"&&(S.innerHTML=Jt),Me=M(l),q=p(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-ym2h95"&&(q.textContent=ot),ae=M(l),o(P.$$.fragment,l),pe=M(l),D=p(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-67fulx"&&(D.innerHTML=ct),ie=M(l),K=p(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-36p84q"&&(K.textContent=mt),ye=M(l),o(O.$$.fragment,l),Je=M(l),ll=p(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1y99397"&&(ll.innerHTML=Tt),oe=M(l),o(el.$$.fragment,l),ce=M(l),o(u.$$.fragment,l),me=M(l),tl=p(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-3w8bak"&&(tl.innerHTML=dt),Te=M(l),o(sl.$$.fragment,l),de=M(l),nl=p(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-n806b8"&&(nl.innerHTML=wt),we=M(l),o(b.$$.fragment,l),je=M(l),Ml=p(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-18wuvr2"&&(Ml.textContent=jt),Ue=M(l),al=p(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-7gjgjm"&&(al.textContent=Ut),re=M(l),o(pl.$$.fragment,l),fe=M(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-nsc87p"&&(il.innerHTML=rt),Ce=M(l),o(yl.$$.fragment,l),ue=M(l),Jl=p(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-1dt591c"&&(Jl.innerHTML=ft),be=M(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1vunet5"&&(ol.textContent=Ct),Ie=M(l),o(cl.$$.fragment,l),Ze=M(l),ml=p(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-11g63u9"&&(ml.textContent=ut),_e=M(l),o(Tl.$$.fragment,l),he=M(l),dl=p(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-1emymh6"&&(dl.textContent=bt),Ae=M(l),o(wl.$$.fragment,l),$e=M(l),jl=p(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-1xi8u2o"&&(jl.textContent=It),ge=M(l),o(Ul.$$.fragment,l),ke=M(l),rl=p(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1qq9kbx"&&(rl.innerHTML=Zt),Ne=M(l),fl=p(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1e6fo38"&&(fl.innerHTML=_t),Be=M(l),o(Cl.$$.fragment,l),We=M(l),ul=p(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-xah23j"&&(ul.innerHTML=ht),Re=M(l),o(bl.$$.fragment,l),ve=M(l),Il=p(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-1dvm79h"&&(Il.innerHTML=At),Xe=M(l),o(Zl.$$.fragment,l),Ge=M(l),_l=p(l,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-8xcaeg"&&(_l.textContent=$t),xe=M(l),o(hl.$$.fragment,l),Ve=M(l),Al=p(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-1y2zt0l"&&(Al.textContent=gt),Ye=M(l),$l=p(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-l7gnnd"&&($l.innerHTML=kt),Qe=M(l),o(gl.$$.fragment,l),Ee=M(l),kl=p(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-zrvvjw"&&(kl.innerHTML=Nt),He=M(l),Bl=p(l,"P",{}),vt(Bl).forEach(t),this.h()},h(){Xt(y,"name","hf:doc:metadata"),Xt(y,"content",St)},m(l,e){Et(document.head,y),s(l,U,e),s(l,w,e),s(l,r,e),c(I,l,e),s(l,Wl,e),s(l,Z,e),s(l,Rl,e),s(l,_,e),s(l,vl,e),s(l,h,e),s(l,Xl,e),c(A,l,e),s(l,Gl,e),s(l,$,e),s(l,xl,e),s(l,g,e),s(l,Vl,e),c(k,l,e),s(l,Yl,e),s(l,N,e),s(l,Ql,e),s(l,B,e),s(l,El,e),s(l,W,e),s(l,Hl,e),s(l,R,e),s(l,zl,e),s(l,v,e),s(l,Fl,e),c(X,l,e),s(l,Ll,e),s(l,G,e),s(l,Sl,e),c(x,l,e),s(l,ql,e),s(l,V,e),s(l,Pl,e),c(Y,l,e),s(l,Dl,e),s(l,Q,e),s(l,Kl,e),s(l,E,e),s(l,Ol,e),c(H,l,e),s(l,le,e),s(l,z,e),s(l,ee,e),c(F,l,e),s(l,te,e),s(l,L,e),s(l,se,e),c(C,l,e),s(l,ne,e),s(l,S,e),s(l,Me,e),s(l,q,e),s(l,ae,e),c(P,l,e),s(l,pe,e),s(l,D,e),s(l,ie,e),s(l,K,e),s(l,ye,e),c(O,l,e),s(l,Je,e),s(l,ll,e),s(l,oe,e),c(el,l,e),s(l,ce,e),c(u,l,e),s(l,me,e),s(l,tl,e),s(l,Te,e),c(sl,l,e),s(l,de,e),s(l,nl,e),s(l,we,e),c(b,l,e),s(l,je,e),s(l,Ml,e),s(l,Ue,e),s(l,al,e),s(l,re,e),c(pl,l,e),s(l,fe,e),s(l,il,e),s(l,Ce,e),c(yl,l,e),s(l,ue,e),s(l,Jl,e),s(l,be,e),s(l,ol,e),s(l,Ie,e),c(cl,l,e),s(l,Ze,e),s(l,ml,e),s(l,_e,e),c(Tl,l,e),s(l,he,e),s(l,dl,e),s(l,Ae,e),c(wl,l,e),s(l,$e,e),s(l,jl,e),s(l,ge,e),c(Ul,l,e),s(l,ke,e),s(l,rl,e),s(l,Ne,e),s(l,fl,e),s(l,Be,e),c(Cl,l,e),s(l,We,e),s(l,ul,e),s(l,Re,e),c(bl,l,e),s(l,ve,e),s(l,Il,e),s(l,Xe,e),c(Zl,l,e),s(l,Ge,e),s(l,_l,e),s(l,xe,e),c(hl,l,e),s(l,Ve,e),s(l,Al,e),s(l,Ye,e),s(l,$l,e),s(l,Qe,e),c(gl,l,e),s(l,Ee,e),s(l,kl,e),s(l,He,e),s(l,Bl,e),ze=!0},p(l,[e]){const Bt={};e&2&&(Bt.$$scope={dirty:e,ctx:l}),C.$set(Bt);const Wt={};e&2&&(Wt.$$scope={dirty:e,ctx:l}),u.$set(Wt);const Rt={};e&2&&(Rt.$$scope={dirty:e,ctx:l}),b.$set(Rt)},i(l){ze||(m(I.$$.fragment,l),m(A.$$.fragment,l),m(k.$$.fragment,l),m(X.$$.fragment,l),m(x.$$.fragment,l),m(Y.$$.fragment,l),m(H.$$.fragment,l),m(F.$$.fragment,l),m(C.$$.fragment,l),m(P.$$.fragment,l),m(O.$$.fragment,l),m(el.$$.fragment,l),m(u.$$.fragment,l),m(sl.$$.fragment,l),m(b.$$.fragment,l),m(pl.$$.fragment,l),m(yl.$$.fragment,l),m(cl.$$.fragment,l),m(Tl.$$.fragment,l),m(wl.$$.fragment,l),m(Ul.$$.fragment,l),m(Cl.$$.fragment,l),m(bl.$$.fragment,l),m(Zl.$$.fragment,l),m(hl.$$.fragment,l),m(gl.$$.fragment,l),ze=!0)},o(l){T(I.$$.fragment,l),T(A.$$.fragment,l),T(k.$$.fragment,l),T(X.$$.fragment,l),T(x.$$.fragment,l),T(Y.$$.fragment,l),T(H.$$.fragment,l),T(F.$$.fragment,l),T(C.$$.fragment,l),T(P.$$.fragment,l),T(O.$$.fragment,l),T(el.$$.fragment,l),T(u.$$.fragment,l),T(sl.$$.fragment,l),T(b.$$.fragment,l),T(pl.$$.fragment,l),T(yl.$$.fragment,l),T(cl.$$.fragment,l),T(Tl.$$.fragment,l),T(wl.$$.fragment,l),T(Ul.$$.fragment,l),T(Cl.$$.fragment,l),T(bl.$$.fragment,l),T(Zl.$$.fragment,l),T(hl.$$.fragment,l),T(gl.$$.fragment,l),ze=!1},d(l){l&&(t(U),t(w),t(r),t(Wl),t(Z),t(Rl),t(_),t(vl),t(h),t(Xl),t(Gl),t($),t(xl),t(g),t(Vl),t(Yl),t(N),t(Ql),t(B),t(El),t(W),t(Hl),t(R),t(zl),t(v),t(Fl),t(Ll),t(G),t(Sl),t(ql),t(V),t(Pl),t(Dl),t(Q),t(Kl),t(E),t(Ol),t(le),t(z),t(ee),t(te),t(L),t(se),t(ne),t(S),t(Me),t(q),t(ae),t(pe),t(D),t(ie),t(K),t(ye),t(Je),t(ll),t(oe),t(ce),t(me),t(tl),t(Te),t(de),t(nl),t(we),t(je),t(Ml),t(Ue),t(al),t(re),t(fe),t(il),t(Ce),t(ue),t(Jl),t(be),t(ol),t(Ie),t(Ze),t(ml),t(_e),t(he),t(dl),t(Ae),t($e),t(jl),t(ge),t(ke),t(rl),t(Ne),t(fl),t(Be),t(We),t(ul),t(Re),t(ve),t(Il),t(Xe),t(Ge),t(_l),t(xe),t(Ve),t(Al),t(Ye),t($l),t(Qe),t(Ee),t(kl),t(He),t(Bl)),t(y),d(I,l),d(A,l),d(k,l),d(X,l),d(x,l),d(Y,l),d(H,l),d(F,l),d(C,l),d(P,l),d(O,l),d(el,l),d(u,l),d(sl,l),d(b,l),d(pl,l),d(yl,l),d(cl,l),d(Tl,l),d(wl,l),d(Ul,l),d(Cl,l),d(bl,l),d(Zl,l),d(hl,l),d(gl,l)}}}const St='{"title":"共享自定义模型","local":"共享自定义模型","sections":[{"title":"编写自定义配置","local":"编写自定义配置","sections":[],"depth":2},{"title":"编写自定义模型","local":"编写自定义模型","sections":[],"depth":2},{"title":"将代码发送到 Hub","local":"将代码发送到-hub","sections":[],"depth":2},{"title":"使用带有自定义代码的模型","local":"使用带有自定义代码的模型","sections":[],"depth":2},{"title":"将自定义代码的模型注册到自动类","local":"将自定义代码的模型注册到自动类","sections":[],"depth":2}],"depth":1}';function qt(f){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends Vt{constructor(y){super(),Yt(this,y,qt,Lt,Gt,{})}}export{es as component};
