import{s as Ss,n as As,o as Ps}from"../chunks/scheduler.9bc65507.js";import{S as Ds,i as Ls,g as p,s as e,r as c,A as Ks,h as i,f as l,c as n,j as Xs,u as m,x as o,k as $s,y as Os,a,v as r,d as g,t as h,w as j}from"../chunks/index.707bf1b6.js";import{C as M}from"../chunks/CodeBlock.54a9f38d.js";import{D as st}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as Cs}from"../chunks/Heading.342b1fa6.js";function tt(vs){let f,A,X,P,y,D,d,L,x,Zs=`ゼロショット画像分類は、次のモデルを使用して画像をさまざまなカテゴリに分類するタスクです。
これらの特定のカテゴリのラベル付きの例を含むデータに対して明示的にトレーニングされていない。`,K,w,ks=`従来、画像分類には、ラベル付き画像の特定のセットでモデルをトレーニングする必要があり、このモデルは次のことを学習します。
特定の画像の特徴をラベルに「マッピング」します。分類タスクにそのようなモデルを使用する必要がある場合、
新しいラベルのセットでは、モデルを “再調整” するために微調整が必​​要です。`,O,J,Rs=`対照的に、ゼロショットまたはオープン語彙画像分類モデルは、通常、大規模なシステムでトレーニングされたマルチモーダル モデルです。
画像と関連する説明のデータセット。これらのモデルは、ゼロショット画像分類を含む多くの下流タスクに使用できる、調整された視覚言語表現を学習します。`,ss,U,_s=`これは、画像分類に対するより柔軟なアプローチであり、モデルを新しいまだ見たことのないカテゴリに一般化できるようになります。
追加のトレーニング データを必要とせず、ユーザーはターゲット オブジェクトの自由形式のテキスト説明を含む画像をクエリできるようになります。`,ts,T,Gs="このガイドでは、次の方法を学びます。",ls,$,Is="<li>ゼロショット画像分類パイプラインを作成する</li> <li>手動でゼロショット画像分類推論を実行します</li>",as,C,zs="始める前に、必要なライブラリがすべてインストールされていることを確認してください。",es,v,ns,Z,ps,k,Ws=`ゼロショット画像分類をサポートするモデルで推論を試す最も簡単な方法は、対応する <code>パイプライン</code> を使用することです。
<a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">Hugging Face Hub のチェックポイント</a> からパイプラインをインスタンス化します。`,is,R,os,_,Es="次に、分類したい画像を選択します。",cs,G,ms,u,Bs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/owl.jpg" alt="Photo of an owl"/>',rs,I,Hs=`画像と候補オブジェクトのラベルをパイプラインに渡します。ここでは画像を直接渡します。他の適切なオプション
画像へのローカル パスまたは画像 URL を含めます。
候補ラベルは、この例のように単純な単語にすることも、より説明的な単語にすることもできます。`,gs,z,hs,W,js,E,Ns=`ゼロショット画像分類パイプラインの使用方法を理解したところで、ゼロショットを実行する方法を見てみましょう。
画像を手動で分類します。`,fs,B,Ys=`まず、<a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">Hugging Face Hub のチェックポイント</a> からモデルと関連プロセッサをロードします。
ここでは、前と同じチェックポイントを使用します。`,us,H,bs,N,Fs="気分を変えて、別の画像を撮ってみましょう。",Ms,Y,ys,b,Qs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/car.jpg" alt="Photo of a car"/>',ds,F,Vs=`プロセッサを使用してモデルの入力を準備します。プロセッサーは、
サイズ変更と正規化によるモデルの画像、およびテキスト入力を処理するトークナイザー。`,xs,Q,ws,V,qs="入力をモデルに渡し、結果を後処理します。",Js,q,Us,S,Ts;return y=new Cs({props:{title:"Zero-shot image classification",local:"zero-shot-image-classification",headingTag:"h1"}}),d=new st({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/zero_shot_image_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/zero_shot_image_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/zero_shot_image_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/zero_shot_image_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/zero_shot_image_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/zero_shot_image_classification.ipynb"}]}}),v=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),Z=new Cs({props:{title:"Zero-shot image classification pipeline",local:"zero-shot-image-classification-pipeline",headingTag:"h2"}}),R=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm9wZW5haSUyRmNsaXAtdml0LWxhcmdlLXBhdGNoMTQlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-image-classification&quot;</span>)`,wrap:!1}}),G=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRmc4b1M4LTgyRHhJJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4MGIzQnBZM3g4U25Cbk5rdHBaR3d0U0d0OGZIeDhmREo4ZkRFMk56Z3hNRFl3T0RjJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/g8oS8-82DxI/download?ixid=MnwxMjA3fDB8MXx0b3BpY3x8SnBnNktpZGwtSGt8fHx8fDJ8fDE2NzgxMDYwODc&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),z=new M({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvcihpbWFnZSUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJmb3glMjIlMkMlMjAlMjJiZWFyJTIyJTJDJTIwJTIyc2VhZ3VsbCUyMiUyQyUyMCUyMm93bCUyMiU1RCklMEFwcmVkaWN0aW9ucw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(image, candidate_labels=[<span class="hljs-string">&quot;fox&quot;</span>, <span class="hljs-string">&quot;bear&quot;</span>, <span class="hljs-string">&quot;seagull&quot;</span>, <span class="hljs-string">&quot;owl&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9996670484542847</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;owl&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.000199399160919711</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;seagull&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">7.392891711788252e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fox&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">5.96074532950297e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bear&#x27;</span>}]`,wrap:!1}}),W=new Cs({props:{title:"Zero-shot image classification by hand",local:"zero-shot-image-classification-by-hand",headingTag:"h2"}}),H=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),Y=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRnhCUlFmUjJicU5JJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4aGJHeDhmSHg4Zkh4OGZId3hOamM0TXpnNE9ERXglMjZmb3JjZSUzRHRydWUlMjZ3JTNENjQwJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/xBRQfR2bqNI/download?ixid=MnwxMjA3fDB8MXxhbGx8fHx8fHx8fHwxNjc4Mzg4ODEx&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),Q=new M({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMnRyZWUlMjIlMkMlMjAlMjJjYXIlMjIlMkMlMjAlMjJiaWtlJTIyJTJDJTIwJTIyY2F0JTIyJTVEJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRGNhbmRpZGF0ZV9sYWJlbHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;tree&quot;</span>, <span class="hljs-string">&quot;car&quot;</span>, <span class="hljs-string">&quot;bike&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=candidate_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)`,wrap:!1}}),q=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzX3Blcl9pbWFnZSU1QjAlNUQlMEFwcm9icyUyMCUzRCUyMGxvZ2l0cy5zb2Z0bWF4KGRpbSUzRC0xKS5udW1weSgpJTBBc2NvcmVzJTIwJTNEJTIwcHJvYnMudG9saXN0KCklMEElMEFyZXN1bHQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMHNjb3JlJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBjYW5kaWRhdGVfbGFiZWwlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBzY29yZSUyQyUyMGNhbmRpZGF0ZV9sYWJlbCUyMGluJTIwc29ydGVkKHppcChwcm9icyUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMC14JTVCMCU1RCklMEElNUQlMEElMEFyZXN1bHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits_per_image[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits.softmax(dim=-<span class="hljs-number">1</span>).numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>scores = probs.tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span>result = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;label&quot;</span>: candidate_label}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> score, candidate_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(<span class="hljs-built_in">zip</span>(probs, candidate_labels), key=<span class="hljs-keyword">lambda</span> x: -x[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>result
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.998572</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0010570387</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bike&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0003393686</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tree&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">3.1572064e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}]`,wrap:!1}}),{c(){f=p("meta"),A=e(),X=p("p"),P=e(),c(y.$$.fragment),D=e(),c(d.$$.fragment),L=e(),x=p("p"),x.textContent=Zs,K=e(),w=p("p"),w.textContent=ks,O=e(),J=p("p"),J.textContent=Rs,ss=e(),U=p("p"),U.textContent=_s,ts=e(),T=p("p"),T.textContent=Gs,ls=e(),$=p("ul"),$.innerHTML=Is,as=e(),C=p("p"),C.textContent=zs,es=e(),c(v.$$.fragment),ns=e(),c(Z.$$.fragment),ps=e(),k=p("p"),k.innerHTML=Ws,is=e(),c(R.$$.fragment),os=e(),_=p("p"),_.textContent=Es,cs=e(),c(G.$$.fragment),ms=e(),u=p("div"),u.innerHTML=Bs,rs=e(),I=p("p"),I.textContent=Hs,gs=e(),c(z.$$.fragment),hs=e(),c(W.$$.fragment),js=e(),E=p("p"),E.textContent=Ns,fs=e(),B=p("p"),B.innerHTML=Ys,us=e(),c(H.$$.fragment),bs=e(),N=p("p"),N.textContent=Fs,Ms=e(),c(Y.$$.fragment),ys=e(),b=p("div"),b.innerHTML=Qs,ds=e(),F=p("p"),F.textContent=Vs,xs=e(),c(Q.$$.fragment),ws=e(),V=p("p"),V.textContent=qs,Js=e(),c(q.$$.fragment),Us=e(),S=p("p"),this.h()},l(s){const t=Ks("svelte-u9bgzb",document.head);f=i(t,"META",{name:!0,content:!0}),t.forEach(l),A=n(s),X=i(s,"P",{}),Xs(X).forEach(l),P=n(s),m(y.$$.fragment,s),D=n(s),m(d.$$.fragment,s),L=n(s),x=i(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-753hod"&&(x.textContent=Zs),K=n(s),w=i(s,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1pvht9m"&&(w.textContent=ks),O=n(s),J=i(s,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1pwpmsj"&&(J.textContent=Rs),ss=n(s),U=i(s,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1izek7c"&&(U.textContent=_s),ts=n(s),T=i(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-tlz6vm"&&(T.textContent=Gs),ls=n(s),$=i(s,"UL",{"data-svelte-h":!0}),o($)!=="svelte-x7hnkc"&&($.innerHTML=Is),as=n(s),C=i(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1lya3k8"&&(C.textContent=zs),es=n(s),m(v.$$.fragment,s),ns=n(s),m(Z.$$.fragment,s),ps=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1yjcekc"&&(k.innerHTML=Ws),is=n(s),m(R.$$.fragment,s),os=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-stzvzh"&&(_.textContent=Es),cs=n(s),m(G.$$.fragment,s),ms=n(s),u=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(u)!=="svelte-10yxso1"&&(u.innerHTML=Bs),rs=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-6ob2q8"&&(I.textContent=Hs),gs=n(s),m(z.$$.fragment,s),hs=n(s),m(W.$$.fragment,s),js=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1lbavmm"&&(E.textContent=Ns),fs=n(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-s5sfsz"&&(B.innerHTML=Ys),us=n(s),m(H.$$.fragment,s),bs=n(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-vbbgku"&&(N.textContent=Fs),Ms=n(s),m(Y.$$.fragment,s),ys=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1kfxibh"&&(b.innerHTML=Qs),ds=n(s),F=i(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-h1u4we"&&(F.textContent=Vs),xs=n(s),m(Q.$$.fragment,s),ws=n(s),V=i(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1mekvsu"&&(V.textContent=qs),Js=n(s),m(q.$$.fragment,s),Us=n(s),S=i(s,"P",{}),Xs(S).forEach(l),this.h()},h(){$s(f,"name","hf:doc:metadata"),$s(f,"content",lt),$s(u,"class","flex justify-center"),$s(b,"class","flex justify-center")},m(s,t){Os(document.head,f),a(s,A,t),a(s,X,t),a(s,P,t),r(y,s,t),a(s,D,t),r(d,s,t),a(s,L,t),a(s,x,t),a(s,K,t),a(s,w,t),a(s,O,t),a(s,J,t),a(s,ss,t),a(s,U,t),a(s,ts,t),a(s,T,t),a(s,ls,t),a(s,$,t),a(s,as,t),a(s,C,t),a(s,es,t),r(v,s,t),a(s,ns,t),r(Z,s,t),a(s,ps,t),a(s,k,t),a(s,is,t),r(R,s,t),a(s,os,t),a(s,_,t),a(s,cs,t),r(G,s,t),a(s,ms,t),a(s,u,t),a(s,rs,t),a(s,I,t),a(s,gs,t),r(z,s,t),a(s,hs,t),r(W,s,t),a(s,js,t),a(s,E,t),a(s,fs,t),a(s,B,t),a(s,us,t),r(H,s,t),a(s,bs,t),a(s,N,t),a(s,Ms,t),r(Y,s,t),a(s,ys,t),a(s,b,t),a(s,ds,t),a(s,F,t),a(s,xs,t),r(Q,s,t),a(s,ws,t),a(s,V,t),a(s,Js,t),r(q,s,t),a(s,Us,t),a(s,S,t),Ts=!0},p:As,i(s){Ts||(g(y.$$.fragment,s),g(d.$$.fragment,s),g(v.$$.fragment,s),g(Z.$$.fragment,s),g(R.$$.fragment,s),g(G.$$.fragment,s),g(z.$$.fragment,s),g(W.$$.fragment,s),g(H.$$.fragment,s),g(Y.$$.fragment,s),g(Q.$$.fragment,s),g(q.$$.fragment,s),Ts=!0)},o(s){h(y.$$.fragment,s),h(d.$$.fragment,s),h(v.$$.fragment,s),h(Z.$$.fragment,s),h(R.$$.fragment,s),h(G.$$.fragment,s),h(z.$$.fragment,s),h(W.$$.fragment,s),h(H.$$.fragment,s),h(Y.$$.fragment,s),h(Q.$$.fragment,s),h(q.$$.fragment,s),Ts=!1},d(s){s&&(l(A),l(X),l(P),l(D),l(L),l(x),l(K),l(w),l(O),l(J),l(ss),l(U),l(ts),l(T),l(ls),l($),l(as),l(C),l(es),l(ns),l(ps),l(k),l(is),l(os),l(_),l(cs),l(ms),l(u),l(rs),l(I),l(gs),l(hs),l(js),l(E),l(fs),l(B),l(us),l(bs),l(N),l(Ms),l(ys),l(b),l(ds),l(F),l(xs),l(ws),l(V),l(Js),l(Us),l(S)),l(f),j(y,s),j(d,s),j(v,s),j(Z,s),j(R,s),j(G,s),j(z,s),j(W,s),j(H,s),j(Y,s),j(Q,s),j(q,s)}}}const lt='{"title":"Zero-shot image classification","local":"zero-shot-image-classification","sections":[{"title":"Zero-shot image classification pipeline","local":"zero-shot-image-classification-pipeline","sections":[],"depth":2},{"title":"Zero-shot image classification by hand","local":"zero-shot-image-classification-by-hand","sections":[],"depth":2}],"depth":1}';function at(vs){return Ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends Ds{constructor(f){super(),Ls(this,f,at,tt,Ss,{})}}export{ct as component};
