import{s as Xn,f as Yn,n as eo,o as to}from"../chunks/scheduler.d627b047.js";import{S as ao,i as no,g as i,s as o,r as m,m as pt,H as Zn,A as oo,h as s,f as a,c as r,j as T,u as c,x as d,n as mt,B as Sn,k as v,y as l,a as n,v as g,d as h,t as f,w as u}from"../chunks/index.73c51727.js";import{D as w}from"../chunks/Docstring.488b7ad2.js";import{C as Xa}from"../chunks/CodeBlock.b1cdc5f6.js";import{H as x,E as ro}from"../chunks/EditOnGithub.859b9ebc.js";function lo(Ya){let L,ht,ct,ft,U,ut,E,en='<a href="https://huggingface.co/models?other=kto,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-KTO-blue"/></a>',_t,J,vt,W,tn='Kahneman-Tversky Optimization (KTO) was introduced in <a href="https://huggingface.co/papers/2402.01306" rel="nofollow">KTO: Model Alignment as Prospect Theoretic Optimization</a> by <a href="https://huggingface.co/kawine" rel="nofollow">Kawin Ethayarajh</a>, <a href="https://huggingface.co/xwinxu" rel="nofollow">Winnie Xu</a>, <a href="https://huggingface.co/Muennighoff" rel="nofollow">Niklas Muennighoff</a>, Dan Jurafsky, <a href="https://huggingface.co/douwekiela" rel="nofollow">Douwe Kiela</a>.',bt,B,an="The abstract from the paper is the following:",Tt,A,nn="<p>Kahneman &amp; Tversky’s prospect theory tells us that humans perceive random variables in a biased but well-defined manner; for example, humans are famously loss-averse. We show that objectives for aligning LLMs with human feedback implicitly incorporate many of these biases — the success of these objectives (e.g., DPO) over cross-entropy minimization can partly be ascribed to them being human-aware loss functions (HALOs). However, the utility functions these methods attribute to humans still differ from those in the prospect theory literature. Using a Kahneman-Tversky model of human utility, we propose a HALO that directly maximizes the utility of generations instead of maximizing the log-likelihood of preferences, as current methods do. We call this approach Kahneman-Tversky Optimization (KTO), and it matches or exceeds the performance of preference-based methods at scales from 1B to 30B. Crucially, KTO does not need preferences — only a binary signal of whether an output is desirable or undesirable for a given input. This makes it far easier to use in the real world, where preference data is scarce and expensive.</p>",yt,D,on='The official code can be found in <a href="https://github.com/ContextualAI/HALOs" rel="nofollow">ContextualAI/HALOs</a>.',wt,q,rn='This post-training method was contributed by <a href="https://huggingface.co/kashif" rel="nofollow">Kashif Rasul</a>, <a href="https://huggingface.co/ybelkada" rel="nofollow">Younes Belkada</a>, <a href="https://huggingface.co/lewtun" rel="nofollow">Lewis Tunstall</a> and Pablo Vicente.',xt,R,$t,V,ln='This example demonstrates how to train a model using the KTO method. We use the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen 0.5B model</a> as the base model. We use the preference data from the <a href="https://huggingface.co/datasets/trl-lib/kto-mix-14k" rel="nofollow">KTO Mix 14k</a>. You can view the data in the dataset here:',Ot,O,sn,kt,Z,dn="Below is the script to train the model:",Mt,S,Ct,Q,pn="Execute the script using the following command:",Lt,G,Kt,X,mn="Distributed across 8 x H100 GPUs, the training takes approximately 30 minutes. You can verify the training progress by checking the reward graph. An increasing trend in the reward margin indicates that the model is improving and generating better responses over time.",Nt,Y,cn='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/kto-qwen2-reward-margin.png"/>',jt,ee,gn='To see how the <a href="https://huggingface.co/trl-lib/Qwen2-0.5B-KTO" rel="nofollow">trained model</a> performs, you can use the <a href="clis#chat-interface">TRL Chat CLI</a>.',Ft,te,hn=`<code>$ trl chat --model_name_or_path trl-lib/Qwen2-0.5B-KTO
<strong><span style="color: red;">&lt;quentin_gallouedec&gt;:</span></strong>
What is the best programming language?

<strong><span style="color: blue;">&lt;trl-lib/Qwen2-0.5B-KTO&gt;:</span></strong>
The best programming language can vary depending on individual preferences, industry-specific requirements, technical skills, and familiarity with the specific use case or task. Here are some widely-used programming languages that have been noted as popular and widely used:                                                                                  

Here are some other factors to consider when choosing a programming language for a project:

 <strong><span style="color: green;">1</span> JavaScript</strong>: JavaScript is at the heart of the web and can be used for building web applications, APIs, and interactive front-end applications like frameworks like React and Angular. It&#39;s similar to C, C++, and F# in syntax structure and is accessible and easy to learn, making it a popular choice for beginners and professionals alike.                                                                   
 <strong><span style="color: green;">2</span> Java</strong>: Known for its object-oriented programming (OOP) and support for Java 8 and .NET, Java is used for developing enterprise-level software applications, high-performance games, as well as mobile apps, game development, and desktop applications.                                                                                                                                                            
 <strong><span style="color: green;">3</span> C++</strong>: Known for its flexibility and scalability, C++ offers comprehensive object-oriented programming and is a popular choice for high-performance computing and other technical fields. It&#39;s a powerful platform for building real-world applications and games at scale.                                                                                                                                         
 <strong><span style="color: green;">4</span> Python</strong>: Developed by Guido van Rossum in 1991, Python is a high-level, interpreted, and dynamically typed language known for its simplicity, readability, and versatility.   
</code>`,Ht,ae,Pt,ne,fn='KTO requires an <a href="dataset_formats#unpaired-preference">unpaired preference dataset</a>. Alternatively, you can provide a <em>paired</em> preference dataset (also known simply as a <em>preference dataset</em>). In this case, the trainer will automatically convert it to an unpaired format by separating the chosen and rejected responses, assigning <code>label = True</code> to the chosen completions and <code>label = False</code> to the rejected ones.',It,oe,un='The <a href="/docs/trl/main/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a> supports both <a href="dataset_formats#conversational">conversational</a> and <a href="dataset_formats#standard">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.',zt,re,_n="In theory, the dataset should contain at least one chosen and one rejected completion. However, some users have successfully run KTO using <em>only</em> chosen or only rejected data. If using only rejected data, it is advisable to adopt a conservative learning rate.",Ut,le,Et,ie,vn='We provide an example script to train a model using the KTO method. The script is available in <a href="https://github.com/huggingface/trl/blob/main/trl/scripts/kto.py" rel="nofollow"><code>trl/scripts/kto.py</code></a>',Jt,se,bn='To test the KTO script with the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen2 0.5B model</a> on the <a href="https://huggingface.co/datasets/trl-lib/kto-mix-14k" rel="nofollow">UltraFeedback dataset</a>, run the following command:',Wt,de,Bt,pe,At,me,Dt,ce,Tn=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,qt,ge,yn=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. <a href="https://huggingface.co/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralConfig" rel="nofollow">MixtralConfig</a>).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: <code>0.001</code>) in the model config.`,Rt,he,Vt,fe,wn="Use a per-step batch size that is at least 4, and an effective batch size between 16 and 128. Even if your effective batch size is large, if your per-step batch size is poor, then the KL estimate in KTO will be poor.",Zt,ue,St,_e,xn="Each choice of <code>beta</code> has a maximum learning rate it can tolerate before learning performance degrades. For the default setting of <code>beta = 0.1</code>, the learning rate should typically not exceed <code>1e-6</code> for most models. As <code>beta</code> decreases, the learning rate should also be reduced accordingly. In general, we strongly recommend keeping the learning rate between <code>5e-7</code> and <code>5e-6</code>. Even with small datasets, we advise against using a learning rate outside this range. Instead, opt for more epochs to achieve better results.",Qt,ve,Gt,b,Ta,Ee,$n="desirable_weight",ya,Je,On="undesirable_weight",wa,be,kn="KTOConfig",xa,We,Mn="desirable_weight",Xt,Qn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo>×</mo></mrow><annotation encoding="application/x-tex">\\times</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6667em;vertical-align:-0.0833em;"></span><span class="mord">×</span></span></span></span>',Yt,Be,Cn="undesirable_weight",ea,Gn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo>×</mo></mrow><annotation encoding="application/x-tex">\\times</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6667em;vertical-align:-0.0833em;"></span><span class="mord">×</span></span></span></span>',ta,aa,Te,na,ye,Ln="While training and evaluating we record the following reward metrics:",oa,we,Kn="<li><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li> <li><code>logps/chosen</code>: the mean log probabilities of the chosen completions</li> <li><code>logps/rejected</code>: the mean log probabilities of the rejected completions</li> <li><code>logits/chosen</code>: the mean logits of the chosen completions</li> <li><code>logits/rejected</code>: the mean logits of the rejected completions</li> <li><code>kl</code>: the KL divergence between the policy model and the reference model</li>",ra,xe,la,p,$e,$a,Ae,Nn="Initialize KTOTrainer.",Oa,K,Oe,ka,De,jn="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",Ma,N,ke,Ca,qe,Fn="Creates a draft of a model card using the information available to the <code>Trainer</code>.",La,k,Me,Ka,Re,Hn=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Na,Ve,Pn="Works both with or without labels.",ja,j,Ce,Fa,Ze,In="Generate samples from the model and reference model for the given batch of inputs.",Ha,F,Le,Pa,Se,zn="Compute the log probabilities of the given labels under the given logits.",Ia,H,Ke,za,Qe,Un="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",Ua,M,Ne,Ea,Ge,En="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Ja,Xe,Jn="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Wa,C,je,Ba,Ye,Wn="Returns the training <code>~torch.utils.data.DataLoader</code>.",Aa,et,Bn="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Da,P,Fe,qa,tt,An="Compute the KTO loss for a batch of policy and reference model log probabilities.",Ra,I,He,Va,at,Dn="Log <code>logs</code> on the various objects watching training, including stored metrics.",Za,z,Pe,Sa,nt,qn="Context manager for handling null reference model (that is, peft adapter manipulation).",ia,Ie,sa,$,ze,Qa,ot,Rn='Configuration class for the <a href="/docs/trl/main/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a>.',Ga,rt,Vn=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,da,Ue,pa,gt,ma;return U=new x({props:{title:"KTO Trainer",local:"kto-trainer",headingTag:"h1"}}),J=new x({props:{title:"Overview",local:"overview",headingTag:"h2"}}),R=new x({props:{title:"Quick start",local:"quick-start",headingTag:"h2"}}),S=new Xa({props:{code:"JTIzJTIwdHJhaW5fa3RvLnB5JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMEtUT0NvbmZpZyUyQyUyMEtUT1RyYWluZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGa3RvLW1peC0xNGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBLVE9Db25maWcob3V0cHV0X2RpciUzRCUyMlF3ZW4yLTAuNUItS1RPJTIyJTJDJTIwbG9nZ2luZ19zdGVwcyUzRDEwKSUwQXRyYWluZXIlMjAlM0QlMjBLVE9UcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># train_kto.py</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> KTOConfig, KTOTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
train_dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/kto-mix-14k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = KTOConfig(output_dir=<span class="hljs-string">&quot;Qwen2-0.5B-KTO&quot;</span>, logging_steps=<span class="hljs-number">10</span>)
trainer = KTOTrainer(model=model, args=training_args, processing_class=tokenizer, train_dataset=train_dataset)
trainer.train()`,wrap:!1}}),G=new Xa({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2t0by5weQ==",highlighted:"accelerate launch train_kto.py",wrap:!1}}),ae=new x({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),le=new x({props:{title:"Example script",local:"example-script",headingTag:"h2"}}),de=new Xa({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRybCUyRnNjcmlwdHMlMkZrdG8ucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1vZGVsX25hbWVfb3JfcGF0aCUyMFF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjB0cmwtbGliJTJGa3RvLW1peC0xNGslMjAlNUMlMEElMjAlMjAlMjAlMjAtLW51bV90cmFpbl9lcG9jaHMlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sb2dnaW5nX3N0ZXBzJTIwMjUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlMjBRd2VuMi0wLjVCLUtUTw==",highlighted:`accelerate launch trl/scripts/kto.py \\
    --model_name_or_path Qwen/Qwen2-0.5B-Instruct \\
    --dataset_name trl-lib/kto-mix-14k \\
    --num_train_epochs 1 \\
    --logging_steps 25 \\
    --output_dir Qwen2-0.5B-KTO`,wrap:!1}}),pe=new x({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),me=new x({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),he=new x({props:{title:"Batch size recommendations",local:"batch-size-recommendations",headingTag:"h3"}}),ue=new x({props:{title:"Learning rate recommendations",local:"learning-rate-recommendations",headingTag:"h3"}}),ve=new x({props:{title:"Imbalanced data",local:"imbalanced-data",headingTag:"h3"}}),Te=new x({props:{title:"Logged metrics",local:"logged-metrics",headingTag:"h2"}}),xe=new x({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),$e=new w({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"processing_class",val:": typing.Union[transformers.tokenization_utils_base.PreTrainedTokenizerBase, transformers.image_processing_utils.BaseImageProcessor, transformers.feature_extraction_utils.FeatureExtractionMixin, transformers.processing_utils.ProcessorMixin, NoneType] = None"},{name:"data_collator",val:": typing.Optional[transformers.data.data_collator.DataCollator] = None"},{name:"model_init",val:": typing.Optional[typing.Callable[[], transformers.modeling_utils.PreTrainedModel]] = None"},{name:"callbacks",val:": typing.Optional[list[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Optional[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor]] = None"},{name:"peft_config",val:": typing.Optional[dict] = None"},{name:"compute_metrics",val:": typing.Optional[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], dict]] = None"},{name:"model_adapter_name",val:": typing.Optional[str] = None"},{name:"ref_adapter_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.`,name:"processing_class"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>list[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.KTOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.KTOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L277"}}),Oe=new w({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L918"}}),ke=new w({props:{name:"create_model_card",anchor:"trl.KTOTrainer.create_model_card",parameters:[{name:"model_name",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"tags",val:": typing.Union[str, list[str], NoneType] = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the model.`,name:"model_name"},{anchor:"trl.KTOTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.KTOTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>list[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1482"}}),Me=new w({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[list[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1386"}}),Ce=new w({props:{name:"generate_from_model_and_ref",anchor:"trl.KTOTrainer.generate_from_model_and_ref",parameters:[{name:"model",val:""},{name:"batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1304"}}),Le=new w({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_batch_logps.logits",description:"<strong>logits</strong> &#x2014; Logits of the model (unnormalized). Shape: (batch_size, sequence_length, vocab_size)",name:"logits"},{anchor:"trl.KTOTrainer.get_batch_logps.labels",description:"<strong>labels</strong> &#x2014; Labels for which to compute the log probabilities. Label tokens with a value of label_pad_token_id are ignored. Shape: (batch_size, sequence_length)",name:"labels"},{anchor:"trl.KTOTrainer.get_batch_logps.average_log_prob",description:"<strong>average_log_prob</strong> &#x2014; If True, return the average log probability per (non-masked) token. Otherwise, return the sum of the log probabilities of the (non-masked) tokens.",name:"average_log_prob"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L997",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Ke=new w({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1188"}}),Ne=new w({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L863"}}),je=new w({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L819"}}),Fe=new w({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.KTOTrainer.kto_loss.policy_chosen_logps",description:"<strong>policy_chosen_logps</strong> &#x2014; Log probabilities of the policy model for the chosen responses. Shape: (num(chosen) in batch_size,)",name:"policy_chosen_logps"},{anchor:"trl.KTOTrainer.kto_loss.policy_rejected_logps",description:"<strong>policy_rejected_logps</strong> &#x2014; Log probabilities of the policy model for the rejected responses. Shape: (num(rejected) in batch_size,)",name:"policy_rejected_logps"},{anchor:"trl.KTOTrainer.kto_loss.policy_KL_logps",description:"<strong>policy_KL_logps</strong> &#x2014; Log probabilities of the policy model for the KL responses. Shape: (batch_size,)",name:"policy_KL_logps"},{anchor:"trl.KTOTrainer.kto_loss.reference_chosen_logps",description:"<strong>reference_chosen_logps</strong> &#x2014; Log probabilities of the reference model for the chosen responses. Shape: (num(chosen) in batch_size,)",name:"reference_chosen_logps"},{anchor:"trl.KTOTrainer.kto_loss.reference_rejected_logps",description:"<strong>reference_rejected_logps</strong> &#x2014; Log probabilities of the reference model for the rejected responses. Shape: (num(rejected) in batch_size,)",name:"reference_rejected_logps"},{anchor:"trl.KTOTrainer.kto_loss.reference_KL_logps",description:"<strong>reference_KL_logps</strong> &#x2014; Log probabilities of the reference model for the KL responses. Shape: (batch_size,)",name:"reference_KL_logps"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1116",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),He=new w({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": dict"},{name:"start_time",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"},{anchor:"trl.KTOTrainer.log.start_time",description:`<strong>start_time</strong> (<code>float</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Start time of the training.`,name:"start_time"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1443"}}),Pe=new w({props:{name:"null_ref_context",anchor:"trl.KTOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L807"}}),Ie=new x({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),ze=new w({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict, str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.SaveStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": typing.Optional[bool] = None"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict, str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": typing.List[str] = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = None"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"split_batches",val:": typing.Optional[bool] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = False"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_completion_length",val:": typing.Optional[int] = None"},{name:"beta",val:": float = 0.1"},{name:"loss_type",val:": typing.Literal['kto', 'apo_zero_unpaired'] = 'kto'"},{name:"desirable_weight",val:": float = 1.0"},{name:"undesirable_weight",val:": float = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": typing.Optional[int] = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"ref_model_init_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"trl.KTOConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>5e-7</code>) &#x2014;
Initial learning rate for <code>AdamW</code> optimizer. The default value replaces that of
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,name:"learning_rate"},{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the completion. This argument is required if you want to use the default data collator
and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model.`,name:"beta"},{anchor:"trl.KTOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;kto&quot;</code>) &#x2014;
Type of loss to use. Possible values are:</p>
<ul>
<li><code>&quot;kto&quot;</code>: KTO loss from the <a href="https://huggingface.co/papers/2402.01306" rel="nofollow">KTO</a> paper.</li>
<li><code>&quot;apo_zero_unpaired&quot;</code>: Unpaired variant of APO-zero loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, generates and logs completions from both the model and the reference model to W&amp;B or Comet during
evaluation.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to precompute reference model log probabilities for training and evaluation datasets. This is
useful when training without the reference model to reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.KTOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.KTOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the reference model
from a string.`,name:"ref_model_init_kwargs"},{anchor:"trl.KTOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> &#x2014; (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"},{anchor:"trl.KTOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable dropout in the model and reference model.`,name:"disable_dropout"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_config.py#L21"}}),Ue=new ro({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/kto_trainer.mdx"}}),{c(){L=i("meta"),ht=o(),ct=i("p"),ft=o(),m(U.$$.fragment),ut=o(),E=i("p"),E.innerHTML=en,_t=o(),m(J.$$.fragment),vt=o(),W=i("p"),W.innerHTML=tn,bt=o(),B=i("p"),B.textContent=an,Tt=o(),A=i("blockquote"),A.innerHTML=nn,yt=o(),D=i("p"),D.innerHTML=on,wt=o(),q=i("p"),q.innerHTML=rn,xt=o(),m(R.$$.fragment),$t=o(),V=i("p"),V.innerHTML=ln,Ot=o(),O=i("iframe"),kt=o(),Z=i("p"),Z.textContent=dn,Mt=o(),m(S.$$.fragment),Ct=o(),Q=i("p"),Q.textContent=pn,Lt=o(),m(G.$$.fragment),Kt=o(),X=i("p"),X.textContent=mn,Nt=o(),Y=i("p"),Y.innerHTML=cn,jt=o(),ee=i("p"),ee.innerHTML=gn,Ft=o(),te=i("pre"),te.innerHTML=hn,Ht=o(),m(ae.$$.fragment),Pt=o(),ne=i("p"),ne.innerHTML=fn,It=o(),oe=i("p"),oe.innerHTML=un,zt=o(),re=i("p"),re.innerHTML=_n,Ut=o(),m(le.$$.fragment),Et=o(),ie=i("p"),ie.innerHTML=vn,Jt=o(),se=i("p"),se.innerHTML=bn,Wt=o(),m(de.$$.fragment),Bt=o(),m(pe.$$.fragment),At=o(),m(me.$$.fragment),Dt=o(),ce=i("p"),ce.innerHTML=Tn,qt=o(),ge=i("p"),ge.innerHTML=yn,Rt=o(),m(he.$$.fragment),Vt=o(),fe=i("p"),fe.textContent=wn,Zt=o(),m(ue.$$.fragment),St=o(),_e=i("p"),_e.innerHTML=xn,Qt=o(),m(ve.$$.fragment),Gt=o(),b=i("p"),Ta=pt("The "),Ee=i("code"),Ee.textContent=$n,ya=pt(" and "),Je=i("code"),Je.textContent=On,wa=pt(" of the "),be=i("a"),be.textContent=kn,xa=pt(` refer to the weights placed on the losses for desirable/positive and undesirable/negative examples.
By default, they are both 1. However, if you have more of one or the other, then you should upweight the less common type such that the ratio of (`),We=i("code"),We.textContent=Mn,Xt=new Zn(!1),Yt=pt(" number of positives) to ("),Be=i("code"),Be.textContent=Cn,ea=new Zn(!1),ta=pt(" number of negatives) is in the range 1:1 to 4:3."),aa=o(),m(Te.$$.fragment),na=o(),ye=i("p"),ye.textContent=Ln,oa=o(),we=i("ul"),we.innerHTML=Kn,ra=o(),m(xe.$$.fragment),la=o(),p=i("div"),m($e.$$.fragment),$a=o(),Ae=i("p"),Ae.textContent=Nn,Oa=o(),K=i("div"),m(Oe.$$.fragment),ka=o(),De=i("p"),De.textContent=jn,Ma=o(),N=i("div"),m(ke.$$.fragment),Ca=o(),qe=i("p"),qe.innerHTML=Fn,La=o(),k=i("div"),m(Me.$$.fragment),Ka=o(),Re=i("p"),Re.innerHTML=Hn,Na=o(),Ve=i("p"),Ve.textContent=Pn,ja=o(),j=i("div"),m(Ce.$$.fragment),Fa=o(),Ze=i("p"),Ze.textContent=In,Ha=o(),F=i("div"),m(Le.$$.fragment),Pa=o(),Se=i("p"),Se.textContent=zn,Ia=o(),H=i("div"),m(Ke.$$.fragment),za=o(),Qe=i("p"),Qe.textContent=Un,Ua=o(),M=i("div"),m(Ne.$$.fragment),Ea=o(),Ge=i("p"),Ge.innerHTML=En,Ja=o(),Xe=i("p"),Xe.innerHTML=Jn,Wa=o(),C=i("div"),m(je.$$.fragment),Ba=o(),Ye=i("p"),Ye.innerHTML=Wn,Aa=o(),et=i("p"),et.innerHTML=Bn,Da=o(),P=i("div"),m(Fe.$$.fragment),qa=o(),tt=i("p"),tt.textContent=An,Ra=o(),I=i("div"),m(He.$$.fragment),Va=o(),at=i("p"),at.innerHTML=Dn,Za=o(),z=i("div"),m(Pe.$$.fragment),Sa=o(),nt=i("p"),nt.textContent=qn,ia=o(),m(Ie.$$.fragment),sa=o(),$=i("div"),m(ze.$$.fragment),Qa=o(),ot=i("p"),ot.innerHTML=Rn,Ga=o(),rt=i("p"),rt.innerHTML=Vn,da=o(),m(Ue.$$.fragment),pa=o(),gt=i("p"),this.h()},l(e){const t=oo("svelte-u9bgzb",document.head);L=s(t,"META",{name:!0,content:!0}),t.forEach(a),ht=r(e),ct=s(e,"P",{}),T(ct).forEach(a),ft=r(e),c(U.$$.fragment,e),ut=r(e),E=s(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1pjg7ok"&&(E.innerHTML=en),_t=r(e),c(J.$$.fragment,e),vt=r(e),W=s(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1ad6dt3"&&(W.innerHTML=tn),bt=r(e),B=s(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-vfdo9a"&&(B.textContent=an),Tt=r(e),A=s(e,"BLOCKQUOTE",{"data-svelte-h":!0}),d(A)!=="svelte-1nbtzvm"&&(A.innerHTML=nn),yt=r(e),D=s(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-crl8e"&&(D.innerHTML=on),wt=r(e),q=s(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1u5zm0"&&(q.innerHTML=rn),xt=r(e),c(R.$$.fragment,e),$t=r(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-gsvz84"&&(V.innerHTML=ln),Ot=r(e),O=s(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),T(O).forEach(a),kt=r(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-uqytq6"&&(Z.textContent=dn),Mt=r(e),c(S.$$.fragment,e),Ct=r(e),Q=s(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-15hino8"&&(Q.textContent=pn),Lt=r(e),c(G.$$.fragment,e),Kt=r(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1396wsd"&&(X.textContent=mn),Nt=r(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1uxw1l0"&&(Y.innerHTML=cn),jt=r(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-ucm2bp"&&(ee.innerHTML=gn),Ft=r(e),te=s(e,"PRE",{"data-svelte-h":!0}),d(te)!=="svelte-81578k"&&(te.innerHTML=hn),Ht=r(e),c(ae.$$.fragment,e),Pt=r(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-16phm6w"&&(ne.innerHTML=fn),It=r(e),oe=s(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1uojo9i"&&(oe.innerHTML=un),zt=r(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-4iifkd"&&(re.innerHTML=_n),Ut=r(e),c(le.$$.fragment,e),Et=r(e),ie=s(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1cezwm0"&&(ie.innerHTML=vn),Jt=r(e),se=s(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-nsomyf"&&(se.innerHTML=bn),Wt=r(e),c(de.$$.fragment,e),Bt=r(e),c(pe.$$.fragment,e),At=r(e),c(me.$$.fragment,e),Dt=r(e),ce=s(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-14px1ga"&&(ce.innerHTML=Tn),qt=r(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-11it1aj"&&(ge.innerHTML=yn),Rt=r(e),c(he.$$.fragment,e),Vt=r(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-z34k5y"&&(fe.textContent=wn),Zt=r(e),c(ue.$$.fragment,e),St=r(e),_e=s(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1gf2zn8"&&(_e.innerHTML=xn),Qt=r(e),c(ve.$$.fragment,e),Gt=r(e),b=s(e,"P",{});var y=T(b);Ta=mt(y,"The "),Ee=s(y,"CODE",{"data-svelte-h":!0}),d(Ee)!=="svelte-1s37gb0"&&(Ee.textContent=$n),ya=mt(y," and "),Je=s(y,"CODE",{"data-svelte-h":!0}),d(Je)!=="svelte-ddv9an"&&(Je.textContent=On),wa=mt(y," of the "),be=s(y,"A",{href:!0,"data-svelte-h":!0}),d(be)!=="svelte-1wmuc8j"&&(be.textContent=kn),xa=mt(y,` refer to the weights placed on the losses for desirable/positive and undesirable/negative examples.
By default, they are both 1. However, if you have more of one or the other, then you should upweight the less common type such that the ratio of (`),We=s(y,"CODE",{"data-svelte-h":!0}),d(We)!=="svelte-1s37gb0"&&(We.textContent=Mn),Xt=Sn(y,!1),Yt=mt(y," number of positives) to ("),Be=s(y,"CODE",{"data-svelte-h":!0}),d(Be)!=="svelte-ddv9an"&&(Be.textContent=Cn),ea=Sn(y,!1),ta=mt(y," number of negatives) is in the range 1:1 to 4:3."),y.forEach(a),aa=r(e),c(Te.$$.fragment,e),na=r(e),ye=s(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-132s7j9"&&(ye.textContent=Ln),oa=r(e),we=s(e,"UL",{"data-svelte-h":!0}),d(we)!=="svelte-1tas4fp"&&(we.innerHTML=Kn),ra=r(e),c(xe.$$.fragment,e),la=r(e),p=s(e,"DIV",{class:!0});var _=T(p);c($e.$$.fragment,_),$a=r(_),Ae=s(_,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-hyhzxp"&&(Ae.textContent=Nn),Oa=r(_),K=s(_,"DIV",{class:!0});var ca=T(K);c(Oe.$$.fragment,ca),ka=r(ca),De=s(ca,"P",{"data-svelte-h":!0}),d(De)!=="svelte-pt6g01"&&(De.textContent=jn),ca.forEach(a),Ma=r(_),N=s(_,"DIV",{class:!0});var ga=T(N);c(ke.$$.fragment,ga),Ca=r(ga),qe=s(ga,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1mh859w"&&(qe.innerHTML=Fn),ga.forEach(a),La=r(_),k=s(_,"DIV",{class:!0});var lt=T(k);c(Me.$$.fragment,lt),Ka=r(lt),Re=s(lt,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-8qlty5"&&(Re.innerHTML=Hn),Na=r(lt),Ve=s(lt,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1tyo99t"&&(Ve.textContent=Pn),lt.forEach(a),ja=r(_),j=s(_,"DIV",{class:!0});var ha=T(j);c(Ce.$$.fragment,ha),Fa=r(ha),Ze=s(ha,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-18uwvbi"&&(Ze.textContent=In),ha.forEach(a),Ha=r(_),F=s(_,"DIV",{class:!0});var fa=T(F);c(Le.$$.fragment,fa),Pa=r(fa),Se=s(fa,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-4nmimv"&&(Se.textContent=zn),fa.forEach(a),Ia=r(_),H=s(_,"DIV",{class:!0});var ua=T(H);c(Ke.$$.fragment,ua),za=r(ua),Qe=s(ua,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-db7iek"&&(Qe.textContent=Un),ua.forEach(a),Ua=r(_),M=s(_,"DIV",{class:!0});var it=T(M);c(Ne.$$.fragment,it),Ea=r(it),Ge=s(it,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-xesobz"&&(Ge.innerHTML=En),Ja=r(it),Xe=s(it,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-qg43tm"&&(Xe.innerHTML=Jn),it.forEach(a),Wa=r(_),C=s(_,"DIV",{class:!0});var st=T(C);c(je.$$.fragment,st),Ba=r(st),Ye=s(st,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-dkae9b"&&(Ye.innerHTML=Wn),Aa=r(st),et=s(st,"P",{"data-svelte-h":!0}),d(et)!=="svelte-hmd5cw"&&(et.innerHTML=Bn),st.forEach(a),Da=r(_),P=s(_,"DIV",{class:!0});var _a=T(P);c(Fe.$$.fragment,_a),qa=r(_a),tt=s(_a,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-svckwe"&&(tt.textContent=An),_a.forEach(a),Ra=r(_),I=s(_,"DIV",{class:!0});var va=T(I);c(He.$$.fragment,va),Va=r(va),at=s(va,"P",{"data-svelte-h":!0}),d(at)!=="svelte-nqksfz"&&(at.innerHTML=Dn),va.forEach(a),Za=r(_),z=s(_,"DIV",{class:!0});var ba=T(z);c(Pe.$$.fragment,ba),Sa=r(ba),nt=s(ba,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-17kjsy4"&&(nt.textContent=qn),ba.forEach(a),_.forEach(a),ia=r(e),c(Ie.$$.fragment,e),sa=r(e),$=s(e,"DIV",{class:!0});var dt=T($);c(ze.$$.fragment,dt),Qa=r(dt),ot=s(dt,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-rh8hda"&&(ot.innerHTML=Rn),Ga=r(dt),rt=s(dt,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-ekuf1t"&&(rt.innerHTML=Vn),dt.forEach(a),da=r(e),c(Ue.$$.fragment,e),pa=r(e),gt=s(e,"P",{}),T(gt).forEach(a),this.h()},h(){v(L,"name","hf:doc:metadata"),v(L,"content",io),Yn(O.src,sn="https://huggingface.co/datasets/trl-lib/kto-mix-14k/embed/viewer/default/train?row=0")||v(O,"src",sn),v(O,"frameborder","0"),v(O,"width","100%"),v(O,"height","560px"),v(be,"href","/docs/trl/main/en/kto_trainer#trl.KTOConfig"),Xt.a=Yt,ea.a=ta,v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,L),n(e,ht,t),n(e,ct,t),n(e,ft,t),g(U,e,t),n(e,ut,t),n(e,E,t),n(e,_t,t),g(J,e,t),n(e,vt,t),n(e,W,t),n(e,bt,t),n(e,B,t),n(e,Tt,t),n(e,A,t),n(e,yt,t),n(e,D,t),n(e,wt,t),n(e,q,t),n(e,xt,t),g(R,e,t),n(e,$t,t),n(e,V,t),n(e,Ot,t),n(e,O,t),n(e,kt,t),n(e,Z,t),n(e,Mt,t),g(S,e,t),n(e,Ct,t),n(e,Q,t),n(e,Lt,t),g(G,e,t),n(e,Kt,t),n(e,X,t),n(e,Nt,t),n(e,Y,t),n(e,jt,t),n(e,ee,t),n(e,Ft,t),n(e,te,t),n(e,Ht,t),g(ae,e,t),n(e,Pt,t),n(e,ne,t),n(e,It,t),n(e,oe,t),n(e,zt,t),n(e,re,t),n(e,Ut,t),g(le,e,t),n(e,Et,t),n(e,ie,t),n(e,Jt,t),n(e,se,t),n(e,Wt,t),g(de,e,t),n(e,Bt,t),g(pe,e,t),n(e,At,t),g(me,e,t),n(e,Dt,t),n(e,ce,t),n(e,qt,t),n(e,ge,t),n(e,Rt,t),g(he,e,t),n(e,Vt,t),n(e,fe,t),n(e,Zt,t),g(ue,e,t),n(e,St,t),n(e,_e,t),n(e,Qt,t),g(ve,e,t),n(e,Gt,t),n(e,b,t),l(b,Ta),l(b,Ee),l(b,ya),l(b,Je),l(b,wa),l(b,be),l(b,xa),l(b,We),Xt.m(Qn,b),l(b,Yt),l(b,Be),ea.m(Gn,b),l(b,ta),n(e,aa,t),g(Te,e,t),n(e,na,t),n(e,ye,t),n(e,oa,t),n(e,we,t),n(e,ra,t),g(xe,e,t),n(e,la,t),n(e,p,t),g($e,p,null),l(p,$a),l(p,Ae),l(p,Oa),l(p,K),g(Oe,K,null),l(K,ka),l(K,De),l(p,Ma),l(p,N),g(ke,N,null),l(N,Ca),l(N,qe),l(p,La),l(p,k),g(Me,k,null),l(k,Ka),l(k,Re),l(k,Na),l(k,Ve),l(p,ja),l(p,j),g(Ce,j,null),l(j,Fa),l(j,Ze),l(p,Ha),l(p,F),g(Le,F,null),l(F,Pa),l(F,Se),l(p,Ia),l(p,H),g(Ke,H,null),l(H,za),l(H,Qe),l(p,Ua),l(p,M),g(Ne,M,null),l(M,Ea),l(M,Ge),l(M,Ja),l(M,Xe),l(p,Wa),l(p,C),g(je,C,null),l(C,Ba),l(C,Ye),l(C,Aa),l(C,et),l(p,Da),l(p,P),g(Fe,P,null),l(P,qa),l(P,tt),l(p,Ra),l(p,I),g(He,I,null),l(I,Va),l(I,at),l(p,Za),l(p,z),g(Pe,z,null),l(z,Sa),l(z,nt),n(e,ia,t),g(Ie,e,t),n(e,sa,t),n(e,$,t),g(ze,$,null),l($,Qa),l($,ot),l($,Ga),l($,rt),n(e,da,t),g(Ue,e,t),n(e,pa,t),n(e,gt,t),ma=!0},p:eo,i(e){ma||(h(U.$$.fragment,e),h(J.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(G.$$.fragment,e),h(ae.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(xe.$$.fragment,e),h($e.$$.fragment,e),h(Oe.$$.fragment,e),h(ke.$$.fragment,e),h(Me.$$.fragment,e),h(Ce.$$.fragment,e),h(Le.$$.fragment,e),h(Ke.$$.fragment,e),h(Ne.$$.fragment,e),h(je.$$.fragment,e),h(Fe.$$.fragment,e),h(He.$$.fragment,e),h(Pe.$$.fragment,e),h(Ie.$$.fragment,e),h(ze.$$.fragment,e),h(Ue.$$.fragment,e),ma=!0)},o(e){f(U.$$.fragment,e),f(J.$$.fragment,e),f(R.$$.fragment,e),f(S.$$.fragment,e),f(G.$$.fragment,e),f(ae.$$.fragment,e),f(le.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(Oe.$$.fragment,e),f(ke.$$.fragment,e),f(Me.$$.fragment,e),f(Ce.$$.fragment,e),f(Le.$$.fragment,e),f(Ke.$$.fragment,e),f(Ne.$$.fragment,e),f(je.$$.fragment,e),f(Fe.$$.fragment,e),f(He.$$.fragment,e),f(Pe.$$.fragment,e),f(Ie.$$.fragment,e),f(ze.$$.fragment,e),f(Ue.$$.fragment,e),ma=!1},d(e){e&&(a(ht),a(ct),a(ft),a(ut),a(E),a(_t),a(vt),a(W),a(bt),a(B),a(Tt),a(A),a(yt),a(D),a(wt),a(q),a(xt),a($t),a(V),a(Ot),a(O),a(kt),a(Z),a(Mt),a(Ct),a(Q),a(Lt),a(Kt),a(X),a(Nt),a(Y),a(jt),a(ee),a(Ft),a(te),a(Ht),a(Pt),a(ne),a(It),a(oe),a(zt),a(re),a(Ut),a(Et),a(ie),a(Jt),a(se),a(Wt),a(Bt),a(At),a(Dt),a(ce),a(qt),a(ge),a(Rt),a(Vt),a(fe),a(Zt),a(St),a(_e),a(Qt),a(Gt),a(b),a(aa),a(na),a(ye),a(oa),a(we),a(ra),a(la),a(p),a(ia),a(sa),a($),a(da),a(pa),a(gt)),a(L),u(U,e),u(J,e),u(R,e),u(S,e),u(G,e),u(ae,e),u(le,e),u(de,e),u(pe,e),u(me,e),u(he,e),u(ue,e),u(ve,e),u(Te,e),u(xe,e),u($e),u(Oe),u(ke),u(Me),u(Ce),u(Le),u(Ke),u(Ne),u(je),u(Fe),u(He),u(Pe),u(Ie,e),u(ze),u(Ue,e)}}}const io='{"title":"KTO Trainer","local":"kto-trainer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Quick start","local":"quick-start","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Example script","local":"example-script","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3},{"title":"Batch size recommendations","local":"batch-size-recommendations","sections":[],"depth":3},{"title":"Learning rate recommendations","local":"learning-rate-recommendations","sections":[],"depth":3},{"title":"Imbalanced data","local":"imbalanced-data","sections":[],"depth":3}],"depth":2},{"title":"Logged metrics","local":"logged-metrics","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2}],"depth":1}';function so(Ya){return to(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fo extends ao{constructor(L){super(),no(this,L,so,lo,Xn,{})}}export{fo as component};
