import{s as TI,o as hI,n as bJ}from"../chunks/scheduler.9bc65507.js";import{S as JI,i as UI,g as p,s as a,r as M,A as wI,h as i,f as e,c as n,j as U,u,x as o,k as w,y as d,a as l,v as c,d as r,t as y,w as j}from"../chunks/index.707bf1b6.js";import{T as CJ}from"../chunks/Tip.c2ecdbf4.js";import{D as dI}from"../chunks/Docstring.17db21ae.js";import{C as T}from"../chunks/CodeBlock.54a9f38d.js";import{H as h}from"../chunks/Heading.342b1fa6.js";function mI(x){let J,g="This section is a must-read";return{c(){J=p("p"),J.textContent=g},l(m){J=i(m,"P",{"data-svelte-h":!0}),o(J)!=="svelte-10scaxe"&&(J.textContent=g)},m(m,I){l(m,J,I)},p:bJ,d(m){m&&e(J)}}}function fI(x){let J,g="As of <code>deepspeed==0.6.0</code> the bf16 support is new and experimental.",m,I,B='If you use <a href="#gradient-accumulation">gradient accumulation</a> with bf16-enabled, you need to be aware that it’ll accumulate gradients in bf16, which may not be what you want due to this format’s low precision, as it may lead to a lossy accumulation.',Z,b,_o="A work is being done to fix that and provide an option to use a higher precision <code>dtype</code> (fp16 or fp32).";return{c(){J=p("p"),J.innerHTML=g,m=a(),I=p("p"),I.innerHTML=B,Z=a(),b=p("p"),b.innerHTML=_o},l(f){J=i(f,"P",{"data-svelte-h":!0}),o(J)!=="svelte-zhd1i5"&&(J.innerHTML=g),m=n(f),I=i(f,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1330j3o"&&(I.innerHTML=B),Z=n(f),b=i(f,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1efu1t3"&&(b.innerHTML=_o)},m(f,v){l(f,J,v),l(f,m,v),l(f,I,v),l(f,Z,v),l(f,b,v)},p:bJ,d(f){f&&(e(J),e(m),e(I),e(Z),e(b))}}}function II(x){let J,g=`Note, that once <code>load_state_dict_from_zero_checkpoint</code> was run, the <code>model</code> will no longer be usable in the
DeepSpeed context of the same application. i.e. you will need to re-initialize the deepspeed engine, since
<code>model.load_state_dict(state_dict)</code> will remove all the DeepSpeed magic from it. So do this only at the very end
of the training.`;return{c(){J=p("p"),J.innerHTML=g},l(m){J=i(m,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1jfwcm8"&&(J.innerHTML=g)},m(m,I){l(m,J,I)},p:bJ,d(m){m&&e(J)}}}function CI(x){let J,g,m,I,B,Z,b,_o='<a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> implements everything described in the <a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO paper</a>. Currently it provides full support for:',f,v,AJ="<li>Optimizer state partitioning (ZeRO stage 1)</li> <li>Gradient partitioning (ZeRO stage 2)</li> <li>Parameter partitioning (ZeRO stage 3)</li> <li>Custom mixed precision training handling</li> <li>A range of fast CUDA-extension-based optimizers</li> <li>ZeRO-Offload to CPU and NVMe</li>",qo,k,gJ=`ZeRO-Offload has its own dedicated paper: <a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a>. And NVMe-support is described in the paper <a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU
Memory Wall for Extreme Scale Deep Learning</a>.`,$o,R,vJ="DeepSpeed ZeRO-2 is primarily used only for training, as its features are of no use to inference.",xo,N,_J=`DeepSpeed ZeRO-3 can be used for inference as well, since it allows huge models to be loaded on multiple GPUs, which
won’t be possible on a single GPU.`,Go,X,BJ='🤗 Transformers integrates <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> via 2 options:',So,Q,ZJ=`<li>Integration of the core DeepSpeed features via <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a>. This is an everything-done-for-you type
of integration - just supply your custom config file or use our template and you have nothing else to do. Most of
this document is focused on this feature.</li> <li>If you don’t use <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> and want to use your own Trainer where you integrated DeepSpeed
yourself, core functionality functions like <code>from_pretrained</code> and <code>from_config</code> include integration of essential
parts of DeepSpeed like <code>zero.Init</code> for ZeRO stage 3 and higher. To tap into this feature read the docs on
<a href="#nontrainer-deepspeed-integration">non-Trainer DeepSpeed Integration</a>.</li>`,zo,E,qJ="What is integrated:",Wo,H,$J="Training:",ko,V,xJ="<li>DeepSpeed ZeRO training supports the full ZeRO stages 1, 2 and 3 with ZeRO-Infinity (CPU and NVME offload).</li>",Ro,Y,GJ="Inference:",No,L,SJ=`<li>DeepSpeed ZeRO Inference supports ZeRO stage 3 with ZeRO-Infinity. It uses the same ZeRO protocol as training, but
it doesn’t use an optimizer and a lr scheduler and only stage 3 is relevant. For more details see:
<a href="#zero-inference">zero-inference</a>.</li>`,Xo,F,zJ=`There is also DeepSpeed Inference - this is a totally different technology which uses Tensor Parallelism instead of
ZeRO (coming soon).`,Qo,Hi,Eo,D,Ho,Vi,Vo,P,Yo,O,WJ="Install the library via pypi:",Lo,K,Fo,ss,kJ="or via <code>transformers</code>’ <code>extras</code>:",Do,ts,Po,es,RJ=`or find more details on <a href="https://github.com/microsoft/deepspeed#installation" rel="nofollow">the DeepSpeed’s GitHub page</a> and
<a href="https://www.deepspeed.ai/tutorials/advanced-install/" rel="nofollow">advanced install</a>.`,Oo,ls,NJ='If you’re still struggling with the build, first make sure to read <a href="trainer#cuda-extension-installation-notes">CUDA Extension Installation Notes</a>.',Ko,as,XJ=`If you don’t prebuild the extensions and rely on them to be built at run time and you tried all of the above solutions
to no avail, the next thing to try is to pre-build the modules before installing them.`,sM,ns,QJ="To make a local build for DeepSpeed:",tM,ps,eM,is,EJ=`If you intend to use NVMe offload you will also need to include <code>DS_BUILD_AIO=1</code> in the instructions above (and also
install <em>libaio-dev</em> system-wide).`,lM,os,HJ=`Edit <code>TORCH_CUDA_ARCH_LIST</code> to insert the code for the architectures of the GPU cards you intend to use. Assuming all
your cards are the same you can get the arch via:`,aM,Ms,nM,us,VJ=`So if you get <code>8, 6</code>, then use <code>TORCH_CUDA_ARCH_LIST=&quot;8.6&quot;</code>. If you have multiple different cards, you can list all
of them like so <code>TORCH_CUDA_ARCH_LIST=&quot;6.1;8.6&quot;</code>`,pM,cs,YJ="If you need to use the same setup on multiple machines, make a binary wheel:",iM,rs,oM,ys,LJ=`it will generate something like <code>dist/deepspeed-0.3.13+8cd046f-cp38-cp38-linux_x86_64.whl</code> which now you can install
as <code>pip install deepspeed-0.3.13+8cd046f-cp38-cp38-linux_x86_64.whl</code> locally or on any other machine.`,MM,js,FJ="Again, remember to ensure to adjust <code>TORCH_CUDA_ARCH_LIST</code> to the target architectures.",uM,Ts,DJ=`You can find the complete list of NVIDIA GPUs and their corresponding <strong>Compute Capabilities</strong> (same as arch in this
context) <a href="https://developer.nvidia.com/cuda-gpus" rel="nofollow">here</a>.`,cM,hs,PJ="You can check the archs pytorch was built with using:",rM,Js,yM,Us,OJ="Here is how to find out the arch for one of the installed GPUs. For example, for GPU 0:",jM,ws,TM,ds,KJ="If the output is:",hM,ms,JM,fs,sU="then you know that this card’s arch is <code>8.6</code>.",UM,Is,tU=`You can also leave <code>TORCH_CUDA_ARCH_LIST</code> out completely and then the build program will automatically query the
architecture of the GPUs the build is made on. This may or may not match the GPUs on the target machines, that’s why
it’s best to specify the desired archs explicitly.`,wM,Cs,eU=`If after trying everything suggested you still encounter build issues, please, proceed with the GitHub Issue of
<a href="https://github.com/microsoft/DeepSpeed/issues" rel="nofollow">Deepspeed</a>,`,dM,Yi,mM,bs,fM,As,lU=`To deploy the DeepSpeed integration adjust the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments to include a new argument <code>--deepspeed ds_config.json</code>, where <code>ds_config.json</code> is the DeepSpeed configuration file as
documented <a href="https://www.deepspeed.ai/docs/config-json/" rel="nofollow">here</a>. The file naming is up to you.
It’s recommended to use DeepSpeed’s <code>add_config_arguments</code> utility to add the necessary command line arguments to your code.
For more information please see <a href="https://deepspeed.readthedocs.io/en/latest/initialize.html#argument-parsing" rel="nofollow">DeepSpeed’s Argument Parsing</a> doc.`,IM,gs,aU="You can use a launcher of your choice here. You can continue using the pytorch launcher:",CM,vs,bM,_s,nU="or use the launcher provided by <code>deepspeed</code>:",AM,Bs,gM,Zs,pU=`As you can see the arguments aren’t the same, but for most needs either of them works. The
full details on how to configure various nodes and GPUs can be found <a href="https://www.deepspeed.ai/getting-started/#resource-configuration-multi-node" rel="nofollow">here</a>.`,vM,qs,iU="When you use the <code>deepspeed</code> launcher and you want to use all available gpus you can just omit the <code>--num_gpus</code> flag.",_M,$s,oU="Here is an example of running <code>run_translation.py</code> under DeepSpeed deploying all available GPUs:",BM,xs,ZM,Gs,MU=`Note that in the DeepSpeed documentation you are likely to see <code>--deepspeed --deepspeed_config ds_config.json</code> - i.e.
two DeepSpeed-related arguments, but for the sake of simplicity, and since there are already so many arguments to deal
with, we combined the two into a single argument.`,qM,Ss,uU='For some practical usage examples, please, see this <a href="https://github.com/huggingface/transformers/issues/8771#issuecomment-759248400" rel="nofollow">post</a>.',$M,Li,xM,zs,GM,Ws,cU='To deploy DeepSpeed with one GPU adjust the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments as follows:',SM,ks,zM,Rs,rU=`This is almost the same as with multiple-GPUs, but here we tell DeepSpeed explicitly to use just one GPU via
<code>--num_gpus=1</code>. By default, DeepSpeed deploys all GPUs it can see on the given node. If you have only 1 GPU to start
with, then you don’t need this argument. The following <a href="https://www.deepspeed.ai/getting-started/#resource-configuration-multi-node" rel="nofollow">documentation</a> discusses the launcher options.`,WM,Ns,yU="Why would you want to use DeepSpeed with just one GPU?",kM,Xs,jU=`<li>It has a ZeRO-offload feature which can delegate some computations and memory to the host’s CPU and RAM, and thus
leave more GPU resources for model’s needs - e.g. larger batch size, or enabling a fitting of a very big model which
normally won’t fit.</li> <li>It provides a smart GPU memory management system, that minimizes memory fragmentation, which again allows you to fit
bigger models and data batches.</li>`,RM,Qs,TU=`While we are going to discuss the configuration in details next, the key to getting a huge improvement on a single GPU
with DeepSpeed is to have at least the following configuration in the configuration file:`,NM,Es,XM,Hs,hU=`which enables optimizer offload and some other important features. You may experiment with the buffer sizes, you will
find more details in the discussion below.`,QM,Vs,JU='For a practical usage example of this type of deployment, please, see this <a href="https://github.com/huggingface/transformers/issues/8771#issuecomment-759176685" rel="nofollow">post</a>.',EM,Ys,UU="You may also try the ZeRO-3 with CPU and NVMe offload as explained further in this document.",HM,Ls,wU="Notes:",VM,Fi,q,Di,dU=`if you need to run on a specific GPU, which is different from GPU 0, you can’t use <code>CUDA_VISIBLE_DEVICES</code> to limit
the visible scope of available GPUs. Instead, you have to use the following syntax:`,yJ,Fs,jJ,Pi,mU="In this example, we tell DeepSpeed to use GPU 1 (second gpu).",YM,Oi,LM,Ds,FM,Ps,fU="The information in this section isn’t not specific to the DeepSpeed integration and is applicable to any multi-node program. But DeepSpeed provides a <code>deepspeed</code> launcher that is easier to use than other launchers unless you are in a SLURM environment.",DM,Os,IU="For the duration of this section let’s assume that you have 2 nodes with 8 gpus each. And you can reach the first node with <code>ssh hostname1</code> and second node with <code>ssh hostname2</code>, and both must be able to reach each other via ssh locally without a password. Of course, you will need to rename these host (node) names to the actual host names you are working with.",PM,Ks,OM,st,CU="For example, to use <code>torch.distributed.run</code>, you could do:",KM,tt,su,et,bU="You have to ssh to each node and run this same command on each one of them! There is no rush, the launcher will wait until both nodes will synchronize.",tu,lt,AU='For more information please see <a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>. Incidentally, this is also the launcher that replaced <code>torch.distributed.launch</code> a few pytorch versions back.',eu,at,lu,nt,gU="To use the <code>deepspeed</code> launcher instead, you have to first create a <code>hostfile</code> file:",au,pt,nu,it,vU="and then you can launch it as:",pu,ot,iu,Mt,_U="Unlike the <code>torch.distributed.run</code> launcher, <code>deepspeed</code> will automatically launch this command on both nodes!",ou,ut,BU='For more information please see <a href="https://www.deepspeed.ai/getting-started/#resource-configuration-multi-node" rel="nofollow">Resource Configuration (multi-node)</a>.',Mu,ct,uu,rt,ZU="In the SLURM environment the following approach can be used. The following is a slurm script <code>launch.slurm</code> which you will need to adapt it to your specific SLURM environment.",cu,yt,ru,jt,qU="All is left is to schedule it to run:",yu,Tt,ju,ht,$U="<code>srun</code> will take care of launching the program simultaneously on all nodes.",Tu,Jt,hu,Ut,xU='By default DeepSpeed expects that a multi-node environment uses a shared storage. If this is not the case and each node can only see the local filesystem, you need to adjust the config file to include a  <a href="https://www.deepspeed.ai/docs/config-json/#checkpoint-options" rel="nofollow"><code>checkpoint</code>_section</a> with the following setting:',Ju,wt,Uu,dt,GU='Alternatively, you can also use the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a>’s <code>--save_on_each_node</code> argument, and the above config will be added automatically for you.',wu,Ki,du,mt,mu,ft,SU=`The problem with running notebook cells as a script is that there is no normal <code>deepspeed</code> launcher to rely on, so
under certain setups we have to emulate it.`,fu,It,zU="If you’re using only 1 GPU, here is how you’d have to adjust your training code in the notebook to use DeepSpeed.",Iu,Ct,Cu,bt,WU="Note: <code>...</code> stands for the normal arguments that you’d pass to the functions.",bu,At,kU=`If you want to use more than 1 GPU, you must use a multi-process environment for DeepSpeed to work. That is, you have
to use the launcher for that purpose and this cannot be accomplished by emulating the distributed environment presented
at the beginning of this section.`,Au,gt,RU=`If you want to create the config file on the fly in the notebook in the current directory, you could have a dedicated
cell with:`,gu,vt,vu,_t,NU=`If the training script is in a normal file and not in the notebook cells, you can launch <code>deepspeed</code> normally via
shell from a cell. For example, to use <code>run_translation.py</code> you would launch it with:`,_u,Bt,Bu,Zt,XU="or with <code>%%bash</code> magic, where you can write a multi-line code for the shell program to run:",Zu,qt,qu,$t,QU="In such case you don’t need any of the code presented at the beginning of this section.",$u,xt,EU=`Note: While <code>%%bash</code> magic is neat, but currently it buffers the output so you won’t see the logs until the process
completes.`,xu,so,Gu,Gt,Su,St,HU=`For the complete guide to the DeepSpeed configuration options that can be used in its configuration file please refer
to the <a href="https://www.deepspeed.ai/docs/config-json/" rel="nofollow">following documentation</a>.`,zu,zt,VU=`You can find dozens of DeepSpeed configuration examples that address various practical needs in <a href="https://github.com/microsoft/DeepSpeedExamples" rel="nofollow">the DeepSpeedExamples
repo</a>:`,Wu,Wt,ku,kt,YU=`Continuing the code from above, let’s say you’re looking to configure the Lamb optimizer. So you can search through the
example <code>.json</code> files with:`,Ru,Rt,Nu,Nt,LU='Some more examples are to be found in the <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">main repo</a> as well.',Xu,Xt,FU=`When using DeepSpeed you always need to supply a DeepSpeed configuration file, yet some configuration parameters have
to be configured via the command line. You will find the nuances in the rest of this guide.`,Qu,Qt,DU=`To get an idea of what DeepSpeed configuration file looks like, here is one that activates ZeRO stage 2 features,
including optimizer states cpu offload, uses <code>AdamW</code> optimizer and <code>WarmupLR</code> scheduler and will enable mixed
precision training if <code>--fp16</code> is passed:`,Eu,Et,Hu,Ht,PU=`When you execute the program, DeepSpeed will log the configuration it received from the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a>
to the console, so you can see exactly what was the final configuration passed to it.`,Vu,to,Yu,Vt,Lu,Yt,OU=`As discussed in this document normally the DeepSpeed configuration is passed as a path to a json file, but if you’re
not using the command line interface to configure the training, and instead instantiate the
<a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> via <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> then for the <code>deepspeed</code> argument you can
pass a nested <code>dict</code>. This allows you to create the configuration on the fly and doesn’t require you to write it to
the file system before passing it to <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.`,Fu,Lt,KU="To summarize you can do:",Du,Ft,Pu,Dt,sw="or:",Ou,Pt,Ku,eo,sc,Ot,tc,G,ec,Kt,tw=`Some configuration values are required by both the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> and DeepSpeed to function correctly,
therefore, to prevent conflicting definitions, which could lead to hard to detect errors, we chose to configure those
via the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments.`,lc,se,ew=`Additionally, some configuration values are derived automatically based on the model’s configuration, so instead of
remembering to manually adjust multiple values, it’s the best to let the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> do the majority
of configuration for you.`,ac,te,lw=`Therefore, in the rest of this guide you will find a special configuration value: <code>auto</code>, which when set will be
automatically replaced with the correct or most efficient value. Please feel free to choose to ignore this
recommendation and set the values explicitly, in which case be very careful that your the
<a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> arguments and DeepSpeed configurations agree. For example, are you using the same
learning rate, or batch size, or gradient accumulation settings? if these mismatch the training may fail in very
difficult to detect ways. You have been warned.`,nc,ee,aw=`There are multiple other values that are specific to DeepSpeed-only and those you will have to set manually to suit
your needs.`,pc,le,nw=`In your own programs, you can also use the following approach if you’d like to modify the DeepSpeed config as a master
and configure <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> based on that. The steps are:`,ic,ae,pw='<li>Create or load the DeepSpeed configuration to be used as a master configuration</li> <li>Create the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object based on these values</li>',oc,ne,iw=`Do note that some values, such as <code>scheduler.params.total_num_steps</code> are calculated by
<a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> during <code>train</code>, but you can of course do the math yourself.`,Mc,lo,uc,pe,cc,ie,ow=`<a href="https://www.deepspeed.ai/tutorials/zero/" rel="nofollow">Zero Redundancy Optimizer (ZeRO)</a> is the workhorse of DeepSpeed. It
supports 3 different levels (stages) of optimization. The first one is not quite interesting for scalability purposes,
therefore this document focuses on stages 2 and 3. Stage 3 is further improved by the latest addition of ZeRO-Infinity.
You will find more indepth information in the DeepSpeed documentation.`,rc,oe,Mw=`The <code>zero_optimization</code> section of the configuration file is the most important part (<a href="https://www.deepspeed.ai/docs/config-json/#zero-optimizations-for-fp16-training" rel="nofollow">docs</a>), since that is where you define
which ZeRO stages you want to enable and how to configure them. You will find the explanation for each parameter in the
DeepSpeed docs.`,yc,Me,uw=`This section has to be configured exclusively via DeepSpeed configuration - the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> provides
no equivalent command line arguments.`,jc,ue,cw=`Note: currently DeepSpeed doesn’t validate parameter names, so if you misspell any, it’ll use the default setting for
the parameter that got misspelled. You can watch the DeepSpeed engine start up log messages to see what values it is
going to use.`,Tc,ao,hc,ce,Jc,re,rw="The following is an example of configuration for ZeRO stage 2:",Uc,ye,wc,je,yw="<strong>Performance tuning:</strong>",dc,Te,jw=`<li>enabling <code>offload_optimizer</code> should reduce GPU RAM usage (it requires <code>&quot;stage&quot;: 2</code>)</li> <li><code>&quot;overlap_comm&quot;: true</code> trades off increased GPU RAM usage to lower all-reduce latency. <code>overlap_comm</code> uses 4.5x
the <code>allgather_bucket_size</code> and <code>reduce_bucket_size</code> values. So if they are set to 5e8, this requires a 9GB
footprint (<code>5e8 x 2Bytes x 2 x 4.5</code>). Therefore, if you have a GPU with 8GB or less RAM, to avoid getting
OOM-errors you will need to reduce those parameters to about <code>2e8</code>, which would require 3.6GB. You will want to do
the same on larger capacity GPU as well, if you’re starting to hit OOM.</li> <li>when reducing these buffers you’re trading communication speed to avail more GPU RAM. The smaller the buffer size is,
the slower the communication gets, and the more GPU RAM will be available to other tasks. So if a bigger batch size is
important, getting a slightly slower training time could be a good trade.</li>`,mc,he,Tw="Additionally, <code>deepspeed==0.4.4</code> added a new option <code>round_robin_gradients</code> which you can enable with:",fc,Je,Ic,Ue,hw="This is a stage 2 optimization for CPU offloading that parallelizes gradient copying to CPU memory among ranks by fine-grained gradient partitioning. Performance benefit grows with gradient accumulation steps (more copying between optimizer steps) or GPU count (increased parallelism).",Cc,no,bc,we,Ac,de,Jw="The following is an example of configuration for ZeRO stage 3:",gc,me,vc,fe,Uw=`If you are getting OOMs, because your model or activations don’t fit into the GPU memory and you have unutilized CPU
memory offloading the optimizer states and parameters to CPU memory with <code>&quot;device&quot;: &quot;cpu&quot;</code> may solve this limitation.
If you don’t want to offload to CPU memory, use <code>none</code> instead of <code>cpu</code> for the <code>device</code> entry. Offloading to
NVMe is discussed further down.`,_c,Ie,ww=`Pinned memory is enabled with <code>pin_memory</code> set to <code>true</code>. This feature can improve the throughput at the cost of
making less memory available to other processes. Pinned memory is set aside to the specific process that requested it
and its typically accessed much faster than normal CPU memory.`,Bc,Ce,dw="<strong>Performance tuning:</strong>",Zc,be,mw="<li><code>stage3_max_live_parameters</code>: <code>1e9</code></li> <li><code>stage3_max_reuse_distance</code>: <code>1e9</code></li>",qc,Ae,fw=`If hitting OOM reduce <code>stage3_max_live_parameters</code> and <code>stage3_max_reuse_distance</code>. They should have minimal impact
on performance unless you are doing activation checkpointing. <code>1e9</code> would consume ~2GB. The memory is shared by
<code>stage3_max_live_parameters</code> and <code>stage3_max_reuse_distance</code>, so it’s not additive, it’s just 2GB total.`,$c,ge,Iw=`<code>stage3_max_live_parameters</code> is the upper limit on how many full parameters you want to keep on the GPU at any given
time. “reuse distance” is a metric we are using to figure out when will a parameter be used again in the future, and we
use the <code>stage3_max_reuse_distance</code> to decide whether to throw away the parameter or to keep it. If a parameter is
going to be used again in near future (less than <code>stage3_max_reuse_distance</code>) then we keep it to reduce communication
overhead. This is super helpful when you have activation checkpointing enabled, where we do a forward recompute and
backward passes a single layer granularity and want to keep the parameter in the forward recompute till the backward`,xc,ve,Cw="The following configuration values depend on the model’s hidden size:",Gc,_e,bw="<li><code>reduce_bucket_size</code>: <code>hidden_size*hidden_size</code></li> <li><code>stage3_prefetch_bucket_size</code>: <code>0.9 * hidden_size * hidden_size</code></li> <li><code>stage3_param_persistence_threshold</code>: <code>10 * hidden_size</code></li>",Sc,Be,Aw=`therefore set these values to <code>auto</code> and the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically assign the recommended
values. But, of course, feel free to set these explicitly as well.`,zc,Ze,gw=`<code>stage3_gather_16bit_weights_on_model_save</code> enables model fp16 weights consolidation when model gets saved. With large
models and multiple GPUs this is an expensive operation both in terms of memory and speed. It’s currently required if
you plan to resume the training. Watch out for future updates that will remove this limitation and make things more
flexible.`,Wc,qe,vw=`If you’re migrating from ZeRO-2 configuration note that <code>allgather_partitions</code>, <code>allgather_bucket_size</code> and
<code>reduce_scatter</code> configuration parameters are not used in ZeRO-3. If you keep these in the config file they will just
be ignored.`,kc,$e,_w="<li><code>sub_group_size</code>: <code>1e9</code></li>",Rc,xe,Bw=`<code>sub_group_size</code> controls the granularity in which parameters are updated during optimizer steps. Parameters are
grouped into buckets of <code>sub_group_size</code> and each buckets is updated one at a time. When used with NVMe offload in
ZeRO-Infinity, <code>sub_group_size</code> therefore controls the granularity in which model states are moved in and out of CPU
memory from NVMe during the optimizer step. This prevents running out of CPU memory for extremely large models.`,Nc,Ge,Zw=`You can leave <code>sub_group_size</code> to its default value of <em>1e9</em> when not using NVMe offload. You may want to change its
default value in the following cases:`,Xc,Se,qw=`<li>Running into OOM during optimizer step: Reduce <code>sub_group_size</code> to reduce memory utilization of temporary buffers</li> <li>Optimizer Step is taking a long time: Increase <code>sub_group_size</code> to improve bandwidth utilization as a result of
the increased data buffers.</li>`,Qc,ze,Ec,We,$w="Note that we’re listing Stage 0 and 1 last since they are rarely used.",Hc,ke,xw="Stage 0 is disabling all types of sharding and just using DeepSpeed as DDP. You can turn it on with:",Vc,Re,Yc,Ne,Gw="This will essentially disable ZeRO without you needing to change anything else.",Lc,Xe,Fc,Qe,Sw="Stage 1 is Stage 2 minus gradient sharding. You can always try it to speed things a tiny bit to only shard the optimizer states with:",Dc,Ee,Pc,po,Oc,He,Kc,Ve,zw=`ZeRO-Infinity allows for training incredibly large models by extending GPU and CPU memory with NVMe memory. Thanks to
smart partitioning and tiling algorithms each GPU needs to send and receive very small amounts of data during
offloading so modern NVMe proved to be fit to allow for an even larger total memory pool available to your training
process. ZeRO-Infinity requires ZeRO-3 enabled.`,sr,Ye,Ww="The following configuration example enables NVMe to offload both optimizer states and the params:",tr,Le,er,Fe,kw=`You can choose to offload both optimizer states and params to NVMe, or just one of them or none. For example, if you
have copious amounts of CPU memory available, by all means offload to CPU memory only as it’d be faster (hint:
<em>“device”: “cpu”</em>).`,lr,De,Rw='Here is the full documentation for offloading <a href="https://www.deepspeed.ai/docs/config-json/#optimizer-offloading" rel="nofollow">optimizer states</a> and <a href="https://www.deepspeed.ai/docs/config-json/#parameter-offloading" rel="nofollow">parameters</a>.',ar,Pe,Nw=`Make sure that your <code>nvme_path</code> is actually an NVMe, since it will work with the normal hard drive or SSD, but it’ll
be much much slower. The fast scalable training was designed with modern NVMe transfer speeds in mind (as of this
writing one can have ~3.5GB/s read, ~3GB/s write peak speeds).`,nr,Oe,Xw=`In order to figure out the optimal <code>aio</code> configuration block you must run a benchmark on your target setup, as
<a href="https://github.com/microsoft/DeepSpeed/issues/998" rel="nofollow">explained here</a>.`,pr,io,ir,Ke,or,sl,Qw=`ZeRO-3 is likely to be slower than ZeRO-2 if everything else is configured the same because the former has to gather
model weights in addition to what ZeRO-2 does. If ZeRO-2 meets your needs and you don’t need to scale beyond a few GPUs
then you may choose to stick to it. It’s important to understand that ZeRO-3 enables a much higher scalability capacity
at a cost of speed.`,Mr,tl,Ew="It’s possible to adjust ZeRO-3 configuration to make it perform closer to ZeRO-2:",ur,el,Hw="<li>set <code>stage3_param_persistence_threshold</code> to a very large number - larger than the largest parameter, e.g., <code>6 * hidden_size * hidden_size</code>. This will keep the parameters on the GPUs.</li> <li>turn off <code>offload_params</code> since ZeRO-2 doesn’t have that option.</li>",cr,ll,Vw=`The performance will likely improve significantly with just <code>offload_params</code> turned off, even if you don’t change
<code>stage3_param_persistence_threshold</code>. Of course, these changes will impact the size of the model you can train. So
these help you to trade scalability for speed depending on your needs.`,rr,oo,yr,al,jr,nl,Yw="Here is a full ZeRO-2 auto-configuration file <code>ds_config_zero2.json</code>:",Tr,pl,hr,il,Lw=`Here is a full ZeRO-2 all-enabled manually set configuration file. It is here mainly for you to see what the typical
values look like, but we highly recommend using the one with multiple <code>auto</code> settings in it.`,Jr,ol,Ur,Mo,wr,Ml,dr,ul,Fw="Here is a full ZeRO-3 auto-configuration file <code>ds_config_zero3.json</code>:",mr,cl,fr,rl,Dw=`Here is a full ZeRO-3 all-enabled manually set configuration file. It is here mainly for you to see what the typical
values look like, but we highly recommend using the one with multiple <code>auto</code> settings in it.`,Ir,yl,Cr,jl,br,Tl,Pw="So now you know there are all these different stages. How to decide which of them to use? This section will attempt to address this question.",Ar,hl,Ow="In general the following applies:",gr,Jl,Kw="<li>Speed-wise (left is faster than right)</li>",vr,Ul,sd="Stage 0 (DDP) > Stage 1 > Stage 2 > Stage 2 + offload > Stage 3 > Stage 3 + offloads",_r,wl,td="<li>GPU Memory usage-wise (right is more GPU memory efficient than left)</li>",Br,dl,ed="Stage 0 (DDP) < Stage 1 < Stage 2 < Stage 2 + offload < Stage 3 < Stage 3 + offloads",Zr,ml,ld="So when you want to get the fastest execution while fitting into minimal number of GPUs, here is the process you could follow. We start with the fastest approach and if running into GPU OOM we then go to the next slower approach, but which will use less GPU memory. And so on and so forth.",qr,fl,ad="First of all set batch size to 1 (you can always use gradient accumulation for any desired effective batch size).",$r,Il,nd="<li><p>Enable <code>--gradient_checkpointing 1</code> (HF Trainer) or directly <code>model.gradient_checkpointing_enable()</code> - if OOM then</p></li> <li><p>Try ZeRO stage 2 first. if OOM then</p></li> <li><p>Try ZeRO stage 2 + <code>offload_optimizer</code> - if OOM then</p></li> <li><p>Switch to ZeRO stage 3 - if OOM then</p></li> <li><p>Enable <code>offload_param</code> to <code>cpu</code> - if OOM then</p></li> <li><p>Enable <code>offload_optimizer</code> to <code>cpu</code> - if OOM then</p></li> <li><p>If you still can’t fit a batch size of 1 first check various default values and lower them if you can. For example, if you use <code>generate</code> and you don’t use a wide search beam make it narrower as it’d take a lot of memory.</p></li> <li><p>Definitely use mixed half-precision over fp32 - so bf16 on Ampere and higher GPUs and fp16 on older gpu architectures.</p></li> <li><p>If you still OOM you could add more hardware or enable ZeRO-Infinity - that is switch offloads <code>offload_param</code> and  <code>offload_optimizer</code> to <code>nvme</code>. You need to make sure it’s a very fast nvme. As an anecdote I was able to infer BLOOM-176B on a tiny GPU using ZeRO-Infinity except it was extremely slow. But it worked!</p></li>",xr,Cl,pd="You can, of course, work through these steps in reverse by starting with the most GPU memory efficient config and then going backwards. Or try bi-secting it.",Gr,bl,id="Once you have your batch size 1 not leading to OOM, measure your effective throughput.",Sr,Al,od="Next try to increase the batch size to as large as you can, since the higher the batch size the more efficient the GPUs are as they perform the best when matrices they multiply are huge.",zr,gl,Md="Now the performance optimization game starts. You can turn off some offload features or step down in ZeRO stages and increase/decrease batch size and again measure your effective throughput. Rinse and repeat until satisfied.",Wr,vl,ud="Don’t spend forever on it, but if you’re about to start a 3 months training - do spend a few days on it to find the most effective throughput-wise setup. So that your training cost will be the lowest and you will finish training faster. In the current crazy-paced ML world, if it takes you an extra month to train something you are likely to miss a golden opportunity. Of course, this is only me sharing an observation and in no way I’m trying to rush you. Before beginning to train BLOOM-176B I spent 2 days on this process and was able to increase throughput from 90 to 150 TFLOPs! This effort saved us more than one month of training time.",kr,_l,cd='These notes were written primarily for the training mode, but they should mostly apply for inference as well. For example, during inference Gradient Checkpointing is a no-op since it is only useful during training. Additionally, we found out that if you are doing a multi-GPU inference and not using <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">DeepSpeed-Inference</a>, <a href="https://huggingface.co/blog/bloom-inference-pytorch-scripts" rel="nofollow">Accelerate</a> should provide a superior performance.',Rr,Bl,rd="Other quick related performance notes:",Nr,Zl,yd='<li>if you are training something from scratch always try to have tensors with shapes that are divisible by 16 (e.g. hidden size). For batch size try divisible by 2 at least. There are <a href="https://developer.nvidia.com/blog/optimizing-gpu-performance-tensor-cores/" rel="nofollow">wave and tile quanitization</a> divisibility that is hardware-specific if you want to squeeze even higher performance from your GPUs.</li>',Xr,ql,Qr,$l,jd="Activation checkpointing and gradient checkpointing are two distinct terms that refer to the same methodology. It’s very confusing but this is how it is.",Er,xl,Td="Gradient checkpointing allows one to trade speed for GPU memory, which either allows one to overcome a GPU OOM, or increase their batch size, which often leads to a better performance.",Hr,Gl,hd="HF Transformers models don’t know anything about DeepSpeed’s activation checkpointing, so if you try to enable that feature in the DeepSpeed config file, nothing will happen.",Vr,Sl,Jd="Therefore you have two ways to take advantage of this very beneficial feature:",Yr,zl,Ud='<li>If you want to use a HF Transformers models you can do <code>model.gradient_checkpointing_enable()</code> or use <code>--gradient_checkpointing</code> in the HF Trainer, which will automatically enable this for you. <code>torch.utils.checkpoint</code> is used there.</li> <li>If you write your own model and you want to use DeepSpeed’s activation checkpointing you can use the <a href="https://deepspeed.readthedocs.io/en/latest/activation-checkpointing.html" rel="nofollow">API prescribed there</a>. You can also take the HF Transformers modeling code and replace <code>torch.utils.checkpoint</code> with the DeepSpeed’s API. The latter is more flexible since it allows you to offload the forward activations to the CPU memory instead of recalculating them.</li>',Lr,Wl,Fr,kl,wd=`As long as you don’t enable <code>offload_optimizer</code> you can mix and match DeepSpeed and HuggingFace schedulers and
optimizers.`,Dr,Rl,dd=`It is possible to use a non-DeepSpeed optimizer when <code>offload_optimizer</code> is enabled, as long as it has both CPU and
GPU implementation (except LAMB).`,Pr,uo,Or,Nl,Kr,Xl,md=`DeepSpeed’s main optimizers are Adam, AdamW, OneBitAdam, and Lamb. These have been thoroughly tested with ZeRO and are
thus recommended to be used. It, however, can import other optimizers from <code>torch</code>. The full documentation is <a href="https://www.deepspeed.ai/docs/config-json/#optimizer-parameters" rel="nofollow">here</a>.`,sy,Ql,fd=`If you don’t configure the <code>optimizer</code> entry in the configuration file, the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> will
automatically set it to <code>AdamW</code> and will use the supplied values or the defaults for the following command line
arguments: <code>--learning_rate</code>, <code>--adam_beta1</code>, <code>--adam_beta2</code>, <code>--adam_epsilon</code> and <code>--weight_decay</code>.`,ty,El,Id="Here is an example of the auto-configured <code>optimizer</code> entry for <code>AdamW</code>:",ey,Hl,ly,Vl,Cd=`Note that the command line arguments will set the values in the configuration file. This is so that there is one
definitive source of the values and to avoid hard to find errors when for example, the learning rate is set to
different values in different places. Command line rules. The values that get overridden are:`,ay,Yl,bd="<li><code>lr</code> with the value of <code>--learning_rate</code></li> <li><code>betas</code> with the value of <code>--adam_beta1 --adam_beta2</code></li> <li><code>eps</code> with the value of <code>--adam_epsilon</code></li> <li><code>weight_decay</code> with the value of <code>--weight_decay</code></li>",ny,Ll,Ad="Therefore please remember to tune the shared hyperparameters on the command line.",py,Fl,gd="You can also set the values explicitly:",iy,Dl,oy,Pl,vd=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,My,Ol,_d="If you want to use another optimizer which is not listed above, you will have to add to the top level configuration.",uy,Kl,cy,sa,Bd="Similarly to <code>AdamW</code>, you can configure other officially supported optimizers. Just remember that those may have different config values. e.g. for Adam you will want <code>weight_decay</code> around <code>0.01</code>.",ry,ta,Zd="Additionally, offload works the best when it’s used with Deepspeed’s CPU Adam optimizer. If you want to use a different optimizer with offload, since <code>deepspeed==0.8.3</code> you need to also add:",yy,ea,jy,la,qd="to the top level configuration.",Ty,co,hy,aa,Jy,na,$d=`DeepSpeed supports <code>LRRangeTest</code>, <code>OneCycle</code>, <code>WarmupLR</code> and <code>WarmupDecayLR</code> learning rate schedulers. The full
documentation is <a href="https://www.deepspeed.ai/docs/config-json/#scheduler-parameters" rel="nofollow">here</a>.`,Uy,pa,xd="Here is where the schedulers overlap between 🤗 Transformers and DeepSpeed:",wy,ia,Gd=`<li><code>WarmupLR</code> via <code>--lr_scheduler_type constant_with_warmup</code></li> <li><code>WarmupDecayLR</code> via <code>--lr_scheduler_type linear</code>. This is also the default value for <code>--lr_scheduler_type</code>,
therefore, if you don’t configure the scheduler this is scheduler that will get configured by default.</li>`,dy,oa,Sd=`If you don’t configure the <code>scheduler</code> entry in the configuration file, the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> will use
the values of <code>--lr_scheduler_type</code>, <code>--learning_rate</code> and <code>--warmup_steps</code> or <code>--warmup_ratio</code> to configure a
🤗 Transformers version of it.`,my,Ma,zd="Here is an example of the auto-configured <code>scheduler</code> entry for <code>WarmupLR</code>:",fy,ua,Iy,ca,Wd=`Since <em>“auto”</em> is used the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> arguments will set the correct values in the configuration
file. This is so that there is one definitive source of the values and to avoid hard to find errors when, for example,
the learning rate is set to different values in different places. Command line rules. The values that get set are:`,Cy,ra,kd=`<li><code>warmup_min_lr</code> with the value of <code>0</code>.</li> <li><code>warmup_max_lr</code> with the value of <code>--learning_rate</code>.</li> <li><code>warmup_num_steps</code> with the value of <code>--warmup_steps</code> if provided. Otherwise will use <code>--warmup_ratio</code>
multiplied by the number of training steps and rounded up.</li> <li><code>total_num_steps</code> with either the value of <code>--max_steps</code> or if it is not provided, derived automatically at run
time based on the environment and the size of the dataset and other command line arguments (needed for
<code>WarmupDecayLR</code>).</li>`,by,ya,Rd="You can, of course, take over any or all of the configuration values and set those yourself:",Ay,ja,gy,Ta,Nd=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,vy,ha,Xd="For example, for <code>WarmupDecayLR</code>, you can use the following entry:",_y,Ja,By,Ua,Qd="and <code>total_num_steps</code>, <code>warmup_max_lr</code>, <code>warmup_num_steps</code> and <code>total_num_steps</code> will be set at loading time.",Zy,ro,qy,wa,$y,da,Ed="Deepspeed supports the full fp32 and the fp16 mixed precision.",xy,ma,Hd=`Because of the much reduced memory needs and faster speed one gets with the fp16 mixed precision, the only time you
will want to not use it is when the model you’re using doesn’t behave well under this training mode. Typically this
happens when the model wasn’t pretrained in the fp16 mixed precision (e.g. often this happens with bf16-pretrained
models). Such models may overflow or underflow leading to <code>NaN</code> loss. If this is your case then you will want to use
the full fp32 mode, by explicitly disabling the otherwise default fp16 mixed precision mode with:`,Gy,fa,Sy,Ia,Vd=`If you’re using the Ampere-architecture based GPU, pytorch version 1.7 and higher will automatically switch to using
the much more efficient tf32 format for some operations, but the results will still be in fp32. For details and
benchmarks, please, see <a href="https://pytorch.org/docs/stable/notes/cuda.html#tensorfloat-32-tf32-on-ampere-devices" rel="nofollow">TensorFloat-32(TF32) on Ampere devices</a>. The document includes
instructions on how to disable this automatic conversion if for some reason you prefer not to use it.`,zy,Ca,Yd="With the 🤗 Trainer you can use <code>--tf32</code> to enable it, or disable it with <code>--tf32 0</code> or <code>--no_tf32</code>. By default the PyTorch default is used.",Wy,yo,ky,ba,Ry,Aa,Ld="You can use automatic mixed precision with either a pytorch-like AMP way or the apex-like way:",Ny,ga,Xy,va,Fd="To configure pytorch AMP-like mode with fp16 (float16) set:",Qy,_a,Ey,Ba,Dd=`and the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically enable or disable it based on the value of
<code>args.fp16_backend</code>. The rest of config values are up to you.`,Hy,Za,Pd="This mode gets enabled when <code>--fp16 --fp16_backend amp</code> or <code>--fp16_full_eval</code> command line args are passed.",Vy,qa,Od="You can also enable/disable this mode explicitly:",Yy,$a,Ly,xa,Kd=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,Fy,Ga,sm='Here is the <a href="https://www.deepspeed.ai/docs/config-json/#fp16-training-options" rel="nofollow">documentation</a>.',Dy,Sa,Py,za,tm="If bf16 (bfloat16) is desired instead of fp16 then the following configuration section is to be used:",Oy,Wa,Ky,ka,em="bf16 has the same dynamic range as fp32 and thus doesn’t require loss scaling.",sj,Ra,lm="This mode gets enabled when <code>--bf16</code> or <code>--bf16_full_eval</code> command line args are passed.",tj,Na,am="You can also enable/disable this mode explicitly:",ej,Xa,lj,S,aj,Qa,nj,Ea,nm="There is the <code>dtype</code> of the training regime and there is a separate <code>dtype</code> that is used for communication collectives like various reduction and gathering/scattering operations.",pj,Ha,pm="All gather/scatter ops are performed in the same <code>dtype</code> the data is in, so if you’re using bf16 training regime it gets gathered in bf16 - gathering is a non-lossy operation.",ij,Va,im="Various reduce operations can be quite lossy, for example when gradients are averaged across multiple-gpus, if the communications are done in fp16 or bf16 the outcome is likely be lossy - since when one ads multiple numbers in low precision the result isn’t exact. More so with bf16 as it has a lower precision than fp16. Often fp16 is good enough as the loss is minimal when averaging grads which are typically very small. Therefore, by default for half precision training fp16 is used as the default for reduction operations. But you have full control over this functionality and if you choose you can add a small overhead and ensure that reductions will be using fp32 as the accumulation dtype and only when the result is ready it’ll get downcast to the half precision <code>dtype</code> you’re training in.",oj,Ya,om="In order to override the default you simply add a new configuration entry:",Mj,La,uj,Fa,Mm="The valid values as of this writing are “fp16”, “bfp16”, “fp32”.",cj,Da,um="note: stage zero 3 had a bug with regards to bf16 comm dtype that was fixed in <code>deepspeed==0.8.1</code>",rj,Pa,yj,Oa,cm="To configure apex AMP-like mode set:",jj,Ka,Tj,sn,rm=`and the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically configure it based on the values of <code>args.fp16_backend</code> and
<code>args.fp16_opt_level</code>.`,hj,tn,ym="This mode gets enabled when <code>--fp16 --fp16_backend apex --fp16_opt_level 01</code> command line args are passed.",Jj,en,jm="You can also configure this mode explicitly:",Uj,ln,wj,an,Tm=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,dj,nn,hm='Here is the <a href="https://www.deepspeed.ai/docs/config-json/#automatic-mixed-precision-amp-training-options" rel="nofollow">documentation</a>.',mj,jo,fj,pn,Ij,on,Jm="To configure batch size, use:",Cj,Mn,bj,un,Um=`and the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically set <code>train_micro_batch_size_per_gpu</code> to the value of
<code>args.per_device_train_batch_size</code> and <code>train_batch_size</code> to <code>args.world_size * args.per_device_train_batch_size * args.gradient_accumulation_steps</code>.`,Aj,cn,wm="You can also set the values explicitly:",gj,rn,vj,yn,dm=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,_j,To,Bj,jn,Zj,Tn,mm="To configure gradient accumulation set:",qj,hn,$j,Jn,fm='and the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically set it to the value of <code>args.gradient_accumulation_steps</code>.',xj,Un,Im="You can also set the value explicitly:",Gj,wn,Sj,dn,Cm=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,zj,ho,Wj,mn,kj,fn,bm="To configure gradient gradient clipping set:",Rj,In,Nj,Cn,Am='and the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically set it to the value of <code>args.max_grad_norm</code>.',Xj,bn,gm="You can also set the value explicitly:",Qj,An,Ej,gn,vm=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,Hj,Jo,Vj,vn,Yj,_n,_m=`As long as you continue training and resuming using DeepSpeed you don’t need to worry about anything. DeepSpeed stores
fp32 master weights in its custom checkpoint optimizer files, which are <code>global_step*/*optim_states.pt</code> (this is glob
pattern), and are saved under the normal checkpoint.`,Lj,Bn,Bm="<strong>FP16 Weights:</strong>",Fj,Zn,Zm=`When a model is saved under ZeRO-2, you end up having the normal <code>pytorch_model.bin</code> file with the model weights, but
they are only the fp16 version of the weights.`,Dj,qn,qm=`Under ZeRO-3, things are much more complicated, since the model weights are partitioned out over multiple GPUs,
therefore <code>&quot;stage3_gather_16bit_weights_on_model_save&quot;: true</code> is required to get the <code>Trainer</code> to save the fp16
version of the weights. If this setting is <code>False</code> <code>pytorch_model.bin</code> won’t be created. This is because by default DeepSpeed’s <code>state_dict</code> contains a placeholder and not the real weights. If we were to save this <code>state_dict</code> it won’t be possible to load it back.`,Pj,$n,Oj,xn,$m="<strong>FP32 Weights:</strong>",Kj,Gn,xm=`While the fp16 weights are fine for resuming training, if you finished finetuning your model and want to upload it to
the <a href="https://huggingface.co/models" rel="nofollow">models hub</a> or pass it to someone else you most likely will want to get the fp32
weights. This ideally shouldn’t be done during training since this is a process that requires a lot of memory, and
therefore best to be performed offline after the training is complete. But if desired and you have plenty of free CPU
memory it can be done in the same training script. The following sections will discuss both approaches.`,sT,Sn,Gm="<strong>Live FP32 Weights Recovery:</strong>",tT,zn,Sm="This approach may not work if you model is large and you have little free CPU memory left, at the end of the training.",eT,Wn,zm="If you have saved at least one checkpoint, and you want to use the latest one, you can do the following:",lT,kn,aT,Rn,Wm=`If you’re using the <code>--load_best_model_at_end</code> class:<em>~transformers.TrainingArguments</em> argument (to track the best
checkpoint), then you can finish the training by first saving the final model explicitly and then do the same as above:`,nT,Nn,pT,z,iT,Xn,km=`Of course, you don’t have to use class:<em>~transformers.Trainer</em> and you can adjust the examples above to your own
trainer.`,oT,Qn,Rm=`If for some reason you want more refinement, you can also extract the fp32 <code>state_dict</code> of the weights and apply
these yourself as is shown in the following example:`,MT,En,uT,Hn,Nm="<strong>Offline FP32 Weights Recovery:</strong>",cT,Vn,Xm=`DeepSpeed creates a special conversion script <code>zero_to_fp32.py</code> which it places in the top-level of the checkpoint
folder. Using this script you can extract the weights at any point. The script is standalone and you no longer need to
have the configuration file or a <code>Trainer</code> to do the extraction.`,rT,Yn,Qm="Let’s say your checkpoint folder looks like this:",yT,Ln,jT,Fn,Em=`In this example there is just one DeepSpeed checkpoint sub-folder <em>global_step1</em>. Therefore to reconstruct the fp32
weights just run:`,TT,Dn,hT,Pn,Hm="This is it. <code>pytorch_model.bin</code> will now contain the full fp32 model weights consolidated from multiple GPUs.",JT,On,Vm="The script will automatically be able to handle either a ZeRO-2 or ZeRO-3 checkpoint.",UT,Kn,Ym="<code>python zero_to_fp32.py -h</code> will give you usage details.",wT,sp,Lm=`The script will auto-discover the deepspeed sub-folder using the contents of the file <code>latest</code>, which in the current
example will contain <code>global_step1</code>.`,dT,tp,Fm="Note: currently the script requires 2x general RAM of the final fp32 model weights.",mT,ep,fT,lp,Dm="ZeRO-3 is quite different from ZeRO-2 because of its param sharding feature.",IT,ap,Pm="ZeRO-Infinity further extends ZeRO-3 to support NVMe memory and multiple other speed and scalability improvements.",CT,np,Om=`While all the efforts were made for things to just work without needing any special changes to your models, in certain
circumstances you may find the following information to be needed.`,bT,pp,AT,ip,Km=`DeepSpeed/ZeRO-3 can handle models with Trillions of parameters which may not fit onto the existing RAM. In such cases,
but also if you want the initialization to happen much faster, initialize the model using <em>deepspeed.zero.Init()</em>
context manager (which is also a function decorator), like so:`,gT,op,vT,Mp,sf="As you can see this gives you a randomly initialized model.",_T,up,tf=`If you want to use a pretrained model, <code>model_class.from_pretrained</code> will activate this feature as long as
<code>is_deepspeed_zero3_enabled()</code> returns <code>True</code>, which currently is setup by the
<a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object if the passed DeepSpeed configuration file contains ZeRO-3 config
section. Thus you must create the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object <strong>before</strong> calling
<code>from_pretrained</code>. Here is an example of a possible sequence:`,BT,cp,ZT,rp,ef=`If you’re using the official example scripts and your command line arguments include <code>--deepspeed ds_config.json</code>
with ZeRO-3 config enabled, then everything is already done for you, since this is how example scripts are written.`,qT,yp,lf="Note: If the fp16 weights of the model can’t fit onto the memory of a single GPU this feature must be used.",$T,jp,af='For full details on this method and other related features please refer to <a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#constructing-massive-models" rel="nofollow">Constructing Massive Models</a>.',xT,Tp,nf=`Also when loading fp16-pretrained models, you will want to tell <code>from_pretrained</code> to use
<code>torch_dtype=torch.float16</code>. For details, please, see <a href="#from_pretrained-torch-dtype">from_pretrained-torch-dtype</a>.`,GT,hp,ST,Jp,pf=`Under ZeRO-3 on multiple GPUs no single GPU has all the parameters unless it’s the parameters for the currently
executing layer. So if you need to access all parameters from all layers at once there is a specific method to do it.
Most likely you won’t need it, but if you do please refer to <a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#manual-parameter-coordination" rel="nofollow">Gathering Parameters</a>`,zT,Up,of=`We do however use it internally in several places, one such example is when loading pretrained model weights in
<code>from_pretrained</code>. We load one layer at a time and immediately partition it to all participating GPUs, as for very
large models it won’t be possible to load it on one GPU and then spread it out to multiple GPUs, due to memory
limitations.`,WT,wp,Mf="Also under ZeRO-3, if you write your own code and run into a model parameter weight that looks like:",kT,dp,RT,mp,uf=`stress on <code>tensor([1.])</code>, or if you get an error where it says the parameter is of size <code>1</code>, instead of some much
larger multi-dimensional shape, this means that the parameter is partitioned and what you see is a ZeRO-3 placeholder.`,NT,Uo,XT,fp,QT,Ip,cf=`ZeRO Inference uses the same config as ZeRO-3 Training. You just don’t need the optimizer and scheduler sections. In
fact you can leave these in the config file if you want to share the same one with the training. They will just be
ignored.`,ET,Cp,rf='Otherwise you just need to pass the usual <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> arguments. For example:',HT,bp,VT,Ap,yf=`The only important thing is that you need to use a ZeRO-3 configuration, since ZeRO-2 provides no benefit whatsoever
for the inference as only ZeRO-3 performs sharding of parameters, whereas ZeRO-1 shards gradients and optimizer states.`,YT,gp,jf="Here is an example of running <code>run_translation.py</code> under DeepSpeed deploying all available GPUs:",LT,vp,FT,_p,Tf=`Since for inference there is no need for additional large memory used by the optimizer states and the gradients you
should be able to fit much larger batches and/or sequence length onto the same hardware.`,DT,Bp,hf=`Additionally DeepSpeed is currently developing a related product called Deepspeed-Inference which has no relationship
to the ZeRO technology, but instead uses tensor parallelism to scale models that can’t fit onto a single GPU. This is a
work in progress and we will provide the integration once that product is complete.`,PT,Zp,OT,qp,Jf="Since Deepspeed ZeRO can offload memory to CPU (and NVMe) the framework provides utils that allow one to tell how much CPU and GPU memory will be needed depending on the number of GPUs being used.",KT,$p,Uf="Let’s estimate how much memory is needed to finetune “bigscience/T0_3B” on a single GPU:",sh,xp,th,Gp,wf="So you can fit it on a single 80GB GPU and no CPU offload, or a tiny 8GB GPU but then need ~60GB of CPU memory. (Remember this is just the memory for params, optimizer states and gradients - you will need a bit more memory for cuda kernels, activations and temps.)",eh,Sp,df="Then it’s a tradeoff of cost vs speed. It’ll be cheaper to buy/rent a smaller GPU (or less GPUs since you can use multiple GPUs with Deepspeed ZeRO. But then it’ll be slower, so even if you don’t care about how fast something will be done, the slowdown has a direct impact on the duration of using the GPU and thus bigger cost. So experiment and compare which works the best.",lh,zp,mf="If you have enough GPU memory make sure to disable the CPU/NVMe offload as it’ll make everything faster.",ah,Wp,ff="For example, let’s repeat the same for 2 GPUs:",nh,kp,ph,Rp,If="So here you’d want 2x 32GB GPUs or higher without offloading to CPU.",ih,Np,Cf='For full information please see <a href="https://deepspeed.readthedocs.io/en/latest/memory.html" rel="nofollow">memory estimators</a>.',oh,Xp,Mh,Qp,bf="Here is how to file an issue so that we could quickly get to the bottom of the issue and help you to unblock your work.",uh,Ep,Af="In your report please always include:",ch,C,wo,gf="<p>the full Deepspeed config file in the report</p>",TJ,mo,vf=`<p>either the command line arguments if you were using the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> or
<a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> arguments if you were scripting the Trainer setup yourself. Please do not
dump the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> as it has dozens of entries that are irrelevant.</p>`,hJ,Hp,fo,_f="Output of:",JJ,Vp,UJ,Io,Bf=`<p>If possible include a link to a Google Colab notebook that we can reproduce the problem with. You can use this
<a href="https://github.com/stas00/porting/blob/master/transformers/deepspeed/DeepSpeed_on_colab_CLI.ipynb" rel="nofollow">notebook</a> as
a starting point.</p>`,wJ,Co,Zf="<p>Unless it’s impossible please always use a standard dataset that we can use and not something custom.</p>",dJ,bo,qf='<p>If possible try to use one of the existing <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch" rel="nofollow">examples</a> to reproduce the problem with.</p>',rh,Yp,$f="Things to consider:",yh,Lp,xf=`<li><p>Deepspeed is often not the cause of the problem.</p> <p>Some of the filed issues proved to be Deepspeed-unrelated. That is once Deepspeed was removed from the setup, the
problem was still there.</p> <p>Therefore, if it’s not absolutely obvious it’s a DeepSpeed-related problem, as in you can see that there is an
exception and you can see that DeepSpeed modules are involved, first re-test your setup without DeepSpeed in it.
And only if the problem persists then do mentioned Deepspeed and supply all the required details.</p></li> <li><p>If it’s clear to you that the issue is in the DeepSpeed core and not the integration part, please file the Issue
directly with <a href="https://github.com/microsoft/DeepSpeed/" rel="nofollow">Deepspeed</a>. If you aren’t sure, please do not worry,
either Issue tracker will do, we will figure it out once you posted it and redirect you to another Issue tracker if
need be.</p></li>`,jh,Fp,Th,Dp,hh,Pp,Gf=`If the <code>deepspeed</code> process gets killed at launch time without a traceback, that usually means that the program tried
to allocate more CPU memory than your system has or your process is allowed to allocate and the OS kernel killed that
process. This is because your configuration file most likely has either <code>offload_optimizer</code> or <code>offload_param</code> or
both configured to offload to <code>cpu</code>. If you have NVMe, experiment with offloading to NVMe if you’re running under
ZeRO-3. Here is how you can <a href="https://deepspeed.readthedocs.io/en/latest/memory.html" rel="nofollow">estimate how much memory is needed for a specific model</a>.`,Jh,Op,Uh,Kp,Sf="This often happens when one takes a model pre-trained in bf16 mixed precision mode and tries to use it under fp16 (with or without mixed precision). Most models trained on TPU and often the ones released by Google are in this category (e.g. almost all t5-based models). Here the solution is to either use fp32 or bf16 if your hardware supports it (TPU, Ampere GPUs or newer).",wh,si,zf="The other problem may have to do with using fp16. When you configure this section:",dh,ti,mh,ei,Wf="and you see in your log that Deepspeed reports <code>OVERFLOW!</code> as follows:",fh,li,Ih,ai,kf="that means that the Deepspeed loss scaler can’t figure out a scaling co-efficient that overcomes loss overflow.",Ch,ni,Rf="(the log was massaged to be more readable here.)",bh,pi,Nf="In this case you usually need to raise the value of <code>initial_scale_power</code>. Setting it to <code>&quot;initial_scale_power&quot;: 32</code> will typically resolve the problem.",Ah,ii,gh,oi,Xf=`<li>While DeepSpeed has a pip installable PyPI package, it is highly recommended that it gets installed from <a href="https://github.com/microsoft/deepspeed#installation" rel="nofollow">source</a> to best match your hardware and also if you need to enable
certain features, like 1-bit Adam, which aren’t available in the pypi distribution.</li> <li>You don’t have to use the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> to use DeepSpeed with 🤗 Transformers - you can use any model
with your own trainer, and you will have to adapt the latter according to <a href="https://www.deepspeed.ai/getting-started/#writing-deepspeed-models" rel="nofollow">the DeepSpeed integration instructions</a>.</li>`,vh,Mi,_h,ui,Qf=`The <a href="/docs/transformers/v4.37.0/en/main_classes/deepspeed#transformers.integrations.HfDeepSpeedConfig">HfDeepSpeedConfig</a> is used to integrate Deepspeed into the 🤗 Transformers core
functionality, when <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> is not used. The only thing that it does is handling Deepspeed ZeRO-3 param gathering and automatically splitting the model onto multiple gpus during <code>from_pretrained</code> call. Everything else you have to do by yourself.`,Bh,ci,Ef='When using <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> everything is automatically taken care of.',Zh,ri,Hf=`When not using <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a>, to efficiently deploy DeepSpeed ZeRO-3, you must instantiate the
<a href="/docs/transformers/v4.37.0/en/main_classes/deepspeed#transformers.integrations.HfDeepSpeedConfig">HfDeepSpeedConfig</a> object before instantiating the model and keep that object alive.`,qh,yi,Vf="If you’re using Deepspeed ZeRO-1 or ZeRO-2 you don’t need to use <code>HfDeepSpeedConfig</code> at all.",$h,ji,Yf="For example for a pretrained model:",xh,Ti,Gh,hi,Lf="or for non-pretrained model:",Sh,Ji,zh,Ui,Ff='Please note that if you’re not using the <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> integration, you’re completely on your own. Basically follow the documentation on the <a href="https://www.deepspeed.ai/" rel="nofollow">Deepspeed</a> website. Also you have to configure explicitly the config file - you can’t use <code>&quot;auto&quot;</code> values and you will have to put real values instead.',Wh,wi,kh,_,di,mJ,Ao,Df="This object contains a DeepSpeed configuration dictionary and can be quickly queried for things like zero stage.",fJ,go,Pf=`A <code>weakref</code> of this object is stored in the module’s globals to be able to access the config from areas where
things like the Trainer object is not available (e.g. <code>from_pretrained</code> and <code>_get_resized_embeddings</code>). Therefore
it’s important that this object remains alive while the program is still running.`,IJ,vo,Of=`<a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> uses the <code>HfTrainerDeepSpeedConfig</code> subclass instead. That subclass has logic to sync the configuration
with values of <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> by replacing special placeholder values: <code>&quot;auto&quot;</code>. Without this special logic
the DeepSpeed configuration is not modified in any way.`,Rh,mi,Nh,fi,Kf='Here is an example of how one could do DeepSpeed ZeRO Inference without using <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> when one can’t fit a model onto a single GPU. The solution includes using additional GPUs or/and offloading GPU memory to CPU memory.',Xh,Ii,sI="The important nuance to understand here is that the way ZeRO is designed you can process different inputs on different GPUs in parallel.",Qh,Ci,tI="The example has copious notes and is self-documenting.",Eh,bi,eI="Make sure to:",Hh,Ai,lI="<li>disable CPU offload if you have enough GPU memory (since it slows things down)</li> <li>enable bf16 if you own an Ampere or a newer GPU to make things faster. If you don’t have that hardware you may enable fp16 as long as you don’t use any model that was pre-trained in bf16 mixed precision (such as most t5 models). These usually overflow in fp16 and you will see garbage as output.</li>",Vh,gi,Yh,vi,aI="Let’s save it as <code>t0.py</code> and run it:",Lh,_i,Fh,Bi,nI="This was a very basic example and you will want to adapt it to your needs.",Dh,Zi,Ph,qi,pI="When using multiple GPUs with ZeRO Stage-3, one has to synchronize the GPUs by calling <code>generate(..., synced_gpus=True)</code>. If this is not done if one GPU finished generating before other GPUs the whole system will hang as the rest of the GPUs will not be able to received the shard of weights from the GPU that stopped generating.",Oh,$i,iI="Starting from <code>transformers&gt;=4.28</code>, if <code>synced_gpus</code> isn’t explicitly specified, it’ll be set to <code>True</code> automatically if these conditions are detected. But you can still override the value of <code>synced_gpus</code> if need to.",Kh,xi,sJ,Gi,oI="If you submit a PR that involves DeepSpeed integration please note our CircleCI PR CI setup has no GPUs, so we only run tests requiring gpus on a different CI nightly. Therefore if you get a green CI report in your PR it doesn’t mean DeepSpeed tests pass.",tJ,Si,MI="To run DeepSpeed tests, please run at least:",eJ,zi,lJ,Wi,uI="If you changed any of the modeling or pytorch examples code, then run the model zoo tests as well. The following will run all DeepSpeed tests:",aJ,ki,nJ,Ri,pJ,Ni,cI='<li><a href="https://github.com/microsoft/deepspeed" rel="nofollow">Project’s github</a></li> <li><a href="https://www.deepspeed.ai/getting-started/" rel="nofollow">Usage docs</a></li> <li><a href="https://deepspeed.readthedocs.io/en/latest/index.html" rel="nofollow">API docs</a></li> <li><a href="https://www.microsoft.com/en-us/research/search/?q=deepspeed" rel="nofollow">Blog posts</a></li>',iJ,Xi,rI="Papers:",oJ,Qi,yI='<li><a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO: Memory Optimizations Toward Training Trillion Parameter Models</a></li> <li><a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a></li> <li><a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU Memory Wall for Extreme Scale Deep Learning</a></li>',MJ,Ei,jI=`Finally, please, remember that, HuggingFace <a href="/docs/transformers/v4.37.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> only integrates DeepSpeed, therefore if you
have any problems or questions with regards to DeepSpeed usage, please, file an issue with <a href="https://github.com/microsoft/DeepSpeed/issues" rel="nofollow">DeepSpeed GitHub</a>.`,uJ,Bo,cJ;return B=new h({props:{title:"DeepSpeed Integration",local:"deepspeed-integration",headingTag:"h1"}}),D=new h({props:{title:"Trainer Deepspeed Integration",local:"trainer-deepspeed-integration",headingTag:"h2"}}),P=new h({props:{title:"Installation",local:"installation",headingTag:"h3"}}),K=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRlZXBzcGVlZA==",highlighted:"pip install deepspeed",wrap:!1}}),ts=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyU1QmRlZXBzcGVlZCU1RA==",highlighted:"pip install transformers[deepspeed]",wrap:!1}}),ps=new T({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZtaWNyb3NvZnQlMkZEZWVwU3BlZWQlMkYlMEFjZCUyMERlZXBTcGVlZCUwQXJtJTIwLXJmJTIwYnVpbGQlMEFUT1JDSF9DVURBX0FSQ0hfTElTVCUzRCUyMjguNiUyMiUyMERTX0JVSUxEX0NQVV9BREFNJTNEMSUyMERTX0JVSUxEX1VUSUxTJTNEMSUyMHBpcCUyMGluc3RhbGwlMjAuJTIwJTVDJTBBLS1nbG9iYWwtb3B0aW9uJTNEJTIyYnVpbGRfZXh0JTIyJTIwLS1nbG9iYWwtb3B0aW9uJTNEJTIyLWo4JTIyJTIwLS1uby1jYWNoZSUyMC12JTIwJTVDJTBBLS1kaXNhYmxlLXBpcC12ZXJzaW9uLWNoZWNrJTIwMiUzRSUyNjElMjAlN0MlMjB0ZWUlMjBidWlsZC5sb2c=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/microsoft/DeepSpeed/
<span class="hljs-built_in">cd</span> DeepSpeed
<span class="hljs-built_in">rm</span> -rf build
TORCH_CUDA_ARCH_LIST=<span class="hljs-string">&quot;8.6&quot;</span> DS_BUILD_CPU_ADAM=1 DS_BUILD_UTILS=1 pip install . \\
--global-option=<span class="hljs-string">&quot;build_ext&quot;</span> --global-option=<span class="hljs-string">&quot;-j8&quot;</span> --no-cache -v \\
--disable-pip-version-check 2&gt;&amp;1 | <span class="hljs-built_in">tee</span> build.log`,wrap:!1}}),Ms=new T({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KHRvcmNoLmN1ZGEuZ2V0X2RldmljZV9jYXBhYmlsaXR5KCkpJTIy",highlighted:'CUDA_VISIBLE_DEVICES=0 python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_capability())&quot;</span>',wrap:!1}}),rs=new T({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZtaWNyb3NvZnQlMkZEZWVwU3BlZWQlMkYlMEFjZCUyMERlZXBTcGVlZCUwQXJtJTIwLXJmJTIwYnVpbGQlMEFUT1JDSF9DVURBX0FSQ0hfTElTVCUzRCUyMjguNiUyMiUyMERTX0JVSUxEX0NQVV9BREFNJTNEMSUyMERTX0JVSUxEX1VUSUxTJTNEMSUyMCU1QyUwQXB5dGhvbiUyMHNldHVwLnB5JTIwYnVpbGRfZXh0JTIwLWo4JTIwYmRpc3Rfd2hlZWw=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/microsoft/DeepSpeed/
<span class="hljs-built_in">cd</span> DeepSpeed
<span class="hljs-built_in">rm</span> -rf build
TORCH_CUDA_ARCH_LIST=<span class="hljs-string">&quot;8.6&quot;</span> DS_BUILD_CPU_ADAM=1 DS_BUILD_UTILS=1 \\
python setup.py build_ext -j8 bdist_wheel`,wrap:!1}}),Js=new T({props:{code:"cHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KHRvcmNoLmN1ZGEuZ2V0X2FyY2hfbGlzdCgpKSUyMg==",highlighted:'python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_arch_list())&quot;</span>',wrap:!1}}),ws=new T({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMCU1QyUwQXByaW50KHRvcmNoLmN1ZGEuZ2V0X2RldmljZV9wcm9wZXJ0aWVzKHRvcmNoLmRldmljZSgnY3VkYScpKSklMjI=",highlighted:`CUDA_VISIBLE_DEVICES=0 python -c <span class="hljs-string">&quot;import torch; \\
print(torch.cuda.get_device_properties(torch.device(&#x27;cuda&#x27;)))&quot;</span>`,wrap:!1}}),ms=new T({props:{code:"X0N1ZGFEZXZpY2VQcm9wZXJ0aWVzKG5hbWUlM0QnR2VGb3JjZSUyMFJUWCUyMDMwOTAnJTJDJTIwbWFqb3IlM0Q4JTJDJTIwbWlub3IlM0Q2JTJDJTIwdG90YWxfbWVtb3J5JTNEMjQyNjhNQiUyQyUyMG11bHRpX3Byb2Nlc3Nvcl9jb3VudCUzRDgyKQ==",highlighted:'_CudaDeviceProperties(name=<span class="hljs-string">&#x27;GeForce RTX 3090&#x27;</span>, major=8, minor=6, total_memory=24268MB, multi_processor_count=82)',wrap:!1}}),bs=new h({props:{title:"Deployment with multiple GPUs",local:"deployment-with-multiple-gpus",headingTag:"h3"}}),vs=new T({props:{code:"dG9yY2guZGlzdHJpYnV0ZWQucnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDIlMjB5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:"torch.distributed.run --nproc_per_node=2 your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json",wrap:!1}}),Bs=new T({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUzRDIlMjB5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:"deepspeed --num_gpus=2 your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json",wrap:!1}}),xs=new T({props:{code:"ZGVlcHNwZWVkJTIwZXhhbXBsZXMlMkZweXRvcmNoJTJGdHJhbnNsYXRpb24lMkZydW5fdHJhbnNsYXRpb24ucHklMjAlNUMlMEEtLWRlZXBzcGVlZCUyMHRlc3RzJTJGZGVlcHNwZWVkJTJGZHNfY29uZmlnX3plcm8zLmpzb24lMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMHQ1LXNtYWxsJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBLS1vdXRwdXRfZGlyJTIwb3V0cHV0X2RpciUyMC0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjAtLWZwMTYlMjAlNUMlMEEtLWRvX3RyYWluJTIwLS1tYXhfdHJhaW5fc2FtcGxlcyUyMDUwMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEEtLWRhdGFzZXRfbmFtZSUyMHdtdDE2JTIwLS1kYXRhc2V0X2NvbmZpZyUyMCUyMnJvLWVuJTIyJTIwJTVDJTBBLS1zb3VyY2VfbGFuZyUyMGVuJTIwLS10YXJnZXRfbGFuZyUyMHJv",highlighted:`deepspeed examples/pytorch/translation/run_translation.py \\
--deepspeed tests/deepspeed/ds_config_zero3.json \\
--model_name_or_path t5-small --per_device_train_batch_size 1 \\
--output_dir output_dir --overwrite_output_dir --fp16 \\
--do_train --max_train_samples 500 --num_train_epochs 1 \\
--dataset_name wmt16 --dataset_config <span class="hljs-string">&quot;ro-en&quot;</span> \\
--source_lang en --target_lang ro`,wrap:!1}}),zs=new h({props:{title:"Deployment with one GPU",local:"deployment-with-one-gpu",headingTag:"h3"}}),ks=new T({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUzRDElMjBleGFtcGxlcyUyRnB5dG9yY2glMkZ0cmFuc2xhdGlvbiUyRnJ1bl90cmFuc2xhdGlvbi5weSUyMCU1QyUwQS0tZGVlcHNwZWVkJTIwdGVzdHMlMkZkZWVwc3BlZWQlMkZkc19jb25maWdfemVybzIuanNvbiUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwdDUtc21hbGwlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEEtLW91dHB1dF9kaXIlMjBvdXRwdXRfZGlyJTIwLS1vdmVyd3JpdGVfb3V0cHV0X2RpciUyMC0tZnAxNiUyMCU1QyUwQS0tZG9fdHJhaW4lMjAtLW1heF90cmFpbl9zYW1wbGVzJTIwNTAwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMSUyMCU1QyUwQS0tZGF0YXNldF9uYW1lJTIwd210MTYlMjAtLWRhdGFzZXRfY29uZmlnJTIwJTIycm8tZW4lMjIlMjAlNUMlMEEtLXNvdXJjZV9sYW5nJTIwZW4lMjAtLXRhcmdldF9sYW5nJTIwcm8=",highlighted:`deepspeed --num_gpus=1 examples/pytorch/translation/run_translation.py \\
--deepspeed tests/deepspeed/ds_config_zero2.json \\
--model_name_or_path t5-small --per_device_train_batch_size 1 \\
--output_dir output_dir --overwrite_output_dir --fp16 \\
--do_train --max_train_samples 500 --num_train_epochs 1 \\
--dataset_name wmt16 --dataset_config <span class="hljs-string">&quot;ro-en&quot;</span> \\
--source_lang en --target_lang ro`,wrap:!1}}),Es=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX3BhcnRpdGlvbnMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX2J1Y2tldF9zaXplJTIyJTNBJTIwMmU4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIycmVkdWNlX3NjYXR0ZXIlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIycmVkdWNlX2J1Y2tldF9zaXplJTIyJTNBJTIwMmU4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMmNvbnRpZ3VvdXNfZ3JhZGllbnRzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
     <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
     <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Fs=new T({props:{code:"ZGVlcHNwZWVkJTIwLS1pbmNsdWRlJTIwbG9jYWxob3N0JTNBMSUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRnRyYW5zbGF0aW9uJTJGcnVuX3RyYW5zbGF0aW9uLnB5JTIwLi4u",highlighted:"deepspeed --include localhost:1 examples/pytorch/translation/run_translation.py ...",wrap:!1}}),Ds=new h({props:{title:"Deployment with multiple Nodes",local:"deployment-with-multiple-nodes",headingTag:"h3"}}),Ks=new h({props:{title:"The torch.distributed.run(torchrun) launcher",local:"the-torchdistributedruntorchrun-launcher",headingTag:"h4"}}),tt=new T({props:{code:"cHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5ydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEOCUyMC0tbm5vZGUlM0QyJTIwLS1ub2RlX3JhbmslM0QwJTIwLS1tYXN0ZXJfYWRkciUzRGhvc3RuYW1lMSUyMCU1QyUwQS0tbWFzdGVyX3BvcnQlM0Q5OTAxJTIweW91cl9wcm9ncmFtLnB5JTIwJTNDbm9ybWFsJTIwY2wlMjBhcmdzJTNFJTIwLS1kZWVwc3BlZWQlMjBkc19jb25maWcuanNvbg==",highlighted:`python -m torch.distributed.run --nproc_per_node=8 --nnode=2 --node_rank=0 --master_addr=hostname1 \\
--master_port=9901 your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json`,wrap:!1}}),at=new h({props:{title:"The deepspeed launcher",local:"the-deepspeed-launcher",headingTag:"h4"}}),pt=new T({props:{code:"aG9zdG5hbWUxJTIwc2xvdHMlM0Q4JTBBaG9zdG5hbWUyJTIwc2xvdHMlM0Q4",highlighted:`hostname1 <span class="hljs-attribute">slots</span>=8
hostname2 <span class="hljs-attribute">slots</span>=8`,wrap:!1}}),ot=new T({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDglMjAtLW51bV9ub2RlcyUyMDIlMjAtLWhvc3RmaWxlJTIwaG9zdGZpbGUlMjAtLW1hc3Rlcl9hZGRyJTIwaG9zdG5hbWUxJTIwLS1tYXN0ZXJfcG9ydCUzRDk5MDElMjAlNUMlMEF5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:`deepspeed --num_gpus 8 --num_nodes 2 --hostfile hostfile --master_addr hostname1 --master_port=9901 \\
your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json`,wrap:!1}}),ct=new h({props:{title:"Launching in a SLURM environment",local:"launching-in-a-slurm-environment",headingTag:"h4"}}),yt=new T({props:{code:"JTIzU0JBVENIJTIwLS1qb2ItbmFtZSUzRHRlc3Qtbm9kZXMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBuYW1lJTBBJTIzU0JBVENIJTIwLS1ub2RlcyUzRDIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBub2RlcyUwQSUyM1NCQVRDSCUyMC0tbnRhc2tzLXBlci1ub2RlJTNEMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGNydWNpYWwlMjAtJTIwb25seSUyMDElMjB0YXNrJTIwcGVyJTIwZGlzdCUyMHBlciUyMG5vZGUhJTBBJTIzU0JBVENIJTIwLS1jcHVzLXBlci10YXNrJTNEMTAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBudW1iZXIlMjBvZiUyMGNvcmVzJTIwcGVyJTIwdGFza3MlMEElMjNTQkFUQ0glMjAtLWdyZXMlM0RncHUlM0E4JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbnVtYmVyJTIwb2YlMjBncHVzJTBBJTIzU0JBVENIJTIwLS10aW1lJTIwMjAlM0EwMCUzQTAwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbWF4aW11bSUyMGV4ZWN1dGlvbiUyMHRpbWUlMjAoSEglM0FNTSUzQVNTKSUwQSUyM1NCQVRDSCUyMC0tb3V0cHV0JTNEJTI1eC0lMjVqLm91dCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG91dHB1dCUyMGZpbGUlMjBuYW1lJTBBJTBBZXhwb3J0JTIwR1BVU19QRVJfTk9ERSUzRDglMEFleHBvcnQlMjBNQVNURVJfQUREUiUzRCUyNChzY29udHJvbCUyMHNob3clMjBob3N0bmFtZXMlMjAlMjRTTFVSTV9KT0JfTk9ERUxJU1QlMjAlN0MlMjBoZWFkJTIwLW4lMjAxKSUwQWV4cG9ydCUyME1BU1RFUl9QT1JUJTNEOTkwMSUwQSUwQXNydW4lMjAtLWpvYmlkJTIwJTI0U0xVUk1fSk9CSUQlMjBiYXNoJTIwLWMlMjAncHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5ydW4lMjAlNUMlMEElMjAtLW5wcm9jX3Blcl9ub2RlJTIwJTI0R1BVU19QRVJfTk9ERSUyMC0tbm5vZGVzJTIwJTI0U0xVUk1fTk5PREVTJTIwLS1ub2RlX3JhbmslMjAlMjRTTFVSTV9QUk9DSUQlMjAlNUMlMEElMjAtLW1hc3Rlcl9hZGRyJTIwJTI0TUFTVEVSX0FERFIlMjAtLW1hc3Rlcl9wb3J0JTIwJTI0TUFTVEVSX1BPUlQlMjAlNUMlMEF5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29uJw==",highlighted:`<span class="hljs-comment">#SBATCH --job-name=test-nodes        # name</span>
<span class="hljs-comment">#SBATCH --nodes=2                    # nodes</span>
<span class="hljs-comment">#SBATCH --ntasks-per-node=1          # crucial - only 1 task per dist per node!</span>
<span class="hljs-comment">#SBATCH --cpus-per-task=10           # number of cores per tasks</span>
<span class="hljs-comment">#SBATCH --gres=gpu:8                 # number of gpus</span>
<span class="hljs-comment">#SBATCH --time 20:00:00              # maximum execution time (HH:MM:SS)</span>
<span class="hljs-comment">#SBATCH --output=%x-%j.out           # output file name</span>

<span class="hljs-built_in">export</span> GPUS_PER_NODE=8
<span class="hljs-built_in">export</span> MASTER_ADDR=$(scontrol show hostnames <span class="hljs-variable">$SLURM_JOB_NODELIST</span> | <span class="hljs-built_in">head</span> -n 1)
<span class="hljs-built_in">export</span> MASTER_PORT=9901

srun --jobid <span class="hljs-variable">$SLURM_JOBID</span> bash -c <span class="hljs-string">&#x27;python -m torch.distributed.run \\
 --nproc_per_node $GPUS_PER_NODE --nnodes $SLURM_NNODES --node_rank $SLURM_PROCID \\
 --master_addr $MASTER_ADDR --master_port $MASTER_PORT \\
your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json&#x27;</span>`,wrap:!1}}),Tt=new T({props:{code:"c2JhdGNoJTIwbGF1bmNoLnNsdXJt",highlighted:"sbatch launch.slurm",wrap:!1}}),Jt=new h({props:{title:"Use of Non-shared filesystem",local:"use-of-non-shared-filesystem",headingTag:"h4"}}),wt=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyY2hlY2twb2ludCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnVzZV9ub2RlX2xvY2FsX3N0b3JhZ2UlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;checkpoint&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;use_node_local_storage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),mt=new h({props:{title:"Deployment in Notebooks",local:"deployment-in-notebooks",headingTag:"h3"}}),Ct=new T({props:{code:"JTIzJTIwRGVlcFNwZWVkJTIwcmVxdWlyZXMlMjBhJTIwZGlzdHJpYnV0ZWQlMjBlbnZpcm9ubWVudCUyMGV2ZW4lMjB3aGVuJTIwb25seSUyMG9uZSUyMHByb2Nlc3MlMjBpcyUyMHVzZWQuJTBBJTIzJTIwVGhpcyUyMGVtdWxhdGVzJTIwYSUyMGxhdW5jaGVyJTIwaW4lMjB0aGUlMjBub3RlYm9vayUwQWltcG9ydCUyMG9zJTBBJTBBb3MuZW52aXJvbiU1QiUyMk1BU1RFUl9BRERSJTIyJTVEJTIwJTNEJTIwJTIybG9jYWxob3N0JTIyJTBBb3MuZW52aXJvbiU1QiUyMk1BU1RFUl9QT1JUJTIyJTVEJTIwJTNEJTIwJTIyOTk5NCUyMiUyMCUyMCUyMyUyMG1vZGlmeSUyMGlmJTIwUnVudGltZUVycm9yJTNBJTIwQWRkcmVzcyUyMGFscmVhZHklMjBpbiUyMHVzZSUwQW9zLmVudmlyb24lNUIlMjJSQU5LJTIyJTVEJTIwJTNEJTIwJTIyMCUyMiUwQW9zLmVudmlyb24lNUIlMjJMT0NBTF9SQU5LJTIyJTVEJTIwJTNEJTIwJTIyMCUyMiUwQW9zLmVudmlyb24lNUIlMjJXT1JMRF9TSVpFJTIyJTVEJTIwJTNEJTIwJTIyMSUyMiUwQSUwQSUyMyUyME5vdyUyMHByb2NlZWQlMjBhcyUyMG5vcm1hbCUyQyUyMHBsdXMlMjBwYXNzJTIwdGhlJTIwZGVlcHNwZWVkJTIwY29uZmlnJTIwZmlsZSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyguLi4lMkMlMjBkZWVwc3BlZWQlM0QlMjJkc19jb25maWdfemVybzMuanNvbiUyMiklMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciguLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># DeepSpeed requires a distributed environment even when only one process is used.</span>
<span class="hljs-comment"># This emulates a launcher in the notebook</span>
<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;MASTER_ADDR&quot;</span>] = <span class="hljs-string">&quot;localhost&quot;</span>
os.environ[<span class="hljs-string">&quot;MASTER_PORT&quot;</span>] = <span class="hljs-string">&quot;9994&quot;</span>  <span class="hljs-comment"># modify if RuntimeError: Address already in use</span>
os.environ[<span class="hljs-string">&quot;RANK&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>
os.environ[<span class="hljs-string">&quot;LOCAL_RANK&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>
os.environ[<span class="hljs-string">&quot;WORLD_SIZE&quot;</span>] = <span class="hljs-string">&quot;1&quot;</span>

<span class="hljs-comment"># Now proceed as normal, plus pass the deepspeed config file</span>
training_args = TrainingArguments(..., deepspeed=<span class="hljs-string">&quot;ds_config_zero3.json&quot;</span>)
trainer = Trainer(...)
trainer.train()`,wrap:!1}}),vt=new T({props:{code:"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",highlighted:`%%bash
cat &lt;&lt;<span class="hljs-string">&#x27;EOT&#x27;</span> &gt; ds_config_zero3.json
{
    <span class="hljs-string">&quot;fp16&quot;</span>: {
        <span class="hljs-string">&quot;enabled&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;loss_scale&quot;</span>: <span class="hljs-number">0</span>,
        <span class="hljs-string">&quot;loss_scale_window&quot;</span>: <span class="hljs-number">1000</span>,
        <span class="hljs-string">&quot;initial_scale_power&quot;</span>: <span class="hljs-number">16</span>,
        <span class="hljs-string">&quot;hysteresis&quot;</span>: <span class="hljs-number">2</span>,
        <span class="hljs-string">&quot;min_loss_scale&quot;</span>: <span class="hljs-number">1</span>
    },

    <span class="hljs-string">&quot;optimizer&quot;</span>: {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;AdamW&quot;</span>,
        <span class="hljs-string">&quot;params&quot;</span>: {
            <span class="hljs-string">&quot;lr&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;betas&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;eps&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;weight_decay&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>
        }
    },

    <span class="hljs-string">&quot;scheduler&quot;</span>: {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;WarmupLR&quot;</span>,
        <span class="hljs-string">&quot;params&quot;</span>: {
            <span class="hljs-string">&quot;warmup_min_lr&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;warmup_max_lr&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;warmup_num_steps&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>
        }
    },

    <span class="hljs-string">&quot;zero_optimization&quot;</span>: {
        <span class="hljs-string">&quot;stage&quot;</span>: <span class="hljs-number">3</span>,
        <span class="hljs-string">&quot;offload_optimizer&quot;</span>: {
            <span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
            <span class="hljs-string">&quot;pin_memory&quot;</span>: true
        },
        <span class="hljs-string">&quot;offload_param&quot;</span>: {
            <span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
            <span class="hljs-string">&quot;pin_memory&quot;</span>: true
        },
        <span class="hljs-string">&quot;overlap_comm&quot;</span>: true,
        <span class="hljs-string">&quot;contiguous_gradients&quot;</span>: true,
        <span class="hljs-string">&quot;sub_group_size&quot;</span>: <span class="hljs-number">1e9</span>,
        <span class="hljs-string">&quot;reduce_bucket_size&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;stage3_prefetch_bucket_size&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;stage3_param_persistence_threshold&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;stage3_max_live_parameters&quot;</span>: <span class="hljs-number">1e9</span>,
        <span class="hljs-string">&quot;stage3_max_reuse_distance&quot;</span>: <span class="hljs-number">1e9</span>,
        <span class="hljs-string">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span>: true
    },

    <span class="hljs-string">&quot;gradient_accumulation_steps&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;gradient_clipping&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;steps_per_print&quot;</span>: <span class="hljs-number">2000</span>,
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;train_micro_batch_size_per_gpu&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;wall_clock_breakdown&quot;</span>: false
}
EOT`,wrap:!1}}),Bt=new T({props:{code:"IWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMEEhY2QlMjB0cmFuc2Zvcm1lcnMlM0IlMjBkZWVwc3BlZWQlMjBleGFtcGxlcyUyRnB5dG9yY2glMkZ0cmFuc2xhdGlvbiUyRnJ1bl90cmFuc2xhdGlvbi5weSUyMC4uLg==",highlighted:`!git clone https://github.com/huggingface/transformers
!cd transformers; deepspeed examples/pytorch/translation/run_translation.py ...`,wrap:!1}}),qt=new T({props:{code:"JTI1JTI1YmFzaCUwQSUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMEFjZCUyMHRyYW5zZm9ybWVycyUwQWRlZXBzcGVlZCUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRnRyYW5zbGF0aW9uJTJGcnVuX3RyYW5zbGF0aW9uLnB5JTIwLi4u",highlighted:`%%bash

git clone https://github.com/huggingface/transformers
cd transformers
deepspeed examples/pytorch/translation/run_translation.py ...`,wrap:!1}}),Gt=new h({props:{title:"Configuration",local:"configuration",headingTag:"h3"}}),Wt=new T({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZtaWNyb3NvZnQlMkZEZWVwU3BlZWRFeGFtcGxlcyUwQWNkJTIwRGVlcFNwZWVkRXhhbXBsZXMlMEFmaW5kJTIwLiUyMC1uYW1lJTIwJypqc29uJw==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/microsoft/DeepSpeedExamples
<span class="hljs-built_in">cd</span> DeepSpeedExamples
find . -name <span class="hljs-string">&#x27;*json&#x27;</span>`,wrap:!1}}),Rt=new T({props:{code:"Z3JlcCUyMC1pJTIwTGFtYiUyMCUyNChmaW5kJTIwLiUyMC1uYW1lJTIwJypqc29uJyk=",highlighted:'grep -i Lamb $(find . -name <span class="hljs-string">&#x27;*json&#x27;</span>)',wrap:!1}}),Et=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Vt=new h({props:{title:"Passing Configuration",local:"passing-configuration",headingTag:"h3"}}),Ft=new T({props:{code:"VHJhaW5pbmdBcmd1bWVudHMoLi4uJTJDJTIwZGVlcHNwZWVkJTNEJTIyJTJGcGF0aCUyRnRvJTJGZHNfY29uZmlnLmpzb24lMjIp",highlighted:'TrainingArguments(..., deepspeed=<span class="hljs-string">&quot;/path/to/ds_config.json&quot;</span>)',wrap:!1}}),Pt=new T({props:{code:"ZHNfY29uZmlnX2RpY3QlMjAlM0QlMjBkaWN0KHNjaGVkdWxlciUzRHNjaGVkdWxlcl9wYXJhbXMlMkMlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXJfcGFyYW1zKSUwQVRyYWluaW5nQXJndW1lbnRzKC4uLiUyQyUyMGRlZXBzcGVlZCUzRGRzX2NvbmZpZ19kaWN0KQ==",highlighted:`ds_config_dict = <span class="hljs-built_in">dict</span>(scheduler=scheduler_params, optimizer=optimizer_params)
TrainingArguments(..., deepspeed=ds_config_dict)`,wrap:!1}}),Ot=new h({props:{title:"Shared Configuration",local:"shared-configuration",headingTag:"h3"}}),G=new CJ({props:{warning:!0,$$slots:{default:[mI]},$$scope:{ctx:x}}}),pe=new h({props:{title:"ZeRO",local:"zero",headingTag:"h3"}}),ce=new h({props:{title:"ZeRO-2 Config",local:"zero-2-config",headingTag:"h4"}}),ye=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX3BhcnRpdGlvbnMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX2J1Y2tldF9zaXplJTIyJTNBJTIwNWU4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlZHVjZV9zY2F0dGVyJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlZHVjZV9idWNrZXRfc2l6ZSUyMiUzQSUyMDVlOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRpZ3VvdXNfZ3JhZGllbnRzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Je=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb3VuZF9yb2Jpbl9ncmFkaWVudHMlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;round_robin_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),we=new h({props:{title:"ZeRO-3 Config",local:"zero-3-config",headingTag:"h4"}}),me=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2ZmbG9hZF9wYXJhbSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRpZ3VvdXNfZ3JhZGllbnRzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN1Yl9ncm91cF9zaXplJTIyJTNBJTIwMWU5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVkdWNlX2J1Y2tldF9zaXplJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlM19wcmVmZXRjaF9idWNrZXRfc2l6ZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfcGFyYW1fcGVyc2lzdGVuY2VfdGhyZXNob2xkJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlM19tYXhfbGl2ZV9wYXJhbWV0ZXJzJTIyJTNBJTIwMWU5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhZ2UzX21heF9yZXVzZV9kaXN0YW5jZSUyMiUzQSUyMDFlOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlM19nYXRoZXJfMTZiaXRfd2VpZ2h0c19vbl9tb2RlbF9zYXZlJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ze=new h({props:{title:"ZeRO-0 Config",local:"zero-0-config",headingTag:"h4"}}),Re=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDAlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Xe=new h({props:{title:"ZeRO-1 Config",local:"zero-1-config",headingTag:"h4"}}),Ee=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDElMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),He=new h({props:{title:"NVMe Support",local:"nvme-support",headingTag:"h3"}}),Le=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;nvme_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/local_nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;buffer_count&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;fast_init&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;nvme_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/local_nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;buffer_count&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;buffer_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e8</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;max_in_cpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;aio&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;block_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">262144</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;queue_depth&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">32</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;thread_count&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;single_submit&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;overlap_events&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ke=new h({props:{title:"ZeRO-2 vs ZeRO-3 Performance",local:"zero-2-vs-zero-3-performance",headingTag:"h4"}}),al=new h({props:{title:"ZeRO-2 Example",local:"zero-2-example",headingTag:"h4"}}),pl=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ol=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.8</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.999</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-8</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-7</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">500</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ml=new h({props:{title:"ZeRO-3 Example",local:"zero-3-example",headingTag:"h4"}}),cl=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),yl=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.8</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.999</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-8</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-7</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">500</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e6</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.94e6</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e4</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),jl=new h({props:{title:"How to Choose Which ZeRO Stage and Offloads To Use For Best Performance",local:"how-to-choose-which-zero-stage-and-offloads-to-use-for-best-performance",headingTag:"h4"}}),ql=new h({props:{title:"Activation Checkpointing or Gradient Checkpointing",local:"activation-checkpointing-or-gradient-checkpointing",headingTag:"h3"}}),Wl=new h({props:{title:"Optimizer and Scheduler",local:"optimizer-and-scheduler",headingTag:"h3"}}),Nl=new h({props:{title:"Optimizer",local:"optimizer",headingTag:"h4"}}),Hl=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyb3B0aW1pemVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMkFkYW1XJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybHIlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmV0YXMlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndlaWdodF9kZWNheSUyMiUzQSUyMCUyMmF1dG8lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
       <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
       <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
       <span class="hljs-punctuation">}</span>
   <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Dl=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyb3B0aW1pemVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMkFkYW1XJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybHIlMjIlM0ElMjAwLjAwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmJldGFzJTIyJTNBJTIwJTVCMC44JTJDJTIwMC45OTklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlcHMlMjIlM0ElMjAxZS04JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2VpZ2h0X2RlY2F5JTIyJTNBJTIwM2UtNyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
       <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
       <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.001</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.8</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.999</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-8</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-7</span>
       <span class="hljs-punctuation">}</span>
   <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Kl=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyemVyb19hbGxvd191bnRlc3RlZF9vcHRpbWl6ZXIlMjIlM0ElMjB0cnVlJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;zero_allow_untested_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ea=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyemVyb19mb3JjZV9kc19jcHVfb3B0aW1pemVyJTIyJTNBJTIwZmFsc2UlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;zero_force_ds_cpu_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),aa=new h({props:{title:"Scheduler",local:"scheduler",headingTag:"h4"}}),ua=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMldhcm11cExSJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX21pbl9sciUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbWF4X2xyJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndhcm11cF9udW1fc3RlcHMlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
             <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
         <span class="hljs-punctuation">}</span>
     <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ja=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMldhcm11cExSJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX21pbl9sciUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbWF4X2xyJTIyJTNBJTIwMC4wMDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbnVtX3N0ZXBzJTIyJTNBJTIwMTAwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
             <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.001</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span>
         <span class="hljs-punctuation">}</span>
     <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ja=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMldhcm11cERlY2F5TFIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYXJhbXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYXN0X2JhdGNoX2l0ZXJhdGlvbiUyMiUzQSUyMC0xJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG90YWxfbnVtX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndhcm11cF9taW5fbHIlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX21heF9sciUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbnVtX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupDecayLR&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
             <span class="hljs-attr">&quot;last_batch_iteration&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">-1</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;total_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
         <span class="hljs-punctuation">}</span>
     <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),wa=new h({props:{title:"fp32 Precision",local:"fp32-precision",headingTag:"h3"}}),fa=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ba=new h({props:{title:"Automatic Mixed Precision",local:"automatic-mixed-precision",headingTag:"h3"}}),ga=new h({props:{title:"fp16",local:"fp16",headingTag:"h3"}}),_a=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9zc19zY2FsZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlX3dpbmRvdyUyMiUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbml0aWFsX3NjYWxlX3Bvd2VyJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoeXN0ZXJlc2lzJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbl9sb3NzX3NjYWxlJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$a=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9zc19zY2FsZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlX3dpbmRvdyUyMiUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbml0aWFsX3NjYWxlX3Bvd2VyJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoeXN0ZXJlc2lzJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbl9sb3NzX3NjYWxlJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Sa=new h({props:{title:"bf16",local:"bf16",headingTag:"h3"}}),Wa=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Xa=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),S=new CJ({props:{$$slots:{default:[fI]},$$scope:{ctx:x}}}),Qa=new h({props:{title:"NCCL Collectives",local:"nccl-collectives",headingTag:"h3"}}),La=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyY29tbXVuaWNhdGlvbl9kYXRhX3R5cGUlMjIlM0ElMjAlMjJmcDMyJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;communication_data_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;fp32&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Pa=new h({props:{title:"apex",local:"apex",headingTag:"h3"}}),Ka=new T({props:{code:"JTIyYW1wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZW5hYmxlZCUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJvcHRfbGV2ZWwlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTdE",highlighted:`<span class="hljs-attr">&quot;amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;opt_level&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ln=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYW1wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW5hYmxlZCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvcHRfbGV2ZWwlMjIlM0ElMjAlMjJPMSUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;opt_level&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;O1&quot;</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),pn=new h({props:{title:"Batch Size",local:"batch-size",headingTag:"h3"}}),Mn=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fYmF0Y2hfc2l6ZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFpbl9taWNyb19iYXRjaF9zaXplX3Blcl9ncHUlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),rn=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fYmF0Y2hfc2l6ZSUyMiUzQSUyMDEyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JTIyJTNBJTIwNCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">12</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),jn=new h({props:{title:"Gradient Accumulation",local:"gradient-accumulation",headingTag:"h3"}}),hn=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),wn=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIyJTNBJTIwMyUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),mn=new h({props:{title:"Gradient Clipping",local:"gradient-clipping",headingTag:"h3"}}),In=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfY2xpcHBpbmclMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),An=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfY2xpcHBpbmclMjIlM0ElMjAxLjAlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.0</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),vn=new h({props:{title:"Getting The Model Weights Out",local:"getting-the-model-weights-out",headingTag:"h3"}}),$n=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),kn=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50cmFpbmVyX3V0aWxzJTIwaW1wb3J0JTIwZ2V0X2xhc3RfY2hlY2twb2ludCUwQWZyb20lMjBkZWVwc3BlZWQudXRpbHMuemVyb190b19mcDMyJTIwaW1wb3J0JTIwbG9hZF9zdGF0ZV9kaWN0X2Zyb21femVyb19jaGVja3BvaW50JTBBJTBBY2hlY2twb2ludF9kaXIlMjAlM0QlMjBnZXRfbGFzdF9jaGVja3BvaW50KHRyYWluZXIuYXJncy5vdXRwdXRfZGlyKSUwQWZwMzJfbW9kZWwlMjAlM0QlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQodHJhaW5lci5tb2RlbCUyQyUyMGNoZWNrcG9pbnRfZGlyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.trainer_utils <span class="hljs-keyword">import</span> get_last_checkpoint
<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> load_state_dict_from_zero_checkpoint

checkpoint_dir = get_last_checkpoint(trainer.args.output_dir)
fp32_model = load_state_dict_from_zero_checkpoint(trainer.model, checkpoint_dir)`,wrap:!1}}),Nn=new T({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQlMEElMEFjaGVja3BvaW50X2RpciUyMCUzRCUyMG9zLnBhdGguam9pbih0cmFpbmVyLmFyZ3Mub3V0cHV0X2RpciUyQyUyMCUyMmNoZWNrcG9pbnQtZmluYWwlMjIpJTBBdHJhaW5lci5kZWVwc3BlZWQuc2F2ZV9jaGVja3BvaW50KGNoZWNrcG9pbnRfZGlyKSUwQWZwMzJfbW9kZWwlMjAlM0QlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQodHJhaW5lci5tb2RlbCUyQyUyMGNoZWNrcG9pbnRfZGlyKQ==",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> load_state_dict_from_zero_checkpoint

checkpoint_dir = os.path.join(trainer.args.output_dir, <span class="hljs-string">&quot;checkpoint-final&quot;</span>)
trainer.deepspeed.save_checkpoint(checkpoint_dir)
fp32_model = load_state_dict_from_zero_checkpoint(trainer.model, checkpoint_dir)`,wrap:!1}}),z=new CJ({props:{$$slots:{default:[II]},$$scope:{ctx:x}}}),En=new T({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBnZXRfZnAzMl9zdGF0ZV9kaWN0X2Zyb21femVyb19jaGVja3BvaW50JTBBJTBBc3RhdGVfZGljdCUyMCUzRCUyMGdldF9mcDMyX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQoY2hlY2twb2ludF9kaXIpJTIwJTIwJTIzJTIwYWxyZWFkeSUyMG9uJTIwY3B1JTBBbW9kZWwlMjAlM0QlMjBtb2RlbC5jcHUoKSUwQW1vZGVsLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0KQ==",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> get_fp32_state_dict_from_zero_checkpoint

state_dict = get_fp32_state_dict_from_zero_checkpoint(checkpoint_dir)  <span class="hljs-comment"># already on cpu</span>
model = model.cpu()
model.load_state_dict(state_dict)`,wrap:!1}}),Ln=new T({props:{code:"JTI0JTIwbHMlMjAtbCUyMG91dHB1dF9kaXIlMkZjaGVja3BvaW50LTElMkYlMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwMS40SyUyME1hciUyMDI3JTIwMjAlM0E0MiUyMGNvbmZpZy5qc29uJTBBZHJ3eHJ3eHIteCUyMDIlMjBzdGFzJTIwc3RhcyUyMDQuMEslMjBNYXIlMjAyNSUyMDE5JTNBNTIlMjBnbG9iYWxfc3RlcDElMkYlMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwJTIwJTIwMTIlMjBNYXIlMjAyNyUyMDEzJTNBMTYlMjBsYXRlc3QlMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwODI3SyUyME1hciUyMDI3JTIwMjAlM0E0MiUyMG9wdGltaXplci5wdCUwQS1ydy1ydy1yLS0lMjAxJTIwc3RhcyUyMHN0YXMlMjAyMzFNJTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwcHl0b3JjaF9tb2RlbC5iaW4lMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwJTIwNjIzJTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwc2NoZWR1bGVyLnB0JTBBLXJ3LXJ3LXItLSUyMDElMjBzdGFzJTIwc3RhcyUyMDEuOEslMjBNYXIlMjAyNyUyMDIwJTNBNDIlMjBzcGVjaWFsX3Rva2Vuc19tYXAuanNvbiUwQS1ydy1ydy1yLS0lMjAxJTIwc3RhcyUyMHN0YXMlMjA3NzRLJTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwc3BpZWNlLm1vZGVsJTBBLXJ3LXJ3LXItLSUyMDElMjBzdGFzJTIwc3RhcyUyMDEuOUslMjBNYXIlMjAyNyUyMDIwJTNBNDIlMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwJTIwMzM5JTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwdHJhaW5lcl9zdGF0ZS5qc29uJTBBLXJ3LXJ3LXItLSUyMDElMjBzdGFzJTIwc3RhcyUyMDIuM0slMjBNYXIlMjAyNyUyMDIwJTNBNDIlMjB0cmFpbmluZ19hcmdzLmJpbiUwQS1yd3hydy1yLS0lMjAxJTIwc3RhcyUyMHN0YXMlMjA1LjVLJTIwTWFyJTIwMjclMjAxMyUzQTE2JTIwemVyb190b19mcDMyLnB5Kg==",highlighted:`$ <span class="hljs-built_in">ls</span> -l output_dir/checkpoint-1/
-rw-rw-r-- 1 stas stas 1.4K Mar 27 20:42 config.json
drwxrwxr-x 2 stas stas 4.0K Mar 25 19:52 global_step1/
-rw-rw-r-- 1 stas stas   12 Mar 27 13:16 latest
-rw-rw-r-- 1 stas stas 827K Mar 27 20:42 optimizer.pt
-rw-rw-r-- 1 stas stas 231M Mar 27 20:42 pytorch_model.bin
-rw-rw-r-- 1 stas stas  623 Mar 27 20:42 scheduler.pt
-rw-rw-r-- 1 stas stas 1.8K Mar 27 20:42 special_tokens_map.json
-rw-rw-r-- 1 stas stas 774K Mar 27 20:42 spiece.model
-rw-rw-r-- 1 stas stas 1.9K Mar 27 20:42 tokenizer_config.json
-rw-rw-r-- 1 stas stas  339 Mar 27 20:42 trainer_state.json
-rw-rw-r-- 1 stas stas 2.3K Mar 27 20:42 training_args.bin
-rwxrw-r-- 1 stas stas 5.5K Mar 27 13:16 zero_to_fp32.py*`,wrap:!1}}),Dn=new T({props:{code:"cHl0aG9uJTIwemVyb190b19mcDMyLnB5JTIwLiUyMHB5dG9yY2hfbW9kZWwuYmlu",highlighted:"python zero_to_fp32.py . pytorch_model.bin",wrap:!1}}),ep=new h({props:{title:"ZeRO-3 and Infinity Nuances",local:"zero-3-and-infinity-nuances",headingTag:"h3"}}),pp=new h({props:{title:"Constructing Massive Models",local:"constructing-massive-models",headingTag:"h4"}}),op=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwVDVDb25maWclMEFpbXBvcnQlMjBkZWVwc3BlZWQlMEElMEF3aXRoJTIwZGVlcHNwZWVkLnplcm8uSW5pdCgpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnJTIwJTNEJTIwVDVDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5ForConditionalGeneration, T5Config
<span class="hljs-keyword">import</span> deepspeed

<span class="hljs-keyword">with</span> deepspeed.zero.Init():
    config = T5Config.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
    model = T5ForConditionalGeneration(config)`,wrap:!1}}),cp=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMFRyYWluZXIlMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyguLi4lMkMlMjBkZWVwc3BlZWQlM0Rkc19jb25maWcpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, Trainer, TrainingArguments

training_args = TrainingArguments(..., deepspeed=ds_config)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
trainer = Trainer(model=model, args=training_args, ...)`,wrap:!1}}),hp=new h({props:{title:"Gathering Parameters",local:"gathering-parameters",headingTag:"h4"}}),dp=new T({props:{code:"dGVuc29yKCU1QjEuMCU1RCUyQyUyMGRldmljZSUzRCUyMmN1ZGElM0EwJTIyJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwcmVxdWlyZXNfZ3JhZCUzRFRydWUp",highlighted:'tensor([<span class="hljs-number">1.0</span>], device=<span class="hljs-string">&quot;cuda:0&quot;</span>, dtype=torch.float16, requires_grad=<span class="hljs-literal">True</span>)',wrap:!1}}),fp=new h({props:{title:"ZeRO Inference",local:"zero-inference",headingTag:"h3"}}),bp=new T({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUzRDIlMjB5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRvX2V2YWwlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:"deepspeed --num_gpus=2 your_program.py &lt;normal cl args&gt; --do_eval --deepspeed ds_config.json",wrap:!1}}),vp=new T({props:{code:"ZGVlcHNwZWVkJTIwZXhhbXBsZXMlMkZweXRvcmNoJTJGdHJhbnNsYXRpb24lMkZydW5fdHJhbnNsYXRpb24ucHklMjAlNUMlMEEtLWRlZXBzcGVlZCUyMHRlc3RzJTJGZGVlcHNwZWVkJTJGZHNfY29uZmlnX3plcm8zLmpzb24lMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMHQ1LXNtYWxsJTIwLS1vdXRwdXRfZGlyJTIwb3V0cHV0X2RpciUyMCU1QyUwQS0tZG9fZXZhbCUyMC0tbWF4X2V2YWxfc2FtcGxlcyUyMDUwJTIwLS13YXJtdXBfc3RlcHMlMjA1MCUyMCUyMCU1QyUwQS0tbWF4X3NvdXJjZV9sZW5ndGglMjAxMjglMjAtLXZhbF9tYXhfdGFyZ2V0X2xlbmd0aCUyMDEyOCUyMCU1QyUwQS0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjAtLXBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTIwNCUyMCU1QyUwQS0tcHJlZGljdF93aXRoX2dlbmVyYXRlJTIwLS1kYXRhc2V0X2NvbmZpZyUyMCUyMnJvLWVuJTIyJTIwLS1mcDE2JTIwJTVDJTBBLS1zb3VyY2VfbGFuZyUyMGVuJTIwLS10YXJnZXRfbGFuZyUyMHJvJTIwLS1kYXRhc2V0X25hbWUlMjB3bXQxNiUyMCU1QyUwQS0tc291cmNlX3ByZWZpeCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMFJvbWFuaWFuJTNBJTIwJTIy",highlighted:`deepspeed examples/pytorch/translation/run_translation.py \\
--deepspeed tests/deepspeed/ds_config_zero3.json \\
--model_name_or_path t5-small --output_dir output_dir \\
--do_eval --max_eval_samples 50 --warmup_steps 50  \\
--max_source_length 128 --val_max_target_length 128 \\
--overwrite_output_dir --per_device_eval_batch_size 4 \\
--predict_with_generate --dataset_config <span class="hljs-string">&quot;ro-en&quot;</span> --fp16 \\
--source_lang en --target_lang ro --dataset_name wmt16 \\
--source_prefix <span class="hljs-string">&quot;translate English to Romanian: &quot;</span>`,wrap:!1}}),Zp=new h({props:{title:"Memory Requirements",local:"memory-requirements",headingTag:"h3"}}),xp=new T({props:{code:"JTI0JTIwcHl0aG9uJTIwLWMlMjAnZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUzQiUyMCU1QyUwQWZyb20lMjBkZWVwc3BlZWQucnVudGltZS56ZXJvLnN0YWdlMyUyMGltcG9ydCUyMGVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUlM0IlMjAlNUMlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRlQwXzNCJTIyKSUzQiUyMCU1QyUwQWVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUobW9kZWwlMkMlMjBudW1fZ3B1c19wZXJfbm9kZSUzRDElMkMlMjBudW1fbm9kZXMlM0QxKSclMEElNUIuLi4lNUQlMEFFc3RpbWF0ZWQlMjBtZW1vcnklMjBuZWVkZWQlMjBmb3IlMjBwYXJhbXMlMkMlMjBvcHRpbSUyMHN0YXRlcyUyMGFuZCUyMGdyYWRpZW50cyUyMGZvciUyMGElM0ElMEFIVyUzQSUyMFNldHVwJTIwd2l0aCUyMDElMjBub2RlJTJDJTIwMSUyMEdQVSUyMHBlciUyMG5vZGUuJTBBU1clM0ElMjBNb2RlbCUyMHdpdGglMjAyNzgzTSUyMHRvdGFsJTIwcGFyYW1zJTJDJTIwNjVNJTIwbGFyZ2VzdCUyMGxheWVyJTIwcGFyYW1zLiUwQSUyMCUyMHBlciUyMENQVSUyMCUyMCU3QyUyMCUyMHBlciUyMEdQVSUyMCU3QyUyMCUyMCUyME9wdGlvbnMlMEElMjAlMjAlMjA3MC4wMEdCJTIwJTdDJTIwJTIwJTIwMC4yNUdCJTIwJTdDJTIwb2ZmbG9hZF9wYXJhbSUzRGNwdSUyMCUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMSUwQSUyMCUyMCUyMDcwLjAwR0IlMjAlN0MlMjAlMjAlMjAwLjI1R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEY3B1JTIwJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0RjcHUlMjAlMkMlMjB6ZXJvX2luaXQlM0QwJTBBJTIwJTIwJTIwNjIuMjNHQiUyMCU3QyUyMCUyMCUyMDUuNDNHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0RjcHUlMjAlMkMlMjB6ZXJvX2luaXQlM0QxJTBBJTIwJTIwJTIwNjIuMjNHQiUyMCU3QyUyMCUyMCUyMDUuNDNHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0RjcHUlMjAlMkMlMjB6ZXJvX2luaXQlM0QwJTBBJTIwJTIwJTIwJTIwMC4zN0dCJTIwJTdDJTIwJTIwNDYuOTFHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0Rub25lJTJDJTIwemVyb19pbml0JTNEMSUwQSUyMCUyMCUyMDE1LjU2R0IlMjAlN0MlMjAlMjA0Ni45MUdCJTIwJTdDJTIwb2ZmbG9hZF9wYXJhbSUzRG5vbmUlMkMlMjBvZmZsb2FkX29wdGltaXplciUzRG5vbmUlMkMlMjB6ZXJvX2luaXQlM0Qw",highlighted:`$ python -c <span class="hljs-string">&#x27;from transformers import AutoModel; \\
from deepspeed.runtime.zero.stage3 import estimate_zero3_model_states_mem_needs_all_live; \\
model = AutoModel.from_pretrained(&quot;bigscience/T0_3B&quot;); \\
estimate_zero3_model_states_mem_needs_all_live(model, num_gpus_per_node=1, num_nodes=1)&#x27;</span>
[...]
Estimated memory needed <span class="hljs-keyword">for</span> params, optim states and gradients <span class="hljs-keyword">for</span> a:
HW: Setup with 1 node, 1 GPU per node.
SW: Model with 2783M total params, 65M largest layer params.
  per CPU  |  per GPU |   Options
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=1
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=0
   62.23GB |   5.43GB | offload_param=none, offload_optimizer=cpu , zero_init=1
   62.23GB |   5.43GB | offload_param=none, offload_optimizer=cpu , zero_init=0
    0.37GB |  46.91GB | offload_param=none, offload_optimizer=none, zero_init=1
   15.56GB |  46.91GB | offload_param=none, offload_optimizer=none, zero_init=0`,wrap:!1}}),kp=new T({props:{code:"JTI0JTIwcHl0aG9uJTIwLWMlMjAnZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUzQiUyMCU1QyUwQWZyb20lMjBkZWVwc3BlZWQucnVudGltZS56ZXJvLnN0YWdlMyUyMGltcG9ydCUyMGVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUlM0IlMjAlNUMlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRlQwXzNCJTIyKSUzQiUyMCU1QyUwQWVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUobW9kZWwlMkMlMjBudW1fZ3B1c19wZXJfbm9kZSUzRDIlMkMlMjBudW1fbm9kZXMlM0QxKSclMEElNUIuLi4lNUQlMEFFc3RpbWF0ZWQlMjBtZW1vcnklMjBuZWVkZWQlMjBmb3IlMjBwYXJhbXMlMkMlMjBvcHRpbSUyMHN0YXRlcyUyMGFuZCUyMGdyYWRpZW50cyUyMGZvciUyMGElM0ElMEFIVyUzQSUyMFNldHVwJTIwd2l0aCUyMDElMjBub2RlJTJDJTIwMiUyMEdQVXMlMjBwZXIlMjBub2RlLiUwQVNXJTNBJTIwTW9kZWwlMjB3aXRoJTIwMjc4M00lMjB0b3RhbCUyMHBhcmFtcyUyQyUyMDY1TSUyMGxhcmdlc3QlMjBsYXllciUyMHBhcmFtcy4lMEElMjAlMjBwZXIlMjBDUFUlMjAlMjAlN0MlMjAlMjBwZXIlMjBHUFUlMjAlN0MlMjAlMjAlMjBPcHRpb25zJTBBJTIwJTIwJTIwNzAuMDBHQiUyMCU3QyUyMCUyMCUyMDAuMjVHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0RjcHUlMjAlMkMlMjBvZmZsb2FkX29wdGltaXplciUzRGNwdSUyMCUyQyUyMHplcm9faW5pdCUzRDElMEElMjAlMjAlMjA3MC4wMEdCJTIwJTdDJTIwJTIwJTIwMC4yNUdCJTIwJTdDJTIwb2ZmbG9hZF9wYXJhbSUzRGNwdSUyMCUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMCUwQSUyMCUyMCUyMDYyLjIzR0IlMjAlN0MlMjAlMjAlMjAyLjg0R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEbm9uZSUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMSUwQSUyMCUyMCUyMDYyLjIzR0IlMjAlN0MlMjAlMjAlMjAyLjg0R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEbm9uZSUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMCUwQSUyMCUyMCUyMCUyMDAuNzRHQiUyMCU3QyUyMCUyMDIzLjU4R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEbm9uZSUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEbm9uZSUyQyUyMHplcm9faW5pdCUzRDElMEElMjAlMjAlMjAzMS4xMUdCJTIwJTdDJTIwJTIwMjMuNThHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0Rub25lJTJDJTIwemVyb19pbml0JTNEMCUwQQ==",highlighted:`$ python -c <span class="hljs-string">&#x27;from transformers import AutoModel; \\
from deepspeed.runtime.zero.stage3 import estimate_zero3_model_states_mem_needs_all_live; \\
model = AutoModel.from_pretrained(&quot;bigscience/T0_3B&quot;); \\
estimate_zero3_model_states_mem_needs_all_live(model, num_gpus_per_node=2, num_nodes=1)&#x27;</span>
[...]
Estimated memory needed <span class="hljs-keyword">for</span> params, optim states and gradients <span class="hljs-keyword">for</span> a:
HW: Setup with 1 node, 2 GPUs per node.
SW: Model with 2783M total params, 65M largest layer params.
  per CPU  |  per GPU |   Options
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=1
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=0
   62.23GB |   2.84GB | offload_param=none, offload_optimizer=cpu , zero_init=1
   62.23GB |   2.84GB | offload_param=none, offload_optimizer=cpu , zero_init=0
    0.74GB |  23.58GB | offload_param=none, offload_optimizer=none, zero_init=1
   31.11GB |  23.58GB | offload_param=none, offload_optimizer=none, zero_init=0
`,wrap:!1}}),Xp=new h({props:{title:"Filing Issues",local:"filing-issues",headingTag:"h3"}}),Vp=new T({props:{code:"cHl0aG9uJTIwLWMlMjAnaW1wb3J0JTIwdG9yY2glM0IlMjBwcmludChmJTIydG9yY2glM0ElMjAlN0J0b3JjaC5fX3ZlcnNpb25fXyU3RCUyMiknJTBBcHl0aG9uJTIwLWMlMjAnaW1wb3J0JTIwdHJhbnNmb3JtZXJzJTNCJTIwcHJpbnQoZiUyMnRyYW5zZm9ybWVycyUzQSUyMCU3QnRyYW5zZm9ybWVycy5fX3ZlcnNpb25fXyU3RCUyMiknJTBBcHl0aG9uJTIwLWMlMjAnaW1wb3J0JTIwZGVlcHNwZWVkJTNCJTIwcHJpbnQoZiUyMmRlZXBzcGVlZCUzQSUyMCU3QmRlZXBzcGVlZC5fX3ZlcnNpb25fXyU3RCUyMikn",highlighted:`python -c <span class="hljs-string">&#x27;import torch; print(f&quot;torch: {torch.__version__}&quot;)&#x27;</span>
python -c <span class="hljs-string">&#x27;import transformers; print(f&quot;transformers: {transformers.__version__}&quot;)&#x27;</span>
python -c <span class="hljs-string">&#x27;import deepspeed; print(f&quot;deepspeed: {deepspeed.__version__}&quot;)&#x27;</span>`,wrap:!1}}),Fp=new h({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h3"}}),Dp=new h({props:{title:"the deepspeed process gets killed at startup without a traceback",local:"the-deepspeed-process-gets-killed-at-startup-without-a-traceback",headingTag:"h4"}}),Op=new h({props:{title:"training and/or eval/predict loss is NaN",local:"training-andor-evalpredict-loss-is-nan",headingTag:"h4"}}),ti=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9zc19zY2FsZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlX3dpbmRvdyUyMiUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbml0aWFsX3NjYWxlX3Bvd2VyJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoeXN0ZXJlc2lzJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbl9sb3NzX3NjYWxlJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),li=new T({props:{code:"MCUyNSU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDAlMkYxODklMjAlNUIwMCUzQTAwJTNDJTNGJTJDJTIwJTNGaXQlMkZzJTVEJTBBJTIwJTVCZGVlcHNjYWxlJTVEJTIwT1ZFUkZMT1chJTIwUmFuayUyMDAlMjBTa2lwcGluZyUyMHN0ZXAuJTIwQXR0ZW1wdGVkJTIwbG9zcyUyMHNjYWxlJTNBJTIwMjYyMTQ0JTJDJTIwcmVkdWNpbmclMjB0byUyMDI2MjE0NCUwQSUyMCUyMDElMjUlN0MlRTIlOTYlOEMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAxJTJGMTg5JTIwJTVCMDAlM0EwMCUzQzAxJTNBMjYlMkMlMjAlMjAyLjE3aXQlMkZzJTVEJTBBJTIwJTVCZGVlcHNjYWxlJTVEJTIwT1ZFUkZMT1chJTIwUmFuayUyMDAlMjBTa2lwcGluZyUyMHN0ZXAuJTIwQXR0ZW1wdGVkJTIwbG9zcyUyMHNjYWxlJTNBJTIwMjYyMTQ0JTJDJTIwcmVkdWNpbmclMjB0byUyMDEzMTA3Mi4wJTBBJTIwJTIwMSUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4RiUwQSUyMCU1Qi4uLiU1RCUwQSUyMCU1QmRlZXBzY2FsZSU1RCUyME9WRVJGTE9XISUyMFJhbmslMjAwJTIwU2tpcHBpbmclMjBzdGVwLiUyMEF0dGVtcHRlZCUyMGxvc3MlMjBzY2FsZSUzQSUyMDElMkMlMjByZWR1Y2luZyUyMHRvJTIwMSUwQSUyMDE0JTI1JTdDJUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JThDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMjclMkYxODklMjAlNUIwMCUzQTE0JTNDMDElM0ExMyUyQyUyMCUyMDIuMjFpdCUyRnMlNUQlMEElMjAlNUJkZWVwc2NhbGUlNUQlMjBPVkVSRkxPVyElMjBSYW5rJTIwMCUyMFNraXBwaW5nJTIwc3RlcC4lMjBBdHRlbXB0ZWQlMjBsb3NzJTIwc2NhbGUlM0ElMjAxJTJDJTIwcmVkdWNpbmclMjB0byUyMDElMEElMjAxNSUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4RiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDI4JTJGMTg5JTIwJTVCMDAlM0ExNCUzQzAxJTNBMTMlMkMlMjAlMjAyLjE4aXQlMkZzJTVEJTBBJTIwJTVCZGVlcHNjYWxlJTVEJTIwT1ZFUkZMT1chJTIwUmFuayUyMDAlMjBTa2lwcGluZyUyMHN0ZXAuJTIwQXR0ZW1wdGVkJTIwbG9zcyUyMHNjYWxlJTNBJTIwMSUyQyUyMHJlZHVjaW5nJTIwdG8lMjAxJTBBJTIwMTUlMjUlN0MlRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlOEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAyOSUyRjE4OSUyMCU1QjAwJTNBMTUlM0MwMSUzQTEzJTJDJTIwJTIwMi4xOGl0JTJGcyU1RCUwQSUyMCU1QmRlZXBzY2FsZSU1RCUyME9WRVJGTE9XISUyMFJhbmslMjAwJTIwU2tpcHBpbmclMjBzdGVwLiUyMEF0dGVtcHRlZCUyMGxvc3MlMjBzY2FsZSUzQSUyMDElMkMlMjByZWR1Y2luZyUyMHRvJTIwMSUwQSU1Qi4uLiU1RA==",highlighted:`<span class="hljs-number">0</span><span class="hljs-comment">%|                                                                                                                             | 0/189 [00:00&lt;?, ?it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">262144</span>, reducing to <span class="hljs-number">262144</span>
  <span class="hljs-number">1</span><span class="hljs-comment">%|▌                                                                                                                    | 1/189 [00:00&lt;01:26,  2.17it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">262144</span>, reducing to <span class="hljs-number">131072.0</span>
  <span class="hljs-number">1</span><span class="hljs-comment">%|█▏</span>
 [...]
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
 <span class="hljs-number">14</span><span class="hljs-comment">%|████████████████▌                                                                                                   | 27/189 [00:14&lt;01:13,  2.21it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
 <span class="hljs-number">15</span><span class="hljs-comment">%|█████████████████▏                                                                                                  | 28/189 [00:14&lt;01:13,  2.18it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
 <span class="hljs-number">15</span><span class="hljs-comment">%|█████████████████▊                                                                                                  | 29/189 [00:15&lt;01:13,  2.18it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
[...]`,wrap:!1}}),ii=new h({props:{title:"Notes",local:"notes",headingTag:"h3"}}),Mi=new h({props:{title:"Non-Trainer Deepspeed Integration",local:"non-trainer-deepspeed-integration",headingTag:"h2"}}),Ti=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMlMjBpbXBvcnQlMjBIZkRlZXBTcGVlZENvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWwlMEFpbXBvcnQlMjBkZWVwc3BlZWQlMEElMEFkc19jb25maWclMjAlM0QlMjAlN0IuLi4lN0QlMjAlMjAlMjMlMjBkZWVwc3BlZWQlMjBjb25maWclMjBvYmplY3QlMjBvciUyMHBhdGglMjB0byUyMHRoZSUyMGZpbGUlMEElMjMlMjBtdXN0JTIwcnVuJTIwYmVmb3JlJTIwaW5zdGFudGlhdGluZyUyMHRoZSUyMG1vZGVsJTIwdG8lMjBkZXRlY3QlMjB6ZXJvJTIwMyUwQWRzY2hmJTIwJTNEJTIwSGZEZWVwU3BlZWRDb25maWcoZHNfY29uZmlnKSUyMCUyMCUyMyUyMGtlZXAlMjB0aGlzJTIwb2JqZWN0JTIwYWxpdmUlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFlbmdpbmUlMjAlM0QlMjBkZWVwc3BlZWQuaW5pdGlhbGl6ZShtb2RlbCUzRG1vZGVsJTJDJTIwY29uZmlnX3BhcmFtcyUzRGRzX2NvbmZpZyUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> transformers.integrations <span class="hljs-keyword">import</span> HfDeepSpeedConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">import</span> deepspeed

ds_config = {...}  <span class="hljs-comment"># deepspeed config object or path to the file</span>
<span class="hljs-comment"># must run before instantiating the model to detect zero 3</span>
dschf = HfDeepSpeedConfig(ds_config)  <span class="hljs-comment"># keep this object alive</span>
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
engine = deepspeed.initialize(model=model, config_params=ds_config, ...)`,wrap:!1}}),Ji=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMlMjBpbXBvcnQlMjBIZkRlZXBTcGVlZENvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWwlMkMlMjBBdXRvQ29uZmlnJTBBaW1wb3J0JTIwZGVlcHNwZWVkJTBBJTBBZHNfY29uZmlnJTIwJTNEJTIwJTdCLi4uJTdEJTIwJTIwJTIzJTIwZGVlcHNwZWVkJTIwY29uZmlnJTIwb2JqZWN0JTIwb3IlMjBwYXRoJTIwdG8lMjB0aGUlMjBmaWxlJTBBJTIzJTIwbXVzdCUyMHJ1biUyMGJlZm9yZSUyMGluc3RhbnRpYXRpbmclMjB0aGUlMjBtb2RlbCUyMHRvJTIwZGV0ZWN0JTIwemVybyUyMDMlMEFkc2NoZiUyMCUzRCUyMEhmRGVlcFNwZWVkQ29uZmlnKGRzX2NvbmZpZyklMjAlMjAlMjMlMjBrZWVwJTIwdGhpcyUyMG9iamVjdCUyMGFsaXZlJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX2NvbmZpZyhjb25maWcpJTBBZW5naW5lJTIwJTNEJTIwZGVlcHNwZWVkLmluaXRpYWxpemUobW9kZWwlM0Rtb2RlbCUyQyUyMGNvbmZpZ19wYXJhbXMlM0Rkc19jb25maWclMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> transformers.integrations <span class="hljs-keyword">import</span> HfDeepSpeedConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoConfig
<span class="hljs-keyword">import</span> deepspeed

ds_config = {...}  <span class="hljs-comment"># deepspeed config object or path to the file</span>
<span class="hljs-comment"># must run before instantiating the model to detect zero 3</span>
dschf = HfDeepSpeedConfig(ds_config)  <span class="hljs-comment"># keep this object alive</span>
config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model = AutoModel.from_config(config)
engine = deepspeed.initialize(model=model, config_params=ds_config, ...)`,wrap:!1}}),wi=new h({props:{title:"HfDeepSpeedConfig",local:"transformers.integrations.HfDeepSpeedConfig",headingTag:"h2"}}),di=new dI({props:{name:"class transformers.integrations.HfDeepSpeedConfig",anchor:"transformers.integrations.HfDeepSpeedConfig",parameters:[{name:"config_file_or_dict",val:""}],parametersDescription:[{anchor:"transformers.integrations.HfDeepSpeedConfig.config_file_or_dict",description:"<strong>config_file_or_dict</strong> (<code>Union[str, Dict]</code>) &#x2014; path to DeepSpeed config file or dict.",name:"config_file_or_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/integrations/deepspeed.py#L56"}}),mi=new h({props:{title:"Custom DeepSpeed ZeRO Inference",local:"custom-deepspeed-zero-inference",headingTag:"h3"}}),gi=new T({props:{code:"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",highlighted:`<span class="hljs-comment">#!/usr/bin/env python</span>

<span class="hljs-comment"># This script demonstrates how to use Deepspeed ZeRO in an inference mode when one can&#x27;t fit a model</span>
<span class="hljs-comment"># into a single GPU</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># 1. Use 1 GPU with CPU offload</span>
<span class="hljs-comment"># 2. Or use multiple GPUs instead</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># First you need to install deepspeed: pip install deepspeed</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># Here we use a 3B &quot;bigscience/T0_3B&quot; model which needs about 15GB GPU RAM - so 1 largish or 2</span>
<span class="hljs-comment"># small GPUs can handle it. or 1 small GPU and a lot of CPU memory.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># To use a larger model like &quot;bigscience/T0&quot; which needs about 50GB, unless you have an 80GB GPU -</span>
<span class="hljs-comment"># you will need 2-4 gpus. And then you can adapt the script to handle more gpus if you want to</span>
<span class="hljs-comment"># process multiple inputs at once.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># The provided deepspeed config also activates CPU memory offloading, so chances are that if you</span>
<span class="hljs-comment"># have a lot of available CPU memory and you don&#x27;t mind a slowdown you should be able to load a</span>
<span class="hljs-comment"># model that doesn&#x27;t normally fit into a single GPU. If you have enough GPU memory the program will</span>
<span class="hljs-comment"># run faster if you don&#x27;t want offload to CPU - so disable that section then.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># To deploy on 1 gpu:</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># deepspeed --num_gpus 1 t0.py</span>
<span class="hljs-comment"># or:</span>
<span class="hljs-comment"># python -m torch.distributed.run --nproc_per_node=1 t0.py</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># To deploy on 2 gpus:</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># deepspeed --num_gpus 2 t0.py</span>
<span class="hljs-comment"># or:</span>
<span class="hljs-comment"># python -m torch.distributed.run --nproc_per_node=2 t0.py</span>


<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoConfig, AutoModelForSeq2SeqLM
<span class="hljs-keyword">from</span> transformers.integrations <span class="hljs-keyword">import</span> HfDeepSpeedConfig
<span class="hljs-keyword">import</span> deepspeed
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch

os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To avoid warnings about parallelism in tokenizers</span>

<span class="hljs-comment"># distributed setup</span>
local_rank = <span class="hljs-built_in">int</span>(os.getenv(<span class="hljs-string">&quot;LOCAL_RANK&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>))
world_size = <span class="hljs-built_in">int</span>(os.getenv(<span class="hljs-string">&quot;WORLD_SIZE&quot;</span>, <span class="hljs-string">&quot;1&quot;</span>))
torch.cuda.set_device(local_rank)
deepspeed.init_distributed()

model_name = <span class="hljs-string">&quot;bigscience/T0_3B&quot;</span>

config = AutoConfig.from_pretrained(model_name)
model_hidden_size = config.d_model

<span class="hljs-comment"># batch size has to be divisible by world_size, but can be bigger than world_size</span>
train_batch_size = <span class="hljs-number">1</span> * world_size

<span class="hljs-comment"># ds_config notes</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - enable bf16 if you use Ampere or higher GPU - this will run in mixed precision and will be</span>
<span class="hljs-comment"># faster.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - for older GPUs you can enable fp16, but it&#x27;ll only work for non-bf16 pretrained models - e.g.</span>
<span class="hljs-comment"># all official t5 models are bf16-pretrained</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - set offload_param.device to &quot;none&quot; or completely remove the \`offload_param\` section if you don&#x27;t</span>
<span class="hljs-comment"># - want CPU offload</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - if using \`offload_param\` you can manually finetune stage3_param_persistence_threshold to control</span>
<span class="hljs-comment"># - which params should remain on gpus - the larger the value the smaller the offload size</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># For indepth info on Deepspeed config see</span>
<span class="hljs-comment"># https://huggingface.co/docs/transformers/main/main_classes/deepspeed</span>

<span class="hljs-comment"># keeping the same format as json for consistency, except it uses lower case for true/false</span>
<span class="hljs-comment"># fmt: off</span>
ds_config = {
    <span class="hljs-string">&quot;fp16&quot;</span>: {
        <span class="hljs-string">&quot;enabled&quot;</span>: <span class="hljs-literal">False</span>
    },
    <span class="hljs-string">&quot;bf16&quot;</span>: {
        <span class="hljs-string">&quot;enabled&quot;</span>: <span class="hljs-literal">False</span>
    },
    <span class="hljs-string">&quot;zero_optimization&quot;</span>: {
        <span class="hljs-string">&quot;stage&quot;</span>: <span class="hljs-number">3</span>,
        <span class="hljs-string">&quot;offload_param&quot;</span>: {
            <span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
            <span class="hljs-string">&quot;pin_memory&quot;</span>: <span class="hljs-literal">True</span>
        },
        <span class="hljs-string">&quot;overlap_comm&quot;</span>: <span class="hljs-literal">True</span>,
        <span class="hljs-string">&quot;contiguous_gradients&quot;</span>: <span class="hljs-literal">True</span>,
        <span class="hljs-string">&quot;reduce_bucket_size&quot;</span>: model_hidden_size * model_hidden_size,
        <span class="hljs-string">&quot;stage3_prefetch_bucket_size&quot;</span>: <span class="hljs-number">0.9</span> * model_hidden_size * model_hidden_size,
        <span class="hljs-string">&quot;stage3_param_persistence_threshold&quot;</span>: <span class="hljs-number">10</span> * model_hidden_size
    },
    <span class="hljs-string">&quot;steps_per_print&quot;</span>: <span class="hljs-number">2000</span>,
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: train_batch_size,
    <span class="hljs-string">&quot;train_micro_batch_size_per_gpu&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;wall_clock_breakdown&quot;</span>: <span class="hljs-literal">False</span>
}
<span class="hljs-comment"># fmt: on</span>

<span class="hljs-comment"># next line instructs transformers to partition the model directly over multiple gpus using</span>
<span class="hljs-comment"># deepspeed.zero.Init when model&#x27;s \`from_pretrained\` method is called.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># **it has to be run before loading the model AutoModelForSeq2SeqLM.from_pretrained(model_name)**</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># otherwise the model will first be loaded normally and only partitioned at forward time which is</span>
<span class="hljs-comment"># less efficient and when there is little CPU RAM may fail</span>
dschf = HfDeepSpeedConfig(ds_config)  <span class="hljs-comment"># keep this object alive</span>

<span class="hljs-comment"># now a model can be loaded.</span>
model = AutoModelForSeq2SeqLM.from_pretrained(model_name)

<span class="hljs-comment"># initialise Deepspeed ZeRO and store only the engine object</span>
ds_engine = deepspeed.initialize(model=model, config_params=ds_config)[<span class="hljs-number">0</span>]
ds_engine.module.<span class="hljs-built_in">eval</span>()  <span class="hljs-comment"># inference</span>

<span class="hljs-comment"># Deepspeed ZeRO can process unrelated inputs on each GPU. So for 2 gpus you process 2 inputs at once.</span>
<span class="hljs-comment"># If you use more GPUs adjust for more.</span>
<span class="hljs-comment"># And of course if you have just one input to process you then need to pass the same string to both gpus</span>
<span class="hljs-comment"># If you use only one GPU, then you will have only rank 0.</span>
rank = torch.distributed.get_rank()
<span class="hljs-keyword">if</span> rank == <span class="hljs-number">0</span>:
    text_in = <span class="hljs-string">&quot;Is this review positive or negative? Review: this is the best cast iron skillet you will ever buy&quot;</span>
<span class="hljs-keyword">elif</span> rank == <span class="hljs-number">1</span>:
    text_in = <span class="hljs-string">&quot;Is this review positive or negative? Review: this is the worst restaurant ever&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_name)
inputs = tokenizer.encode(text_in, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=local_rank)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = ds_engine.module.generate(inputs, synced_gpus=<span class="hljs-literal">True</span>)
text_out = tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;rank<span class="hljs-subst">{rank}</span>:\\n   in=<span class="hljs-subst">{text_in}</span>\\n  out=<span class="hljs-subst">{text_out}</span>&quot;</span>)`,wrap:!1}}),_i=new T({props:{code:"JTI0JTIwZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDIlMjB0MC5weSUwQXJhbmswJTNBJTBBJTIwJTIwJTIwaW4lM0RJcyUyMHRoaXMlMjByZXZpZXclMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjBSZXZpZXclM0ElMjB0aGlzJTIwaXMlMjB0aGUlMjBiZXN0JTIwY2FzdCUyMGlyb24lMjBza2lsbGV0JTIweW91JTIwd2lsbCUyMGV2ZXIlMjBidXklMEElMjAlMjBvdXQlM0RQb3NpdGl2ZSUwQXJhbmsxJTNBJTBBJTIwJTIwJTIwaW4lM0RJcyUyMHRoaXMlMjByZXZpZXclMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjBSZXZpZXclM0ElMjB0aGlzJTIwaXMlMjB0aGUlMjB3b3JzdCUyMHJlc3RhdXJhbnQlMjBldmVyJTBBJTIwJTIwb3V0JTNEbmVnYXRpdmU=",highlighted:`$ deepspeed --num_gpus <span class="hljs-number">2</span> t0.py
rank0:
   <span class="hljs-keyword">in</span>=Is <span class="hljs-keyword">this</span> review positive or negative? Review: <span class="hljs-keyword">this</span> <span class="hljs-keyword">is</span> the best cast iron skillet you will ever buy
  <span class="hljs-keyword">out</span>=Positive
rank1:
   <span class="hljs-keyword">in</span>=Is <span class="hljs-keyword">this</span> review positive or negative? Review: <span class="hljs-keyword">this</span> <span class="hljs-keyword">is</span> the worst restaurant ever
  <span class="hljs-keyword">out</span>=negative`,wrap:!1}}),Zi=new h({props:{title:"generate nuances",local:"generate-nuances",headingTag:"h3"}}),xi=new h({props:{title:"Testing Deepspeed Integration",local:"testing-deepspeed-integration",headingTag:"h2"}}),zi=new T({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwdGVzdHMlMkZkZWVwc3BlZWQlMkZ0ZXN0X2RlZXBzcGVlZC5weQ==",highlighted:'RUN_SLOW=<span class="hljs-number">1</span> pytest tests<span class="hljs-regexp">/deepspeed/</span>test_deepspeed.py',wrap:!1}}),ki=new T({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwdGVzdHMlMkZkZWVwc3BlZWQ=",highlighted:'<span class="hljs-attr">RUN_SLOW</span>=<span class="hljs-number">1</span> pytest tests/deepspeed',wrap:!1}}),Ri=new h({props:{title:"Main DeepSpeed Resources",local:"main-deepspeed-resources",headingTag:"h2"}}),{c(){J=p("meta"),g=a(),m=p("p"),I=a(),M(B.$$.fragment),Z=a(),b=p("p"),b.innerHTML=_o,f=a(),v=p("ol"),v.innerHTML=AJ,qo=a(),k=p("p"),k.innerHTML=gJ,$o=a(),R=p("p"),R.textContent=vJ,xo=a(),N=p("p"),N.textContent=_J,Go=a(),X=p("p"),X.innerHTML=BJ,So=a(),Q=p("ol"),Q.innerHTML=ZJ,zo=a(),E=p("p"),E.textContent=qJ,Wo=a(),H=p("p"),H.textContent=$J,ko=a(),V=p("ol"),V.innerHTML=xJ,Ro=a(),Y=p("p"),Y.textContent=GJ,No=a(),L=p("ol"),L.innerHTML=SJ,Xo=a(),F=p("p"),F.textContent=zJ,Qo=a(),Hi=p("a"),Eo=a(),M(D.$$.fragment),Ho=a(),Vi=p("a"),Vo=a(),M(P.$$.fragment),Yo=a(),O=p("p"),O.textContent=WJ,Lo=a(),M(K.$$.fragment),Fo=a(),ss=p("p"),ss.innerHTML=kJ,Do=a(),M(ts.$$.fragment),Po=a(),es=p("p"),es.innerHTML=RJ,Oo=a(),ls=p("p"),ls.innerHTML=NJ,Ko=a(),as=p("p"),as.textContent=XJ,sM=a(),ns=p("p"),ns.textContent=QJ,tM=a(),M(ps.$$.fragment),eM=a(),is=p("p"),is.innerHTML=EJ,lM=a(),os=p("p"),os.innerHTML=HJ,aM=a(),M(Ms.$$.fragment),nM=a(),us=p("p"),us.innerHTML=VJ,pM=a(),cs=p("p"),cs.textContent=YJ,iM=a(),M(rs.$$.fragment),oM=a(),ys=p("p"),ys.innerHTML=LJ,MM=a(),js=p("p"),js.innerHTML=FJ,uM=a(),Ts=p("p"),Ts.innerHTML=DJ,cM=a(),hs=p("p"),hs.textContent=PJ,rM=a(),M(Js.$$.fragment),yM=a(),Us=p("p"),Us.textContent=OJ,jM=a(),M(ws.$$.fragment),TM=a(),ds=p("p"),ds.textContent=KJ,hM=a(),M(ms.$$.fragment),JM=a(),fs=p("p"),fs.innerHTML=sU,UM=a(),Is=p("p"),Is.innerHTML=tU,wM=a(),Cs=p("p"),Cs.innerHTML=eU,dM=a(),Yi=p("a"),mM=a(),M(bs.$$.fragment),fM=a(),As=p("p"),As.innerHTML=lU,IM=a(),gs=p("p"),gs.textContent=aU,CM=a(),M(vs.$$.fragment),bM=a(),_s=p("p"),_s.innerHTML=nU,AM=a(),M(Bs.$$.fragment),gM=a(),Zs=p("p"),Zs.innerHTML=pU,vM=a(),qs=p("p"),qs.innerHTML=iU,_M=a(),$s=p("p"),$s.innerHTML=oU,BM=a(),M(xs.$$.fragment),ZM=a(),Gs=p("p"),Gs.innerHTML=MU,qM=a(),Ss=p("p"),Ss.innerHTML=uU,$M=a(),Li=p("a"),xM=a(),M(zs.$$.fragment),GM=a(),Ws=p("p"),Ws.innerHTML=cU,SM=a(),M(ks.$$.fragment),zM=a(),Rs=p("p"),Rs.innerHTML=rU,WM=a(),Ns=p("p"),Ns.textContent=yU,kM=a(),Xs=p("ol"),Xs.innerHTML=jU,RM=a(),Qs=p("p"),Qs.textContent=TU,NM=a(),M(Es.$$.fragment),XM=a(),Hs=p("p"),Hs.textContent=hU,QM=a(),Vs=p("p"),Vs.innerHTML=JU,EM=a(),Ys=p("p"),Ys.textContent=UU,HM=a(),Ls=p("p"),Ls.textContent=wU,VM=a(),Fi=p("ul"),q=p("li"),Di=p("p"),Di.innerHTML=dU,yJ=a(),M(Fs.$$.fragment),jJ=a(),Pi=p("p"),Pi.textContent=mU,YM=a(),Oi=p("a"),LM=a(),M(Ds.$$.fragment),FM=a(),Ps=p("p"),Ps.innerHTML=fU,DM=a(),Os=p("p"),Os.innerHTML=IU,PM=a(),M(Ks.$$.fragment),OM=a(),st=p("p"),st.innerHTML=CU,KM=a(),M(tt.$$.fragment),su=a(),et=p("p"),et.textContent=bU,tu=a(),lt=p("p"),lt.innerHTML=AU,eu=a(),M(at.$$.fragment),lu=a(),nt=p("p"),nt.innerHTML=gU,au=a(),M(pt.$$.fragment),nu=a(),it=p("p"),it.textContent=vU,pu=a(),M(ot.$$.fragment),iu=a(),Mt=p("p"),Mt.innerHTML=_U,ou=a(),ut=p("p"),ut.innerHTML=BU,Mu=a(),M(ct.$$.fragment),uu=a(),rt=p("p"),rt.innerHTML=ZU,cu=a(),M(yt.$$.fragment),ru=a(),jt=p("p"),jt.textContent=qU,yu=a(),M(Tt.$$.fragment),ju=a(),ht=p("p"),ht.innerHTML=$U,Tu=a(),M(Jt.$$.fragment),hu=a(),Ut=p("p"),Ut.innerHTML=xU,Ju=a(),M(wt.$$.fragment),Uu=a(),dt=p("p"),dt.innerHTML=GU,wu=a(),Ki=p("a"),du=a(),M(mt.$$.fragment),mu=a(),ft=p("p"),ft.innerHTML=SU,fu=a(),It=p("p"),It.textContent=zU,Iu=a(),M(Ct.$$.fragment),Cu=a(),bt=p("p"),bt.innerHTML=WU,bu=a(),At=p("p"),At.textContent=kU,Au=a(),gt=p("p"),gt.textContent=RU,gu=a(),M(vt.$$.fragment),vu=a(),_t=p("p"),_t.innerHTML=NU,_u=a(),M(Bt.$$.fragment),Bu=a(),Zt=p("p"),Zt.innerHTML=XU,Zu=a(),M(qt.$$.fragment),qu=a(),$t=p("p"),$t.textContent=QU,$u=a(),xt=p("p"),xt.innerHTML=EU,xu=a(),so=p("a"),Gu=a(),M(Gt.$$.fragment),Su=a(),St=p("p"),St.innerHTML=HU,zu=a(),zt=p("p"),zt.innerHTML=VU,Wu=a(),M(Wt.$$.fragment),ku=a(),kt=p("p"),kt.innerHTML=YU,Ru=a(),M(Rt.$$.fragment),Nu=a(),Nt=p("p"),Nt.innerHTML=LU,Xu=a(),Xt=p("p"),Xt.textContent=FU,Qu=a(),Qt=p("p"),Qt.innerHTML=DU,Eu=a(),M(Et.$$.fragment),Hu=a(),Ht=p("p"),Ht.innerHTML=PU,Vu=a(),to=p("a"),Yu=a(),M(Vt.$$.fragment),Lu=a(),Yt=p("p"),Yt.innerHTML=OU,Fu=a(),Lt=p("p"),Lt.textContent=KU,Du=a(),M(Ft.$$.fragment),Pu=a(),Dt=p("p"),Dt.textContent=sw,Ou=a(),M(Pt.$$.fragment),Ku=a(),eo=p("a"),sc=a(),M(Ot.$$.fragment),tc=a(),M(G.$$.fragment),ec=a(),Kt=p("p"),Kt.innerHTML=tw,lc=a(),se=p("p"),se.innerHTML=ew,ac=a(),te=p("p"),te.innerHTML=lw,nc=a(),ee=p("p"),ee.textContent=aw,pc=a(),le=p("p"),le.innerHTML=nw,ic=a(),ae=p("ol"),ae.innerHTML=pw,oc=a(),ne=p("p"),ne.innerHTML=iw,Mc=a(),lo=p("a"),uc=a(),M(pe.$$.fragment),cc=a(),ie=p("p"),ie.innerHTML=ow,rc=a(),oe=p("p"),oe.innerHTML=Mw,yc=a(),Me=p("p"),Me.innerHTML=uw,jc=a(),ue=p("p"),ue.textContent=cw,Tc=a(),ao=p("a"),hc=a(),M(ce.$$.fragment),Jc=a(),re=p("p"),re.textContent=rw,Uc=a(),M(ye.$$.fragment),wc=a(),je=p("p"),je.innerHTML=yw,dc=a(),Te=p("ul"),Te.innerHTML=jw,mc=a(),he=p("p"),he.innerHTML=Tw,fc=a(),M(Je.$$.fragment),Ic=a(),Ue=p("p"),Ue.textContent=hw,Cc=a(),no=p("a"),bc=a(),M(we.$$.fragment),Ac=a(),de=p("p"),de.textContent=Jw,gc=a(),M(me.$$.fragment),vc=a(),fe=p("p"),fe.innerHTML=Uw,_c=a(),Ie=p("p"),Ie.innerHTML=ww,Bc=a(),Ce=p("p"),Ce.innerHTML=dw,Zc=a(),be=p("ul"),be.innerHTML=mw,qc=a(),Ae=p("p"),Ae.innerHTML=fw,$c=a(),ge=p("p"),ge.innerHTML=Iw,xc=a(),ve=p("p"),ve.textContent=Cw,Gc=a(),_e=p("ul"),_e.innerHTML=bw,Sc=a(),Be=p("p"),Be.innerHTML=Aw,zc=a(),Ze=p("p"),Ze.innerHTML=gw,Wc=a(),qe=p("p"),qe.innerHTML=vw,kc=a(),$e=p("ul"),$e.innerHTML=_w,Rc=a(),xe=p("p"),xe.innerHTML=Bw,Nc=a(),Ge=p("p"),Ge.innerHTML=Zw,Xc=a(),Se=p("ol"),Se.innerHTML=qw,Qc=a(),M(ze.$$.fragment),Ec=a(),We=p("p"),We.textContent=$w,Hc=a(),ke=p("p"),ke.textContent=xw,Vc=a(),M(Re.$$.fragment),Yc=a(),Ne=p("p"),Ne.textContent=Gw,Lc=a(),M(Xe.$$.fragment),Fc=a(),Qe=p("p"),Qe.textContent=Sw,Dc=a(),M(Ee.$$.fragment),Pc=a(),po=p("a"),Oc=a(),M(He.$$.fragment),Kc=a(),Ve=p("p"),Ve.textContent=zw,sr=a(),Ye=p("p"),Ye.textContent=Ww,tr=a(),M(Le.$$.fragment),er=a(),Fe=p("p"),Fe.innerHTML=kw,lr=a(),De=p("p"),De.innerHTML=Rw,ar=a(),Pe=p("p"),Pe.innerHTML=Nw,nr=a(),Oe=p("p"),Oe.innerHTML=Xw,pr=a(),io=p("a"),ir=a(),M(Ke.$$.fragment),or=a(),sl=p("p"),sl.textContent=Qw,Mr=a(),tl=p("p"),tl.textContent=Ew,ur=a(),el=p("ul"),el.innerHTML=Hw,cr=a(),ll=p("p"),ll.innerHTML=Vw,rr=a(),oo=p("a"),yr=a(),M(al.$$.fragment),jr=a(),nl=p("p"),nl.innerHTML=Yw,Tr=a(),M(pl.$$.fragment),hr=a(),il=p("p"),il.innerHTML=Lw,Jr=a(),M(ol.$$.fragment),Ur=a(),Mo=p("a"),wr=a(),M(Ml.$$.fragment),dr=a(),ul=p("p"),ul.innerHTML=Fw,mr=a(),M(cl.$$.fragment),fr=a(),rl=p("p"),rl.innerHTML=Dw,Ir=a(),M(yl.$$.fragment),Cr=a(),M(jl.$$.fragment),br=a(),Tl=p("p"),Tl.textContent=Pw,Ar=a(),hl=p("p"),hl.textContent=Ow,gr=a(),Jl=p("ul"),Jl.innerHTML=Kw,vr=a(),Ul=p("p"),Ul.textContent=sd,_r=a(),wl=p("ul"),wl.innerHTML=td,Br=a(),dl=p("p"),dl.textContent=ed,Zr=a(),ml=p("p"),ml.textContent=ld,qr=a(),fl=p("p"),fl.textContent=ad,$r=a(),Il=p("ol"),Il.innerHTML=nd,xr=a(),Cl=p("p"),Cl.textContent=pd,Gr=a(),bl=p("p"),bl.textContent=id,Sr=a(),Al=p("p"),Al.textContent=od,zr=a(),gl=p("p"),gl.textContent=Md,Wr=a(),vl=p("p"),vl.textContent=ud,kr=a(),_l=p("p"),_l.innerHTML=cd,Rr=a(),Bl=p("p"),Bl.textContent=rd,Nr=a(),Zl=p("ul"),Zl.innerHTML=yd,Xr=a(),M(ql.$$.fragment),Qr=a(),$l=p("p"),$l.textContent=jd,Er=a(),xl=p("p"),xl.textContent=Td,Hr=a(),Gl=p("p"),Gl.textContent=hd,Vr=a(),Sl=p("p"),Sl.textContent=Jd,Yr=a(),zl=p("ol"),zl.innerHTML=Ud,Lr=a(),M(Wl.$$.fragment),Fr=a(),kl=p("p"),kl.innerHTML=wd,Dr=a(),Rl=p("p"),Rl.innerHTML=dd,Pr=a(),uo=p("a"),Or=a(),M(Nl.$$.fragment),Kr=a(),Xl=p("p"),Xl.innerHTML=md,sy=a(),Ql=p("p"),Ql.innerHTML=fd,ty=a(),El=p("p"),El.innerHTML=Id,ey=a(),M(Hl.$$.fragment),ly=a(),Vl=p("p"),Vl.textContent=Cd,ay=a(),Yl=p("ul"),Yl.innerHTML=bd,ny=a(),Ll=p("p"),Ll.textContent=Ad,py=a(),Fl=p("p"),Fl.textContent=gd,iy=a(),M(Dl.$$.fragment),oy=a(),Pl=p("p"),Pl.innerHTML=vd,My=a(),Ol=p("p"),Ol.textContent=_d,uy=a(),M(Kl.$$.fragment),cy=a(),sa=p("p"),sa.innerHTML=Bd,ry=a(),ta=p("p"),ta.innerHTML=Zd,yy=a(),M(ea.$$.fragment),jy=a(),la=p("p"),la.textContent=qd,Ty=a(),co=p("a"),hy=a(),M(aa.$$.fragment),Jy=a(),na=p("p"),na.innerHTML=$d,Uy=a(),pa=p("p"),pa.textContent=xd,wy=a(),ia=p("ul"),ia.innerHTML=Gd,dy=a(),oa=p("p"),oa.innerHTML=Sd,my=a(),Ma=p("p"),Ma.innerHTML=zd,fy=a(),M(ua.$$.fragment),Iy=a(),ca=p("p"),ca.innerHTML=Wd,Cy=a(),ra=p("ul"),ra.innerHTML=kd,by=a(),ya=p("p"),ya.textContent=Rd,Ay=a(),M(ja.$$.fragment),gy=a(),Ta=p("p"),Ta.innerHTML=Nd,vy=a(),ha=p("p"),ha.innerHTML=Xd,_y=a(),M(Ja.$$.fragment),By=a(),Ua=p("p"),Ua.innerHTML=Qd,Zy=a(),ro=p("a"),qy=a(),M(wa.$$.fragment),$y=a(),da=p("p"),da.textContent=Ed,xy=a(),ma=p("p"),ma.innerHTML=Hd,Gy=a(),M(fa.$$.fragment),Sy=a(),Ia=p("p"),Ia.innerHTML=Vd,zy=a(),Ca=p("p"),Ca.innerHTML=Yd,Wy=a(),yo=p("a"),ky=a(),M(ba.$$.fragment),Ry=a(),Aa=p("p"),Aa.textContent=Ld,Ny=a(),M(ga.$$.fragment),Xy=a(),va=p("p"),va.textContent=Fd,Qy=a(),M(_a.$$.fragment),Ey=a(),Ba=p("p"),Ba.innerHTML=Dd,Hy=a(),Za=p("p"),Za.innerHTML=Pd,Vy=a(),qa=p("p"),qa.textContent=Od,Yy=a(),M($a.$$.fragment),Ly=a(),xa=p("p"),xa.innerHTML=Kd,Fy=a(),Ga=p("p"),Ga.innerHTML=sm,Dy=a(),M(Sa.$$.fragment),Py=a(),za=p("p"),za.textContent=tm,Oy=a(),M(Wa.$$.fragment),Ky=a(),ka=p("p"),ka.textContent=em,sj=a(),Ra=p("p"),Ra.innerHTML=lm,tj=a(),Na=p("p"),Na.textContent=am,ej=a(),M(Xa.$$.fragment),lj=a(),M(S.$$.fragment),aj=a(),M(Qa.$$.fragment),nj=a(),Ea=p("p"),Ea.innerHTML=nm,pj=a(),Ha=p("p"),Ha.innerHTML=pm,ij=a(),Va=p("p"),Va.innerHTML=im,oj=a(),Ya=p("p"),Ya.textContent=om,Mj=a(),M(La.$$.fragment),uj=a(),Fa=p("p"),Fa.textContent=Mm,cj=a(),Da=p("p"),Da.innerHTML=um,rj=a(),M(Pa.$$.fragment),yj=a(),Oa=p("p"),Oa.textContent=cm,jj=a(),M(Ka.$$.fragment),Tj=a(),sn=p("p"),sn.innerHTML=rm,hj=a(),tn=p("p"),tn.innerHTML=ym,Jj=a(),en=p("p"),en.textContent=jm,Uj=a(),M(ln.$$.fragment),wj=a(),an=p("p"),an.innerHTML=Tm,dj=a(),nn=p("p"),nn.innerHTML=hm,mj=a(),jo=p("a"),fj=a(),M(pn.$$.fragment),Ij=a(),on=p("p"),on.textContent=Jm,Cj=a(),M(Mn.$$.fragment),bj=a(),un=p("p"),un.innerHTML=Um,Aj=a(),cn=p("p"),cn.textContent=wm,gj=a(),M(rn.$$.fragment),vj=a(),yn=p("p"),yn.innerHTML=dm,_j=a(),To=p("a"),Bj=a(),M(jn.$$.fragment),Zj=a(),Tn=p("p"),Tn.textContent=mm,qj=a(),M(hn.$$.fragment),$j=a(),Jn=p("p"),Jn.innerHTML=fm,xj=a(),Un=p("p"),Un.textContent=Im,Gj=a(),M(wn.$$.fragment),Sj=a(),dn=p("p"),dn.innerHTML=Cm,zj=a(),ho=p("a"),Wj=a(),M(mn.$$.fragment),kj=a(),fn=p("p"),fn.textContent=bm,Rj=a(),M(In.$$.fragment),Nj=a(),Cn=p("p"),Cn.innerHTML=Am,Xj=a(),bn=p("p"),bn.textContent=gm,Qj=a(),M(An.$$.fragment),Ej=a(),gn=p("p"),gn.innerHTML=vm,Hj=a(),Jo=p("a"),Vj=a(),M(vn.$$.fragment),Yj=a(),_n=p("p"),_n.innerHTML=_m,Lj=a(),Bn=p("p"),Bn.innerHTML=Bm,Fj=a(),Zn=p("p"),Zn.innerHTML=Zm,Dj=a(),qn=p("p"),qn.innerHTML=qm,Pj=a(),M($n.$$.fragment),Oj=a(),xn=p("p"),xn.innerHTML=$m,Kj=a(),Gn=p("p"),Gn.innerHTML=xm,sT=a(),Sn=p("p"),Sn.innerHTML=Gm,tT=a(),zn=p("p"),zn.textContent=Sm,eT=a(),Wn=p("p"),Wn.textContent=zm,lT=a(),M(kn.$$.fragment),aT=a(),Rn=p("p"),Rn.innerHTML=Wm,nT=a(),M(Nn.$$.fragment),pT=a(),M(z.$$.fragment),iT=a(),Xn=p("p"),Xn.innerHTML=km,oT=a(),Qn=p("p"),Qn.innerHTML=Rm,MT=a(),M(En.$$.fragment),uT=a(),Hn=p("p"),Hn.innerHTML=Nm,cT=a(),Vn=p("p"),Vn.innerHTML=Xm,rT=a(),Yn=p("p"),Yn.textContent=Qm,yT=a(),M(Ln.$$.fragment),jT=a(),Fn=p("p"),Fn.innerHTML=Em,TT=a(),M(Dn.$$.fragment),hT=a(),Pn=p("p"),Pn.innerHTML=Hm,JT=a(),On=p("p"),On.textContent=Vm,UT=a(),Kn=p("p"),Kn.innerHTML=Ym,wT=a(),sp=p("p"),sp.innerHTML=Lm,dT=a(),tp=p("p"),tp.textContent=Fm,mT=a(),M(ep.$$.fragment),fT=a(),lp=p("p"),lp.textContent=Dm,IT=a(),ap=p("p"),ap.textContent=Pm,CT=a(),np=p("p"),np.textContent=Om,bT=a(),M(pp.$$.fragment),AT=a(),ip=p("p"),ip.innerHTML=Km,gT=a(),M(op.$$.fragment),vT=a(),Mp=p("p"),Mp.textContent=sf,_T=a(),up=p("p"),up.innerHTML=tf,BT=a(),M(cp.$$.fragment),ZT=a(),rp=p("p"),rp.innerHTML=ef,qT=a(),yp=p("p"),yp.textContent=lf,$T=a(),jp=p("p"),jp.innerHTML=af,xT=a(),Tp=p("p"),Tp.innerHTML=nf,GT=a(),M(hp.$$.fragment),ST=a(),Jp=p("p"),Jp.innerHTML=pf,zT=a(),Up=p("p"),Up.innerHTML=of,WT=a(),wp=p("p"),wp.textContent=Mf,kT=a(),M(dp.$$.fragment),RT=a(),mp=p("p"),mp.innerHTML=uf,NT=a(),Uo=p("a"),XT=a(),M(fp.$$.fragment),QT=a(),Ip=p("p"),Ip.textContent=cf,ET=a(),Cp=p("p"),Cp.innerHTML=rf,HT=a(),M(bp.$$.fragment),VT=a(),Ap=p("p"),Ap.textContent=yf,YT=a(),gp=p("p"),gp.innerHTML=jf,LT=a(),M(vp.$$.fragment),FT=a(),_p=p("p"),_p.textContent=Tf,DT=a(),Bp=p("p"),Bp.textContent=hf,PT=a(),M(Zp.$$.fragment),OT=a(),qp=p("p"),qp.textContent=Jf,KT=a(),$p=p("p"),$p.textContent=Uf,sh=a(),M(xp.$$.fragment),th=a(),Gp=p("p"),Gp.textContent=wf,eh=a(),Sp=p("p"),Sp.textContent=df,lh=a(),zp=p("p"),zp.textContent=mf,ah=a(),Wp=p("p"),Wp.textContent=ff,nh=a(),M(kp.$$.fragment),ph=a(),Rp=p("p"),Rp.textContent=If,ih=a(),Np=p("p"),Np.innerHTML=Cf,oh=a(),M(Xp.$$.fragment),Mh=a(),Qp=p("p"),Qp.textContent=bf,uh=a(),Ep=p("p"),Ep.textContent=Af,ch=a(),C=p("ol"),wo=p("li"),wo.innerHTML=gf,TJ=a(),mo=p("li"),mo.innerHTML=vf,hJ=a(),Hp=p("li"),fo=p("p"),fo.textContent=_f,JJ=a(),M(Vp.$$.fragment),UJ=a(),Io=p("li"),Io.innerHTML=Bf,wJ=a(),Co=p("li"),Co.innerHTML=Zf,dJ=a(),bo=p("li"),bo.innerHTML=qf,rh=a(),Yp=p("p"),Yp.textContent=$f,yh=a(),Lp=p("ul"),Lp.innerHTML=xf,jh=a(),M(Fp.$$.fragment),Th=a(),M(Dp.$$.fragment),hh=a(),Pp=p("p"),Pp.innerHTML=Gf,Jh=a(),M(Op.$$.fragment),Uh=a(),Kp=p("p"),Kp.textContent=Sf,wh=a(),si=p("p"),si.textContent=zf,dh=a(),M(ti.$$.fragment),mh=a(),ei=p("p"),ei.innerHTML=Wf,fh=a(),M(li.$$.fragment),Ih=a(),ai=p("p"),ai.textContent=kf,Ch=a(),ni=p("p"),ni.textContent=Rf,bh=a(),pi=p("p"),pi.innerHTML=Nf,Ah=a(),M(ii.$$.fragment),gh=a(),oi=p("ul"),oi.innerHTML=Xf,vh=a(),M(Mi.$$.fragment),_h=a(),ui=p("p"),ui.innerHTML=Qf,Bh=a(),ci=p("p"),ci.innerHTML=Ef,Zh=a(),ri=p("p"),ri.innerHTML=Hf,qh=a(),yi=p("p"),yi.innerHTML=Vf,$h=a(),ji=p("p"),ji.textContent=Yf,xh=a(),M(Ti.$$.fragment),Gh=a(),hi=p("p"),hi.textContent=Lf,Sh=a(),M(Ji.$$.fragment),zh=a(),Ui=p("p"),Ui.innerHTML=Ff,Wh=a(),M(wi.$$.fragment),kh=a(),_=p("div"),M(di.$$.fragment),mJ=a(),Ao=p("p"),Ao.textContent=Df,fJ=a(),go=p("p"),go.innerHTML=Pf,IJ=a(),vo=p("p"),vo.innerHTML=Of,Rh=a(),M(mi.$$.fragment),Nh=a(),fi=p("p"),fi.innerHTML=Kf,Xh=a(),Ii=p("p"),Ii.textContent=sI,Qh=a(),Ci=p("p"),Ci.textContent=tI,Eh=a(),bi=p("p"),bi.textContent=eI,Hh=a(),Ai=p("ol"),Ai.innerHTML=lI,Vh=a(),M(gi.$$.fragment),Yh=a(),vi=p("p"),vi.innerHTML=aI,Lh=a(),M(_i.$$.fragment),Fh=a(),Bi=p("p"),Bi.textContent=nI,Dh=a(),M(Zi.$$.fragment),Ph=a(),qi=p("p"),qi.innerHTML=pI,Oh=a(),$i=p("p"),$i.innerHTML=iI,Kh=a(),M(xi.$$.fragment),sJ=a(),Gi=p("p"),Gi.textContent=oI,tJ=a(),Si=p("p"),Si.textContent=MI,eJ=a(),M(zi.$$.fragment),lJ=a(),Wi=p("p"),Wi.textContent=uI,aJ=a(),M(ki.$$.fragment),nJ=a(),M(Ri.$$.fragment),pJ=a(),Ni=p("ul"),Ni.innerHTML=cI,iJ=a(),Xi=p("p"),Xi.textContent=rI,oJ=a(),Qi=p("ul"),Qi.innerHTML=yI,MJ=a(),Ei=p("p"),Ei.innerHTML=jI,uJ=a(),Bo=p("p"),this.h()},l(s){const t=wI("svelte-u9bgzb",document.head);J=i(t,"META",{name:!0,content:!0}),t.forEach(e),g=n(s),m=i(s,"P",{}),U(m).forEach(e),I=n(s),u(B.$$.fragment,s),Z=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-4c3rde"&&(b.innerHTML=_o),f=n(s),v=i(s,"OL",{"data-svelte-h":!0}),o(v)!=="svelte-12k6of1"&&(v.innerHTML=AJ),qo=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1ipy5tt"&&(k.innerHTML=gJ),$o=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-iaccrf"&&(R.textContent=vJ),xo=n(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1jckdpk"&&(N.textContent=_J),Go=n(s),X=i(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-k3r8dh"&&(X.innerHTML=BJ),So=n(s),Q=i(s,"OL",{"data-svelte-h":!0}),o(Q)!=="svelte-1vdiy61"&&(Q.innerHTML=ZJ),zo=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1j61y1r"&&(E.textContent=qJ),Wo=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1igpel8"&&(H.textContent=$J),ko=n(s),V=i(s,"OL",{"data-svelte-h":!0}),o(V)!=="svelte-lihws0"&&(V.innerHTML=xJ),Ro=n(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1i9b1jx"&&(Y.textContent=GJ),No=n(s),L=i(s,"OL",{"data-svelte-h":!0}),o(L)!=="svelte-ipbdbn"&&(L.innerHTML=SJ),Xo=n(s),F=i(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1nlnufl"&&(F.textContent=zJ),Qo=n(s),Hi=i(s,"A",{id:!0}),U(Hi).forEach(e),Eo=n(s),u(D.$$.fragment,s),Ho=n(s),Vi=i(s,"A",{id:!0}),U(Vi).forEach(e),Vo=n(s),u(P.$$.fragment,s),Yo=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1vqjc6p"&&(O.textContent=WJ),Lo=n(s),u(K.$$.fragment,s),Fo=n(s),ss=i(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1t82ll5"&&(ss.innerHTML=kJ),Do=n(s),u(ts.$$.fragment,s),Po=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-1cphooc"&&(es.innerHTML=RJ),Oo=n(s),ls=i(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-122yejb"&&(ls.innerHTML=NJ),Ko=n(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-1cymhp5"&&(as.textContent=XJ),sM=n(s),ns=i(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-168m9gp"&&(ns.textContent=QJ),tM=n(s),u(ps.$$.fragment,s),eM=n(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-a7t4f9"&&(is.innerHTML=EJ),lM=n(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-gl7s3y"&&(os.innerHTML=HJ),aM=n(s),u(Ms.$$.fragment,s),nM=n(s),us=i(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-yu99fb"&&(us.innerHTML=VJ),pM=n(s),cs=i(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-1ldirwe"&&(cs.textContent=YJ),iM=n(s),u(rs.$$.fragment,s),oM=n(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-17wmgg8"&&(ys.innerHTML=LJ),MM=n(s),js=i(s,"P",{"data-svelte-h":!0}),o(js)!=="svelte-1rxyat4"&&(js.innerHTML=FJ),uM=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-x5qy10"&&(Ts.innerHTML=DJ),cM=n(s),hs=i(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-1mgjr9n"&&(hs.textContent=PJ),rM=n(s),u(Js.$$.fragment,s),yM=n(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-5piew1"&&(Us.textContent=OJ),jM=n(s),u(ws.$$.fragment,s),TM=n(s),ds=i(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-1jhj7gz"&&(ds.textContent=KJ),hM=n(s),u(ms.$$.fragment,s),JM=n(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-wulif7"&&(fs.innerHTML=sU),UM=n(s),Is=i(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-1m52oc1"&&(Is.innerHTML=tU),wM=n(s),Cs=i(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1bgh2n5"&&(Cs.innerHTML=eU),dM=n(s),Yi=i(s,"A",{id:!0}),U(Yi).forEach(e),mM=n(s),u(bs.$$.fragment,s),fM=n(s),As=i(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-1npmf3i"&&(As.innerHTML=lU),IM=n(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-18nicry"&&(gs.textContent=aU),CM=n(s),u(vs.$$.fragment,s),bM=n(s),_s=i(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-1xbc0kp"&&(_s.innerHTML=nU),AM=n(s),u(Bs.$$.fragment,s),gM=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-14y0009"&&(Zs.innerHTML=pU),vM=n(s),qs=i(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-4y3pxo"&&(qs.innerHTML=iU),_M=n(s),$s=i(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-1jem9f9"&&($s.innerHTML=oU),BM=n(s),u(xs.$$.fragment,s),ZM=n(s),Gs=i(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-1hk3m2d"&&(Gs.innerHTML=MU),qM=n(s),Ss=i(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-1r95sq9"&&(Ss.innerHTML=uU),$M=n(s),Li=i(s,"A",{id:!0}),U(Li).forEach(e),xM=n(s),u(zs.$$.fragment,s),GM=n(s),Ws=i(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-17kynqh"&&(Ws.innerHTML=cU),SM=n(s),u(ks.$$.fragment,s),zM=n(s),Rs=i(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-1xjofrh"&&(Rs.innerHTML=rU),WM=n(s),Ns=i(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-3lttbu"&&(Ns.textContent=yU),kM=n(s),Xs=i(s,"OL",{"data-svelte-h":!0}),o(Xs)!=="svelte-11yg5ud"&&(Xs.innerHTML=jU),RM=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-1ynxwf6"&&(Qs.textContent=TU),NM=n(s),u(Es.$$.fragment,s),XM=n(s),Hs=i(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-1w20i2l"&&(Hs.textContent=hU),QM=n(s),Vs=i(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-1cjih2x"&&(Vs.innerHTML=JU),EM=n(s),Ys=i(s,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-1vjeo35"&&(Ys.textContent=UU),HM=n(s),Ls=i(s,"P",{"data-svelte-h":!0}),o(Ls)!=="svelte-1biq3pv"&&(Ls.textContent=wU),VM=n(s),Fi=i(s,"UL",{});var Zo=U(Fi);q=i(Zo,"LI",{});var $=U(q);Di=i($,"P",{"data-svelte-h":!0}),o(Di)!=="svelte-t6dru4"&&(Di.innerHTML=dU),yJ=n($),u(Fs.$$.fragment,$),jJ=n($),Pi=i($,"P",{"data-svelte-h":!0}),o(Pi)!=="svelte-1qlwfj"&&(Pi.textContent=mU),$.forEach(e),Zo.forEach(e),YM=n(s),Oi=i(s,"A",{id:!0}),U(Oi).forEach(e),LM=n(s),u(Ds.$$.fragment,s),FM=n(s),Ps=i(s,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-1qsnpa1"&&(Ps.innerHTML=fU),DM=n(s),Os=i(s,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-84g6lv"&&(Os.innerHTML=IU),PM=n(s),u(Ks.$$.fragment,s),OM=n(s),st=i(s,"P",{"data-svelte-h":!0}),o(st)!=="svelte-dh13n7"&&(st.innerHTML=CU),KM=n(s),u(tt.$$.fragment,s),su=n(s),et=i(s,"P",{"data-svelte-h":!0}),o(et)!=="svelte-kk9ioq"&&(et.textContent=bU),tu=n(s),lt=i(s,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-bk7isu"&&(lt.innerHTML=AU),eu=n(s),u(at.$$.fragment,s),lu=n(s),nt=i(s,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1u51h9h"&&(nt.innerHTML=gU),au=n(s),u(pt.$$.fragment,s),nu=n(s),it=i(s,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1ipwpw9"&&(it.textContent=vU),pu=n(s),u(ot.$$.fragment,s),iu=n(s),Mt=i(s,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1c219ul"&&(Mt.innerHTML=_U),ou=n(s),ut=i(s,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1pc2cg3"&&(ut.innerHTML=BU),Mu=n(s),u(ct.$$.fragment,s),uu=n(s),rt=i(s,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-7vonjg"&&(rt.innerHTML=ZU),cu=n(s),u(yt.$$.fragment,s),ru=n(s),jt=i(s,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-yis0vn"&&(jt.textContent=qU),yu=n(s),u(Tt.$$.fragment,s),ju=n(s),ht=i(s,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-5wrpqf"&&(ht.innerHTML=$U),Tu=n(s),u(Jt.$$.fragment,s),hu=n(s),Ut=i(s,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-10606ys"&&(Ut.innerHTML=xU),Ju=n(s),u(wt.$$.fragment,s),Uu=n(s),dt=i(s,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-vug0w0"&&(dt.innerHTML=GU),wu=n(s),Ki=i(s,"A",{id:!0}),U(Ki).forEach(e),du=n(s),u(mt.$$.fragment,s),mu=n(s),ft=i(s,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1gplil1"&&(ft.innerHTML=SU),fu=n(s),It=i(s,"P",{"data-svelte-h":!0}),o(It)!=="svelte-rsdc5h"&&(It.textContent=zU),Iu=n(s),u(Ct.$$.fragment,s),Cu=n(s),bt=i(s,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1ehkqs4"&&(bt.innerHTML=WU),bu=n(s),At=i(s,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1valkuq"&&(At.textContent=kU),Au=n(s),gt=i(s,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1714474"&&(gt.textContent=RU),gu=n(s),u(vt.$$.fragment,s),vu=n(s),_t=i(s,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-nh20cz"&&(_t.innerHTML=NU),_u=n(s),u(Bt.$$.fragment,s),Bu=n(s),Zt=i(s,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-2zmg66"&&(Zt.innerHTML=XU),Zu=n(s),u(qt.$$.fragment,s),qu=n(s),$t=i(s,"P",{"data-svelte-h":!0}),o($t)!=="svelte-tgm4xl"&&($t.textContent=QU),$u=n(s),xt=i(s,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-5k5wyb"&&(xt.innerHTML=EU),xu=n(s),so=i(s,"A",{id:!0}),U(so).forEach(e),Gu=n(s),u(Gt.$$.fragment,s),Su=n(s),St=i(s,"P",{"data-svelte-h":!0}),o(St)!=="svelte-1twydg2"&&(St.innerHTML=HU),zu=n(s),zt=i(s,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1mc0tbi"&&(zt.innerHTML=VU),Wu=n(s),u(Wt.$$.fragment,s),ku=n(s),kt=i(s,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-jyv2rl"&&(kt.innerHTML=YU),Ru=n(s),u(Rt.$$.fragment,s),Nu=n(s),Nt=i(s,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-1cqg1x2"&&(Nt.innerHTML=LU),Xu=n(s),Xt=i(s,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-1ledwpo"&&(Xt.textContent=FU),Qu=n(s),Qt=i(s,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1hl5ia"&&(Qt.innerHTML=DU),Eu=n(s),u(Et.$$.fragment,s),Hu=n(s),Ht=i(s,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-1ujjt16"&&(Ht.innerHTML=PU),Vu=n(s),to=i(s,"A",{id:!0}),U(to).forEach(e),Yu=n(s),u(Vt.$$.fragment,s),Lu=n(s),Yt=i(s,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-14z0759"&&(Yt.innerHTML=OU),Fu=n(s),Lt=i(s,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-1ixfnm8"&&(Lt.textContent=KU),Du=n(s),u(Ft.$$.fragment,s),Pu=n(s),Dt=i(s,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-ylttvt"&&(Dt.textContent=sw),Ou=n(s),u(Pt.$$.fragment,s),Ku=n(s),eo=i(s,"A",{id:!0}),U(eo).forEach(e),sc=n(s),u(Ot.$$.fragment,s),tc=n(s),u(G.$$.fragment,s),ec=n(s),Kt=i(s,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-4skmu4"&&(Kt.innerHTML=tw),lc=n(s),se=i(s,"P",{"data-svelte-h":!0}),o(se)!=="svelte-5la2bj"&&(se.innerHTML=ew),ac=n(s),te=i(s,"P",{"data-svelte-h":!0}),o(te)!=="svelte-ibfrr"&&(te.innerHTML=lw),nc=n(s),ee=i(s,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-969ltr"&&(ee.textContent=aw),pc=n(s),le=i(s,"P",{"data-svelte-h":!0}),o(le)!=="svelte-rtuiz7"&&(le.innerHTML=nw),ic=n(s),ae=i(s,"OL",{"data-svelte-h":!0}),o(ae)!=="svelte-14k1ay7"&&(ae.innerHTML=pw),oc=n(s),ne=i(s,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-yktaar"&&(ne.innerHTML=iw),Mc=n(s),lo=i(s,"A",{id:!0}),U(lo).forEach(e),uc=n(s),u(pe.$$.fragment,s),cc=n(s),ie=i(s,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-24gsuk"&&(ie.innerHTML=ow),rc=n(s),oe=i(s,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-878q4m"&&(oe.innerHTML=Mw),yc=n(s),Me=i(s,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-p4qx3w"&&(Me.innerHTML=uw),jc=n(s),ue=i(s,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-107618e"&&(ue.textContent=cw),Tc=n(s),ao=i(s,"A",{id:!0}),U(ao).forEach(e),hc=n(s),u(ce.$$.fragment,s),Jc=n(s),re=i(s,"P",{"data-svelte-h":!0}),o(re)!=="svelte-15jy11l"&&(re.textContent=rw),Uc=n(s),u(ye.$$.fragment,s),wc=n(s),je=i(s,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1fr2k06"&&(je.innerHTML=yw),dc=n(s),Te=i(s,"UL",{"data-svelte-h":!0}),o(Te)!=="svelte-1dbs24o"&&(Te.innerHTML=jw),mc=n(s),he=i(s,"P",{"data-svelte-h":!0}),o(he)!=="svelte-qsswlv"&&(he.innerHTML=Tw),fc=n(s),u(Je.$$.fragment,s),Ic=n(s),Ue=i(s,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1w7z5ow"&&(Ue.textContent=hw),Cc=n(s),no=i(s,"A",{id:!0}),U(no).forEach(e),bc=n(s),u(we.$$.fragment,s),Ac=n(s),de=i(s,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1tebs8m"&&(de.textContent=Jw),gc=n(s),u(me.$$.fragment,s),vc=n(s),fe=i(s,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1g2nab0"&&(fe.innerHTML=Uw),_c=n(s),Ie=i(s,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-ko8r4h"&&(Ie.innerHTML=ww),Bc=n(s),Ce=i(s,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1fr2k06"&&(Ce.innerHTML=dw),Zc=n(s),be=i(s,"UL",{"data-svelte-h":!0}),o(be)!=="svelte-l43e63"&&(be.innerHTML=mw),qc=n(s),Ae=i(s,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-pylq8y"&&(Ae.innerHTML=fw),$c=n(s),ge=i(s,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1x1c6u9"&&(ge.innerHTML=Iw),xc=n(s),ve=i(s,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-p0gfl6"&&(ve.textContent=Cw),Gc=n(s),_e=i(s,"UL",{"data-svelte-h":!0}),o(_e)!=="svelte-1iwv2ux"&&(_e.innerHTML=bw),Sc=n(s),Be=i(s,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1spjdn9"&&(Be.innerHTML=Aw),zc=n(s),Ze=i(s,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-2klf7u"&&(Ze.innerHTML=gw),Wc=n(s),qe=i(s,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-qdu2k0"&&(qe.innerHTML=vw),kc=n(s),$e=i(s,"UL",{"data-svelte-h":!0}),o($e)!=="svelte-1a9ucw0"&&($e.innerHTML=_w),Rc=n(s),xe=i(s,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1h39ux0"&&(xe.innerHTML=Bw),Nc=n(s),Ge=i(s,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1ykp0a6"&&(Ge.innerHTML=Zw),Xc=n(s),Se=i(s,"OL",{"data-svelte-h":!0}),o(Se)!=="svelte-184i5cb"&&(Se.innerHTML=qw),Qc=n(s),u(ze.$$.fragment,s),Ec=n(s),We=i(s,"P",{"data-svelte-h":!0}),o(We)!=="svelte-d6yedb"&&(We.textContent=$w),Hc=n(s),ke=i(s,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1vpgrfa"&&(ke.textContent=xw),Vc=n(s),u(Re.$$.fragment,s),Yc=n(s),Ne=i(s,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1o9ymaq"&&(Ne.textContent=Gw),Lc=n(s),u(Xe.$$.fragment,s),Fc=n(s),Qe=i(s,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1mxfzxv"&&(Qe.textContent=Sw),Dc=n(s),u(Ee.$$.fragment,s),Pc=n(s),po=i(s,"A",{id:!0}),U(po).forEach(e),Oc=n(s),u(He.$$.fragment,s),Kc=n(s),Ve=i(s,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-169yzfh"&&(Ve.textContent=zw),sr=n(s),Ye=i(s,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-4qz2m"&&(Ye.textContent=Ww),tr=n(s),u(Le.$$.fragment,s),er=n(s),Fe=i(s,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-6el816"&&(Fe.innerHTML=kw),lr=n(s),De=i(s,"P",{"data-svelte-h":!0}),o(De)!=="svelte-muwnvs"&&(De.innerHTML=Rw),ar=n(s),Pe=i(s,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1xgzrsc"&&(Pe.innerHTML=Nw),nr=n(s),Oe=i(s,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-f73cj8"&&(Oe.innerHTML=Xw),pr=n(s),io=i(s,"A",{id:!0}),U(io).forEach(e),ir=n(s),u(Ke.$$.fragment,s),or=n(s),sl=i(s,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-q8gcrr"&&(sl.textContent=Qw),Mr=n(s),tl=i(s,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-zjlf7h"&&(tl.textContent=Ew),ur=n(s),el=i(s,"UL",{"data-svelte-h":!0}),o(el)!=="svelte-11ygmoj"&&(el.innerHTML=Hw),cr=n(s),ll=i(s,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-jwn0zz"&&(ll.innerHTML=Vw),rr=n(s),oo=i(s,"A",{id:!0}),U(oo).forEach(e),yr=n(s),u(al.$$.fragment,s),jr=n(s),nl=i(s,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-kggmat"&&(nl.innerHTML=Yw),Tr=n(s),u(pl.$$.fragment,s),hr=n(s),il=i(s,"P",{"data-svelte-h":!0}),o(il)!=="svelte-1iwd1rz"&&(il.innerHTML=Lw),Jr=n(s),u(ol.$$.fragment,s),Ur=n(s),Mo=i(s,"A",{id:!0}),U(Mo).forEach(e),wr=n(s),u(Ml.$$.fragment,s),dr=n(s),ul=i(s,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-1rafa19"&&(ul.innerHTML=Fw),mr=n(s),u(cl.$$.fragment,s),fr=n(s),rl=i(s,"P",{"data-svelte-h":!0}),o(rl)!=="svelte-1enkn00"&&(rl.innerHTML=Dw),Ir=n(s),u(yl.$$.fragment,s),Cr=n(s),u(jl.$$.fragment,s),br=n(s),Tl=i(s,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-qfhyy9"&&(Tl.textContent=Pw),Ar=n(s),hl=i(s,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-16uf65b"&&(hl.textContent=Ow),gr=n(s),Jl=i(s,"UL",{"data-svelte-h":!0}),o(Jl)!=="svelte-1j4sbsl"&&(Jl.innerHTML=Kw),vr=n(s),Ul=i(s,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1ab7r8x"&&(Ul.textContent=sd),_r=n(s),wl=i(s,"UL",{"data-svelte-h":!0}),o(wl)!=="svelte-covk0c"&&(wl.innerHTML=td),Br=n(s),dl=i(s,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-4dwozd"&&(dl.textContent=ed),Zr=n(s),ml=i(s,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-1dr92i0"&&(ml.textContent=ld),qr=n(s),fl=i(s,"P",{"data-svelte-h":!0}),o(fl)!=="svelte-t7pxdh"&&(fl.textContent=ad),$r=n(s),Il=i(s,"OL",{"data-svelte-h":!0}),o(Il)!=="svelte-287qs6"&&(Il.innerHTML=nd),xr=n(s),Cl=i(s,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-16perix"&&(Cl.textContent=pd),Gr=n(s),bl=i(s,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-1dtmptu"&&(bl.textContent=id),Sr=n(s),Al=i(s,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-1sz5y3k"&&(Al.textContent=od),zr=n(s),gl=i(s,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-1yer2s4"&&(gl.textContent=Md),Wr=n(s),vl=i(s,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-1my41ql"&&(vl.textContent=ud),kr=n(s),_l=i(s,"P",{"data-svelte-h":!0}),o(_l)!=="svelte-10a65tx"&&(_l.innerHTML=cd),Rr=n(s),Bl=i(s,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-11pyqnf"&&(Bl.textContent=rd),Nr=n(s),Zl=i(s,"UL",{"data-svelte-h":!0}),o(Zl)!=="svelte-1d88xai"&&(Zl.innerHTML=yd),Xr=n(s),u(ql.$$.fragment,s),Qr=n(s),$l=i(s,"P",{"data-svelte-h":!0}),o($l)!=="svelte-10cvgi7"&&($l.textContent=jd),Er=n(s),xl=i(s,"P",{"data-svelte-h":!0}),o(xl)!=="svelte-1w613qh"&&(xl.textContent=Td),Hr=n(s),Gl=i(s,"P",{"data-svelte-h":!0}),o(Gl)!=="svelte-s4wgap"&&(Gl.textContent=hd),Vr=n(s),Sl=i(s,"P",{"data-svelte-h":!0}),o(Sl)!=="svelte-c067ql"&&(Sl.textContent=Jd),Yr=n(s),zl=i(s,"OL",{"data-svelte-h":!0}),o(zl)!=="svelte-cglkiv"&&(zl.innerHTML=Ud),Lr=n(s),u(Wl.$$.fragment,s),Fr=n(s),kl=i(s,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-1028ssc"&&(kl.innerHTML=wd),Dr=n(s),Rl=i(s,"P",{"data-svelte-h":!0}),o(Rl)!=="svelte-10k5ql"&&(Rl.innerHTML=dd),Pr=n(s),uo=i(s,"A",{id:!0}),U(uo).forEach(e),Or=n(s),u(Nl.$$.fragment,s),Kr=n(s),Xl=i(s,"P",{"data-svelte-h":!0}),o(Xl)!=="svelte-zvvps7"&&(Xl.innerHTML=md),sy=n(s),Ql=i(s,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-1517cd"&&(Ql.innerHTML=fd),ty=n(s),El=i(s,"P",{"data-svelte-h":!0}),o(El)!=="svelte-qqxtuf"&&(El.innerHTML=Id),ey=n(s),u(Hl.$$.fragment,s),ly=n(s),Vl=i(s,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-1fu4tok"&&(Vl.textContent=Cd),ay=n(s),Yl=i(s,"UL",{"data-svelte-h":!0}),o(Yl)!=="svelte-hhd3hb"&&(Yl.innerHTML=bd),ny=n(s),Ll=i(s,"P",{"data-svelte-h":!0}),o(Ll)!=="svelte-an845p"&&(Ll.textContent=Ad),py=n(s),Fl=i(s,"P",{"data-svelte-h":!0}),o(Fl)!=="svelte-ho8hoo"&&(Fl.textContent=gd),iy=n(s),u(Dl.$$.fragment,s),oy=n(s),Pl=i(s,"P",{"data-svelte-h":!0}),o(Pl)!=="svelte-ck43ig"&&(Pl.innerHTML=vd),My=n(s),Ol=i(s,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-iuz4k6"&&(Ol.textContent=_d),uy=n(s),u(Kl.$$.fragment,s),cy=n(s),sa=i(s,"P",{"data-svelte-h":!0}),o(sa)!=="svelte-1f0ysyu"&&(sa.innerHTML=Bd),ry=n(s),ta=i(s,"P",{"data-svelte-h":!0}),o(ta)!=="svelte-1o7ogjk"&&(ta.innerHTML=Zd),yy=n(s),u(ea.$$.fragment,s),jy=n(s),la=i(s,"P",{"data-svelte-h":!0}),o(la)!=="svelte-qrzd6x"&&(la.textContent=qd),Ty=n(s),co=i(s,"A",{id:!0}),U(co).forEach(e),hy=n(s),u(aa.$$.fragment,s),Jy=n(s),na=i(s,"P",{"data-svelte-h":!0}),o(na)!=="svelte-1bm7jil"&&(na.innerHTML=$d),Uy=n(s),pa=i(s,"P",{"data-svelte-h":!0}),o(pa)!=="svelte-1cqsh10"&&(pa.textContent=xd),wy=n(s),ia=i(s,"UL",{"data-svelte-h":!0}),o(ia)!=="svelte-zirrsg"&&(ia.innerHTML=Gd),dy=n(s),oa=i(s,"P",{"data-svelte-h":!0}),o(oa)!=="svelte-1c7e6f3"&&(oa.innerHTML=Sd),my=n(s),Ma=i(s,"P",{"data-svelte-h":!0}),o(Ma)!=="svelte-w55f7f"&&(Ma.innerHTML=zd),fy=n(s),u(ua.$$.fragment,s),Iy=n(s),ca=i(s,"P",{"data-svelte-h":!0}),o(ca)!=="svelte-1wqye6d"&&(ca.innerHTML=Wd),Cy=n(s),ra=i(s,"UL",{"data-svelte-h":!0}),o(ra)!=="svelte-gr31mi"&&(ra.innerHTML=kd),by=n(s),ya=i(s,"P",{"data-svelte-h":!0}),o(ya)!=="svelte-17pyaox"&&(ya.textContent=Rd),Ay=n(s),u(ja.$$.fragment,s),gy=n(s),Ta=i(s,"P",{"data-svelte-h":!0}),o(Ta)!=="svelte-ck43ig"&&(Ta.innerHTML=Nd),vy=n(s),ha=i(s,"P",{"data-svelte-h":!0}),o(ha)!=="svelte-1lf5l3z"&&(ha.innerHTML=Xd),_y=n(s),u(Ja.$$.fragment,s),By=n(s),Ua=i(s,"P",{"data-svelte-h":!0}),o(Ua)!=="svelte-qnxoz2"&&(Ua.innerHTML=Qd),Zy=n(s),ro=i(s,"A",{id:!0}),U(ro).forEach(e),qy=n(s),u(wa.$$.fragment,s),$y=n(s),da=i(s,"P",{"data-svelte-h":!0}),o(da)!=="svelte-1dvil4m"&&(da.textContent=Ed),xy=n(s),ma=i(s,"P",{"data-svelte-h":!0}),o(ma)!=="svelte-m827p9"&&(ma.innerHTML=Hd),Gy=n(s),u(fa.$$.fragment,s),Sy=n(s),Ia=i(s,"P",{"data-svelte-h":!0}),o(Ia)!=="svelte-bdy26k"&&(Ia.innerHTML=Vd),zy=n(s),Ca=i(s,"P",{"data-svelte-h":!0}),o(Ca)!=="svelte-kydp6d"&&(Ca.innerHTML=Yd),Wy=n(s),yo=i(s,"A",{id:!0}),U(yo).forEach(e),ky=n(s),u(ba.$$.fragment,s),Ry=n(s),Aa=i(s,"P",{"data-svelte-h":!0}),o(Aa)!=="svelte-kybyhn"&&(Aa.textContent=Ld),Ny=n(s),u(ga.$$.fragment,s),Xy=n(s),va=i(s,"P",{"data-svelte-h":!0}),o(va)!=="svelte-cwa3yk"&&(va.textContent=Fd),Qy=n(s),u(_a.$$.fragment,s),Ey=n(s),Ba=i(s,"P",{"data-svelte-h":!0}),o(Ba)!=="svelte-yb5edr"&&(Ba.innerHTML=Dd),Hy=n(s),Za=i(s,"P",{"data-svelte-h":!0}),o(Za)!=="svelte-pmyaoj"&&(Za.innerHTML=Pd),Vy=n(s),qa=i(s,"P",{"data-svelte-h":!0}),o(qa)!=="svelte-1nyp904"&&(qa.textContent=Od),Yy=n(s),u($a.$$.fragment,s),Ly=n(s),xa=i(s,"P",{"data-svelte-h":!0}),o(xa)!=="svelte-ck43ig"&&(xa.innerHTML=Kd),Fy=n(s),Ga=i(s,"P",{"data-svelte-h":!0}),o(Ga)!=="svelte-12xhtcc"&&(Ga.innerHTML=sm),Dy=n(s),u(Sa.$$.fragment,s),Py=n(s),za=i(s,"P",{"data-svelte-h":!0}),o(za)!=="svelte-169tzv7"&&(za.textContent=tm),Oy=n(s),u(Wa.$$.fragment,s),Ky=n(s),ka=i(s,"P",{"data-svelte-h":!0}),o(ka)!=="svelte-5n7z7p"&&(ka.textContent=em),sj=n(s),Ra=i(s,"P",{"data-svelte-h":!0}),o(Ra)!=="svelte-1nldlad"&&(Ra.innerHTML=lm),tj=n(s),Na=i(s,"P",{"data-svelte-h":!0}),o(Na)!=="svelte-1nyp904"&&(Na.textContent=am),ej=n(s),u(Xa.$$.fragment,s),lj=n(s),u(S.$$.fragment,s),aj=n(s),u(Qa.$$.fragment,s),nj=n(s),Ea=i(s,"P",{"data-svelte-h":!0}),o(Ea)!=="svelte-1u92iuj"&&(Ea.innerHTML=nm),pj=n(s),Ha=i(s,"P",{"data-svelte-h":!0}),o(Ha)!=="svelte-86oqji"&&(Ha.innerHTML=pm),ij=n(s),Va=i(s,"P",{"data-svelte-h":!0}),o(Va)!=="svelte-qbyzy7"&&(Va.innerHTML=im),oj=n(s),Ya=i(s,"P",{"data-svelte-h":!0}),o(Ya)!=="svelte-jwyw4f"&&(Ya.textContent=om),Mj=n(s),u(La.$$.fragment,s),uj=n(s),Fa=i(s,"P",{"data-svelte-h":!0}),o(Fa)!=="svelte-1o8aerk"&&(Fa.textContent=Mm),cj=n(s),Da=i(s,"P",{"data-svelte-h":!0}),o(Da)!=="svelte-1i0626v"&&(Da.innerHTML=um),rj=n(s),u(Pa.$$.fragment,s),yj=n(s),Oa=i(s,"P",{"data-svelte-h":!0}),o(Oa)!=="svelte-1iq1d9w"&&(Oa.textContent=cm),jj=n(s),u(Ka.$$.fragment,s),Tj=n(s),sn=i(s,"P",{"data-svelte-h":!0}),o(sn)!=="svelte-ekevgg"&&(sn.innerHTML=rm),hj=n(s),tn=i(s,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-1dbs7ls"&&(tn.innerHTML=ym),Jj=n(s),en=i(s,"P",{"data-svelte-h":!0}),o(en)!=="svelte-1h83nqw"&&(en.textContent=jm),Uj=n(s),u(ln.$$.fragment,s),wj=n(s),an=i(s,"P",{"data-svelte-h":!0}),o(an)!=="svelte-ck43ig"&&(an.innerHTML=Tm),dj=n(s),nn=i(s,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-5l4nm8"&&(nn.innerHTML=hm),mj=n(s),jo=i(s,"A",{id:!0}),U(jo).forEach(e),fj=n(s),u(pn.$$.fragment,s),Ij=n(s),on=i(s,"P",{"data-svelte-h":!0}),o(on)!=="svelte-xs1yap"&&(on.textContent=Jm),Cj=n(s),u(Mn.$$.fragment,s),bj=n(s),un=i(s,"P",{"data-svelte-h":!0}),o(un)!=="svelte-qs0ei"&&(un.innerHTML=Um),Aj=n(s),cn=i(s,"P",{"data-svelte-h":!0}),o(cn)!=="svelte-ho8hoo"&&(cn.textContent=wm),gj=n(s),u(rn.$$.fragment,s),vj=n(s),yn=i(s,"P",{"data-svelte-h":!0}),o(yn)!=="svelte-ck43ig"&&(yn.innerHTML=dm),_j=n(s),To=i(s,"A",{id:!0}),U(To).forEach(e),Bj=n(s),u(jn.$$.fragment,s),Zj=n(s),Tn=i(s,"P",{"data-svelte-h":!0}),o(Tn)!=="svelte-117mynk"&&(Tn.textContent=mm),qj=n(s),u(hn.$$.fragment,s),$j=n(s),Jn=i(s,"P",{"data-svelte-h":!0}),o(Jn)!=="svelte-p4mwjb"&&(Jn.innerHTML=fm),xj=n(s),Un=i(s,"P",{"data-svelte-h":!0}),o(Un)!=="svelte-1ml0uo7"&&(Un.textContent=Im),Gj=n(s),u(wn.$$.fragment,s),Sj=n(s),dn=i(s,"P",{"data-svelte-h":!0}),o(dn)!=="svelte-ck43ig"&&(dn.innerHTML=Cm),zj=n(s),ho=i(s,"A",{id:!0}),U(ho).forEach(e),Wj=n(s),u(mn.$$.fragment,s),kj=n(s),fn=i(s,"P",{"data-svelte-h":!0}),o(fn)!=="svelte-5w86or"&&(fn.textContent=bm),Rj=n(s),u(In.$$.fragment,s),Nj=n(s),Cn=i(s,"P",{"data-svelte-h":!0}),o(Cn)!=="svelte-wyl29v"&&(Cn.innerHTML=Am),Xj=n(s),bn=i(s,"P",{"data-svelte-h":!0}),o(bn)!=="svelte-1ml0uo7"&&(bn.textContent=gm),Qj=n(s),u(An.$$.fragment,s),Ej=n(s),gn=i(s,"P",{"data-svelte-h":!0}),o(gn)!=="svelte-ck43ig"&&(gn.innerHTML=vm),Hj=n(s),Jo=i(s,"A",{id:!0}),U(Jo).forEach(e),Vj=n(s),u(vn.$$.fragment,s),Yj=n(s),_n=i(s,"P",{"data-svelte-h":!0}),o(_n)!=="svelte-17ht9wx"&&(_n.innerHTML=_m),Lj=n(s),Bn=i(s,"P",{"data-svelte-h":!0}),o(Bn)!=="svelte-1w3rd8v"&&(Bn.innerHTML=Bm),Fj=n(s),Zn=i(s,"P",{"data-svelte-h":!0}),o(Zn)!=="svelte-skbdco"&&(Zn.innerHTML=Zm),Dj=n(s),qn=i(s,"P",{"data-svelte-h":!0}),o(qn)!=="svelte-1bhjkyj"&&(qn.innerHTML=qm),Pj=n(s),u($n.$$.fragment,s),Oj=n(s),xn=i(s,"P",{"data-svelte-h":!0}),o(xn)!=="svelte-smfkl9"&&(xn.innerHTML=$m),Kj=n(s),Gn=i(s,"P",{"data-svelte-h":!0}),o(Gn)!=="svelte-dunk9g"&&(Gn.innerHTML=xm),sT=n(s),Sn=i(s,"P",{"data-svelte-h":!0}),o(Sn)!=="svelte-1lyq672"&&(Sn.innerHTML=Gm),tT=n(s),zn=i(s,"P",{"data-svelte-h":!0}),o(zn)!=="svelte-1alw0cq"&&(zn.textContent=Sm),eT=n(s),Wn=i(s,"P",{"data-svelte-h":!0}),o(Wn)!=="svelte-vnz9bj"&&(Wn.textContent=zm),lT=n(s),u(kn.$$.fragment,s),aT=n(s),Rn=i(s,"P",{"data-svelte-h":!0}),o(Rn)!=="svelte-1kitce"&&(Rn.innerHTML=Wm),nT=n(s),u(Nn.$$.fragment,s),pT=n(s),u(z.$$.fragment,s),iT=n(s),Xn=i(s,"P",{"data-svelte-h":!0}),o(Xn)!=="svelte-46af4q"&&(Xn.innerHTML=km),oT=n(s),Qn=i(s,"P",{"data-svelte-h":!0}),o(Qn)!=="svelte-1k7xvv3"&&(Qn.innerHTML=Rm),MT=n(s),u(En.$$.fragment,s),uT=n(s),Hn=i(s,"P",{"data-svelte-h":!0}),o(Hn)!=="svelte-75olud"&&(Hn.innerHTML=Nm),cT=n(s),Vn=i(s,"P",{"data-svelte-h":!0}),o(Vn)!=="svelte-1c769bq"&&(Vn.innerHTML=Xm),rT=n(s),Yn=i(s,"P",{"data-svelte-h":!0}),o(Yn)!=="svelte-x82t5s"&&(Yn.textContent=Qm),yT=n(s),u(Ln.$$.fragment,s),jT=n(s),Fn=i(s,"P",{"data-svelte-h":!0}),o(Fn)!=="svelte-nly9am"&&(Fn.innerHTML=Em),TT=n(s),u(Dn.$$.fragment,s),hT=n(s),Pn=i(s,"P",{"data-svelte-h":!0}),o(Pn)!=="svelte-1y5jgb5"&&(Pn.innerHTML=Hm),JT=n(s),On=i(s,"P",{"data-svelte-h":!0}),o(On)!=="svelte-3pqf1n"&&(On.textContent=Vm),UT=n(s),Kn=i(s,"P",{"data-svelte-h":!0}),o(Kn)!=="svelte-9879ii"&&(Kn.innerHTML=Ym),wT=n(s),sp=i(s,"P",{"data-svelte-h":!0}),o(sp)!=="svelte-13yg7dv"&&(sp.innerHTML=Lm),dT=n(s),tp=i(s,"P",{"data-svelte-h":!0}),o(tp)!=="svelte-1wfe5kh"&&(tp.textContent=Fm),mT=n(s),u(ep.$$.fragment,s),fT=n(s),lp=i(s,"P",{"data-svelte-h":!0}),o(lp)!=="svelte-1m0vnge"&&(lp.textContent=Dm),IT=n(s),ap=i(s,"P",{"data-svelte-h":!0}),o(ap)!=="svelte-1vst44s"&&(ap.textContent=Pm),CT=n(s),np=i(s,"P",{"data-svelte-h":!0}),o(np)!=="svelte-zk7rbv"&&(np.textContent=Om),bT=n(s),u(pp.$$.fragment,s),AT=n(s),ip=i(s,"P",{"data-svelte-h":!0}),o(ip)!=="svelte-17kyo4r"&&(ip.innerHTML=Km),gT=n(s),u(op.$$.fragment,s),vT=n(s),Mp=i(s,"P",{"data-svelte-h":!0}),o(Mp)!=="svelte-12v8sdv"&&(Mp.textContent=sf),_T=n(s),up=i(s,"P",{"data-svelte-h":!0}),o(up)!=="svelte-bnntt2"&&(up.innerHTML=tf),BT=n(s),u(cp.$$.fragment,s),ZT=n(s),rp=i(s,"P",{"data-svelte-h":!0}),o(rp)!=="svelte-1citdyb"&&(rp.innerHTML=ef),qT=n(s),yp=i(s,"P",{"data-svelte-h":!0}),o(yp)!=="svelte-1iltlt8"&&(yp.textContent=lf),$T=n(s),jp=i(s,"P",{"data-svelte-h":!0}),o(jp)!=="svelte-lvtfhp"&&(jp.innerHTML=af),xT=n(s),Tp=i(s,"P",{"data-svelte-h":!0}),o(Tp)!=="svelte-ifovwy"&&(Tp.innerHTML=nf),GT=n(s),u(hp.$$.fragment,s),ST=n(s),Jp=i(s,"P",{"data-svelte-h":!0}),o(Jp)!=="svelte-1m7dsvx"&&(Jp.innerHTML=pf),zT=n(s),Up=i(s,"P",{"data-svelte-h":!0}),o(Up)!=="svelte-zsc548"&&(Up.innerHTML=of),WT=n(s),wp=i(s,"P",{"data-svelte-h":!0}),o(wp)!=="svelte-112tcb5"&&(wp.textContent=Mf),kT=n(s),u(dp.$$.fragment,s),RT=n(s),mp=i(s,"P",{"data-svelte-h":!0}),o(mp)!=="svelte-1hh79bp"&&(mp.innerHTML=uf),NT=n(s),Uo=i(s,"A",{id:!0}),U(Uo).forEach(e),XT=n(s),u(fp.$$.fragment,s),QT=n(s),Ip=i(s,"P",{"data-svelte-h":!0}),o(Ip)!=="svelte-1kc5zro"&&(Ip.textContent=cf),ET=n(s),Cp=i(s,"P",{"data-svelte-h":!0}),o(Cp)!=="svelte-19ais62"&&(Cp.innerHTML=rf),HT=n(s),u(bp.$$.fragment,s),VT=n(s),Ap=i(s,"P",{"data-svelte-h":!0}),o(Ap)!=="svelte-y0v7ku"&&(Ap.textContent=yf),YT=n(s),gp=i(s,"P",{"data-svelte-h":!0}),o(gp)!=="svelte-1jem9f9"&&(gp.innerHTML=jf),LT=n(s),u(vp.$$.fragment,s),FT=n(s),_p=i(s,"P",{"data-svelte-h":!0}),o(_p)!=="svelte-1dep852"&&(_p.textContent=Tf),DT=n(s),Bp=i(s,"P",{"data-svelte-h":!0}),o(Bp)!=="svelte-j75mu1"&&(Bp.textContent=hf),PT=n(s),u(Zp.$$.fragment,s),OT=n(s),qp=i(s,"P",{"data-svelte-h":!0}),o(qp)!=="svelte-ezkzj2"&&(qp.textContent=Jf),KT=n(s),$p=i(s,"P",{"data-svelte-h":!0}),o($p)!=="svelte-1ugusnt"&&($p.textContent=Uf),sh=n(s),u(xp.$$.fragment,s),th=n(s),Gp=i(s,"P",{"data-svelte-h":!0}),o(Gp)!=="svelte-ct9ez8"&&(Gp.textContent=wf),eh=n(s),Sp=i(s,"P",{"data-svelte-h":!0}),o(Sp)!=="svelte-s1px3l"&&(Sp.textContent=df),lh=n(s),zp=i(s,"P",{"data-svelte-h":!0}),o(zp)!=="svelte-bmrnhs"&&(zp.textContent=mf),ah=n(s),Wp=i(s,"P",{"data-svelte-h":!0}),o(Wp)!=="svelte-g2c16a"&&(Wp.textContent=ff),nh=n(s),u(kp.$$.fragment,s),ph=n(s),Rp=i(s,"P",{"data-svelte-h":!0}),o(Rp)!=="svelte-9c1q51"&&(Rp.textContent=If),ih=n(s),Np=i(s,"P",{"data-svelte-h":!0}),o(Np)!=="svelte-24xeo5"&&(Np.innerHTML=Cf),oh=n(s),u(Xp.$$.fragment,s),Mh=n(s),Qp=i(s,"P",{"data-svelte-h":!0}),o(Qp)!=="svelte-1kab485"&&(Qp.textContent=bf),uh=n(s),Ep=i(s,"P",{"data-svelte-h":!0}),o(Ep)!=="svelte-1oebycv"&&(Ep.textContent=Af),ch=n(s),C=i(s,"OL",{});var A=U(C);wo=i(A,"LI",{"data-svelte-h":!0}),o(wo)!=="svelte-rrz71w"&&(wo.innerHTML=gf),TJ=n(A),mo=i(A,"LI",{"data-svelte-h":!0}),o(mo)!=="svelte-hv873h"&&(mo.innerHTML=vf),hJ=n(A),Hp=i(A,"LI",{});var rJ=U(Hp);fo=i(rJ,"P",{"data-svelte-h":!0}),o(fo)!=="svelte-1ncrygs"&&(fo.textContent=_f),JJ=n(rJ),u(Vp.$$.fragment,rJ),rJ.forEach(e),UJ=n(A),Io=i(A,"LI",{"data-svelte-h":!0}),o(Io)!=="svelte-tdhskc"&&(Io.innerHTML=Bf),wJ=n(A),Co=i(A,"LI",{"data-svelte-h":!0}),o(Co)!=="svelte-1bwmgyk"&&(Co.innerHTML=Zf),dJ=n(A),bo=i(A,"LI",{"data-svelte-h":!0}),o(bo)!=="svelte-ql9qyt"&&(bo.innerHTML=qf),A.forEach(e),rh=n(s),Yp=i(s,"P",{"data-svelte-h":!0}),o(Yp)!=="svelte-3g72th"&&(Yp.textContent=$f),yh=n(s),Lp=i(s,"UL",{"data-svelte-h":!0}),o(Lp)!=="svelte-2bwbor"&&(Lp.innerHTML=xf),jh=n(s),u(Fp.$$.fragment,s),Th=n(s),u(Dp.$$.fragment,s),hh=n(s),Pp=i(s,"P",{"data-svelte-h":!0}),o(Pp)!=="svelte-1uwonxy"&&(Pp.innerHTML=Gf),Jh=n(s),u(Op.$$.fragment,s),Uh=n(s),Kp=i(s,"P",{"data-svelte-h":!0}),o(Kp)!=="svelte-6et3o9"&&(Kp.textContent=Sf),wh=n(s),si=i(s,"P",{"data-svelte-h":!0}),o(si)!=="svelte-zoxbhu"&&(si.textContent=zf),dh=n(s),u(ti.$$.fragment,s),mh=n(s),ei=i(s,"P",{"data-svelte-h":!0}),o(ei)!=="svelte-ivzk1k"&&(ei.innerHTML=Wf),fh=n(s),u(li.$$.fragment,s),Ih=n(s),ai=i(s,"P",{"data-svelte-h":!0}),o(ai)!=="svelte-ee4ukj"&&(ai.textContent=kf),Ch=n(s),ni=i(s,"P",{"data-svelte-h":!0}),o(ni)!=="svelte-7t5s0l"&&(ni.textContent=Rf),bh=n(s),pi=i(s,"P",{"data-svelte-h":!0}),o(pi)!=="svelte-1dvgk5f"&&(pi.innerHTML=Nf),Ah=n(s),u(ii.$$.fragment,s),gh=n(s),oi=i(s,"UL",{"data-svelte-h":!0}),o(oi)!=="svelte-1x5vkjd"&&(oi.innerHTML=Xf),vh=n(s),u(Mi.$$.fragment,s),_h=n(s),ui=i(s,"P",{"data-svelte-h":!0}),o(ui)!=="svelte-1f0huw1"&&(ui.innerHTML=Qf),Bh=n(s),ci=i(s,"P",{"data-svelte-h":!0}),o(ci)!=="svelte-1h4cg5o"&&(ci.innerHTML=Ef),Zh=n(s),ri=i(s,"P",{"data-svelte-h":!0}),o(ri)!=="svelte-qbo1w4"&&(ri.innerHTML=Hf),qh=n(s),yi=i(s,"P",{"data-svelte-h":!0}),o(yi)!=="svelte-1g6cule"&&(yi.innerHTML=Vf),$h=n(s),ji=i(s,"P",{"data-svelte-h":!0}),o(ji)!=="svelte-1l1ss1c"&&(ji.textContent=Yf),xh=n(s),u(Ti.$$.fragment,s),Gh=n(s),hi=i(s,"P",{"data-svelte-h":!0}),o(hi)!=="svelte-1svk6rj"&&(hi.textContent=Lf),Sh=n(s),u(Ji.$$.fragment,s),zh=n(s),Ui=i(s,"P",{"data-svelte-h":!0}),o(Ui)!=="svelte-1mh1rgh"&&(Ui.innerHTML=Ff),Wh=n(s),u(wi.$$.fragment,s),kh=n(s),_=i(s,"DIV",{class:!0});var W=U(_);u(di.$$.fragment,W),mJ=n(W),Ao=i(W,"P",{"data-svelte-h":!0}),o(Ao)!=="svelte-g6t8ro"&&(Ao.textContent=Df),fJ=n(W),go=i(W,"P",{"data-svelte-h":!0}),o(go)!=="svelte-xzx2jk"&&(go.innerHTML=Pf),IJ=n(W),vo=i(W,"P",{"data-svelte-h":!0}),o(vo)!=="svelte-3t87ts"&&(vo.innerHTML=Of),W.forEach(e),Rh=n(s),u(mi.$$.fragment,s),Nh=n(s),fi=i(s,"P",{"data-svelte-h":!0}),o(fi)!=="svelte-3n25ok"&&(fi.innerHTML=Kf),Xh=n(s),Ii=i(s,"P",{"data-svelte-h":!0}),o(Ii)!=="svelte-1kok2zl"&&(Ii.textContent=sI),Qh=n(s),Ci=i(s,"P",{"data-svelte-h":!0}),o(Ci)!=="svelte-2awh2l"&&(Ci.textContent=tI),Eh=n(s),bi=i(s,"P",{"data-svelte-h":!0}),o(bi)!=="svelte-o4r1i6"&&(bi.textContent=eI),Hh=n(s),Ai=i(s,"OL",{"data-svelte-h":!0}),o(Ai)!=="svelte-1kuo9hl"&&(Ai.innerHTML=lI),Vh=n(s),u(gi.$$.fragment,s),Yh=n(s),vi=i(s,"P",{"data-svelte-h":!0}),o(vi)!=="svelte-1boyjju"&&(vi.innerHTML=aI),Lh=n(s),u(_i.$$.fragment,s),Fh=n(s),Bi=i(s,"P",{"data-svelte-h":!0}),o(Bi)!=="svelte-1ezcpn"&&(Bi.textContent=nI),Dh=n(s),u(Zi.$$.fragment,s),Ph=n(s),qi=i(s,"P",{"data-svelte-h":!0}),o(qi)!=="svelte-1blwf7x"&&(qi.innerHTML=pI),Oh=n(s),$i=i(s,"P",{"data-svelte-h":!0}),o($i)!=="svelte-h0s2m6"&&($i.innerHTML=iI),Kh=n(s),u(xi.$$.fragment,s),sJ=n(s),Gi=i(s,"P",{"data-svelte-h":!0}),o(Gi)!=="svelte-14hjhxw"&&(Gi.textContent=oI),tJ=n(s),Si=i(s,"P",{"data-svelte-h":!0}),o(Si)!=="svelte-59lrmj"&&(Si.textContent=MI),eJ=n(s),u(zi.$$.fragment,s),lJ=n(s),Wi=i(s,"P",{"data-svelte-h":!0}),o(Wi)!=="svelte-xyk76s"&&(Wi.textContent=uI),aJ=n(s),u(ki.$$.fragment,s),nJ=n(s),u(Ri.$$.fragment,s),pJ=n(s),Ni=i(s,"UL",{"data-svelte-h":!0}),o(Ni)!=="svelte-qibs9v"&&(Ni.innerHTML=cI),iJ=n(s),Xi=i(s,"P",{"data-svelte-h":!0}),o(Xi)!=="svelte-1pnpyer"&&(Xi.textContent=rI),oJ=n(s),Qi=i(s,"UL",{"data-svelte-h":!0}),o(Qi)!=="svelte-teaul9"&&(Qi.innerHTML=yI),MJ=n(s),Ei=i(s,"P",{"data-svelte-h":!0}),o(Ei)!=="svelte-z48g7w"&&(Ei.innerHTML=jI),uJ=n(s),Bo=i(s,"P",{}),U(Bo).forEach(e),this.h()},h(){w(J,"name","hf:doc:metadata"),w(J,"content",bI),w(Hi,"id","deepspeed-trainer-integration"),w(Vi,"id","deepspeed-installation"),w(Yi,"id","deepspeed-multi-gpu"),w(Li,"id","deepspeed-one-gpu"),w(Oi,"id","deepspeed-multi-node"),w(Ki,"id","deepspeed-notebook"),w(so,"id","deepspeed-config"),w(to,"id","deepspeed-config-passing"),w(eo,"id","deepspeed-config-shared"),w(lo,"id","deepspeed-zero"),w(ao,"id","deepspeed-zero2-config"),w(no,"id","deepspeed-zero3-config"),w(po,"id","deepspeed-nvme"),w(io,"id","deepspeed-zero2-zero3-performance"),w(oo,"id","deepspeed-zero2-example"),w(Mo,"id","deepspeed-zero3-example"),w(uo,"id","deepspeed-optimizer"),w(co,"id","deepspeed-scheduler"),w(ro,"id","deepspeed-fp32"),w(yo,"id","deepspeed-amp"),w(jo,"id","deepspeed-bs"),w(To,"id","deepspeed-grad-acc"),w(ho,"id","deepspeed-grad-clip"),w(Jo,"id","deepspeed-weight-extraction"),w(Uo,"id","deepspeed-zero-inference"),w(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,t){d(document.head,J),l(s,g,t),l(s,m,t),l(s,I,t),c(B,s,t),l(s,Z,t),l(s,b,t),l(s,f,t),l(s,v,t),l(s,qo,t),l(s,k,t),l(s,$o,t),l(s,R,t),l(s,xo,t),l(s,N,t),l(s,Go,t),l(s,X,t),l(s,So,t),l(s,Q,t),l(s,zo,t),l(s,E,t),l(s,Wo,t),l(s,H,t),l(s,ko,t),l(s,V,t),l(s,Ro,t),l(s,Y,t),l(s,No,t),l(s,L,t),l(s,Xo,t),l(s,F,t),l(s,Qo,t),l(s,Hi,t),l(s,Eo,t),c(D,s,t),l(s,Ho,t),l(s,Vi,t),l(s,Vo,t),c(P,s,t),l(s,Yo,t),l(s,O,t),l(s,Lo,t),c(K,s,t),l(s,Fo,t),l(s,ss,t),l(s,Do,t),c(ts,s,t),l(s,Po,t),l(s,es,t),l(s,Oo,t),l(s,ls,t),l(s,Ko,t),l(s,as,t),l(s,sM,t),l(s,ns,t),l(s,tM,t),c(ps,s,t),l(s,eM,t),l(s,is,t),l(s,lM,t),l(s,os,t),l(s,aM,t),c(Ms,s,t),l(s,nM,t),l(s,us,t),l(s,pM,t),l(s,cs,t),l(s,iM,t),c(rs,s,t),l(s,oM,t),l(s,ys,t),l(s,MM,t),l(s,js,t),l(s,uM,t),l(s,Ts,t),l(s,cM,t),l(s,hs,t),l(s,rM,t),c(Js,s,t),l(s,yM,t),l(s,Us,t),l(s,jM,t),c(ws,s,t),l(s,TM,t),l(s,ds,t),l(s,hM,t),c(ms,s,t),l(s,JM,t),l(s,fs,t),l(s,UM,t),l(s,Is,t),l(s,wM,t),l(s,Cs,t),l(s,dM,t),l(s,Yi,t),l(s,mM,t),c(bs,s,t),l(s,fM,t),l(s,As,t),l(s,IM,t),l(s,gs,t),l(s,CM,t),c(vs,s,t),l(s,bM,t),l(s,_s,t),l(s,AM,t),c(Bs,s,t),l(s,gM,t),l(s,Zs,t),l(s,vM,t),l(s,qs,t),l(s,_M,t),l(s,$s,t),l(s,BM,t),c(xs,s,t),l(s,ZM,t),l(s,Gs,t),l(s,qM,t),l(s,Ss,t),l(s,$M,t),l(s,Li,t),l(s,xM,t),c(zs,s,t),l(s,GM,t),l(s,Ws,t),l(s,SM,t),c(ks,s,t),l(s,zM,t),l(s,Rs,t),l(s,WM,t),l(s,Ns,t),l(s,kM,t),l(s,Xs,t),l(s,RM,t),l(s,Qs,t),l(s,NM,t),c(Es,s,t),l(s,XM,t),l(s,Hs,t),l(s,QM,t),l(s,Vs,t),l(s,EM,t),l(s,Ys,t),l(s,HM,t),l(s,Ls,t),l(s,VM,t),l(s,Fi,t),d(Fi,q),d(q,Di),d(q,yJ),c(Fs,q,null),d(q,jJ),d(q,Pi),l(s,YM,t),l(s,Oi,t),l(s,LM,t),c(Ds,s,t),l(s,FM,t),l(s,Ps,t),l(s,DM,t),l(s,Os,t),l(s,PM,t),c(Ks,s,t),l(s,OM,t),l(s,st,t),l(s,KM,t),c(tt,s,t),l(s,su,t),l(s,et,t),l(s,tu,t),l(s,lt,t),l(s,eu,t),c(at,s,t),l(s,lu,t),l(s,nt,t),l(s,au,t),c(pt,s,t),l(s,nu,t),l(s,it,t),l(s,pu,t),c(ot,s,t),l(s,iu,t),l(s,Mt,t),l(s,ou,t),l(s,ut,t),l(s,Mu,t),c(ct,s,t),l(s,uu,t),l(s,rt,t),l(s,cu,t),c(yt,s,t),l(s,ru,t),l(s,jt,t),l(s,yu,t),c(Tt,s,t),l(s,ju,t),l(s,ht,t),l(s,Tu,t),c(Jt,s,t),l(s,hu,t),l(s,Ut,t),l(s,Ju,t),c(wt,s,t),l(s,Uu,t),l(s,dt,t),l(s,wu,t),l(s,Ki,t),l(s,du,t),c(mt,s,t),l(s,mu,t),l(s,ft,t),l(s,fu,t),l(s,It,t),l(s,Iu,t),c(Ct,s,t),l(s,Cu,t),l(s,bt,t),l(s,bu,t),l(s,At,t),l(s,Au,t),l(s,gt,t),l(s,gu,t),c(vt,s,t),l(s,vu,t),l(s,_t,t),l(s,_u,t),c(Bt,s,t),l(s,Bu,t),l(s,Zt,t),l(s,Zu,t),c(qt,s,t),l(s,qu,t),l(s,$t,t),l(s,$u,t),l(s,xt,t),l(s,xu,t),l(s,so,t),l(s,Gu,t),c(Gt,s,t),l(s,Su,t),l(s,St,t),l(s,zu,t),l(s,zt,t),l(s,Wu,t),c(Wt,s,t),l(s,ku,t),l(s,kt,t),l(s,Ru,t),c(Rt,s,t),l(s,Nu,t),l(s,Nt,t),l(s,Xu,t),l(s,Xt,t),l(s,Qu,t),l(s,Qt,t),l(s,Eu,t),c(Et,s,t),l(s,Hu,t),l(s,Ht,t),l(s,Vu,t),l(s,to,t),l(s,Yu,t),c(Vt,s,t),l(s,Lu,t),l(s,Yt,t),l(s,Fu,t),l(s,Lt,t),l(s,Du,t),c(Ft,s,t),l(s,Pu,t),l(s,Dt,t),l(s,Ou,t),c(Pt,s,t),l(s,Ku,t),l(s,eo,t),l(s,sc,t),c(Ot,s,t),l(s,tc,t),c(G,s,t),l(s,ec,t),l(s,Kt,t),l(s,lc,t),l(s,se,t),l(s,ac,t),l(s,te,t),l(s,nc,t),l(s,ee,t),l(s,pc,t),l(s,le,t),l(s,ic,t),l(s,ae,t),l(s,oc,t),l(s,ne,t),l(s,Mc,t),l(s,lo,t),l(s,uc,t),c(pe,s,t),l(s,cc,t),l(s,ie,t),l(s,rc,t),l(s,oe,t),l(s,yc,t),l(s,Me,t),l(s,jc,t),l(s,ue,t),l(s,Tc,t),l(s,ao,t),l(s,hc,t),c(ce,s,t),l(s,Jc,t),l(s,re,t),l(s,Uc,t),c(ye,s,t),l(s,wc,t),l(s,je,t),l(s,dc,t),l(s,Te,t),l(s,mc,t),l(s,he,t),l(s,fc,t),c(Je,s,t),l(s,Ic,t),l(s,Ue,t),l(s,Cc,t),l(s,no,t),l(s,bc,t),c(we,s,t),l(s,Ac,t),l(s,de,t),l(s,gc,t),c(me,s,t),l(s,vc,t),l(s,fe,t),l(s,_c,t),l(s,Ie,t),l(s,Bc,t),l(s,Ce,t),l(s,Zc,t),l(s,be,t),l(s,qc,t),l(s,Ae,t),l(s,$c,t),l(s,ge,t),l(s,xc,t),l(s,ve,t),l(s,Gc,t),l(s,_e,t),l(s,Sc,t),l(s,Be,t),l(s,zc,t),l(s,Ze,t),l(s,Wc,t),l(s,qe,t),l(s,kc,t),l(s,$e,t),l(s,Rc,t),l(s,xe,t),l(s,Nc,t),l(s,Ge,t),l(s,Xc,t),l(s,Se,t),l(s,Qc,t),c(ze,s,t),l(s,Ec,t),l(s,We,t),l(s,Hc,t),l(s,ke,t),l(s,Vc,t),c(Re,s,t),l(s,Yc,t),l(s,Ne,t),l(s,Lc,t),c(Xe,s,t),l(s,Fc,t),l(s,Qe,t),l(s,Dc,t),c(Ee,s,t),l(s,Pc,t),l(s,po,t),l(s,Oc,t),c(He,s,t),l(s,Kc,t),l(s,Ve,t),l(s,sr,t),l(s,Ye,t),l(s,tr,t),c(Le,s,t),l(s,er,t),l(s,Fe,t),l(s,lr,t),l(s,De,t),l(s,ar,t),l(s,Pe,t),l(s,nr,t),l(s,Oe,t),l(s,pr,t),l(s,io,t),l(s,ir,t),c(Ke,s,t),l(s,or,t),l(s,sl,t),l(s,Mr,t),l(s,tl,t),l(s,ur,t),l(s,el,t),l(s,cr,t),l(s,ll,t),l(s,rr,t),l(s,oo,t),l(s,yr,t),c(al,s,t),l(s,jr,t),l(s,nl,t),l(s,Tr,t),c(pl,s,t),l(s,hr,t),l(s,il,t),l(s,Jr,t),c(ol,s,t),l(s,Ur,t),l(s,Mo,t),l(s,wr,t),c(Ml,s,t),l(s,dr,t),l(s,ul,t),l(s,mr,t),c(cl,s,t),l(s,fr,t),l(s,rl,t),l(s,Ir,t),c(yl,s,t),l(s,Cr,t),c(jl,s,t),l(s,br,t),l(s,Tl,t),l(s,Ar,t),l(s,hl,t),l(s,gr,t),l(s,Jl,t),l(s,vr,t),l(s,Ul,t),l(s,_r,t),l(s,wl,t),l(s,Br,t),l(s,dl,t),l(s,Zr,t),l(s,ml,t),l(s,qr,t),l(s,fl,t),l(s,$r,t),l(s,Il,t),l(s,xr,t),l(s,Cl,t),l(s,Gr,t),l(s,bl,t),l(s,Sr,t),l(s,Al,t),l(s,zr,t),l(s,gl,t),l(s,Wr,t),l(s,vl,t),l(s,kr,t),l(s,_l,t),l(s,Rr,t),l(s,Bl,t),l(s,Nr,t),l(s,Zl,t),l(s,Xr,t),c(ql,s,t),l(s,Qr,t),l(s,$l,t),l(s,Er,t),l(s,xl,t),l(s,Hr,t),l(s,Gl,t),l(s,Vr,t),l(s,Sl,t),l(s,Yr,t),l(s,zl,t),l(s,Lr,t),c(Wl,s,t),l(s,Fr,t),l(s,kl,t),l(s,Dr,t),l(s,Rl,t),l(s,Pr,t),l(s,uo,t),l(s,Or,t),c(Nl,s,t),l(s,Kr,t),l(s,Xl,t),l(s,sy,t),l(s,Ql,t),l(s,ty,t),l(s,El,t),l(s,ey,t),c(Hl,s,t),l(s,ly,t),l(s,Vl,t),l(s,ay,t),l(s,Yl,t),l(s,ny,t),l(s,Ll,t),l(s,py,t),l(s,Fl,t),l(s,iy,t),c(Dl,s,t),l(s,oy,t),l(s,Pl,t),l(s,My,t),l(s,Ol,t),l(s,uy,t),c(Kl,s,t),l(s,cy,t),l(s,sa,t),l(s,ry,t),l(s,ta,t),l(s,yy,t),c(ea,s,t),l(s,jy,t),l(s,la,t),l(s,Ty,t),l(s,co,t),l(s,hy,t),c(aa,s,t),l(s,Jy,t),l(s,na,t),l(s,Uy,t),l(s,pa,t),l(s,wy,t),l(s,ia,t),l(s,dy,t),l(s,oa,t),l(s,my,t),l(s,Ma,t),l(s,fy,t),c(ua,s,t),l(s,Iy,t),l(s,ca,t),l(s,Cy,t),l(s,ra,t),l(s,by,t),l(s,ya,t),l(s,Ay,t),c(ja,s,t),l(s,gy,t),l(s,Ta,t),l(s,vy,t),l(s,ha,t),l(s,_y,t),c(Ja,s,t),l(s,By,t),l(s,Ua,t),l(s,Zy,t),l(s,ro,t),l(s,qy,t),c(wa,s,t),l(s,$y,t),l(s,da,t),l(s,xy,t),l(s,ma,t),l(s,Gy,t),c(fa,s,t),l(s,Sy,t),l(s,Ia,t),l(s,zy,t),l(s,Ca,t),l(s,Wy,t),l(s,yo,t),l(s,ky,t),c(ba,s,t),l(s,Ry,t),l(s,Aa,t),l(s,Ny,t),c(ga,s,t),l(s,Xy,t),l(s,va,t),l(s,Qy,t),c(_a,s,t),l(s,Ey,t),l(s,Ba,t),l(s,Hy,t),l(s,Za,t),l(s,Vy,t),l(s,qa,t),l(s,Yy,t),c($a,s,t),l(s,Ly,t),l(s,xa,t),l(s,Fy,t),l(s,Ga,t),l(s,Dy,t),c(Sa,s,t),l(s,Py,t),l(s,za,t),l(s,Oy,t),c(Wa,s,t),l(s,Ky,t),l(s,ka,t),l(s,sj,t),l(s,Ra,t),l(s,tj,t),l(s,Na,t),l(s,ej,t),c(Xa,s,t),l(s,lj,t),c(S,s,t),l(s,aj,t),c(Qa,s,t),l(s,nj,t),l(s,Ea,t),l(s,pj,t),l(s,Ha,t),l(s,ij,t),l(s,Va,t),l(s,oj,t),l(s,Ya,t),l(s,Mj,t),c(La,s,t),l(s,uj,t),l(s,Fa,t),l(s,cj,t),l(s,Da,t),l(s,rj,t),c(Pa,s,t),l(s,yj,t),l(s,Oa,t),l(s,jj,t),c(Ka,s,t),l(s,Tj,t),l(s,sn,t),l(s,hj,t),l(s,tn,t),l(s,Jj,t),l(s,en,t),l(s,Uj,t),c(ln,s,t),l(s,wj,t),l(s,an,t),l(s,dj,t),l(s,nn,t),l(s,mj,t),l(s,jo,t),l(s,fj,t),c(pn,s,t),l(s,Ij,t),l(s,on,t),l(s,Cj,t),c(Mn,s,t),l(s,bj,t),l(s,un,t),l(s,Aj,t),l(s,cn,t),l(s,gj,t),c(rn,s,t),l(s,vj,t),l(s,yn,t),l(s,_j,t),l(s,To,t),l(s,Bj,t),c(jn,s,t),l(s,Zj,t),l(s,Tn,t),l(s,qj,t),c(hn,s,t),l(s,$j,t),l(s,Jn,t),l(s,xj,t),l(s,Un,t),l(s,Gj,t),c(wn,s,t),l(s,Sj,t),l(s,dn,t),l(s,zj,t),l(s,ho,t),l(s,Wj,t),c(mn,s,t),l(s,kj,t),l(s,fn,t),l(s,Rj,t),c(In,s,t),l(s,Nj,t),l(s,Cn,t),l(s,Xj,t),l(s,bn,t),l(s,Qj,t),c(An,s,t),l(s,Ej,t),l(s,gn,t),l(s,Hj,t),l(s,Jo,t),l(s,Vj,t),c(vn,s,t),l(s,Yj,t),l(s,_n,t),l(s,Lj,t),l(s,Bn,t),l(s,Fj,t),l(s,Zn,t),l(s,Dj,t),l(s,qn,t),l(s,Pj,t),c($n,s,t),l(s,Oj,t),l(s,xn,t),l(s,Kj,t),l(s,Gn,t),l(s,sT,t),l(s,Sn,t),l(s,tT,t),l(s,zn,t),l(s,eT,t),l(s,Wn,t),l(s,lT,t),c(kn,s,t),l(s,aT,t),l(s,Rn,t),l(s,nT,t),c(Nn,s,t),l(s,pT,t),c(z,s,t),l(s,iT,t),l(s,Xn,t),l(s,oT,t),l(s,Qn,t),l(s,MT,t),c(En,s,t),l(s,uT,t),l(s,Hn,t),l(s,cT,t),l(s,Vn,t),l(s,rT,t),l(s,Yn,t),l(s,yT,t),c(Ln,s,t),l(s,jT,t),l(s,Fn,t),l(s,TT,t),c(Dn,s,t),l(s,hT,t),l(s,Pn,t),l(s,JT,t),l(s,On,t),l(s,UT,t),l(s,Kn,t),l(s,wT,t),l(s,sp,t),l(s,dT,t),l(s,tp,t),l(s,mT,t),c(ep,s,t),l(s,fT,t),l(s,lp,t),l(s,IT,t),l(s,ap,t),l(s,CT,t),l(s,np,t),l(s,bT,t),c(pp,s,t),l(s,AT,t),l(s,ip,t),l(s,gT,t),c(op,s,t),l(s,vT,t),l(s,Mp,t),l(s,_T,t),l(s,up,t),l(s,BT,t),c(cp,s,t),l(s,ZT,t),l(s,rp,t),l(s,qT,t),l(s,yp,t),l(s,$T,t),l(s,jp,t),l(s,xT,t),l(s,Tp,t),l(s,GT,t),c(hp,s,t),l(s,ST,t),l(s,Jp,t),l(s,zT,t),l(s,Up,t),l(s,WT,t),l(s,wp,t),l(s,kT,t),c(dp,s,t),l(s,RT,t),l(s,mp,t),l(s,NT,t),l(s,Uo,t),l(s,XT,t),c(fp,s,t),l(s,QT,t),l(s,Ip,t),l(s,ET,t),l(s,Cp,t),l(s,HT,t),c(bp,s,t),l(s,VT,t),l(s,Ap,t),l(s,YT,t),l(s,gp,t),l(s,LT,t),c(vp,s,t),l(s,FT,t),l(s,_p,t),l(s,DT,t),l(s,Bp,t),l(s,PT,t),c(Zp,s,t),l(s,OT,t),l(s,qp,t),l(s,KT,t),l(s,$p,t),l(s,sh,t),c(xp,s,t),l(s,th,t),l(s,Gp,t),l(s,eh,t),l(s,Sp,t),l(s,lh,t),l(s,zp,t),l(s,ah,t),l(s,Wp,t),l(s,nh,t),c(kp,s,t),l(s,ph,t),l(s,Rp,t),l(s,ih,t),l(s,Np,t),l(s,oh,t),c(Xp,s,t),l(s,Mh,t),l(s,Qp,t),l(s,uh,t),l(s,Ep,t),l(s,ch,t),l(s,C,t),d(C,wo),d(C,TJ),d(C,mo),d(C,hJ),d(C,Hp),d(Hp,fo),d(Hp,JJ),c(Vp,Hp,null),d(C,UJ),d(C,Io),d(C,wJ),d(C,Co),d(C,dJ),d(C,bo),l(s,rh,t),l(s,Yp,t),l(s,yh,t),l(s,Lp,t),l(s,jh,t),c(Fp,s,t),l(s,Th,t),c(Dp,s,t),l(s,hh,t),l(s,Pp,t),l(s,Jh,t),c(Op,s,t),l(s,Uh,t),l(s,Kp,t),l(s,wh,t),l(s,si,t),l(s,dh,t),c(ti,s,t),l(s,mh,t),l(s,ei,t),l(s,fh,t),c(li,s,t),l(s,Ih,t),l(s,ai,t),l(s,Ch,t),l(s,ni,t),l(s,bh,t),l(s,pi,t),l(s,Ah,t),c(ii,s,t),l(s,gh,t),l(s,oi,t),l(s,vh,t),c(Mi,s,t),l(s,_h,t),l(s,ui,t),l(s,Bh,t),l(s,ci,t),l(s,Zh,t),l(s,ri,t),l(s,qh,t),l(s,yi,t),l(s,$h,t),l(s,ji,t),l(s,xh,t),c(Ti,s,t),l(s,Gh,t),l(s,hi,t),l(s,Sh,t),c(Ji,s,t),l(s,zh,t),l(s,Ui,t),l(s,Wh,t),c(wi,s,t),l(s,kh,t),l(s,_,t),c(di,_,null),d(_,mJ),d(_,Ao),d(_,fJ),d(_,go),d(_,IJ),d(_,vo),l(s,Rh,t),c(mi,s,t),l(s,Nh,t),l(s,fi,t),l(s,Xh,t),l(s,Ii,t),l(s,Qh,t),l(s,Ci,t),l(s,Eh,t),l(s,bi,t),l(s,Hh,t),l(s,Ai,t),l(s,Vh,t),c(gi,s,t),l(s,Yh,t),l(s,vi,t),l(s,Lh,t),c(_i,s,t),l(s,Fh,t),l(s,Bi,t),l(s,Dh,t),c(Zi,s,t),l(s,Ph,t),l(s,qi,t),l(s,Oh,t),l(s,$i,t),l(s,Kh,t),c(xi,s,t),l(s,sJ,t),l(s,Gi,t),l(s,tJ,t),l(s,Si,t),l(s,eJ,t),c(zi,s,t),l(s,lJ,t),l(s,Wi,t),l(s,aJ,t),c(ki,s,t),l(s,nJ,t),c(Ri,s,t),l(s,pJ,t),l(s,Ni,t),l(s,iJ,t),l(s,Xi,t),l(s,oJ,t),l(s,Qi,t),l(s,MJ,t),l(s,Ei,t),l(s,uJ,t),l(s,Bo,t),cJ=!0},p(s,[t]){const Zo={};t&2&&(Zo.$$scope={dirty:t,ctx:s}),G.$set(Zo);const $={};t&2&&($.$$scope={dirty:t,ctx:s}),S.$set($);const A={};t&2&&(A.$$scope={dirty:t,ctx:s}),z.$set(A)},i(s){cJ||(r(B.$$.fragment,s),r(D.$$.fragment,s),r(P.$$.fragment,s),r(K.$$.fragment,s),r(ts.$$.fragment,s),r(ps.$$.fragment,s),r(Ms.$$.fragment,s),r(rs.$$.fragment,s),r(Js.$$.fragment,s),r(ws.$$.fragment,s),r(ms.$$.fragment,s),r(bs.$$.fragment,s),r(vs.$$.fragment,s),r(Bs.$$.fragment,s),r(xs.$$.fragment,s),r(zs.$$.fragment,s),r(ks.$$.fragment,s),r(Es.$$.fragment,s),r(Fs.$$.fragment,s),r(Ds.$$.fragment,s),r(Ks.$$.fragment,s),r(tt.$$.fragment,s),r(at.$$.fragment,s),r(pt.$$.fragment,s),r(ot.$$.fragment,s),r(ct.$$.fragment,s),r(yt.$$.fragment,s),r(Tt.$$.fragment,s),r(Jt.$$.fragment,s),r(wt.$$.fragment,s),r(mt.$$.fragment,s),r(Ct.$$.fragment,s),r(vt.$$.fragment,s),r(Bt.$$.fragment,s),r(qt.$$.fragment,s),r(Gt.$$.fragment,s),r(Wt.$$.fragment,s),r(Rt.$$.fragment,s),r(Et.$$.fragment,s),r(Vt.$$.fragment,s),r(Ft.$$.fragment,s),r(Pt.$$.fragment,s),r(Ot.$$.fragment,s),r(G.$$.fragment,s),r(pe.$$.fragment,s),r(ce.$$.fragment,s),r(ye.$$.fragment,s),r(Je.$$.fragment,s),r(we.$$.fragment,s),r(me.$$.fragment,s),r(ze.$$.fragment,s),r(Re.$$.fragment,s),r(Xe.$$.fragment,s),r(Ee.$$.fragment,s),r(He.$$.fragment,s),r(Le.$$.fragment,s),r(Ke.$$.fragment,s),r(al.$$.fragment,s),r(pl.$$.fragment,s),r(ol.$$.fragment,s),r(Ml.$$.fragment,s),r(cl.$$.fragment,s),r(yl.$$.fragment,s),r(jl.$$.fragment,s),r(ql.$$.fragment,s),r(Wl.$$.fragment,s),r(Nl.$$.fragment,s),r(Hl.$$.fragment,s),r(Dl.$$.fragment,s),r(Kl.$$.fragment,s),r(ea.$$.fragment,s),r(aa.$$.fragment,s),r(ua.$$.fragment,s),r(ja.$$.fragment,s),r(Ja.$$.fragment,s),r(wa.$$.fragment,s),r(fa.$$.fragment,s),r(ba.$$.fragment,s),r(ga.$$.fragment,s),r(_a.$$.fragment,s),r($a.$$.fragment,s),r(Sa.$$.fragment,s),r(Wa.$$.fragment,s),r(Xa.$$.fragment,s),r(S.$$.fragment,s),r(Qa.$$.fragment,s),r(La.$$.fragment,s),r(Pa.$$.fragment,s),r(Ka.$$.fragment,s),r(ln.$$.fragment,s),r(pn.$$.fragment,s),r(Mn.$$.fragment,s),r(rn.$$.fragment,s),r(jn.$$.fragment,s),r(hn.$$.fragment,s),r(wn.$$.fragment,s),r(mn.$$.fragment,s),r(In.$$.fragment,s),r(An.$$.fragment,s),r(vn.$$.fragment,s),r($n.$$.fragment,s),r(kn.$$.fragment,s),r(Nn.$$.fragment,s),r(z.$$.fragment,s),r(En.$$.fragment,s),r(Ln.$$.fragment,s),r(Dn.$$.fragment,s),r(ep.$$.fragment,s),r(pp.$$.fragment,s),r(op.$$.fragment,s),r(cp.$$.fragment,s),r(hp.$$.fragment,s),r(dp.$$.fragment,s),r(fp.$$.fragment,s),r(bp.$$.fragment,s),r(vp.$$.fragment,s),r(Zp.$$.fragment,s),r(xp.$$.fragment,s),r(kp.$$.fragment,s),r(Xp.$$.fragment,s),r(Vp.$$.fragment,s),r(Fp.$$.fragment,s),r(Dp.$$.fragment,s),r(Op.$$.fragment,s),r(ti.$$.fragment,s),r(li.$$.fragment,s),r(ii.$$.fragment,s),r(Mi.$$.fragment,s),r(Ti.$$.fragment,s),r(Ji.$$.fragment,s),r(wi.$$.fragment,s),r(di.$$.fragment,s),r(mi.$$.fragment,s),r(gi.$$.fragment,s),r(_i.$$.fragment,s),r(Zi.$$.fragment,s),r(xi.$$.fragment,s),r(zi.$$.fragment,s),r(ki.$$.fragment,s),r(Ri.$$.fragment,s),cJ=!0)},o(s){y(B.$$.fragment,s),y(D.$$.fragment,s),y(P.$$.fragment,s),y(K.$$.fragment,s),y(ts.$$.fragment,s),y(ps.$$.fragment,s),y(Ms.$$.fragment,s),y(rs.$$.fragment,s),y(Js.$$.fragment,s),y(ws.$$.fragment,s),y(ms.$$.fragment,s),y(bs.$$.fragment,s),y(vs.$$.fragment,s),y(Bs.$$.fragment,s),y(xs.$$.fragment,s),y(zs.$$.fragment,s),y(ks.$$.fragment,s),y(Es.$$.fragment,s),y(Fs.$$.fragment,s),y(Ds.$$.fragment,s),y(Ks.$$.fragment,s),y(tt.$$.fragment,s),y(at.$$.fragment,s),y(pt.$$.fragment,s),y(ot.$$.fragment,s),y(ct.$$.fragment,s),y(yt.$$.fragment,s),y(Tt.$$.fragment,s),y(Jt.$$.fragment,s),y(wt.$$.fragment,s),y(mt.$$.fragment,s),y(Ct.$$.fragment,s),y(vt.$$.fragment,s),y(Bt.$$.fragment,s),y(qt.$$.fragment,s),y(Gt.$$.fragment,s),y(Wt.$$.fragment,s),y(Rt.$$.fragment,s),y(Et.$$.fragment,s),y(Vt.$$.fragment,s),y(Ft.$$.fragment,s),y(Pt.$$.fragment,s),y(Ot.$$.fragment,s),y(G.$$.fragment,s),y(pe.$$.fragment,s),y(ce.$$.fragment,s),y(ye.$$.fragment,s),y(Je.$$.fragment,s),y(we.$$.fragment,s),y(me.$$.fragment,s),y(ze.$$.fragment,s),y(Re.$$.fragment,s),y(Xe.$$.fragment,s),y(Ee.$$.fragment,s),y(He.$$.fragment,s),y(Le.$$.fragment,s),y(Ke.$$.fragment,s),y(al.$$.fragment,s),y(pl.$$.fragment,s),y(ol.$$.fragment,s),y(Ml.$$.fragment,s),y(cl.$$.fragment,s),y(yl.$$.fragment,s),y(jl.$$.fragment,s),y(ql.$$.fragment,s),y(Wl.$$.fragment,s),y(Nl.$$.fragment,s),y(Hl.$$.fragment,s),y(Dl.$$.fragment,s),y(Kl.$$.fragment,s),y(ea.$$.fragment,s),y(aa.$$.fragment,s),y(ua.$$.fragment,s),y(ja.$$.fragment,s),y(Ja.$$.fragment,s),y(wa.$$.fragment,s),y(fa.$$.fragment,s),y(ba.$$.fragment,s),y(ga.$$.fragment,s),y(_a.$$.fragment,s),y($a.$$.fragment,s),y(Sa.$$.fragment,s),y(Wa.$$.fragment,s),y(Xa.$$.fragment,s),y(S.$$.fragment,s),y(Qa.$$.fragment,s),y(La.$$.fragment,s),y(Pa.$$.fragment,s),y(Ka.$$.fragment,s),y(ln.$$.fragment,s),y(pn.$$.fragment,s),y(Mn.$$.fragment,s),y(rn.$$.fragment,s),y(jn.$$.fragment,s),y(hn.$$.fragment,s),y(wn.$$.fragment,s),y(mn.$$.fragment,s),y(In.$$.fragment,s),y(An.$$.fragment,s),y(vn.$$.fragment,s),y($n.$$.fragment,s),y(kn.$$.fragment,s),y(Nn.$$.fragment,s),y(z.$$.fragment,s),y(En.$$.fragment,s),y(Ln.$$.fragment,s),y(Dn.$$.fragment,s),y(ep.$$.fragment,s),y(pp.$$.fragment,s),y(op.$$.fragment,s),y(cp.$$.fragment,s),y(hp.$$.fragment,s),y(dp.$$.fragment,s),y(fp.$$.fragment,s),y(bp.$$.fragment,s),y(vp.$$.fragment,s),y(Zp.$$.fragment,s),y(xp.$$.fragment,s),y(kp.$$.fragment,s),y(Xp.$$.fragment,s),y(Vp.$$.fragment,s),y(Fp.$$.fragment,s),y(Dp.$$.fragment,s),y(Op.$$.fragment,s),y(ti.$$.fragment,s),y(li.$$.fragment,s),y(ii.$$.fragment,s),y(Mi.$$.fragment,s),y(Ti.$$.fragment,s),y(Ji.$$.fragment,s),y(wi.$$.fragment,s),y(di.$$.fragment,s),y(mi.$$.fragment,s),y(gi.$$.fragment,s),y(_i.$$.fragment,s),y(Zi.$$.fragment,s),y(xi.$$.fragment,s),y(zi.$$.fragment,s),y(ki.$$.fragment,s),y(Ri.$$.fragment,s),cJ=!1},d(s){s&&(e(g),e(m),e(I),e(Z),e(b),e(f),e(v),e(qo),e(k),e($o),e(R),e(xo),e(N),e(Go),e(X),e(So),e(Q),e(zo),e(E),e(Wo),e(H),e(ko),e(V),e(Ro),e(Y),e(No),e(L),e(Xo),e(F),e(Qo),e(Hi),e(Eo),e(Ho),e(Vi),e(Vo),e(Yo),e(O),e(Lo),e(Fo),e(ss),e(Do),e(Po),e(es),e(Oo),e(ls),e(Ko),e(as),e(sM),e(ns),e(tM),e(eM),e(is),e(lM),e(os),e(aM),e(nM),e(us),e(pM),e(cs),e(iM),e(oM),e(ys),e(MM),e(js),e(uM),e(Ts),e(cM),e(hs),e(rM),e(yM),e(Us),e(jM),e(TM),e(ds),e(hM),e(JM),e(fs),e(UM),e(Is),e(wM),e(Cs),e(dM),e(Yi),e(mM),e(fM),e(As),e(IM),e(gs),e(CM),e(bM),e(_s),e(AM),e(gM),e(Zs),e(vM),e(qs),e(_M),e($s),e(BM),e(ZM),e(Gs),e(qM),e(Ss),e($M),e(Li),e(xM),e(GM),e(Ws),e(SM),e(zM),e(Rs),e(WM),e(Ns),e(kM),e(Xs),e(RM),e(Qs),e(NM),e(XM),e(Hs),e(QM),e(Vs),e(EM),e(Ys),e(HM),e(Ls),e(VM),e(Fi),e(YM),e(Oi),e(LM),e(FM),e(Ps),e(DM),e(Os),e(PM),e(OM),e(st),e(KM),e(su),e(et),e(tu),e(lt),e(eu),e(lu),e(nt),e(au),e(nu),e(it),e(pu),e(iu),e(Mt),e(ou),e(ut),e(Mu),e(uu),e(rt),e(cu),e(ru),e(jt),e(yu),e(ju),e(ht),e(Tu),e(hu),e(Ut),e(Ju),e(Uu),e(dt),e(wu),e(Ki),e(du),e(mu),e(ft),e(fu),e(It),e(Iu),e(Cu),e(bt),e(bu),e(At),e(Au),e(gt),e(gu),e(vu),e(_t),e(_u),e(Bu),e(Zt),e(Zu),e(qu),e($t),e($u),e(xt),e(xu),e(so),e(Gu),e(Su),e(St),e(zu),e(zt),e(Wu),e(ku),e(kt),e(Ru),e(Nu),e(Nt),e(Xu),e(Xt),e(Qu),e(Qt),e(Eu),e(Hu),e(Ht),e(Vu),e(to),e(Yu),e(Lu),e(Yt),e(Fu),e(Lt),e(Du),e(Pu),e(Dt),e(Ou),e(Ku),e(eo),e(sc),e(tc),e(ec),e(Kt),e(lc),e(se),e(ac),e(te),e(nc),e(ee),e(pc),e(le),e(ic),e(ae),e(oc),e(ne),e(Mc),e(lo),e(uc),e(cc),e(ie),e(rc),e(oe),e(yc),e(Me),e(jc),e(ue),e(Tc),e(ao),e(hc),e(Jc),e(re),e(Uc),e(wc),e(je),e(dc),e(Te),e(mc),e(he),e(fc),e(Ic),e(Ue),e(Cc),e(no),e(bc),e(Ac),e(de),e(gc),e(vc),e(fe),e(_c),e(Ie),e(Bc),e(Ce),e(Zc),e(be),e(qc),e(Ae),e($c),e(ge),e(xc),e(ve),e(Gc),e(_e),e(Sc),e(Be),e(zc),e(Ze),e(Wc),e(qe),e(kc),e($e),e(Rc),e(xe),e(Nc),e(Ge),e(Xc),e(Se),e(Qc),e(Ec),e(We),e(Hc),e(ke),e(Vc),e(Yc),e(Ne),e(Lc),e(Fc),e(Qe),e(Dc),e(Pc),e(po),e(Oc),e(Kc),e(Ve),e(sr),e(Ye),e(tr),e(er),e(Fe),e(lr),e(De),e(ar),e(Pe),e(nr),e(Oe),e(pr),e(io),e(ir),e(or),e(sl),e(Mr),e(tl),e(ur),e(el),e(cr),e(ll),e(rr),e(oo),e(yr),e(jr),e(nl),e(Tr),e(hr),e(il),e(Jr),e(Ur),e(Mo),e(wr),e(dr),e(ul),e(mr),e(fr),e(rl),e(Ir),e(Cr),e(br),e(Tl),e(Ar),e(hl),e(gr),e(Jl),e(vr),e(Ul),e(_r),e(wl),e(Br),e(dl),e(Zr),e(ml),e(qr),e(fl),e($r),e(Il),e(xr),e(Cl),e(Gr),e(bl),e(Sr),e(Al),e(zr),e(gl),e(Wr),e(vl),e(kr),e(_l),e(Rr),e(Bl),e(Nr),e(Zl),e(Xr),e(Qr),e($l),e(Er),e(xl),e(Hr),e(Gl),e(Vr),e(Sl),e(Yr),e(zl),e(Lr),e(Fr),e(kl),e(Dr),e(Rl),e(Pr),e(uo),e(Or),e(Kr),e(Xl),e(sy),e(Ql),e(ty),e(El),e(ey),e(ly),e(Vl),e(ay),e(Yl),e(ny),e(Ll),e(py),e(Fl),e(iy),e(oy),e(Pl),e(My),e(Ol),e(uy),e(cy),e(sa),e(ry),e(ta),e(yy),e(jy),e(la),e(Ty),e(co),e(hy),e(Jy),e(na),e(Uy),e(pa),e(wy),e(ia),e(dy),e(oa),e(my),e(Ma),e(fy),e(Iy),e(ca),e(Cy),e(ra),e(by),e(ya),e(Ay),e(gy),e(Ta),e(vy),e(ha),e(_y),e(By),e(Ua),e(Zy),e(ro),e(qy),e($y),e(da),e(xy),e(ma),e(Gy),e(Sy),e(Ia),e(zy),e(Ca),e(Wy),e(yo),e(ky),e(Ry),e(Aa),e(Ny),e(Xy),e(va),e(Qy),e(Ey),e(Ba),e(Hy),e(Za),e(Vy),e(qa),e(Yy),e(Ly),e(xa),e(Fy),e(Ga),e(Dy),e(Py),e(za),e(Oy),e(Ky),e(ka),e(sj),e(Ra),e(tj),e(Na),e(ej),e(lj),e(aj),e(nj),e(Ea),e(pj),e(Ha),e(ij),e(Va),e(oj),e(Ya),e(Mj),e(uj),e(Fa),e(cj),e(Da),e(rj),e(yj),e(Oa),e(jj),e(Tj),e(sn),e(hj),e(tn),e(Jj),e(en),e(Uj),e(wj),e(an),e(dj),e(nn),e(mj),e(jo),e(fj),e(Ij),e(on),e(Cj),e(bj),e(un),e(Aj),e(cn),e(gj),e(vj),e(yn),e(_j),e(To),e(Bj),e(Zj),e(Tn),e(qj),e($j),e(Jn),e(xj),e(Un),e(Gj),e(Sj),e(dn),e(zj),e(ho),e(Wj),e(kj),e(fn),e(Rj),e(Nj),e(Cn),e(Xj),e(bn),e(Qj),e(Ej),e(gn),e(Hj),e(Jo),e(Vj),e(Yj),e(_n),e(Lj),e(Bn),e(Fj),e(Zn),e(Dj),e(qn),e(Pj),e(Oj),e(xn),e(Kj),e(Gn),e(sT),e(Sn),e(tT),e(zn),e(eT),e(Wn),e(lT),e(aT),e(Rn),e(nT),e(pT),e(iT),e(Xn),e(oT),e(Qn),e(MT),e(uT),e(Hn),e(cT),e(Vn),e(rT),e(Yn),e(yT),e(jT),e(Fn),e(TT),e(hT),e(Pn),e(JT),e(On),e(UT),e(Kn),e(wT),e(sp),e(dT),e(tp),e(mT),e(fT),e(lp),e(IT),e(ap),e(CT),e(np),e(bT),e(AT),e(ip),e(gT),e(vT),e(Mp),e(_T),e(up),e(BT),e(ZT),e(rp),e(qT),e(yp),e($T),e(jp),e(xT),e(Tp),e(GT),e(ST),e(Jp),e(zT),e(Up),e(WT),e(wp),e(kT),e(RT),e(mp),e(NT),e(Uo),e(XT),e(QT),e(Ip),e(ET),e(Cp),e(HT),e(VT),e(Ap),e(YT),e(gp),e(LT),e(FT),e(_p),e(DT),e(Bp),e(PT),e(OT),e(qp),e(KT),e($p),e(sh),e(th),e(Gp),e(eh),e(Sp),e(lh),e(zp),e(ah),e(Wp),e(nh),e(ph),e(Rp),e(ih),e(Np),e(oh),e(Mh),e(Qp),e(uh),e(Ep),e(ch),e(C),e(rh),e(Yp),e(yh),e(Lp),e(jh),e(Th),e(hh),e(Pp),e(Jh),e(Uh),e(Kp),e(wh),e(si),e(dh),e(mh),e(ei),e(fh),e(Ih),e(ai),e(Ch),e(ni),e(bh),e(pi),e(Ah),e(gh),e(oi),e(vh),e(_h),e(ui),e(Bh),e(ci),e(Zh),e(ri),e(qh),e(yi),e($h),e(ji),e(xh),e(Gh),e(hi),e(Sh),e(zh),e(Ui),e(Wh),e(kh),e(_),e(Rh),e(Nh),e(fi),e(Xh),e(Ii),e(Qh),e(Ci),e(Eh),e(bi),e(Hh),e(Ai),e(Vh),e(Yh),e(vi),e(Lh),e(Fh),e(Bi),e(Dh),e(Ph),e(qi),e(Oh),e($i),e(Kh),e(sJ),e(Gi),e(tJ),e(Si),e(eJ),e(lJ),e(Wi),e(aJ),e(nJ),e(pJ),e(Ni),e(iJ),e(Xi),e(oJ),e(Qi),e(MJ),e(Ei),e(uJ),e(Bo)),e(J),j(B,s),j(D,s),j(P,s),j(K,s),j(ts,s),j(ps,s),j(Ms,s),j(rs,s),j(Js,s),j(ws,s),j(ms,s),j(bs,s),j(vs,s),j(Bs,s),j(xs,s),j(zs,s),j(ks,s),j(Es,s),j(Fs),j(Ds,s),j(Ks,s),j(tt,s),j(at,s),j(pt,s),j(ot,s),j(ct,s),j(yt,s),j(Tt,s),j(Jt,s),j(wt,s),j(mt,s),j(Ct,s),j(vt,s),j(Bt,s),j(qt,s),j(Gt,s),j(Wt,s),j(Rt,s),j(Et,s),j(Vt,s),j(Ft,s),j(Pt,s),j(Ot,s),j(G,s),j(pe,s),j(ce,s),j(ye,s),j(Je,s),j(we,s),j(me,s),j(ze,s),j(Re,s),j(Xe,s),j(Ee,s),j(He,s),j(Le,s),j(Ke,s),j(al,s),j(pl,s),j(ol,s),j(Ml,s),j(cl,s),j(yl,s),j(jl,s),j(ql,s),j(Wl,s),j(Nl,s),j(Hl,s),j(Dl,s),j(Kl,s),j(ea,s),j(aa,s),j(ua,s),j(ja,s),j(Ja,s),j(wa,s),j(fa,s),j(ba,s),j(ga,s),j(_a,s),j($a,s),j(Sa,s),j(Wa,s),j(Xa,s),j(S,s),j(Qa,s),j(La,s),j(Pa,s),j(Ka,s),j(ln,s),j(pn,s),j(Mn,s),j(rn,s),j(jn,s),j(hn,s),j(wn,s),j(mn,s),j(In,s),j(An,s),j(vn,s),j($n,s),j(kn,s),j(Nn,s),j(z,s),j(En,s),j(Ln,s),j(Dn,s),j(ep,s),j(pp,s),j(op,s),j(cp,s),j(hp,s),j(dp,s),j(fp,s),j(bp,s),j(vp,s),j(Zp,s),j(xp,s),j(kp,s),j(Xp,s),j(Vp),j(Fp,s),j(Dp,s),j(Op,s),j(ti,s),j(li,s),j(ii,s),j(Mi,s),j(Ti,s),j(Ji,s),j(wi,s),j(di),j(mi,s),j(gi,s),j(_i,s),j(Zi,s),j(xi,s),j(zi,s),j(ki,s),j(Ri,s)}}}const bI='{"title":"DeepSpeed Integration","local":"deepspeed-integration","sections":[{"title":"Trainer Deepspeed Integration","local":"trainer-deepspeed-integration","sections":[{"title":"Installation","local":"installation","sections":[],"depth":3},{"title":"Deployment with multiple GPUs","local":"deployment-with-multiple-gpus","sections":[],"depth":3},{"title":"Deployment with one GPU","local":"deployment-with-one-gpu","sections":[],"depth":3},{"title":"Deployment with multiple Nodes","local":"deployment-with-multiple-nodes","sections":[{"title":"The torch.distributed.run(torchrun) launcher","local":"the-torchdistributedruntorchrun-launcher","sections":[],"depth":4},{"title":"The deepspeed launcher","local":"the-deepspeed-launcher","sections":[],"depth":4},{"title":"Launching in a SLURM environment","local":"launching-in-a-slurm-environment","sections":[],"depth":4},{"title":"Use of Non-shared filesystem","local":"use-of-non-shared-filesystem","sections":[],"depth":4}],"depth":3},{"title":"Deployment in Notebooks","local":"deployment-in-notebooks","sections":[],"depth":3},{"title":"Configuration","local":"configuration","sections":[],"depth":3},{"title":"Passing Configuration","local":"passing-configuration","sections":[],"depth":3},{"title":"Shared Configuration","local":"shared-configuration","sections":[],"depth":3},{"title":"ZeRO","local":"zero","sections":[{"title":"ZeRO-2 Config","local":"zero-2-config","sections":[],"depth":4},{"title":"ZeRO-3 Config","local":"zero-3-config","sections":[],"depth":4},{"title":"ZeRO-0 Config","local":"zero-0-config","sections":[],"depth":4},{"title":"ZeRO-1 Config","local":"zero-1-config","sections":[],"depth":4}],"depth":3},{"title":"NVMe Support","local":"nvme-support","sections":[{"title":"ZeRO-2 vs ZeRO-3 Performance","local":"zero-2-vs-zero-3-performance","sections":[],"depth":4},{"title":"ZeRO-2 Example","local":"zero-2-example","sections":[],"depth":4},{"title":"ZeRO-3 Example","local":"zero-3-example","sections":[],"depth":4},{"title":"How to Choose Which ZeRO Stage and Offloads To Use For Best Performance","local":"how-to-choose-which-zero-stage-and-offloads-to-use-for-best-performance","sections":[],"depth":4}],"depth":3},{"title":"Activation Checkpointing or Gradient Checkpointing","local":"activation-checkpointing-or-gradient-checkpointing","sections":[],"depth":3},{"title":"Optimizer and Scheduler","local":"optimizer-and-scheduler","sections":[{"title":"Optimizer","local":"optimizer","sections":[],"depth":4},{"title":"Scheduler","local":"scheduler","sections":[],"depth":4}],"depth":3},{"title":"fp32 Precision","local":"fp32-precision","sections":[],"depth":3},{"title":"Automatic Mixed Precision","local":"automatic-mixed-precision","sections":[],"depth":3},{"title":"fp16","local":"fp16","sections":[],"depth":3},{"title":"bf16","local":"bf16","sections":[],"depth":3},{"title":"NCCL Collectives","local":"nccl-collectives","sections":[],"depth":3},{"title":"apex","local":"apex","sections":[],"depth":3},{"title":"Batch Size","local":"batch-size","sections":[],"depth":3},{"title":"Gradient Accumulation","local":"gradient-accumulation","sections":[],"depth":3},{"title":"Gradient Clipping","local":"gradient-clipping","sections":[],"depth":3},{"title":"Getting The Model Weights Out","local":"getting-the-model-weights-out","sections":[],"depth":3},{"title":"ZeRO-3 and Infinity Nuances","local":"zero-3-and-infinity-nuances","sections":[{"title":"Constructing Massive Models","local":"constructing-massive-models","sections":[],"depth":4},{"title":"Gathering Parameters","local":"gathering-parameters","sections":[],"depth":4}],"depth":3},{"title":"ZeRO Inference","local":"zero-inference","sections":[],"depth":3},{"title":"Memory Requirements","local":"memory-requirements","sections":[],"depth":3},{"title":"Filing Issues","local":"filing-issues","sections":[],"depth":3},{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"the deepspeed process gets killed at startup without a traceback","local":"the-deepspeed-process-gets-killed-at-startup-without-a-traceback","sections":[],"depth":4},{"title":"training and/or eval/predict loss is NaN","local":"training-andor-evalpredict-loss-is-nan","sections":[],"depth":4}],"depth":3},{"title":"Notes","local":"notes","sections":[],"depth":3}],"depth":2},{"title":"Non-Trainer Deepspeed Integration","local":"non-trainer-deepspeed-integration","sections":[],"depth":2},{"title":"HfDeepSpeedConfig","local":"transformers.integrations.HfDeepSpeedConfig","sections":[{"title":"Custom DeepSpeed ZeRO Inference","local":"custom-deepspeed-zero-inference","sections":[],"depth":3},{"title":"generate nuances","local":"generate-nuances","sections":[],"depth":3}],"depth":2},{"title":"Testing Deepspeed Integration","local":"testing-deepspeed-integration","sections":[],"depth":2},{"title":"Main DeepSpeed Resources","local":"main-deepspeed-resources","sections":[],"depth":2}],"depth":1}';function AI(x){return hI(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $I extends JI{constructor(J){super(),UI(this,J,AI,CI,TI,{})}}export{$I as component};
