import{s as K,o as O,n as D}from"../chunks/scheduler.9bc65507.js";import{S as ee,i as te,g as r,s as a,r as j,A as ne,h as p,f as n,c as o,j as Y,u as _,x as b,k as Q,y as le,a as l,v as k,d as J,t as Z,w as U}from"../chunks/index.707bf1b6.js";import{T as se}from"../chunks/Tip.c2ecdbf4.js";import{C as ae}from"../chunks/CodeBlock.54a9f38d.js";import{H as X}from"../chunks/Heading.342b1fa6.js";function oe(L){let s,c='Refer to <a href="t5">T5’s documentation page</a> for API reference, tips, code examples and notebooks.';return{c(){s=r("p"),s.innerHTML=c},l(i){s=p(i,"P",{"data-svelte-h":!0}),b(s)!=="svelte-qwctac"&&(s.innerHTML=c)},m(i,$){l(i,s,$)},p:D,d(i){i&&n(s)}}}function ie(L){let s,c,i,$,u,I,d,q,h,N=`Flan-UL2 is an encoder decoder model based on the T5 architecture. It uses the same configuration as the <a href="ul2">UL2</a> model released earlier last year.
It was fine tuned using the “Flan” prompt tuning and dataset collection. Similar to <code>Flan-T5</code>,  one can directly use FLAN-UL2 weights without finetuning the model:`,F,f,W="According to the original blog here are the notable improvements:",x,g,A=`<li>The original UL2 model was only trained with receptive field of 512, which made it non-ideal for N-shot prompting where N is large.</li> <li>The Flan-UL2 checkpoint uses a receptive field of 2048 which makes it more usable for few-shot in-context learning.</li> <li>The original UL2 model also had mode switch tokens that was rather mandatory to get good performance. However, they were a little cumbersome as this requires often some changes during inference or finetuning. In this update/change, we continue training UL2 20B for an additional 100k steps (with small batch) to forget “mode tokens” before applying Flan instruction tuning. This Flan-UL2 checkpoint does not require mode tokens anymore.
Google has released the following variants:</li>`,B,w,S='The original checkpoints can be found <a href="https://github.com/google-research/t5x/blob/main/docs/models.md#flan-ul2-checkpoints" rel="nofollow">here</a>.',G,T,C,M,V="The model is pretty heavy (~40GB in half precision) so if you just want to run the model, make sure you load your model in 8bit, and use <code>device_map=&quot;auto&quot;</code> to make sure  you don’t have any OOM issue!",z,y,H,m,E,v,R;return u=new X({props:{title:"FLAN-UL2",local:"flan-ul2",headingTag:"h1"}}),d=new X({props:{title:"Overview",local:"overview",headingTag:"h2"}}),T=new X({props:{title:"Running on low resource devices",local:"running-on-low-resource-devices",headingTag:"h2"}}),y=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi11bDIlMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi11bDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzdGVwJTIwYnklMjBzdGVwJTIwcmVjaXBlJTIwdG8lMjBtYWtlJTIwYm9sb2duZXNlJTIwcGFzdGElM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-ul2&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-ul2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A step by step recipe to make bolognese pasta:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;In a large skillet, brown the ground beef and onion over medium heat. Add the garlic&#x27;</span>]`,wrap:!1}}),m=new se({props:{$$slots:{default:[oe]},$$scope:{ctx:L}}}),{c(){s=r("meta"),c=a(),i=r("p"),$=a(),j(u.$$.fragment),I=a(),j(d.$$.fragment),q=a(),h=r("p"),h.innerHTML=N,F=a(),f=r("p"),f.textContent=W,x=a(),g=r("ul"),g.innerHTML=A,B=a(),w=r("p"),w.innerHTML=S,G=a(),j(T.$$.fragment),C=a(),M=r("p"),M.innerHTML=V,z=a(),j(y.$$.fragment),H=a(),j(m.$$.fragment),E=a(),v=r("p"),this.h()},l(e){const t=ne("svelte-u9bgzb",document.head);s=p(t,"META",{name:!0,content:!0}),t.forEach(n),c=o(e),i=p(e,"P",{}),Y(i).forEach(n),$=o(e),_(u.$$.fragment,e),I=o(e),_(d.$$.fragment,e),q=o(e),h=p(e,"P",{"data-svelte-h":!0}),b(h)!=="svelte-gpwdss"&&(h.innerHTML=N),F=o(e),f=p(e,"P",{"data-svelte-h":!0}),b(f)!=="svelte-10cnwdi"&&(f.textContent=W),x=o(e),g=p(e,"UL",{"data-svelte-h":!0}),b(g)!=="svelte-145gzzg"&&(g.innerHTML=A),B=o(e),w=p(e,"P",{"data-svelte-h":!0}),b(w)!=="svelte-tjdjai"&&(w.innerHTML=S),G=o(e),_(T.$$.fragment,e),C=o(e),M=p(e,"P",{"data-svelte-h":!0}),b(M)!=="svelte-1qrqz37"&&(M.innerHTML=V),z=o(e),_(y.$$.fragment,e),H=o(e),_(m.$$.fragment,e),E=o(e),v=p(e,"P",{}),Y(v).forEach(n),this.h()},h(){Q(s,"name","hf:doc:metadata"),Q(s,"content",re)},m(e,t){le(document.head,s),l(e,c,t),l(e,i,t),l(e,$,t),k(u,e,t),l(e,I,t),k(d,e,t),l(e,q,t),l(e,h,t),l(e,F,t),l(e,f,t),l(e,x,t),l(e,g,t),l(e,B,t),l(e,w,t),l(e,G,t),k(T,e,t),l(e,C,t),l(e,M,t),l(e,z,t),k(y,e,t),l(e,H,t),k(m,e,t),l(e,E,t),l(e,v,t),R=!0},p(e,[t]){const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),m.$set(P)},i(e){R||(J(u.$$.fragment,e),J(d.$$.fragment,e),J(T.$$.fragment,e),J(y.$$.fragment,e),J(m.$$.fragment,e),R=!0)},o(e){Z(u.$$.fragment,e),Z(d.$$.fragment,e),Z(T.$$.fragment,e),Z(y.$$.fragment,e),Z(m.$$.fragment,e),R=!1},d(e){e&&(n(c),n(i),n($),n(I),n(q),n(h),n(F),n(f),n(x),n(g),n(B),n(w),n(G),n(C),n(M),n(z),n(H),n(E),n(v)),n(s),U(u,e),U(d,e),U(T,e),U(y,e),U(m,e)}}}const re='{"title":"FLAN-UL2","local":"flan-ul2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Running on low resource devices","local":"running-on-low-resource-devices","sections":[],"depth":2}],"depth":1}';function pe(L){return O(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fe extends ee{constructor(s){super(),te(this,s,pe,ie,K,{})}}export{fe as component};
