import{s as hi,o as ui,n as kn}from"../chunks/scheduler.25b97de1.js";import{S as fi,i as bi,g as s,s as n,r as m,A as vi,h as l,f as a,c as o,j as v,u as d,x as u,k as _,y as t,a as i,v as p,d as c,t as g,w as h}from"../chunks/index.d9030fc9.js";import{T as Ks}from"../chunks/Tip.baa67368.js";import{D as $}from"../chunks/Docstring.e257edda.js";import{C as Eo}from"../chunks/CodeBlock.e6cd0d95.js";import{E as pr}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as M,E as _i}from"../chunks/EditOnGithub.91d95064.js";function $i(L){let f,x=`Transformers Agents is an experimental API which is subject to change at any time. Results returned by the agents
can vary as the APIs or underlying models are prone to change.`;return{c(){f=s("p"),f.textContent=x},l(y){f=l(y,"P",{"data-svelte-h":!0}),u(f)!=="svelte-1fgfei3"&&(f.textContent=x)},m(y,w){i(y,f,w)},p:kn,d(y){y&&a(f)}}}function yi(L){let f,x="Example:",y,w,T;return w=new Eo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBQeXRob25JbnRlcnByZXRlclRvb2wlMEElMEFweXRob25faW50ZXJwcmV0ZXIlMjAlM0QlMjBQeXRob25JbnRlcnByZXRlclRvb2woKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCcHl0aG9uX2ludGVycHJldGVyJTVEKSUwQWFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjByZXN1bHQlMjBvZiUyMDIlMjBwb3dlciUyMDMuNzM4NCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> CodeAgent, PythonInterpreterTool

python_interpreter = PythonInterpreterTool()
agent = CodeAgent(tools=[python_interpreter])
agent.run(<span class="hljs-string">&quot;What is the result of 2 power 3.7384?&quot;</span>)`,wrap:!1}}),{c(){f=s("p"),f.textContent=x,y=n(),m(w.$$.fragment)},l(b){f=l(b,"P",{"data-svelte-h":!0}),u(f)!=="svelte-11lpom8"&&(f.textContent=x),y=o(b),d(w.$$.fragment,b)},m(b,C){i(b,f,C),i(b,y,C),p(w,b,C),T=!0},p:kn,i(b){T||(c(w.$$.fragment,b),T=!0)},o(b){g(w.$$.fragment,b),T=!1},d(b){b&&(a(f),a(y)),h(w,b)}}}function wi(L){let f,x="Example:",y,w,T;return w=new Eo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBSZWFjdENvZGVBZ2VudCUwQWFnZW50JTIwJTNEJTIwUmVhY3RDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQpJTBBYWdlbnQucnVuKCUyMldoYXQlMjBpcyUyMHRoZSUyMHJlc3VsdCUyMG9mJTIwMiUyMHBvd2VyJTIwMy43Mzg0JTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> ReactCodeAgent
agent = ReactCodeAgent(tools=[])
agent.run(<span class="hljs-string">&quot;What is the result of 2 power 3.7384?&quot;</span>)`,wrap:!1}}),{c(){f=s("p"),f.textContent=x,y=n(),m(w.$$.fragment)},l(b){f=l(b,"P",{"data-svelte-h":!0}),u(f)!=="svelte-11lpom8"&&(f.textContent=x),y=o(b),d(w.$$.fragment,b)},m(b,C){i(b,f,C),i(b,y,C),p(w,b,C),T=!0},p:kn,i(b){T||(c(w.$$.fragment,b),T=!0)},o(b){g(w.$$.fragment,b),T=!1},d(b){b&&(a(f),a(y)),h(w,b)}}}function Ti(L){let f,x=`Loading a tool means that you’ll download the tool and execute it locally.
ALWAYS inspect the tool you’re downloading before loading it within your runtime, as you would do when
installing a package using pip/npm/apt.`;return{c(){f=s("p"),f.textContent=x},l(y){f=l(y,"P",{"data-svelte-h":!0}),u(f)!=="svelte-1kcherd"&&(f.textContent=x)},m(y,w){i(y,f,w)},p:kn,d(y){y&&a(f)}}}function xi(L){let f,x=`Loading a tool from the Hub means that you’ll download the tool and execute it locally.
ALWAYS inspect the tool you’re downloading before loading it within your runtime, as you would do when
installing a package using pip/npm/apt.`;return{c(){f=s("p"),f.textContent=x},l(y){f=l(y,"P",{"data-svelte-h":!0}),u(f)!=="svelte-fpk7e5"&&(f.textContent=x)},m(y,w){i(y,f,w)},p:kn,d(y){y&&a(f)}}}function ki(L){let f,x="For instance:",y,w,T;return w=new Eo({props:{code:"ZnJvbSUyMG15X3Rvb2xfbW9kdWxlJTIwaW1wb3J0JTIwTXlUb29sJTBBbXlfdG9vbCUyMCUzRCUyME15VG9vbCgpJTBBbXlfdG9vbC5wdXNoX3RvX2h1YiglMjJteS11c2VybmFtZSUyRm15LXNwYWNlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> my_tool_module <span class="hljs-keyword">import</span> MyTool
my_tool = MyTool()
my_tool.push_to_hub(<span class="hljs-string">&quot;my-username/my-space&quot;</span>)`,wrap:!1}}),{c(){f=s("p"),f.textContent=x,y=n(),m(w.$$.fragment)},l(b){f=l(b,"P",{"data-svelte-h":!0}),u(f)!=="svelte-4vay6o"&&(f.textContent=x),y=o(b),d(w.$$.fragment,b)},m(b,C){i(b,f,C),i(b,y,C),p(w,b,C),T=!0},p:kn,i(b){T||(c(w.$$.fragment,b),T=!0)},o(b){g(w.$$.fragment,b),T=!1},d(b){b&&(a(f),a(y)),h(w,b)}}}function Ci(L){let f,x="Example:",y,w,T;return w=new Eo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2xDb2xsZWN0aW9uJTJDJTIwUmVhY3RDb2RlQWdlbnQlMEElMEFpbWFnZV90b29sX2NvbGxlY3Rpb24lMjAlM0QlMjBUb29sQ29sbGVjdGlvbihjb2xsZWN0aW9uX3NsdWclM0QlMjJodWdnaW5nZmFjZS10b29scyUyRmRpZmZ1c2lvbi10b29scy02NjMwYmIxOWE5NDJjMjMwNmEyY2RiNmYlMjIpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QippbWFnZV90b29sX2NvbGxlY3Rpb24udG9vbHMlNUQlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUyMlBsZWFzZSUyMGRyYXclMjBtZSUyMGElMjBwaWN0dXJlJTIwb2YlMjByaXZlcnMlMjBhbmQlMjBsYWtlcy4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ToolCollection, ReactCodeAgent

<span class="hljs-meta">&gt;&gt;&gt; </span>image_tool_collection = ToolCollection(collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactCodeAgent(tools=[*image_tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),{c(){f=s("p"),f.textContent=x,y=n(),m(w.$$.fragment)},l(b){f=l(b,"P",{"data-svelte-h":!0}),u(f)!=="svelte-11lpom8"&&(f.textContent=x),y=o(b),d(w.$$.fragment,b)},m(b,C){i(b,f,C),i(b,y,C),p(w,b,C),T=!0},p:kn,i(b){T||(c(w.$$.fragment,b),T=!0)},o(b){g(w.$$.fragment,b),T=!1},d(b){b&&(a(f),a(y)),h(w,b)}}}function Mi(L){let f,x,y,w,T,b,C,No,Re,el=`To learn more about agents and tools make sure to read the <a href="../transformers_agents">introductory guide</a>. This page
contains the API docs for the underlying classes.`,Ho,Ve,Do,Be,tl='We provide two types of agents, based on the main <a href="/docs/transformers/main/en/main_classes/agent#transformers.Agent">Agent</a> class:',Wo,ze,nl='<li><a href="/docs/transformers/main/en/main_classes/agent#transformers.CodeAgent">CodeAgent</a> acts in one shot, generating code to solve the task, then executes it at once.</li> <li><a href="/docs/transformers/main/en/main_classes/agent#transformers.ReactAgent">ReactAgent</a> acts step by step, each step consisting of one thought, then one tool call and execution. It has two classes:<ul><li><a href="/docs/transformers/main/en/main_classes/agent#transformers.ReactJsonAgent">ReactJsonAgent</a> writes its tool calls in JSON.</li> <li><a href="/docs/transformers/main/en/main_classes/agent#transformers.ReactCodeAgent">ReactCodeAgent</a> writes its tool calls in Python code.</li></ul></li>',Ro,Ze,Vo,P,Se,cr,oe,Ge,gr,Cn,ol=`Execute tool with the provided input and returns the result.
This method replaces arguments with the actual values from the state if they refer to state variables.`,hr,ae,Oe,ur,Mn,al="Parse action from the LLM output",fr,re,Fe,br,In,rl="To be implemented in the child class",vr,se,Ye,_r,An,sl=`Reads past llm_outputs, actions, and observations or errors from the logs into a series of messages
that can be used as input to the LLM.`,Bo,Qe,zo,H,Xe,$r,jn,ll="A class for an agent that solves the given task using a single block of code. It plans all its actions, then executes all in one shot.",yr,le,Ke,wr,qn,il=`Override this method if you want to change the way the code is
cleaned in the <code>run</code> method.`,Tr,O,et,xr,Ln,ml="Runs the agent for the given task.",kr,ie,Zo,tt,So,A,nt,Cr,Pn,dl=`This agent that solves the given task step by step, using the ReAct framework:
While the objective is not reached, the agent will perform a cycle of thinking and acting.
The action will be parsed from the LLM output: it consists in calls to tools from the toolbox, with arguments chosen by the LLM engine.`,Mr,me,ot,Ir,Jn,pl="Runs the agent in direct mode, returning outputs only at the end: should be launched only in the <code>run</code> method.",Ar,de,at,jr,En,cl="Used periodically by the agent to plan the next steps to reach the objective.",qr,pe,rt,Lr,Un,gl="This method provides a final answer to the task, based on the logs of the agent’s interactions.",Pr,F,st,Jr,Nn,hl="Runs the agent for the given task.",Er,ce,Ur,ge,lt,Nr,Hn,ul="Runs the agent in streaming mode, yielding steps as they are executed: should be launched only in the <code>run</code> method.",Go,z,it,Hr,Dn,fl=`This agent that solves the given task step by step, using the ReAct framework:
While the objective is not reached, the agent will perform a cycle of thinking and acting.
The tool calls will be formulated by the LLM in JSON format, then parsed and executed.`,Dr,he,mt,Wr,Wn,bl=`Perform one step in the ReAct framework: the agent thinks, acts, and observes the result.
The errors are raised here, they are caught and logged in the run() method.`,Oo,Z,dt,Rr,Rn,vl=`This agent that solves the given task step by step, using the ReAct framework:
While the objective is not reached, the agent will perform a cycle of thinking and acting.
The tool calls will be formulated by the LLM in code format, then parsed and executed.`,Vr,ue,pt,Br,Vn,_l=`Perform one step in the ReAct framework: the agent thinks, acts, and observes the result.
The errors are raised here, they are caught and logged in the run() method.`,Fo,ct,Yo,gt,ht,Qo,ut,Xo,ft,Ko,S,bt,zr,Bn,$l="Main function to quickly load a tool, be it on the Hub or in the Transformers library.",Zr,fe,ea,vt,ta,k,_t,Sr,zn,yl=`A base class for the functions used by the agent. Subclass this and implement the <code>__call__</code> method as well as the
following class attributes:`,Gr,Zn,wl=`<li><strong>description</strong> (<code>str</code>) — A short description of what your tool does, the inputs it expects and the output(s) it
will return. For instance ‘This is a tool that downloads a file from a <code>url</code>. It takes the <code>url</code> as input, and
returns the text contained in the file’.</li> <li><strong>name</strong> (<code>str</code>) — A performative name that will be used for your tool in the prompt to the agent. For instance
<code>&quot;text-classifier&quot;</code> or <code>&quot;image_generator&quot;</code>.</li> <li><strong>inputs</strong> (<code>Dict[str, Dict[str, Union[str, type]]]</code>) — The dict of modalities expected for the inputs.
It has one <code>type</code>key and a <code>description</code>key.
This is used by <code>launch_gradio_demo</code> or to make a nice space from your tool, and also can be used in the generated
description for your tool.</li> <li><strong>output_type</strong> (<code>type</code>) — The type of the tool output. This is used by <code>launch_gradio_demo</code>
or to make a nice space from your tool, and also can be used in the generated description for your tool.</li>`,Or,Sn,Tl=`You can also override the method <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool.setup">setup()</a> if your tool as an expensive operation to perform before being
usable (such as loading a model). <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool.setup">setup()</a> will be called the first time you use your tool, but not at
instantiation.`,Fr,be,$t,Yr,Gn,xl='Creates a <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool">Tool</a> from a gradio tool.',Qr,Y,yt,Xr,On,kl="Loads a tool defined on the Hub.",Kr,ve,es,_e,wt,ts,Fn,Cl='Creates a <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool">Tool</a> from a langchain tool.',ns,V,Tt,os,Yn,Ml="Upload the tool to the Hub.",as,Qn,Il="For this method to work properly, your tool must have been defined in a separate module (not <code>__main__</code>).",rs,$e,ss,B,xt,ls,Xn,Al=`Saves the relevant code files for your tool so it can be pushed to the Hub. This will copy the code of your
tool in <code>output_dir</code> as well as autogenerate:`,is,Kn,jl=`<li>a config file named <code>tool_config.json</code></li> <li>an <code>app.py</code> file so that your tool can be converted to a space</li> <li>a <code>requirements.txt</code> containing the names of the module used by your tool (as detected when inspecting its
code)</li>`,ms,eo,ql="You should only use this method to save tools that are defined in a separate module (not <code>__main__</code>).",ds,ye,kt,ps,to,Ll=`Overwrite this method here for any operation that is expensive and needs to be executed before you start using
your tool. Such as loading a big model.`,na,Ct,oa,j,Mt,cs,no,Pl=`The toolbox contains all tools that the agent can perform operations with, as well as a few methods to
manage them.`,gs,we,It,hs,oo,Jl="Adds a tool to the toolbox",us,Te,At,fs,ao,El="Clears the toolbox",bs,xe,jt,vs,ro,Ul="Removes a tool from the toolbox",_s,ke,qt,$s,so,Nl="Returns the description of all tools in the toolbox",ys,Ce,Lt,ws,lo,Hl="Updates a tool in the toolbox according to its name.",aa,Pt,ra,q,Jt,Ts,io,Dl=`A <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool">Tool</a> tailored towards Transformer models. On top of the class attributes of the base class <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool">Tool</a>, you will
need to specify:`,xs,mo,Wl=`<li><strong>model_class</strong> (<code>type</code>) — The class to use to load the model in this tool.</li> <li><strong>default_checkpoint</strong> (<code>str</code>) — The default checkpoint that should be used when the user doesn’t specify one.</li> <li><strong>pre_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a>) — The class to use to load the
pre-processor</li> <li><strong>post_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a>) — The class to use to load the
post-processor (when different from the pre-processor).</li>`,ks,Me,Et,Cs,po,Rl="Uses the <code>post_processor</code> to decode the model output.",Ms,Ie,Ut,Is,co,Vl="Uses the <code>pre_processor</code> to prepare the inputs for the <code>model</code>.",As,Ae,Nt,js,go,Bl="Sends the inputs through the <code>model</code>.",qs,je,Ht,Ls,ho,zl="Instantiates the <code>pre_processor</code>, <code>model</code> and <code>post_processor</code> if necessary.",sa,Dt,la,X,Wt,Ps,uo,Zl=`Launches a gradio demo for a tool. The corresponding tool class needs to properly implement the class attributes
<code>inputs</code> and <code>output_type</code>.`,ia,Rt,ma,K,Vt,Js,fo,Sl="Runs an agent with the given task and streams the messages from the agent as gradio ChatMessages.",da,Bt,pa,D,zt,Es,bo,Gl="Tool collections enable loading all Spaces from a collection in order to be added to the agent’s toolbox.",Us,vo,Ol=`<p>[!NOTE]
Only Spaces will be fetched, so you can feel free to add models and datasets to your collection if you’d
like for this collection to showcase them.</p>`,Ns,qe,ca,Zt,ga,St,Fl=`You’re free to create and use your own engines to be usable by the Agents framework.
These engines have the following specification:`,ha,Gt,Yl='<li>Follow the <a href="../chat_templating.md">messages format</a> for its input (<code>List[Dict[str, str]]</code>) and return a string.</li> <li>Stop generating outputs <em>before</em> the sequences passed in the argument <code>stop_sequences</code></li>',ua,Ot,fa,Ft,Ql="For convenience, we have added a <code>TransformersEngine</code> that implements the points above, taking a pre-initialized <code>Pipeline</code> as input.",ba,Yt,va,ee,Qt,Hs,_o,Xl="This engine uses a pre-initialized local text-generation pipeline.",_a,Xt,$a,Kt,Kl='The <code>HfApiEngine</code> is an engine that wraps an <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">HF Inference API</a> client for the execution of the LLM.',ya,en,wa,te,tn,Ds,$o,ei="This engine leverages Hugging Face’s Inference API service, either serverless or with a dedicated endpoint.",Ta,nn,xa,on,ti=`Agents can handle any type of object in-between tools; tools, being completely multimodal, can accept and return
text, image, audio, video, among other types. In order to increase compatibility between tools, as well as to
correctly render these returns in ipython (jupyter, colab, ipython notebooks, …), we implement wrapper classes
around these types.`,ka,an,ni=`The wrapped objects should continue behaving as initially; a text object should still behave as a string, an image
object should still behave as a <code>PIL.Image</code>.`,Ca,rn,oi="These types have three specific purposes:",Ma,sn,ai=`<li>Calling <code>to_raw</code> on the type should return the underlying object</li> <li>Calling <code>to_string</code> on the type should return the object as a string: that can be the string in case of an <code>AgentText</code>
but will be the path of the serialized version of the object in other instances</li> <li>Displaying it in an ipython kernel should display the object correctly</li>`,Ia,ln,Aa,ne,mn,Ws,yo,ri="Text type returned by the agent. Behaves as a string.",ja,dn,qa,J,pn,Rs,wo,si="Image type returned by the agent. Behaves as a PIL.Image.",Vs,Le,cn,Bs,To,li="Saves the image to a file.",zs,Pe,gn,Zs,xo,ii="Returns the “raw” version of that object. In the case of an AgentImage, it is a PIL.Image.",Ss,Je,hn,Gs,ko,mi=`Returns the stringified version of that object. In the case of an AgentImage, it is a path to the serialized
version of the image.`,La,un,Pa,W,fn,Os,Co,di="Audio type returned by the agent.",Fs,Ee,bn,Ys,Mo,pi="Returns the “raw” version of that object. It is a <code>torch.Tensor</code> object.",Qs,Ue,vn,Xs,Io,ci=`Returns the stringified version of that object. In the case of an AgentAudio, it is a path to the serialized
version of the audio.`,Ja,_n,Ea,Uo,Ua;return T=new M({props:{title:"Agents & Tools",local:"agents--tools",headingTag:"h1"}}),C=new Ks({props:{warning:!0,$$slots:{default:[$i]},$$scope:{ctx:L}}}),Ve=new M({props:{title:"Agents",local:"agents",headingTag:"h2"}}),Ze=new M({props:{title:"Agent",local:"transformers.Agent",headingTag:"h3"}}),Se=new $({props:{name:"class transformers.Agent",anchor:"transformers.Agent",parameters:[{name:"tools",val:": Union"},{name:"llm_engine",val:": Callable = <transformers.agents.llm_engine.HfApiEngine object at 0x7f5855315990>"},{name:"system_prompt",val:" = 'You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.\\nTo do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.\\nTo solve the task, you must plan forward to proceed in a series of steps, in a cycle of \\'Thought:\\', \\'Code:\\', and \\'Observation:\\' sequences.\\n\\nAt each step, in the \\'Thought:\\' sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.\\nThen in the \\'Code:\\' sequence, you should write the code in simple Python. The code sequence must end with \\'<end_action>\\' sequence.\\nDuring each intermediate step, you can use \\'print()\\' to save whatever important information you will then need.\\nThese print outputs will then appear in the \\'Observation:\\' field, which will be available as input for the next step.\\nIn the end you have to return a final answer using the `final_answer` tool.\\n\\nHere are a few examples using notional tools:\\n---\\nTask: \"Generate an image of the oldest person in this document.\"\\n\\nThought: I will proceed step by step and use the following tools: `document_qa` to find the oldest person in the document, then `image_generator` to generate an image according to the answer.\\nCode:\\n```py\\nanswer = document_qa(document=document, question=\"Who is the oldest person mentioned?\")\\nprint(answer)\\n```<end_action>\\nObservation: \"The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.\"\\n\\nThought: I will now generate an image showcasing the oldest person.\\nCode:\\n```py\\nimage = image_generator(\"A portrait of John Doe, a 55-year-old man living in Canada.\")\\nfinal_answer(image)\\n```<end_action>\\n\\n---\\nTask: \"What is the result of the following operation: 5 + 3 + 1294.678?\"\\n\\nThought: I will use python code to compute the result of the operation and then return the final answer using the `final_answer` tool\\nCode:\\n```py\\nresult = 5 + 3 + 1294.678\\nfinal_answer(result)\\n```<end_action>\\n\\n---\\nTask: \"Which city has the highest population: Guangzhou or Shanghai?\"\\n\\nThought: I need to get the populations for both cities and compare them: I will use the tool `search` to get the population of both cities.\\nCode:\\n```py\\npopulation_guangzhou = search(\"Guangzhou population\")\\nprint(\"Population Guangzhou:\", population_guangzhou)\\npopulation_shanghai = search(\"Shanghai population\")\\nprint(\"Population Shanghai:\", population_shanghai)\\n```<end_action>\\nObservation:\\nPopulation Guangzhou: [\\'Guangzhou has a population of 15 million inhabitants as of 2021.\\']\\nPopulation Shanghai: \\'26 million (2019)\\'\\n\\nThought: Now I know that Shanghai has the highest population.\\nCode:\\n```py\\nfinal_answer(\"Shanghai\")\\n```<end_action>\\n\\n---\\nTask: \"What is the current age of the pope, raised to the power 0.36?\"\\n\\nThought: I will use the tool `wiki` to get the age of the pope, then raise it to the power 0.36.\\nCode:\\n```py\\npope_age = wiki(query=\"current pope age\")\\nprint(\"Pope age:\", pope_age)\\n```<end_action>\\nObservation:\\nPope age: \"The pope Francis is currently 85 years old.\"\\n\\nThought: I know that the pope is 85 years old. Let\\'s compute the result using python code.\\nCode:\\n```py\\npope_current_age = 85 ** 0.36\\nfinal_answer(pope_current_age)\\n```<end_action>\\n\\nAbove example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you have acces to those tools (and no other tool):\\n\\n<<tool_descriptions>>\\n\\n<<managed_agents_descriptions>>\\n\\nHere are the rules you should always follow to solve your task:\\n1. Always provide a \\'Thought:\\' sequence, and a \\'Code:\\n```py\\' sequence ending with \\'```<end_action>\\' sequence, else you will fail.\\n2. Use only variables that you have defined!\\n3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in \\'answer = wiki({\\'query\\': \"What is the place where James Bond lives?\"})\\', but use the arguments directly as in \\'answer = wiki(query=\"What is the place where James Bond lives?\")\\'.\\n4. Take care to not chain too many sequential tool calls in the same code block, especially when the output format is unpredictable. For instance, a call to search has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.\\n5. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.\\n6. Don\\'t name any new variable with the same name as a tool: for instance don\\'t name a variable \\'final_answer\\'.\\n7. Never create any notional variables in our code, as having these in your logs might derail you from the true variables.\\n8. You can use imports in your code, but only from the following list of modules: <<authorized_imports>>\\n9. The state persists between code executions: so if in one step you\\'ve created variables or imported modules, these will all persist.\\n10. Don\\'t give up! You\\'re in charge of solving the task, not providing directions to solve it.\\n\\nNow Begin! If you solve the task correctly, you will receive a reward of $1,000,000.\\n'"},{name:"tool_description_template",val:" = None"},{name:"additional_args",val:" = {}"},{name:"max_iterations",val:": int = 6"},{name:"tool_parser",val:" = <function parse_json_tool_call at 0x7f5855318790>"},{name:"add_base_tools",val:": bool = False"},{name:"verbose",val:": int = 0"},{name:"grammar",val:": Dict = None"},{name:"managed_agents",val:": List = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L352"}}),Ge=new $({props:{name:"execute_tool_call",anchor:"transformers.Agent.execute_tool_call",parameters:[{name:"tool_name",val:": str"},{name:"arguments",val:": Dict"}],parametersDescription:[{anchor:"transformers.Agent.execute_tool_call.tool_name",description:"<strong>tool_name</strong> (<code>str</code>) &#x2014; Name of the Tool to execute (should be one from self.toolbox).",name:"tool_name"},{anchor:"transformers.Agent.execute_tool_call.arguments",description:"<strong>arguments</strong> (Dict[str, str]) &#x2014; Arguments passed to the Tool.",name:"arguments"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L513"}}),Oe=new $({props:{name:"extract_action",anchor:"transformers.Agent.extract_action",parameters:[{name:"llm_output",val:": str"},{name:"split_token",val:": str"}],parametersDescription:[{anchor:"transformers.Agent.extract_action.llm_output",description:"<strong>llm_output</strong> (<code>str</code>) &#x2014; Output of the LLM",name:"llm_output"},{anchor:"transformers.Agent.extract_action.split_token",description:"<strong>split_token</strong> (<code>str</code>) &#x2014; Separator for the action. Should match the example in the system prompt.",name:"split_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L492"}}),Fe=new $({props:{name:"run",anchor:"transformers.Agent.run",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L568"}}),Ye=new $({props:{name:"write_inner_memory_from_logs",anchor:"transformers.Agent.write_inner_memory_from_logs",parameters:[{name:"summary_mode",val:": Optional = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L432"}}),Qe=new M({props:{title:"CodeAgent",local:"transformers.CodeAgent",headingTag:"h3"}}),Xe=new $({props:{name:"class transformers.CodeAgent",anchor:"transformers.CodeAgent",parameters:[{name:"tools",val:": List"},{name:"llm_engine",val:": Callable = <transformers.agents.llm_engine.HfApiEngine object at 0x7f5855315c30>"},{name:"system_prompt",val:': str = \'You will be given a task to solve, your job is to come up with a series of simple commands in Python that will perform the task.\\nTo help you, I will give you access to a set of tools that you can use. Each tool is a Python function and has a description explaining the task it performs, the inputs it expects and the outputs it returns.\\nYou should first explain which tool you will use to perform the task and for what reason, then write the code in Python.\\nEach instruction in Python should be a simple assignment. You can print intermediate results if it makes sense to do so.\\nIn the end, use tool \\\'final_answer\\\' to return your answer, its argument will be what gets returned.\\nYou can use imports in your code, but only from the following list of modules: <<authorized_imports>>\\nBe sure to provide a \\\'Code:\\\' token, else the run will fail.\\n\\nTools:\\n<<tool_descriptions>>\\n\\nExamples:\\n---\\nTask: "Answer the question in the variable `question` about the image stored in the variable `image`. The question is in French."\\n\\nThought: I will use the following tools: `translator` to translate the question into English and then `image_qa` to answer the question on the input image.\\nCode:\\n```py\\ntranslated_question = translator(question=question, src_lang="French", tgt_lang="English")\\nprint(f"The translated question is {translated_question}.")\\nanswer = image_qa(image=image, question=translated_question)\\nfinal_answer(f"The answer is {answer}")\\n```<end_action>\\n\\n---\\nTask: "Identify the oldest person in the `document` and create an image showcasing the result."\\n\\nThought: I will use the following tools: `document_qa` to find the oldest person in the document, then `image_generator` to generate an image according to the answer.\\nCode:\\n```py\\nanswer = document_qa(document, question="What is the oldest person?")\\nprint(f"The answer is {answer}.")\\nimage = image_generator(answer)\\nfinal_answer(image)\\n```<end_action>\\n\\n---\\nTask: "Generate an image using the text given in the variable `caption`."\\n\\nThought: I will use the following tool: `image_generator` to generate an image.\\nCode:\\n```py\\nimage = image_generator(prompt=caption)\\nfinal_answer(image)\\n```<end_action>\\n\\n---\\nTask: "Summarize the text given in the variable `text` and read it out loud."\\n\\nThought: I will use the following tools: `summarizer` to create a summary of the input text, then `text_reader` to read it out loud.\\nCode:\\n```py\\nsummarized_text = summarizer(text)\\nprint(f"Summary: {summarized_text}")\\naudio_summary = text_reader(summarized_text)\\nfinal_answer(audio_summary)\\n```<end_action>\\n\\n---\\nTask: "Answer the question in the variable `question` about the text in the variable `text`. Use the answer to generate an image."\\n\\nThought: I will use the following tools: `text_qa` to create the answer, then `image_generator` to generate an image according to the answer.\\nCode:\\n```py\\nanswer = text_qa(text=text, question=question)\\nprint(f"The answer is {answer}.")\\nimage = image_generator(answer)\\nfinal_answer(image)\\n```<end_action>\\n\\n---\\nTask: "Caption the following `image`."\\n\\nThought: I will use the following tool: `image_captioner` to generate a caption for the image.\\nCode:\\n```py\\ncaption = image_captioner(image)\\nfinal_answer(caption)\\n```<end_action>\\n\\n---\\nAbove example were using tools that might not exist for you. You only have acces to those Tools:\\n<<tool_names>>\\n\\nRemember to make sure that variables you use are all defined.\\nBe sure to provide a \\\'Code:\\n```\\\' sequence before the code and \\\'```<end_action>\\\' after, else you will get an error.\\nDO NOT pass the arguments as a dict as in \\\'answer = ask_search_agent({\\\'query\\\': "What is the place where James Bond lives?"})\\\', but use the arguments directly as in \\\'answer = ask_search_agent(query="What is the place where James Bond lives?")\\\'.\\n\\nNow Begin! If you solve the task correctly, you will receive a reward of $1,000,000.\\n\''},{name:"tool_description_template",val:": str = '\\n- {{ tool.name }}: {{ tool.description }}\\n    Takes inputs: {{tool.inputs}}\\n'"},{name:"grammar",val:": Dict = None"},{name:"additional_authorized_imports",val:": Optional = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L573"}}),Ke=new $({props:{name:"parse_code_blob",anchor:"transformers.CodeAgent.parse_code_blob",parameters:[{name:"result",val:": str"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L609"}}),et=new $({props:{name:"run",anchor:"transformers.CodeAgent.run",parameters:[{name:"task",val:": str"},{name:"return_generated_code",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeAgent.run.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.CodeAgent.run.return_generated_code",description:"<strong>return_generated_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to return the generated code instead of running it",name:"return_generated_code"},{anchor:"transformers.CodeAgent.run.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any keyword argument to send to the agent when evaluating the code.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L616"}}),ie=new pr({props:{anchor:"transformers.CodeAgent.run.example",$$slots:{default:[yi]},$$scope:{ctx:L}}}),tt=new M({props:{title:"React agents",local:"transformers.ReactAgent",headingTag:"h3"}}),nt=new $({props:{name:"class transformers.ReactAgent",anchor:"transformers.ReactAgent",parameters:[{name:"tools",val:": List"},{name:"llm_engine",val:": Callable = <transformers.agents.llm_engine.HfApiEngine object at 0x7f5855315db0>"},{name:"system_prompt",val:": str = 'You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.\\nTo do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.\\nTo solve the task, you must plan forward to proceed in a series of steps, in a cycle of \\'Thought:\\', \\'Code:\\', and \\'Observation:\\' sequences.\\n\\nAt each step, in the \\'Thought:\\' sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.\\nThen in the \\'Code:\\' sequence, you should write the code in simple Python. The code sequence must end with \\'<end_action>\\' sequence.\\nDuring each intermediate step, you can use \\'print()\\' to save whatever important information you will then need.\\nThese print outputs will then appear in the \\'Observation:\\' field, which will be available as input for the next step.\\nIn the end you have to return a final answer using the `final_answer` tool.\\n\\nHere are a few examples using notional tools:\\n---\\nTask: \"Generate an image of the oldest person in this document.\"\\n\\nThought: I will proceed step by step and use the following tools: `document_qa` to find the oldest person in the document, then `image_generator` to generate an image according to the answer.\\nCode:\\n```py\\nanswer = document_qa(document=document, question=\"Who is the oldest person mentioned?\")\\nprint(answer)\\n```<end_action>\\nObservation: \"The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.\"\\n\\nThought: I will now generate an image showcasing the oldest person.\\nCode:\\n```py\\nimage = image_generator(\"A portrait of John Doe, a 55-year-old man living in Canada.\")\\nfinal_answer(image)\\n```<end_action>\\n\\n---\\nTask: \"What is the result of the following operation: 5 + 3 + 1294.678?\"\\n\\nThought: I will use python code to compute the result of the operation and then return the final answer using the `final_answer` tool\\nCode:\\n```py\\nresult = 5 + 3 + 1294.678\\nfinal_answer(result)\\n```<end_action>\\n\\n---\\nTask: \"Which city has the highest population: Guangzhou or Shanghai?\"\\n\\nThought: I need to get the populations for both cities and compare them: I will use the tool `search` to get the population of both cities.\\nCode:\\n```py\\npopulation_guangzhou = search(\"Guangzhou population\")\\nprint(\"Population Guangzhou:\", population_guangzhou)\\npopulation_shanghai = search(\"Shanghai population\")\\nprint(\"Population Shanghai:\", population_shanghai)\\n```<end_action>\\nObservation:\\nPopulation Guangzhou: [\\'Guangzhou has a population of 15 million inhabitants as of 2021.\\']\\nPopulation Shanghai: \\'26 million (2019)\\'\\n\\nThought: Now I know that Shanghai has the highest population.\\nCode:\\n```py\\nfinal_answer(\"Shanghai\")\\n```<end_action>\\n\\n---\\nTask: \"What is the current age of the pope, raised to the power 0.36?\"\\n\\nThought: I will use the tool `wiki` to get the age of the pope, then raise it to the power 0.36.\\nCode:\\n```py\\npope_age = wiki(query=\"current pope age\")\\nprint(\"Pope age:\", pope_age)\\n```<end_action>\\nObservation:\\nPope age: \"The pope Francis is currently 85 years old.\"\\n\\nThought: I know that the pope is 85 years old. Let\\'s compute the result using python code.\\nCode:\\n```py\\npope_current_age = 85 ** 0.36\\nfinal_answer(pope_current_age)\\n```<end_action>\\n\\nAbove example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you have acces to those tools (and no other tool):\\n\\n<<tool_descriptions>>\\n\\n<<managed_agents_descriptions>>\\n\\nHere are the rules you should always follow to solve your task:\\n1. Always provide a \\'Thought:\\' sequence, and a \\'Code:\\n```py\\' sequence ending with \\'```<end_action>\\' sequence, else you will fail.\\n2. Use only variables that you have defined!\\n3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in \\'answer = wiki({\\'query\\': \"What is the place where James Bond lives?\"})\\', but use the arguments directly as in \\'answer = wiki(query=\"What is the place where James Bond lives?\")\\'.\\n4. Take care to not chain too many sequential tool calls in the same code block, especially when the output format is unpredictable. For instance, a call to search has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.\\n5. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.\\n6. Don\\'t name any new variable with the same name as a tool: for instance don\\'t name a variable \\'final_answer\\'.\\n7. Never create any notional variables in our code, as having these in your logs might derail you from the true variables.\\n8. You can use imports in your code, but only from the following list of modules: <<authorized_imports>>\\n9. The state persists between code executions: so if in one step you\\'ve created variables or imported modules, these will all persist.\\n10. Don\\'t give up! You\\'re in charge of solving the task, not providing directions to solve it.\\n\\nNow Begin! If you solve the task correctly, you will receive a reward of $1,000,000.\\n'"},{name:"tool_description_template",val:": str = '\\n- {{ tool.name }}: {{ tool.description }}\\n    Takes inputs: {{tool.inputs}}\\n'"},{name:"grammar",val:": Dict = None"},{name:"plan_type",val:": Literal = 'default'"},{name:"planning_interval",val:": Optional = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L694"}}),ot=new $({props:{name:"direct_run",anchor:"transformers.ReactAgent.direct_run",parameters:[{name:"task",val:": str"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L802"}}),at=new $({props:{name:"planning_step",anchor:"transformers.ReactAgent.planning_step",parameters:[{name:"task",val:""},{name:"is_first_step",val:": bool = False"},{name:"iteration",val:": int = None"}],parametersDescription:[{anchor:"transformers.ReactAgent.planning_step.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.ReactAgent.planning_step.is_first_step",description:"<strong>is_first_step</strong> (<code>bool</code>) &#x2014; If this step is not the first one, the plan should be an update over a previous plan.",name:"is_first_step"},{anchor:"transformers.ReactAgent.planning_step.iteration",description:"<strong>iteration</strong> (<code>int</code>) &#x2014; The number of the current step, used as an indication for the LLM.",name:"iteration"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L831"}}),rt=new $({props:{name:"provide_final_answer",anchor:"transformers.ReactAgent.provide_final_answer",parameters:[{name:"task",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L724"}}),st=new $({props:{name:"run",anchor:"transformers.ReactAgent.run",parameters:[{name:"task",val:": str"},{name:"stream",val:": bool = False"},{name:"reset",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ReactAgent.run.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L746"}}),ce=new pr({props:{anchor:"transformers.ReactAgent.run.example",$$slots:{default:[wi]},$$scope:{ctx:L}}}),lt=new $({props:{name:"stream_run",anchor:"transformers.ReactAgent.stream_run",parameters:[{name:"task",val:": str"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L773"}}),it=new $({props:{name:"class transformers.ReactJsonAgent",anchor:"transformers.ReactJsonAgent",parameters:[{name:"tools",val:": List"},{name:"llm_engine",val:": Callable = <transformers.agents.llm_engine.HfApiEngine object at 0x7f5855315f60>"},{name:"system_prompt",val:`: str = 'You are an expert assistant who can solve any task using JSON tool calls. You will be given a task to solve as best you can.\\nTo do so, you have been given access to the following tools: <<tool_names>>\\nThe way you use the tools is by specifying a json blob, ending with \\'<end_action>\\'.\\nSpecifically, this json should have an \`action\` key (name of the tool to use) and an \`action_input\` key (input to the tool).\\n\\nThe $ACTION_JSON_BLOB should only contain a SINGLE action, do NOT return a list of multiple actions. It should be formatted in json. Do not try to escape special characters. Here is the template of a valid $ACTION_JSON_BLOB:\\n{\\n  "action": $TOOL_NAME,\\n  "action_input": $INPUT\\n}<end_action>\\n\\nMake sure to have the $INPUT as a dictionary in the right format for the tool you are using, and do not put variable names as input if you can find the right values.\\n\\nYou should ALWAYS use the following format:\\n\\nThought: you should always think about one action to take. Then use the action as follows:\\nAction:\\n$ACTION_JSON_BLOB\\nObservation: the result of the action\\n... (this Thought/Action/Observation can repeat N times, you should take several steps when needed. The $ACTION_JSON_BLOB must only use a SINGLE action at a time.)\\n\\nYou can use the result of the previous action as input for the next action.\\nThe observation will always be a string: it can represent a file, like "image_1.jpg".\\nThen you can use it as input for the next action. You can do it for instance as follows:\\n\\nObservation: "image_1.jpg"\\n\\nThought: I need to transform the image that I received in the previous observation to make it green.\\nAction:\\n{\\n  "action": "image_transformer",\\n  "action_input": {"image": "image_1.jpg"}\\n}<end_action>\\n\\nTo provide the final answer to the task, use an action blob with "action": "final_answer" tool. It is the only way to complete the task, else you will be stuck on a loop. So your final output should look like this:\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": {"answer": "insert your final answer here"}\\n}<end_action>\\n\\n\\nHere are a few examples using notional tools:\\n---\\nTask: "Generate an image of the oldest person in this document."\\n\\nThought: I will proceed step by step and use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.\\nAction:\\n{\\n  "action": "document_qa",\\n  "action_input": {"document": "document.pdf", "question": "Who is the oldest person mentioned?"}\\n}<end_action>\\nObservation: "The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland."\\n\\n\\nThought: I will now generate an image showcasing the oldest person.\\nAction:\\n{\\n  "action": "image_generator",\\n  "action_input": {"text": ""A portrait of John Doe, a 55-year-old man living in Canada.""}\\n}<end_action>\\nObservation: "image.png"\\n\\nThought: I will now return the generated image.\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": "image.png"\\n}<end_action>\\n\\n---\\nTask: "What is the result of the following operation: 5 + 3 + 1294.678?"\\n\\nThought: I will use python code evaluator to compute the result of the operation and then return the final answer using the \`final_answer\` tool\\nAction:\\n{\\n    "action": "python_interpreter",\\n    "action_input": {"code": "5 + 3 + 1294.678"}\\n}<end_action>\\nObservation: 1302.678\\n\\nThought: Now that I know the result, I will now return it.\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": "1302.678"\\n}<end_action>\\n\\n---\\nTask: "Which city has the highest population , Guangzhou or Shanghai?"\\n\\nThought: I need to get the populations for both cities and compare them: I will use the tool \`search\` to get the population of both cities.\\nAction:\\n{\\n    "action": "search",\\n    "action_input": "Population Guangzhou"\\n}<end_action>\\nObservation: [\\'Guangzhou has a population of 15 million inhabitants as of 2021.\\']\\n\\n\\nThought: Now let\\'s get the population of Shanghai using the tool \\'search\\'.\\nAction:\\n{\\n    "action": "search",\\n    "action_input": "Population Shanghai"\\n}\\nObservation: \\'26 million (2019)\\'\\n\\nThought: Now I know that Shanghai has a larger population. Let\\'s return the result.\\nAction:\\n{\\n  "action": "final_answer",\\n  "action_input": "Shanghai"\\n}<end_action>\\n\\n\\nAbove example were using notional tools that might not exist for you. You only have acces to those tools:\\n<<tool_descriptions>>\\n\\nHere are the rules you should always follow to solve your task:\\n1. ALWAYS provide a \\'Thought:\\' sequence, and an \\'Action:\\' sequence that ends with <end_action>, else you will fail.\\n2. Always use the right arguments for the tools. Never use variable names in the \\'action_input\\' field, use the value instead.\\n3. Call a tool only when needed: do not call the search agent if you do not need information, try to solve the task yourself.\\n4. Never re-do a tool call that you previously did with the exact same parameters.\\n\\nNow Begin! If you solve the task correctly, you will receive a reward of $1,000,000.\\n'`},{name:"tool_description_template",val:": str = '\\n- {{ tool.name }}: {{ tool.description }}\\n    Takes inputs: {{tool.inputs}}\\n'"},{name:"grammar",val:": Dict = None"},{name:"planning_interval",val:": Optional = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L931"}}),mt=new $({props:{name:"step",anchor:"transformers.ReactJsonAgent.step",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L958"}}),dt=new $({props:{name:"class transformers.ReactCodeAgent",anchor:"transformers.ReactCodeAgent",parameters:[{name:"tools",val:": List"},{name:"llm_engine",val:": Callable = <transformers.agents.llm_engine.HfApiEngine object at 0x7f58553160e0>"},{name:"system_prompt",val:": str = 'You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.\\nTo do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.\\nTo solve the task, you must plan forward to proceed in a series of steps, in a cycle of \\'Thought:\\', \\'Code:\\', and \\'Observation:\\' sequences.\\n\\nAt each step, in the \\'Thought:\\' sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.\\nThen in the \\'Code:\\' sequence, you should write the code in simple Python. The code sequence must end with \\'<end_action>\\' sequence.\\nDuring each intermediate step, you can use \\'print()\\' to save whatever important information you will then need.\\nThese print outputs will then appear in the \\'Observation:\\' field, which will be available as input for the next step.\\nIn the end you have to return a final answer using the `final_answer` tool.\\n\\nHere are a few examples using notional tools:\\n---\\nTask: \"Generate an image of the oldest person in this document.\"\\n\\nThought: I will proceed step by step and use the following tools: `document_qa` to find the oldest person in the document, then `image_generator` to generate an image according to the answer.\\nCode:\\n```py\\nanswer = document_qa(document=document, question=\"Who is the oldest person mentioned?\")\\nprint(answer)\\n```<end_action>\\nObservation: \"The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.\"\\n\\nThought: I will now generate an image showcasing the oldest person.\\nCode:\\n```py\\nimage = image_generator(\"A portrait of John Doe, a 55-year-old man living in Canada.\")\\nfinal_answer(image)\\n```<end_action>\\n\\n---\\nTask: \"What is the result of the following operation: 5 + 3 + 1294.678?\"\\n\\nThought: I will use python code to compute the result of the operation and then return the final answer using the `final_answer` tool\\nCode:\\n```py\\nresult = 5 + 3 + 1294.678\\nfinal_answer(result)\\n```<end_action>\\n\\n---\\nTask: \"Which city has the highest population: Guangzhou or Shanghai?\"\\n\\nThought: I need to get the populations for both cities and compare them: I will use the tool `search` to get the population of both cities.\\nCode:\\n```py\\npopulation_guangzhou = search(\"Guangzhou population\")\\nprint(\"Population Guangzhou:\", population_guangzhou)\\npopulation_shanghai = search(\"Shanghai population\")\\nprint(\"Population Shanghai:\", population_shanghai)\\n```<end_action>\\nObservation:\\nPopulation Guangzhou: [\\'Guangzhou has a population of 15 million inhabitants as of 2021.\\']\\nPopulation Shanghai: \\'26 million (2019)\\'\\n\\nThought: Now I know that Shanghai has the highest population.\\nCode:\\n```py\\nfinal_answer(\"Shanghai\")\\n```<end_action>\\n\\n---\\nTask: \"What is the current age of the pope, raised to the power 0.36?\"\\n\\nThought: I will use the tool `wiki` to get the age of the pope, then raise it to the power 0.36.\\nCode:\\n```py\\npope_age = wiki(query=\"current pope age\")\\nprint(\"Pope age:\", pope_age)\\n```<end_action>\\nObservation:\\nPope age: \"The pope Francis is currently 85 years old.\"\\n\\nThought: I know that the pope is 85 years old. Let\\'s compute the result using python code.\\nCode:\\n```py\\npope_current_age = 85 ** 0.36\\nfinal_answer(pope_current_age)\\n```<end_action>\\n\\nAbove example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you have acces to those tools (and no other tool):\\n\\n<<tool_descriptions>>\\n\\n<<managed_agents_descriptions>>\\n\\nHere are the rules you should always follow to solve your task:\\n1. Always provide a \\'Thought:\\' sequence, and a \\'Code:\\n```py\\' sequence ending with \\'```<end_action>\\' sequence, else you will fail.\\n2. Use only variables that you have defined!\\n3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in \\'answer = wiki({\\'query\\': \"What is the place where James Bond lives?\"})\\', but use the arguments directly as in \\'answer = wiki(query=\"What is the place where James Bond lives?\")\\'.\\n4. Take care to not chain too many sequential tool calls in the same code block, especially when the output format is unpredictable. For instance, a call to search has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.\\n5. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.\\n6. Don\\'t name any new variable with the same name as a tool: for instance don\\'t name a variable \\'final_answer\\'.\\n7. Never create any notional variables in our code, as having these in your logs might derail you from the true variables.\\n8. You can use imports in your code, but only from the following list of modules: <<authorized_imports>>\\n9. The state persists between code executions: so if in one step you\\'ve created variables or imported modules, these will all persist.\\n10. Don\\'t give up! You\\'re in charge of solving the task, not providing directions to solve it.\\n\\nNow Begin! If you solve the task correctly, you will receive a reward of $1,000,000.\\n'"},{name:"tool_description_template",val:": str = '\\n- {{ tool.name }}: {{ tool.description }}\\n    Takes inputs: {{tool.inputs}}\\n'"},{name:"grammar",val:": Dict = None"},{name:"additional_authorized_imports",val:": Optional = None"},{name:"planning_interval",val:": Optional = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L1041"}}),pt=new $({props:{name:"step",anchor:"transformers.ReactCodeAgent.step",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L1082"}}),ct=new M({props:{title:"ManagedAgent",local:"transformers.ManagedAgent",headingTag:"h3"}}),ht=new $({props:{name:"class transformers.ManagedAgent",anchor:"transformers.ManagedAgent",parameters:[{name:"agent",val:""},{name:"name",val:""},{name:"description",val:""},{name:"additional_prompting",val:" = None"},{name:"provide_run_summary",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L1168"}}),ut=new M({props:{title:"Tools",local:"tools",headingTag:"h2"}}),ft=new M({props:{title:"load_tool",local:"transformers.load_tool",headingTag:"h3"}}),bt=new $({props:{name:"transformers.load_tool",anchor:"transformers.load_tool",parameters:[{name:"task_or_repo_id",val:""},{name:"model_repo_id",val:" = None"},{name:"token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.load_tool.task_or_repo_id",description:`<strong>task_or_repo_id</strong> (<code>str</code>) &#x2014;
The task for which to load the tool or a repo ID of a tool on the Hub. Tasks implemented in Transformers
are:</p>
<ul>
<li><code>&quot;document_question_answering&quot;</code></li>
<li><code>&quot;image_question_answering&quot;</code></li>
<li><code>&quot;speech_to_text&quot;</code></li>
<li><code>&quot;text_to_speech&quot;</code></li>
<li><code>&quot;translation&quot;</code></li>
</ul>`,name:"task_or_repo_id"},{anchor:"transformers.load_tool.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use this argument to use a different model than the default one for the tool you selected.`,name:"model_repo_id"},{anchor:"transformers.load_tool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.load_tool.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the others
will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L657"}}),fe=new Ks({props:{warning:!0,$$slots:{default:[Ti]},$$scope:{ctx:L}}}),vt=new M({props:{title:"Tool",local:"transformers.Tool",headingTag:"h3"}}),_t=new $({props:{name:"class transformers.Tool",anchor:"transformers.Tool",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L87"}}),$t=new $({props:{name:"from_gradio",anchor:"transformers.Tool.from_gradio",parameters:[{name:"gradio_tool",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L373"}}),yt=new $({props:{name:"from_hub",anchor:"transformers.Tool.from_hub",parameters:[{name:"repo_id",val:": str"},{name:"model_repo_id",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Tool.from_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repo on the Hub where your tool is defined.`,name:"repo_id"},{anchor:"transformers.Tool.from_hub.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If your tool uses a model and you want to use a different model than the default, you can pass a second
repo ID or an endpoint url to this argument.`,name:"model_repo_id"},{anchor:"transformers.Tool.from_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.from_hub.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the
others will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L204"}}),ve=new Ks({props:{warning:!0,$$slots:{default:[xi]},$$scope:{ctx:L}}}),wt=new $({props:{name:"from_langchain",anchor:"transformers.Tool.from_langchain",parameters:[{name:"langchain_tool",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L395"}}),Tt=new $({props:{name:"push_to_hub",anchor:"transformers.Tool.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": str = 'Upload tool'"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"create_pr",val:": bool = False"}],parametersDescription:[{anchor:"transformers.Tool.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your tool to. It should contain your organization name when
pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.Tool.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;Upload tool&quot;</code>) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"transformers.Tool.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.Tool.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L316"}}),$e=new pr({props:{anchor:"transformers.Tool.push_to_hub.example",$$slots:{default:[ki]},$$scope:{ctx:L}}}),xt=new $({props:{name:"save",anchor:"transformers.Tool.save",parameters:[{name:"output_dir",val:""}],parametersDescription:[{anchor:"transformers.Tool.save.output_dir",description:"<strong>output_dir</strong> (<code>str</code>) &#x2014; The folder in which you want to save your tool.",name:"output_dir"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L144"}}),kt=new $({props:{name:"setup",anchor:"transformers.Tool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L137"}}),Ct=new M({props:{title:"Toolbox",local:"transformers.Toolbox",headingTag:"h3"}}),Mt=new $({props:{name:"class transformers.Toolbox",anchor:"transformers.Toolbox",parameters:[{name:"tools",val:": List"},{name:"add_base_tools",val:": bool = False"}],parametersDescription:[{anchor:"transformers.Toolbox.tools",description:`<strong>tools</strong> (<code>List[Tool]</code>) &#x2014;
The list of tools to instantiate the toolbox with`,name:"tools"},{anchor:"transformers.Toolbox.add_base_tools",description:`<strong>add_base_tools</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add the tools available within <code>transformers</code> to the toolbox.`,name:"add_base_tools"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L182"}}),It=new $({props:{name:"add_tool",anchor:"transformers.Toolbox.add_tool",parameters:[{name:"tool",val:": Tool"}],parametersDescription:[{anchor:"transformers.Toolbox.add_tool.tool",description:`<strong>tool</strong> (<code>Tool</code>) &#x2014;
The tool to add to the toolbox.`,name:"tool"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L228"}}),At=new $({props:{name:"clear_toolbox",anchor:"transformers.Toolbox.clear_toolbox",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L268"}}),jt=new $({props:{name:"remove_tool",anchor:"transformers.Toolbox.remove_tool",parameters:[{name:"tool_name",val:": str"}],parametersDescription:[{anchor:"transformers.Toolbox.remove_tool.tool_name",description:`<strong>tool_name</strong> (<code>str</code>) &#x2014;
The tool to remove from the toolbox.`,name:"tool_name"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L240"}}),qt=new $({props:{name:"show_tool_descriptions",anchor:"transformers.Toolbox.show_tool_descriptions",parameters:[{name:"tool_description_template",val:": str = None"}],parametersDescription:[{anchor:"transformers.Toolbox.show_tool_descriptions.tool_description_template",description:`<strong>tool_description_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The template to use to describe the tools. If not provided, the default template will be used.`,name:"tool_description_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L216"}}),Lt=new $({props:{name:"update_tool",anchor:"transformers.Toolbox.update_tool",parameters:[{name:"tool",val:": Tool"}],parametersDescription:[{anchor:"transformers.Toolbox.update_tool.tool",description:`<strong>tool</strong> (<code>Tool</code>) &#x2014;
The tool to update to the toolbox.`,name:"tool"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agents.py#L254"}}),Pt=new M({props:{title:"PipelineTool",local:"transformers.PipelineTool",headingTag:"h3"}}),Jt=new $({props:{name:"class transformers.PipelineTool",anchor:"transformers.PipelineTool",parameters:[{name:"model",val:" = None"},{name:"pre_processor",val:" = None"},{name:"post_processor",val:" = None"},{name:"device",val:" = None"},{name:"device_map",val:" = None"},{name:"model_kwargs",val:" = None"},{name:"token",val:" = None"},{name:"**hub_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PipelineTool.model",description:`<strong>model</strong> (<code>str</code> or <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the model, or the instantiated model. If unset, will default to the
value of the class attribute <code>default_checkpoint</code>.`,name:"model"},{anchor:"transformers.PipelineTool.pre_processor",description:`<strong>pre_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the pre-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the value of <code>model</code> if
unset.`,name:"pre_processor"},{anchor:"transformers.PipelineTool.post_processor",description:`<strong>post_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the post-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the <code>pre_processor</code> if
unset.`,name:"post_processor"},{anchor:"transformers.PipelineTool.device",description:`<strong>device</strong> (<code>int</code>, <code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which to execute the model. Will default to any accelerator available (GPU, MPS etc&#x2026;), the
CPU otherwise.`,name:"device"},{anchor:"transformers.PipelineTool.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>dict</code>, <em>optional</em>) &#x2014;
If passed along, will be used to instantiate the model.`,name:"device_map"},{anchor:"transformers.PipelineTool.model_kwargs",description:`<strong>model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Any keyword argument to send to the model instantiation.`,name:"model_kwargs"},{anchor:"transformers.PipelineTool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.PipelineTool.hub_kwargs",description:`<strong>hub_kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any additional keyword argument to send to the methods that will load the data from the Hub.`,name:"hub_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L455"}}),Et=new $({props:{name:"decode",anchor:"transformers.PipelineTool.decode",parameters:[{name:"outputs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L578"}}),Ut=new $({props:{name:"encode",anchor:"transformers.PipelineTool.encode",parameters:[{name:"raw_inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L565"}}),Nt=new $({props:{name:"forward",anchor:"transformers.PipelineTool.forward",parameters:[{name:"inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L571"}}),Ht=new $({props:{name:"setup",anchor:"transformers.PipelineTool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L539"}}),Dt=new M({props:{title:"launch_gradio_demo",local:"transformers.launch_gradio_demo",headingTag:"h3"}}),Wt=new $({props:{name:"transformers.launch_gradio_demo",anchor:"transformers.launch_gradio_demo",parameters:[{name:"tool_class",val:": Tool"}],parametersDescription:[{anchor:"transformers.launch_gradio_demo.tool_class",description:"<strong>tool_class</strong> (<code>type</code>) &#x2014; The class of the tool for which to launch the demo.",name:"tool_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L603"}}),Rt=new M({props:{title:"stream_to_gradio",local:"transformers.stream_to_gradio",headingTag:"h3"}}),Vt=new $({props:{name:"transformers.stream_to_gradio",anchor:"transformers.stream_to_gradio",parameters:[{name:"agent",val:": ReactAgent"},{name:"task",val:": str"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/monitoring.py#L49"}}),Bt=new M({props:{title:"ToolCollection",local:"transformers.ToolCollection",headingTag:"h3"}}),zt=new $({props:{name:"class transformers.ToolCollection",anchor:"transformers.ToolCollection",parameters:[{name:"collection_slug",val:": str"},{name:"token",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ToolCollection.collection_slug",description:`<strong>collection_slug</strong> (str) &#x2014;
The collection slug referencing the collection.`,name:"collection_slug"},{anchor:"transformers.ToolCollection.token",description:`<strong>token</strong> (str, <em>optional</em>) &#x2014;
The authentication token if the collection is private.`,name:"token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/tools.py#L781"}}),qe=new pr({props:{anchor:"transformers.ToolCollection.example",$$slots:{default:[Ci]},$$scope:{ctx:L}}}),Zt=new M({props:{title:"Engines",local:"engines",headingTag:"h2"}}),Ot=new M({props:{title:"TransformersEngine",local:"transformers.TransformersEngine",headingTag:"h3"}}),Yt=new Eo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHBpcGVsaW5lJTJDJTIwVHJhbnNmb3JtZXJzRW5naW5lJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0tMTM1TS1JbnN0cnVjdCUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMEFlbmdpbmUlMjAlM0QlMjBUcmFuc2Zvcm1lcnNFbmdpbmUocGlwZSklMEFlbmdpbmUoJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyT2shJTIyJTdEJTVEJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlMjJncmVhdCUyMiU1RCklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, pipeline, TransformersEngine

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>engine = TransformersEngine(pipe)
<span class="hljs-meta">&gt;&gt;&gt; </span>engine([{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Ok!&quot;</span>}], stop_sequences=[<span class="hljs-string">&quot;great&quot;</span>])

<span class="hljs-string">&quot;What a &quot;</span>`,wrap:!1}}),Qt=new $({props:{name:"class transformers.TransformersEngine",anchor:"transformers.TransformersEngine",parameters:[{name:"pipeline",val:": Pipeline"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/llm_engine.py#L100"}}),Xt=new M({props:{title:"HfApiEngine",local:"transformers.HfApiEngine",headingTag:"h3"}}),en=new Eo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQXBpRW5naW5lJTBBJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTm8lMjBuZWVkJTIwdG8lMjBoZWxwJTJDJTIwdGFrZSUyMGl0JTIwZWFzeS4lMjIlN0QlMkMlMEElNUQlMEElMEFIZkFwaUVuZ2luZSgpKG1lc3NhZ2VzJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlMjJjb252ZXJzYXRpb24lMjIlNUQpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfApiEngine

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;No need to help, take it easy.&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApiEngine()(messages, stop_sequences=[<span class="hljs-string">&quot;conversation&quot;</span>])

<span class="hljs-string">&quot;That&#x27;s very kind of you to say! It&#x27;s always nice to have a relaxed &quot;</span>`,wrap:!1}}),tn=new $({props:{name:"class transformers.HfApiEngine",anchor:"transformers.HfApiEngine",parameters:[{name:"model",val:": str = 'meta-llama/Meta-Llama-3.1-8B-Instruct'"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/llm_engine.py#L70"}}),nn=new M({props:{title:"Agent Types",local:"agent-types",headingTag:"h2"}}),ln=new M({props:{title:"AgentText",local:"transformers.agents.agent_types.AgentText",headingTag:"h3"}}),mn=new $({props:{name:"class transformers.agents.agent_types.AgentText",anchor:"transformers.agents.agent_types.AgentText",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L73"}}),dn=new M({props:{title:"AgentImage",local:"transformers.agents.agent_types.AgentImage",headingTag:"h3"}}),pn=new $({props:{name:"class transformers.agents.agent_types.AgentImage",anchor:"transformers.agents.agent_types.AgentImage",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L85"}}),cn=new $({props:{name:"save",anchor:"transformers.agents.agent_types.AgentImage.save",parameters:[{name:"output_bytes",val:""},{name:"format",val:""},{name:"**params",val:""}],parametersDescription:[{anchor:"transformers.agents.agent_types.AgentImage.save.output_bytes",description:"<strong>output_bytes</strong> (bytes) &#x2014; The output bytes to save the image to.",name:"output_bytes"},{anchor:"transformers.agents.agent_types.AgentImage.save.format",description:`<strong>format</strong> (str) &#x2014; The format to use for the output image. The format is the same as in PIL.Image.save.
**params &#x2014; Additional parameters to pass to PIL.Image.save.`,name:"format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L162"}}),gn=new $({props:{name:"to_raw",anchor:"transformers.agents.agent_types.AgentImage.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L120"}}),hn=new $({props:{name:"to_string",anchor:"transformers.agents.agent_types.AgentImage.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L135"}}),un=new M({props:{title:"AgentAudio",local:"transformers.agents.agent_types.AgentAudio",headingTag:"h3"}}),fn=new $({props:{name:"class transformers.agents.agent_types.AgentAudio",anchor:"transformers.agents.agent_types.AgentAudio",parameters:[{name:"value",val:""},{name:"samplerate",val:" = 16000"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L174"}}),bn=new $({props:{name:"to_raw",anchor:"transformers.agents.agent_types.AgentAudio.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L210"}}),vn=new $({props:{name:"to_string",anchor:"transformers.agents.agent_types.AgentAudio.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/agents/agent_types.py#L222"}}),_n=new _i({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/main_classes/agent.md"}}),{c(){f=s("meta"),x=n(),y=s("p"),w=n(),m(T.$$.fragment),b=n(),m(C.$$.fragment),No=n(),Re=s("p"),Re.innerHTML=el,Ho=n(),m(Ve.$$.fragment),Do=n(),Be=s("p"),Be.innerHTML=tl,Wo=n(),ze=s("ul"),ze.innerHTML=nl,Ro=n(),m(Ze.$$.fragment),Vo=n(),P=s("div"),m(Se.$$.fragment),cr=n(),oe=s("div"),m(Ge.$$.fragment),gr=n(),Cn=s("p"),Cn.textContent=ol,hr=n(),ae=s("div"),m(Oe.$$.fragment),ur=n(),Mn=s("p"),Mn.textContent=al,fr=n(),re=s("div"),m(Fe.$$.fragment),br=n(),In=s("p"),In.textContent=rl,vr=n(),se=s("div"),m(Ye.$$.fragment),_r=n(),An=s("p"),An.textContent=sl,Bo=n(),m(Qe.$$.fragment),zo=n(),H=s("div"),m(Xe.$$.fragment),$r=n(),jn=s("p"),jn.textContent=ll,yr=n(),le=s("div"),m(Ke.$$.fragment),wr=n(),qn=s("p"),qn.innerHTML=il,Tr=n(),O=s("div"),m(et.$$.fragment),xr=n(),Ln=s("p"),Ln.textContent=ml,kr=n(),m(ie.$$.fragment),Zo=n(),m(tt.$$.fragment),So=n(),A=s("div"),m(nt.$$.fragment),Cr=n(),Pn=s("p"),Pn.textContent=dl,Mr=n(),me=s("div"),m(ot.$$.fragment),Ir=n(),Jn=s("p"),Jn.innerHTML=pl,Ar=n(),de=s("div"),m(at.$$.fragment),jr=n(),En=s("p"),En.textContent=cl,qr=n(),pe=s("div"),m(rt.$$.fragment),Lr=n(),Un=s("p"),Un.textContent=gl,Pr=n(),F=s("div"),m(st.$$.fragment),Jr=n(),Nn=s("p"),Nn.textContent=hl,Er=n(),m(ce.$$.fragment),Ur=n(),ge=s("div"),m(lt.$$.fragment),Nr=n(),Hn=s("p"),Hn.innerHTML=ul,Go=n(),z=s("div"),m(it.$$.fragment),Hr=n(),Dn=s("p"),Dn.textContent=fl,Dr=n(),he=s("div"),m(mt.$$.fragment),Wr=n(),Wn=s("p"),Wn.textContent=bl,Oo=n(),Z=s("div"),m(dt.$$.fragment),Rr=n(),Rn=s("p"),Rn.textContent=vl,Vr=n(),ue=s("div"),m(pt.$$.fragment),Br=n(),Vn=s("p"),Vn.textContent=_l,Fo=n(),m(ct.$$.fragment),Yo=n(),gt=s("div"),m(ht.$$.fragment),Qo=n(),m(ut.$$.fragment),Xo=n(),m(ft.$$.fragment),Ko=n(),S=s("div"),m(bt.$$.fragment),zr=n(),Bn=s("p"),Bn.textContent=$l,Zr=n(),m(fe.$$.fragment),ea=n(),m(vt.$$.fragment),ta=n(),k=s("div"),m(_t.$$.fragment),Sr=n(),zn=s("p"),zn.innerHTML=yl,Gr=n(),Zn=s("ul"),Zn.innerHTML=wl,Or=n(),Sn=s("p"),Sn.innerHTML=Tl,Fr=n(),be=s("div"),m($t.$$.fragment),Yr=n(),Gn=s("p"),Gn.innerHTML=xl,Qr=n(),Y=s("div"),m(yt.$$.fragment),Xr=n(),On=s("p"),On.textContent=kl,Kr=n(),m(ve.$$.fragment),es=n(),_e=s("div"),m(wt.$$.fragment),ts=n(),Fn=s("p"),Fn.innerHTML=Cl,ns=n(),V=s("div"),m(Tt.$$.fragment),os=n(),Yn=s("p"),Yn.textContent=Ml,as=n(),Qn=s("p"),Qn.innerHTML=Il,rs=n(),m($e.$$.fragment),ss=n(),B=s("div"),m(xt.$$.fragment),ls=n(),Xn=s("p"),Xn.innerHTML=Al,is=n(),Kn=s("ul"),Kn.innerHTML=jl,ms=n(),eo=s("p"),eo.innerHTML=ql,ds=n(),ye=s("div"),m(kt.$$.fragment),ps=n(),to=s("p"),to.textContent=Ll,na=n(),m(Ct.$$.fragment),oa=n(),j=s("div"),m(Mt.$$.fragment),cs=n(),no=s("p"),no.textContent=Pl,gs=n(),we=s("div"),m(It.$$.fragment),hs=n(),oo=s("p"),oo.textContent=Jl,us=n(),Te=s("div"),m(At.$$.fragment),fs=n(),ao=s("p"),ao.textContent=El,bs=n(),xe=s("div"),m(jt.$$.fragment),vs=n(),ro=s("p"),ro.textContent=Ul,_s=n(),ke=s("div"),m(qt.$$.fragment),$s=n(),so=s("p"),so.textContent=Nl,ys=n(),Ce=s("div"),m(Lt.$$.fragment),ws=n(),lo=s("p"),lo.textContent=Hl,aa=n(),m(Pt.$$.fragment),ra=n(),q=s("div"),m(Jt.$$.fragment),Ts=n(),io=s("p"),io.innerHTML=Dl,xs=n(),mo=s("ul"),mo.innerHTML=Wl,ks=n(),Me=s("div"),m(Et.$$.fragment),Cs=n(),po=s("p"),po.innerHTML=Rl,Ms=n(),Ie=s("div"),m(Ut.$$.fragment),Is=n(),co=s("p"),co.innerHTML=Vl,As=n(),Ae=s("div"),m(Nt.$$.fragment),js=n(),go=s("p"),go.innerHTML=Bl,qs=n(),je=s("div"),m(Ht.$$.fragment),Ls=n(),ho=s("p"),ho.innerHTML=zl,sa=n(),m(Dt.$$.fragment),la=n(),X=s("div"),m(Wt.$$.fragment),Ps=n(),uo=s("p"),uo.innerHTML=Zl,ia=n(),m(Rt.$$.fragment),ma=n(),K=s("div"),m(Vt.$$.fragment),Js=n(),fo=s("p"),fo.textContent=Sl,da=n(),m(Bt.$$.fragment),pa=n(),D=s("div"),m(zt.$$.fragment),Es=n(),bo=s("p"),bo.textContent=Gl,Us=n(),vo=s("blockquote"),vo.innerHTML=Ol,Ns=n(),m(qe.$$.fragment),ca=n(),m(Zt.$$.fragment),ga=n(),St=s("p"),St.textContent=Fl,ha=n(),Gt=s("ol"),Gt.innerHTML=Yl,ua=n(),m(Ot.$$.fragment),fa=n(),Ft=s("p"),Ft.innerHTML=Ql,ba=n(),m(Yt.$$.fragment),va=n(),ee=s("div"),m(Qt.$$.fragment),Hs=n(),_o=s("p"),_o.textContent=Xl,_a=n(),m(Xt.$$.fragment),$a=n(),Kt=s("p"),Kt.innerHTML=Kl,ya=n(),m(en.$$.fragment),wa=n(),te=s("div"),m(tn.$$.fragment),Ds=n(),$o=s("p"),$o.textContent=ei,Ta=n(),m(nn.$$.fragment),xa=n(),on=s("p"),on.textContent=ti,ka=n(),an=s("p"),an.innerHTML=ni,Ca=n(),rn=s("p"),rn.textContent=oi,Ma=n(),sn=s("ul"),sn.innerHTML=ai,Ia=n(),m(ln.$$.fragment),Aa=n(),ne=s("div"),m(mn.$$.fragment),Ws=n(),yo=s("p"),yo.textContent=ri,ja=n(),m(dn.$$.fragment),qa=n(),J=s("div"),m(pn.$$.fragment),Rs=n(),wo=s("p"),wo.textContent=si,Vs=n(),Le=s("div"),m(cn.$$.fragment),Bs=n(),To=s("p"),To.textContent=li,zs=n(),Pe=s("div"),m(gn.$$.fragment),Zs=n(),xo=s("p"),xo.textContent=ii,Ss=n(),Je=s("div"),m(hn.$$.fragment),Gs=n(),ko=s("p"),ko.textContent=mi,La=n(),m(un.$$.fragment),Pa=n(),W=s("div"),m(fn.$$.fragment),Os=n(),Co=s("p"),Co.textContent=di,Fs=n(),Ee=s("div"),m(bn.$$.fragment),Ys=n(),Mo=s("p"),Mo.innerHTML=pi,Qs=n(),Ue=s("div"),m(vn.$$.fragment),Xs=n(),Io=s("p"),Io.textContent=ci,Ja=n(),m(_n.$$.fragment),Ea=n(),Uo=s("p"),this.h()},l(e){const r=vi("svelte-u9bgzb",document.head);f=l(r,"META",{name:!0,content:!0}),r.forEach(a),x=o(e),y=l(e,"P",{}),v(y).forEach(a),w=o(e),d(T.$$.fragment,e),b=o(e),d(C.$$.fragment,e),No=o(e),Re=l(e,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-7mj07q"&&(Re.innerHTML=el),Ho=o(e),d(Ve.$$.fragment,e),Do=o(e),Be=l(e,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-n8fmrj"&&(Be.innerHTML=tl),Wo=o(e),ze=l(e,"UL",{"data-svelte-h":!0}),u(ze)!=="svelte-kxuq94"&&(ze.innerHTML=nl),Ro=o(e),d(Ze.$$.fragment,e),Vo=o(e),P=l(e,"DIV",{class:!0});var R=v(P);d(Se.$$.fragment,R),cr=o(R),oe=l(R,"DIV",{class:!0});var $n=v(oe);d(Ge.$$.fragment,$n),gr=o($n),Cn=l($n,"P",{"data-svelte-h":!0}),u(Cn)!=="svelte-a91m64"&&(Cn.textContent=ol),$n.forEach(a),hr=o(R),ae=l(R,"DIV",{class:!0});var yn=v(ae);d(Oe.$$.fragment,yn),ur=o(yn),Mn=l(yn,"P",{"data-svelte-h":!0}),u(Mn)!=="svelte-104knry"&&(Mn.textContent=al),yn.forEach(a),fr=o(R),re=l(R,"DIV",{class:!0});var wn=v(re);d(Fe.$$.fragment,wn),br=o(wn),In=l(wn,"P",{"data-svelte-h":!0}),u(In)!=="svelte-wvvftk"&&(In.textContent=rl),wn.forEach(a),vr=o(R),se=l(R,"DIV",{class:!0});var Tn=v(se);d(Ye.$$.fragment,Tn),_r=o(Tn),An=l(Tn,"P",{"data-svelte-h":!0}),u(An)!=="svelte-1cw6633"&&(An.textContent=sl),Tn.forEach(a),R.forEach(a),Bo=o(e),d(Qe.$$.fragment,e),zo=o(e),H=l(e,"DIV",{class:!0});var G=v(H);d(Xe.$$.fragment,G),$r=o(G),jn=l(G,"P",{"data-svelte-h":!0}),u(jn)!=="svelte-rq8zg0"&&(jn.textContent=ll),yr=o(G),le=l(G,"DIV",{class:!0});var xn=v(le);d(Ke.$$.fragment,xn),wr=o(xn),qn=l(xn,"P",{"data-svelte-h":!0}),u(qn)!=="svelte-tvi94l"&&(qn.innerHTML=il),xn.forEach(a),Tr=o(G),O=l(G,"DIV",{class:!0});var Ao=v(O);d(et.$$.fragment,Ao),xr=o(Ao),Ln=l(Ao,"P",{"data-svelte-h":!0}),u(Ln)!=="svelte-tbr5ck"&&(Ln.textContent=ml),kr=o(Ao),d(ie.$$.fragment,Ao),Ao.forEach(a),G.forEach(a),Zo=o(e),d(tt.$$.fragment,e),So=o(e),A=l(e,"DIV",{class:!0});var E=v(A);d(nt.$$.fragment,E),Cr=o(E),Pn=l(E,"P",{"data-svelte-h":!0}),u(Pn)!=="svelte-c95fji"&&(Pn.textContent=dl),Mr=o(E),me=l(E,"DIV",{class:!0});var Na=v(me);d(ot.$$.fragment,Na),Ir=o(Na),Jn=l(Na,"P",{"data-svelte-h":!0}),u(Jn)!=="svelte-17ywxxr"&&(Jn.innerHTML=pl),Na.forEach(a),Ar=o(E),de=l(E,"DIV",{class:!0});var Ha=v(de);d(at.$$.fragment,Ha),jr=o(Ha),En=l(Ha,"P",{"data-svelte-h":!0}),u(En)!=="svelte-e54ku6"&&(En.textContent=cl),Ha.forEach(a),qr=o(E),pe=l(E,"DIV",{class:!0});var Da=v(pe);d(rt.$$.fragment,Da),Lr=o(Da),Un=l(Da,"P",{"data-svelte-h":!0}),u(Un)!=="svelte-1ii4mb"&&(Un.textContent=gl),Da.forEach(a),Pr=o(E),F=l(E,"DIV",{class:!0});var jo=v(F);d(st.$$.fragment,jo),Jr=o(jo),Nn=l(jo,"P",{"data-svelte-h":!0}),u(Nn)!=="svelte-tbr5ck"&&(Nn.textContent=hl),Er=o(jo),d(ce.$$.fragment,jo),jo.forEach(a),Ur=o(E),ge=l(E,"DIV",{class:!0});var Wa=v(ge);d(lt.$$.fragment,Wa),Nr=o(Wa),Hn=l(Wa,"P",{"data-svelte-h":!0}),u(Hn)!=="svelte-nf9see"&&(Hn.innerHTML=ul),Wa.forEach(a),E.forEach(a),Go=o(e),z=l(e,"DIV",{class:!0});var qo=v(z);d(it.$$.fragment,qo),Hr=o(qo),Dn=l(qo,"P",{"data-svelte-h":!0}),u(Dn)!=="svelte-1ip7q5f"&&(Dn.textContent=fl),Dr=o(qo),he=l(qo,"DIV",{class:!0});var Ra=v(he);d(mt.$$.fragment,Ra),Wr=o(Ra),Wn=l(Ra,"P",{"data-svelte-h":!0}),u(Wn)!=="svelte-1bbx2c8"&&(Wn.textContent=bl),Ra.forEach(a),qo.forEach(a),Oo=o(e),Z=l(e,"DIV",{class:!0});var Lo=v(Z);d(dt.$$.fragment,Lo),Rr=o(Lo),Rn=l(Lo,"P",{"data-svelte-h":!0}),u(Rn)!=="svelte-1egm30q"&&(Rn.textContent=vl),Vr=o(Lo),ue=l(Lo,"DIV",{class:!0});var Va=v(ue);d(pt.$$.fragment,Va),Br=o(Va),Vn=l(Va,"P",{"data-svelte-h":!0}),u(Vn)!=="svelte-1bbx2c8"&&(Vn.textContent=_l),Va.forEach(a),Lo.forEach(a),Fo=o(e),d(ct.$$.fragment,e),Yo=o(e),gt=l(e,"DIV",{class:!0});var gi=v(gt);d(ht.$$.fragment,gi),gi.forEach(a),Qo=o(e),d(ut.$$.fragment,e),Xo=o(e),d(ft.$$.fragment,e),Ko=o(e),S=l(e,"DIV",{class:!0});var Po=v(S);d(bt.$$.fragment,Po),zr=o(Po),Bn=l(Po,"P",{"data-svelte-h":!0}),u(Bn)!=="svelte-16uh3p8"&&(Bn.textContent=$l),Zr=o(Po),d(fe.$$.fragment,Po),Po.forEach(a),ea=o(e),d(vt.$$.fragment,e),ta=o(e),k=l(e,"DIV",{class:!0});var I=v(k);d(_t.$$.fragment,I),Sr=o(I),zn=l(I,"P",{"data-svelte-h":!0}),u(zn)!=="svelte-cca4c5"&&(zn.innerHTML=yl),Gr=o(I),Zn=l(I,"UL",{"data-svelte-h":!0}),u(Zn)!=="svelte-1cvtzkm"&&(Zn.innerHTML=wl),Or=o(I),Sn=l(I,"P",{"data-svelte-h":!0}),u(Sn)!=="svelte-10s049q"&&(Sn.innerHTML=Tl),Fr=o(I),be=l(I,"DIV",{class:!0});var Ba=v(be);d($t.$$.fragment,Ba),Yr=o(Ba),Gn=l(Ba,"P",{"data-svelte-h":!0}),u(Gn)!=="svelte-548oc7"&&(Gn.innerHTML=xl),Ba.forEach(a),Qr=o(I),Y=l(I,"DIV",{class:!0});var Jo=v(Y);d(yt.$$.fragment,Jo),Xr=o(Jo),On=l(Jo,"P",{"data-svelte-h":!0}),u(On)!=="svelte-yy7b2c"&&(On.textContent=kl),Kr=o(Jo),d(ve.$$.fragment,Jo),Jo.forEach(a),es=o(I),_e=l(I,"DIV",{class:!0});var za=v(_e);d(wt.$$.fragment,za),ts=o(za),Fn=l(za,"P",{"data-svelte-h":!0}),u(Fn)!=="svelte-umcuss"&&(Fn.innerHTML=Cl),za.forEach(a),ns=o(I),V=l(I,"DIV",{class:!0});var Ne=v(V);d(Tt.$$.fragment,Ne),os=o(Ne),Yn=l(Ne,"P",{"data-svelte-h":!0}),u(Yn)!=="svelte-1u3gku9"&&(Yn.textContent=Ml),as=o(Ne),Qn=l(Ne,"P",{"data-svelte-h":!0}),u(Qn)!=="svelte-1yeagwn"&&(Qn.innerHTML=Il),rs=o(Ne),d($e.$$.fragment,Ne),Ne.forEach(a),ss=o(I),B=l(I,"DIV",{class:!0});var He=v(B);d(xt.$$.fragment,He),ls=o(He),Xn=l(He,"P",{"data-svelte-h":!0}),u(Xn)!=="svelte-19evuwa"&&(Xn.innerHTML=Al),is=o(He),Kn=l(He,"UL",{"data-svelte-h":!0}),u(Kn)!=="svelte-15of9ze"&&(Kn.innerHTML=jl),ms=o(He),eo=l(He,"P",{"data-svelte-h":!0}),u(eo)!=="svelte-msa4ge"&&(eo.innerHTML=ql),He.forEach(a),ds=o(I),ye=l(I,"DIV",{class:!0});var Za=v(ye);d(kt.$$.fragment,Za),ps=o(Za),to=l(Za,"P",{"data-svelte-h":!0}),u(to)!=="svelte-63kthh"&&(to.textContent=Ll),Za.forEach(a),I.forEach(a),na=o(e),d(Ct.$$.fragment,e),oa=o(e),j=l(e,"DIV",{class:!0});var U=v(j);d(Mt.$$.fragment,U),cs=o(U),no=l(U,"P",{"data-svelte-h":!0}),u(no)!=="svelte-1jgzyq0"&&(no.textContent=Pl),gs=o(U),we=l(U,"DIV",{class:!0});var Sa=v(we);d(It.$$.fragment,Sa),hs=o(Sa),oo=l(Sa,"P",{"data-svelte-h":!0}),u(oo)!=="svelte-g8q0nk"&&(oo.textContent=Jl),Sa.forEach(a),us=o(U),Te=l(U,"DIV",{class:!0});var Ga=v(Te);d(At.$$.fragment,Ga),fs=o(Ga),ao=l(Ga,"P",{"data-svelte-h":!0}),u(ao)!=="svelte-1l2znf2"&&(ao.textContent=El),Ga.forEach(a),bs=o(U),xe=l(U,"DIV",{class:!0});var Oa=v(xe);d(jt.$$.fragment,Oa),vs=o(Oa),ro=l(Oa,"P",{"data-svelte-h":!0}),u(ro)!=="svelte-165lhg0"&&(ro.textContent=Ul),Oa.forEach(a),_s=o(U),ke=l(U,"DIV",{class:!0});var Fa=v(ke);d(qt.$$.fragment,Fa),$s=o(Fa),so=l(Fa,"P",{"data-svelte-h":!0}),u(so)!=="svelte-15vkk0u"&&(so.textContent=Nl),Fa.forEach(a),ys=o(U),Ce=l(U,"DIV",{class:!0});var Ya=v(Ce);d(Lt.$$.fragment,Ya),ws=o(Ya),lo=l(Ya,"P",{"data-svelte-h":!0}),u(lo)!=="svelte-1p64qrs"&&(lo.textContent=Hl),Ya.forEach(a),U.forEach(a),aa=o(e),d(Pt.$$.fragment,e),ra=o(e),q=l(e,"DIV",{class:!0});var N=v(q);d(Jt.$$.fragment,N),Ts=o(N),io=l(N,"P",{"data-svelte-h":!0}),u(io)!=="svelte-1tqfigx"&&(io.innerHTML=Dl),xs=o(N),mo=l(N,"UL",{"data-svelte-h":!0}),u(mo)!=="svelte-n6zm2g"&&(mo.innerHTML=Wl),ks=o(N),Me=l(N,"DIV",{class:!0});var Qa=v(Me);d(Et.$$.fragment,Qa),Cs=o(Qa),po=l(Qa,"P",{"data-svelte-h":!0}),u(po)!=="svelte-zkjq4t"&&(po.innerHTML=Rl),Qa.forEach(a),Ms=o(N),Ie=l(N,"DIV",{class:!0});var Xa=v(Ie);d(Ut.$$.fragment,Xa),Is=o(Xa),co=l(Xa,"P",{"data-svelte-h":!0}),u(co)!=="svelte-1vxzk80"&&(co.innerHTML=Vl),Xa.forEach(a),As=o(N),Ae=l(N,"DIV",{class:!0});var Ka=v(Ae);d(Nt.$$.fragment,Ka),js=o(Ka),go=l(Ka,"P",{"data-svelte-h":!0}),u(go)!=="svelte-1qgsi13"&&(go.innerHTML=Bl),Ka.forEach(a),qs=o(N),je=l(N,"DIV",{class:!0});var er=v(je);d(Ht.$$.fragment,er),Ls=o(er),ho=l(er,"P",{"data-svelte-h":!0}),u(ho)!=="svelte-1ojxz66"&&(ho.innerHTML=zl),er.forEach(a),N.forEach(a),sa=o(e),d(Dt.$$.fragment,e),la=o(e),X=l(e,"DIV",{class:!0});var tr=v(X);d(Wt.$$.fragment,tr),Ps=o(tr),uo=l(tr,"P",{"data-svelte-h":!0}),u(uo)!=="svelte-j4u4it"&&(uo.innerHTML=Zl),tr.forEach(a),ia=o(e),d(Rt.$$.fragment,e),ma=o(e),K=l(e,"DIV",{class:!0});var nr=v(K);d(Vt.$$.fragment,nr),Js=o(nr),fo=l(nr,"P",{"data-svelte-h":!0}),u(fo)!=="svelte-3yyclm"&&(fo.textContent=Sl),nr.forEach(a),da=o(e),d(Bt.$$.fragment,e),pa=o(e),D=l(e,"DIV",{class:!0});var De=v(D);d(zt.$$.fragment,De),Es=o(De),bo=l(De,"P",{"data-svelte-h":!0}),u(bo)!=="svelte-n5kqzu"&&(bo.textContent=Gl),Us=o(De),vo=l(De,"BLOCKQUOTE",{"data-svelte-h":!0}),u(vo)!=="svelte-1ezz2hf"&&(vo.innerHTML=Ol),Ns=o(De),d(qe.$$.fragment,De),De.forEach(a),ca=o(e),d(Zt.$$.fragment,e),ga=o(e),St=l(e,"P",{"data-svelte-h":!0}),u(St)!=="svelte-oor881"&&(St.textContent=Fl),ha=o(e),Gt=l(e,"OL",{"data-svelte-h":!0}),u(Gt)!=="svelte-1fvckr8"&&(Gt.innerHTML=Yl),ua=o(e),d(Ot.$$.fragment,e),fa=o(e),Ft=l(e,"P",{"data-svelte-h":!0}),u(Ft)!=="svelte-326rto"&&(Ft.innerHTML=Ql),ba=o(e),d(Yt.$$.fragment,e),va=o(e),ee=l(e,"DIV",{class:!0});var or=v(ee);d(Qt.$$.fragment,or),Hs=o(or),_o=l(or,"P",{"data-svelte-h":!0}),u(_o)!=="svelte-phvciw"&&(_o.textContent=Xl),or.forEach(a),_a=o(e),d(Xt.$$.fragment,e),$a=o(e),Kt=l(e,"P",{"data-svelte-h":!0}),u(Kt)!=="svelte-1korg3b"&&(Kt.innerHTML=Kl),ya=o(e),d(en.$$.fragment,e),wa=o(e),te=l(e,"DIV",{class:!0});var ar=v(te);d(tn.$$.fragment,ar),Ds=o(ar),$o=l(ar,"P",{"data-svelte-h":!0}),u($o)!=="svelte-1earq1f"&&($o.textContent=ei),ar.forEach(a),Ta=o(e),d(nn.$$.fragment,e),xa=o(e),on=l(e,"P",{"data-svelte-h":!0}),u(on)!=="svelte-jsq4jz"&&(on.textContent=ti),ka=o(e),an=l(e,"P",{"data-svelte-h":!0}),u(an)!=="svelte-1ixcu88"&&(an.innerHTML=ni),Ca=o(e),rn=l(e,"P",{"data-svelte-h":!0}),u(rn)!=="svelte-1nfvcwf"&&(rn.textContent=oi),Ma=o(e),sn=l(e,"UL",{"data-svelte-h":!0}),u(sn)!=="svelte-ysem30"&&(sn.innerHTML=ai),Ia=o(e),d(ln.$$.fragment,e),Aa=o(e),ne=l(e,"DIV",{class:!0});var rr=v(ne);d(mn.$$.fragment,rr),Ws=o(rr),yo=l(rr,"P",{"data-svelte-h":!0}),u(yo)!=="svelte-57fhj7"&&(yo.textContent=ri),rr.forEach(a),ja=o(e),d(dn.$$.fragment,e),qa=o(e),J=l(e,"DIV",{class:!0});var Q=v(J);d(pn.$$.fragment,Q),Rs=o(Q),wo=l(Q,"P",{"data-svelte-h":!0}),u(wo)!=="svelte-1hsb0qs"&&(wo.textContent=si),Vs=o(Q),Le=l(Q,"DIV",{class:!0});var sr=v(Le);d(cn.$$.fragment,sr),Bs=o(sr),To=l(sr,"P",{"data-svelte-h":!0}),u(To)!=="svelte-qix5eq"&&(To.textContent=li),sr.forEach(a),zs=o(Q),Pe=l(Q,"DIV",{class:!0});var lr=v(Pe);d(gn.$$.fragment,lr),Zs=o(lr),xo=l(lr,"P",{"data-svelte-h":!0}),u(xo)!=="svelte-ybie7i"&&(xo.textContent=ii),lr.forEach(a),Ss=o(Q),Je=l(Q,"DIV",{class:!0});var ir=v(Je);d(hn.$$.fragment,ir),Gs=o(ir),ko=l(ir,"P",{"data-svelte-h":!0}),u(ko)!=="svelte-chc6sp"&&(ko.textContent=mi),ir.forEach(a),Q.forEach(a),La=o(e),d(un.$$.fragment,e),Pa=o(e),W=l(e,"DIV",{class:!0});var We=v(W);d(fn.$$.fragment,We),Os=o(We),Co=l(We,"P",{"data-svelte-h":!0}),u(Co)!=="svelte-ckiqb6"&&(Co.textContent=di),Fs=o(We),Ee=l(We,"DIV",{class:!0});var mr=v(Ee);d(bn.$$.fragment,mr),Ys=o(mr),Mo=l(mr,"P",{"data-svelte-h":!0}),u(Mo)!=="svelte-10rnn1x"&&(Mo.innerHTML=pi),mr.forEach(a),Qs=o(We),Ue=l(We,"DIV",{class:!0});var dr=v(Ue);d(vn.$$.fragment,dr),Xs=o(dr),Io=l(dr,"P",{"data-svelte-h":!0}),u(Io)!=="svelte-1xu9o93"&&(Io.textContent=ci),dr.forEach(a),We.forEach(a),Ja=o(e),d(_n.$$.fragment,e),Ea=o(e),Uo=l(e,"P",{}),v(Uo).forEach(a),this.h()},h(){_(f,"name","hf:doc:metadata"),_(f,"content",Ii),_(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,f),i(e,x,r),i(e,y,r),i(e,w,r),p(T,e,r),i(e,b,r),p(C,e,r),i(e,No,r),i(e,Re,r),i(e,Ho,r),p(Ve,e,r),i(e,Do,r),i(e,Be,r),i(e,Wo,r),i(e,ze,r),i(e,Ro,r),p(Ze,e,r),i(e,Vo,r),i(e,P,r),p(Se,P,null),t(P,cr),t(P,oe),p(Ge,oe,null),t(oe,gr),t(oe,Cn),t(P,hr),t(P,ae),p(Oe,ae,null),t(ae,ur),t(ae,Mn),t(P,fr),t(P,re),p(Fe,re,null),t(re,br),t(re,In),t(P,vr),t(P,se),p(Ye,se,null),t(se,_r),t(se,An),i(e,Bo,r),p(Qe,e,r),i(e,zo,r),i(e,H,r),p(Xe,H,null),t(H,$r),t(H,jn),t(H,yr),t(H,le),p(Ke,le,null),t(le,wr),t(le,qn),t(H,Tr),t(H,O),p(et,O,null),t(O,xr),t(O,Ln),t(O,kr),p(ie,O,null),i(e,Zo,r),p(tt,e,r),i(e,So,r),i(e,A,r),p(nt,A,null),t(A,Cr),t(A,Pn),t(A,Mr),t(A,me),p(ot,me,null),t(me,Ir),t(me,Jn),t(A,Ar),t(A,de),p(at,de,null),t(de,jr),t(de,En),t(A,qr),t(A,pe),p(rt,pe,null),t(pe,Lr),t(pe,Un),t(A,Pr),t(A,F),p(st,F,null),t(F,Jr),t(F,Nn),t(F,Er),p(ce,F,null),t(A,Ur),t(A,ge),p(lt,ge,null),t(ge,Nr),t(ge,Hn),i(e,Go,r),i(e,z,r),p(it,z,null),t(z,Hr),t(z,Dn),t(z,Dr),t(z,he),p(mt,he,null),t(he,Wr),t(he,Wn),i(e,Oo,r),i(e,Z,r),p(dt,Z,null),t(Z,Rr),t(Z,Rn),t(Z,Vr),t(Z,ue),p(pt,ue,null),t(ue,Br),t(ue,Vn),i(e,Fo,r),p(ct,e,r),i(e,Yo,r),i(e,gt,r),p(ht,gt,null),i(e,Qo,r),p(ut,e,r),i(e,Xo,r),p(ft,e,r),i(e,Ko,r),i(e,S,r),p(bt,S,null),t(S,zr),t(S,Bn),t(S,Zr),p(fe,S,null),i(e,ea,r),p(vt,e,r),i(e,ta,r),i(e,k,r),p(_t,k,null),t(k,Sr),t(k,zn),t(k,Gr),t(k,Zn),t(k,Or),t(k,Sn),t(k,Fr),t(k,be),p($t,be,null),t(be,Yr),t(be,Gn),t(k,Qr),t(k,Y),p(yt,Y,null),t(Y,Xr),t(Y,On),t(Y,Kr),p(ve,Y,null),t(k,es),t(k,_e),p(wt,_e,null),t(_e,ts),t(_e,Fn),t(k,ns),t(k,V),p(Tt,V,null),t(V,os),t(V,Yn),t(V,as),t(V,Qn),t(V,rs),p($e,V,null),t(k,ss),t(k,B),p(xt,B,null),t(B,ls),t(B,Xn),t(B,is),t(B,Kn),t(B,ms),t(B,eo),t(k,ds),t(k,ye),p(kt,ye,null),t(ye,ps),t(ye,to),i(e,na,r),p(Ct,e,r),i(e,oa,r),i(e,j,r),p(Mt,j,null),t(j,cs),t(j,no),t(j,gs),t(j,we),p(It,we,null),t(we,hs),t(we,oo),t(j,us),t(j,Te),p(At,Te,null),t(Te,fs),t(Te,ao),t(j,bs),t(j,xe),p(jt,xe,null),t(xe,vs),t(xe,ro),t(j,_s),t(j,ke),p(qt,ke,null),t(ke,$s),t(ke,so),t(j,ys),t(j,Ce),p(Lt,Ce,null),t(Ce,ws),t(Ce,lo),i(e,aa,r),p(Pt,e,r),i(e,ra,r),i(e,q,r),p(Jt,q,null),t(q,Ts),t(q,io),t(q,xs),t(q,mo),t(q,ks),t(q,Me),p(Et,Me,null),t(Me,Cs),t(Me,po),t(q,Ms),t(q,Ie),p(Ut,Ie,null),t(Ie,Is),t(Ie,co),t(q,As),t(q,Ae),p(Nt,Ae,null),t(Ae,js),t(Ae,go),t(q,qs),t(q,je),p(Ht,je,null),t(je,Ls),t(je,ho),i(e,sa,r),p(Dt,e,r),i(e,la,r),i(e,X,r),p(Wt,X,null),t(X,Ps),t(X,uo),i(e,ia,r),p(Rt,e,r),i(e,ma,r),i(e,K,r),p(Vt,K,null),t(K,Js),t(K,fo),i(e,da,r),p(Bt,e,r),i(e,pa,r),i(e,D,r),p(zt,D,null),t(D,Es),t(D,bo),t(D,Us),t(D,vo),t(D,Ns),p(qe,D,null),i(e,ca,r),p(Zt,e,r),i(e,ga,r),i(e,St,r),i(e,ha,r),i(e,Gt,r),i(e,ua,r),p(Ot,e,r),i(e,fa,r),i(e,Ft,r),i(e,ba,r),p(Yt,e,r),i(e,va,r),i(e,ee,r),p(Qt,ee,null),t(ee,Hs),t(ee,_o),i(e,_a,r),p(Xt,e,r),i(e,$a,r),i(e,Kt,r),i(e,ya,r),p(en,e,r),i(e,wa,r),i(e,te,r),p(tn,te,null),t(te,Ds),t(te,$o),i(e,Ta,r),p(nn,e,r),i(e,xa,r),i(e,on,r),i(e,ka,r),i(e,an,r),i(e,Ca,r),i(e,rn,r),i(e,Ma,r),i(e,sn,r),i(e,Ia,r),p(ln,e,r),i(e,Aa,r),i(e,ne,r),p(mn,ne,null),t(ne,Ws),t(ne,yo),i(e,ja,r),p(dn,e,r),i(e,qa,r),i(e,J,r),p(pn,J,null),t(J,Rs),t(J,wo),t(J,Vs),t(J,Le),p(cn,Le,null),t(Le,Bs),t(Le,To),t(J,zs),t(J,Pe),p(gn,Pe,null),t(Pe,Zs),t(Pe,xo),t(J,Ss),t(J,Je),p(hn,Je,null),t(Je,Gs),t(Je,ko),i(e,La,r),p(un,e,r),i(e,Pa,r),i(e,W,r),p(fn,W,null),t(W,Os),t(W,Co),t(W,Fs),t(W,Ee),p(bn,Ee,null),t(Ee,Ys),t(Ee,Mo),t(W,Qs),t(W,Ue),p(vn,Ue,null),t(Ue,Xs),t(Ue,Io),i(e,Ja,r),p(_n,e,r),i(e,Ea,r),i(e,Uo,r),Ua=!0},p(e,[r]){const R={};r&2&&(R.$$scope={dirty:r,ctx:e}),C.$set(R);const $n={};r&2&&($n.$$scope={dirty:r,ctx:e}),ie.$set($n);const yn={};r&2&&(yn.$$scope={dirty:r,ctx:e}),ce.$set(yn);const wn={};r&2&&(wn.$$scope={dirty:r,ctx:e}),fe.$set(wn);const Tn={};r&2&&(Tn.$$scope={dirty:r,ctx:e}),ve.$set(Tn);const G={};r&2&&(G.$$scope={dirty:r,ctx:e}),$e.$set(G);const xn={};r&2&&(xn.$$scope={dirty:r,ctx:e}),qe.$set(xn)},i(e){Ua||(c(T.$$.fragment,e),c(C.$$.fragment,e),c(Ve.$$.fragment,e),c(Ze.$$.fragment,e),c(Se.$$.fragment,e),c(Ge.$$.fragment,e),c(Oe.$$.fragment,e),c(Fe.$$.fragment,e),c(Ye.$$.fragment,e),c(Qe.$$.fragment,e),c(Xe.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(ie.$$.fragment,e),c(tt.$$.fragment,e),c(nt.$$.fragment,e),c(ot.$$.fragment,e),c(at.$$.fragment,e),c(rt.$$.fragment,e),c(st.$$.fragment,e),c(ce.$$.fragment,e),c(lt.$$.fragment,e),c(it.$$.fragment,e),c(mt.$$.fragment,e),c(dt.$$.fragment,e),c(pt.$$.fragment,e),c(ct.$$.fragment,e),c(ht.$$.fragment,e),c(ut.$$.fragment,e),c(ft.$$.fragment,e),c(bt.$$.fragment,e),c(fe.$$.fragment,e),c(vt.$$.fragment,e),c(_t.$$.fragment,e),c($t.$$.fragment,e),c(yt.$$.fragment,e),c(ve.$$.fragment,e),c(wt.$$.fragment,e),c(Tt.$$.fragment,e),c($e.$$.fragment,e),c(xt.$$.fragment,e),c(kt.$$.fragment,e),c(Ct.$$.fragment,e),c(Mt.$$.fragment,e),c(It.$$.fragment,e),c(At.$$.fragment,e),c(jt.$$.fragment,e),c(qt.$$.fragment,e),c(Lt.$$.fragment,e),c(Pt.$$.fragment,e),c(Jt.$$.fragment,e),c(Et.$$.fragment,e),c(Ut.$$.fragment,e),c(Nt.$$.fragment,e),c(Ht.$$.fragment,e),c(Dt.$$.fragment,e),c(Wt.$$.fragment,e),c(Rt.$$.fragment,e),c(Vt.$$.fragment,e),c(Bt.$$.fragment,e),c(zt.$$.fragment,e),c(qe.$$.fragment,e),c(Zt.$$.fragment,e),c(Ot.$$.fragment,e),c(Yt.$$.fragment,e),c(Qt.$$.fragment,e),c(Xt.$$.fragment,e),c(en.$$.fragment,e),c(tn.$$.fragment,e),c(nn.$$.fragment,e),c(ln.$$.fragment,e),c(mn.$$.fragment,e),c(dn.$$.fragment,e),c(pn.$$.fragment,e),c(cn.$$.fragment,e),c(gn.$$.fragment,e),c(hn.$$.fragment,e),c(un.$$.fragment,e),c(fn.$$.fragment,e),c(bn.$$.fragment,e),c(vn.$$.fragment,e),c(_n.$$.fragment,e),Ua=!0)},o(e){g(T.$$.fragment,e),g(C.$$.fragment,e),g(Ve.$$.fragment,e),g(Ze.$$.fragment,e),g(Se.$$.fragment,e),g(Ge.$$.fragment,e),g(Oe.$$.fragment,e),g(Fe.$$.fragment,e),g(Ye.$$.fragment,e),g(Qe.$$.fragment,e),g(Xe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(ie.$$.fragment,e),g(tt.$$.fragment,e),g(nt.$$.fragment,e),g(ot.$$.fragment,e),g(at.$$.fragment,e),g(rt.$$.fragment,e),g(st.$$.fragment,e),g(ce.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(mt.$$.fragment,e),g(dt.$$.fragment,e),g(pt.$$.fragment,e),g(ct.$$.fragment,e),g(ht.$$.fragment,e),g(ut.$$.fragment,e),g(ft.$$.fragment,e),g(bt.$$.fragment,e),g(fe.$$.fragment,e),g(vt.$$.fragment,e),g(_t.$$.fragment,e),g($t.$$.fragment,e),g(yt.$$.fragment,e),g(ve.$$.fragment,e),g(wt.$$.fragment,e),g(Tt.$$.fragment,e),g($e.$$.fragment,e),g(xt.$$.fragment,e),g(kt.$$.fragment,e),g(Ct.$$.fragment,e),g(Mt.$$.fragment,e),g(It.$$.fragment,e),g(At.$$.fragment,e),g(jt.$$.fragment,e),g(qt.$$.fragment,e),g(Lt.$$.fragment,e),g(Pt.$$.fragment,e),g(Jt.$$.fragment,e),g(Et.$$.fragment,e),g(Ut.$$.fragment,e),g(Nt.$$.fragment,e),g(Ht.$$.fragment,e),g(Dt.$$.fragment,e),g(Wt.$$.fragment,e),g(Rt.$$.fragment,e),g(Vt.$$.fragment,e),g(Bt.$$.fragment,e),g(zt.$$.fragment,e),g(qe.$$.fragment,e),g(Zt.$$.fragment,e),g(Ot.$$.fragment,e),g(Yt.$$.fragment,e),g(Qt.$$.fragment,e),g(Xt.$$.fragment,e),g(en.$$.fragment,e),g(tn.$$.fragment,e),g(nn.$$.fragment,e),g(ln.$$.fragment,e),g(mn.$$.fragment,e),g(dn.$$.fragment,e),g(pn.$$.fragment,e),g(cn.$$.fragment,e),g(gn.$$.fragment,e),g(hn.$$.fragment,e),g(un.$$.fragment,e),g(fn.$$.fragment,e),g(bn.$$.fragment,e),g(vn.$$.fragment,e),g(_n.$$.fragment,e),Ua=!1},d(e){e&&(a(x),a(y),a(w),a(b),a(No),a(Re),a(Ho),a(Do),a(Be),a(Wo),a(ze),a(Ro),a(Vo),a(P),a(Bo),a(zo),a(H),a(Zo),a(So),a(A),a(Go),a(z),a(Oo),a(Z),a(Fo),a(Yo),a(gt),a(Qo),a(Xo),a(Ko),a(S),a(ea),a(ta),a(k),a(na),a(oa),a(j),a(aa),a(ra),a(q),a(sa),a(la),a(X),a(ia),a(ma),a(K),a(da),a(pa),a(D),a(ca),a(ga),a(St),a(ha),a(Gt),a(ua),a(fa),a(Ft),a(ba),a(va),a(ee),a(_a),a($a),a(Kt),a(ya),a(wa),a(te),a(Ta),a(xa),a(on),a(ka),a(an),a(Ca),a(rn),a(Ma),a(sn),a(Ia),a(Aa),a(ne),a(ja),a(qa),a(J),a(La),a(Pa),a(W),a(Ja),a(Ea),a(Uo)),a(f),h(T,e),h(C,e),h(Ve,e),h(Ze,e),h(Se),h(Ge),h(Oe),h(Fe),h(Ye),h(Qe,e),h(Xe),h(Ke),h(et),h(ie),h(tt,e),h(nt),h(ot),h(at),h(rt),h(st),h(ce),h(lt),h(it),h(mt),h(dt),h(pt),h(ct,e),h(ht),h(ut,e),h(ft,e),h(bt),h(fe),h(vt,e),h(_t),h($t),h(yt),h(ve),h(wt),h(Tt),h($e),h(xt),h(kt),h(Ct,e),h(Mt),h(It),h(At),h(jt),h(qt),h(Lt),h(Pt,e),h(Jt),h(Et),h(Ut),h(Nt),h(Ht),h(Dt,e),h(Wt),h(Rt,e),h(Vt),h(Bt,e),h(zt),h(qe),h(Zt,e),h(Ot,e),h(Yt,e),h(Qt),h(Xt,e),h(en,e),h(tn),h(nn,e),h(ln,e),h(mn),h(dn,e),h(pn),h(cn),h(gn),h(hn),h(un,e),h(fn),h(bn),h(vn),h(_n,e)}}}const Ii='{"title":"Agents & Tools","local":"agents--tools","sections":[{"title":"Agents","local":"agents","sections":[{"title":"Agent","local":"transformers.Agent","sections":[],"depth":3},{"title":"CodeAgent","local":"transformers.CodeAgent","sections":[],"depth":3},{"title":"React agents","local":"transformers.ReactAgent","sections":[],"depth":3},{"title":"ManagedAgent","local":"transformers.ManagedAgent","sections":[],"depth":3}],"depth":2},{"title":"Tools","local":"tools","sections":[{"title":"load_tool","local":"transformers.load_tool","sections":[],"depth":3},{"title":"Tool","local":"transformers.Tool","sections":[],"depth":3},{"title":"Toolbox","local":"transformers.Toolbox","sections":[],"depth":3},{"title":"PipelineTool","local":"transformers.PipelineTool","sections":[],"depth":3},{"title":"launch_gradio_demo","local":"transformers.launch_gradio_demo","sections":[],"depth":3},{"title":"stream_to_gradio","local":"transformers.stream_to_gradio","sections":[],"depth":3},{"title":"ToolCollection","local":"transformers.ToolCollection","sections":[],"depth":3}],"depth":2},{"title":"Engines","local":"engines","sections":[{"title":"TransformersEngine","local":"transformers.TransformersEngine","sections":[],"depth":3},{"title":"HfApiEngine","local":"transformers.HfApiEngine","sections":[],"depth":3}],"depth":2},{"title":"Agent Types","local":"agent-types","sections":[{"title":"AgentText","local":"transformers.agents.agent_types.AgentText","sections":[],"depth":3},{"title":"AgentImage","local":"transformers.agents.agent_types.AgentImage","sections":[],"depth":3},{"title":"AgentAudio","local":"transformers.agents.agent_types.AgentAudio","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ai(L){return ui(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ni extends fi{constructor(f){super(),bi(this,f,Ai,Mi,hi,{})}}export{Ni as component};
