import{S as hn,i as un,s as fn,e as p,k as f,w as v,t as a,M as mn,c as i,d as s,m,a as c,x as E,h as l,b as j,G as t,g as h,y as T,q as z,o as x,B as q,v as dn,L as ra}from"../../chunks/vendor-hf-doc-builder.js";import{T as hl}from"../../chunks/Tip-hf-doc-builder.js";import{I as at}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{C as N}from"../../chunks/CodeBlock-hf-doc-builder.js";import{F as cl,M as lt}from"../../chunks/Markdown-hf-doc-builder.js";function _n(B){let r,_;return r=new N({props:{code:`from dataclasses import dataclass
from transformers.tokenization_utils_base import PreTrainedTokenizerBase, PaddingStrategy
from typing import Optional, Union
import torch


@dataclass
class DataCollatorForMultipleChoice:
    """
    Data collator that will dynamically pad the inputs for multiple choice received.
    """

    tokenizer: PreTrainedTokenizerBase
    padding: Union[bool, str, PaddingStrategy] = True
    max_length: Optional[int] = None
    pad_to_multiple_of: Optional[int] = None

    def __call__(self, features):
        label_name = "label" if "label" in features[0].keys() else "labels"
        labels = [feature.pop(label_name) for feature in features]
        batch_size = len(features)
        num_choices = len(features[0]["input_ids"])
        flattened_features = [
            [{k: v[i] for k, v in feature.items()} for i in range(num_choices)] for feature in features
        ]
        flattened_features = sum(flattened_features, [])

        batch = self.tokenizer.pad(
            flattened_features,
            padding=self.padding,
            max_length=self.max_length,
            pad_to_multiple_of=self.pad_to_multiple_of,
            return_tensors="pt",
        )

        batch = {k: v.view(batch_size, num_choices, -1) for k, v in batch.items()}
        batch["labels"] = torch.tensor(labels, dtype=torch.int64)
        return batch`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.tokenization_utils_base <span class="hljs-keyword">import</span> PreTrainedTokenizerBase, PaddingStrategy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorForMultipleChoice</span>:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Data collator that will dynamically pad the inputs for multiple choice received.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>

<span class="hljs-meta">... </span>    tokenizer: PreTrainedTokenizerBase
<span class="hljs-meta">... </span>    padding: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bool</span>, <span class="hljs-built_in">str</span>, PaddingStrategy] = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    max_length: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>    pad_to_multiple_of: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features</span>):
<span class="hljs-meta">... </span>        label_name = <span class="hljs-string">&quot;label&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;label&quot;</span> <span class="hljs-keyword">in</span> features[<span class="hljs-number">0</span>].keys() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;labels&quot;</span>
<span class="hljs-meta">... </span>        labels = [feature.pop(label_name) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        batch_size = <span class="hljs-built_in">len</span>(features)
<span class="hljs-meta">... </span>        num_choices = <span class="hljs-built_in">len</span>(features[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">... </span>        flattened_features = [
<span class="hljs-meta">... </span>            [{k: v[i] <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> feature.items()} <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_choices)] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features
<span class="hljs-meta">... </span>        ]
<span class="hljs-meta">... </span>        flattened_features = <span class="hljs-built_in">sum</span>(flattened_features, [])

<span class="hljs-meta">... </span>        batch = self.tokenizer.pad(
<span class="hljs-meta">... </span>            flattened_features,
<span class="hljs-meta">... </span>            padding=self.padding,
<span class="hljs-meta">... </span>            max_length=self.max_length,
<span class="hljs-meta">... </span>            pad_to_multiple_of=self.pad_to_multiple_of,
<span class="hljs-meta">... </span>            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>        )

<span class="hljs-meta">... </span>        batch = {k: v.view(batch_size, num_choices, -<span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = torch.tensor(labels, dtype=torch.int64)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`}}),{c(){v(r.$$.fragment)},l(n){E(r.$$.fragment,n)},m(n,d){T(r,n,d),_=!0},p:ra,i(n){_||(z(r.$$.fragment,n),_=!0)},o(n){x(r.$$.fragment,n),_=!1},d(n){q(r,n)}}}function gn(B){let r,_;return r=new lt({props:{$$slots:{default:[_n]},$$scope:{ctx:B}}}),{c(){v(r.$$.fragment)},l(n){E(r.$$.fragment,n)},m(n,d){T(r,n,d),_=!0},p(n,d){const w={};d&2&&(w.$$scope={dirty:d,ctx:n}),r.$set(w)},i(n){_||(z(r.$$.fragment,n),_=!0)},o(n){x(r.$$.fragment,n),_=!1},d(n){q(r,n)}}}function $n(B){let r,_;return r=new N({props:{code:`from dataclasses import dataclass
from transformers.tokenization_utils_base import PreTrainedTokenizerBase, PaddingStrategy
from typing import Optional, Union
import tensorflow as tf


@dataclass
class DataCollatorForMultipleChoice:
    """
    Data collator that will dynamically pad the inputs for multiple choice received.
    """

    tokenizer: PreTrainedTokenizerBase
    padding: Union[bool, str, PaddingStrategy] = True
    max_length: Optional[int] = None
    pad_to_multiple_of: Optional[int] = None

    def __call__(self, features):
        label_name = "label" if "label" in features[0].keys() else "labels"
        labels = [feature.pop(label_name) for feature in features]
        batch_size = len(features)
        num_choices = len(features[0]["input_ids"])
        flattened_features = [
            [{k: v[i] for k, v in feature.items()} for i in range(num_choices)] for feature in features
        ]
        flattened_features = sum(flattened_features, [])

        batch = self.tokenizer.pad(
            flattened_features,
            padding=self.padding,
            max_length=self.max_length,
            pad_to_multiple_of=self.pad_to_multiple_of,
            return_tensors="tf",
        )

        batch = {k: tf.reshape(v, (batch_size, num_choices, -1)) for k, v in batch.items()}
        batch["labels"] = tf.convert_to_tensor(labels, dtype=tf.int64)
        return batch`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.tokenization_utils_base <span class="hljs-keyword">import</span> PreTrainedTokenizerBase, PaddingStrategy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorForMultipleChoice</span>:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Data collator that will dynamically pad the inputs for multiple choice received.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>

<span class="hljs-meta">... </span>    tokenizer: PreTrainedTokenizerBase
<span class="hljs-meta">... </span>    padding: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bool</span>, <span class="hljs-built_in">str</span>, PaddingStrategy] = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    max_length: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>    pad_to_multiple_of: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features</span>):
<span class="hljs-meta">... </span>        label_name = <span class="hljs-string">&quot;label&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;label&quot;</span> <span class="hljs-keyword">in</span> features[<span class="hljs-number">0</span>].keys() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;labels&quot;</span>
<span class="hljs-meta">... </span>        labels = [feature.pop(label_name) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        batch_size = <span class="hljs-built_in">len</span>(features)
<span class="hljs-meta">... </span>        num_choices = <span class="hljs-built_in">len</span>(features[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">... </span>        flattened_features = [
<span class="hljs-meta">... </span>            [{k: v[i] <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> feature.items()} <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_choices)] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features
<span class="hljs-meta">... </span>        ]
<span class="hljs-meta">... </span>        flattened_features = <span class="hljs-built_in">sum</span>(flattened_features, [])

<span class="hljs-meta">... </span>        batch = self.tokenizer.pad(
<span class="hljs-meta">... </span>            flattened_features,
<span class="hljs-meta">... </span>            padding=self.padding,
<span class="hljs-meta">... </span>            max_length=self.max_length,
<span class="hljs-meta">... </span>            pad_to_multiple_of=self.pad_to_multiple_of,
<span class="hljs-meta">... </span>            return_tensors=<span class="hljs-string">&quot;tf&quot;</span>,
<span class="hljs-meta">... </span>        )

<span class="hljs-meta">... </span>        batch = {k: tf.reshape(v, (batch_size, num_choices, -<span class="hljs-number">1</span>)) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = tf.convert_to_tensor(labels, dtype=tf.int64)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`}}),{c(){v(r.$$.fragment)},l(n){E(r.$$.fragment,n)},m(n,d){T(r,n,d),_=!0},p:ra,i(n){_||(z(r.$$.fragment,n),_=!0)},o(n){x(r.$$.fragment,n),_=!1},d(n){q(r,n)}}}function jn(B){let r,_;return r=new lt({props:{$$slots:{default:[$n]},$$scope:{ctx:B}}}),{c(){v(r.$$.fragment)},l(n){E(r.$$.fragment,n)},m(n,d){T(r,n,d),_=!0},p(n,d){const w={};d&2&&(w.$$scope={dirty:d,ctx:n}),r.$set(w)},i(n){_||(z(r.$$.fragment,n),_=!0)},o(n){x(r.$$.fragment,n),_=!1},d(n){q(r,n)}}}function wn(B){let r,_,n,d,w,b,A,P;return{c(){r=p("p"),_=a("If you aren\u2019t familiar with finetuning a model with the "),n=p("a"),d=a("Trainer"),w=a(", take a look at the basic tutorial "),b=p("a"),A=a("here"),P=a("!"),this.h()},l(C){r=i(C,"P",{});var F=c(r);_=l(F,"If you aren\u2019t familiar with finetuning a model with the "),n=i(F,"A",{href:!0});var D=c(n);d=l(D,"Trainer"),D.forEach(s),w=l(F,", take a look at the basic tutorial "),b=i(F,"A",{href:!0});var I=c(b);A=l(I,"here"),I.forEach(s),P=l(F,"!"),F.forEach(s),this.h()},h(){j(n,"href","/docs/transformers/v4.26.0/en/main_classes/trainer#transformers.Trainer"),j(b,"href","../training#train-with-pytorch-trainer")},m(C,F){h(C,r,F),t(r,_),t(r,n),t(n,d),t(r,w),t(r,b),t(b,A),t(r,P)},d(C){C&&s(r)}}}function kn(B){let r,_,n,d,w,b,A,P,C,F,D,I,W,G,U,J,S,L,k,M,Q,g,O,Y,oe,K,pe,De,be,ge,fe,ye,R,Oe,le,me,xe,ie,V,ve,X,qe,se,te,Ee,ce,he,ne;return r=new hl({props:{$$slots:{default:[wn]},$$scope:{ctx:B}}}),n=new N({props:{code:`from transformers import AutoModelForMultipleChoice, TrainingArguments, Trainer

model = AutoModelForMultipleChoice.from_pretrained("bert-base-uncased")`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForMultipleChoice, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)`}}),V=new N({props:{code:`training_args = TrainingArguments(
    output_dir="my_awesome_swag_model",
    evaluation_strategy="epoch",
    save_strategy="epoch",
    load_best_model_at_end=True,
    learning_rate=5e-5,
    per_device_train_batch_size=16,
    per_device_eval_batch_size=16,
    num_train_epochs=3,
    weight_decay=0.01,
    push_to_hub=True,
)

trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=tokenized_swag["train"],
    eval_dataset=tokenized_swag["validation"],
    tokenizer=tokenizer,
    data_collator=DataCollatorForMultipleChoice(tokenizer=tokenizer),
    compute_metrics=compute_metrics,
)

trainer.train()`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">16</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">16</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    weight_decay=<span class="hljs-number">0.01</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=tokenized_swag[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=tokenized_swag[<span class="hljs-string">&quot;validation&quot;</span>],
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>    data_collator=DataCollatorForMultipleChoice(tokenizer=tokenizer),
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`}}),he=new N({props:{code:"trainer.push_to_hub()",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()'}}),{c(){v(r.$$.fragment),_=a(`
You're ready to start training your model now! Load BERT with [AutoModelForMultipleChoice](/docs/transformers/v4.26.0/en/model_doc/auto#transformers.AutoModelForMultipleChoice):

	`),v(n.$$.fragment),d=f(),w=p("p"),b=a("At this point, only three steps remain:"),A=f(),P=p("ol"),C=p("li"),F=a("Define your training hyperparameters in "),D=p("a"),I=a("TrainingArguments"),W=a(". The only required parameter is "),G=p("code"),U=a("output_dir"),J=a(" which specifies where to save your model. You\u2019ll push this model to the Hub by setting "),S=p("code"),L=a("push_to_hub=True"),k=a(" (you need to be signed in to Hugging Face to upload your model). At the end of each epoch, the "),M=p("a"),Q=a("Trainer"),g=a(" will evaluate the accuracy and save the training checkpoint."),O=f(),Y=p("li"),oe=a("Pass the training arguments to "),K=p("a"),pe=a("Trainer"),De=a(" along with the model, dataset, tokenizer, data collator, and "),be=p("code"),ge=a("compute_metrics"),fe=a(" function."),ye=f(),R=p("li"),Oe=a("Call "),le=p("a"),me=a("train()"),xe=a(" to finetune your model."),ie=f(),v(V.$$.fragment),ve=f(),X=p("p"),qe=a("Once training is completed, share your model to the Hub with the "),se=p("a"),te=a("push_to_hub()"),Ee=a(" method so everyone can use your model:"),ce=f(),v(he.$$.fragment),this.h()},l($){E(r.$$.fragment,$),_=l($,`
You're ready to start training your model now! Load BERT with [AutoModelForMultipleChoice](/docs/transformers/v4.26.0/en/model_doc/auto#transformers.AutoModelForMultipleChoice):

	`),E(n.$$.fragment,$),d=m($),w=i($,"P",{});var H=c(w);b=l(H,"At this point, only three steps remain:"),H.forEach(s),A=m($),P=i($,"OL",{});var Z=c(P);C=i(Z,"LI",{});var ee=c(C);F=l(ee,"Define your training hyperparameters in "),D=i(ee,"A",{href:!0});var Ce=c(D);I=l(Ce,"TrainingArguments"),Ce.forEach(s),W=l(ee,". The only required parameter is "),G=i(ee,"CODE",{});var We=c(G);U=l(We,"output_dir"),We.forEach(s),J=l(ee," which specifies where to save your model. You\u2019ll push this model to the Hub by setting "),S=i(ee,"CODE",{});var Se=c(S);L=l(Se,"push_to_hub=True"),Se.forEach(s),k=l(ee," (you need to be signed in to Hugging Face to upload your model). At the end of each epoch, the "),M=i(ee,"A",{href:!0});var de=c(M);Q=l(de,"Trainer"),de.forEach(s),g=l(ee," will evaluate the accuracy and save the training checkpoint."),ee.forEach(s),O=m(Z),Y=i(Z,"LI",{});var ae=c(Y);oe=l(ae,"Pass the training arguments to "),K=i(ae,"A",{href:!0});var $e=c(K);pe=l($e,"Trainer"),$e.forEach(s),De=l(ae," along with the model, dataset, tokenizer, data collator, and "),be=i(ae,"CODE",{});var Te=c(be);ge=l(Te,"compute_metrics"),Te.forEach(s),fe=l(ae," function."),ae.forEach(s),ye=m(Z),R=i(Z,"LI",{});var ze=c(R);Oe=l(ze,"Call "),le=i(ze,"A",{href:!0});var _e=c(le);me=l(_e,"train()"),_e.forEach(s),xe=l(ze," to finetune your model."),ze.forEach(s),Z.forEach(s),ie=m($),E(V.$$.fragment,$),ve=m($),X=i($,"P",{});var re=c(X);qe=l(re,"Once training is completed, share your model to the Hub with the "),se=i(re,"A",{href:!0});var ue=c(se);te=l(ue,"push_to_hub()"),ue.forEach(s),Ee=l(re," method so everyone can use your model:"),re.forEach(s),ce=m($),E(he.$$.fragment,$),this.h()},h(){j(D,"href","/docs/transformers/v4.26.0/en/main_classes/trainer#transformers.TrainingArguments"),j(M,"href","/docs/transformers/v4.26.0/en/main_classes/trainer#transformers.Trainer"),j(K,"href","/docs/transformers/v4.26.0/en/main_classes/trainer#transformers.Trainer"),j(le,"href","/docs/transformers/v4.26.0/en/main_classes/trainer#transformers.Trainer.train"),j(se,"href","/docs/transformers/v4.26.0/en/main_classes/trainer#transformers.Trainer.push_to_hub")},m($,H){T(r,$,H),h($,_,H),T(n,$,H),h($,d,H),h($,w,H),t(w,b),h($,A,H),h($,P,H),t(P,C),t(C,F),t(C,D),t(D,I),t(C,W),t(C,G),t(G,U),t(C,J),t(C,S),t(S,L),t(C,k),t(C,M),t(M,Q),t(C,g),t(P,O),t(P,Y),t(Y,oe),t(Y,K),t(K,pe),t(Y,De),t(Y,be),t(be,ge),t(Y,fe),t(P,ye),t(P,R),t(R,Oe),t(R,le),t(le,me),t(R,xe),h($,ie,H),T(V,$,H),h($,ve,H),h($,X,H),t(X,qe),t(X,se),t(se,te),t(X,Ee),h($,ce,H),T(he,$,H),ne=!0},p($,H){const Z={};H&2&&(Z.$$scope={dirty:H,ctx:$}),r.$set(Z)},i($){ne||(z(r.$$.fragment,$),z(n.$$.fragment,$),z(V.$$.fragment,$),z(he.$$.fragment,$),ne=!0)},o($){x(r.$$.fragment,$),x(n.$$.fragment,$),x(V.$$.fragment,$),x(he.$$.fragment,$),ne=!1},d($){q(r,$),$&&s(_),q(n,$),$&&s(d),$&&s(w),$&&s(A),$&&s(P),$&&s(ie),q(V,$),$&&s(ve),$&&s(X),$&&s(ce),q(he,$)}}}function bn(B){let r,_;return r=new lt({props:{$$slots:{default:[kn]},$$scope:{ctx:B}}}),{c(){v(r.$$.fragment)},l(n){E(r.$$.fragment,n)},m(n,d){T(r,n,d),_=!0},p(n,d){const w={};d&2&&(w.$$scope={dirty:d,ctx:n}),r.$set(w)},i(n){_||(z(r.$$.fragment,n),_=!0)},o(n){x(r.$$.fragment,n),_=!1},d(n){q(r,n)}}}function yn(B){let r,_,n,d,w;return{c(){r=p("p"),_=a("If you aren\u2019t familiar with finetuning a model with Keras, take a look at the basic tutorial "),n=p("a"),d=a("here"),w=a("!"),this.h()},l(b){r=i(b,"P",{});var A=c(r);_=l(A,"If you aren\u2019t familiar with finetuning a model with Keras, take a look at the basic tutorial "),n=i(A,"A",{href:!0});var P=c(n);d=l(P,"here"),P.forEach(s),w=l(A,"!"),A.forEach(s),this.h()},h(){j(n,"href","../training#train-a-tensorflow-model-with-keras")},m(b,A){h(b,r,A),t(r,_),t(r,n),t(n,d),t(r,w)},d(b){b&&s(r)}}}function vn(B){let r,_,n,d,w,b,A,P,C,F,D,I,W,G,U,J,S,L,k,M,Q,g,O,Y,oe,K,pe,De,be,ge,fe,ye,R,Oe,le,me,xe,ie,V,ve,X,qe,se,te,Ee,ce,he,ne,$,H,Z,ee,Ce,We,Se,de,ae,$e,Te,ze,_e,re,ue,Ge,He,Ue,je,we,Ye,Le,as,Ae,ys,ls;return r=new hl({props:{$$slots:{default:[yn]},$$scope:{ctx:B}}}),n=new N({props:{code:`from transformers import create_optimizer

batch_size = 16
num_train_epochs = 2
total_train_steps = (len(tokenized_swag["train"]) // batch_size) * num_train_epochs
optimizer, schedule = create_optimizer(init_lr=5e-5, num_warmup_steps=0, num_train_steps=total_train_steps)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> create_optimizer

<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">16</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_train_epochs = <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>total_train_steps = (<span class="hljs-built_in">len</span>(tokenized_swag[<span class="hljs-string">&quot;train&quot;</span>]) // batch_size) * num_train_epochs
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer, schedule = create_optimizer(init_lr=<span class="hljs-number">5e-5</span>, num_warmup_steps=<span class="hljs-number">0</span>, num_train_steps=total_train_steps)`}}),D=new N({props:{code:`from transformers import TFAutoModelForMultipleChoice

model = TFAutoModelForMultipleChoice.from_pretrained("bert-base-uncased")`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)`}}),g=new N({props:{code:`data_collator = DataCollatorForMultipleChoice(tokenizer=tokenizer)
tf_train_set = model.prepare_tf_dataset(
    tokenized_swag["train"],
    shuffle=True,
    batch_size=batch_size,
    collate_fn=data_collator,
)

tf_validation_set = model.prepare_tf_dataset(
    tokenized_swag["validation"],
    shuffle=False,
    batch_size=batch_size,
    collate_fn=data_collator,
)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DataCollatorForMultipleChoice(tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_set = model.prepare_tf_dataset(
<span class="hljs-meta">... </span>    tokenized_swag[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_validation_set = model.prepare_tf_dataset(
<span class="hljs-meta">... </span>    tokenized_swag[<span class="hljs-string">&quot;validation&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)`}}),fe=new N({props:{code:"model.compile(optimizer=optimizer)",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(optimizer=optimizer)'}}),ne=new N({props:{code:`from transformers.keras_callbacks import KerasMetricCallback

metric_callback = KerasMetricCallback(metric_fn=compute_metrics, eval_dataset=tf_validation_set)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.keras_callbacks <span class="hljs-keyword">import</span> KerasMetricCallback

<span class="hljs-meta">&gt;&gt;&gt; </span>metric_callback = KerasMetricCallback(metric_fn=compute_metrics, eval_dataset=tf_validation_set)`}}),de=new N({props:{code:`from transformers.keras_callbacks import PushToHubCallback

push_to_hub_callback = PushToHubCallback(
    output_dir="my_awesome_model",
    tokenizer=tokenizer,
)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.keras_callbacks <span class="hljs-keyword">import</span> PushToHubCallback

<span class="hljs-meta">&gt;&gt;&gt; </span>push_to_hub_callback = PushToHubCallback(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_model&quot;</span>,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>)`}}),_e=new N({props:{code:"callbacks = [metric_callback, push_to_hub_callback]",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>callbacks = [metric_callback, push_to_hub_callback]'}}),Le=new N({props:{code:"model.fit(x=tf_train_set, validation_data=tf_validation_set, epochs=2, callbacks=callbacks)",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(x=tf_train_set, validation_data=tf_validation_set, epochs=<span class="hljs-number">2</span>, callbacks=callbacks)'}}),{c(){v(r.$$.fragment),_=a(`
To finetune a model in TensorFlow, start by setting up an optimizer function, learning rate schedule, and some training hyperparameters:

	`),v(n.$$.fragment),d=f(),w=p("p"),b=a("Then you can load BERT with "),A=p("a"),P=a("TFAutoModelForMultipleChoice"),C=a(":"),F=f(),v(D.$$.fragment),I=f(),W=p("p"),G=a("Convert your datasets to the "),U=p("code"),J=a("tf.data.Dataset"),S=a(" format with "),L=p("a"),k=a("prepare_tf_dataset()"),M=a(":"),Q=f(),v(g.$$.fragment),O=f(),Y=p("p"),oe=a("Configure the model for training with "),K=p("a"),pe=p("code"),De=a("compile"),be=a(":"),ge=f(),v(fe.$$.fragment),ye=f(),R=p("p"),Oe=a("The last two things to setup before you start training is to compute the accuracy from the predictions, and provide a way to push your model to the Hub. Both are done by using "),le=p("a"),me=a("Keras callbacks"),xe=a("."),ie=f(),V=p("p"),ve=a("Pass your "),X=p("code"),qe=a("compute_metrics"),se=a(" function to "),te=p("a"),Ee=a("KerasMetricCallback"),ce=a(":"),he=f(),v(ne.$$.fragment),$=f(),H=p("p"),Z=a("Specify where to push your model and tokenizer in the "),ee=p("a"),Ce=a("PushToHubCallback"),We=a(":"),Se=f(),v(de.$$.fragment),ae=f(),$e=p("p"),Te=a("Then bundle your callbacks together:"),ze=f(),v(_e.$$.fragment),re=f(),ue=p("p"),Ge=a("Finally, you\u2019re ready to start training your model! Call "),He=p("a"),Ue=p("code"),je=a("fit"),we=a(" with your training and validation datasets, the number of epochs, and your callbacks to finetune the model:"),Ye=f(),v(Le.$$.fragment),as=f(),Ae=p("p"),ys=a("Once training is completed, your model is automatically uploaded to the Hub so everyone can use it!"),this.h()},l(o){E(r.$$.fragment,o),_=l(o,`
To finetune a model in TensorFlow, start by setting up an optimizer function, learning rate schedule, and some training hyperparameters:

	`),E(n.$$.fragment,o),d=m(o),w=i(o,"P",{});var y=c(w);b=l(y,"Then you can load BERT with "),A=i(y,"A",{href:!0});var Ve=c(A);P=l(Ve,"TFAutoModelForMultipleChoice"),Ve.forEach(s),C=l(y,":"),y.forEach(s),F=m(o),E(D.$$.fragment,o),I=m(o),W=i(o,"P",{});var Ke=c(W);G=l(Ke,"Convert your datasets to the "),U=i(Ke,"CODE",{});var Xe=c(U);J=l(Xe,"tf.data.Dataset"),Xe.forEach(s),S=l(Ke," format with "),L=i(Ke,"A",{href:!0});var ns=c(L);k=l(ns,"prepare_tf_dataset()"),ns.forEach(s),M=l(Ke,":"),Ke.forEach(s),Q=m(o),E(g.$$.fragment,o),O=m(o),Y=i(o,"P",{});var rs=c(Y);oe=l(rs,"Configure the model for training with "),K=i(rs,"A",{href:!0,rel:!0});var Ws=c(K);pe=i(Ws,"CODE",{});var Gs=c(pe);De=l(Gs,"compile"),Gs.forEach(s),Ws.forEach(s),be=l(rs,":"),rs.forEach(s),ge=m(o),E(fe.$$.fragment,o),ye=m(o),R=i(o,"P",{});var Ie=c(R);Oe=l(Ie,"The last two things to setup before you start training is to compute the accuracy from the predictions, and provide a way to push your model to the Hub. Both are done by using "),le=i(Ie,"A",{href:!0});var os=c(le);me=l(os,"Keras callbacks"),os.forEach(s),xe=l(Ie,"."),Ie.forEach(s),ie=m(o),V=i(o,"P",{});var Re=c(V);ve=l(Re,"Pass your "),X=i(Re,"CODE",{});var Us=c(X);qe=l(Us,"compute_metrics"),Us.forEach(s),se=l(Re," function to "),te=i(Re,"A",{href:!0});var vs=c(te);Ee=l(vs,"KerasMetricCallback"),vs.forEach(s),ce=l(Re,":"),Re.forEach(s),he=m(o),E(ne.$$.fragment,o),$=m(o),H=i(o,"P",{});var ke=c(H);Z=l(ke,"Specify where to push your model and tokenizer in the "),ee=i(ke,"A",{href:!0});var Be=c(ee);Ce=l(Be,"PushToHubCallback"),Be.forEach(s),We=l(ke,":"),ke.forEach(s),Se=m(o),E(de.$$.fragment,o),ae=m(o),$e=i(o,"P",{});var ps=c($e);Te=l(ps,"Then bundle your callbacks together:"),ps.forEach(s),ze=m(o),E(_e.$$.fragment,o),re=m(o),ue=i(o,"P",{});var Pe=c(ue);Ge=l(Pe,"Finally, you\u2019re ready to start training your model! Call "),He=i(Pe,"A",{href:!0,rel:!0});var Ys=c(He);Ue=i(Ys,"CODE",{});var is=c(Ue);je=l(is,"fit"),is.forEach(s),Ys.forEach(s),we=l(Pe," with your training and validation datasets, the number of epochs, and your callbacks to finetune the model:"),Pe.forEach(s),Ye=m(o),E(Le.$$.fragment,o),as=m(o),Ae=i(o,"P",{});var Ks=c(Ae);ys=l(Ks,"Once training is completed, your model is automatically uploaded to the Hub so everyone can use it!"),Ks.forEach(s),this.h()},h(){j(A,"href","/docs/transformers/v4.26.0/en/model_doc/auto#transformers.TFAutoModelForMultipleChoice"),j(L,"href","/docs/transformers/v4.26.0/en/main_classes/model#transformers.TFPreTrainedModel.prepare_tf_dataset"),j(K,"href","https://keras.io/api/models/model_training_apis/#compile-method"),j(K,"rel","nofollow"),j(le,"href","./main_classes/keras_callbacks"),j(te,"href","/docs/transformers/v4.26.0/en/main_classes/keras_callbacks#transformers.KerasMetricCallback"),j(ee,"href","/docs/transformers/v4.26.0/en/main_classes/keras_callbacks#transformers.PushToHubCallback"),j(He,"href","https://keras.io/api/models/model_training_apis/#fit-method"),j(He,"rel","nofollow")},m(o,y){T(r,o,y),h(o,_,y),T(n,o,y),h(o,d,y),h(o,w,y),t(w,b),t(w,A),t(A,P),t(w,C),h(o,F,y),T(D,o,y),h(o,I,y),h(o,W,y),t(W,G),t(W,U),t(U,J),t(W,S),t(W,L),t(L,k),t(W,M),h(o,Q,y),T(g,o,y),h(o,O,y),h(o,Y,y),t(Y,oe),t(Y,K),t(K,pe),t(pe,De),t(Y,be),h(o,ge,y),T(fe,o,y),h(o,ye,y),h(o,R,y),t(R,Oe),t(R,le),t(le,me),t(R,xe),h(o,ie,y),h(o,V,y),t(V,ve),t(V,X),t(X,qe),t(V,se),t(V,te),t(te,Ee),t(V,ce),h(o,he,y),T(ne,o,y),h(o,$,y),h(o,H,y),t(H,Z),t(H,ee),t(ee,Ce),t(H,We),h(o,Se,y),T(de,o,y),h(o,ae,y),h(o,$e,y),t($e,Te),h(o,ze,y),T(_e,o,y),h(o,re,y),h(o,ue,y),t(ue,Ge),t(ue,He),t(He,Ue),t(Ue,je),t(ue,we),h(o,Ye,y),T(Le,o,y),h(o,as,y),h(o,Ae,y),t(Ae,ys),ls=!0},p(o,y){const Ve={};y&2&&(Ve.$$scope={dirty:y,ctx:o}),r.$set(Ve)},i(o){ls||(z(r.$$.fragment,o),z(n.$$.fragment,o),z(D.$$.fragment,o),z(g.$$.fragment,o),z(fe.$$.fragment,o),z(ne.$$.fragment,o),z(de.$$.fragment,o),z(_e.$$.fragment,o),z(Le.$$.fragment,o),ls=!0)},o(o){x(r.$$.fragment,o),x(n.$$.fragment,o),x(D.$$.fragment,o),x(g.$$.fragment,o),x(fe.$$.fragment,o),x(ne.$$.fragment,o),x(de.$$.fragment,o),x(_e.$$.fragment,o),x(Le.$$.fragment,o),ls=!1},d(o){q(r,o),o&&s(_),q(n,o),o&&s(d),o&&s(w),o&&s(F),q(D,o),o&&s(I),o&&s(W),o&&s(Q),q(g,o),o&&s(O),o&&s(Y),o&&s(ge),q(fe,o),o&&s(ye),o&&s(R),o&&s(ie),o&&s(V),o&&s(he),q(ne,o),o&&s($),o&&s(H),o&&s(Se),q(de,o),o&&s(ae),o&&s($e),o&&s(ze),q(_e,o),o&&s(re),o&&s(ue),o&&s(Ye),q(Le,o),o&&s(as),o&&s(Ae)}}}function En(B){let r,_;return r=new lt({props:{$$slots:{default:[vn]},$$scope:{ctx:B}}}),{c(){v(r.$$.fragment)},l(n){E(r.$$.fragment,n)},m(n,d){T(r,n,d),_=!0},p(n,d){const w={};d&2&&(w.$$scope={dirty:d,ctx:n}),r.$set(w)},i(n){_||(z(r.$$.fragment,n),_=!0)},o(n){x(r.$$.fragment,n),_=!1},d(n){q(r,n)}}}function Tn(B){let r,_,n,d,w,b,A,P;return{c(){r=p("p"),_=a(`For a more in-depth example of how to finetune a model for multiple choice, take a look at the corresponding
`),n=p("a"),d=a("PyTorch notebook"),w=a(`
or `),b=p("a"),A=a("TensorFlow notebook"),P=a("."),this.h()},l(C){r=i(C,"P",{});var F=c(r);_=l(F,`For a more in-depth example of how to finetune a model for multiple choice, take a look at the corresponding
`),n=i(F,"A",{href:!0,rel:!0});var D=c(n);d=l(D,"PyTorch notebook"),D.forEach(s),w=l(F,`
or `),b=i(F,"A",{href:!0,rel:!0});var I=c(b);A=l(I,"TensorFlow notebook"),I.forEach(s),P=l(F,"."),F.forEach(s),this.h()},h(){j(n,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/multiple_choice.ipynb"),j(n,"rel","nofollow"),j(b,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/multiple_choice-tf.ipynb"),j(b,"rel","nofollow")},m(C,F){h(C,r,F),t(r,_),t(r,n),t(n,d),t(r,w),t(r,b),t(b,A),t(r,P)},d(C){C&&s(r)}}}function zn(B){let r,_,n,d,w,b,A,P,C,F,D,I,W,G,U,J,S,L,k,M,Q;return A=new N({props:{code:`from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("my_awesome_swag_model")
inputs = tokenizer([[prompt, candidate1], [prompt, candidate2]], return_tensors="pt", padding=True)
labels = torch.tensor(0).unsqueeze(0)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([[prompt, candidate1], [prompt, candidate2]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)`}}),U=new N({props:{code:`from transformers import AutoModelForMultipleChoice

model = AutoModelForMultipleChoice.from_pretrained("my_awesome_swag_model")
outputs = model(**{k: v.unsqueeze(0) for k, v in inputs.items()}, labels=labels)
logits = outputs.logits`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),M=new N({props:{code:`predicted_class = logits.argmax().item()
predicted_class`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class
<span class="hljs-string">&#x27;0&#x27;</span>`}}),{c(){r=p("p"),_=a("Tokenize each prompt and candidate answer pair and return PyTorch tensors. You should also create some "),n=p("code"),d=a("labels"),w=a(":"),b=f(),v(A.$$.fragment),P=f(),C=p("p"),F=a("Pass your inputs and labels to the model and return the "),D=p("code"),I=a("logits"),W=a(":"),G=f(),v(U.$$.fragment),J=f(),S=p("p"),L=a("Get the class with the highest probability:"),k=f(),v(M.$$.fragment)},l(g){r=i(g,"P",{});var O=c(r);_=l(O,"Tokenize each prompt and candidate answer pair and return PyTorch tensors. You should also create some "),n=i(O,"CODE",{});var Y=c(n);d=l(Y,"labels"),Y.forEach(s),w=l(O,":"),O.forEach(s),b=m(g),E(A.$$.fragment,g),P=m(g),C=i(g,"P",{});var oe=c(C);F=l(oe,"Pass your inputs and labels to the model and return the "),D=i(oe,"CODE",{});var K=c(D);I=l(K,"logits"),K.forEach(s),W=l(oe,":"),oe.forEach(s),G=m(g),E(U.$$.fragment,g),J=m(g),S=i(g,"P",{});var pe=c(S);L=l(pe,"Get the class with the highest probability:"),pe.forEach(s),k=m(g),E(M.$$.fragment,g)},m(g,O){h(g,r,O),t(r,_),t(r,n),t(n,d),t(r,w),h(g,b,O),T(A,g,O),h(g,P,O),h(g,C,O),t(C,F),t(C,D),t(D,I),t(C,W),h(g,G,O),T(U,g,O),h(g,J,O),h(g,S,O),t(S,L),h(g,k,O),T(M,g,O),Q=!0},p:ra,i(g){Q||(z(A.$$.fragment,g),z(U.$$.fragment,g),z(M.$$.fragment,g),Q=!0)},o(g){x(A.$$.fragment,g),x(U.$$.fragment,g),x(M.$$.fragment,g),Q=!1},d(g){g&&s(r),g&&s(b),q(A,g),g&&s(P),g&&s(C),g&&s(G),q(U,g),g&&s(J),g&&s(S),g&&s(k),q(M,g)}}}function xn(B){let r,_;return r=new lt({props:{$$slots:{default:[zn]},$$scope:{ctx:B}}}),{c(){v(r.$$.fragment)},l(n){E(r.$$.fragment,n)},m(n,d){T(r,n,d),_=!0},p(n,d){const w={};d&2&&(w.$$scope={dirty:d,ctx:n}),r.$set(w)},i(n){_||(z(r.$$.fragment,n),_=!0)},o(n){x(r.$$.fragment,n),_=!1},d(n){q(r,n)}}}function qn(B){let r,_,n,d,w,b,A,P,C,F,D,I,W,G,U,J,S,L;return d=new N({props:{code:`from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("my_awesome_swag_model")
inputs = tokenizer([[prompt, candidate1], [prompt, candidate2]], return_tensors="tf", padding=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([[prompt, candidate1], [prompt, candidate2]], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>, padding=<span class="hljs-literal">True</span>)`}}),I=new N({props:{code:`from transformers import TFAutoModelForMultipleChoice

model = TFAutoModelForMultipleChoice.from_pretrained("my_awesome_swag_model")
inputs = {k: tf.expand_dims(v, 0) for k, v in inputs.items()}
outputs = model(inputs)
logits = outputs.logits`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {k: tf.expand_dims(v, <span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),S=new N({props:{code:`predicted_class = int(tf.math.argmax(logits, axis=-1)[0])
predicted_class`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class
<span class="hljs-string">&#x27;0&#x27;</span>`}}),{c(){r=p("p"),_=a("Tokenize each prompt and candidate answer pair and return TensorFlow tensors:"),n=f(),v(d.$$.fragment),w=f(),b=p("p"),A=a("Pass your inputs to the model and return the "),P=p("code"),C=a("logits"),F=a(":"),D=f(),v(I.$$.fragment),W=f(),G=p("p"),U=a("Get the class with the highest probability:"),J=f(),v(S.$$.fragment)},l(k){r=i(k,"P",{});var M=c(r);_=l(M,"Tokenize each prompt and candidate answer pair and return TensorFlow tensors:"),M.forEach(s),n=m(k),E(d.$$.fragment,k),w=m(k),b=i(k,"P",{});var Q=c(b);A=l(Q,"Pass your inputs to the model and return the "),P=i(Q,"CODE",{});var g=c(P);C=l(g,"logits"),g.forEach(s),F=l(Q,":"),Q.forEach(s),D=m(k),E(I.$$.fragment,k),W=m(k),G=i(k,"P",{});var O=c(G);U=l(O,"Get the class with the highest probability:"),O.forEach(s),J=m(k),E(S.$$.fragment,k)},m(k,M){h(k,r,M),t(r,_),h(k,n,M),T(d,k,M),h(k,w,M),h(k,b,M),t(b,A),t(b,P),t(P,C),t(b,F),h(k,D,M),T(I,k,M),h(k,W,M),h(k,G,M),t(G,U),h(k,J,M),T(S,k,M),L=!0},p:ra,i(k){L||(z(d.$$.fragment,k),z(I.$$.fragment,k),z(S.$$.fragment,k),L=!0)},o(k){x(d.$$.fragment,k),x(I.$$.fragment,k),x(S.$$.fragment,k),L=!1},d(k){k&&s(r),k&&s(n),q(d,k),k&&s(w),k&&s(b),k&&s(D),q(I,k),k&&s(W),k&&s(G),k&&s(J),q(S,k)}}}function Cn(B){let r,_;return r=new lt({props:{$$slots:{default:[qn]},$$scope:{ctx:B}}}),{c(){v(r.$$.fragment)},l(n){E(r.$$.fragment,n)},m(n,d){T(r,n,d),_=!0},p(n,d){const w={};d&2&&(w.$$scope={dirty:d,ctx:n}),r.$set(w)},i(n){_||(z(r.$$.fragment,n),_=!0)},o(n){x(r.$$.fragment,n),_=!1},d(n){q(r,n)}}}function An(B){let r,_,n,d,w,b,A,P,C,F,D,I,W,G,U,J,S,L,k,M,Q,g,O,Y,oe,K,pe,De,be,ge,fe,ye,R,Oe,le,me,xe,ie,V,ve,X,qe,se,te,Ee,ce,he,ne,$,H,Z,ee,Ce,We,Se,de,ae,$e,Te,ze,_e,re,ue,Ge,He,Ue,je,we,Ye,Le,as,Ae,ys,ls,o,y,Ve,Ke,Xe,ns,rs,Ws,Gs,Ie,os,Re,Us,vs,ke,Be,ps,Pe,Ys,is,Ks,Et,Rs,oa,Tt,Es,zt,Js,pa,xt,Je,Ze,ia,nt,ca,ha,rt,ua,fa,ma,Ts,da,ot,_a,ga,$a,Ne,ja,pt,wa,ka,it,ba,ya,ct,va,Ea,qt,zs,Ct,Me,Ta,xs,za,xa,ht,qa,Ca,ut,Aa,Pa,At,qs,Pt,Qe,Ma,Qs,Fa,Da,ft,Oa,Sa,Mt,Cs,mt,Ha,La,Ft,cs,Dt,es,hs,dt,As,Ia,_t,Ba,Ot,Fe,Na,Ps,Wa,Ga,Ms,Ua,Ya,Fs,Ka,Ra,St,Ds,Ht,us,Ja,Os,Qa,Va,Lt,Ss,It,fs,Xa,gt,Za,el,Bt,ss,ms,$t,Hs,sl,jt,tl,Nt,ds,Wt,_s,Gt,ts,gs,wt,Ls,al,kt,ll,Ut,Vs,nl,Yt,Xs,rl,Kt,Is,Rt,$s,Jt;return b=new at({}),me=new N({props:{code:"pip install transformers datasets evaluate",highlighted:"pip install transformers datasets evaluate"}}),X=new N({props:{code:`from huggingface_hub import notebook_login

notebook_login()`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`}}),ce=new at({}),ae=new N({props:{code:`from datasets import load_dataset

swag = load_dataset("swag", "regular")`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>swag = load_dataset(<span class="hljs-string">&quot;swag&quot;</span>, <span class="hljs-string">&quot;regular&quot;</span>)`}}),re=new N({props:{code:'swag["train"][0]',highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>swag[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;ending0&#x27;</span>: <span class="hljs-string">&#x27;passes by walking down the street playing their instruments.&#x27;</span>,
 <span class="hljs-string">&#x27;ending1&#x27;</span>: <span class="hljs-string">&#x27;has heard approaching them.&#x27;</span>,
 <span class="hljs-string">&#x27;ending2&#x27;</span>: <span class="hljs-string">&quot;arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
 <span class="hljs-string">&#x27;ending3&#x27;</span>: <span class="hljs-string">&#x27;turns the lead singer watches the performance.&#x27;</span>,
 <span class="hljs-string">&#x27;fold-ind&#x27;</span>: <span class="hljs-string">&#x27;3416&#x27;</span>,
 <span class="hljs-string">&#x27;gold-source&#x27;</span>: <span class="hljs-string">&#x27;gold&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;sent1&#x27;</span>: <span class="hljs-string">&#x27;Members of the procession walk down the street holding small horn brass instruments.&#x27;</span>,
 <span class="hljs-string">&#x27;sent2&#x27;</span>: <span class="hljs-string">&#x27;A drum line&#x27;</span>,
 <span class="hljs-string">&#x27;startphrase&#x27;</span>: <span class="hljs-string">&#x27;Members of the procession walk down the street holding small horn brass instruments. A drum line&#x27;</span>,
 <span class="hljs-string">&#x27;video-id&#x27;</span>: <span class="hljs-string">&#x27;anetv_jkn6uvmqwh4&#x27;</span>}`}}),Pe=new at({}),Es=new N({props:{code:`from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("bert-base-uncased")`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)`}}),zs=new N({props:{code:`ending_names = ["ending0", "ending1", "ending2", "ending3"]


def preprocess_function(examples):
    first_sentences = [[context] * 4 for context in examples["sent1"]]
    question_headers = examples["sent2"]
    second_sentences = [
        [f"{header} {examples[end][i]}" for end in ending_names] for i, header in enumerate(question_headers)
    ]

    first_sentences = sum(first_sentences, [])
    second_sentences = sum(second_sentences, [])

    tokenized_examples = tokenizer(first_sentences, second_sentences, truncation=True)
    return {k: [v[i : i + 4] for i in range(0, len(v), 4)] for k, v in tokenized_examples.items()}`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ending_names = [<span class="hljs-string">&quot;ending0&quot;</span>, <span class="hljs-string">&quot;ending1&quot;</span>, <span class="hljs-string">&quot;ending2&quot;</span>, <span class="hljs-string">&quot;ending3&quot;</span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    first_sentences = [[context] * <span class="hljs-number">4</span> <span class="hljs-keyword">for</span> context <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;sent1&quot;</span>]]
<span class="hljs-meta">... </span>    question_headers = examples[<span class="hljs-string">&quot;sent2&quot;</span>]
<span class="hljs-meta">... </span>    second_sentences = [
<span class="hljs-meta">... </span>        [<span class="hljs-string">f&quot;<span class="hljs-subst">{header}</span> <span class="hljs-subst">{examples[end][i]}</span>&quot;</span> <span class="hljs-keyword">for</span> end <span class="hljs-keyword">in</span> ending_names] <span class="hljs-keyword">for</span> i, header <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(question_headers)
<span class="hljs-meta">... </span>    ]

<span class="hljs-meta">... </span>    first_sentences = <span class="hljs-built_in">sum</span>(first_sentences, [])
<span class="hljs-meta">... </span>    second_sentences = <span class="hljs-built_in">sum</span>(second_sentences, [])

<span class="hljs-meta">... </span>    tokenized_examples = tokenizer(first_sentences, second_sentences, truncation=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {k: [v[i : i + <span class="hljs-number">4</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), <span class="hljs-number">4</span>)] <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> tokenized_examples.items()}`}}),qs=new N({props:{code:"tokenized_swag = swag.map(preprocess_function, batched=True)",highlighted:'tokenized_swag = swag.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)'}}),cs=new cl({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[jn],pytorch:[gn]},$$scope:{ctx:B}}}),As=new at({}),Ds=new N({props:{code:`import evaluate

accuracy = evaluate.load("accuracy")`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)`}}),Ss=new N({props:{code:`import numpy as np


def compute_metrics(eval_pred):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=1)
    return accuracy.compute(predictions=predictions, references=labels)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    predictions, labels = eval_pred
<span class="hljs-meta">... </span>    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> accuracy.compute(predictions=predictions, references=labels)`}}),Hs=new at({}),ds=new cl({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[En],pytorch:[bn]},$$scope:{ctx:B}}}),_s=new hl({props:{$$slots:{default:[Tn]},$$scope:{ctx:B}}}),Ls=new at({}),Is=new N({props:{code:`prompt = "France has a bread law, Le D\xE9cret Pain, with strict rules on what is allowed in a traditional baguette."
candidate1 = "The law does not apply to croissants and brioche."
candidate2 = "The law applies to baguettes."`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;France has a bread law, Le D\xE9cret Pain, with strict rules on what is allowed in a traditional baguette.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate1 = <span class="hljs-string">&quot;The law does not apply to croissants and brioche.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate2 = <span class="hljs-string">&quot;The law applies to baguettes.&quot;</span>`}}),$s=new cl({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Cn],pytorch:[xn]},$$scope:{ctx:B}}}),{c(){r=p("meta"),_=f(),n=p("h1"),d=p("a"),w=p("span"),v(b.$$.fragment),A=f(),P=p("span"),C=a("Multiple choice"),F=f(),D=p("p"),I=a("A multiple choice task is similar to question answering, except several candidate answers are provided along with a context and the model is trained to select the correct answer."),W=f(),G=p("p"),U=a("This guide will show you how to:"),J=f(),S=p("ol"),L=p("li"),k=a("Finetune "),M=p("a"),Q=a("BERT"),g=a(" on the "),O=p("code"),Y=a("regular"),oe=a(" configuration of the "),K=p("a"),pe=a("SWAG"),De=a(" dataset to select the best answer given multiple options and some context."),be=f(),ge=p("li"),fe=a("Use your finetuned model for inference."),ye=f(),R=p("p"),Oe=a("Before you begin, make sure you have all the necessary libraries installed:"),le=f(),v(me.$$.fragment),xe=f(),ie=p("p"),V=a("We encourage you to login to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to login:"),ve=f(),v(X.$$.fragment),qe=f(),se=p("h2"),te=p("a"),Ee=p("span"),v(ce.$$.fragment),he=f(),ne=p("span"),$=a("Load SWAG dataset"),H=f(),Z=p("p"),ee=a("Start by loading the "),Ce=p("code"),We=a("regular"),Se=a(" configuration of the SWAG dataset from the \u{1F917} Datasets library:"),de=f(),v(ae.$$.fragment),$e=f(),Te=p("p"),ze=a("Then take a look at an example:"),_e=f(),v(re.$$.fragment),ue=f(),Ge=p("p"),He=a("While it looks like there are a lot of fields here, it is actually pretty straightforward:"),Ue=f(),je=p("ul"),we=p("li"),Ye=p("code"),Le=a("sent1"),as=a(" and "),Ae=p("code"),ys=a("sent2"),ls=a(": these fields show how a sentence starts, and if you put the two together, you get the "),o=p("code"),y=a("startphrase"),Ve=a(" field."),Ke=f(),Xe=p("li"),ns=p("code"),rs=a("ending"),Ws=a(": suggests a possible ending for how a sentence can end, but only one of them is correct."),Gs=f(),Ie=p("li"),os=p("code"),Re=a("label"),Us=a(": identifies the correct sentence ending."),vs=f(),ke=p("h2"),Be=p("a"),ps=p("span"),v(Pe.$$.fragment),Ys=f(),is=p("span"),Ks=a("Preprocess"),Et=f(),Rs=p("p"),oa=a("The next step is to load a BERT tokenizer to process the sentence starts and the four possible endings:"),Tt=f(),v(Es.$$.fragment),zt=f(),Js=p("p"),pa=a("The preprocessing function you want to create needs to:"),xt=f(),Je=p("ol"),Ze=p("li"),ia=a("Make four copies of the "),nt=p("code"),ca=a("sent1"),ha=a(" field and combine each of them with "),rt=p("code"),ua=a("sent2"),fa=a(" to recreate how a sentence starts."),ma=f(),Ts=p("li"),da=a("Combine "),ot=p("code"),_a=a("sent2"),ga=a(" with each of the four possible sentence endings."),$a=f(),Ne=p("li"),ja=a("Flatten these two lists so you can tokenize them, and then unflatten them afterward so each example has a corresponding "),pt=p("code"),wa=a("input_ids"),ka=a(", "),it=p("code"),ba=a("attention_mask"),ya=a(", and "),ct=p("code"),va=a("labels"),Ea=a(" field."),qt=f(),v(zs.$$.fragment),Ct=f(),Me=p("p"),Ta=a("To apply the preprocessing function over the entire dataset, use \u{1F917} Datasets "),xs=p("a"),za=a("map"),xa=a(" method. You can speed up the "),ht=p("code"),qa=a("map"),Ca=a(" function by setting "),ut=p("code"),Aa=a("batched=True"),Pa=a(" to process multiple elements of the dataset at once:"),At=f(),v(qs.$$.fragment),Pt=f(),Qe=p("p"),Ma=a("\u{1F917} Transformers doesn\u2019t have a data collator for multiple choice, so you\u2019ll need to adapt the "),Qs=p("a"),Fa=a("DataCollatorWithPadding"),Da=a(" to create a batch of examples. It\u2019s more efficient to "),ft=p("em"),Oa=a("dynamically pad"),Sa=a(" the sentences to the longest length in a batch during collation, instead of padding the whole dataset to the maximium length."),Mt=f(),Cs=p("p"),mt=p("code"),Ha=a("DataCollatorForMultipleChoice"),La=a(" flattens all the model inputs, applies padding, and then unflattens the results:"),Ft=f(),v(cs.$$.fragment),Dt=f(),es=p("h2"),hs=p("a"),dt=p("span"),v(As.$$.fragment),Ia=f(),_t=p("span"),Ba=a("Evaluate"),Ot=f(),Fe=p("p"),Na=a("Including a metric during training is often helpful for evaluating your model\u2019s performance. You can quickly load a evaluation method with the \u{1F917} "),Ps=p("a"),Wa=a("Evaluate"),Ga=a(" library. For this task, load the "),Ms=p("a"),Ua=a("accuracy"),Ya=a(" metric (see the \u{1F917} Evaluate "),Fs=p("a"),Ka=a("quick tour"),Ra=a(" to learn more about how to load and compute a metric):"),St=f(),v(Ds.$$.fragment),Ht=f(),us=p("p"),Ja=a("Then create a function that passes your predictions and labels to "),Os=p("a"),Qa=a("compute"),Va=a(" to calculate the accuracy:"),Lt=f(),v(Ss.$$.fragment),It=f(),fs=p("p"),Xa=a("Your "),gt=p("code"),Za=a("compute_metrics"),el=a(" function is ready to go now, and you\u2019ll return to it when you setup your training."),Bt=f(),ss=p("h2"),ms=p("a"),$t=p("span"),v(Hs.$$.fragment),sl=f(),jt=p("span"),tl=a("Train"),Nt=f(),v(ds.$$.fragment),Wt=f(),v(_s.$$.fragment),Gt=f(),ts=p("h2"),gs=p("a"),wt=p("span"),v(Ls.$$.fragment),al=f(),kt=p("span"),ll=a("Inference"),Ut=f(),Vs=p("p"),nl=a("Great, now that you\u2019ve finetuned a model, you can use it for inference!"),Yt=f(),Xs=p("p"),rl=a("Come up with some text and two candidate answers:"),Kt=f(),v(Is.$$.fragment),Rt=f(),v($s.$$.fragment),this.h()},l(e){const u=mn('[data-svelte="svelte-1phssyn"]',document.head);r=i(u,"META",{name:!0,content:!0}),u.forEach(s),_=m(e),n=i(e,"H1",{class:!0});var Bs=c(n);d=i(Bs,"A",{id:!0,class:!0,href:!0});var bt=c(d);w=i(bt,"SPAN",{});var yt=c(w);E(b.$$.fragment,yt),yt.forEach(s),bt.forEach(s),A=m(Bs),P=i(Bs,"SPAN",{});var vt=c(P);C=l(vt,"Multiple choice"),vt.forEach(s),Bs.forEach(s),F=m(e),D=i(e,"P",{});var ul=c(D);I=l(ul,"A multiple choice task is similar to question answering, except several candidate answers are provided along with a context and the model is trained to select the correct answer."),ul.forEach(s),W=m(e),G=i(e,"P",{});var fl=c(G);U=l(fl,"This guide will show you how to:"),fl.forEach(s),J=m(e),S=i(e,"OL",{});var Qt=c(S);L=i(Qt,"LI",{});var js=c(L);k=l(js,"Finetune "),M=i(js,"A",{href:!0,rel:!0});var ml=c(M);Q=l(ml,"BERT"),ml.forEach(s),g=l(js," on the "),O=i(js,"CODE",{});var dl=c(O);Y=l(dl,"regular"),dl.forEach(s),oe=l(js," configuration of the "),K=i(js,"A",{href:!0,rel:!0});var _l=c(K);pe=l(_l,"SWAG"),_l.forEach(s),De=l(js," dataset to select the best answer given multiple options and some context."),js.forEach(s),be=m(Qt),ge=i(Qt,"LI",{});var gl=c(ge);fe=l(gl,"Use your finetuned model for inference."),gl.forEach(s),Qt.forEach(s),ye=m(e),R=i(e,"P",{});var $l=c(R);Oe=l($l,"Before you begin, make sure you have all the necessary libraries installed:"),$l.forEach(s),le=m(e),E(me.$$.fragment,e),xe=m(e),ie=i(e,"P",{});var jl=c(ie);V=l(jl,"We encourage you to login to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to login:"),jl.forEach(s),ve=m(e),E(X.$$.fragment,e),qe=m(e),se=i(e,"H2",{class:!0});var Vt=c(se);te=i(Vt,"A",{id:!0,class:!0,href:!0});var wl=c(te);Ee=i(wl,"SPAN",{});var kl=c(Ee);E(ce.$$.fragment,kl),kl.forEach(s),wl.forEach(s),he=m(Vt),ne=i(Vt,"SPAN",{});var bl=c(ne);$=l(bl,"Load SWAG dataset"),bl.forEach(s),Vt.forEach(s),H=m(e),Z=i(e,"P",{});var Xt=c(Z);ee=l(Xt,"Start by loading the "),Ce=i(Xt,"CODE",{});var yl=c(Ce);We=l(yl,"regular"),yl.forEach(s),Se=l(Xt," configuration of the SWAG dataset from the \u{1F917} Datasets library:"),Xt.forEach(s),de=m(e),E(ae.$$.fragment,e),$e=m(e),Te=i(e,"P",{});var vl=c(Te);ze=l(vl,"Then take a look at an example:"),vl.forEach(s),_e=m(e),E(re.$$.fragment,e),ue=m(e),Ge=i(e,"P",{});var El=c(Ge);He=l(El,"While it looks like there are a lot of fields here, it is actually pretty straightforward:"),El.forEach(s),Ue=m(e),je=i(e,"UL",{});var Zs=c(je);we=i(Zs,"LI",{});var Ns=c(we);Ye=i(Ns,"CODE",{});var Tl=c(Ye);Le=l(Tl,"sent1"),Tl.forEach(s),as=l(Ns," and "),Ae=i(Ns,"CODE",{});var zl=c(Ae);ys=l(zl,"sent2"),zl.forEach(s),ls=l(Ns,": these fields show how a sentence starts, and if you put the two together, you get the "),o=i(Ns,"CODE",{});var xl=c(o);y=l(xl,"startphrase"),xl.forEach(s),Ve=l(Ns," field."),Ns.forEach(s),Ke=m(Zs),Xe=i(Zs,"LI",{});var ol=c(Xe);ns=i(ol,"CODE",{});var ql=c(ns);rs=l(ql,"ending"),ql.forEach(s),Ws=l(ol,": suggests a possible ending for how a sentence can end, but only one of them is correct."),ol.forEach(s),Gs=m(Zs),Ie=i(Zs,"LI",{});var pl=c(Ie);os=i(pl,"CODE",{});var Cl=c(os);Re=l(Cl,"label"),Cl.forEach(s),Us=l(pl,": identifies the correct sentence ending."),pl.forEach(s),Zs.forEach(s),vs=m(e),ke=i(e,"H2",{class:!0});var Zt=c(ke);Be=i(Zt,"A",{id:!0,class:!0,href:!0});var Al=c(Be);ps=i(Al,"SPAN",{});var Pl=c(ps);E(Pe.$$.fragment,Pl),Pl.forEach(s),Al.forEach(s),Ys=m(Zt),is=i(Zt,"SPAN",{});var Ml=c(is);Ks=l(Ml,"Preprocess"),Ml.forEach(s),Zt.forEach(s),Et=m(e),Rs=i(e,"P",{});var Fl=c(Rs);oa=l(Fl,"The next step is to load a BERT tokenizer to process the sentence starts and the four possible endings:"),Fl.forEach(s),Tt=m(e),E(Es.$$.fragment,e),zt=m(e),Js=i(e,"P",{});var Dl=c(Js);pa=l(Dl,"The preprocessing function you want to create needs to:"),Dl.forEach(s),xt=m(e),Je=i(e,"OL",{});var et=c(Je);Ze=i(et,"LI",{});var st=c(Ze);ia=l(st,"Make four copies of the "),nt=i(st,"CODE",{});var Ol=c(nt);ca=l(Ol,"sent1"),Ol.forEach(s),ha=l(st," field and combine each of them with "),rt=i(st,"CODE",{});var Sl=c(rt);ua=l(Sl,"sent2"),Sl.forEach(s),fa=l(st," to recreate how a sentence starts."),st.forEach(s),ma=m(et),Ts=i(et,"LI",{});var ea=c(Ts);da=l(ea,"Combine "),ot=i(ea,"CODE",{});var Hl=c(ot);_a=l(Hl,"sent2"),Hl.forEach(s),ga=l(ea," with each of the four possible sentence endings."),ea.forEach(s),$a=m(et),Ne=i(et,"LI",{});var ws=c(Ne);ja=l(ws,"Flatten these two lists so you can tokenize them, and then unflatten them afterward so each example has a corresponding "),pt=i(ws,"CODE",{});var Ll=c(pt);wa=l(Ll,"input_ids"),Ll.forEach(s),ka=l(ws,", "),it=i(ws,"CODE",{});var Il=c(it);ba=l(Il,"attention_mask"),Il.forEach(s),ya=l(ws,", and "),ct=i(ws,"CODE",{});var Bl=c(ct);va=l(Bl,"labels"),Bl.forEach(s),Ea=l(ws," field."),ws.forEach(s),et.forEach(s),qt=m(e),E(zs.$$.fragment,e),Ct=m(e),Me=i(e,"P",{});var ks=c(Me);Ta=l(ks,"To apply the preprocessing function over the entire dataset, use \u{1F917} Datasets "),xs=i(ks,"A",{href:!0,rel:!0});var Nl=c(xs);za=l(Nl,"map"),Nl.forEach(s),xa=l(ks," method. You can speed up the "),ht=i(ks,"CODE",{});var Wl=c(ht);qa=l(Wl,"map"),Wl.forEach(s),Ca=l(ks," function by setting "),ut=i(ks,"CODE",{});var Gl=c(ut);Aa=l(Gl,"batched=True"),Gl.forEach(s),Pa=l(ks," to process multiple elements of the dataset at once:"),ks.forEach(s),At=m(e),E(qs.$$.fragment,e),Pt=m(e),Qe=i(e,"P",{});var tt=c(Qe);Ma=l(tt,"\u{1F917} Transformers doesn\u2019t have a data collator for multiple choice, so you\u2019ll need to adapt the "),Qs=i(tt,"A",{href:!0});var Ul=c(Qs);Fa=l(Ul,"DataCollatorWithPadding"),Ul.forEach(s),Da=l(tt," to create a batch of examples. It\u2019s more efficient to "),ft=i(tt,"EM",{});var Yl=c(ft);Oa=l(Yl,"dynamically pad"),Yl.forEach(s),Sa=l(tt," the sentences to the longest length in a batch during collation, instead of padding the whole dataset to the maximium length."),tt.forEach(s),Mt=m(e),Cs=i(e,"P",{});var il=c(Cs);mt=i(il,"CODE",{});var Kl=c(mt);Ha=l(Kl,"DataCollatorForMultipleChoice"),Kl.forEach(s),La=l(il," flattens all the model inputs, applies padding, and then unflattens the results:"),il.forEach(s),Ft=m(e),E(cs.$$.fragment,e),Dt=m(e),es=i(e,"H2",{class:!0});var sa=c(es);hs=i(sa,"A",{id:!0,class:!0,href:!0});var Rl=c(hs);dt=i(Rl,"SPAN",{});var Jl=c(dt);E(As.$$.fragment,Jl),Jl.forEach(s),Rl.forEach(s),Ia=m(sa),_t=i(sa,"SPAN",{});var Ql=c(_t);Ba=l(Ql,"Evaluate"),Ql.forEach(s),sa.forEach(s),Ot=m(e),Fe=i(e,"P",{});var bs=c(Fe);Na=l(bs,"Including a metric during training is often helpful for evaluating your model\u2019s performance. You can quickly load a evaluation method with the \u{1F917} "),Ps=i(bs,"A",{href:!0,rel:!0});var Vl=c(Ps);Wa=l(Vl,"Evaluate"),Vl.forEach(s),Ga=l(bs," library. For this task, load the "),Ms=i(bs,"A",{href:!0,rel:!0});var Xl=c(Ms);Ua=l(Xl,"accuracy"),Xl.forEach(s),Ya=l(bs," metric (see the \u{1F917} Evaluate "),Fs=i(bs,"A",{href:!0,rel:!0});var Zl=c(Fs);Ka=l(Zl,"quick tour"),Zl.forEach(s),Ra=l(bs," to learn more about how to load and compute a metric):"),bs.forEach(s),St=m(e),E(Ds.$$.fragment,e),Ht=m(e),us=i(e,"P",{});var ta=c(us);Ja=l(ta,"Then create a function that passes your predictions and labels to "),Os=i(ta,"A",{href:!0,rel:!0});var en=c(Os);Qa=l(en,"compute"),en.forEach(s),Va=l(ta," to calculate the accuracy:"),ta.forEach(s),Lt=m(e),E(Ss.$$.fragment,e),It=m(e),fs=i(e,"P",{});var aa=c(fs);Xa=l(aa,"Your "),gt=i(aa,"CODE",{});var sn=c(gt);Za=l(sn,"compute_metrics"),sn.forEach(s),el=l(aa," function is ready to go now, and you\u2019ll return to it when you setup your training."),aa.forEach(s),Bt=m(e),ss=i(e,"H2",{class:!0});var la=c(ss);ms=i(la,"A",{id:!0,class:!0,href:!0});var tn=c(ms);$t=i(tn,"SPAN",{});var an=c($t);E(Hs.$$.fragment,an),an.forEach(s),tn.forEach(s),sl=m(la),jt=i(la,"SPAN",{});var ln=c(jt);tl=l(ln,"Train"),ln.forEach(s),la.forEach(s),Nt=m(e),E(ds.$$.fragment,e),Wt=m(e),E(_s.$$.fragment,e),Gt=m(e),ts=i(e,"H2",{class:!0});var na=c(ts);gs=i(na,"A",{id:!0,class:!0,href:!0});var nn=c(gs);wt=i(nn,"SPAN",{});var rn=c(wt);E(Ls.$$.fragment,rn),rn.forEach(s),nn.forEach(s),al=m(na),kt=i(na,"SPAN",{});var on=c(kt);ll=l(on,"Inference"),on.forEach(s),na.forEach(s),Ut=m(e),Vs=i(e,"P",{});var pn=c(Vs);nl=l(pn,"Great, now that you\u2019ve finetuned a model, you can use it for inference!"),pn.forEach(s),Yt=m(e),Xs=i(e,"P",{});var cn=c(Xs);rl=l(cn,"Come up with some text and two candidate answers:"),cn.forEach(s),Kt=m(e),E(Is.$$.fragment,e),Rt=m(e),E($s.$$.fragment,e),this.h()},h(){j(r,"name","hf:doc:metadata"),j(r,"content",JSON.stringify(Pn)),j(d,"id","multiple-choice"),j(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(d,"href","#multiple-choice"),j(n,"class","relative group"),j(M,"href","https://huggingface.co/bert-base-uncased"),j(M,"rel","nofollow"),j(K,"href","https://huggingface.co/datasets/swag"),j(K,"rel","nofollow"),j(te,"id","load-swag-dataset"),j(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(te,"href","#load-swag-dataset"),j(se,"class","relative group"),j(Be,"id","preprocess"),j(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(Be,"href","#preprocess"),j(ke,"class","relative group"),j(xs,"href","https://huggingface.co/docs/datasets/v2.8.0/en/package_reference/main_classes#datasets.Dataset.map"),j(xs,"rel","nofollow"),j(Qs,"href","/docs/transformers/v4.26.0/en/main_classes/data_collator#transformers.DataCollatorWithPadding"),j(hs,"id","evaluate"),j(hs,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(hs,"href","#evaluate"),j(es,"class","relative group"),j(Ps,"href","https://huggingface.co/docs/evaluate/index"),j(Ps,"rel","nofollow"),j(Ms,"href","https://huggingface.co/spaces/evaluate-metric/accuracy"),j(Ms,"rel","nofollow"),j(Fs,"href","https://huggingface.co/docs/evaluate/a_quick_tour"),j(Fs,"rel","nofollow"),j(Os,"href","https://huggingface.co/docs/evaluate/v0.4.0/en/package_reference/main_classes#evaluate.EvaluationModule.compute"),j(Os,"rel","nofollow"),j(ms,"id","train"),j(ms,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(ms,"href","#train"),j(ss,"class","relative group"),j(gs,"id","inference"),j(gs,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(gs,"href","#inference"),j(ts,"class","relative group")},m(e,u){t(document.head,r),h(e,_,u),h(e,n,u),t(n,d),t(d,w),T(b,w,null),t(n,A),t(n,P),t(P,C),h(e,F,u),h(e,D,u),t(D,I),h(e,W,u),h(e,G,u),t(G,U),h(e,J,u),h(e,S,u),t(S,L),t(L,k),t(L,M),t(M,Q),t(L,g),t(L,O),t(O,Y),t(L,oe),t(L,K),t(K,pe),t(L,De),t(S,be),t(S,ge),t(ge,fe),h(e,ye,u),h(e,R,u),t(R,Oe),h(e,le,u),T(me,e,u),h(e,xe,u),h(e,ie,u),t(ie,V),h(e,ve,u),T(X,e,u),h(e,qe,u),h(e,se,u),t(se,te),t(te,Ee),T(ce,Ee,null),t(se,he),t(se,ne),t(ne,$),h(e,H,u),h(e,Z,u),t(Z,ee),t(Z,Ce),t(Ce,We),t(Z,Se),h(e,de,u),T(ae,e,u),h(e,$e,u),h(e,Te,u),t(Te,ze),h(e,_e,u),T(re,e,u),h(e,ue,u),h(e,Ge,u),t(Ge,He),h(e,Ue,u),h(e,je,u),t(je,we),t(we,Ye),t(Ye,Le),t(we,as),t(we,Ae),t(Ae,ys),t(we,ls),t(we,o),t(o,y),t(we,Ve),t(je,Ke),t(je,Xe),t(Xe,ns),t(ns,rs),t(Xe,Ws),t(je,Gs),t(je,Ie),t(Ie,os),t(os,Re),t(Ie,Us),h(e,vs,u),h(e,ke,u),t(ke,Be),t(Be,ps),T(Pe,ps,null),t(ke,Ys),t(ke,is),t(is,Ks),h(e,Et,u),h(e,Rs,u),t(Rs,oa),h(e,Tt,u),T(Es,e,u),h(e,zt,u),h(e,Js,u),t(Js,pa),h(e,xt,u),h(e,Je,u),t(Je,Ze),t(Ze,ia),t(Ze,nt),t(nt,ca),t(Ze,ha),t(Ze,rt),t(rt,ua),t(Ze,fa),t(Je,ma),t(Je,Ts),t(Ts,da),t(Ts,ot),t(ot,_a),t(Ts,ga),t(Je,$a),t(Je,Ne),t(Ne,ja),t(Ne,pt),t(pt,wa),t(Ne,ka),t(Ne,it),t(it,ba),t(Ne,ya),t(Ne,ct),t(ct,va),t(Ne,Ea),h(e,qt,u),T(zs,e,u),h(e,Ct,u),h(e,Me,u),t(Me,Ta),t(Me,xs),t(xs,za),t(Me,xa),t(Me,ht),t(ht,qa),t(Me,Ca),t(Me,ut),t(ut,Aa),t(Me,Pa),h(e,At,u),T(qs,e,u),h(e,Pt,u),h(e,Qe,u),t(Qe,Ma),t(Qe,Qs),t(Qs,Fa),t(Qe,Da),t(Qe,ft),t(ft,Oa),t(Qe,Sa),h(e,Mt,u),h(e,Cs,u),t(Cs,mt),t(mt,Ha),t(Cs,La),h(e,Ft,u),T(cs,e,u),h(e,Dt,u),h(e,es,u),t(es,hs),t(hs,dt),T(As,dt,null),t(es,Ia),t(es,_t),t(_t,Ba),h(e,Ot,u),h(e,Fe,u),t(Fe,Na),t(Fe,Ps),t(Ps,Wa),t(Fe,Ga),t(Fe,Ms),t(Ms,Ua),t(Fe,Ya),t(Fe,Fs),t(Fs,Ka),t(Fe,Ra),h(e,St,u),T(Ds,e,u),h(e,Ht,u),h(e,us,u),t(us,Ja),t(us,Os),t(Os,Qa),t(us,Va),h(e,Lt,u),T(Ss,e,u),h(e,It,u),h(e,fs,u),t(fs,Xa),t(fs,gt),t(gt,Za),t(fs,el),h(e,Bt,u),h(e,ss,u),t(ss,ms),t(ms,$t),T(Hs,$t,null),t(ss,sl),t(ss,jt),t(jt,tl),h(e,Nt,u),T(ds,e,u),h(e,Wt,u),T(_s,e,u),h(e,Gt,u),h(e,ts,u),t(ts,gs),t(gs,wt),T(Ls,wt,null),t(ts,al),t(ts,kt),t(kt,ll),h(e,Ut,u),h(e,Vs,u),t(Vs,nl),h(e,Yt,u),h(e,Xs,u),t(Xs,rl),h(e,Kt,u),T(Is,e,u),h(e,Rt,u),T($s,e,u),Jt=!0},p(e,[u]){const Bs={};u&2&&(Bs.$$scope={dirty:u,ctx:e}),cs.$set(Bs);const bt={};u&2&&(bt.$$scope={dirty:u,ctx:e}),ds.$set(bt);const yt={};u&2&&(yt.$$scope={dirty:u,ctx:e}),_s.$set(yt);const vt={};u&2&&(vt.$$scope={dirty:u,ctx:e}),$s.$set(vt)},i(e){Jt||(z(b.$$.fragment,e),z(me.$$.fragment,e),z(X.$$.fragment,e),z(ce.$$.fragment,e),z(ae.$$.fragment,e),z(re.$$.fragment,e),z(Pe.$$.fragment,e),z(Es.$$.fragment,e),z(zs.$$.fragment,e),z(qs.$$.fragment,e),z(cs.$$.fragment,e),z(As.$$.fragment,e),z(Ds.$$.fragment,e),z(Ss.$$.fragment,e),z(Hs.$$.fragment,e),z(ds.$$.fragment,e),z(_s.$$.fragment,e),z(Ls.$$.fragment,e),z(Is.$$.fragment,e),z($s.$$.fragment,e),Jt=!0)},o(e){x(b.$$.fragment,e),x(me.$$.fragment,e),x(X.$$.fragment,e),x(ce.$$.fragment,e),x(ae.$$.fragment,e),x(re.$$.fragment,e),x(Pe.$$.fragment,e),x(Es.$$.fragment,e),x(zs.$$.fragment,e),x(qs.$$.fragment,e),x(cs.$$.fragment,e),x(As.$$.fragment,e),x(Ds.$$.fragment,e),x(Ss.$$.fragment,e),x(Hs.$$.fragment,e),x(ds.$$.fragment,e),x(_s.$$.fragment,e),x(Ls.$$.fragment,e),x(Is.$$.fragment,e),x($s.$$.fragment,e),Jt=!1},d(e){s(r),e&&s(_),e&&s(n),q(b),e&&s(F),e&&s(D),e&&s(W),e&&s(G),e&&s(J),e&&s(S),e&&s(ye),e&&s(R),e&&s(le),q(me,e),e&&s(xe),e&&s(ie),e&&s(ve),q(X,e),e&&s(qe),e&&s(se),q(ce),e&&s(H),e&&s(Z),e&&s(de),q(ae,e),e&&s($e),e&&s(Te),e&&s(_e),q(re,e),e&&s(ue),e&&s(Ge),e&&s(Ue),e&&s(je),e&&s(vs),e&&s(ke),q(Pe),e&&s(Et),e&&s(Rs),e&&s(Tt),q(Es,e),e&&s(zt),e&&s(Js),e&&s(xt),e&&s(Je),e&&s(qt),q(zs,e),e&&s(Ct),e&&s(Me),e&&s(At),q(qs,e),e&&s(Pt),e&&s(Qe),e&&s(Mt),e&&s(Cs),e&&s(Ft),q(cs,e),e&&s(Dt),e&&s(es),q(As),e&&s(Ot),e&&s(Fe),e&&s(St),q(Ds,e),e&&s(Ht),e&&s(us),e&&s(Lt),q(Ss,e),e&&s(It),e&&s(fs),e&&s(Bt),e&&s(ss),q(Hs),e&&s(Nt),q(ds,e),e&&s(Wt),q(_s,e),e&&s(Gt),e&&s(ts),q(Ls),e&&s(Ut),e&&s(Vs),e&&s(Yt),e&&s(Xs),e&&s(Kt),q(Is,e),e&&s(Rt),q($s,e)}}}const Pn={local:"multiple-choice",sections:[{local:"load-swag-dataset",title:"Load SWAG dataset"},{local:"preprocess",title:"Preprocess"},{local:"evaluate",title:"Evaluate"},{local:"train",title:"Train"},{local:"inference",title:"Inference"}],title:"Multiple choice"};function Mn(B){return dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ln extends hn{constructor(r){super();un(this,r,Mn,An,fn,{})}}export{Ln as default,Pn as metadata};
