import{s as Ls,o as Ws,n as nn}from"../chunks/scheduler.9bc65507.js";import{S as Ps,i as Gs,g as s,s as a,r as d,A as Ys,h as r,f as n,c as l,j as zs,u as m,x as o,k as As,y as Rs,a as i,v as c,d as f,t as h,w as u}from"../chunks/index.707bf1b6.js";import{H as w,g as Is}from"../chunks/Heading.98cce615.js";import{T as tn}from"../chunks/Tip.c2ecdbf4.js";import{C as v}from"../chunks/CodeBlock.54a9f38d.js";function Zs(T){let p,b='If you have access to a machine with multiple GPUs, these approaches are still valid, plus you can leverage additional methods outlined in the <a href="perf_train_gpu_many">multi-GPU section</a>.';return{c(){p=s("p"),p.innerHTML=b},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-198lgun"&&(p.innerHTML=b)},m(g,y){i(g,p,y)},p:nn,d(g){g&&n(p)}}}function Fs(T){let p,b=`Note: when using mixed precision with a small model and a large batch size, there will be some memory savings but with a
large model and a small batch size, the memory use will be larger.`;return{c(){p=s("p"),p.textContent=b},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-e8wqm0"&&(p.textContent=b)},m(g,y){i(g,p,y)},p:nn,d(g){g&&n(p)}}}function Bs(T){let p,b="While gradient checkpointing may improve memory efficiency, it slows training by approximately 20%.";return{c(){p=s("p"),p.textContent=b},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1rw5pua"&&(p.textContent=b)},m(g,y){i(g,p,y)},p:nn,d(g){g&&n(p)}}}function Xs(T){let p,b="tf32 can’t be accessed directly via <code>tensor.to(dtype=torch.tf32)</code> because it is an internal CUDA data type. You need <code>torch&gt;=1.7</code> to use tf32 data types.";return{c(){p=s("p"),p.innerHTML=b},l(g){p=r(g,"P",{"data-svelte-h":!0}),o(p)!=="svelte-lagf4l"&&(p.innerHTML=b)},m(g,y){i(g,p,y)},p:nn,d(g){g&&n(p)}}}function qs(T){let p,b="The PyTorch-native <code>scaled_dot_product_attention</code> operator can only dispatch to Flash Attention if no <code>attention_mask</code> is provided.",g,y,$="By default, in training mode, the BetterTransformer integration <strong>drops the mask support and can only be used for training that does not require a padding mask for batched training</strong>. This is the case, for example, during masked language modeling or causal language modeling. BetterTransformer is not suited for fine-tuning models on tasks that require a padding mask.";return{c(){p=s("p"),p.innerHTML=b,g=a(),y=s("p"),y.innerHTML=$},l(M){p=r(M,"P",{"data-svelte-h":!0}),o(p)!=="svelte-3mpetc"&&(p.innerHTML=b),g=l(M),y=r(M,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1sd6oaz"&&(y.innerHTML=$)},m(M,_){i(M,p,_),i(M,g,_),i(M,y,_)},p:nn,d(M){M&&(n(p),n(g),n(y))}}}function Es(T){let p,b,g,y,$,M,_,Wa=`This guide demonstrates practical techniques that you can use to increase the efficiency of your model’s training by
optimizing memory utilization, speeding up the training, or both. If you’d like to understand how GPU is utilized during
training, please refer to the <a href="model_memory_anatomy">Model training anatomy</a> conceptual guide first. This guide
focuses on practical techniques.`,an,x,ln,j,Pa="When training large models, there are two aspects that should be considered at the same time:",sn,H,Ga="<li>Data throughput/training time</li> <li>Model performance</li>",rn,z,Ya=`Maximizing the throughput (samples/second) leads to lower training cost. This is generally achieved by utilizing the GPU
as much as possible and thus filling GPU memory to its limit. If the desired batch size exceeds the limits of the GPU memory,
the memory optimization techniques, such as gradient accumulation, can help.`,on,A,Ra=`However, if the preferred batch size fits into memory, there’s no reason to apply memory-optimizing techniques because they can
slow down the training. Just because one can use a large batch size, does not necessarily mean they should. As part of
hyperparameter tuning, you should determine which batch size yields the best results and then optimize resources accordingly.`,pn,L,Ia="The methods and tools covered in this guide can be classified based on the effect they have on the training process:",dn,W,Za='<thead><tr><th align="left">Method/tool</th> <th align="left">Improves training speed</th> <th align="left">Optimizes memory utilization</th></tr></thead> <tbody><tr><td align="left"><a href="#batch-size-choice">Batch size choice</a></td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#gradient-accumulation">Gradient accumulation</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#gradient-checkpointing">Gradient checkpointing</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#mixed-precision-training">Mixed precision training</a></td> <td align="left">Yes</td> <td align="left">(No)</td></tr> <tr><td align="left"><a href="#optimizer-choice">Optimizer choice</a></td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#data-preloading">Data preloading</a></td> <td align="left">Yes</td> <td align="left">No</td></tr> <tr><td align="left"><a href="#deepspeed-zero">DeepSpeed Zero</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#using-torchcompile">torch.compile</a></td> <td align="left">Yes</td> <td align="left">No</td></tr></tbody>',mn,C,cn,P,Fa=`You can combine the above methods to get a cumulative effect. These techniques are available to you whether you are
training your model with <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> or writing a pure PyTorch loop, in which case you can <a href="#using-accelerate">configure these optimizations
with 🤗 Accelerate</a>.`,fn,G,Ba="If these methods do not result in sufficient gains, you can explore the following options:",hn,Y,Xa='<li><a href="#efficient-software-prebuilds">Look into building your own custom Docker container with efficient softare prebuilds</a></li> <li><a href="#mixture-of-experts">Consider a model that uses Mixture of Experts (MoE)</a></li> <li><a href="#using-pytorch-native-attention">Convert your model to BetterTransformer to leverage PyTorch native attention</a></li>',un,R,qa=`Finally, if all of the above is still not enough, even after switching to a server-grade GPU like A100, consider moving
to a multi-GPU setup. All these approaches are still valid in a multi-GPU setup, plus you can leverage additional parallelism
techniques outlined in the <a href="perf_train_gpu_many">multi-GPU section</a>.`,gn,I,yn,Z,Ea=`To achieve optimal performance, start by identifying the appropriate batch size. It is recommended to use batch sizes and
input/output neuron counts that are of size 2^N. Often it’s a multiple of 8, but it can be
higher depending on the hardware being used and the model’s dtype.`,wn,F,Va=`For reference, check out NVIDIA’s recommendation for <a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-fully-connected/index.html#input-features" rel="nofollow">input/output neuron counts</a> and
<a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-fully-connected/index.html#batch-size" rel="nofollow">batch size</a> for
fully connected layers (which are involved in GEMMs (General Matrix Multiplications)).`,bn,B,Na=`<a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-matrix-multiplication/index.html#requirements-tc" rel="nofollow">Tensor Core Requirements</a>
define the multiplier based on the dtype and the hardware. For instance, for fp16 data type a multiple of 8 is recommended, unless
it’s an A100 GPU, in which case use multiples of 64.`,Mn,X,Da=`For parameters that are small, consider also <a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-matrix-multiplication/index.html#dim-quantization" rel="nofollow">Dimension Quantization Effects</a>.
This is where tiling happens and the right multiplier can have a significant speedup.`,vn,q,Tn,E,Sa=`The <strong>gradient accumulation</strong> method aims to calculate gradients in smaller increments instead of computing them for the
entire batch at once. This approach involves iteratively calculating gradients in smaller batches by performing forward
and backward passes through the model and accumulating the gradients during the process. Once a sufficient number of
gradients have been accumulated, the model’s optimization step is executed. By employing gradient accumulation, it
becomes possible to increase the <strong>effective batch size</strong> beyond the limitations imposed by the GPU’s memory capacity.
However, it is important to note that the additional forward and backward passes introduced by gradient accumulation can
slow down the training process.`,_n,V,Qa='You can enable gradient accumulation by adding the <code>gradient_accumulation_steps</code> argument to  <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',$n,N,xn,D,Ka="In the above example, your effective batch size becomes 4.",Cn,S,Oa=`Alternatively, use 🤗 Accelerate to gain full control over the training loop. Find the 🤗 Accelerate example
<a href="#using-accelerate">further down in this guide</a>.`,Jn,Q,el=`While it is advised to max out GPU usage as much as possible, a high number of gradient accumulation steps can
result in a more pronounced training slowdown. Consider the following example. Let’s say, the <code>per_device_train_batch_size=4</code>
without gradient accumulation hits the GPU’s limit. If you would like to train with batches of size 64, do not set the
<code>per_device_train_batch_size</code> to 1 and <code>gradient_accumulation_steps</code> to 64. Instead, keep <code>per_device_train_batch_size=4</code>
and set <code>gradient_accumulation_steps=16</code>. This results in the same effective batch size while making better use of
the available GPU resources.`,Un,K,tl=`For additional information, please refer to batch size and gradient accumulation benchmarks for <a href="https://github.com/huggingface/transformers/issues/14608#issuecomment-1004392537" rel="nofollow">RTX-3090</a>
and <a href="https://github.com/huggingface/transformers/issues/15026#issuecomment-1005033957" rel="nofollow">A100</a>.`,kn,O,jn,ee,nl=`Some large models may still face memory issues even when the batch size is set to 1 and gradient accumulation is used.
This is because there are other components that also require memory storage.`,Hn,te,il=`Saving all activations from the forward pass in order to compute the gradients during the backward pass can result in
significant memory overhead. The alternative approach of discarding the activations and recalculating them when needed
during the backward pass, would introduce a considerable computational overhead and slow down the training process.`,zn,ne,al=`<strong>Gradient checkpointing</strong> offers a compromise between these two approaches and saves strategically selected activations
throughout the computational graph so only a fraction of the activations need to be re-computed for the gradients. For
an in-depth explanation of gradient checkpointing, refer to <a href="https://medium.com/tensorflow/fitting-larger-networks-into-memory-583e3c758ff9" rel="nofollow">this great article</a>.`,An,ie,ll='To enable gradient checkpointing in the <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.Trainer">Trainer</a>, pass the corresponding a flag to <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Ln,ae,Wn,le,sl='Alternatively, use 🤗 Accelerate - find the 🤗 Accelerate example <a href="#using-accelerate">further in this guide</a>.',Pn,J,Gn,se,Yn,re,rl=`<strong>Mixed precision training</strong> is a technique that aims to optimize the computational efficiency of training models by
utilizing lower-precision numerical formats for certain variables. Traditionally, most models use 32-bit floating point
precision (fp32 or float32) to represent and process variables. However, not all variables require this high precision
level to achieve accurate results. By reducing the precision of certain variables to lower numerical formats like 16-bit
floating point (fp16 or float16), we can speed up the computations. Because in this approach some computations are performed
in half-precision, while some are still in full precision, the approach is called mixed precision training.`,Rn,oe,ol=`Most commonly mixed precision training is achieved by using fp16 (float16) data types, however, some GPU architectures
(such as the Ampere architecture) offer bf16 and tf32 (CUDA internal data type) data types. Check
out the <a href="https://developer.nvidia.com/blog/accelerating-ai-training-with-tf32-tensor-cores/" rel="nofollow">NVIDIA Blog</a> to learn more about
the differences between these data types.`,In,pe,Zn,de,pl=`The main advantage of mixed precision training comes from saving the activations in half precision (fp16).
Although the gradients are also computed in half precision they are converted back to full precision for the optimization
step so no memory is saved here.
While mixed precision training results in faster computations, it can also lead to more GPU memory being utilized, especially for small batch sizes.
This is because the model is now present on the GPU in both 16-bit and 32-bit precision (1.5x the original model on the GPU).`,Fn,me,dl="To enable mixed precision training, set the <code>fp16</code> flag to <code>True</code>:",Bn,ce,Xn,fe,ml='If you prefer to use 🤗 Accelerate, find the 🤗 Accelerate example <a href="#using-accelerate">further in this guide</a>.',qn,he,En,ue,cl=`If you have access to an Ampere or newer hardware you can use bf16 for mixed precision training and evaluation. While
bf16 has a worse precision than fp16, it has a much bigger dynamic range. In fp16 the biggest number you can have
is <code>65535</code> and any number above that will result in an overflow. A bf16 number can be as large as <code>3.39e+38</code> (!) which
is about the same as fp32 - because both have 8-bits used for the numerical range.`,Vn,ge,fl="You can enable BF16 in the 🤗 Trainer with:",Nn,ye,Dn,we,Sn,be,hl=`The Ampere hardware uses a magical data type called tf32. It has the same numerical range as fp32 (8-bits), but instead
of 23 bits precision it has only 10 bits (same as fp16) and uses only 19 bits in total. It’s “magical” in the sense that
you can use the normal fp32 training and/or inference code and by enabling tf32 support you can get up to 3x throughput
improvement. All you need to do is to add the following to your code:`,Qn,Me,Kn,ve,ul="CUDA will automatically switch to using tf32 instead of fp32 where possible, assuming that the used GPU is from the Ampere series.",On,Te,gl=`According to <a href="https://developer.nvidia.com/blog/accelerating-ai-training-with-tf32-tensor-cores/" rel="nofollow">NVIDIA research</a>, the
majority of machine learning training workloads show the same perplexity and convergence with tf32 training as with fp32.
If you’re already using fp16 or bf16 mixed precision it may help with the throughput as well.`,ei,_e,yl="You can enable this mode in the 🤗 Trainer:",ti,$e,ni,U,ii,xe,wl=`For additional information on tf32 vs other precisions, please refer to the following benchmarks:
<a href="https://github.com/huggingface/transformers/issues/14608#issuecomment-1004390803" rel="nofollow">RTX-3090</a> and
<a href="https://github.com/huggingface/transformers/issues/15026#issuecomment-1004543189" rel="nofollow">A100</a>.`,ai,Ce,li,Je,bl='You can speedup the training throughput by using Flash Attention 2 integration in transformers. Check out the appropriate section in the <a href="./perf_infer_gpu_one#Flash-Attention-2">single GPU section</a> to learn more about how to load a model with Flash Attention 2 modules.',si,Ue,ri,ke,Ml=`The most common optimizer used to train transformer models is Adam or AdamW (Adam with weight decay). Adam achieves
good convergence by storing the rolling average of the previous gradients; however, it adds an additional memory
footprint of the order of the number of model parameters. To remedy this, you can use an alternative optimizer.
For example if you have <a href="https://github.com/NVIDIA/apex" rel="nofollow">NVIDIA/apex</a> installed, <code>adamw_apex_fused</code> will give you the
fastest training experience among all supported AdamW optimizers.`,oi,je,vl=`<a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.Trainer">Trainer</a> integrates a variety of optimizers that can be used out of box: <code>adamw_hf</code>, <code>adamw_torch</code>, <code>adamw_torch_fused</code>,
<code>adamw_apex_fused</code>, <code>adamw_anyprecision</code>, <code>adafactor</code>, or <code>adamw_bnb_8bit</code>. More optimizers can be plugged in via a third-party implementation.`,pi,He,Tl="Let’s take a closer look at two alternatives to AdamW optimizer:",di,ze,_l='<li><code>adafactor</code> which is available in <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.Trainer">Trainer</a></li> <li><code>adamw_bnb_8bit</code> is also available in Trainer, but a third-party integration is provided below for demonstration.</li>',mi,Ae,$l="For comparison, for a 3B-parameter model, like “t5-3b”:",ci,Le,xl="<li>A standard AdamW optimizer will need 24GB of GPU memory because it uses 8 bytes for each parameter (8*3 =&gt; 24GB)</li> <li>Adafactor optimizer will need more than 12GB. It uses slightly more than 4 bytes for each parameter, so 4*3 and then some extra.</li> <li>8bit BNB quantized optimizer will use only (2*3) 6GB if all optimizer states are quantized.</li>",fi,We,hi,Pe,Cl=`Adafactor doesn’t store rolling averages for each element in weight matrices. Instead, it keeps aggregated information
(sums of rolling averages row- and column-wise), significantly reducing its footprint. However, compared to Adam,
Adafactor may have slower convergence in certain cases.`,ui,Ge,Jl='You can switch to Adafactor by setting <code>optim=&quot;adafactor&quot;</code> in <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',gi,Ye,yi,Re,Ul=`Combined with other approaches (gradient accumulation, gradient checkpointing, and mixed precision training)
you can notice up to 3x improvement while maintaining the throughput! However, as mentioned before, the convergence of
Adafactor can be worse than Adam.`,wi,Ie,bi,Ze,kl=`Instead of aggregating optimizer states like Adafactor, 8-bit Adam keeps the full state and quantizes it. Quantization
means that it stores the state with lower precision and dequantizes it only for the optimization. This is similar to the
idea behind mixed precision training.`,Mi,Fe,jl='To use <code>adamw_bnb_8bit</code>, you simply need to set <code>optim=&quot;adamw_bnb_8bit&quot;</code> in <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',vi,Be,Ti,Xe,Hl="However, we can also use a third-party implementation of the 8-bit optimizer for demonstration purposes to see how that can be integrated.",_i,qe,zl=`First, follow the installation guide in the GitHub <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">repo</a> to install the <code>bitsandbytes</code> library
that implements the 8-bit Adam optimizer.`,$i,Ee,Al="Next you need to initialize the optimizer. This involves two steps:",xi,Ve,Ll="<li>First, group the model’s parameters into two groups - one where weight decay should be applied, and the other one where it should not. Usually, biases and layer norm parameters are not weight decayed.</li> <li>Then do some argument housekeeping to use the same parameters as the previously used AdamW optimizer.</li>",Ci,Ne,Ji,De,Wl="Finally, pass the custom optimizer as an argument to the <code>Trainer</code>:",Ui,Se,ki,Qe,Pl=`Combined with other approaches (gradient accumulation, gradient checkpointing, and mixed precision training),
you can expect to get about a 3x memory improvement and even slightly higher throughput as using Adafactor.`,ji,Ke,Hi,Oe,Gl=`pytorch-nightly introduced <code>torch.optim._multi_tensor</code> which should significantly speed up the optimizers for situations
with lots of small feature tensors. It should eventually become the default, but if you want to experiment with it sooner, take a look at this GitHub <a href="https://github.com/huggingface/transformers/issues/9965" rel="nofollow">issue</a>.`,zi,et,Ai,tt,Yl=`One of the important requirements to reach great training speed is the ability to feed the GPU at the maximum speed it
can handle. By default, everything happens in the main process, and it might not be able to read the data from disk fast
enough, and thus create a bottleneck, leading to GPU under-utilization. Configure the following arguments to reduce the bottleneck:`,Li,nt,Rl="<li><code>DataLoader(pin_memory=True, ...)</code> - ensures the data gets preloaded into the pinned memory on CPU and typically leads to much faster transfers from CPU to GPU memory.</li> <li><code>DataLoader(num_workers=4, ...)</code> - spawn several workers to preload data faster. During training, watch the GPU utilization stats; if it’s far from 100%, experiment with increasing the number of workers. Of course, the problem could be elsewhere, so many workers won’t necessarily lead to better performance.</li>",Wi,it,Il='When using <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.Trainer">Trainer</a>, the corresponding <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> are: <code>dataloader_pin_memory</code> (<code>True</code> by default), and <code>dataloader_num_workers</code> (defaults to <code>0</code>).',Pi,at,Gi,lt,Zl=`DeepSpeed is an open-source deep learning optimization library that is integrated with 🤗 Transformers and 🤗 Accelerate.
It provides a wide range of features and optimizations designed to improve the efficiency and scalability of large-scale
deep learning training.`,Yi,st,Fl=`If your model fits onto a single GPU and you have enough space to fit a small batch size, you don’t need to use DeepSpeed
as it’ll only slow things down. However, if the model doesn’t fit onto a single GPU or you can’t fit a small batch, you can
leverage DeepSpeed ZeRO + CPU Offload, or NVMe Offload for much larger models. In this case, you need to separately
<a href="main_classes/deepspeed#installation">install the library</a>, then follow one of the guides to create a configuration file
and launch DeepSpeed:`,Ri,rt,Bl=`<li>For an in-depth guide on DeepSpeed integration with <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.Trainer">Trainer</a>, review <a href="main_classes/deepspeed">the corresponding documentation</a>, specifically the
<a href="main_classes/deepspeed#deployment-with-one-gpu">section for a single GPU</a>. Some adjustments are required to use DeepSpeed in a notebook; please take a look at the <a href="main_classes/deepspeed#deployment-in-notebooks">corresponding guide</a>.</li> <li>If you prefer to use 🤗 Accelerate, refer to <a href="https://huggingface.co/docs/accelerate/en/usage_guides/deepspeed" rel="nofollow">🤗 Accelerate DeepSpeed guide</a>.</li>`,Ii,ot,Zi,pt,Xl=`PyTorch 2.0 introduced a new compile function that doesn’t require any modification to existing PyTorch code but can
optimize your code by adding a single line of code: <code>model = torch.compile(model)</code>.`,Fi,dt,ql='If using <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.Trainer">Trainer</a>, you only need <code>to</code> pass the <code>torch_compile</code> option in the <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Bi,mt,Xi,ct,El=`<code>torch.compile</code> uses Python’s frame evaluation API to automatically create a graph from existing PyTorch programs. After
capturing the graph, different backends can be deployed to lower the graph to an optimized engine.
You can find more details and benchmarks in <a href="https://pytorch.org/get-started/pytorch-2.0/" rel="nofollow">PyTorch documentation</a>.`,qi,ft,Vl="<code>torch.compile</code> has a growing list of backends, which can be found in by calling <code>torchdynamo.list_backends()</code>, each of which with its optional dependencies.",Ei,ht,Nl='Choose which backend to use by specifying it via <code>torch_compile_backend</code> in the <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.  Some of the most commonly used backends are:',Vi,ut,Dl="<strong>Debugging backends</strong>:",Ni,gt,Sl="<li><code>dynamo.optimize(&quot;eager&quot;)</code> - Uses PyTorch to run the extracted GraphModule. This is quite useful in debugging TorchDynamo issues.</li> <li><code>dynamo.optimize(&quot;aot_eager&quot;)</code> - Uses AotAutograd with no compiler, i.e, just using PyTorch eager for the AotAutograd’s extracted forward and backward graphs. This is useful for debugging, and unlikely to give speedups.</li>",Di,yt,Ql="<strong>Training &amp; inference backends</strong>:",Si,wt,Kl='<li><code>dynamo.optimize(&quot;inductor&quot;)</code> - Uses TorchInductor backend with AotAutograd and cudagraphs by leveraging codegened Triton kernels  <a href="https://dev-discuss.pytorch.org/t/torchinductor-a-pytorch-native-compiler-with-define-by-run-ir-and-symbolic-shapes/747" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;nvfuser&quot;)</code> -  nvFuser with TorchScript. <a href="https://dev-discuss.pytorch.org/t/tracing-with-primitives-update-1-nvfuser-and-its-primitives/593" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;aot_nvfuser&quot;)</code> -  nvFuser with AotAutograd. <a href="https://dev-discuss.pytorch.org/t/tracing-with-primitives-update-1-nvfuser-and-its-primitives/593" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;aot_cudagraphs&quot;)</code> - cudagraphs with AotAutograd. <a href="https://github.com/pytorch/torchdynamo/pull/757" rel="nofollow">Read more</a></li>',Qi,bt,Ol="<strong>Inference-only backend</strong>s:",Ki,Mt,es='<li><code>dynamo.optimize(&quot;ofi&quot;)</code> -  Uses Torchscript optimize_for_inference.  <a href="https://pytorch.org/docs/stable/generated/torch.jit.optimize_for_inference.html" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;fx2trt&quot;)</code> -  Uses Nvidia TensorRT for inference optimizations.  <a href="https://github.com/pytorch/TensorRT/blob/master/docsrc/tutorials/getting_started_with_fx_path.rst" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;onnxrt&quot;)</code> -  Uses ONNXRT for inference on CPU/GPU.  <a href="https://onnxruntime.ai/" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;ipex&quot;)</code> -  Uses IPEX for inference on CPU.  <a href="https://github.com/intel/intel-extension-for-pytorch" rel="nofollow">Read more</a></li>',Oi,vt,ts='For an example of using <code>torch.compile</code> with 🤗 Transformers, check out this <a href="https://www.philschmid.de/getting-started-pytorch-2-0-transformers" rel="nofollow">blog post on fine-tuning a BERT model for Text Classification using the newest PyTorch 2.0 features</a>',ea,Tt,ta,_t,ns=`With <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate</a> you can use the above methods while gaining full
control over the training loop and can essentially write the loop in pure PyTorch with some minor modifications.`,na,$t,is='Suppose you have combined the methods in the <a href="/docs/transformers/v4.35.1/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> like so:',ia,xt,aa,Ct,as="The full example training loop with 🤗 Accelerate is only a handful of lines of code long:",la,Jt,sa,Ut,ls=`First we wrap the dataset in a <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>.
Then we can enable gradient checkpointing by calling the model’s <a href="/docs/transformers/v4.35.1/en/main_classes/model#transformers.PreTrainedModel.gradient_checkpointing_enable">gradient_checkpointing_enable()</a> method.
When we initialize the <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator" rel="nofollow"><code>Accelerator</code></a>
we can specify if we want to use mixed precision training and it will take care of it for us in the <code>prepare</code> call.
During the <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow"><code>prepare</code></a>
call the dataloader will also be distributed across workers should we use multiple GPUs. We use the same <a href="#8-bit-adam">8-bit optimizer</a> from the earlier example.`,ra,kt,ss=`Finally, we can add the main training loop. Note that the <code>backward</code> call is handled by 🤗 Accelerate. We can also see
how gradient accumulation works: we normalize the loss, so we get the average at the end of accumulation and once we have
enough steps we run the optimization.`,oa,jt,rs=`Implementing these optimization techniques with 🤗 Accelerate only takes a handful of lines of code and comes with the
benefit of more flexibility in the training loop. For a full documentation of all features have a look at the
<a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate documentation</a>.`,pa,Ht,da,zt,os=`PyTorch’s <a href="https://pytorch.org/get-started/locally/#start-locally" rel="nofollow">pip and conda builds</a> come prebuilt with the cuda toolkit
which is enough to run PyTorch, but it is insufficient if you need to build cuda extensions.`,ma,At,ps=`At times, additional efforts may be required to pre-build some components. For instance, if you’re using libraries like <code>apex</code> that
don’t come pre-compiled. In other situations figuring out how to install the right cuda toolkit system-wide can be complicated.
To address these scenarios PyTorch and NVIDIA released a new version of NGC docker container which already comes with
everything prebuilt. You just need to install your programs on it, and it will run out of the box.`,ca,Lt,ds=`This approach is also useful if you want to tweak the pytorch source and/or make a new customized build.
To find the docker image version you want start <a href="https://docs.nvidia.com/deeplearning/frameworks/pytorch-release-notes/" rel="nofollow">with PyTorch release notes</a>,
choose one of the latest monthly releases. Go into the release’s notes for the desired release, check that the environment’s
components are matching your needs (including NVIDIA Driver requirements!) and then at the very top of that document go
to the corresponding NGC page. If for some reason you get lost, here is <a href="https://ngc.nvidia.com/catalog/containers/nvidia:pytorch" rel="nofollow">the index of all PyTorch NGC images</a>.`,fa,Wt,ms="Next follow the instructions to download and deploy the docker image.",ha,Pt,ua,Gt,cs=`Some recent papers reported a 4-5x training speedup and a faster inference by integrating
Mixture of Experts (MoE) into the Transformer models.`,ga,Yt,fs=`Since it has been discovered that more parameters lead to better performance, this technique allows to increase the
number of parameters by an order of magnitude without increasing training costs.`,ya,Rt,hs=`In this approach every other FFN layer is replaced with a MoE Layer which consists of many experts, with a gated function
that trains each expert in a balanced way depending on the input token’s position in a sequence.`,wa,It,us='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perf-moe-transformer.png" alt="MoE Transformer 2x block"/>',ba,Zt,gs='(source: <a href="https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html" rel="nofollow">GLAM</a>)',Ma,Ft,ys="You can find exhaustive details and comparison tables in the papers listed at the end of this section.",va,Bt,ws=`The main drawback of this approach is that it requires staggering amounts of GPU memory - almost an order of magnitude
larger than its dense equivalent. Various distillation and approaches are proposed to how to overcome the much higher memory requirements.`,Ta,Xt,bs=`There is direct trade-off though, you can use just a few experts with a 2-3x smaller base model instead of dozens or
hundreds experts leading to a 5x smaller model and thus increase the training speed moderately while increasing the
memory requirements moderately as well.`,_a,qt,Ms="Most related papers and implementations are built around Tensorflow/TPUs:",$a,Et,vs='<li><a href="https://arxiv.org/abs/2006.16668" rel="nofollow">GShard: Scaling Giant Models with Conditional Computation and Automatic Sharding</a></li> <li><a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with Simple and Efficient Sparsity</a></li> <li><a href="https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html" rel="nofollow">GLaM: Generalist Language Model (GLaM)</a></li>',xa,Vt,Ts='And for Pytorch DeepSpeed has built one as well: <a href="https://arxiv.org/abs/2201.05596" rel="nofollow">DeepSpeed-MoE: Advancing Mixture-of-Experts Inference and Training to Power Next-Generation AI Scale</a>, <a href="https://www.deepspeed.ai/tutorials/mixture-of-experts/" rel="nofollow">Mixture of Experts</a> - blog posts:  <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-powers-8x-larger-moe-model-training-with-high-performance/" rel="nofollow">1</a>, <a href="https://www.microsoft.com/en-us/research/publication/scalable-and-efficient-moe-training-for-multitask-multilingual-models/" rel="nofollow">2</a> and specific deployment with large transformer-based natural language generation models: <a href="https://www.deepspeed.ai/news/2021/12/09/deepspeed-moe-nlg.html" rel="nofollow">blog post</a>, <a href="Thttps://github.com/microsoft/Megatron-DeepSpeed/tree/moe-training">Megatron-Deepspeed branch</a>.',Ca,Nt,Ja,Dt,_s=`PyTorch 2.0 released a native <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> (SDPA),
that allows using fused GPU kernels such as <a href="https://arxiv.org/abs/2112.05682" rel="nofollow">memory-efficient attention</a> and <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">flash attention</a>.`,Ua,St,$s=`After installing the <a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a> package, the relevant internal modules can be
replaced to use PyTorch’s native attention with:`,ka,Qt,ja,Kt,xs="Once converted, train the model as usual.",Ha,k,za,Ot,Cs='Check out this <a href="https://pytorch.org/blog/out-of-the-box-acceleration/" rel="nofollow">blogpost</a> to learn more about acceleration and memory-savings with SDPA.',Aa,en,La;return $=new w({props:{title:"Methods and tools for efficient training on a single GPU",local:"methods-and-tools-for-efficient-training-on-a-single-gpu",headingTag:"h1"}}),x=new tn({props:{$$slots:{default:[Zs]},$$scope:{ctx:T}}}),C=new tn({props:{$$slots:{default:[Fs]},$$scope:{ctx:T}}}),I=new w({props:{title:"Batch size choice",local:"batch-size-choice",headingTag:"h2"}}),q=new w({props:{title:"Gradient Accumulation",local:"gradient-accumulation",headingTag:"h2"}}),N=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">1</span>, gradient_accumulation_steps=<span class="hljs-number">4</span>, **default_args)',wrap:!1}}),O=new w({props:{title:"Gradient Checkpointing",local:"gradient-checkpointing",headingTag:"h2"}}),ae=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMjAqKmRlZmF1bHRfYXJncyUwQSk=",highlighted:`training_args = TrainingArguments(
    per_device_train_batch_size=<span class="hljs-number">1</span>, gradient_accumulation_steps=<span class="hljs-number">4</span>, gradient_checkpointing=<span class="hljs-literal">True</span>, **default_args
)`,wrap:!1}}),J=new tn({props:{$$slots:{default:[Bs]},$$scope:{ctx:T}}}),se=new w({props:{title:"Mixed precision training",local:"mixed-precision-training",headingTag:"h2"}}),pe=new w({props:{title:"fp16",local:"fp16",headingTag:"h3"}}),ce=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBmcDE2JTNEVHJ1ZSUyQyUyMCoqZGVmYXVsdF9hcmdzKQ==",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, fp16=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),he=new w({props:{title:"BF16",local:"bf16",headingTag:"h3"}}),ye=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKGJmMTYlM0RUcnVlJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(bf16=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),we=new w({props:{title:"TF32",local:"tf32",headingTag:"h3"}}),Me=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF0b3JjaC5iYWNrZW5kcy5jdWRhLm1hdG11bC5hbGxvd190ZjMyJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLmJhY2tlbmRzLmN1ZG5uLmFsbG93X3RmMzIlMjAlM0QlMjBUcnVl",highlighted:`import torch
torch<span class="hljs-selector-class">.backends</span><span class="hljs-selector-class">.cuda</span><span class="hljs-selector-class">.matmul</span><span class="hljs-selector-class">.allow_tf32</span> = True
torch<span class="hljs-selector-class">.backends</span><span class="hljs-selector-class">.cudnn</span><span class="hljs-selector-class">.allow_tf32</span> = True`,wrap:!1}}),$e=new v({props:{code:"VHJhaW5pbmdBcmd1bWVudHModGYzMiUzRFRydWUlMkMlMjAqKmRlZmF1bHRfYXJncyk=",highlighted:'TrainingArguments(tf32=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),U=new tn({props:{$$slots:{default:[Xs]},$$scope:{ctx:T}}}),Ce=new w({props:{title:"Flash Attention 2",local:"flash-attention-2",headingTag:"h2"}}),Ue=new w({props:{title:"Optimizer choice",local:"optimizer-choice",headingTag:"h2"}}),We=new w({props:{title:"Adafactor",local:"adafactor",headingTag:"h3"}}),Ye=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBvcHRpbSUzRCUyMmFkYWZhY3RvciUyMiUyQyUyMCoqZGVmYXVsdF9hcmdzKQ==",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, optim=<span class="hljs-string">&quot;adafactor&quot;</span>, **default_args)',wrap:!1}}),Ie=new w({props:{title:"8-bit Adam",local:"8-bit-adam",headingTag:"h3"}}),Be=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBvcHRpbSUzRCUyMmFkYW13X2JuYl84Yml0JTIyJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, optim=<span class="hljs-string">&quot;adamw_bnb_8bit&quot;</span>, **default_args)',wrap:!1}}),Ne=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> transformers.trainer_pt_utils <span class="hljs-keyword">import</span> get_parameter_names

training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, **default_args)

decay_parameters = get_parameter_names(model, [nn.LayerNorm])
decay_parameters = [name <span class="hljs-keyword">for</span> name <span class="hljs-keyword">in</span> decay_parameters <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;bias&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> name]
optimizer_grouped_parameters = [
    {
        <span class="hljs-string">&quot;params&quot;</span>: [p <span class="hljs-keyword">for</span> n, p <span class="hljs-keyword">in</span> model.named_parameters() <span class="hljs-keyword">if</span> n <span class="hljs-keyword">in</span> decay_parameters],
        <span class="hljs-string">&quot;weight_decay&quot;</span>: training_args.weight_decay,
    },
    {
        <span class="hljs-string">&quot;params&quot;</span>: [p <span class="hljs-keyword">for</span> n, p <span class="hljs-keyword">in</span> model.named_parameters() <span class="hljs-keyword">if</span> n <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> decay_parameters],
        <span class="hljs-string">&quot;weight_decay&quot;</span>: <span class="hljs-number">0.0</span>,
    },
]

optimizer_kwargs = {
    <span class="hljs-string">&quot;betas&quot;</span>: (training_args.adam_beta1, training_args.adam_beta2),
    <span class="hljs-string">&quot;eps&quot;</span>: training_args.adam_epsilon,
}
optimizer_kwargs[<span class="hljs-string">&quot;lr&quot;</span>] = training_args.learning_rate
adam_bnb_optim = bnb.optim.Adam8bit(
    optimizer_grouped_parameters,
    betas=(training_args.adam_beta1, training_args.adam_beta2),
    eps=training_args.adam_epsilon,
    lr=training_args.learning_rate,
)`,wrap:!1}}),Se=new v({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCUzRGRzJTJDJTIwb3B0aW1pemVycyUzRChhZGFtX2JuYl9vcHRpbSUyQyUyME5vbmUpKQ==",highlighted:'trainer = Trainer(model=model, args=training_args, train_dataset=ds, optimizers=(adam_bnb_optim, <span class="hljs-literal">None</span>))',wrap:!1}}),Ke=new w({props:{title:"multi_tensor",local:"multitensor",headingTag:"h3"}}),et=new w({props:{title:"Data preloading",local:"data-preloading",headingTag:"h2"}}),at=new w({props:{title:"DeepSpeed ZeRO",local:"deepspeed-zero",headingTag:"h2"}}),ot=new w({props:{title:"Using torch.compile",local:"using-torchcompile",headingTag:"h2"}}),mt=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHRvcmNoX2NvbXBpbGUlM0RUcnVlJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(torch_compile=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),Tt=new w({props:{title:"Using 🤗 Accelerate",local:"using--accelerate",headingTag:"h2"}}),xt=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCoqZGVmYXVsdF9hcmdzJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    **default_args,
)`,wrap:!1}}),Jt=new v({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhLmRhdGFsb2FkZXIlMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZHMlMkMlMjBiYXRjaF9zaXplJTNEdHJhaW5pbmdfYXJncy5wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUpJTBBJTBBaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0ElMEElMjAlMjAlMjAlMjBtb2RlbC5ncmFkaWVudF9jaGVja3BvaW50aW5nX2VuYWJsZSgpJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihmcDE2JTNEdHJhaW5pbmdfYXJncy5mcDE2KSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBhZGFtX2JuYl9vcHRpbSUyQyUyMGRhdGFsb2FkZXIpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMHN0ZXAlMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKGRhdGFsb2FkZXIlMkMlMjBzdGFydCUzRDEpJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpLmxvc3MlMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMHRyYWluaW5nX2FyZ3MuZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjBpZiUyMHN0ZXAlMjAlMjUlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.utils.data.dataloader <span class="hljs-keyword">import</span> DataLoader

dataloader = DataLoader(ds, batch_size=training_args.per_device_train_batch_size)

<span class="hljs-keyword">if</span> training_args.gradient_checkpointing:
    model.gradient_checkpointing_enable()

accelerator = Accelerator(fp16=training_args.fp16)
model, optimizer, dataloader = accelerator.prepare(model, adam_bnb_optim, dataloader)

model.train()
<span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader, start=<span class="hljs-number">1</span>):
    loss = model(**batch).loss
    loss = loss / training_args.gradient_accumulation_steps
    accelerator.backward(loss)
    <span class="hljs-keyword">if</span> step % training_args.gradient_accumulation_steps == <span class="hljs-number">0</span>:
        optimizer.step()
        optimizer.zero_grad()`,wrap:!1}}),Ht=new w({props:{title:"Efficient Software Prebuilds",local:"efficient-software-prebuilds",headingTag:"h2"}}),Pt=new w({props:{title:"Mixture of Experts",local:"mixture-of-experts",headingTag:"h2"}}),Nt=new w({props:{title:"Using PyTorch native attention and Flash Attention",local:"using-pytorch-native-attention-and-flash-attention",headingTag:"h2"}}),Qt=new v({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC50b19iZXR0ZXJ0cmFuc2Zvcm1lcigp",highlighted:"model = model.to_bettertransformer()",wrap:!1}}),k=new tn({props:{warning:!0,$$slots:{default:[qs]},$$scope:{ctx:T}}}),{c(){p=s("meta"),b=a(),g=s("p"),y=a(),d($.$$.fragment),M=a(),_=s("p"),_.innerHTML=Wa,an=a(),d(x.$$.fragment),ln=a(),j=s("p"),j.textContent=Pa,sn=a(),H=s("ul"),H.innerHTML=Ga,rn=a(),z=s("p"),z.textContent=Ya,on=a(),A=s("p"),A.textContent=Ra,pn=a(),L=s("p"),L.textContent=Ia,dn=a(),W=s("table"),W.innerHTML=Za,mn=a(),d(C.$$.fragment),cn=a(),P=s("p"),P.innerHTML=Fa,fn=a(),G=s("p"),G.textContent=Ba,hn=a(),Y=s("ul"),Y.innerHTML=Xa,un=a(),R=s("p"),R.innerHTML=qa,gn=a(),d(I.$$.fragment),yn=a(),Z=s("p"),Z.textContent=Ea,wn=a(),F=s("p"),F.innerHTML=Va,bn=a(),B=s("p"),B.innerHTML=Na,Mn=a(),X=s("p"),X.innerHTML=Da,vn=a(),d(q.$$.fragment),Tn=a(),E=s("p"),E.innerHTML=Sa,_n=a(),V=s("p"),V.innerHTML=Qa,$n=a(),d(N.$$.fragment),xn=a(),D=s("p"),D.textContent=Ka,Cn=a(),S=s("p"),S.innerHTML=Oa,Jn=a(),Q=s("p"),Q.innerHTML=el,Un=a(),K=s("p"),K.innerHTML=tl,kn=a(),d(O.$$.fragment),jn=a(),ee=s("p"),ee.textContent=nl,Hn=a(),te=s("p"),te.textContent=il,zn=a(),ne=s("p"),ne.innerHTML=al,An=a(),ie=s("p"),ie.innerHTML=ll,Ln=a(),d(ae.$$.fragment),Wn=a(),le=s("p"),le.innerHTML=sl,Pn=a(),d(J.$$.fragment),Gn=a(),d(se.$$.fragment),Yn=a(),re=s("p"),re.innerHTML=rl,Rn=a(),oe=s("p"),oe.innerHTML=ol,In=a(),d(pe.$$.fragment),Zn=a(),de=s("p"),de.textContent=pl,Fn=a(),me=s("p"),me.innerHTML=dl,Bn=a(),d(ce.$$.fragment),Xn=a(),fe=s("p"),fe.innerHTML=ml,qn=a(),d(he.$$.fragment),En=a(),ue=s("p"),ue.innerHTML=cl,Vn=a(),ge=s("p"),ge.textContent=fl,Nn=a(),d(ye.$$.fragment),Dn=a(),d(we.$$.fragment),Sn=a(),be=s("p"),be.textContent=hl,Qn=a(),d(Me.$$.fragment),Kn=a(),ve=s("p"),ve.textContent=ul,On=a(),Te=s("p"),Te.innerHTML=gl,ei=a(),_e=s("p"),_e.textContent=yl,ti=a(),d($e.$$.fragment),ni=a(),d(U.$$.fragment),ii=a(),xe=s("p"),xe.innerHTML=wl,ai=a(),d(Ce.$$.fragment),li=a(),Je=s("p"),Je.innerHTML=bl,si=a(),d(Ue.$$.fragment),ri=a(),ke=s("p"),ke.innerHTML=Ml,oi=a(),je=s("p"),je.innerHTML=vl,pi=a(),He=s("p"),He.textContent=Tl,di=a(),ze=s("ol"),ze.innerHTML=_l,mi=a(),Ae=s("p"),Ae.textContent=$l,ci=a(),Le=s("ul"),Le.innerHTML=xl,fi=a(),d(We.$$.fragment),hi=a(),Pe=s("p"),Pe.textContent=Cl,ui=a(),Ge=s("p"),Ge.innerHTML=Jl,gi=a(),d(Ye.$$.fragment),yi=a(),Re=s("p"),Re.textContent=Ul,wi=a(),d(Ie.$$.fragment),bi=a(),Ze=s("p"),Ze.textContent=kl,Mi=a(),Fe=s("p"),Fe.innerHTML=jl,vi=a(),d(Be.$$.fragment),Ti=a(),Xe=s("p"),Xe.textContent=Hl,_i=a(),qe=s("p"),qe.innerHTML=zl,$i=a(),Ee=s("p"),Ee.textContent=Al,xi=a(),Ve=s("ul"),Ve.innerHTML=Ll,Ci=a(),d(Ne.$$.fragment),Ji=a(),De=s("p"),De.innerHTML=Wl,Ui=a(),d(Se.$$.fragment),ki=a(),Qe=s("p"),Qe.textContent=Pl,ji=a(),d(Ke.$$.fragment),Hi=a(),Oe=s("p"),Oe.innerHTML=Gl,zi=a(),d(et.$$.fragment),Ai=a(),tt=s("p"),tt.textContent=Yl,Li=a(),nt=s("ul"),nt.innerHTML=Rl,Wi=a(),it=s("p"),it.innerHTML=Il,Pi=a(),d(at.$$.fragment),Gi=a(),lt=s("p"),lt.textContent=Zl,Yi=a(),st=s("p"),st.innerHTML=Fl,Ri=a(),rt=s("ul"),rt.innerHTML=Bl,Ii=a(),d(ot.$$.fragment),Zi=a(),pt=s("p"),pt.innerHTML=Xl,Fi=a(),dt=s("p"),dt.innerHTML=ql,Bi=a(),d(mt.$$.fragment),Xi=a(),ct=s("p"),ct.innerHTML=El,qi=a(),ft=s("p"),ft.innerHTML=Vl,Ei=a(),ht=s("p"),ht.innerHTML=Nl,Vi=a(),ut=s("p"),ut.innerHTML=Dl,Ni=a(),gt=s("ul"),gt.innerHTML=Sl,Di=a(),yt=s("p"),yt.innerHTML=Ql,Si=a(),wt=s("ul"),wt.innerHTML=Kl,Qi=a(),bt=s("p"),bt.innerHTML=Ol,Ki=a(),Mt=s("ul"),Mt.innerHTML=es,Oi=a(),vt=s("p"),vt.innerHTML=ts,ea=a(),d(Tt.$$.fragment),ta=a(),_t=s("p"),_t.innerHTML=ns,na=a(),$t=s("p"),$t.innerHTML=is,ia=a(),d(xt.$$.fragment),aa=a(),Ct=s("p"),Ct.textContent=as,la=a(),d(Jt.$$.fragment),sa=a(),Ut=s("p"),Ut.innerHTML=ls,ra=a(),kt=s("p"),kt.innerHTML=ss,oa=a(),jt=s("p"),jt.innerHTML=rs,pa=a(),d(Ht.$$.fragment),da=a(),zt=s("p"),zt.innerHTML=os,ma=a(),At=s("p"),At.innerHTML=ps,ca=a(),Lt=s("p"),Lt.innerHTML=ds,fa=a(),Wt=s("p"),Wt.textContent=ms,ha=a(),d(Pt.$$.fragment),ua=a(),Gt=s("p"),Gt.textContent=cs,ga=a(),Yt=s("p"),Yt.textContent=fs,ya=a(),Rt=s("p"),Rt.textContent=hs,wa=a(),It=s("p"),It.innerHTML=us,ba=a(),Zt=s("p"),Zt.innerHTML=gs,Ma=a(),Ft=s("p"),Ft.textContent=ys,va=a(),Bt=s("p"),Bt.textContent=ws,Ta=a(),Xt=s("p"),Xt.textContent=bs,_a=a(),qt=s("p"),qt.textContent=Ms,$a=a(),Et=s("ul"),Et.innerHTML=vs,xa=a(),Vt=s("p"),Vt.innerHTML=Ts,Ca=a(),d(Nt.$$.fragment),Ja=a(),Dt=s("p"),Dt.innerHTML=_s,Ua=a(),St=s("p"),St.innerHTML=$s,ka=a(),d(Qt.$$.fragment),ja=a(),Kt=s("p"),Kt.textContent=xs,Ha=a(),d(k.$$.fragment),za=a(),Ot=s("p"),Ot.innerHTML=Cs,Aa=a(),en=s("p"),this.h()},l(e){const t=Ys("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(n),b=l(e),g=r(e,"P",{}),zs(g).forEach(n),y=l(e),m($.$$.fragment,e),M=l(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-tqdu0u"&&(_.innerHTML=Wa),an=l(e),m(x.$$.fragment,e),ln=l(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-4s75i8"&&(j.textContent=Pa),sn=l(e),H=r(e,"UL",{"data-svelte-h":!0}),o(H)!=="svelte-djgcn1"&&(H.innerHTML=Ga),rn=l(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-uf18r4"&&(z.textContent=Ya),on=l(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-b3xmwb"&&(A.textContent=Ra),pn=l(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1qbc4zp"&&(L.textContent=Ia),dn=l(e),W=r(e,"TABLE",{"data-svelte-h":!0}),o(W)!=="svelte-15stut3"&&(W.innerHTML=Za),mn=l(e),m(C.$$.fragment,e),cn=l(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-zopc0y"&&(P.innerHTML=Fa),fn=l(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1thjxg4"&&(G.textContent=Ba),hn=l(e),Y=r(e,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-18kwup6"&&(Y.innerHTML=Xa),un=l(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1uvbmrd"&&(R.innerHTML=qa),gn=l(e),m(I.$$.fragment,e),yn=l(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1f9wkzb"&&(Z.textContent=Ea),wn=l(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-h1ek0g"&&(F.innerHTML=Va),bn=l(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-sfn5k1"&&(B.innerHTML=Na),Mn=l(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-wvp8kx"&&(X.innerHTML=Da),vn=l(e),m(q.$$.fragment,e),Tn=l(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1l7rfkq"&&(E.innerHTML=Sa),_n=l(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1ay2myz"&&(V.innerHTML=Qa),$n=l(e),m(N.$$.fragment,e),xn=l(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-18ky75y"&&(D.textContent=Ka),Cn=l(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-khctnv"&&(S.innerHTML=Oa),Jn=l(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1bitspm"&&(Q.innerHTML=el),Un=l(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-nbfonf"&&(K.innerHTML=tl),kn=l(e),m(O.$$.fragment,e),jn=l(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-n1qbw"&&(ee.textContent=nl),Hn=l(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1419dmv"&&(te.textContent=il),zn=l(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-nfo3gu"&&(ne.innerHTML=al),An=l(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1do52ef"&&(ie.innerHTML=ll),Ln=l(e),m(ae.$$.fragment,e),Wn=l(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1wwrmcl"&&(le.innerHTML=sl),Pn=l(e),m(J.$$.fragment,e),Gn=l(e),m(se.$$.fragment,e),Yn=l(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-7pqnv0"&&(re.innerHTML=rl),Rn=l(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1ttanpy"&&(oe.innerHTML=ol),In=l(e),m(pe.$$.fragment,e),Zn=l(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-h2t8go"&&(de.textContent=pl),Fn=l(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-wwg09w"&&(me.innerHTML=dl),Bn=l(e),m(ce.$$.fragment,e),Xn=l(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-11fsu6r"&&(fe.innerHTML=ml),qn=l(e),m(he.$$.fragment,e),En=l(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1p48z2n"&&(ue.innerHTML=cl),Vn=l(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-vq639r"&&(ge.textContent=fl),Nn=l(e),m(ye.$$.fragment,e),Dn=l(e),m(we.$$.fragment,e),Sn=l(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-7szee7"&&(be.textContent=hl),Qn=l(e),m(Me.$$.fragment,e),Kn=l(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1kvnj8w"&&(ve.textContent=ul),On=l(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-alc3bu"&&(Te.innerHTML=gl),ei=l(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-d0keh1"&&(_e.textContent=yl),ti=l(e),m($e.$$.fragment,e),ni=l(e),m(U.$$.fragment,e),ii=l(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-dzrbtx"&&(xe.innerHTML=wl),ai=l(e),m(Ce.$$.fragment,e),li=l(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-4gzx8m"&&(Je.innerHTML=bl),si=l(e),m(Ue.$$.fragment,e),ri=l(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-xkv29v"&&(ke.innerHTML=Ml),oi=l(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1osvxls"&&(je.innerHTML=vl),pi=l(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1qfw41"&&(He.textContent=Tl),di=l(e),ze=r(e,"OL",{"data-svelte-h":!0}),o(ze)!=="svelte-1xnsiz3"&&(ze.innerHTML=_l),mi=l(e),Ae=r(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-2mb823"&&(Ae.textContent=$l),ci=l(e),Le=r(e,"UL",{"data-svelte-h":!0}),o(Le)!=="svelte-ajuctj"&&(Le.innerHTML=xl),fi=l(e),m(We.$$.fragment,e),hi=l(e),Pe=r(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-19jpav8"&&(Pe.textContent=Cl),ui=l(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1atcq5f"&&(Ge.innerHTML=Jl),gi=l(e),m(Ye.$$.fragment,e),yi=l(e),Re=r(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1850zf2"&&(Re.textContent=Ul),wi=l(e),m(Ie.$$.fragment,e),bi=l(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1ld1y8t"&&(Ze.textContent=kl),Mi=l(e),Fe=r(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-2an79v"&&(Fe.innerHTML=jl),vi=l(e),m(Be.$$.fragment,e),Ti=l(e),Xe=r(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-czmcu6"&&(Xe.textContent=Hl),_i=l(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1av8920"&&(qe.innerHTML=zl),$i=l(e),Ee=r(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-19nyc4u"&&(Ee.textContent=Al),xi=l(e),Ve=r(e,"UL",{"data-svelte-h":!0}),o(Ve)!=="svelte-8z8ok2"&&(Ve.innerHTML=Ll),Ci=l(e),m(Ne.$$.fragment,e),Ji=l(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-n8bkwf"&&(De.innerHTML=Wl),Ui=l(e),m(Se.$$.fragment,e),ki=l(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1egi1g7"&&(Qe.textContent=Pl),ji=l(e),m(Ke.$$.fragment,e),Hi=l(e),Oe=r(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-1cvgqaq"&&(Oe.innerHTML=Gl),zi=l(e),m(et.$$.fragment,e),Ai=l(e),tt=r(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-16tninz"&&(tt.textContent=Yl),Li=l(e),nt=r(e,"UL",{"data-svelte-h":!0}),o(nt)!=="svelte-1i85v8g"&&(nt.innerHTML=Rl),Wi=l(e),it=r(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-13sigwt"&&(it.innerHTML=Il),Pi=l(e),m(at.$$.fragment,e),Gi=l(e),lt=r(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1onp6io"&&(lt.textContent=Zl),Yi=l(e),st=r(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-18hg7g"&&(st.innerHTML=Fl),Ri=l(e),rt=r(e,"UL",{"data-svelte-h":!0}),o(rt)!=="svelte-1uk0gxk"&&(rt.innerHTML=Bl),Ii=l(e),m(ot.$$.fragment,e),Zi=l(e),pt=r(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-5qw0v5"&&(pt.innerHTML=Xl),Fi=l(e),dt=r(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1qex2tw"&&(dt.innerHTML=ql),Bi=l(e),m(mt.$$.fragment,e),Xi=l(e),ct=r(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-1y4s25e"&&(ct.innerHTML=El),qi=l(e),ft=r(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-jluuok"&&(ft.innerHTML=Vl),Ei=l(e),ht=r(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-lxowme"&&(ht.innerHTML=Nl),Vi=l(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-v82kng"&&(ut.innerHTML=Dl),Ni=l(e),gt=r(e,"UL",{"data-svelte-h":!0}),o(gt)!=="svelte-1dbgjs7"&&(gt.innerHTML=Sl),Di=l(e),yt=r(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-m2qf5f"&&(yt.innerHTML=Ql),Si=l(e),wt=r(e,"UL",{"data-svelte-h":!0}),o(wt)!=="svelte-x9b2wm"&&(wt.innerHTML=Kl),Qi=l(e),bt=r(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-78l3h4"&&(bt.innerHTML=Ol),Ki=l(e),Mt=r(e,"UL",{"data-svelte-h":!0}),o(Mt)!=="svelte-1y0itbi"&&(Mt.innerHTML=es),Oi=l(e),vt=r(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1prqm7s"&&(vt.innerHTML=ts),ea=l(e),m(Tt.$$.fragment,e),ta=l(e),_t=r(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-d91a9c"&&(_t.innerHTML=ns),na=l(e),$t=r(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-1wnaicd"&&($t.innerHTML=is),ia=l(e),m(xt.$$.fragment,e),aa=l(e),Ct=r(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-eja69v"&&(Ct.textContent=as),la=l(e),m(Jt.$$.fragment,e),sa=l(e),Ut=r(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-12byzex"&&(Ut.innerHTML=ls),ra=l(e),kt=r(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-i5733s"&&(kt.innerHTML=ss),oa=l(e),jt=r(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-1caz98g"&&(jt.innerHTML=rs),pa=l(e),m(Ht.$$.fragment,e),da=l(e),zt=r(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-nmhpgl"&&(zt.innerHTML=os),ma=l(e),At=r(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-kxuhyz"&&(At.innerHTML=ps),ca=l(e),Lt=r(e,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-qkuwkx"&&(Lt.innerHTML=ds),fa=l(e),Wt=r(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-16g8p4x"&&(Wt.textContent=ms),ha=l(e),m(Pt.$$.fragment,e),ua=l(e),Gt=r(e,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1aawf57"&&(Gt.textContent=cs),ga=l(e),Yt=r(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-ln9ugc"&&(Yt.textContent=fs),ya=l(e),Rt=r(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1ett6yb"&&(Rt.textContent=hs),wa=l(e),It=r(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-tdgts9"&&(It.innerHTML=us),ba=l(e),Zt=r(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-z2dori"&&(Zt.innerHTML=gs),Ma=l(e),Ft=r(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-1gc8znk"&&(Ft.textContent=ys),va=l(e),Bt=r(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-13sa7m0"&&(Bt.textContent=ws),Ta=l(e),Xt=r(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-dxh8d5"&&(Xt.textContent=bs),_a=l(e),qt=r(e,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-1jfhyzg"&&(qt.textContent=Ms),$a=l(e),Et=r(e,"UL",{"data-svelte-h":!0}),o(Et)!=="svelte-1fjc55v"&&(Et.innerHTML=vs),xa=l(e),Vt=r(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-o7v7js"&&(Vt.innerHTML=Ts),Ca=l(e),m(Nt.$$.fragment,e),Ja=l(e),Dt=r(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-10jsqxr"&&(Dt.innerHTML=_s),Ua=l(e),St=r(e,"P",{"data-svelte-h":!0}),o(St)!=="svelte-mg6n76"&&(St.innerHTML=$s),ka=l(e),m(Qt.$$.fragment,e),ja=l(e),Kt=r(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-wfi44p"&&(Kt.textContent=xs),Ha=l(e),m(k.$$.fragment,e),za=l(e),Ot=r(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-1r3sioy"&&(Ot.innerHTML=Cs),Aa=l(e),en=r(e,"P",{}),zs(en).forEach(n),this.h()},h(){As(p,"name","hf:doc:metadata"),As(p,"content",Vs)},m(e,t){Rs(document.head,p),i(e,b,t),i(e,g,t),i(e,y,t),c($,e,t),i(e,M,t),i(e,_,t),i(e,an,t),c(x,e,t),i(e,ln,t),i(e,j,t),i(e,sn,t),i(e,H,t),i(e,rn,t),i(e,z,t),i(e,on,t),i(e,A,t),i(e,pn,t),i(e,L,t),i(e,dn,t),i(e,W,t),i(e,mn,t),c(C,e,t),i(e,cn,t),i(e,P,t),i(e,fn,t),i(e,G,t),i(e,hn,t),i(e,Y,t),i(e,un,t),i(e,R,t),i(e,gn,t),c(I,e,t),i(e,yn,t),i(e,Z,t),i(e,wn,t),i(e,F,t),i(e,bn,t),i(e,B,t),i(e,Mn,t),i(e,X,t),i(e,vn,t),c(q,e,t),i(e,Tn,t),i(e,E,t),i(e,_n,t),i(e,V,t),i(e,$n,t),c(N,e,t),i(e,xn,t),i(e,D,t),i(e,Cn,t),i(e,S,t),i(e,Jn,t),i(e,Q,t),i(e,Un,t),i(e,K,t),i(e,kn,t),c(O,e,t),i(e,jn,t),i(e,ee,t),i(e,Hn,t),i(e,te,t),i(e,zn,t),i(e,ne,t),i(e,An,t),i(e,ie,t),i(e,Ln,t),c(ae,e,t),i(e,Wn,t),i(e,le,t),i(e,Pn,t),c(J,e,t),i(e,Gn,t),c(se,e,t),i(e,Yn,t),i(e,re,t),i(e,Rn,t),i(e,oe,t),i(e,In,t),c(pe,e,t),i(e,Zn,t),i(e,de,t),i(e,Fn,t),i(e,me,t),i(e,Bn,t),c(ce,e,t),i(e,Xn,t),i(e,fe,t),i(e,qn,t),c(he,e,t),i(e,En,t),i(e,ue,t),i(e,Vn,t),i(e,ge,t),i(e,Nn,t),c(ye,e,t),i(e,Dn,t),c(we,e,t),i(e,Sn,t),i(e,be,t),i(e,Qn,t),c(Me,e,t),i(e,Kn,t),i(e,ve,t),i(e,On,t),i(e,Te,t),i(e,ei,t),i(e,_e,t),i(e,ti,t),c($e,e,t),i(e,ni,t),c(U,e,t),i(e,ii,t),i(e,xe,t),i(e,ai,t),c(Ce,e,t),i(e,li,t),i(e,Je,t),i(e,si,t),c(Ue,e,t),i(e,ri,t),i(e,ke,t),i(e,oi,t),i(e,je,t),i(e,pi,t),i(e,He,t),i(e,di,t),i(e,ze,t),i(e,mi,t),i(e,Ae,t),i(e,ci,t),i(e,Le,t),i(e,fi,t),c(We,e,t),i(e,hi,t),i(e,Pe,t),i(e,ui,t),i(e,Ge,t),i(e,gi,t),c(Ye,e,t),i(e,yi,t),i(e,Re,t),i(e,wi,t),c(Ie,e,t),i(e,bi,t),i(e,Ze,t),i(e,Mi,t),i(e,Fe,t),i(e,vi,t),c(Be,e,t),i(e,Ti,t),i(e,Xe,t),i(e,_i,t),i(e,qe,t),i(e,$i,t),i(e,Ee,t),i(e,xi,t),i(e,Ve,t),i(e,Ci,t),c(Ne,e,t),i(e,Ji,t),i(e,De,t),i(e,Ui,t),c(Se,e,t),i(e,ki,t),i(e,Qe,t),i(e,ji,t),c(Ke,e,t),i(e,Hi,t),i(e,Oe,t),i(e,zi,t),c(et,e,t),i(e,Ai,t),i(e,tt,t),i(e,Li,t),i(e,nt,t),i(e,Wi,t),i(e,it,t),i(e,Pi,t),c(at,e,t),i(e,Gi,t),i(e,lt,t),i(e,Yi,t),i(e,st,t),i(e,Ri,t),i(e,rt,t),i(e,Ii,t),c(ot,e,t),i(e,Zi,t),i(e,pt,t),i(e,Fi,t),i(e,dt,t),i(e,Bi,t),c(mt,e,t),i(e,Xi,t),i(e,ct,t),i(e,qi,t),i(e,ft,t),i(e,Ei,t),i(e,ht,t),i(e,Vi,t),i(e,ut,t),i(e,Ni,t),i(e,gt,t),i(e,Di,t),i(e,yt,t),i(e,Si,t),i(e,wt,t),i(e,Qi,t),i(e,bt,t),i(e,Ki,t),i(e,Mt,t),i(e,Oi,t),i(e,vt,t),i(e,ea,t),c(Tt,e,t),i(e,ta,t),i(e,_t,t),i(e,na,t),i(e,$t,t),i(e,ia,t),c(xt,e,t),i(e,aa,t),i(e,Ct,t),i(e,la,t),c(Jt,e,t),i(e,sa,t),i(e,Ut,t),i(e,ra,t),i(e,kt,t),i(e,oa,t),i(e,jt,t),i(e,pa,t),c(Ht,e,t),i(e,da,t),i(e,zt,t),i(e,ma,t),i(e,At,t),i(e,ca,t),i(e,Lt,t),i(e,fa,t),i(e,Wt,t),i(e,ha,t),c(Pt,e,t),i(e,ua,t),i(e,Gt,t),i(e,ga,t),i(e,Yt,t),i(e,ya,t),i(e,Rt,t),i(e,wa,t),i(e,It,t),i(e,ba,t),i(e,Zt,t),i(e,Ma,t),i(e,Ft,t),i(e,va,t),i(e,Bt,t),i(e,Ta,t),i(e,Xt,t),i(e,_a,t),i(e,qt,t),i(e,$a,t),i(e,Et,t),i(e,xa,t),i(e,Vt,t),i(e,Ca,t),c(Nt,e,t),i(e,Ja,t),i(e,Dt,t),i(e,Ua,t),i(e,St,t),i(e,ka,t),c(Qt,e,t),i(e,ja,t),i(e,Kt,t),i(e,Ha,t),c(k,e,t),i(e,za,t),i(e,Ot,t),i(e,Aa,t),i(e,en,t),La=!0},p(e,[t]){const Js={};t&2&&(Js.$$scope={dirty:t,ctx:e}),x.$set(Js);const Us={};t&2&&(Us.$$scope={dirty:t,ctx:e}),C.$set(Us);const ks={};t&2&&(ks.$$scope={dirty:t,ctx:e}),J.$set(ks);const js={};t&2&&(js.$$scope={dirty:t,ctx:e}),U.$set(js);const Hs={};t&2&&(Hs.$$scope={dirty:t,ctx:e}),k.$set(Hs)},i(e){La||(f($.$$.fragment,e),f(x.$$.fragment,e),f(C.$$.fragment,e),f(I.$$.fragment,e),f(q.$$.fragment,e),f(N.$$.fragment,e),f(O.$$.fragment,e),f(ae.$$.fragment,e),f(J.$$.fragment,e),f(se.$$.fragment,e),f(pe.$$.fragment,e),f(ce.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(Me.$$.fragment,e),f($e.$$.fragment,e),f(U.$$.fragment,e),f(Ce.$$.fragment,e),f(Ue.$$.fragment,e),f(We.$$.fragment,e),f(Ye.$$.fragment,e),f(Ie.$$.fragment,e),f(Be.$$.fragment,e),f(Ne.$$.fragment,e),f(Se.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(at.$$.fragment,e),f(ot.$$.fragment,e),f(mt.$$.fragment,e),f(Tt.$$.fragment,e),f(xt.$$.fragment,e),f(Jt.$$.fragment,e),f(Ht.$$.fragment,e),f(Pt.$$.fragment,e),f(Nt.$$.fragment,e),f(Qt.$$.fragment,e),f(k.$$.fragment,e),La=!0)},o(e){h($.$$.fragment,e),h(x.$$.fragment,e),h(C.$$.fragment,e),h(I.$$.fragment,e),h(q.$$.fragment,e),h(N.$$.fragment,e),h(O.$$.fragment,e),h(ae.$$.fragment,e),h(J.$$.fragment,e),h(se.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h($e.$$.fragment,e),h(U.$$.fragment,e),h(Ce.$$.fragment,e),h(Ue.$$.fragment,e),h(We.$$.fragment,e),h(Ye.$$.fragment,e),h(Ie.$$.fragment,e),h(Be.$$.fragment,e),h(Ne.$$.fragment,e),h(Se.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(at.$$.fragment,e),h(ot.$$.fragment,e),h(mt.$$.fragment,e),h(Tt.$$.fragment,e),h(xt.$$.fragment,e),h(Jt.$$.fragment,e),h(Ht.$$.fragment,e),h(Pt.$$.fragment,e),h(Nt.$$.fragment,e),h(Qt.$$.fragment,e),h(k.$$.fragment,e),La=!1},d(e){e&&(n(b),n(g),n(y),n(M),n(_),n(an),n(ln),n(j),n(sn),n(H),n(rn),n(z),n(on),n(A),n(pn),n(L),n(dn),n(W),n(mn),n(cn),n(P),n(fn),n(G),n(hn),n(Y),n(un),n(R),n(gn),n(yn),n(Z),n(wn),n(F),n(bn),n(B),n(Mn),n(X),n(vn),n(Tn),n(E),n(_n),n(V),n($n),n(xn),n(D),n(Cn),n(S),n(Jn),n(Q),n(Un),n(K),n(kn),n(jn),n(ee),n(Hn),n(te),n(zn),n(ne),n(An),n(ie),n(Ln),n(Wn),n(le),n(Pn),n(Gn),n(Yn),n(re),n(Rn),n(oe),n(In),n(Zn),n(de),n(Fn),n(me),n(Bn),n(Xn),n(fe),n(qn),n(En),n(ue),n(Vn),n(ge),n(Nn),n(Dn),n(Sn),n(be),n(Qn),n(Kn),n(ve),n(On),n(Te),n(ei),n(_e),n(ti),n(ni),n(ii),n(xe),n(ai),n(li),n(Je),n(si),n(ri),n(ke),n(oi),n(je),n(pi),n(He),n(di),n(ze),n(mi),n(Ae),n(ci),n(Le),n(fi),n(hi),n(Pe),n(ui),n(Ge),n(gi),n(yi),n(Re),n(wi),n(bi),n(Ze),n(Mi),n(Fe),n(vi),n(Ti),n(Xe),n(_i),n(qe),n($i),n(Ee),n(xi),n(Ve),n(Ci),n(Ji),n(De),n(Ui),n(ki),n(Qe),n(ji),n(Hi),n(Oe),n(zi),n(Ai),n(tt),n(Li),n(nt),n(Wi),n(it),n(Pi),n(Gi),n(lt),n(Yi),n(st),n(Ri),n(rt),n(Ii),n(Zi),n(pt),n(Fi),n(dt),n(Bi),n(Xi),n(ct),n(qi),n(ft),n(Ei),n(ht),n(Vi),n(ut),n(Ni),n(gt),n(Di),n(yt),n(Si),n(wt),n(Qi),n(bt),n(Ki),n(Mt),n(Oi),n(vt),n(ea),n(ta),n(_t),n(na),n($t),n(ia),n(aa),n(Ct),n(la),n(sa),n(Ut),n(ra),n(kt),n(oa),n(jt),n(pa),n(da),n(zt),n(ma),n(At),n(ca),n(Lt),n(fa),n(Wt),n(ha),n(ua),n(Gt),n(ga),n(Yt),n(ya),n(Rt),n(wa),n(It),n(ba),n(Zt),n(Ma),n(Ft),n(va),n(Bt),n(Ta),n(Xt),n(_a),n(qt),n($a),n(Et),n(xa),n(Vt),n(Ca),n(Ja),n(Dt),n(Ua),n(St),n(ka),n(ja),n(Kt),n(Ha),n(za),n(Ot),n(Aa),n(en)),n(p),u($,e),u(x,e),u(C,e),u(I,e),u(q,e),u(N,e),u(O,e),u(ae,e),u(J,e),u(se,e),u(pe,e),u(ce,e),u(he,e),u(ye,e),u(we,e),u(Me,e),u($e,e),u(U,e),u(Ce,e),u(Ue,e),u(We,e),u(Ye,e),u(Ie,e),u(Be,e),u(Ne,e),u(Se,e),u(Ke,e),u(et,e),u(at,e),u(ot,e),u(mt,e),u(Tt,e),u(xt,e),u(Jt,e),u(Ht,e),u(Pt,e),u(Nt,e),u(Qt,e),u(k,e)}}}const Vs='{"title":"Methods and tools for efficient training on a single GPU","local":"methods-and-tools-for-efficient-training-on-a-single-gpu","sections":[{"title":"Batch size choice","local":"batch-size-choice","sections":[],"depth":2},{"title":"Gradient Accumulation","local":"gradient-accumulation","sections":[],"depth":2},{"title":"Gradient Checkpointing","local":"gradient-checkpointing","sections":[],"depth":2},{"title":"Mixed precision training","local":"mixed-precision-training","sections":[{"title":"fp16","local":"fp16","sections":[],"depth":3},{"title":"BF16","local":"bf16","sections":[],"depth":3},{"title":"TF32","local":"tf32","sections":[],"depth":3}],"depth":2},{"title":"Flash Attention 2","local":"flash-attention-2","sections":[],"depth":2},{"title":"Optimizer choice","local":"optimizer-choice","sections":[{"title":"Adafactor","local":"adafactor","sections":[],"depth":3},{"title":"8-bit Adam","local":"8-bit-adam","sections":[],"depth":3},{"title":"multi_tensor","local":"multitensor","sections":[],"depth":3}],"depth":2},{"title":"Data preloading","local":"data-preloading","sections":[],"depth":2},{"title":"DeepSpeed ZeRO","local":"deepspeed-zero","sections":[],"depth":2},{"title":"Using torch.compile","local":"using-torchcompile","sections":[],"depth":2},{"title":"Using 🤗 Accelerate","local":"using--accelerate","sections":[],"depth":2},{"title":"Efficient Software Prebuilds","local":"efficient-software-prebuilds","sections":[],"depth":2},{"title":"Mixture of Experts","local":"mixture-of-experts","sections":[],"depth":2},{"title":"Using PyTorch native attention and Flash Attention","local":"using-pytorch-native-attention-and-flash-attention","sections":[],"depth":2}],"depth":1}';function Ns(T){return Ws(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Is}),[]}class er extends Ps{constructor(p){super(),Gs(this,p,Ns,Es,Ls,{})}}export{er as component};
