import{s as Bt,o as vt,n as kt}from"../chunks/scheduler.9991993c.js";import{S as Zt,i as Wt,g as a,s,r as p,A as Ft,h as o,f as l,c as r,j as gt,u as m,x as i,k as _t,y as Et,a as n,v as c,d as M,t as d,w as T}from"../chunks/index.7fc9a5e7.js";import{T as It}from"../chunks/Tip.9de92fc6.js";import{C as me}from"../chunks/CodeBlock.e11cba92.js";import{H as u}from"../chunks/Heading.e3de321f.js";function xt(Me){let f,y=`这是开始使用 TorchScript 进行实验的起点，我们仍在探索其在变量输入大小模型中的能力。
这是我们关注的焦点，我们将在即将发布的版本中深入分析，提供更多的代码示例、更灵活的实现以及比较
Python 代码与编译 TorchScript 的性能基准。`;return{c(){f=a("p"),f.textContent=y},l(h){f=o(h,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1gfz947"&&(f.textContent=y)},m(h,pe){n(h,f,pe)},p:kt,d(h){h&&l(f)}}}function Ht(Me){let f,y,h,pe,C,de,U,Te,V,st='根据 <a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">TorchScript 文档</a>：',fe,b,rt="<p>TorchScript 是从 PyTorch 代码创建可序列化和可优化的模型的一种方式。</p>",he,J,at=`有两个 PyTorch 模块：<a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">JIT 和 TRACE</a>。
这两个模块允许开发人员将其模型导出到其他程序中重用，比如面向效率的 C++ 程序。`,ue,j,ot=`我们提供了一个接口，允许您将 🤗 Transformers 模型导出为 TorchScript，
以便在与基于 PyTorch 的 Python 程序不同的环境中重用。
本文解释如何使用 TorchScript 导出并使用我们的模型。`,Ue,w,it="导出模型需要两个步骤：",ye,$,pt="<li>使用 <code>torchscript</code> 参数实例化模型</li> <li>使用虚拟输入进行前向传递</li>",Ce,Q,mt="这些必要条件意味着开发人员应该注意以下详细信息。",Ve,R,be,S,ct=`<code>torchscript</code> 参数是必需的，因为大多数 🤗 Transformers 语言模型的 <code>Embedding</code> 层和
<code>Decoding</code> 层之间有绑定权重。TorchScript 不允许导出具有绑定权重的模型，因此必须事先解绑和克隆权重。`,Je,N,Mt=`使用 <code>torchscript</code> 参数实例化的模型将其 <code>Embedding</code> 层和 <code>Decoding</code> 层分开，
这意味着它们不应该在后续进行训练。训练将导致这两层不同步，产生意外结果。`,je,g,dt=`对于没有语言模型头部的模型，情况不同，因为这些模型没有绑定权重。
这些模型可以安全地导出而无需 <code>torchscript</code> 参数。`,we,_,$e,B,Tt=`虚拟输入用于模型的前向传递。当输入的值传播到各层时，PyTorch 会跟踪在每个张量上执行的不同操作。
然后使用记录的操作来创建模型的 <em>trace</em> 。`,Qe,v,ft=`跟踪是相对于输入的维度创建的。因此，它受到虚拟输入的维度限制，对于任何其他序列长度或批量大小都不起作用。
当尝试使用不同大小时，会引发以下错误：`,Re,k,Se,Z,ht=`我们建议使用至少与推断期间将馈送到模型的最大输入一样大的虚拟输入大小进行跟踪。
填充可以帮助填补缺失的值。然而，由于模型是使用更大的输入大小进行跟踪的，矩阵的维度也会很大，导致更多的计算。`,Ne,W,ut="在每个输入上执行的操作总数要仔细考虑，并在导出不同序列长度模型时密切关注性能。",ge,F,_e,E,Ut="本节演示了如何保存和加载模型以及如何使用 trace 进行推断。",Be,I,ve,x,yt=`要使用 TorchScript 导出 <code>BertModel</code>，请从 <code>BertConfig</code> 类实例化 <code>BertModel</code>，
然后将其保存到名为 <code>traced_bert.pt</code> 的磁盘文件中：`,ke,H,Ze,z,We,A,Ct="现在，您可以从磁盘加载先前保存的 <code>BertModel</code>、<code>traced_bert.pt</code>，并在先前初始化的 <code>dummy_input</code> 上使用：",Fe,G,Ee,O,Ie,X,Vt="通过使用其 <code>__call__</code> dunder 方法使用 trace 模型进行推断：",xe,L,He,D,ze,P,bt=`AWS 引入了用于云端低成本、高性能机器学习推理的
<a href="https://aws.amazon.com/ec2/instance-types/inf1/" rel="nofollow">Amazon EC2 Inf1</a> 实例系列。
Inf1 实例由 AWS Inferentia 芯片提供支持，这是一款专为深度学习推理工作负载而构建的定制硬件加速器。
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/#" rel="nofollow">AWS Neuron</a> 是
Inferentia 的 SDK，支持对 transformers 模型进行跟踪和优化，以便在 Inf1 上部署。Neuron SDK 提供：`,Ae,Y,Jt=`<li>简单易用的 API，只需更改一行代码即可为云端推理跟踪和优化 TorchScript 模型。</li> <li>针对<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/benchmark/" rel="nofollow">改进的性能成本</a>的即插即用性能优化。</li> <li>支持使用 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/bert_tutorial/tutorial_pretrained_bert.html" rel="nofollow">PyTorch</a>
或 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/tensorflow/huggingface_bert/huggingface_bert.html" rel="nofollow">TensorFlow</a>
构建的 Hugging Face transformers 模型。</li>`,Ge,K,Oe,q,jt=`基于 <a href="https://huggingface.co/docs/transformers/main/model_doc/bert" rel="nofollow">BERT（来自 Transformers 的双向编码器表示）</a>架构的
transformers 模型，或其变体，如 <a href="https://huggingface.co/docs/transformers/main/model_doc/distilbert" rel="nofollow">distilBERT</a>
和 <a href="https://huggingface.co/docs/transformers/main/model_doc/roberta" rel="nofollow">roBERTa</a> 在 Inf1 上运行最佳，
可用于生成抽取式问答、序列分类和标记分类等任务。然而，文本生成任务仍可以适应在 Inf1 上运行，
如这篇 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/transformers-marianmt.html" rel="nofollow">AWS Neuron MarianMT 教程</a>所述。
有关可以直接在 Inferentia 上转换的模型的更多信息，请参阅 Neuron 文档的<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/models/models-inferentia.html#models-inferentia" rel="nofollow">模型架构适配</a>章节。`,Xe,ee,Le,te,wt=`使用 AWS Neuron 将模型转换为模型需要一个
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/neuron-frameworks/pytorch-neuron/index.html#installation-guide" rel="nofollow">Neuron SDK 环境</a>，
它已经预先配置在 <a href="https://docs.aws.amazon.com/dlami/latest/devguide/tutorial-inferentia-launching.html" rel="nofollow">AWS 深度学习 AMI</a>上。`,De,le,Pe,ne,$t=`使用与 <a href="torchscript#using-torchscript-in-python">Python 中使用 TorchScript</a> 相同的代码来跟踪
<code>BertModel</code> 以将模型转换为 AWS NEURON。导入 <code>torch.neuron</code> 框架扩展以通过 Python API 访问 Neuron SDK 的组件：`,Ye,se,Ke,re,Qt="您只需要修改下面这一行：",qe,ae,et,oe,Rt="这样就能使 Neuron SDK 跟踪模型并对其进行优化，以在 Inf1 实例上运行。",tt,ie,St=`要了解有关 AWS Neuron SDK 功能、工具、示例教程和最新更新的更多信息，
请参阅 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/index.html" rel="nofollow">AWS NeuronSDK 文档</a>。`,lt,ce,nt;return C=new u({props:{title:"导出为 TorchScript",local:"导出为-torchscript",headingTag:"h1"}}),U=new It({props:{$$slots:{default:[xt]},$$scope:{ctx:Me}}}),R=new u({props:{title:"TorchScript 参数和绑定权重",local:"torchscript-参数和绑定权重",headingTag:"h2"}}),_=new u({props:{title:"虚拟输入和标准长度",local:"虚拟输入和标准长度",headingTag:"h2"}}),k=new me({props:{code:"JTYwVGhlJTIwZXhwYW5kZWQlMjBzaXplJTIwb2YlMjB0aGUlMjB0ZW5zb3IlMjAoMyklMjBtdXN0JTIwbWF0Y2glMjB0aGUlMjBleGlzdGluZyUyMHNpemUlMjAoNyklMjBhdCUyMG5vbi1zaW5nbGV0b24lMjBkaW1lbnNpb24lMjAyJTYw",highlighted:"`The expanded size of the tensor (3) must match the existing size (7) at non-singleton dimension 2`",wrap:!1}}),F=new u({props:{title:"在 Python 中使用 TorchScript",local:"在-python-中使用-torchscript",headingTag:"h2"}}),I=new u({props:{title:"保存模型",local:"保存模型",headingTag:"h3"}}),H=new me({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch

enc = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-comment"># 对输入文本分词</span>
text = <span class="hljs-string">&quot;[CLS] Who was Jim Henson ? [SEP] Jim Henson was a puppeteer [SEP]&quot;</span>
tokenized_text = enc.tokenize(text)

<span class="hljs-comment"># 屏蔽一个输入 token</span>
masked_index = <span class="hljs-number">8</span>
tokenized_text[masked_index] = <span class="hljs-string">&quot;[MASK]&quot;</span>
indexed_tokens = enc.convert_tokens_to_ids(tokenized_text)
segments_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]

<span class="hljs-comment"># 创建虚拟输入</span>
tokens_tensor = torch.tensor([indexed_tokens])
segments_tensors = torch.tensor([segments_ids])
dummy_input = [tokens_tensor, segments_tensors]

<span class="hljs-comment"># 使用 torchscript 参数初始化模型</span>
<span class="hljs-comment"># 即使此模型没有 LM Head，也将参数设置为 True。</span>
config = BertConfig(
    vocab_size_or_config_json_file=<span class="hljs-number">32000</span>,
    hidden_size=<span class="hljs-number">768</span>,
    num_hidden_layers=<span class="hljs-number">12</span>,
    num_attention_heads=<span class="hljs-number">12</span>,
    intermediate_size=<span class="hljs-number">3072</span>,
    torchscript=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># 实例化模型</span>
model = BertModel(config)

<span class="hljs-comment"># 模型需要处于评估模式</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># 如果您使用 *from_pretrained* 实例化模型，还可以轻松设置 TorchScript 参数</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>, torchscript=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># 创建 trace</span>
traced_model = torch.jit.trace(model, [tokens_tensor, segments_tensors])
torch.jit.save(traced_model, <span class="hljs-string">&quot;traced_bert.pt&quot;</span>)`,wrap:!1}}),z=new u({props:{title:"加载模型",local:"加载模型",headingTag:"h3"}}),G=new me({props:{code:"bG9hZGVkX21vZGVsJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydHJhY2VkX2JlcnQucHQlMjIpJTBBbG9hZGVkX21vZGVsLmV2YWwoKSUwQSUwQWFsbF9lbmNvZGVyX2xheWVycyUyQyUyMHBvb2xlZF9vdXRwdXQlMjAlM0QlMjBsb2FkZWRfbW9kZWwoKmR1bW15X2lucHV0KQ==",highlighted:`loaded_model = torch.jit.load(<span class="hljs-string">&quot;traced_bert.pt&quot;</span>)
loaded_model.<span class="hljs-built_in">eval</span>()

all_encoder_layers, pooled_output = loaded_model(*dummy_input)`,wrap:!1}}),O=new u({props:{title:"使用 trace 模型进行推断",local:"使用-trace-模型进行推断",headingTag:"h3"}}),L=new me({props:{code:"dHJhY2VkX21vZGVsKHRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzKQ==",highlighted:"traced_model(tokens_tensor, segments_tensors)",wrap:!1}}),D=new u({props:{title:"使用 Neuron SDK 将 Hugging Face TorchScript 模型部署到 AWS",local:"使用-neuron-sdk-将-hugging-face-torchscript-模型部署到-aws",headingTag:"h2"}}),K=new u({props:{title:"影响",local:"影响",headingTag:"h3"}}),ee=new u({props:{title:"依赖关系",local:"依赖关系",headingTag:"h3"}}),le=new u({props:{title:"将模型转换为 AWS Neuron",local:"将模型转换为-aws-neuron",headingTag:"h3"}}),se=new me({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUyQyUyMEJlcnRUb2tlbml6ZXIlMkMlMjBCZXJ0Q29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5uZXVyb24=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.neuron`,wrap:!1}}),ae=new me({props:{code:"LSUyMHRvcmNoLmppdC50cmFjZShtb2RlbCUyQyUyMCU1QnRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzJTVEKSUwQSUyQiUyMHRvcmNoLm5ldXJvbi50cmFjZShtb2RlbCUyQyUyMCU1QnRva2VuX3RlbnNvciUyQyUyMHNlZ21lbnRzX3RlbnNvcnMlNUQp",highlighted:`<span class="hljs-deletion">- torch.jit.trace(model, [tokens_tensor, segments_tensors])</span>
<span class="hljs-addition">+ torch.neuron.trace(model, [token_tensor, segments_tensors])</span>`,wrap:!1}}),{c(){f=a("meta"),y=s(),h=a("p"),pe=s(),p(C.$$.fragment),de=s(),p(U.$$.fragment),Te=s(),V=a("p"),V.innerHTML=st,fe=s(),b=a("blockquote"),b.innerHTML=rt,he=s(),J=a("p"),J.innerHTML=at,ue=s(),j=a("p"),j.textContent=ot,Ue=s(),w=a("p"),w.textContent=it,ye=s(),$=a("ul"),$.innerHTML=pt,Ce=s(),Q=a("p"),Q.textContent=mt,Ve=s(),p(R.$$.fragment),be=s(),S=a("p"),S.innerHTML=ct,Je=s(),N=a("p"),N.innerHTML=Mt,je=s(),g=a("p"),g.innerHTML=dt,we=s(),p(_.$$.fragment),$e=s(),B=a("p"),B.innerHTML=Tt,Qe=s(),v=a("p"),v.textContent=ft,Re=s(),p(k.$$.fragment),Se=s(),Z=a("p"),Z.textContent=ht,Ne=s(),W=a("p"),W.textContent=ut,ge=s(),p(F.$$.fragment),_e=s(),E=a("p"),E.textContent=Ut,Be=s(),p(I.$$.fragment),ve=s(),x=a("p"),x.innerHTML=yt,ke=s(),p(H.$$.fragment),Ze=s(),p(z.$$.fragment),We=s(),A=a("p"),A.innerHTML=Ct,Fe=s(),p(G.$$.fragment),Ee=s(),p(O.$$.fragment),Ie=s(),X=a("p"),X.innerHTML=Vt,xe=s(),p(L.$$.fragment),He=s(),p(D.$$.fragment),ze=s(),P=a("p"),P.innerHTML=bt,Ae=s(),Y=a("ol"),Y.innerHTML=Jt,Ge=s(),p(K.$$.fragment),Oe=s(),q=a("p"),q.innerHTML=jt,Xe=s(),p(ee.$$.fragment),Le=s(),te=a("p"),te.innerHTML=wt,De=s(),p(le.$$.fragment),Pe=s(),ne=a("p"),ne.innerHTML=$t,Ye=s(),p(se.$$.fragment),Ke=s(),re=a("p"),re.textContent=Qt,qe=s(),p(ae.$$.fragment),et=s(),oe=a("p"),oe.textContent=Rt,tt=s(),ie=a("p"),ie.innerHTML=St,lt=s(),ce=a("p"),this.h()},l(e){const t=Ft("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),y=r(e),h=o(e,"P",{}),gt(h).forEach(l),pe=r(e),m(C.$$.fragment,e),de=r(e),m(U.$$.fragment,e),Te=r(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-s0qya2"&&(V.innerHTML=st),fe=r(e),b=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),i(b)!=="svelte-rlo4iu"&&(b.innerHTML=rt),he=r(e),J=o(e,"P",{"data-svelte-h":!0}),i(J)!=="svelte-n5bnu6"&&(J.innerHTML=at),ue=r(e),j=o(e,"P",{"data-svelte-h":!0}),i(j)!=="svelte-13dtdru"&&(j.textContent=ot),Ue=r(e),w=o(e,"P",{"data-svelte-h":!0}),i(w)!=="svelte-12yrypg"&&(w.textContent=it),ye=r(e),$=o(e,"UL",{"data-svelte-h":!0}),i($)!=="svelte-1fh86cr"&&($.innerHTML=pt),Ce=r(e),Q=o(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1fwt0g0"&&(Q.textContent=mt),Ve=r(e),m(R.$$.fragment,e),be=r(e),S=o(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1xhai90"&&(S.innerHTML=ct),Je=r(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1rblw4n"&&(N.innerHTML=Mt),je=r(e),g=o(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1rojuw1"&&(g.innerHTML=dt),we=r(e),m(_.$$.fragment,e),$e=r(e),B=o(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-3rxu07"&&(B.innerHTML=Tt),Qe=r(e),v=o(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1ha254l"&&(v.textContent=ft),Re=r(e),m(k.$$.fragment,e),Se=r(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-19fynrt"&&(Z.textContent=ht),Ne=r(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1surt3l"&&(W.textContent=ut),ge=r(e),m(F.$$.fragment,e),_e=r(e),E=o(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1d41jn5"&&(E.textContent=Ut),Be=r(e),m(I.$$.fragment,e),ve=r(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1l6vll5"&&(x.innerHTML=yt),ke=r(e),m(H.$$.fragment,e),Ze=r(e),m(z.$$.fragment,e),We=r(e),A=o(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-8mcedk"&&(A.innerHTML=Ct),Fe=r(e),m(G.$$.fragment,e),Ee=r(e),m(O.$$.fragment,e),Ie=r(e),X=o(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-15zasob"&&(X.innerHTML=Vt),xe=r(e),m(L.$$.fragment,e),He=r(e),m(D.$$.fragment,e),ze=r(e),P=o(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-qtxveh"&&(P.innerHTML=bt),Ae=r(e),Y=o(e,"OL",{"data-svelte-h":!0}),i(Y)!=="svelte-pj5pw8"&&(Y.innerHTML=Jt),Ge=r(e),m(K.$$.fragment,e),Oe=r(e),q=o(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-8m4g1s"&&(q.innerHTML=jt),Xe=r(e),m(ee.$$.fragment,e),Le=r(e),te=o(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-y456f4"&&(te.innerHTML=wt),De=r(e),m(le.$$.fragment,e),Pe=r(e),ne=o(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-1u7opmj"&&(ne.innerHTML=$t),Ye=r(e),m(se.$$.fragment,e),Ke=r(e),re=o(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-1t1ndji"&&(re.textContent=Qt),qe=r(e),m(ae.$$.fragment,e),et=r(e),oe=o(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1t6xzzv"&&(oe.textContent=Rt),tt=r(e),ie=o(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-1tzl0b4"&&(ie.innerHTML=St),lt=r(e),ce=o(e,"P",{}),gt(ce).forEach(l),this.h()},h(){_t(f,"name","hf:doc:metadata"),_t(f,"content",zt)},m(e,t){Et(document.head,f),n(e,y,t),n(e,h,t),n(e,pe,t),c(C,e,t),n(e,de,t),c(U,e,t),n(e,Te,t),n(e,V,t),n(e,fe,t),n(e,b,t),n(e,he,t),n(e,J,t),n(e,ue,t),n(e,j,t),n(e,Ue,t),n(e,w,t),n(e,ye,t),n(e,$,t),n(e,Ce,t),n(e,Q,t),n(e,Ve,t),c(R,e,t),n(e,be,t),n(e,S,t),n(e,Je,t),n(e,N,t),n(e,je,t),n(e,g,t),n(e,we,t),c(_,e,t),n(e,$e,t),n(e,B,t),n(e,Qe,t),n(e,v,t),n(e,Re,t),c(k,e,t),n(e,Se,t),n(e,Z,t),n(e,Ne,t),n(e,W,t),n(e,ge,t),c(F,e,t),n(e,_e,t),n(e,E,t),n(e,Be,t),c(I,e,t),n(e,ve,t),n(e,x,t),n(e,ke,t),c(H,e,t),n(e,Ze,t),c(z,e,t),n(e,We,t),n(e,A,t),n(e,Fe,t),c(G,e,t),n(e,Ee,t),c(O,e,t),n(e,Ie,t),n(e,X,t),n(e,xe,t),c(L,e,t),n(e,He,t),c(D,e,t),n(e,ze,t),n(e,P,t),n(e,Ae,t),n(e,Y,t),n(e,Ge,t),c(K,e,t),n(e,Oe,t),n(e,q,t),n(e,Xe,t),c(ee,e,t),n(e,Le,t),n(e,te,t),n(e,De,t),c(le,e,t),n(e,Pe,t),n(e,ne,t),n(e,Ye,t),c(se,e,t),n(e,Ke,t),n(e,re,t),n(e,qe,t),c(ae,e,t),n(e,et,t),n(e,oe,t),n(e,tt,t),n(e,ie,t),n(e,lt,t),n(e,ce,t),nt=!0},p(e,[t]){const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),U.$set(Nt)},i(e){nt||(M(C.$$.fragment,e),M(U.$$.fragment,e),M(R.$$.fragment,e),M(_.$$.fragment,e),M(k.$$.fragment,e),M(F.$$.fragment,e),M(I.$$.fragment,e),M(H.$$.fragment,e),M(z.$$.fragment,e),M(G.$$.fragment,e),M(O.$$.fragment,e),M(L.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),nt=!0)},o(e){d(C.$$.fragment,e),d(U.$$.fragment,e),d(R.$$.fragment,e),d(_.$$.fragment,e),d(k.$$.fragment,e),d(F.$$.fragment,e),d(I.$$.fragment,e),d(H.$$.fragment,e),d(z.$$.fragment,e),d(G.$$.fragment,e),d(O.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),nt=!1},d(e){e&&(l(y),l(h),l(pe),l(de),l(Te),l(V),l(fe),l(b),l(he),l(J),l(ue),l(j),l(Ue),l(w),l(ye),l($),l(Ce),l(Q),l(Ve),l(be),l(S),l(Je),l(N),l(je),l(g),l(we),l($e),l(B),l(Qe),l(v),l(Re),l(Se),l(Z),l(Ne),l(W),l(ge),l(_e),l(E),l(Be),l(ve),l(x),l(ke),l(Ze),l(We),l(A),l(Fe),l(Ee),l(Ie),l(X),l(xe),l(He),l(ze),l(P),l(Ae),l(Y),l(Ge),l(Oe),l(q),l(Xe),l(Le),l(te),l(De),l(Pe),l(ne),l(Ye),l(Ke),l(re),l(qe),l(et),l(oe),l(tt),l(ie),l(lt),l(ce)),l(f),T(C,e),T(U,e),T(R,e),T(_,e),T(k,e),T(F,e),T(I,e),T(H,e),T(z,e),T(G,e),T(O,e),T(L,e),T(D,e),T(K,e),T(ee,e),T(le,e),T(se,e),T(ae,e)}}}const zt='{"title":"导出为 TorchScript","local":"导出为-torchscript","sections":[{"title":"TorchScript 参数和绑定权重","local":"torchscript-参数和绑定权重","sections":[],"depth":2},{"title":"虚拟输入和标准长度","local":"虚拟输入和标准长度","sections":[],"depth":2},{"title":"在 Python 中使用 TorchScript","local":"在-python-中使用-torchscript","sections":[{"title":"保存模型","local":"保存模型","sections":[],"depth":3},{"title":"加载模型","local":"加载模型","sections":[],"depth":3},{"title":"使用 trace 模型进行推断","local":"使用-trace-模型进行推断","sections":[],"depth":3}],"depth":2},{"title":"使用 Neuron SDK 将 Hugging Face TorchScript 模型部署到 AWS","local":"使用-neuron-sdk-将-hugging-face-torchscript-模型部署到-aws","sections":[{"title":"影响","local":"影响","sections":[],"depth":3},{"title":"依赖关系","local":"依赖关系","sections":[],"depth":3},{"title":"将模型转换为 AWS Neuron","local":"将模型转换为-aws-neuron","sections":[],"depth":3}],"depth":2}],"depth":1}';function At(Me){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends Zt{constructor(f){super(),Wt(this,f,At,Ht,Bt,{})}}export{Pt as component};
