import{s as lo,f as eo,o as so,n as ks}from"../chunks/scheduler.25b97de1.js";import{S as no,i as oo,g as a,s as n,r,A as ao,h as i,f as l,c as o,j as to,u as d,x as p,k as Ws,y as io,a as s,v as m,d as u,t as c,w as M}from"../chunks/index.d9030fc9.js";import{T as xs}from"../chunks/Tip.baa67368.js";import{C as w}from"../chunks/CodeBlock.e6cd0d95.js";import{D as po}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as T,E as ro}from"../chunks/EditOnGithub.91d95064.js";function mo(J){let h,b='Read <a href="https://huggingface.co/blog/open-source-llms-as-agents" rel="nofollow">Open-source LLMs as LangChain Agents</a> blog post to learn more the ReAct agent.';return{c(){h=a("p"),h.innerHTML=b},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-15lyhbx"&&(h.innerHTML=b)},m(y,f){s(y,h,f)},p:ks,d(y){y&&l(h)}}}function uo(J){let h,b=`Please make sure to define the <code>&lt;&lt;tool_descriptions&gt;&gt;</code> string somewhere in the <code>template</code> so the agent is aware
of the available tools.`;return{c(){h=a("p"),h.innerHTML=b},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-xo5gv6"&&(h.innerHTML=b)},m(y,f){s(y,h,f)},p:ks,d(y){y&&l(h)}}}function co(J){let h,b="Beware when adding tools to an agent that already works well because it can bias selection towards your tool or select another tool other than the one already defined.";return{c(){h=a("p"),h.textContent=b},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-fotfby"&&(h.textContent=b)},m(y,f){s(y,h,f)},p:ks,d(y){y&&l(h)}}}function Mo(J){let h,b="gradio-tools require <em>textual</em> inputs and outputs even when working with different modalities like image and audio objects. Image and audio inputs and outputs are currently incompatible.";return{c(){h=a("p"),h.innerHTML=b},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1vfyu6i"&&(h.innerHTML=b)},m(y,f){s(y,h,f)},p:ks,d(y){y&&l(h)}}}function ho(J){let h,b,y,f,G,Bt,B,Zt,Z,It,I,Rs='Large Language Models (LLMs) trained to perform <a href="./tasks/language_modeling.">causal language modeling</a> can tackle a wide range of tasks, but they often struggle with basic tasks like logic, calculation, and search. When prompted in domains in which they do not perform well, they often fail to generate the answer we expect them to.',$t,$,_s="One approach to overcome this weakness is to create an <em>agent</em>.",Ct,C,Hs="An agent is a system that uses an LLM as its engine, and it has access to functions called <em>tools</em>.",Wt,W,Vs="These <em>tools</em> are functions for performing a task, and they contain all necessary description for the agent to properly use them.",xt,x,Ys="The agent can be programmed to:",kt,k,Xs="<li>devise a series of actions/tools and run them all at once like the <code>CodeAgent</code> for example</li> <li>plan and execute actions/tools one by one and wait for the outcome of each action before launching the next one like the <code>ReactJsonAgent</code> for example</li>",Rt,R,_t,_,Ht,H,Qs="This agent has a planning step, then generates python code to execute all its actions at once. It natively handles different input and output types for its tools, thus it is the recommended choice for multimodal tasks.",Vt,V,Yt,Y,Ns='This is the go-to agent to solve reasoning tasks, since the ReAct framework (<a href="https://huggingface.co/papers/2210.03629" rel="nofollow">Yao et al., 2022</a>) makes it really efficient to think on the basis of its previous observations.',Xt,X,zs="We implement two versions of ReactJsonAgent:",Qt,Q,Fs='<li><a href="/docs/transformers/v4.41.3/en/main_classes/agent#transformers.ReactJsonAgent">~ReactJsonAgent</a> generates tool calls as a JSON in its output.</li> <li><a href="/docs/transformers/v4.41.3/en/main_classes/agent#transformers.ReactCodeAgent">~ReactCodeAgent</a> is a new type of ReactJsonAgent that generates its tool calls as blobs of code, which works really well for LLMs that have strong coding performance.</li>',Nt,g,zt,N,Es='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/open-source-llms-as-agents/ReAct.png" alt="Framework of a React Agent"/>',Ft,z,Ss="For example, here is how a ReAct agent would work its way through the following question.",Et,F,St,E,Lt,S,Ls="To initialize an agent, you need these arguments:",At,L,As="<li>an LLM to power your agent - the agent is not exactly the LLM, it’s more like the agent is a program that uses an LLM as its engine.</li> <li>a system prompt: what the LLM engine will be prompted with to generate its output</li> <li>a toolbox from which the agent pick tools to execute</li> <li>a parser to extract from the LLM output which tools are to call and with which arguments</li>",qt,A,qs="Upon initialization of the agent system, the tool attributes are used to generate a tool description, then baked into the agent’s <code>system_prompt</code> to let it know which tools it can use and why.",Pt,q,Ps="To start with, please install the <code>agents</code> extras in order to install all default dependencies.",Dt,P,Kt,D,Ds='Build your LLM engine by defining a <code>llm_engine</code> method which accepts a list of <a href="./chat_templating.">messages</a> and returns text. This callable also needs to accept a <code>stop</code> argument that indicates when to stop generating.',Ot,K,el,O,Ks="You could use any <code>llm_engine</code> method as long as:",tl,ee,Os='<li>it follows the <a href="./chat_templating.md">messages format</a> for its input (<code>List[Dict[str, str]]</code>) and returns a <code>str</code></li> <li>it stops generating outputs at the sequences passed in the argument <code>stop</code></li>',ll,te,en="You also need a <code>tools</code> argument which accepts a list of <code>Tools</code>. You can provide an empty list for <code>tools</code>, but use the default toolbox with the optional argument <code>add_base_tools=True</code>.",sl,le,tn="Now you can create an agent, like <code>CodeAgent</code>, and run it. For convenience, we also provide the <code>HfEngine</code> class that uses <code>huggingface_hub.InferenceClient</code> under the hood.",nl,se,ol,ne,ln=`This will be handy in case of emergency baguette need!
You can even leave the argument <code>llm_engine</code> undefined, and an [~HfEngine] will be created by default.`,al,oe,il,ae,sn="Note that we used an additional <code>sentence</code> argument: you can pass text as additional arguments to the model.",pl,ie,nn="You can also use this to indicate the path to local or remote files for the model to use:",rl,pe,dl,re,on="The prompt and output parser were automatically defined, but you can easily inspect them by calling the <code>system_prompt_template</code> on your agent.",ml,de,ul,me,an=`It’s important to explain as clearly as possible the task you want to perform.
Every <a href="/docs/transformers/v4.41.3/en/main_classes/agent#transformers.Agent.run">run()</a> operation is independent, and since an agent is powered by an LLM, minor variations in your prompt might yield completely different results.
You can also run an agent consecutively for different tasks: each time the attributes <code>agent.task</code> and <code>agent.logs</code> will be re-initialized.`,cl,ue,Ml,ce,pn=`A Python interpreter executes the code on a set of inputs passed along with your tools.
This should be safe because the only functions that can be called are the tools you provided (especially if it’s only tools by Hugging Face) and the print function, so you’re already limited in what can be executed.`,hl,Me,rn="The Python interpreter also doesn’t allow any attribute lookup or imports (which shouldn’t be needed for passing inputs/outputs to a small set of functions) so all the most obvious attacks shouldn’t be an issue.",yl,he,dn="The execution will stop at any code trying to perform an illegal operation or if there is a regular Python error with the code generated by the agent.",wl,ye,bl,we,mn="An agent, or rather the LLM that drives the agent, generates an output based on the system prompt. The system prompt can be customized and tailored to the intended task. For example, check the system prompt for the <code>ReactCodeAgent</code> (below version is slightly simplified).",Tl,be,fl,Te,un="The system prompt includes:",Jl,fe,cn="<li>An <em>introduction</em> that explains how the agent should behave and what tools are.</li> <li>A description of all the tools that is defined by a <code>&lt;&lt;tool_descriptions&gt;&gt;</code> token that is dynamically replaced at runtime with the tools defined/chosen by the user.<ul><li>The tool description comes from the tool attributes, <code>name</code>, <code>description</code>, <code>inputs</code> and <code>output_type</code>,  and a simple <code>jinja2</code> template that you can refine.</li></ul></li> <li>The expected output format.</li>",gl,Je,Mn="You could improve the system prompt, for example, by adding an explanation of the output format.",Ul,ge,hn="For maximum flexibility, you can overwrite the whole system prompt template by passing your custom prompt as an argument to the <code>system_prompt</code> parameter.",jl,Ue,vl,U,Gl,je,Bl,ve,yn="A tool is an atomic function to be used by an agent.",Zl,Ge,wn="You can for instance check the [~PythonInterpreterTool]: it has a name, a description, input descriptions, an output type, and a <code>__call__</code> method to perform the action.",Il,Be,bn="When the agent is initialized, the tool attributes are used to generate a tool description which is baked into the agent’s system prompt. This lets the agent know which tools it can use and why.",$l,Ze,Cl,Ie,Tn="Transformers comes with a default toolbox for empowering agents, that you can add to your agent upon initialization with argument <code>add_base_tools = True</code>:",Wl,$e,fn='<li><strong>Document question answering</strong>: given a document (such as a PDF) in image format, answer a question on this document (<a href="./model_doc/donut">Donut</a>)</li> <li><strong>Image question answering</strong>: given an image, answer a question on this image (<a href="./model_doc/vilt">VILT</a>)</li> <li><strong>Speech to text</strong>: given an audio recording of a person talking, transcribe the speech into text (<a href="./model_doc/whisper">Whisper</a>)</li> <li><strong>Text to speech</strong>: convert text to speech (<a href="./model_doc/speecht5">SpeechT5</a>)</li> <li><strong>Translation</strong>: translates a given sentence from source language to target language.</li> <li><strong>Python code interpreter</strong>: runs your the LLM generated Python code in a secure environment. This tool will only be added to [~ReactJsonAgent] if you use <code>add_base_tools=True</code>, since code-based tools can already execute Python code</li>',xl,Ce,Jn='You can manually use a tool by calling the <a href="/docs/transformers/v4.41.3/en/main_classes/agent#transformers.load_tool">load_tool()</a> function and a task to perform.',kl,We,Rl,xe,_l,ke,gn=`You can create your own tool for use cases not covered by the default tools from Hugging Face.
For example, let’s create a tool that returns the most downloaded model for a given task from the Hub.`,Hl,Re,Un="You’ll start with the code below.",Vl,_e,Yl,He,jn='This code can be converted into a class that inherits from the <a href="/docs/transformers/v4.41.3/en/main_classes/agent#transformers.Tool">Tool</a> superclass.',Xl,Ve,vn="The custom tool needs:",Ql,Ye,Gn="<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name is <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>",Nl,Xe,zl,Qe,Bn="Now that the custom <code>HfModelDownloadsTool</code> class is ready, you can save it to a file named <code>model_downloads.py</code> and import it for use.",Fl,Ne,El,ze,Zn='You can also share your custom tool to the Hub by calling <a href="/docs/transformers/v4.41.3/en/main_classes/agent#transformers.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Sl,Fe,Ll,Ee,In="Load the tool with the <code>~Tool.load_tool</code> function and pass it to the <code>tools</code> parameter in your agent.",Al,Se,ql,Le,$n="You get the following:",Pl,Ae,Dl,qe,Cn=`And the output:
<code>&quot;The most downloaded model for the &#39;text-to-video&#39; task is ByteDance/AnimateDiff-Lightning.&quot;</code>`,Kl,Pe,Ol,De,Wn="If you have already initialized an agent, it is inconvenient to reinitialize it from scratch with a tool you want to use. With Transformers, you can manage an agent’s toolbox by adding or replacing a tool.",es,Ke,xn="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",ts,Oe,ls,et,kn="Now we can leverage both the new tool and the previous text-to-speech tool:",ss,tt,ns,lt,Rn='<thead><tr><th><strong>Audio</strong></th></tr></thead> <tbody><tr><td><audio controls=""><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/damo.wav" type="audio/wav"/></audio></td></tr></tbody>',os,j,as,st,_n=`Use the <code>agent.toolbox.update_tool()</code> method to replace an existing tool in the agent’s toolbox.
This is useful if your new tool is a one-to-one replacement of the existing tool because the agent already knows how to perform that specific task.
Just make sure the new tool follows the same API as the replaced tool or adapt the system prompt template to ensure all examples using the replaced tool are updated.`,is,nt,ps,ot,Hn=`You can leverage tool collections by using the ToolCollection object, with the slug of the collection you want to use.
Then pass them as a list to initialize you agent, and start using them!`,rs,at,ds,it,Vn="To speed up the start, tools are loaded only if called by the agent.",ms,pt,Yn="This gets you this image:",us,jt,Xn,cs,rt,Ms,dt,Qn=`<a href="https://github.com/freddyaboulton/gradio-tools" rel="nofollow">gradio-tools</a> is a powerful library that allows using Hugging
Face Spaces as tools. It supports many existing Spaces as well as custom Spaces.`,hs,mt,Nn='Transformers supports <code>gradio_tools</code> with the <a href="/docs/transformers/v4.41.3/en/main_classes/agent#transformers.Tool.from_gradio">Tool.from_gradio()</a> method. For example, let’s use the <a href="https://github.com/freddyaboulton/gradio-tools/blob/main/gradio_tools/tools/prompt_generator.py" rel="nofollow"><code>StableDiffusionPromptGeneratorTool</code></a> from <code>gradio-tools</code> toolkit for improving prompts to generate better images.',ys,ut,zn="Import and instantiate the tool, then pass it to the <code>Tool.from_gradio</code> method:",ws,ct,bs,Mt,Fn="Now you can use it just like any other tool. For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code>.",Ts,ht,fs,yt,En="The model adequately leverages the tool:",Js,wt,gs,bt,Sn="Before finally generating the image:",Us,vt,Ln,js,v,vs,Tt,Gs,ft,An=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,Bs,Jt,qn="Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.",Zs,gt,Is,Ut,$s,Gt,Cs;return G=new T({props:{title:"Agents and tools",local:"agents-and-tools",headingTag:"h1"}}),B=new po({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/agents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/agents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/agents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/agents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/agents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/agents.ipynb"}]}}),Z=new T({props:{title:"What is an agent?",local:"what-is-an-agent",headingTag:"h3"}}),R=new T({props:{title:"Types of agents",local:"types-of-agents",headingTag:"h3"}}),_=new T({props:{title:"Code agent",local:"code-agent",headingTag:"h4"}}),V=new T({props:{title:"React agents",local:"react-agents",headingTag:"h4"}}),g=new xs({props:{warning:!1,$$slots:{default:[mo]},$$scope:{ctx:J}}}),F=new w({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkhvdyUyMG1hbnklMjBtb3JlJTIwYmxvY2tzJTIwKGFsc28lMjBkZW5vdGVkJTIwYXMlMjBsYXllcnMpJTIwaW4lMjBCRVJUJTIwYmFzZSUyMGVuY29kZXIlMjB0aGFuJTIwdGhlJTIwZW5jb2RlciUyMGZyb20lMjB0aGUlMjBhcmNoaXRlY3R1cmUlMjBwcm9wb3NlZCUyMGluJTIwQXR0ZW50aW9uJTIwaXMlMjBBbGwlMjBZb3UlMjBOZWVkJTNGJTIyJTJDJTBBKSUwQSUwQSUwQSUwQQ==",highlighted:`&gt;&gt;&gt; agent.<span class="hljs-built_in">run</span>(
<span class="hljs-built_in">..</span>.     <span class="hljs-string">&quot;How many more blocks (also denoted as layers) in BERT base encoder than the encoder from the architecture proposed in Attention is All You Need?&quot;</span>,
<span class="hljs-built_in">..</span>. )
=====New <span class="hljs-attribute">task</span>=====
How many more blocks (also denoted as layers) <span class="hljs-keyword">in</span> BERT base encoder than the encoder <span class="hljs-keyword">from</span> the architecture proposed <span class="hljs-keyword">in</span> Attention is All You Need?
====Agent is executing the code below:
bert_blocks = search(<span class="hljs-attribute">query</span>=<span class="hljs-string">&quot;number of blocks in BERT base encoder&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;BERT blocks:&quot;</span>, bert_blocks)
====
<span class="hljs-built_in">Print</span> outputs:
BERT blocks: twelve encoder blocks

====Agent is executing the code below:
attention_layer = search(<span class="hljs-attribute">query</span>=<span class="hljs-string">&quot;number of layers in Attention is All You Need&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Attention layers:&quot;</span>, attention_layer)
====
<span class="hljs-built_in">Print</span> outputs:
Attention layers: Encoder: The encoder is composed of a stack of N = 6 identical layers. Each layer has two sub-layers. The first is a multi-head self-attention mechanism, <span class="hljs-keyword">and</span> the second is a simple, position- 2<span class="hljs-built_in"> Page </span>3 Figure 1: The Transformer - model architecture.

====Agent is executing the code below:
bert_blocks = 12
attention_layers = 6
diff = bert_blocks - attention_layers
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Difference in blocks:&quot;</span>, diff)
final_answer(diff)
====

<span class="hljs-built_in">Print</span> outputs:
Difference <span class="hljs-keyword">in</span> blocks: 6

Final answer: 6`,wrap:!1}}),E=new T({props:{title:"How can I build an agent?",local:"how-can-i-build-an-agent",headingTag:"h3"}}),P=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyU1QmFnZW50cyU1RA==",highlighted:"pip install transformers[agents]",wrap:!1}}),K=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTJDJTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBbG9naW4oJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIpJTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBJTBBZGVmJTIwbGxtX2VuZ2luZShtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTIyVGFzayUyMiU1RCklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQuY2hhdF9jb21wbGV0aW9uKG1lc3NhZ2VzJTJDJTIwc3RvcCUzRHN0b3Bfc2VxdWVuY2VzJTJDJTIwbWF4X3Rva2VucyUzRDEwMDApJTBBJTIwJTIwJTIwJTIwYW5zd2VyJTIwJTNEJTIwcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYW5zd2Vy",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login, InferenceClient

login(<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)

client = InferenceClient(model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">llm_engine</span>(<span class="hljs-params">messages, stop_sequences=[<span class="hljs-string">&quot;Task&quot;</span>]</span>) -&gt; <span class="hljs-built_in">str</span>:
    response = client.chat_completion(messages, stop=stop_sequences, max_tokens=<span class="hljs-number">1000</span>)
    answer = response.choices[<span class="hljs-number">0</span>].message.content
    <span class="hljs-keyword">return</span> answer`,wrap:!1}}),se=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEhmRW5naW5lJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmRW5naW5lKG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyQ291bGQlMjB5b3UlMjB0cmFuc2xhdGUlMjB0aGlzJTIwc2VudGVuY2UlMjBmcm9tJTIwRnJlbmNoJTJDJTIwc2F5JTIwaXQlMjBvdXQlMjBsb3VkJTIwYW5kJTIwcmV0dXJuJTIwdGhlJTIwYXVkaW8uJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2VudGVuY2UlM0QlMjJPJUMzJUI5JTIwZXN0JTIwbGElMjBib3VsYW5nZXJpZSUyMGxhJTIwcGx1cyUyMHByb2NoZSUzRiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeAgent, HfEngine

llm_engine = HfEngine(model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
agent = CodeAgent(tools=[], llm_engine=llm_engine, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Could you translate this sentence from French, say it out loud and return the audio.&quot;</span>,
    sentence=<span class="hljs-string">&quot;Où est la boulangerie la plus proche?&quot;</span>,
)`,wrap:!1}}),oe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJDb3VsZCUyMHlvdSUyMHRyYW5zbGF0ZSUyMHRoaXMlMjBzZW50ZW5jZSUyMGZyb20lMjBGcmVuY2glMkMlMjBzYXklMjBpdCUyMG91dCUyMGxvdWQlMjBhbmQlMjBnaXZlJTIwbWUlMjB0aGUlMjBhdWRpby4lMjIlMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZSUzRCUyMk8lQzMlQjklMjBlc3QlMjBsYSUyMGJvdWxhbmdlcmllJTIwbGElMjBwbHVzJTIwcHJvY2hlJTNGJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeAgent

agent = CodeAgent(tools=[], add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Could you translate this sentence from French, say it out loud and give me the audio.&quot;</span>,
    sentence=<span class="hljs-string">&quot;Où est la boulangerie la plus proche?&quot;</span>,
)`,wrap:!1}}),pe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMGxsbV9lbmdpbmUlM0RsbG1fZW5naW5lJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUwQWFnZW50LnJ1biglMjJXaHklMjBkb2VzJTIwTWlrZSUyMG5vdCUyMGtub3clMjBtYW55JTIwcGVvcGxlJTIwaW4lMjBOZXclMjBZb3JrJTNGJTIyJTJDJTIwYXVkaW8lM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZyZWNvcmRpbmcubXAzJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[], llm_engine=llm_engine, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Why does Mike not know many people in New York?&quot;</span>, audio=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/recording.mp3&quot;</span>)`,wrap:!1}}),de=new w({props:{code:"cHJpbnQoYWdlbnQuc3lzdGVtX3Byb21wdF90ZW1wbGF0ZSk=",highlighted:'<span class="hljs-built_in">print</span>(agent.system_prompt_template)',wrap:!1}}),ue=new T({props:{title:"Code execution",local:"code-execution",headingTag:"h4"}}),ye=new T({props:{title:"The system prompt",local:"the-system-prompt",headingTag:"h3"}}),be=new w({props:{code:"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",highlighted:`You will be given a task to solve as best you can.
You have access to the following tools:
&lt;&lt;tool_descriptions&gt;&gt;

To solve the task, you must plan forward to proceed in a series of steps, in a cycle of &#x27;Thought:&#x27;, &#x27;Code:&#x27;, and &#x27;Observation:&#x27; sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task, then the tools that you want to use.
Then in the &#x27;Code:&#x27; sequence, you shold write the code in simple Python. The code sequence must end with &#x27;/End code&#x27; sequence.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then be available in the &#x27;Observation:&#x27; field, for using this information as input for the next step.

In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
{examples}

Above example were using notional tools that might not exist for you. You only have acces to those tools:
&lt;&lt;tool_names&gt;&gt;
You also can perform computations in the python code you generate.

Always provide a &#x27;Thought:&#x27; and a &#x27;Code:\\n\`\`\`py&#x27; sequence ending with &#x27;\`\`\`&lt;end_code&gt;&#x27; sequence. You MUST provide at least the &#x27;Code:&#x27; sequence to move forward.

Remember to not perform too many operations in a single code block! You should split the task into intermediate code blocks.
Print results at the end of each step to save the intermediate results. Then use final_answer() to return the final result.

Remember to make sure that variables you use are all defined.

Now Begin!`,wrap:!1}}),Ue=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0SnNvbkFnZW50JTBBZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBQeXRob25JbnRlcnByZXRlclRvb2wlMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0SnNvbkFnZW50KHRvb2xzJTNEJTVCUHl0aG9uSW50ZXJwcmV0ZXJUb29sKCklNUQlMkMlMjBzeXN0ZW1fcHJvbXB0JTNEJTIyJTdCeW91cl9jdXN0b21fcHJvbXB0JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactJsonAgent
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> PythonInterpreterTool

agent = ReactJsonAgent(tools=[PythonInterpreterTool()], system_prompt=<span class="hljs-string">&quot;{your_custom_prompt}&quot;</span>)`,wrap:!1}}),U=new xs({props:{warning:!0,$$slots:{default:[uo]},$$scope:{ctx:J}}}),je=new T({props:{title:"Tools",local:"tools",headingTag:"h2"}}),Ze=new T({props:{title:"Default toolbox",local:"default-toolbox",headingTag:"h3"}}),We=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUwQSUwQXRvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIydGV4dC10by1zcGVlY2glMjIpJTBBYXVkaW8lMjAlM0QlMjB0b29sKCUyMlRoaXMlMjBpcyUyMGElMjB0ZXh0JTIwdG8lMjBzcGVlY2glMjB0b29sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool

tool = load_tool(<span class="hljs-string">&quot;text-to-speech&quot;</span>)
audio = tool(<span class="hljs-string">&quot;This is a text to speech tool&quot;</span>)`,wrap:!1}}),xe=new T({props:{title:"Create a new tool",local:"create-a-new-tool",headingTag:"h3"}}),_e=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbW9kZWxzJTBBJTBBdGFzayUyMCUzRCUyMCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMEElMEFtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBcHJpbnQobW9kZWwuaWQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

task = <span class="hljs-string">&quot;text-classification&quot;</span>

model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
<span class="hljs-built_in">print</span>(model.<span class="hljs-built_in">id</span>)`,wrap:!1}}),Xe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEFjbGFzcyUyMEhGTW9kZWxEb3dubG9hZHNUb29sKFRvb2wpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMm1vZGVsX2Rvd25sb2FkX2NvdW50ZXIlMjIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJ0aGUlMjB0YXNrJTIwY2F0ZWdvcnklMjAoc3VjaCUyMGFzJTIwdGV4dC1jbGFzc2lmaWNhdGlvbiUyQyUyMGRlcHRoLWVzdGltYXRpb24lMkMlMjBldGMpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlMjAlM0QlMjAlMjJ0ZXh0JTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = (
        <span class="hljs-string">&quot;This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub. &quot;</span>
        <span class="hljs-string">&quot;It returns the name of the checkpoint.&quot;</span>
    )

    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>`,wrap:!1}}),Ne=new w({props:{code:"ZnJvbSUyMG1vZGVsX2Rvd25sb2FkcyUyMGltcG9ydCUyMEhGTW9kZWxEb3dubG9hZHNUb29sJTBBJTBBdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> model_downloads <span class="hljs-keyword">import</span> HFModelDownloadsTool

tool = HFModelDownloadsTool()`,wrap:!1}}),Fe=new w({props:{code:"dG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGaGYtbW9kZWwtZG93bmxvYWRzJTIyKQ==",highlighted:'tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>)',wrap:!1}}),Se=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUyQyUyMENvZGVBZ2VudCUwQSUwQW1vZGVsX2Rvd25sb2FkX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJtb2RlbF9kb3dubG9hZF90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(<span class="hljs-string">&quot;m-ric/hf-model-downloads&quot;</span>)
agent = CodeAgent(tools=[model_download_tool], llm_engine=llm_engine)
agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub?&quot;</span>
)`,wrap:!1}}),Ae=new w({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwTmV3JTIwdGFzayUyMCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQUNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTNGJTBBJTNEJTNEJTNEJTNEJTIwQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQSUwQW1vc3RfZG93bmxvYWRlZF9tb2RlbCUyMCUzRCUyMG1vZGVsX2Rvd25sb2FkX2NvdW50ZXIodGFzayUzRCUyMnRleHQtdG8tdmlkZW8lMjIpJTBBcHJpbnQoZiUyMlRoZSUyMG1vc3QlMjBkb3dubG9hZGVkJTIwbW9kZWwlMjBmb3IlMjB0aGUlMjAndGV4dC10by12aWRlbyclMjB0YXNrJTIwaXMlMjAlN0Jtb3N0X2Rvd25sb2FkZWRfbW9kZWwlN0QuJTIyKSUwQSUzRCUzRCUzRCUzRA==",highlighted:`======== New task ========
Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub?
==== Agent is executing the code below:
most_downloaded_model = model_download_counter(task=&quot;text-to-video&quot;)
print(f&quot;The most downloaded model for the &#x27;text-to-video&#x27; task is {most_downloaded_model}.&quot;)
====`,wrap:!1}}),Pe=new T({props:{title:"Manage agent toolbox",local:"manage-agent-toolbox",headingTag:"h3"}}),Oe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBYWdlbnQudG9vbGJveC5hZGRfdG9vbChtb2RlbF9kb3dubG9hZF90b29sKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeAgent

agent = CodeAgent(tools=[], llm_engine=llm_engine, add_base_tools=<span class="hljs-literal">True</span>)
agent.toolbox.add_tool(model_download_tool)`,wrap:!1}}),tt=new w({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMHJlYWQlMjBvdXQlMjBsb3VkJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwbW9kZWwlMjB0aGF0JTIwaGFzJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkcyUyMGluJTIwdGhlJTIwJ3RleHQtdG8tdmlkZW8nJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIlMjBhbmQlMjByZXR1cm4lMjB0aGUlMjBhdWRpbyUzRiUyMiUwQSk=",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you read out loud the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub and return the audio?&quot;</span>
)`,wrap:!1}}),j=new xs({props:{warning:!0,$$slots:{default:[co]},$$scope:{ctx:J}}}),nt=new T({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),at=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2xDb2xsZWN0aW9uJTJDJTIwUmVhY3RDb2RlQWdlbnQlMEElMEFpbWFnZV90b29sX2NvbGxlY3Rpb24lMjAlM0QlMjBUb29sQ29sbGVjdGlvbihjb2xsZWN0aW9uX3NsdWclM0QlMjJodWdnaW5nZmFjZS10b29scyUyRmRpZmZ1c2lvbi10b29scy02NjMwYmIxOWE5NDJjMjMwNmEyY2RiNmYlMjIpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QippbWFnZV90b29sX2NvbGxlY3Rpb24udG9vbHMlNUQlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUyMlBsZWFzZSUyMGRyYXclMjBtZSUyMGElMjBwaWN0dXJlJTIwb2YlMjByaXZlcnMlMjBhbmQlMjBsYWtlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ToolCollection, ReactCodeAgent

image_tool_collection = ToolCollection(collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>)
agent = ReactCodeAgent(tools=[*image_tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),rt=new T({props:{title:"Use gradio-tools",local:"use-gradio-tools",headingTag:"h3"}}),ct=new w({props:{code:"ZnJvbSUyMGdyYWRpb190b29scyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblByb21wdEdlbmVyYXRvclRvb2wlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVG9vbCUyQyUyMGxvYWRfdG9vbCUyQyUyMENvZGVBZ2VudCUwQSUwQWdyYWRpb19wcm9tcHRfZ2VuZXJhdG9yX3Rvb2wlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Qcm9tcHRHZW5lcmF0b3JUb29sKCklMEFwcm9tcHRfZ2VuZXJhdG9yX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fZ3JhZGlvKGdyYWRpb19wcm9tcHRfZ2VuZXJhdG9yX3Rvb2wp",highlighted:`<span class="hljs-keyword">from</span> gradio_tools <span class="hljs-keyword">import</span> StableDiffusionPromptGeneratorTool
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, load_tool, CodeAgent

gradio_prompt_generator_tool = StableDiffusionPromptGeneratorTool()
prompt_generator_tool = Tool.from_gradio(gradio_prompt_generator_tool)`,wrap:!1}}),ht=new w({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwbG9hZF90b29sKCdodWdnaW5nZmFjZS10b29scyUyRnRleHQtdG8taW1hZ2UnKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCcHJvbXB0X2dlbmVyYXRvcl90b29sJTJDJTIwaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTIyJTJDJTIwcHJvbXB0JTNEJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclMEEp",highlighted:`image_generation_tool = load_tool(<span class="hljs-string">&#x27;huggingface-tools/text-to-image&#x27;</span>)
agent = CodeAgent(tools=[prompt_generator_tool, image_generation_tool], llm_engine=llm_engine)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, prompt=<span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>
)`,wrap:!1}}),wt=new w({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwTmV3JTIwdGFzayUyMCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQUltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTBBWW91JTIwaGF2ZSUyMGJlZW4lMjBwcm92aWRlZCUyMHdpdGglMjB0aGVzZSUyMGluaXRpYWwlMjBhcmd1bWVudHMlM0ElMjAlN0IncHJvbXB0JyUzQSUyMCdBJTIwcmFiYml0JTIwd2VhcmluZyUyMGElMjBzcGFjZSUyMHN1aXQnJTdELiUwQSUzRCUzRCUzRCUzRCUyMEFnZW50JTIwaXMlMjBleGVjdXRpbmclMjB0aGUlMjBjb2RlJTIwYmVsb3clM0ElMEFpbXByb3ZlZF9wcm9tcHQlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Qcm9tcHRHZW5lcmF0b3IocXVlcnklM0Rwcm9tcHQpJTBBd2hpbGUlMjBpbXByb3ZlZF9wcm9tcHQlMjAlM0QlM0QlMjAlMjJRVUVVRV9GVUxMJTIyJTNBJTBBJTIwJTIwJTIwJTIwaW1wcm92ZWRfcHJvbXB0JTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUHJvbXB0R2VuZXJhdG9yKHF1ZXJ5JTNEcHJvbXB0KSUwQXByaW50KGYlMjJUaGUlMjBpbXByb3ZlZCUyMHByb21wdCUyMGlzJTIwJTdCaW1wcm92ZWRfcHJvbXB0JTdELiUyMiklMEFpbWFnZSUyMCUzRCUyMGltYWdlX2dlbmVyYXRvcihwcm9tcHQlM0RpbXByb3ZlZF9wcm9tcHQpJTBBJTNEJTNEJTNEJTNE",highlighted:`======== New task ========
Improve this prompt, then generate an image of it.
You have been provided with these initial arguments: {&#x27;prompt&#x27;: &#x27;A rabbit wearing a space suit&#x27;}.
==== Agent is executing the code below:
improved_prompt = StableDiffusionPromptGenerator(query=prompt)
while improved_prompt == &quot;QUEUE_FULL&quot;:
    improved_prompt = StableDiffusionPromptGenerator(query=prompt)
print(f&quot;The improved prompt is {improved_prompt}.&quot;)
image = image_generator(prompt=improved_prompt)
====`,wrap:!1}}),v=new xs({props:{warning:!0,$$slots:{default:[Mo]},$$scope:{ctx:J}}}),Tt=new T({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),gt=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMkMlMjBSZWFjdENvZGVBZ2VudCUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwVG9vbC5mcm9tX2xhbmdjaGFpbihsb2FkX3Rvb2xzKCU1QiUyMnNlcnBhcGklMjIlNUQpJTVCMCU1RCklMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQpJTBBJTBBYWdlbnQucnVuKCUyMkhvdyUyMG1hbnklMjBtb3JlJTIwYmxvY2tzJTIwKGFsc28lMjBkZW5vdGVkJTIwYXMlMjBsYXllcnMpJTIwaW4lMjBCRVJUJTIwYmFzZSUyMGVuY29kZXIlMjB0aGFuJTIwdGhlJTIwZW5jb2RlciUyMGZyb20lMjB0aGUlMjBhcmNoaXRlY3R1cmUlMjBwcm9wb3NlZCUyMGluJTIwQXR0ZW50aW9uJTIwaXMlMjBBbGwlMjBZb3UlMjBOZWVkJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, ReactCodeAgent

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = ReactCodeAgent(tools=[search_tool])

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) in BERT base encoder than the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),Ut=new ro({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/agents.md"}}),{c(){h=a("meta"),b=n(),y=a("p"),f=n(),r(G.$$.fragment),Bt=n(),r(B.$$.fragment),Zt=n(),r(Z.$$.fragment),It=n(),I=a("p"),I.innerHTML=Rs,$t=n(),$=a("p"),$.innerHTML=_s,Ct=n(),C=a("p"),C.innerHTML=Hs,Wt=n(),W=a("p"),W.innerHTML=Vs,xt=n(),x=a("p"),x.textContent=Ys,kt=n(),k=a("ul"),k.innerHTML=Xs,Rt=n(),r(R.$$.fragment),_t=n(),r(_.$$.fragment),Ht=n(),H=a("p"),H.textContent=Qs,Vt=n(),r(V.$$.fragment),Yt=n(),Y=a("p"),Y.innerHTML=Ns,Xt=n(),X=a("p"),X.textContent=zs,Qt=n(),Q=a("ul"),Q.innerHTML=Fs,Nt=n(),r(g.$$.fragment),zt=n(),N=a("p"),N.innerHTML=Es,Ft=n(),z=a("p"),z.textContent=Ss,Et=n(),r(F.$$.fragment),St=n(),r(E.$$.fragment),Lt=n(),S=a("p"),S.textContent=Ls,At=n(),L=a("ul"),L.innerHTML=As,qt=n(),A=a("p"),A.innerHTML=qs,Pt=n(),q=a("p"),q.innerHTML=Ps,Dt=n(),r(P.$$.fragment),Kt=n(),D=a("p"),D.innerHTML=Ds,Ot=n(),r(K.$$.fragment),el=n(),O=a("p"),O.innerHTML=Ks,tl=n(),ee=a("ol"),ee.innerHTML=Os,ll=n(),te=a("p"),te.innerHTML=en,sl=n(),le=a("p"),le.innerHTML=tn,nl=n(),r(se.$$.fragment),ol=n(),ne=a("p"),ne.innerHTML=ln,al=n(),r(oe.$$.fragment),il=n(),ae=a("p"),ae.innerHTML=sn,pl=n(),ie=a("p"),ie.textContent=nn,rl=n(),r(pe.$$.fragment),dl=n(),re=a("p"),re.innerHTML=on,ml=n(),r(de.$$.fragment),ul=n(),me=a("p"),me.innerHTML=an,cl=n(),r(ue.$$.fragment),Ml=n(),ce=a("p"),ce.textContent=pn,hl=n(),Me=a("p"),Me.textContent=rn,yl=n(),he=a("p"),he.textContent=dn,wl=n(),r(ye.$$.fragment),bl=n(),we=a("p"),we.innerHTML=mn,Tl=n(),r(be.$$.fragment),fl=n(),Te=a("p"),Te.textContent=un,Jl=n(),fe=a("ul"),fe.innerHTML=cn,gl=n(),Je=a("p"),Je.textContent=Mn,Ul=n(),ge=a("p"),ge.innerHTML=hn,jl=n(),r(Ue.$$.fragment),vl=n(),r(U.$$.fragment),Gl=n(),r(je.$$.fragment),Bl=n(),ve=a("p"),ve.textContent=yn,Zl=n(),Ge=a("p"),Ge.innerHTML=wn,Il=n(),Be=a("p"),Be.textContent=bn,$l=n(),r(Ze.$$.fragment),Cl=n(),Ie=a("p"),Ie.innerHTML=Tn,Wl=n(),$e=a("ul"),$e.innerHTML=fn,xl=n(),Ce=a("p"),Ce.innerHTML=Jn,kl=n(),r(We.$$.fragment),Rl=n(),r(xe.$$.fragment),_l=n(),ke=a("p"),ke.textContent=gn,Hl=n(),Re=a("p"),Re.textContent=Un,Vl=n(),r(_e.$$.fragment),Yl=n(),He=a("p"),He.innerHTML=jn,Xl=n(),Ve=a("p"),Ve.textContent=vn,Ql=n(),Ye=a("ul"),Ye.innerHTML=Gn,Nl=n(),r(Xe.$$.fragment),zl=n(),Qe=a("p"),Qe.innerHTML=Bn,Fl=n(),r(Ne.$$.fragment),El=n(),ze=a("p"),ze.innerHTML=Zn,Sl=n(),r(Fe.$$.fragment),Ll=n(),Ee=a("p"),Ee.innerHTML=In,Al=n(),r(Se.$$.fragment),ql=n(),Le=a("p"),Le.textContent=$n,Pl=n(),r(Ae.$$.fragment),Dl=n(),qe=a("p"),qe.innerHTML=Cn,Kl=n(),r(Pe.$$.fragment),Ol=n(),De=a("p"),De.textContent=Wn,es=n(),Ke=a("p"),Ke.innerHTML=xn,ts=n(),r(Oe.$$.fragment),ls=n(),et=a("p"),et.textContent=kn,ss=n(),r(tt.$$.fragment),ns=n(),lt=a("table"),lt.innerHTML=Rn,os=n(),r(j.$$.fragment),as=n(),st=a("p"),st.innerHTML=_n,is=n(),r(nt.$$.fragment),ps=n(),ot=a("p"),ot.textContent=Hn,rs=n(),r(at.$$.fragment),ds=n(),it=a("p"),it.textContent=Vn,ms=n(),pt=a("p"),pt.textContent=Yn,us=n(),jt=a("img"),cs=n(),r(rt.$$.fragment),Ms=n(),dt=a("p"),dt.innerHTML=Qn,hs=n(),mt=a("p"),mt.innerHTML=Nn,ys=n(),ut=a("p"),ut.innerHTML=zn,ws=n(),r(ct.$$.fragment),bs=n(),Mt=a("p"),Mt.innerHTML=Fn,Ts=n(),r(ht.$$.fragment),fs=n(),yt=a("p"),yt.textContent=En,Js=n(),r(wt.$$.fragment),gs=n(),bt=a("p"),bt.textContent=Sn,Us=n(),vt=a("img"),js=n(),r(v.$$.fragment),vs=n(),r(Tt.$$.fragment),Gs=n(),ft=a("p"),ft.innerHTML=An,Bs=n(),Jt=a("p"),Jt.textContent=qn,Zs=n(),r(gt.$$.fragment),Is=n(),r(Ut.$$.fragment),$s=n(),Gt=a("p"),this.h()},l(e){const t=ao("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),b=o(e),y=i(e,"P",{}),to(y).forEach(l),f=o(e),d(G.$$.fragment,e),Bt=o(e),d(B.$$.fragment,e),Zt=o(e),d(Z.$$.fragment,e),It=o(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1fkpjtq"&&(I.innerHTML=Rs),$t=o(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1c8vvla"&&($.innerHTML=_s),Ct=o(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-ueie6c"&&(C.innerHTML=Hs),Wt=o(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1v15icf"&&(W.innerHTML=Vs),xt=o(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1oh78rs"&&(x.textContent=Ys),kt=o(e),k=i(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-1u7wtlk"&&(k.innerHTML=Xs),Rt=o(e),d(R.$$.fragment,e),_t=o(e),d(_.$$.fragment,e),Ht=o(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1o9o1oq"&&(H.textContent=Qs),Vt=o(e),d(V.$$.fragment,e),Yt=o(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-un0fb8"&&(Y.innerHTML=Ns),Xt=o(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1jksgzv"&&(X.textContent=zs),Qt=o(e),Q=i(e,"UL",{"data-svelte-h":!0}),p(Q)!=="svelte-1so62zv"&&(Q.innerHTML=Fs),Nt=o(e),d(g.$$.fragment,e),zt=o(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-f8aw2d"&&(N.innerHTML=Es),Ft=o(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-avm166"&&(z.textContent=Ss),Et=o(e),d(F.$$.fragment,e),St=o(e),d(E.$$.fragment,e),Lt=o(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1vwgkxv"&&(S.textContent=Ls),At=o(e),L=i(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-peqpvl"&&(L.innerHTML=As),qt=o(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1pl6btk"&&(A.innerHTML=qs),Pt=o(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1dv7sdf"&&(q.innerHTML=Ps),Dt=o(e),d(P.$$.fragment,e),Kt=o(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-16hu4e5"&&(D.innerHTML=Ds),Ot=o(e),d(K.$$.fragment,e),el=o(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-f52dcf"&&(O.innerHTML=Ks),tl=o(e),ee=i(e,"OL",{"data-svelte-h":!0}),p(ee)!=="svelte-1eem0dk"&&(ee.innerHTML=Os),ll=o(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-cyf9a5"&&(te.innerHTML=en),sl=o(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1skktl"&&(le.innerHTML=tn),nl=o(e),d(se.$$.fragment,e),ol=o(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1jcg9mk"&&(ne.innerHTML=ln),al=o(e),d(oe.$$.fragment,e),il=o(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1sxtmn2"&&(ae.innerHTML=sn),pl=o(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-18l0kfm"&&(ie.textContent=nn),rl=o(e),d(pe.$$.fragment,e),dl=o(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1d0hijn"&&(re.innerHTML=on),ml=o(e),d(de.$$.fragment,e),ul=o(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-sgc4o2"&&(me.innerHTML=an),cl=o(e),d(ue.$$.fragment,e),Ml=o(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1ysbw77"&&(ce.textContent=pn),hl=o(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-m29zy5"&&(Me.textContent=rn),yl=o(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1iiqbq7"&&(he.textContent=dn),wl=o(e),d(ye.$$.fragment,e),bl=o(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-t1ea5t"&&(we.innerHTML=mn),Tl=o(e),d(be.$$.fragment,e),fl=o(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1xlke9j"&&(Te.textContent=un),Jl=o(e),fe=i(e,"UL",{"data-svelte-h":!0}),p(fe)!=="svelte-1jdqerr"&&(fe.innerHTML=cn),gl=o(e),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1poc7fx"&&(Je.textContent=Mn),Ul=o(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-2xz207"&&(ge.innerHTML=hn),jl=o(e),d(Ue.$$.fragment,e),vl=o(e),d(U.$$.fragment,e),Gl=o(e),d(je.$$.fragment,e),Bl=o(e),ve=i(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-kl6fdx"&&(ve.textContent=yn),Zl=o(e),Ge=i(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1coc3o8"&&(Ge.innerHTML=wn),Il=o(e),Be=i(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-u83m8z"&&(Be.textContent=bn),$l=o(e),d(Ze.$$.fragment,e),Cl=o(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1uj21n8"&&(Ie.innerHTML=Tn),Wl=o(e),$e=i(e,"UL",{"data-svelte-h":!0}),p($e)!=="svelte-1lxvfta"&&($e.innerHTML=fn),xl=o(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-b5qon1"&&(Ce.innerHTML=Jn),kl=o(e),d(We.$$.fragment,e),Rl=o(e),d(xe.$$.fragment,e),_l=o(e),ke=i(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-8dd7rj"&&(ke.textContent=gn),Hl=o(e),Re=i(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-jio97"&&(Re.textContent=Un),Vl=o(e),d(_e.$$.fragment,e),Yl=o(e),He=i(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-8c0i6p"&&(He.innerHTML=jn),Xl=o(e),Ve=i(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-hid0wz"&&(Ve.textContent=vn),Ql=o(e),Ye=i(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-11dnyg5"&&(Ye.innerHTML=Gn),Nl=o(e),d(Xe.$$.fragment,e),zl=o(e),Qe=i(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-58l3g5"&&(Qe.innerHTML=Bn),Fl=o(e),d(Ne.$$.fragment,e),El=o(e),ze=i(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-2d5vgw"&&(ze.innerHTML=Zn),Sl=o(e),d(Fe.$$.fragment,e),Ll=o(e),Ee=i(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-n0ukpl"&&(Ee.innerHTML=In),Al=o(e),d(Se.$$.fragment,e),ql=o(e),Le=i(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-rgc1m9"&&(Le.textContent=$n),Pl=o(e),d(Ae.$$.fragment,e),Dl=o(e),qe=i(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-di3g23"&&(qe.innerHTML=Cn),Kl=o(e),d(Pe.$$.fragment,e),Ol=o(e),De=i(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-j71532"&&(De.textContent=Wn),es=o(e),Ke=i(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-ocb8u2"&&(Ke.innerHTML=xn),ts=o(e),d(Oe.$$.fragment,e),ls=o(e),et=i(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1pyqvzc"&&(et.textContent=kn),ss=o(e),d(tt.$$.fragment,e),ns=o(e),lt=i(e,"TABLE",{"data-svelte-h":!0}),p(lt)!=="svelte-1tqzmpy"&&(lt.innerHTML=Rn),os=o(e),d(j.$$.fragment,e),as=o(e),st=i(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-zx9fzv"&&(st.innerHTML=_n),is=o(e),d(nt.$$.fragment,e),ps=o(e),ot=i(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-15fzsol"&&(ot.textContent=Hn),rs=o(e),d(at.$$.fragment,e),ds=o(e),it=i(e,"P",{"data-svelte-h":!0}),p(it)!=="svelte-6r1jgt"&&(it.textContent=Vn),ms=o(e),pt=i(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1azl0wr"&&(pt.textContent=Yn),us=o(e),jt=i(e,"IMG",{src:!0}),cs=o(e),d(rt.$$.fragment,e),Ms=o(e),dt=i(e,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-c328x"&&(dt.innerHTML=Qn),hs=o(e),mt=i(e,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-1ryjlva"&&(mt.innerHTML=Nn),ys=o(e),ut=i(e,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-6fvul5"&&(ut.innerHTML=zn),ws=o(e),d(ct.$$.fragment,e),bs=o(e),Mt=i(e,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-14hvnbw"&&(Mt.innerHTML=Fn),Ts=o(e),d(ht.$$.fragment,e),fs=o(e),yt=i(e,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-1ss743w"&&(yt.textContent=En),Js=o(e),d(wt.$$.fragment,e),gs=o(e),bt=i(e,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-euaib0"&&(bt.textContent=Sn),Us=o(e),vt=i(e,"IMG",{src:!0}),js=o(e),d(v.$$.fragment,e),vs=o(e),d(Tt.$$.fragment,e),Gs=o(e),ft=i(e,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-1rq40pf"&&(ft.innerHTML=An),Bs=o(e),Jt=i(e,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-aqowof"&&(Jt.textContent=qn),Zs=o(e),d(gt.$$.fragment,e),Is=o(e),d(Ut.$$.fragment,e),$s=o(e),Gt=i(e,"P",{}),to(Gt).forEach(l),this.h()},h(){Ws(h,"name","hf:doc:metadata"),Ws(h,"content",yo),eo(jt.src,Xn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rivers_and_lakes.png")||Ws(jt,"src",Xn),eo(vt.src,Ln="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png")||Ws(vt,"src",Ln)},m(e,t){io(document.head,h),s(e,b,t),s(e,y,t),s(e,f,t),m(G,e,t),s(e,Bt,t),m(B,e,t),s(e,Zt,t),m(Z,e,t),s(e,It,t),s(e,I,t),s(e,$t,t),s(e,$,t),s(e,Ct,t),s(e,C,t),s(e,Wt,t),s(e,W,t),s(e,xt,t),s(e,x,t),s(e,kt,t),s(e,k,t),s(e,Rt,t),m(R,e,t),s(e,_t,t),m(_,e,t),s(e,Ht,t),s(e,H,t),s(e,Vt,t),m(V,e,t),s(e,Yt,t),s(e,Y,t),s(e,Xt,t),s(e,X,t),s(e,Qt,t),s(e,Q,t),s(e,Nt,t),m(g,e,t),s(e,zt,t),s(e,N,t),s(e,Ft,t),s(e,z,t),s(e,Et,t),m(F,e,t),s(e,St,t),m(E,e,t),s(e,Lt,t),s(e,S,t),s(e,At,t),s(e,L,t),s(e,qt,t),s(e,A,t),s(e,Pt,t),s(e,q,t),s(e,Dt,t),m(P,e,t),s(e,Kt,t),s(e,D,t),s(e,Ot,t),m(K,e,t),s(e,el,t),s(e,O,t),s(e,tl,t),s(e,ee,t),s(e,ll,t),s(e,te,t),s(e,sl,t),s(e,le,t),s(e,nl,t),m(se,e,t),s(e,ol,t),s(e,ne,t),s(e,al,t),m(oe,e,t),s(e,il,t),s(e,ae,t),s(e,pl,t),s(e,ie,t),s(e,rl,t),m(pe,e,t),s(e,dl,t),s(e,re,t),s(e,ml,t),m(de,e,t),s(e,ul,t),s(e,me,t),s(e,cl,t),m(ue,e,t),s(e,Ml,t),s(e,ce,t),s(e,hl,t),s(e,Me,t),s(e,yl,t),s(e,he,t),s(e,wl,t),m(ye,e,t),s(e,bl,t),s(e,we,t),s(e,Tl,t),m(be,e,t),s(e,fl,t),s(e,Te,t),s(e,Jl,t),s(e,fe,t),s(e,gl,t),s(e,Je,t),s(e,Ul,t),s(e,ge,t),s(e,jl,t),m(Ue,e,t),s(e,vl,t),m(U,e,t),s(e,Gl,t),m(je,e,t),s(e,Bl,t),s(e,ve,t),s(e,Zl,t),s(e,Ge,t),s(e,Il,t),s(e,Be,t),s(e,$l,t),m(Ze,e,t),s(e,Cl,t),s(e,Ie,t),s(e,Wl,t),s(e,$e,t),s(e,xl,t),s(e,Ce,t),s(e,kl,t),m(We,e,t),s(e,Rl,t),m(xe,e,t),s(e,_l,t),s(e,ke,t),s(e,Hl,t),s(e,Re,t),s(e,Vl,t),m(_e,e,t),s(e,Yl,t),s(e,He,t),s(e,Xl,t),s(e,Ve,t),s(e,Ql,t),s(e,Ye,t),s(e,Nl,t),m(Xe,e,t),s(e,zl,t),s(e,Qe,t),s(e,Fl,t),m(Ne,e,t),s(e,El,t),s(e,ze,t),s(e,Sl,t),m(Fe,e,t),s(e,Ll,t),s(e,Ee,t),s(e,Al,t),m(Se,e,t),s(e,ql,t),s(e,Le,t),s(e,Pl,t),m(Ae,e,t),s(e,Dl,t),s(e,qe,t),s(e,Kl,t),m(Pe,e,t),s(e,Ol,t),s(e,De,t),s(e,es,t),s(e,Ke,t),s(e,ts,t),m(Oe,e,t),s(e,ls,t),s(e,et,t),s(e,ss,t),m(tt,e,t),s(e,ns,t),s(e,lt,t),s(e,os,t),m(j,e,t),s(e,as,t),s(e,st,t),s(e,is,t),m(nt,e,t),s(e,ps,t),s(e,ot,t),s(e,rs,t),m(at,e,t),s(e,ds,t),s(e,it,t),s(e,ms,t),s(e,pt,t),s(e,us,t),s(e,jt,t),s(e,cs,t),m(rt,e,t),s(e,Ms,t),s(e,dt,t),s(e,hs,t),s(e,mt,t),s(e,ys,t),s(e,ut,t),s(e,ws,t),m(ct,e,t),s(e,bs,t),s(e,Mt,t),s(e,Ts,t),m(ht,e,t),s(e,fs,t),s(e,yt,t),s(e,Js,t),m(wt,e,t),s(e,gs,t),s(e,bt,t),s(e,Us,t),s(e,vt,t),s(e,js,t),m(v,e,t),s(e,vs,t),m(Tt,e,t),s(e,Gs,t),s(e,ft,t),s(e,Bs,t),s(e,Jt,t),s(e,Zs,t),m(gt,e,t),s(e,Is,t),m(Ut,e,t),s(e,$s,t),s(e,Gt,t),Cs=!0},p(e,[t]){const Pn={};t&2&&(Pn.$$scope={dirty:t,ctx:e}),g.$set(Pn);const Dn={};t&2&&(Dn.$$scope={dirty:t,ctx:e}),U.$set(Dn);const Kn={};t&2&&(Kn.$$scope={dirty:t,ctx:e}),j.$set(Kn);const On={};t&2&&(On.$$scope={dirty:t,ctx:e}),v.$set(On)},i(e){Cs||(u(G.$$.fragment,e),u(B.$$.fragment,e),u(Z.$$.fragment,e),u(R.$$.fragment,e),u(_.$$.fragment,e),u(V.$$.fragment,e),u(g.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(se.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(be.$$.fragment,e),u(Ue.$$.fragment,e),u(U.$$.fragment,e),u(je.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u(xe.$$.fragment,e),u(_e.$$.fragment,e),u(Xe.$$.fragment,e),u(Ne.$$.fragment,e),u(Fe.$$.fragment,e),u(Se.$$.fragment,e),u(Ae.$$.fragment,e),u(Pe.$$.fragment,e),u(Oe.$$.fragment,e),u(tt.$$.fragment,e),u(j.$$.fragment,e),u(nt.$$.fragment,e),u(at.$$.fragment,e),u(rt.$$.fragment,e),u(ct.$$.fragment,e),u(ht.$$.fragment,e),u(wt.$$.fragment,e),u(v.$$.fragment,e),u(Tt.$$.fragment,e),u(gt.$$.fragment,e),u(Ut.$$.fragment,e),Cs=!0)},o(e){c(G.$$.fragment,e),c(B.$$.fragment,e),c(Z.$$.fragment,e),c(R.$$.fragment,e),c(_.$$.fragment,e),c(V.$$.fragment,e),c(g.$$.fragment,e),c(F.$$.fragment,e),c(E.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(se.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(ye.$$.fragment,e),c(be.$$.fragment,e),c(Ue.$$.fragment,e),c(U.$$.fragment,e),c(je.$$.fragment,e),c(Ze.$$.fragment,e),c(We.$$.fragment,e),c(xe.$$.fragment,e),c(_e.$$.fragment,e),c(Xe.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Se.$$.fragment,e),c(Ae.$$.fragment,e),c(Pe.$$.fragment,e),c(Oe.$$.fragment,e),c(tt.$$.fragment,e),c(j.$$.fragment,e),c(nt.$$.fragment,e),c(at.$$.fragment,e),c(rt.$$.fragment,e),c(ct.$$.fragment,e),c(ht.$$.fragment,e),c(wt.$$.fragment,e),c(v.$$.fragment,e),c(Tt.$$.fragment,e),c(gt.$$.fragment,e),c(Ut.$$.fragment,e),Cs=!1},d(e){e&&(l(b),l(y),l(f),l(Bt),l(Zt),l(It),l(I),l($t),l($),l(Ct),l(C),l(Wt),l(W),l(xt),l(x),l(kt),l(k),l(Rt),l(_t),l(Ht),l(H),l(Vt),l(Yt),l(Y),l(Xt),l(X),l(Qt),l(Q),l(Nt),l(zt),l(N),l(Ft),l(z),l(Et),l(St),l(Lt),l(S),l(At),l(L),l(qt),l(A),l(Pt),l(q),l(Dt),l(Kt),l(D),l(Ot),l(el),l(O),l(tl),l(ee),l(ll),l(te),l(sl),l(le),l(nl),l(ol),l(ne),l(al),l(il),l(ae),l(pl),l(ie),l(rl),l(dl),l(re),l(ml),l(ul),l(me),l(cl),l(Ml),l(ce),l(hl),l(Me),l(yl),l(he),l(wl),l(bl),l(we),l(Tl),l(fl),l(Te),l(Jl),l(fe),l(gl),l(Je),l(Ul),l(ge),l(jl),l(vl),l(Gl),l(Bl),l(ve),l(Zl),l(Ge),l(Il),l(Be),l($l),l(Cl),l(Ie),l(Wl),l($e),l(xl),l(Ce),l(kl),l(Rl),l(_l),l(ke),l(Hl),l(Re),l(Vl),l(Yl),l(He),l(Xl),l(Ve),l(Ql),l(Ye),l(Nl),l(zl),l(Qe),l(Fl),l(El),l(ze),l(Sl),l(Ll),l(Ee),l(Al),l(ql),l(Le),l(Pl),l(Dl),l(qe),l(Kl),l(Ol),l(De),l(es),l(Ke),l(ts),l(ls),l(et),l(ss),l(ns),l(lt),l(os),l(as),l(st),l(is),l(ps),l(ot),l(rs),l(ds),l(it),l(ms),l(pt),l(us),l(jt),l(cs),l(Ms),l(dt),l(hs),l(mt),l(ys),l(ut),l(ws),l(bs),l(Mt),l(Ts),l(fs),l(yt),l(Js),l(gs),l(bt),l(Us),l(vt),l(js),l(vs),l(Gs),l(ft),l(Bs),l(Jt),l(Zs),l(Is),l($s),l(Gt)),l(h),M(G,e),M(B,e),M(Z,e),M(R,e),M(_,e),M(V,e),M(g,e),M(F,e),M(E,e),M(P,e),M(K,e),M(se,e),M(oe,e),M(pe,e),M(de,e),M(ue,e),M(ye,e),M(be,e),M(Ue,e),M(U,e),M(je,e),M(Ze,e),M(We,e),M(xe,e),M(_e,e),M(Xe,e),M(Ne,e),M(Fe,e),M(Se,e),M(Ae,e),M(Pe,e),M(Oe,e),M(tt,e),M(j,e),M(nt,e),M(at,e),M(rt,e),M(ct,e),M(ht,e),M(wt,e),M(v,e),M(Tt,e),M(gt,e),M(Ut,e)}}}const yo='{"title":"Agents and tools","local":"agents-and-tools","sections":[{"title":"What is an agent?","local":"what-is-an-agent","sections":[],"depth":3},{"title":"Types of agents","local":"types-of-agents","sections":[{"title":"Code agent","local":"code-agent","sections":[],"depth":4},{"title":"React agents","local":"react-agents","sections":[],"depth":4}],"depth":3},{"title":"How can I build an agent?","local":"how-can-i-build-an-agent","sections":[{"title":"Code execution","local":"code-execution","sections":[],"depth":4}],"depth":3},{"title":"The system prompt","local":"the-system-prompt","sections":[],"depth":3},{"title":"Tools","local":"tools","sections":[{"title":"Default toolbox","local":"default-toolbox","sections":[],"depth":3},{"title":"Create a new tool","local":"create-a-new-tool","sections":[],"depth":3},{"title":"Manage agent toolbox","local":"manage-agent-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[],"depth":3},{"title":"Use gradio-tools","local":"use-gradio-tools","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3}],"depth":2}],"depth":1}';function wo(J){return so(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jo extends no{constructor(h){super(),oo(this,h,wo,ho,lo,{})}}export{jo as component};
