import{s as Ns,n as ks,o as xs}from"../chunks/scheduler.f7e1785c.js";import{S as Vs,i as Zs,g as n,s as a,u as B,A as _s,h as y,f as t,c as e,j as F,v,y as U,k as N,o as W,a as l,w as k,d as x,t as V,x as Z}from"../chunks/index.815a732f.js";import{I as zs}from"../chunks/IconCopyLink.e7937f56.js";import{C as Y}from"../chunks/CodeBlock.c6e8b464.js";function Rs(rs){let o,G,_,L,i,T,z,J,js,D,us="Streaming audio data",X,w,Is=`One of the biggest challenges faced with audio datasets is their sheer size. A single minute of uncompressed CD-quality audio (44.1kHz, 16-bit)
takes up  a bit more than 5 MB of storage. Typically, an audio dataset would contains hours of recordings.`,$,C,hs=`In the previous sections we used a very small subset of MINDS-14 audio dataset, however, typical audio datasets are much larger.
For example, the <code>xs</code> (smallest) configuration of <a href="https://huggingface.co/datasets/speechcolab/gigaspeech" rel="nofollow">GigaSpeech from SpeechColab</a>
contains only 10 hours of training data, but takes over 13GB of storage space for download and preparation. So what
happens when we want to train on a larger split? The full <code>xl</code> configuration of the same dataset contains 10,000 hours of
training data, requiring over 1TB of storage space. For most of us, this well exceeds the specifications of a typical
hard drive disk. Do we need to fork out and buy additional storage? Or is there a way we can train on these datasets with no disk space constraints?`,O,p,As=`🤗 Datasets comes to the rescue by offering the <a href="https://huggingface.co/docs/datasets/stream" rel="nofollow">streaming mode</a>. Streaming allows us to load the data progressively as
we iterate over the dataset. Rather than downloading the whole dataset at once, we load the dataset one example at a time.
We iterate over the dataset, loading and preparing examples on the fly when they are needed. This way, we only ever
load the examples that we’re using, and not the ones that we’re not!
Once we’re done with an example sample, we continue iterating over the dataset and load the next one.`,H,j,cs="Streaming mode has three primary advantages over downloading the entire dataset at once:",P,r,ds=`<li>Disk space: examples are loaded to memory one-by-one as we iterate over the dataset. Since the data is not downloaded
locally, there are no disk space requirements, so you can use datasets of arbitrary size.</li> <li>Download and processing time: audio datasets are large and need a significant amount of time to download and process.
With streaming, loading and processing is done on the fly, meaning you can start using the dataset as soon as the first
example is ready.</li> <li>Easy experimentation: you can experiment on a handful of examples to check that your script works without having to
download the entire dataset.</li>`,K,u,ms=`There is one caveat to streaming mode. When downloading a full dataset without streaming, both the raw data and processed
data are saved locally to disk. If we want to re-use this dataset, we can directly load the processed data from disk,
skipping the download and processing steps.  Consequently, we only have to perform the downloading and processing
operations once, after which we can re-use the prepared data.`,ss,I,gs=`With streaming mode, the data is not downloaded to disk. Thus, neither the downloaded nor pre-processed data are cached.
If we want to re-use the dataset, the streaming steps must be repeated, with the audio files loaded and processed on
the fly again. For this reason, it is advised to download datasets that you are likely to use multiple times.`,Ms,h,qs=`How can you enable streaming mode? Easy! Just set <code>streaming=True</code> when you load your dataset. The rest will be taken
care for you:`,ts,A,ls,c,fs=`Just like we applied preprocessing steps to a downloaded subset of MINDS-14, you can do the same preprocessing with a
streaming dataset in the exactly the same manner.`,as,d,Es=`The only difference is that you can no longer access individual samples using Python indexing (i.e. <code>gigaspeech[&quot;train&quot;][sample_idx]</code>).
Instead, you have to iterate over the dataset. Here’s how you can access an example when streaming a dataset:`,es,m,ns,g,Ss="<strong>Output:</strong>",ys,q,Us,f,bs=`If you’d like to preview several examples from a large dataset, use the <code>take()</code> to get the first n elements. Let’s grab
the first two examples in the gigaspeech dataset:`,os,E,is,S,Qs="<strong>Output:</strong>",Ts,b,Js,Q,Ds=`Streaming mode can take your research to the next level: not only are the biggest datasets accessible to you, but you
can easily evaluate systems over multiple datasets in one go without worrying about your disk space. Compared to
evaluating on a single dataset, multi-dataset evaluation gives a better metric for the generalisation abilities of a
speech recognition system (c.f. End-to-end Speech Benchmark (ESB)).`,ws,R,Cs;return J=new zs({}),A=new Y({props:{code:"Z2lnYXNwZWVjaCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzcGVlY2hjb2xhYiUyRmdpZ2FzcGVlY2glMjIlMkMlMjAlMjJ4cyUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUp",highlighted:'gigaspeech = load_dataset(<span class="hljs-string">&quot;speechcolab/gigaspeech&quot;</span>, <span class="hljs-string">&quot;xs&quot;</span>, streaming=<span class="hljs-literal">True</span>)'}}),m=new Y({props:{code:"bmV4dChpdGVyKGdpZ2FzcGVlY2glNUIlMjJ0cmFpbiUyMiU1RCkp",highlighted:'<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(gigaspeech[<span class="hljs-string">&quot;train&quot;</span>]))'}}),q=new Y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyc2VnbWVudF9pZCUyMiUzQSUyMCUyMllPVTAwMDAwMDAzMTVfUzAwMDA2NjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJzcGVha2VyJTIyJTNBJTIwJTIyTiUyRkElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyQVMlMjBUSEVZJ1JFJTIwTEVBVklORyUyMCUzQ0NPTU1BJTNFJTIwQ0FOJTIwS0FTSCUyMFBVTEwlMjBaQUhSQSUyMEFTSURFJTIwUkVBTExZJTIwUVVJQ0tMWSUyMCUzQ1FVRVNUSU9OTUFSSyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMnhzX2NodW5rc18wMDAwJTJGWU9VMDAwMDAwMDMxNV9TMDAwMDY2MC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjAuMDAwNTE4OCUyQyUyMDAuMDAwODU0NDklMkMlMjAwLjAwMDEyMjA3JTJDJTIwLi4uJTJDJTIwMC4wMDEyNTEyMiUyQyUyMDAuMDAwNzYyOTQlMkMlMjAwLjAwMDM2NjIxJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjAxNjAwMCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmJlZ2luX3RpbWUlMjIlM0ElMjAyOTQxLjg5JTJDJTBBJTIwJTIwJTIwJTIwJTIyZW5kX3RpbWUlMjIlM0ElMjAyOTQ1LjA3JTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW9faWQlMjIlM0ElMjAlMjJZT1UwMDAwMDAwMzE1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjAlMjJSZXR1cm4lMjB0byUyMFZhc3NlbGhlaW0lMjAlN0MlMjBDcml0aWNhbCUyMFJvbGUlM0ElMjBWT1glMjBNQUNISU5BJTIwJTdDJTIwRXBpc29kZSUyMDQzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cueW91dHViZS5jb20lMkZ3YXRjaCUzRnYlM0R6cjJuMWZMVmFzVSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnNvdXJjZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJjYXRlZ29yeSUyMiUzQSUyMDI0JTJDJTBBJTIwJTIwJTIwJTIwJTIyb3JpZ2luYWxfZnVsbF9wYXRoJTIyJTNBJTIwJTIyYXVkaW8lMkZ5b3V0dWJlJTJGUDAwMDQlMkZZT1UwMDAwMDAwMzE1Lm9wdXMlMjIlMkMlMEElN0Q=",highlighted:`{
    <span class="hljs-string">&quot;segment_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315_S0000660&quot;</span>,
    <span class="hljs-string">&quot;speaker&quot;</span>: <span class="hljs-string">&quot;N/A&quot;</span>,
    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;AS THEY&#x27;RE LEAVING &lt;COMMA&gt; CAN KASH PULL ZAHRA ASIDE REALLY QUICKLY &lt;QUESTIONMARK&gt;&quot;</span>,
    <span class="hljs-string">&quot;audio&quot;</span>: {
        <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;xs_chunks_0000/YOU0000000315_S0000660.wav&quot;</span>,
        <span class="hljs-string">&quot;array&quot;</span>: <span class="hljs-built_in">array</span>(
            <span class="hljs-selector-attr">[0.0005188, 0.00085449, 0.00012207, ..., 0.00125122, 0.00076294, 0.00036621]</span>
        ),
        <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-string">&quot;begin_time&quot;</span>: <span class="hljs-number">2941.89</span>,
    <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-number">2945.07</span>,
    <span class="hljs-string">&quot;audio_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315&quot;</span>,
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Return to Vasselheim | Critical Role: VOX MACHINA | Episode 43&quot;</span>,
    <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://www.youtube.com/watch?v=zr2n1fLVasU&quot;</span>,
    <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&quot;category&quot;</span>: <span class="hljs-number">24</span>,
    <span class="hljs-string">&quot;original_full_path&quot;</span>: <span class="hljs-string">&quot;audio/youtube/P0004/YOU0000000315.opus&quot;</span>,
}`}}),E=new Y({props:{code:"Z2lnYXNwZWVjaF9oZWFkJTIwJTNEJTIwZ2lnYXNwZWVjaCU1QiUyMnRyYWluJTIyJTVELnRha2UoMiklMEFsaXN0KGdpZ2FzcGVlY2hfaGVhZCk=",highlighted:`gigaspeech_head = gigaspeech[<span class="hljs-string">&quot;train&quot;</span>].take(<span class="hljs-number">2</span>)
<span class="hljs-built_in">list</span>(gigaspeech_head)`}}),b=new Y({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2VnbWVudF9pZCUyMiUzQSUyMCUyMllPVTAwMDAwMDAzMTVfUzAwMDA2NjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzcGVha2VyJTIyJTNBJTIwJTIyTiUyRkElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyQVMlMjBUSEVZJ1JFJTIwTEVBVklORyUyMCUzQ0NPTU1BJTNFJTIwQ0FOJTIwS0FTSCUyMFBVTEwlMjBaQUhSQSUyMEFTSURFJTIwUkVBTExZJTIwUVVJQ0tMWSUyMCUzQ1FVRVNUSU9OTUFSSyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMnhzX2NodW5rc18wMDAwJTJGWU9VMDAwMDAwMDMxNV9TMDAwMDY2MC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAuMDAwNTE4OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAuMDAwODU0NDklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwLjAwMDEyMjA3JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMC4wMDEyNTEyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAuMDAwNzYyOTQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwLjAwMDM2NjIxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjAxNjAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmJlZ2luX3RpbWUlMjIlM0ElMjAyOTQxLjg5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW5kX3RpbWUlMjIlM0ElMjAyOTQ1LjA3JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXVkaW9faWQlMjIlM0ElMjAlMjJZT1UwMDAwMDAwMzE1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjAlMjJSZXR1cm4lMjB0byUyMFZhc3NlbGhlaW0lMjAlN0MlMjBDcml0aWNhbCUyMFJvbGUlM0ElMjBWT1glMjBNQUNISU5BJTIwJTdDJTIwRXBpc29kZSUyMDQzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cueW91dHViZS5jb20lMkZ3YXRjaCUzRnYlM0R6cjJuMWZMVmFzVSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNvdXJjZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeSUyMiUzQSUyMDI0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3JpZ2luYWxfZnVsbF9wYXRoJTIyJTNBJTIwJTIyYXVkaW8lMkZ5b3V0dWJlJTJGUDAwMDQlMkZZT1UwMDAwMDAwMzE1Lm9wdXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZWdtZW50X2lkJTIyJTNBJTIwJTIyQVVEMDAwMDAwMTA0M19TMDAwMDc3NSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNwZWFrZXIlMjIlM0ElMjAlMjJOJTJGQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlMjJTSVglMjBUT01BVE9FUyUyMCUzQ1BFUklPRCUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMnhzX2NodW5rc18wMDAwJTJGQVVEMDAwMDAwMTA0M19TMDAwMDc3NS53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDEuNDM0MzI2MTdlLTAzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4zNzMyOTEwMmUtMDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxLjMxMjI1NTg2ZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC02LjEwMzUxNTYyZS0wNSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0xLjIyMDcwMzEyZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0xLjgzMTA1NDY5ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzYW1wbGluZ19yYXRlJTIyJTNBJTIwMTYwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiZWdpbl90aW1lJTIyJTNBJTIwMzY3My45NiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuZF90aW1lJTIyJTNBJTIwMzY3NS4yNiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmF1ZGlvX2lkJTIyJTNBJTIwJTIyQVVEMDAwMDAwMTA0MyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRpdGxlJTIyJTNBJTIwJTIyQXN0ZXJvaWQlMjBvZiUyMEZlYXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTJGJTJGd3d3LmFyY2hpdmUub3JnJTJGZG93bmxvYWQlMkZhc3Rlcm9pZF9vZl9mZWFyXzEwMTJfbGlicml2b3glMkZhc3Rlcm9pZF9vZl9mZWFyXzEwMTJfbGlicml2b3hfNjRrYl9tcDMuemlwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc291cmNlJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNhdGVnb3J5JTIyJTNBJTIwMjglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvcmlnaW5hbF9mdWxsX3BhdGglMjIlM0ElMjAlMjJhdWRpbyUyRmF1ZGlvYm9vayUyRlAwMDExJTJGQVVEMDAwMDAwMTA0My5vcHVzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVE",highlighted:`[
    {
        <span class="hljs-string">&quot;segment_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315_S0000660&quot;</span>,
        <span class="hljs-string">&quot;speaker&quot;</span>: <span class="hljs-string">&quot;N/A&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;AS THEY&#x27;RE LEAVING &lt;COMMA&gt; CAN KASH PULL ZAHRA ASIDE REALLY QUICKLY &lt;QUESTIONMARK&gt;&quot;</span>,
        <span class="hljs-string">&quot;audio&quot;</span>: {
            <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;xs_chunks_0000/YOU0000000315_S0000660.wav&quot;</span>,
            <span class="hljs-string">&quot;array&quot;</span>: array(
                [
                    <span class="hljs-number">0.0005188</span>,
                    <span class="hljs-number">0.00085449</span>,
                    <span class="hljs-number">0.00012207</span>,
                    ...,
                    <span class="hljs-number">0.00125122</span>,
                    <span class="hljs-number">0.00076294</span>,
                    <span class="hljs-number">0.00036621</span>,
                ]
            ),
            <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
        },
        <span class="hljs-string">&quot;begin_time&quot;</span>: <span class="hljs-number">2941.89</span>,
        <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-number">2945.07</span>,
        <span class="hljs-string">&quot;audio_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315&quot;</span>,
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Return to Vasselheim | Critical Role: VOX MACHINA | Episode 43&quot;</span>,
        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://www.youtube.com/watch?v=zr2n1fLVasU&quot;</span>,
        <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-number">2</span>,
        <span class="hljs-string">&quot;category&quot;</span>: <span class="hljs-number">24</span>,
        <span class="hljs-string">&quot;original_full_path&quot;</span>: <span class="hljs-string">&quot;audio/youtube/P0004/YOU0000000315.opus&quot;</span>,
    },
    {
        <span class="hljs-string">&quot;segment_id&quot;</span>: <span class="hljs-string">&quot;AUD0000001043_S0000775&quot;</span>,
        <span class="hljs-string">&quot;speaker&quot;</span>: <span class="hljs-string">&quot;N/A&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;SIX TOMATOES &lt;PERIOD&gt;&quot;</span>,
        <span class="hljs-string">&quot;audio&quot;</span>: {
            <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;xs_chunks_0000/AUD0000001043_S0000775.wav&quot;</span>,
            <span class="hljs-string">&quot;array&quot;</span>: array(
                [
                    <span class="hljs-number">1.43432617</span>e-03,
                    <span class="hljs-number">1.37329102</span>e-03,
                    <span class="hljs-number">1.31225586</span>e-03,
                    ...,
                    <span class="hljs-number">-6.10351562</span>e-05,
                    <span class="hljs-number">-1.22070312</span>e-04,
                    <span class="hljs-number">-1.83105469</span>e-04,
                ]
            ),
            <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
        },
        <span class="hljs-string">&quot;begin_time&quot;</span>: <span class="hljs-number">3673.96</span>,
        <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-number">3675.26</span>,
        <span class="hljs-string">&quot;audio_id&quot;</span>: <span class="hljs-string">&quot;AUD0000001043&quot;</span>,
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Asteroid of Fear&quot;</span>,
        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http//www.archive.org/download/asteroid_of_fear_1012_librivox/asteroid_of_fear_1012_librivox_64kb_mp3.zip&quot;</span>,
        <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-number">0</span>,
        <span class="hljs-string">&quot;category&quot;</span>: <span class="hljs-number">28</span>,
        <span class="hljs-string">&quot;original_full_path&quot;</span>: <span class="hljs-string">&quot;audio/audiobook/P0011/AUD0000001043.opus&quot;</span>,
    },
]`}}),{c(){o=n("meta"),G=a(),_=n("p"),L=a(),i=n("h1"),T=n("a"),z=n("span"),B(J.$$.fragment),js=a(),D=n("span"),D.textContent=us,X=a(),w=n("p"),w.textContent=Is,$=a(),C=n("p"),C.innerHTML=hs,O=a(),p=n("p"),p.innerHTML=As,H=a(),j=n("p"),j.textContent=cs,P=a(),r=n("ul"),r.innerHTML=ds,K=a(),u=n("p"),u.textContent=ms,ss=a(),I=n("p"),I.textContent=gs,Ms=a(),h=n("p"),h.innerHTML=qs,ts=a(),B(A.$$.fragment),ls=a(),c=n("p"),c.textContent=fs,as=a(),d=n("p"),d.innerHTML=Es,es=a(),B(m.$$.fragment),ns=a(),g=n("p"),g.innerHTML=Ss,ys=a(),B(q.$$.fragment),Us=a(),f=n("p"),f.innerHTML=bs,os=a(),B(E.$$.fragment),is=a(),S=n("p"),S.innerHTML=Qs,Ts=a(),B(b.$$.fragment),Js=a(),Q=n("p"),Q.textContent=Ds,ws=a(),R=n("p"),this.h()},l(s){const M=_s("svelte-1phssyn",document.head);o=y(M,"META",{name:!0,content:!0}),M.forEach(t),G=e(s),_=y(s,"P",{}),F(_).forEach(t),L=e(s),i=y(s,"H1",{class:!0});var ps=F(i);T=y(ps,"A",{id:!0,class:!0,href:!0});var Bs=F(T);z=y(Bs,"SPAN",{});var vs=F(z);v(J.$$.fragment,vs),vs.forEach(t),Bs.forEach(t),js=e(ps),D=y(ps,"SPAN",{"data-svelte-h":!0}),U(D)!=="svelte-rb9933"&&(D.textContent=us),ps.forEach(t),X=e(s),w=y(s,"P",{"data-svelte-h":!0}),U(w)!=="svelte-n8v3tf"&&(w.textContent=Is),$=e(s),C=y(s,"P",{"data-svelte-h":!0}),U(C)!=="svelte-nayksx"&&(C.innerHTML=hs),O=e(s),p=y(s,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1cmn14y"&&(p.innerHTML=As),H=e(s),j=y(s,"P",{"data-svelte-h":!0}),U(j)!=="svelte-1doba0z"&&(j.textContent=cs),P=e(s),r=y(s,"UL",{"data-svelte-h":!0}),U(r)!=="svelte-dy12ia"&&(r.innerHTML=ds),K=e(s),u=y(s,"P",{"data-svelte-h":!0}),U(u)!=="svelte-dhhyuw"&&(u.textContent=ms),ss=e(s),I=y(s,"P",{"data-svelte-h":!0}),U(I)!=="svelte-1b0tiu9"&&(I.textContent=gs),Ms=e(s),h=y(s,"P",{"data-svelte-h":!0}),U(h)!=="svelte-16vl0hj"&&(h.innerHTML=qs),ts=e(s),v(A.$$.fragment,s),ls=e(s),c=y(s,"P",{"data-svelte-h":!0}),U(c)!=="svelte-182p0qe"&&(c.textContent=fs),as=e(s),d=y(s,"P",{"data-svelte-h":!0}),U(d)!=="svelte-1e6b0ye"&&(d.innerHTML=Es),es=e(s),v(m.$$.fragment,s),ns=e(s),g=y(s,"P",{"data-svelte-h":!0}),U(g)!=="svelte-1mvdyro"&&(g.innerHTML=Ss),ys=e(s),v(q.$$.fragment,s),Us=e(s),f=y(s,"P",{"data-svelte-h":!0}),U(f)!=="svelte-k3iau9"&&(f.innerHTML=bs),os=e(s),v(E.$$.fragment,s),is=e(s),S=y(s,"P",{"data-svelte-h":!0}),U(S)!=="svelte-1mvdyro"&&(S.innerHTML=Qs),Ts=e(s),v(b.$$.fragment,s),Js=e(s),Q=y(s,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-1jjur40"&&(Q.textContent=Ds),ws=e(s),R=y(s,"P",{}),F(R).forEach(t),this.h()},h(){N(o,"name","hf:doc:metadata"),N(o,"content",JSON.stringify(Fs)),N(T,"id","streaming-audio-data"),N(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),N(T,"href","#streaming-audio-data"),N(i,"class","relative group")},m(s,M){W(document.head,o),l(s,G,M),l(s,_,M),l(s,L,M),l(s,i,M),W(i,T),W(T,z),k(J,z,null),W(i,js),W(i,D),l(s,X,M),l(s,w,M),l(s,$,M),l(s,C,M),l(s,O,M),l(s,p,M),l(s,H,M),l(s,j,M),l(s,P,M),l(s,r,M),l(s,K,M),l(s,u,M),l(s,ss,M),l(s,I,M),l(s,Ms,M),l(s,h,M),l(s,ts,M),k(A,s,M),l(s,ls,M),l(s,c,M),l(s,as,M),l(s,d,M),l(s,es,M),k(m,s,M),l(s,ns,M),l(s,g,M),l(s,ys,M),k(q,s,M),l(s,Us,M),l(s,f,M),l(s,os,M),k(E,s,M),l(s,is,M),l(s,S,M),l(s,Ts,M),k(b,s,M),l(s,Js,M),l(s,Q,M),l(s,ws,M),l(s,R,M),Cs=!0},p:ks,i(s){Cs||(x(J.$$.fragment,s),x(A.$$.fragment,s),x(m.$$.fragment,s),x(q.$$.fragment,s),x(E.$$.fragment,s),x(b.$$.fragment,s),Cs=!0)},o(s){V(J.$$.fragment,s),V(A.$$.fragment,s),V(m.$$.fragment,s),V(q.$$.fragment,s),V(E.$$.fragment,s),V(b.$$.fragment,s),Cs=!1},d(s){s&&(t(G),t(_),t(L),t(i),t(X),t(w),t($),t(C),t(O),t(p),t(H),t(j),t(P),t(r),t(K),t(u),t(ss),t(I),t(Ms),t(h),t(ts),t(ls),t(c),t(as),t(d),t(es),t(ns),t(g),t(ys),t(Us),t(f),t(os),t(is),t(S),t(Ts),t(Js),t(Q),t(ws),t(R)),t(o),Z(J),Z(A,s),Z(m,s),Z(q,s),Z(E,s),Z(b,s)}}}const Fs={local:"streaming-audio-data",title:"Streaming audio data"};function Ws(rs){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends Vs{constructor(o){super(),Zs(this,o,Ws,Rs,Ns,{})}}export{$s as component};
