import{s as qt,n as xt,o as _t}from"../chunks/scheduler.f7e1785c.js";import{S as At,i as zt,g as i,s as l,u as h,A as Nt,h as o,f as s,c as n,j as L,v as m,y as p,k as G,o as R,a,w as d,d as y,t as f,x as M}from"../chunks/index.815a732f.js";import{I as Wt}from"../chunks/IconCopyLink.e7937f56.js";import{C as E}from"../chunks/CodeBlock.c6e8b464.js";function Et(yt){let r,S,Q,D,c,u,F,J,dt,Z,ft="Audio classification with a pipeline",H,T,Mt=`Audio classification involves assigning one or more labels to an audio recording based on its content. The labels
could correspond to different sound categories, such as music, speech, or noise, or more specific categories like
bird song or car engine sounds.`,P,w,Jt=`Before diving into details on how the most popular audio transformers work, and before fine-tuning a custom model, let’s
see how you can use an off-the-shelf pre-trained model for audio classification with only a few lines of code with 🤗 Transformers.`,V,j,Tt=`Let’s go ahead and use the same <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a> dataset that you have explored
in the previous unit. If you recall, MINDS-14 contains recordings of people asking an e-banking system questions in several
languages and dialects, and has the <code>intent_class</code> for each recording. We can classify the recordings by intent of the call.`,X,b,wt=`Just as before, let’s start by loading the <code>en-AU</code> subset of the data to try out the pipeline, and upsample it to 16kHz
sampling rate which is what most speech models require.`,Y,g,O,U,jt=`To classify an audio recording into a set of classes, we can use the <code>audio-classification</code> pipeline from 🤗 Transformers.
In our case, we need a model that’s been fine-tuned for intent classification, and specifically on
the MINDS-14 dataset. Luckily for us, the Hub has a model that does just that! Let’s load it by using the <code>pipeline()</code> function:`,K,$,tt,I,bt=`This pipeline expects the audio data as a NumPy array. All the preprocessing of the raw audio data will be conveniently
handled for us by the pipeline. Let’s pick an example to try it out:`,et,C,st,v,gt=`If you recall the structure of the dataset, the raw audio data is stored in a NumPy array under <code>[&quot;audio&quot;][&quot;array&quot;]</code>, let’s
pass it straight to the <code>classifier</code>:`,at,k,lt,q,Ut="<strong>Output:</strong>",nt,x,it,_,$t=`The model is very confident that the caller intended to learn about paying their bill. Let’s see what the actual label for
this example is:`,ot,A,pt,z,It="<strong>Output:</strong>",rt,N,ct,W,Ct=`Hooray! The predicted label was correct! Here we were lucky to find a model that can classify the exact labels that we need.
A lot of the times, when dealing with a classification task, a pre-trained model’s set of classes is not exactly the same
as the classes you need the model to distinguish. In this case, you can fine-tune a pre-trained model to “calibrate” it to
your exact set of class labels. We’ll learn how to do this in the upcoming units. Now, let’s take a look at another very
common task in speech processing, <em>automatic speech recognition</em>.`,ut,B,ht;return J=new Wt({}),g=new E({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwbmFtZSUzRCUyMmVuLUFVJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`}}),$=new E({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJhbnRvbi1sJTJGeHRyZW1lX3NfeGxzcl8zMDBtX21pbmRzMTQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>,
    model=<span class="hljs-string">&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</span>,
)`}}),C=new E({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RA==",highlighted:'example = minds[<span class="hljs-number">0</span>]'}}),k=new E({props:{code:"Y2xhc3NpZmllcihleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:'classifier(example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])'}}),x=new E({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjk2MzE1MjUyNzgwOTE0MzElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMnBheV9iaWxsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAyODE5Njk4MzAzOTM3OTEyJTJDJTIwJTIybGFiZWwlMjIlM0ElMjAlMjJmcmVlemUlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAzMjc4NzQ5Mjk2NDQxNjc0MiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2FyZF9pc3N1ZXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAxOTQxNDQ0NTg1MDk5ODE2MyUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyYWJyb2FkJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAwMDgzNzg2OTM2MDExMTY1MzglMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMmhpZ2hfdmFsdWVfcGF5bWVudCUyMiU3RCUyQyUwQSU1RA==",highlighted:`[
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.9631525278091431</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;pay_bill&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.02819698303937912</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;freeze&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0032787492964416742</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;card_issues&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0019414445850998163</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;abroad&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0008378693601116538</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;high_value_payment&quot;</span>},
]`}}),A=new E({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`}}),N=new E({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>'}}),{c(){r=i("meta"),S=l(),Q=i("p"),D=l(),c=i("h1"),u=i("a"),F=i("span"),h(J.$$.fragment),dt=l(),Z=i("span"),Z.textContent=ft,H=l(),T=i("p"),T.textContent=Mt,P=l(),w=i("p"),w.textContent=Jt,V=l(),j=i("p"),j.innerHTML=Tt,X=l(),b=i("p"),b.innerHTML=wt,Y=l(),h(g.$$.fragment),O=l(),U=i("p"),U.innerHTML=jt,K=l(),h($.$$.fragment),tt=l(),I=i("p"),I.textContent=bt,et=l(),h(C.$$.fragment),st=l(),v=i("p"),v.innerHTML=gt,at=l(),h(k.$$.fragment),lt=l(),q=i("p"),q.innerHTML=Ut,nt=l(),h(x.$$.fragment),it=l(),_=i("p"),_.textContent=$t,ot=l(),h(A.$$.fragment),pt=l(),z=i("p"),z.innerHTML=It,rt=l(),h(N.$$.fragment),ct=l(),W=i("p"),W.innerHTML=Ct,ut=l(),B=i("p"),this.h()},l(t){const e=Nt("svelte-1phssyn",document.head);r=o(e,"META",{name:!0,content:!0}),e.forEach(s),S=n(t),Q=o(t,"P",{}),L(Q).forEach(s),D=n(t),c=o(t,"H1",{class:!0});var mt=L(c);u=o(mt,"A",{id:!0,class:!0,href:!0});var vt=L(u);F=o(vt,"SPAN",{});var kt=L(F);m(J.$$.fragment,kt),kt.forEach(s),vt.forEach(s),dt=n(mt),Z=o(mt,"SPAN",{"data-svelte-h":!0}),p(Z)!=="svelte-1kntkm"&&(Z.textContent=ft),mt.forEach(s),H=n(t),T=o(t,"P",{"data-svelte-h":!0}),p(T)!=="svelte-j9r3i6"&&(T.textContent=Mt),P=n(t),w=o(t,"P",{"data-svelte-h":!0}),p(w)!=="svelte-dub6at"&&(w.textContent=Jt),V=n(t),j=o(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1jsn8wa"&&(j.innerHTML=Tt),X=n(t),b=o(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-15x65jw"&&(b.innerHTML=wt),Y=n(t),m(g.$$.fragment,t),O=n(t),U=o(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1gi5ja6"&&(U.innerHTML=jt),K=n(t),m($.$$.fragment,t),tt=n(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-h7hari"&&(I.textContent=bt),et=n(t),m(C.$$.fragment,t),st=n(t),v=o(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-nl73ko"&&(v.innerHTML=gt),at=n(t),m(k.$$.fragment,t),lt=n(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1mvdyro"&&(q.innerHTML=Ut),nt=n(t),m(x.$$.fragment,t),it=n(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1xhxyyp"&&(_.textContent=$t),ot=n(t),m(A.$$.fragment,t),pt=n(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1mvdyro"&&(z.innerHTML=It),rt=n(t),m(N.$$.fragment,t),ct=n(t),W=o(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-66lxjm"&&(W.innerHTML=Ct),ut=n(t),B=o(t,"P",{}),L(B).forEach(s),this.h()},h(){G(r,"name","hf:doc:metadata"),G(r,"content",JSON.stringify(Zt)),G(u,"id","audio-classification-with-a-pipeline"),G(u,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),G(u,"href","#audio-classification-with-a-pipeline"),G(c,"class","relative group")},m(t,e){R(document.head,r),a(t,S,e),a(t,Q,e),a(t,D,e),a(t,c,e),R(c,u),R(u,F),d(J,F,null),R(c,dt),R(c,Z),a(t,H,e),a(t,T,e),a(t,P,e),a(t,w,e),a(t,V,e),a(t,j,e),a(t,X,e),a(t,b,e),a(t,Y,e),d(g,t,e),a(t,O,e),a(t,U,e),a(t,K,e),d($,t,e),a(t,tt,e),a(t,I,e),a(t,et,e),d(C,t,e),a(t,st,e),a(t,v,e),a(t,at,e),d(k,t,e),a(t,lt,e),a(t,q,e),a(t,nt,e),d(x,t,e),a(t,it,e),a(t,_,e),a(t,ot,e),d(A,t,e),a(t,pt,e),a(t,z,e),a(t,rt,e),d(N,t,e),a(t,ct,e),a(t,W,e),a(t,ut,e),a(t,B,e),ht=!0},p:xt,i(t){ht||(y(J.$$.fragment,t),y(g.$$.fragment,t),y($.$$.fragment,t),y(C.$$.fragment,t),y(k.$$.fragment,t),y(x.$$.fragment,t),y(A.$$.fragment,t),y(N.$$.fragment,t),ht=!0)},o(t){f(J.$$.fragment,t),f(g.$$.fragment,t),f($.$$.fragment,t),f(C.$$.fragment,t),f(k.$$.fragment,t),f(x.$$.fragment,t),f(A.$$.fragment,t),f(N.$$.fragment,t),ht=!1},d(t){t&&(s(S),s(Q),s(D),s(c),s(H),s(T),s(P),s(w),s(V),s(j),s(X),s(b),s(Y),s(O),s(U),s(K),s(tt),s(I),s(et),s(st),s(v),s(at),s(lt),s(q),s(nt),s(it),s(_),s(ot),s(pt),s(z),s(rt),s(ct),s(W),s(ut),s(B)),s(r),M(J),M(g,t),M($,t),M(C,t),M(k,t),M(x,t),M(A,t),M(N,t)}}}const Zt={local:"audio-classification-with-a-pipeline",title:"Audio classification with a pipeline"};function Gt(yt){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends At{constructor(r){super(),zt(this,r,Gt,Et,qt,{})}}export{Rt as component};
