import{s as rt,n as ut,o as ht}from"../chunks/scheduler.f7e1785c.js";import{S as ct,i as dt,g as i,s,u as h,A as mt,h as o,f as t,c as a,j as M,v as c,y as p,k as r,o as u,a as l,w as d,d as m,t as y,x as f}from"../chunks/index.815a732f.js";import{I as Qe}from"../chunks/IconCopyLink.e7937f56.js";import{C}from"../chunks/CodeBlock.c6e8b464.js";function yt(Re){let w,ae,ee,ie,g,J,te,x,Ze,D,ze="Audio generation with a pipeline",oe,k,Xe=`Audio generation encompasses a versatile set of tasks that involve producing an audio output. The tasks
that we will look into here are speech generation (aka “text-to-speech”) and music generation. In text-to-speech, a
model transforms a piece of text into lifelike spoken language sound, opening the door to applications such as virtual assistants,
accessibility tools for the visually impaired, and personalized audiobooks.
On the other hand, music generation can enable creative expression, and finds its use mostly in entertainment and game
development industries.`,pe,T,Se=`In 🤗 Transformers, you’ll find a pipeline that covers both of these tasks. This pipeline is called <code>&quot;text-to-audio&quot;</code>,
but for convenience, it also has a <code>&quot;text-to-speech&quot;</code> alias. Here we’ll use both, and you are free to pick whichever
seems more applicable for your task.`,re,j,Fe="Let’s explore how you can use this pipeline to start generating audio narration for texts, and music with just a few lines of code.",ue,G,Ne="This pipeline is new to 🤗 Transformers and comes part of the version 4.32 release. Thus you’ll need to upgrade the library to the latest version to get the feature:",he,B,ce,U,b,ne,V,He,K,Ae="Generating speech",de,I,Ee=`Let’s begin by exploring text-to-speech generation. First, just as it was the case with audio classification and automatic
speech recognition, we’ll need to define the pipeline. We’ll define a text-to-speech pipeline since it best describes our task, and use the <a href="https://huggingface.co/suno/bark-small" rel="nofollow"><code>suno/bark-small</code></a> checkpoint:`,me,_,ye,W,Pe="The next step is as simple as passing some text through the pipeline. All the preprocessing will be done for us under the hood:",fe,Z,Me,H,Ye="In a notebook, we can use the following code snippet to listen to the result:",we,q,ge,Q,Le=`The model that we’re using with the pipeline, Bark, is actually multilingual, so we can easily substitute the initial
text with a text in, say, French, and use the pipeline in the exact same way. It will pick up on the language all by itself:`,Ue,R,ve,z,De=`Not only is this model multilingual, it can also generate audio with non-verbal communications and singing. Here’s how
you can make it sing:`,Ce,X,Je,S,Ke=`We’ll dive deeper into Bark specifics in the later unit dedicated to Text-to-speech, and will also show how you can use
other models for this task. Now, let’s generate some music!`,be,v,$,le,F,qe,O,Oe="Generating music",$e,N,et='Just as before, we’ll begin by instantiating a pipeline. For music generation, we’ll define a text-to-audio pipeline, and initialise it with the pretrained checkpoint <a href="https://huggingface.co/facebook/musicgen-small" rel="nofollow"><code>facebook/musicgen-small</code></a>',xe,A,ke,E,tt="Let’s create a text description of the music we’d like to generate:",Te,P,je,Y,nt="We can control the length of the generated output by passing an additional <code>max_new_tokens</code> parameter to the model.",Ge,L,Be,se,Ve;return x=new Qe({}),B=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install --upgrade transformers"}}),V=new Qe({}),_=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tc3BlZWNoJTIyJTJDJTIwbW9kZWwlM0QlMjJzdW5vJTJGYmFyay1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-to-speech&quot;</span>, model=<span class="hljs-string">&quot;suno/bark-small&quot;</span>)`}}),Z=new C({props:{code:"dGV4dCUyMCUzRCUyMCUyMkxhZHlidWdzJTIwaGF2ZSUyMGhhZCUyMGltcG9ydGFudCUyMHJvbGVzJTIwaW4lMjBjdWx0dXJlJTIwYW5kJTIwcmVsaWdpb24lMkMlMjBiZWluZyUyMGFzc29jaWF0ZWQlMjB3aXRoJTIwbHVjayUyQyUyMGxvdmUlMkMlMjBmZXJ0aWxpdHklMjBhbmQlMjBwcm9waGVjeS4lMjAlMjIlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHRleHQp",highlighted:`text = <span class="hljs-string">&quot;Ladybugs have had important roles in culture and religion, being associated with luck, love, fertility and prophecy. &quot;</span>
output = pipe(text)`}}),q=new C({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8ob3V0cHV0JTVCJTIyYXVkaW8lMjIlNUQlMkMlMjByYXRlJTNEb3V0cHV0JTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(output[<span class="hljs-string">&quot;audio&quot;</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),R=new C({props:{code:"ZnJfdGV4dCUyMCUzRCUyMCUyMkNvbnRyYWlyZW1lbnQlMjAlQzMlQTAlMjB1bmUlMjBpZCVDMyVBOWUlMjByJUMzJUE5cGFuZHVlJTJDJTIwbGUlMjBub21icmUlMjBkZSUyMHBvaW50cyUyMHN1ciUyMGxlcyUyMCVDMyVBOWx5dHJlcyUyMGQndW5lJTIwY29jY2luZWxsZSUyMG5lJTIwY29ycmVzcG9uZCUyMHBhcyUyMCVDMyVBMCUyMHNvbiUyMCVDMyVBMmdlJTJDJTIwbmklMjBlbiUyMG5vbWJyZSUyMGQnYW5uJUMzJUE5ZXMlMkMlMjBuaSUyMGVuJTIwbm9tYnJlJTIwZGUlMjBtb2lzLiUyMCUyMiUwQW91dHB1dCUyMCUzRCUyMHBpcGUoZnJfdGV4dCklMEFBdWRpbyhvdXRwdXQlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMHJhdGUlM0RvdXRwdXQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`fr_text = <span class="hljs-string">&quot;Contrairement à une idée répandue, le nombre de points sur les élytres d&#x27;une coccinelle ne correspond pas à son âge, ni en nombre d&#x27;années, ni en nombre de mois. &quot;</span>
output = pipe(fr_text)
Audio(output[<span class="hljs-string">&quot;audio&quot;</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),X=new C({props:{code:"c29uZyUyMCUzRCUyMCUyMiVFMiU5OSVBQSUyMEluJTIwdGhlJTIwanVuZ2xlJTJDJTIwdGhlJTIwbWlnaHR5JTIwanVuZ2xlJTJDJTIwdGhlJTIwbGFkeWJ1ZyUyMHdhcyUyMHNlZW4uJTIwJUUyJTk5JUFBJTIwJTIyJTBBb3V0cHV0JTIwJTNEJTIwcGlwZShzb25nKSUwQUF1ZGlvKG91dHB1dCU1QiUyMmF1ZGlvJTIyJTVEJTJDJTIwcmF0ZSUzRG91dHB1dCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`song = <span class="hljs-string">&quot;♪ In the jungle, the mighty jungle, the ladybug was seen. ♪ &quot;</span>
output = pipe(song)
Audio(output[<span class="hljs-string">&quot;audio&quot;</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),F=new Qe({}),A=new C({props:{code:"bXVzaWNfcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tYXVkaW8lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIp",highlighted:'music_pipe = pipeline(<span class="hljs-string">&quot;text-to-audio&quot;</span>, model=<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)'}}),P=new C({props:{code:"dGV4dCUyMCUzRCUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGVsZWN0cmljJTIwZ3VpdGFyJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMg==",highlighted:'text = <span class="hljs-string">&quot;90s rock song with electric guitar and heavy drums&quot;</span>'}}),L=new C({props:{code:"Zm9yd2FyZF9wYXJhbXMlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDUxMiU3RCUwQSUwQW91dHB1dCUyMCUzRCUyMG11c2ljX3BpcGUodGV4dCUyQyUyMGZvcndhcmRfcGFyYW1zJTNEZm9yd2FyZF9wYXJhbXMpJTBBQXVkaW8ob3V0cHV0JTVCJTIyYXVkaW8lMjIlNUQlNUIwJTVEJTJDJTIwcmF0ZSUzRG91dHB1dCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`forward_params = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>}

output = music_pipe(text, forward_params=forward_params)
Audio(output[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-number">0</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),{c(){w=i("meta"),ae=s(),ee=i("p"),ie=s(),g=i("h1"),J=i("a"),te=i("span"),h(x.$$.fragment),Ze=s(),D=i("span"),D.textContent=ze,oe=s(),k=i("p"),k.textContent=Xe,pe=s(),T=i("p"),T.innerHTML=Se,re=s(),j=i("p"),j.textContent=Fe,ue=s(),G=i("p"),G.textContent=Ne,he=s(),h(B.$$.fragment),ce=s(),U=i("h2"),b=i("a"),ne=i("span"),h(V.$$.fragment),He=s(),K=i("span"),K.textContent=Ae,de=s(),I=i("p"),I.innerHTML=Ee,me=s(),h(_.$$.fragment),ye=s(),W=i("p"),W.textContent=Pe,fe=s(),h(Z.$$.fragment),Me=s(),H=i("p"),H.textContent=Ye,we=s(),h(q.$$.fragment),ge=s(),Q=i("p"),Q.textContent=Le,Ue=s(),h(R.$$.fragment),ve=s(),z=i("p"),z.textContent=De,Ce=s(),h(X.$$.fragment),Je=s(),S=i("p"),S.textContent=Ke,be=s(),v=i("h2"),$=i("a"),le=i("span"),h(F.$$.fragment),qe=s(),O=i("span"),O.textContent=Oe,$e=s(),N=i("p"),N.innerHTML=et,xe=s(),h(A.$$.fragment),ke=s(),E=i("p"),E.textContent=tt,Te=s(),h(P.$$.fragment),je=s(),Y=i("p"),Y.innerHTML=nt,Ge=s(),h(L.$$.fragment),Be=s(),se=i("p"),this.h()},l(e){const n=mt("svelte-1phssyn",document.head);w=o(n,"META",{name:!0,content:!0}),n.forEach(t),ae=a(e),ee=o(e,"P",{}),M(ee).forEach(t),ie=a(e),g=o(e,"H1",{class:!0});var Ie=M(g);J=o(Ie,"A",{id:!0,class:!0,href:!0});var lt=M(J);te=o(lt,"SPAN",{});var st=M(te);c(x.$$.fragment,st),st.forEach(t),lt.forEach(t),Ze=a(Ie),D=o(Ie,"SPAN",{"data-svelte-h":!0}),p(D)!=="svelte-v114qo"&&(D.textContent=ze),Ie.forEach(t),oe=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1dtkcul"&&(k.textContent=Xe),pe=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-f44taj"&&(T.innerHTML=Se),re=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1x3quri"&&(j.textContent=Fe),ue=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1iuie69"&&(G.textContent=Ne),he=a(e),c(B.$$.fragment,e),ce=a(e),U=o(e,"H2",{class:!0});var _e=M(U);b=o(_e,"A",{id:!0,class:!0,href:!0});var at=M(b);ne=o(at,"SPAN",{});var it=M(ne);c(V.$$.fragment,it),it.forEach(t),at.forEach(t),He=a(_e),K=o(_e,"SPAN",{"data-svelte-h":!0}),p(K)!=="svelte-1ay69o1"&&(K.textContent=Ae),_e.forEach(t),de=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-anq3st"&&(I.innerHTML=Ee),me=a(e),c(_.$$.fragment,e),ye=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-6b8wyl"&&(W.textContent=Pe),fe=a(e),c(Z.$$.fragment,e),Me=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1w6x0gz"&&(H.textContent=Ye),we=a(e),c(q.$$.fragment,e),ge=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-16u7g8g"&&(Q.textContent=Le),Ue=a(e),c(R.$$.fragment,e),ve=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-ags8tg"&&(z.textContent=De),Ce=a(e),c(X.$$.fragment,e),Je=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-b3wsq0"&&(S.textContent=Ke),be=a(e),v=o(e,"H2",{class:!0});var We=M(v);$=o(We,"A",{id:!0,class:!0,href:!0});var ot=M($);le=o(ot,"SPAN",{});var pt=M(le);c(F.$$.fragment,pt),pt.forEach(t),ot.forEach(t),qe=a(We),O=o(We,"SPAN",{"data-svelte-h":!0}),p(O)!=="svelte-aacsmc"&&(O.textContent=Oe),We.forEach(t),$e=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-kuejmv"&&(N.innerHTML=et),xe=a(e),c(A.$$.fragment,e),ke=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1xd5ix4"&&(E.textContent=tt),Te=a(e),c(P.$$.fragment,e),je=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-le5gn"&&(Y.innerHTML=nt),Ge=a(e),c(L.$$.fragment,e),Be=a(e),se=o(e,"P",{}),M(se).forEach(t),this.h()},h(){r(w,"name","hf:doc:metadata"),r(w,"content",JSON.stringify(ft)),r(J,"id","audio-generation-with-a-pipeline"),r(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(J,"href","#audio-generation-with-a-pipeline"),r(g,"class","relative group"),r(b,"id","generating-speech"),r(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(b,"href","#generating-speech"),r(U,"class","relative group"),r($,"id","generating-music"),r($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($,"href","#generating-music"),r(v,"class","relative group")},m(e,n){u(document.head,w),l(e,ae,n),l(e,ee,n),l(e,ie,n),l(e,g,n),u(g,J),u(J,te),d(x,te,null),u(g,Ze),u(g,D),l(e,oe,n),l(e,k,n),l(e,pe,n),l(e,T,n),l(e,re,n),l(e,j,n),l(e,ue,n),l(e,G,n),l(e,he,n),d(B,e,n),l(e,ce,n),l(e,U,n),u(U,b),u(b,ne),d(V,ne,null),u(U,He),u(U,K),l(e,de,n),l(e,I,n),l(e,me,n),d(_,e,n),l(e,ye,n),l(e,W,n),l(e,fe,n),d(Z,e,n),l(e,Me,n),l(e,H,n),l(e,we,n),d(q,e,n),l(e,ge,n),l(e,Q,n),l(e,Ue,n),d(R,e,n),l(e,ve,n),l(e,z,n),l(e,Ce,n),d(X,e,n),l(e,Je,n),l(e,S,n),l(e,be,n),l(e,v,n),u(v,$),u($,le),d(F,le,null),u(v,qe),u(v,O),l(e,$e,n),l(e,N,n),l(e,xe,n),d(A,e,n),l(e,ke,n),l(e,E,n),l(e,Te,n),d(P,e,n),l(e,je,n),l(e,Y,n),l(e,Ge,n),d(L,e,n),l(e,Be,n),l(e,se,n),Ve=!0},p:ut,i(e){Ve||(m(x.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(_.$$.fragment,e),m(Z.$$.fragment,e),m(q.$$.fragment,e),m(R.$$.fragment,e),m(X.$$.fragment,e),m(F.$$.fragment,e),m(A.$$.fragment,e),m(P.$$.fragment,e),m(L.$$.fragment,e),Ve=!0)},o(e){y(x.$$.fragment,e),y(B.$$.fragment,e),y(V.$$.fragment,e),y(_.$$.fragment,e),y(Z.$$.fragment,e),y(q.$$.fragment,e),y(R.$$.fragment,e),y(X.$$.fragment,e),y(F.$$.fragment,e),y(A.$$.fragment,e),y(P.$$.fragment,e),y(L.$$.fragment,e),Ve=!1},d(e){e&&(t(ae),t(ee),t(ie),t(g),t(oe),t(k),t(pe),t(T),t(re),t(j),t(ue),t(G),t(he),t(ce),t(U),t(de),t(I),t(me),t(ye),t(W),t(fe),t(Me),t(H),t(we),t(ge),t(Q),t(Ue),t(ve),t(z),t(Ce),t(Je),t(S),t(be),t(v),t($e),t(N),t(xe),t(ke),t(E),t(Te),t(je),t(Y),t(Ge),t(Be),t(se)),t(w),f(x),f(B,e),f(V),f(_,e),f(Z,e),f(q,e),f(R,e),f(X,e),f(F),f(A,e),f(P,e),f(L,e)}}}const ft={local:"audio-generation-with-a-pipeline",sections:[{local:"generating-speech",title:"Generating speech"},{local:"generating-music",title:"Generating music"}],title:"Audio generation with a pipeline"};function Mt(Re){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends ct{constructor(w){super(),dt(this,w,Mt,yt,rt,{})}}export{Ct as component};
