import{s as Gl,n as Dl,o as Rl}from"../chunks/scheduler.f7e1785c.js";import{S as Fl,i as Bl,g as l,s as i,u,A as Vl,h as n,f as t,c as o,j as c,v as d,y as r,k as h,o as p,a,w as m,d as f,t as y,x as g}from"../chunks/index.815a732f.js";import{I as k}from"../chunks/IconCopyLink.e7937f56.js";import{C as b}from"../chunks/CodeBlock.c6e8b464.js";function Xl(Ma){let w,kt,bt,_t,M,_,wt,Y,ca,ht,va="Pre-trained models and datasets for audio classification",Nt,P,xa=`The Hugging Face Hub is home to over 500 pre-trained models for audio classification. In this section, we’ll go through
some of the most common audio classification tasks and suggest appropriate pre-trained models for each. Using the <code>pipeline()</code>
class, switching between models and tasks is straightforward - once you know how to use <code>pipeline()</code> for one model, you’ll
be able to use it for any model on the Hub no code changes! This makes experimenting with the <code>pipeline()</code> class extremely
fast, allowing you to quickly select the best pre-trained model for your needs.`,It,G,ja=`Before we jump into the various audio classification problems, let’s quickly recap the transformer architectures typically
used. The standard audio classification architecture is motivated by the nature of the task; we want to transform a sequence
of audio inputs (i.e. our input audio array) into a single class label prediction. Encoder-only models first map the input
audio sequence into a sequence of hidden-state representations by passing the inputs through a transformer block. The
sequence of hidden-state representations is then mapped to a class label output by taking the mean over the hidden-states,
and passing the resulting vector through a linear classification layer. Hence, there is a preference for <em>encoder-only</em>
models for audio classification.`,Wt,D,Ta=`Decoder-only models introduce unnecessary complexity to the task, since they assume that the outputs can also be a <em>sequence</em>
of predictions (rather than a single class label prediction), and so generate multiple outputs. Therefore, they have slower
inference speed and tend not to be used. Encoder-decoder models are largely omitted for the same reason. These architecture
choices are analogous to those in NLP, where encoder-only models such as <a href="https://huggingface.co/blog/bert-101" rel="nofollow">BERT</a>
are favoured for sequence classification tasks, and decoder-only models such as GPT reserved for sequence generation tasks.`,Ht,R,Ca=`Now that we’ve recapped the standard transformer architecture for audio classification, let’s jump into the different
subsets of audio classification and cover the most popular models!`,St,v,N,Mt,F,ua,pt,Ua="🤗 Transformers Installation",Lt,B,Ja=`At the time of writing, the latest updates required for audio classification pipeline are only on the <code>main</code> version of
the 🤗 Transformers repository, rather than the latest PyPi version. To make sure we have these updates locally, we’ll
install Transformers from the <code>main</code> branch with the following command:`,At,V,qt,x,I,vt,X,da,ct,$a="Keyword Spotting",Et,O,ka=`Keyword spotting (KWS) is the task of identifying a keyword in a spoken utterance. The set of possible keywords forms the
set of predicted class labels. Hence, to use a pre-trained keyword spotting model, you should ensure that your keywords
match those that the model was pre-trained on. Below, we’ll introduce two datasets and models for keyword spotting.`,Zt,j,W,xt,K,ma,ut,_a="Minds-14",Qt,ee,Na=`Let’s go ahead and use the same <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a> dataset that you have explored
in the previous unit. If you recall, MINDS-14 contains recordings of people asking an e-banking system questions in several
languages and dialects, and has the <code>intent_class</code> for each recording. We can classify the recordings by intent of the call.`,zt,te,Yt,se,Ia=`We’ll load the checkpoint <a href="https://huggingface.co/anton-l/xtreme_s_xlsr_300m_minds14" rel="nofollow"><code>&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</code></a>,
which is an XLS-R model fine-tuned on MINDS-14 for approximately 50 epochs. It achieves 90% accuracy over all languages
from MINDS-14 on the evaluation set.`,Pt,ae,Gt,le,Wa="Finally, we can pass a sample to the classification pipeline to make a prediction:",Dt,ne,Rt,ie,Ha="<strong>Output:</strong>",Ft,oe,Bt,re,Sa=`Great! We’ve identified that the intent of the call was paying a bill, with probability 96%. You can imagine this kind of
keyword spotting system being used as the first stage of an automated call centre, where we want to categorise incoming
customer calls based on their query and offer them contextualised support accordingly.`,Vt,T,H,jt,he,fa,dt,La="Speech Commands",Xt,pe,Aa=`Speech Commands is a dataset of spoken words designed to evaluate audio classification models on simple command words.
The dataset consists of 15 classes of keywords, a class for silence, and an unknown class to include the false positive.
The 15 keywords are single words that would typically be used in on-device settings to control basic tasks or launch
other processes.`,Ot,ce,qa=`A similar model is running continuously on your mobile phone. Here, instead of having single command words, we have
‘wake words’ specific to your device, such as “Hey Google” or “Hey Siri”. When the audio classification model detects
these wake words, it triggers your phone to start listening to the microphone and transcribe your speech using a speech
recognition model.`,Kt,ue,Ea=`The audio classification model is much smaller and lighter than the speech recognition model, often only several millions
of parameters compared to several hundred millions for speech recognition. Thus, it can be run continuously on your device
without draining your battery! Only when the wake word is detected is the larger speech recognition model launched, and
afterwards it is shut down again. We’ll cover transformer models for speech recognition in the next Unit, so by the end
of the course you should have the tools you need to build your own voice activated assistant!`,es,de,Za=`As with any dataset on the Hugging Face Hub, we can get a feel for the kind of audio data it has present without downloading
or committing it memory. After heading to the <a href="https://huggingface.co/datasets/speech_commands" rel="nofollow">Speech Commands’ dataset card</a>
on the Hub, we can use the Dataset Viewer to scroll through the first 100 samples of the dataset, listening to the audio
files and checking any other metadata information:`,ts,S,Qa='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/speech_commands.png" alt="Diagram of datasets viewer."/>',ss,me,za=`The Dataset Preview is a brilliant way of experiencing audio datasets before committing to using them. You can pick any
dataset on the Hub, scroll through the samples and listen to the audio for the different subsets and splits, gauging whether
it’s the right dataset for your needs. Once you’ve selected a dataset, it’s trivial to load the data so that you can start
using it.`,as,fe,Ya="Let’s do exactly that and load a sample of the Speech Commands dataset using streaming mode:",ls,ye,ns,ge,Pa=`We’ll load an official <a href="https://huggingface.co/docs/transformers/model_doc/audio-spectrogram-transformer" rel="nofollow">Audio Spectrogram Transformer</a>
checkpoint fine-tuned on the Speech Commands dataset, under the namespace <a href="https://huggingface.co/MIT/ast-finetuned-speech-commands-v2" rel="nofollow"><code>&quot;MIT/ast-finetuned-speech-commands-v2&quot;</code></a>:`,is,be,os,we,Ga="<strong>Output:</strong>",rs,Me,hs,ve,Da=`Cool! Looks like the example contains the word “backward” with high probability. We can take a listen to the sample
and verify this is correct:`,ps,xe,cs,je,Ra=`Now, you might be wondering how we’ve selected these pre-trained models to show you in these audio classification examples.
The truth is, finding pre-trained models for your dataset and task is very straightforward! The first thing we need to do
is head to the Hugging Face Hub and click on the “Models” tab: <a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>`,us,Te,Fa="This is going to bring up all the models on the Hugging Face Hub, sorted by downloads in the past 30 days:",ds,L,Ba='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/all_models.png"/>',ms,Ce,Va=`You’ll notice on the left-hand side that we have a selection of tabs that we can select to filter models by task, library,
dataset, etc. Scroll down and select the task “Audio Classification” from the list of audio tasks:`,fs,A,Xa='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_audio_classification.png"/>',ys,Ue,Oa=`We’re now presented with the sub-set of 500+ audio classification models on the Hub. To further refine this selection, we
can filter models by dataset. Click on the tab “Datasets”, and in the search box type “speech_commands”. As you begin typing,
you’ll see the selection for <code>speech_commands</code> appear underneath the search tab. You can click this button to filter all
audio classification models to those fine-tuned on the Speech Commands dataset:`,gs,q,Ka='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_speech_commands.png"/>',bs,Je,el=`Great! We see that we have 6 pre-trained models available to us for this specific dataset and task. You’ll recognise the
first of these models as the Audio Spectrogram Transformer checkpoint that we used in the previous example. This process
of filtering models on the Hub is exactly how we went about selecting the checkpoint to show you!`,ws,C,E,Tt,$e,ya,mt,tl="Language Identification",Ms,ke,sl=`Language identification (LID) is the task of identifying the language spoken in an audio sample from a list of candidate
languages. LID can form an important part in many speech pipelines. For example, given an audio sample in an unknown language,
an LID model can be used to categorise the language(s) spoken in the audio sample, and then select an appropriate speech
recognition model trained on that language to transcribe the audio.`,vs,U,Z,Ct,_e,ga,ft,al="FLEURS",xs,Ne,ll=`FLEURS (Few-shot Learning Evaluation of Universal Representations of Speech) is a dataset for evaluating speech recognition
systems in 102 languages, including many that are classified as ‘low-resource’. Take a look at the FLEURS dataset
card on the Hub and explore the different languages that are present: <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.
Can you find your native tongue here? If not, what’s the most closely related language?`,js,Ie,nl="Let’s load up a sample from the validation split of the FLEURS dataset using streaming mode:",Ts,We,Cs,He,il=`Great! Now we can load our audio classification model. For this, we’ll use a version of <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper</a>
fine-tuned on the FLEURS dataset, which is currently the most performant LID model on the Hub:`,Us,Se,Js,Le,ol="We can then pass the audio through our classifier and generate a prediction:",$s,Ae,ks,qe,rl="<strong>Output:</strong>",_s,Ee,Ns,Ze,hl=`We can see that the model predicted the audio was in Afrikaans with extremely high probability (near 1). The FLEURS dataset
contains audio data from a wide range of languages - we can see that possible class labels include Northern-Sotho, Icelandic,
Danish and Cantonese Chinese amongst others. You can find the full list of languages on the dataset card here: <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.`,Is,Qe,pl="Over to you! What other checkpoints can you find for FLEURS LID on the Hub? What transformer models are they using under-the-hood?",Ws,J,Q,Ut,ze,ba,yt,cl="Zero-Shot Audio Classification",Hs,Ye,ul=`In the traditional paradigm for audio classification, the model predicts a class label from a <em>pre-defined</em> set of
possible classes. This poses a barrier to using pre-trained models for audio classification, since the label set of the
pre-trained model must match that of the downstream task. For the previous example of LID, the model must predict one of
the 102 langauge classes on which it was trained. If the downstream task actually requires 110 languages, the model would
not be able to predict 8 of the 110 languages, and so would require re-training to achieve full coverage. This limits the
effectiveness of transfer learning for audio classification tasks.`,Ss,Pe,dl=`Zero-shot audio classification is a method for taking a pre-trained audio classification model trained on a set of labelled
examples and enabling it to be able to classify new examples from previously unseen classes. Let’s take a look at how we
can achieve this!`,Ls,Ge,ml=`Currently, 🤗 Transformers supports one kind of model for zero-shot audio classification: the <a href="https://huggingface.co/docs/transformers/model_doc/clap" rel="nofollow">CLAP model</a>.
CLAP is a transformer-based model that takes both audio and text as inputs, and computes the <em>similarity</em> between the two.
If we pass a text input that strongly correlates with an audio input, we’ll get a high similarity score. Conversely, passing
a text input that is completely unrelated to the audio input will return a low similarity.`,As,De,fl=`We can use this similarity prediction for zero-shot audio classification by passing one audio input to the model and
multiple candidate labels. The model will return a similarity score for each of the candidate labels, and we can pick the
one that has the highest score as our prediction.`,qs,Re,yl=`Let’s take an example where we use one audio input from the <a href="https://huggingface.co/datasets/ashraq/esc50" rel="nofollow">Environmental Speech Challenge (ESC)</a>
dataset:`,Es,Fe,Zs,Be,gl=`We then define our candidate labels, which form the set of possible classification labels. The model will return a
classification probability for each of the labels we define. This means we need to know <em>a-priori</em> the set of possible
labels in our classification problem, such that the correct label is contained within the set and is thus assigned a
valid probability score. Note that we can either pass the full set of labels to the model, or a hand-selected subset
that we believe contains the correct label. Passing the full set of labels is going to be more exhaustive, but comes
at the expense of lower classification accuracy since the classification space is larger (provided the correct label is
our chosen subset of labels):`,Qs,Ve,zs,Xe,bl="We can run both through the model to find the candidate label that is <em>most similar</em> to the audio input:",Ys,Oe,Ps,Ke,wl="<strong>Output:</strong>",Gs,et,Ds,tt,Ml=`Alright! The model seems pretty confident we have the sound of a dog - it predicts it with 99.96% probability, so we’ll
take that as our prediction. Let’s confirm whether we were right by listening to the audio sample (don’t turn up your
volume too high or else you might get a jump!):`,Rs,st,Fs,at,vl=`Perfect! We have the sound of a dog barking 🐕, which aligns with the model’s prediction. Have a play with different audio
samples and different candidate labels - can you define a set of labels that give good generalisation across the ESC
dataset? Hint: think about where you could find information on the possible sounds in ESC and construct your labels accordingly!`,Bs,lt,xl=`You might be wondering why we don’t use the zero-shot audio classification pipeline for <strong>all</strong> audio classification tasks?
It seems as though we can make predictions for any audio classification problem by defining appropriate class labels <em>a-priori</em>,
thus bypassing the constraint that our classification task needs to match the labels that the model was pre-trained on.
This comes down to the nature of the CLAP model used in the zero-shot pipeline: CLAP is pre-trained on <em>generic</em> audio
classification data, similar to the environmental sounds in the ESC dataset, rather than specifically speech data, like
we had in the LID task. If you gave it speech in English and speech in Spanish, CLAP would know that both examples were
speech data 🗣️ But it wouldn’t be able to differentiate between the languages in the same way a dedicated LID model is
able to.`,Vs,$,z,Jt,nt,wa,gt,jl="What next?",Xs,it,Tl=`We’ve covered a number of different audio classification tasks and presented the most relevant datasets and models that
you can download from the Hugging Face Hub and use in just several lines of code using the <code>pipeline()</code> class. These tasks
included keyword spotting, language identification and zero-shot audio classification.`,Os,ot,Cl=`But what if we want to do something <strong>new</strong>? We’ve worked extensively on speech processing tasks, but this is only one
aspect of audio classification. Another popular field of audio processing involves <strong>music</strong>. While music has inherently
different features to speech, many of the same principles that we’ve learnt about already can be applied to music.`,Ks,rt,Ul=`In the following section, we’ll go through a step-by-step guide on how you can fine-tune a transformer model with 🤗
Transformers on the task of music classification. By the end of it, you’ll have a fine-tuned checkpoint that you can plug
into the <code>pipeline()</code> class, enabling you to classify songs in exactly the same way that we’ve classified speech here!`,ea,$t,ta;return Y=new k({}),F=new k({}),V=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:'pip install git+https:<span class="hljs-regexp">//gi</span>thub.com<span class="hljs-regexp">/huggingface/</span>transformers'}}),X=new k({}),K=new k({}),te=new b({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`}}),ae=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJhbnRvbi1sJTJGeHRyZW1lX3NfeGxzcl8zMDBtX21pbmRzMTQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>,
    model=<span class="hljs-string">&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</span>,
)`}}),ne=new b({props:{code:"Y2xhc3NpZmllcihtaW5kcyU1QjAlNUQlNUIlMjJwYXRoJTIyJTVEKQ==",highlighted:'classifier(minds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;path&quot;</span>])'}}),oe=new b({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjk2MzE1MjUyNzgwOTE0MzElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMnBheV9iaWxsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAyODE5Njk4MzAzOTM3OTEyJTJDJTIwJTIybGFiZWwlMjIlM0ElMjAlMjJmcmVlemUlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAzMjc4NzQ5Mjk2NDQxNjc0MiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2FyZF9pc3N1ZXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAxOTQxNDQ0NTg1MDk5ODE2MyUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyYWJyb2FkJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAwMDgzNzg2OTM2MDExMTY1MzglMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMmhpZ2hfdmFsdWVfcGF5bWVudCUyMiU3RCUyQyUwQSU1RA==",highlighted:`[
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.9631525278091431</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;pay_bill&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.02819698303937912</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;freeze&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0032787492964416742</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;card_issues&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0019414445850998163</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;abroad&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0008378693601116538</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;high_value_payment&quot;</span>},
]`}}),he=new k({}),ye=new b({props:{code:"c3BlZWNoX2NvbW1hbmRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMnNwZWVjaF9jb21tYW5kcyUyMiUyQyUyMCUyMnYwLjAyJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUwQSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoc3BlZWNoX2NvbW1hbmRzKSk=",highlighted:`speech_commands = load_dataset(
    <span class="hljs-string">&quot;speech_commands&quot;</span>, <span class="hljs-string">&quot;v0.02&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(speech_commands))`}}),be=new b({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJNSVQlMkZhc3QtZmluZXR1bmVkLXNwZWVjaC1jb21tYW5kcy12MiUyMiUwQSklMEFjbGFzc2lmaWVyKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSk=",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;MIT/ast-finetuned-speech-commands-v2&quot;</span>
)
classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())`}}),Me=new b({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTg5MjcxMTYzOTQwNCUyQyUyMCdsYWJlbCclM0ElMjAnYmFja3dhcmQnJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDEuNzUwNDg4ODc3NDA1NTg3MWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ2hhcHB5JyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA2LjcwMzA0MDE4NTEyOTc5NGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ2ZvbGxvdyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwNS44MDU4ODQ0ODQyODg5ODFlLTA3JTJDJTIwJ2xhYmVsJyUzQSUyMCdzdG9wJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA1LjYxNDU0NjY5NDIzMjU1OGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ3VwJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999892711639404</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;backward</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">1.7504888774055871</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;happy</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">6.703040185129794</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;follow</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.805884484288981</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;stop</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.614546694232558</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;up</span>&#x27;}]`}}),xe=new b({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`from <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">IPython</span>.</span></span>display import Audio

<span class="hljs-constructor">Audio(<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], <span class="hljs-params">rate</span>=<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])</span>`}}),$e=new k({}),_e=new k({}),We=new b({props:{code:"ZmxldXJzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdvb2dsZSUyRmZsZXVycyUyMiUyQyUyMCUyMmFsbCUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBc2FtcGxlJTIwJTNEJTIwbmV4dChpdGVyKGZsZXVycykp",highlighted:`fleurs = load_dataset(<span class="hljs-string">&quot;google/fleurs&quot;</span>, <span class="hljs-string">&quot;all&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(fleurs))`}}),Se=new b({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzYW5jaGl0LWdhbmRoaSUyRndoaXNwZXItbWVkaXVtLWZsZXVycy1sYW5nLWlkJTIyJTBBKQ==",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-medium-fleurs-lang-id&quot;</span>
)`}}),Ae=new b({props:{code:"Y2xhc3NpZmllcihzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCk=",highlighted:'classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>])'}}),Ee=new b({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTMzMDA0Mzc5MjcyNSUyQyUyMCdsYWJlbCclM0ElMjAnQWZyaWthYW5zJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA3LjA5MzAyMzY2ODg1ODIyM2UtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ05vcnRoZXJuLVNvdGhvJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA0LjI2OTE0OTQ4NTQ4MDczOWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ0ljZWxhbmRpYyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwMy4yNjYxMTQxNjMxMjUxNjY3ZS0wNiUyQyUyMCdsYWJlbCclM0ElMjAnRGFuaXNoJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAzLjI1ODA3MjQxMDk3MjA5MDRlLTA2JTJDJTIwJ2xhYmVsJyUzQSUyMCdDYW50b25lc2UlMjBDaGluZXNlJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999330043792725</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Afrikaans</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">7.093023668858223</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Northern-Sotho</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">4.269149485480739</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Icelandic</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2661141631251667</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Danish</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2580724109720904</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Cantonese</span> Chinese&#x27;}]`}}),ze=new k({}),Fe=new b({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhc2hyYXElMkZlc2M1MCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWF1ZGlvX3NhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSklNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVE",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;ashraq/esc50&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
audio_sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]`}}),Ve=new b({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMlNvdW5kJTIwb2YlMjBhJTIwZG9nJTIyJTJDJTIwJTIyU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXIlMjIlNUQ=",highlighted:'candidate_labels = [<span class="hljs-string">&quot;Sound of a dog&quot;</span>, <span class="hljs-string">&quot;Sound of vacuum cleaner&quot;</span>]'}}),Oe=new b({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmxhaW9uJTJGY2xhcC1odHNhdC11bmZ1c2VkJTIyJTBBKSUwQWNsYXNzaWZpZXIoYXVkaW9fc2FtcGxlJTJDJTIwY2FuZGlkYXRlX2xhYmVscyUzRGNhbmRpZGF0ZV9sYWJlbHMp",highlighted:`classifier = pipeline(
    task=<span class="hljs-string">&quot;zero-shot-audio-classification&quot;</span>, model=<span class="hljs-string">&quot;laion/clap-htsat-unfused&quot;</span>
)
classifier(audio_sample, candidate_labels=candidate_labels)`}}),et=new b({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5NzI0MjA5MzA4NjI0MyUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMGElMjBkb2cnJTdEJTJDJTIwJTdCJ3Njb3JlJyUzQSUyMDAuMDAwMjc1ODMyMzk3MTY0Nzc2OSUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXInJTdEJTVE",highlighted:'[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9997242093086243</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of a dog&#x27;}, {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.0002758323971647769</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of vacuum cleaner&#x27;}]'}}),st=new b({props:{code:"QXVkaW8oYXVkaW9fc2FtcGxlJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:'Audio(audio_sample, rate=<span class="hljs-number">16000</span>)'}}),nt=new k({}),{c(){w=l("meta"),kt=i(),bt=l("p"),_t=i(),M=l("h1"),_=l("a"),wt=l("span"),u(Y.$$.fragment),ca=i(),ht=l("span"),ht.textContent=va,Nt=i(),P=l("p"),P.innerHTML=xa,It=i(),G=l("p"),G.innerHTML=ja,Wt=i(),D=l("p"),D.innerHTML=Ta,Ht=i(),R=l("p"),R.textContent=Ca,St=i(),v=l("h2"),N=l("a"),Mt=l("span"),u(F.$$.fragment),ua=i(),pt=l("span"),pt.textContent=Ua,Lt=i(),B=l("p"),B.innerHTML=Ja,At=i(),u(V.$$.fragment),qt=i(),x=l("h2"),I=l("a"),vt=l("span"),u(X.$$.fragment),da=i(),ct=l("span"),ct.textContent=$a,Et=i(),O=l("p"),O.textContent=ka,Zt=i(),j=l("h3"),W=l("a"),xt=l("span"),u(K.$$.fragment),ma=i(),ut=l("span"),ut.textContent=_a,Qt=i(),ee=l("p"),ee.innerHTML=Na,zt=i(),u(te.$$.fragment),Yt=i(),se=l("p"),se.innerHTML=Ia,Pt=i(),u(ae.$$.fragment),Gt=i(),le=l("p"),le.textContent=Wa,Dt=i(),u(ne.$$.fragment),Rt=i(),ie=l("p"),ie.innerHTML=Ha,Ft=i(),u(oe.$$.fragment),Bt=i(),re=l("p"),re.textContent=Sa,Vt=i(),T=l("h3"),H=l("a"),jt=l("span"),u(he.$$.fragment),fa=i(),dt=l("span"),dt.textContent=La,Xt=i(),pe=l("p"),pe.textContent=Aa,Ot=i(),ce=l("p"),ce.textContent=qa,Kt=i(),ue=l("p"),ue.textContent=Ea,es=i(),de=l("p"),de.innerHTML=Za,ts=i(),S=l("div"),S.innerHTML=Qa,ss=i(),me=l("p"),me.textContent=za,as=i(),fe=l("p"),fe.textContent=Ya,ls=i(),u(ye.$$.fragment),ns=i(),ge=l("p"),ge.innerHTML=Pa,is=i(),u(be.$$.fragment),os=i(),we=l("p"),we.innerHTML=Ga,rs=i(),u(Me.$$.fragment),hs=i(),ve=l("p"),ve.textContent=Da,ps=i(),u(xe.$$.fragment),cs=i(),je=l("p"),je.innerHTML=Ra,us=i(),Te=l("p"),Te.textContent=Fa,ds=i(),L=l("div"),L.innerHTML=Ba,ms=i(),Ce=l("p"),Ce.textContent=Va,fs=i(),A=l("div"),A.innerHTML=Xa,ys=i(),Ue=l("p"),Ue.innerHTML=Oa,gs=i(),q=l("div"),q.innerHTML=Ka,bs=i(),Je=l("p"),Je.textContent=el,ws=i(),C=l("h2"),E=l("a"),Tt=l("span"),u($e.$$.fragment),ya=i(),mt=l("span"),mt.textContent=tl,Ms=i(),ke=l("p"),ke.textContent=sl,vs=i(),U=l("h3"),Z=l("a"),Ct=l("span"),u(_e.$$.fragment),ga=i(),ft=l("span"),ft.textContent=al,xs=i(),Ne=l("p"),Ne.innerHTML=ll,js=i(),Ie=l("p"),Ie.textContent=nl,Ts=i(),u(We.$$.fragment),Cs=i(),He=l("p"),He.innerHTML=il,Us=i(),u(Se.$$.fragment),Js=i(),Le=l("p"),Le.textContent=ol,$s=i(),u(Ae.$$.fragment),ks=i(),qe=l("p"),qe.innerHTML=rl,_s=i(),u(Ee.$$.fragment),Ns=i(),Ze=l("p"),Ze.innerHTML=hl,Is=i(),Qe=l("p"),Qe.textContent=pl,Ws=i(),J=l("h2"),Q=l("a"),Ut=l("span"),u(ze.$$.fragment),ba=i(),yt=l("span"),yt.textContent=cl,Hs=i(),Ye=l("p"),Ye.innerHTML=ul,Ss=i(),Pe=l("p"),Pe.textContent=dl,Ls=i(),Ge=l("p"),Ge.innerHTML=ml,As=i(),De=l("p"),De.textContent=fl,qs=i(),Re=l("p"),Re.innerHTML=yl,Es=i(),u(Fe.$$.fragment),Zs=i(),Be=l("p"),Be.innerHTML=gl,Qs=i(),u(Ve.$$.fragment),zs=i(),Xe=l("p"),Xe.innerHTML=bl,Ys=i(),u(Oe.$$.fragment),Ps=i(),Ke=l("p"),Ke.innerHTML=wl,Gs=i(),u(et.$$.fragment),Ds=i(),tt=l("p"),tt.textContent=Ml,Rs=i(),u(st.$$.fragment),Fs=i(),at=l("p"),at.textContent=vl,Bs=i(),lt=l("p"),lt.innerHTML=xl,Vs=i(),$=l("h2"),z=l("a"),Jt=l("span"),u(nt.$$.fragment),wa=i(),gt=l("span"),gt.textContent=jl,Xs=i(),it=l("p"),it.innerHTML=Tl,Os=i(),ot=l("p"),ot.innerHTML=Cl,Ks=i(),rt=l("p"),rt.innerHTML=Ul,ea=i(),$t=l("p"),this.h()},l(e){const s=Vl("svelte-1phssyn",document.head);w=n(s,"META",{name:!0,content:!0}),s.forEach(t),kt=o(e),bt=n(e,"P",{}),c(bt).forEach(t),_t=o(e),M=n(e,"H1",{class:!0});var sa=c(M);_=n(sa,"A",{id:!0,class:!0,href:!0});var Jl=c(_);wt=n(Jl,"SPAN",{});var $l=c(wt);d(Y.$$.fragment,$l),$l.forEach(t),Jl.forEach(t),ca=o(sa),ht=n(sa,"SPAN",{"data-svelte-h":!0}),r(ht)!=="svelte-1qly3ef"&&(ht.textContent=va),sa.forEach(t),Nt=o(e),P=n(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1sx6iox"&&(P.innerHTML=xa),It=o(e),G=n(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1fbyaxi"&&(G.innerHTML=ja),Wt=o(e),D=n(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1webo38"&&(D.innerHTML=Ta),Ht=o(e),R=n(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-rwwaij"&&(R.textContent=Ca),St=o(e),v=n(e,"H2",{class:!0});var aa=c(v);N=n(aa,"A",{id:!0,class:!0,href:!0});var kl=c(N);Mt=n(kl,"SPAN",{});var _l=c(Mt);d(F.$$.fragment,_l),_l.forEach(t),kl.forEach(t),ua=o(aa),pt=n(aa,"SPAN",{"data-svelte-h":!0}),r(pt)!=="svelte-1ok1850"&&(pt.textContent=Ua),aa.forEach(t),Lt=o(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1tugr7p"&&(B.innerHTML=Ja),At=o(e),d(V.$$.fragment,e),qt=o(e),x=n(e,"H2",{class:!0});var la=c(x);I=n(la,"A",{id:!0,class:!0,href:!0});var Nl=c(I);vt=n(Nl,"SPAN",{});var Il=c(vt);d(X.$$.fragment,Il),Il.forEach(t),Nl.forEach(t),da=o(la),ct=n(la,"SPAN",{"data-svelte-h":!0}),r(ct)!=="svelte-x2h36u"&&(ct.textContent=$a),la.forEach(t),Et=o(e),O=n(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-18ejjqs"&&(O.textContent=ka),Zt=o(e),j=n(e,"H3",{class:!0});var na=c(j);W=n(na,"A",{id:!0,class:!0,href:!0});var Wl=c(W);xt=n(Wl,"SPAN",{});var Hl=c(xt);d(K.$$.fragment,Hl),Hl.forEach(t),Wl.forEach(t),ma=o(na),ut=n(na,"SPAN",{"data-svelte-h":!0}),r(ut)!=="svelte-c3n8l2"&&(ut.textContent=_a),na.forEach(t),Qt=o(e),ee=n(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1jsn8wa"&&(ee.innerHTML=Na),zt=o(e),d(te.$$.fragment,e),Yt=o(e),se=n(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1c1mr12"&&(se.innerHTML=Ia),Pt=o(e),d(ae.$$.fragment,e),Gt=o(e),le=n(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1xz16k"&&(le.textContent=Wa),Dt=o(e),d(ne.$$.fragment,e),Rt=o(e),ie=n(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1mvdyro"&&(ie.innerHTML=Ha),Ft=o(e),d(oe.$$.fragment,e),Bt=o(e),re=n(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-k1rlzh"&&(re.textContent=Sa),Vt=o(e),T=n(e,"H3",{class:!0});var ia=c(T);H=n(ia,"A",{id:!0,class:!0,href:!0});var Sl=c(H);jt=n(Sl,"SPAN",{});var Ll=c(jt);d(he.$$.fragment,Ll),Ll.forEach(t),Sl.forEach(t),fa=o(ia),dt=n(ia,"SPAN",{"data-svelte-h":!0}),r(dt)!=="svelte-ulb7f3"&&(dt.textContent=La),ia.forEach(t),Xt=o(e),pe=n(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-11rdezd"&&(pe.textContent=Aa),Ot=o(e),ce=n(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1o56zbf"&&(ce.textContent=qa),Kt=o(e),ue=n(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-ts3or1"&&(ue.textContent=Ea),es=o(e),de=n(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-fipl47"&&(de.innerHTML=Za),ts=o(e),S=n(e,"DIV",{class:!0,"data-svelte-h":!0}),r(S)!=="svelte-sk0ezl"&&(S.innerHTML=Qa),ss=o(e),me=n(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-yyvm6u"&&(me.textContent=za),as=o(e),fe=n(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-p686we"&&(fe.textContent=Ya),ls=o(e),d(ye.$$.fragment,e),ns=o(e),ge=n(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-hz24qn"&&(ge.innerHTML=Pa),is=o(e),d(be.$$.fragment,e),os=o(e),we=n(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1mvdyro"&&(we.innerHTML=Ga),rs=o(e),d(Me.$$.fragment,e),hs=o(e),ve=n(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-kbnmt8"&&(ve.textContent=Da),ps=o(e),d(xe.$$.fragment,e),cs=o(e),je=n(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-7botfj"&&(je.innerHTML=Ra),us=o(e),Te=n(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-csh5dy"&&(Te.textContent=Fa),ds=o(e),L=n(e,"DIV",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-bqfzrn"&&(L.innerHTML=Ba),ms=o(e),Ce=n(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-6zblrj"&&(Ce.textContent=Va),fs=o(e),A=n(e,"DIV",{class:!0,"data-svelte-h":!0}),r(A)!=="svelte-1t2za6k"&&(A.innerHTML=Xa),ys=o(e),Ue=n(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-7t6r33"&&(Ue.innerHTML=Oa),gs=o(e),q=n(e,"DIV",{class:!0,"data-svelte-h":!0}),r(q)!=="svelte-1sstogo"&&(q.innerHTML=Ka),bs=o(e),Je=n(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1jgbk0j"&&(Je.textContent=el),ws=o(e),C=n(e,"H2",{class:!0});var oa=c(C);E=n(oa,"A",{id:!0,class:!0,href:!0});var Al=c(E);Tt=n(Al,"SPAN",{});var ql=c(Tt);d($e.$$.fragment,ql),ql.forEach(t),Al.forEach(t),ya=o(oa),mt=n(oa,"SPAN",{"data-svelte-h":!0}),r(mt)!=="svelte-130pw8j"&&(mt.textContent=tl),oa.forEach(t),Ms=o(e),ke=n(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-5rskgo"&&(ke.textContent=sl),vs=o(e),U=n(e,"H3",{class:!0});var ra=c(U);Z=n(ra,"A",{id:!0,class:!0,href:!0});var El=c(Z);Ct=n(El,"SPAN",{});var Zl=c(Ct);d(_e.$$.fragment,Zl),Zl.forEach(t),El.forEach(t),ga=o(ra),ft=n(ra,"SPAN",{"data-svelte-h":!0}),r(ft)!=="svelte-6ko8yw"&&(ft.textContent=al),ra.forEach(t),xs=o(e),Ne=n(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1n5euwf"&&(Ne.innerHTML=ll),js=o(e),Ie=n(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-a6zngd"&&(Ie.textContent=nl),Ts=o(e),d(We.$$.fragment,e),Cs=o(e),He=n(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1g1l39x"&&(He.innerHTML=il),Us=o(e),d(Se.$$.fragment,e),Js=o(e),Le=n(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1fons3v"&&(Le.textContent=ol),$s=o(e),d(Ae.$$.fragment,e),ks=o(e),qe=n(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1mvdyro"&&(qe.innerHTML=rl),_s=o(e),d(Ee.$$.fragment,e),Ns=o(e),Ze=n(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1044ak6"&&(Ze.innerHTML=hl),Is=o(e),Qe=n(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-857vsk"&&(Qe.textContent=pl),Ws=o(e),J=n(e,"H2",{class:!0});var ha=c(J);Q=n(ha,"A",{id:!0,class:!0,href:!0});var Ql=c(Q);Ut=n(Ql,"SPAN",{});var zl=c(Ut);d(ze.$$.fragment,zl),zl.forEach(t),Ql.forEach(t),ba=o(ha),yt=n(ha,"SPAN",{"data-svelte-h":!0}),r(yt)!=="svelte-pv8m1i"&&(yt.textContent=cl),ha.forEach(t),Hs=o(e),Ye=n(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1wf33gz"&&(Ye.innerHTML=ul),Ss=o(e),Pe=n(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1bub4i"&&(Pe.textContent=dl),Ls=o(e),Ge=n(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-xv3v8"&&(Ge.innerHTML=ml),As=o(e),De=n(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-yr149b"&&(De.textContent=fl),qs=o(e),Re=n(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1osll5p"&&(Re.innerHTML=yl),Es=o(e),d(Fe.$$.fragment,e),Zs=o(e),Be=n(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-18w9coi"&&(Be.innerHTML=gl),Qs=o(e),d(Ve.$$.fragment,e),zs=o(e),Xe=n(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-163k6s1"&&(Xe.innerHTML=bl),Ys=o(e),d(Oe.$$.fragment,e),Ps=o(e),Ke=n(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1mvdyro"&&(Ke.innerHTML=wl),Gs=o(e),d(et.$$.fragment,e),Ds=o(e),tt=n(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1slv1zu"&&(tt.textContent=Ml),Rs=o(e),d(st.$$.fragment,e),Fs=o(e),at=n(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-125h3os"&&(at.textContent=vl),Bs=o(e),lt=n(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-elwwua"&&(lt.innerHTML=xl),Vs=o(e),$=n(e,"H2",{class:!0});var pa=c($);z=n(pa,"A",{id:!0,class:!0,href:!0});var Yl=c(z);Jt=n(Yl,"SPAN",{});var Pl=c(Jt);d(nt.$$.fragment,Pl),Pl.forEach(t),Yl.forEach(t),wa=o(pa),gt=n(pa,"SPAN",{"data-svelte-h":!0}),r(gt)!=="svelte-1mgx2px"&&(gt.textContent=jl),pa.forEach(t),Xs=o(e),it=n(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1b8ovtt"&&(it.innerHTML=Tl),Os=o(e),ot=n(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1dkp3zb"&&(ot.innerHTML=Cl),Ks=o(e),rt=n(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-nfuday"&&(rt.innerHTML=Ul),ea=o(e),$t=n(e,"P",{}),c($t).forEach(t),this.h()},h(){h(w,"name","hf:doc:metadata"),h(w,"content",JSON.stringify(Ol)),h(_,"id","pretrained-models-and-datasets-for-audio-classification"),h(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(_,"href","#pretrained-models-and-datasets-for-audio-classification"),h(M,"class","relative group"),h(N,"id","transformers-installation"),h(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(N,"href","#transformers-installation"),h(v,"class","relative group"),h(I,"id","keyword-spotting"),h(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(I,"href","#keyword-spotting"),h(x,"class","relative group"),h(W,"id","minds14"),h(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(W,"href","#minds14"),h(j,"class","relative group"),h(H,"id","speech-commands"),h(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(H,"href","#speech-commands"),h(T,"class","relative group"),h(S,"class","flex justify-center"),h(L,"class","flex justify-center"),h(A,"class","flex justify-center"),h(q,"class","flex justify-center"),h(E,"id","language-identification"),h(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(E,"href","#language-identification"),h(C,"class","relative group"),h(Z,"id","fleurs"),h(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Z,"href","#fleurs"),h(U,"class","relative group"),h(Q,"id","zeroshot-audio-classification"),h(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Q,"href","#zeroshot-audio-classification"),h(J,"class","relative group"),h(z,"id","what-next"),h(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(z,"href","#what-next"),h($,"class","relative group")},m(e,s){p(document.head,w),a(e,kt,s),a(e,bt,s),a(e,_t,s),a(e,M,s),p(M,_),p(_,wt),m(Y,wt,null),p(M,ca),p(M,ht),a(e,Nt,s),a(e,P,s),a(e,It,s),a(e,G,s),a(e,Wt,s),a(e,D,s),a(e,Ht,s),a(e,R,s),a(e,St,s),a(e,v,s),p(v,N),p(N,Mt),m(F,Mt,null),p(v,ua),p(v,pt),a(e,Lt,s),a(e,B,s),a(e,At,s),m(V,e,s),a(e,qt,s),a(e,x,s),p(x,I),p(I,vt),m(X,vt,null),p(x,da),p(x,ct),a(e,Et,s),a(e,O,s),a(e,Zt,s),a(e,j,s),p(j,W),p(W,xt),m(K,xt,null),p(j,ma),p(j,ut),a(e,Qt,s),a(e,ee,s),a(e,zt,s),m(te,e,s),a(e,Yt,s),a(e,se,s),a(e,Pt,s),m(ae,e,s),a(e,Gt,s),a(e,le,s),a(e,Dt,s),m(ne,e,s),a(e,Rt,s),a(e,ie,s),a(e,Ft,s),m(oe,e,s),a(e,Bt,s),a(e,re,s),a(e,Vt,s),a(e,T,s),p(T,H),p(H,jt),m(he,jt,null),p(T,fa),p(T,dt),a(e,Xt,s),a(e,pe,s),a(e,Ot,s),a(e,ce,s),a(e,Kt,s),a(e,ue,s),a(e,es,s),a(e,de,s),a(e,ts,s),a(e,S,s),a(e,ss,s),a(e,me,s),a(e,as,s),a(e,fe,s),a(e,ls,s),m(ye,e,s),a(e,ns,s),a(e,ge,s),a(e,is,s),m(be,e,s),a(e,os,s),a(e,we,s),a(e,rs,s),m(Me,e,s),a(e,hs,s),a(e,ve,s),a(e,ps,s),m(xe,e,s),a(e,cs,s),a(e,je,s),a(e,us,s),a(e,Te,s),a(e,ds,s),a(e,L,s),a(e,ms,s),a(e,Ce,s),a(e,fs,s),a(e,A,s),a(e,ys,s),a(e,Ue,s),a(e,gs,s),a(e,q,s),a(e,bs,s),a(e,Je,s),a(e,ws,s),a(e,C,s),p(C,E),p(E,Tt),m($e,Tt,null),p(C,ya),p(C,mt),a(e,Ms,s),a(e,ke,s),a(e,vs,s),a(e,U,s),p(U,Z),p(Z,Ct),m(_e,Ct,null),p(U,ga),p(U,ft),a(e,xs,s),a(e,Ne,s),a(e,js,s),a(e,Ie,s),a(e,Ts,s),m(We,e,s),a(e,Cs,s),a(e,He,s),a(e,Us,s),m(Se,e,s),a(e,Js,s),a(e,Le,s),a(e,$s,s),m(Ae,e,s),a(e,ks,s),a(e,qe,s),a(e,_s,s),m(Ee,e,s),a(e,Ns,s),a(e,Ze,s),a(e,Is,s),a(e,Qe,s),a(e,Ws,s),a(e,J,s),p(J,Q),p(Q,Ut),m(ze,Ut,null),p(J,ba),p(J,yt),a(e,Hs,s),a(e,Ye,s),a(e,Ss,s),a(e,Pe,s),a(e,Ls,s),a(e,Ge,s),a(e,As,s),a(e,De,s),a(e,qs,s),a(e,Re,s),a(e,Es,s),m(Fe,e,s),a(e,Zs,s),a(e,Be,s),a(e,Qs,s),m(Ve,e,s),a(e,zs,s),a(e,Xe,s),a(e,Ys,s),m(Oe,e,s),a(e,Ps,s),a(e,Ke,s),a(e,Gs,s),m(et,e,s),a(e,Ds,s),a(e,tt,s),a(e,Rs,s),m(st,e,s),a(e,Fs,s),a(e,at,s),a(e,Bs,s),a(e,lt,s),a(e,Vs,s),a(e,$,s),p($,z),p(z,Jt),m(nt,Jt,null),p($,wa),p($,gt),a(e,Xs,s),a(e,it,s),a(e,Os,s),a(e,ot,s),a(e,Ks,s),a(e,rt,s),a(e,ea,s),a(e,$t,s),ta=!0},p:Dl,i(e){ta||(f(Y.$$.fragment,e),f(F.$$.fragment,e),f(V.$$.fragment,e),f(X.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(be.$$.fragment,e),f(Me.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(_e.$$.fragment,e),f(We.$$.fragment,e),f(Se.$$.fragment,e),f(Ae.$$.fragment,e),f(Ee.$$.fragment,e),f(ze.$$.fragment,e),f(Fe.$$.fragment,e),f(Ve.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(st.$$.fragment,e),f(nt.$$.fragment,e),ta=!0)},o(e){y(Y.$$.fragment,e),y(F.$$.fragment,e),y(V.$$.fragment,e),y(X.$$.fragment,e),y(K.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(he.$$.fragment,e),y(ye.$$.fragment,e),y(be.$$.fragment,e),y(Me.$$.fragment,e),y(xe.$$.fragment,e),y($e.$$.fragment,e),y(_e.$$.fragment,e),y(We.$$.fragment,e),y(Se.$$.fragment,e),y(Ae.$$.fragment,e),y(Ee.$$.fragment,e),y(ze.$$.fragment,e),y(Fe.$$.fragment,e),y(Ve.$$.fragment,e),y(Oe.$$.fragment,e),y(et.$$.fragment,e),y(st.$$.fragment,e),y(nt.$$.fragment,e),ta=!1},d(e){e&&(t(kt),t(bt),t(_t),t(M),t(Nt),t(P),t(It),t(G),t(Wt),t(D),t(Ht),t(R),t(St),t(v),t(Lt),t(B),t(At),t(qt),t(x),t(Et),t(O),t(Zt),t(j),t(Qt),t(ee),t(zt),t(Yt),t(se),t(Pt),t(Gt),t(le),t(Dt),t(Rt),t(ie),t(Ft),t(Bt),t(re),t(Vt),t(T),t(Xt),t(pe),t(Ot),t(ce),t(Kt),t(ue),t(es),t(de),t(ts),t(S),t(ss),t(me),t(as),t(fe),t(ls),t(ns),t(ge),t(is),t(os),t(we),t(rs),t(hs),t(ve),t(ps),t(cs),t(je),t(us),t(Te),t(ds),t(L),t(ms),t(Ce),t(fs),t(A),t(ys),t(Ue),t(gs),t(q),t(bs),t(Je),t(ws),t(C),t(Ms),t(ke),t(vs),t(U),t(xs),t(Ne),t(js),t(Ie),t(Ts),t(Cs),t(He),t(Us),t(Js),t(Le),t($s),t(ks),t(qe),t(_s),t(Ns),t(Ze),t(Is),t(Qe),t(Ws),t(J),t(Hs),t(Ye),t(Ss),t(Pe),t(Ls),t(Ge),t(As),t(De),t(qs),t(Re),t(Es),t(Zs),t(Be),t(Qs),t(zs),t(Xe),t(Ys),t(Ps),t(Ke),t(Gs),t(Ds),t(tt),t(Rs),t(Fs),t(at),t(Bs),t(lt),t(Vs),t($),t(Xs),t(it),t(Os),t(ot),t(Ks),t(rt),t(ea),t($t)),t(w),g(Y),g(F),g(V,e),g(X),g(K),g(te,e),g(ae,e),g(ne,e),g(oe,e),g(he),g(ye,e),g(be,e),g(Me,e),g(xe,e),g($e),g(_e),g(We,e),g(Se,e),g(Ae,e),g(Ee,e),g(ze),g(Fe,e),g(Ve,e),g(Oe,e),g(et,e),g(st,e),g(nt)}}}const Ol={local:"pretrained-models-and-datasets-for-audio-classification",sections:[{local:"transformers-installation",title:"🤗 Transformers Installation"},{local:"keyword-spotting",sections:[{local:"minds14",title:"Minds-14"},{local:"speech-commands",title:"Speech Commands"}],title:"Keyword Spotting"},{local:"language-identification",sections:[{local:"fleurs",title:"FLEURS"}],title:"Language Identification"},{local:"zeroshot-audio-classification",title:"Zero-Shot Audio Classification"},{local:"what-next",title:"What next?"}],title:"Pre-trained models and datasets for audio classification"};function Kl(Ma){return Rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ln extends Fl{constructor(w){super(),Bl(this,w,Kl,Xl,Gl,{})}}export{ln as component};
