import{s as se,f as ne,n as oe,o as ie}from"../chunks/scheduler.f7e1785c.js";import{S as re,i as pe,g as o,s as i,u as V,A as ce,h as r,f as t,c as p,j as J,v as E,y as U,k as n,o as _,a as l,w as S,d as Y,t as X,x as q}from"../chunks/index.815a732f.js";import{I as de}from"../chunks/IconCopyLink.e7937f56.js";import{C as z}from"../chunks/CodeBlock.c6e8b464.js";function me(F){let c,$,v,C,d,m,T,u,P,b,L="Build a demo with Gradio",B,h,K=`In this final section on audio classification, we’ll build a <a href="https://gradio.app" rel="nofollow">Gradio</a> demo to showcase the music
classification model that we just trained on the <a href="https://huggingface.co/datasets/marsyas/gtzan" rel="nofollow">GTZAN</a> dataset. The first
thing to do is load up the fine-tuned checkpoint using the <code>pipeline()</code> class - this is very familiar now from the section
on <a href="classification_models">pre-trained models</a>. You can change the <code>model_id</code> to the namespace of your fine-tuned model
on the Hugging Face Hub:`,G,f,x,w,O=`Secondly, we’ll define a function that takes the filepath for an audio input and passes it through the pipeline. Here,
the pipeline automatically takes care of loading the audio file, resampling it to the correct sampling rate, and running
inference with the model. We take the models predictions of <code>preds</code> and format them as a dictionary object to be displayed on the
output:`,I,y,R,M,D="Finally, we launch the Gradio demo using the function we’ve just defined:",W,g,Z,j,ee="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",H,s,te,A,k,Q;return u=new de({}),f=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzYW5jaGl0LWdhbmRoaSUyRmRpc3RpbGh1YmVydC1maW5ldHVuZWQtZ3R6YW4lMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model_id = <span class="hljs-string">&quot;sanchit-gandhi/distilhubert-finetuned-gtzan&quot;</span>
pipe = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model_id)`}}),y=new z({props:{code:"ZGVmJTIwY2xhc3NpZnlfYXVkaW8oZmlsZXBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZHMlMjAlM0QlMjBwaXBlKGZpbGVwYXRoKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBwJTIwaW4lMjBwcmVkcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlNUJwJTVCJTIybGFiZWwlMjIlNUQlNUQlMjAlM0QlMjBwJTVCJTIyc2NvcmUlMjIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_audio</span>(<span class="hljs-params">filepath</span>):
    preds = pipe(filepath)
    outputs = {}
    <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> preds:
        outputs[p[<span class="hljs-string">&quot;label&quot;</span>]] = p[<span class="hljs-string">&quot;score&quot;</span>]
    <span class="hljs-keyword">return</span> outputs`}}),g=new z({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RjbGFzc2lmeV9hdWRpbyUyQyUyMGlucHV0cyUzRGdyLkF1ZGlvKHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMjBvdXRwdXRzJTNEZ3Iub3V0cHV0cy5MYWJlbCgpJTBBKSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Interface(
    fn=classify_audio, inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>), outputs=gr.outputs.Label()
)
demo.launch(debug=<span class="hljs-literal">True</span>)`}}),{c(){c=o("meta"),$=i(),v=o("p"),C=i(),d=o("h1"),m=o("a"),T=o("span"),V(u.$$.fragment),P=i(),b=o("span"),b.textContent=L,B=i(),h=o("p"),h.innerHTML=K,G=i(),V(f.$$.fragment),x=i(),w=o("p"),w.innerHTML=O,I=i(),V(y.$$.fragment),R=i(),M=o("p"),M.textContent=D,W=i(),V(g.$$.fragment),Z=i(),j=o("p"),j.textContent=ee,H=i(),s=o("iframe"),A=i(),k=o("p"),this.h()},l(e){const a=ce("svelte-1phssyn",document.head);c=r(a,"META",{name:!0,content:!0}),a.forEach(t),$=p(e),v=r(e,"P",{}),J(v).forEach(t),C=p(e),d=r(e,"H1",{class:!0});var N=J(d);m=r(N,"A",{id:!0,class:!0,href:!0});var ae=J(m);T=r(ae,"SPAN",{});var le=J(T);E(u.$$.fragment,le),le.forEach(t),ae.forEach(t),P=p(N),b=r(N,"SPAN",{"data-svelte-h":!0}),U(b)!=="svelte-1yk39ev"&&(b.textContent=L),N.forEach(t),B=p(e),h=r(e,"P",{"data-svelte-h":!0}),U(h)!=="svelte-1r0764x"&&(h.innerHTML=K),G=p(e),E(f.$$.fragment,e),x=p(e),w=r(e,"P",{"data-svelte-h":!0}),U(w)!=="svelte-1o13rj8"&&(w.innerHTML=O),I=p(e),E(y.$$.fragment,e),R=p(e),M=r(e,"P",{"data-svelte-h":!0}),U(M)!=="svelte-rqn9c6"&&(M.textContent=D),W=p(e),E(g.$$.fragment,e),Z=p(e),j=r(e,"P",{"data-svelte-h":!0}),U(j)!=="svelte-10sf4ix"&&(j.textContent=ee),H=p(e),s=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),J(s).forEach(t),A=p(e),k=r(e,"P",{}),J(k).forEach(t),this.h()},h(){n(c,"name","hf:doc:metadata"),n(c,"content",JSON.stringify(ue)),n(m,"id","build-a-demo-with-gradio"),n(m,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),n(m,"href","#build-a-demo-with-gradio"),n(d,"class","relative group"),ne(s.src,te="https://course-demos-song-classifier.hf.space")||n(s,"src",te),n(s,"frameborder","0"),n(s,"height","450"),n(s,"title","Gradio app"),n(s,"class","container p-0 flex-grow space-iframe"),n(s,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(s,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,a){_(document.head,c),l(e,$,a),l(e,v,a),l(e,C,a),l(e,d,a),_(d,m),_(m,T),S(u,T,null),_(d,P),_(d,b),l(e,B,a),l(e,h,a),l(e,G,a),S(f,e,a),l(e,x,a),l(e,w,a),l(e,I,a),S(y,e,a),l(e,R,a),l(e,M,a),l(e,W,a),S(g,e,a),l(e,Z,a),l(e,j,a),l(e,H,a),l(e,s,a),l(e,A,a),l(e,k,a),Q=!0},p:oe,i(e){Q||(Y(u.$$.fragment,e),Y(f.$$.fragment,e),Y(y.$$.fragment,e),Y(g.$$.fragment,e),Q=!0)},o(e){X(u.$$.fragment,e),X(f.$$.fragment,e),X(y.$$.fragment,e),X(g.$$.fragment,e),Q=!1},d(e){e&&(t($),t(v),t(C),t(d),t(B),t(h),t(G),t(x),t(w),t(I),t(R),t(M),t(W),t(Z),t(j),t(H),t(s),t(A),t(k)),t(c),q(u),q(f,e),q(y,e),q(g,e)}}}const ue={local:"build-a-demo-with-gradio",title:"Build a demo with Gradio"};function he(F){return ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ge extends re{constructor(c){super(),pe(this,c,he,me,se,{})}}export{ge as component};
