import{s as Tn,n as Un,o as fn}from"../chunks/scheduler.f7e1785c.js";import{S as gn,i as bn,g as i,s as l,u as h,m as R,H as Ba,A as Jn,h as o,f as s,c as n,j as U,v as c,y as r,n as V,E as Ea,k as y,o as p,a,w as d,d as m,t as u,x as M}from"../chunks/index.815a732f.js";import{I as Bt}from"../chunks/IconCopyLink.e7937f56.js";import{C as w}from"../chunks/CodeBlock.c6e8b464.js";function jn(Na){let g,Et,jt,Gt,b,k,vt,H,Ga,wt,Ya="Pre-trained models for automatic speech recognition",Rt,$,Aa=`In this section, we’ll cover how to use the <code>pipeline()</code> to leverage pre-trained models for speech recognition. In <a href="../chapter2/asr_pipeline">Unit 2</a>,
we introduced the <code>pipeline()</code> as an easy way of running speech recognition tasks, with all pre- and post-processing handled under-the-hood
and the flexibility to quickly experiment with any pre-trained checkpoint on the Hugging Face Hub. In this Unit, we’ll go a
level deeper and explore the different attributes of speech recognition models and how we can use them to tackle a range
of different tasks.`,Vt,W,La="As detailed in Unit 3, speech recognition model broadly fall into one of two categories:",Ht,F,qa="<li>Connectionist Temporal Classification (CTC): <em>encoder-only</em> models with a linear classification (CTC) head on top</li> <li>Sequence-to-sequence (Seq2Seq): <em>encoder-decoder</em> models, with a cross-attention mechanism between the encoder and decoder</li>",$t,Z,Qa=`Prior to 2022, CTC was the more popular of the two architectures, with encoder-only models such as Wav2Vec2, HuBERT and XLSR achieving
breakthoughs in the pre-training / fine-tuning paradigm for speech. Big corporations, such as Meta and Microsoft, pre-trained
the encoder on vast amounts of unlabelled audio data for many days or weeks. Users could then take a pre-trained checkpoint, and
fine-tune it with a CTC head on as little as <strong>10 minutes</strong> of labelled speech data to achieve strong performance on a downstream
speech recognition task.`,Wt,_,Xa=`However, CTC models have their shortcomings. Appending a simple linear layer to an encoder gives a small, fast overall model, but can
be prone to phonetic spelling errors. We’ll demonstrate this for the Wav2Vec2 model below.`,Ft,J,S,It,N,Ra,Tt,za="Probing CTC Models",Zt,Y,Pa=`Let’s load a small excerpt of the <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> dataset to demonstrate
Wav2Vec2’s speech transcription capabilities:`,_t,A,Nt,L,Oa="<strong>Output:</strong>",Yt,q,At,Q,Da="We can pick one of the 73 audio samples and inspect the audio sample as well as the transcription:",Lt,X,qt,z,Ka="<strong>Output:</strong>",Qt,P,Xt,O,el=`Alright! Christmas and roast beef, sounds great! 🎄 Having chosen a data sample, we now load a fine-tuned checkpoint into
the <code>pipeline()</code>. For this, we’ll use the official <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a> checkpoint fine-tuned on
100 hours of LibriSpeech data:`,zt,D,Pt,K,tl=`Next, we’ll take an example from the dataset and pass its raw data to the pipeline. Since the <code>pipeline</code> <em>consumes</em> any
dictionary that we pass it (meaning it cannot be re-used), we’ll pass a copy of the data. This way, we can safely re-use
the same audio sample in the following examples:`,Ot,ee,Dt,te,sl="<strong>Output:</strong>",Kt,se,es,ae,al=`We can see that the Wav2Vec2 model does a pretty good job at transcribing this sample - at a first glance it looks generally correct.
Let’s put the target and prediction side-by-side and highlight the differences:`,ts,le,ss,ne,ll="Comparing the target text to the predicted transcription, we can see that all words <em>sound</em> correct, but some are not spelled accurately. For example:",as,ie,nl="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",ls,oe,il=`This highlights the shortcoming of a CTC model. A CTC model is essentially an ‘acoustic-only’ model: it consists of an encoder
which forms hidden-state representations from the audio inputs, and a linear layer which maps the hidden-states to characters:`,ns,re,ol=`This means that the system almost entirely bases its prediction on the acoustic input it was given (the phonetic sounds of the audio),
and so has a tendency to transcribe the audio in a phonetic way (e.g. <em>CHRISTMAUS</em>). It gives less importance to the
language modelling context of previous and successive letters, and so is prone to phonetic spelling errors. A more intelligent model
would identify that <em>CHRISTMAUS</em> is not a valid word in the English vocabulary, and correct it to <em>CHRISTMAS</em> when making
its predictions. We’re also missing two big features in our prediction - casing and punctuation - which limits the usefulness of
the model’s transcriptions to real-world applications.`,is,j,C,kt,pe,Va,Ut,rl="Graduation to Seq2Seq",os,he,pl=`Cue Seq2Seq models! As outlined in Unit 3, Seq2Seq models are formed of an encoder and decoder linked via a cross-attention
mechanism. The encoder plays the same role as before, computing hidden-state representations of the audio inputs, while the decoder
plays the role of a <strong>language model</strong>. The decoder processes the entire sequence of hidden-state representations
from the encoder and generates the corresponding text transcriptions. With global context of the audio input, the decoder
is able to use language modelling context as it makes its predictions, correcting for spelling mistakes on-the-fly and thus
circumventing the issue of phonetic predictions.`,rs,ce,hl="There are two downsides to Seq2Seq models:",ps,de,cl="<li>They are inherently slower at decoding, since the decoding process happens one step at a time, rather than all at once</li> <li>They are more data hungry, requiring significantly more training data to reach convergence</li>",hs,me,dl=`In particular, the need for large amounts of training data has been a bottleneck in the advancement of Seq2Seq architectures for
speech. Labelled speech data is difficult to come by, with the largest annotated datasets at the time clocking in at just
10,000 hours. This all changed in 2022 upon the release of <strong>Whisper</strong>. Whisper is a pre-trained model for speech recognition
published in <a href="https://openai.com/blog/whisper/" rel="nofollow">September 2022</a> by the authors Alec Radford et al. from OpenAI. Unlike
its CTC predecessors, which were pre-trained entirely on <strong>un-labelled</strong> audio data, Whisper is pre-trained on a vast quantity of
<strong>labelled</strong> audio-transcription data, 680,000 hours to be precise.`,cs,ue,ml=`This is an order of magnitude more data than the un-labelled audio data used to train Wav2Vec 2.0 (60,000 hours). What is
more, 117,000 hours of this pre-training data is multilingual (or “non-English”) data. This results in checkpoints that can be applied to
over 96 languages, many of which are considered <em>low-resource</em>, meaning the language lacks a large corpus of data suitable for training.`,ds,Me,ul=`When scaled to 680,000 hours of labelled pre-training data, Whisper models demonstrate a strong ability to generalise to
many datasets and domains. The pre-trained checkpoints achieve competitive results to state-of-the-art pipe systems, with
near 3% word error rate (WER) on the test-clean subset of LibriSpeech pipe and a new state-of-the-art on TED-LIUM with
4.7% WER (<em>c.f.</em> Table 8 of the <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper paper</a>).`,ms,ye,Ml=`Of particular importance is Whisper’s ability to handle long-form audio samples, its robustness to input noise and ability
to predict cased and punctuated transcriptions. This makes it a viable candidate for real-world speech recognition systems.`,us,we,yl=`The remainder of this section will show you how to use the pre-trained Whisper models for speech recognition using 🤗
Transformers. In many situations, the pre-trained Whisper checkpoints are extremely performant and give great results,
thus we encourage you to try using the pre-trained checkpoints as a first step to solving any speech recognition problem.
Through fine-tuning, the pre-trained checkpoints can be adapted for specific datasets and languages to further improve
upon these results. We’ll demonstrate how to do this in the upcoming subsection on <a href="fine-tuning">fine-tuning</a>.`,Ms,Te,wl=`The Whisper checkpoints come in five configurations of varying model sizes. The smallest four are trained on either
English-only or multilingual data. The largest checkpoint is multilingual only. All nine of the pre-trained checkpoints
are available on the <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a>. The checkpoints are
summarised in the following table with links to the models on the Hub. “VRAM” denotes the required GPU memory to run the
model with the minimum batch size of 1. “Rel Speed” is the relative speed of a checkpoint compared to the largest model.
Based on this information, you can select a checkpoint that is best suited to your hardware.`,ys,Ue,Tl='<thead><tr><th>Size</th> <th>Parameters</th> <th>VRAM / GB</th> <th>Rel Speed</th> <th>English-only</th> <th>Multilingual</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',ws,fe,Ul=`Let’s load the <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> checkpoint, which is of comparable size to the
Wav2Vec2 checkpoint we used previously. Preempting our move to multilingual speech recognition, we’ll load the multilingual
variant of the base checkpoint. We’ll also load the model on the GPU if available, or CPU otherwise. The <code>pipeline()</code> will
subsequently take care of moving all inputs / outputs from the CPU to the GPU as required:`,Ts,ge,Us,be,fl=`Great! Now let’s transcribe the audio as before. The only change we make is passing an extra argument, <code>max_new_tokens</code>,
which tells the model the maximum number of tokens to generate when making its prediction:`,fs,Je,gs,je,gl="<strong>Output:</strong>",bs,ve,Js,Ie,bl=`Easy enough! The first thing you’ll notice is the presence of both casing and punctuation. Immediately this makes the
transcription easier to read compared to the un-cased and un-punctuated transcription from Wav2Vec2. Let’s put the transcription
side-by-side with the target:`,js,ke,vs,Se,Jl=`Whisper has done a great job at correcting the phonetic errors we saw from Wav2Vec2 - both <em>Christmas</em> and <em>roast</em> are
spelled correctly. We see that the model still struggles with <em>SIMILES</em>, being incorrectly transcribed as <em>similarly</em>, but
this time the prediction is a valid word from the English vocabulary. Using a larger Whisper checkpoint can help further
reduce transcription errors, at the expense of requiring more compute and a longer transcription time.`,Is,Ce,jl=`We’ve been promised a model that can handle 96 languages, so lets leave English speech recognition for now and go global 🌎!
The <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a> (MLS) dataset is
the multilingual equivalent of the LibriSpeech dataset, with labelled audio data in six languages. We’ll load one sample
from the Spanish split of the MLS dataset, making use of <em>streaming</em> mode so that we don’t have to download the entire dataset:`,ks,xe,Ss,Be,vl="Again, we’ll inspect the text transcription and take a listen to the audio segment:",Cs,Ee,xs,Ge,Il="<strong>Output:</strong>",Bs,Re,Es,Ve,kl=`This is the target text that we’re aiming for with our Whisper transcription. Although we now know that we can
probably do better this, since our model is also going to predict punctuation and casing, neither of which are present in the
reference. Let’s forward the audio sample to the pipeline to get our text prediction. One thing to note is that the
pipeline <em>consumes</em> the dictionary of audio inputs that we input, meaning the dictionary can’t be re-used. To circumvent
this, we’ll pass a <em>copy</em> of the audio sample, so that we can re-use the same audio sample in the proceeding code examples:`,Gs,He,Rs,$e,Sl="<strong>Output:</strong>",Vs,We,Hs,Fe,Cl=`Great - this looks very similar to our reference text (arguably better since it has punctuation and casing!). You’ll notice
that we forwarded the <code>&quot;task&quot;</code> as a <em>generate key-word argument</em> (generate kwarg). Setting the <code>&quot;task&quot;</code> to <code>&quot;transcribe&quot;</code>
forces Whisper to perform the task of <em>speech recognition</em>, where the audio is transcribed in the same language that the
speech was spoken in. Whisper is also capable of performing the closely related task of <em>speech translation</em>, where the
audio in Spanish can be translated to text in English. To achieve this, we set the <code>&quot;task&quot;</code> to <code>&quot;translate&quot;</code>:`,$s,Ze,Ws,_e,xl="<strong>Output:</strong>",Fs,Ne,Zs,Ye,Bl=`Now that we know we can toggle between speech recognition and speech translation, we can pick our task depending on our
needs. Either we recognise from audio in language X to text in the same language X (e.g. Spanish audio to Spanish text),
or we translate from audio in any language X to text in English (e.g. Spanish audio to English text).`,_s,Ae,El=`To read more about how the <code>&quot;task&quot;</code> argument is used to control the properties of the generated text, refer to the
<a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">model card</a> for the Whisper base model.`,Ns,v,x,St,Le,Ha,ft,Gl="Long-Form Transcription and Timestamps",Ys,qe,Rl=`So far, we’ve focussed on transcribing short audio samples of less than 30 seconds. We mentioned that one of the appeals
of Whisper was its ability to work on long audio samples. We’ll tackle this task here!`,As,Qe,Vl=`Let’s create a long audio file by concatenating sequential samples from the MLS dataset. Since the MLS dataset is
curated by splitting long audiobook recordings into shorter segments, concatenating samples is one way of reconstructing
longer audiobook passages. Consequently, the resulting audio should be coherent across the entire sample.`,Ls,Xe,Hl="We’ll set our target audio length to 5 minutes, and stop concatenating samples once we hit this value:",qs,ze,Qs,Pe,$l="<strong>Output:</strong>",Xs,Oe,zs,De,Wl=`Alright! 5 minutes and 17 seconds of audio to transcribe. There are two problems with forwarding this long audio sample
directly to the model:`,Ps,Ke,Fl="<li>Whisper is inherently designed to work with 30 second samples: anything shorter than 30s is padded to 30s with silence, anything longer than 30s is truncated to 30s by cutting of the extra audio, so if we pass our audio directly we’ll only get the transcription for the first 30s</li> <li>Memory in a transformer network scales with the sequence length squared: doubling the input length quadruples the memory requirement, so passing super long audio files is bound to lead to an out-of-memory (OOM) error</li>",Os,et,Zl=`The way long-form transcription works in 🤗 Transformers is by <em>chunking</em> the input audio into smaller, more manageable segments.
Each segment has a small amount of overlap with the previous one. This allows us to accurately stitch the segments back together
at the boundaries, since we can find the overlap between segments and merge the transcriptions accordingly:`,Ds,B,_l='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',Ks,T,$a,ea,un='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',ta,sa,Mn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',aa,gt,Nl="stateless",Wa,la,yn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',na,ia,wn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',oa,bt,Yl="batch",Fa,E,Al="blog post",Za,ra,tt,Ll=`To activate long-form transcriptions, we have to add one additional argument when we call the pipeline. This argument,
<code>chunk_length_s</code>, controls the length of the chunked segments in seconds. For Whisper, 30 second chunks are optimal,
since this matches the input length Whisper expects.`,pa,st,ql=`To activate batching, we need to pass the argument <code>batch_size</code> to the pipeline. Putting it all together, we can transcribe the
long audio sample with chunking and batching as follows:`,ha,at,ca,lt,Ql="<strong>Output:</strong>",da,nt,ma,it,Xl=`We won’t print the entire output here since it’s pretty long (312 words total)! On a 16GB V100 GPU, you can expect the above
line to take approximately 3.45 seconds to run, which is pretty good for a 317 second audio sample. On a CPU, expect
closer to 30 seconds.`,ua,ot,zl=`Whisper is also able to predict segment-level <em>timestamps</em> for the audio data. These timestamps indicate the start and end
time for a short passage of audio, and are particularly useful for aligning a transcription with the input audio. Suppose
we want to provide closed captions for a video - we need these timestamps to know which part of the transcription corresponds
to a certain segment of video, in order to display the correct transcription for that time.`,Ma,rt,Pl=`Activating timestamp prediction is straightforward, we just need to set the argument <code>return_timestamps=True</code>. Timestamps
are compatible with both the chunking and batching methods we used previously, so we can simply append the timestamp
argument to our previous call:`,ya,pt,wa,ht,Ol="<strong>Output:</strong>",Ta,ct,Ua,dt,Dl="And voila! We have our predicted text as well as corresponding timestamps.",fa,I,G,Ct,mt,_a,Jt,Kl="Summary",ga,ut,en=`Whisper is a strong pre-trained model for speech recognition and translation. Compared to Wav2Vec2, it has higher
transcription accuracy, with outputs that contain punctuation and casing. It can be used to transcribe speech in English
as well as 96 other languages, both on short audio segments and longer ones through <em>chunking</em>. These attributes make it
a viable model for many speech recognition and translation tasks without the need for fine-tuning. The <code>pipeline()</code> method
provides an easy way of running inference in one-line API calls with control over the generated predictions.`,ba,Mt,tn=`While the Whisper model performs extremely well on many high-resource languages, it has lower transcription and translation
accuracy on low-resource languages, i.e. those with less readily available training data. There is also varying performance
across different accents and dialects of certain languages, including lower accuracy for speakers of different genders,
races, ages or other demographic criteria (<em>c.f.</em> <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper paper</a>).`,Ja,yt,sn=`To boost the performance on low-resource languages, accents or dialects, we can take the pre-trained Whisper model and
train it on a small corpus of appropriately selected data, in a process called <em>fine-tuning</em>. We’ll show that with
as little as ten hours of additional data, we can improve the performance of the Whisper model by over 100% on a low-resource
language. In the next section, we’ll cover the process behind selecting a dataset for fine-tuning.`,ja,xt,va;return H=new Bt({}),N=new Bt({}),A=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`}}),q=new w({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`}}),X=new w({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),P=new w({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND'}}),D=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`}}),ee=new w({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())'}}),se=new w({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>'}}),le=new w({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`}}),pe=new Bt({}),ge=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`}}),Je=new w({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)'}}),ve=new w({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}'}}),ke=new w({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`}}),xe=new w({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`}}),Ee=new w({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),Re=new w({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado'}}),He=new w({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})'}}),We=new w({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}'}}),Ze=new w({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})'}}),Ne=new w({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>'}}),Le=new Bt({}),ze=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2xlbmd0aF9pbl9tJTIwJTNEJTIwNSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBmcm9tJTIwbWludXRlcyUyMHRvJTIwc2Vjb25kcyUyMCgqJTIwNjApJTIwdG8lMjBudW0lMjBzYW1wbGVzJTIwKColMjBzYW1wbGluZyUyMHJhdGUpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMHBpcGUuZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUwQXRhcmdldF9sZW5ndGhfaW5fc2FtcGxlcyUyMCUzRCUyMHRhcmdldF9sZW5ndGhfaW5fbSUyMColMjA2MCUyMColMjBzYW1wbGluZ19yYXRlJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMG92ZXIlMjBvdXIlMjBzdHJlYW1pbmclMjBkYXRhc2V0JTJDJTIwY29uY2F0ZW5hdGluZyUyMHNhbXBsZXMlMjB1bnRpbCUyMHdlJTIwaGl0JTIwb3VyJTIwdGFyZ2V0JTBBbG9uZ19hdWRpbyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMHNhbXBsZSUyMGluJTIwZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMGxvbmdfYXVkaW8uZXh0ZW5kKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4obG9uZ19hdWRpbyklMjAlM0UlMjB0YXJnZXRfbGVuZ3RoX2luX3NhbXBsZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUwQWxvbmdfYXVkaW8lMjAlM0QlMjBucC5hc2FycmF5KGxvbmdfYXVkaW8pJTBBJTBBJTIzJTIwaG93JTIwZGlkJTIwd2UlMjBkbyUzRiUwQXNlY29uZHMlMjAlM0QlMjBsZW4obG9uZ19hdWRpbyklMjAlMkYlMjAxNjAwMCUwQW1pbnV0ZXMlMkMlMjBzZWNvbmRzJTIwJTNEJTIwZGl2bW9kKHNlY29uZHMlMkMlMjA2MCklMEFwcmludChmJTIyTGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwJTdCbWludXRlcyU3RCUyMG1pbnV0ZXMlMjAlN0JzZWNvbmRzJTNBLjJmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># convert from minutes to seconds (* 60) to num samples (* sampling rate)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># iterate over our streaming dataset, concatenating samples until we hit our target</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># how did we do?</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`}}),Oe=new w({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds'}}),at=new w({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`}}),nt=new w({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`}}),pt=new w({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`}}),ct=new w({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`}}),mt=new Bt({}),{c(){g=i("meta"),Et=l(),jt=i("p"),Gt=l(),b=i("h1"),k=i("a"),vt=i("span"),h(H.$$.fragment),Ga=l(),wt=i("span"),wt.textContent=Ya,Rt=l(),$=i("p"),$.innerHTML=Aa,Vt=l(),W=i("p"),W.textContent=La,Ht=l(),F=i("ol"),F.innerHTML=qa,$t=l(),Z=i("p"),Z.innerHTML=Qa,Wt=l(),_=i("p"),_.textContent=Xa,Ft=l(),J=i("h2"),S=i("a"),It=i("span"),h(N.$$.fragment),Ra=l(),Tt=i("span"),Tt.textContent=za,Zt=l(),Y=i("p"),Y.innerHTML=Pa,_t=l(),h(A.$$.fragment),Nt=l(),L=i("p"),L.innerHTML=Oa,Yt=l(),h(q.$$.fragment),At=l(),Q=i("p"),Q.textContent=Da,Lt=l(),h(X.$$.fragment),qt=l(),z=i("p"),z.innerHTML=Ka,Qt=l(),h(P.$$.fragment),Xt=l(),O=i("p"),O.innerHTML=el,zt=l(),h(D.$$.fragment),Pt=l(),K=i("p"),K.innerHTML=tl,Ot=l(),h(ee.$$.fragment),Dt=l(),te=i("p"),te.innerHTML=sl,Kt=l(),h(se.$$.fragment),es=l(),ae=i("p"),ae.textContent=al,ts=l(),h(le.$$.fragment),ss=l(),ne=i("p"),ne.innerHTML=ll,as=l(),ie=i("ul"),ie.innerHTML=nl,ls=l(),oe=i("p"),oe.textContent=il,ns=l(),re=i("p"),re.innerHTML=ol,is=l(),j=i("h2"),C=i("a"),kt=i("span"),h(pe.$$.fragment),Va=l(),Ut=i("span"),Ut.textContent=rl,os=l(),he=i("p"),he.innerHTML=pl,rs=l(),ce=i("p"),ce.textContent=hl,ps=l(),de=i("ol"),de.innerHTML=cl,hs=l(),me=i("p"),me.innerHTML=dl,cs=l(),ue=i("p"),ue.innerHTML=ml,ds=l(),Me=i("p"),Me.innerHTML=ul,ms=l(),ye=i("p"),ye.textContent=Ml,us=l(),we=i("p"),we.innerHTML=yl,Ms=l(),Te=i("p"),Te.innerHTML=wl,ys=l(),Ue=i("table"),Ue.innerHTML=Tl,ws=l(),fe=i("p"),fe.innerHTML=Ul,Ts=l(),h(ge.$$.fragment),Us=l(),be=i("p"),be.innerHTML=fl,fs=l(),h(Je.$$.fragment),gs=l(),je=i("p"),je.innerHTML=gl,bs=l(),h(ve.$$.fragment),Js=l(),Ie=i("p"),Ie.textContent=bl,js=l(),h(ke.$$.fragment),vs=l(),Se=i("p"),Se.innerHTML=Jl,Is=l(),Ce=i("p"),Ce.innerHTML=jl,ks=l(),h(xe.$$.fragment),Ss=l(),Be=i("p"),Be.textContent=vl,Cs=l(),h(Ee.$$.fragment),xs=l(),Ge=i("p"),Ge.innerHTML=Il,Bs=l(),h(Re.$$.fragment),Es=l(),Ve=i("p"),Ve.innerHTML=kl,Gs=l(),h(He.$$.fragment),Rs=l(),$e=i("p"),$e.innerHTML=Sl,Vs=l(),h(We.$$.fragment),Hs=l(),Fe=i("p"),Fe.innerHTML=Cl,$s=l(),h(Ze.$$.fragment),Ws=l(),_e=i("p"),_e.innerHTML=xl,Fs=l(),h(Ne.$$.fragment),Zs=l(),Ye=i("p"),Ye.textContent=Bl,_s=l(),Ae=i("p"),Ae.innerHTML=El,Ns=l(),v=i("h2"),x=i("a"),St=i("span"),h(Le.$$.fragment),Ha=l(),ft=i("span"),ft.textContent=Gl,Ys=l(),qe=i("p"),qe.textContent=Rl,As=l(),Qe=i("p"),Qe.textContent=Vl,Ls=l(),Xe=i("p"),Xe.textContent=Hl,qs=l(),h(ze.$$.fragment),Qs=l(),Pe=i("p"),Pe.innerHTML=$l,Xs=l(),h(Oe.$$.fragment),zs=l(),De=i("p"),De.textContent=Wl,Ps=l(),Ke=i("ol"),Ke.innerHTML=Fl,Os=l(),et=i("p"),et.innerHTML=Zl,Ds=l(),B=i("div"),B.innerHTML=_l,Ks=l(),T=i("p"),$a=R("The advantage of chunking the samples is that we don’t need the result of chunk "),ea=new Ba(!1),ta=R(` to transcribe the subsequent
chunk `),sa=new Ba(!1),aa=R(`. The stitching is done after we have transcribed all the chunks at the chunk boundaries, so it doesn’t
matter which order we transcribe chunks in. The algorithm is entirely `),gt=i("strong"),gt.textContent=Nl,Wa=R(", so we can even do chunk "),la=new Ba(!1),na=R(`
at the same time as chunk `),ia=new Ba(!1),oa=R("! This allows us to "),bt=i("em"),bt.textContent=Yl,Fa=R(` the chunks and run them through the model in parallel,
providing a large computational speed-up compared to transcribing them sequentially. To read more about chunking in 🤗 Transformers,
you can refer to this `),E=i("a"),E.textContent=Al,Za=R("."),ra=l(),tt=i("p"),tt.innerHTML=Ll,pa=l(),st=i("p"),st.innerHTML=ql,ha=l(),h(at.$$.fragment),ca=l(),lt=i("p"),lt.innerHTML=Ql,da=l(),h(nt.$$.fragment),ma=l(),it=i("p"),it.textContent=Xl,ua=l(),ot=i("p"),ot.innerHTML=zl,Ma=l(),rt=i("p"),rt.innerHTML=Pl,ya=l(),h(pt.$$.fragment),wa=l(),ht=i("p"),ht.innerHTML=Ol,Ta=l(),h(ct.$$.fragment),Ua=l(),dt=i("p"),dt.textContent=Dl,fa=l(),I=i("h2"),G=i("a"),Ct=i("span"),h(mt.$$.fragment),_a=l(),Jt=i("span"),Jt.textContent=Kl,ga=l(),ut=i("p"),ut.innerHTML=en,ba=l(),Mt=i("p"),Mt.innerHTML=tn,Ja=l(),yt=i("p"),yt.innerHTML=sn,ja=l(),xt=i("p"),this.h()},l(e){const t=Jn("svelte-1phssyn",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(s),Et=n(e),jt=o(e,"P",{}),U(jt).forEach(s),Gt=n(e),b=o(e,"H1",{class:!0});var Ia=U(b);k=o(Ia,"A",{id:!0,class:!0,href:!0});var an=U(k);vt=o(an,"SPAN",{});var ln=U(vt);c(H.$$.fragment,ln),ln.forEach(s),an.forEach(s),Ga=n(Ia),wt=o(Ia,"SPAN",{"data-svelte-h":!0}),r(wt)!=="svelte-tusf4r"&&(wt.textContent=Ya),Ia.forEach(s),Rt=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-qu6ugv"&&($.innerHTML=Aa),Vt=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1lo7cg7"&&(W.textContent=La),Ht=n(e),F=o(e,"OL",{"data-svelte-h":!0}),r(F)!=="svelte-4r9go5"&&(F.innerHTML=qa),$t=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-7bh989"&&(Z.innerHTML=Qa),Wt=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1y7wlps"&&(_.textContent=Xa),Ft=n(e),J=o(e,"H2",{class:!0});var ka=U(J);S=o(ka,"A",{id:!0,class:!0,href:!0});var nn=U(S);It=o(nn,"SPAN",{});var on=U(It);c(N.$$.fragment,on),on.forEach(s),nn.forEach(s),Ra=n(ka),Tt=o(ka,"SPAN",{"data-svelte-h":!0}),r(Tt)!=="svelte-16a5ycy"&&(Tt.textContent=za),ka.forEach(s),Zt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-6p3rx4"&&(Y.innerHTML=Pa),_t=n(e),c(A.$$.fragment,e),Nt=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1mvdyro"&&(L.innerHTML=Oa),Yt=n(e),c(q.$$.fragment,e),At=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1f14qa5"&&(Q.textContent=Da),Lt=n(e),c(X.$$.fragment,e),qt=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1mvdyro"&&(z.innerHTML=Ka),Qt=n(e),c(P.$$.fragment,e),Xt=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-zwb92k"&&(O.innerHTML=el),zt=n(e),c(D.$$.fragment,e),Pt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-160y70r"&&(K.innerHTML=tl),Ot=n(e),c(ee.$$.fragment,e),Dt=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1mvdyro"&&(te.innerHTML=sl),Kt=n(e),c(se.$$.fragment,e),es=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1n1tyml"&&(ae.textContent=al),ts=n(e),c(le.$$.fragment,e),ss=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-fjdtrw"&&(ne.innerHTML=ll),as=n(e),ie=o(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-11mc7qy"&&(ie.innerHTML=nl),ls=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-18hr596"&&(oe.textContent=il),ns=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-mwf7be"&&(re.innerHTML=ol),is=n(e),j=o(e,"H2",{class:!0});var Sa=U(j);C=o(Sa,"A",{id:!0,class:!0,href:!0});var rn=U(C);kt=o(rn,"SPAN",{});var pn=U(kt);c(pe.$$.fragment,pn),pn.forEach(s),rn.forEach(s),Va=n(Sa),Ut=o(Sa,"SPAN",{"data-svelte-h":!0}),r(Ut)!=="svelte-qaour4"&&(Ut.textContent=rl),Sa.forEach(s),os=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-55oy83"&&(he.innerHTML=pl),rs=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-969zyv"&&(ce.textContent=hl),ps=n(e),de=o(e,"OL",{"data-svelte-h":!0}),r(de)!=="svelte-osi73t"&&(de.innerHTML=cl),hs=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1bn96on"&&(me.innerHTML=dl),cs=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-zyrdbw"&&(ue.innerHTML=ml),ds=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-em8jox"&&(Me.innerHTML=ul),ms=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1g5392c"&&(ye.textContent=Ml),us=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-5h4os6"&&(we.innerHTML=yl),Ms=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-uy2cuy"&&(Te.innerHTML=wl),ys=n(e),Ue=o(e,"TABLE",{"data-svelte-h":!0}),r(Ue)!=="svelte-leifmh"&&(Ue.innerHTML=Tl),ws=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-efpzbz"&&(fe.innerHTML=Ul),Ts=n(e),c(ge.$$.fragment,e),Us=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1feq0tt"&&(be.innerHTML=fl),fs=n(e),c(Je.$$.fragment,e),gs=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1mvdyro"&&(je.innerHTML=gl),bs=n(e),c(ve.$$.fragment,e),Js=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-18db65j"&&(Ie.textContent=bl),js=n(e),c(ke.$$.fragment,e),vs=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-mm1pes"&&(Se.innerHTML=Jl),Is=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1ol57p5"&&(Ce.innerHTML=jl),ks=n(e),c(xe.$$.fragment,e),Ss=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1f9nh4o"&&(Be.textContent=vl),Cs=n(e),c(Ee.$$.fragment,e),xs=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1mvdyro"&&(Ge.innerHTML=Il),Bs=n(e),c(Re.$$.fragment,e),Es=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-75q7fw"&&(Ve.innerHTML=kl),Gs=n(e),c(He.$$.fragment,e),Rs=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1mvdyro"&&($e.innerHTML=Sl),Vs=n(e),c(We.$$.fragment,e),Hs=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-uzlabu"&&(Fe.innerHTML=Cl),$s=n(e),c(Ze.$$.fragment,e),Ws=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1mvdyro"&&(_e.innerHTML=xl),Fs=n(e),c(Ne.$$.fragment,e),Zs=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-joibr"&&(Ye.textContent=Bl),_s=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1aecqb1"&&(Ae.innerHTML=El),Ns=n(e),v=o(e,"H2",{class:!0});var Ca=U(v);x=o(Ca,"A",{id:!0,class:!0,href:!0});var hn=U(x);St=o(hn,"SPAN",{});var cn=U(St);c(Le.$$.fragment,cn),cn.forEach(s),hn.forEach(s),Ha=n(Ca),ft=o(Ca,"SPAN",{"data-svelte-h":!0}),r(ft)!=="svelte-4r07q0"&&(ft.textContent=Gl),Ca.forEach(s),Ys=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-ad6ien"&&(qe.textContent=Rl),As=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1atykwj"&&(Qe.textContent=Vl),Ls=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-8fkb86"&&(Xe.textContent=Hl),qs=n(e),c(ze.$$.fragment,e),Qs=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1mvdyro"&&(Pe.innerHTML=$l),Xs=n(e),c(Oe.$$.fragment,e),zs=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-rlobar"&&(De.textContent=Wl),Ps=n(e),Ke=o(e,"OL",{"data-svelte-h":!0}),r(Ke)!=="svelte-xow7at"&&(Ke.innerHTML=Fl),Os=n(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1kl6cah"&&(et.innerHTML=Zl),Ds=n(e),B=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(B)!=="svelte-dbmn5s"&&(B.innerHTML=_l),Ks=n(e),T=o(e,"P",{});var f=U(T);$a=V(f,"The advantage of chunking the samples is that we don’t need the result of chunk "),ea=Ea(f,!1),ta=V(f,` to transcribe the subsequent
chunk `),sa=Ea(f,!1),aa=V(f,`. The stitching is done after we have transcribed all the chunks at the chunk boundaries, so it doesn’t
matter which order we transcribe chunks in. The algorithm is entirely `),gt=o(f,"STRONG",{"data-svelte-h":!0}),r(gt)!=="svelte-1caf2ri"&&(gt.textContent=Nl),Wa=V(f,", so we can even do chunk "),la=Ea(f,!1),na=V(f,`
at the same time as chunk `),ia=Ea(f,!1),oa=V(f,"! This allows us to "),bt=o(f,"EM",{"data-svelte-h":!0}),r(bt)!=="svelte-1swb9sm"&&(bt.textContent=Yl),Fa=V(f,` the chunks and run them through the model in parallel,
providing a large computational speed-up compared to transcribing them sequentially. To read more about chunking in 🤗 Transformers,
you can refer to this `),E=o(f,"A",{href:!0,rel:!0,"data-svelte-h":!0}),r(E)!=="svelte-1d46t8h"&&(E.textContent=Al),Za=V(f,"."),f.forEach(s),ra=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1bfrg8c"&&(tt.innerHTML=Ll),pa=n(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1ldveni"&&(st.innerHTML=ql),ha=n(e),c(at.$$.fragment,e),ca=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1mvdyro"&&(lt.innerHTML=Ql),da=n(e),c(nt.$$.fragment,e),ma=n(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-wy7qyj"&&(it.textContent=Xl),ua=n(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1pdqzp1"&&(ot.innerHTML=zl),Ma=n(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1kodbk1"&&(rt.innerHTML=Pl),ya=n(e),c(pt.$$.fragment,e),wa=n(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1mvdyro"&&(ht.innerHTML=Ol),Ta=n(e),c(ct.$$.fragment,e),Ua=n(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-7n3xc4"&&(dt.textContent=Dl),fa=n(e),I=o(e,"H2",{class:!0});var xa=U(I);G=o(xa,"A",{id:!0,class:!0,href:!0});var dn=U(G);Ct=o(dn,"SPAN",{});var mn=U(Ct);c(mt.$$.fragment,mn),mn.forEach(s),dn.forEach(s),_a=n(xa),Jt=o(xa,"SPAN",{"data-svelte-h":!0}),r(Jt)!=="svelte-lnd84v"&&(Jt.textContent=Kl),xa.forEach(s),ga=n(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1t35nks"&&(ut.innerHTML=en),ba=n(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1eiih7q"&&(Mt.innerHTML=tn),Ja=n(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-a24nm6"&&(yt.innerHTML=sn),ja=n(e),xt=o(e,"P",{}),U(xt).forEach(s),this.h()},h(){y(g,"name","hf:doc:metadata"),y(g,"content",JSON.stringify(vn)),y(k,"id","pretrained-models-for-automatic-speech-recognition"),y(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(k,"href","#pretrained-models-for-automatic-speech-recognition"),y(b,"class","relative group"),y(S,"id","probing-ctc-models"),y(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(S,"href","#probing-ctc-models"),y(J,"class","relative group"),y(C,"id","graduation-to-seq2seq"),y(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(C,"href","#graduation-to-seq2seq"),y(j,"class","relative group"),y(x,"id","longform-transcription-and-timestamps"),y(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(x,"href","#longform-transcription-and-timestamps"),y(v,"class","relative group"),y(B,"class","flex justify-center"),ea.a=ta,sa.a=aa,la.a=na,ia.a=oa,y(E,"href","https://huggingface.co/blog/asr-chunking"),y(E,"rel","nofollow"),y(G,"id","summary"),y(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(G,"href","#summary"),y(I,"class","relative group")},m(e,t){p(document.head,g),a(e,Et,t),a(e,jt,t),a(e,Gt,t),a(e,b,t),p(b,k),p(k,vt),d(H,vt,null),p(b,Ga),p(b,wt),a(e,Rt,t),a(e,$,t),a(e,Vt,t),a(e,W,t),a(e,Ht,t),a(e,F,t),a(e,$t,t),a(e,Z,t),a(e,Wt,t),a(e,_,t),a(e,Ft,t),a(e,J,t),p(J,S),p(S,It),d(N,It,null),p(J,Ra),p(J,Tt),a(e,Zt,t),a(e,Y,t),a(e,_t,t),d(A,e,t),a(e,Nt,t),a(e,L,t),a(e,Yt,t),d(q,e,t),a(e,At,t),a(e,Q,t),a(e,Lt,t),d(X,e,t),a(e,qt,t),a(e,z,t),a(e,Qt,t),d(P,e,t),a(e,Xt,t),a(e,O,t),a(e,zt,t),d(D,e,t),a(e,Pt,t),a(e,K,t),a(e,Ot,t),d(ee,e,t),a(e,Dt,t),a(e,te,t),a(e,Kt,t),d(se,e,t),a(e,es,t),a(e,ae,t),a(e,ts,t),d(le,e,t),a(e,ss,t),a(e,ne,t),a(e,as,t),a(e,ie,t),a(e,ls,t),a(e,oe,t),a(e,ns,t),a(e,re,t),a(e,is,t),a(e,j,t),p(j,C),p(C,kt),d(pe,kt,null),p(j,Va),p(j,Ut),a(e,os,t),a(e,he,t),a(e,rs,t),a(e,ce,t),a(e,ps,t),a(e,de,t),a(e,hs,t),a(e,me,t),a(e,cs,t),a(e,ue,t),a(e,ds,t),a(e,Me,t),a(e,ms,t),a(e,ye,t),a(e,us,t),a(e,we,t),a(e,Ms,t),a(e,Te,t),a(e,ys,t),a(e,Ue,t),a(e,ws,t),a(e,fe,t),a(e,Ts,t),d(ge,e,t),a(e,Us,t),a(e,be,t),a(e,fs,t),d(Je,e,t),a(e,gs,t),a(e,je,t),a(e,bs,t),d(ve,e,t),a(e,Js,t),a(e,Ie,t),a(e,js,t),d(ke,e,t),a(e,vs,t),a(e,Se,t),a(e,Is,t),a(e,Ce,t),a(e,ks,t),d(xe,e,t),a(e,Ss,t),a(e,Be,t),a(e,Cs,t),d(Ee,e,t),a(e,xs,t),a(e,Ge,t),a(e,Bs,t),d(Re,e,t),a(e,Es,t),a(e,Ve,t),a(e,Gs,t),d(He,e,t),a(e,Rs,t),a(e,$e,t),a(e,Vs,t),d(We,e,t),a(e,Hs,t),a(e,Fe,t),a(e,$s,t),d(Ze,e,t),a(e,Ws,t),a(e,_e,t),a(e,Fs,t),d(Ne,e,t),a(e,Zs,t),a(e,Ye,t),a(e,_s,t),a(e,Ae,t),a(e,Ns,t),a(e,v,t),p(v,x),p(x,St),d(Le,St,null),p(v,Ha),p(v,ft),a(e,Ys,t),a(e,qe,t),a(e,As,t),a(e,Qe,t),a(e,Ls,t),a(e,Xe,t),a(e,qs,t),d(ze,e,t),a(e,Qs,t),a(e,Pe,t),a(e,Xs,t),d(Oe,e,t),a(e,zs,t),a(e,De,t),a(e,Ps,t),a(e,Ke,t),a(e,Os,t),a(e,et,t),a(e,Ds,t),a(e,B,t),a(e,Ks,t),a(e,T,t),p(T,$a),ea.m(un,T),p(T,ta),sa.m(Mn,T),p(T,aa),p(T,gt),p(T,Wa),la.m(yn,T),p(T,na),ia.m(wn,T),p(T,oa),p(T,bt),p(T,Fa),p(T,E),p(T,Za),a(e,ra,t),a(e,tt,t),a(e,pa,t),a(e,st,t),a(e,ha,t),d(at,e,t),a(e,ca,t),a(e,lt,t),a(e,da,t),d(nt,e,t),a(e,ma,t),a(e,it,t),a(e,ua,t),a(e,ot,t),a(e,Ma,t),a(e,rt,t),a(e,ya,t),d(pt,e,t),a(e,wa,t),a(e,ht,t),a(e,Ta,t),d(ct,e,t),a(e,Ua,t),a(e,dt,t),a(e,fa,t),a(e,I,t),p(I,G),p(G,Ct),d(mt,Ct,null),p(I,_a),p(I,Jt),a(e,ga,t),a(e,ut,t),a(e,ba,t),a(e,Mt,t),a(e,Ja,t),a(e,yt,t),a(e,ja,t),a(e,xt,t),va=!0},p:Un,i(e){va||(m(H.$$.fragment,e),m(N.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(X.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(pe.$$.fragment,e),m(ge.$$.fragment,e),m(Je.$$.fragment,e),m(ve.$$.fragment,e),m(ke.$$.fragment,e),m(xe.$$.fragment,e),m(Ee.$$.fragment,e),m(Re.$$.fragment,e),m(He.$$.fragment,e),m(We.$$.fragment,e),m(Ze.$$.fragment,e),m(Ne.$$.fragment,e),m(Le.$$.fragment,e),m(ze.$$.fragment,e),m(Oe.$$.fragment,e),m(at.$$.fragment,e),m(nt.$$.fragment,e),m(pt.$$.fragment,e),m(ct.$$.fragment,e),m(mt.$$.fragment,e),va=!0)},o(e){u(H.$$.fragment,e),u(N.$$.fragment,e),u(A.$$.fragment,e),u(q.$$.fragment,e),u(X.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(pe.$$.fragment,e),u(ge.$$.fragment,e),u(Je.$$.fragment,e),u(ve.$$.fragment,e),u(ke.$$.fragment,e),u(xe.$$.fragment,e),u(Ee.$$.fragment,e),u(Re.$$.fragment,e),u(He.$$.fragment,e),u(We.$$.fragment,e),u(Ze.$$.fragment,e),u(Ne.$$.fragment,e),u(Le.$$.fragment,e),u(ze.$$.fragment,e),u(Oe.$$.fragment,e),u(at.$$.fragment,e),u(nt.$$.fragment,e),u(pt.$$.fragment,e),u(ct.$$.fragment,e),u(mt.$$.fragment,e),va=!1},d(e){e&&(s(Et),s(jt),s(Gt),s(b),s(Rt),s($),s(Vt),s(W),s(Ht),s(F),s($t),s(Z),s(Wt),s(_),s(Ft),s(J),s(Zt),s(Y),s(_t),s(Nt),s(L),s(Yt),s(At),s(Q),s(Lt),s(qt),s(z),s(Qt),s(Xt),s(O),s(zt),s(Pt),s(K),s(Ot),s(Dt),s(te),s(Kt),s(es),s(ae),s(ts),s(ss),s(ne),s(as),s(ie),s(ls),s(oe),s(ns),s(re),s(is),s(j),s(os),s(he),s(rs),s(ce),s(ps),s(de),s(hs),s(me),s(cs),s(ue),s(ds),s(Me),s(ms),s(ye),s(us),s(we),s(Ms),s(Te),s(ys),s(Ue),s(ws),s(fe),s(Ts),s(Us),s(be),s(fs),s(gs),s(je),s(bs),s(Js),s(Ie),s(js),s(vs),s(Se),s(Is),s(Ce),s(ks),s(Ss),s(Be),s(Cs),s(xs),s(Ge),s(Bs),s(Es),s(Ve),s(Gs),s(Rs),s($e),s(Vs),s(Hs),s(Fe),s($s),s(Ws),s(_e),s(Fs),s(Zs),s(Ye),s(_s),s(Ae),s(Ns),s(v),s(Ys),s(qe),s(As),s(Qe),s(Ls),s(Xe),s(qs),s(Qs),s(Pe),s(Xs),s(zs),s(De),s(Ps),s(Ke),s(Os),s(et),s(Ds),s(B),s(Ks),s(T),s(ra),s(tt),s(pa),s(st),s(ha),s(ca),s(lt),s(da),s(ma),s(it),s(ua),s(ot),s(Ma),s(rt),s(ya),s(wa),s(ht),s(Ta),s(Ua),s(dt),s(fa),s(I),s(ga),s(ut),s(ba),s(Mt),s(Ja),s(yt),s(ja),s(xt)),s(g),M(H),M(N),M(A,e),M(q,e),M(X,e),M(P,e),M(D,e),M(ee,e),M(se,e),M(le,e),M(pe),M(ge,e),M(Je,e),M(ve,e),M(ke,e),M(xe,e),M(Ee,e),M(Re,e),M(He,e),M(We,e),M(Ze,e),M(Ne,e),M(Le),M(ze,e),M(Oe,e),M(at,e),M(nt,e),M(pt,e),M(ct,e),M(mt)}}}const vn={local:"pretrained-models-for-automatic-speech-recognition",sections:[{local:"probing-ctc-models",title:"Probing CTC Models"},{local:"graduation-to-seq2seq",title:"Graduation to Seq2Seq"},{local:"longform-transcription-and-timestamps",title:"Long-Form Transcription and Timestamps"},{local:"summary",title:"Summary"}],title:"Pre-trained models for automatic speech recognition"};function In(Na){return fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bn extends gn{constructor(g){super(),bn(this,g,In,jn,Tn,{})}}export{Bn as component};
