import{s as _e,f as ke,n as xe,o as Ge}from"../chunks/scheduler.f7e1785c.js";import{S as Ze,i as Be,g as o,s,u as E,A as Ee,h as i,f as t,c as n,j as x,v as $,y as p,k as u,o as S,a,w as H,d as Y,t as Q,x as R}from"../chunks/index.815a732f.js";import{I as $e}from"../chunks/IconCopyLink.e7937f56.js";import{C as ce}from"../chunks/CodeBlock.c6e8b464.js";function Se(de){let c,V,G,N,h,d,Z,M,he,k,Me="Build a demo with Gradio",q,m,me=`Now that we’ve fine-tuned a Whisper model for Dhivehi speech recognition, let’s go ahead and build a <a href="https://gradio.app" rel="nofollow">Gradio</a>
demo to showcase it to the community!`,X,y,ye=`The first thing to do is load up the fine-tuned checkpoint using the <code>pipeline()</code> class - this is very familiar now from
the section on <a href="asr_models">pre-trained models</a>. You can change the <code>model_id</code> to the namespace of your fine-tuned
model on the Hugging Face Hub, or one of the pre-trained <a href="https://huggingface.co/models?sort=downloads&amp;search=openai%2Fwhisper-" rel="nofollow">Whisper models</a>
to perform zero-shot speech recognition:`,z,w,F,f,we=`Secondly, we’ll define a function that takes the filepath for an audio input and passes it through the pipeline. Here,
the pipeline automatically takes care of loading the audio file, resampling it to the correct sampling rate, and running
inference with the model. We can then simply return the transcribed text as the output of the function. To ensure our
model can handle audio inputs of arbitrary length, we’ll enable <em>chunking</em> as described in the section
on <a href="asr_models">pre-trained models</a>:`,P,j,L,U,fe=`We’ll use the Gradio <a href="https://gradio.app/docs/#blocks" rel="nofollow">blocks</a> feature to launch two tabs on our demo: one for microphone
transcription, and the other for file upload.`,K,J,D,T,je="Finally, we launch the Gradio demo using the two blocks that we’ve just defined:",O,g,ee,b,Ue="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",te,r,Je,le,C,Te="Should you wish to host your demo on the Hugging Face Hub, you can use this Space as a template for your fine-tuned model.",ae,v,ge='Click the link to duplicate the template demo to your account: <a href="https://huggingface.co/spaces/course-demos/whisper-small?duplicate=true" rel="nofollow">https://huggingface.co/spaces/course-demos/whisper-small?duplicate=true</a>',se,I,be="We recommend giving your space a similar name to your fine-tuned model (e.g. whisper-small-dv-demo) and setting the visibility to “Public”.",ne,A,Ce=`Once you’ve duplicated the Space to your account, click “Files and versions” -> “app.py” -> “edit”. Then change the
model identifier to your fine-tuned model (line 6). Scroll to the bottom of the page and click “Commit changes to main”.
The demo will reboot, this time using your fine-tuned model. You can share this demo with your friends and family so that
they can use the model that you’ve trained!`,oe,W,ve='Checkout our video tutorial to get a better understanding of how to duplicate the Space 👉️ <a href="https://www.youtube.com/watch?v=VQYuvl6-9VE" rel="nofollow">YouTube Video</a>',ie,_,Ie="We look forward to seeing your demos on the Hub!",re,B,pe;return M=new $e({}),w=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzYW5jaGl0LWdhbmRoaSUyRndoaXNwZXItc21hbGwtZHYlMjIlMjAlMjAlMjMlMjB1cGRhdGUlMjB3aXRoJTIweW91ciUyMG1vZGVsJTIwaWQlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model_id = <span class="hljs-string">&quot;sanchit-gandhi/whisper-small-dv&quot;</span>  <span class="hljs-comment"># update with your model id</span>
pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model_id)`}}),j=new ce({props:{code:"ZGVmJTIwdHJhbnNjcmliZV9zcGVlY2goZmlsZXBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWxlcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zY3JpYmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5ndWFnZSUyMiUzQSUyMCUyMnNpbmhhbGVzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUyMCUyMyUyMHVwZGF0ZSUyMHdpdGglMjB0aGUlMjBsYW5ndWFnZSUyMHlvdSd2ZSUyMGZpbmUtdHVuZWQlMjBvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXQlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_speech</span>(<span class="hljs-params">filepath</span>):
    output = pipe(
        filepath,
        max_new_tokens=<span class="hljs-number">256</span>,
        generate_kwargs={
            <span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>,
            <span class="hljs-string">&quot;language&quot;</span>: <span class="hljs-string">&quot;sinhalese&quot;</span>,
        },  <span class="hljs-comment"># update with the language you&#x27;ve fine-tuned on</span>
        chunk_length_s=<span class="hljs-number">30</span>,
        batch_size=<span class="hljs-number">8</span>,
    )
    <span class="hljs-keyword">return</span> output[<span class="hljs-string">&quot;text&quot;</span>]`}}),J=new ce({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQW1pY190cmFuc2NyaWJlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEdHJhbnNjcmliZV9zcGVlY2glMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyKSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0Rnci5vdXRwdXRzLlRleHRib3goKSUyQyUwQSklMEElMEFmaWxlX3RyYW5zY3JpYmUlMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0R0cmFuc2NyaWJlX3NwZWVjaCUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyUzRGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3Iub3V0cHV0cy5UZXh0Ym94KCklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Blocks()

mic_transcribe = gr.Interface(
    fn=transcribe_speech,
    inputs=gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.outputs.Textbox(),
)

file_transcribe = gr.Interface(
    fn=transcribe_speech,
    inputs=gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.outputs.Textbox(),
)`}}),g=new ce({props:{code:"d2l0aCUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjBnci5UYWJiZWRJbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCbWljX3RyYW5zY3JpYmUlMkMlMjBmaWxlX3RyYW5zY3JpYmUlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMjJUcmFuc2NyaWJlJTIwTWljcm9waG9uZSUyMiUyQyUyMCUyMlRyYW5zY3JpYmUlMjBBdWRpbyUyMEZpbGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBZGVtby5sYXVuY2goZGVidWclM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">with</span> demo:
    gr.TabbedInterface(
        [mic_transcribe, file_transcribe],
        [<span class="hljs-string">&quot;Transcribe Microphone&quot;</span>, <span class="hljs-string">&quot;Transcribe Audio File&quot;</span>],
    )

demo.launch(debug=<span class="hljs-literal">True</span>)`}}),{c(){c=o("meta"),V=s(),G=o("p"),N=s(),h=o("h1"),d=o("a"),Z=o("span"),E(M.$$.fragment),he=s(),k=o("span"),k.textContent=Me,q=s(),m=o("p"),m.innerHTML=me,X=s(),y=o("p"),y.innerHTML=ye,z=s(),E(w.$$.fragment),F=s(),f=o("p"),f.innerHTML=we,P=s(),E(j.$$.fragment),L=s(),U=o("p"),U.innerHTML=fe,K=s(),E(J.$$.fragment),D=s(),T=o("p"),T.textContent=je,O=s(),E(g.$$.fragment),ee=s(),b=o("p"),b.textContent=Ue,te=s(),r=o("iframe"),le=s(),C=o("p"),C.textContent=Te,ae=s(),v=o("p"),v.innerHTML=ge,se=s(),I=o("p"),I.textContent=be,ne=s(),A=o("p"),A.textContent=Ce,oe=s(),W=o("p"),W.innerHTML=ve,ie=s(),_=o("p"),_.textContent=Ie,re=s(),B=o("p"),this.h()},l(e){const l=Ee("svelte-1phssyn",document.head);c=i(l,"META",{name:!0,content:!0}),l.forEach(t),V=n(e),G=i(e,"P",{}),x(G).forEach(t),N=n(e),h=i(e,"H1",{class:!0});var ue=x(h);d=i(ue,"A",{id:!0,class:!0,href:!0});var Ae=x(d);Z=i(Ae,"SPAN",{});var We=x(Z);$(M.$$.fragment,We),We.forEach(t),Ae.forEach(t),he=n(ue),k=i(ue,"SPAN",{"data-svelte-h":!0}),p(k)!=="svelte-1yk39ev"&&(k.textContent=Me),ue.forEach(t),q=n(e),m=i(e,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1q95dto"&&(m.innerHTML=me),X=n(e),y=i(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-ldnoqw"&&(y.innerHTML=ye),z=n(e),$(w.$$.fragment,e),F=n(e),f=i(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-g873e4"&&(f.innerHTML=we),P=n(e),$(j.$$.fragment,e),L=n(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-wlltyj"&&(U.innerHTML=fe),K=n(e),$(J.$$.fragment,e),D=n(e),T=i(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1s2jh73"&&(T.textContent=je),O=n(e),$(g.$$.fragment,e),ee=n(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-10sf4ix"&&(b.textContent=Ue),te=n(e),r=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(r).forEach(t),le=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-ojipak"&&(C.textContent=Te),ae=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1uiun01"&&(v.innerHTML=ge),se=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1oyez0p"&&(I.textContent=be),ne=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-7essz6"&&(A.textContent=Ce),oe=n(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-9wesld"&&(W.innerHTML=ve),ie=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1v4hd0t"&&(_.textContent=Ie),re=n(e),B=i(e,"P",{}),x(B).forEach(t),this.h()},h(){u(c,"name","hf:doc:metadata"),u(c,"content",JSON.stringify(He)),u(d,"id","build-a-demo-with-gradio"),u(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(d,"href","#build-a-demo-with-gradio"),u(h,"class","relative group"),ke(r.src,Je="https://course-demos-whisper-small.hf.space")||u(r,"src",Je),u(r,"frameborder","0"),u(r,"height","450"),u(r,"title","Gradio app"),u(r,"class","container p-0 flex-grow space-iframe"),u(r,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(r,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,l){S(document.head,c),a(e,V,l),a(e,G,l),a(e,N,l),a(e,h,l),S(h,d),S(d,Z),H(M,Z,null),S(h,he),S(h,k),a(e,q,l),a(e,m,l),a(e,X,l),a(e,y,l),a(e,z,l),H(w,e,l),a(e,F,l),a(e,f,l),a(e,P,l),H(j,e,l),a(e,L,l),a(e,U,l),a(e,K,l),H(J,e,l),a(e,D,l),a(e,T,l),a(e,O,l),H(g,e,l),a(e,ee,l),a(e,b,l),a(e,te,l),a(e,r,l),a(e,le,l),a(e,C,l),a(e,ae,l),a(e,v,l),a(e,se,l),a(e,I,l),a(e,ne,l),a(e,A,l),a(e,oe,l),a(e,W,l),a(e,ie,l),a(e,_,l),a(e,re,l),a(e,B,l),pe=!0},p:xe,i(e){pe||(Y(M.$$.fragment,e),Y(w.$$.fragment,e),Y(j.$$.fragment,e),Y(J.$$.fragment,e),Y(g.$$.fragment,e),pe=!0)},o(e){Q(M.$$.fragment,e),Q(w.$$.fragment,e),Q(j.$$.fragment,e),Q(J.$$.fragment,e),Q(g.$$.fragment,e),pe=!1},d(e){e&&(t(V),t(G),t(N),t(h),t(q),t(m),t(X),t(y),t(z),t(F),t(f),t(P),t(L),t(U),t(K),t(D),t(T),t(O),t(ee),t(b),t(te),t(r),t(le),t(C),t(ae),t(v),t(se),t(I),t(ne),t(A),t(oe),t(W),t(ie),t(_),t(re),t(B)),t(c),R(M),R(w,e),R(j,e),R(J,e),R(g,e)}}}const He={local:"build-a-demo-with-gradio",title:"Build a demo with Gradio"};function Ye(de){return Ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qe extends Ze{constructor(c){super(),Be(this,c,Ye,Se,_e,{})}}export{qe as component};
