import{s as io,o as oo}from"../chunks/scheduler.f7e1785c.js";import{S as ro,i as po,g as i,s as n,u as c,A as ho,h as o,f as t,c as a,j as w,v as d,y as r,k as p,o as h,a as s,w as u,d as M,t as m,x as y,m as no,n as ao}from"../chunks/index.815a732f.js";import{T as so}from"../chunks/Tip.1258ac78.js";import{I as g}from"../chunks/IconCopyLink.e7937f56.js";import{C as f}from"../chunks/CodeBlock.c6e8b464.js";function co(Ot){let J;return{c(){J=no('You can change the language identifier from `"dv"` to a language identifier of your choice. To see all possible languages\n    in Common Voice 13, check out the dataset card on the Hugging Face Hub: https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},l(T){J=ao(T,'You can change the language identifier from `"dv"` to a language identifier of your choice. To see all possible languages\n    in Common Voice 13, check out the dataset card on the Hugging Face Hub: https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},m(T,b){s(T,J,b)},d(T){T&&t(J)}}}function uo(Ot){let J;return{c(){J=no("If you do not want to upload the model checkpoints to the Hub, set `push_to_hub=False`.")},l(T){J=ao(T,"If you do not want to upload the model checkpoints to the Hub, set `push_to_hub=False`.")},m(T,b){s(T,J,b)},d(T){T&&t(J)}}}function Mo(Ot){let J,T,b,_l,j,X,ul,D,Sn,el,aa="Fine-tuning the ASR model",kl,K,ia=`In this section, we’ll cover a step-by-step guide on fine-tuning Whisper for speech recognition on the Common Voice 13
dataset. We’ll use the ‘small’ version of the model and a relatively lightweight dataset, enabling you to run fine-tuning
fairly quickly on any 16GB+ GPU with low disk space requirements, such as the 16GB T4 GPU provided in the Google Colab free
tier.`,xl,O,oa=`Should you have a smaller GPU or encounter memory issues during training, you can follow the suggestions provided for
reducing memory usage. Conversely, should you have access to a larger GPU, you can amend the training arguments to maximise
your throughput. Thus, this guide is accessible regardless of your GPU specifications!`,Wl,ee,ra=`Likewise, this guide outlines how to fine-tune the Whisper model for the Dhivehi language. However, the steps covered here
generalise to any language in the Common Voice dataset, and more generally to any ASR dataset on the Hugging Face Hub.
You can tweak the code to quickly switch to a language of your choice and fine-tune a Whisper model in your native tongue 🌍`,$l,te,pa="Right! Now that’s out the way, let’s get started and kick-off our fine-tuning pipeline!",Gl,U,A,Ml,le,Qn,tl,ha="Prepare Environment",Zl,se,ca=`We strongly advise you to upload model checkpoints directly the <a href="https://huggingface.co/" rel="nofollow">Hugging Face Hub</a> while training.
The Hub provides:`,Bl,ne,da="<li>Integrated version control: you can be sure that no model checkpoint is lost during training.</li> <li>Tensorboard logs: track important metrics over the course of training.</li> <li>Model cards: document what a model does and its intended use cases.</li> <li>Community: an easy way to share and collaborate with the community! 🤗</li>",Xl,ae,ua=`Linking the notebook to the Hub is straightforward - it simply requires entering your Hub authentication token when prompted.
Find your Hub authentication token <a href="https://huggingface.co/settings/tokens" rel="nofollow">here</a> and enter it when prompted:`,Al,ie,Nl,oe,Ma="<strong>Output:</strong>",El,re,Hl,v,N,ml,pe,qn,ll,ma="Load Dataset",Vl,he,ya=`<a href="https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0" rel="nofollow">Common Voice 13</a> contains approximately ten
hours of labelled Dhivehi data, three of which is held-out test data. This is extremely little data for fine-tuning, so
we’ll be relying on leveraging the extensive multilingual ASR knowledge acquired by Whisper during pre-training for the
low-resource Dhivehi language.`,Rl,ce,wa=`Using 🤗 Datasets, downloading and preparing data is extremely simple. We can download and prepare the Common Voice 13
splits in just one line of code. Since Dhivehi is very low-resource, we’ll combine the <code>train</code> and <code>validation</code> splits
to give approximately seven hours of training data. We’ll use the three hours of <code>test</code> data as our held-out test set:`,Yl,de,zl,ue,fa="<strong>Output:</strong>",Fl,Me,Sl,E,Ql,me,Ja=`Most ASR datasets only provide input audio samples (<code>audio</code>) and the corresponding transcribed text (<code>sentence</code>).
Common Voice contains additional metadata information, such as <code>accent</code> and <code>locale</code>, which we can disregard for ASR.
Keeping the notebook as general as possible, we only consider the input audio and transcribed text for fine-tuning,
discarding the additional metadata information:`,ql,ye,Ll,C,H,yl,we,Ln,sl,Ta="Feature Extractor, Tokenizer and Processor",Pl,fe,ga="The ASR pipeline can be de-composed into three stages:",Dl,Je,ba="<li>The feature extractor which pre-processes the raw audio-inputs to log-mel spectrograms</li> <li>The model which performs the sequence-to-sequence mapping</li> <li>The tokenizer which post-processes the predicted tokens to text</li>",Kl,Te,ja=`In 🤗 Transformers, the Whisper model has an associated feature extractor and tokenizer, called <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperFeatureExtractor" rel="nofollow">WhisperFeatureExtractor</a> and <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperTokenizer" rel="nofollow">WhisperTokenizer</a>
respectively. To make our lives simple, these two objects are wrapped under a single class, called the <a href="https://huggingface.co/docs/transformers/model_doc/whisper#transformers.WhisperProcessor" rel="nofollow">WhisperProcessor</a>.
We can call the WhisperProcessor to perform both the audio pre-processing and the text token post-processing. In doing
so, we only need to keep track of two objects during training: the processor and the model.`,Ol,ge,Ua=`When performing multilingual fine-tuning, we need to set the <code>&quot;language&quot;</code> and <code>&quot;task&quot;</code> when instantiating the processor.
The <code>&quot;language&quot;</code> should be set to the source audio language, and the task to <code>&quot;transcribe&quot;</code> for speech recognition or
<code>&quot;translate&quot;</code> for speech translation. These arguments modify the behaviour of the tokenizer, and should be set correctly
to ensure the target labels are encoded properly.`,es,be,va="We can see all possible languages supported by Whisper by importing the list of languages:",ts,je,ls,Ue,Ca=`If you scroll through this list, you’ll notice that many languages are present, but Dhivehi is one of few that is not!
This means that Whisper was not pre-trained on Dhivehi. However, this doesn’t mean that we can’t fine tune Whisper on it.
In doing so, we’ll be teaching Whisper a new language, one that the pre-trained checkpoint does not support. That’s pretty
cool, right!`,ss,ve,Ia=`When you fine-tune it on a new language, Whisper does a good job at leveraging its knowledge of the other 96 languages
it’s pre-trained on. Largely speaking, all modern languages will be linguistically similar to at least one of the
96 languages Whisper already knows, so we’ll fall under this paradigm of cross-lingual knowledge representation.`,ns,Ce,_a=`What we need to do to fine-tune Whisper on a new language is find the language <strong>most similar</strong> that Whisper was
pre-trained on. The Wikipedia article for Dhivehi states that Dhivehi is closely related to the Sinhalese language of Sri Lanka.
If we check the language codes again, we can see that Sinhalese is present in the Whisper language set,
so we can safely set our language argument to <code>&quot;sinhalese&quot;</code>.`,as,Ie,ka=`Right! We’ll load our processor from the pre-trained checkpoint, setting the language to <code>&quot;sinhalese&quot;</code> and task to <code>&quot;transcribe&quot;</code>
as explained above:`,is,_e,os,ke,xa=`It’s worth reiterating that in most circumstances, you’ll find that the language you want to fine-tune on is in the set of
pre-training languages, in which case you can simply set the language directly as your source audio language! Note that
both of these arguments should be omitted for English-only fine-tuning, where there is only one option for the language
(<code>&quot;English&quot;</code>) and task (<code>&quot;transcribe&quot;</code>).`,rs,I,V,wl,xe,Pn,nl,Wa="Pre-Process the Data",ps,We,$a=`Let’s have a look at the dataset features. Pay particular attention to the <code>&quot;audio&quot;</code> column - this details the sampling
rate of our audio inputs:`,hs,$e,cs,Ge,Ga="<strong>Output:</strong>",ds,Ze,us,Be,Za=`Since our input audio is sampled at 48kHz, we need to <em>downsample</em> it to 16kHz prior to passing it to the Whisper feature
extractor, 16kHz being the sampling rate expected by the Whisper model.`,Ms,Xe,Ba=`We’ll set the audio inputs to the correct sampling rate using dataset’s <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.cast_column" rel="nofollow"><code>cast_column</code></a>
method. This operation does not change the audio in-place, but rather signals to datasets to resample audio samples
on-the-fly when they are loaded:`,ms,Ae,ys,Ne,Xa="Now we can write a function to prepare our data ready for the model:",ws,Ee,Aa="<li>We load and resample the audio data on a sample-by-sample basis by calling <code>sample[&quot;audio&quot;]</code>. As explained above, 🤗 Datasets performs any necessary resampling operations on the fly.</li> <li>We use the feature extractor to compute the log-mel spectrogram input features from our 1-dimensional audio array.</li> <li>We encode the transcriptions to label ids through the use of the tokenizer.</li>",fs,He,Js,Ve,Na=`We can apply the data preparation function to all of our training examples using 🤗 Datasets’ <code>.map</code> method. We’ll
remove the columns from the raw training data (the audio and text), leaving just the columns returned by the
<code>prepare_dataset</code> function:`,Ts,Re,gs,Ye,Ea=`Finally, we filter any training data with audio samples longer than 30s. These samples would otherwise be truncated by
the Whisper feature-extractor which could affect the stability of training. We define a function that returns <code>True</code> for
samples that are less than 30s, and <code>False</code> for those that are longer:`,bs,ze,js,Fe,Ha="We apply our filter function to all samples of our training dataset through 🤗 Datasets’ <code>.filter</code> method:",Us,Se,vs,Qe,Va="Let’s check how much training data we removed through this filtering step:",Cs,qe,Is,Le,Ra="<strong>Output</strong>",_s,Pe,ks,De,Ya=`Alright! In this case we actually have the same number of samples as before, so there were no samples longer than 30s.
This might not be the case if you switch languages, so it’s best to keep this filter step in-place for robustness. With
that, we have our data fully prepared for training! Let’s continue and take a look at how we can use this data to fine-tune
Whisper.`,xs,_,R,fl,Ke,Dn,al,za="Training and Evaluation",Ws,Oe,Fa=`Now that we’ve prepared our data, we’re ready to dive into the training pipeline.
The <a href="https://huggingface.co/transformers/master/main_classes/trainer.html?highlight=trainer" rel="nofollow">🤗 Trainer</a>
will do much of the heavy lifting for us. All we have to do is:`,$s,et,Sa="<li><p>Define a data collator: the data collator takes our pre-processed data and prepares PyTorch tensors ready for the model.</p></li> <li><p>Evaluation metrics: during evaluation, we want to evaluate the model using the word error rate (WER) metric. We need to define a <code>compute_metrics</code> function that handles this computation.</p></li> <li><p>Load a pre-trained checkpoint: we need to load a pre-trained checkpoint and configure it correctly for training.</p></li> <li><p>Define the training arguments: these will be used by the 🤗 Trainer in constructing the training schedule.</p></li>",Gs,tt,Qa=`Once we’ve fine-tuned the model, we will evaluate it on the test data to verify that we have correctly trained it
to transcribe speech in Dhivehi.`,Zs,k,Y,Jl,lt,Kn,il,qa="Define a Data Collator",Bs,st,La=`The data collator for a sequence-to-sequence speech model is unique in the sense that it treats the <code>input_features</code>
and <code>labels</code> independently: the  <code>input_features</code> must be handled by the feature extractor and the <code>labels</code> by the tokenizer.`,Xs,nt,Pa=`The <code>input_features</code> are already padded to 30s and converted to a log-Mel spectrogram of fixed dimension, so all we
have to do is convert them to batched PyTorch tensors. We do this using the feature extractor’s <code>.pad</code> method with
<code>return_tensors=pt</code>. Note that no additional padding is applied here since the inputs are of fixed dimension, the
<code>input_features</code> are simply converted to PyTorch tensors.`,As,at,Da=`On the other hand, the <code>labels</code> are un-padded. We first pad the sequences to the maximum length in the batch using
the tokenizer’s <code>.pad</code> method. The padding tokens are then replaced by <code>-100</code> so that these tokens are <strong>not</strong> taken
into account when computing the loss. We then cut the start of transcript token from the beginning of the label sequence
as we append it later during training.`,Ns,it,Ka="We can leverage the <code>WhisperProcessor</code> we defined earlier to perform both the feature extractor and the tokenizer operations:",Es,ot,Hs,rt,Oa="We can now initialise the data collator we’ve just defined:",Vs,pt,Rs,ht,ei="Onwards!",Ys,x,z,Tl,ct,On,ol,ti="Evaluation Metrics",zs,dt,li=`Next, we define the evaluation metric we’ll use on our evaluation set. We’ll use the Word Error Rate (WER) metric introduced
in the section on <a href="evaluation">Evaluation</a>, the ‘de-facto’ metric for assessing ASR systems.`,Fs,ut,si="We’ll load the WER metric from 🤗 Evaluate:",Ss,Mt,Qs,mt,ni=`We then simply have to define a function that takes our model predictions and returns the WER metric. This function, called
<code>compute_metrics</code>, first replaces <code>-100</code> with the <code>pad_token_id</code> in the <code>label_ids</code> (undoing the step we applied in the
data collator to ignore padded tokens correctly in the loss). It then decodes the predicted and label ids to strings. Finally,
it computes the WER between the predictions and reference labels. Here, we have the option of evaluating with the ‘normalised’
transcriptions and predictions, which have punctuation and casing removed. We recommend you follow this to benefit
from the WER improvement obtained by normalising the transcriptions.`,qs,yt,Ls,W,F,gl,wt,ea,rl,ai="Load a Pre-Trained Checkpoint",Ps,ft,ii="Now let’s load the pre-trained Whisper small checkpoint. Again, this is trivial through use of 🤗 Transformers!",Ds,Jt,Ks,Tt,oi=`We’ll set <code>use_cache</code> to <code>False</code> for training since we’re using <a href="https://huggingface.co/docs/transformers/v4.18.0/en/performance#gradient-checkpointing" rel="nofollow">gradient checkpointing</a>
and the two are incompatible. We’ll also override two generation arguments to control the behaviour of the model during inference:
we’ll force the language and task tokens during generation by setting the <code>language</code> and <code>task</code> arguments, and also re-enable
cache for generation to speed-up inference time:`,Os,gt,en,$,S,bl,bt,ta,pl,ri="Define the Training Configuration",tn,jt,pi=`In the final step, we define all the parameters related to training. Here, we set the number of training steps to 500.
This is enough steps to see a big WER improvement compared to the pre-trained Whisper model, while ensuring that fine-tuning can
be run in approximately 45 minutes on a Google Colab free tier. For more detail on the training arguments, refer to the
Seq2SeqTrainingArguments <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments" rel="nofollow">docs</a>.`,ln,Ut,sn,Q,nn,vt,hi="We can forward the training arguments to the 🤗 Trainer along with our model, dataset, data collator and <code>compute_metrics</code> function:",an,Ct,on,It,ci="And with that, we’re ready to start training!",rn,G,q,jl,_t,la,hl,di="Training",pn,kt,ui="To launch training, simply execute:",hn,xt,cn,Wt,Mi=`Training will take approximately 45 minutes depending on your GPU or the one allocated to the Google Colab. Depending on
your GPU, it is possible that you will encounter a CUDA <code>&quot;out-of-memory&quot;</code> error when you start training. In this case,
you can reduce the <code>per_device_train_batch_size</code> incrementally by factors of 2 and employ <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments.gradient_accumulation_steps" rel="nofollow"><code>gradient_accumulation_steps</code></a>
to compensate.`,dn,$t,mi="<strong>Output:</strong>",un,Gt,yi='<thead><tr><th align="center">Training Loss</th> <th align="center">Epoch</th> <th align="center">Step</th> <th align="center">Validation Loss</th> <th align="center">Wer Ortho</th> <th align="center">Wer</th></tr></thead> <tbody><tr><td align="center">0.136</td> <td align="center">1.63</td> <td align="center">500</td> <td align="center">0.1727</td> <td align="center">63.8972</td> <td align="center">14.0661</td></tr></tbody>',Mn,Zt,wi=`Our final WER is 14.1% - not bad for seven hours of training data and just 500 training steps! That amounts to a 112%
improvement versus the pre-trained model! That means we’ve taken a model that previously had no knowledge about Dhivehi,
and fine-tuned it to recognise Dhivehi speech with adequate accuracy in under one hour 🤯`,mn,Bt,fi=`The big question is how this compares to other ASR systems. For that, we can view the autoevaluate <a href="https://huggingface.co/spaces/autoevaluate/leaderboards?dataset=mozilla-foundation%2Fcommon_voice_13_0&amp;only_verified=0&amp;task=automatic-speech-recognition&amp;config=dv&amp;split=test&amp;metric=wer" rel="nofollow">leaderboard</a>,
a leaderboard that categorises models by language and dataset, and subsequently ranks them according to their WER.`,yn,Xt,Ji=`Looking at the leaderboard, we see that our model trained for 500 steps convincingly beats the pre-trained <a href="https://huggingface.co/openai/whisper-small" rel="nofollow">Whisper Small</a>
checkpoint that we evaluated in the previous section. Nice job 👏`,wn,At,Ti=`We see that there are a few checkpoints that do better than the one we trained. The beauty of the Hugging Face Hub is that
it’s a <em>collaborative</em> platform - if we don’t have the time or resources to perform a longer training run ourselves, we
can load a checkpoint that someone else in the community has trained and been kind enough to share (making sure to thank them for it!).
You’ll be able to load these checkpoints in exactly the same way as the pre-trained ones using the <code>pipeline</code> class as we
did previously! So there’s nothing stopping you cherry-picking the best model on the leaderboard to use for your task!`,fn,Nt,gi=`We can automatically submit our checkpoint to the leaderboard when we push the training results to the Hub - we simply
have to set the appropriate key-word arguments (kwargs). You can change these values to match your dataset, language and
model name accordingly:`,Jn,Et,Tn,Ht,bi="The training results can now be uploaded to the Hub. To do so, execute the <code>push_to_hub</code> command:",gn,Vt,bn,Rt,ji=`This will save the training logs and model weights under <code>&quot;your-username/the-name-you-picked&quot;</code>. For this example, check
out the upload at <code>sanchit-gandhi/whisper-small-dv</code>.`,jn,Yt,Ui=`While the fine-tuned model yields satisfactory results on the Common Voice 13 Dhivehi test data, it is by no means optimal.
The purpose of this guide is to demonstrate how to fine-tune an ASR model using the 🤗 Trainer for multilingual speech
recognition.`,Un,zt,vi=`If you have access to your own GPU or are subscribed to a Google Colab paid plan, you can increase <code>max_steps</code> to 4000 steps
to improve the WER further by training for more steps. Training for 4000 steps will take approximately 3-5 hours depending
on your GPU and yield WER results approximately 3% lower than training for 500 steps. If you decide to train for 4000 steps,
we also recommend changing the learning rate scheduler to a <em>linear</em> schedule (set <code>lr_scheduler_type=&quot;linear&quot;</code>), as this will
yield an additional performance boost over long training runs.`,vn,Ft,Ci=`The results could likely be improved further by optimising the training hyperparameters, such as <em>learning rate</em> and
<em>dropout</em>, and using a larger pre-trained checkpoint (<code>medium</code> or <code>large</code>). We leave this as an exercise to the reader.`,Cn,Z,L,Ul,St,sa,cl,Ii="Sharing Your Model",In,Qt,_i=`You can now share this model with anyone using the link on the Hub. They can load it with the identifier <code>&quot;your-username/the-name-you-picked&quot;</code>
directly into the <code>pipeline()</code> object. For instance, to load the fine-tuned checkpoint <a href="https://huggingface.co/sanchit-gandhi/whisper-small-dv" rel="nofollow">“sanchit-gandhi/whisper-small-dv”</a>:`,_n,qt,kn,B,P,vl,Lt,na,dl,ki="Conclusion",xn,Pt,xi=`In this section, we covered a step-by-step guide on fine-tuning the Whisper model for speech recognition 🤗 Datasets,
Transformers and the Hugging Face Hub. We first loaded the Dhivehi subset of the Common Voice 13 dataset and pre-processed
it by computing log-mel spectrograms and tokenising the text. We then defined a data collator, evaluation metric and
training arguments, before using the 🤗 Trainer to train and evaluate our model. We finished by uploading the fine-tuned
model to the Hugging Face Hub, and showcased how to share and use it with the <code>pipeline()</code> class.`,Wn,Dt,Wi=`If you followed through to this point, you should now have a fine-tuned checkpoint for speech recognition, well done! 🥳
Even more importantly, you’re equipped with all the tools you need to fine-tune the Whisper model on any speech recognition
dataset or domain. So what are you waiting for! Pick one of the datasets covered in the section <a href="choosing_dataset">Choosing a Dataset</a>
or select a dataset of your own, and see whether you can get state-of-the-art performance! The leaderboard is waiting for you…`,$n,Cl,Gn;return D=new g({}),le=new g({}),ie=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),re=new f({props:{code:"TG9naW4lMjBzdWNjZXNzZnVsJTBBWW91ciUyMHRva2VuJTIwaGFzJTIwYmVlbiUyMHNhdmVkJTIwdG8lMjAlMkZyb290JTJGLmh1Z2dpbmdmYWNlJTJGdG9rZW4=",highlighted:`Login successful
Your token has been saved to /root/.huggingface/token`}}),pe=new g({}),de=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwRGF0YXNldERpY3QlMEElMEFjb21tb25fdm9pY2UlMjAlM0QlMjBEYXRhc2V0RGljdCgpJTBBJTBBY29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ2YWxpZGF0aW9uJTIyJTBBKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMiUwQSklMEElMEFwcmludChjb21tb25fdm9pY2Up",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, DatasetDict

common_voice = DatasetDict()

common_voice[<span class="hljs-string">&quot;train&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;train+validation&quot;</span>
)
common_voice[<span class="hljs-string">&quot;test&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>
)

<span class="hljs-built_in">print</span>(common_voice)`}}),Me=new f({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2NsaWVudF9pZCclMkMlMjAncGF0aCclMkMlMjAnYXVkaW8nJTJDJTIwJ3NlbnRlbmNlJyUyQyUyMCd1cF92b3RlcyclMkMlMjAnZG93bl92b3RlcyclMkMlMjAnYWdlJyUyQyUyMCdnZW5kZXInJTJDJTIwJ2FjY2VudCclMkMlMjAnbG9jYWxlJyUyQyUyMCdzZWdtZW50JyUyQyUyMCd2YXJpYW50JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNDkwNCUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidjbGllbnRfaWQnJTJDJTIwJ3BhdGgnJTJDJTIwJ2F1ZGlvJyUyQyUyMCdzZW50ZW5jZSclMkMlMjAndXBfdm90ZXMnJTJDJTIwJ2Rvd25fdm90ZXMnJTJDJTIwJ2FnZSclMkMlMjAnZ2VuZGVyJyUyQyUyMCdhY2NlbnQnJTJDJTIwJ2xvY2FsZSclMkMlMjAnc2VnbWVudCclMkMlMjAndmFyaWFudCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDIyMTIlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTdEKQ==",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">4904</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">2212</span>
    })
})`}}),E=new so({props:{$$slots:{default:[co]},$$scope:{ctx:Ot}}}),ye=new f({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLnNlbGVjdF9jb2x1bW5zKCU1QiUyMmF1ZGlvJTIyJTJDJTIwJTIyc2VudGVuY2UlMjIlNUQp",highlighted:'common_voice = common_voice.select_columns([<span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;sentence&quot;</span>])'}}),we=new g({}),je=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMud2hpc3Blci50b2tlbml6YXRpb25fd2hpc3BlciUyMGltcG9ydCUyMFRPX0xBTkdVQUdFX0NPREUlMEElMEFUT19MQU5HVUFHRV9DT0RF",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.tokenization_whisper <span class="hljs-keyword">import</span> TO_LANGUAGE_CODE

TO_LANGUAGE_CODE`}}),_e=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBXaGlzcGVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTIwbGFuZ3VhZ2UlM0QlMjJzaW5oYWxlc2UlMjIlMkMlMjB0YXNrJTNEJTIydHJhbnNjcmliZSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperProcessor

processor = WhisperProcessor.from_pretrained(
    <span class="hljs-string">&quot;openai/whisper-small&quot;</span>, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>
)`}}),xe=new g({}),$e=new f({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQuZmVhdHVyZXM=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>].features'}}),Ze=new f({props:{code:"JTdCJ2F1ZGlvJyUzQSUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0Q0ODAwMCUyQyUyMG1vbm8lM0RUcnVlJTJDJTIwZGVjb2RlJTNEVHJ1ZSUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnc2VudGVuY2UnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklN0Q=",highlighted:`{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(<span class="hljs-attribute">sampling_rate</span>=48000, <span class="hljs-attribute">mono</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">decode</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">id</span>=None),
 <span class="hljs-string">&#x27;sentence&#x27;</span>: Value(<span class="hljs-attribute">dtype</span>=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-attribute">id</span>=None)}`}}),Ae=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMEFjb21tb25fdm9pY2UlMjAlM0QlMjBjb21tb25fdm9pY2UuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

sampling_rate = processor.feature_extractor.sampling_rate
common_voice = common_voice.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=sampling_rate))`}}),He=new f({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTNEZXhhbXBsZSU1QiUyMnNlbnRlbmNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBpbnB1dCUyMGxlbmd0aCUyMG9mJTIwYXVkaW8lMjBzYW1wbGUlMjBpbiUyMHNlY29uZHMlMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW5wdXRfbGVuZ3RoJTIyJTVEJTIwJTNEJTIwbGVuKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTIwYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        audio=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        text=example[<span class="hljs-string">&quot;sentence&quot;</span>],
    )

    <span class="hljs-comment"># compute input length of audio sample in seconds</span>
    example[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(audio[<span class="hljs-string">&quot;array&quot;</span>]) / audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>]

    <span class="hljs-keyword">return</span> example`}}),Re=new f({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLm1hcCglMEElMjAlMjAlMjAlMjBwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRGNvbW1vbl92b2ljZS5jb2x1bW5fbmFtZXMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMG51bV9wcm9jJTNEMSUwQSk=",highlighted:`common_voice = common_voice.<span class="hljs-built_in">map</span>(
    prepare_dataset, remove_columns=common_voice.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">1</span>
)`}}),ze=new f({props:{code:"bWF4X2lucHV0X2xlbmd0aCUyMCUzRCUyMDMwLjAlMEElMEElMEFkZWYlMjBpc19hdWRpb19pbl9sZW5ndGhfcmFuZ2UobGVuZ3RoKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxlbmd0aCUyMCUzQyUyMG1heF9pbnB1dF9sZW5ndGg=",highlighted:`max_input_length = <span class="hljs-number">30.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_in_length_range</span>(<span class="hljs-params">length</span>):
    <span class="hljs-keyword">return</span> length &lt; max_input_length`}}),Se=new f({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RC5maWx0ZXIoJTBBJTIwJTIwJTIwJTIwaXNfYXVkaW9faW5fbGVuZ3RoX3JhbmdlJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmlucHV0X2xlbmd0aCUyMiU1RCUyQyUwQSk=",highlighted:`common_voice[<span class="hljs-string">&quot;train&quot;</span>] = common_voice[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">filter</span>(
    is_audio_in_length_range,
    input_columns=[<span class="hljs-string">&quot;input_length&quot;</span>],
)`}}),qe=new f({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>]'}}),Pe=new f({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidpbnB1dF9mZWF0dXJlcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdpbnB1dF9sZW5ndGgnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA0OTA0JTBBJTdEKQ==",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;input_features&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;input_length&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">4904</span>
})`}}),Ke=new g({}),lt=new g({}),ot=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorSpeechSeq2SeqWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-comment"># split inputs and labels since they have to be of different lengths and need different padding methods</span>
        <span class="hljs-comment"># first treat the audio inputs by simply returning torch tensors</span>
        input_features = [
            {<span class="hljs-string">&quot;input_features&quot;</span>: feature[<span class="hljs-string">&quot;input_features&quot;</span>][<span class="hljs-number">0</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features
        ]
        batch = self.processor.feature_extractor.pad(input_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># get the tokenized label sequences</span>
        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        <span class="hljs-comment"># pad the labels to max length</span>
        labels_batch = self.processor.tokenizer.pad(label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(
            labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># if bos token is appended in previous tokenization step,</span>
        <span class="hljs-comment"># cut bos token here as it&#x27;s append later anyways</span>
        <span class="hljs-keyword">if</span> (labels[:, <span class="hljs-number">0</span>] == self.processor.tokenizer.bos_token_id).<span class="hljs-built_in">all</span>().cpu().item():
            labels = labels[:, <span class="hljs-number">1</span>:]

        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

        <span class="hljs-keyword">return</span> batch`}}),pt=new f({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvclNwZWVjaFNlcTJTZXFXaXRoUGFkZGluZyhwcm9jZXNzb3IlM0Rwcm9jZXNzb3Ip",highlighted:"data_collator = DataCollatorSpeechSeq2SeqWithPadding(processor=processor)"}}),ct=new g({}),Mt=new f({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`}}),yt=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.english_normalizer <span class="hljs-keyword">import</span> BasicTextNormalizer

normalizer = BasicTextNormalizer()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">pred</span>):
    pred_ids = pred.predictions
    label_ids = pred.label_ids

    <span class="hljs-comment"># replace -100 with the pad_token_id</span>
    label_ids[label_ids == -<span class="hljs-number">100</span>] = processor.tokenizer.pad_token_id

    <span class="hljs-comment"># we do not want to group tokens when computing the metrics</span>
    pred_str = processor.batch_decode(pred_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
    label_str = processor.batch_decode(label_ids, skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># compute orthographic wer</span>
    wer_ortho = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str, references=label_str)

    <span class="hljs-comment"># compute normalised WER</span>
    pred_str_norm = [normalizer(pred) <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> pred_str]
    label_str_norm = [normalizer(label) <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> label_str]
    <span class="hljs-comment"># filtering step to only evaluate the samples that correspond to non-zero references:</span>
    pred_str_norm = [
        pred_str_norm[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(pred_str_norm)) <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]
    label_str_norm = [
        label_str_norm[i]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(label_str_norm))
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]

    wer = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str_norm, references=label_str_norm)

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer_ortho&quot;</span>: wer_ortho, <span class="hljs-string">&quot;wer&quot;</span>: wer}`}}),wt=new g({}),Jt=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperForConditionalGeneration

model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`}}),gt=new f({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkaXNhYmxlJTIwY2FjaGUlMjBkdXJpbmclMjB0cmFpbmluZyUyMHNpbmNlJTIwaXQncyUyMGluY29tcGF0aWJsZSUyMHdpdGglMjBncmFkaWVudCUyMGNoZWNrcG9pbnRpbmclMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBzZXQlMjBsYW5ndWFnZSUyMGFuZCUyMHRhc2slMjBmb3IlMjBnZW5lcmF0aW9uJTIwYW5kJTIwcmUtZW5hYmxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwoJTBBJTIwJTIwJTIwJTIwbW9kZWwuZ2VuZXJhdGUlMkMlMjBsYW5ndWFnZSUzRCUyMnNpbmhhbGVzZSUyMiUyQyUyMHRhc2slM0QlMjJ0cmFuc2NyaWJlJTIyJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># disable cache during training since it&#x27;s incompatible with gradient checkpointing</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># set language and task for generation and re-enable cache</span>
model.generate = partial(
    model.generate, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>, use_cache=<span class="hljs-literal">True</span>
)`}}),bt=new g({}),Ut=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMi4lMkZ3aGlzcGVyLXNtYWxsLWR2JTIyJTJDJTIwJTIwJTIzJTIwbmFtZSUyMG9uJTIwdGhlJTIwSEYlMjBIdWIlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDElMkMlMjAlMjAlMjMlMjBpbmNyZWFzZSUyMGJ5JTIwMnglMjBmb3IlMjBldmVyeSUyMDJ4JTIwZGVjcmVhc2UlMjBpbiUyMGJhdGNoJTIwc2l6ZSUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyX3R5cGUlM0QlMjJjb25zdGFudF93aXRoX3dhcm11cCUyMiUyQyUwQSUyMCUyMCUyMCUyMHdhcm11cF9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENTAwJTJDJTIwJTIwJTIzJTIwaW5jcmVhc2UlMjB0byUyMDQwMDAlMjBpZiUyMHlvdSUyMGhhdmUlMjB5b3VyJTIwb3duJTIwR1BVJTIwb3IlMjBhJTIwQ29sYWIlMjBwYWlkJTIwcGxhbiUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2X2Z1bGxfZXZhbCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwcHJlZGljdF93aXRoX2dlbmVyYXRlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRpb25fbWF4X2xlbmd0aCUzRDIyNSUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0ZXBzJTNENTAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTVCJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpY19mb3JfYmVzdF9tb2RlbCUzRCUyMndlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;./whisper-small-dv&quot;</span>,  <span class="hljs-comment"># name on the HF Hub</span>
    per_device_train_batch_size=<span class="hljs-number">16</span>,
    gradient_accumulation_steps=<span class="hljs-number">1</span>,  <span class="hljs-comment"># increase by 2x for every 2x decrease in batch size</span>
    learning_rate=<span class="hljs-number">1e-5</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;constant_with_warmup&quot;</span>,
    warmup_steps=<span class="hljs-number">50</span>,
    max_steps=<span class="hljs-number">500</span>,  <span class="hljs-comment"># increase to 4000 if you have your own GPU or a Colab paid plan</span>
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    fp16_full_eval=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">16</span>,
    predict_with_generate=<span class="hljs-literal">True</span>,
    generation_max_length=<span class="hljs-number">225</span>,
    save_steps=<span class="hljs-number">500</span>,
    eval_steps=<span class="hljs-number">500</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;wer&quot;</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
)`}}),Q=new so({props:{$$slots:{default:[uo]},$$scope:{ctx:Ot}}}),Ct=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=common_voice[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=common_voice[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    compute_metrics=compute_metrics,
    tokenizer=processor,
)`}}),_t=new g({}),xt=new f({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()"}}),Et=new f({props:{code:"a3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZGF0YXNldF90YWdzJTIyJTNBJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkYXRhc2V0JTIyJTNBJTIwJTIyQ29tbW9uJTIwVm9pY2UlMjAxMyUyMiUyQyUyMCUyMCUyMyUyMGElMjAncHJldHR5JyUyMG5hbWUlMjBmb3IlMjB0aGUlMjB0cmFpbmluZyUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjAlMjJsYW5ndWFnZSUyMiUzQSUyMCUyMmR2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMldoaXNwZXIlMjBTbWFsbCUyMER2JTIwLSUyMFNhbmNoaXQlMjBHYW5kaGklMjIlMkMlMjAlMjAlMjMlMjBhJTIwJ3ByZXR0eSclMjBuYW1lJTIwZm9yJTIweW91ciUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwJTIyZmluZXR1bmVkX2Zyb20lMjIlM0ElMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFza3MlMjIlM0ElMjAlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTBBJTdE",highlighted:`kwargs = {
    <span class="hljs-string">&quot;dataset_tags&quot;</span>: <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>,
    <span class="hljs-string">&quot;dataset&quot;</span>: <span class="hljs-string">&quot;Common Voice 13&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for the training dataset</span>
    <span class="hljs-string">&quot;language&quot;</span>: <span class="hljs-string">&quot;dv&quot;</span>,
    <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;Whisper Small Dv - Sanchit Gandhi&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for your model</span>
    <span class="hljs-string">&quot;finetuned_from&quot;</span>: <span class="hljs-string">&quot;openai/whisper-small&quot;</span>,
    <span class="hljs-string">&quot;tasks&quot;</span>: <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
}`}}),Vt=new f({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1YigqKmt3YXJncyk=",highlighted:"trainer.push_to_hub(**kwargs)"}}),St=new g({}),qt=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNhbmNoaXQtZ2FuZGhpJTJGd2hpc3Blci1zbWFsbC1kdiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-small-dv&quot;</span>)`}}),Lt=new g({}),{c(){J=i("meta"),T=n(),b=i("p"),_l=n(),j=i("h1"),X=i("a"),ul=i("span"),c(D.$$.fragment),Sn=n(),el=i("span"),el.textContent=aa,kl=n(),K=i("p"),K.textContent=ia,xl=n(),O=i("p"),O.textContent=oa,Wl=n(),ee=i("p"),ee.textContent=ra,$l=n(),te=i("p"),te.textContent=pa,Gl=n(),U=i("h2"),A=i("a"),Ml=i("span"),c(le.$$.fragment),Qn=n(),tl=i("span"),tl.textContent=ha,Zl=n(),se=i("p"),se.innerHTML=ca,Bl=n(),ne=i("ul"),ne.innerHTML=da,Xl=n(),ae=i("p"),ae.innerHTML=ua,Al=n(),c(ie.$$.fragment),Nl=n(),oe=i("p"),oe.innerHTML=Ma,El=n(),c(re.$$.fragment),Hl=n(),v=i("h2"),N=i("a"),ml=i("span"),c(pe.$$.fragment),qn=n(),ll=i("span"),ll.textContent=ma,Vl=n(),he=i("p"),he.innerHTML=ya,Rl=n(),ce=i("p"),ce.innerHTML=wa,Yl=n(),c(de.$$.fragment),zl=n(),ue=i("p"),ue.innerHTML=fa,Fl=n(),c(Me.$$.fragment),Sl=n(),c(E.$$.fragment),Ql=n(),me=i("p"),me.innerHTML=Ja,ql=n(),c(ye.$$.fragment),Ll=n(),C=i("h2"),H=i("a"),yl=i("span"),c(we.$$.fragment),Ln=n(),sl=i("span"),sl.textContent=Ta,Pl=n(),fe=i("p"),fe.textContent=ga,Dl=n(),Je=i("ol"),Je.innerHTML=ba,Kl=n(),Te=i("p"),Te.innerHTML=ja,Ol=n(),ge=i("p"),ge.innerHTML=Ua,es=n(),be=i("p"),be.textContent=va,ts=n(),c(je.$$.fragment),ls=n(),Ue=i("p"),Ue.textContent=Ca,ss=n(),ve=i("p"),ve.textContent=Ia,ns=n(),Ce=i("p"),Ce.innerHTML=_a,as=n(),Ie=i("p"),Ie.innerHTML=ka,is=n(),c(_e.$$.fragment),os=n(),ke=i("p"),ke.innerHTML=xa,rs=n(),I=i("h2"),V=i("a"),wl=i("span"),c(xe.$$.fragment),Pn=n(),nl=i("span"),nl.textContent=Wa,ps=n(),We=i("p"),We.innerHTML=$a,hs=n(),c($e.$$.fragment),cs=n(),Ge=i("p"),Ge.innerHTML=Ga,ds=n(),c(Ze.$$.fragment),us=n(),Be=i("p"),Be.innerHTML=Za,Ms=n(),Xe=i("p"),Xe.innerHTML=Ba,ms=n(),c(Ae.$$.fragment),ys=n(),Ne=i("p"),Ne.textContent=Xa,ws=n(),Ee=i("ol"),Ee.innerHTML=Aa,fs=n(),c(He.$$.fragment),Js=n(),Ve=i("p"),Ve.innerHTML=Na,Ts=n(),c(Re.$$.fragment),gs=n(),Ye=i("p"),Ye.innerHTML=Ea,bs=n(),c(ze.$$.fragment),js=n(),Fe=i("p"),Fe.innerHTML=Ha,Us=n(),c(Se.$$.fragment),vs=n(),Qe=i("p"),Qe.textContent=Va,Cs=n(),c(qe.$$.fragment),Is=n(),Le=i("p"),Le.innerHTML=Ra,_s=n(),c(Pe.$$.fragment),ks=n(),De=i("p"),De.textContent=Ya,xs=n(),_=i("h2"),R=i("a"),fl=i("span"),c(Ke.$$.fragment),Dn=n(),al=i("span"),al.textContent=za,Ws=n(),Oe=i("p"),Oe.innerHTML=Fa,$s=n(),et=i("ul"),et.innerHTML=Sa,Gs=n(),tt=i("p"),tt.textContent=Qa,Zs=n(),k=i("h3"),Y=i("a"),Jl=i("span"),c(lt.$$.fragment),Kn=n(),il=i("span"),il.textContent=qa,Bs=n(),st=i("p"),st.innerHTML=La,Xs=n(),nt=i("p"),nt.innerHTML=Pa,As=n(),at=i("p"),at.innerHTML=Da,Ns=n(),it=i("p"),it.innerHTML=Ka,Es=n(),c(ot.$$.fragment),Hs=n(),rt=i("p"),rt.textContent=Oa,Vs=n(),c(pt.$$.fragment),Rs=n(),ht=i("p"),ht.textContent=ei,Ys=n(),x=i("h3"),z=i("a"),Tl=i("span"),c(ct.$$.fragment),On=n(),ol=i("span"),ol.textContent=ti,zs=n(),dt=i("p"),dt.innerHTML=li,Fs=n(),ut=i("p"),ut.textContent=si,Ss=n(),c(Mt.$$.fragment),Qs=n(),mt=i("p"),mt.innerHTML=ni,qs=n(),c(yt.$$.fragment),Ls=n(),W=i("h3"),F=i("a"),gl=i("span"),c(wt.$$.fragment),ea=n(),rl=i("span"),rl.textContent=ai,Ps=n(),ft=i("p"),ft.textContent=ii,Ds=n(),c(Jt.$$.fragment),Ks=n(),Tt=i("p"),Tt.innerHTML=oi,Os=n(),c(gt.$$.fragment),en=n(),$=i("h2"),S=i("a"),bl=i("span"),c(bt.$$.fragment),ta=n(),pl=i("span"),pl.textContent=ri,tn=n(),jt=i("p"),jt.innerHTML=pi,ln=n(),c(Ut.$$.fragment),sn=n(),c(Q.$$.fragment),nn=n(),vt=i("p"),vt.innerHTML=hi,an=n(),c(Ct.$$.fragment),on=n(),It=i("p"),It.textContent=ci,rn=n(),G=i("h3"),q=i("a"),jl=i("span"),c(_t.$$.fragment),la=n(),hl=i("span"),hl.textContent=di,pn=n(),kt=i("p"),kt.textContent=ui,hn=n(),c(xt.$$.fragment),cn=n(),Wt=i("p"),Wt.innerHTML=Mi,dn=n(),$t=i("p"),$t.innerHTML=mi,un=n(),Gt=i("table"),Gt.innerHTML=yi,Mn=n(),Zt=i("p"),Zt.textContent=wi,mn=n(),Bt=i("p"),Bt.innerHTML=fi,yn=n(),Xt=i("p"),Xt.innerHTML=Ji,wn=n(),At=i("p"),At.innerHTML=Ti,fn=n(),Nt=i("p"),Nt.textContent=gi,Jn=n(),c(Et.$$.fragment),Tn=n(),Ht=i("p"),Ht.innerHTML=bi,gn=n(),c(Vt.$$.fragment),bn=n(),Rt=i("p"),Rt.innerHTML=ji,jn=n(),Yt=i("p"),Yt.textContent=Ui,Un=n(),zt=i("p"),zt.innerHTML=vi,vn=n(),Ft=i("p"),Ft.innerHTML=Ci,Cn=n(),Z=i("h2"),L=i("a"),Ul=i("span"),c(St.$$.fragment),sa=n(),cl=i("span"),cl.textContent=Ii,In=n(),Qt=i("p"),Qt.innerHTML=_i,_n=n(),c(qt.$$.fragment),kn=n(),B=i("h2"),P=i("a"),vl=i("span"),c(Lt.$$.fragment),na=n(),dl=i("span"),dl.textContent=ki,xn=n(),Pt=i("p"),Pt.innerHTML=xi,Wn=n(),Dt=i("p"),Dt.innerHTML=Wi,$n=n(),Cl=i("p"),this.h()},l(e){const l=ho("svelte-1phssyn",document.head);J=o(l,"META",{name:!0,content:!0}),l.forEach(t),T=a(e),b=o(e,"P",{}),w(b).forEach(t),_l=a(e),j=o(e,"H1",{class:!0});var Kt=w(j);X=o(Kt,"A",{id:!0,class:!0,href:!0});var Il=w(X);ul=o(Il,"SPAN",{});var $i=w(ul);d(D.$$.fragment,$i),$i.forEach(t),Il.forEach(t),Sn=a(Kt),el=o(Kt,"SPAN",{"data-svelte-h":!0}),r(el)!=="svelte-rb2lx"&&(el.textContent=aa),Kt.forEach(t),kl=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-y7r5mv"&&(K.textContent=ia),xl=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-15djjoq"&&(O.textContent=oa),Wl=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1qs2xtc"&&(ee.textContent=ra),$l=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-vn1gx2"&&(te.textContent=pa),Gl=a(e),U=o(e,"H2",{class:!0});var Zn=w(U);A=o(Zn,"A",{id:!0,class:!0,href:!0});var Gi=w(A);Ml=o(Gi,"SPAN",{});var Zi=w(Ml);d(le.$$.fragment,Zi),Zi.forEach(t),Gi.forEach(t),Qn=a(Zn),tl=o(Zn,"SPAN",{"data-svelte-h":!0}),r(tl)!=="svelte-1v1mo2h"&&(tl.textContent=ha),Zn.forEach(t),Zl=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-lavash"&&(se.innerHTML=ca),Bl=a(e),ne=o(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-1vhmuwk"&&(ne.innerHTML=da),Xl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-dngs6s"&&(ae.innerHTML=ua),Al=a(e),d(ie.$$.fragment,e),Nl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1mvdyro"&&(oe.innerHTML=Ma),El=a(e),d(re.$$.fragment,e),Hl=a(e),v=o(e,"H2",{class:!0});var Bn=w(v);N=o(Bn,"A",{id:!0,class:!0,href:!0});var Bi=w(N);ml=o(Bi,"SPAN",{});var Xi=w(ml);d(pe.$$.fragment,Xi),Xi.forEach(t),Bi.forEach(t),qn=a(Bn),ll=o(Bn,"SPAN",{"data-svelte-h":!0}),r(ll)!=="svelte-1p1snad"&&(ll.textContent=ma),Bn.forEach(t),Vl=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-9bh3m8"&&(he.innerHTML=ya),Rl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1d296ko"&&(ce.innerHTML=wa),Yl=a(e),d(de.$$.fragment,e),zl=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1mvdyro"&&(ue.innerHTML=fa),Fl=a(e),d(Me.$$.fragment,e),Sl=a(e),d(E.$$.fragment,e),Ql=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-amnv42"&&(me.innerHTML=Ja),ql=a(e),d(ye.$$.fragment,e),Ll=a(e),C=o(e,"H2",{class:!0});var Xn=w(C);H=o(Xn,"A",{id:!0,class:!0,href:!0});var Ai=w(H);yl=o(Ai,"SPAN",{});var Ni=w(yl);d(we.$$.fragment,Ni),Ni.forEach(t),Ai.forEach(t),Ln=a(Xn),sl=o(Xn,"SPAN",{"data-svelte-h":!0}),r(sl)!=="svelte-1f52tcf"&&(sl.textContent=Ta),Xn.forEach(t),Pl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1iebir5"&&(fe.textContent=ga),Dl=a(e),Je=o(e,"OL",{"data-svelte-h":!0}),r(Je)!=="svelte-peruey"&&(Je.innerHTML=ba),Kl=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1al0blu"&&(Te.innerHTML=ja),Ol=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-zcpfiu"&&(ge.innerHTML=Ua),es=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1o6e7as"&&(be.textContent=va),ts=a(e),d(je.$$.fragment,e),ls=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-bbew1u"&&(Ue.textContent=Ca),ss=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1c5pwr8"&&(ve.textContent=Ia),ns=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-nq5sit"&&(Ce.innerHTML=_a),as=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-14p5mnr"&&(Ie.innerHTML=ka),is=a(e),d(_e.$$.fragment,e),os=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-kof0c9"&&(ke.innerHTML=xa),rs=a(e),I=o(e,"H2",{class:!0});var An=w(I);V=o(An,"A",{id:!0,class:!0,href:!0});var Ei=w(V);wl=o(Ei,"SPAN",{});var Hi=w(wl);d(xe.$$.fragment,Hi),Hi.forEach(t),Ei.forEach(t),Pn=a(An),nl=o(An,"SPAN",{"data-svelte-h":!0}),r(nl)!=="svelte-1mvwy03"&&(nl.textContent=Wa),An.forEach(t),ps=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1h5ivu3"&&(We.innerHTML=$a),hs=a(e),d($e.$$.fragment,e),cs=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1mvdyro"&&(Ge.innerHTML=Ga),ds=a(e),d(Ze.$$.fragment,e),us=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1k18r6h"&&(Be.innerHTML=Za),Ms=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-17pt1y2"&&(Xe.innerHTML=Ba),ms=a(e),d(Ae.$$.fragment,e),ys=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-93po82"&&(Ne.textContent=Xa),ws=a(e),Ee=o(e,"OL",{"data-svelte-h":!0}),r(Ee)!=="svelte-51y4cn"&&(Ee.innerHTML=Aa),fs=a(e),d(He.$$.fragment,e),Js=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-c2eyft"&&(Ve.innerHTML=Na),Ts=a(e),d(Re.$$.fragment,e),gs=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1a11l7s"&&(Ye.innerHTML=Ea),bs=a(e),d(ze.$$.fragment,e),js=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1mmculc"&&(Fe.innerHTML=Ha),Us=a(e),d(Se.$$.fragment,e),vs=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-184pc3h"&&(Qe.textContent=Va),Cs=a(e),d(qe.$$.fragment,e),Is=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ga3zr2"&&(Le.innerHTML=Ra),_s=a(e),d(Pe.$$.fragment,e),ks=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-6oin7m"&&(De.textContent=Ya),xs=a(e),_=o(e,"H2",{class:!0});var Nn=w(_);R=o(Nn,"A",{id:!0,class:!0,href:!0});var Vi=w(R);fl=o(Vi,"SPAN",{});var Ri=w(fl);d(Ke.$$.fragment,Ri),Ri.forEach(t),Vi.forEach(t),Dn=a(Nn),al=o(Nn,"SPAN",{"data-svelte-h":!0}),r(al)!=="svelte-1pju008"&&(al.textContent=za),Nn.forEach(t),Ws=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1ei1tif"&&(Oe.innerHTML=Fa),$s=a(e),et=o(e,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-1osxt83"&&(et.innerHTML=Sa),Gs=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-pvjt36"&&(tt.textContent=Qa),Zs=a(e),k=o(e,"H3",{class:!0});var En=w(k);Y=o(En,"A",{id:!0,class:!0,href:!0});var Yi=w(Y);Jl=o(Yi,"SPAN",{});var zi=w(Jl);d(lt.$$.fragment,zi),zi.forEach(t),Yi.forEach(t),Kn=a(En),il=o(En,"SPAN",{"data-svelte-h":!0}),r(il)!=="svelte-k1q0cf"&&(il.textContent=qa),En.forEach(t),Bs=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-3d3hl2"&&(st.innerHTML=La),Xs=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1r84vh4"&&(nt.innerHTML=Pa),As=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-e9pzmh"&&(at.innerHTML=Da),Ns=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-ah9f4t"&&(it.innerHTML=Ka),Es=a(e),d(ot.$$.fragment,e),Hs=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-14k5ead"&&(rt.textContent=Oa),Vs=a(e),d(pt.$$.fragment,e),Rs=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-hg8uw5"&&(ht.textContent=ei),Ys=a(e),x=o(e,"H3",{class:!0});var Hn=w(x);z=o(Hn,"A",{id:!0,class:!0,href:!0});var Fi=w(z);Tl=o(Fi,"SPAN",{});var Si=w(Tl);d(ct.$$.fragment,Si),Si.forEach(t),Fi.forEach(t),On=a(Hn),ol=o(Hn,"SPAN",{"data-svelte-h":!0}),r(ol)!=="svelte-hltjxw"&&(ol.textContent=ti),Hn.forEach(t),zs=a(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1dqtuem"&&(dt.innerHTML=li),Fs=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-16pkeis"&&(ut.textContent=si),Ss=a(e),d(Mt.$$.fragment,e),Qs=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-wtclzb"&&(mt.innerHTML=ni),qs=a(e),d(yt.$$.fragment,e),Ls=a(e),W=o(e,"H3",{class:!0});var Vn=w(W);F=o(Vn,"A",{id:!0,class:!0,href:!0});var Qi=w(F);gl=o(Qi,"SPAN",{});var qi=w(gl);d(wt.$$.fragment,qi),qi.forEach(t),Qi.forEach(t),ea=a(Vn),rl=o(Vn,"SPAN",{"data-svelte-h":!0}),r(rl)!=="svelte-nyr2u1"&&(rl.textContent=ai),Vn.forEach(t),Ps=a(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1xesvxe"&&(ft.textContent=ii),Ds=a(e),d(Jt.$$.fragment,e),Ks=a(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1fuw0bw"&&(Tt.innerHTML=oi),Os=a(e),d(gt.$$.fragment,e),en=a(e),$=o(e,"H2",{class:!0});var Rn=w($);S=o(Rn,"A",{id:!0,class:!0,href:!0});var Li=w(S);bl=o(Li,"SPAN",{});var Pi=w(bl);d(bt.$$.fragment,Pi),Pi.forEach(t),Li.forEach(t),ta=a(Rn),pl=o(Rn,"SPAN",{"data-svelte-h":!0}),r(pl)!=="svelte-5ox3n3"&&(pl.textContent=ri),Rn.forEach(t),tn=a(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1h5nxlm"&&(jt.innerHTML=pi),ln=a(e),d(Ut.$$.fragment,e),sn=a(e),d(Q.$$.fragment,e),nn=a(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1i53tjj"&&(vt.innerHTML=hi),an=a(e),d(Ct.$$.fragment,e),on=a(e),It=o(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-rljiwv"&&(It.textContent=ci),rn=a(e),G=o(e,"H3",{class:!0});var Yn=w(G);q=o(Yn,"A",{id:!0,class:!0,href:!0});var Di=w(q);jl=o(Di,"SPAN",{});var Ki=w(jl);d(_t.$$.fragment,Ki),Ki.forEach(t),Di.forEach(t),la=a(Yn),hl=o(Yn,"SPAN",{"data-svelte-h":!0}),r(hl)!=="svelte-1q1s287"&&(hl.textContent=di),Yn.forEach(t),pn=a(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1ary2hj"&&(kt.textContent=ui),hn=a(e),d(xt.$$.fragment,e),cn=a(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-k1eeda"&&(Wt.innerHTML=Mi),dn=a(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1mvdyro"&&($t.innerHTML=mi),un=a(e),Gt=o(e,"TABLE",{"data-svelte-h":!0}),r(Gt)!=="svelte-10vryw9"&&(Gt.innerHTML=yi),Mn=a(e),Zt=o(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1w06i7z"&&(Zt.textContent=wi),mn=a(e),Bt=o(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1ryvxjm"&&(Bt.innerHTML=fi),yn=a(e),Xt=o(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-yo8880"&&(Xt.innerHTML=Ji),wn=a(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-nt4ns1"&&(At.innerHTML=Ti),fn=a(e),Nt=o(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1jhde3j"&&(Nt.textContent=gi),Jn=a(e),d(Et.$$.fragment,e),Tn=a(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-14z2x03"&&(Ht.innerHTML=bi),gn=a(e),d(Vt.$$.fragment,e),bn=a(e),Rt=o(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-1m7wkzz"&&(Rt.innerHTML=ji),jn=a(e),Yt=o(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-ywnn18"&&(Yt.textContent=Ui),Un=a(e),zt=o(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-7mks79"&&(zt.innerHTML=vi),vn=a(e),Ft=o(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-1i1ixy0"&&(Ft.innerHTML=Ci),Cn=a(e),Z=o(e,"H2",{class:!0});var zn=w(Z);L=o(zn,"A",{id:!0,class:!0,href:!0});var Oi=w(L);Ul=o(Oi,"SPAN",{});var eo=w(Ul);d(St.$$.fragment,eo),eo.forEach(t),Oi.forEach(t),sa=a(zn),cl=o(zn,"SPAN",{"data-svelte-h":!0}),r(cl)!=="svelte-1lz1ehr"&&(cl.textContent=Ii),zn.forEach(t),In=a(e),Qt=o(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-5ekp45"&&(Qt.innerHTML=_i),_n=a(e),d(qt.$$.fragment,e),kn=a(e),B=o(e,"H2",{class:!0});var Fn=w(B);P=o(Fn,"A",{id:!0,class:!0,href:!0});var to=w(P);vl=o(to,"SPAN",{});var lo=w(vl);d(Lt.$$.fragment,lo),lo.forEach(t),to.forEach(t),na=a(Fn),dl=o(Fn,"SPAN",{"data-svelte-h":!0}),r(dl)!=="svelte-11v4ufk"&&(dl.textContent=ki),Fn.forEach(t),xn=a(e),Pt=o(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-z4yljy"&&(Pt.innerHTML=xi),Wn=a(e),Dt=o(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1kap55g"&&(Dt.innerHTML=Wi),$n=a(e),Cl=o(e,"P",{}),w(Cl).forEach(t),this.h()},h(){p(J,"name","hf:doc:metadata"),p(J,"content",JSON.stringify(mo)),p(X,"id","finetuning-the-asr-model"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#finetuning-the-asr-model"),p(j,"class","relative group"),p(A,"id","prepare-environment"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#prepare-environment"),p(U,"class","relative group"),p(N,"id","load-dataset"),p(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(N,"href","#load-dataset"),p(v,"class","relative group"),p(H,"id","feature-extractor-tokenizer-and-processor"),p(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(H,"href","#feature-extractor-tokenizer-and-processor"),p(C,"class","relative group"),p(V,"id","preprocess-the-data"),p(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(V,"href","#preprocess-the-data"),p(I,"class","relative group"),p(R,"id","training-and-evaluation"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#training-and-evaluation"),p(_,"class","relative group"),p(Y,"id","define-a-data-collator"),p(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Y,"href","#define-a-data-collator"),p(k,"class","relative group"),p(z,"id","evaluation-metrics"),p(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(z,"href","#evaluation-metrics"),p(x,"class","relative group"),p(F,"id","load-a-pretrained-checkpoint"),p(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(F,"href","#load-a-pretrained-checkpoint"),p(W,"class","relative group"),p(S,"id","define-the-training-configuration"),p(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(S,"href","#define-the-training-configuration"),p($,"class","relative group"),p(q,"id","training"),p(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(q,"href","#training"),p(G,"class","relative group"),p(L,"id","sharing-your-model"),p(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(L,"href","#sharing-your-model"),p(Z,"class","relative group"),p(P,"id","conclusion"),p(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(P,"href","#conclusion"),p(B,"class","relative group")},m(e,l){h(document.head,J),s(e,T,l),s(e,b,l),s(e,_l,l),s(e,j,l),h(j,X),h(X,ul),u(D,ul,null),h(j,Sn),h(j,el),s(e,kl,l),s(e,K,l),s(e,xl,l),s(e,O,l),s(e,Wl,l),s(e,ee,l),s(e,$l,l),s(e,te,l),s(e,Gl,l),s(e,U,l),h(U,A),h(A,Ml),u(le,Ml,null),h(U,Qn),h(U,tl),s(e,Zl,l),s(e,se,l),s(e,Bl,l),s(e,ne,l),s(e,Xl,l),s(e,ae,l),s(e,Al,l),u(ie,e,l),s(e,Nl,l),s(e,oe,l),s(e,El,l),u(re,e,l),s(e,Hl,l),s(e,v,l),h(v,N),h(N,ml),u(pe,ml,null),h(v,qn),h(v,ll),s(e,Vl,l),s(e,he,l),s(e,Rl,l),s(e,ce,l),s(e,Yl,l),u(de,e,l),s(e,zl,l),s(e,ue,l),s(e,Fl,l),u(Me,e,l),s(e,Sl,l),u(E,e,l),s(e,Ql,l),s(e,me,l),s(e,ql,l),u(ye,e,l),s(e,Ll,l),s(e,C,l),h(C,H),h(H,yl),u(we,yl,null),h(C,Ln),h(C,sl),s(e,Pl,l),s(e,fe,l),s(e,Dl,l),s(e,Je,l),s(e,Kl,l),s(e,Te,l),s(e,Ol,l),s(e,ge,l),s(e,es,l),s(e,be,l),s(e,ts,l),u(je,e,l),s(e,ls,l),s(e,Ue,l),s(e,ss,l),s(e,ve,l),s(e,ns,l),s(e,Ce,l),s(e,as,l),s(e,Ie,l),s(e,is,l),u(_e,e,l),s(e,os,l),s(e,ke,l),s(e,rs,l),s(e,I,l),h(I,V),h(V,wl),u(xe,wl,null),h(I,Pn),h(I,nl),s(e,ps,l),s(e,We,l),s(e,hs,l),u($e,e,l),s(e,cs,l),s(e,Ge,l),s(e,ds,l),u(Ze,e,l),s(e,us,l),s(e,Be,l),s(e,Ms,l),s(e,Xe,l),s(e,ms,l),u(Ae,e,l),s(e,ys,l),s(e,Ne,l),s(e,ws,l),s(e,Ee,l),s(e,fs,l),u(He,e,l),s(e,Js,l),s(e,Ve,l),s(e,Ts,l),u(Re,e,l),s(e,gs,l),s(e,Ye,l),s(e,bs,l),u(ze,e,l),s(e,js,l),s(e,Fe,l),s(e,Us,l),u(Se,e,l),s(e,vs,l),s(e,Qe,l),s(e,Cs,l),u(qe,e,l),s(e,Is,l),s(e,Le,l),s(e,_s,l),u(Pe,e,l),s(e,ks,l),s(e,De,l),s(e,xs,l),s(e,_,l),h(_,R),h(R,fl),u(Ke,fl,null),h(_,Dn),h(_,al),s(e,Ws,l),s(e,Oe,l),s(e,$s,l),s(e,et,l),s(e,Gs,l),s(e,tt,l),s(e,Zs,l),s(e,k,l),h(k,Y),h(Y,Jl),u(lt,Jl,null),h(k,Kn),h(k,il),s(e,Bs,l),s(e,st,l),s(e,Xs,l),s(e,nt,l),s(e,As,l),s(e,at,l),s(e,Ns,l),s(e,it,l),s(e,Es,l),u(ot,e,l),s(e,Hs,l),s(e,rt,l),s(e,Vs,l),u(pt,e,l),s(e,Rs,l),s(e,ht,l),s(e,Ys,l),s(e,x,l),h(x,z),h(z,Tl),u(ct,Tl,null),h(x,On),h(x,ol),s(e,zs,l),s(e,dt,l),s(e,Fs,l),s(e,ut,l),s(e,Ss,l),u(Mt,e,l),s(e,Qs,l),s(e,mt,l),s(e,qs,l),u(yt,e,l),s(e,Ls,l),s(e,W,l),h(W,F),h(F,gl),u(wt,gl,null),h(W,ea),h(W,rl),s(e,Ps,l),s(e,ft,l),s(e,Ds,l),u(Jt,e,l),s(e,Ks,l),s(e,Tt,l),s(e,Os,l),u(gt,e,l),s(e,en,l),s(e,$,l),h($,S),h(S,bl),u(bt,bl,null),h($,ta),h($,pl),s(e,tn,l),s(e,jt,l),s(e,ln,l),u(Ut,e,l),s(e,sn,l),u(Q,e,l),s(e,nn,l),s(e,vt,l),s(e,an,l),u(Ct,e,l),s(e,on,l),s(e,It,l),s(e,rn,l),s(e,G,l),h(G,q),h(q,jl),u(_t,jl,null),h(G,la),h(G,hl),s(e,pn,l),s(e,kt,l),s(e,hn,l),u(xt,e,l),s(e,cn,l),s(e,Wt,l),s(e,dn,l),s(e,$t,l),s(e,un,l),s(e,Gt,l),s(e,Mn,l),s(e,Zt,l),s(e,mn,l),s(e,Bt,l),s(e,yn,l),s(e,Xt,l),s(e,wn,l),s(e,At,l),s(e,fn,l),s(e,Nt,l),s(e,Jn,l),u(Et,e,l),s(e,Tn,l),s(e,Ht,l),s(e,gn,l),u(Vt,e,l),s(e,bn,l),s(e,Rt,l),s(e,jn,l),s(e,Yt,l),s(e,Un,l),s(e,zt,l),s(e,vn,l),s(e,Ft,l),s(e,Cn,l),s(e,Z,l),h(Z,L),h(L,Ul),u(St,Ul,null),h(Z,sa),h(Z,cl),s(e,In,l),s(e,Qt,l),s(e,_n,l),u(qt,e,l),s(e,kn,l),s(e,B,l),h(B,P),h(P,vl),u(Lt,vl,null),h(B,na),h(B,dl),s(e,xn,l),s(e,Pt,l),s(e,Wn,l),s(e,Dt,l),s(e,$n,l),s(e,Cl,l),Gn=!0},p(e,[l]){const Kt={};l&2&&(Kt.$$scope={dirty:l,ctx:e}),E.$set(Kt);const Il={};l&2&&(Il.$$scope={dirty:l,ctx:e}),Q.$set(Il)},i(e){Gn||(M(D.$$.fragment,e),M(le.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(pe.$$.fragment,e),M(de.$$.fragment,e),M(Me.$$.fragment,e),M(E.$$.fragment,e),M(ye.$$.fragment,e),M(we.$$.fragment,e),M(je.$$.fragment,e),M(_e.$$.fragment,e),M(xe.$$.fragment,e),M($e.$$.fragment,e),M(Ze.$$.fragment,e),M(Ae.$$.fragment,e),M(He.$$.fragment,e),M(Re.$$.fragment,e),M(ze.$$.fragment,e),M(Se.$$.fragment,e),M(qe.$$.fragment,e),M(Pe.$$.fragment,e),M(Ke.$$.fragment,e),M(lt.$$.fragment,e),M(ot.$$.fragment,e),M(pt.$$.fragment,e),M(ct.$$.fragment,e),M(Mt.$$.fragment,e),M(yt.$$.fragment,e),M(wt.$$.fragment,e),M(Jt.$$.fragment,e),M(gt.$$.fragment,e),M(bt.$$.fragment,e),M(Ut.$$.fragment,e),M(Q.$$.fragment,e),M(Ct.$$.fragment,e),M(_t.$$.fragment,e),M(xt.$$.fragment,e),M(Et.$$.fragment,e),M(Vt.$$.fragment,e),M(St.$$.fragment,e),M(qt.$$.fragment,e),M(Lt.$$.fragment,e),Gn=!0)},o(e){m(D.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(de.$$.fragment,e),m(Me.$$.fragment,e),m(E.$$.fragment,e),m(ye.$$.fragment,e),m(we.$$.fragment,e),m(je.$$.fragment,e),m(_e.$$.fragment,e),m(xe.$$.fragment,e),m($e.$$.fragment,e),m(Ze.$$.fragment,e),m(Ae.$$.fragment,e),m(He.$$.fragment,e),m(Re.$$.fragment,e),m(ze.$$.fragment,e),m(Se.$$.fragment,e),m(qe.$$.fragment,e),m(Pe.$$.fragment,e),m(Ke.$$.fragment,e),m(lt.$$.fragment,e),m(ot.$$.fragment,e),m(pt.$$.fragment,e),m(ct.$$.fragment,e),m(Mt.$$.fragment,e),m(yt.$$.fragment,e),m(wt.$$.fragment,e),m(Jt.$$.fragment,e),m(gt.$$.fragment,e),m(bt.$$.fragment,e),m(Ut.$$.fragment,e),m(Q.$$.fragment,e),m(Ct.$$.fragment,e),m(_t.$$.fragment,e),m(xt.$$.fragment,e),m(Et.$$.fragment,e),m(Vt.$$.fragment,e),m(St.$$.fragment,e),m(qt.$$.fragment,e),m(Lt.$$.fragment,e),Gn=!1},d(e){e&&(t(T),t(b),t(_l),t(j),t(kl),t(K),t(xl),t(O),t(Wl),t(ee),t($l),t(te),t(Gl),t(U),t(Zl),t(se),t(Bl),t(ne),t(Xl),t(ae),t(Al),t(Nl),t(oe),t(El),t(Hl),t(v),t(Vl),t(he),t(Rl),t(ce),t(Yl),t(zl),t(ue),t(Fl),t(Sl),t(Ql),t(me),t(ql),t(Ll),t(C),t(Pl),t(fe),t(Dl),t(Je),t(Kl),t(Te),t(Ol),t(ge),t(es),t(be),t(ts),t(ls),t(Ue),t(ss),t(ve),t(ns),t(Ce),t(as),t(Ie),t(is),t(os),t(ke),t(rs),t(I),t(ps),t(We),t(hs),t(cs),t(Ge),t(ds),t(us),t(Be),t(Ms),t(Xe),t(ms),t(ys),t(Ne),t(ws),t(Ee),t(fs),t(Js),t(Ve),t(Ts),t(gs),t(Ye),t(bs),t(js),t(Fe),t(Us),t(vs),t(Qe),t(Cs),t(Is),t(Le),t(_s),t(ks),t(De),t(xs),t(_),t(Ws),t(Oe),t($s),t(et),t(Gs),t(tt),t(Zs),t(k),t(Bs),t(st),t(Xs),t(nt),t(As),t(at),t(Ns),t(it),t(Es),t(Hs),t(rt),t(Vs),t(Rs),t(ht),t(Ys),t(x),t(zs),t(dt),t(Fs),t(ut),t(Ss),t(Qs),t(mt),t(qs),t(Ls),t(W),t(Ps),t(ft),t(Ds),t(Ks),t(Tt),t(Os),t(en),t($),t(tn),t(jt),t(ln),t(sn),t(nn),t(vt),t(an),t(on),t(It),t(rn),t(G),t(pn),t(kt),t(hn),t(cn),t(Wt),t(dn),t($t),t(un),t(Gt),t(Mn),t(Zt),t(mn),t(Bt),t(yn),t(Xt),t(wn),t(At),t(fn),t(Nt),t(Jn),t(Tn),t(Ht),t(gn),t(bn),t(Rt),t(jn),t(Yt),t(Un),t(zt),t(vn),t(Ft),t(Cn),t(Z),t(In),t(Qt),t(_n),t(kn),t(B),t(xn),t(Pt),t(Wn),t(Dt),t($n),t(Cl)),t(J),y(D),y(le),y(ie,e),y(re,e),y(pe),y(de,e),y(Me,e),y(E,e),y(ye,e),y(we),y(je,e),y(_e,e),y(xe),y($e,e),y(Ze,e),y(Ae,e),y(He,e),y(Re,e),y(ze,e),y(Se,e),y(qe,e),y(Pe,e),y(Ke),y(lt),y(ot,e),y(pt,e),y(ct),y(Mt,e),y(yt,e),y(wt),y(Jt,e),y(gt,e),y(bt),y(Ut,e),y(Q,e),y(Ct,e),y(_t),y(xt,e),y(Et,e),y(Vt,e),y(St),y(qt,e),y(Lt)}}}const mo={local:"finetuning-the-asr-model",sections:[{local:"prepare-environment",title:"Prepare Environment"},{local:"load-dataset",title:"Load Dataset"},{local:"feature-extractor-tokenizer-and-processor",title:"Feature Extractor, Tokenizer and Processor"},{local:"preprocess-the-data",title:"Pre-Process the Data"},{local:"training-and-evaluation",sections:[{local:"define-a-data-collator",title:"Define a Data Collator"},{local:"evaluation-metrics",title:"Evaluation Metrics"},{local:"load-a-pretrained-checkpoint",title:"Load a Pre-Trained Checkpoint"}],title:"Training and Evaluation"},{local:"define-the-training-configuration",sections:[{local:"training",title:"Training"}],title:"Define the Training Configuration"},{local:"sharing-your-model",title:"Sharing Your Model"},{local:"conclusion",title:"Conclusion"}],title:"Fine-tuning the ASR model"};function yo(Ot){return oo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bo extends ro{constructor(J){super(),po(this,J,yo,Mo,io,{})}}export{bo as component};
