import{s as Lp,o as Kp,n as Op}from"../chunks/scheduler.f7e1785c.js";import{S as ei,i as ti,g as p,s as a,u as o,m as li,A as si,h as i,f as l,c as n,j as J,v as h,y as r,n as ai,k as m,o as w,a as s,w as c,d as M,t as y,x as u}from"../chunks/index.815a732f.js";import{T as ni}from"../chunks/Tip.1258ac78.js";import{I as U}from"../chunks/IconCopyLink.e7937f56.js";import{C as d}from"../chunks/CodeBlock.c6e8b464.js";function pi(vl){let T,S=`In our example we will be using approximately 40 hours of training data. If you’d like to follow along using the Google Colab free tier GPU,
you will need to reduce the amount of training data to approximately 10-15 hours, and reduce the number of training steps.`;return{c(){T=p("p"),T.textContent=S},l(f){T=i(f,"P",{"data-svelte-h":!0}),r(T)!=="svelte-jn3a6r"&&(T.textContent=S)},m(f,al){s(f,T,al)},p:Op,d(f){f&&l(T)}}}function ii(vl){let T,S,f,al,j,G,dl,q,Ka,nl,hn="Fine-tuning SpeechT5",xl,P,cn=`Now that you are familiar with the text-to-speech task and internal workings of the SpeechT5 model that was pre-trained
on English language data, let’s see how we can fine-tune it to another language.`,$l,b,V,wl,D,Oa,pl,Mn="House-keeping",Zl,L,_l,B,Gl,K,yn="You’ll also need some additional dependencies:",Vl,O,Bl,ee,un="Finally, don’t forget to log in to your Hugging Face account so that you could upload and share your model with the community:",Wl,te,Xl,C,W,Jl,le,en,il,mn="The dataset",Rl,se,dn=`For this example we’ll take the Dutch (<code>nl</code>) language subset of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset.
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> is a large-scale multilingual speech corpus consisting of
data sourced from 2009-2020 European Parliament event recordings. It contains labelled audio-transcription data for 15
European languages. While we will be using the Dutch language subset, feel free to pick another subset.`,Al,ae,wn=`This is an automated speech recognition (ASR) dataset, so, as mentioned before, it is not the most suitable
option for training TTS models. However, it will be good enough for this exercise.`,Nl,ne,Jn="Let’s load the data:",Yl,pe,Ql,ie,Tn="<strong>Output:</strong>",El,re,zl,oe,fn=`20968 examples should be sufficient for fine-tuning. SpeechT5 expects audio data to have a sampling rate of 16 kHz, so
make sure the examples in the dataset meet this requirement:`,Fl,he,Hl,I,X,Tl,ce,tn,rl,Un="Preprocessing the data",Sl,Me,jn=`Let’s begin by defining the model checkpoint to use and loading the appropriate processor that contains both tokenizer,
and feature extractor that we will need to prepare the data for training:`,ql,ye,Pl,g,R,fl,ue,ln,ol,bn="Text cleanup for SpeechT5 tokenization",Dl,me,Cn="First, for preparing the text, we’ll need the tokenizer part of the processor, so let’s get it:",Ll,de,Kl,we,In="Let’s take a look at an example:",Ol,Je,es,Te,gn="<strong>Output:</strong>",ts,fe,ls,Ue,kn=`What you may notice is that the dataset examples contain <code>raw_text</code> and <code>normalized_text</code> features. When deciding which
feature to use as the text input, it will be important to know that the SpeechT5 tokenizer doesn’t have any tokens for
numbers. In <code>normalized_text</code> the numbers are written out as text. Thus, it is a better fit, and we should use <code>normalized_text</code>
as input text.`,ss,je,vn=`Because SpeechT5 was trained on the English language, it may not recognize certain characters in the Dutch dataset. If
left as is, these characters will be converted to <code>&lt;unk&gt;</code> tokens. However, in Dutch, certain characters like <code>à</code> are
used to stress syllables. In order to preserve the meaning of the text, we can replace this character with a regular <code>a</code>.`,as,be,xn=`To identify unsupported tokens, extract all unique characters in the dataset using the <code>SpeechT5Tokenizer</code> which
works with characters as tokens. To do this, we’ll write the <code>extract_all_chars</code> mapping function that concatenates
the transcriptions from all examples into one string and converts it to a set of characters.
Make sure to set <code>batched=True</code> and <code>batch_size=-1</code> in <code>dataset.map()</code> so that all transcriptions are available at once for
the mapping function.`,ns,Ce,ps,Ie,$n=`Now you have two sets of characters: one with the vocabulary from the dataset and one with the vocabulary from the tokenizer.
To identify any unsupported characters in the dataset, you can take the difference between these two sets. The resulting
set will contain the characters that are in the dataset but not in the tokenizer.`,is,ge,rs,ke,Zn="<strong>Output:</strong>",os,ve,hs,xe,_n=`To handle the unsupported characters identified in the previous step, we can define a function that maps these characters to
valid tokens. Note that spaces are already replaced by <code>▁</code> in the tokenizer and don’t need to be handled separately.`,cs,$e,Ms,Ze,Gn="Now that we have dealt with special characters in the text, it’s time to shift the focus to the audio data.",ys,k,A,Ul,_e,sn,hl,Vn="Speakers",us,Ge,Bn=`The VoxPopuli dataset includes speech from multiple speakers, but how many speakers are represented in the dataset? To
determine this, we can count the number of unique speakers and the number of examples each speaker contributes to the dataset.
With a total of 20,968 examples in the dataset, this information will give us a better understanding of the distribution of
speakers and examples in the data.`,ms,Ve,ds,Be,Wn="By plotting a histogram you can get a sense of how much data there is for each speaker.",ws,We,Js,N,Xn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',Ts,Xe,Rn=`The histogram reveals that approximately one-third of the speakers in the dataset have fewer than 100 examples, while
around ten speakers have more than 500 examples. To improve training efficiency and balance the dataset, we can limit
the data to speakers with between 100 and 400 examples.`,fs,Re,Us,Ae,An="Let’s check how many speakers remain:",js,Ne,bs,Ye,Nn="<strong>Output:</strong>",Cs,Qe,Is,Ee,Yn="Let’s see how many examples are left:",gs,ze,ks,Fe,Qn="<strong>Output:</strong>",vs,He,xs,Se,En="You are left with just under 10,000 examples from approximately 40 unique speakers, which should be sufficient.",$s,qe,zn=`Note that some speakers with few examples may actually have more audio available if the examples are long. However,
determining the total amount of audio for each speaker requires scanning through the entire dataset, which is a
time-consuming process that involves loading and decoding each audio file. As such, we have chosen to skip this step here.`,Zs,v,Y,jl,Pe,an,cl,Fn="Speaker embeddings",_s,De,Hn=`To enable the TTS model to differentiate between multiple speakers, you’ll need to create a speaker embedding for each example.
The speaker embedding is an additional input into the model that captures a particular speaker’s voice characteristics.
To generate these speaker embeddings, use the pre-trained <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
model from SpeechBrain.`,Gs,Le,Sn=`Create a function <code>create_speaker_embedding()</code> that takes an input audio waveform and outputs a 512-element vector
containing the corresponding speaker embedding.`,Vs,Ke,Bs,Oe,qn=`It’s important to note that the <code>speechbrain/spkrec-xvect-voxceleb</code> model was trained on English speech from the VoxCeleb
dataset, whereas the training examples in this guide are in Dutch. While we believe that this model will still generate
reasonable speaker embeddings for our Dutch dataset, this assumption may not hold true in all cases.`,Ws,et,Pn=`For optimal results, we would need to train an X-vector model on the target speech first. This will ensure that the model
is better able to capture the unique voice characteristics present in the Dutch language. If you’d like to train your own
X-vector model, you can use <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">this script</a>
as an example.`,Xs,x,Q,bl,tt,nn,Ml,Dn="Processing the dataset",Rs,lt,Ln=`Finally, let’s process the data into the format the model expects. Create a <code>prepare_dataset</code> function that takes in a
single example and uses the <code>SpeechT5Processor</code> object to tokenize the input text and load the target audio into a log-mel spectrogram.
It should also add the speaker embeddings as an additional input.`,As,st,Ns,at,Kn="Verify the processing is correct by looking at a single example:",Ys,nt,Qs,pt,On="<strong>Output:</strong>",Es,it,zs,rt,ep="Speaker embeddings should be a 512-element vector:",Fs,ot,Hs,ht,tp="<strong>Output:</strong>",Ss,ct,qs,Mt,lp="The labels should be a log-mel spectrogram with 80 mel bins.",Ps,yt,Ds,E,sp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',Ls,ut,ap=`Side note: If you find this spectrogram confusing, it may be due to your familiarity with the convention of placing low frequencies
at the bottom and high frequencies at the top of a plot. However, when plotting spectrograms as an image using the matplotlib library,
the y-axis is flipped and the spectrograms appear upside down.`,Ks,mt,np="Now we need to apply the processing function to the entire dataset. This will take between 5 and 10 minutes.",Os,dt,ea,wt,pp=`You’ll see a warning saying that some examples in the dataset are longer than the maximum input length the model can handle (600 tokens).
Remove those examples from the dataset. Here we go even further and to allow for larger batch sizes we remove anything over 200 tokens.`,ta,Jt,la,Tt,ip="<strong>Output:</strong>",sa,ft,aa,Ut,rp="Next, create a basic train/test split:",na,jt,pa,$,z,Cl,bt,pn,yl,op="Data collator",ia,Ct,hp=`In order to combine multiple examples into a batch, you need to define a custom data collator. This collator will pad shorter sequences with padding
tokens, ensuring that all examples have the same length. For the spectrogram labels, the padded portions are replaced with
the special value <code>-100</code>. This special value instructs the model to ignore that part of the spectrogram when calculating the spectrogram loss.`,ra,It,oa,gt,cp=`In SpeechT5, the input to the decoder part of the model is reduced by a factor 2. In other words, it throws away every
other timestep from the target sequence. The decoder then predicts a sequence that is twice as long. Since the original
target sequence length may be odd, the data collator makes sure to round the maximum length of the batch down to be a
multiple of 2.`,ha,kt,ca,Z,F,Il,vt,rn,ul,Mp="Train the model",Ma,xt,yp="Load the pre-trained model from the same checkpoint as you used for loading the processor:",ya,$t,ua,Zt,up=`The <code>use_cache=True</code> option is incompatible with gradient checkpointing. Disable it for training, and re-enable cache for
generation to speed-up inference time:`,ma,_t,da,Gt,mp=`Define the training arguments. Here we are not computing any evaluation metrics during the training process,
we’ll talk about evaluation later in this chapter. Instead, we’ll only look at the loss:`,wa,Vt,Ja,Bt,dp="Instantiate the <code>Trainer</code> object  and pass the model, dataset, and data collator to it.",Ta,Wt,fa,Xt,wp=`And with that, we’re ready to start training! Training will take several hours. Depending on your GPU,
it is possible that you will encounter a CUDA “out-of-memory” error when you start training. In this case, you can reduce
the <code>per_device_train_batch_size</code> incrementally by factors of 2 and increase <code>gradient_accumulation_steps</code> by 2x to compensate.`,Ua,Rt,ja,At,Jp="Push the final model to the 🤗 Hub:",ba,Nt,Ca,_,H,gl,Yt,on,ml,Tp="Inference",Ia,Qt,fp=`Once you have fine-tuned a model, you can use it for inference! Load the model from the 🤗 Hub (make sure to use your
account name in the following code snippet):`,ga,Et,ka,zt,Up="Pick an example, here we’ll take one from the test dataset. Obtain a speaker embedding.",va,Ft,xa,Ht,jp="Define some input text and tokenize it.",$a,St,Za,qt,bp="Preprocess the input text:",_a,Pt,Ga,Dt,Cp="Instantiate a vocoder and generate speech:",Va,Lt,Ba,Kt,Ip="Ready to listen to the result?",Wa,Ot,Xa,el,gp=`Obtaining satisfactory results from this model on a new language can be challenging. The quality of the speaker
embeddings can be a significant factor. Since SpeechT5 was pre-trained with English x-vectors, it performs best
when using English speaker embeddings. If the synthesized speech sounds poor, try using a different speaker embedding.`,Ra,tl,kp=`Increasing the training duration is also likely to enhance the quality of the results. Even so, the speech clearly is Dutch instead of English, and it does
capture the voice characteristics of the speaker (compare to the original audio in the example).
Another thing to experiment with is the model’s configuration. For example, try using <code>config.reduction_factor = 1</code> to
see if this improves the results.`,Aa,ll,vp="In the next section, we’ll talk about how we evaluate text-to-speech models.",Na,kl,Ya;return q=new U({}),D=new U({}),L=new d({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi"}}),B=new ni({props:{warning:!0,$$slots:{default:[pi]},$$scope:{ctx:vl}}}),O=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate"}}),te=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),le=new U({}),pe=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`}}),re=new d({props:{code:"MjA5Njg=",highlighted:"20968"}}),he=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))'}}),ce=new U({}),ye=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`}}),ue=new U({}),de=new d({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer"}}),Je=new d({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]'}}),fe=new d({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`}}),Ce=new d({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`}}),ge=new d({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab"}}),ve=new d({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}"}}),$e=new d({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`}}),_e=new U({}),Ve=new d({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`}}),We=new d({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`}}),Re=new d({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`}}),Ne=new d({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))'}}),Qe=new d({props:{code:"NDI=",highlighted:"42"}}),ze=new d({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)'}}),He=new d({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>'}}),Pe=new U({}),Ke=new d({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`}}),tt=new U({}),st=new d({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># strip off the batch dimension</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`}}),nt=new d({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`}}),it=new d({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]'}}),ot=new d({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape'}}),ct=new d({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)'}}),yt=new d({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`}}),dt=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)'}}),Jt=new d({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`}}),ft=new d({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>'}}),jt=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)'}}),bt=new U({}),It=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># not used during fine-tuning</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># also add in the speaker embeddings</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`}}),kt=new d({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)"}}),vt=new U({}),$t=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`}}),_t=new d({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkaXNhYmxlJTIwY2FjaGUlMjBkdXJpbmclMjB0cmFpbmluZyUyMHNpbmNlJTIwaXQncyUyMGluY29tcGF0aWJsZSUyMHdpdGglMjBncmFkaWVudCUyMGNoZWNrcG9pbnRpbmclMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBzZXQlMjBsYW5ndWFnZSUyMGFuZCUyMHRhc2slMjBmb3IlMjBnZW5lcmF0aW9uJTIwYW5kJTIwcmUtZW5hYmxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># disable cache during training since it&#x27;s incompatible with gradient checkpointing</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># set language and task for generation and re-enable cache</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`}}),Vt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`}}),Wt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`}}),Rt=new d({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()"}}),Nt=new d({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()"}}),Yt=new U({}),Et=new d({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`}}),Ft=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`}}),St=new d({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>'}}),Pt=new d({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)'}}),Lt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`}}),Ot=new d({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`}}),{c(){T=p("meta"),S=a(),f=p("p"),al=a(),j=p("h1"),G=p("a"),dl=p("span"),o(q.$$.fragment),Ka=a(),nl=p("span"),nl.textContent=hn,xl=a(),P=p("p"),P.textContent=cn,$l=a(),b=p("h2"),V=p("a"),wl=p("span"),o(D.$$.fragment),Oa=a(),pl=p("span"),pl.textContent=Mn,Zl=li(`

Make sure that you have a GPU if you want to reproduce this example. In a notebook, you can check with the following command:

	`),o(L.$$.fragment),_l=a(),o(B.$$.fragment),Gl=a(),K=p("p"),K.textContent=yn,Vl=a(),o(O.$$.fragment),Bl=a(),ee=p("p"),ee.textContent=un,Wl=a(),o(te.$$.fragment),Xl=a(),C=p("h2"),W=p("a"),Jl=p("span"),o(le.$$.fragment),en=a(),il=p("span"),il.textContent=mn,Rl=a(),se=p("p"),se.innerHTML=dn,Al=a(),ae=p("p"),ae.textContent=wn,Nl=a(),ne=p("p"),ne.textContent=Jn,Yl=a(),o(pe.$$.fragment),Ql=a(),ie=p("p"),ie.innerHTML=Tn,El=a(),o(re.$$.fragment),zl=a(),oe=p("p"),oe.textContent=fn,Fl=a(),o(he.$$.fragment),Hl=a(),I=p("h2"),X=p("a"),Tl=p("span"),o(ce.$$.fragment),tn=a(),rl=p("span"),rl.textContent=Un,Sl=a(),Me=p("p"),Me.textContent=jn,ql=a(),o(ye.$$.fragment),Pl=a(),g=p("h3"),R=p("a"),fl=p("span"),o(ue.$$.fragment),ln=a(),ol=p("span"),ol.textContent=bn,Dl=a(),me=p("p"),me.textContent=Cn,Ll=a(),o(de.$$.fragment),Kl=a(),we=p("p"),we.textContent=In,Ol=a(),o(Je.$$.fragment),es=a(),Te=p("p"),Te.innerHTML=gn,ts=a(),o(fe.$$.fragment),ls=a(),Ue=p("p"),Ue.innerHTML=kn,ss=a(),je=p("p"),je.innerHTML=vn,as=a(),be=p("p"),be.innerHTML=xn,ns=a(),o(Ce.$$.fragment),ps=a(),Ie=p("p"),Ie.textContent=$n,is=a(),o(ge.$$.fragment),rs=a(),ke=p("p"),ke.innerHTML=Zn,os=a(),o(ve.$$.fragment),hs=a(),xe=p("p"),xe.innerHTML=_n,cs=a(),o($e.$$.fragment),Ms=a(),Ze=p("p"),Ze.textContent=Gn,ys=a(),k=p("h3"),A=p("a"),Ul=p("span"),o(_e.$$.fragment),sn=a(),hl=p("span"),hl.textContent=Vn,us=a(),Ge=p("p"),Ge.textContent=Bn,ms=a(),o(Ve.$$.fragment),ds=a(),Be=p("p"),Be.textContent=Wn,ws=a(),o(We.$$.fragment),Js=a(),N=p("div"),N.innerHTML=Xn,Ts=a(),Xe=p("p"),Xe.textContent=Rn,fs=a(),o(Re.$$.fragment),Us=a(),Ae=p("p"),Ae.textContent=An,js=a(),o(Ne.$$.fragment),bs=a(),Ye=p("p"),Ye.innerHTML=Nn,Cs=a(),o(Qe.$$.fragment),Is=a(),Ee=p("p"),Ee.textContent=Yn,gs=a(),o(ze.$$.fragment),ks=a(),Fe=p("p"),Fe.innerHTML=Qn,vs=a(),o(He.$$.fragment),xs=a(),Se=p("p"),Se.textContent=En,$s=a(),qe=p("p"),qe.textContent=zn,Zs=a(),v=p("h3"),Y=p("a"),jl=p("span"),o(Pe.$$.fragment),an=a(),cl=p("span"),cl.textContent=Fn,_s=a(),De=p("p"),De.innerHTML=Hn,Gs=a(),Le=p("p"),Le.innerHTML=Sn,Vs=a(),o(Ke.$$.fragment),Bs=a(),Oe=p("p"),Oe.innerHTML=qn,Ws=a(),et=p("p"),et.innerHTML=Pn,Xs=a(),x=p("h3"),Q=p("a"),bl=p("span"),o(tt.$$.fragment),nn=a(),Ml=p("span"),Ml.textContent=Dn,Rs=a(),lt=p("p"),lt.innerHTML=Ln,As=a(),o(st.$$.fragment),Ns=a(),at=p("p"),at.textContent=Kn,Ys=a(),o(nt.$$.fragment),Qs=a(),pt=p("p"),pt.innerHTML=On,Es=a(),o(it.$$.fragment),zs=a(),rt=p("p"),rt.textContent=ep,Fs=a(),o(ot.$$.fragment),Hs=a(),ht=p("p"),ht.innerHTML=tp,Ss=a(),o(ct.$$.fragment),qs=a(),Mt=p("p"),Mt.textContent=lp,Ps=a(),o(yt.$$.fragment),Ds=a(),E=p("div"),E.innerHTML=sp,Ls=a(),ut=p("p"),ut.textContent=ap,Ks=a(),mt=p("p"),mt.textContent=np,Os=a(),o(dt.$$.fragment),ea=a(),wt=p("p"),wt.textContent=pp,ta=a(),o(Jt.$$.fragment),la=a(),Tt=p("p"),Tt.innerHTML=ip,sa=a(),o(ft.$$.fragment),aa=a(),Ut=p("p"),Ut.textContent=rp,na=a(),o(jt.$$.fragment),pa=a(),$=p("h3"),z=p("a"),Cl=p("span"),o(bt.$$.fragment),pn=a(),yl=p("span"),yl.textContent=op,ia=a(),Ct=p("p"),Ct.innerHTML=hp,ra=a(),o(It.$$.fragment),oa=a(),gt=p("p"),gt.textContent=cp,ha=a(),o(kt.$$.fragment),ca=a(),Z=p("h2"),F=p("a"),Il=p("span"),o(vt.$$.fragment),rn=a(),ul=p("span"),ul.textContent=Mp,Ma=a(),xt=p("p"),xt.textContent=yp,ya=a(),o($t.$$.fragment),ua=a(),Zt=p("p"),Zt.innerHTML=up,ma=a(),o(_t.$$.fragment),da=a(),Gt=p("p"),Gt.textContent=mp,wa=a(),o(Vt.$$.fragment),Ja=a(),Bt=p("p"),Bt.innerHTML=dp,Ta=a(),o(Wt.$$.fragment),fa=a(),Xt=p("p"),Xt.innerHTML=wp,Ua=a(),o(Rt.$$.fragment),ja=a(),At=p("p"),At.textContent=Jp,ba=a(),o(Nt.$$.fragment),Ca=a(),_=p("h2"),H=p("a"),gl=p("span"),o(Yt.$$.fragment),on=a(),ml=p("span"),ml.textContent=Tp,Ia=a(),Qt=p("p"),Qt.textContent=fp,ga=a(),o(Et.$$.fragment),ka=a(),zt=p("p"),zt.textContent=Up,va=a(),o(Ft.$$.fragment),xa=a(),Ht=p("p"),Ht.textContent=jp,$a=a(),o(St.$$.fragment),Za=a(),qt=p("p"),qt.textContent=bp,_a=a(),o(Pt.$$.fragment),Ga=a(),Dt=p("p"),Dt.textContent=Cp,Va=a(),o(Lt.$$.fragment),Ba=a(),Kt=p("p"),Kt.textContent=Ip,Wa=a(),o(Ot.$$.fragment),Xa=a(),el=p("p"),el.textContent=gp,Ra=a(),tl=p("p"),tl.innerHTML=kp,Aa=a(),ll=p("p"),ll.textContent=vp,Na=a(),kl=p("p"),this.h()},l(e){const t=si("svelte-1phssyn",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(l),S=n(e),f=i(e,"P",{}),J(f).forEach(l),al=n(e),j=i(e,"H1",{class:!0});var sl=J(j);G=i(sl,"A",{id:!0,class:!0,href:!0});var xp=J(G);dl=i(xp,"SPAN",{});var $p=J(dl);h(q.$$.fragment,$p),$p.forEach(l),xp.forEach(l),Ka=n(sl),nl=i(sl,"SPAN",{"data-svelte-h":!0}),r(nl)!=="svelte-10n8w1s"&&(nl.textContent=hn),sl.forEach(l),xl=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-6isf2f"&&(P.textContent=cn),$l=n(e),b=i(e,"H2",{class:!0});var Qa=J(b);V=i(Qa,"A",{id:!0,class:!0,href:!0});var Zp=J(V);wl=i(Zp,"SPAN",{});var _p=J(wl);h(D.$$.fragment,_p),_p.forEach(l),Zp.forEach(l),Oa=n(Qa),pl=i(Qa,"SPAN",{"data-svelte-h":!0}),r(pl)!=="svelte-luv5jt"&&(pl.textContent=Mn),Qa.forEach(l),Zl=ai(e,`

Make sure that you have a GPU if you want to reproduce this example. In a notebook, you can check with the following command:

	`),h(L.$$.fragment,e),_l=n(e),h(B.$$.fragment,e),Gl=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-9u3xmt"&&(K.textContent=yn),Vl=n(e),h(O.$$.fragment,e),Bl=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1lsy5mj"&&(ee.textContent=un),Wl=n(e),h(te.$$.fragment,e),Xl=n(e),C=i(e,"H2",{class:!0});var Ea=J(C);W=i(Ea,"A",{id:!0,class:!0,href:!0});var Gp=J(W);Jl=i(Gp,"SPAN",{});var Vp=J(Jl);h(le.$$.fragment,Vp),Vp.forEach(l),Gp.forEach(l),en=n(Ea),il=i(Ea,"SPAN",{"data-svelte-h":!0}),r(il)!=="svelte-124r4mc"&&(il.textContent=mn),Ea.forEach(l),Rl=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1ixb96o"&&(se.innerHTML=dn),Al=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1p30ok7"&&(ae.textContent=wn),Nl=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1soaqfm"&&(ne.textContent=Jn),Yl=n(e),h(pe.$$.fragment,e),Ql=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1mvdyro"&&(ie.innerHTML=Tn),El=n(e),h(re.$$.fragment,e),zl=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1xdebij"&&(oe.textContent=fn),Fl=n(e),h(he.$$.fragment,e),Hl=n(e),I=i(e,"H2",{class:!0});var za=J(I);X=i(za,"A",{id:!0,class:!0,href:!0});var Bp=J(X);Tl=i(Bp,"SPAN",{});var Wp=J(Tl);h(ce.$$.fragment,Wp),Wp.forEach(l),Bp.forEach(l),tn=n(za),rl=i(za,"SPAN",{"data-svelte-h":!0}),r(rl)!=="svelte-17ijcsy"&&(rl.textContent=Un),za.forEach(l),Sl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1k7tad6"&&(Me.textContent=jn),ql=n(e),h(ye.$$.fragment,e),Pl=n(e),g=i(e,"H3",{class:!0});var Fa=J(g);R=i(Fa,"A",{id:!0,class:!0,href:!0});var Xp=J(R);fl=i(Xp,"SPAN",{});var Rp=J(fl);h(ue.$$.fragment,Rp),Rp.forEach(l),Xp.forEach(l),ln=n(Fa),ol=i(Fa,"SPAN",{"data-svelte-h":!0}),r(ol)!=="svelte-8ognmd"&&(ol.textContent=bn),Fa.forEach(l),Dl=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-a1pl49"&&(me.textContent=Cn),Ll=n(e),h(de.$$.fragment,e),Kl=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-17epgem"&&(we.textContent=In),Ol=n(e),h(Je.$$.fragment,e),es=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1mvdyro"&&(Te.innerHTML=gn),ts=n(e),h(fe.$$.fragment,e),ls=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-y5gqfm"&&(Ue.innerHTML=kn),ss=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1qiuc1m"&&(je.innerHTML=vn),as=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-19dff1r"&&(be.innerHTML=xn),ns=n(e),h(Ce.$$.fragment,e),ps=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-fefaym"&&(Ie.textContent=$n),is=n(e),h(ge.$$.fragment,e),rs=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1mvdyro"&&(ke.innerHTML=Zn),os=n(e),h(ve.$$.fragment,e),hs=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-akzhx6"&&(xe.innerHTML=_n),cs=n(e),h($e.$$.fragment,e),Ms=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-hhu8o3"&&(Ze.textContent=Gn),ys=n(e),k=i(e,"H3",{class:!0});var Ha=J(k);A=i(Ha,"A",{id:!0,class:!0,href:!0});var Ap=J(A);Ul=i(Ap,"SPAN",{});var Np=J(Ul);h(_e.$$.fragment,Np),Np.forEach(l),Ap.forEach(l),sn=n(Ha),hl=i(Ha,"SPAN",{"data-svelte-h":!0}),r(hl)!=="svelte-1djgoy3"&&(hl.textContent=Vn),Ha.forEach(l),us=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1edo483"&&(Ge.textContent=Bn),ms=n(e),h(Ve.$$.fragment,e),ds=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1hah56a"&&(Be.textContent=Wn),ws=n(e),h(We.$$.fragment,e),Js=n(e),N=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(N)!=="svelte-1uufiik"&&(N.innerHTML=Xn),Ts=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1ujf40"&&(Xe.textContent=Rn),fs=n(e),h(Re.$$.fragment,e),Us=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-g2dd32"&&(Ae.textContent=An),js=n(e),h(Ne.$$.fragment,e),bs=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1mvdyro"&&(Ye.innerHTML=Nn),Cs=n(e),h(Qe.$$.fragment,e),Is=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-hbes5t"&&(Ee.textContent=Yn),gs=n(e),h(ze.$$.fragment,e),ks=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1mvdyro"&&(Fe.innerHTML=Qn),vs=n(e),h(He.$$.fragment,e),xs=n(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-oizlk1"&&(Se.textContent=En),$s=n(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1n0u7fp"&&(qe.textContent=zn),Zs=n(e),v=i(e,"H3",{class:!0});var Sa=J(v);Y=i(Sa,"A",{id:!0,class:!0,href:!0});var Yp=J(Y);jl=i(Yp,"SPAN",{});var Qp=J(jl);h(Pe.$$.fragment,Qp),Qp.forEach(l),Yp.forEach(l),an=n(Sa),cl=i(Sa,"SPAN",{"data-svelte-h":!0}),r(cl)!=="svelte-11a8qqy"&&(cl.textContent=Fn),Sa.forEach(l),_s=n(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1xdfpy2"&&(De.innerHTML=Hn),Gs=n(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-7nncma"&&(Le.innerHTML=Sn),Vs=n(e),h(Ke.$$.fragment,e),Bs=n(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1mtxkxr"&&(Oe.innerHTML=qn),Ws=n(e),et=i(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-15ol8sg"&&(et.innerHTML=Pn),Xs=n(e),x=i(e,"H3",{class:!0});var qa=J(x);Q=i(qa,"A",{id:!0,class:!0,href:!0});var Ep=J(Q);bl=i(Ep,"SPAN",{});var zp=J(bl);h(tt.$$.fragment,zp),zp.forEach(l),Ep.forEach(l),nn=n(qa),Ml=i(qa,"SPAN",{"data-svelte-h":!0}),r(Ml)!=="svelte-yn1vvh"&&(Ml.textContent=Dn),qa.forEach(l),Rs=n(e),lt=i(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1tlidee"&&(lt.innerHTML=Ln),As=n(e),h(st.$$.fragment,e),Ns=n(e),at=i(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-17mzfft"&&(at.textContent=Kn),Ys=n(e),h(nt.$$.fragment,e),Qs=n(e),pt=i(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1mvdyro"&&(pt.innerHTML=On),Es=n(e),h(it.$$.fragment,e),zs=n(e),rt=i(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1mqg4ck"&&(rt.textContent=ep),Fs=n(e),h(ot.$$.fragment,e),Hs=n(e),ht=i(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1mvdyro"&&(ht.innerHTML=tp),Ss=n(e),h(ct.$$.fragment,e),qs=n(e),Mt=i(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-f7g58h"&&(Mt.textContent=lp),Ps=n(e),h(yt.$$.fragment,e),Ds=n(e),E=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(E)!=="svelte-j4o1b8"&&(E.innerHTML=sp),Ls=n(e),ut=i(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1t9vz0y"&&(ut.textContent=ap),Ks=n(e),mt=i(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-7crb3r"&&(mt.textContent=np),Os=n(e),h(dt.$$.fragment,e),ea=n(e),wt=i(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-wvyh3r"&&(wt.textContent=pp),ta=n(e),h(Jt.$$.fragment,e),la=n(e),Tt=i(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1mvdyro"&&(Tt.innerHTML=ip),sa=n(e),h(ft.$$.fragment,e),aa=n(e),Ut=i(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-12gx63x"&&(Ut.textContent=rp),na=n(e),h(jt.$$.fragment,e),pa=n(e),$=i(e,"H3",{class:!0});var Pa=J($);z=i(Pa,"A",{id:!0,class:!0,href:!0});var Fp=J(z);Cl=i(Fp,"SPAN",{});var Hp=J(Cl);h(bt.$$.fragment,Hp),Hp.forEach(l),Fp.forEach(l),pn=n(Pa),yl=i(Pa,"SPAN",{"data-svelte-h":!0}),r(yl)!=="svelte-a1w05"&&(yl.textContent=op),Pa.forEach(l),ia=n(e),Ct=i(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-rsy2my"&&(Ct.innerHTML=hp),ra=n(e),h(It.$$.fragment,e),oa=n(e),gt=i(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-u623yc"&&(gt.textContent=cp),ha=n(e),h(kt.$$.fragment,e),ca=n(e),Z=i(e,"H2",{class:!0});var Da=J(Z);F=i(Da,"A",{id:!0,class:!0,href:!0});var Sp=J(F);Il=i(Sp,"SPAN",{});var qp=J(Il);h(vt.$$.fragment,qp),qp.forEach(l),Sp.forEach(l),rn=n(Da),ul=i(Da,"SPAN",{"data-svelte-h":!0}),r(ul)!=="svelte-n13n3f"&&(ul.textContent=Mp),Da.forEach(l),Ma=n(e),xt=i(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1kkriue"&&(xt.textContent=yp),ya=n(e),h($t.$$.fragment,e),ua=n(e),Zt=i(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1fpvhw6"&&(Zt.innerHTML=up),ma=n(e),h(_t.$$.fragment,e),da=n(e),Gt=i(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1af5qye"&&(Gt.textContent=mp),wa=n(e),h(Vt.$$.fragment,e),Ja=n(e),Bt=i(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1yq1u47"&&(Bt.innerHTML=dp),Ta=n(e),h(Wt.$$.fragment,e),fa=n(e),Xt=i(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-98ddde"&&(Xt.innerHTML=wp),Ua=n(e),h(Rt.$$.fragment,e),ja=n(e),At=i(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-hefgo2"&&(At.textContent=Jp),ba=n(e),h(Nt.$$.fragment,e),Ca=n(e),_=i(e,"H2",{class:!0});var La=J(_);H=i(La,"A",{id:!0,class:!0,href:!0});var Pp=J(H);gl=i(Pp,"SPAN",{});var Dp=J(gl);h(Yt.$$.fragment,Dp),Dp.forEach(l),Pp.forEach(l),on=n(La),ml=i(La,"SPAN",{"data-svelte-h":!0}),r(ml)!=="svelte-199uz7g"&&(ml.textContent=Tp),La.forEach(l),Ia=n(e),Qt=i(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-vqys4o"&&(Qt.textContent=fp),ga=n(e),h(Et.$$.fragment,e),ka=n(e),zt=i(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-kiuzrb"&&(zt.textContent=Up),va=n(e),h(Ft.$$.fragment,e),xa=n(e),Ht=i(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-1sn5mu7"&&(Ht.textContent=jp),$a=n(e),h(St.$$.fragment,e),Za=n(e),qt=i(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-1sf6bxe"&&(qt.textContent=bp),_a=n(e),h(Pt.$$.fragment,e),Ga=n(e),Dt=i(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1kfdmvn"&&(Dt.textContent=Cp),Va=n(e),h(Lt.$$.fragment,e),Ba=n(e),Kt=i(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-jp0xjb"&&(Kt.textContent=Ip),Wa=n(e),h(Ot.$$.fragment,e),Xa=n(e),el=i(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-yji0sl"&&(el.textContent=gp),Ra=n(e),tl=i(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-6lmfh0"&&(tl.innerHTML=kp),Aa=n(e),ll=i(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-bv2cz9"&&(ll.textContent=vp),Na=n(e),kl=i(e,"P",{}),J(kl).forEach(l),this.h()},h(){m(T,"name","hf:doc:metadata"),m(T,"content",JSON.stringify(ri)),m(G,"id","finetuning-speecht5"),m(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(G,"href","#finetuning-speecht5"),m(j,"class","relative group"),m(V,"id","housekeeping"),m(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(V,"href","#housekeeping"),m(b,"class","relative group"),m(W,"id","the-dataset"),m(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(W,"href","#the-dataset"),m(C,"class","relative group"),m(X,"id","preprocessing-the-data"),m(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(X,"href","#preprocessing-the-data"),m(I,"class","relative group"),m(R,"id","text-cleanup-for-speecht5-tokenization"),m(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(R,"href","#text-cleanup-for-speecht5-tokenization"),m(g,"class","relative group"),m(A,"id","speakers"),m(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(A,"href","#speakers"),m(k,"class","relative group"),m(N,"class","flex justify-center"),m(Y,"id","speaker-embeddings"),m(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Y,"href","#speaker-embeddings"),m(v,"class","relative group"),m(Q,"id","processing-the-dataset"),m(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Q,"href","#processing-the-dataset"),m(x,"class","relative group"),m(E,"class","flex justify-center"),m(z,"id","data-collator"),m(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(z,"href","#data-collator"),m($,"class","relative group"),m(F,"id","train-the-model"),m(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(F,"href","#train-the-model"),m(Z,"class","relative group"),m(H,"id","inference"),m(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(H,"href","#inference"),m(_,"class","relative group")},m(e,t){w(document.head,T),s(e,S,t),s(e,f,t),s(e,al,t),s(e,j,t),w(j,G),w(G,dl),c(q,dl,null),w(j,Ka),w(j,nl),s(e,xl,t),s(e,P,t),s(e,$l,t),s(e,b,t),w(b,V),w(V,wl),c(D,wl,null),w(b,Oa),w(b,pl),s(e,Zl,t),c(L,e,t),s(e,_l,t),c(B,e,t),s(e,Gl,t),s(e,K,t),s(e,Vl,t),c(O,e,t),s(e,Bl,t),s(e,ee,t),s(e,Wl,t),c(te,e,t),s(e,Xl,t),s(e,C,t),w(C,W),w(W,Jl),c(le,Jl,null),w(C,en),w(C,il),s(e,Rl,t),s(e,se,t),s(e,Al,t),s(e,ae,t),s(e,Nl,t),s(e,ne,t),s(e,Yl,t),c(pe,e,t),s(e,Ql,t),s(e,ie,t),s(e,El,t),c(re,e,t),s(e,zl,t),s(e,oe,t),s(e,Fl,t),c(he,e,t),s(e,Hl,t),s(e,I,t),w(I,X),w(X,Tl),c(ce,Tl,null),w(I,tn),w(I,rl),s(e,Sl,t),s(e,Me,t),s(e,ql,t),c(ye,e,t),s(e,Pl,t),s(e,g,t),w(g,R),w(R,fl),c(ue,fl,null),w(g,ln),w(g,ol),s(e,Dl,t),s(e,me,t),s(e,Ll,t),c(de,e,t),s(e,Kl,t),s(e,we,t),s(e,Ol,t),c(Je,e,t),s(e,es,t),s(e,Te,t),s(e,ts,t),c(fe,e,t),s(e,ls,t),s(e,Ue,t),s(e,ss,t),s(e,je,t),s(e,as,t),s(e,be,t),s(e,ns,t),c(Ce,e,t),s(e,ps,t),s(e,Ie,t),s(e,is,t),c(ge,e,t),s(e,rs,t),s(e,ke,t),s(e,os,t),c(ve,e,t),s(e,hs,t),s(e,xe,t),s(e,cs,t),c($e,e,t),s(e,Ms,t),s(e,Ze,t),s(e,ys,t),s(e,k,t),w(k,A),w(A,Ul),c(_e,Ul,null),w(k,sn),w(k,hl),s(e,us,t),s(e,Ge,t),s(e,ms,t),c(Ve,e,t),s(e,ds,t),s(e,Be,t),s(e,ws,t),c(We,e,t),s(e,Js,t),s(e,N,t),s(e,Ts,t),s(e,Xe,t),s(e,fs,t),c(Re,e,t),s(e,Us,t),s(e,Ae,t),s(e,js,t),c(Ne,e,t),s(e,bs,t),s(e,Ye,t),s(e,Cs,t),c(Qe,e,t),s(e,Is,t),s(e,Ee,t),s(e,gs,t),c(ze,e,t),s(e,ks,t),s(e,Fe,t),s(e,vs,t),c(He,e,t),s(e,xs,t),s(e,Se,t),s(e,$s,t),s(e,qe,t),s(e,Zs,t),s(e,v,t),w(v,Y),w(Y,jl),c(Pe,jl,null),w(v,an),w(v,cl),s(e,_s,t),s(e,De,t),s(e,Gs,t),s(e,Le,t),s(e,Vs,t),c(Ke,e,t),s(e,Bs,t),s(e,Oe,t),s(e,Ws,t),s(e,et,t),s(e,Xs,t),s(e,x,t),w(x,Q),w(Q,bl),c(tt,bl,null),w(x,nn),w(x,Ml),s(e,Rs,t),s(e,lt,t),s(e,As,t),c(st,e,t),s(e,Ns,t),s(e,at,t),s(e,Ys,t),c(nt,e,t),s(e,Qs,t),s(e,pt,t),s(e,Es,t),c(it,e,t),s(e,zs,t),s(e,rt,t),s(e,Fs,t),c(ot,e,t),s(e,Hs,t),s(e,ht,t),s(e,Ss,t),c(ct,e,t),s(e,qs,t),s(e,Mt,t),s(e,Ps,t),c(yt,e,t),s(e,Ds,t),s(e,E,t),s(e,Ls,t),s(e,ut,t),s(e,Ks,t),s(e,mt,t),s(e,Os,t),c(dt,e,t),s(e,ea,t),s(e,wt,t),s(e,ta,t),c(Jt,e,t),s(e,la,t),s(e,Tt,t),s(e,sa,t),c(ft,e,t),s(e,aa,t),s(e,Ut,t),s(e,na,t),c(jt,e,t),s(e,pa,t),s(e,$,t),w($,z),w(z,Cl),c(bt,Cl,null),w($,pn),w($,yl),s(e,ia,t),s(e,Ct,t),s(e,ra,t),c(It,e,t),s(e,oa,t),s(e,gt,t),s(e,ha,t),c(kt,e,t),s(e,ca,t),s(e,Z,t),w(Z,F),w(F,Il),c(vt,Il,null),w(Z,rn),w(Z,ul),s(e,Ma,t),s(e,xt,t),s(e,ya,t),c($t,e,t),s(e,ua,t),s(e,Zt,t),s(e,ma,t),c(_t,e,t),s(e,da,t),s(e,Gt,t),s(e,wa,t),c(Vt,e,t),s(e,Ja,t),s(e,Bt,t),s(e,Ta,t),c(Wt,e,t),s(e,fa,t),s(e,Xt,t),s(e,Ua,t),c(Rt,e,t),s(e,ja,t),s(e,At,t),s(e,ba,t),c(Nt,e,t),s(e,Ca,t),s(e,_,t),w(_,H),w(H,gl),c(Yt,gl,null),w(_,on),w(_,ml),s(e,Ia,t),s(e,Qt,t),s(e,ga,t),c(Et,e,t),s(e,ka,t),s(e,zt,t),s(e,va,t),c(Ft,e,t),s(e,xa,t),s(e,Ht,t),s(e,$a,t),c(St,e,t),s(e,Za,t),s(e,qt,t),s(e,_a,t),c(Pt,e,t),s(e,Ga,t),s(e,Dt,t),s(e,Va,t),c(Lt,e,t),s(e,Ba,t),s(e,Kt,t),s(e,Wa,t),c(Ot,e,t),s(e,Xa,t),s(e,el,t),s(e,Ra,t),s(e,tl,t),s(e,Aa,t),s(e,ll,t),s(e,Na,t),s(e,kl,t),Ya=!0},p(e,[t]){const sl={};t&2&&(sl.$$scope={dirty:t,ctx:e}),B.$set(sl)},i(e){Ya||(M(q.$$.fragment,e),M(D.$$.fragment,e),M(L.$$.fragment,e),M(B.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(pe.$$.fragment,e),M(re.$$.fragment,e),M(he.$$.fragment,e),M(ce.$$.fragment,e),M(ye.$$.fragment,e),M(ue.$$.fragment,e),M(de.$$.fragment,e),M(Je.$$.fragment,e),M(fe.$$.fragment,e),M(Ce.$$.fragment,e),M(ge.$$.fragment,e),M(ve.$$.fragment,e),M($e.$$.fragment,e),M(_e.$$.fragment,e),M(Ve.$$.fragment,e),M(We.$$.fragment,e),M(Re.$$.fragment,e),M(Ne.$$.fragment,e),M(Qe.$$.fragment,e),M(ze.$$.fragment,e),M(He.$$.fragment,e),M(Pe.$$.fragment,e),M(Ke.$$.fragment,e),M(tt.$$.fragment,e),M(st.$$.fragment,e),M(nt.$$.fragment,e),M(it.$$.fragment,e),M(ot.$$.fragment,e),M(ct.$$.fragment,e),M(yt.$$.fragment,e),M(dt.$$.fragment,e),M(Jt.$$.fragment,e),M(ft.$$.fragment,e),M(jt.$$.fragment,e),M(bt.$$.fragment,e),M(It.$$.fragment,e),M(kt.$$.fragment,e),M(vt.$$.fragment,e),M($t.$$.fragment,e),M(_t.$$.fragment,e),M(Vt.$$.fragment,e),M(Wt.$$.fragment,e),M(Rt.$$.fragment,e),M(Nt.$$.fragment,e),M(Yt.$$.fragment,e),M(Et.$$.fragment,e),M(Ft.$$.fragment,e),M(St.$$.fragment,e),M(Pt.$$.fragment,e),M(Lt.$$.fragment,e),M(Ot.$$.fragment,e),Ya=!0)},o(e){y(q.$$.fragment,e),y(D.$$.fragment,e),y(L.$$.fragment,e),y(B.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(le.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(he.$$.fragment,e),y(ce.$$.fragment,e),y(ye.$$.fragment,e),y(ue.$$.fragment,e),y(de.$$.fragment,e),y(Je.$$.fragment,e),y(fe.$$.fragment,e),y(Ce.$$.fragment,e),y(ge.$$.fragment,e),y(ve.$$.fragment,e),y($e.$$.fragment,e),y(_e.$$.fragment,e),y(Ve.$$.fragment,e),y(We.$$.fragment,e),y(Re.$$.fragment,e),y(Ne.$$.fragment,e),y(Qe.$$.fragment,e),y(ze.$$.fragment,e),y(He.$$.fragment,e),y(Pe.$$.fragment,e),y(Ke.$$.fragment,e),y(tt.$$.fragment,e),y(st.$$.fragment,e),y(nt.$$.fragment,e),y(it.$$.fragment,e),y(ot.$$.fragment,e),y(ct.$$.fragment,e),y(yt.$$.fragment,e),y(dt.$$.fragment,e),y(Jt.$$.fragment,e),y(ft.$$.fragment,e),y(jt.$$.fragment,e),y(bt.$$.fragment,e),y(It.$$.fragment,e),y(kt.$$.fragment,e),y(vt.$$.fragment,e),y($t.$$.fragment,e),y(_t.$$.fragment,e),y(Vt.$$.fragment,e),y(Wt.$$.fragment,e),y(Rt.$$.fragment,e),y(Nt.$$.fragment,e),y(Yt.$$.fragment,e),y(Et.$$.fragment,e),y(Ft.$$.fragment,e),y(St.$$.fragment,e),y(Pt.$$.fragment,e),y(Lt.$$.fragment,e),y(Ot.$$.fragment,e),Ya=!1},d(e){e&&(l(S),l(f),l(al),l(j),l(xl),l(P),l($l),l(b),l(Zl),l(_l),l(Gl),l(K),l(Vl),l(Bl),l(ee),l(Wl),l(Xl),l(C),l(Rl),l(se),l(Al),l(ae),l(Nl),l(ne),l(Yl),l(Ql),l(ie),l(El),l(zl),l(oe),l(Fl),l(Hl),l(I),l(Sl),l(Me),l(ql),l(Pl),l(g),l(Dl),l(me),l(Ll),l(Kl),l(we),l(Ol),l(es),l(Te),l(ts),l(ls),l(Ue),l(ss),l(je),l(as),l(be),l(ns),l(ps),l(Ie),l(is),l(rs),l(ke),l(os),l(hs),l(xe),l(cs),l(Ms),l(Ze),l(ys),l(k),l(us),l(Ge),l(ms),l(ds),l(Be),l(ws),l(Js),l(N),l(Ts),l(Xe),l(fs),l(Us),l(Ae),l(js),l(bs),l(Ye),l(Cs),l(Is),l(Ee),l(gs),l(ks),l(Fe),l(vs),l(xs),l(Se),l($s),l(qe),l(Zs),l(v),l(_s),l(De),l(Gs),l(Le),l(Vs),l(Bs),l(Oe),l(Ws),l(et),l(Xs),l(x),l(Rs),l(lt),l(As),l(Ns),l(at),l(Ys),l(Qs),l(pt),l(Es),l(zs),l(rt),l(Fs),l(Hs),l(ht),l(Ss),l(qs),l(Mt),l(Ps),l(Ds),l(E),l(Ls),l(ut),l(Ks),l(mt),l(Os),l(ea),l(wt),l(ta),l(la),l(Tt),l(sa),l(aa),l(Ut),l(na),l(pa),l($),l(ia),l(Ct),l(ra),l(oa),l(gt),l(ha),l(ca),l(Z),l(Ma),l(xt),l(ya),l(ua),l(Zt),l(ma),l(da),l(Gt),l(wa),l(Ja),l(Bt),l(Ta),l(fa),l(Xt),l(Ua),l(ja),l(At),l(ba),l(Ca),l(_),l(Ia),l(Qt),l(ga),l(ka),l(zt),l(va),l(xa),l(Ht),l($a),l(Za),l(qt),l(_a),l(Ga),l(Dt),l(Va),l(Ba),l(Kt),l(Wa),l(Xa),l(el),l(Ra),l(tl),l(Aa),l(ll),l(Na),l(kl)),l(T),u(q),u(D),u(L,e),u(B,e),u(O,e),u(te,e),u(le),u(pe,e),u(re,e),u(he,e),u(ce),u(ye,e),u(ue),u(de,e),u(Je,e),u(fe,e),u(Ce,e),u(ge,e),u(ve,e),u($e,e),u(_e),u(Ve,e),u(We,e),u(Re,e),u(Ne,e),u(Qe,e),u(ze,e),u(He,e),u(Pe),u(Ke,e),u(tt),u(st,e),u(nt,e),u(it,e),u(ot,e),u(ct,e),u(yt,e),u(dt,e),u(Jt,e),u(ft,e),u(jt,e),u(bt),u(It,e),u(kt,e),u(vt),u($t,e),u(_t,e),u(Vt,e),u(Wt,e),u(Rt,e),u(Nt,e),u(Yt),u(Et,e),u(Ft,e),u(St,e),u(Pt,e),u(Lt,e),u(Ot,e)}}}const ri={local:"finetuning-speecht5",sections:[{local:"housekeeping",title:"House-keeping"},{local:"the-dataset",title:"The dataset"},{local:"preprocessing-the-data",sections:[{local:"text-cleanup-for-speecht5-tokenization",title:"Text cleanup for SpeechT5 tokenization"},{local:"speakers",title:"Speakers"},{local:"speaker-embeddings",title:"Speaker embeddings"},{local:"processing-the-dataset",title:"Processing the dataset"},{local:"data-collator",title:"Data collator"}],title:"Preprocessing the data "},{local:"train-the-model",title:"Train the model"},{local:"inference",title:"Inference"}],title:"Fine-tuning SpeechT5"};function oi(vl){return Kp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mi extends ei{constructor(T){super(),ti(this,T,oi,ii,Lp,{})}}export{mi as component};
