import{s as Os,f as ea,o as ta,n as sa}from"../chunks/scheduler.f7e1785c.js";import{S as aa,i as na,g as o,s as n,u as c,A as la,h as i,f as s,c as l,j as T,v as h,y as r,k as p,o as g,a,w as u,d,t as m,x as f,m as oa,n as ia}from"../chunks/index.815a732f.js";import{T as Ds}from"../chunks/Tip.1258ac78.js";import{I as Ae}from"../chunks/IconCopyLink.e7937f56.js";import{C as M}from"../chunks/CodeBlock.c6e8b464.js";function ra(Ne){let y,v=`Whisper can also be ‘tricked’ into translating from speech in any language X to any language Y. Simply set the task to
<code>&quot;transcribe&quot;</code> and the <code>&quot;language&quot;</code> to your target language in the generation key-word arguments,
e.g. for Spanish, one would set:`,b,U,j="<code>generate_kwargs={&quot;task&quot;: &quot;transcribe&quot;, &quot;language&quot;: &quot;es&quot;}</code>";return{c(){y=o("p"),y.innerHTML=v,b=n(),U=o("p"),U.innerHTML=j},l(w){y=i(w,"P",{"data-svelte-h":!0}),r(y)!=="svelte-vga0jc"&&(y.innerHTML=v),b=l(w),U=i(w,"P",{"data-svelte-h":!0}),r(U)!=="svelte-130lm1j"&&(U.innerHTML=j)},m(w,$){a(w,y,$),a(w,b,$),a(w,U,$)},p:sa,d(w){w&&(s(y),s(b),s(U))}}}function pa(Ne){let y;return{c(){y=oa(`Here we're using SpeechT5 checkpoint trained specifically for English TTS. Should you wish to translate into a language 
    other than English, either swap the checkpoint for a SpeechT5 TTS model fine-tuned on your language of choice, or 
    use an MMS TTS checkpoint pre-trained in your target langauge.`)},l(v){y=ia(v,`Here we're using SpeechT5 checkpoint trained specifically for English TTS. Should you wish to translate into a language 
    other than English, either swap the checkpoint for a SpeechT5 TTS model fine-tuned on your language of choice, or 
    use an MMS TTS checkpoint pre-trained in your target langauge.`)},m(v,b){a(v,y,b)},d(v){v&&s(y)}}}function ca(Ne){let y,v,b,U,j,w,$,H,ts,Be,os="Speech-to-speech translation",Pe,X,is=`Speech-to-speech translation (STST or S2ST) is a relatively new spoken language processing task. It involves translating
speech from one langauge into speech in a <strong>different</strong> language:`,Le,Z,rs='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/s2st.png" alt="Diagram of speech to speech translation"/>',Ke,q,ps=`STST can be viewed as an extension of the traditional machine translation (MT) task: instead of translating <strong>text</strong> from one
language into another, we translate <strong>speech</strong> from one language into another. STST holds applications in the field of
multilingual communication, enabling speakers in different languages to communicate with one another through the medium
of speech.`,De,R,cs=`Suppose you want to communicate with another individual across a langauge barrier. Rather
than writing the information that you want to convey and then translating it to text in the target language, you
can speak it directly and have a STST system convert your spoken speech into the target langauge. The recipient can then
respond by speaking back at the STST system, and you can listen to their response. This is a more natural way of communicating
compared to text-based machine translation.`,Oe,Y,hs=`In this chapter, we’ll explore a <em>cascaded</em> approach to STST, piecing together the knowledge you’ve acquired in Units
5 and 6 of the course. We’ll use a <em>speech translation (ST)</em> system to transcribe the source speech into text in the target
language, then <em>text-to-speech (TTS)</em> to generate speech in the target language from the translated text:`,et,G,us='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/s2st_cascaded.png" alt="Diagram of cascaded speech to speech translation"/>',tt,Q,ds=`We could also have used a three stage approach, where first we use an automatic speech recognition (ASR) system to
transcribe the source speech into text in the same language, then machine translation to translate the transcribed text
into the target language, and finally text-to-speech to generate speech in the target language. However, adding more
components to the pipeline lends itself to <em>error propagation</em>, where the errors introduced in one system are compounded
as they flow through the remaining systems, and also increases latency, since inference has to be conducted for more models.`,st,E,ms=`While this cascaded approach to STST is pretty straightforward, it results in very effective STST systems. The three-stage
cascaded system of ASR + MT + TTS was previously used to power many commercial STST products, including <a href="https://ai.googleblog.com/2019/05/introducing-translatotron-end-to-end.html" rel="nofollow">Google Translate</a>.
It’s also a very data and compute efficient way of developing a STST system, since existing speech recognition and
text-to-speech systems can be coupled together to yield a new STST model without any additional training.`,at,F,fs=`In the remainder of this Unit, we’ll focus on creating a STST system that translates speech from any language X to speech
in English. The methods covered can be extended to STST systems that translate from any language X to any
langauge Y, but we leave this as an extension to the reader and provide pointers where applicable. We further divide up the
task of STST into its two constituent components: ST and TTS. We’ll finish by piecing them together to build a Gradio
demo to showcase our system.`,nt,k,I,Re,z,ss,Ve,ys="Speech translation",lt,A,gs=`We’ll use the Whisper model for our speech translation system, since it’s capable of translating from over 96 languages
to English. Specifically, we’ll load the <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> checkpoint, which
clocks in at 74M parameters. It’s by no means the most performant Whisper model, with the <a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">largest Whisper checkpoint</a>
being over 20x larger, but since we’re concatenating two auto-regressive systems together (ST + TTS), we want to ensure
each model can generate relatively quickly so that we get reasonable inference speed:`,ot,P,it,L,ws=`Great! To test our STST system, we’ll load an audio sample in a non-English language. Let’s load the first example of the
Italian (<code>it</code>) split of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset:`,rt,K,pt,D,Ts='To listen to this sample, we can either play it using the dataset viewer on the Hub: <a href="https://huggingface.co/datasets/facebook/voxpopuli/viewer/it/validation?row=0" rel="nofollow">facebook/voxpopuli/viewer</a>',ct,O,Ms="Or playback using the ipynb audio feature:",ht,ee,ut,te,vs=`Now let’s define a function that takes this audio input and returns the translated text. You’ll remember that we have to
pass the generation key-word argument for the <code>&quot;task&quot;</code>, setting it to <code>&quot;translate&quot;</code> to ensure that Whisper performs
speech translation and not speech recognition:`,dt,se,mt,W,ft,ae,Js="Great! Let’s quickly check that we get a sensible result from the model:",yt,ne,gt,le,wt,oe,bs="Alright! If we compare this to the source text:",Tt,ie,Mt,re,vt,pe,Us=`We see that the translation more or less lines up (you can double check this using Google Translate), barring a small
extra few words at the start of the transcription where the speaker was finishing off their previous sentence.`,Jt,ce,js=`With that, we’ve completed the first half of our cascaded STST pipeline, putting into practice the skills we gained in Unit 5
when we learnt how to use the Whisper model for speech recognition and translation. If you want a refresher on any of the
steps we covered, have a read through the section on <a href="../chapter5/asr_models">Pre-trained models for ASR</a> from Unit 5.`,bt,x,_,Ye,he,as,He,$s="Text-to-speech",Ut,ue,ks=`The second half of our cascaded STST system involves mapping from English text to English speech. For this, we’ll use
the pre-trained <a href="https://huggingface.co/microsoft/speecht5_tts" rel="nofollow">SpeechT5 TTS</a> model for English TTS. 🤗 Transformers currently doesn’t
have a TTS <code>pipeline</code>, so we’ll have to use the model directly ourselves. This is no biggie, you’re all experts on using
the model for inference following Unit 6!`,jt,de,xs="First, let’s load the SpeechT5 processor, model and vocoder from the pre-trained checkpoint:",$t,me,kt,N,xt,fe,Ss="As with the Whisper model, we’ll place the SpeechT5 model and vocoder on our GPU accelerator device if we have one:",St,ye,Ct,ge,Cs="Great! Let’s load up the speaker embeddings:",Zt,we,Gt,Te,Zs=`We can now write a function that takes a text prompt as input, and generates the corresponding speech. We’ll first pre-process
the text input using the SpeechT5 processor, tokenizing the text to get our input ids. We’ll then pass the input ids and
speaker embeddings to the SpeechT5 model, placing each on the accelerator device if available. Finally, we’ll return the
generated speech, bringing it back to the CPU so that we can play it back in our ipynb notebook:`,It,Me,Wt,ve,Gs="Let’s check it works with a dummy text input:",_t,Je,Nt,be,Is="Sounds good! Now for the exciting part - piecing it all together.",Bt,S,B,Qe,Ue,ns,Xe,Ws="Creating a STST demo",Vt,je,_s=`Before we create a <a href="https://gradio.app" rel="nofollow">Gradio</a> demo to showcase our STST system, let’s first do a quick sanity check
to make sure we can concatenate the two models, putting an audio sample in and getting an audio sample out. We’ll do
this by concatenating the two functions we defined in the previous two sub-sections, such that we input the source audio
and retrieve the translated text, then synthesise the translated text to get the translated speech. Finally, we’ll convert
the synthesised speech to an <code>int16</code> array, which is the output audio file format expected by Gradio. To do this, we
first have to normalise the audio array by the dynamic range of the target dtype (<code>int16</code>), and then convert from the
default NumPy dtype (<code>float64</code>) to the target dtype (<code>int16</code>):`,Ht,$e,Xt,ke,Ns="Let’s check this concatenated function gives the expected result:",qt,xe,Rt,Se,Bs=`Perfect! Now we’ll wrap this up into a nice Gradio demo so that we can record our source speech using a microphone input
or file input and playback the system’s prediction:`,Yt,Ce,Qt,Ze,Vs="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",Et,J,Hs,Ft,Ge,Xs=`You can <a href="https://huggingface.co/spaces/course-demos/speech-to-speech-translation?duplicate=true" rel="nofollow">duplicate</a> this demo and adapt
it to use a different Whisper checkpoint, a different TTS checkpoint, or relax the constraint of outputting English
speech and follow the tips provide for translating into a langauge of your choice!`,zt,C,V,Ee,Ie,ls,qe,qs="Going forwards",At,We,Rs=`While the cascaded system is a compute and data efficient way of building a STST system, it suffers from the issues of
error propagation and additive latency described above. Recent works have explored a <em>direct</em> approach to STST, one that
does not predict an intermediate text output and instead maps directly from source speech to target speech. These systems
are also capable of retaining the speaking characteristics of the source speaker in the target speech (such a prosody,
pitch and intonation). If you’re interested in finding out more about these systems, check-out the resources listed in
the section on <a href="supplemental_reading">supplemental reading</a>.`,Pt,Fe,Lt;return H=new Ae({}),z=new Ae({}),P=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`}}),K=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmYWNlYm9vayUyRnZveHBvcHVsaSUyMiUyQyUyMCUyMml0JTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;it&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`}}),ee=new M({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),se=new M({props:{code:"ZGVmJTIwdHJhbnNsYXRlKGF1ZGlvKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBwaXBlKGF1ZGlvJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNsYXRlJTIyJTdEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dHMlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">translate</span>(<span class="hljs-params">audio</span>):
    outputs = pipe(audio, max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})
    <span class="hljs-keyword">return</span> outputs[<span class="hljs-string">&quot;text&quot;</span>]`}}),W=new Ds({props:{$$slots:{default:[ra]},$$scope:{ctx:Ne}}}),ne=new M({props:{code:"dHJhbnNsYXRlKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSk=",highlighted:'translate(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())'}}),le=new M({props:{code:"JyUyMHBzeWNob2xvZ2ljYWwlMjBhbmQlMjBzb2NpYWwuJTIwSSUyMHRoaW5rJTIwdGhhdCUyMGl0JTIwaXMlMjBhJTIwdmVyeSUyMGltcG9ydGFudCUyMHN0ZXAlMjBpbiUyMHRoZSUyMGNvbnN0cnVjdGlvbiUyMG9mJTIwYSUyMGp1cmlkaWNhbCUyMHNwYWNlJTIwb2YlMjBmcmVlZG9tJTJDJTIwY2lyY3VsYXRpb24lMjBhbmQlMjBwcm90ZWN0aW9uJTIwb2YlMjByaWdodHMuJw==",highlighted:'<span class="hljs-comment">&#x27; psychological and social. I think that it is a very important step in the construction of a juridical space of freedom, circulation and protection of rights.&#x27;</span>'}}),ie=new M({props:{code:"c2FtcGxlJTVCJTIycmF3X3RleHQlMjIlNUQ=",highlighted:'sample[<span class="hljs-string">&quot;raw_text&quot;</span>]'}}),re=new M({props:{code:"J1BlbnNvJTIwY2hlJTIwcXVlc3RvJTIwc2lhJTIwdW4lMjBwYXNzbyUyMGluJTIwYXZhbnRpJTIwaW1wb3J0YW50ZSUyMG5lbGxhJTIwY29zdHJ1emlvbmUlMjBkaSUyMHVubyUyMHNwYXppbyUyMGdpdXJpZGljbyUyMGRpJTIwbGliZXJ0JUMzJUEwJTIwZGklMjBjaXJjb2xhemlvbmUlMjBlJTIwZGklMjBwcm90ZXppb25lJTIwZGVpJTIwZGlyaXR0aSUyMHBlciUyMGxlJTIwcGVyc29uZSUyMGluJTIwRXVyb3BhLic=",highlighted:'<span class="hljs-comment">&#x27;Penso che questo sia un passo in avanti importante nella costruzione di uno spazio giuridico di libertà di circolazione e di protezione dei diritti per le persone in Europa.&#x27;</span>'}}),he=new Ae({}),me=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTJDJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2glMkMlMjBTcGVlY2hUNUhpZmlHYW4lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTcGVlY2hUNVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3BlZWNodDVfdHRzJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2guZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiklMEF2b2NvZGVyJTIwJTNEJTIwU3BlZWNoVDVIaWZpR2FuLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzcGVlY2h0NV9oaWZpZ2FuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor, SpeechT5ForTextToSpeech, SpeechT5HifiGan

processor = SpeechT5Processor.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)

model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)
vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)`}}),N=new Ds({props:{$$slots:{default:[pa]},$$scope:{ctx:Ne}}}),ye=new M({props:{code:"bW9kZWwudG8oZGV2aWNlKSUwQXZvY29kZXIudG8oZGV2aWNlKQ==",highlighted:`model.to(device)
vocoder.to(device)`}}),we=new M({props:{code:"ZW1iZWRkaW5nc19kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMk1hdHRoaWpzJTJGY211LWFyY3RpYy14dmVjdG9ycyUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC50ZW5zb3IoZW1iZWRkaW5nc19kYXRhc2V0JTVCNzMwNiU1RCU1QiUyMnh2ZWN0b3IlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`embeddings_dataset = load_dataset(<span class="hljs-string">&quot;Matthijs/cmu-arctic-xvectors&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
speaker_embeddings = torch.tensor(embeddings_dataset[<span class="hljs-number">7306</span>][<span class="hljs-string">&quot;xvector&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`}}),Me=new M({props:{code:"ZGVmJTIwc3ludGhlc2lzZSh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC50byhkZXZpY2UpJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzLnRvKGRldmljZSklMkMlMjB2b2NvZGVyJTNEdm9jb2RlciUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVlY2guY3B1KCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">synthesise</span>(<span class="hljs-params">text</span>):
    inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    speech = model.generate_speech(
        inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(device), speaker_embeddings.to(device), vocoder=vocoder
    )
    <span class="hljs-keyword">return</span> speech.cpu()`}}),Je=new M({props:{code:"c3BlZWNoJTIwJTNEJTIwc3ludGhlc2lzZSglMjJIZXklMjB0aGVyZSElMjBUaGlzJTIwaXMlMjBhJTIwdGVzdCElMjIpJTBBJTBBQXVkaW8oc3BlZWNoJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:`speech = synthesise(<span class="hljs-string">&quot;Hey there! This is a test!&quot;</span>)

Audio(speech, rate=<span class="hljs-number">16000</span>)`}}),Ue=new Ae({}),$e=new M({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2R0eXBlJTIwJTNEJTIwbnAuaW50MTYlMEFtYXhfcmFuZ2UlMjAlM0QlMjBucC5paW5mbyh0YXJnZXRfZHR5cGUpLm1heCUwQSUwQSUwQWRlZiUyMHNwZWVjaF90b19zcGVlY2hfdHJhbnNsYXRpb24oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwdHJhbnNsYXRlZF90ZXh0JTIwJTNEJTIwdHJhbnNsYXRlKGF1ZGlvKSUwQSUyMCUyMCUyMCUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMHN5bnRoZXNpc2UodHJhbnNsYXRlZF90ZXh0KSUwQSUyMCUyMCUyMCUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMChzeW50aGVzaXNlZF9zcGVlY2gubnVtcHkoKSUyMColMjBtYXhfcmFuZ2UpLmFzdHlwZShucC5pbnQxNiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxNjAwMCUyQyUyMHN5bnRoZXNpc2VkX3NwZWVjaA==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_dtype = np.int16
max_range = np.iinfo(target_dtype).<span class="hljs-built_in">max</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">speech_to_speech_translation</span>(<span class="hljs-params">audio</span>):
    translated_text = translate(audio)
    synthesised_speech = synthesise(translated_text)
    synthesised_speech = (synthesised_speech.numpy() * max_range).astype(np.int16)
    <span class="hljs-keyword">return</span> <span class="hljs-number">16000</span>, synthesised_speech`}}),xe=new M({props:{code:"c2FtcGxpbmdfcmF0ZSUyQyUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMHNwZWVjaF90b19zcGVlY2hfdHJhbnNsYXRpb24oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQpJTBBJTBBQXVkaW8oc3ludGhlc2lzZWRfc3BlZWNoJTJDJTIwcmF0ZSUzRHNhbXBsaW5nX3JhdGUp",highlighted:`sampling_rate, synthesised_speech = speech_to_speech_translation(sample[<span class="hljs-string">&quot;audio&quot;</span>])

Audio(synthesised_speech, rate=sampling_rate)`}}),Ce=new M({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQW1pY190cmFuc2xhdGUlMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RzcGVlY2hfdG9fc3BlZWNoX3RyYW5zbGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8oc291cmNlJTNEJTIybWljcm9waG9uZSUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJHZW5lcmF0ZWQlMjBTcGVlY2glMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIpJTJDJTBBKSUwQSUwQWZpbGVfdHJhbnNsYXRlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEc3BlZWNoX3RvX3NwZWVjaF90cmFuc2xhdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyUzRGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJHZW5lcmF0ZWQlMjBTcGVlY2glMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIpJTJDJTBBKSUwQSUwQXdpdGglMjBkZW1vJTNBJTBBJTIwJTIwJTIwJTIwZ3IuVGFiYmVkSW50ZXJmYWNlKCU1Qm1pY190cmFuc2xhdGUlMkMlMjBmaWxlX3RyYW5zbGF0ZSU1RCUyQyUyMCU1QiUyMk1pY3JvcGhvbmUlMjIlMkMlMjAlMjJBdWRpbyUyMEZpbGUlMjIlNUQpJTBBJTBBZGVtby5sYXVuY2goZGVidWclM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Blocks()

mic_translate = gr.Interface(
    fn=speech_to_speech_translation,
    inputs=gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Audio(label=<span class="hljs-string">&quot;Generated Speech&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>),
)

file_translate = gr.Interface(
    fn=speech_to_speech_translation,
    inputs=gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Audio(label=<span class="hljs-string">&quot;Generated Speech&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>),
)

<span class="hljs-keyword">with</span> demo:
    gr.TabbedInterface([mic_translate, file_translate], [<span class="hljs-string">&quot;Microphone&quot;</span>, <span class="hljs-string">&quot;Audio File&quot;</span>])

demo.launch(debug=<span class="hljs-literal">True</span>)`}}),Ie=new Ae({}),{c(){y=o("meta"),v=n(),b=o("p"),U=n(),j=o("h1"),w=o("a"),$=o("span"),c(H.$$.fragment),ts=n(),Be=o("span"),Be.textContent=os,Pe=n(),X=o("p"),X.innerHTML=is,Le=n(),Z=o("div"),Z.innerHTML=rs,Ke=n(),q=o("p"),q.innerHTML=ps,De=n(),R=o("p"),R.textContent=cs,Oe=n(),Y=o("p"),Y.innerHTML=hs,et=n(),G=o("div"),G.innerHTML=us,tt=n(),Q=o("p"),Q.innerHTML=ds,st=n(),E=o("p"),E.innerHTML=ms,at=n(),F=o("p"),F.textContent=fs,nt=n(),k=o("h2"),I=o("a"),Re=o("span"),c(z.$$.fragment),ss=n(),Ve=o("span"),Ve.textContent=ys,lt=n(),A=o("p"),A.innerHTML=gs,ot=n(),c(P.$$.fragment),it=n(),L=o("p"),L.innerHTML=ws,rt=n(),c(K.$$.fragment),pt=n(),D=o("p"),D.innerHTML=Ts,ct=n(),O=o("p"),O.textContent=Ms,ht=n(),c(ee.$$.fragment),ut=n(),te=o("p"),te.innerHTML=vs,dt=n(),c(se.$$.fragment),mt=n(),c(W.$$.fragment),ft=n(),ae=o("p"),ae.textContent=Js,yt=n(),c(ne.$$.fragment),gt=n(),c(le.$$.fragment),wt=n(),oe=o("p"),oe.textContent=bs,Tt=n(),c(ie.$$.fragment),Mt=n(),c(re.$$.fragment),vt=n(),pe=o("p"),pe.textContent=Us,Jt=n(),ce=o("p"),ce.innerHTML=js,bt=n(),x=o("h2"),_=o("a"),Ye=o("span"),c(he.$$.fragment),as=n(),He=o("span"),He.textContent=$s,Ut=n(),ue=o("p"),ue.innerHTML=ks,jt=n(),de=o("p"),de.textContent=xs,$t=n(),c(me.$$.fragment),kt=n(),c(N.$$.fragment),xt=n(),fe=o("p"),fe.textContent=Ss,St=n(),c(ye.$$.fragment),Ct=n(),ge=o("p"),ge.textContent=Cs,Zt=n(),c(we.$$.fragment),Gt=n(),Te=o("p"),Te.textContent=Zs,It=n(),c(Me.$$.fragment),Wt=n(),ve=o("p"),ve.textContent=Gs,_t=n(),c(Je.$$.fragment),Nt=n(),be=o("p"),be.textContent=Is,Bt=n(),S=o("h2"),B=o("a"),Qe=o("span"),c(Ue.$$.fragment),ns=n(),Xe=o("span"),Xe.textContent=Ws,Vt=n(),je=o("p"),je.innerHTML=_s,Ht=n(),c($e.$$.fragment),Xt=n(),ke=o("p"),ke.textContent=Ns,qt=n(),c(xe.$$.fragment),Rt=n(),Se=o("p"),Se.textContent=Bs,Yt=n(),c(Ce.$$.fragment),Qt=n(),Ze=o("p"),Ze.textContent=Vs,Et=n(),J=o("iframe"),Ft=n(),Ge=o("p"),Ge.innerHTML=Xs,zt=n(),C=o("h2"),V=o("a"),Ee=o("span"),c(Ie.$$.fragment),ls=n(),qe=o("span"),qe.textContent=qs,At=n(),We=o("p"),We.innerHTML=Rs,Pt=n(),Fe=o("p"),this.h()},l(e){const t=la("svelte-1phssyn",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(s),v=l(e),b=i(e,"P",{}),T(b).forEach(s),U=l(e),j=i(e,"H1",{class:!0});var _e=T(j);w=i(_e,"A",{id:!0,class:!0,href:!0});var ze=T(w);$=i(ze,"SPAN",{});var Ys=T($);h(H.$$.fragment,Ys),Ys.forEach(s),ze.forEach(s),ts=l(_e),Be=i(_e,"SPAN",{"data-svelte-h":!0}),r(Be)!=="svelte-ru1j0z"&&(Be.textContent=os),_e.forEach(s),Pe=l(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-xrl39y"&&(X.innerHTML=is),Le=l(e),Z=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-1q8w6r1"&&(Z.innerHTML=rs),Ke=l(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1r1gucv"&&(q.innerHTML=ps),De=l(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1g3p1ee"&&(R.textContent=cs),Oe=l(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-16kqqhy"&&(Y.innerHTML=hs),et=l(e),G=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-55g36w"&&(G.innerHTML=us),tt=l(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-17ui3zo"&&(Q.innerHTML=ds),st=l(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-oqffa8"&&(E.innerHTML=ms),at=l(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1jnkkhd"&&(F.textContent=fs),nt=l(e),k=i(e,"H2",{class:!0});var Kt=T(k);I=i(Kt,"A",{id:!0,class:!0,href:!0});var Qs=T(I);Re=i(Qs,"SPAN",{});var Es=T(Re);h(z.$$.fragment,Es),Es.forEach(s),Qs.forEach(s),ss=l(Kt),Ve=i(Kt,"SPAN",{"data-svelte-h":!0}),r(Ve)!=="svelte-bo5mtq"&&(Ve.textContent=ys),Kt.forEach(s),lt=l(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1d2no8a"&&(A.innerHTML=gs),ot=l(e),h(P.$$.fragment,e),it=l(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1s7hzub"&&(L.innerHTML=ws),rt=l(e),h(K.$$.fragment,e),pt=l(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-veyz1i"&&(D.innerHTML=Ts),ct=l(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-txz4z7"&&(O.textContent=Ms),ht=l(e),h(ee.$$.fragment,e),ut=l(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-uzvw8l"&&(te.innerHTML=vs),dt=l(e),h(se.$$.fragment,e),mt=l(e),h(W.$$.fragment,e),ft=l(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-dz3cev"&&(ae.textContent=Js),yt=l(e),h(ne.$$.fragment,e),gt=l(e),h(le.$$.fragment,e),wt=l(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1j8a6ju"&&(oe.textContent=bs),Tt=l(e),h(ie.$$.fragment,e),Mt=l(e),h(re.$$.fragment,e),vt=l(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-wp88n3"&&(pe.textContent=Us),Jt=l(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-k7dh1z"&&(ce.innerHTML=js),bt=l(e),x=i(e,"H2",{class:!0});var Dt=T(x);_=i(Dt,"A",{id:!0,class:!0,href:!0});var Fs=T(_);Ye=i(Fs,"SPAN",{});var zs=T(Ye);h(he.$$.fragment,zs),zs.forEach(s),Fs.forEach(s),as=l(Dt),He=i(Dt,"SPAN",{"data-svelte-h":!0}),r(He)!=="svelte-4cff0p"&&(He.textContent=$s),Dt.forEach(s),Ut=l(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1xzib0a"&&(ue.innerHTML=ks),jt=l(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-d9cpp9"&&(de.textContent=xs),$t=l(e),h(me.$$.fragment,e),kt=l(e),h(N.$$.fragment,e),xt=l(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-2glor5"&&(fe.textContent=Ss),St=l(e),h(ye.$$.fragment,e),Ct=l(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-f6jrhm"&&(ge.textContent=Cs),Zt=l(e),h(we.$$.fragment,e),Gt=l(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1hvsx4q"&&(Te.textContent=Zs),It=l(e),h(Me.$$.fragment,e),Wt=l(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-i24jqg"&&(ve.textContent=Gs),_t=l(e),h(Je.$$.fragment,e),Nt=l(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-e3hzpi"&&(be.textContent=Is),Bt=l(e),S=i(e,"H2",{class:!0});var Ot=T(S);B=i(Ot,"A",{id:!0,class:!0,href:!0});var As=T(B);Qe=i(As,"SPAN",{});var Ps=T(Qe);h(Ue.$$.fragment,Ps),Ps.forEach(s),As.forEach(s),ns=l(Ot),Xe=i(Ot,"SPAN",{"data-svelte-h":!0}),r(Xe)!=="svelte-3231ss"&&(Xe.textContent=Ws),Ot.forEach(s),Vt=l(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-17w2mjs"&&(je.innerHTML=_s),Ht=l(e),h($e.$$.fragment,e),Xt=l(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1a1frzk"&&(ke.textContent=Ns),qt=l(e),h(xe.$$.fragment,e),Rt=l(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1f76kv1"&&(Se.textContent=Bs),Yt=l(e),h(Ce.$$.fragment,e),Qt=l(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-10sf4ix"&&(Ze.textContent=Vs),Et=l(e),J=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),T(J).forEach(s),Ft=l(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1arc8ys"&&(Ge.innerHTML=Xs),zt=l(e),C=i(e,"H2",{class:!0});var es=T(C);V=i(es,"A",{id:!0,class:!0,href:!0});var Ls=T(V);Ee=i(Ls,"SPAN",{});var Ks=T(Ee);h(Ie.$$.fragment,Ks),Ks.forEach(s),Ls.forEach(s),ls=l(es),qe=i(es,"SPAN",{"data-svelte-h":!0}),r(qe)!=="svelte-lka7g1"&&(qe.textContent=qs),es.forEach(s),At=l(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-9tvm6n"&&(We.innerHTML=Rs),Pt=l(e),Fe=i(e,"P",{}),T(Fe).forEach(s),this.h()},h(){p(y,"name","hf:doc:metadata"),p(y,"content",JSON.stringify(ha)),p(w,"id","speechtospeech-translation"),p(w,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(w,"href","#speechtospeech-translation"),p(j,"class","relative group"),p(Z,"class","flex justify-center"),p(G,"class","flex justify-center"),p(I,"id","speech-translation"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#speech-translation"),p(k,"class","relative group"),p(_,"id","texttospeech"),p(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(_,"href","#texttospeech"),p(x,"class","relative group"),p(B,"id","creating-a-stst-demo"),p(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(B,"href","#creating-a-stst-demo"),p(S,"class","relative group"),ea(J.src,Hs="https://course-demos-speech-to-speech-translation.hf.space")||p(J,"src",Hs),p(J,"frameborder","0"),p(J,"height","450"),p(J,"title","Gradio app"),p(J,"class","container p-0 flex-grow space-iframe"),p(J,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(J,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),p(V,"id","going-forwards"),p(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(V,"href","#going-forwards"),p(C,"class","relative group")},m(e,t){g(document.head,y),a(e,v,t),a(e,b,t),a(e,U,t),a(e,j,t),g(j,w),g(w,$),u(H,$,null),g(j,ts),g(j,Be),a(e,Pe,t),a(e,X,t),a(e,Le,t),a(e,Z,t),a(e,Ke,t),a(e,q,t),a(e,De,t),a(e,R,t),a(e,Oe,t),a(e,Y,t),a(e,et,t),a(e,G,t),a(e,tt,t),a(e,Q,t),a(e,st,t),a(e,E,t),a(e,at,t),a(e,F,t),a(e,nt,t),a(e,k,t),g(k,I),g(I,Re),u(z,Re,null),g(k,ss),g(k,Ve),a(e,lt,t),a(e,A,t),a(e,ot,t),u(P,e,t),a(e,it,t),a(e,L,t),a(e,rt,t),u(K,e,t),a(e,pt,t),a(e,D,t),a(e,ct,t),a(e,O,t),a(e,ht,t),u(ee,e,t),a(e,ut,t),a(e,te,t),a(e,dt,t),u(se,e,t),a(e,mt,t),u(W,e,t),a(e,ft,t),a(e,ae,t),a(e,yt,t),u(ne,e,t),a(e,gt,t),u(le,e,t),a(e,wt,t),a(e,oe,t),a(e,Tt,t),u(ie,e,t),a(e,Mt,t),u(re,e,t),a(e,vt,t),a(e,pe,t),a(e,Jt,t),a(e,ce,t),a(e,bt,t),a(e,x,t),g(x,_),g(_,Ye),u(he,Ye,null),g(x,as),g(x,He),a(e,Ut,t),a(e,ue,t),a(e,jt,t),a(e,de,t),a(e,$t,t),u(me,e,t),a(e,kt,t),u(N,e,t),a(e,xt,t),a(e,fe,t),a(e,St,t),u(ye,e,t),a(e,Ct,t),a(e,ge,t),a(e,Zt,t),u(we,e,t),a(e,Gt,t),a(e,Te,t),a(e,It,t),u(Me,e,t),a(e,Wt,t),a(e,ve,t),a(e,_t,t),u(Je,e,t),a(e,Nt,t),a(e,be,t),a(e,Bt,t),a(e,S,t),g(S,B),g(B,Qe),u(Ue,Qe,null),g(S,ns),g(S,Xe),a(e,Vt,t),a(e,je,t),a(e,Ht,t),u($e,e,t),a(e,Xt,t),a(e,ke,t),a(e,qt,t),u(xe,e,t),a(e,Rt,t),a(e,Se,t),a(e,Yt,t),u(Ce,e,t),a(e,Qt,t),a(e,Ze,t),a(e,Et,t),a(e,J,t),a(e,Ft,t),a(e,Ge,t),a(e,zt,t),a(e,C,t),g(C,V),g(V,Ee),u(Ie,Ee,null),g(C,ls),g(C,qe),a(e,At,t),a(e,We,t),a(e,Pt,t),a(e,Fe,t),Lt=!0},p(e,[t]){const _e={};t&2&&(_e.$$scope={dirty:t,ctx:e}),W.$set(_e);const ze={};t&2&&(ze.$$scope={dirty:t,ctx:e}),N.$set(ze)},i(e){Lt||(d(H.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(W.$$.fragment,e),d(ne.$$.fragment,e),d(le.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(he.$$.fragment,e),d(me.$$.fragment,e),d(N.$$.fragment,e),d(ye.$$.fragment,e),d(we.$$.fragment,e),d(Me.$$.fragment,e),d(Je.$$.fragment,e),d(Ue.$$.fragment,e),d($e.$$.fragment,e),d(xe.$$.fragment,e),d(Ce.$$.fragment,e),d(Ie.$$.fragment,e),Lt=!0)},o(e){m(H.$$.fragment,e),m(z.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(W.$$.fragment,e),m(ne.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(he.$$.fragment,e),m(me.$$.fragment,e),m(N.$$.fragment,e),m(ye.$$.fragment,e),m(we.$$.fragment,e),m(Me.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m($e.$$.fragment,e),m(xe.$$.fragment,e),m(Ce.$$.fragment,e),m(Ie.$$.fragment,e),Lt=!1},d(e){e&&(s(v),s(b),s(U),s(j),s(Pe),s(X),s(Le),s(Z),s(Ke),s(q),s(De),s(R),s(Oe),s(Y),s(et),s(G),s(tt),s(Q),s(st),s(E),s(at),s(F),s(nt),s(k),s(lt),s(A),s(ot),s(it),s(L),s(rt),s(pt),s(D),s(ct),s(O),s(ht),s(ut),s(te),s(dt),s(mt),s(ft),s(ae),s(yt),s(gt),s(wt),s(oe),s(Tt),s(Mt),s(vt),s(pe),s(Jt),s(ce),s(bt),s(x),s(Ut),s(ue),s(jt),s(de),s($t),s(kt),s(xt),s(fe),s(St),s(Ct),s(ge),s(Zt),s(Gt),s(Te),s(It),s(Wt),s(ve),s(_t),s(Nt),s(be),s(Bt),s(S),s(Vt),s(je),s(Ht),s(Xt),s(ke),s(qt),s(Rt),s(Se),s(Yt),s(Qt),s(Ze),s(Et),s(J),s(Ft),s(Ge),s(zt),s(C),s(At),s(We),s(Pt),s(Fe)),s(y),f(H),f(z),f(P,e),f(K,e),f(ee,e),f(se,e),f(W,e),f(ne,e),f(le,e),f(ie,e),f(re,e),f(he),f(me,e),f(N,e),f(ye,e),f(we,e),f(Me,e),f(Je,e),f(Ue),f($e,e),f(xe,e),f(Ce,e),f(Ie)}}}const ha={local:"speechtospeech-translation",sections:[{local:"speech-translation",title:"Speech translation"},{local:"texttospeech",title:"Text-to-speech"},{local:"creating-a-stst-demo",title:"Creating a STST demo"},{local:"going-forwards",title:"Going forwards"}],title:"Speech-to-speech translation"};function ua(Ne){return ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wa extends aa{constructor(y){super(),na(this,y,ua,ca,Os,{})}}export{wa as component};
