import{s as ci,o as pi,n as ui}from"../chunks/scheduler.f7e1785c.js";import{S as di,i as mi,g as i,s as n,u as p,A as fi,h as o,f as t,c as a,j as y,v as u,y as r,k as h,o as c,a as l,w as d,d as m,t as f,x as w,m as cs,n as ps}from"../chunks/index.815a732f.js";import{T as jn}from"../chunks/Tip.1258ac78.js";import{I as U}from"../chunks/IconCopyLink.e7937f56.js";import{C as v}from"../chunks/CodeBlock.c6e8b464.js";function wi(S){let g;return{c(){g=cs(`The following section requires the use of a microphone to record a voice input. Since Google Colab machines do not
    have microphone compatibility, it is recommended to run this section locally, either on your CPU, or on a GPU if you
    have local access. The checkpoint sizes have been selected as those small enough to run adequately fast on CPU, so
    you will still get good performance without a GPU.`)},l(M){g=ps(M,`The following section requires the use of a microphone to record a voice input. Since Google Colab machines do not
    have microphone compatibility, it is recommended to run this section locally, either on your CPU, or on a GPU if you
    have local access. The checkpoint sizes have been selected as those small enough to run adequately fast on CPU, so
    you will still get good performance without a GPU.`)},m(M,J){l(M,g,J)},d(M){M&&t(g)}}}function yi(S){let g,M,J="Whisper Small English",C,T,j='"openai/whisper-small.en"',k;return{c(){g=cs("If you're using a GPU, you can increase the checkpoint size to use the "),M=i("a"),M.textContent=J,C=cs(` 
    checkpoint, which will return better transcription accuracy and still be within the required latency threshold. Simply swap the 
    model id to: `),T=i("code"),T.textContent=j,k=cs("."),this.h()},l(b){g=ps(b,"If you're using a GPU, you can increase the checkpoint size to use the "),M=o(b,"A",{href:!0,"data-svelte-h":!0}),r(M)!=="svelte-1vwlxrf"&&(M.textContent=J),C=ps(b,` 
    checkpoint, which will return better transcription accuracy and still be within the required latency threshold. Simply swap the 
    model id to: `),T=o(b,"CODE",{"data-svelte-h":!0}),r(T)!=="svelte-1roca6s"&&(T.textContent=j),k=ps(b,"."),this.h()},h(){h(M,"href","https://huggingface.co/openai/whisper-small.en")},m(b,x){l(b,g,x),l(b,M,x),l(b,C,x),l(b,T,x),l(b,k,x)},p:ui,d(b){b&&(t(g),t(M),t(C),t(T),t(k))}}}function Mi(S){let g;return{c(){g=cs(`Note that the first time calling this will trigger the model weights to be downloaded, which might take 
    some time depending on your Hub download speed.`)},l(M){g=ps(M,`Note that the first time calling this will trigger the model weights to be downloaded, which might take 
    some time depending on your Hub download speed.`)},m(M,J){l(M,g,J)},d(M){M&&t(g)}}}function gi(S){let g,M,J,C,T,j,k,b,x,Lt,Un="Creating a voice assistant",us,ie,kn=`In this section, we’ll piece together three models that we’ve already had hands-on experience with to build an end-to-end
voice assistant called <strong>Marvin</strong> 🤖. Like Amazon’s Alexa or Apple’s Siri, Marvin is a virtual voice assistant who
responds to a particular ‘wake word’, then listens out for a spoken query, and finally responds with a spoken answer.`,ds,oe,Cn="We can break down the voice assistant pipeline into four stages, each of which requires a standalone model:",ms,L,xn='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/voice_assistant.png"/>',fs,$,V,Dt,re,mn,Vt,$n="1. Wake word detection",ws,he,In=`Voice assistants are constantly listening to the audio inputs coming through your device’s microphone, however they only
boot into action when a particular ‘wake word’ or ‘trigger word’ is spoken.`,ys,ce,_n=`The wake word detection task is handled by a small on-device audio classification model, which is much smaller and lighter
than the speech recognition model, often only several millions of parameters compared to several hundred millions for
speech recognition. Thus, it can be run continuously on your device without draining your battery. Only when the wake
word is detected is the larger speech recognition model launched, and afterwards it is shut down again.`,Ms,I,E,Kt,pe,fn,Et,Zn="2. Speech transcription",gs,ue,Wn=`The next stage in the pipeline is transcribing the spoken query to text. In practice, transferring audio files from your
local device to the Cloud is slow due to the large nature of audio files, so it’s more efficient to transcribe them
directly using an automatic speech recognition (ASR) model on-device rather than using a model in the Cloud. The on-device
model might be smaller and thus less accurate than one hosted in the Cloud, but the faster inference speed makes it
worthwhile since we can run speech recognition in near real-time, our spoken audio utterance being transcribed as we say it.`,vs,de,Hn="We’re very familiar with the speech recognition process now, so this should be a piece of cake!",bs,_,q,Ot,me,wn,qt,Nn="3. Language model query",Ts,fe,Bn=`Now that we know what the user asked, we need to generate a response! The best candidate models for this task are
<em>large language models (LLMs)</em>, since they are effectively able to understand the semantics of the text query and
generate a suitable response.`,Js,we,An=`Since our text query is small (just a few text tokens), and language models large (many billions of parameters), the most
efficient way of running LLM inference is to send our text query from our device to an LLM running in the Cloud,
generate a text response, and return the response back to the device.`,js,Z,Y,es,ye,yn,Yt,Gn="4. Synthesise speech",Us,Me,Sn=`Finally, we’ll use a text-to-speech (TTS) model to synthesise the text response as spoken speech. This is done
on-device, but you could feasibly run a TTS model in the Cloud, generating the audio output and transferring it back to
the device.`,ks,ge,Ln="Again, we’ve done this several times now, so the process will be very familiar!",Cs,Q,xs,W,z,ts,ve,Mn,Qt,Vn="Wake word detection",$s,be,En=`The first stage in the voice assistant pipeline is detecting whether the wake word was spoken, and we need to find ourselves
an appropriate pre-trained model for this task! You’ll remember from the section on <a href="../chapter4/classification_models">pre-trained models for audio classification</a>
that <a href="https://huggingface.co/datasets/speech_commands" rel="nofollow">Speech Commands</a> is a dataset of spoken words designed to
evaluate audio classification models on 15+ simple command words like <code>&quot;up&quot;</code>, <code>&quot;down&quot;</code>, <code>&quot;yes&quot;</code> and <code>&quot;no&quot;</code>, as well as a
<code>&quot;silence&quot;</code> label to classify no speech. Take a minute to listen through the samples on the datasets viewer on
the Hub and re-acquaint yourself with the Speech Commands dataset: <a href="https://huggingface.co/datasets/speech_commands/viewer/v0.01/train" rel="nofollow">datasets viewer</a>.`,Is,Te,qn=`We can take an audio classification model pre-trained on the Speech Commands dataset and pick one of these simple command
words to be our chosen wake word. Out of the 15+ possible command words, if the model predicts our chosen wake word with the
highest probability, we can be fairly certain that the wake word has been said.`,_s,Je,Yn='Let’s head to the Hugging Face Hub and click on the “Models” tab: <a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>',Zs,je,Qn="This is going to bring up all the models on the Hugging Face Hub, sorted by downloads in the past 30 days:",Ws,R,zn='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/all_models.png"/>',Hs,Ue,Rn=`You’ll notice on the left-hand side that we have a selection of tabs that we can select to filter models by task, library,
dataset, etc. Scroll down and select the task “Audio Classification” from the list of audio tasks:`,Ns,X,Xn='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_audio_classification.png"/>',Bs,ke,Pn=`We’re now presented with the sub-set of 500+ audio classification models on the Hub. To further refine this selection, we
can filter models by dataset. Click on the tab “Datasets”, and in the search box type “speech_commands”. As you begin typing,
you’ll see the selection for <code>speech_commands</code> appear underneath the search tab. You can click this button to filter all
audio classification models to those fine-tuned on the Speech Commands dataset:`,As,P,Fn='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_speech_commands.png"/>',Gs,Ce,Dn=`Great! We see that we have six pre-trained models available to us for this specific dataset and task (although there may
be new models added if you’re reading at a later date!). You’ll recognise the first of these models as the <a href="https://huggingface.co/MIT/ast-finetuned-speech-commands-v2" rel="nofollow">Audio Spectrogram Transformer checkpoint</a>
that we used in Unit 4 example. We’ll use this checkpoint again for our wake word detection task.`,Ss,xe,Kn="Let’s go ahead and load the checkpoint using the <code>pipeline</code> class:",Ls,$e,Vs,Ie,On="We can check what labels the model was trained on by checking the <code>id2label</code> attribute in the model config:",Es,_e,qs,Ze,ea=`Alright! We see that the model was trained on 35 class labels, including some simple command words that we described above,
as well as some particular objects like <code>&quot;bed&quot;</code>, <code>&quot;house&quot;</code> and <code>&quot;cat&quot;</code>. We see that there is one name in these class labels:
id 27 corresponds to the label <strong>“marvin”</strong>:`,Ys,We,Qs,He,zs,Ne,ta=`Perfect! We can use this name as our wake word for our voice assistant, similar to how “Alexa” is used for Amazon’s Alexa,
or “Hey Siri” is used for Apple’s Siri. Of all the possible labels, if the model predicts <code>&quot;marvin&quot;</code> with the highest class
probability, we can be fairly sure that our chosen wake word has been said.`,Rs,Be,sa=`Now we need to define a function that is constantly listening to our device’s microphone input, and continuously
passes the audio to the classification model for inference. To do this, we’ll use a handy helper function that comes
with 🤗 Transformers called <a href="https://github.com/huggingface/transformers/blob/fb78769b9c053876ed7ae152ee995b0439a4462a/src/transformers/pipelines/audio_utils.py#L98" rel="nofollow"><code>ffmpeg_microphone_live</code></a>.`,Xs,Ae,la=`This function forwards small chunks of audio of specified length <code>chunk_length_s</code> to the model to be classified. To ensure that
we get smooth boundaries across chunks of audio, we run a sliding window across our audio with stride <code>chunk_length_s / 6</code>.
So that we don’t have to wait for the entire first chunk to be recorded before we start inferring, we also define a minimal
temporary audio input length <code>stream_chunk_s</code> that is forwarded to the model before <code>chunk_length_s</code> time is reached.`,Ps,Ge,na=`The function <code>ffmpeg_microphone_live</code> returns a <em>generator</em> object, yielding a sequence of audio chunks that can each
be passed to the classification model to make a prediction. We can pass this generator directly to the <code>pipeline</code>,
which in turn returns a sequence of output predictions, one for each chunk of audio input. We can inspect the class
label probabilities for each audio chunk, and stop our wake word detection loop when we detect that the wake word
has been spoken.`,Fs,Se,aa=`We’ll use a very simple criteria for classifying whether our wake word was spoken: if the class label with the highest
probability was our wake word, and this probability exceeds a threshold <code>prob_threshold</code>, we declare that the wake word
as having been spoken. Using a probability threshold to gate our classifier this way ensures that the wake word is not
erroneously predicted if the audio input is noise, which is typically when the model is very uncertain and all the class
label probabilities low. You might want to tune this probability threshold, or explore more sophisticated means for
the wake word decision through an <a href="https://en.wikipedia.org/wiki/Entropy_(information_theory)" rel="nofollow"><em>entropy</em></a> (or uncertainty) based metric.`,Ds,Le,Ks,Ve,ia=`Let’s give this function a try to see how it works! We’ll set the flag <code>debug=True</code> to print out the prediction for each
chunk of audio. Let the model run for a few seconds to see the kinds of predictions that it makes when there is no speech
input, then clearly say the wake word <code>&quot;marvin&quot;</code> and watch the class label prediction for <code>&quot;marvin&quot;</code> spike to near 1:`,Os,Ee,el,qe,tl,Ye,oa=`Awesome! As we expect, the model generates garbage predictions for the first few seconds. There is no speech input, so the
model makes close to random predictions, but with very low probability. As soon as we say the wake word, the model predicts
<code>&quot;marvin&quot;</code> with probability close to 1 and terminates the loop, signalling that the wake word has been detected and that the
ASR system should be activated!`,sl,H,F,ss,Qe,gn,zt,ra="Speech transcription",ll,ze,ha=`Once again, we’ll use the Whisper model for our speech transcription system. Specifically, we’ll load the <a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">Whisper Base English</a>
checkpoint, since it’s small enough to give good inference speed with reasonable transcription accuracy. We’ll use a trick
to get near real-time transcription by being clever with how we forward our audio inputs to the model. As before, feel
free to use any speech recognition checkpoint on <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;library=transformers&amp;sort=trending" rel="nofollow">the Hub</a>,
including Wav2Vec2, MMS ASR or other Whisper checkpoints:`,nl,Re,al,D,il,Xe,ca=`We can now define a function to record our microphone input and transcribe the corresponding text. With the <code>ffmpeg_microphone_live</code>
helper function, we can control how ‘real-time’ our speech recognition model is. Using a smaller <code>stream_chunk_s</code> lends
itself to more real-time speech recognition, since we divide our input audio into smaller chunks and transcribe them on
the fly. However, this comes at the expense of poorer accuracy, since there’s less context for the model to infer from.`,ol,Pe,pa=`As we’re transcribing the speech, we also need to have an idea of when the user <strong>stops</strong> speaking, so that we can terminate
the recording. For simplicity, we’ll terminate our microphone recording after the first <code>chunk_length_s</code> (which is set to
5 seconds by default), but you can experiment with using a <a href="https://huggingface.co/models?pipeline_tag=voice-activity-detection&amp;sort=trending" rel="nofollow">voice activity detection (VAD)</a>
model to predict when the user has stopped speaking.`,rl,Fe,hl,De,ua=`Let’s give this a go and see how we get on! Once the microphone is live, start speaking and watch your transcription
appear in semi real-time:`,cl,Ke,pl,Oe,ul,et,da=`Nice! You can adjust the maximum audio length <code>chunk_length_s</code> based on how fast or slow you speak (increase it if you
felt like you didn’t have enough time to speak, decrease it if you were left waiting at the end), and the
<code>stream_chunk_s</code> for the real-time factor. Just pass these as arguments to the <code>transcribe</code> function.`,dl,N,K,ls,tt,vn,Rt,ma="Language model query",ml,st,fa=`Now that we have our spoken query transcribed, we want to generate a meaningful response. To do this, we’ll use an LLM
hosted on the Cloud. Specifically, we’ll pick an LLM on the Hugging Face Hub and use the <a href="https://huggingface.co/inference-api" rel="nofollow">Inference API</a>
to easily query the model.`,fl,lt,wa=`First, let’s head over to the Hugging Face Hub. To find our LLM, we’ll use the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">🤗 Open LLM Leaderboard</a>,
a Space that ranks LLM models by performance over four generation tasks. We’ll search by “instruct” to filter out models
that have been instruction fine-tuned, since these should work better for our querying task:`,wl,O,ya='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/llm_leaderboard.png"/>',yl,nt,Ma=`We’ll use the <a href="https://huggingface.co/tiiuae/falcon-7b-instruct" rel="nofollow">tiiuae/falcon-7b-instruct</a> checkpoint by <a href="https://www.tii.ae/" rel="nofollow">TII</a>,
a 7B parameter decoder-only LM fine-tuned on a mixture of chat and instruction datasets. You can use any LLM on the Hugging
Face Hub that has the “Hosted inference API” enabled, just look out for the widget on the right-side of the model card:`,Ml,ee,ga='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/inference_api.png"/>',gl,at,va=`The Inference API allows us to send a HTTP request from our local machine to the LLM hosted on the Hub, and returns the
response as a <code>json</code> file. All we need to provide is our Hugging Face Hub token (which we retrieve directly from our Hugging Face
Hub folder) and the model id of the LLM we wish to query:`,vl,it,bl,ot,ba="Let’s give it a try with a test input!",Tl,rt,Jl,ht,jl,ct,Ta=`You’ll notice just how fast inference is using the Inference API - we only have to send a small number of text tokens
from our local machine to the hosted model, so the communication cost is very low. The LLM is hosted on GPU accelerators,
so inference runs very quickly. Finally, the generated response is transferred back from the model to our local machine,
again with low communication overhead.`,Ul,B,te,ns,pt,bn,Xt,Ja="Synthesise speech",kl,ut,ja=`And now we’re ready to get the final spoken output! Once again, we’ll use the Microsoft <a href="https://huggingface.co/microsoft/speecht5_tts" rel="nofollow">SpeechT5 TTS</a>
model for English TTS, but you can use any TTS model of your choice. Let’s go ahead and load the processor and model:`,Cl,dt,xl,mt,Ua="And also the speaker embeddings:",$l,ft,Il,wt,ka='We’ll re-use the <code>synthesise</code> function that we defined in the previous chapter on <a href="speech-to-speech">Speech-to-speech translation</a>:',_l,yt,Zl,Mt,Ca="Let’s quickly verify this works as expected:",Wl,gt,Hl,vt,xa="Nice job 👍",Nl,A,se,as,bt,Tn,Pt,$a="Marvin 🤖",Bl,Tt,Ia=`Now that we’ve defined a function for each of the four stages of the voice assistant pipeline, all that’s left to do is
piece them together to get our end-to-end voice assistant. We’ll simply concatenate the four stages, starting with
wake word detection (<code>launch_fn</code>), speech transcription, querying the LLM, and finally speech synthesis.`,Al,Jt,Gl,jt,_a="Try it out with a few prompts! Here are some examples to get you started:",Sl,Ut,Za="<li><em>What is the hottest country in the world?</em></li> <li><em>How do Transformer models work?</em></li> <li><em>Do you know Spanish?</em></li>",Ll,kt,Wa=`And with that, we have our end-to-end voice assistant complete, made using the 🤗 audio tools you’ve learnt throughout
this course, with a sprinkling of LLM magic at the end. There are several extensions that we could make to improve the
voice assistant. Firstly, the audio classification model classifies 35 different labels. We could use a smaller, more
lightweight binary classification model that only predicts whether the wake word was spoken or not. Secondly, we pre-load
all the models ahead and keep them running on our device. If we wanted to save power, we would only load each model at
the time it was required, and subsequently un-load them afterwards. Thirdly, we’re missing a voice activity detection model
in our transcription function, transcribing for a fixed amount of time, which in some cases is too long, and in others too
short.`,Vl,G,le,is,Ct,Jn,Ft,Ha="Generalise to anything 🪄",El,xt,Na=`So far, we’ve seen how we can generate speech outputs with our voice assistant Marvin. To finish, we’ll demonstrate how
we can generalise these speech outputs to text, audio and image.`,ql,$t,Ba=`We’ll use <a href="https://huggingface.co/docs/transformers/transformers_agents" rel="nofollow">Transformers Agents</a> to build our assistant.
Transformers Agents provides a natural language API on top of the 🤗 Transformers and Diffusers libraries, interpreting
a natural language input using an LLM with carefully crafted prompts, and using a set of curated tools to provide
multimodal outputs.`,Yl,It,Aa=`Let’s go ahead and instantiate an agent. There are <a href="https://huggingface.co/docs/transformers/transformers_agents#quickstart" rel="nofollow">three LLMs available</a>
for Transformers Agents, two of which are open-source and free on the Hugging Face Hub. The third is a model from OpenAI
that requires an OpenAI API key. We’ll use the free <a href="https://huggingface.co/bigcode/starcoder" rel="nofollow">Bigcode Starcoder</a> model
in this example, but you can also try either of the other LLMs available:`,Ql,_t,zl,Zt,Ga=`To use the agent, we simply have to call <code>agent.run</code> with our text prompt. As an example, we’ll get it to generate an
image of a cat 🐈 (that hopefully looks a bit better than this emoji):`,Rl,Wt,Xl,ne,Sa='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/generated_cat.png"/>',Pl,ae,Fl,Ht,La=`Easy as that! The Agent interpreted our prompt, and used <a href="https://huggingface.co/docs/diffusers/using-diffusers/conditional_image_generation" rel="nofollow">Stable Diffusion</a>
under the hood to generate the image, without us having to worry about loading the model, writing the function or executing
the code.`,Dl,Nt,Va=`We can now replace our LLM query function and text synthesis step with our Transformers Agent in our voice assistant,
since the Agent is going to take care of both of these steps for us:`,Kl,Bt,Ol,At,Ea=`Try speaking the same prompt “Generate an image of a cat” and see how the system gets on. If you ask the Agent a simple
question / answer query, the Agent will respond with a text answer. You can encourage it to generate multimodal outputs
by asking it to return an image or speech. For example, you can ask it to: “Generate an image of a cat, caption it, and
speak the caption”.`,en,Gt,qa=`While the Agent is more flexible than our first iteration Marvin 🤖 assistant, generalising the voice assistant task in this way
may lead to inferior performance on standard voice assistant queries. To recover performance, you can try using a
more performant LLM checkpoint, such as the one from OpenAI, or define a set of <a href="https://huggingface.co/docs/transformers/transformers_agents#custom-tools" rel="nofollow">custom tools</a>
that are specific to the voice assistant task.`,tn,os,sn;return b=new U({}),re=new U({}),pe=new U({}),me=new U({}),ye=new U({}),Q=new jn({props:{$$slots:{default:[wi]},$$scope:{ctx:S}}}),ve=new U({}),$e=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMk1JVCUyRmFzdC1maW5ldHVuZWQtc3BlZWNoLWNvbW1hbmRzLXYyJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;MIT/ast-finetuned-speech-commands-v2&quot;</span>, device=device
)`}}),_e=new v({props:{code:"Y2xhc3NpZmllci5tb2RlbC5jb25maWcuaWQybGFiZWw=",highlighted:"classifier.model.config.id2label"}}),We=new v({props:{code:"Y2xhc3NpZmllci5tb2RlbC5jb25maWcuaWQybGFiZWwlNUIyNyU1RA==",highlighted:'classifier.model.config.id2label[<span class="hljs-number">27</span>]'}}),He=new v({props:{code:"J21hcnZpbic=",highlighted:'<span class="hljs-symbol">&#x27;marvin</span>&#x27;'}}),Le=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines.audio_utils <span class="hljs-keyword">import</span> ffmpeg_microphone_live


<span class="hljs-keyword">def</span> <span class="hljs-title function_">launch_fn</span>(<span class="hljs-params">
    wake_word=<span class="hljs-string">&quot;marvin&quot;</span>,
    prob_threshold=<span class="hljs-number">0.5</span>,
    chunk_length_s=<span class="hljs-number">2.0</span>,
    stream_chunk_s=<span class="hljs-number">0.25</span>,
    debug=<span class="hljs-literal">False</span>,
</span>):
    <span class="hljs-keyword">if</span> wake_word <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> classifier.model.config.label2id.keys():
        <span class="hljs-keyword">raise</span> ValueError(
            <span class="hljs-string">f&quot;Wake word <span class="hljs-subst">{wake_word}</span> not in set of valid class labels, pick a wake word in the set <span class="hljs-subst">{classifier.model.config.label2id.keys()}</span>.&quot;</span>
        )

    sampling_rate = classifier.feature_extractor.sampling_rate

    mic = ffmpeg_microphone_live(
        sampling_rate=sampling_rate,
        chunk_length_s=chunk_length_s,
        stream_chunk_s=stream_chunk_s,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Listening for wake word...&quot;</span>)
    <span class="hljs-keyword">for</span> prediction <span class="hljs-keyword">in</span> classifier(mic):
        prediction = prediction[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">if</span> debug:
            <span class="hljs-built_in">print</span>(prediction)
        <span class="hljs-keyword">if</span> prediction[<span class="hljs-string">&quot;label&quot;</span>] == wake_word:
            <span class="hljs-keyword">if</span> prediction[<span class="hljs-string">&quot;score&quot;</span>] &gt; prob_threshold:
                <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>`}}),Ee=new v({props:{code:"bGF1bmNoX2ZuKGRlYnVnJTNEVHJ1ZSk=",highlighted:'launch_fn(debug=<span class="hljs-literal">True</span>)'}}),qe=new v({props:{code:"TGlzdGVuaW5nJTIwZm9yJTIwd2FrZSUyMHdvcmQuLi4lMEElN0Inc2NvcmUnJTNBJTIwMC4wNTUzMjYxMDc4ODk0MTM4MzQlMkMlMjAnbGFiZWwnJTNBJTIwJ29uZSclN0QlMEElN0Inc2NvcmUnJTNBJTIwMC4wNTk5OTg1NjgxNDc0MjA4OCUyQyUyMCdsYWJlbCclM0ElMjAnb2ZmJyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjEyODI3NDg0MzA5NjczMzElMkMlMjAnbGFiZWwnJTNBJTIwJ2ZpdmUnJTdEJTBBJTdCJ3Njb3JlJyUzQSUyMDAuMDczMTAxMTAzMzA1ODE2NjUlMkMlMjAnbGFiZWwnJTNBJTIwJ2ZvbGxvdyclN0QlMEElN0Inc2NvcmUnJTNBJTIwMC4wNjYzNDgwOTgyMTg0NDEwMSUyQyUyMCdsYWJlbCclM0ElMjAnZm9sbG93JyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjA1OTkyNjQyNDE3NTUwMDg3JTJDJTIwJ2xhYmVsJyUzQSUyMCd0cmVlJyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjA1OTkyNjQyNDE3NTUwMDg3JTJDJTIwJ2xhYmVsJyUzQSUyMCd0cmVlJyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjk5OTkxMzIxNTYzNzIwNyUyQyUyMCdsYWJlbCclM0ElMjAnbWFydmluJyU3RA==",highlighted:`Listening for wake word...
{&#x27;score&#x27;: 0.055326107889413834, &#x27;label&#x27;: &#x27;one&#x27;}
{&#x27;score&#x27;: 0.05999856814742088, &#x27;label&#x27;: &#x27;off&#x27;}
{&#x27;score&#x27;: 0.1282748430967331, &#x27;label&#x27;: &#x27;five&#x27;}
{&#x27;score&#x27;: 0.07310110330581665, &#x27;label&#x27;: &#x27;follow&#x27;}
{&#x27;score&#x27;: 0.06634809821844101, &#x27;label&#x27;: &#x27;follow&#x27;}
{&#x27;score&#x27;: 0.05992642417550087, &#x27;label&#x27;: &#x27;tree&#x27;}
{&#x27;score&#x27;: 0.05992642417550087, &#x27;label&#x27;: &#x27;tree&#x27;}
{&#x27;score&#x27;: 0.999913215637207, &#x27;label&#x27;: &#x27;marvin&#x27;}`}}),Qe=new U({}),Re=new v({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJvcGVuYWklMkZ3aGlzcGVyLWJhc2UuZW4lMjIlMkMlMjBkZXZpY2UlM0RkZXZpY2UlMEEp",highlighted:`transcriber = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base.en&quot;</span>, device=device
)`}}),D=new jn({props:{$$slots:{default:[yi]},$$scope:{ctx:S}}}),Fe=new v({props:{code:"aW1wb3J0JTIwc3lzJTBBJTBBJTBBZGVmJTIwdHJhbnNjcmliZShjaHVua19sZW5ndGhfcyUzRDUuMCUyQyUyMHN0cmVhbV9jaHVua19zJTNEMS4wKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlMjAlM0QlMjB0cmFuc2NyaWJlci5mZWF0dXJlX2V4dHJhY3Rvci5zYW1wbGluZ19yYXRlJTBBJTBBJTIwJTIwJTIwJTIwbWljJTIwJTNEJTIwZmZtcGVnX21pY3JvcGhvbmVfbGl2ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEY2h1bmtfbGVuZ3RoX3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW1fY2h1bmtfcyUzRHN0cmVhbV9jaHVua19zJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMlN0YXJ0JTIwc3BlYWtpbmcuLi4lMjIpJTBBJTIwJTIwJTIwJTIwZm9yJTIwaXRlbSUyMGluJTIwdHJhbnNjcmliZXIobWljJTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMjglN0QpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3lzLnN0ZG91dC53cml0ZSglMjIlNUMwMzMlNUJLJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGl0ZW0lNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwZW5kJTNEJTIyJTVDciUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG5vdCUyMGl0ZW0lNUIlMjJwYXJ0aWFsJTIyJTVEJTVCMCU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaXRlbSU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-keyword">import</span> sys


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">chunk_length_s=<span class="hljs-number">5.0</span>, stream_chunk_s=<span class="hljs-number">1.0</span></span>):
    sampling_rate = transcriber.feature_extractor.sampling_rate

    mic = ffmpeg_microphone_live(
        sampling_rate=sampling_rate,
        chunk_length_s=chunk_length_s,
        stream_chunk_s=stream_chunk_s,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Start speaking...&quot;</span>)
    <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> transcriber(mic, generate_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>}):
        sys.stdout.write(<span class="hljs-string">&quot;\\033[K&quot;</span>)
        <span class="hljs-built_in">print</span>(item[<span class="hljs-string">&quot;text&quot;</span>], end=<span class="hljs-string">&quot;\\r&quot;</span>)
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> item[<span class="hljs-string">&quot;partial&quot;</span>][<span class="hljs-number">0</span>]:
            <span class="hljs-keyword">break</span>

    <span class="hljs-keyword">return</span> item[<span class="hljs-string">&quot;text&quot;</span>]`}}),Ke=new v({props:{code:"dHJhbnNjcmliZSgp",highlighted:"transcribe()"}}),Oe=new v({props:{code:"U3RhcnQlMjBzcGVha2luZy4uLiUwQSUyMEhleSUyQyUyMHRoaXMlMjBpcyUyMGElMjB0ZXN0JTIwd2l0aCUyMHRoZSUyMHdoaXNwZXIlMjBtb2RlbC4=",highlighted:`Start speaking...
 Hey, this is a test with the whisper model.`}}),tt=new U({}),it=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRm9sZGVyJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFkZWYlMjBxdWVyeSh0ZXh0JTJDJTIwbW9kZWxfaWQlM0QlMjJ0aWl1YWUlMkZmYWxjb24tN2ItaW5zdHJ1Y3QlMjIpJTNBJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRmFwaS1pbmZlcmVuY2UuaHVnZ2luZ2ZhY2UuY28lMkZtb2RlbHMlMkYlN0Jtb2RlbF9pZCU3RCUyMiUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlMjAlM0QlMjAlN0IlMjJBdXRob3JpemF0aW9uJTIyJTNBJTIwZiUyMkJlYXJlciUyMCU3QkhmRm9sZGVyKCkuZ2V0X3Rva2VuKCklN0QlMjIlN0QlMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwdGV4dCU3RCUwQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJRdWVyeWluZy4uLiUzQSUyMCU3QnRleHQlN0QlMjIpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5wb3N0KGFwaV91cmwlMkMlMjBoZWFkZXJzJTNEaGVhZGVycyUyQyUyMGpzb24lM0RwYXlsb2FkKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNlLmpzb24oKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbih0ZXh0KSUyMCUyQiUyMDElMjAlM0ElNUQ=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFolder
<span class="hljs-keyword">import</span> requests


<span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">text, model_id=<span class="hljs-string">&quot;tiiuae/falcon-7b-instruct&quot;</span></span>):
    api_url = <span class="hljs-string">f&quot;https://api-inference.huggingface.co/models/<span class="hljs-subst">{model_id}</span>&quot;</span>
    headers = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HfFolder().get_token()}</span>&quot;</span>}
    payload = {<span class="hljs-string">&quot;inputs&quot;</span>: text}

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Querying...: <span class="hljs-subst">{text}</span>&quot;</span>)
    response = requests.post(api_url, headers=headers, json=payload)
    <span class="hljs-keyword">return</span> response.json()[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(text) + <span class="hljs-number">1</span> :]`}}),rt=new v({props:{code:"cXVlcnkoJTIyV2hhdCUyMGRvZXMlMjBIdWdnaW5nJTIwRmFjZSUyMGRvJTNGJTIyKQ==",highlighted:'query(<span class="hljs-string">&quot;What does Hugging Face do?&quot;</span>)'}}),ht=new v({props:{code:"J0h1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMHRoYXQlMjBwcm92aWRlcyUyMG5hdHVyYWwlMjBsYW5ndWFnZSUyMHByb2Nlc3NpbmclMjBhbmQlMjBtYWNoaW5lJTIwbGVhcm5pbmclMjB0b29scyUyMGZvciUyMGRldmVsb3BlcnMuJTIwVGhleSc=",highlighted:'<span class="hljs-comment">&#x27;Hugging Face is a company that provides natural language processing and machine learning tools for developers. They&#x27;</span>'}}),pt=new U({}),dt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTJDJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2glMkMlMjBTcGVlY2hUNUhpZmlHYW4lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTcGVlY2hUNVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3BlZWNodDVfdHRzJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2guZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMikudG8oZGV2aWNlKSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpLnRvKGRldmljZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor, SpeechT5ForTextToSpeech, SpeechT5HifiGan

processor = SpeechT5Processor.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)

model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>).to(device)
vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>).to(device)`}}),ft=new v({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZW1iZWRkaW5nc19kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMk1hdHRoaWpzJTJGY211LWFyY3RpYy14dmVjdG9ycyUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC50ZW5zb3IoZW1iZWRkaW5nc19kYXRhc2V0JTVCNzMwNiU1RCU1QiUyMnh2ZWN0b3IlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

embeddings_dataset = load_dataset(<span class="hljs-string">&quot;Matthijs/cmu-arctic-xvectors&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
speaker_embeddings = torch.tensor(embeddings_dataset[<span class="hljs-number">7306</span>][<span class="hljs-string">&quot;xvector&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`}}),yt=new v({props:{code:"ZGVmJTIwc3ludGhlc2lzZSh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC50byhkZXZpY2UpJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzLnRvKGRldmljZSklMkMlMjB2b2NvZGVyJTNEdm9jb2RlciUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVlY2guY3B1KCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">synthesise</span>(<span class="hljs-params">text</span>):
    inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    speech = model.generate_speech(
        inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(device), speaker_embeddings.to(device), vocoder=vocoder
    )
    <span class="hljs-keyword">return</span> speech.cpu()`}}),gt=new v({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBYXVkaW8lMjAlM0QlMjBzeW50aGVzaXNlKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMHRoYXQlMjBwcm92aWRlcyUyMG5hdHVyYWwlMjBsYW5ndWFnZSUyMHByb2Nlc3NpbmclMjBhbmQlMjBtYWNoaW5lJTIwbGVhcm5pbmclMjB0b29scyUyMGZvciUyMGRldmVsb3BlcnMuJTIyJTBBKSUwQSUwQUF1ZGlvKGF1ZGlvJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

audio = synthesise(
    <span class="hljs-string">&quot;Hugging Face is a company that provides natural language processing and machine learning tools for developers.&quot;</span>
)

Audio(audio, rate=<span class="hljs-number">16000</span>)`}}),bt=new U({}),Jt=new v({props:{code:"bGF1bmNoX2ZuKCklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwdHJhbnNjcmliZSgpJTBBcmVzcG9uc2UlMjAlM0QlMjBxdWVyeSh0cmFuc2NyaXB0aW9uKSUwQWF1ZGlvJTIwJTNEJTIwc3ludGhlc2lzZShyZXNwb25zZSklMEElMEFBdWRpbyhhdWRpbyUyQyUyMHJhdGUlM0QxNjAwMCUyQyUyMGF1dG9wbGF5JTNEVHJ1ZSk=",highlighted:`launch_fn()
transcription = transcribe()
response = query(transcription)
audio = synthesise(response)

Audio(audio, rate=<span class="hljs-number">16000</span>, autoplay=<span class="hljs-literal">True</span>)`}}),Ct=new U({}),_t=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTBBJTIwJTIwJTIwJTIwdXJsX2VuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(
    url_endpoint=<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>
)`}}),Wt=new v({props:{code:"YWdlbnQucnVuKCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwYSUyMGNhdCUyMik=",highlighted:'agent.run(<span class="hljs-string">&quot;Generate an image of a cat&quot;</span>)'}}),ae=new jn({props:{$$slots:{default:[Mi]},$$scope:{ctx:S}}}),Bt=new v({props:{code:"bGF1bmNoX2ZuKCklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwdHJhbnNjcmliZSgpJTBBYWdlbnQucnVuKHRyYW5zY3JpcHRpb24p",highlighted:`launch_fn()
transcription = transcribe()
agent.run(transcription)`}}),{c(){g=i("meta"),M=n(),J=i("p"),C=n(),T=i("h1"),j=i("a"),k=i("span"),p(b.$$.fragment),x=n(),Lt=i("span"),Lt.textContent=Un,us=n(),ie=i("p"),ie.innerHTML=kn,ds=n(),oe=i("p"),oe.textContent=Cn,ms=n(),L=i("div"),L.innerHTML=xn,fs=n(),$=i("h3"),V=i("a"),Dt=i("span"),p(re.$$.fragment),mn=n(),Vt=i("span"),Vt.textContent=$n,ws=n(),he=i("p"),he.textContent=In,ys=n(),ce=i("p"),ce.textContent=_n,Ms=n(),I=i("h3"),E=i("a"),Kt=i("span"),p(pe.$$.fragment),fn=n(),Et=i("span"),Et.textContent=Zn,gs=n(),ue=i("p"),ue.textContent=Wn,vs=n(),de=i("p"),de.textContent=Hn,bs=n(),_=i("h3"),q=i("a"),Ot=i("span"),p(me.$$.fragment),wn=n(),qt=i("span"),qt.textContent=Nn,Ts=n(),fe=i("p"),fe.innerHTML=Bn,Js=n(),we=i("p"),we.textContent=An,js=n(),Z=i("h3"),Y=i("a"),es=i("span"),p(ye.$$.fragment),yn=n(),Yt=i("span"),Yt.textContent=Gn,Us=n(),Me=i("p"),Me.textContent=Sn,ks=n(),ge=i("p"),ge.textContent=Ln,Cs=n(),p(Q.$$.fragment),xs=n(),W=i("h2"),z=i("a"),ts=i("span"),p(ve.$$.fragment),Mn=n(),Qt=i("span"),Qt.textContent=Vn,$s=n(),be=i("p"),be.innerHTML=En,Is=n(),Te=i("p"),Te.textContent=qn,_s=n(),Je=i("p"),Je.innerHTML=Yn,Zs=n(),je=i("p"),je.textContent=Qn,Ws=n(),R=i("div"),R.innerHTML=zn,Hs=n(),Ue=i("p"),Ue.textContent=Rn,Ns=n(),X=i("div"),X.innerHTML=Xn,Bs=n(),ke=i("p"),ke.innerHTML=Pn,As=n(),P=i("div"),P.innerHTML=Fn,Gs=n(),Ce=i("p"),Ce.innerHTML=Dn,Ss=n(),xe=i("p"),xe.innerHTML=Kn,Ls=n(),p($e.$$.fragment),Vs=n(),Ie=i("p"),Ie.innerHTML=On,Es=n(),p(_e.$$.fragment),qs=n(),Ze=i("p"),Ze.innerHTML=ea,Ys=n(),p(We.$$.fragment),Qs=n(),p(He.$$.fragment),zs=n(),Ne=i("p"),Ne.innerHTML=ta,Rs=n(),Be=i("p"),Be.innerHTML=sa,Xs=n(),Ae=i("p"),Ae.innerHTML=la,Ps=n(),Ge=i("p"),Ge.innerHTML=na,Fs=n(),Se=i("p"),Se.innerHTML=aa,Ds=n(),p(Le.$$.fragment),Ks=n(),Ve=i("p"),Ve.innerHTML=ia,Os=n(),p(Ee.$$.fragment),el=n(),p(qe.$$.fragment),tl=n(),Ye=i("p"),Ye.innerHTML=oa,sl=n(),H=i("h2"),F=i("a"),ss=i("span"),p(Qe.$$.fragment),gn=n(),zt=i("span"),zt.textContent=ra,ll=n(),ze=i("p"),ze.innerHTML=ha,nl=n(),p(Re.$$.fragment),al=n(),p(D.$$.fragment),il=n(),Xe=i("p"),Xe.innerHTML=ca,ol=n(),Pe=i("p"),Pe.innerHTML=pa,rl=n(),p(Fe.$$.fragment),hl=n(),De=i("p"),De.textContent=ua,cl=n(),p(Ke.$$.fragment),pl=n(),p(Oe.$$.fragment),ul=n(),et=i("p"),et.innerHTML=da,dl=n(),N=i("h2"),K=i("a"),ls=i("span"),p(tt.$$.fragment),vn=n(),Rt=i("span"),Rt.textContent=ma,ml=n(),st=i("p"),st.innerHTML=fa,fl=n(),lt=i("p"),lt.innerHTML=wa,wl=n(),O=i("div"),O.innerHTML=ya,yl=n(),nt=i("p"),nt.innerHTML=Ma,Ml=n(),ee=i("div"),ee.innerHTML=ga,gl=n(),at=i("p"),at.innerHTML=va,vl=n(),p(it.$$.fragment),bl=n(),ot=i("p"),ot.textContent=ba,Tl=n(),p(rt.$$.fragment),Jl=n(),p(ht.$$.fragment),jl=n(),ct=i("p"),ct.textContent=Ta,Ul=n(),B=i("h2"),te=i("a"),ns=i("span"),p(pt.$$.fragment),bn=n(),Xt=i("span"),Xt.textContent=Ja,kl=n(),ut=i("p"),ut.innerHTML=ja,Cl=n(),p(dt.$$.fragment),xl=n(),mt=i("p"),mt.textContent=Ua,$l=n(),p(ft.$$.fragment),Il=n(),wt=i("p"),wt.innerHTML=ka,_l=n(),p(yt.$$.fragment),Zl=n(),Mt=i("p"),Mt.textContent=Ca,Wl=n(),p(gt.$$.fragment),Hl=n(),vt=i("p"),vt.textContent=xa,Nl=n(),A=i("h2"),se=i("a"),as=i("span"),p(bt.$$.fragment),Tn=n(),Pt=i("span"),Pt.textContent=$a,Bl=n(),Tt=i("p"),Tt.innerHTML=Ia,Al=n(),p(Jt.$$.fragment),Gl=n(),jt=i("p"),jt.textContent=_a,Sl=n(),Ut=i("ul"),Ut.innerHTML=Za,Ll=n(),kt=i("p"),kt.textContent=Wa,Vl=n(),G=i("h2"),le=i("a"),is=i("span"),p(Ct.$$.fragment),Jn=n(),Ft=i("span"),Ft.textContent=Ha,El=n(),xt=i("p"),xt.textContent=Na,ql=n(),$t=i("p"),$t.innerHTML=Ba,Yl=n(),It=i("p"),It.innerHTML=Aa,Ql=n(),p(_t.$$.fragment),zl=n(),Zt=i("p"),Zt.innerHTML=Ga,Rl=n(),p(Wt.$$.fragment),Xl=n(),ne=i("div"),ne.innerHTML=Sa,Pl=n(),p(ae.$$.fragment),Fl=n(),Ht=i("p"),Ht.innerHTML=La,Dl=n(),Nt=i("p"),Nt.textContent=Va,Kl=n(),p(Bt.$$.fragment),Ol=n(),At=i("p"),At.textContent=Ea,en=n(),Gt=i("p"),Gt.innerHTML=qa,tn=n(),os=i("p"),this.h()},l(e){const s=fi("svelte-1phssyn",document.head);g=o(s,"META",{name:!0,content:!0}),s.forEach(t),M=a(e),J=o(e,"P",{}),y(J).forEach(t),C=a(e),T=o(e,"H1",{class:!0});var St=y(T);j=o(St,"A",{id:!0,class:!0,href:!0});var rs=y(j);k=o(rs,"SPAN",{});var hs=y(k);u(b.$$.fragment,hs),hs.forEach(t),rs.forEach(t),x=a(St),Lt=o(St,"SPAN",{"data-svelte-h":!0}),r(Lt)!=="svelte-1mau1nb"&&(Lt.textContent=Un),St.forEach(t),us=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-11bxms2"&&(ie.innerHTML=kn),ds=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-m7grsz"&&(oe.textContent=Cn),ms=a(e),L=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-1tdavdk"&&(L.innerHTML=xn),fs=a(e),$=o(e,"H3",{class:!0});var ln=y($);V=o(ln,"A",{id:!0,class:!0,href:!0});var Ya=y(V);Dt=o(Ya,"SPAN",{});var Qa=y(Dt);u(re.$$.fragment,Qa),Qa.forEach(t),Ya.forEach(t),mn=a(ln),Vt=o(ln,"SPAN",{"data-svelte-h":!0}),r(Vt)!=="svelte-1yjth49"&&(Vt.textContent=$n),ln.forEach(t),ws=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-win72"&&(he.textContent=In),ys=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1lk8spd"&&(ce.textContent=_n),Ms=a(e),I=o(e,"H3",{class:!0});var nn=y(I);E=o(nn,"A",{id:!0,class:!0,href:!0});var za=y(E);Kt=o(za,"SPAN",{});var Ra=y(Kt);u(pe.$$.fragment,Ra),Ra.forEach(t),za.forEach(t),fn=a(nn),Et=o(nn,"SPAN",{"data-svelte-h":!0}),r(Et)!=="svelte-tydn49"&&(Et.textContent=Zn),nn.forEach(t),gs=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-npjebc"&&(ue.textContent=Wn),vs=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-eowjnn"&&(de.textContent=Hn),bs=a(e),_=o(e,"H3",{class:!0});var an=y(_);q=o(an,"A",{id:!0,class:!0,href:!0});var Xa=y(q);Ot=o(Xa,"SPAN",{});var Pa=y(Ot);u(me.$$.fragment,Pa),Pa.forEach(t),Xa.forEach(t),wn=a(an),qt=o(an,"SPAN",{"data-svelte-h":!0}),r(qt)!=="svelte-zesnkf"&&(qt.textContent=Nn),an.forEach(t),Ts=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-s64ikd"&&(fe.innerHTML=Bn),Js=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-k3i71h"&&(we.textContent=An),js=a(e),Z=o(e,"H3",{class:!0});var on=y(Z);Y=o(on,"A",{id:!0,class:!0,href:!0});var Fa=y(Y);es=o(Fa,"SPAN",{});var Da=y(es);u(ye.$$.fragment,Da),Da.forEach(t),Fa.forEach(t),yn=a(on),Yt=o(on,"SPAN",{"data-svelte-h":!0}),r(Yt)!=="svelte-42igp4"&&(Yt.textContent=Gn),on.forEach(t),Us=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-fhg2dn"&&(Me.textContent=Sn),ks=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1yl3el9"&&(ge.textContent=Ln),Cs=a(e),u(Q.$$.fragment,e),xs=a(e),W=o(e,"H2",{class:!0});var rn=y(W);z=o(rn,"A",{id:!0,class:!0,href:!0});var Ka=y(z);ts=o(Ka,"SPAN",{});var Oa=y(ts);u(ve.$$.fragment,Oa),Oa.forEach(t),Ka.forEach(t),Mn=a(rn),Qt=o(rn,"SPAN",{"data-svelte-h":!0}),r(Qt)!=="svelte-1rcafcg"&&(Qt.textContent=Vn),rn.forEach(t),$s=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-11xidww"&&(be.innerHTML=En),Is=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1s0beaa"&&(Te.textContent=qn),_s=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1yre5xi"&&(Je.innerHTML=Yn),Zs=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-csh5dy"&&(je.textContent=Qn),Ws=a(e),R=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(R)!=="svelte-bqfzrn"&&(R.innerHTML=zn),Hs=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-6zblrj"&&(Ue.textContent=Rn),Ns=a(e),X=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(X)!=="svelte-1t2za6k"&&(X.innerHTML=Xn),Bs=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-7t6r33"&&(ke.innerHTML=Pn),As=a(e),P=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(P)!=="svelte-1sstogo"&&(P.innerHTML=Fn),Gs=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1mp71ex"&&(Ce.innerHTML=Dn),Ss=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1wcx2fs"&&(xe.innerHTML=Kn),Ls=a(e),u($e.$$.fragment,e),Vs=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1h82zgp"&&(Ie.innerHTML=On),Es=a(e),u(_e.$$.fragment,e),qs=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1ezdz2s"&&(Ze.innerHTML=ea),Ys=a(e),u(We.$$.fragment,e),Qs=a(e),u(He.$$.fragment,e),zs=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1yzqpu5"&&(Ne.innerHTML=ta),Rs=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-swzzsy"&&(Be.innerHTML=sa),Xs=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-d8mgn1"&&(Ae.innerHTML=la),Ps=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1dht7iu"&&(Ge.innerHTML=na),Fs=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1fw82gd"&&(Se.innerHTML=aa),Ds=a(e),u(Le.$$.fragment,e),Ks=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-elfuuf"&&(Ve.innerHTML=ia),Os=a(e),u(Ee.$$.fragment,e),el=a(e),u(qe.$$.fragment,e),tl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-17ytkn3"&&(Ye.innerHTML=oa),sl=a(e),H=o(e,"H2",{class:!0});var hn=y(H);F=o(hn,"A",{id:!0,class:!0,href:!0});var ei=y(F);ss=o(ei,"SPAN",{});var ti=y(ss);u(Qe.$$.fragment,ti),ti.forEach(t),ei.forEach(t),gn=a(hn),zt=o(hn,"SPAN",{"data-svelte-h":!0}),r(zt)!=="svelte-18iq23z"&&(zt.textContent=ra),hn.forEach(t),ll=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-x83m7j"&&(ze.innerHTML=ha),nl=a(e),u(Re.$$.fragment,e),al=a(e),u(D.$$.fragment,e),il=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-jjozqo"&&(Xe.innerHTML=ca),ol=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-16oab1u"&&(Pe.innerHTML=pa),rl=a(e),u(Fe.$$.fragment,e),hl=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1h6pf22"&&(De.textContent=ua),cl=a(e),u(Ke.$$.fragment,e),pl=a(e),u(Oe.$$.fragment,e),ul=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1hk7buj"&&(et.innerHTML=da),dl=a(e),N=o(e,"H2",{class:!0});var cn=y(N);K=o(cn,"A",{id:!0,class:!0,href:!0});var si=y(K);ls=o(si,"SPAN",{});var li=y(ls);u(tt.$$.fragment,li),li.forEach(t),si.forEach(t),vn=a(cn),Rt=o(cn,"SPAN",{"data-svelte-h":!0}),r(Rt)!=="svelte-1m3y5hs"&&(Rt.textContent=ma),cn.forEach(t),ml=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-dq0etq"&&(st.innerHTML=fa),fl=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-pt2fmn"&&(lt.innerHTML=wa),wl=a(e),O=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(O)!=="svelte-bxbti"&&(O.innerHTML=ya),yl=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-q4fxjc"&&(nt.innerHTML=Ma),Ml=a(e),ee=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(ee)!=="svelte-dbv2wd"&&(ee.innerHTML=ga),gl=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1p7tgmz"&&(at.innerHTML=va),vl=a(e),u(it.$$.fragment,e),bl=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-138rkn9"&&(ot.textContent=ba),Tl=a(e),u(rt.$$.fragment,e),Jl=a(e),u(ht.$$.fragment,e),jl=a(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1nbwfmv"&&(ct.textContent=Ta),Ul=a(e),B=o(e,"H2",{class:!0});var pn=y(B);te=o(pn,"A",{id:!0,class:!0,href:!0});var ni=y(te);ns=o(ni,"SPAN",{});var ai=y(ns);u(pt.$$.fragment,ai),ai.forEach(t),ni.forEach(t),bn=a(pn),Xt=o(pn,"SPAN",{"data-svelte-h":!0}),r(Xt)!=="svelte-8826vy"&&(Xt.textContent=Ja),pn.forEach(t),kl=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1qk4wbi"&&(ut.innerHTML=ja),Cl=a(e),u(dt.$$.fragment,e),xl=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1twafdm"&&(mt.textContent=Ua),$l=a(e),u(ft.$$.fragment,e),Il=a(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-15rml10"&&(wt.innerHTML=ka),_l=a(e),u(yt.$$.fragment,e),Zl=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1xqi1hq"&&(Mt.textContent=Ca),Wl=a(e),u(gt.$$.fragment,e),Hl=a(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-2evwpg"&&(vt.textContent=xa),Nl=a(e),A=o(e,"H2",{class:!0});var un=y(A);se=o(un,"A",{id:!0,class:!0,href:!0});var ii=y(se);as=o(ii,"SPAN",{});var oi=y(as);u(bt.$$.fragment,oi),oi.forEach(t),ii.forEach(t),Tn=a(un),Pt=o(un,"SPAN",{"data-svelte-h":!0}),r(Pt)!=="svelte-28v60c"&&(Pt.textContent=$a),un.forEach(t),Bl=a(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-a1o8gg"&&(Tt.innerHTML=Ia),Al=a(e),u(Jt.$$.fragment,e),Gl=a(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-19hw34h"&&(jt.textContent=_a),Sl=a(e),Ut=o(e,"UL",{"data-svelte-h":!0}),r(Ut)!=="svelte-41mgch"&&(Ut.innerHTML=Za),Ll=a(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-infbj7"&&(kt.textContent=Wa),Vl=a(e),G=o(e,"H2",{class:!0});var dn=y(G);le=o(dn,"A",{id:!0,class:!0,href:!0});var ri=y(le);is=o(ri,"SPAN",{});var hi=y(is);u(Ct.$$.fragment,hi),hi.forEach(t),ri.forEach(t),Jn=a(dn),Ft=o(dn,"SPAN",{"data-svelte-h":!0}),r(Ft)!=="svelte-1n1b62b"&&(Ft.textContent=Ha),dn.forEach(t),El=a(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-11bcz2b"&&(xt.textContent=Na),ql=a(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-x0jm20"&&($t.innerHTML=Ba),Yl=a(e),It=o(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-zis204"&&(It.innerHTML=Aa),Ql=a(e),u(_t.$$.fragment,e),zl=a(e),Zt=o(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1id51x6"&&(Zt.innerHTML=Ga),Rl=a(e),u(Wt.$$.fragment,e),Xl=a(e),ne=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(ne)!=="svelte-1ggy3u7"&&(ne.innerHTML=Sa),Pl=a(e),u(ae.$$.fragment,e),Fl=a(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-n30ots"&&(Ht.innerHTML=La),Dl=a(e),Nt=o(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1w2aefi"&&(Nt.textContent=Va),Kl=a(e),u(Bt.$$.fragment,e),Ol=a(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-k11338"&&(At.textContent=Ea),en=a(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-sxpcjd"&&(Gt.innerHTML=qa),tn=a(e),os=o(e,"P",{}),y(os).forEach(t),this.h()},h(){h(g,"name","hf:doc:metadata"),h(g,"content",JSON.stringify(vi)),h(j,"id","creating-a-voice-assistant"),h(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(j,"href","#creating-a-voice-assistant"),h(T,"class","relative group"),h(L,"class","flex justify-center"),h(V,"id","1-wake-word-detection"),h(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(V,"href","#1-wake-word-detection"),h($,"class","relative group"),h(E,"id","2-speech-transcription"),h(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(E,"href","#2-speech-transcription"),h(I,"class","relative group"),h(q,"id","3-language-model-query"),h(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(q,"href","#3-language-model-query"),h(_,"class","relative group"),h(Y,"id","4-synthesise-speech"),h(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Y,"href","#4-synthesise-speech"),h(Z,"class","relative group"),h(z,"id","wake-word-detection"),h(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(z,"href","#wake-word-detection"),h(W,"class","relative group"),h(R,"class","flex justify-center"),h(X,"class","flex justify-center"),h(P,"class","flex justify-center"),h(F,"id","speech-transcription"),h(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(F,"href","#speech-transcription"),h(H,"class","relative group"),h(K,"id","language-model-query"),h(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(K,"href","#language-model-query"),h(N,"class","relative group"),h(O,"class","flex justify-center"),h(ee,"class","flex justify-center"),h(te,"id","synthesise-speech"),h(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(te,"href","#synthesise-speech"),h(B,"class","relative group"),h(se,"id","marvin"),h(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(se,"href","#marvin"),h(A,"class","relative group"),h(le,"id","generalise-to-anything"),h(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(le,"href","#generalise-to-anything"),h(G,"class","relative group"),h(ne,"class","flex justify-center")},m(e,s){c(document.head,g),l(e,M,s),l(e,J,s),l(e,C,s),l(e,T,s),c(T,j),c(j,k),d(b,k,null),c(T,x),c(T,Lt),l(e,us,s),l(e,ie,s),l(e,ds,s),l(e,oe,s),l(e,ms,s),l(e,L,s),l(e,fs,s),l(e,$,s),c($,V),c(V,Dt),d(re,Dt,null),c($,mn),c($,Vt),l(e,ws,s),l(e,he,s),l(e,ys,s),l(e,ce,s),l(e,Ms,s),l(e,I,s),c(I,E),c(E,Kt),d(pe,Kt,null),c(I,fn),c(I,Et),l(e,gs,s),l(e,ue,s),l(e,vs,s),l(e,de,s),l(e,bs,s),l(e,_,s),c(_,q),c(q,Ot),d(me,Ot,null),c(_,wn),c(_,qt),l(e,Ts,s),l(e,fe,s),l(e,Js,s),l(e,we,s),l(e,js,s),l(e,Z,s),c(Z,Y),c(Y,es),d(ye,es,null),c(Z,yn),c(Z,Yt),l(e,Us,s),l(e,Me,s),l(e,ks,s),l(e,ge,s),l(e,Cs,s),d(Q,e,s),l(e,xs,s),l(e,W,s),c(W,z),c(z,ts),d(ve,ts,null),c(W,Mn),c(W,Qt),l(e,$s,s),l(e,be,s),l(e,Is,s),l(e,Te,s),l(e,_s,s),l(e,Je,s),l(e,Zs,s),l(e,je,s),l(e,Ws,s),l(e,R,s),l(e,Hs,s),l(e,Ue,s),l(e,Ns,s),l(e,X,s),l(e,Bs,s),l(e,ke,s),l(e,As,s),l(e,P,s),l(e,Gs,s),l(e,Ce,s),l(e,Ss,s),l(e,xe,s),l(e,Ls,s),d($e,e,s),l(e,Vs,s),l(e,Ie,s),l(e,Es,s),d(_e,e,s),l(e,qs,s),l(e,Ze,s),l(e,Ys,s),d(We,e,s),l(e,Qs,s),d(He,e,s),l(e,zs,s),l(e,Ne,s),l(e,Rs,s),l(e,Be,s),l(e,Xs,s),l(e,Ae,s),l(e,Ps,s),l(e,Ge,s),l(e,Fs,s),l(e,Se,s),l(e,Ds,s),d(Le,e,s),l(e,Ks,s),l(e,Ve,s),l(e,Os,s),d(Ee,e,s),l(e,el,s),d(qe,e,s),l(e,tl,s),l(e,Ye,s),l(e,sl,s),l(e,H,s),c(H,F),c(F,ss),d(Qe,ss,null),c(H,gn),c(H,zt),l(e,ll,s),l(e,ze,s),l(e,nl,s),d(Re,e,s),l(e,al,s),d(D,e,s),l(e,il,s),l(e,Xe,s),l(e,ol,s),l(e,Pe,s),l(e,rl,s),d(Fe,e,s),l(e,hl,s),l(e,De,s),l(e,cl,s),d(Ke,e,s),l(e,pl,s),d(Oe,e,s),l(e,ul,s),l(e,et,s),l(e,dl,s),l(e,N,s),c(N,K),c(K,ls),d(tt,ls,null),c(N,vn),c(N,Rt),l(e,ml,s),l(e,st,s),l(e,fl,s),l(e,lt,s),l(e,wl,s),l(e,O,s),l(e,yl,s),l(e,nt,s),l(e,Ml,s),l(e,ee,s),l(e,gl,s),l(e,at,s),l(e,vl,s),d(it,e,s),l(e,bl,s),l(e,ot,s),l(e,Tl,s),d(rt,e,s),l(e,Jl,s),d(ht,e,s),l(e,jl,s),l(e,ct,s),l(e,Ul,s),l(e,B,s),c(B,te),c(te,ns),d(pt,ns,null),c(B,bn),c(B,Xt),l(e,kl,s),l(e,ut,s),l(e,Cl,s),d(dt,e,s),l(e,xl,s),l(e,mt,s),l(e,$l,s),d(ft,e,s),l(e,Il,s),l(e,wt,s),l(e,_l,s),d(yt,e,s),l(e,Zl,s),l(e,Mt,s),l(e,Wl,s),d(gt,e,s),l(e,Hl,s),l(e,vt,s),l(e,Nl,s),l(e,A,s),c(A,se),c(se,as),d(bt,as,null),c(A,Tn),c(A,Pt),l(e,Bl,s),l(e,Tt,s),l(e,Al,s),d(Jt,e,s),l(e,Gl,s),l(e,jt,s),l(e,Sl,s),l(e,Ut,s),l(e,Ll,s),l(e,kt,s),l(e,Vl,s),l(e,G,s),c(G,le),c(le,is),d(Ct,is,null),c(G,Jn),c(G,Ft),l(e,El,s),l(e,xt,s),l(e,ql,s),l(e,$t,s),l(e,Yl,s),l(e,It,s),l(e,Ql,s),d(_t,e,s),l(e,zl,s),l(e,Zt,s),l(e,Rl,s),d(Wt,e,s),l(e,Xl,s),l(e,ne,s),l(e,Pl,s),d(ae,e,s),l(e,Fl,s),l(e,Ht,s),l(e,Dl,s),l(e,Nt,s),l(e,Kl,s),d(Bt,e,s),l(e,Ol,s),l(e,At,s),l(e,en,s),l(e,Gt,s),l(e,tn,s),l(e,os,s),sn=!0},p(e,[s]){const St={};s&2&&(St.$$scope={dirty:s,ctx:e}),Q.$set(St);const rs={};s&2&&(rs.$$scope={dirty:s,ctx:e}),D.$set(rs);const hs={};s&2&&(hs.$$scope={dirty:s,ctx:e}),ae.$set(hs)},i(e){sn||(m(b.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(ye.$$.fragment,e),m(Q.$$.fragment,e),m(ve.$$.fragment,e),m($e.$$.fragment,e),m(_e.$$.fragment,e),m(We.$$.fragment,e),m(He.$$.fragment,e),m(Le.$$.fragment,e),m(Ee.$$.fragment,e),m(qe.$$.fragment,e),m(Qe.$$.fragment,e),m(Re.$$.fragment,e),m(D.$$.fragment,e),m(Fe.$$.fragment,e),m(Ke.$$.fragment,e),m(Oe.$$.fragment,e),m(tt.$$.fragment,e),m(it.$$.fragment,e),m(rt.$$.fragment,e),m(ht.$$.fragment,e),m(pt.$$.fragment,e),m(dt.$$.fragment,e),m(ft.$$.fragment,e),m(yt.$$.fragment,e),m(gt.$$.fragment,e),m(bt.$$.fragment,e),m(Jt.$$.fragment,e),m(Ct.$$.fragment,e),m(_t.$$.fragment,e),m(Wt.$$.fragment,e),m(ae.$$.fragment,e),m(Bt.$$.fragment,e),sn=!0)},o(e){f(b.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(ye.$$.fragment,e),f(Q.$$.fragment,e),f(ve.$$.fragment,e),f($e.$$.fragment,e),f(_e.$$.fragment,e),f(We.$$.fragment,e),f(He.$$.fragment,e),f(Le.$$.fragment,e),f(Ee.$$.fragment,e),f(qe.$$.fragment,e),f(Qe.$$.fragment,e),f(Re.$$.fragment,e),f(D.$$.fragment,e),f(Fe.$$.fragment,e),f(Ke.$$.fragment,e),f(Oe.$$.fragment,e),f(tt.$$.fragment,e),f(it.$$.fragment,e),f(rt.$$.fragment,e),f(ht.$$.fragment,e),f(pt.$$.fragment,e),f(dt.$$.fragment,e),f(ft.$$.fragment,e),f(yt.$$.fragment,e),f(gt.$$.fragment,e),f(bt.$$.fragment,e),f(Jt.$$.fragment,e),f(Ct.$$.fragment,e),f(_t.$$.fragment,e),f(Wt.$$.fragment,e),f(ae.$$.fragment,e),f(Bt.$$.fragment,e),sn=!1},d(e){e&&(t(M),t(J),t(C),t(T),t(us),t(ie),t(ds),t(oe),t(ms),t(L),t(fs),t($),t(ws),t(he),t(ys),t(ce),t(Ms),t(I),t(gs),t(ue),t(vs),t(de),t(bs),t(_),t(Ts),t(fe),t(Js),t(we),t(js),t(Z),t(Us),t(Me),t(ks),t(ge),t(Cs),t(xs),t(W),t($s),t(be),t(Is),t(Te),t(_s),t(Je),t(Zs),t(je),t(Ws),t(R),t(Hs),t(Ue),t(Ns),t(X),t(Bs),t(ke),t(As),t(P),t(Gs),t(Ce),t(Ss),t(xe),t(Ls),t(Vs),t(Ie),t(Es),t(qs),t(Ze),t(Ys),t(Qs),t(zs),t(Ne),t(Rs),t(Be),t(Xs),t(Ae),t(Ps),t(Ge),t(Fs),t(Se),t(Ds),t(Ks),t(Ve),t(Os),t(el),t(tl),t(Ye),t(sl),t(H),t(ll),t(ze),t(nl),t(al),t(il),t(Xe),t(ol),t(Pe),t(rl),t(hl),t(De),t(cl),t(pl),t(ul),t(et),t(dl),t(N),t(ml),t(st),t(fl),t(lt),t(wl),t(O),t(yl),t(nt),t(Ml),t(ee),t(gl),t(at),t(vl),t(bl),t(ot),t(Tl),t(Jl),t(jl),t(ct),t(Ul),t(B),t(kl),t(ut),t(Cl),t(xl),t(mt),t($l),t(Il),t(wt),t(_l),t(Zl),t(Mt),t(Wl),t(Hl),t(vt),t(Nl),t(A),t(Bl),t(Tt),t(Al),t(Gl),t(jt),t(Sl),t(Ut),t(Ll),t(kt),t(Vl),t(G),t(El),t(xt),t(ql),t($t),t(Yl),t(It),t(Ql),t(zl),t(Zt),t(Rl),t(Xl),t(ne),t(Pl),t(Fl),t(Ht),t(Dl),t(Nt),t(Kl),t(Ol),t(At),t(en),t(Gt),t(tn),t(os)),t(g),w(b),w(re),w(pe),w(me),w(ye),w(Q,e),w(ve),w($e,e),w(_e,e),w(We,e),w(He,e),w(Le,e),w(Ee,e),w(qe,e),w(Qe),w(Re,e),w(D,e),w(Fe,e),w(Ke,e),w(Oe,e),w(tt),w(it,e),w(rt,e),w(ht,e),w(pt),w(dt,e),w(ft,e),w(yt,e),w(gt,e),w(bt),w(Jt,e),w(Ct),w(_t,e),w(Wt,e),w(ae,e),w(Bt,e)}}}const vi={local:"creating-a-voice-assistant",sections:[{local:null,sections:[{local:"1-wake-word-detection",title:"1. Wake word detection"},{local:"2-speech-transcription",title:"2. Speech transcription"},{local:"3-language-model-query",title:"3. Language model query"},{local:"4-synthesise-speech",title:"4. Synthesise speech"}],title:null},{local:"wake-word-detection",title:"Wake word detection"},{local:"speech-transcription",title:"Speech transcription"},{local:"language-model-query",title:"Language model query"},{local:"synthesise-speech",title:"Synthesise speech"},{local:"marvin",title:"Marvin 🤖"},{local:"generalise-to-anything",title:"Generalise to anything 🪄"}],title:"Creating a voice assistant"};function bi(S){return pi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ci extends di{constructor(g){super(),mi(this,g,bi,gi,ci,{})}}export{Ci as component};
