import{s as on,o as rn}from"../chunks/scheduler.f7e1785c.js";import{S as pn,i as un,g as n,s as l,u as d,A as hn,h as i,f as t,c as o,j as h,v as f,y as r,k as p,o as u,a as s,w as g,d as v,t as w,x as y,m as nn,n as ln}from"../chunks/index.815a732f.js";import{T as sn}from"../chunks/Tip.1258ac78.js";import{I as Re}from"../chunks/IconCopyLink.e7937f56.js";import{C as st}from"../chunks/CodeBlock.c6e8b464.js";function mn(Ve){let m;return{c(){m=nn(`💡 In practice, people use the term FFT interchangeably with DFT, as the FFT or Fast Fourier Transform is the only efficient
way to calculate the DFT on a computer.`)},l(c){m=ln(c,`💡 In practice, people use the term FFT interchangeably with DFT, as the FFT or Fast Fourier Transform is the only efficient
way to calculate the DFT on a computer.`)},m(c,b){s(c,m,b)},d(c){c&&t(m)}}}function cn(Ve){let m;return{c(){m=nn(`💡 Not all mel spectrograms are the same! There are two different mel scales in common use ("htk" and "slaney"),
and instead of the power spectrogram the amplitude spectrogram may be used. The conversion to a log-mel spectrogram doesn't
always compute true decibels but may simply take the \`log\`. Therefore, if a machine learning model expects a mel spectrogram
as input, double check to make sure you're computing it the same way.`)},l(c){m=ln(c,`💡 Not all mel spectrograms are the same! There are two different mel scales in common use ("htk" and "slaney"),
and instead of the power spectrogram the amplitude spectrogram may be used. The conversion to a log-mel spectrogram doesn't
always compute true decibels but may simply take the \`log\`. Therefore, if a machine learning model expects a mel spectrogram
as input, double check to make sure you're computing it the same way.`)},m(c,b){s(c,m,b)},d(c){c&&t(m)}}}function dn(Ve){let m,c,b,ct,x,J,nt,U,za,De,Pa="Introduction to audio data",dt,X,Za=`By nature, a sound wave is a continuous signal, meaning it contains an infinite number of signal values in a given time.
This poses problems for digital devices which expect finite arrays. To be processed, stored, and transmitted by digital
devices, the continuous sound wave needs to be converted into a series of discrete values, known as a digital representation.`,ft,A,Ua=`If you look at any audio dataset, you’ll find digital files with sound excerpts, such as text narration or music.
You may encounter different file formats such as <code>.wav</code> (Waveform Audio File), <code>.flac</code> (Free Lossless Audio Codec)
and <code>.mp3</code> (MPEG-1 Audio Layer 3). These formats mainly differ in how they compress the digital representation of the audio signal.`,gt,W,Xa=`Let’s take a look at how we arrive from a continuous signal to this representation. The analog signal is first captured by
a microphone, which converts the sound waves into an electrical signal. The electrical signal is then digitized by an
Analog-to-Digital Converter to get the digital representation through sampling.`,vt,T,H,it,N,Ia,Qe,Aa="Sampling and sampling rate",wt,Y,Wa=`Sampling is the process of measuring the value of a continuous signal at fixed time steps. The sampled waveform is <em>discrete</em>,
since it contains a finite number of signal values at uniform intervals.`,yt,q,Na='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/Signal_Sampling.png" alt="Signal sampling illustration"/>',bt,R,Ya='<em>Illustration from Wikipedia article: <a href="https://en.wikipedia.org/wiki/Sampling_(signal_processing)" rel="nofollow">Sampling (signal processing)</a></em>',xt,V,Ra=`The <strong>sampling rate</strong> (also called sampling frequency) is the number of samples taken in one second and is measured in
hertz (Hz). To give you a point of reference, CD-quality audio has a sampling rate of 44,100 Hz, meaning samples are taken
44,100 times per second. For comparison, high-resolution audio has a sampling rate of 192,000 Hz or 192 kHz. A common
sampling rate used in training speech models is 16,000 Hz or 16 kHz.`,Tt,D,Va=`The choice of sampling rate primarily determines the highest frequency that can be captured from the signal. This is also
known as the Nyquist limit and is exactly half the sampling rate. The audible frequencies in human speech are below 8 kHz
and therefore sampling speech at 16 kHz is sufficient. Using a higher sampling rate will not capture more information and
merely leads to an increase in the computational cost of processing such files. On the other hand, sampling audio at too
low a sampling rate will result in information loss. Speech sampled at 8 kHz will sound muffled, as the higher frequencies
cannot be captured at this rate.`,Ct,Q,Da=`It’s important to ensure that all audio examples in your dataset have the same sampling rate when working on any audio task.
If you plan to use custom audio data to fine-tune a pre-trained model, the sampling rate of your data should match the
sampling rate of the data the model was pre-trained on. The sampling rate determines the time interval between successive
audio samples, which impacts the temporal resolution of the audio data. Consider an example: a 5-second sound at a sampling
rate of 16,000 Hz will be represented as a series of 80,000 values, while the same 5-second sound at a sampling rate of
8,000 Hz will be represented as a series of 40,000 values. Transformer models that solve audio tasks treat examples as
sequences and rely on attention mechanisms to learn audio or multimodal representation. Since sequences are different for
audio examples at different sampling rates, it will be challenging for models to generalize between sampling rates.
<strong>Resampling</strong> is the process of making the sampling rates match, and is part of <a href="preprocessing#resampling-the-audio-data">preprocessing</a> the audio data.`,kt,C,j,lt,K,Ba,Ke,Qa="Amplitude and bit depth",Mt,O,Ka="While the sampling rate tells you how often the samples are taken, what exactly are the values in each sample?",_t,ee,Oa=`Sound is made by changes in air pressure at frequencies that are audible to humans. The <strong>amplitude</strong> of a sound describes
the sound pressure level at any given instant and is measured in decibels (dB). We perceive the amplitude as loudness.
To give you an example, a normal speaking voice is under 60 dB, and a rock concert can be at around 125 dB, pushing the
limits of human hearing.`,$t,te,es=`In digital audio, each audio sample records the amplitude of the audio wave at a point in time. The <strong>bit depth</strong> of the
sample determines with how much precision this amplitude value can be described. The higher the bit depth, the more
faithfully the digital representation approximates the original continuous sound wave.`,Jt,ae,ts=`The most common audio bit depths are 16-bit and 24-bit. Each is a binary term, representing the number of possible steps
to which the amplitude value can be quantized when it’s converted from continuous to discrete: 65,536 steps for 16-bit audio,
a whopping 16,777,216 steps for 24-bit audio. Because quantizing involves rounding off the continuous value to a discrete
value, the sampling process introduces noise. The higher the bit depth, the smaller this quantization noise. In practice,
the quantization noise of 16-bit audio is already small enough to be inaudible, and using higher bit depths is generally
not necessary.`,Ht,se,as=`You may also come across 32-bit audio. This stores the samples as floating-point values, whereas 16-bit and 24-bit audio
use integer samples. The precision of a 32-bit floating-point value is 24 bits, giving it the same bit depth as 24-bit audio.
Floating-point audio samples are expected to lie within the [-1.0, 1.0] range. Since machine learning models naturally
work on floating-point data, the audio must first be converted into floating-point format before it can be used to train
the model. We’ll see how to do this in the next section on <a href="preprocessing">Preprocessing</a>.`,qt,ne,ss=`Just as with continuous audio signals, the amplitude of digital audio is typically expressed in decibels (dB). Since
human hearing is logarithmic in nature — our ears are more sensitive to small fluctuations in quiet sounds than in loud
sounds — the loudness of a sound is easier to interpret if the amplitudes are in decibels, which are also logarithmic.
The decibel scale for real-world audio starts at 0 dB, which represents the quietest possible sound humans can hear, and
louder sounds have larger values. However, for digital audio signals, 0 dB is the loudest possible amplitude, while all
other amplitudes are negative. As a quick rule of thumb: every -6 dB is a halving of the amplitude, and anything below -60 dB
is generally inaudible unless you really crank up the volume.`,jt,k,G,ot,ie,Sa,Oe,ns="Audio as a waveform",Gt,le,is=`You may have seen sounds visualized as a <strong>waveform</strong>, which plots the sample values over time and illustrates the changes
in the sound’s amplitude. This is also known as the <em>time domain</em> representation of sound.`,zt,oe,ls=`This type of visualization is useful for identifying specific features of the audio signal such as the timing of individual
sound events, the overall loudness of the signal, and any irregularities or noise present in the audio.`,It,re,os="To plot the waveform for an audio signal, we can use a Python library called <code>librosa</code>:",Bt,pe,St,ue,rs="Let’s take an example sound called “trumpet” that comes with the library:",Ft,he,Lt,me,ps=`The example is loaded as a tuple of audio time series (here we call it <code>array</code>), and sampling rate (<code>sampling_rate</code>).
Let’s take a look at this sound’s waveform by using librosa’s <code>waveshow()</code> function:`,Et,ce,Pt,z,us='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_plot.png" alt="Waveform plot"/>',Zt,de,hs=`This plots the amplitude of the signal on the y-axis and time along the x-axis. In other words, each point corresponds
to a single sample value that was taken when this sound was sampled. Also note that librosa returns the audio as
floating-point values already, and that the amplitude values are indeed within the [-1.0, 1.0] range.`,Ut,fe,ms=`Visualizing the audio along with listening to it can be a useful tool for understanding the data you are working with.
You can see the shape of the signal, observe patterns, learn to spot noise or distortion. If you preprocess data in some
ways, such as normalization, resampling, or filtering, you can visually confirm that preprocessing steps have been applied as expected.
After training a model, you can also visualize samples where errors occur (e.g. in audio classification task) to debug
the issue.`,Xt,M,I,rt,ge,Fa,et,cs="The frequency spectrum",At,ve,ds=`Another way to visualize audio data is to plot the <strong>frequency spectrum</strong> of an audio signal, also known as the <em>frequency domain</em>
representation. The spectrum is computed using the discrete Fourier transform or DFT. It describes the individual frequencies
that make up the signal and how strong they are.`,Wt,we,fs=`Let’s plot the frequency spectrum for the same trumpet sound by taking the DFT using numpy’s <code>rfft()</code> function. While it
is possible to plot the spectrum of the entire sound, it’s more useful to look at a small region instead. Here we’ll take
the DFT over the first 4096 samples, which is roughly the length of the first note being played:`,Nt,ye,Yt,B,gs='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/spectrum_plot.png" alt="Spectrum plot"/>',Rt,be,vs=`This plots the strength of the various frequency components that are present in this audio segment. The frequency values are on
the x-axis, usually plotted on a logarithmic scale, while their amplitudes are on the y-axis.`,Vt,xe,ws=`The frequency spectrum that we plotted shows several peaks. These peaks correspond to the harmonics of the note that’s
being played, with the higher harmonics being quieter. Since the first peak is at around 620 Hz, this is the frequency spectrum of an E♭ note.`,Dt,Te,ys=`The output of the DFT is an array of complex numbers, made up of real and imaginary components. Taking
the magnitude with <code>np.abs(dft)</code> extracts the amplitude information from the spectrogram. The angle between the real and
imaginary components provides the so-called phase spectrum, but this is often discarded in machine learning applications.`,Qt,Ce,bs=`You used <code>librosa.amplitude_to_db()</code> to convert the amplitude values to the decibel scale, making it easier to see
the finer details in the spectrum. Sometimes people use the <strong>power spectrum</strong>, which measures energy rather than amplitude;
this is simply a spectrum with the amplitude values squared.`,Kt,S,Ot,ke,xs=`The frequency spectrum of an audio signal contains the exact same information as its waveform — they are simply two different
ways of looking at the same data (here, the first 4096 samples from the trumpet sound). Where the waveform plots the amplitude
of the audio signal over time, the spectrum visualizes the amplitudes of the individual frequencies at a fixed point in time.`,ea,_,F,pt,Me,La,tt,Ts="Spectrogram",ta,_e,Cs=`What if we want to see how the frequencies in an audio signal change? The trumpet plays several notes and they all have
different frequencies. The problem is that the spectrum only shows a frozen snapshot of the frequencies at a given instant.
The solution is to take multiple DFTs, each covering only a small slice of time, and stack the resulting spectra together
into a <strong>spectrogram</strong>.`,aa,$e,ks=`A spectrogram plots the frequency content of an audio signal as it changes over time. It allows you to see time, frequency,
and amplitude all on one graph. The algorithm that performs this computation is the STFT or Short Time Fourier Transform.`,sa,Je,Ms=`The spectrogram is one of the most informative audio tools available to you. For example, when working with a music recording,
you can see the various instruments and vocal tracks and how they contribute to the overall sound. In speech, you can
identify different vowel sounds as each vowel is characterized by particular frequencies.`,na,He,_s="Let’s plot a spectrogram for the same trumpet sound, using librosa’s <code>stft()</code> and <code>specshow()</code> functions:",ia,qe,la,L,$s='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/spectrogram_plot.png" alt="Spectrogram plot"/>',oa,je,Js=`In this plot, the x-axis represents time as in the waveform visualization but now the y-axis represents frequency in Hz.
The intensity of the color gives the amplitude or power of the frequency component at each point in time, measured in decibels (dB).`,ra,Ge,Hs=`The spectrogram is created by taking short segments of the audio signal, typically lasting a few milliseconds, and calculating
the discrete Fourier transform of each segment to obtain its frequency spectrum. The resulting spectra are then stacked
together on the time axis to create the spectrogram. Each vertical slice in this image corresponds to a single frequency
spectrum, seen from the top. By default, <code>librosa.stft()</code> splits the audio signal into segments of 2048 samples, which
gives a good trade-off between frequency resolution and time resolution.`,pa,ze,qs=`Since the spectrogram and the waveform are different views of the same data, it’s possible to turn the spectrogram back
into the original waveform using the inverse STFT. However, this requires the phase information in addition to the amplitude
information. If the spectrogram was generated by a machine learning model, it typically only outputs the amplitudes. In
that case, we can use a phase reconstruction algorithm such as the classic Griffin-Lim algorithm, or using a neural network
called a vocoder, to reconstruct a waveform from the spectrogram.`,ua,Ie,js=`Spectrograms aren’t just used for visualization. Many machine learning models will take spectrograms as input — as opposed
to waveforms — and produce spectrograms as output.`,ha,Be,Gs="Now that we know what a spectrogram is and how it’s made, let’s take a look at a variant of it widely used for speech processing: the mel spectrogram.",ma,$,E,ut,Se,Ea,at,zs="Mel spectrogram",ca,Fe,Is=`A mel spectrogram is a variation of the spectrogram that is commonly used in speech processing and machine learning tasks.
It is similar to a spectrogram in that it shows the frequency content of an audio signal over time, but on a different frequency axis.`,da,Le,Bs=`In a standard spectrogram, the frequency axis is linear and is measured in hertz (Hz). However, the human auditory system
is more sensitive to changes in lower frequencies than higher frequencies, and this sensitivity decreases logarithmically
as frequency increases. The mel scale is a perceptual scale that approximates the non-linear frequency response of the human ear.`,fa,Ee,Ss=`To create a mel spectrogram, the STFT is used just like before, splitting the audio into short segments to obtain a sequence
of frequency spectra. Additionally, each spectrum is sent through a set of filters, the so-called mel filterbank, to
transform the frequencies to the mel scale.`,ga,Pe,Fs="Let’s see how we can plot a mel spectrogram using librosa’s <code>melspectrogram()</code> function, which performs all of those steps for us:",va,Ze,wa,P,Ls='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/mel-spectrogram.png" alt="Mel spectrogram plot"/>',ya,Ue,Es=`In the example above, <code>n_mels</code> stands for the number of mel bands to generate. The mel bands define a set of frequency
ranges that divide the spectrum into perceptually meaningful components, using a set of filters whose shape and spacing
are chosen to mimic the way the human ear responds to different frequencies. Common values for <code>n_mels</code> are 40 or 80. <code>fmax</code>
indicates the highest frequency (in Hz) we care about.`,ba,Xe,Ps=`Just as with a regular spectrogram, it’s common practice to express the strength of the mel frequency components in
decibels. This is commonly referred to as a <strong>log-mel spectrogram</strong>, because the conversion to decibels involves a
logarithmic operation. The above example used <code>librosa.power_to_db()</code> as <code>librosa.feature.melspectrogram()</code> creates a power spectrogram.`,xa,Z,Ta,Ae,Zs=`Creating a mel spectrogram is a lossy operation as it involves filtering the signal. Converting a mel spectrogram back
into a waveform is more difficult than doing this for a regular spectrogram, as it requires estimating the frequencies
that were thrown away. This is why machine learning models such as HiFiGAN vocoder are needed to produce a waveform from a mel
spectrogram.`,Ca,We,Us=`Compared to a standard spectrogram, a mel spectrogram can capture more meaningful features of the audio signal for
human perception, making it a popular choice in tasks such as speech recognition, speaker identification, and music genre classification.`,ka,Ne,Xs="Now that you know how to visualize audio data examples, go ahead and try to see what your favorite sounds look like. :)",Ma,ht,_a;return U=new Re({}),N=new Re({}),K=new Re({}),ie=new Re({}),pe=new st({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxpYnJvc2E=",highlighted:"pip install librosa"}}),he=new st({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQSUwQWFycmF5JTJDJTIwc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGxpYnJvc2EubG9hZChsaWJyb3NhLmV4KCUyMnRydW1wZXQlMjIpKQ==",highlighted:`<span class="hljs-keyword">import</span> librosa

array, sampling_rate = librosa.load(librosa.ex(<span class="hljs-string">&quot;trumpet&quot;</span>))`}}),ce=new st({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMGxpYnJvc2EuZGlzcGxheSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LndhdmVzaG93KGFycmF5JTJDJTIwc3IlM0RzYW1wbGluZ19yYXRlKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`}}),ge=new Re({}),ye=new st({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZGZ0X2lucHV0JTIwJTNEJTIwYXJyYXklNUIlM0E0MDk2JTVEJTBBJTBBJTIzJTIwY2FsY3VsYXRlJTIwdGhlJTIwREZUJTBBd2luZG93JTIwJTNEJTIwbnAuaGFubmluZyhsZW4oZGZ0X2lucHV0KSklMEF3aW5kb3dlZF9pbnB1dCUyMCUzRCUyMGRmdF9pbnB1dCUyMColMjB3aW5kb3clMEFkZnQlMjAlM0QlMjBucC5mZnQucmZmdCh3aW5kb3dlZF9pbnB1dCklMEElMEElMjMlMjBnZXQlMjB0aGUlMjBhbXBsaXR1ZGUlMjBzcGVjdHJ1bSUyMGluJTIwZGVjaWJlbHMlMEFhbXBsaXR1ZGUlMjAlM0QlMjBucC5hYnMoZGZ0KSUwQWFtcGxpdHVkZV9kYiUyMCUzRCUyMGxpYnJvc2EuYW1wbGl0dWRlX3RvX2RiKGFtcGxpdHVkZSUyQyUyMHJlZiUzRG5wLm1heCklMEElMEElMjMlMjBnZXQlMjB0aGUlMjBmcmVxdWVuY3klMjBiaW5zJTBBZnJlcXVlbmN5JTIwJTNEJTIwbGlicm9zYS5mZnRfZnJlcXVlbmNpZXMoc3IlM0RzYW1wbGluZ19yYXRlJTJDJTIwbl9mZnQlM0RsZW4oZGZ0X2lucHV0KSklMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQXBsdC5wbG90KGZyZXF1ZW5jeSUyQyUyMGFtcGxpdHVkZV9kYiklMEFwbHQueGxhYmVsKCUyMkZyZXF1ZW5jeSUyMChIeiklMjIpJTBBcGx0LnlsYWJlbCglMjJBbXBsaXR1ZGUlMjAoZEIpJTIyKSUwQXBsdC54c2NhbGUoJTIybG9nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

dft_input = array[:<span class="hljs-number">4096</span>]

<span class="hljs-comment"># calculate the DFT</span>
window = np.hanning(<span class="hljs-built_in">len</span>(dft_input))
windowed_input = dft_input * window
dft = np.fft.rfft(windowed_input)

<span class="hljs-comment"># get the amplitude spectrum in decibels</span>
amplitude = np.<span class="hljs-built_in">abs</span>(dft)
amplitude_db = librosa.amplitude_to_db(amplitude, ref=np.<span class="hljs-built_in">max</span>)

<span class="hljs-comment"># get the frequency bins</span>
frequency = librosa.fft_frequencies(sr=sampling_rate, n_fft=<span class="hljs-built_in">len</span>(dft_input))

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
plt.plot(frequency, amplitude_db)
plt.xlabel(<span class="hljs-string">&quot;Frequency (Hz)&quot;</span>)
plt.ylabel(<span class="hljs-string">&quot;Amplitude (dB)&quot;</span>)
plt.xscale(<span class="hljs-string">&quot;log&quot;</span>)`}}),S=new sn({props:{$$slots:{default:[mn]},$$scope:{ctx:Ve}}}),Me=new Re({}),qe=new st({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBRCUyMCUzRCUyMGxpYnJvc2Euc3RmdChhcnJheSklMEFTX2RiJTIwJTNEJTIwbGlicm9zYS5hbXBsaXR1ZGVfdG9fZGIobnAuYWJzKEQpJTJDJTIwcmVmJTNEbnAubWF4KSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LnNwZWNzaG93KFNfZGIlMkMlMjB4X2F4aXMlM0QlMjJ0aW1lJTIyJTJDJTIweV9heGlzJTNEJTIyaHolMjIpJTBBcGx0LmNvbG9yYmFyKCk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

D = librosa.stft(array)
S_db = librosa.amplitude_to_db(np.<span class="hljs-built_in">abs</span>(D), ref=np.<span class="hljs-built_in">max</span>)

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(S_db, x_axis=<span class="hljs-string">&quot;time&quot;</span>, y_axis=<span class="hljs-string">&quot;hz&quot;</span>)
plt.colorbar()`}}),Se=new Re({}),Ze=new st({props:{code:"UyUyMCUzRCUyMGxpYnJvc2EuZmVhdHVyZS5tZWxzcGVjdHJvZ3JhbSh5JTNEYXJyYXklMkMlMjBzciUzRHNhbXBsaW5nX3JhdGUlMkMlMjBuX21lbHMlM0QxMjglMkMlMjBmbWF4JTNEODAwMCklMEFTX2RCJTIwJTNEJTIwbGlicm9zYS5wb3dlcl90b19kYihTJTJDJTIwcmVmJTNEbnAubWF4KSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LnNwZWNzaG93KFNfZEIlMkMlMjB4X2F4aXMlM0QlMjJ0aW1lJTIyJTJDJTIweV9heGlzJTNEJTIybWVsJTIyJTJDJTIwc3IlM0RzYW1wbGluZ19yYXRlJTJDJTIwZm1heCUzRDgwMDApJTBBcGx0LmNvbG9yYmFyKCk=",highlighted:`S = librosa.feature.melspectrogram(y=array, sr=sampling_rate, n_mels=<span class="hljs-number">128</span>, fmax=<span class="hljs-number">8000</span>)
S_dB = librosa.power_to_db(S, ref=np.<span class="hljs-built_in">max</span>)

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(S_dB, x_axis=<span class="hljs-string">&quot;time&quot;</span>, y_axis=<span class="hljs-string">&quot;mel&quot;</span>, sr=sampling_rate, fmax=<span class="hljs-number">8000</span>)
plt.colorbar()`}}),Z=new sn({props:{$$slots:{default:[cn]},$$scope:{ctx:Ve}}}),{c(){m=n("meta"),c=l(),b=n("p"),ct=l(),x=n("h1"),J=n("a"),nt=n("span"),d(U.$$.fragment),za=l(),De=n("span"),De.textContent=Pa,dt=l(),X=n("p"),X.textContent=Za,ft=l(),A=n("p"),A.innerHTML=Ua,gt=l(),W=n("p"),W.textContent=Xa,vt=l(),T=n("h2"),H=n("a"),it=n("span"),d(N.$$.fragment),Ia=l(),Qe=n("span"),Qe.textContent=Aa,wt=l(),Y=n("p"),Y.innerHTML=Wa,yt=l(),q=n("div"),q.innerHTML=Na,bt=l(),R=n("p"),R.innerHTML=Ya,xt=l(),V=n("p"),V.innerHTML=Ra,Tt=l(),D=n("p"),D.textContent=Va,Ct=l(),Q=n("p"),Q.innerHTML=Da,kt=l(),C=n("h2"),j=n("a"),lt=n("span"),d(K.$$.fragment),Ba=l(),Ke=n("span"),Ke.textContent=Qa,Mt=l(),O=n("p"),O.textContent=Ka,_t=l(),ee=n("p"),ee.innerHTML=Oa,$t=l(),te=n("p"),te.innerHTML=es,Jt=l(),ae=n("p"),ae.textContent=ts,Ht=l(),se=n("p"),se.innerHTML=as,qt=l(),ne=n("p"),ne.textContent=ss,jt=l(),k=n("h2"),G=n("a"),ot=n("span"),d(ie.$$.fragment),Sa=l(),Oe=n("span"),Oe.textContent=ns,Gt=l(),le=n("p"),le.innerHTML=is,zt=l(),oe=n("p"),oe.textContent=ls,It=l(),re=n("p"),re.innerHTML=os,Bt=l(),d(pe.$$.fragment),St=l(),ue=n("p"),ue.textContent=rs,Ft=l(),d(he.$$.fragment),Lt=l(),me=n("p"),me.innerHTML=ps,Et=l(),d(ce.$$.fragment),Pt=l(),z=n("div"),z.innerHTML=us,Zt=l(),de=n("p"),de.textContent=hs,Ut=l(),fe=n("p"),fe.textContent=ms,Xt=l(),M=n("h2"),I=n("a"),rt=n("span"),d(ge.$$.fragment),Fa=l(),et=n("span"),et.textContent=cs,At=l(),ve=n("p"),ve.innerHTML=ds,Wt=l(),we=n("p"),we.innerHTML=fs,Nt=l(),d(ye.$$.fragment),Yt=l(),B=n("div"),B.innerHTML=gs,Rt=l(),be=n("p"),be.textContent=vs,Vt=l(),xe=n("p"),xe.textContent=ws,Dt=l(),Te=n("p"),Te.innerHTML=ys,Qt=l(),Ce=n("p"),Ce.innerHTML=bs,Kt=l(),d(S.$$.fragment),Ot=l(),ke=n("p"),ke.textContent=xs,ea=l(),_=n("h2"),F=n("a"),pt=n("span"),d(Me.$$.fragment),La=l(),tt=n("span"),tt.textContent=Ts,ta=l(),_e=n("p"),_e.innerHTML=Cs,aa=l(),$e=n("p"),$e.textContent=ks,sa=l(),Je=n("p"),Je.textContent=Ms,na=l(),He=n("p"),He.innerHTML=_s,ia=l(),d(qe.$$.fragment),la=l(),L=n("div"),L.innerHTML=$s,oa=l(),je=n("p"),je.textContent=Js,ra=l(),Ge=n("p"),Ge.innerHTML=Hs,pa=l(),ze=n("p"),ze.textContent=qs,ua=l(),Ie=n("p"),Ie.textContent=js,ha=l(),Be=n("p"),Be.textContent=Gs,ma=l(),$=n("h2"),E=n("a"),ut=n("span"),d(Se.$$.fragment),Ea=l(),at=n("span"),at.textContent=zs,ca=l(),Fe=n("p"),Fe.textContent=Is,da=l(),Le=n("p"),Le.textContent=Bs,fa=l(),Ee=n("p"),Ee.textContent=Ss,ga=l(),Pe=n("p"),Pe.innerHTML=Fs,va=l(),d(Ze.$$.fragment),wa=l(),P=n("div"),P.innerHTML=Ls,ya=l(),Ue=n("p"),Ue.innerHTML=Es,ba=l(),Xe=n("p"),Xe.innerHTML=Ps,xa=l(),d(Z.$$.fragment),Ta=l(),Ae=n("p"),Ae.textContent=Zs,Ca=l(),We=n("p"),We.textContent=Us,ka=l(),Ne=n("p"),Ne.textContent=Xs,Ma=l(),ht=n("p"),this.h()},l(e){const a=hn("svelte-1phssyn",document.head);m=i(a,"META",{name:!0,content:!0}),a.forEach(t),c=o(e),b=i(e,"P",{}),h(b).forEach(t),ct=o(e),x=i(e,"H1",{class:!0});var Ye=h(x);J=i(Ye,"A",{id:!0,class:!0,href:!0});var mt=h(J);nt=i(mt,"SPAN",{});var As=h(nt);f(U.$$.fragment,As),As.forEach(t),mt.forEach(t),za=o(Ye),De=i(Ye,"SPAN",{"data-svelte-h":!0}),r(De)!=="svelte-14dncmm"&&(De.textContent=Pa),Ye.forEach(t),dt=o(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1pmkh95"&&(X.textContent=Za),ft=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-bb9jdf"&&(A.innerHTML=Ua),gt=o(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1nxlqp8"&&(W.textContent=Xa),vt=o(e),T=i(e,"H2",{class:!0});var $a=h(T);H=i($a,"A",{id:!0,class:!0,href:!0});var Ws=h(H);it=i(Ws,"SPAN",{});var Ns=h(it);f(N.$$.fragment,Ns),Ns.forEach(t),Ws.forEach(t),Ia=o($a),Qe=i($a,"SPAN",{"data-svelte-h":!0}),r(Qe)!=="svelte-edsm0y"&&(Qe.textContent=Aa),$a.forEach(t),wt=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-ou5bn8"&&(Y.innerHTML=Wa),yt=o(e),q=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(q)!=="svelte-1g809yq"&&(q.innerHTML=Na),bt=o(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-42toji"&&(R.innerHTML=Ya),xt=o(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1bavgg"&&(V.innerHTML=Ra),Tt=o(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-erenf"&&(D.textContent=Va),Ct=o(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-vwfzx1"&&(Q.innerHTML=Da),kt=o(e),C=i(e,"H2",{class:!0});var Ja=h(C);j=i(Ja,"A",{id:!0,class:!0,href:!0});var Ys=h(j);lt=i(Ys,"SPAN",{});var Rs=h(lt);f(K.$$.fragment,Rs),Rs.forEach(t),Ys.forEach(t),Ba=o(Ja),Ke=i(Ja,"SPAN",{"data-svelte-h":!0}),r(Ke)!=="svelte-yw8rt"&&(Ke.textContent=Qa),Ja.forEach(t),Mt=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-aeraln"&&(O.textContent=Ka),_t=o(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-c1topq"&&(ee.innerHTML=Oa),$t=o(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-17m5t67"&&(te.innerHTML=es),Jt=o(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-r3waof"&&(ae.textContent=ts),Ht=o(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1mkb3me"&&(se.innerHTML=as),qt=o(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1vo81sc"&&(ne.textContent=ss),jt=o(e),k=i(e,"H2",{class:!0});var Ha=h(k);G=i(Ha,"A",{id:!0,class:!0,href:!0});var Vs=h(G);ot=i(Vs,"SPAN",{});var Ds=h(ot);f(ie.$$.fragment,Ds),Ds.forEach(t),Vs.forEach(t),Sa=o(Ha),Oe=i(Ha,"SPAN",{"data-svelte-h":!0}),r(Oe)!=="svelte-ccdkx7"&&(Oe.textContent=ns),Ha.forEach(t),Gt=o(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1cl8jes"&&(le.innerHTML=is),zt=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1ef6fws"&&(oe.textContent=ls),It=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-7fbxqn"&&(re.innerHTML=os),Bt=o(e),f(pe.$$.fragment,e),St=o(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-4c289b"&&(ue.textContent=rs),Ft=o(e),f(he.$$.fragment,e),Lt=o(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1uo32p8"&&(me.innerHTML=ps),Et=o(e),f(ce.$$.fragment,e),Pt=o(e),z=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(z)!=="svelte-1cse5se"&&(z.innerHTML=us),Zt=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-4i4t88"&&(de.textContent=hs),Ut=o(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-15w4tcn"&&(fe.textContent=ms),Xt=o(e),M=i(e,"H2",{class:!0});var qa=h(M);I=i(qa,"A",{id:!0,class:!0,href:!0});var Qs=h(I);rt=i(Qs,"SPAN",{});var Ks=h(rt);f(ge.$$.fragment,Ks),Ks.forEach(t),Qs.forEach(t),Fa=o(qa),et=i(qa,"SPAN",{"data-svelte-h":!0}),r(et)!=="svelte-al27wh"&&(et.textContent=cs),qa.forEach(t),At=o(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-zbggm7"&&(ve.innerHTML=ds),Wt=o(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-pcmpy3"&&(we.innerHTML=fs),Nt=o(e),f(ye.$$.fragment,e),Yt=o(e),B=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(B)!=="svelte-1eg4i6m"&&(B.innerHTML=gs),Rt=o(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-2gktww"&&(be.textContent=vs),Vt=o(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1iiz53k"&&(xe.textContent=ws),Dt=o(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1djmz7i"&&(Te.innerHTML=ys),Qt=o(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1bt1xj3"&&(Ce.innerHTML=bs),Kt=o(e),f(S.$$.fragment,e),Ot=o(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-59fha7"&&(ke.textContent=xs),ea=o(e),_=i(e,"H2",{class:!0});var ja=h(_);F=i(ja,"A",{id:!0,class:!0,href:!0});var Os=h(F);pt=i(Os,"SPAN",{});var en=h(pt);f(Me.$$.fragment,en),en.forEach(t),Os.forEach(t),La=o(ja),tt=i(ja,"SPAN",{"data-svelte-h":!0}),r(tt)!=="svelte-808iuu"&&(tt.textContent=Ts),ja.forEach(t),ta=o(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-196s45l"&&(_e.innerHTML=Cs),aa=o(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1l55l7k"&&($e.textContent=ks),sa=o(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-u0c2pj"&&(Je.textContent=Ms),na=o(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-rcbtf3"&&(He.innerHTML=_s),ia=o(e),f(qe.$$.fragment,e),la=o(e),L=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-b6kbs6"&&(L.innerHTML=$s),oa=o(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1fap1oe"&&(je.textContent=Js),ra=o(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1v7yz7v"&&(Ge.innerHTML=Hs),pa=o(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-13z5f9l"&&(ze.textContent=qs),ua=o(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-fc7u1p"&&(Ie.textContent=js),ha=o(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-tu7x1"&&(Be.textContent=Gs),ma=o(e),$=i(e,"H2",{class:!0});var Ga=h($);E=i(Ga,"A",{id:!0,class:!0,href:!0});var tn=h(E);ut=i(tn,"SPAN",{});var an=h(ut);f(Se.$$.fragment,an),an.forEach(t),tn.forEach(t),Ea=o(Ga),at=i(Ga,"SPAN",{"data-svelte-h":!0}),r(at)!=="svelte-188ljnw"&&(at.textContent=zs),Ga.forEach(t),ca=o(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-naa7dr"&&(Fe.textContent=Is),da=o(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1x7yj9g"&&(Le.textContent=Bs),fa=o(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-9z7nz9"&&(Ee.textContent=Ss),ga=o(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1bkzq64"&&(Pe.innerHTML=Fs),va=o(e),f(Ze.$$.fragment,e),wa=o(e),P=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(P)!=="svelte-1soplef"&&(P.innerHTML=Ls),ya=o(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-otxgpj"&&(Ue.innerHTML=Es),ba=o(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-fposmi"&&(Xe.innerHTML=Ps),xa=o(e),f(Z.$$.fragment,e),Ta=o(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-ph55g"&&(Ae.textContent=Zs),Ca=o(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-lsf6hk"&&(We.textContent=Us),ka=o(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1xaydvu"&&(Ne.textContent=Xs),Ma=o(e),ht=i(e,"P",{}),h(ht).forEach(t),this.h()},h(){p(m,"name","hf:doc:metadata"),p(m,"content",JSON.stringify(fn)),p(J,"id","introduction-to-audio-data"),p(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(J,"href","#introduction-to-audio-data"),p(x,"class","relative group"),p(H,"id","sampling-and-sampling-rate"),p(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(H,"href","#sampling-and-sampling-rate"),p(T,"class","relative group"),p(q,"class","flex justify-center"),p(j,"id","amplitude-and-bit-depth"),p(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(j,"href","#amplitude-and-bit-depth"),p(C,"class","relative group"),p(G,"id","audio-as-a-waveform"),p(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(G,"href","#audio-as-a-waveform"),p(k,"class","relative group"),p(z,"class","flex justify-center"),p(I,"id","the-frequency-spectrum"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#the-frequency-spectrum"),p(M,"class","relative group"),p(B,"class","flex justify-center"),p(F,"id","spectrogram"),p(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(F,"href","#spectrogram"),p(_,"class","relative group"),p(L,"class","flex justify-center"),p(E,"id","mel-spectrogram"),p(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(E,"href","#mel-spectrogram"),p($,"class","relative group"),p(P,"class","flex justify-center")},m(e,a){u(document.head,m),s(e,c,a),s(e,b,a),s(e,ct,a),s(e,x,a),u(x,J),u(J,nt),g(U,nt,null),u(x,za),u(x,De),s(e,dt,a),s(e,X,a),s(e,ft,a),s(e,A,a),s(e,gt,a),s(e,W,a),s(e,vt,a),s(e,T,a),u(T,H),u(H,it),g(N,it,null),u(T,Ia),u(T,Qe),s(e,wt,a),s(e,Y,a),s(e,yt,a),s(e,q,a),s(e,bt,a),s(e,R,a),s(e,xt,a),s(e,V,a),s(e,Tt,a),s(e,D,a),s(e,Ct,a),s(e,Q,a),s(e,kt,a),s(e,C,a),u(C,j),u(j,lt),g(K,lt,null),u(C,Ba),u(C,Ke),s(e,Mt,a),s(e,O,a),s(e,_t,a),s(e,ee,a),s(e,$t,a),s(e,te,a),s(e,Jt,a),s(e,ae,a),s(e,Ht,a),s(e,se,a),s(e,qt,a),s(e,ne,a),s(e,jt,a),s(e,k,a),u(k,G),u(G,ot),g(ie,ot,null),u(k,Sa),u(k,Oe),s(e,Gt,a),s(e,le,a),s(e,zt,a),s(e,oe,a),s(e,It,a),s(e,re,a),s(e,Bt,a),g(pe,e,a),s(e,St,a),s(e,ue,a),s(e,Ft,a),g(he,e,a),s(e,Lt,a),s(e,me,a),s(e,Et,a),g(ce,e,a),s(e,Pt,a),s(e,z,a),s(e,Zt,a),s(e,de,a),s(e,Ut,a),s(e,fe,a),s(e,Xt,a),s(e,M,a),u(M,I),u(I,rt),g(ge,rt,null),u(M,Fa),u(M,et),s(e,At,a),s(e,ve,a),s(e,Wt,a),s(e,we,a),s(e,Nt,a),g(ye,e,a),s(e,Yt,a),s(e,B,a),s(e,Rt,a),s(e,be,a),s(e,Vt,a),s(e,xe,a),s(e,Dt,a),s(e,Te,a),s(e,Qt,a),s(e,Ce,a),s(e,Kt,a),g(S,e,a),s(e,Ot,a),s(e,ke,a),s(e,ea,a),s(e,_,a),u(_,F),u(F,pt),g(Me,pt,null),u(_,La),u(_,tt),s(e,ta,a),s(e,_e,a),s(e,aa,a),s(e,$e,a),s(e,sa,a),s(e,Je,a),s(e,na,a),s(e,He,a),s(e,ia,a),g(qe,e,a),s(e,la,a),s(e,L,a),s(e,oa,a),s(e,je,a),s(e,ra,a),s(e,Ge,a),s(e,pa,a),s(e,ze,a),s(e,ua,a),s(e,Ie,a),s(e,ha,a),s(e,Be,a),s(e,ma,a),s(e,$,a),u($,E),u(E,ut),g(Se,ut,null),u($,Ea),u($,at),s(e,ca,a),s(e,Fe,a),s(e,da,a),s(e,Le,a),s(e,fa,a),s(e,Ee,a),s(e,ga,a),s(e,Pe,a),s(e,va,a),g(Ze,e,a),s(e,wa,a),s(e,P,a),s(e,ya,a),s(e,Ue,a),s(e,ba,a),s(e,Xe,a),s(e,xa,a),g(Z,e,a),s(e,Ta,a),s(e,Ae,a),s(e,Ca,a),s(e,We,a),s(e,ka,a),s(e,Ne,a),s(e,Ma,a),s(e,ht,a),_a=!0},p(e,[a]){const Ye={};a&2&&(Ye.$$scope={dirty:a,ctx:e}),S.$set(Ye);const mt={};a&2&&(mt.$$scope={dirty:a,ctx:e}),Z.$set(mt)},i(e){_a||(v(U.$$.fragment,e),v(N.$$.fragment,e),v(K.$$.fragment,e),v(ie.$$.fragment,e),v(pe.$$.fragment,e),v(he.$$.fragment,e),v(ce.$$.fragment,e),v(ge.$$.fragment,e),v(ye.$$.fragment,e),v(S.$$.fragment,e),v(Me.$$.fragment,e),v(qe.$$.fragment,e),v(Se.$$.fragment,e),v(Ze.$$.fragment,e),v(Z.$$.fragment,e),_a=!0)},o(e){w(U.$$.fragment,e),w(N.$$.fragment,e),w(K.$$.fragment,e),w(ie.$$.fragment,e),w(pe.$$.fragment,e),w(he.$$.fragment,e),w(ce.$$.fragment,e),w(ge.$$.fragment,e),w(ye.$$.fragment,e),w(S.$$.fragment,e),w(Me.$$.fragment,e),w(qe.$$.fragment,e),w(Se.$$.fragment,e),w(Ze.$$.fragment,e),w(Z.$$.fragment,e),_a=!1},d(e){e&&(t(c),t(b),t(ct),t(x),t(dt),t(X),t(ft),t(A),t(gt),t(W),t(vt),t(T),t(wt),t(Y),t(yt),t(q),t(bt),t(R),t(xt),t(V),t(Tt),t(D),t(Ct),t(Q),t(kt),t(C),t(Mt),t(O),t(_t),t(ee),t($t),t(te),t(Jt),t(ae),t(Ht),t(se),t(qt),t(ne),t(jt),t(k),t(Gt),t(le),t(zt),t(oe),t(It),t(re),t(Bt),t(St),t(ue),t(Ft),t(Lt),t(me),t(Et),t(Pt),t(z),t(Zt),t(de),t(Ut),t(fe),t(Xt),t(M),t(At),t(ve),t(Wt),t(we),t(Nt),t(Yt),t(B),t(Rt),t(be),t(Vt),t(xe),t(Dt),t(Te),t(Qt),t(Ce),t(Kt),t(Ot),t(ke),t(ea),t(_),t(ta),t(_e),t(aa),t($e),t(sa),t(Je),t(na),t(He),t(ia),t(la),t(L),t(oa),t(je),t(ra),t(Ge),t(pa),t(ze),t(ua),t(Ie),t(ha),t(Be),t(ma),t($),t(ca),t(Fe),t(da),t(Le),t(fa),t(Ee),t(ga),t(Pe),t(va),t(wa),t(P),t(ya),t(Ue),t(ba),t(Xe),t(xa),t(Ta),t(Ae),t(Ca),t(We),t(ka),t(Ne),t(Ma),t(ht)),t(m),y(U),y(N),y(K),y(ie),y(pe,e),y(he,e),y(ce,e),y(ge),y(ye,e),y(S,e),y(Me),y(qe,e),y(Se),y(Ze,e),y(Z,e)}}}const fn={local:"introduction-to-audio-data",sections:[{local:"sampling-and-sampling-rate",title:"Sampling and sampling rate"},{local:"amplitude-and-bit-depth",title:"Amplitude and bit depth"},{local:"audio-as-a-waveform",title:"Audio as a waveform"},{local:"the-frequency-spectrum",title:"The frequency spectrum"},{local:"spectrogram",title:"Spectrogram"},{local:"mel-spectrogram",title:"Mel spectrogram"}],title:"Introduction to audio data"};function gn(Ve){return rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tn extends pn{constructor(m){super(),un(this,m,gn,dn,on,{})}}export{Tn as component};
