import{s as yt,n as ct,o as dt}from"../chunks/scheduler.f7e1785c.js";import{S as rt,i as jt,g as M,s as a,u as p,A as mt,h as i,f as e,c as n,j as el,v as u,y as o,k as P,o as sl,a as s,w as y,d as c,t as d,x as r}from"../chunks/index.815a732f.js";import{I as ht}from"../chunks/IconCopyLink.e7937f56.js";import{C as j}from"../chunks/CodeBlock.c6e8b464.js";function Ut(Fl){let m,al,K,nl,h,U,ll,J,Rl,O,Yl="Load and explore an audio dataset",Ml,T,Hl=`In this course we will use the 🤗 Datasets library to work with audio datasets. 🤗 Datasets is an open-source library for
downloading and preparing datasets from all modalities including audio. The library offers easy access to an unparalleled
selection of machine learning datasets publicly available on Hugging Face Hub. Moreover, 🤗 Datasets includes multiple
features tailored to audio datasets that simplify working with such datasets for both researchers and practitioners.`,il,f,Nl="To begin working with audio datasets, make sure you have the 🤗 Datasets library installed:",ol,A,pl,b,Sl=`One of the key defining features of 🤗 Datasets is the ability to download and prepare a dataset in just one line of
Python code using the <code>load_dataset()</code> function.`,ul,C,zl=`Let’s load and explore and audio dataset called <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, which contains
recordings of people asking an e-banking system questions in several languages and dialects.`,yl,I,Xl=`To load the MINDS-14 dataset, we need to copy the dataset’s identifier on the Hub (<code>PolyAI/minds14</code>) and pass it
to the <code>load_dataset</code> function. We’ll also specify that we’re only interested in the Australian subset (<code>en-AU</code>) of
the data, and limit it to the training split:`,cl,g,dl,v,Ll="<strong>Output:</strong>",rl,k,jl,G,Vl=`The dataset contains 654 audio files, each of which is accompanied by a transcription, an English translation, and a label
indicating the intent behind the person’s query. The audio column contains the raw audio data. Let’s take a closer look
at one of the examples:`,ml,$,hl,x,Dl="<strong>Output:</strong>",Ul,Z,wl,E,Pl="You may notice that the audio column contains several features. Here’s what they are:",Jl,_,Ol="<li><code>path</code>: the path to the audio file (<code>*.wav</code> in this case).</li> <li><code>array</code>: The decoded audio data, represented as a 1-dimensional NumPy array.</li> <li><code>sampling_rate</code>. The sampling rate of the audio file (8,000 Hz in this example).</li>",Tl,q,Kl=`The <code>intent_class</code> is a classification category of the audio recording. To convert this number into a meaningful string,
we can use the <code>int2str()</code> method:`,fl,W,Al,B,lt="<strong>Output:</strong>",bl,Q,Cl,R,tt=`If you look at the transcription feature, you can see that the audio file indeed has recorded a person asking a question
about paying a bill.`,Il,F,et=`If you plan to train an audio classifier on this subset of data, you may not necessarily need all of the features. For example,
the <code>lang_id</code> is going to have the same value for all examples, and won’t be useful. The <code>english_transcription</code> will likely
duplicate the <code>transcription</code> in this subset, so we can safely remove them.`,gl,Y,st="You can easily remove irrelevant features using 🤗 Datasets’ <code>remove_columns</code> method:",vl,H,kl,N,at="<strong>Output:</strong>",Gl,S,$l,z,nt=`Now that we’ve loaded and inspected the raw contents of the dataset, let’s listen to a few examples! We’ll use the <code>Blocks</code>
and <code>Audio</code> features from <code>Gradio</code> to decode a few random samples from the dataset:`,xl,X,Zl,L,Mt="If you’d like to, you can also visualize some of the examples. Let’s plot the waveform for the first example.",El,V,_l,w,it='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',ql,D,ot=`Try it out! Download another dialect or language of the MINDS-14 dataset, listen and visualize some examples to get a sense
of the variation in the whole dataset. You can find the full list of available languages <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">here</a>.`,Wl,tl,Bl;return J=new ht({}),A=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]"}}),g=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`}}),k=new j({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`}}),$=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`}}),Z=new j({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`}}),W=new j({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`}}),Q=new j({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>'}}),H=new j({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`}}),S=new j({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>'}}),X=new j({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`}}),V=new j({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`}}),{c(){m=M("meta"),al=a(),K=M("p"),nl=a(),h=M("h1"),U=M("a"),ll=M("span"),p(J.$$.fragment),Rl=a(),O=M("span"),O.textContent=Yl,Ml=a(),T=M("p"),T.textContent=Hl,il=a(),f=M("p"),f.textContent=Nl,ol=a(),p(A.$$.fragment),pl=a(),b=M("p"),b.innerHTML=Sl,ul=a(),C=M("p"),C.innerHTML=zl,yl=a(),I=M("p"),I.innerHTML=Xl,cl=a(),p(g.$$.fragment),dl=a(),v=M("p"),v.innerHTML=Ll,rl=a(),p(k.$$.fragment),jl=a(),G=M("p"),G.textContent=Vl,ml=a(),p($.$$.fragment),hl=a(),x=M("p"),x.innerHTML=Dl,Ul=a(),p(Z.$$.fragment),wl=a(),E=M("p"),E.textContent=Pl,Jl=a(),_=M("ul"),_.innerHTML=Ol,Tl=a(),q=M("p"),q.innerHTML=Kl,fl=a(),p(W.$$.fragment),Al=a(),B=M("p"),B.innerHTML=lt,bl=a(),p(Q.$$.fragment),Cl=a(),R=M("p"),R.textContent=tt,Il=a(),F=M("p"),F.innerHTML=et,gl=a(),Y=M("p"),Y.innerHTML=st,vl=a(),p(H.$$.fragment),kl=a(),N=M("p"),N.innerHTML=at,Gl=a(),p(S.$$.fragment),$l=a(),z=M("p"),z.innerHTML=nt,xl=a(),p(X.$$.fragment),Zl=a(),L=M("p"),L.textContent=Mt,El=a(),p(V.$$.fragment),_l=a(),w=M("div"),w.innerHTML=it,ql=a(),D=M("p"),D.innerHTML=ot,Wl=a(),tl=M("p"),this.h()},l(l){const t=mt("svelte-1phssyn",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(e),al=n(l),K=i(l,"P",{}),el(K).forEach(e),nl=n(l),h=i(l,"H1",{class:!0});var Ql=el(h);U=i(Ql,"A",{id:!0,class:!0,href:!0});var pt=el(U);ll=i(pt,"SPAN",{});var ut=el(ll);u(J.$$.fragment,ut),ut.forEach(e),pt.forEach(e),Rl=n(Ql),O=i(Ql,"SPAN",{"data-svelte-h":!0}),o(O)!=="svelte-8zu140"&&(O.textContent=Yl),Ql.forEach(e),Ml=n(l),T=i(l,"P",{"data-svelte-h":!0}),o(T)!=="svelte-14tdruz"&&(T.textContent=Hl),il=n(l),f=i(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-16weaia"&&(f.textContent=Nl),ol=n(l),u(A.$$.fragment,l),pl=n(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-vy8pv5"&&(b.innerHTML=Sl),ul=n(l),C=i(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1ibmxou"&&(C.innerHTML=zl),yl=n(l),I=i(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-11xjat8"&&(I.innerHTML=Xl),cl=n(l),u(g.$$.fragment,l),dl=n(l),v=i(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1mvdyro"&&(v.innerHTML=Ll),rl=n(l),u(k.$$.fragment,l),jl=n(l),G=i(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-7t6f49"&&(G.textContent=Vl),ml=n(l),u($.$$.fragment,l),hl=n(l),x=i(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1mvdyro"&&(x.innerHTML=Dl),Ul=n(l),u(Z.$$.fragment,l),wl=n(l),E=i(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1xpct0w"&&(E.textContent=Pl),Jl=n(l),_=i(l,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-n6enht"&&(_.innerHTML=Ol),Tl=n(l),q=i(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1wz2ihr"&&(q.innerHTML=Kl),fl=n(l),u(W.$$.fragment,l),Al=n(l),B=i(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1mvdyro"&&(B.innerHTML=lt),bl=n(l),u(Q.$$.fragment,l),Cl=n(l),R=i(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1a1ybip"&&(R.textContent=tt),Il=n(l),F=i(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-11cpnca"&&(F.innerHTML=et),gl=n(l),Y=i(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-gmqz2q"&&(Y.innerHTML=st),vl=n(l),u(H.$$.fragment,l),kl=n(l),N=i(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1mvdyro"&&(N.innerHTML=at),Gl=n(l),u(S.$$.fragment,l),$l=n(l),z=i(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1iz3f0u"&&(z.innerHTML=nt),xl=n(l),u(X.$$.fragment,l),Zl=n(l),L=i(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-14zloga"&&(L.textContent=Mt),El=n(l),u(V.$$.fragment,l),_l=n(l),w=i(l,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1ym6zda"&&(w.innerHTML=it),ql=n(l),D=i(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1frcml4"&&(D.innerHTML=ot),Wl=n(l),tl=i(l,"P",{}),el(tl).forEach(e),this.h()},h(){P(m,"name","hf:doc:metadata"),P(m,"content",JSON.stringify(wt)),P(U,"id","load-and-explore-an-audio-dataset"),P(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),P(U,"href","#load-and-explore-an-audio-dataset"),P(h,"class","relative group"),P(w,"class","flex justify-center")},m(l,t){sl(document.head,m),s(l,al,t),s(l,K,t),s(l,nl,t),s(l,h,t),sl(h,U),sl(U,ll),y(J,ll,null),sl(h,Rl),sl(h,O),s(l,Ml,t),s(l,T,t),s(l,il,t),s(l,f,t),s(l,ol,t),y(A,l,t),s(l,pl,t),s(l,b,t),s(l,ul,t),s(l,C,t),s(l,yl,t),s(l,I,t),s(l,cl,t),y(g,l,t),s(l,dl,t),s(l,v,t),s(l,rl,t),y(k,l,t),s(l,jl,t),s(l,G,t),s(l,ml,t),y($,l,t),s(l,hl,t),s(l,x,t),s(l,Ul,t),y(Z,l,t),s(l,wl,t),s(l,E,t),s(l,Jl,t),s(l,_,t),s(l,Tl,t),s(l,q,t),s(l,fl,t),y(W,l,t),s(l,Al,t),s(l,B,t),s(l,bl,t),y(Q,l,t),s(l,Cl,t),s(l,R,t),s(l,Il,t),s(l,F,t),s(l,gl,t),s(l,Y,t),s(l,vl,t),y(H,l,t),s(l,kl,t),s(l,N,t),s(l,Gl,t),y(S,l,t),s(l,$l,t),s(l,z,t),s(l,xl,t),y(X,l,t),s(l,Zl,t),s(l,L,t),s(l,El,t),y(V,l,t),s(l,_l,t),s(l,w,t),s(l,ql,t),s(l,D,t),s(l,Wl,t),s(l,tl,t),Bl=!0},p:ct,i(l){Bl||(c(J.$$.fragment,l),c(A.$$.fragment,l),c(g.$$.fragment,l),c(k.$$.fragment,l),c($.$$.fragment,l),c(Z.$$.fragment,l),c(W.$$.fragment,l),c(Q.$$.fragment,l),c(H.$$.fragment,l),c(S.$$.fragment,l),c(X.$$.fragment,l),c(V.$$.fragment,l),Bl=!0)},o(l){d(J.$$.fragment,l),d(A.$$.fragment,l),d(g.$$.fragment,l),d(k.$$.fragment,l),d($.$$.fragment,l),d(Z.$$.fragment,l),d(W.$$.fragment,l),d(Q.$$.fragment,l),d(H.$$.fragment,l),d(S.$$.fragment,l),d(X.$$.fragment,l),d(V.$$.fragment,l),Bl=!1},d(l){l&&(e(al),e(K),e(nl),e(h),e(Ml),e(T),e(il),e(f),e(ol),e(pl),e(b),e(ul),e(C),e(yl),e(I),e(cl),e(dl),e(v),e(rl),e(jl),e(G),e(ml),e(hl),e(x),e(Ul),e(wl),e(E),e(Jl),e(_),e(Tl),e(q),e(fl),e(Al),e(B),e(bl),e(Cl),e(R),e(Il),e(F),e(gl),e(Y),e(vl),e(kl),e(N),e(Gl),e($l),e(z),e(xl),e(Zl),e(L),e(El),e(_l),e(w),e(ql),e(D),e(Wl),e(tl)),e(m),r(J),r(A,l),r(g,l),r(k,l),r($,l),r(Z,l),r(W,l),r(Q,l),r(H,l),r(S,l),r(X,l),r(V,l)}}}const wt={local:"load-and-explore-an-audio-dataset",title:"Load and explore an audio dataset"};function Jt(Fl){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends rt{constructor(m){super(),jt(this,m,Jt,Ut,yt,{})}}export{Ct as component};
