import{s as ja,o as Ta}from"../chunks/scheduler.f7e1785c.js";import{S as Ja,i as ga,g as i,s as l,u as h,A as Ua,h as o,f as a,c as n,j as w,v as u,y as r,k as p,o as c,a as s,w as m,d as M,t as d,x as y,m as ba,n as va}from"../chunks/index.815a732f.js";import{T as Ca}from"../chunks/Tip.1258ac78.js";import{I as At}from"../chunks/IconCopyLink.e7937f56.js";import{C as j}from"../chunks/CodeBlock.c6e8b464.js";function Ia($e){let f;return{c(){f=ba(`💡 Some background on resampling: If an audio signal has been sampled at 8 kHz, so that it has 8000 sample readings per
second, we know that the audio does not contain any frequencies over 4 kHz. This is guaranteed by the Nyquist sampling
theorem. Because of this, we can be certain that in between the sampling points the original continuous signal always
makes a smooth curve. Upsampling to a higher sampling rate is then a matter of calculating additional sample values that go in between
the existing ones, by approximating this curve. Downsampling, however, requires that we first filter out any frequencies
that would be higher than the new Nyquist limit, before estimating the new sample points. In other words, you can't
downsample by a factor 2x by simply throwing away every other sample — this will create distortions in the signal called
aliases. Doing resampling correctly is tricky and best left to well-tested libraries such as librosa or 🤗 Datasets.`)},l(T){f=va(T,`💡 Some background on resampling: If an audio signal has been sampled at 8 kHz, so that it has 8000 sample readings per
second, we know that the audio does not contain any frequencies over 4 kHz. This is guaranteed by the Nyquist sampling
theorem. Because of this, we can be certain that in between the sampling points the original continuous signal always
makes a smooth curve. Upsampling to a higher sampling rate is then a matter of calculating additional sample values that go in between
the existing ones, by approximating this curve. Downsampling, however, requires that we first filter out any frequencies
that would be higher than the new Nyquist limit, before estimating the new sample points. In other words, you can't
downsample by a factor 2x by simply throwing away every other sample — this will create distortions in the signal called
aliases. Doing resampling correctly is tricky and best left to well-tested libraries such as librosa or 🤗 Datasets.`)},m(T,$){s(T,f,$)},d(T){T&&a(f)}}}function Aa($e){let f,T,$,_e,J,v,Ce,_,xt,ge,Bt="Preprocessing an audio dataset",Be,B,Rt=`Loading a dataset with 🤗 Datasets is just half of the fun. If you plan to use it either for training a model, or for running
inference, you will need to pre-process the data first. In general, this will involve the following steps:`,Re,R,Zt="<li>Resampling the audio data</li> <li>Filtering the dataset</li> <li>Converting audio data to model’s expected input</li>",Ze,g,C,Ie,Z,kt,Ue,Ht="Resampling the audio data",He,H,Wt=`The <code>load_dataset</code> function downloads audio examples with the sampling rate that they were published with. This is not
always the sampling rate expected by a model you plan to train, or use for inference. If there’s a discrepancy between
the sampling rates, you can resample the audio to the model’s expected sampling rate.`,We,W,Gt=`Most of the available pretrained models have been pretrained on audio datasets at a sampling rate of 16 kHz.
When we explored MINDS-14 dataset, you may have noticed that it is sampled at 8 kHz, which means we will likely need
to upsample it.`,Ge,G,Nt=`To do so, use 🤗 Datasets’ <code>cast_column</code> method. This operation does not change the audio in-place, but rather signals
to datasets to resample the audio examples on the fly when they are loaded. The following code will set the sampling
rate to 16kHz:`,Ne,N,Xe,X,Xt="Re-load the first audio example in the MINDS-14 dataset, and check that it has been resampled to the desired <code>sampling rate</code>:",qe,q,Ve,V,qt="<strong>Output:</strong>",Ye,Y,Ee,E,Vt=`You may notice that the array values are now also different. This is because we’ve now got twice the number of amplitude values for
every one that we had before.`,ze,I,Se,U,A,Ae,z,$t,be,Yt="Filtering the dataset",Qe,S,Et=`You may need to filter the data based on some criteria. One of the common cases involves limiting the audio examples to a
certain duration. For instance, we might want to filter out any examples longer than 20s to prevent out-of-memory errors
when training a model.`,Fe,Q,zt=`We can do this by using the  🤗 Datasets’ <code>filter</code> method and passing a function with filtering logic to it. Let’s start by writing a
function that indicates which examples to keep and which to discard. This function, <code>is_audio_length_in_range</code>,
returns <code>True</code> if a sample is shorter than 20s, and <code>False</code> if it is longer than 20s.`,Le,F,De,L,St=`The filtering function can be applied to a dataset’s column but we do not have a column with audio track duration in this
dataset. However, we can create one, filter based on the values in that column, and then remove it.`,Pe,D,Oe,P,Qt="<strong>Output:</strong>",Ke,O,et,K,Ft="We can verify that dataset has been filtered down from 654 examples to 624.",tt,b,x,xe,ee,_t,ve,Lt="Pre-processing audio data",at,te,Dt=`One of the most challenging aspects of working with audio datasets is preparing the data in the right format for model
training. As you saw, the raw audio data comes as an array of sample values. However, pre-trained models, whether you use them
for inference, or want to fine-tune them for your task, expect the raw data to be converted into input features. The
requirements for the input features may vary from one model to another — they depend on the model’s architecture, and the data it was
pre-trained with. The good news is, for every supported audio model, 🤗 Transformers offer a feature extractor class
that can convert raw audio data into the input features the model expects.`,st,ae,Pt=`So what does a feature extractor do with the raw audio data? Let’s take a look at <a href="https://huggingface.co/papers/2212.04356" rel="nofollow">Whisper</a>’s
feature extractor to understand some common feature extraction transformations. Whisper is a pre-trained model for
automatic speech recognition (ASR) published in September 2022 by Alec Radford et al. from OpenAI.`,lt,se,Ot=`First, the Whisper feature extractor pads/truncates a batch of audio examples such that all
examples have an input length of 30s. Examples shorter than this are padded to 30s by appending zeros to the end of the
sequence (zeros in an audio signal correspond to no signal or silence). Examples longer than 30s are truncated to 30s.
Since all elements in the batch are padded/truncated to a maximum length in the input space, there is no need for an attention
mask. Whisper is unique in this regard, most other audio models require an attention mask that details
where sequences have been padded, and thus where they should be ignored in the self-attention mechanism. Whisper is
trained to operate without an attention mask and infer directly from the speech signals where to ignore the inputs.`,nt,le,Kt=`The second operation that the Whisper feature extractor performs is converting the padded audio arrays to log-mel spectrograms.
As you recall, these spectrograms describe how the frequencies of a signal change over time, expressed on the mel scale
and measured in decibels (the log part) to make the frequencies and amplitudes more representative of human hearing.`,it,ne,ea=`All these transformations can be applied to your raw audio data with a couple of lines of code. Let’s go ahead and load
the feature extractor from the pre-trained Whisper checkpoint to have ready for our audio data:`,ot,ie,rt,oe,ta="Next, you can write a function to pre-process a single audio example by passing it through the <code>feature_extractor</code>.",pt,re,ht,pe,aa="We can apply the data preparation function to all of our training examples using 🤗 Datasets’ map method:",ut,he,ct,ue,sa="<strong>Output:</strong>",mt,ce,Mt,me,la="As easy as that, we now have log-mel spectrograms as <code>input_features</code> in the dataset.",dt,Me,na="Let’s visualize it for one of the examples in the <code>minds</code> dataset:",yt,de,ft,k,ia='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',wt,ye,oa="Now you can see what the audio input to the Whisper model looks like after preprocessing.",jt,fe,ra=`The model’s feature extractor class takes care of transforming raw audio data to the format that the model expects. However,
many tasks involving audio are multimodal, e.g. speech recognition. In such cases 🤗 Transformers also offer model-specific
tokenizers to process the text inputs. For a deep dive into tokenizers, please refer to our <a href="https://huggingface.co/course/chapter2/4" rel="nofollow">NLP course</a>.`,Tt,we,pa=`You can load the feature extractor and tokenizer for Whisper and other multimodal models separately, or you can load both via
a so-called processor. To make things even simpler, use <code>AutoProcessor</code> to load a model’s feature extractor and processor from a
checkpoint, like this:`,Jt,je,gt,Te,ha=`Here we have illustrated the fundamental data preparation steps. Of course, custom data may require more complex preprocessing.
In this case, you can extend the function <code>prepare_dataset</code> to perform any sort of custom data transformations. With 🤗 Datasets,
if you can write it as a Python function, you can <a href="https://huggingface.co/docs/datasets/audio_process" rel="nofollow">apply it</a> to your dataset!`,Ut,ke,bt;return _=new At({}),Z=new At({}),N=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`}}),q=new j({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]'}}),Y=new j({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`}}),I=new Ca({props:{$$slots:{default:[Ia]},$$scope:{ctx:$e}}}),z=new At({}),F=new j({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`}}),D=new j({props:{code:"JTIzJTIwdXNlJTIwbGlicm9zYSUyMHRvJTIwZ2V0JTIwZXhhbXBsZSdzJTIwZHVyYXRpb24lMjBmcm9tJTIwdGhlJTIwYXVkaW8lMjBmaWxlJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKHBhdGglM0R4KSUyMGZvciUyMHglMjBpbiUyMG1pbmRzJTVCJTIycGF0aCUyMiU1RCU1RCUwQW1pbmRzJTIwJTNEJTIwbWluZHMuYWRkX2NvbHVtbiglMjJkdXJhdGlvbiUyMiUyQyUyMG5ld19jb2x1bW4pJTBBJTBBJTIzJTIwdXNlJTIwJUYwJTlGJUE0JTk3JTIwRGF0YXNldHMnJTIwJTYwZmlsdGVyJTYwJTIwbWV0aG9kJTIwdG8lMjBhcHBseSUyMHRoZSUyMGZpbHRlcmluZyUyMGZ1bmN0aW9uJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5maWx0ZXIoaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlJTJDJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmR1cmF0aW9uJTIyJTVEKSUwQSUwQSUyMyUyMHJlbW92ZSUyMHRoZSUyMHRlbXBvcmFyeSUyMGhlbHBlciUyMGNvbHVtbiUwQW1pbmRzJTIwJTNEJTIwbWluZHMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBbWluZHM=",highlighted:`<span class="hljs-comment"># use librosa to get example&#x27;s duration from the audio file</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># use 🤗 Datasets&#x27; \`filter\` method to apply the filtering function</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># remove the temporary helper column</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`}}),O=new j({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>'}}),ee=new At({}),ie=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`}}),re=new j({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`}}),he=new j({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`}}),ce=new j({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`}}),de=new j({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`}}),je=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`}}),{c(){f=i("meta"),T=l(),$=i("p"),_e=l(),J=i("h1"),v=i("a"),Ce=i("span"),h(_.$$.fragment),xt=l(),ge=i("span"),ge.textContent=Bt,Be=l(),B=i("p"),B.textContent=Rt,Re=l(),R=i("ul"),R.innerHTML=Zt,Ze=l(),g=i("h2"),C=i("a"),Ie=i("span"),h(Z.$$.fragment),kt=l(),Ue=i("span"),Ue.textContent=Ht,He=l(),H=i("p"),H.innerHTML=Wt,We=l(),W=i("p"),W.textContent=Gt,Ge=l(),G=i("p"),G.innerHTML=Nt,Ne=l(),h(N.$$.fragment),Xe=l(),X=i("p"),X.innerHTML=Xt,qe=l(),h(q.$$.fragment),Ve=l(),V=i("p"),V.innerHTML=qt,Ye=l(),h(Y.$$.fragment),Ee=l(),E=i("p"),E.textContent=Vt,ze=l(),h(I.$$.fragment),Se=l(),U=i("h2"),A=i("a"),Ae=i("span"),h(z.$$.fragment),$t=l(),be=i("span"),be.textContent=Yt,Qe=l(),S=i("p"),S.textContent=Et,Fe=l(),Q=i("p"),Q.innerHTML=zt,Le=l(),h(F.$$.fragment),De=l(),L=i("p"),L.textContent=St,Pe=l(),h(D.$$.fragment),Oe=l(),P=i("p"),P.innerHTML=Qt,Ke=l(),h(O.$$.fragment),et=l(),K=i("p"),K.textContent=Ft,tt=l(),b=i("h2"),x=i("a"),xe=i("span"),h(ee.$$.fragment),_t=l(),ve=i("span"),ve.textContent=Lt,at=l(),te=i("p"),te.textContent=Dt,st=l(),ae=i("p"),ae.innerHTML=Pt,lt=l(),se=i("p"),se.textContent=Ot,nt=l(),le=i("p"),le.textContent=Kt,it=l(),ne=i("p"),ne.textContent=ea,ot=l(),h(ie.$$.fragment),rt=l(),oe=i("p"),oe.innerHTML=ta,pt=l(),h(re.$$.fragment),ht=l(),pe=i("p"),pe.textContent=aa,ut=l(),h(he.$$.fragment),ct=l(),ue=i("p"),ue.innerHTML=sa,mt=l(),h(ce.$$.fragment),Mt=l(),me=i("p"),me.innerHTML=la,dt=l(),Me=i("p"),Me.innerHTML=na,yt=l(),h(de.$$.fragment),ft=l(),k=i("div"),k.innerHTML=ia,wt=l(),ye=i("p"),ye.textContent=oa,jt=l(),fe=i("p"),fe.innerHTML=ra,Tt=l(),we=i("p"),we.innerHTML=pa,Jt=l(),h(je.$$.fragment),gt=l(),Te=i("p"),Te.innerHTML=ha,Ut=l(),ke=i("p"),this.h()},l(e){const t=Ua("svelte-1phssyn",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(a),T=n(e),$=o(e,"P",{}),w($).forEach(a),_e=n(e),J=o(e,"H1",{class:!0});var Je=w(J);v=o(Je,"A",{id:!0,class:!0,href:!0});var ua=w(v);Ce=o(ua,"SPAN",{});var ca=w(Ce);u(_.$$.fragment,ca),ca.forEach(a),ua.forEach(a),xt=n(Je),ge=o(Je,"SPAN",{"data-svelte-h":!0}),r(ge)!=="svelte-y5owk"&&(ge.textContent=Bt),Je.forEach(a),Be=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1b3xnqq"&&(B.textContent=Rt),Re=n(e),R=o(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1anvx2"&&(R.innerHTML=Zt),Ze=n(e),g=o(e,"H2",{class:!0});var vt=w(g);C=o(vt,"A",{id:!0,class:!0,href:!0});var ma=w(C);Ie=o(ma,"SPAN",{});var Ma=w(Ie);u(Z.$$.fragment,Ma),Ma.forEach(a),ma.forEach(a),kt=n(vt),Ue=o(vt,"SPAN",{"data-svelte-h":!0}),r(Ue)!=="svelte-13ibzx4"&&(Ue.textContent=Ht),vt.forEach(a),He=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-47dy14"&&(H.innerHTML=Wt),We=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1c2c4da"&&(W.textContent=Gt),Ge=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-x7frc7"&&(G.innerHTML=Nt),Ne=n(e),u(N.$$.fragment,e),Xe=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-96ugis"&&(X.innerHTML=Xt),qe=n(e),u(q.$$.fragment,e),Ve=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1mvdyro"&&(V.innerHTML=qt),Ye=n(e),u(Y.$$.fragment,e),Ee=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-hnb1k"&&(E.textContent=Vt),ze=n(e),u(I.$$.fragment,e),Se=n(e),U=o(e,"H2",{class:!0});var Ct=w(U);A=o(Ct,"A",{id:!0,class:!0,href:!0});var da=w(A);Ae=o(da,"SPAN",{});var ya=w(Ae);u(z.$$.fragment,ya),ya.forEach(a),da.forEach(a),$t=n(Ct),be=o(Ct,"SPAN",{"data-svelte-h":!0}),r(be)!=="svelte-nvq6f6"&&(be.textContent=Yt),Ct.forEach(a),Qe=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-s6y06a"&&(S.textContent=Et),Fe=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1szy3nk"&&(Q.innerHTML=zt),Le=n(e),u(F.$$.fragment,e),De=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1btp9dp"&&(L.textContent=St),Pe=n(e),u(D.$$.fragment,e),Oe=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1mvdyro"&&(P.innerHTML=Qt),Ke=n(e),u(O.$$.fragment,e),et=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-ipsrxo"&&(K.textContent=Ft),tt=n(e),b=o(e,"H2",{class:!0});var It=w(b);x=o(It,"A",{id:!0,class:!0,href:!0});var fa=w(x);xe=o(fa,"SPAN",{});var wa=w(xe);u(ee.$$.fragment,wa),wa.forEach(a),fa.forEach(a),_t=n(It),ve=o(It,"SPAN",{"data-svelte-h":!0}),r(ve)!=="svelte-6km34g"&&(ve.textContent=Lt),It.forEach(a),at=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-jbw2e0"&&(te.textContent=Dt),st=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1jndbwe"&&(ae.innerHTML=Pt),lt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1y8nv8f"&&(se.textContent=Ot),nt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1ys9rww"&&(le.textContent=Kt),it=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-n9ngno"&&(ne.textContent=ea),ot=n(e),u(ie.$$.fragment,e),rt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-kd1gw8"&&(oe.innerHTML=ta),pt=n(e),u(re.$$.fragment,e),ht=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-6ixft2"&&(pe.textContent=aa),ut=n(e),u(he.$$.fragment,e),ct=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1mvdyro"&&(ue.innerHTML=sa),mt=n(e),u(ce.$$.fragment,e),Mt=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-14djzfz"&&(me.innerHTML=la),dt=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1478ups"&&(Me.innerHTML=na),yt=n(e),u(de.$$.fragment,e),ft=n(e),k=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(k)!=="svelte-csckl"&&(k.innerHTML=ia),wt=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-pj9vlt"&&(ye.textContent=oa),jt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1x1eerf"&&(fe.innerHTML=ra),Tt=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-ngi3x1"&&(we.innerHTML=pa),Jt=n(e),u(je.$$.fragment,e),gt=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-gvmmsi"&&(Te.innerHTML=ha),Ut=n(e),ke=o(e,"P",{}),w(ke).forEach(a),this.h()},h(){p(f,"name","hf:doc:metadata"),p(f,"content",JSON.stringify(xa)),p(v,"id","preprocessing-an-audio-dataset"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#preprocessing-an-audio-dataset"),p(J,"class","relative group"),p(C,"id","resampling-the-audio-data"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#resampling-the-audio-data"),p(g,"class","relative group"),p(A,"id","filtering-the-dataset"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#filtering-the-dataset"),p(U,"class","relative group"),p(x,"id","preprocessing-audio-data"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#preprocessing-audio-data"),p(b,"class","relative group"),p(k,"class","flex justify-center")},m(e,t){c(document.head,f),s(e,T,t),s(e,$,t),s(e,_e,t),s(e,J,t),c(J,v),c(v,Ce),m(_,Ce,null),c(J,xt),c(J,ge),s(e,Be,t),s(e,B,t),s(e,Re,t),s(e,R,t),s(e,Ze,t),s(e,g,t),c(g,C),c(C,Ie),m(Z,Ie,null),c(g,kt),c(g,Ue),s(e,He,t),s(e,H,t),s(e,We,t),s(e,W,t),s(e,Ge,t),s(e,G,t),s(e,Ne,t),m(N,e,t),s(e,Xe,t),s(e,X,t),s(e,qe,t),m(q,e,t),s(e,Ve,t),s(e,V,t),s(e,Ye,t),m(Y,e,t),s(e,Ee,t),s(e,E,t),s(e,ze,t),m(I,e,t),s(e,Se,t),s(e,U,t),c(U,A),c(A,Ae),m(z,Ae,null),c(U,$t),c(U,be),s(e,Qe,t),s(e,S,t),s(e,Fe,t),s(e,Q,t),s(e,Le,t),m(F,e,t),s(e,De,t),s(e,L,t),s(e,Pe,t),m(D,e,t),s(e,Oe,t),s(e,P,t),s(e,Ke,t),m(O,e,t),s(e,et,t),s(e,K,t),s(e,tt,t),s(e,b,t),c(b,x),c(x,xe),m(ee,xe,null),c(b,_t),c(b,ve),s(e,at,t),s(e,te,t),s(e,st,t),s(e,ae,t),s(e,lt,t),s(e,se,t),s(e,nt,t),s(e,le,t),s(e,it,t),s(e,ne,t),s(e,ot,t),m(ie,e,t),s(e,rt,t),s(e,oe,t),s(e,pt,t),m(re,e,t),s(e,ht,t),s(e,pe,t),s(e,ut,t),m(he,e,t),s(e,ct,t),s(e,ue,t),s(e,mt,t),m(ce,e,t),s(e,Mt,t),s(e,me,t),s(e,dt,t),s(e,Me,t),s(e,yt,t),m(de,e,t),s(e,ft,t),s(e,k,t),s(e,wt,t),s(e,ye,t),s(e,jt,t),s(e,fe,t),s(e,Tt,t),s(e,we,t),s(e,Jt,t),m(je,e,t),s(e,gt,t),s(e,Te,t),s(e,Ut,t),s(e,ke,t),bt=!0},p(e,[t]){const Je={};t&2&&(Je.$$scope={dirty:t,ctx:e}),I.$set(Je)},i(e){bt||(M(_.$$.fragment,e),M(Z.$$.fragment,e),M(N.$$.fragment,e),M(q.$$.fragment,e),M(Y.$$.fragment,e),M(I.$$.fragment,e),M(z.$$.fragment,e),M(F.$$.fragment,e),M(D.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(he.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(je.$$.fragment,e),bt=!0)},o(e){d(_.$$.fragment,e),d(Z.$$.fragment,e),d(N.$$.fragment,e),d(q.$$.fragment,e),d(Y.$$.fragment,e),d(I.$$.fragment,e),d(z.$$.fragment,e),d(F.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(he.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(je.$$.fragment,e),bt=!1},d(e){e&&(a(T),a($),a(_e),a(J),a(Be),a(B),a(Re),a(R),a(Ze),a(g),a(He),a(H),a(We),a(W),a(Ge),a(G),a(Ne),a(Xe),a(X),a(qe),a(Ve),a(V),a(Ye),a(Ee),a(E),a(ze),a(Se),a(U),a(Qe),a(S),a(Fe),a(Q),a(Le),a(De),a(L),a(Pe),a(Oe),a(P),a(Ke),a(et),a(K),a(tt),a(b),a(at),a(te),a(st),a(ae),a(lt),a(se),a(nt),a(le),a(it),a(ne),a(ot),a(rt),a(oe),a(pt),a(ht),a(pe),a(ut),a(ct),a(ue),a(mt),a(Mt),a(me),a(dt),a(Me),a(yt),a(ft),a(k),a(wt),a(ye),a(jt),a(fe),a(Tt),a(we),a(Jt),a(gt),a(Te),a(Ut),a(ke)),a(f),y(_),y(Z),y(N,e),y(q,e),y(Y,e),y(I,e),y(z),y(F,e),y(D,e),y(O,e),y(ee),y(ie,e),y(re,e),y(he,e),y(ce,e),y(de,e),y(je,e)}}}const xa={local:"preprocessing-an-audio-dataset",sections:[{local:"resampling-the-audio-data",title:"Resampling the audio data"},{local:"filtering-the-dataset",title:"Filtering the dataset"},{local:"preprocessing-audio-data",title:"Pre-processing audio data"}],title:"Preprocessing an audio dataset"};function ka($e){return Ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ha extends Ja{constructor(f){super(),ga(this,f,ka,Aa,ja,{})}}export{Ha as component};
