import{s as ce,n as de,o as ue}from"../chunks/scheduler.f6b352c8.js";import{S as je,i as ye,g as M,s as t,u as p,A as me,h as o,f as s,c as n,j as sl,v as r,y as i,k as D,o as al,a,w as c,d,t as u,x as j}from"../chunks/index.896efe71.js";import{I as Ue}from"../chunks/IconCopyLink.ad5e3f62.js";import{C as y}from"../chunks/CodeBlock.1ac1b76a.js";function Je(Fl){let m,tl,K,nl,U,J,ll,T,Rl,O,Yl="Cargar y explorar una base de datos de audio",Ml,w,Hl=`En este curso usaremos la libreria 🤗 Datasets para trabajar con bases de datos de audio. 🤗 Datasets es una libreria de
código abierto para descargar y preparar conjuntos de datos de todos los tipos, incluyendo audio. La libreria ofrece un
acceso fácil a una gran cantidad de conjuntos de datos públicos almacenados en el Hugging Face Hub. Además, 🤗 Datasets incluye
multiples funcionalidades pensadas para simplificar el trabajo con conjuntos de datos de audio para investigadores y desarrolladores.`,ol,b,Sl="Para empezar a trabajar con bases de datos de audio, asegurate de tener la librería 🤗 Datasets instalada:",il,A,pl,f,Nl=`Una de las principales características de 🤗 Datasets es la posibilidad de descargar y preparar un conjunto de datos
en una sola linea de código usando la función <code>load_dataset()</code>`,rl,C,zl=`Carguemos y exploremos un conjunto de audios llamado <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, el cual contiene
grabaciones de personas haciendo preguntas sobre sistemas electrónicos bancarios en diferentes lenguajes y dialectos.`,cl,I,Xl=`Para cargar MINDS-14, necesitamos copiar el identificador de la base de datos que aparece en el Hub (<code>PolyAI/minds14</code>) y pasarlo
como argumento a la función <code>load_dataset</code>. Tambien especificaremos que solo estamos interesados en el subconjunto de inglés Australiano(<code>en-AU</code>)
y la partición de entrenamiento(“train”):`,dl,g,ul,v,Ll="<strong>Output:</strong>",jl,G,yl,k,Vl=`El conjunto de datos contiene 654 audios, cada uno acompañado de su transcripción, una transcripción en inglés, y una etiqueta
que indica la intención de la pregunta de la persona. La columna de audio, contiene la información en bruto del audio. Examinemos
ahora uno de los ejemplos:`,ml,$,Ul,q,Pl="<strong>Output:</strong>",Jl,x,hl,E,Dl="Puedes ver que la columna de audio se compone de las siguiente información:",Tl,Z,Ol="<li><code>path</code>: La ruta al archivo de audio (<code>*.wav</code> en este caso).</li> <li><code>array</code>: Los datos decodificados de audios, representedos como un NumPy array de 1 dimensión.</li> <li><code>sampling_rate</code>. La frecuencia de muestreo del archivo (8,000 Hz en este ejemplo).</li>",wl,_,Kl=`La columna <code>intent_class</code> es de tipo categórico codificado en enteros. Para convertir este número en una texto con significado
podemos usar el método <code>int2str()</code>:`,bl,B,Al,Q,le="<strong>Output:</strong>",fl,W,Cl,R,ee=`Si miras la columna de <code>transcription</code>, puedes ver que en efecto la persona ha grabado un audio haciendo una pregunta sobre
pagar una cuenta.`,Il,F,se=`Si planeas entrenar un clasificador de audio en este subconjunto de datos, no necesitas toda la información contenida en las
columnas del conjunto de datos. Por ejemplo, la información en <code>lang_id</code> sera igual para todos los ejemplos y no nos será útil.
La columna <code>english_transcription&#39; seguramente sera un duplicado de la columna </code>transcription\` en este subconjunto, por lo que
podemos removerla tambien.`,gl,Y,ae="Puedes eliminar características irrelevantes usando el método `<code>remove_columns</code>de 🤗 Datasets",vl,H,Gl,S,te="<strong>Output:</strong>",kl,N,$l,z,ne=`Ahora que hemos cargado e inspeccionado los contenidos del conjunto de datos, ¡escuchemos algunos ejemplos! Usaremos <code>Blocks</code>
y <code>Audio</code> de <code>Gradio</code> para cargar algunos ejemplos del dataset.`,ql,X,xl,L,Me="Podemos visulizar tambien algunos de los ejemplos. Grafiquemos ahora la forma de onda del primer ejemplo.",El,V,Zl,h,oe='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',_l,P,ie=`¡Pruebalo! Decarga otro dialecto o lenguaje del conjunto MINDS-14, escucha y visualiza ajgunos ejemplos para tener un
sentido de la variación de toda la base de datos. Puedes ver una lista de todos los lenguajes <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">aqui</a>.`,Bl,el,Ql;return T=new Ue({}),A=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]"}}),g=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`}}),G=new y({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`}}),$=new y({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`}}),x=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`}}),B=new y({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`}}),W=new y({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>'}}),H=new y({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`}}),N=new y({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>'}}),X=new y({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`}}),V=new y({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`}}),{c(){m=M("meta"),tl=t(),K=M("p"),nl=t(),U=M("h1"),J=M("a"),ll=M("span"),p(T.$$.fragment),Rl=t(),O=M("span"),O.textContent=Yl,Ml=t(),w=M("p"),w.textContent=Hl,ol=t(),b=M("p"),b.textContent=Sl,il=t(),p(A.$$.fragment),pl=t(),f=M("p"),f.innerHTML=Nl,rl=t(),C=M("p"),C.innerHTML=zl,cl=t(),I=M("p"),I.innerHTML=Xl,dl=t(),p(g.$$.fragment),ul=t(),v=M("p"),v.innerHTML=Ll,jl=t(),p(G.$$.fragment),yl=t(),k=M("p"),k.textContent=Vl,ml=t(),p($.$$.fragment),Ul=t(),q=M("p"),q.innerHTML=Pl,Jl=t(),p(x.$$.fragment),hl=t(),E=M("p"),E.textContent=Dl,Tl=t(),Z=M("ul"),Z.innerHTML=Ol,wl=t(),_=M("p"),_.innerHTML=Kl,bl=t(),p(B.$$.fragment),Al=t(),Q=M("p"),Q.innerHTML=le,fl=t(),p(W.$$.fragment),Cl=t(),R=M("p"),R.innerHTML=ee,Il=t(),F=M("p"),F.innerHTML=se,gl=t(),Y=M("p"),Y.innerHTML=ae,vl=t(),p(H.$$.fragment),Gl=t(),S=M("p"),S.innerHTML=te,kl=t(),p(N.$$.fragment),$l=t(),z=M("p"),z.innerHTML=ne,ql=t(),p(X.$$.fragment),xl=t(),L=M("p"),L.textContent=Me,El=t(),p(V.$$.fragment),Zl=t(),h=M("div"),h.innerHTML=oe,_l=t(),P=M("p"),P.innerHTML=ie,Bl=t(),el=M("p"),this.h()},l(l){const e=me("svelte-1phssyn",document.head);m=o(e,"META",{name:!0,content:!0}),e.forEach(s),tl=n(l),K=o(l,"P",{}),sl(K).forEach(s),nl=n(l),U=o(l,"H1",{class:!0});var Wl=sl(U);J=o(Wl,"A",{id:!0,class:!0,href:!0});var pe=sl(J);ll=o(pe,"SPAN",{});var re=sl(ll);r(T.$$.fragment,re),re.forEach(s),pe.forEach(s),Rl=n(Wl),O=o(Wl,"SPAN",{"data-svelte-h":!0}),i(O)!=="svelte-1f9x8nd"&&(O.textContent=Yl),Wl.forEach(s),Ml=n(l),w=o(l,"P",{"data-svelte-h":!0}),i(w)!=="svelte-fms3f9"&&(w.textContent=Hl),ol=n(l),b=o(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1o8p9et"&&(b.textContent=Sl),il=n(l),r(A.$$.fragment,l),pl=n(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1kcnm3r"&&(f.innerHTML=Nl),rl=n(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1yiem8x"&&(C.innerHTML=zl),cl=n(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1ir28gq"&&(I.innerHTML=Xl),dl=n(l),r(g.$$.fragment,l),ul=n(l),v=o(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1mvdyro"&&(v.innerHTML=Ll),jl=n(l),r(G.$$.fragment,l),yl=n(l),k=o(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-ivyj94"&&(k.textContent=Vl),ml=n(l),r($.$$.fragment,l),Ul=n(l),q=o(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1mvdyro"&&(q.innerHTML=Pl),Jl=n(l),r(x.$$.fragment,l),hl=n(l),E=o(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-hxz5rj"&&(E.textContent=Dl),Tl=n(l),Z=o(l,"UL",{"data-svelte-h":!0}),i(Z)!=="svelte-op7a9q"&&(Z.innerHTML=Ol),wl=n(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-ybdd87"&&(_.innerHTML=Kl),bl=n(l),r(B.$$.fragment,l),Al=n(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1mvdyro"&&(Q.innerHTML=le),fl=n(l),r(W.$$.fragment,l),Cl=n(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1v4lcjp"&&(R.innerHTML=ee),Il=n(l),F=o(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1ufbi3q"&&(F.innerHTML=se),gl=n(l),Y=o(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-18j6r1l"&&(Y.innerHTML=ae),vl=n(l),r(H.$$.fragment,l),Gl=n(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1mvdyro"&&(S.innerHTML=te),kl=n(l),r(N.$$.fragment,l),$l=n(l),z=o(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-ymdrwo"&&(z.innerHTML=ne),ql=n(l),r(X.$$.fragment,l),xl=n(l),L=o(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1jx33x4"&&(L.textContent=Me),El=n(l),r(V.$$.fragment,l),Zl=n(l),h=o(l,"DIV",{class:!0,"data-svelte-h":!0}),i(h)!=="svelte-1ym6zda"&&(h.innerHTML=oe),_l=n(l),P=o(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1wmw5cx"&&(P.innerHTML=ie),Bl=n(l),el=o(l,"P",{}),sl(el).forEach(s),this.h()},h(){D(m,"name","hf:doc:metadata"),D(m,"content",JSON.stringify(he)),D(J,"id","cargar-y-explorar-una-base-de-datos-de-audio"),D(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),D(J,"href","#cargar-y-explorar-una-base-de-datos-de-audio"),D(U,"class","relative group"),D(h,"class","flex justify-center")},m(l,e){al(document.head,m),a(l,tl,e),a(l,K,e),a(l,nl,e),a(l,U,e),al(U,J),al(J,ll),c(T,ll,null),al(U,Rl),al(U,O),a(l,Ml,e),a(l,w,e),a(l,ol,e),a(l,b,e),a(l,il,e),c(A,l,e),a(l,pl,e),a(l,f,e),a(l,rl,e),a(l,C,e),a(l,cl,e),a(l,I,e),a(l,dl,e),c(g,l,e),a(l,ul,e),a(l,v,e),a(l,jl,e),c(G,l,e),a(l,yl,e),a(l,k,e),a(l,ml,e),c($,l,e),a(l,Ul,e),a(l,q,e),a(l,Jl,e),c(x,l,e),a(l,hl,e),a(l,E,e),a(l,Tl,e),a(l,Z,e),a(l,wl,e),a(l,_,e),a(l,bl,e),c(B,l,e),a(l,Al,e),a(l,Q,e),a(l,fl,e),c(W,l,e),a(l,Cl,e),a(l,R,e),a(l,Il,e),a(l,F,e),a(l,gl,e),a(l,Y,e),a(l,vl,e),c(H,l,e),a(l,Gl,e),a(l,S,e),a(l,kl,e),c(N,l,e),a(l,$l,e),a(l,z,e),a(l,ql,e),c(X,l,e),a(l,xl,e),a(l,L,e),a(l,El,e),c(V,l,e),a(l,Zl,e),a(l,h,e),a(l,_l,e),a(l,P,e),a(l,Bl,e),a(l,el,e),Ql=!0},p:de,i(l){Ql||(d(T.$$.fragment,l),d(A.$$.fragment,l),d(g.$$.fragment,l),d(G.$$.fragment,l),d($.$$.fragment,l),d(x.$$.fragment,l),d(B.$$.fragment,l),d(W.$$.fragment,l),d(H.$$.fragment,l),d(N.$$.fragment,l),d(X.$$.fragment,l),d(V.$$.fragment,l),Ql=!0)},o(l){u(T.$$.fragment,l),u(A.$$.fragment,l),u(g.$$.fragment,l),u(G.$$.fragment,l),u($.$$.fragment,l),u(x.$$.fragment,l),u(B.$$.fragment,l),u(W.$$.fragment,l),u(H.$$.fragment,l),u(N.$$.fragment,l),u(X.$$.fragment,l),u(V.$$.fragment,l),Ql=!1},d(l){l&&(s(tl),s(K),s(nl),s(U),s(Ml),s(w),s(ol),s(b),s(il),s(pl),s(f),s(rl),s(C),s(cl),s(I),s(dl),s(ul),s(v),s(jl),s(yl),s(k),s(ml),s(Ul),s(q),s(Jl),s(hl),s(E),s(Tl),s(Z),s(wl),s(_),s(bl),s(Al),s(Q),s(fl),s(Cl),s(R),s(Il),s(F),s(gl),s(Y),s(vl),s(Gl),s(S),s(kl),s($l),s(z),s(ql),s(xl),s(L),s(El),s(Zl),s(h),s(_l),s(P),s(Bl),s(el)),s(m),j(T),j(A,l),j(g,l),j(G,l),j($,l),j(x,l),j(B,l),j(W,l),j(H,l),j(N,l),j(X,l),j(V,l)}}}const he={local:"cargar-y-explorar-una-base-de-datos-de-audio",title:"Cargar y explorar una base de datos de audio"};function Te(Fl){return ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ce extends je{constructor(m){super(),ye(this,m,Te,Je,ce,{})}}export{Ce as component};
