import{s as Ue,n as ge,o as we}from"../chunks/scheduler.f7e1785c.js";import{S as $e,i as Ce,g as i,s as l,u as m,A as Ie,h as o,f as t,c as a,j as S,v as d,y as u,k as E,o as F,a as n,w as M,d as y,t as f,x as h}from"../chunks/index.815a732f.js";import{I as xe}from"../chunks/IconCopyLink.e7937f56.js";import{C as N}from"../chunks/CodeBlock.c6e8b464.js";function ke(ce){let p,B,Z,R,r,c,G,J,re,W,me="Classification audio avec un pipeline",D,T,de=`La classification audio consiste à attribuer une ou plusieurs étiquettes à un enregistrement audio en fonction de son contenu.
Les étiquettes peuvent correspondre à différentes catégories sonores, telles que la musique, la parole ou le bruit, ou à des catégories plus spécifiques telles que le chant d’oiseaux ou les sons de moteur de voiture.
Avant de plonger dans les détails du fonctionnement des <em>transformers</em> audio les plus populaires, et avant de finetuner un modèle personnalisé, voyons comment vous pouvez utiliser un modèle pré-entraîné standard pour la classification audio avec seulement quelques lignes de code avec 🤗 <em>Transformers</em>.
Utilisons le même jeu de données <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a> que vous avez exploré dans l’unité précédente.
Si vous vous souvenez, MINDS-14 contient des enregistrements de personnes posant des questions à un système bancaire électronique dans plusieurs langues et dialectes, et a le <code>intent_class</code> pour chaque enregistrement. Nous pouvons classer les enregistrements par intention de l’appel.`,L,j,Me="Comme précédemment, commençons par charger le sous-ensemble <code>en-AU</code> pour essayer le pipeline, et suréchantillonnons-le à un taux d’échantillonnage de 16 kHz, ce qui est ce que la plupart des modèles vocaux exigent.",P,v,V,q,ye=`Pour classer un enregistrement audio dans un ensemble de classes, nous pouvons utiliser le pipeline <code>audio-classification</code> de 🤗 <em>Transformers</em>.
Dans notre cas, nous avons besoin d’un modèle qui a été finetuné pour la classification des intentions, et en particulier sur le jeu de données MINDS-14. Heureusement pour nous, le <em>Hub</em> a un modèle qui fait exactement cela ! Chargeons-le en utilisant la fonction <code>pipeline()</code> :`,H,b,X,U,fe="Ce pipeline attend les données audio sous forme de tableau NumPy. Tout le prétraitement des données audio brutes sera commodément géré pour nous par le pipeline. Choisissons un exemple pour l’essayer :",Y,g,O,w,he="Si vous vous souvenez de la structure du jeu de données, les données audio brutes sont stockées dans un tableau NumPy sous <code>[&quot;audio&quot;][&quot;array&quot;]</code>, passons-les directement au <code>classifier</code> :",K,$,ee,C,Je="<strong>Sortie :</strong>",se,I,te,x,Te="Le modèle est très confiant que l’appelant avait l’intention d’apprendre à payer sa facture. Voyons quelle est l’étiquette réelle pour cet exemple:",ne,k,le,z,je="<strong>Sortie :</strong>",ae,_,ie,A,ve=`L’étiquette prédite est correcte ! Ici, nous avons eu la chance de trouver un modèle capable de classer les étiquettes exactes dont nous avons besoin.
Souvent, lorsqu’il s’agit d’une tâche de classification, l’ensemble de classes d’un modèle pré-entraîné n’est pas exactement le même que les classes que vous devez distinguer par le modèle.
Dans ce cas, vous pouvez finetuner un modèle pré-entraîné pour le « calibrer » en fonction de votre ensemble exact d’étiquettes de classe. Nous apprendrons comment le faire dans les prochaines unités.`,oe,Q,ue;return J=new xe({}),v=new N({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwbmFtZSUzRCUyMmVuLUFVJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`}}),b=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJhbnRvbi1sJTJGeHRyZW1lX3NfeGxzcl8zMDBtX21pbmRzMTQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>,
    model=<span class="hljs-string">&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</span>,
)`}}),g=new N({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RA==",highlighted:'example = minds[<span class="hljs-number">0</span>]'}}),$=new N({props:{code:"Y2xhc3NpZmllcihleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:'classifier(example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])'}}),I=new N({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjk2MzE1MjUyNzgwOTE0MzElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMnBheV9iaWxsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAyODE5Njk4MzAzOTM3OTEyJTJDJTIwJTIybGFiZWwlMjIlM0ElMjAlMjJmcmVlemUlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAzMjc4NzQ5Mjk2NDQxNjc0MiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2FyZF9pc3N1ZXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAxOTQxNDQ0NTg1MDk5ODE2MyUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyYWJyb2FkJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAwMDgzNzg2OTM2MDExMTY1MzglMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMmhpZ2hfdmFsdWVfcGF5bWVudCUyMiU3RCUyQyUwQSU1RA==",highlighted:`[
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.9631525278091431</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;pay_bill&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.02819698303937912</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;freeze&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0032787492964416742</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;card_issues&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0019414445850998163</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;abroad&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0008378693601116538</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;high_value_payment&quot;</span>},
]`}}),k=new N({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`}}),_=new N({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>'}}),{c(){p=i("meta"),B=l(),Z=i("p"),R=l(),r=i("h1"),c=i("a"),G=i("span"),m(J.$$.fragment),re=l(),W=i("span"),W.textContent=me,D=l(),T=i("p"),T.innerHTML=de,L=l(),j=i("p"),j.innerHTML=Me,P=l(),m(v.$$.fragment),V=l(),q=i("p"),q.innerHTML=ye,H=l(),m(b.$$.fragment),X=l(),U=i("p"),U.textContent=fe,Y=l(),m(g.$$.fragment),O=l(),w=i("p"),w.innerHTML=he,K=l(),m($.$$.fragment),ee=l(),C=i("p"),C.innerHTML=Je,se=l(),m(I.$$.fragment),te=l(),x=i("p"),x.textContent=Te,ne=l(),m(k.$$.fragment),le=l(),z=i("p"),z.innerHTML=je,ae=l(),m(_.$$.fragment),ie=l(),A=i("p"),A.textContent=ve,oe=l(),Q=i("p"),this.h()},l(e){const s=Ie("svelte-1phssyn",document.head);p=o(s,"META",{name:!0,content:!0}),s.forEach(t),B=a(e),Z=o(e,"P",{}),S(Z).forEach(t),R=a(e),r=o(e,"H1",{class:!0});var pe=S(r);c=o(pe,"A",{id:!0,class:!0,href:!0});var qe=S(c);G=o(qe,"SPAN",{});var be=S(G);d(J.$$.fragment,be),be.forEach(t),qe.forEach(t),re=a(pe),W=o(pe,"SPAN",{"data-svelte-h":!0}),u(W)!=="svelte-1gbf4yh"&&(W.textContent=me),pe.forEach(t),D=a(e),T=o(e,"P",{"data-svelte-h":!0}),u(T)!=="svelte-rvzziw"&&(T.innerHTML=de),L=a(e),j=o(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-wbkria"&&(j.innerHTML=Me),P=a(e),d(v.$$.fragment,e),V=a(e),q=o(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-12hj9jn"&&(q.innerHTML=ye),H=a(e),d(b.$$.fragment,e),X=a(e),U=o(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-b3mk4t"&&(U.textContent=fe),Y=a(e),d(g.$$.fragment,e),O=a(e),w=o(e,"P",{"data-svelte-h":!0}),u(w)!=="svelte-1tkv2"&&(w.innerHTML=he),K=a(e),d($.$$.fragment,e),ee=a(e),C=o(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-dbzevp"&&(C.innerHTML=Je),se=a(e),d(I.$$.fragment,e),te=a(e),x=o(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-w8dulx"&&(x.textContent=Te),ne=a(e),d(k.$$.fragment,e),le=a(e),z=o(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-dbzevp"&&(z.innerHTML=je),ae=a(e),d(_.$$.fragment,e),ie=a(e),A=o(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-134o58x"&&(A.textContent=ve),oe=a(e),Q=o(e,"P",{}),S(Q).forEach(t),this.h()},h(){E(p,"name","hf:doc:metadata"),E(p,"content",JSON.stringify(ze)),E(c,"id","classification-audio-avec-un-pipeline"),E(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),E(c,"href","#classification-audio-avec-un-pipeline"),E(r,"class","relative group")},m(e,s){F(document.head,p),n(e,B,s),n(e,Z,s),n(e,R,s),n(e,r,s),F(r,c),F(c,G),M(J,G,null),F(r,re),F(r,W),n(e,D,s),n(e,T,s),n(e,L,s),n(e,j,s),n(e,P,s),M(v,e,s),n(e,V,s),n(e,q,s),n(e,H,s),M(b,e,s),n(e,X,s),n(e,U,s),n(e,Y,s),M(g,e,s),n(e,O,s),n(e,w,s),n(e,K,s),M($,e,s),n(e,ee,s),n(e,C,s),n(e,se,s),M(I,e,s),n(e,te,s),n(e,x,s),n(e,ne,s),M(k,e,s),n(e,le,s),n(e,z,s),n(e,ae,s),M(_,e,s),n(e,ie,s),n(e,A,s),n(e,oe,s),n(e,Q,s),ue=!0},p:ge,i(e){ue||(y(J.$$.fragment,e),y(v.$$.fragment,e),y(b.$$.fragment,e),y(g.$$.fragment,e),y($.$$.fragment,e),y(I.$$.fragment,e),y(k.$$.fragment,e),y(_.$$.fragment,e),ue=!0)},o(e){f(J.$$.fragment,e),f(v.$$.fragment,e),f(b.$$.fragment,e),f(g.$$.fragment,e),f($.$$.fragment,e),f(I.$$.fragment,e),f(k.$$.fragment,e),f(_.$$.fragment,e),ue=!1},d(e){e&&(t(B),t(Z),t(R),t(r),t(D),t(T),t(L),t(j),t(P),t(V),t(q),t(H),t(X),t(U),t(Y),t(O),t(w),t(K),t(ee),t(C),t(se),t(te),t(x),t(ne),t(le),t(z),t(ae),t(ie),t(A),t(oe),t(Q)),t(p),h(J),h(v,e),h(b,e),h(g,e),h($,e),h(I,e),h(k,e),h(_,e)}}}const ze={local:"classification-audio-avec-un-pipeline",title:"Classification audio avec un pipeline"};function _e(ce){return we(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends $e{constructor(p){super(),Ce(this,p,_e,ke,Ue,{})}}export{Ze as component};
