import{s as On,n as Kn,o as el}from"../chunks/scheduler.f7e1785c.js";import{S as sl,i as tl,g as l,s as i,u as d,A as nl,h as a,f as s,c as o,j as c,v as m,y as r,k as u,o as p,a as n,w as h,d as f,t as v,x as y}from"../chunks/index.815a732f.js";import{I as w}from"../chunks/IconCopyLink.e7937f56.js";import{C as M}from"../chunks/CodeBlock.c6e8b464.js";function ll(Zt){let b,ms,ts,hs,g,N,ns,Y,It,De,Yt="Modèles et jeux de données pré-entraînés pour la classification d’audio",fs,G,Gt=`Le <em>Hub</em> abrite <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">plusieurs centaines de modèles pré-entraînés pour la classification d’audio</a>. Dans cette section, nous passerons en revue certaines des tâches de classification d’audio les plus courantes et suggérerons des modèles pré-entraînés appropriés pour chacune. En utilisant la classe <code>pipeline()</code>, la commutation entre les modèles et les tâches est simple : une fois que vous savez comment utiliser <code>pipeline()</code> pour un modèle, vous pourrez l’utiliser pour n’importe quel modèle sur le <em>Hub</em>, sans modification du code ! Cela rend l’expérimentation de la classe <code>pipeline()</code> extrêmement rapide, ce qui vous permet de sélectionner rapidement le meilleur modèle pré-entraîné pour vos besoins.
Avant de passer aux différents problèmes de classification d’audio, récapitulons rapidement les architectures de <em>transformers</em> généralement utilisées. L’architecture standard de classification d’audio est motivée par la nature de la tâche. Nous voulons transformer une séquence d’entrées audio (c’est-à-dire notre réseau audio d’entrée) en une prédiction d’étiquette de classe unique. Les modèles d’encodeur associent d’abord la séquence audio d’entrée dans une séquence de représentations à l’état caché en faisant passer les entrées à travers un bloc <em>transformer</em>. La séquence de représentations d’états masqués est ensuite associée à une sortie d’étiquette de classe en prenant la moyenne sur les états masqués et en faisant passer le vecteur résultant à travers une couche de classification linéaire. Par conséquent, il y a une préférence pour les modèles <em>encodeur</em> pour la classification d’audio.
Les modèles de décodeur introduisent une complexité inutile à la tâche car ils supposent que les sorties peuvent également être une <em>séquence</em> de prédictions (plutôt qu’une prédiction d’étiquette de classe unique), et génèrent ainsi plusieurs sorties. Par conséquent, ils ont une vitesse d’inférence plus lente et ont tendance à ne pas être utilisés. Les modèles encodeur-décodeur sont largement omis pour la même raison. Ces choix d’architecture sont analogues à ceux de NLP, où les modèles d’encodeur tels que BERT sont privilégiés pour les tâches de classification de séquences, et les modèles de décodeur tels que GPT réservés aux tâches de génération de séquences.
Maintenant que nous avons récapitulé l’architecture du <em>transformer</em> standard pour la classification d’audio, passons aux différents sous-ensembles de la classification d’audio et couvrons les modèles les plus populaires !`,vs,j,z,ls,P,kt,Ve,Pt="🤗 Installation de Transformers",ys,R,Rt="Au moment de la rédaction de cette section, les dernières mises à jour requises pour le pipeline de classification d’audio se trouvent uniquement sur la version « principale » du dépôt 🤗 Transformers, plutôt que sur la dernière version de PyPi. Pour nous assurer que nous avons ces mises à jour localement, nous allons installer Transformers à partir de la branche <code>main</code> avec la commande suivante :",Ms,D,bs,x,_,as,V,St,Be,Dt="Repérage de mots-clés",gs,B,Vt="Le repérage de mots clés (KWS pour <em>Keyword spotting</em>) est la tâche d’identifier un mot-clé dans un discours. L’ensemble des mots-clés possibles forme l’ensemble des étiquettes de classe prédites. Par conséquent, pour utiliser un modèle de repérage de mots clés pré-entraîné, vous devez vous assurer que vos mots-clés correspondent à ceux sur lesquels le modèle a été pré-entraîné. Ci-dessous, nous présenterons deux jeux de données et modèles pour la détection de mots clés.",js,U,I,is,F,Lt,Fe,Bt="MINDS-14",xs,X,Ft='Commençons en utilisant le même jeu de données <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a> exploré dans l’unité précédente. Si vous vous souvenez, MINDS-14 contient des enregistrements de personnes posant des questions à un système bancaire électronique dans plusieurs langues et dialectes, et a indique une classe d’intention pour chaque enregistrement. Nous pouvons donc classer les enregistrements par intention de l’appel.',Us,O,Js,K,Xt='Nous allons charger le <em>checkpoint</em> <a href="https://huggingface.co/anton-l/xtreme_s_xlsr_300m_minds14" rel="nofollow"><code>&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</code></a>, qui est un modèle XLS-R <em>finetuné</em> sur MINDS-14 pendant environ 50 époques. Il atteint une précision de 90% sur toutes les langues de MINDS-14 sur l’ensemble d’évaluation.',qs,ee,Ts,se,Ot="Enfin, nous pouvons passer un échantillon au pipeline de classification pour faire une prédiction :",Cs,te,$s,ne,Kt="<strong>Sortie :</strong>",ws,le,Ns,ae,en="Nous avons identifié que l’intention de l’appel était de payer une facture, avec une probabilité de 96%. Vous pouvez imaginer que ce type de système de repérage de mots-clés soit utilisé comme première étape d’un centre d’appels automatisé, où nous voulons catégoriser les appels entrants des clients en fonction de leur requête et leur offrir un support contextualisé en conséquence.",zs,J,k,os,ie,At,Xe,sn="Speech Commands",_s,oe,tn=`Speech Commands est un jeu de données de mots parlés conçu pour évaluer les modèles de classification d’audio sur des mots de commande simples.
Le jeu de données se compose de 15 classes de mots-clés, d’une classe pour le silence et d’une classe inconnue pour inclure le faux positif.
Les 15 mots-clés sont des mots uniques qui seraient généralement utilisés dans les paramètres sur l’appareil pour contrôler les tâches de base ou lancer d’autres processus.
Un modèle similaire fonctionne en continu sur votre téléphone mobile. Ici, au lieu d’avoir des mots de commande uniques, nous avons des mots de réveil spécifiques à votre appareil, tels que « Hey Google » ou « Hey Siri ». Lorsque le modèle de classification d’audio détecte ces mots de réveil, il déclenche votre téléphone pour commencer à écouter le microphone et transcrire votre discours à l’aide d’un modèle de reconnaissance vocale.
Le modèle de classification d’audio est beaucoup plus petit et plus léger que le modèle de reconnaissance vocale, souvent seulement quelques millions de paramètres contre plusieurs centaines de millions pour la reconnaissance vocale. Ainsi, il peut fonctionner en continu sur votre appareil sans vider votre batterie ! Ce n’est que lorsque le mot de réveil est détecté que le modèle de reconnaissance vocale plus large est lancé, puis qu’il est à nouveau arrêté. Nous couvrirons les modèles de <em>transformers</em> pour la reconnaissance vocale dans la prochaine unité, donc à la fin du cours, vous devriez avoir les outils dont vous avez besoin pour construire votre propre assistant à commande vocale !
Comme pour tout jeu de données sur le <em>Hub</em>, nous pouvons avoir une idée de la tête des données sans avoir à les télécharger ou les avoir en mémoire. Après avoir accédé à la <a href="https://huggingface.co/datasets/speech_commands" rel="nofollow">carte du jeu de données Speech Commands</a> sur le <em>Hub</em>, nous pouvons utiliser la visionneuse de données pour faire défiler les 100 premiers échantillons du jeu de données, écouter les fichiers audio et vérifier toute autre information de métadonnées :`,Is,S,nn='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/speech_commands.png" alt="Diagram of datasets viewer."/>',ks,re,ln=`L’aperçu du jeu de données est un moyen de découvrir les jeux de données audio avant de s’engager à les utiliser. Vous pouvez choisir n’importe quel jeu de données sur le <em>Hub</em>, faire défiler les échantillons et écouter l’audio pour les différents sous-ensembles et échantillons, en évaluant s’il s’agit du bon jeu de données pour vos besoins. Une fois que vous avez sélectionné un jeu de données, il est trivial de télécharger les données afin de pouvoir commencer à les utiliser.
Faisons cela et chargeons un échantillon du jeu de données Speech Commands en utilisant le mode streaming :`,Ss,ue,Ls,pe,an='Nous allons charger un <em>checkpoint</em> d’un <a href="https://huggingface.co/docs/transformers/model_doc/audio-spectrogramme-transformer" rel="nofollow"><em>transformer</em> d’audio sous la forme de spectrogramme</a> <em>finetuné</em> sur le jeu de données Speech Commands :',As,ce,Hs,de,on="<strong>Sortie :</strong>",Es,me,Qs,he,rn="On dirait que l’exemple contient le mot <code>backward</code> avec une forte probabilité. Nous pouvons écouter l’échantillon et vérifier qu’il est correct:",Ws,fe,Zs,ve,un=`Vous vous demandez peut-être comment nous avons sélectionné les modèles pré-entraînés montrés dans ces exemples de classification d’audio.
C’est très simple ! La première chose que nous devons faire est de nous diriger sur le <em>Hub</em> et de cliquer sur l’onglet « <em>Models</em> »: <a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>
Cela va faire apparaître tous les modèles sur le <em>Hub</em> :`,Ys,L,pn='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/all_models.png"/>',Gs,ye,cn="Vous remarquerez sur le côté gauche que nous avons plusieurs onglets que nous pouvons sélectionner pour filtrer les modèles par tâche, bibliothèque, jeu de données, etc. Faites défiler vers le bas et sélectionnez la tâche « Classification d’audio » dans la liste des tâches audio:",Ps,A,dn='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_audio_classification.png"/>',Rs,Me,mn="Nous voyons alors le sous-ensemble de modèles de classification d’audio présent sur le <em>Hub</em>. Pour affiner davantage cette sélection, nous pouvons filtrer les modèles par jeu de données. Cliquez sur l’onglet « Jeux de données », et dans la zone de recherche, tapez « speech_commands ». Lorsque vous commencez à taper, vous verrez la sélection pour ‘speech_commands’ apparaître sous l’onglet de recherche. Vous pouvez cliquer sur ce bouton pour filtrer tous les modèles de classification d’audio <em>finetuné</em> sur le jeu de données Speech Commands :",Ds,H,hn='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_speech_commands.png"/>',Vs,be,fn="Bien, nous voyons que nous avons 6 modèles pré-entraînés à notre disposition pour ce jeu de données et cette tâche spécifiques. Le premier listé est celui que nous avons utilisé dans l’exemple précédent. Ce processus de filtrage des modèles du <em>Hub</em> est exactement la façon dont nous avons procédé pour choisir ce modèle.",Bs,q,E,rs,ge,Ht,Oe,vn="Identification de la langue",Fs,je,yn="L’identification de la langue est la tâche d’identifier la langue parlée dans un échantillon audio à partir d’une liste de langues candidates. Cette tâche peut jouer un rôle important dans de nombreux pipelines de parole. Par exemple, étant donné un échantillon audio dans une langue inconnue, un modèle d’identification de langue peut être utilisé pour catégoriser la ou les langues parlées dans l’échantillon audio, puis sélectionner un modèle de reconnaissance vocale approprié entraîné sur cette langue pour transcrire l’audio.",Xs,T,Q,us,xe,Et,Ke,Mn="FLEURS",Os,Ue,bn=`FLEURS (<em>Few-shot Learning Evaluation of Universal Representations of Speech</em>) est un jeu de données permettant d’évaluer les systèmes de reconnaissance vocale dans 102 langues, dont beaucoup sont classées comme à faibles ressources. Jetez un coup d’œil à la carte de FLEURS sur le <em>Hub</em> et explorez les différentes langues présentes : <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.
Pouvez-vous trouver votre langue maternelle ici ? Si ce n’est pas le cas, quelle est la langue la plus proche ?
Chargeons un échantillon à partir de l’échantillon de validation de FLEURS en utilisant le mode streaming :`,Ks,Je,et,qe,gn='Génial ! Nous pouvons maintenant charger notre modèle de classification d’audio. Pour cela, nous utiliserons une version de <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper</a> <em>finetuné</em> sur FLEURS, qui est actuellement le modèle de détection de langue le plus performant sur le Hub:',st,Te,tt,Ce,jn="Nous pouvons ensuite passer l’audio à travers notre classifieur et générer une prédiction :",nt,$e,lt,we,xn="<strong>Sortie :</strong>",at,Ne,it,ze,Un=`Nous pouvons voir que le modèle a prédit que l’audio était en Afrikaans avec une probabilité extrêmement élevée. FLEURS contient des données audio provenant d’un large éventail de langues : nous pouvons voir que les étiquettes de classe possibles incluent le sotho du Nord, l’islandais, le danois et le cantonais, entre autres. Vous pouvez trouver la liste complète des langues ici : <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.
À vous de jouer ! Quels autres <em>checkpoints</em> pouvez-vous trouver sur le <em>Hub</em>  afin de détecter les langues présentes dans FLEURS ? Quels modèles de <em>transformers</em> utilisent-ils sous le capot ?`,ot,C,W,ps,_e,Qt,es,Jn="Classification d’audio en zéro-shot",rt,Ie,qn=`Dans le paradigme traditionnel de la classification d’audio, le modèle prédit une étiquette de classe à partir d’un ensemble de classes prédéfinies possibles. Cela constitue un obstacle à l’utilisation de modèles pré-entraînés pour la classification d’audio, car les étiquettes du modèle pré-entraîné doit correspondre à celui de la tâche en aval. Pour l’exemple précédent de détection de langues, le modèle doit prédire l’une des 102 classes de langue sur lesquelles il a été entraîné. Si la tâche en aval nécessite en fait 110 langues, le modèle ne serait pas en mesure de prédire 8 des 110 langues, et nécessiterait donc un nouvel entraînement pour atteindre une couverture complète. Cela limite l’efficacité de l’apprentissage par transfert pour les tâches de classification d’audio.
La classification d’audio zéro-shot est une méthode permettant de prendre un modèle de classification d’audio pré-entraîné entraîné sur un ensemble d’exemples étiquetés et de lui permettre de classer de nouveaux exemples de classes inédites. Voyons comment nous pouvons y parvenir.
Actuellement, 🤗 <em>Transformers</em> prend en charge un type de modèle pour la classification d’audio en zéro-shot : le <a href="https://huggingface.co/docs/transformers/model_doc/clap" rel="nofollow">modèle CLAP</a>.
CLAP est un modèle basé sur un <em>transformer</em> qui prend à la fois l’audio et le texte comme entrées, et calcule la <em>similitude</em> entre les deux.
Si nous passons une entrée de texte fortement corrélée à une entrée audio, nous obtiendrons un score de similarité élevé. Inversement, passer une entrée de texte qui n’a aucun rapport avec l’entrée audio renverra une faible similitude.
Nous pouvons utiliser cette prédiction de similarité pour la classification d’audio en zéro-shot en passant une entrée audio au modèle et plusieurs étiquettes candidates. Le modèle renverra un score de similarité pour chacune des étiquettes candidates, et nous pouvons choisir celle qui a le score le plus élevé comme prédiction.`,ut,ke,Tn='Prenons un exemple où nous utilisons une entrée audio du jeu de données <a href="https://huggingface.co/datasets/ashraq/esc50" rel="nofollow">Environmental Speech Challenge (ESC)</a> :',pt,Se,ct,Le,Cn="Nous définissons ensuite nos étiquettes candidates, qui forment l’ensemble des étiquettes de classification possibles. Le modèle renverra une probabilité de classification pour chacune des étiquettes que nous définissons. Cela signifie que nous devons connaître <em>a-priori</em> l’ensemble des étiquettes possibles dans notre problème de classification, de sorte que l’étiquette correcte soit contenue dans l’ensemble et se voie donc attribuer un score de probabilité valide. Notez que nous pouvons soit transmettre l’ensemble complet des étiquettes au modèle, soit un sous-ensemble sélectionné à la main qui, selon nous, contient l’étiquette correcte. Passer l’ensemble complet des étiquettes sera plus exhaustif, mais se fait au détriment d’une précision de classification plus faible puisque l’espace de classification est plus grand (à condition que l’étiquette correcte soit notre sous-ensemble d’étiquettes choisi):",dt,Ae,mt,He,$n="Nous pouvons parcourir les deux modèles pour trouver l’étiquette candidate qui est la plus similaire à l’entrée audio:",ht,Ee,ft,Qe,wn="<strong>Sortie :</strong>",vt,We,yt,Ze,Nn="Le modèle semble assez confiant (probabilité de 99,97%) que nous ayons le son d’un chien .Nous allons donc prendre cela comme notre prédiction. Confirmons si nous avions raison en écoutant l’échantillon audio (n’augmentez pas trop le volume, sinon vous risquez de sursauter !):",Mt,Ye,bt,Ge,zn=`Parfait ! Nous avons le son d’un chien qui aboie 🐕, ce qui correspond à la prédiction du modèle. Jouez avec différents échantillons audio et différentes étiquettes candidates. Pouvez-vous définir un ensemble d’étiquettes qui donnent une bonne généralisation à travers le jeu de données ESC ? Astuce : pensez à l’endroit où vous pourriez trouver des informations sur les sons possibles dans ESC et construisez vos étiquettes en conséquence.
Vous vous demandez peut-être pourquoi nous n’utilisons pas le pipeline de classification d’audio zero-shot pour <strong>toutes</strong> les tâches de classification d’audio ?
Il semble que nous puissions faire des prédictions pour n’importe quel problème de classification d’audio en définissant des étiquettes de classe appropriées <em>à priori</em>, contournant ainsi la contrainte dont notre tâche de classification a besoin pour correspondre aux étiquettes sur lesquelles le modèle a été pré-entraîné.
Cela se résume à la nature du modèle CLAP utilisé dans le pipeline zéro-shot. CLAP est pré-entraîné sur des données de classification d’audio <em>génériques</em>, similaires aux sons environnementaux dans le jeu de données ESC, plutôt que sur des données vocales spécifiques, comme nous l’avions dans la tâche de détection de langue. Si vous lui donnez un discours en anglais et un discours en espagnol, CLAP saurait que les deux exemples étaient des données vocales.  Mais il ne serait pas capable de différencier les langues de la même manière qu’un modèle de détection de langue dédié à cette tâche.`,gt,$,Z,cs,Pe,Wt,ss,_n="Et ensuite ?",jt,Re,In=`Nous avons couvert un certain nombre de tâches de classification d’audio, présenté les jeux de données et les modèles les plus pertinents que vous pouvez télécharger à partir du <em>Hub</em> et comment les utiliser en quelques lignes de code à l’aide de la classe <code>pipeline()</code>. Ces tâches comprenent la détection de mots-clés, l’identification de la langue et la classification d’audio en zéro-shot.
Mais que se passe-t-il si nous voulons faire quelque chose de <strong>nouveau</strong> ? Nous avons beaucoup travaillé sur les tâches de traitement de la parole, mais ce n’est qu’un aspect de la classification d’audio. Un autre domaine populaire du traitement d’audio est la <strong>musique</strong>. Bien que la musique ait des caractéristiques intrinsèquement différentes à la parole, bon nombre des mêmes principes que nous avons déjà appris peuvent être appliqués.
Dans la section suivante, nous allons passer en revue un guide étape par étape sur la façon dont vous pouvez <em>finetuner</em> un <em>transformer</em> avec 🤗 <em>Transformers</em> sur la tâche de classification de la musique. À la fin, vous aurez un <em>checkpoint</em> <em>finetuné</em> que vous pourrez brancher dans la classe <code>pipeline()</code>, vous permettant de classer les chansons exactement de la même manière que nous avons classé la parole ici.`,xt,ds,Ut;return Y=new w({}),P=new w({}),D=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:'pip install git+https:<span class="hljs-regexp">//gi</span>thub.com<span class="hljs-regexp">/huggingface/</span>transformers'}}),V=new w({}),F=new w({}),O=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`}}),ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJhbnRvbi1sJTJGeHRyZW1lX3NfeGxzcl8zMDBtX21pbmRzMTQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>,
    model=<span class="hljs-string">&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</span>,
)`}}),te=new M({props:{code:"Y2xhc3NpZmllcihtaW5kcyU1QjAlNUQlNUIlMjJwYXRoJTIyJTVEKQ==",highlighted:'classifier(minds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;path&quot;</span>])'}}),le=new M({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjk2MzE1MjUyNzgwOTE0MzElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMnBheV9iaWxsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAyODE5Njk4MzAzOTM3OTEyJTJDJTIwJTIybGFiZWwlMjIlM0ElMjAlMjJmcmVlemUlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAzMjc4NzQ5Mjk2NDQxNjc0MiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2FyZF9pc3N1ZXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAxOTQxNDQ0NTg1MDk5ODE2MyUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyYWJyb2FkJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAwMDgzNzg2OTM2MDExMTY1MzglMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMmhpZ2hfdmFsdWVfcGF5bWVudCUyMiU3RCUyQyUwQSU1RA==",highlighted:`[
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.9631525278091431</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;pay_bill&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.02819698303937912</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;freeze&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0032787492964416742</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;card_issues&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0019414445850998163</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;abroad&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0008378693601116538</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;high_value_payment&quot;</span>},
]`}}),ie=new w({}),ue=new M({props:{code:"c3BlZWNoX2NvbW1hbmRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMnNwZWVjaF9jb21tYW5kcyUyMiUyQyUyMCUyMnYwLjAyJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUwQSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoc3BlZWNoX2NvbW1hbmRzKSk=",highlighted:`speech_commands = load_dataset(
    <span class="hljs-string">&quot;speech_commands&quot;</span>, <span class="hljs-string">&quot;v0.02&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(speech_commands))`}}),ce=new M({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJNSVQlMkZhc3QtZmluZXR1bmVkLXNwZWVjaC1jb21tYW5kcy12MiUyMiUwQSklMEFjbGFzc2lmaWVyKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSk=",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;MIT/ast-finetuned-speech-commands-v2&quot;</span>
)
classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())`}}),me=new M({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTg5MjcxMTYzOTQwNCUyQyUyMCdsYWJlbCclM0ElMjAnYmFja3dhcmQnJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDEuNzUwNDg4ODc3NDA1NTg3MWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ2hhcHB5JyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA2LjcwMzA0MDE4NTEyOTc5NGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ2ZvbGxvdyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwNS44MDU4ODQ0ODQyODg5ODFlLTA3JTJDJTIwJ2xhYmVsJyUzQSUyMCdzdG9wJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA1LjYxNDU0NjY5NDIzMjU1OGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ3VwJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999892711639404</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;backward</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">1.7504888774055871</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;happy</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">6.703040185129794</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;follow</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.805884484288981</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;stop</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.614546694232558</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;up</span>&#x27;}]`}}),fe=new M({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`from <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">IPython</span>.</span></span>display import Audio

<span class="hljs-constructor">Audio(<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], <span class="hljs-params">rate</span>=<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])</span>`}}),ge=new w({}),xe=new w({}),Je=new M({props:{code:"ZmxldXJzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdvb2dsZSUyRmZsZXVycyUyMiUyQyUyMCUyMmFsbCUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBc2FtcGxlJTIwJTNEJTIwbmV4dChpdGVyKGZsZXVycykp",highlighted:`fleurs = load_dataset(<span class="hljs-string">&quot;google/fleurs&quot;</span>, <span class="hljs-string">&quot;all&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(fleurs))`}}),Te=new M({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzYW5jaGl0LWdhbmRoaSUyRndoaXNwZXItbWVkaXVtLWZsZXVycy1sYW5nLWlkJTIyJTBBKQ==",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-medium-fleurs-lang-id&quot;</span>
)`}}),$e=new M({props:{code:"Y2xhc3NpZmllcihzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCk=",highlighted:'classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>])'}}),Ne=new M({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTMzMDA0Mzc5MjcyNSUyQyUyMCdsYWJlbCclM0ElMjAnQWZyaWthYW5zJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA3LjA5MzAyMzY2ODg1ODIyM2UtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ05vcnRoZXJuLVNvdGhvJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA0LjI2OTE0OTQ4NTQ4MDczOWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ0ljZWxhbmRpYyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwMy4yNjYxMTQxNjMxMjUxNjY3ZS0wNiUyQyUyMCdsYWJlbCclM0ElMjAnRGFuaXNoJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAzLjI1ODA3MjQxMDk3MjA5MDRlLTA2JTJDJTIwJ2xhYmVsJyUzQSUyMCdDYW50b25lc2UlMjBDaGluZXNlJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999330043792725</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Afrikaans</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">7.093023668858223</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Northern-Sotho</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">4.269149485480739</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Icelandic</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2661141631251667</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Danish</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2580724109720904</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Cantonese</span> Chinese&#x27;}]`}}),_e=new w({}),Se=new M({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhc2hyYXElMkZlc2M1MCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWF1ZGlvX3NhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSklNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVE",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;ashraq/esc50&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
audio_sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]`}}),Ae=new M({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMlNvdW5kJTIwb2YlMjBhJTIwZG9nJTIyJTJDJTIwJTIyU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXIlMjIlNUQ=",highlighted:'candidate_labels = [<span class="hljs-string">&quot;Sound of a dog&quot;</span>, <span class="hljs-string">&quot;Sound of vacuum cleaner&quot;</span>]'}}),Ee=new M({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmxhaW9uJTJGY2xhcC1odHNhdC11bmZ1c2VkJTIyJTBBKSUwQWNsYXNzaWZpZXIoYXVkaW9fc2FtcGxlJTJDJTIwY2FuZGlkYXRlX2xhYmVscyUzRGNhbmRpZGF0ZV9sYWJlbHMp",highlighted:`classifier = pipeline(
    task=<span class="hljs-string">&quot;zero-shot-audio-classification&quot;</span>, model=<span class="hljs-string">&quot;laion/clap-htsat-unfused&quot;</span>
)
classifier(audio_sample, candidate_labels=candidate_labels)`}}),We=new M({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5NzI0MjA5MzA4NjI0MyUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMGElMjBkb2cnJTdEJTJDJTIwJTdCJ3Njb3JlJyUzQSUyMDAuMDAwMjc1ODMyMzk3MTY0Nzc2OSUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXInJTdEJTVE",highlighted:'[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9997242093086243</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of a dog&#x27;}, {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.0002758323971647769</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of vacuum cleaner&#x27;}]'}}),Ye=new M({props:{code:"QXVkaW8oYXVkaW8lMkMlMjByYXRlJTNEMTYwMDAp",highlighted:'Audio(audio, rate=<span class="hljs-number">16000</span>)'}}),Pe=new w({}),{c(){b=l("meta"),ms=i(),ts=l("p"),hs=i(),g=l("h1"),N=l("a"),ns=l("span"),d(Y.$$.fragment),It=i(),De=l("span"),De.textContent=Yt,fs=i(),G=l("p"),G.innerHTML=Gt,vs=i(),j=l("h2"),z=l("a"),ls=l("span"),d(P.$$.fragment),kt=i(),Ve=l("span"),Ve.textContent=Pt,ys=i(),R=l("p"),R.innerHTML=Rt,Ms=i(),d(D.$$.fragment),bs=i(),x=l("h2"),_=l("a"),as=l("span"),d(V.$$.fragment),St=i(),Be=l("span"),Be.textContent=Dt,gs=i(),B=l("p"),B.innerHTML=Vt,js=i(),U=l("h3"),I=l("a"),is=l("span"),d(F.$$.fragment),Lt=i(),Fe=l("span"),Fe.textContent=Bt,xs=i(),X=l("p"),X.innerHTML=Ft,Us=i(),d(O.$$.fragment),Js=i(),K=l("p"),K.innerHTML=Xt,qs=i(),d(ee.$$.fragment),Ts=i(),se=l("p"),se.textContent=Ot,Cs=i(),d(te.$$.fragment),$s=i(),ne=l("p"),ne.innerHTML=Kt,ws=i(),d(le.$$.fragment),Ns=i(),ae=l("p"),ae.textContent=en,zs=i(),J=l("h3"),k=l("a"),os=l("span"),d(ie.$$.fragment),At=i(),Xe=l("span"),Xe.textContent=sn,_s=i(),oe=l("p"),oe.innerHTML=tn,Is=i(),S=l("div"),S.innerHTML=nn,ks=i(),re=l("p"),re.innerHTML=ln,Ss=i(),d(ue.$$.fragment),Ls=i(),pe=l("p"),pe.innerHTML=an,As=i(),d(ce.$$.fragment),Hs=i(),de=l("p"),de.innerHTML=on,Es=i(),d(me.$$.fragment),Qs=i(),he=l("p"),he.innerHTML=rn,Ws=i(),d(fe.$$.fragment),Zs=i(),ve=l("p"),ve.innerHTML=un,Ys=i(),L=l("div"),L.innerHTML=pn,Gs=i(),ye=l("p"),ye.textContent=cn,Ps=i(),A=l("div"),A.innerHTML=dn,Rs=i(),Me=l("p"),Me.innerHTML=mn,Ds=i(),H=l("div"),H.innerHTML=hn,Vs=i(),be=l("p"),be.innerHTML=fn,Bs=i(),q=l("h2"),E=l("a"),rs=l("span"),d(ge.$$.fragment),Ht=i(),Oe=l("span"),Oe.textContent=vn,Fs=i(),je=l("p"),je.textContent=yn,Xs=i(),T=l("h3"),Q=l("a"),us=l("span"),d(xe.$$.fragment),Et=i(),Ke=l("span"),Ke.textContent=Mn,Os=i(),Ue=l("p"),Ue.innerHTML=bn,Ks=i(),d(Je.$$.fragment),et=i(),qe=l("p"),qe.innerHTML=gn,st=i(),d(Te.$$.fragment),tt=i(),Ce=l("p"),Ce.textContent=jn,nt=i(),d($e.$$.fragment),lt=i(),we=l("p"),we.innerHTML=xn,at=i(),d(Ne.$$.fragment),it=i(),ze=l("p"),ze.innerHTML=Un,ot=i(),C=l("h2"),W=l("a"),ps=l("span"),d(_e.$$.fragment),Qt=i(),es=l("span"),es.textContent=Jn,rt=i(),Ie=l("p"),Ie.innerHTML=qn,ut=i(),ke=l("p"),ke.innerHTML=Tn,pt=i(),d(Se.$$.fragment),ct=i(),Le=l("p"),Le.innerHTML=Cn,dt=i(),d(Ae.$$.fragment),mt=i(),He=l("p"),He.textContent=$n,ht=i(),d(Ee.$$.fragment),ft=i(),Qe=l("p"),Qe.innerHTML=wn,vt=i(),d(We.$$.fragment),yt=i(),Ze=l("p"),Ze.textContent=Nn,Mt=i(),d(Ye.$$.fragment),bt=i(),Ge=l("p"),Ge.innerHTML=zn,gt=i(),$=l("h2"),Z=l("a"),cs=l("span"),d(Pe.$$.fragment),Wt=i(),ss=l("span"),ss.textContent=_n,jt=i(),Re=l("p"),Re.innerHTML=In,xt=i(),ds=l("p"),this.h()},l(e){const t=nl("svelte-1phssyn",document.head);b=a(t,"META",{name:!0,content:!0}),t.forEach(s),ms=o(e),ts=a(e,"P",{}),c(ts).forEach(s),hs=o(e),g=a(e,"H1",{class:!0});var Jt=c(g);N=a(Jt,"A",{id:!0,class:!0,href:!0});var kn=c(N);ns=a(kn,"SPAN",{});var Sn=c(ns);m(Y.$$.fragment,Sn),Sn.forEach(s),kn.forEach(s),It=o(Jt),De=a(Jt,"SPAN",{"data-svelte-h":!0}),r(De)!=="svelte-19mctzx"&&(De.textContent=Yt),Jt.forEach(s),fs=o(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-lsxr7h"&&(G.innerHTML=Gt),vs=o(e),j=a(e,"H2",{class:!0});var qt=c(j);z=a(qt,"A",{id:!0,class:!0,href:!0});var Ln=c(z);ls=a(Ln,"SPAN",{});var An=c(ls);m(P.$$.fragment,An),An.forEach(s),Ln.forEach(s),kt=o(qt),Ve=a(qt,"SPAN",{"data-svelte-h":!0}),r(Ve)!=="svelte-18ha4rr"&&(Ve.textContent=Pt),qt.forEach(s),ys=o(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-zanaqk"&&(R.innerHTML=Rt),Ms=o(e),m(D.$$.fragment,e),bs=o(e),x=a(e,"H2",{class:!0});var Tt=c(x);_=a(Tt,"A",{id:!0,class:!0,href:!0});var Hn=c(_);as=a(Hn,"SPAN",{});var En=c(as);m(V.$$.fragment,En),En.forEach(s),Hn.forEach(s),St=o(Tt),Be=a(Tt,"SPAN",{"data-svelte-h":!0}),r(Be)!=="svelte-1if6g2u"&&(Be.textContent=Dt),Tt.forEach(s),gs=o(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-2mhc4i"&&(B.innerHTML=Vt),js=o(e),U=a(e,"H3",{class:!0});var Ct=c(U);I=a(Ct,"A",{id:!0,class:!0,href:!0});var Qn=c(I);is=a(Qn,"SPAN",{});var Wn=c(is);m(F.$$.fragment,Wn),Wn.forEach(s),Qn.forEach(s),Lt=o(Ct),Fe=a(Ct,"SPAN",{"data-svelte-h":!0}),r(Fe)!=="svelte-1k6ssom"&&(Fe.textContent=Bt),Ct.forEach(s),xs=o(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-pxcq6"&&(X.innerHTML=Ft),Us=o(e),m(O.$$.fragment,e),Js=o(e),K=a(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-14uya4i"&&(K.innerHTML=Xt),qs=o(e),m(ee.$$.fragment,e),Ts=o(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1ahiviy"&&(se.textContent=Ot),Cs=o(e),m(te.$$.fragment,e),$s=o(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-dbzevp"&&(ne.innerHTML=Kt),ws=o(e),m(le.$$.fragment,e),Ns=o(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1exq1ul"&&(ae.textContent=en),zs=o(e),J=a(e,"H3",{class:!0});var $t=c(J);k=a($t,"A",{id:!0,class:!0,href:!0});var Zn=c(k);os=a(Zn,"SPAN",{});var Yn=c(os);m(ie.$$.fragment,Yn),Yn.forEach(s),Zn.forEach(s),At=o($t),Xe=a($t,"SPAN",{"data-svelte-h":!0}),r(Xe)!=="svelte-ulb7f3"&&(Xe.textContent=sn),$t.forEach(s),_s=o(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1dnncr2"&&(oe.innerHTML=tn),Is=o(e),S=a(e,"DIV",{class:!0,"data-svelte-h":!0}),r(S)!=="svelte-sk0ezl"&&(S.innerHTML=nn),ks=o(e),re=a(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-7cdmxy"&&(re.innerHTML=ln),Ss=o(e),m(ue.$$.fragment,e),Ls=o(e),pe=a(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-9uwmvh"&&(pe.innerHTML=an),As=o(e),m(ce.$$.fragment,e),Hs=o(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-dbzevp"&&(de.innerHTML=on),Es=o(e),m(me.$$.fragment,e),Qs=o(e),he=a(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1nyizdg"&&(he.innerHTML=rn),Ws=o(e),m(fe.$$.fragment,e),Zs=o(e),ve=a(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-bjsjj0"&&(ve.innerHTML=un),Ys=o(e),L=a(e,"DIV",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-bqfzrn"&&(L.innerHTML=pn),Gs=o(e),ye=a(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-9ifayn"&&(ye.textContent=cn),Ps=o(e),A=a(e,"DIV",{class:!0,"data-svelte-h":!0}),r(A)!=="svelte-1t2za6k"&&(A.innerHTML=dn),Rs=o(e),Me=a(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1ruh3w6"&&(Me.innerHTML=mn),Ds=o(e),H=a(e,"DIV",{class:!0,"data-svelte-h":!0}),r(H)!=="svelte-1sstogo"&&(H.innerHTML=hn),Vs=o(e),be=a(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1coiede"&&(be.innerHTML=fn),Bs=o(e),q=a(e,"H2",{class:!0});var wt=c(q);E=a(wt,"A",{id:!0,class:!0,href:!0});var Gn=c(E);rs=a(Gn,"SPAN",{});var Pn=c(rs);m(ge.$$.fragment,Pn),Pn.forEach(s),Gn.forEach(s),Ht=o(wt),Oe=a(wt,"SPAN",{"data-svelte-h":!0}),r(Oe)!=="svelte-oea8kd"&&(Oe.textContent=vn),wt.forEach(s),Fs=o(e),je=a(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1kvumvt"&&(je.textContent=yn),Xs=o(e),T=a(e,"H3",{class:!0});var Nt=c(T);Q=a(Nt,"A",{id:!0,class:!0,href:!0});var Rn=c(Q);us=a(Rn,"SPAN",{});var Dn=c(us);m(xe.$$.fragment,Dn),Dn.forEach(s),Rn.forEach(s),Et=o(Nt),Ke=a(Nt,"SPAN",{"data-svelte-h":!0}),r(Ke)!=="svelte-6ko8yw"&&(Ke.textContent=Mn),Nt.forEach(s),Os=o(e),Ue=a(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-wss39v"&&(Ue.innerHTML=bn),Ks=o(e),m(Je.$$.fragment,e),et=o(e),qe=a(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1xnisix"&&(qe.innerHTML=gn),st=o(e),m(Te.$$.fragment,e),tt=o(e),Ce=a(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-mwec1y"&&(Ce.textContent=jn),nt=o(e),m($e.$$.fragment,e),lt=o(e),we=a(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-dbzevp"&&(we.innerHTML=xn),at=o(e),m(Ne.$$.fragment,e),it=o(e),ze=a(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1uvuy1n"&&(ze.innerHTML=Un),ot=o(e),C=a(e,"H2",{class:!0});var zt=c(C);W=a(zt,"A",{id:!0,class:!0,href:!0});var Vn=c(W);ps=a(Vn,"SPAN",{});var Bn=c(ps);m(_e.$$.fragment,Bn),Bn.forEach(s),Vn.forEach(s),Qt=o(zt),es=a(zt,"SPAN",{"data-svelte-h":!0}),r(es)!=="svelte-1n23ksg"&&(es.textContent=Jn),zt.forEach(s),rt=o(e),Ie=a(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-abl4ay"&&(Ie.innerHTML=qn),ut=o(e),ke=a(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1hlgy2h"&&(ke.innerHTML=Tn),pt=o(e),m(Se.$$.fragment,e),ct=o(e),Le=a(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1imgqdy"&&(Le.innerHTML=Cn),dt=o(e),m(Ae.$$.fragment,e),mt=o(e),He=a(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-k1iv44"&&(He.textContent=$n),ht=o(e),m(Ee.$$.fragment,e),ft=o(e),Qe=a(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-dbzevp"&&(Qe.innerHTML=wn),vt=o(e),m(We.$$.fragment,e),yt=o(e),Ze=a(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-2np99t"&&(Ze.textContent=Nn),Mt=o(e),m(Ye.$$.fragment,e),bt=o(e),Ge=a(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1hhsvs9"&&(Ge.innerHTML=zn),gt=o(e),$=a(e,"H2",{class:!0});var _t=c($);Z=a(_t,"A",{id:!0,class:!0,href:!0});var Fn=c(Z);cs=a(Fn,"SPAN",{});var Xn=c(cs);m(Pe.$$.fragment,Xn),Xn.forEach(s),Fn.forEach(s),Wt=o(_t),ss=a(_t,"SPAN",{"data-svelte-h":!0}),r(ss)!=="svelte-19okr92"&&(ss.textContent=_n),_t.forEach(s),jt=o(e),Re=a(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-12mdb7a"&&(Re.innerHTML=In),xt=o(e),ds=a(e,"P",{}),c(ds).forEach(s),this.h()},h(){u(b,"name","hf:doc:metadata"),u(b,"content",JSON.stringify(al)),u(N,"id","modles-et-jeux-de-donnes-prentrans-pour-la-classification-daudio"),u(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(N,"href","#modles-et-jeux-de-donnes-prentrans-pour-la-classification-daudio"),u(g,"class","relative group"),u(z,"id","installation-de-transformers"),u(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(z,"href","#installation-de-transformers"),u(j,"class","relative group"),u(_,"id","reprage-de-motscls"),u(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(_,"href","#reprage-de-motscls"),u(x,"class","relative group"),u(I,"id","minds14"),u(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(I,"href","#minds14"),u(U,"class","relative group"),u(k,"id","speech-commands"),u(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(k,"href","#speech-commands"),u(J,"class","relative group"),u(S,"class","flex justify-center"),u(L,"class","flex justify-center"),u(A,"class","flex justify-center"),u(H,"class","flex justify-center"),u(E,"id","identification-de-la-langue"),u(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(E,"href","#identification-de-la-langue"),u(q,"class","relative group"),u(Q,"id","fleurs"),u(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Q,"href","#fleurs"),u(T,"class","relative group"),u(W,"id","classification-daudio-en-zroshot"),u(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(W,"href","#classification-daudio-en-zroshot"),u(C,"class","relative group"),u(Z,"id","et-ensuite"),u(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Z,"href","#et-ensuite"),u($,"class","relative group")},m(e,t){p(document.head,b),n(e,ms,t),n(e,ts,t),n(e,hs,t),n(e,g,t),p(g,N),p(N,ns),h(Y,ns,null),p(g,It),p(g,De),n(e,fs,t),n(e,G,t),n(e,vs,t),n(e,j,t),p(j,z),p(z,ls),h(P,ls,null),p(j,kt),p(j,Ve),n(e,ys,t),n(e,R,t),n(e,Ms,t),h(D,e,t),n(e,bs,t),n(e,x,t),p(x,_),p(_,as),h(V,as,null),p(x,St),p(x,Be),n(e,gs,t),n(e,B,t),n(e,js,t),n(e,U,t),p(U,I),p(I,is),h(F,is,null),p(U,Lt),p(U,Fe),n(e,xs,t),n(e,X,t),n(e,Us,t),h(O,e,t),n(e,Js,t),n(e,K,t),n(e,qs,t),h(ee,e,t),n(e,Ts,t),n(e,se,t),n(e,Cs,t),h(te,e,t),n(e,$s,t),n(e,ne,t),n(e,ws,t),h(le,e,t),n(e,Ns,t),n(e,ae,t),n(e,zs,t),n(e,J,t),p(J,k),p(k,os),h(ie,os,null),p(J,At),p(J,Xe),n(e,_s,t),n(e,oe,t),n(e,Is,t),n(e,S,t),n(e,ks,t),n(e,re,t),n(e,Ss,t),h(ue,e,t),n(e,Ls,t),n(e,pe,t),n(e,As,t),h(ce,e,t),n(e,Hs,t),n(e,de,t),n(e,Es,t),h(me,e,t),n(e,Qs,t),n(e,he,t),n(e,Ws,t),h(fe,e,t),n(e,Zs,t),n(e,ve,t),n(e,Ys,t),n(e,L,t),n(e,Gs,t),n(e,ye,t),n(e,Ps,t),n(e,A,t),n(e,Rs,t),n(e,Me,t),n(e,Ds,t),n(e,H,t),n(e,Vs,t),n(e,be,t),n(e,Bs,t),n(e,q,t),p(q,E),p(E,rs),h(ge,rs,null),p(q,Ht),p(q,Oe),n(e,Fs,t),n(e,je,t),n(e,Xs,t),n(e,T,t),p(T,Q),p(Q,us),h(xe,us,null),p(T,Et),p(T,Ke),n(e,Os,t),n(e,Ue,t),n(e,Ks,t),h(Je,e,t),n(e,et,t),n(e,qe,t),n(e,st,t),h(Te,e,t),n(e,tt,t),n(e,Ce,t),n(e,nt,t),h($e,e,t),n(e,lt,t),n(e,we,t),n(e,at,t),h(Ne,e,t),n(e,it,t),n(e,ze,t),n(e,ot,t),n(e,C,t),p(C,W),p(W,ps),h(_e,ps,null),p(C,Qt),p(C,es),n(e,rt,t),n(e,Ie,t),n(e,ut,t),n(e,ke,t),n(e,pt,t),h(Se,e,t),n(e,ct,t),n(e,Le,t),n(e,dt,t),h(Ae,e,t),n(e,mt,t),n(e,He,t),n(e,ht,t),h(Ee,e,t),n(e,ft,t),n(e,Qe,t),n(e,vt,t),h(We,e,t),n(e,yt,t),n(e,Ze,t),n(e,Mt,t),h(Ye,e,t),n(e,bt,t),n(e,Ge,t),n(e,gt,t),n(e,$,t),p($,Z),p(Z,cs),h(Pe,cs,null),p($,Wt),p($,ss),n(e,jt,t),n(e,Re,t),n(e,xt,t),n(e,ds,t),Ut=!0},p:Kn,i(e){Ut||(f(Y.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(V.$$.fragment,e),f(F.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(ue.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(xe.$$.fragment,e),f(Je.$$.fragment,e),f(Te.$$.fragment,e),f($e.$$.fragment,e),f(Ne.$$.fragment,e),f(_e.$$.fragment,e),f(Se.$$.fragment,e),f(Ae.$$.fragment,e),f(Ee.$$.fragment,e),f(We.$$.fragment,e),f(Ye.$$.fragment,e),f(Pe.$$.fragment,e),Ut=!0)},o(e){v(Y.$$.fragment,e),v(P.$$.fragment,e),v(D.$$.fragment,e),v(V.$$.fragment,e),v(F.$$.fragment,e),v(O.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(le.$$.fragment,e),v(ie.$$.fragment,e),v(ue.$$.fragment,e),v(ce.$$.fragment,e),v(me.$$.fragment,e),v(fe.$$.fragment,e),v(ge.$$.fragment,e),v(xe.$$.fragment,e),v(Je.$$.fragment,e),v(Te.$$.fragment,e),v($e.$$.fragment,e),v(Ne.$$.fragment,e),v(_e.$$.fragment,e),v(Se.$$.fragment,e),v(Ae.$$.fragment,e),v(Ee.$$.fragment,e),v(We.$$.fragment,e),v(Ye.$$.fragment,e),v(Pe.$$.fragment,e),Ut=!1},d(e){e&&(s(ms),s(ts),s(hs),s(g),s(fs),s(G),s(vs),s(j),s(ys),s(R),s(Ms),s(bs),s(x),s(gs),s(B),s(js),s(U),s(xs),s(X),s(Us),s(Js),s(K),s(qs),s(Ts),s(se),s(Cs),s($s),s(ne),s(ws),s(Ns),s(ae),s(zs),s(J),s(_s),s(oe),s(Is),s(S),s(ks),s(re),s(Ss),s(Ls),s(pe),s(As),s(Hs),s(de),s(Es),s(Qs),s(he),s(Ws),s(Zs),s(ve),s(Ys),s(L),s(Gs),s(ye),s(Ps),s(A),s(Rs),s(Me),s(Ds),s(H),s(Vs),s(be),s(Bs),s(q),s(Fs),s(je),s(Xs),s(T),s(Os),s(Ue),s(Ks),s(et),s(qe),s(st),s(tt),s(Ce),s(nt),s(lt),s(we),s(at),s(it),s(ze),s(ot),s(C),s(rt),s(Ie),s(ut),s(ke),s(pt),s(ct),s(Le),s(dt),s(mt),s(He),s(ht),s(ft),s(Qe),s(vt),s(yt),s(Ze),s(Mt),s(bt),s(Ge),s(gt),s($),s(jt),s(Re),s(xt),s(ds)),s(b),y(Y),y(P),y(D,e),y(V),y(F),y(O,e),y(ee,e),y(te,e),y(le,e),y(ie),y(ue,e),y(ce,e),y(me,e),y(fe,e),y(ge),y(xe),y(Je,e),y(Te,e),y($e,e),y(Ne,e),y(_e),y(Se,e),y(Ae,e),y(Ee,e),y(We,e),y(Ye,e),y(Pe)}}}const al={local:"modles-et-jeux-de-donnes-prentrans-pour-la-classification-daudio",sections:[{local:"installation-de-transformers",title:"🤗 Installation de Transformers"},{local:"reprage-de-motscls",sections:[{local:"minds14",title:"MINDS-14"},{local:"speech-commands",title:"Speech Commands"}],title:"Repérage de mots-clés"},{local:"identification-de-la-langue",sections:[{local:"fleurs",title:"FLEURS"}],title:"Identification de la langue"},{local:"classification-daudio-en-zroshot",title:"Classification d’audio en zéro-shot"},{local:"et-ensuite",title:"Et ensuite ?"}],title:"Modèles et jeux de données pré-entraînés pour la classification d’audio"};function il(Zt){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cl extends sl{constructor(b){super(),tl(this,b,il,ll,On,{})}}export{cl as component};
