import{s as bl,n as gl,o as vl}from"../chunks/scheduler.f7e1785c.js";import{S as fl,i as Il,g as o,s as l,u,m as j,H as zt,A as Sl,h as r,f as t,c as a,j as w,v as d,y as i,n as b,E as Xt,k as T,o as p,a as n,w as c,d as m,t as M,x as h}from"../chunks/index.815a732f.js";import{I as Ms}from"../chunks/IconCopyLink.e7937f56.js";import{C as U}from"../chunks/CodeBlock.c6e8b464.js";function xl(pn){let g,hs,rs,ys,v,B,is,$,Pt,Oe,un="Modèles pré-entraînés pour la reconnaissance automatique de la parole",Ts,F,dn=`Dans cette section, nous verrons comment utiliser le <code>pipeline()</code> pour tirer parti des modèles pré-entraînés pour la reconnaissance automatique de la parole. Dans l’[unité 2](.. /chapter2/asr_pipeline), nous avons introduit le <code>pipeline()</code> comme un moyen facile d’exécuter des tâches de reconnaissance de la parole, avec tout le prétraitement et le post-traitement gérés sous le capot et la flexibilité d’expérimenter rapidement avec n’importe quel <em>checkpoint</em> pré-entraîné disponible sur le <em>Hub</em>.
Dans cette unité, nous irons plus loin et explorerons les différents attributs des modèles de reconnaissance automatique de la parole et comment nous pouvons les utiliser pour aborder une gamme de tâches différentes.`,Us,W,cn="Comme détaillé dans l’unité 3, le modèle de reconnaissance automatique de la parole se divise généralement dans l’une des deux catégories suivantes :",Js,H,mn="<li>Modèle avec Classification temporelle connexionniste (CTC) : modèles avec que l’encodeur du <em>transformer</em> avec une tête de classification linéaire sur le dessus</li> <li>Modèle de séquence à séquence (Seq2Seq) : modèles encodeur-décodeur, avec un mécanisme d’attention croisée entre l’encodeur et le décodeur</li>",ws,N,Mn=`Avant 2022, la variante avec CTC était la plus populaire des deux architectures, avec des modèles tels que Wav2Vec2, HuBERT et XLSR réalisant des percées dans le paradigme de pré-entraînement / <em>finetuning</em> de la parole.
De grandes entreprises, telles que Meta et Microsoft, ont pré-entraîné l’encodeur sur de grandes quantités de données audio non étiquetées pendant plusieurs jours ou semaines.
Les utilisateurs pouvent ensuite prendre un <em>checkpoint</em> pré-entraîné et le finetuner avec une tête CTC sur à peine <strong>10 minutes</strong> de données audio étiquetées pour obtenir de solides performances sur une tâche en aval de reconnaissance automatique de la parole.
Cependant, les modèles CTC ont des lacunes. L’ajout d’une simple couche linéaire à un encodeur donne un petit modèle global rapide, mais peut être sujet à des fautes d’orthographe phonétiques. Nous allons le démontrer ci-dessous pour le modèle Wav2Vec2.`,js,f,k,ps,Z,Ot,De,hn="Sonder les modèles CTC",bs,_,yn='Chargeons un petit extrait du jeu de données <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> pour démontrer les capacités de transcription de Wav2Vec2 :',gs,Y,vs,Q,Tn="<strong>Sortie :</strong>",fs,L,Is,A,Un="Nous pouvons choisir l’un des 73 échantillons audio et en inspecter l’audio ainsi que la transcription :",Ss,z,xs,X,Jn="<strong>Sortie :</strong>",Bs,P,ks,O,wn=`Noël et rôti de bœuf, ça sonne bien! 🎄 Après avoir choisi un échantillon de données, nous chargeons maintenant un <em>checkpoint</em> <em>finetuné</em> dans le <code>pipeline()</code>.
Pour cela, nous utiliserons le <em>checkpoint</em> officiel [base Wav2Vec2] (facebook/wav2vec2-base-100h) <em>finetuné</em> sur 100 heures de données LibriSpeech :`,Es,D,Cs,K,jn=`Ensuite, nous allons prendre un exemple du jeu de données et transmettre ses données brutes au pipeline.
Puisque le pipeline <em>consomme</em> n’importe quel dictionnaire que nous lui passons (ce qui signifie qu’il ne peut pas être réutilisé), nous transmettrons une copie des données. De cette façon, nous pouvons réutiliser en toute sécurité le même échantillon audio dans les exemples suivants:`,qs,ee,Gs,se,bn=`Nous pouvons voir que le modèle Wav2Vec2 fait un assez bon travail pour transcrire cet échantillon. A première vue, il semble généralement correct.
Mettons la cible et la prédiction côte à côte et mettons en évidence les différences:`,Rs,te,Vs,ne,gn="En comparant le texte cible à la transcription prévue, nous pouvons voir que tous les mots <em>sonnent</em> correctement mais que certains ne sont pas orthographiés avec précision. Par exemple :",$s,le,vn=`<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em>
Cela met en évidence les lacunes d’un modèle CTC. Un modèle CTC est essentiellement uniquement un modèle « acoustique» : il se compose d’un encodeur qui forme des représentations d’états cachés à partir des entrées audio, et d’une couche linéaire qui associe les états cachés aux caractères :</li>`,Fs,E,fn='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/wav2vec2-ctc.png" alt="Transformer encoder with a CTC head on top"/>',Ws,ae,In=`Cela signifie que le système base presque entièrement sa prédiction sur l’entrée acoustique qui lui a été donnée (les sons phonétiques de l’audio), et a donc tendance à transcrire l’audio de manière phonétique.
Il donne moins d’importance au contexte de modélisation linguistique des lettres précédentes et successives, et est donc sujet aux fautes d’orthographe phonétique.
Un modèle plus intelligent identifierait que <em>CHRISTMAUS</em> n’est pas un mot valide dans le vocabulaire anglais, et le corrigerait en <em>CHRISTMAS</em> lors de ses prédictions. Il nous manque également deux grandes fonctionnalités dans notre prédiction, la casse et la ponctuation, ce qui limite l’utilité des transcriptions du modèle aux applications réelles.`,Hs,I,C,us,oe,Dt,Ke,Sn="Passage à Seq2Seq",Ns,re,xn=`Comme indiqué dans l’unité 3, les modèles Seq2Seq sont formés d’un codeur et d’un décodeur reliés par un mécanisme d’attention croisée. L’encodeur joue le même rôle qu’auparavant, calculant des représentations d’états cachés des entrées audio, tandis que le décodeur joue le rôle d’un <strong>modèle de langage</strong>. Le décodeur traite toute la séquence de représentations d’états cachés de l’encodeur et génère les transcriptions de texte correspondantes. Avec le contexte global de l’entrée audio, le décodeur est capable d’utiliser le contexte du modèle de langage lorsqu’il fait ses prédictions, corrigeant les fautes d’orthographe à la volée et contournant ainsi le problème des prédictions phonétiques.
Les modèles Seq2Seq présentent deux inconvénients :`,Zs,ie,Bn="<li>Ils sont intrinsèquement plus lents lors du décodage puisqu’il se produit une étape à la fois, plutôt que tout à la fois 2. Ils nécessitent beaucoup plus de données d’entraînement pour converger</li>",_s,pe,kn=`Le besoin de grandes quantités de données d’apprentissage a été un goulot d’étranglement dans l’avancement des architectures Seq2Seq pour la parole. Les données audios étiquetées sont difficiles à obtenir, les plus grands jeux de données annotées à l’époque ne totalisant que 10 000 heures. Tout cela a changé en 2022 avec la sortie de <strong>Whisper</strong>. Whisper est un modèle pré-entraîné pour la reconnaissance automatique de la parole publié en <a href="https://openai.com/blog/whisper/" rel="nofollow">septembre 2022</a> par Alec Radford et al. d’OpenAI. Contrairement à ses prédécesseurs CTC, qui étaient entièrement pré-entraînés sur des données audio <strong>non étiquetées</strong>, Whisper est pré-entraîné sur une grande quantité de données de transcription audio <strong>étiquetées</strong>, 680 000 heures pour être précis.
Il s’agit d’un ordre de grandeur de données plus grand que les données audio non étiquetées utilisées pour entraîner Wav2Vec 2.0 (60 000 heures). De plus, 117 000 heures de ces données de pré-entraînement sont des données multilingues. Il en résulte des <em>checkpoints</em> qui peuvent être appliqués à plus de 96 langues, dont beaucoup sont considérées comme <em>à faible ressource</em>.
Lorsqu’ils sont passés à l’échelle, les modèles Whisper démontrent une forte capacité à généraliser sur de nombreux jeux de données et domaines. Obtenant des résultats compétitifs de pointe, avec un taux d’erreur de mots (WER) de près de 3% sur le sous-ensemble de test LibriSpeech et de 4,7% WER  sur le sous-ensemble de test TED-LIUM (<em>cf.</em> Tableau 8 du <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">papier de Whisper</a>).
La capacité de Whisper à gérer de longs échantillons audio, sa robustesse au bruit et sa capacité à prédire les transcriptions en casse et ponctuées revêtent une importance particulière. Cela en fait un candidat viable pour les systèmes de reconnaissance automatique de la parole du monde réel.
Le reste de cette section vous montrera comment utiliser les modèles Whisper pré-entraînés pour la reconnaissance automatique de la parole à l’aide de 🤗 <em>Transformers</em>. Dans de nombreuses situations, les <em>checkpoints</em> pré-entraînés sont extrêmement performants et donnent d’excellents résultats, nous vous encourageons donc à essayer de les utiliser comme première étape pour résoudre tout problème de reconnaissance automatique de la parole.
Grâce à un <em>finetuning</em>, les <em>checkpoints</em> peuvent être adaptés à des jeux de données et à des langues spécifiques afin d’améliorer encore ces résultats. Nous montrerons comment faire cela dans la section sur <a href="fine-tuning">le <em>finetuning</em></a>.
Whisper est disponible en cinq tailles différentes de modèles. Les quatre plus petits sont entraînés soit sur des données en anglais soit sur des données multilingues. Le <em>checkpoint</em> le plus grand est uniquement multilingue. Les neuf <em>checkpoints</em> pré-entraînés sont disponibles sur le <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow"><em>Hub</em></a>. Ils sont résumés dans le tableau suivant. « VRAM » indique la mémoire GPU requise pour exécuter le modèle avec une taille de batch minimale de 1. « <em>Rel Speed</em> » est la vitesse relative d’un <em>checkpoint</em> par rapport au plus grand modèle.
Sur la base de ces informations, vous pouvez sélectionner le <em>checkpoint</em> le plus adapté à votre matériel.`,Ys,ue,En='<thead><tr><th>Taille</th> <th>Paramètres</th> <th>VRAM / Go</th> <th><em>Rel Speed</em></th> <th>Anglais</th> <th>Multilingue</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',Qs,de,Cn='Chargeons le <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a>, qui est de taille comparable au Wav2Vec2 que nous avons utilisé précédemment. Anticipant notre passage à la reconnaissance automatique de la parole multilingue, nous allons charger la variante multilingue du <em>checkpoint</em> de base. Nous chargons également le modèle sur le GPU s’il est disponible, ou sur le CPU dans le cas contraire. Le <code>pipeline()</code> se chargera ensuite de déplacer toutes les entrées / sorties du CPU vers le GPU selon les besoins:',Ls,ce,As,me,qn="Bien, maintenant, transcrivons l’audio comme avant. Le seul changement que nous apportons est de passer un argument supplémentaire, <code>max_new_tokens</code>, qui indique au modèle le nombre maximum de <em>tokens</em> à générer lors de sa prédiction :",zs,Me,Xs,he,Gn="<strong>Sortie :</strong>",Ps,ye,Os,Te,Rn="La première chose que vous remarquerez est la présence de la casse et de la ponctuation. Cela rend immédiatement la transcription plus facile à lire par rapport à la transcription non casée et non ponctuée de Wav2Vec2. Mettons la transcription côte à côte avec la cible :",Ds,Ue,Ks,Je,Vn=`Whisper a fait un excellent travail pour corriger les erreurs phonétiques que nous avons vues avec Wav2Vec2 : <em>Christmas</em> et <em>roast</em> sont orthographiés correctement. Nous voyons que le modèle a encore du mal avec <em>SIMILES</em>, étant incorrectement transcrit comme <em>similarly</em>, mais cette fois la prédiction est un mot valide du vocabulaire anglais. L’utilisation d’un Whisper plus grand peut aider à réduire davantage les erreurs de transcription, au détriment d’un calcul plus important et d’un temps de transcription plus long.
On nous a promis un modèle capable de gérer 96 langues, alors passons à de la reconnaissance automatique multilingue 🌎 !
Le jeu de données <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a> (MLS) est l’équivalent multilingue du jeu de données LibriSpeech, avec des données audio étiquetées en six langues. Nous allons charger un échantillon de l’échantillon espagnol de MLS, en utilisant le mode <em>streaming</em> afin de ne pas avoir à télécharger l’ensemble de données :`,et,we,st,je,$n="Encore une fois, nous allons inspecter la transcription du texte et écouter le segment audio:",tt,be,nt,ge,Fn="<strong>Sortie :</strong>",lt,ve,at,fe,Wn="C’est le texte cible que nous visons avec notre transcription Whisper. Bien que nous sachions maintenant que nous pouvons probablement faire mieux, puisque notre modèle va aussi prédire la ponctuation et la casse, qui ne sont pas présents dans la référence. Transmettons l’échantillon audio au pipeline pour obtenir notre prédiction de texte. Une chose à noter est que le pipeline <em>consomme</em> le dictionnaire des entrées audio que nous entrons, ce qui signifie que le dictionnaire ne peut pas être réutilisé. Pour contourner ce problème, nous allons passer une <em>copie</em> de l’échantillon audio, afin de pouvoir réutiliser le même échantillon audio dans les exemples de code suivants :",ot,Ie,rt,Se,Hn="<strong>Sortie :</strong>",it,xe,pt,Be,Nn="Super, cela ressemble énormément à notre texte de référence (sans doute mieux car il a une ponctuation et une casse !). Vous remarquerez que nous avons transféré <code>&quot;task&quot;</code> en tant que <em>generate kwarg</em>. Définir la <code>&quot;task&quot;</code> à <code>&quot;transcribe&quot;</code> oblige Whisper à effectuer la tâche de reconnaissance de la parole, où l’audio est transcrit dans la même langue que le discours a été prononcé. Whisper est également capable d’effectuer la tâche étroitement liée de traduction de la parole, où l’audio en espagnol peut être traduit en texte en anglais. Pour y parvenir, nous définissons la <code>&quot;task&quot;</code> sur <code>&quot;translate&quot;</code> :",ut,ke,dt,Ee,Zn="<strong>Sortie :</strong>",ct,Ce,mt,qe,_n=`Maintenant que nous savons que nous pouvons basculer entre la reconnaissance automatique de la parole et la traduction de la parole, nous pouvons choisir notre tâche en fonction de nos besoins. Soit nous reconnaissons l’audio dans la langue X vers le texte dans la même langue X (par exemple, l’audio espagnol vers le texte espagnol), soit nous traduisons de l’audio dans n’importe quelle langue X vers du texte en anglais (par exemple, l’audio espagnol vers le texte anglais).
Pour en savoir plus sur la façon dont l’argument <code>&quot;task&quot;</code> est utilisé pour contrôler les propriétés du texte généré, reportez-vous à la <a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">carte de modèle</a> pour le modèle Whisper base.`,Mt,S,q,ds,Ge,Kt,es,Yn="Longue transcription et horodatage",ht,Re,Qn=`Jusqu’à présent, nous nous sommes concentrés sur la transcription de courts échantillons audio de moins de 30 secondes. Nous avons mentionné que l’un des attraits de Whisper était sa capacité à travailler sur de longs échantillons audio. Nous allons nous attaquer à cette tâche ici !
Créons un long fichier audio en concaténant des échantillons successifs à partir du jeu de données MLS. Étant donné que MLS est organisé en divisant de longs enregistrements de livres audio en segments plus courts, la concaténation d’échantillons est un moyen de reconstruire des passages de livres audio plus longs. Par conséquent, l’audio résultant doit être cohérent sur l’ensemble de l’échantillon. Nous allons définir notre durée audio cible sur 5 minutes et arrêter de concaténer des échantillons une fois que nous aurons atteint cette valeur :`,yt,Ve,Tt,$e,Ln="<strong>Sortie :</strong>",Ut,Fe,Jt,We,An="5 minutes et 17 secondes d’audio à transcrire. Le transfert de ce long échantillon audio directement vers le modèle pose deux problèmes :",wt,He,zn=`<li>Whisper est intrinsèquement conçu pour fonctionner avec des échantillons de 30 secondes. Tout ce qui est inférieur à 30s est rembourré à 30s avec du silence, et tout ce qui dépasse 30s est tronqué à 30s en coupant l’audio excédentaire. Donc si nous passons notre audio directement, nous n’obtiendrons la transcription que pour les 30 premières secondes</li> <li>La mémoire dans un <em>transformer</em> évolue quadratiquement avec la longueur de séquence a : doubler la longueur d’entrée quadruple le besoin en mémoire, de sorte que le passage de fichiers audio très longs entraînera inévitablement une erreur de mémoire insuffisante (OOM : out-of-memory)
La transcription de longs audio fonctionne dans 🤗 <em>Transformers</em> en segmentant l’audio d’entrée en segments plus petits et plus faciles à gérer.
Chaque segment a un petit chevauchement avec le précédent. Cela nous permet de recoudre avec précision les segments aux bornes, car nous pouvons trouver le chevauchement entre les segments et fusionner les transcriptions en conséquence :</li>`,jt,G,Xn='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',bt,y,en,gt,Ul='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',vt,ft,Jl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',It,ss,Pn="sans états",sn,St,wl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',xt,Bt,jl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',kt,ts,On="batch",tn,ns,Dn="Transformers",nn,R,Kn="https://huggingface.co/blog/asr-chunking",ln,ls,el="chunk_length_s",an,as,sl="batch_size",on,Et,Ne,Ct,Ze,tl="<strong>Sortie :</strong>",qt,_e,Gt,Ye,nl=`Nous n’affichons pas toute la sortie ici car elle est assez longue (312 mots au total). Sur un GPU V100 de 16 Go, vous pouvez vous attendre à ce que la ligne ci-dessus prenne environ 3,45 secondes à s’éxécuter, ce qui est assez bon pour un échantillon audio de 317 secondes. Sur un CPU, attendez-vous à plus de 30 secondes.
Whisper est également capable de prédire les <em>horodatages</em> au niveau du segment pour les données audio. Ces horodatages indiquent l’heure de début et de fin d’un court passage audio et sont particulièrement utiles pour aligner une transcription avec l’audio d’entrée. Supposons que nous voulions fournir des sous-titres pour une vidéo. Nous avons besoin de ces horodatages pour savoir quelle partie de la transcription correspond à un certain segment de vidéo, afin d’afficher la transcription correcte pour cette heure.
L’activation de la prédiction d’horodatage est simple, il suffit de définir l’argument <code>return_timestamps=True</code>. Les horodatages sont compatibles avec les méthodes de segmentation et de traitement par batchs que nous avons utilisées précédemment. Nous pouvons donc simplement ajouter l’argument timestamp à notre code précédent :`,Rt,Qe,Vt,Le,ll="<strong>Sortie :</strong>",$t,Ae,Ft,ze,al="Et le tour est joué ! Nous avons notre texte prédit ainsi que les horodatages correspondants.",Wt,x,V,cs,Xe,rn,os,ol="Résumé",Ht,Pe,rl=`Whisper est un modèle pré-entraîné solide pour la reconnaissance automatique de la parole et la traduction. Par rapport à Wav2Vec2, il a une plus grande précision de transcription, avec des sorties qui contiennent la ponctuation et la casse. Il peut être utilisé pour transcrire la parole en anglais ainsi que dans 96 autres langues, à la fois sur des segments audio courts et des segments plus longs par le biais de  la segmentation. Ces attributs en font un modèle viable pour de nombreuses tâches de reconnaissance automatique de la parole et de traduction sans avoir besoin d’être <em>finetuné</em>. La méthode <code>pipeline()</code> fournit un moyen facile d’inférer en une ligne de code avec un contrôle sur les prédictions générées.
Bien que le modèle Whisper fonctionne extrêmement bien sur de nombreuses langues à ressources élevées, il a une précision de transcription et de traduction plus faible sur les langues à faibles ressources, c’est-à-dire celles pour lesquelles les données d’apprentissage sont moins facilement disponibles. Les performances varient également selon les accents et dialectes de certaines langues, y compris une précision moindre pour les locuteurs de différents sexes, races, âges ou autres critères démographiques (<em>cf.</em> le papier de <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper</a>).
Pour améliorer les performances sur les langues, les accents ou les dialectes à faibles ressources, nous pouvons prendre le modèle Whisper pré-entraîné et l’entraîner sur un petit corpus de données sélectionnées de manière appropriée, dans un processus appelé <em><em>finetuning</em></em>. Nous montrerons qu’avec seulement dix heures de données supplémentaires, nous pouvons améliorer les performances du modèle Whisper de plus de 100% sur une langue à faibles ressources. Dans la section suivante, nous aborderons le processus de sélection d’un jeu de données à <em>finetuner</em>.`,Nt,ms,Zt;return $=new Ms({}),Z=new Ms({}),Y=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`}}),L=new U({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`}}),z=new U({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),P=new U({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND'}}),D=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`}}),ee=new U({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkpJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlMEElN0Q=",highlighted:`pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())
{
    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;</span>
}`}}),te=new U({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`}}),oe=new Ms({}),ce=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`}}),Me=new U({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)'}}),ye=new U({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}'}}),Ue=new U({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`}}),we=new U({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`}}),be=new U({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),ve=new U({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado'}}),Ie=new U({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})'}}),xe=new U({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}'}}),ke=new U({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})'}}),Ce=new U({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>'}}),Ge=new Ms({}),Ve=new U({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2xlbmd0aF9pbl9tJTIwJTNEJTIwNSUwQSUwQSUyMyUyMGNvbnZlcnRpciUyMGxlcyUyMG1pbnV0ZXMlMjBlbiUyMHNlY29uZGVzJTIwKColMjA2MCklMjBlbiUyMG5vbWJyZSUyMGQnJUMzJUE5Y2hhbnRpbGxvbnMlMjAoKiUyMHRhdXglMjBkJyVDMyVBOWNoYW50aWxsb25uYWdlKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBwaXBlLmZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMEF0YXJnZXRfbGVuZ3RoX2luX3NhbXBsZXMlMjAlM0QlMjB0YXJnZXRfbGVuZ3RoX2luX20lMjAqJTIwNjAlMjAqJTIwc2FtcGxpbmdfcmF0ZSUwQSUwQSUyMyUyMGl0JUMzJUE5cmVyJTIwc3VyJTIwbm90cmUlMjBqZXUlMjBkZSUyMGRvbm4lQzMlQTllcyUyMGVuJTIwc3RyZWFtaW5nJTJDJTIwZW4lMjBjb25jYXQlQzMlQTluYW50JTIwbGVzJTIwJUMzJUE5Y2hhbnRpbGxvbnMlMjBqdXNxdSclQzMlQTAlMjBjZSUyMHF1ZSUyMG5vdXMlMjBhdHRlaWduaW9ucyUyMG5vdHJlJTIwY2libGUlMEFsb25nX2F1ZGlvJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwc2FtcGxlJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwbG9uZ19hdWRpby5leHRlbmQoc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCklMEElMjAlMjAlMjAlMjBpZiUyMGxlbihsb25nX2F1ZGlvKSUyMCUzRSUyMHRhcmdldF9sZW5ndGhfaW5fc2FtcGxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBbG9uZ19hdWRpbyUyMCUzRCUyMG5wLmFzYXJyYXkobG9uZ19hdWRpbyklMEElMEElMjMlMjBSJUMzJUE5c3VsdGF0JTBBc2Vjb25kcyUyMCUzRCUyMGxlbihsb25nX2F1ZGlvKSUyMCUyRiUyMDE2MDAwJTBBbWludXRlcyUyQyUyMHNlY29uZHMlMjAlM0QlMjBkaXZtb2Qoc2Vjb25kcyUyQyUyMDYwKSUwQXByaW50KGYlMjJMZW5ndGglMjBvZiUyMGF1ZGlvJTIwc2FtcGxlJTIwaXMlMjAlN0JtaW51dGVzJTdEJTIwbWludXRlcyUyMCU3QnNlY29uZHMlM0EuMmYlN0QlMjBzZWNvbmRzJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># convertir les minutes en secondes (* 60) en nombre d&#x27;échantillons (* taux d&#x27;échantillonnage)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># itérer sur notre jeu de données en streaming, en concaténant les échantillons jusqu&#x27;à ce que nous atteignions notre cible</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># Résultat</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`}}),Fe=new U({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds'}}),Ne=new U({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`}}),_e=new U({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`}}),Qe=new U({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`}}),Ae=new U({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`}}),Xe=new Ms({}),{c(){g=o("meta"),hs=l(),rs=o("p"),ys=l(),v=o("h1"),B=o("a"),is=o("span"),u($.$$.fragment),Pt=l(),Oe=o("span"),Oe.textContent=un,Ts=l(),F=o("p"),F.innerHTML=dn,Us=l(),W=o("p"),W.textContent=cn,Js=l(),H=o("ol"),H.innerHTML=mn,ws=l(),N=o("p"),N.innerHTML=Mn,js=l(),f=o("h2"),k=o("a"),ps=o("span"),u(Z.$$.fragment),Ot=l(),De=o("span"),De.textContent=hn,bs=l(),_=o("p"),_.innerHTML=yn,gs=l(),u(Y.$$.fragment),vs=l(),Q=o("p"),Q.innerHTML=Tn,fs=l(),u(L.$$.fragment),Is=l(),A=o("p"),A.textContent=Un,Ss=l(),u(z.$$.fragment),xs=l(),X=o("p"),X.innerHTML=Jn,Bs=l(),u(P.$$.fragment),ks=l(),O=o("p"),O.innerHTML=wn,Es=l(),u(D.$$.fragment),Cs=l(),K=o("p"),K.innerHTML=jn,qs=l(),u(ee.$$.fragment),Gs=l(),se=o("p"),se.textContent=bn,Rs=l(),u(te.$$.fragment),Vs=l(),ne=o("p"),ne.innerHTML=gn,$s=l(),le=o("ul"),le.innerHTML=vn,Fs=l(),E=o("div"),E.innerHTML=fn,Ws=l(),ae=o("p"),ae.innerHTML=In,Hs=l(),I=o("h2"),C=o("a"),us=o("span"),u(oe.$$.fragment),Dt=l(),Ke=o("span"),Ke.textContent=Sn,Ns=l(),re=o("p"),re.innerHTML=xn,Zs=l(),ie=o("ol"),ie.innerHTML=Bn,_s=l(),pe=o("p"),pe.innerHTML=kn,Ys=l(),ue=o("table"),ue.innerHTML=En,Qs=l(),de=o("p"),de.innerHTML=Cn,Ls=l(),u(ce.$$.fragment),As=l(),me=o("p"),me.innerHTML=qn,zs=l(),u(Me.$$.fragment),Xs=l(),he=o("p"),he.innerHTML=Gn,Ps=l(),u(ye.$$.fragment),Os=l(),Te=o("p"),Te.textContent=Rn,Ds=l(),u(Ue.$$.fragment),Ks=l(),Je=o("p"),Je.innerHTML=Vn,et=l(),u(we.$$.fragment),st=l(),je=o("p"),je.textContent=$n,tt=l(),u(be.$$.fragment),nt=l(),ge=o("p"),ge.innerHTML=Fn,lt=l(),u(ve.$$.fragment),at=l(),fe=o("p"),fe.innerHTML=Wn,ot=l(),u(Ie.$$.fragment),rt=l(),Se=o("p"),Se.innerHTML=Hn,it=l(),u(xe.$$.fragment),pt=l(),Be=o("p"),Be.innerHTML=Nn,ut=l(),u(ke.$$.fragment),dt=l(),Ee=o("p"),Ee.innerHTML=Zn,ct=l(),u(Ce.$$.fragment),mt=l(),qe=o("p"),qe.innerHTML=_n,Mt=l(),S=o("h2"),q=o("a"),ds=o("span"),u(Ge.$$.fragment),Kt=l(),es=o("span"),es.textContent=Yn,ht=l(),Re=o("p"),Re.textContent=Qn,yt=l(),u(Ve.$$.fragment),Tt=l(),$e=o("p"),$e.innerHTML=Ln,Ut=l(),u(Fe.$$.fragment),Jt=l(),We=o("p"),We.textContent=An,wt=l(),He=o("ol"),He.innerHTML=zn,jt=l(),G=o("div"),G.innerHTML=Xn,bt=l(),y=o("p"),en=j("L’avantage de segmenter les échantillons est que nous n’avons pas besoin du résultat du bloc "),gt=new zt(!1),vt=j(" pour transcrire le morceau suivant "),ft=new zt(!1),It=j(". La couture est effectuée après que nous ayons transcrit tous les morceaux aux bornes des morceaux. Donc peu importe l’ordre dans lequel nous transcrivons les morceaux. L’algorithme est entièrement "),ss=o("strong"),ss.textContent=Pn,sn=j(", donc nous pouvons même faire du découpage sur "),St=new zt(!1),xt=j(" en même temps que du découpage sur "),Bt=new zt(!1),kt=j(" ! Cela nous permet de former des "),ts=o("em"),ts.textContent=On,tn=j(" de morceaux et de les exécuter dans le modèle en parallèle, offrant une grande accélération de calcul par rapport à leur transcription séquentielle. Pour en savoir plus sur la segmentation d’audio dans 🤗 "),ns=o("em"),ns.textContent=Dn,nn=j(", vous pouvez vous référer à cet [article de blog] ("),R=o("a"),R.textContent=Kn,ln=j(`) (en anglais).
Pour activer les longues transcriptions, nous devons ajouter un argument supplémentaire lorsque nous appelons le pipeline. Cet argument, `),ls=o("code"),ls.textContent=el,an=j(`, contrôle la longueur des segments divisés en secondes. Pour Whisper, des morceaux de 30 secondes sont optimaux, car cela correspond à la longueur d’entrée attendue par Whisper.
Pour activer le traitement par batch, nous devons passer l’argument `),as=o("code"),as.textContent=sl,on=j(" au pipeline. En mettant tout cela ensemble, nous pouvons transcrire le long échantillon audio comme suit:"),Et=l(),u(Ne.$$.fragment),Ct=l(),Ze=o("p"),Ze.innerHTML=tl,qt=l(),u(_e.$$.fragment),Gt=l(),Ye=o("p"),Ye.innerHTML=nl,Rt=l(),u(Qe.$$.fragment),Vt=l(),Le=o("p"),Le.innerHTML=ll,$t=l(),u(Ae.$$.fragment),Ft=l(),ze=o("p"),ze.textContent=al,Wt=l(),x=o("h2"),V=o("a"),cs=o("span"),u(Xe.$$.fragment),rn=l(),os=o("span"),os.textContent=ol,Ht=l(),Pe=o("p"),Pe.innerHTML=rl,Nt=l(),ms=o("p"),this.h()},l(e){const s=Sl("svelte-1phssyn",document.head);g=r(s,"META",{name:!0,content:!0}),s.forEach(t),hs=a(e),rs=r(e,"P",{}),w(rs).forEach(t),ys=a(e),v=r(e,"H1",{class:!0});var _t=w(v);B=r(_t,"A",{id:!0,class:!0,href:!0});var il=w(B);is=r(il,"SPAN",{});var pl=w(is);d($.$$.fragment,pl),pl.forEach(t),il.forEach(t),Pt=a(_t),Oe=r(_t,"SPAN",{"data-svelte-h":!0}),i(Oe)!=="svelte-1rwanye"&&(Oe.textContent=un),_t.forEach(t),Ts=a(e),F=r(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-3vbmup"&&(F.innerHTML=dn),Us=a(e),W=r(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1hil8d"&&(W.textContent=cn),Js=a(e),H=r(e,"OL",{"data-svelte-h":!0}),i(H)!=="svelte-1n4dhmh"&&(H.innerHTML=mn),ws=a(e),N=r(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1u61o1g"&&(N.innerHTML=Mn),js=a(e),f=r(e,"H2",{class:!0});var Yt=w(f);k=r(Yt,"A",{id:!0,class:!0,href:!0});var ul=w(k);ps=r(ul,"SPAN",{});var dl=w(ps);d(Z.$$.fragment,dl),dl.forEach(t),ul.forEach(t),Ot=a(Yt),De=r(Yt,"SPAN",{"data-svelte-h":!0}),i(De)!=="svelte-1ubnc48"&&(De.textContent=hn),Yt.forEach(t),bs=a(e),_=r(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1gr743m"&&(_.innerHTML=yn),gs=a(e),d(Y.$$.fragment,e),vs=a(e),Q=r(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-dbzevp"&&(Q.innerHTML=Tn),fs=a(e),d(L.$$.fragment,e),Is=a(e),A=r(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1a8dqyk"&&(A.textContent=Un),Ss=a(e),d(z.$$.fragment,e),xs=a(e),X=r(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-dbzevp"&&(X.innerHTML=Jn),Bs=a(e),d(P.$$.fragment,e),ks=a(e),O=r(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-dkq6xg"&&(O.innerHTML=wn),Es=a(e),d(D.$$.fragment,e),Cs=a(e),K=r(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1anz7jf"&&(K.innerHTML=jn),qs=a(e),d(ee.$$.fragment,e),Gs=a(e),se=r(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-1qo7344"&&(se.textContent=bn),Rs=a(e),d(te.$$.fragment,e),Vs=a(e),ne=r(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-rp0hzj"&&(ne.innerHTML=gn),$s=a(e),le=r(e,"UL",{"data-svelte-h":!0}),i(le)!=="svelte-64w2eh"&&(le.innerHTML=vn),Fs=a(e),E=r(e,"DIV",{class:!0,"data-svelte-h":!0}),i(E)!=="svelte-koi3b6"&&(E.innerHTML=fn),Ws=a(e),ae=r(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-13smvyy"&&(ae.innerHTML=In),Hs=a(e),I=r(e,"H2",{class:!0});var Qt=w(I);C=r(Qt,"A",{id:!0,class:!0,href:!0});var cl=w(C);us=r(cl,"SPAN",{});var ml=w(us);d(oe.$$.fragment,ml),ml.forEach(t),cl.forEach(t),Dt=a(Qt),Ke=r(Qt,"SPAN",{"data-svelte-h":!0}),i(Ke)!=="svelte-1wl3dzl"&&(Ke.textContent=Sn),Qt.forEach(t),Ns=a(e),re=r(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-ybukjk"&&(re.innerHTML=xn),Zs=a(e),ie=r(e,"OL",{"data-svelte-h":!0}),i(ie)!=="svelte-m4uc4o"&&(ie.innerHTML=Bn),_s=a(e),pe=r(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-19vk3ts"&&(pe.innerHTML=kn),Ys=a(e),ue=r(e,"TABLE",{"data-svelte-h":!0}),i(ue)!=="svelte-1gqxr00"&&(ue.innerHTML=En),Qs=a(e),de=r(e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-1gihkbk"&&(de.innerHTML=Cn),Ls=a(e),d(ce.$$.fragment,e),As=a(e),me=r(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-1ycfnts"&&(me.innerHTML=qn),zs=a(e),d(Me.$$.fragment,e),Xs=a(e),he=r(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-dbzevp"&&(he.innerHTML=Gn),Ps=a(e),d(ye.$$.fragment,e),Os=a(e),Te=r(e,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-1lwymx8"&&(Te.textContent=Rn),Ds=a(e),d(Ue.$$.fragment,e),Ks=a(e),Je=r(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-99semi"&&(Je.innerHTML=Vn),et=a(e),d(we.$$.fragment,e),st=a(e),je=r(e,"P",{"data-svelte-h":!0}),i(je)!=="svelte-1e3nkoe"&&(je.textContent=$n),tt=a(e),d(be.$$.fragment,e),nt=a(e),ge=r(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-dbzevp"&&(ge.innerHTML=Fn),lt=a(e),d(ve.$$.fragment,e),at=a(e),fe=r(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-1vlpheo"&&(fe.innerHTML=Wn),ot=a(e),d(Ie.$$.fragment,e),rt=a(e),Se=r(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-dbzevp"&&(Se.innerHTML=Hn),it=a(e),d(xe.$$.fragment,e),pt=a(e),Be=r(e,"P",{"data-svelte-h":!0}),i(Be)!=="svelte-1kcg18j"&&(Be.innerHTML=Nn),ut=a(e),d(ke.$$.fragment,e),dt=a(e),Ee=r(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-dbzevp"&&(Ee.innerHTML=Zn),ct=a(e),d(Ce.$$.fragment,e),mt=a(e),qe=r(e,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-1yhnauy"&&(qe.innerHTML=_n),Mt=a(e),S=r(e,"H2",{class:!0});var Lt=w(S);q=r(Lt,"A",{id:!0,class:!0,href:!0});var Ml=w(q);ds=r(Ml,"SPAN",{});var hl=w(ds);d(Ge.$$.fragment,hl),hl.forEach(t),Ml.forEach(t),Kt=a(Lt),es=r(Lt,"SPAN",{"data-svelte-h":!0}),i(es)!=="svelte-hw7a7i"&&(es.textContent=Yn),Lt.forEach(t),ht=a(e),Re=r(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-vcnxm4"&&(Re.textContent=Qn),yt=a(e),d(Ve.$$.fragment,e),Tt=a(e),$e=r(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-dbzevp"&&($e.innerHTML=Ln),Ut=a(e),d(Fe.$$.fragment,e),Jt=a(e),We=r(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1y5e1ug"&&(We.textContent=An),wt=a(e),He=r(e,"OL",{"data-svelte-h":!0}),i(He)!=="svelte-1qi514d"&&(He.innerHTML=zn),jt=a(e),G=r(e,"DIV",{class:!0,"data-svelte-h":!0}),i(G)!=="svelte-dbmn5s"&&(G.innerHTML=Xn),bt=a(e),y=r(e,"P",{});var J=w(y);en=b(J,"L’avantage de segmenter les échantillons est que nous n’avons pas besoin du résultat du bloc "),gt=Xt(J,!1),vt=b(J," pour transcrire le morceau suivant "),ft=Xt(J,!1),It=b(J,". La couture est effectuée après que nous ayons transcrit tous les morceaux aux bornes des morceaux. Donc peu importe l’ordre dans lequel nous transcrivons les morceaux. L’algorithme est entièrement "),ss=r(J,"STRONG",{"data-svelte-h":!0}),i(ss)!=="svelte-1kau282"&&(ss.textContent=Pn),sn=b(J,", donc nous pouvons même faire du découpage sur "),St=Xt(J,!1),xt=b(J," en même temps que du découpage sur "),Bt=Xt(J,!1),kt=b(J," ! Cela nous permet de former des "),ts=r(J,"EM",{"data-svelte-h":!0}),i(ts)!=="svelte-1swb9sm"&&(ts.textContent=On),tn=b(J," de morceaux et de les exécuter dans le modèle en parallèle, offrant une grande accélération de calcul par rapport à leur transcription séquentielle. Pour en savoir plus sur la segmentation d’audio dans 🤗 "),ns=r(J,"EM",{"data-svelte-h":!0}),i(ns)!=="svelte-1c497z6"&&(ns.textContent=Dn),nn=b(J,", vous pouvez vous référer à cet [article de blog] ("),R=r(J,"A",{href:!0,rel:!0,"data-svelte-h":!0}),i(R)!=="svelte-wh64se"&&(R.textContent=Kn),ln=b(J,`) (en anglais).
Pour activer les longues transcriptions, nous devons ajouter un argument supplémentaire lorsque nous appelons le pipeline. Cet argument, `),ls=r(J,"CODE",{"data-svelte-h":!0}),i(ls)!=="svelte-1ihfftk"&&(ls.textContent=el),an=b(J,`, contrôle la longueur des segments divisés en secondes. Pour Whisper, des morceaux de 30 secondes sont optimaux, car cela correspond à la longueur d’entrée attendue par Whisper.
Pour activer le traitement par batch, nous devons passer l’argument `),as=r(J,"CODE",{"data-svelte-h":!0}),i(as)!=="svelte-1grlmso"&&(as.textContent=sl),on=b(J," au pipeline. En mettant tout cela ensemble, nous pouvons transcrire le long échantillon audio comme suit:"),J.forEach(t),Et=a(e),d(Ne.$$.fragment,e),Ct=a(e),Ze=r(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-dbzevp"&&(Ze.innerHTML=tl),qt=a(e),d(_e.$$.fragment,e),Gt=a(e),Ye=r(e,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-zgfrlv"&&(Ye.innerHTML=nl),Rt=a(e),d(Qe.$$.fragment,e),Vt=a(e),Le=r(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-dbzevp"&&(Le.innerHTML=ll),$t=a(e),d(Ae.$$.fragment,e),Ft=a(e),ze=r(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-1q3v7dp"&&(ze.textContent=al),Wt=a(e),x=r(e,"H2",{class:!0});var At=w(x);V=r(At,"A",{id:!0,class:!0,href:!0});var yl=w(V);cs=r(yl,"SPAN",{});var Tl=w(cs);d(Xe.$$.fragment,Tl),Tl.forEach(t),yl.forEach(t),rn=a(At),os=r(At,"SPAN",{"data-svelte-h":!0}),i(os)!=="svelte-5v3jkk"&&(os.textContent=ol),At.forEach(t),Ht=a(e),Pe=r(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-2z7mlq"&&(Pe.innerHTML=rl),Nt=a(e),ms=r(e,"P",{}),w(ms).forEach(t),this.h()},h(){T(g,"name","hf:doc:metadata"),T(g,"content",JSON.stringify(Bl)),T(B,"id","modles-prentrans-pour-la-reconnaissance-automatique-de-la-parole"),T(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(B,"href","#modles-prentrans-pour-la-reconnaissance-automatique-de-la-parole"),T(v,"class","relative group"),T(k,"id","sonder-les-modles-ctc"),T(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(k,"href","#sonder-les-modles-ctc"),T(f,"class","relative group"),T(E,"class","flex justify-center"),T(C,"id","passage-seq2seq"),T(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(C,"href","#passage-seq2seq"),T(I,"class","relative group"),T(q,"id","longue-transcription-et-horodatage"),T(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(q,"href","#longue-transcription-et-horodatage"),T(S,"class","relative group"),T(G,"class","flex justify-center"),gt.a=vt,ft.a=It,St.a=xt,Bt.a=kt,T(R,"href","https://huggingface.co/blog/asr-chunking"),T(R,"rel","nofollow"),T(V,"id","rsum"),T(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(V,"href","#rsum"),T(x,"class","relative group")},m(e,s){p(document.head,g),n(e,hs,s),n(e,rs,s),n(e,ys,s),n(e,v,s),p(v,B),p(B,is),c($,is,null),p(v,Pt),p(v,Oe),n(e,Ts,s),n(e,F,s),n(e,Us,s),n(e,W,s),n(e,Js,s),n(e,H,s),n(e,ws,s),n(e,N,s),n(e,js,s),n(e,f,s),p(f,k),p(k,ps),c(Z,ps,null),p(f,Ot),p(f,De),n(e,bs,s),n(e,_,s),n(e,gs,s),c(Y,e,s),n(e,vs,s),n(e,Q,s),n(e,fs,s),c(L,e,s),n(e,Is,s),n(e,A,s),n(e,Ss,s),c(z,e,s),n(e,xs,s),n(e,X,s),n(e,Bs,s),c(P,e,s),n(e,ks,s),n(e,O,s),n(e,Es,s),c(D,e,s),n(e,Cs,s),n(e,K,s),n(e,qs,s),c(ee,e,s),n(e,Gs,s),n(e,se,s),n(e,Rs,s),c(te,e,s),n(e,Vs,s),n(e,ne,s),n(e,$s,s),n(e,le,s),n(e,Fs,s),n(e,E,s),n(e,Ws,s),n(e,ae,s),n(e,Hs,s),n(e,I,s),p(I,C),p(C,us),c(oe,us,null),p(I,Dt),p(I,Ke),n(e,Ns,s),n(e,re,s),n(e,Zs,s),n(e,ie,s),n(e,_s,s),n(e,pe,s),n(e,Ys,s),n(e,ue,s),n(e,Qs,s),n(e,de,s),n(e,Ls,s),c(ce,e,s),n(e,As,s),n(e,me,s),n(e,zs,s),c(Me,e,s),n(e,Xs,s),n(e,he,s),n(e,Ps,s),c(ye,e,s),n(e,Os,s),n(e,Te,s),n(e,Ds,s),c(Ue,e,s),n(e,Ks,s),n(e,Je,s),n(e,et,s),c(we,e,s),n(e,st,s),n(e,je,s),n(e,tt,s),c(be,e,s),n(e,nt,s),n(e,ge,s),n(e,lt,s),c(ve,e,s),n(e,at,s),n(e,fe,s),n(e,ot,s),c(Ie,e,s),n(e,rt,s),n(e,Se,s),n(e,it,s),c(xe,e,s),n(e,pt,s),n(e,Be,s),n(e,ut,s),c(ke,e,s),n(e,dt,s),n(e,Ee,s),n(e,ct,s),c(Ce,e,s),n(e,mt,s),n(e,qe,s),n(e,Mt,s),n(e,S,s),p(S,q),p(q,ds),c(Ge,ds,null),p(S,Kt),p(S,es),n(e,ht,s),n(e,Re,s),n(e,yt,s),c(Ve,e,s),n(e,Tt,s),n(e,$e,s),n(e,Ut,s),c(Fe,e,s),n(e,Jt,s),n(e,We,s),n(e,wt,s),n(e,He,s),n(e,jt,s),n(e,G,s),n(e,bt,s),n(e,y,s),p(y,en),gt.m(Ul,y),p(y,vt),ft.m(Jl,y),p(y,It),p(y,ss),p(y,sn),St.m(wl,y),p(y,xt),Bt.m(jl,y),p(y,kt),p(y,ts),p(y,tn),p(y,ns),p(y,nn),p(y,R),p(y,ln),p(y,ls),p(y,an),p(y,as),p(y,on),n(e,Et,s),c(Ne,e,s),n(e,Ct,s),n(e,Ze,s),n(e,qt,s),c(_e,e,s),n(e,Gt,s),n(e,Ye,s),n(e,Rt,s),c(Qe,e,s),n(e,Vt,s),n(e,Le,s),n(e,$t,s),c(Ae,e,s),n(e,Ft,s),n(e,ze,s),n(e,Wt,s),n(e,x,s),p(x,V),p(V,cs),c(Xe,cs,null),p(x,rn),p(x,os),n(e,Ht,s),n(e,Pe,s),n(e,Nt,s),n(e,ms,s),Zt=!0},p:gl,i(e){Zt||(m($.$$.fragment,e),m(Z.$$.fragment,e),m(Y.$$.fragment,e),m(L.$$.fragment,e),m(z.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(Ue.$$.fragment,e),m(we.$$.fragment,e),m(be.$$.fragment,e),m(ve.$$.fragment,e),m(Ie.$$.fragment,e),m(xe.$$.fragment,e),m(ke.$$.fragment,e),m(Ce.$$.fragment,e),m(Ge.$$.fragment,e),m(Ve.$$.fragment,e),m(Fe.$$.fragment,e),m(Ne.$$.fragment,e),m(_e.$$.fragment,e),m(Qe.$$.fragment,e),m(Ae.$$.fragment,e),m(Xe.$$.fragment,e),Zt=!0)},o(e){M($.$$.fragment,e),M(Z.$$.fragment,e),M(Y.$$.fragment,e),M(L.$$.fragment,e),M(z.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(Me.$$.fragment,e),M(ye.$$.fragment,e),M(Ue.$$.fragment,e),M(we.$$.fragment,e),M(be.$$.fragment,e),M(ve.$$.fragment,e),M(Ie.$$.fragment,e),M(xe.$$.fragment,e),M(ke.$$.fragment,e),M(Ce.$$.fragment,e),M(Ge.$$.fragment,e),M(Ve.$$.fragment,e),M(Fe.$$.fragment,e),M(Ne.$$.fragment,e),M(_e.$$.fragment,e),M(Qe.$$.fragment,e),M(Ae.$$.fragment,e),M(Xe.$$.fragment,e),Zt=!1},d(e){e&&(t(hs),t(rs),t(ys),t(v),t(Ts),t(F),t(Us),t(W),t(Js),t(H),t(ws),t(N),t(js),t(f),t(bs),t(_),t(gs),t(vs),t(Q),t(fs),t(Is),t(A),t(Ss),t(xs),t(X),t(Bs),t(ks),t(O),t(Es),t(Cs),t(K),t(qs),t(Gs),t(se),t(Rs),t(Vs),t(ne),t($s),t(le),t(Fs),t(E),t(Ws),t(ae),t(Hs),t(I),t(Ns),t(re),t(Zs),t(ie),t(_s),t(pe),t(Ys),t(ue),t(Qs),t(de),t(Ls),t(As),t(me),t(zs),t(Xs),t(he),t(Ps),t(Os),t(Te),t(Ds),t(Ks),t(Je),t(et),t(st),t(je),t(tt),t(nt),t(ge),t(lt),t(at),t(fe),t(ot),t(rt),t(Se),t(it),t(pt),t(Be),t(ut),t(dt),t(Ee),t(ct),t(mt),t(qe),t(Mt),t(S),t(ht),t(Re),t(yt),t(Tt),t($e),t(Ut),t(Jt),t(We),t(wt),t(He),t(jt),t(G),t(bt),t(y),t(Et),t(Ct),t(Ze),t(qt),t(Gt),t(Ye),t(Rt),t(Vt),t(Le),t($t),t(Ft),t(ze),t(Wt),t(x),t(Ht),t(Pe),t(Nt),t(ms)),t(g),h($),h(Z),h(Y,e),h(L,e),h(z,e),h(P,e),h(D,e),h(ee,e),h(te,e),h(oe),h(ce,e),h(Me,e),h(ye,e),h(Ue,e),h(we,e),h(be,e),h(ve,e),h(Ie,e),h(xe,e),h(ke,e),h(Ce,e),h(Ge),h(Ve,e),h(Fe,e),h(Ne,e),h(_e,e),h(Qe,e),h(Ae,e),h(Xe)}}}const Bl={local:"modles-prentrans-pour-la-reconnaissance-automatique-de-la-parole",sections:[{local:"sonder-les-modles-ctc",title:"Sonder les modèles CTC"},{local:"passage-seq2seq",title:"Passage à Seq2Seq"},{local:"longue-transcription-et-horodatage",title:"Longue transcription et horodatage"},{local:"rsum",title:"Résumé"}],title:"Modèles pré-entraînés pour la reconnaissance automatique de la parole"};function kl(pn){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends fl{constructor(g){super(),Il(this,g,kl,xl,bl,{})}}export{Rl as component};
