import{s as ri,o as ii}from"../chunks/scheduler.f7e1785c.js";import{S as oi,i as ui,g as r,s as n,u as c,A as pi,h as i,f as t,c as a,j as J,v as d,y as o,k as u,o as p,a as l,w as m,d as M,t as h,x as y,m as ni,n as ai}from"../chunks/index.815a732f.js";import{T as li}from"../chunks/Tip.1258ac78.js";import{I as j}from"../chunks/IconCopyLink.e7937f56.js";import{C as v}from"../chunks/CodeBlock.c6e8b464.js";function ci(Ot){let T;return{c(){T=ni('Vous pouvez changer l\'identifiant de langue de `"dv"` pour un identifiant de langue de votre choix. Pour voir toutes les langues possibles dans Common Voice 13, consultez la carte du jeu de données sur le *Hub* : https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},l(f){T=ai(f,'Vous pouvez changer l\'identifiant de langue de `"dv"` pour un identifiant de langue de votre choix. Pour voir toutes les langues possibles dans Common Voice 13, consultez la carte du jeu de données sur le *Hub* : https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},m(f,U){l(f,T,U)},d(f){f&&t(T)}}}function di(Ot){let T;return{c(){T=ni("Si vous ne voulez pas télécharger les *checkpoints* du modèle vers le *Hub*, mettez `push_to_hub=False`.")},l(f){T=ai(f,"Si vous ne voulez pas télécharger les *checkpoints* du modèle vers le *Hub*, mettez `push_to_hub=False`.")},m(f,U){l(f,T,U)},d(f){f&&t(T)}}}function mi(Ot){let T,f,U,_s,w,B,ms,D,Sn,es,aa="Comment finetuner un système de reconnaissance automatique de la parole avec l'API Trainer",xs,K,ra="Dans cette section, nous allons couvrir un guide étape par étape pour <em>finetuner</em> Whisper pour la reconnaissance automatique de la parole sur le jeu de données Common Voice 13. Nous utiliserons la version ”<em>small</em>” du modèle et un jeu de données relativement léger, vous permettant d’exécuter le <em>finetuning</em> assez rapidement sur n’importe quel GPU de plus de 16 Go avec de faibles besoins en espace disque, comme le GPU T4 de 16 Go fourni dans le volet gratuit de Google Colab.",Zs,O,ia="Si vous disposez d’un GPU plus petit ou si vous rencontrez des problèmes de mémoire pendant l’entraînement, vous pouvez suivre les suggestions fournies pour réduire l’utilisation de la mémoire. À l’inverse, si vous avez accès à un GPU plus puissant, vous pouvez modifier les arguments d’entraînement pour maximiser votre capacité de traitement. Ce guide est donc accessible quelles que soient les spécifications de votre GPU !",Ws,ee,oa=`De même, ce guide porte plus précisément sur le <em>finetuning</em> sur la langue Dhivehi mais les étapes couvertes ici se généralisent à n’importe quelle langue du jeu de données Common Voice, et plus généralement à n’importe quel jeu de données d’ASR disponible sur le <em>Hub</em>.
Vous pouvez modifier le code pour passer rapidement à la langue de votre choix et <em>finetuner</em> un modèle Whisper dans votre langue maternelle 🌍.`,ks,te,ua="Commençons et donnons le coup d’envoi de notre pipeline de <em>finetuning</em> !",qs,b,X,Ms,se,Yn,ts,pa="Préparer l'environnement",$s,le,ca=`Nous vous conseillons vivement de télécharger les <em>checkpoints</em> du modèle directement sur le <a href="https://huggingface.co/" rel="nofollow"><em>Hub</em></a>.
Le <em>Hub</em> offre les avantages suivants :`,Gs,ne,da="<li>Un contrôle de version intégré : vous pouvez être sûr qu’aucun <em>checkpoint</em> n’est perdu pendant l’entraînement.</li> <li>Tensorboard : suivi des mesures importantes au cours de l’entraînement.</li> <li>Cartes de modèle : documenter ce que fait un modèle et ses cas d’utilisation prévus.</li> <li>Communauté : un moyen facile de partager et de collaborer avec la communauté ! 🤗</li>",Bs,ae,ma=`Lier le <em>notebook</em> au <em>Hub</em> est très simple, il suffit d’entrer votre <em>token</em> d’authentification au <em>Hub</em> lorsque l’on vous y invite.
Votre <em>token</em> d’authentification est trouvable <a href="https://huggingface.co/settings/tokens" rel="nofollow">ici</a>.`,Xs,re,zs,ie,Ma="<strong>Sortie :</strong>",Ns,oe,As,g,z,hs,ue,Fn,ss,ha="Charger le jeu de données",Vs,pe,ya='<a href="https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0" rel="nofollow">Common Voice 13</a> contient environ dix heures de données Dhivehi étiquetées, dont trois sont des données de test. Il s’agit de très peu de données pour un <em>finetuning</em>, nous nous appuierons donc sur la connaissance multilingue acquise par Whisper pendant le pré-entraînement.',Es,ce,Ja="En utilisant les 🤗 <em>Datasets</em>, le téléchargement et la préparation des données sont extrêmement simples. Nous pouvons télécharger et préparer les ensembles de Common Voice 13 en une seule ligne de code. Puisque le Dhivehi est très pauvre en ressources, nous combinerons les splits <code>train</code> et <code>validation</code> pour obtenir environ sept heures de données d’entraînement. Nous utiliserons les trois heures de données <code>test</code> comme notre ensemble de test :",Hs,de,Rs,me,va="<strong>Sortie :</strong>",Qs,Me,Ss,N,Ys,he,Ta=`La plupart des jeux de données d’ASR ne fournissent que des échantillons audio en entrée (<code>audio</code>) et le texte transcrit correspondant (<code>sentence</code>).
Common Voice contient des métadonnées supplémentaires, telles que <code>accent</code> et <code>locale</code>, que nous pouvons ignorer pour l’ASR.
En gardant le <em>notebook</em> aussi général que possible, nous ne considérons que l’audio d’entrée et le texte transcrit en écartant les informations de métadonnées supplémentaires :`,Fs,ye,Ls,C,A,ys,Je,Ln,ls,fa="Extracteur de caractéristiques, tokeniser et processeur",Ps,ve,ja="Le pipeline d’ASR peut être décomposé en trois étapes :",Ds,Te,Ua="<li>L’extracteur de caractéristiques qui pré-traite les entrées audio brutes en spectrogrammes log-mél.</li> <li>Le modèle qui effectue l’association séquence-séquence</li> <li>Le tokenizer qui post-traite les <em>tokens</em> prédits en texte.</li>",Ks,fe,wa=`Dans 🤗 <em>Transformers</em>, le modèle Whisper est associé à un extracteur de caractéristiques et à un tokenizer, appelés respectivement <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperFeatureExtractor" rel="nofollow">WhisperFeatureExtractor</a> et <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperTokenizer" rel="nofollow">WhisperTokenizer</a>.
Pour nous simplifier la vie, ces deux objets sont regroupés dans une seule classe, appelée <a href="https://huggingface.co/docs/transformers/model_doc/whisper#transformers.WhisperProcessor" rel="nofollow">WhisperProcessor</a>.
Nous pouvons appeler le WhisperProcessor pour effectuer à la fois le prétraitement audio et le post-traitement des <em>tokens</em> de texte. Ce faisant, nous n’avons besoin de suivre que deux objets pendant l’entraîningment : le processeur et le modèle.`,Os,je,ba=`Lors d’un <em>finetuné</em> multilingue, nous devons définir la <code>&quot;language&quot;</code> et la <code>&quot;task&quot;</code> lors de l’instanciation du processeur.
La <code>&quot;language&quot;</code> doit être fixée à la langue audio source, et la tâche à <code>&quot;translate&quot;</code> pour la reconnaissance vocale ou à <code>&quot;translate&quot;</code> pour la traduction vocale. Ces arguments modifient le comportement du <em>tokens</em>, et doivent être définis correctement pour s’assurer que les étiquettes cibles sont encodées correctement.`,el,Ue,ga="Nous pouvons voir toutes les langues possibles supportées par Whisper en important la liste des langues :",tl,we,sl,be,Ca=`Si vous parcourez cette liste, vous remarquerez que de nombreuses langues sont présentes, mais que le dhivehi est l’une des rares à ne pas l’être !
Cela signifie que Whisper n’a pas été pré-entraîné sur le dhivehi. Cependant, cela ne signifie pas que nous ne pouvons pas <em>finetuner</em> Whisper sur cette langue.
En faisant cela, nous allons entraîner Whisper dans une nouvelle langue, une langue non supportée par le <em>checkpoint</em> pré-entraîné. C’est plutôt cool, non ?`,ll,ge,Ia="Lorsque vous le <em>finetunez</em> sur une nouvelle langue, Whisper fait un bon travail en tirant parti de sa connaissance des 96 autres langues sur lesquelles il a été pré-entraîné. En général, toutes les langues modernes seront linguistiquement similaires à au moins l’une des 96 langues que Whisper connaît déjà, nous nous inscrivons donc dans ce paradigme de représentation des connaissances interlinguistiques.",nl,Ce,_a=`Ce que nous devons faire pour cette nouvelle langue, est de trouver la langue <strong>la plus similaire</strong> sur laquelle Whisper a été pré-entraîné. L’article de Wikipédia sur le dhivehi indique que cette langue est étroitement liée à la langue cinghalaise du Sri Lanka.
Si nous vérifions à nouveau les codes de langue, nous pouvons voir que le cinghalais est présent dans le jeu de langues de Whisper, nous pouvons donc en toute sécurité mettre notre argument de langue à <code>&quot;sinhalese&quot;</code>.`,al,Ie,xa="Nous allons charger notre processeur à partir du <em>checkpoint</em> pré-entraîné, en fixant la langue à <code>&quot;sinhalese&quot;</code> et la tâche à <code>&quot;transcribe&quot;</code> comme expliqué ci-dessus :",rl,_e,il,xe,Za="Il est utile de rappeler que dans la plupart des cas, vous constaterez que la langue sur laquelle vous souhaitez effectuer un <em>finetuning</em> se trouve dans l’ensemble des langues de pré-entraînement, auquel cas vous pouvez simplement définir cette langue directement comme langue audio source ! Notez que ces deux arguments doivent être omis pour le <em>finetuning</em> en anglais où il n’y a qu’une seule option pour la langue (<code>&quot;English&quot;</code>) et la tâche (<code>&quot;transcribe&quot;</code>).",ol,I,V,Js,Ze,Pn,ns,Wa="Prétraitement des données",ul,We,ka="Jetons un coup d’oeil aux caractéristiques du jeu de données. Portez une attention particulière à la colonne <code>&quot;audio&quot;</code>, elle détaille le taux d’échantillonnage de nos entrées audio :",pl,ke,cl,qe,qa="<strong>Sortie :</strong>",dl,$e,ml,Ge,$a="Puisque notre audio d’entrée est échantillonné à 48kHz, nous devons le sous-échantillonner à 16kHz avant de le passer à l’extracteur de caractéristiques de Whisper qui est la fréquence d’échantillonnage attendue par le modèle.",Ml,Be,Ga='Nous allons régler les entrées audio à la bonne fréquence d’échantillonnage en utilisant la méthode <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.cast_column" rel="nofollow"><code>cast_column</code></a> du jeu de données. Cette opération ne modifie pas l’audio sur place, mais signale aux jeux de données de rééchantillonner les échantillons audio à la volée lorsqu’ils sont chargés :',hl,Xe,yl,ze,Ba="Nous pouvons maintenant écrire une fonction pour préparer nos données pour le modèle :",Jl,Ne,Xa="<li>Nous chargeons et rééchantillonnons les données audio échantillon par échantillon en appelant <code>sample[&quot;audio&quot;]</code>. Comme expliqué ci-dessus, 🤗 <em>Datasets</em> effectue toutes les opérations de rééchantillonnage nécessaires à la volée.</li> <li>Nous utilisons l’extracteur de caractéristiques pour calculer les caractéristiques d’entrée du spectrogramme log-mel à partir de notre tableau audio unidimensionnel.</li> <li>Nous encodons les transcriptions en identifiants d’étiquettes à l’aide d’un <em>tokenizer</em>.</li>",vl,Ae,Tl,Ve,za="Nous pouvons appliquer la fonction de préparation des données à tous nos exemples d’entraînement en utilisant la méthode <code>.map</code> de 🤗 <em>Datasets</em>. Nous allons supprimer les colonnes des données d’entraînement brutes (l’audio et le texte), en ne laissant que les colonnes renvoyées par la fonction <code>prepare_dataset</code> :",fl,Ee,jl,He,Na="Enfin, nous filtrons toutes les données d’entraînement contenant des échantillons audio de plus de 30 secondes. Ces échantillons seraient sinon tronqués par l’extracteur de caractéristiques de Whisper, ce qui pourrait affecter la stabilité de l’entraînement. Nous définissons une fonction qui renvoie <code>True</code> pour les échantillons de moins de 30 secondes, et <code>False</code> pour ceux qui sont plus longs :",Ul,Re,wl,Qe,Aa="Nous appliquons notre fonction de filtrage à tous les échantillons de notre jeu de données d’entraînement par le biais de la méthode <code>.filter</code> de 🤗 <em>Datasets</em> :",bl,Se,gl,Ye,Va="Vérifions la quantité de données d’entraînement que nous avons supprimée grâce à cette étape de filtrage :",Cl,Fe,Il,Le,Ea="<strong>Sortie :</strong>",_l,Pe,xl,De,Ha=`Dans ce cas, nous avons en fait le même nombre d’échantillons que précédemment, donc il n’y a pas d’échantillons de plus de 30s.
Cela pourrait ne pas être le cas si vous changez de langue, il est donc préférable de garder cette étape de filtrage en place pour plus de robustesse. Nos données sont maintenant prêtes à être entraînées ! Continuons et regardons comment nous pouvons utiliser ces données pour le <em>finetuning</em>.`,Zl,_,E,vs,Ke,Dn,as,Ra="Entraînement et évaluation",Wl,Oe,Qa=`Maintenant que nous avons préparé nos données, nous sommes prêts à plonger dans le pipeline d’entraînement.
<a href="https://huggingface.co/transformers/master/main_classes/trainer.html?highlight=trainer" rel="nofollow">Trainer</a>
va faire le gros du travail à notre place. Tout ce que nous avons à faire est de :`,kl,et,Sa="<li><p>Définir un assembleur de données qui prend nos données prétraitées et prépare des tenseurs PyTorch adaptés au modèle.</p></li> <li><p>Métriques d’évaluation : lors de l’évaluation, nous voulons évaluer le modèle en utilisant la métrique du taux d’erreur au niveau du mot (WER). Nous devons définir une fonction <code>compute_metrics</code> qui gère ce calcul.</p></li> <li><p>Charger un <em>checkpoint</em> pré-entraîné et le configurer correctement pour l’entraînement.</p></li> <li><p>Définir les arguments d’entraînement : ils seront utilisés par le Trainer pour construire le plannificateur d’entraînement.</p></li>",ql,tt,Ya="Une fois le modèle <em>finetuné</em>, nous l’évaluerons sur les données de test pour vérifier que nous l’avons correctement entraîné à transcrire la parole en Dhivehi.",$l,x,H,Ts,st,Kn,rs,Fa="Définir un assembleur de données",Gl,lt,La="L’assembleur de données pour un modèle audio séquence-à-séquence est unique dans le sens où il traite les <code>input_features</code> et les <code>labels</code> indépendamment : les <code>input_features</code> doivent être traitées par l’extracteur de caractéristiques et les <code>labels</code> par le tokenizer.",Bl,nt,Pa="Les <code>input_features</code> sont déjà rembourrées à 30s et converties en un spectrogramme log-Mel de dimension fixe, donc tout ce que nous avons à faire est de les convertir en tenseurs PyTorch batchés. Nous le faisons en utilisant la méthode <code>.pad</code> de l’extracteur de caractéristiques avec <code>return_tensors=pt</code>. Notez qu’aucun rembourrage supplémentaire n’est appliqué ici puisque les entrées sont de dimension fixe, les <code>input_features</code> sont simplement converties en tenseurs PyTorch.",Xl,at,Da="D’un autre côté, les <code>labels</code> ne sont pas rembourrés. Les séquences sont d’abord remplacées par la longueur maximale du batch à l’aide de la méthode <code>.pad</code> du <em>tokenizer</em>. Les <em>tokens</em> de remplissage sont ensuite remplacés par <code>-100</code> de sorte que ces tokens ne sont <strong>pas</strong> pris en compte lors du calcul de la perte. Nous coupons ensuite le début du <em>token</em> de transcription du début de la séquence d’étiquettes comme nous l’ajouterons plus tard pendant l’entraînement.",zl,rt,Ka="Nous pouvons utiliser le <code>WhisperProcessor</code> que nous avons défini plus tôt pour effectuer à la fois les opérations de l’extracteur de caractéristiques et du <em>tokenizer</em> :",Nl,it,Al,ot,Oa="Nous pouvons maintenant initialiser l’assembleur de données que nous venons de définir :",Vl,ut,El,pt,er="En avant !",Hl,Z,R,fs,ct,On,is,tr="Métriques d'évaluation",Rl,dt,sr='Ensuite, nous définissons la métrique d’évaluation que nous utiliserons sur notre ensemble d’évaluation. Nous utiliserons le taux d’erreur au niveaud du mot (WER) introduit dans la section <a href="%C3%A9valuation">évaluation</a>, la métrique “de-facto” pour évaluer les systèmes d’ASR.',Ql,mt,lr="Nous chargerons la métrique WER à partir d’ 🤗 <em>Evaluate</em> :",Sl,Mt,Yl,ht,nr="Il suffit ensuite de définir une fonction qui prend les prédictions de notre modèle et renvoie la métrique WER. Cette fonction, appelée <code>compute_metrics</code>, remplace d’abord <code>-100</code> par le <code>pad_token_id</code> dans <code>label_ids</code> (annulant l’étape que nous avons appliquée dans l’assembleur de données pour ignorer correctement les <em>tokens</em> rembourrés dans la perte). Il décode ensuite les identifiants prédits et les identifiants d’étiquettes en chaînes de caractères. Enfin, il calcule le WER entre les prédictions et les étiquettes de référence. Ici, nous avons la possibilité d’évaluer les transcriptions et les prédictions “normalisées”, dont la ponctuation et la casse ont été supprimées. Nous vous recommandons de procéder ainsi pour bénéficier de l’amélioration du WER obtenue par la normalisation des transcriptions.",Fl,yt,Ll,W,Q,js,Jt,ea,os,ar="Charger un *checkpoint* pré-entraîné",Pl,vt,rr="Chargeons maintenant le <em>checkpoint</em> pré-entraîné de Whisper small. Encore une fois, ceci est trivial grâce à l’utilisation de 🤗 <em>Transformers</em> !",Dl,Tt,Kl,ft,ir='Nous allons mettre <code>use_cache</code> à <code>False</code> pour l’entraînement puisque nous utilisons [<em>gradient checkpointing</em>] (<a href="https://huggingface.co/docs/transformers/v4.18.0/en/performance#gradient-checkpointing" rel="nofollow">https://huggingface.co/docs/transformers/v4.18.0/en/performance#gradient-checkpointing</a>) et que les deux sont incompatibles. Nous allons aussi surcharger deux arguments de génération pour contrôler le comportement du modèle pendant l’inférence : nous allons forcer la langue et les <em>tokens</em> de tâche pendant la génération en définissant les arguments <code>language</code> et <code>task</code>, et aussi réactiver le cache pour la génération afin d’accélérer le temps d’inférence :',Ol,jt,en,k,S,Us,Ut,ta,us,or="Définir la configuration de l'entraînement",tn,wt,ur=`Dans la dernière étape, nous définissons tous les paramètres liés à l’entraînement. Ici, nous fixons le nombre d’étapes d’entraînement à 500.
Cela représente suffisamment d’étapes pour voir une grande amélioration du WER par rapport au modèle pré-entraîné, tout en s’assurant que le <em>finetuning</em> peut être exécuté en environ 45 minutes sur un niveau gratuit de Google Colab. Pour plus de détails sur les arguments d’entraînement, reportez-vous à la documentation de [Seq2SeqTrainingArguments] (<a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments" rel="nofollow">https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments</a>).`,sn,bt,ln,Y,nn,gt,pr="Nous pouvons transmettre les arguments d’entraînement au <em>Trainer</em> avec notre modèle, notre jeu de données, notre assembleur de données et la fonction <code>compute_metrics</code> :",an,Ct,rn,It,cr="Et voilà, nous sommes prêts à entraîner !",on,q,F,ws,_t,sa,ps,dr="Entraînement",un,xt,mr="Pour lancer l’entraînement, il suffit d’exécuter :",pn,Zt,cn,Wt,Mr='L’entraînement prendra environ 45 minutes en fonction de votre GPU ou de celui alloué par Google Colab. En fonction de votre GPU, il est possible que vous rencontriez une erreur CUDA <code>&quot;out-of-memory&quot;</code> lorsque vous commencez à entraîner. Dans ce cas, vous pouvez réduire le <code>per_device_train_batch_size</code> par incréments d’un facteur 2 et utiliser <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments.gradient_accumulation_steps" rel="nofollow"><code>gradient_accumulation_steps</code></a> pour compenser.',dn,kt,hr="<strong>Sortie :</strong>",mn,qt,yr='<thead><tr><th align="center">Training Loss</th> <th align="center">Epoch</th> <th align="center">Step</th> <th align="center">Validation Loss</th> <th align="center">Wer Ortho</th> <th align="center">Wer</th></tr></thead> <tbody><tr><td align="center">0.136</td> <td align="center">1.63</td> <td align="center">500</td> <td align="center">0.1727</td> <td align="center">63.8972</td> <td align="center">14.0661</td></tr></tbody>',Mn,$t,Jr="Notre WER final est de 14,1 % ce qui n’est pas mal pour sept heures de données d’entraînement et seulement 500 étapes d’entraînement ! Cela représente une amélioration de 112 % par rapport au modèle pré-entraîné ! Cela signifie que nous avons pris un modèle qui n’avait aucune connaissance du dhivehi et que nous l’avons <em>finetuné</em> pour reconnaître l’dhivehi avec une précision adéquate en moins d’une heure 🤯.",hn,Gt,vr='La grande question est de savoir comment cela se compare à d’autres systèmes ASR. Pour cela, nous pouvons consulter le [classement autoevaluate] (<a href="https://huggingface.co/spaces/autoevaluate/leaderboards?dataset=mozilla-foundation%2Fcommon_voice_13_0&amp;only_verified=0&amp;task=automatic-speech-recognition&amp;config=dv&amp;split=test&amp;metric=wer" rel="nofollow">https://huggingface.co/spaces/autoevaluate/leaderboards?dataset=mozilla-foundation%2Fcommon_voice_13_0&amp;only_verified=0&amp;task=automatic-speech-recognition&amp;config=dv&amp;split=test&amp;metric=wer</a>) qui catégorise les modèles par langue et par jeu de données, et les classe ensuite en fonction de leur WER.',yn,Bt,Tr='En regardant le classement, nous voyons que notre modèle entraîné pour 500 étapes bat de manière convaincante le <em>checkpoint</em> <a href="https://huggingface.co/openai/whisper-small" rel="nofollow">Whisper Small</a> pré-entraîné que nous avons évalué dans la section précédente. Bon travail 👏',Jn,Xt,fr=`Nous voyons qu’il y a quelques <em>checkpoints</em> qui font mieux que celui que nous avons entraîné. La beauté du <em>Hub</em> est qu’il s’agit d’une plateforme <em>collaborative</em>. Si nous n’avons pas le temps ou les ressources pour effectuer un entraînement plus long nous-mêmes, nous pouvons charger un <em>checkpoint</em> que quelqu’un d’autre dans la communauté a entraîné et a eu la gentillesse de partager (en s’assurant de le remercier pour cela !).
Vous pourrez charger ces <em>checkpoints</em> exactement de la même manière que les pré-entraînés en utilisant la classe <code>pipeline</code> comme nous l’avons fait précédemment ! Ainsi, rien ne vous empêche de sélectionner le meilleur modèle du leaderboard pour l’utiliser dans le cadre de votre tâche !`,vn,zt,jr="Nous pouvons automatiquement soumettre notre <em>checkpoint</em> au classement lorsque nous envoyons les résultats de l’entraînement au <em>Hub</em>. Nous devons simplement définir les arguments de mot-clé appropriés (kwargs). Vous pouvez modifier ces valeurs pour qu’elles correspondent à votre jeu de données, à votre langue et au nom de votre modèle en conséquence :",Tn,Nt,fn,At,Ur="Les résultats de l’entraînement peuvent maintenant être téléchargés vers le <em>Hub</em>. Pour ce faire, exécutez la commande <code>push_to_hub</code> :",jn,Vt,Un,Et,wr="Ceci sauvegardera les logs d’entraînement et les poids des modèles sous <code>&quot;votre-nom-d&#39;utilisateur/le-nom-que-vous-avez-choisi&quot;</code>. Pour cet exemple, regardez le téléchargement à <code>sanchit-gandhi/whisper-small-dv</code>.",wn,Ht,br=`Bien que le modèle <em>finetuné</em> donne des résultats satisfaisants sur les données de test de Common Voice 13, il n’est en aucun cas optimal.
Le but de ce guide est de démontrer comment <em>finetuner</em> un modèle ASR en utilisant le <em>Trainer</em> pour la reconnaissance automatique de la parole multilingue.`,bn,Rt,gr="Si vous avez accès à votre propre GPU ou si vous êtes abonné à un plan payant de Google Colab, vous pouvez augmenter <code>max_pas</code> à 4000 pas pour améliorer davantage le WER en entraînant plus de pas. Entraîner 4000 pas prendra environ 3 à 5 heures en fonction de votre GPU et donnera des résultats WER inférieurs d’environ 3 % à l’entraînement de 500 pas. Si vous décidez d’entraîner sur 4000 pas, nous vous recommandons également de changer le planificateur de taux d’apprentissage pour un plan <em>linéaire</em> (set <code>lr_scheduler_type=&quot;linear&quot;</code>), car cela permettra d’augmenter les performances sur de longues périodes d’entraînement.",gn,Qt,Cr="Les résultats pourraient probablement être améliorés en optimisant les hyperparamètres d’entraînement, tels que <em>learning rate</em> et <em>dropout</em>, et en utilisant un <em>checkpoint</em> pré-entraîné plus grand (<code>medium</code> ou <code>large</code>). Nous laissons cet exercice au lecteur.",Cn,$,L,bs,St,la,cs,Ir="Partager votre modèle",In,Yt,_r='Vous pouvez maintenant partager ce modèle avec n’importe qui en utilisant le lien sur le <em>Hub</em>. Ils peuvent le charger avec l’identifiant <code>&quot;votre-nom-d&#39;utilisateur/le-nom-que-vous-avez-choisi&quot;</code> directement dans l’objet <code>pipeline()</code>. Par exemple, pour charger le <em>checkpoint</em> <em>finetuné</em> <a href="https://huggingface.co/sanchit-gandhi/whisper-small-dv" rel="nofollow">“sanchit-gandhi/whisper-small-dv”</a> :',_n,Ft,xn,G,P,gs,Lt,na,ds,xr="Conclusion",Zn,Pt,Zr="Dans cette section, nous avons couvert un guide étape par étape sur le <em>finetuning</em> du modèle Whisper pour la reconnaissance vocale en utilisants 🤗 <em>Jeux de données</em>, 🤗 <em>Transformers</em> et le <em>Hub</em>. Nous avons d’abord chargé le sous-ensemble Dhivehi du jeu de données Common Voice 13 et l’avons prétraité en calculant des spectrogrammes log-mel et en tokenisant le texte. Nous avons ensuite défini un assembleur de données, une métrique d’évaluation et des arguments d’entraînement, avant d’utiliser le <em>Trainer</em> pour entraîner et évaluer notre modèle. Nous avons terminé en téléchargeant le modèle <em>finetuné</em> sur le <em>Hub</em>, et nous avons montré comment le partager et l’utiliser avec la classe <code>pipeline()</code>.",Wn,Dt,Wr=`Si vous avez suivi jusqu’à ce point, vous devriez maintenant avoir un <em>checkpoint</em> <em>finetuné</em> pour la reconnaissance automatique de la parole, bien joué ! 🥳
Plus important encore, vous êtes équipé de tous les outils nécessaires pour <em>finetuner</em> le modèle Whisper sur n’importe quel jeu de données ou domaine de reconnaissance vocale. Alors, qu’attendez-vous ? Choisissez l’un des jeux de données couverts dans la section <a href="choosing_dataset">Choisir un jeu de données</a> ou sélectionnez un jeu de données de votre choix, et voyez si vous pouvez obtenir des performances de pointe ! Le classement vous attend…`,kn,Cs,qn;return D=new j({}),se=new j({}),re=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),oe=new v({props:{code:"TG9naW4lMjBzdWNjZXNzZnVsJTBBWW91ciUyMHRva2VuJTIwaGFzJTIwYmVlbiUyMHNhdmVkJTIwdG8lMjAlMkZyb290JTJGLmh1Z2dpbmdmYWNlJTJGdG9rZW4=",highlighted:`Login successful
Your token has been saved to /root/.huggingface/token`}}),ue=new j({}),de=new v({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwRGF0YXNldERpY3QlMEElMEFjb21tb25fdm9pY2UlMjAlM0QlMjBEYXRhc2V0RGljdCgpJTBBJTBBY29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ2YWxpZGF0aW9uJTIyJTBBKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMiUwQSklMEElMEFwcmludChjb21tb25fdm9pY2Up",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, DatasetDict

common_voice = DatasetDict()

common_voice[<span class="hljs-string">&quot;train&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;train+validation&quot;</span>
)
common_voice[<span class="hljs-string">&quot;test&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>
)

<span class="hljs-built_in">print</span>(common_voice)`}}),Me=new v({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2NsaWVudF9pZCclMkMlMjAncGF0aCclMkMlMjAnYXVkaW8nJTJDJTIwJ3NlbnRlbmNlJyUyQyUyMCd1cF92b3RlcyclMkMlMjAnZG93bl92b3RlcyclMkMlMjAnYWdlJyUyQyUyMCdnZW5kZXInJTJDJTIwJ2FjY2VudCclMkMlMjAnbG9jYWxlJyUyQyUyMCdzZWdtZW50JyUyQyUyMCd2YXJpYW50JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNDkwNCUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidjbGllbnRfaWQnJTJDJTIwJ3BhdGgnJTJDJTIwJ2F1ZGlvJyUyQyUyMCdzZW50ZW5jZSclMkMlMjAndXBfdm90ZXMnJTJDJTIwJ2Rvd25fdm90ZXMnJTJDJTIwJ2FnZSclMkMlMjAnZ2VuZGVyJyUyQyUyMCdhY2NlbnQnJTJDJTIwJ2xvY2FsZSclMkMlMjAnc2VnbWVudCclMkMlMjAndmFyaWFudCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDIyMTIlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTdEKQ==",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">4904</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">2212</span>
    })
})`}}),N=new li({props:{$$slots:{default:[ci]},$$scope:{ctx:Ot}}}),ye=new v({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLnNlbGVjdF9jb2x1bW5zKCU1QiUyMmF1ZGlvJTIyJTJDJTIwJTIyc2VudGVuY2UlMjIlNUQp",highlighted:'common_voice = common_voice.select_columns([<span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;sentence&quot;</span>])'}}),Je=new j({}),we=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMud2hpc3Blci50b2tlbml6YXRpb25fd2hpc3BlciUyMGltcG9ydCUyMFRPX0xBTkdVQUdFX0NPREUlMEElMEFUT19MQU5HVUFHRV9DT0RF",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.tokenization_whisper <span class="hljs-keyword">import</span> TO_LANGUAGE_CODE

TO_LANGUAGE_CODE`}}),_e=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBXaGlzcGVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTIwbGFuZ3VhZ2UlM0QlMjJzaW5oYWxlc2UlMjIlMkMlMjB0YXNrJTNEJTIydHJhbnNjcmliZSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperProcessor

processor = WhisperProcessor.from_pretrained(
    <span class="hljs-string">&quot;openai/whisper-small&quot;</span>, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>
)`}}),Ze=new j({}),ke=new v({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQuZmVhdHVyZXM=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>].features'}}),$e=new v({props:{code:"JTdCJ2F1ZGlvJyUzQSUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0Q0ODAwMCUyQyUyMG1vbm8lM0RUcnVlJTJDJTIwZGVjb2RlJTNEVHJ1ZSUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnc2VudGVuY2UnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklN0Q=",highlighted:`{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(<span class="hljs-attribute">sampling_rate</span>=48000, <span class="hljs-attribute">mono</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">decode</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">id</span>=None),
 <span class="hljs-string">&#x27;sentence&#x27;</span>: Value(<span class="hljs-attribute">dtype</span>=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-attribute">id</span>=None)}`}}),Xe=new v({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMEFjb21tb25fdm9pY2UlMjAlM0QlMjBjb21tb25fdm9pY2UuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

sampling_rate = processor.feature_extractor.sampling_rate
common_voice = common_voice.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=sampling_rate))`}}),Ae=new v({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTNEZXhhbXBsZSU1QiUyMnNlbnRlbmNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBpbnB1dCUyMGxlbmd0aCUyMG9mJTIwYXVkaW8lMjBzYW1wbGUlMjBpbiUyMHNlY29uZHMlMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW5wdXRfbGVuZ3RoJTIyJTVEJTIwJTNEJTIwbGVuKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTIwYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        audio=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        text=example[<span class="hljs-string">&quot;sentence&quot;</span>],
    )

    <span class="hljs-comment"># compute input length of audio sample in seconds</span>
    example[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(audio[<span class="hljs-string">&quot;array&quot;</span>]) / audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>]

    <span class="hljs-keyword">return</span> example`}}),Ee=new v({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLm1hcCglMEElMjAlMjAlMjAlMjBwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRGNvbW1vbl92b2ljZS5jb2x1bW5fbmFtZXMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMG51bV9wcm9jJTNEMSUwQSk=",highlighted:`common_voice = common_voice.<span class="hljs-built_in">map</span>(
    prepare_dataset, remove_columns=common_voice.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">1</span>
)`}}),Re=new v({props:{code:"bWF4X2lucHV0X2xlbmd0aCUyMCUzRCUyMDMwLjAlMEElMEElMEFkZWYlMjBpc19hdWRpb19pbl9sZW5ndGhfcmFuZ2UobGVuZ3RoKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxlbmd0aCUyMCUzQyUyMG1heF9pbnB1dF9sZW5ndGg=",highlighted:`max_input_length = <span class="hljs-number">30.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_in_length_range</span>(<span class="hljs-params">length</span>):
    <span class="hljs-keyword">return</span> length &lt; max_input_length`}}),Se=new v({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RC5maWx0ZXIoJTBBJTIwJTIwJTIwJTIwaXNfYXVkaW9faW5fbGVuZ3RoX3JhbmdlJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmlucHV0X2xlbmd0aCUyMiU1RCUyQyUwQSk=",highlighted:`common_voice[<span class="hljs-string">&quot;train&quot;</span>] = common_voice[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">filter</span>(
    is_audio_in_length_range,
    input_columns=[<span class="hljs-string">&quot;input_length&quot;</span>],
)`}}),Fe=new v({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>]'}}),Pe=new v({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidpbnB1dF9mZWF0dXJlcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdpbnB1dF9sZW5ndGgnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA0OTA0JTBBJTdEKQ==",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;input_features&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;input_length&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">4904</span>
})`}}),Ke=new j({}),st=new j({}),it=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorSpeechSeq2SeqWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-comment"># diviser les entrées et les étiquettes car elles doivent être de longueurs différentes et nécessitent des méthodes de remplissage différentes</span>
        <span class="hljs-comment"># traiter d&#x27;abord les entrées audio en renvoyant simplement des tenseurs Torch</span>
        input_features = [
            {<span class="hljs-string">&quot;input_features&quot;</span>: feature[<span class="hljs-string">&quot;input_features&quot;</span>][<span class="hljs-number">0</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features
        ]
        batch = self.processor.feature_extractor.pad(input_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># obtenir les séquences d&#x27;étiquettes tokenisées</span>
        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        <span class="hljs-comment"># rembourrer les étiquettes à la longueur maximale</span>
        labels_batch = self.processor.tokenizer.pad(label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># remplacer le remplissage par -100 pour ignorer correctement les pertes</span>
        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(
            labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># si le token bos est ajouté lors de l&#x27;étape de tokenisation précédente, couper le token bos ici puisqu&#x27;il sera de toute façon ajouté plus tard</span>
        <span class="hljs-keyword">if</span> (labels[:, <span class="hljs-number">0</span>] == self.processor.tokenizer.bos_token_id).<span class="hljs-built_in">all</span>().cpu().item():
            labels = labels[:, <span class="hljs-number">1</span>:]

        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

        <span class="hljs-keyword">return</span> batch`}}),ut=new v({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvclNwZWVjaFNlcTJTZXFXaXRoUGFkZGluZyhwcm9jZXNzb3IlM0Rwcm9jZXNzb3Ip",highlighted:"data_collator = DataCollatorSpeechSeq2SeqWithPadding(processor=processor)"}}),ct=new j({}),Mt=new v({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`}}),yt=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.english_normalizer <span class="hljs-keyword">import</span> BasicTextNormalizer

normalizer = BasicTextNormalizer()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">pred</span>):
    pred_ids = pred.predictions
    label_ids = pred.label_ids

    <span class="hljs-comment"># remplacer -100 par pad_token_id</span>
    label_ids[label_ids == -<span class="hljs-number">100</span>] = processor.tokenizer.pad_token_id

    <span class="hljs-comment"># nous ne voulons pas grouper les *tokens* lors du calcul des métriques</span>
    pred_str = processor.batch_decode(pred_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
    label_str = processor.batch_decode(label_ids, skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># calculer le Wer orthographique</span>
    wer_ortho = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str, references=label_str)

    <span class="hljs-comment"># calculer le WER normalisé</span>
    pred_str_norm = [normalizer(pred) <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> pred_str]
    label_str_norm = [normalizer(label) <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> label_str]
    <span class="hljs-comment"># afin de n&#x27;évaluer que les échantillons correspondant à des références non nulles</span>
    pred_str_norm = [
        pred_str_norm[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(pred_str_norm)) <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]
    label_str_norm = [
        label_str_norm[i]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(label_str_norm))
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]

    wer = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str_norm, references=label_str_norm)

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer_ortho&quot;</span>: wer_ortho, <span class="hljs-string">&quot;wer&quot;</span>: wer}`}}),Jt=new j({}),Tt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperForConditionalGeneration

model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`}}),jt=new v({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkJUMzJUE5c2FjdGl2ZXIlMjBsZSUyMGNhY2hlJTIwcGVuZGFudCUyMGwnZW50cmElQzMlQUVuZW1lbnQlMjBjYXIlMjBpbCUyMGVzdCUyMGluY29tcGF0aWJsZSUyMGF2ZWMlMjBsZSUyMGNoZWNrcG9pbnRpbmclMjBkdSUyMGdyYWRpZW50JTBBbW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNlJTBBJTBBJTIzJTIwZCVDMyVBOWZpbmlyJTIwbGElMjBsYW5ndWUlMjBldCUyMGxhJTIwdCVDMyVBMmNoZSUyMHBvdXIlMjBsYSUyMGclQzMlQTluJUMzJUE5cmF0aW9uJTIwZXQlMjByJUMzJUE5YWN0aXZlciUyMGxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwoJTBBJTIwJTIwJTIwJTIwbW9kZWwuZ2VuZXJhdGUlMkMlMjBsYW5ndWFnZSUzRCUyMnNpbmhhbGVzZSUyMiUyQyUyMHRhc2slM0QlMjJ0cmFuc2NyaWJlJTIyJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># désactiver le cache pendant l&#x27;entraînement car il est incompatible avec le checkpointing du gradient</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># définir la langue et la tâche pour la génération et réactiver le cache</span>
model.generate = partial(
    model.generate, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>, use_cache=<span class="hljs-literal">True</span>
)`}}),Ut=new j({}),bt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMi4lMkZ3aGlzcGVyLXNtYWxsLWR2JTIyJTJDJTIwJTIwJTIzJTIwbm9tJTIwc3VyJTIwbGUlMjBIdWIlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDElMkMlMjAlMjAlMjMlMjAlQzMlQTAlMjB4MiUyMCUyMHBvdXIlMjBjaGFxdWUlMjBkaW1pbnV0aW9uJTIwZGUlMjAyeCUyMGRlJTIwbGElMjB0YWlsbGUlMjBkdSUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXJfdHlwZSUzRCUyMmNvbnN0YW50X3dpdGhfd2FybXVwJTIyJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q1MDAlMkMlMjAlMjAlMjMlMjBhdWdtZW50ZXIlMjBqdXNxdSclQzMlQTAlMjA0MDAwJTIwc2klMjB2b3VzJTIwZGlzcG9zZXolMjBkZSUyMHZvdHJlJTIwcHJvcHJlJTIwR1BVJTIwb3UlMjBkJ3VuJTIwcGxhbiUyMENvbGFiJTIwcGF5YW50JTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZwMTZfZnVsbF9ldmFsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBwcmVkaWN0X3dpdGhfZ2VuZXJhdGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9tYXhfbGVuZ3RoJTNEMjI1JTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdGVwcyUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljX2Zvcl9iZXN0X21vZGVsJTNEJTIyd2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;./whisper-small-dv&quot;</span>,  <span class="hljs-comment"># nom sur le Hub</span>
    per_device_train_batch_size=<span class="hljs-number">16</span>,
    gradient_accumulation_steps=<span class="hljs-number">1</span>,  <span class="hljs-comment"># à x2  pour chaque diminution de 2x de la taille du batch</span>
    learning_rate=<span class="hljs-number">1e-5</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;constant_with_warmup&quot;</span>,
    warmup_steps=<span class="hljs-number">50</span>,
    max_steps=<span class="hljs-number">500</span>,  <span class="hljs-comment"># augmenter jusqu&#x27;à 4000 si vous disposez de votre propre GPU ou d&#x27;un plan Colab payant</span>
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    fp16_full_eval=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">16</span>,
    predict_with_generate=<span class="hljs-literal">True</span>,
    generation_max_length=<span class="hljs-number">225</span>,
    save_steps=<span class="hljs-number">500</span>,
    eval_steps=<span class="hljs-number">500</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;wer&quot;</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
)`}}),Y=new li({props:{$$slots:{default:[di]},$$scope:{ctx:Ot}}}),Ct=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=common_voice[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=common_voice[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    compute_metrics=compute_metrics,
    tokenizer=processor,
)`}}),_t=new j({}),Zt=new v({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()"}}),Nt=new v({props:{code:"a3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZGF0YXNldF90YWdzJTIyJTNBJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkYXRhc2V0JTIyJTNBJTIwJTIyQ29tbW9uJTIwVm9pY2UlMjAxMyUyMiUyQyUyMCUyMCUyMyUyMGElMjAncHJldHR5JyUyMG5hbWUlMjBmb3IlMjB0aGUlMjB0cmFpbmluZyUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjAlMjJsYW5ndWFnZSUyMiUzQSUyMCUyMmR2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMldoaXNwZXIlMjBTbWFsbCUyMER2JTIwLSUyMFNhbmNoaXQlMjBHYW5kaGklMjIlMkMlMjAlMjAlMjMlMjBhJTIwJ3ByZXR0eSclMjBuYW1lJTIwZm9yJTIweW91ciUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwJTIyZmluZXR1bmVkX2Zyb20lMjIlM0ElMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFza3MlMjIlM0ElMjAlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTBBJTdE",highlighted:`kwargs = {
    <span class="hljs-string">&quot;dataset_tags&quot;</span>: <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>,
    <span class="hljs-string">&quot;dataset&quot;</span>: <span class="hljs-string">&quot;Common Voice 13&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for the training dataset</span>
    <span class="hljs-string">&quot;language&quot;</span>: <span class="hljs-string">&quot;dv&quot;</span>,
    <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;Whisper Small Dv - Sanchit Gandhi&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for your model</span>
    <span class="hljs-string">&quot;finetuned_from&quot;</span>: <span class="hljs-string">&quot;openai/whisper-small&quot;</span>,
    <span class="hljs-string">&quot;tasks&quot;</span>: <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
}`}}),Vt=new v({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1YigqKmt3YXJncyk=",highlighted:"trainer.push_to_hub(**kwargs)"}}),St=new j({}),Ft=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNhbmNoaXQtZ2FuZGhpJTJGd2hpc3Blci1zbWFsbC1kdiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-small-dv&quot;</span>)`}}),Lt=new j({}),{c(){T=r("meta"),f=n(),U=r("p"),_s=n(),w=r("h1"),B=r("a"),ms=r("span"),c(D.$$.fragment),Sn=n(),es=r("span"),es.textContent=aa,xs=n(),K=r("p"),K.innerHTML=ra,Zs=n(),O=r("p"),O.textContent=ia,Ws=n(),ee=r("p"),ee.innerHTML=oa,ks=n(),te=r("p"),te.innerHTML=ua,qs=n(),b=r("h2"),X=r("a"),Ms=r("span"),c(se.$$.fragment),Yn=n(),ts=r("span"),ts.textContent=pa,$s=n(),le=r("p"),le.innerHTML=ca,Gs=n(),ne=r("ul"),ne.innerHTML=da,Bs=n(),ae=r("p"),ae.innerHTML=ma,Xs=n(),c(re.$$.fragment),zs=n(),ie=r("p"),ie.innerHTML=Ma,Ns=n(),c(oe.$$.fragment),As=n(),g=r("h2"),z=r("a"),hs=r("span"),c(ue.$$.fragment),Fn=n(),ss=r("span"),ss.textContent=ha,Vs=n(),pe=r("p"),pe.innerHTML=ya,Es=n(),ce=r("p"),ce.innerHTML=Ja,Hs=n(),c(de.$$.fragment),Rs=n(),me=r("p"),me.innerHTML=va,Qs=n(),c(Me.$$.fragment),Ss=n(),c(N.$$.fragment),Ys=n(),he=r("p"),he.innerHTML=Ta,Fs=n(),c(ye.$$.fragment),Ls=n(),C=r("h2"),A=r("a"),ys=r("span"),c(Je.$$.fragment),Ln=n(),ls=r("span"),ls.textContent=fa,Ps=n(),ve=r("p"),ve.textContent=ja,Ds=n(),Te=r("ol"),Te.innerHTML=Ua,Ks=n(),fe=r("p"),fe.innerHTML=wa,Os=n(),je=r("p"),je.innerHTML=ba,el=n(),Ue=r("p"),Ue.textContent=ga,tl=n(),c(we.$$.fragment),sl=n(),be=r("p"),be.innerHTML=Ca,ll=n(),ge=r("p"),ge.innerHTML=Ia,nl=n(),Ce=r("p"),Ce.innerHTML=_a,al=n(),Ie=r("p"),Ie.innerHTML=xa,rl=n(),c(_e.$$.fragment),il=n(),xe=r("p"),xe.innerHTML=Za,ol=n(),I=r("h2"),V=r("a"),Js=r("span"),c(Ze.$$.fragment),Pn=n(),ns=r("span"),ns.textContent=Wa,ul=n(),We=r("p"),We.innerHTML=ka,pl=n(),c(ke.$$.fragment),cl=n(),qe=r("p"),qe.innerHTML=qa,dl=n(),c($e.$$.fragment),ml=n(),Ge=r("p"),Ge.textContent=$a,Ml=n(),Be=r("p"),Be.innerHTML=Ga,hl=n(),c(Xe.$$.fragment),yl=n(),ze=r("p"),ze.textContent=Ba,Jl=n(),Ne=r("ol"),Ne.innerHTML=Xa,vl=n(),c(Ae.$$.fragment),Tl=n(),Ve=r("p"),Ve.innerHTML=za,fl=n(),c(Ee.$$.fragment),jl=n(),He=r("p"),He.innerHTML=Na,Ul=n(),c(Re.$$.fragment),wl=n(),Qe=r("p"),Qe.innerHTML=Aa,bl=n(),c(Se.$$.fragment),gl=n(),Ye=r("p"),Ye.textContent=Va,Cl=n(),c(Fe.$$.fragment),Il=n(),Le=r("p"),Le.innerHTML=Ea,_l=n(),c(Pe.$$.fragment),xl=n(),De=r("p"),De.innerHTML=Ha,Zl=n(),_=r("h2"),E=r("a"),vs=r("span"),c(Ke.$$.fragment),Dn=n(),as=r("span"),as.textContent=Ra,Wl=n(),Oe=r("p"),Oe.innerHTML=Qa,kl=n(),et=r("ul"),et.innerHTML=Sa,ql=n(),tt=r("p"),tt.innerHTML=Ya,$l=n(),x=r("h3"),H=r("a"),Ts=r("span"),c(st.$$.fragment),Kn=n(),rs=r("span"),rs.textContent=Fa,Gl=n(),lt=r("p"),lt.innerHTML=La,Bl=n(),nt=r("p"),nt.innerHTML=Pa,Xl=n(),at=r("p"),at.innerHTML=Da,zl=n(),rt=r("p"),rt.innerHTML=Ka,Nl=n(),c(it.$$.fragment),Al=n(),ot=r("p"),ot.textContent=Oa,Vl=n(),c(ut.$$.fragment),El=n(),pt=r("p"),pt.textContent=er,Hl=n(),Z=r("h3"),R=r("a"),fs=r("span"),c(ct.$$.fragment),On=n(),is=r("span"),is.textContent=tr,Rl=n(),dt=r("p"),dt.innerHTML=sr,Ql=n(),mt=r("p"),mt.innerHTML=lr,Sl=n(),c(Mt.$$.fragment),Yl=n(),ht=r("p"),ht.innerHTML=nr,Fl=n(),c(yt.$$.fragment),Ll=n(),W=r("h3"),Q=r("a"),js=r("span"),c(Jt.$$.fragment),ea=n(),os=r("span"),os.textContent=ar,Pl=n(),vt=r("p"),vt.innerHTML=rr,Dl=n(),c(Tt.$$.fragment),Kl=n(),ft=r("p"),ft.innerHTML=ir,Ol=n(),c(jt.$$.fragment),en=n(),k=r("h2"),S=r("a"),Us=r("span"),c(Ut.$$.fragment),ta=n(),us=r("span"),us.textContent=or,tn=n(),wt=r("p"),wt.innerHTML=ur,sn=n(),c(bt.$$.fragment),ln=n(),c(Y.$$.fragment),nn=n(),gt=r("p"),gt.innerHTML=pr,an=n(),c(Ct.$$.fragment),rn=n(),It=r("p"),It.textContent=cr,on=n(),q=r("h4"),F=r("a"),ws=r("span"),c(_t.$$.fragment),sa=n(),ps=r("span"),ps.textContent=dr,un=n(),xt=r("p"),xt.textContent=mr,pn=n(),c(Zt.$$.fragment),cn=n(),Wt=r("p"),Wt.innerHTML=Mr,dn=n(),kt=r("p"),kt.innerHTML=hr,mn=n(),qt=r("table"),qt.innerHTML=yr,Mn=n(),$t=r("p"),$t.innerHTML=Jr,hn=n(),Gt=r("p"),Gt.innerHTML=vr,yn=n(),Bt=r("p"),Bt.innerHTML=Tr,Jn=n(),Xt=r("p"),Xt.innerHTML=fr,vn=n(),zt=r("p"),zt.innerHTML=jr,Tn=n(),c(Nt.$$.fragment),fn=n(),At=r("p"),At.innerHTML=Ur,jn=n(),c(Vt.$$.fragment),Un=n(),Et=r("p"),Et.innerHTML=wr,wn=n(),Ht=r("p"),Ht.innerHTML=br,bn=n(),Rt=r("p"),Rt.innerHTML=gr,gn=n(),Qt=r("p"),Qt.innerHTML=Cr,Cn=n(),$=r("h2"),L=r("a"),bs=r("span"),c(St.$$.fragment),la=n(),cs=r("span"),cs.textContent=Ir,In=n(),Yt=r("p"),Yt.innerHTML=_r,_n=n(),c(Ft.$$.fragment),xn=n(),G=r("h2"),P=r("a"),gs=r("span"),c(Lt.$$.fragment),na=n(),ds=r("span"),ds.textContent=xr,Zn=n(),Pt=r("p"),Pt.innerHTML=Zr,Wn=n(),Dt=r("p"),Dt.innerHTML=Wr,kn=n(),Cs=r("p"),this.h()},l(e){const s=pi("svelte-1phssyn",document.head);T=i(s,"META",{name:!0,content:!0}),s.forEach(t),f=a(e),U=i(e,"P",{}),J(U).forEach(t),_s=a(e),w=i(e,"H1",{class:!0});var Kt=J(w);B=i(Kt,"A",{id:!0,class:!0,href:!0});var Is=J(B);ms=i(Is,"SPAN",{});var kr=J(ms);d(D.$$.fragment,kr),kr.forEach(t),Is.forEach(t),Sn=a(Kt),es=i(Kt,"SPAN",{"data-svelte-h":!0}),o(es)!=="svelte-zj8em4"&&(es.textContent=aa),Kt.forEach(t),xs=a(e),K=i(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-7xhodp"&&(K.innerHTML=ra),Zs=a(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-4imhws"&&(O.textContent=ia),Ws=a(e),ee=i(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-311mw7"&&(ee.innerHTML=oa),ks=a(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-2difxl"&&(te.innerHTML=ua),qs=a(e),b=i(e,"H2",{class:!0});var $n=J(b);X=i($n,"A",{id:!0,class:!0,href:!0});var qr=J(X);Ms=i(qr,"SPAN",{});var $r=J(Ms);d(se.$$.fragment,$r),$r.forEach(t),qr.forEach(t),Yn=a($n),ts=i($n,"SPAN",{"data-svelte-h":!0}),o(ts)!=="svelte-1imbzgh"&&(ts.textContent=pa),$n.forEach(t),$s=a(e),le=i(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1utckd2"&&(le.innerHTML=ca),Gs=a(e),ne=i(e,"UL",{"data-svelte-h":!0}),o(ne)!=="svelte-1j0por"&&(ne.innerHTML=da),Bs=a(e),ae=i(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-x9ppr7"&&(ae.innerHTML=ma),Xs=a(e),d(re.$$.fragment,e),zs=a(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-dbzevp"&&(ie.innerHTML=Ma),Ns=a(e),d(oe.$$.fragment,e),As=a(e),g=i(e,"H2",{class:!0});var Gn=J(g);z=i(Gn,"A",{id:!0,class:!0,href:!0});var Gr=J(z);hs=i(Gr,"SPAN",{});var Br=J(hs);d(ue.$$.fragment,Br),Br.forEach(t),Gr.forEach(t),Fn=a(Gn),ss=i(Gn,"SPAN",{"data-svelte-h":!0}),o(ss)!=="svelte-ly8yyv"&&(ss.textContent=ha),Gn.forEach(t),Vs=a(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-71vyw5"&&(pe.innerHTML=ya),Es=a(e),ce=i(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-12unh11"&&(ce.innerHTML=Ja),Hs=a(e),d(de.$$.fragment,e),Rs=a(e),me=i(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-dbzevp"&&(me.innerHTML=va),Qs=a(e),d(Me.$$.fragment,e),Ss=a(e),d(N.$$.fragment,e),Ys=a(e),he=i(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-ybamg3"&&(he.innerHTML=Ta),Fs=a(e),d(ye.$$.fragment,e),Ls=a(e),C=i(e,"H2",{class:!0});var Bn=J(C);A=i(Bn,"A",{id:!0,class:!0,href:!0});var Xr=J(A);ys=i(Xr,"SPAN",{});var zr=J(ys);d(Je.$$.fragment,zr),zr.forEach(t),Xr.forEach(t),Ln=a(Bn),ls=i(Bn,"SPAN",{"data-svelte-h":!0}),o(ls)!=="svelte-k5m12v"&&(ls.textContent=fa),Bn.forEach(t),Ps=a(e),ve=i(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-qk6exq"&&(ve.textContent=ja),Ds=a(e),Te=i(e,"OL",{"data-svelte-h":!0}),o(Te)!=="svelte-1yr2wae"&&(Te.innerHTML=Ua),Ks=a(e),fe=i(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-coa99w"&&(fe.innerHTML=wa),Os=a(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-p9miuc"&&(je.innerHTML=ba),el=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-101xqap"&&(Ue.textContent=ga),tl=a(e),d(we.$$.fragment,e),sl=a(e),be=i(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-mv87b3"&&(be.innerHTML=Ca),ll=a(e),ge=i(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-ftdzgz"&&(ge.innerHTML=Ia),nl=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-32kddc"&&(Ce.innerHTML=_a),al=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1bhj23r"&&(Ie.innerHTML=xa),rl=a(e),d(_e.$$.fragment,e),il=a(e),xe=i(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1vetgq4"&&(xe.innerHTML=Za),ol=a(e),I=i(e,"H2",{class:!0});var Xn=J(I);V=i(Xn,"A",{id:!0,class:!0,href:!0});var Nr=J(V);Js=i(Nr,"SPAN",{});var Ar=J(Js);d(Ze.$$.fragment,Ar),Ar.forEach(t),Nr.forEach(t),Pn=a(Xn),ns=i(Xn,"SPAN",{"data-svelte-h":!0}),o(ns)!=="svelte-9ng0cx"&&(ns.textContent=Wa),Xn.forEach(t),ul=a(e),We=i(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1s88cms"&&(We.innerHTML=ka),pl=a(e),d(ke.$$.fragment,e),cl=a(e),qe=i(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-dbzevp"&&(qe.innerHTML=qa),dl=a(e),d($e.$$.fragment,e),ml=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-bhbzlh"&&(Ge.textContent=$a),Ml=a(e),Be=i(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1c9l05"&&(Be.innerHTML=Ga),hl=a(e),d(Xe.$$.fragment,e),yl=a(e),ze=i(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-kma8yf"&&(ze.textContent=Ba),Jl=a(e),Ne=i(e,"OL",{"data-svelte-h":!0}),o(Ne)!=="svelte-l386lk"&&(Ne.innerHTML=Xa),vl=a(e),d(Ae.$$.fragment,e),Tl=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-p7ipd6"&&(Ve.innerHTML=za),fl=a(e),d(Ee.$$.fragment,e),jl=a(e),He=i(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1qc8iml"&&(He.innerHTML=Na),Ul=a(e),d(Re.$$.fragment,e),wl=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-gzokzm"&&(Qe.innerHTML=Aa),bl=a(e),d(Se.$$.fragment,e),gl=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1astr79"&&(Ye.textContent=Va),Cl=a(e),d(Fe.$$.fragment,e),Il=a(e),Le=i(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-dbzevp"&&(Le.innerHTML=Ea),_l=a(e),d(Pe.$$.fragment,e),xl=a(e),De=i(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-p7jukp"&&(De.innerHTML=Ha),Zl=a(e),_=i(e,"H2",{class:!0});var zn=J(_);E=i(zn,"A",{id:!0,class:!0,href:!0});var Vr=J(E);vs=i(Vr,"SPAN",{});var Er=J(vs);d(Ke.$$.fragment,Er),Er.forEach(t),Vr.forEach(t),Dn=a(zn),as=i(zn,"SPAN",{"data-svelte-h":!0}),o(as)!=="svelte-il7sd7"&&(as.textContent=Ra),zn.forEach(t),Wl=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-1mq6oan"&&(Oe.innerHTML=Qa),kl=a(e),et=i(e,"UL",{"data-svelte-h":!0}),o(et)!=="svelte-sqta85"&&(et.innerHTML=Sa),ql=a(e),tt=i(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-2uwoqk"&&(tt.innerHTML=Ya),$l=a(e),x=i(e,"H3",{class:!0});var Nn=J(x);H=i(Nn,"A",{id:!0,class:!0,href:!0});var Hr=J(H);Ts=i(Hr,"SPAN",{});var Rr=J(Ts);d(st.$$.fragment,Rr),Rr.forEach(t),Hr.forEach(t),Kn=a(Nn),rs=i(Nn,"SPAN",{"data-svelte-h":!0}),o(rs)!=="svelte-10pf3m5"&&(rs.textContent=Fa),Nn.forEach(t),Gl=a(e),lt=i(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1k53otr"&&(lt.innerHTML=La),Bl=a(e),nt=i(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-enj5n1"&&(nt.innerHTML=Pa),Xl=a(e),at=i(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1g4czpk"&&(at.innerHTML=Da),zl=a(e),rt=i(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-i0n36t"&&(rt.innerHTML=Ka),Nl=a(e),d(it.$$.fragment,e),Al=a(e),ot=i(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-cc0sp7"&&(ot.textContent=Oa),Vl=a(e),d(ut.$$.fragment,e),El=a(e),pt=i(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-nyz60k"&&(pt.textContent=er),Hl=a(e),Z=i(e,"H3",{class:!0});var An=J(Z);R=i(An,"A",{id:!0,class:!0,href:!0});var Qr=J(R);fs=i(Qr,"SPAN",{});var Sr=J(fs);d(ct.$$.fragment,Sr),Sr.forEach(t),Qr.forEach(t),On=a(An),is=i(An,"SPAN",{"data-svelte-h":!0}),o(is)!=="svelte-nos02t"&&(is.textContent=tr),An.forEach(t),Rl=a(e),dt=i(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-3hsyij"&&(dt.innerHTML=sr),Ql=a(e),mt=i(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-c52gbi"&&(mt.innerHTML=lr),Sl=a(e),d(Mt.$$.fragment,e),Yl=a(e),ht=i(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-1j3exdi"&&(ht.innerHTML=nr),Fl=a(e),d(yt.$$.fragment,e),Ll=a(e),W=i(e,"H3",{class:!0});var Vn=J(W);Q=i(Vn,"A",{id:!0,class:!0,href:!0});var Yr=J(Q);js=i(Yr,"SPAN",{});var Fr=J(js);d(Jt.$$.fragment,Fr),Fr.forEach(t),Yr.forEach(t),ea=a(Vn),os=i(Vn,"SPAN",{"data-svelte-h":!0}),o(os)!=="svelte-1duo5p1"&&(os.textContent=ar),Vn.forEach(t),Pl=a(e),vt=i(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-db0asr"&&(vt.innerHTML=rr),Dl=a(e),d(Tt.$$.fragment,e),Kl=a(e),ft=i(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-17vn05i"&&(ft.innerHTML=ir),Ol=a(e),d(jt.$$.fragment,e),en=a(e),k=i(e,"H2",{class:!0});var En=J(k);S=i(En,"A",{id:!0,class:!0,href:!0});var Lr=J(S);Us=i(Lr,"SPAN",{});var Pr=J(Us);d(Ut.$$.fragment,Pr),Pr.forEach(t),Lr.forEach(t),ta=a(En),us=i(En,"SPAN",{"data-svelte-h":!0}),o(us)!=="svelte-1u7lc8w"&&(us.textContent=or),En.forEach(t),tn=a(e),wt=i(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1gc8mk7"&&(wt.innerHTML=ur),sn=a(e),d(bt.$$.fragment,e),ln=a(e),d(Y.$$.fragment,e),nn=a(e),gt=i(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1hcg6it"&&(gt.innerHTML=pr),an=a(e),d(Ct.$$.fragment,e),rn=a(e),It=i(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-iy6ynd"&&(It.textContent=cr),on=a(e),q=i(e,"H4",{class:!0});var Hn=J(q);F=i(Hn,"A",{id:!0,class:!0,href:!0});var Dr=J(F);ws=i(Dr,"SPAN",{});var Kr=J(ws);d(_t.$$.fragment,Kr),Kr.forEach(t),Dr.forEach(t),sa=a(Hn),ps=i(Hn,"SPAN",{"data-svelte-h":!0}),o(ps)!=="svelte-1v4q1ec"&&(ps.textContent=dr),Hn.forEach(t),un=a(e),xt=i(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-v8wedd"&&(xt.textContent=mr),pn=a(e),d(Zt.$$.fragment,e),cn=a(e),Wt=i(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-igzv0v"&&(Wt.innerHTML=Mr),dn=a(e),kt=i(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-dbzevp"&&(kt.innerHTML=hr),mn=a(e),qt=i(e,"TABLE",{"data-svelte-h":!0}),o(qt)!=="svelte-10vryw9"&&(qt.innerHTML=yr),Mn=a(e),$t=i(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-189evyt"&&($t.innerHTML=Jr),hn=a(e),Gt=i(e,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-c68dny"&&(Gt.innerHTML=vr),yn=a(e),Bt=i(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1i7i3ab"&&(Bt.innerHTML=Tr),Jn=a(e),Xt=i(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-e0goyt"&&(Xt.innerHTML=fr),vn=a(e),zt=i(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-10v9yjn"&&(zt.innerHTML=jr),Tn=a(e),d(Nt.$$.fragment,e),fn=a(e),At=i(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-8qq12z"&&(At.innerHTML=Ur),jn=a(e),d(Vt.$$.fragment,e),Un=a(e),Et=i(e,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-1n05g3i"&&(Et.innerHTML=wr),wn=a(e),Ht=i(e,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-jftxq6"&&(Ht.innerHTML=br),bn=a(e),Rt=i(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-muxy92"&&(Rt.innerHTML=gr),gn=a(e),Qt=i(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-15dfq0u"&&(Qt.innerHTML=Cr),Cn=a(e),$=i(e,"H2",{class:!0});var Rn=J($);L=i(Rn,"A",{id:!0,class:!0,href:!0});var Or=J(L);bs=i(Or,"SPAN",{});var ei=J(bs);d(St.$$.fragment,ei),ei.forEach(t),Or.forEach(t),la=a(Rn),cs=i(Rn,"SPAN",{"data-svelte-h":!0}),o(cs)!=="svelte-18uj7hm"&&(cs.textContent=Ir),Rn.forEach(t),In=a(e),Yt=i(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-1ecvei2"&&(Yt.innerHTML=_r),_n=a(e),d(Ft.$$.fragment,e),xn=a(e),G=i(e,"H2",{class:!0});var Qn=J(G);P=i(Qn,"A",{id:!0,class:!0,href:!0});var ti=J(P);gs=i(ti,"SPAN",{});var si=J(gs);d(Lt.$$.fragment,si),si.forEach(t),ti.forEach(t),na=a(Qn),ds=i(Qn,"SPAN",{"data-svelte-h":!0}),o(ds)!=="svelte-11v4ufk"&&(ds.textContent=xr),Qn.forEach(t),Zn=a(e),Pt=i(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-7weori"&&(Pt.innerHTML=Zr),Wn=a(e),Dt=i(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-1a2cjs"&&(Dt.innerHTML=Wr),kn=a(e),Cs=i(e,"P",{}),J(Cs).forEach(t),this.h()},h(){u(T,"name","hf:doc:metadata"),u(T,"content",JSON.stringify(Mi)),u(B,"id","comment-finetuner-un-systme-de-reconnaissance-automatique-de-la-parole-avec-lapi-trainer"),u(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(B,"href","#comment-finetuner-un-systme-de-reconnaissance-automatique-de-la-parole-avec-lapi-trainer"),u(w,"class","relative group"),u(X,"id","prparer-lenvironnement"),u(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(X,"href","#prparer-lenvironnement"),u(b,"class","relative group"),u(z,"id","charger-le-jeu-de-donnes"),u(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(z,"href","#charger-le-jeu-de-donnes"),u(g,"class","relative group"),u(A,"id","extracteur-de-caractristiques-tokeniser-et-processeur"),u(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(A,"href","#extracteur-de-caractristiques-tokeniser-et-processeur"),u(C,"class","relative group"),u(V,"id","prtraitement-des-donnes"),u(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(V,"href","#prtraitement-des-donnes"),u(I,"class","relative group"),u(E,"id","entranement-et-valuation"),u(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(E,"href","#entranement-et-valuation"),u(_,"class","relative group"),u(H,"id","dfinir-un-assembleur-de-donnes"),u(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(H,"href","#dfinir-un-assembleur-de-donnes"),u(x,"class","relative group"),u(R,"id","mtriques-dvaluation"),u(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(R,"href","#mtriques-dvaluation"),u(Z,"class","relative group"),u(Q,"id","charger-un-checkpoint-prentran"),u(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Q,"href","#charger-un-checkpoint-prentran"),u(W,"class","relative group"),u(S,"id","dfinir-la-configuration-de-lentranement"),u(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(S,"href","#dfinir-la-configuration-de-lentranement"),u(k,"class","relative group"),u(F,"id","entranement"),u(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(F,"href","#entranement"),u(q,"class","relative group"),u(L,"id","partager-votre-modle"),u(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(L,"href","#partager-votre-modle"),u($,"class","relative group"),u(P,"id","conclusion"),u(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(P,"href","#conclusion"),u(G,"class","relative group")},m(e,s){p(document.head,T),l(e,f,s),l(e,U,s),l(e,_s,s),l(e,w,s),p(w,B),p(B,ms),m(D,ms,null),p(w,Sn),p(w,es),l(e,xs,s),l(e,K,s),l(e,Zs,s),l(e,O,s),l(e,Ws,s),l(e,ee,s),l(e,ks,s),l(e,te,s),l(e,qs,s),l(e,b,s),p(b,X),p(X,Ms),m(se,Ms,null),p(b,Yn),p(b,ts),l(e,$s,s),l(e,le,s),l(e,Gs,s),l(e,ne,s),l(e,Bs,s),l(e,ae,s),l(e,Xs,s),m(re,e,s),l(e,zs,s),l(e,ie,s),l(e,Ns,s),m(oe,e,s),l(e,As,s),l(e,g,s),p(g,z),p(z,hs),m(ue,hs,null),p(g,Fn),p(g,ss),l(e,Vs,s),l(e,pe,s),l(e,Es,s),l(e,ce,s),l(e,Hs,s),m(de,e,s),l(e,Rs,s),l(e,me,s),l(e,Qs,s),m(Me,e,s),l(e,Ss,s),m(N,e,s),l(e,Ys,s),l(e,he,s),l(e,Fs,s),m(ye,e,s),l(e,Ls,s),l(e,C,s),p(C,A),p(A,ys),m(Je,ys,null),p(C,Ln),p(C,ls),l(e,Ps,s),l(e,ve,s),l(e,Ds,s),l(e,Te,s),l(e,Ks,s),l(e,fe,s),l(e,Os,s),l(e,je,s),l(e,el,s),l(e,Ue,s),l(e,tl,s),m(we,e,s),l(e,sl,s),l(e,be,s),l(e,ll,s),l(e,ge,s),l(e,nl,s),l(e,Ce,s),l(e,al,s),l(e,Ie,s),l(e,rl,s),m(_e,e,s),l(e,il,s),l(e,xe,s),l(e,ol,s),l(e,I,s),p(I,V),p(V,Js),m(Ze,Js,null),p(I,Pn),p(I,ns),l(e,ul,s),l(e,We,s),l(e,pl,s),m(ke,e,s),l(e,cl,s),l(e,qe,s),l(e,dl,s),m($e,e,s),l(e,ml,s),l(e,Ge,s),l(e,Ml,s),l(e,Be,s),l(e,hl,s),m(Xe,e,s),l(e,yl,s),l(e,ze,s),l(e,Jl,s),l(e,Ne,s),l(e,vl,s),m(Ae,e,s),l(e,Tl,s),l(e,Ve,s),l(e,fl,s),m(Ee,e,s),l(e,jl,s),l(e,He,s),l(e,Ul,s),m(Re,e,s),l(e,wl,s),l(e,Qe,s),l(e,bl,s),m(Se,e,s),l(e,gl,s),l(e,Ye,s),l(e,Cl,s),m(Fe,e,s),l(e,Il,s),l(e,Le,s),l(e,_l,s),m(Pe,e,s),l(e,xl,s),l(e,De,s),l(e,Zl,s),l(e,_,s),p(_,E),p(E,vs),m(Ke,vs,null),p(_,Dn),p(_,as),l(e,Wl,s),l(e,Oe,s),l(e,kl,s),l(e,et,s),l(e,ql,s),l(e,tt,s),l(e,$l,s),l(e,x,s),p(x,H),p(H,Ts),m(st,Ts,null),p(x,Kn),p(x,rs),l(e,Gl,s),l(e,lt,s),l(e,Bl,s),l(e,nt,s),l(e,Xl,s),l(e,at,s),l(e,zl,s),l(e,rt,s),l(e,Nl,s),m(it,e,s),l(e,Al,s),l(e,ot,s),l(e,Vl,s),m(ut,e,s),l(e,El,s),l(e,pt,s),l(e,Hl,s),l(e,Z,s),p(Z,R),p(R,fs),m(ct,fs,null),p(Z,On),p(Z,is),l(e,Rl,s),l(e,dt,s),l(e,Ql,s),l(e,mt,s),l(e,Sl,s),m(Mt,e,s),l(e,Yl,s),l(e,ht,s),l(e,Fl,s),m(yt,e,s),l(e,Ll,s),l(e,W,s),p(W,Q),p(Q,js),m(Jt,js,null),p(W,ea),p(W,os),l(e,Pl,s),l(e,vt,s),l(e,Dl,s),m(Tt,e,s),l(e,Kl,s),l(e,ft,s),l(e,Ol,s),m(jt,e,s),l(e,en,s),l(e,k,s),p(k,S),p(S,Us),m(Ut,Us,null),p(k,ta),p(k,us),l(e,tn,s),l(e,wt,s),l(e,sn,s),m(bt,e,s),l(e,ln,s),m(Y,e,s),l(e,nn,s),l(e,gt,s),l(e,an,s),m(Ct,e,s),l(e,rn,s),l(e,It,s),l(e,on,s),l(e,q,s),p(q,F),p(F,ws),m(_t,ws,null),p(q,sa),p(q,ps),l(e,un,s),l(e,xt,s),l(e,pn,s),m(Zt,e,s),l(e,cn,s),l(e,Wt,s),l(e,dn,s),l(e,kt,s),l(e,mn,s),l(e,qt,s),l(e,Mn,s),l(e,$t,s),l(e,hn,s),l(e,Gt,s),l(e,yn,s),l(e,Bt,s),l(e,Jn,s),l(e,Xt,s),l(e,vn,s),l(e,zt,s),l(e,Tn,s),m(Nt,e,s),l(e,fn,s),l(e,At,s),l(e,jn,s),m(Vt,e,s),l(e,Un,s),l(e,Et,s),l(e,wn,s),l(e,Ht,s),l(e,bn,s),l(e,Rt,s),l(e,gn,s),l(e,Qt,s),l(e,Cn,s),l(e,$,s),p($,L),p(L,bs),m(St,bs,null),p($,la),p($,cs),l(e,In,s),l(e,Yt,s),l(e,_n,s),m(Ft,e,s),l(e,xn,s),l(e,G,s),p(G,P),p(P,gs),m(Lt,gs,null),p(G,na),p(G,ds),l(e,Zn,s),l(e,Pt,s),l(e,Wn,s),l(e,Dt,s),l(e,kn,s),l(e,Cs,s),qn=!0},p(e,[s]){const Kt={};s&2&&(Kt.$$scope={dirty:s,ctx:e}),N.$set(Kt);const Is={};s&2&&(Is.$$scope={dirty:s,ctx:e}),Y.$set(Is)},i(e){qn||(M(D.$$.fragment,e),M(se.$$.fragment,e),M(re.$$.fragment,e),M(oe.$$.fragment,e),M(ue.$$.fragment,e),M(de.$$.fragment,e),M(Me.$$.fragment,e),M(N.$$.fragment,e),M(ye.$$.fragment,e),M(Je.$$.fragment,e),M(we.$$.fragment,e),M(_e.$$.fragment,e),M(Ze.$$.fragment,e),M(ke.$$.fragment,e),M($e.$$.fragment,e),M(Xe.$$.fragment,e),M(Ae.$$.fragment,e),M(Ee.$$.fragment,e),M(Re.$$.fragment,e),M(Se.$$.fragment,e),M(Fe.$$.fragment,e),M(Pe.$$.fragment,e),M(Ke.$$.fragment,e),M(st.$$.fragment,e),M(it.$$.fragment,e),M(ut.$$.fragment,e),M(ct.$$.fragment,e),M(Mt.$$.fragment,e),M(yt.$$.fragment,e),M(Jt.$$.fragment,e),M(Tt.$$.fragment,e),M(jt.$$.fragment,e),M(Ut.$$.fragment,e),M(bt.$$.fragment,e),M(Y.$$.fragment,e),M(Ct.$$.fragment,e),M(_t.$$.fragment,e),M(Zt.$$.fragment,e),M(Nt.$$.fragment,e),M(Vt.$$.fragment,e),M(St.$$.fragment,e),M(Ft.$$.fragment,e),M(Lt.$$.fragment,e),qn=!0)},o(e){h(D.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(oe.$$.fragment,e),h(ue.$$.fragment,e),h(de.$$.fragment,e),h(Me.$$.fragment,e),h(N.$$.fragment,e),h(ye.$$.fragment,e),h(Je.$$.fragment,e),h(we.$$.fragment,e),h(_e.$$.fragment,e),h(Ze.$$.fragment,e),h(ke.$$.fragment,e),h($e.$$.fragment,e),h(Xe.$$.fragment,e),h(Ae.$$.fragment,e),h(Ee.$$.fragment,e),h(Re.$$.fragment,e),h(Se.$$.fragment,e),h(Fe.$$.fragment,e),h(Pe.$$.fragment,e),h(Ke.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(ut.$$.fragment,e),h(ct.$$.fragment,e),h(Mt.$$.fragment,e),h(yt.$$.fragment,e),h(Jt.$$.fragment,e),h(Tt.$$.fragment,e),h(jt.$$.fragment,e),h(Ut.$$.fragment,e),h(bt.$$.fragment,e),h(Y.$$.fragment,e),h(Ct.$$.fragment,e),h(_t.$$.fragment,e),h(Zt.$$.fragment,e),h(Nt.$$.fragment,e),h(Vt.$$.fragment,e),h(St.$$.fragment,e),h(Ft.$$.fragment,e),h(Lt.$$.fragment,e),qn=!1},d(e){e&&(t(f),t(U),t(_s),t(w),t(xs),t(K),t(Zs),t(O),t(Ws),t(ee),t(ks),t(te),t(qs),t(b),t($s),t(le),t(Gs),t(ne),t(Bs),t(ae),t(Xs),t(zs),t(ie),t(Ns),t(As),t(g),t(Vs),t(pe),t(Es),t(ce),t(Hs),t(Rs),t(me),t(Qs),t(Ss),t(Ys),t(he),t(Fs),t(Ls),t(C),t(Ps),t(ve),t(Ds),t(Te),t(Ks),t(fe),t(Os),t(je),t(el),t(Ue),t(tl),t(sl),t(be),t(ll),t(ge),t(nl),t(Ce),t(al),t(Ie),t(rl),t(il),t(xe),t(ol),t(I),t(ul),t(We),t(pl),t(cl),t(qe),t(dl),t(ml),t(Ge),t(Ml),t(Be),t(hl),t(yl),t(ze),t(Jl),t(Ne),t(vl),t(Tl),t(Ve),t(fl),t(jl),t(He),t(Ul),t(wl),t(Qe),t(bl),t(gl),t(Ye),t(Cl),t(Il),t(Le),t(_l),t(xl),t(De),t(Zl),t(_),t(Wl),t(Oe),t(kl),t(et),t(ql),t(tt),t($l),t(x),t(Gl),t(lt),t(Bl),t(nt),t(Xl),t(at),t(zl),t(rt),t(Nl),t(Al),t(ot),t(Vl),t(El),t(pt),t(Hl),t(Z),t(Rl),t(dt),t(Ql),t(mt),t(Sl),t(Yl),t(ht),t(Fl),t(Ll),t(W),t(Pl),t(vt),t(Dl),t(Kl),t(ft),t(Ol),t(en),t(k),t(tn),t(wt),t(sn),t(ln),t(nn),t(gt),t(an),t(rn),t(It),t(on),t(q),t(un),t(xt),t(pn),t(cn),t(Wt),t(dn),t(kt),t(mn),t(qt),t(Mn),t($t),t(hn),t(Gt),t(yn),t(Bt),t(Jn),t(Xt),t(vn),t(zt),t(Tn),t(fn),t(At),t(jn),t(Un),t(Et),t(wn),t(Ht),t(bn),t(Rt),t(gn),t(Qt),t(Cn),t($),t(In),t(Yt),t(_n),t(xn),t(G),t(Zn),t(Pt),t(Wn),t(Dt),t(kn),t(Cs)),t(T),y(D),y(se),y(re,e),y(oe,e),y(ue),y(de,e),y(Me,e),y(N,e),y(ye,e),y(Je),y(we,e),y(_e,e),y(Ze),y(ke,e),y($e,e),y(Xe,e),y(Ae,e),y(Ee,e),y(Re,e),y(Se,e),y(Fe,e),y(Pe,e),y(Ke),y(st),y(it,e),y(ut,e),y(ct),y(Mt,e),y(yt,e),y(Jt),y(Tt,e),y(jt,e),y(Ut),y(bt,e),y(Y,e),y(Ct,e),y(_t),y(Zt,e),y(Nt,e),y(Vt,e),y(St),y(Ft,e),y(Lt)}}}const Mi={local:"comment-finetuner-un-systme-de-reconnaissance-automatique-de-la-parole-avec-lapi-trainer",sections:[{local:"prparer-lenvironnement",title:"Préparer l'environnement"},{local:"charger-le-jeu-de-donnes",title:"Charger le jeu de données"},{local:"extracteur-de-caractristiques-tokeniser-et-processeur",title:"Extracteur de caractéristiques, tokeniser et processeur"},{local:"prtraitement-des-donnes",title:"Prétraitement des données"},{local:"entranement-et-valuation",sections:[{local:"dfinir-un-assembleur-de-donnes",title:"Définir un assembleur de données"},{local:"mtriques-dvaluation",title:"Métriques d'évaluation"},{local:"charger-un-checkpoint-prentran",title:"Charger un *checkpoint* pré-entraîné"}],title:"Entraînement et évaluation"},{local:"dfinir-la-configuration-de-lentranement",sections:[{local:"entranement",title:"Entraînement"}],title:"Définir la configuration de l'entraînement"},{local:"partager-votre-modle",title:"Partager votre modèle"},{local:"conclusion",title:"Conclusion"}],title:"Comment finetuner un système de reconnaissance automatique de la parole avec l'API Trainer"};function hi(Ot){return ii(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ji extends oi{constructor(T){super(),ui(this,T,hi,mi,ri,{})}}export{ji as component};
