import{s as Dr,o as Kr,n as Or}from"../chunks/scheduler.f7e1785c.js";import{S as ep,i as tp,g as r,s as n,u as o,m as sp,A as lp,h as p,f as s,c as a,j as T,v as u,y as i,n as np,k as y,o as h,a as l,w as c,d as M,t as d,x as m}from"../chunks/index.815a732f.js";import{T as ap}from"../chunks/Tip.1258ac78.js";import{I as U}from"../chunks/IconCopyLink.e7937f56.js";import{C as J}from"../chunks/CodeBlock.c6e8b464.js";function rp(xs){let w,F="Dans notre exemple, nous utiliserons environ 40 heures de données d’entraînement. Si vous souhaitez suivre en utilisant la version gratuite de Google Colab, vous devrez réduire la quantité de données d’entraînement à environ 10-15 heures, ainsi que réduire le nombre d’étapes d’entraînement.";return{c(){w=r("p"),w.textContent=F},l(j){w=p(j,"P",{"data-svelte-h":!0}),i(w)!=="svelte-6yku8n"&&(w.textContent=F)},m(j,ns){l(j,w,ns)},p:Or,d(j){j&&s(w)}}}function pp(xs){let w,F,j,ns,f,V,Js,S,On,as,ua="Finetuning du SpeechT5",Zs,L,ca="Maintenant que vous êtes familiarisé avec la tâche de synthèse vocale et le fonctionnement interne du SpeechT5 qui a été entraîné sur des données en langue anglaise, voyons comment nous pouvons le <em>finetuner</em> à une autre langue.",gs,b,B,hs,P,ea,rs,Ma="Préparation",ks,D,_s,W,Vs,K,da="Vous aurez également besoin de quelques dépendances supplémentaires :",Bs,O,Ws,ee,ma="Enfin, n’oubliez pas de vous connecter à votre compte Hugging Face pour pouvoir télécharger et partager votre modèle avec la communauté :",Gs,te,zs,v,G,Ts,se,ta,ps,ya="Le jeu de données",Ns,le,Ja=`Pour cet exemple, nous prendrons le sous-ensemble en néerlandais (<code>nl</code>) du jeu de données <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a>.
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> est un corpus de parole multilingue à grande échelle composé de données provenant d’enregistrements d’événements du Parlement européen de 2009 à 2020.
Il contient des données de transcription audio étiquetées pour 15 langues européennes. Nous utiliserons le sous-ensemble néerlandais, mais vous pouvez choisir un autre sous-ensemble.`,Xs,ne,ha="Il s’agit d’un jeu de données de reconnaissance automatique de la parole, donc comme mentionné précédemment, ce n’est pas l’option la plus appropriée pour entraîner des modèles TTS. Cependant, il sera suffisant pour cet exercice.",As,ae,Ta="Chargeons les données :",Ys,re,Es,pe,wa="<strong>Sortie :</strong>",Qs,ie,Rs,oe,ja="20968 exemples devraient suffire pour un <em>finetuning</em>. SpeechT5 s’attend à ce que les données audio aient une fréquence d’échantillonnage de 16 kHz, assurez-vous donc que les exemples du jeu de données répondent à cette exigence :",qs,ue,Hs,C,z,ws,ce,sa,is,Ua="Prétraitement des données",Fs,Me,fa="Commençons par définir le <em>checkpoint</em> du modèle à utiliser et par charger le processeur approprié qui contient à la fois le <em>tokenizer</em> et l’extracteur de caractéristiques dont nous aurons besoin pour préparer les données en vue de l’entraînement :",Ss,de,Ls,I,N,js,me,la,os,ba="Nettoyage du texte pour la tokenisation de SpeechT5",Ps,ye,va="Tout d’abord, pour préparer le texte, nous aurons besoin de la partie <em>tokenizer</em> du processeur, alors allons-y :",Ds,Je,Ks,he,Ca="Prenons un exemple :",Os,Te,el,we,Ia="<strong>Sortie :</strong>",tl,je,sl,Ue,$a="Vous remarquerez que les exemples du jeu de données contiennent les caractéristiques <code>raw_text</code> et <code>normalized_text</code>. Lorsque vous décidez quelle caractéristique utiliser comme entrée de texte, il est important de savoir que le <em>tokenizer</em> de SpeechT5 n’a pas de <em>tokens</em> pour les nombres. Dans <code>normalized_text</code>, les nombres sont écrits sous forme textuel. Il s’agit donc d’une meilleure option, et nous devrions utiliser <code>normalized_text</code> comme texte d’entrée.",ll,fe,xa=`Comme SpeechT5 a été entraîné sur la langue anglaise, il se peut qu’il ne reconnaisse pas certains caractères dans le jeu de données néerlandais.
S’ils sont laissés tels quels, ces caractères seront convertis en tokens <code>&lt;unk&gt;</code>. Cependant, en néerlandais, certains caractères comme <code>à</code> sont utilisés pour souligner les syllabes. Afin de préserver le sens du texte, nous pouvons remplacer ce caractère par un <code>a</code> normal.`,nl,be,Za=`Pour identifier les <em>tokens</em> non supportés, extrayez tous les caractères uniques du jeu de données en utilisant le <code>SpeechT5Tokenizer</code> qui fonctionne avec les caractères comme des <em>tokens</em>.
Pour ce faire, nous allons écrire la fonction <code>extract_all_chars</code> qui concatène les transcriptions de tous les exemples en une chaîne et la convertit en un ensemble de caractères.
Assurez-vous de mettre <code>batched=True</code> et <code>batch_size=-1</code> dans <code>dataset.map()</code> afin que toutes les transcriptions soient disponibles en même temps pour la fonction de <em>mapping</em>.`,al,ve,rl,Ce,ga=`Vous disposez à présent de deux ensembles de caractères : l’un avec le vocabulaire du jeu de données et l’autre avec le vocabulaire du <em>tokenizer</em>.
Pour identifier les caractères non pris en charge dans le jeu de données, vous pouvez prendre la différence entre ces deux ensembles. L’ensemble résultant contiendra les caractères qui se trouvent dans le jeu de données mais pas dans le <em>tokenizer</em>.`,pl,Ie,il,$e,ka="<strong>Sortie :</strong>",ol,xe,ul,Ze,_a="Pour gérer les caractères non supportés identifiés dans l’étape précédente, nous pouvons définir une fonction qui fait correspondre ces caractères à des <em>tokens</em> valides. Notez que les espaces sont déjà remplacés par <code>▁</code> dans le <em>tokenizer</em> et n’ont pas besoin d’être gérés séparément.",cl,ge,Ml,ke,Va="Maintenant que nous avons traité les caractères spéciaux dans le texte, il est temps de se concentrer sur les données audio.",dl,$,X,Us,_e,na,us,Ba="Les locuteurs",ml,Ve,Wa=`Le jeu de données VoxPopuli comprend la parole de plusieurs locuteurs, mais combien de locuteurs sont représentés dans le jeu de données ? Pour le savoir, nous pouvons compter le nombre de locuteurs uniques et le nombre d’exemples que chaque locuteur apporte au jeu de données.
Avec un total de 20 968 exemples dans le jeu de données, cette information nous permettra de mieux comprendre la distribution des locuteurs et des exemples dans les données.`,yl,Be,Jl,We,Ga="En traçant un histogramme, vous pouvez vous faire une idée de la quantité de données pour chaque locuteur.",hl,Ge,Tl,A,za='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',wl,ze,Na="L’histogramme révèle qu’environ un tiers des locuteurs du jeu de données ont moins de 100 exemples, tandis qu’une dizaine de locuteurs ont plus de 500 exemples. Pour améliorer l’efficacité de l’entraînement et équilibrer le jeu de données, nous pouvons limiter les données aux locuteurs ayant entre 100 et 400 exemples.",jl,Ne,Ul,Xe,Xa="Vérifions le nombre de locuteurs restants :",fl,Ae,bl,Ye,Aa="<strong>Sortie :</strong>",vl,Ee,Cl,Qe,Ya="Voyons combien d’exemples il reste :",Il,Re,$l,qe,Ea="<strong>Sortie :</strong>",xl,He,Zl,Fe,Qa="Vous vous retrouvez avec un peu moins de 10 000 exemples provenant d’environ 40 locuteurs uniques, ce qui devrait être suffisant.",gl,Se,Ra="Notez que certains locuteurs ayant peu d’exemples peuvent en fait avoir plus d’audio disponible si les exemples sont longs. Cependant, pour déterminer la quantité totale d’audio pour chaque locuteur, il faut parcourir l’ensemble des données, ce qui est un processus long qui implique le chargement et le décodage de chaque fichier audio. C’est pourquoi nous avons choisi de sauter cette étape.",kl,x,Y,fs,Le,aa,cs,qa="Enchâssement des locuteurs",_l,Pe,Ha=`Pour permettre au modèle TTS de différencier plusieurs locuteurs, vous devrez créer un enchâssement de locuteur pour chaque exemple.
C’est est une entrée supplémentaire dans le modèle qui capture les caractéristiques de la voix d’un locuteur particulier.
Pour générer ces enchâssements, utilisez le modèle pré-entraîné <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a> de SpeechBrain.`,Vl,De,Fa="Créez une fonction <code>create_speaker_embedding()</code> qui prend une forme d’onde audio en entrée et produit un vecteur de 512 éléments contenant l’enchâssement du locuteur correspondant.",Bl,Ke,Wl,Oe,Sa="Il est important de noter que le modèle <code>speechbrain/spkrec-xvect-voxceleb</code> a été entraîné sur de l’anglais provenant du jeu de données VoxCeleb, alors que les exemples d’entraînement dans ce guide sont en néerlandais. Bien que nous pensions que ce modèle génèrerait toujours des enchâssements de locuteurs raisonnables pour notre jeu de données néerlandais, cette hypothèse peut ne pas être vraie dans tous les cas.",Gl,et,La='Pour obtenir des résultats optimaux, nous devrions d’abord entraîner un modèle de vecteur X sur le discours cible. Ainsi, le modèle sera mieux à même de capturer les caractéristiques vocales uniques présentes dans la langue néerlandaise. Si vous souhaitez entraîner votre propre modèle X-vector, vous pouvez utiliser <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">ce script</a> comme exemple.',zl,Z,E,bs,tt,ra,Ms,Pa="Traitement du jeu de données",Nl,st,Da=`Enfin, traitons les données dans le format attendu par le modèle. Créez une fonction <code>prepare_dataset</code> qui prend un seul exemple et utilise l’objet <code>SpeechT5Processor</code> pour tokeniser le texte d’entrée et charger l’audio cible dans un spectrogramme log-mel.
Elle devrait également ajouter les enchâssements de locuteur en tant qu’entrée supplémentaire.`,Xl,lt,Al,nt,Ka="Vérifiez que le traitement est correct en examinant un seul exemple :",Yl,at,El,rt,Oa="<strong>Sortie :</strong>",Ql,pt,Rl,it,er="Les enchâssements de locuteurs doivent être un vecteur de 512 éléments :",ql,ot,Hl,ut,tr="<strong>Sortie :</strong>",Fl,ct,Sl,Mt,sr="Les étiquettes doivent être un spectrogramme log-mel avec 80 bins mel.",Ll,dt,Pl,Q,lr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',Dl,mt,nr=`Remarque : si vous trouvez ce spectrogramme déroutant, c’est peut-être parce que vous êtes familier avec la convention qui consiste à placer les basses fréquences en bas et les hautes fréquences en haut d’un graphique.
Cependant, lorsque l’on trace des spectrogrammes sous forme d’image à l’aide de la bibliothèque matplotlib, l’axe des ordonnées est inversé et les spectrogrammes apparaissent à l’envers.`,Kl,yt,ar="Nous devons maintenant appliquer la fonction de traitement à l’ensemble du jeu de données. Cela prendra entre 5 et 10 minutes.",Ol,Jt,en,ht,rr=`Vous verrez un avertissement indiquant que certains exemples du jeu de données sont plus longs que la longueur d’entrée maximale que le modèle peut traiter (600 <em>tokens</em>).
Supprimez ces exemples du jeu de données. Ici, nous allons encore plus loin et, pour tenir compte de la taille des batchs, nous supprimons tout ce qui dépasse 200 <em>tokens</em>.`,tn,Tt,sn,wt,pr="<strong>Sortie :</strong>",ln,jt,nn,Ut,ir="Next, create a basic train/test split:",an,ft,rn,g,R,vs,bt,pa,ds,or="Assembleur de données",pn,vt,ur="Afin de combiner plusieurs exemples dans un batch, vous devez définir un assembleur de données personnalisé. Il remplacera les séquences les plus courtes par des <em>tokens</em> de rembourrage, afin de s’assurer que tous les exemples ont la même longueur. Pour les étiquettes des spectrogrammes, les parties rembourrées sont remplacées par la valeur spéciale <code>-100</code>. Cette valeur spéciale indique au modèle d’ignorer cette partie du spectrogramme lors du calcul de la perte de spectrogramme.",on,Ct,un,It,cr="Dans SpeechT5, l’entrée de la partie décodeur du modèle est réduite d’un facteur 2. En d’autres termes, il élimine un pas de temps sur deux de la séquence cible. Le décodeur prédit alors une séquence deux fois plus longue. Étant donné que la longueur de la séquence cible d’origine peut être impaire, l’assembleur de données veille à arrondir la longueur maximale du batch à un multiple de 2.",cn,$t,Mn,k,q,Cs,xt,ia,ms,Mr="Entraîner le modèle",dn,Zt,dr="Chargez le modèle pré-entraîné à partir du même <em>checkpoint</em> que celui utilisé pour le chargement du processeur :",mn,gt,yn,kt,mr="L’option <code>use_cache=True</code> est incompatible avec le <em>checkingpointing</em> du gradient. Désactivez-la pour l’entraînement, et réactivez le cache pour la génération afin d’accélérer le temps d’inférence :",Jn,_t,hn,Vt,yr="Définir les arguments d’entraînement. Ici, nous ne calculons aucune métrique d’évaluation pendant le processus d’entraînement, nous parlerons d’évaluation plus tard dans ce chapitre. Au lieu de cela, nous ne nous intéresserons qu’à la perte :",Tn,Bt,wn,Wt,Jr="Instancie l’objet <code>Trainer</code> et lui passe le modèle, le jeu de données et l’assembleur de données.",jn,Gt,Un,zt,hr="Et voilà, nous sommes prêts à commencer l’entraînement ! Il prendra plusieurs heures. En fonction de votre GPU, il est possible que vous rencontriez une erreur CUDA “out-of-memory” lorsque vous commencez l’entraînement. Dans ce cas, vous pouvez réduire la taille de <code>per_device_train_batch_size</code> par incréments d’un facteur 2 et augmenter <code>gradient_accumulation_steps</code> par 2 pour compenser.",fn,Nt,bn,Xt,Tr="Pousser le modèle final sur le <em>Hub</em> :",vn,At,Cn,_,H,Is,Yt,oa,ys,wr="Inférence",In,Et,jr="Une fois que vous avez <em>finetuné</em> un modèle, vous pouvez l’utiliser pour l’inférence ! Chargez le modèle à partir du <em>Hub</em> (assurez-vous d’utiliser votre nom de compte dans l’extrait de code suivant) :",$n,Qt,xn,Rt,Ur="Choisissez un exemple, ici nous en prendrons un du jeu de données de test. Obtenez un enchâssement du locuteur.",Zn,qt,gn,Ht,fr="Définir un texte d’entrée et le <em>tokeniser</em>.",kn,Ft,_n,St,br="Prétraiter le texte d’entrée :",Vn,Lt,Bn,Pt,vr="Installez un vocodeur et générez de la parole :",Wn,Dt,Gn,Kt,Cr="On écoute le résultat ?",zn,Ot,Nn,es,Ir="Il peut être difficile d’obtenir des résultats satisfaisants avec ce modèle dans une nouvelle langue. La qualité de l’enchâssement du locuteur peut être un facteur important. Comme SpeechT5 a été entraîné avec des X-vectors anglais, il donne de meilleurs résultats lorsqu’il utilise des enchâssements de locuteurs anglais. Si la synthèse vocale semble médiocre, essayez d’utiliser un autre enchâssement de locuteur.",Xn,ts,$r=`L’augmentation de la durée d’entraînement est également susceptible d’améliorer la qualité des résultats. Malgré cela, le discours est clairement néerlandais et non anglais, et il capture les caractéristiques vocales du locuteur (comparez avec l’audio original dans l’exemple).
Une autre chose à expérimenter est la configuration du modèle. Par exemple, essayez d’utiliser <code>config.reduction_factor = 1</code> pour voir si cela améliore les résultats.`,An,ss,xr="Dans la section suivante, nous verrons comment nous évaluons les modèles de synthèse vocale.",Yn,$s,En;return S=new U({}),P=new U({}),D=new J({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi"}}),W=new ap({props:{warning:!0,$$slots:{default:[rp]},$$scope:{ctx:xs}}}),O=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate"}}),te=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),se=new U({}),re=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`}}),ie=new J({props:{code:"MjA5Njg=",highlighted:"20968"}}),ue=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))'}}),ce=new U({}),de=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`}}),me=new U({}),Je=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer"}}),Te=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]'}}),je=new J({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`}}),ve=new J({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`}}),Ie=new J({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab"}}),xe=new J({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}"}}),ge=new J({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`}}),_e=new U({}),Be=new J({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`}}),Ge=new J({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`}}),Ne=new J({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`}}),Ae=new J({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))'}}),Ee=new J({props:{code:"NDI=",highlighted:"42"}}),Re=new J({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)'}}),He=new J({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>'}}),Le=new U({}),Ke=new J({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`}}),tt=new U({}),lt=new J({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># strip off the batch dimension</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`}}),at=new J({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`}}),pt=new J({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]'}}),ot=new J({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape'}}),ct=new J({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)'}}),dt=new J({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`}}),Jt=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)'}}),Tt=new J({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`}}),jt=new J({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>'}}),ft=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)'}}),bt=new U({}),Ct=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># assembler les données d&#x27;entrée et les cibles dans un batch</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># remplacer le rembourrage par -100 pour ignorer correctement les pertes</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># non utilisé pendant le finetuning</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># arrondir les longueurs cibles au multiple du facteur de réduction</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># ajoutez également les enchâssements de locuteur</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`}}),$t=new J({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)"}}),xt=new U({}),gt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`}}),_t=new J({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkJUMzJUE5c2FjdGl2ZXIlMjBsZSUyMGNhY2hlJTIwcGVuZGFudCUyMGwnZW50cmElQzMlQUVuZW1lbnQlMjBjYXIlMjBpbCUyMGVzdCUyMGluY29tcGF0aWJsZSUyMGF2ZWMlMjBsZSUyMGNoZWNrcG9pbnRpbmclMjBkdSUyMGdyYWRpZW50JTBBbW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNlJTBBJTBBJTIzJTIwZCVDMyVBOWZpbmlyJTIwbGElMjBsYW5ndWUlMjBldCUyMGxhJTIwdCVDMyVBMmNoZSUyMHBvdXIlMjBsYSUyMGclQzMlQTluJUMzJUE5cmF0aW9uJTIwZXQlMjByJUMzJUE5YWN0aXZlciUyMGxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># désactiver le cache pendant l&#x27;entraînement car il est incompatible avec le checkpointing du gradient</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># définir la langue et la tâche pour la génération et réactiver le cache</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`}}),Bt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2VyJTIwcG91ciUyMHVuJTIwbm9tJTIwZGUlMjBkJUMzJUE5cCVDMyVCNHQlMjBkZSUyMHZvdHJlJTIwY2hvaXglMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENDAwMCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTVCJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># changer pour un nom de dépôt de votre choix</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`}}),Gt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`}}),Nt=new J({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()"}}),At=new J({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()"}}),Yt=new U({}),Qt=new J({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`}}),qt=new J({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`}}),Ft=new J({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>'}}),Lt=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)'}}),Dt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`}}),Ot=new J({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`}}),{c(){w=r("meta"),F=n(),j=r("p"),ns=n(),f=r("h1"),V=r("a"),Js=r("span"),o(S.$$.fragment),On=n(),as=r("span"),as.textContent=ua,Zs=n(),L=r("p"),L.innerHTML=ca,gs=n(),b=r("h2"),B=r("a"),hs=r("span"),o(P.$$.fragment),ea=n(),rs=r("span"),rs.textContent=Ma,ks=sp(`

Assurez-vous de disposer d'un GPU si vous souhaitez reproduire cet exemple. Dans un *notebook*, vous pouvez vérifier avec la commande suivante :

	`),o(D.$$.fragment),_s=n(),o(W.$$.fragment),Vs=n(),K=r("p"),K.textContent=da,Bs=n(),o(O.$$.fragment),Ws=n(),ee=r("p"),ee.textContent=ma,Gs=n(),o(te.$$.fragment),zs=n(),v=r("h2"),G=r("a"),Ts=r("span"),o(se.$$.fragment),ta=n(),ps=r("span"),ps.textContent=ya,Ns=n(),le=r("p"),le.innerHTML=Ja,Xs=n(),ne=r("p"),ne.textContent=ha,As=n(),ae=r("p"),ae.textContent=Ta,Ys=n(),o(re.$$.fragment),Es=n(),pe=r("p"),pe.innerHTML=wa,Qs=n(),o(ie.$$.fragment),Rs=n(),oe=r("p"),oe.innerHTML=ja,qs=n(),o(ue.$$.fragment),Hs=n(),C=r("h2"),z=r("a"),ws=r("span"),o(ce.$$.fragment),sa=n(),is=r("span"),is.textContent=Ua,Fs=n(),Me=r("p"),Me.innerHTML=fa,Ss=n(),o(de.$$.fragment),Ls=n(),I=r("h3"),N=r("a"),js=r("span"),o(me.$$.fragment),la=n(),os=r("span"),os.textContent=ba,Ps=n(),ye=r("p"),ye.innerHTML=va,Ds=n(),o(Je.$$.fragment),Ks=n(),he=r("p"),he.textContent=Ca,Os=n(),o(Te.$$.fragment),el=n(),we=r("p"),we.innerHTML=Ia,tl=n(),o(je.$$.fragment),sl=n(),Ue=r("p"),Ue.innerHTML=$a,ll=n(),fe=r("p"),fe.innerHTML=xa,nl=n(),be=r("p"),be.innerHTML=Za,al=n(),o(ve.$$.fragment),rl=n(),Ce=r("p"),Ce.innerHTML=ga,pl=n(),o(Ie.$$.fragment),il=n(),$e=r("p"),$e.innerHTML=ka,ol=n(),o(xe.$$.fragment),ul=n(),Ze=r("p"),Ze.innerHTML=_a,cl=n(),o(ge.$$.fragment),Ml=n(),ke=r("p"),ke.textContent=Va,dl=n(),$=r("h3"),X=r("a"),Us=r("span"),o(_e.$$.fragment),na=n(),us=r("span"),us.textContent=Ba,ml=n(),Ve=r("p"),Ve.textContent=Wa,yl=n(),o(Be.$$.fragment),Jl=n(),We=r("p"),We.textContent=Ga,hl=n(),o(Ge.$$.fragment),Tl=n(),A=r("div"),A.innerHTML=za,wl=n(),ze=r("p"),ze.textContent=Na,jl=n(),o(Ne.$$.fragment),Ul=n(),Xe=r("p"),Xe.textContent=Xa,fl=n(),o(Ae.$$.fragment),bl=n(),Ye=r("p"),Ye.innerHTML=Aa,vl=n(),o(Ee.$$.fragment),Cl=n(),Qe=r("p"),Qe.textContent=Ya,Il=n(),o(Re.$$.fragment),$l=n(),qe=r("p"),qe.innerHTML=Ea,xl=n(),o(He.$$.fragment),Zl=n(),Fe=r("p"),Fe.textContent=Qa,gl=n(),Se=r("p"),Se.textContent=Ra,kl=n(),x=r("h3"),Y=r("a"),fs=r("span"),o(Le.$$.fragment),aa=n(),cs=r("span"),cs.textContent=qa,_l=n(),Pe=r("p"),Pe.innerHTML=Ha,Vl=n(),De=r("p"),De.innerHTML=Fa,Bl=n(),o(Ke.$$.fragment),Wl=n(),Oe=r("p"),Oe.innerHTML=Sa,Gl=n(),et=r("p"),et.innerHTML=La,zl=n(),Z=r("h3"),E=r("a"),bs=r("span"),o(tt.$$.fragment),ra=n(),Ms=r("span"),Ms.textContent=Pa,Nl=n(),st=r("p"),st.innerHTML=Da,Xl=n(),o(lt.$$.fragment),Al=n(),nt=r("p"),nt.textContent=Ka,Yl=n(),o(at.$$.fragment),El=n(),rt=r("p"),rt.innerHTML=Oa,Ql=n(),o(pt.$$.fragment),Rl=n(),it=r("p"),it.textContent=er,ql=n(),o(ot.$$.fragment),Hl=n(),ut=r("p"),ut.innerHTML=tr,Fl=n(),o(ct.$$.fragment),Sl=n(),Mt=r("p"),Mt.textContent=sr,Ll=n(),o(dt.$$.fragment),Pl=n(),Q=r("div"),Q.innerHTML=lr,Dl=n(),mt=r("p"),mt.textContent=nr,Kl=n(),yt=r("p"),yt.textContent=ar,Ol=n(),o(Jt.$$.fragment),en=n(),ht=r("p"),ht.innerHTML=rr,tn=n(),o(Tt.$$.fragment),sn=n(),wt=r("p"),wt.innerHTML=pr,ln=n(),o(jt.$$.fragment),nn=n(),Ut=r("p"),Ut.textContent=ir,an=n(),o(ft.$$.fragment),rn=n(),g=r("h3"),R=r("a"),vs=r("span"),o(bt.$$.fragment),pa=n(),ds=r("span"),ds.textContent=or,pn=n(),vt=r("p"),vt.innerHTML=ur,on=n(),o(Ct.$$.fragment),un=n(),It=r("p"),It.textContent=cr,cn=n(),o($t.$$.fragment),Mn=n(),k=r("h2"),q=r("a"),Cs=r("span"),o(xt.$$.fragment),ia=n(),ms=r("span"),ms.textContent=Mr,dn=n(),Zt=r("p"),Zt.innerHTML=dr,mn=n(),o(gt.$$.fragment),yn=n(),kt=r("p"),kt.innerHTML=mr,Jn=n(),o(_t.$$.fragment),hn=n(),Vt=r("p"),Vt.textContent=yr,Tn=n(),o(Bt.$$.fragment),wn=n(),Wt=r("p"),Wt.innerHTML=Jr,jn=n(),o(Gt.$$.fragment),Un=n(),zt=r("p"),zt.innerHTML=hr,fn=n(),o(Nt.$$.fragment),bn=n(),Xt=r("p"),Xt.innerHTML=Tr,vn=n(),o(At.$$.fragment),Cn=n(),_=r("h2"),H=r("a"),Is=r("span"),o(Yt.$$.fragment),oa=n(),ys=r("span"),ys.textContent=wr,In=n(),Et=r("p"),Et.innerHTML=jr,$n=n(),o(Qt.$$.fragment),xn=n(),Rt=r("p"),Rt.textContent=Ur,Zn=n(),o(qt.$$.fragment),gn=n(),Ht=r("p"),Ht.innerHTML=fr,kn=n(),o(Ft.$$.fragment),_n=n(),St=r("p"),St.textContent=br,Vn=n(),o(Lt.$$.fragment),Bn=n(),Pt=r("p"),Pt.textContent=vr,Wn=n(),o(Dt.$$.fragment),Gn=n(),Kt=r("p"),Kt.textContent=Cr,zn=n(),o(Ot.$$.fragment),Nn=n(),es=r("p"),es.textContent=Ir,Xn=n(),ts=r("p"),ts.innerHTML=$r,An=n(),ss=r("p"),ss.textContent=xr,Yn=n(),$s=r("p"),this.h()},l(e){const t=lp("svelte-1phssyn",document.head);w=p(t,"META",{name:!0,content:!0}),t.forEach(s),F=a(e),j=p(e,"P",{}),T(j).forEach(s),ns=a(e),f=p(e,"H1",{class:!0});var ls=T(f);V=p(ls,"A",{id:!0,class:!0,href:!0});var Zr=T(V);Js=p(Zr,"SPAN",{});var gr=T(Js);u(S.$$.fragment,gr),gr.forEach(s),Zr.forEach(s),On=a(ls),as=p(ls,"SPAN",{"data-svelte-h":!0}),i(as)!=="svelte-8w3002"&&(as.textContent=ua),ls.forEach(s),Zs=a(e),L=p(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1odglk1"&&(L.innerHTML=ca),gs=a(e),b=p(e,"H2",{class:!0});var Qn=T(b);B=p(Qn,"A",{id:!0,class:!0,href:!0});var kr=T(B);hs=p(kr,"SPAN",{});var _r=T(hs);u(P.$$.fragment,_r),_r.forEach(s),kr.forEach(s),ea=a(Qn),rs=p(Qn,"SPAN",{"data-svelte-h":!0}),i(rs)!=="svelte-1byj10i"&&(rs.textContent=Ma),Qn.forEach(s),ks=np(e,`

Assurez-vous de disposer d'un GPU si vous souhaitez reproduire cet exemple. Dans un *notebook*, vous pouvez vérifier avec la commande suivante :

	`),u(D.$$.fragment,e),_s=a(e),u(W.$$.fragment,e),Vs=a(e),K=p(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-zql47t"&&(K.textContent=da),Bs=a(e),u(O.$$.fragment,e),Ws=a(e),ee=p(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-182tg48"&&(ee.textContent=ma),Gs=a(e),u(te.$$.fragment,e),zs=a(e),v=p(e,"H2",{class:!0});var Rn=T(v);G=p(Rn,"A",{id:!0,class:!0,href:!0});var Vr=T(G);Ts=p(Vr,"SPAN",{});var Br=T(Ts);u(se.$$.fragment,Br),Br.forEach(s),Vr.forEach(s),ta=a(Rn),ps=p(Rn,"SPAN",{"data-svelte-h":!0}),i(ps)!=="svelte-1ukqx99"&&(ps.textContent=ya),Rn.forEach(s),Ns=a(e),le=p(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-649ds4"&&(le.innerHTML=Ja),Xs=a(e),ne=p(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-r0igd1"&&(ne.textContent=ha),As=a(e),ae=p(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-gwah4k"&&(ae.textContent=Ta),Ys=a(e),u(re.$$.fragment,e),Es=a(e),pe=p(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-dbzevp"&&(pe.innerHTML=wa),Qs=a(e),u(ie.$$.fragment,e),Rs=a(e),oe=p(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-iud575"&&(oe.innerHTML=ja),qs=a(e),u(ue.$$.fragment,e),Hs=a(e),C=p(e,"H2",{class:!0});var qn=T(C);z=p(qn,"A",{id:!0,class:!0,href:!0});var Wr=T(z);ws=p(Wr,"SPAN",{});var Gr=T(ws);u(ce.$$.fragment,Gr),Gr.forEach(s),Wr.forEach(s),sa=a(qn),is=p(qn,"SPAN",{"data-svelte-h":!0}),i(is)!=="svelte-rvvotz"&&(is.textContent=Ua),qn.forEach(s),Fs=a(e),Me=p(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1xkg4b0"&&(Me.innerHTML=fa),Ss=a(e),u(de.$$.fragment,e),Ls=a(e),I=p(e,"H3",{class:!0});var Hn=T(I);N=p(Hn,"A",{id:!0,class:!0,href:!0});var zr=T(N);js=p(zr,"SPAN",{});var Nr=T(js);u(me.$$.fragment,Nr),Nr.forEach(s),zr.forEach(s),la=a(Hn),os=p(Hn,"SPAN",{"data-svelte-h":!0}),i(os)!=="svelte-93rhcx"&&(os.textContent=ba),Hn.forEach(s),Ps=a(e),ye=p(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-1hwlbv"&&(ye.innerHTML=va),Ds=a(e),u(Je.$$.fragment,e),Ks=a(e),he=p(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-1ma4sp4"&&(he.textContent=Ca),Os=a(e),u(Te.$$.fragment,e),el=a(e),we=p(e,"P",{"data-svelte-h":!0}),i(we)!=="svelte-dbzevp"&&(we.innerHTML=Ia),tl=a(e),u(je.$$.fragment,e),sl=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-1fh07v6"&&(Ue.innerHTML=$a),ll=a(e),fe=p(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-bjt1cp"&&(fe.innerHTML=xa),nl=a(e),be=p(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-1y8jaor"&&(be.innerHTML=Za),al=a(e),u(ve.$$.fragment,e),rl=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-1xmdue5"&&(Ce.innerHTML=ga),pl=a(e),u(Ie.$$.fragment,e),il=a(e),$e=p(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-dbzevp"&&($e.innerHTML=ka),ol=a(e),u(xe.$$.fragment,e),ul=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-8zji7u"&&(Ze.innerHTML=_a),cl=a(e),u(ge.$$.fragment,e),Ml=a(e),ke=p(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-19enlau"&&(ke.textContent=Va),dl=a(e),$=p(e,"H3",{class:!0});var Fn=T($);X=p(Fn,"A",{id:!0,class:!0,href:!0});var Xr=T(X);Us=p(Xr,"SPAN",{});var Ar=T(Us);u(_e.$$.fragment,Ar),Ar.forEach(s),Xr.forEach(s),na=a(Fn),us=p(Fn,"SPAN",{"data-svelte-h":!0}),i(us)!=="svelte-1gfzbnx"&&(us.textContent=Ba),Fn.forEach(s),ml=a(e),Ve=p(e,"P",{"data-svelte-h":!0}),i(Ve)!=="svelte-18ycs8t"&&(Ve.textContent=Wa),yl=a(e),u(Be.$$.fragment,e),Jl=a(e),We=p(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-nwfji0"&&(We.textContent=Ga),hl=a(e),u(Ge.$$.fragment,e),Tl=a(e),A=p(e,"DIV",{class:!0,"data-svelte-h":!0}),i(A)!=="svelte-1uufiik"&&(A.innerHTML=za),wl=a(e),ze=p(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-1rtsrif"&&(ze.textContent=Na),jl=a(e),u(Ne.$$.fragment,e),Ul=a(e),Xe=p(e,"P",{"data-svelte-h":!0}),i(Xe)!=="svelte-16v30mk"&&(Xe.textContent=Xa),fl=a(e),u(Ae.$$.fragment,e),bl=a(e),Ye=p(e,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-dbzevp"&&(Ye.innerHTML=Aa),vl=a(e),u(Ee.$$.fragment,e),Cl=a(e),Qe=p(e,"P",{"data-svelte-h":!0}),i(Qe)!=="svelte-zuw53j"&&(Qe.textContent=Ya),Il=a(e),u(Re.$$.fragment,e),$l=a(e),qe=p(e,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-dbzevp"&&(qe.innerHTML=Ea),xl=a(e),u(He.$$.fragment,e),Zl=a(e),Fe=p(e,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-31x8kk"&&(Fe.textContent=Qa),gl=a(e),Se=p(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-1w6hl2u"&&(Se.textContent=Ra),kl=a(e),x=p(e,"H3",{class:!0});var Sn=T(x);Y=p(Sn,"A",{id:!0,class:!0,href:!0});var Yr=T(Y);fs=p(Yr,"SPAN",{});var Er=T(fs);u(Le.$$.fragment,Er),Er.forEach(s),Yr.forEach(s),aa=a(Sn),cs=p(Sn,"SPAN",{"data-svelte-h":!0}),i(cs)!=="svelte-sobe9y"&&(cs.textContent=qa),Sn.forEach(s),_l=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-17z7cpr"&&(Pe.innerHTML=Ha),Vl=a(e),De=p(e,"P",{"data-svelte-h":!0}),i(De)!=="svelte-4hmwow"&&(De.innerHTML=Fa),Bl=a(e),u(Ke.$$.fragment,e),Wl=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-xw8jh1"&&(Oe.innerHTML=Sa),Gl=a(e),et=p(e,"P",{"data-svelte-h":!0}),i(et)!=="svelte-6lbev2"&&(et.innerHTML=La),zl=a(e),Z=p(e,"H3",{class:!0});var Ln=T(Z);E=p(Ln,"A",{id:!0,class:!0,href:!0});var Qr=T(E);bs=p(Qr,"SPAN",{});var Rr=T(bs);u(tt.$$.fragment,Rr),Rr.forEach(s),Qr.forEach(s),ra=a(Ln),Ms=p(Ln,"SPAN",{"data-svelte-h":!0}),i(Ms)!=="svelte-hh2lam"&&(Ms.textContent=Pa),Ln.forEach(s),Nl=a(e),st=p(e,"P",{"data-svelte-h":!0}),i(st)!=="svelte-1oc1ikt"&&(st.innerHTML=Da),Xl=a(e),u(lt.$$.fragment,e),Al=a(e),nt=p(e,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-56wyab"&&(nt.textContent=Ka),Yl=a(e),u(at.$$.fragment,e),El=a(e),rt=p(e,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-dbzevp"&&(rt.innerHTML=Oa),Ql=a(e),u(pt.$$.fragment,e),Rl=a(e),it=p(e,"P",{"data-svelte-h":!0}),i(it)!=="svelte-8c0crw"&&(it.textContent=er),ql=a(e),u(ot.$$.fragment,e),Hl=a(e),ut=p(e,"P",{"data-svelte-h":!0}),i(ut)!=="svelte-dbzevp"&&(ut.innerHTML=tr),Fl=a(e),u(ct.$$.fragment,e),Sl=a(e),Mt=p(e,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-33k1kn"&&(Mt.textContent=sr),Ll=a(e),u(dt.$$.fragment,e),Pl=a(e),Q=p(e,"DIV",{class:!0,"data-svelte-h":!0}),i(Q)!=="svelte-j4o1b8"&&(Q.innerHTML=lr),Dl=a(e),mt=p(e,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-dra6ot"&&(mt.textContent=nr),Kl=a(e),yt=p(e,"P",{"data-svelte-h":!0}),i(yt)!=="svelte-6d8mq6"&&(yt.textContent=ar),Ol=a(e),u(Jt.$$.fragment,e),en=a(e),ht=p(e,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-ezcn9z"&&(ht.innerHTML=rr),tn=a(e),u(Tt.$$.fragment,e),sn=a(e),wt=p(e,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-dbzevp"&&(wt.innerHTML=pr),ln=a(e),u(jt.$$.fragment,e),nn=a(e),Ut=p(e,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-12gx63x"&&(Ut.textContent=ir),an=a(e),u(ft.$$.fragment,e),rn=a(e),g=p(e,"H3",{class:!0});var Pn=T(g);R=p(Pn,"A",{id:!0,class:!0,href:!0});var qr=T(R);vs=p(qr,"SPAN",{});var Hr=T(vs);u(bt.$$.fragment,Hr),Hr.forEach(s),qr.forEach(s),pa=a(Pn),ds=p(Pn,"SPAN",{"data-svelte-h":!0}),i(ds)!=="svelte-k95nvd"&&(ds.textContent=or),Pn.forEach(s),pn=a(e),vt=p(e,"P",{"data-svelte-h":!0}),i(vt)!=="svelte-zdglne"&&(vt.innerHTML=ur),on=a(e),u(Ct.$$.fragment,e),un=a(e),It=p(e,"P",{"data-svelte-h":!0}),i(It)!=="svelte-1g1h6a2"&&(It.textContent=cr),cn=a(e),u($t.$$.fragment,e),Mn=a(e),k=p(e,"H2",{class:!0});var Dn=T(k);q=p(Dn,"A",{id:!0,class:!0,href:!0});var Fr=T(q);Cs=p(Fr,"SPAN",{});var Sr=T(Cs);u(xt.$$.fragment,Sr),Sr.forEach(s),Fr.forEach(s),ia=a(Dn),ms=p(Dn,"SPAN",{"data-svelte-h":!0}),i(ms)!=="svelte-16aqvtq"&&(ms.textContent=Mr),Dn.forEach(s),dn=a(e),Zt=p(e,"P",{"data-svelte-h":!0}),i(Zt)!=="svelte-kop7ev"&&(Zt.innerHTML=dr),mn=a(e),u(gt.$$.fragment,e),yn=a(e),kt=p(e,"P",{"data-svelte-h":!0}),i(kt)!=="svelte-1wpgu2u"&&(kt.innerHTML=mr),Jn=a(e),u(_t.$$.fragment,e),hn=a(e),Vt=p(e,"P",{"data-svelte-h":!0}),i(Vt)!=="svelte-14u91wl"&&(Vt.textContent=yr),Tn=a(e),u(Bt.$$.fragment,e),wn=a(e),Wt=p(e,"P",{"data-svelte-h":!0}),i(Wt)!=="svelte-15wpyyc"&&(Wt.innerHTML=Jr),jn=a(e),u(Gt.$$.fragment,e),Un=a(e),zt=p(e,"P",{"data-svelte-h":!0}),i(zt)!=="svelte-c07opw"&&(zt.innerHTML=hr),fn=a(e),u(Nt.$$.fragment,e),bn=a(e),Xt=p(e,"P",{"data-svelte-h":!0}),i(Xt)!=="svelte-mr5xro"&&(Xt.innerHTML=Tr),vn=a(e),u(At.$$.fragment,e),Cn=a(e),_=p(e,"H2",{class:!0});var Kn=T(_);H=p(Kn,"A",{id:!0,class:!0,href:!0});var Lr=T(H);Is=p(Lr,"SPAN",{});var Pr=T(Is);u(Yt.$$.fragment,Pr),Pr.forEach(s),Lr.forEach(s),oa=a(Kn),ys=p(Kn,"SPAN",{"data-svelte-h":!0}),i(ys)!=="svelte-ve0rfc"&&(ys.textContent=wr),Kn.forEach(s),In=a(e),Et=p(e,"P",{"data-svelte-h":!0}),i(Et)!=="svelte-7v0yj3"&&(Et.innerHTML=jr),$n=a(e),u(Qt.$$.fragment,e),xn=a(e),Rt=p(e,"P",{"data-svelte-h":!0}),i(Rt)!=="svelte-qm5zo2"&&(Rt.textContent=Ur),Zn=a(e),u(qt.$$.fragment,e),gn=a(e),Ht=p(e,"P",{"data-svelte-h":!0}),i(Ht)!=="svelte-1atngeh"&&(Ht.innerHTML=fr),kn=a(e),u(Ft.$$.fragment,e),_n=a(e),St=p(e,"P",{"data-svelte-h":!0}),i(St)!=="svelte-11n0rrj"&&(St.textContent=br),Vn=a(e),u(Lt.$$.fragment,e),Bn=a(e),Pt=p(e,"P",{"data-svelte-h":!0}),i(Pt)!=="svelte-671fhq"&&(Pt.textContent=vr),Wn=a(e),u(Dt.$$.fragment,e),Gn=a(e),Kt=p(e,"P",{"data-svelte-h":!0}),i(Kt)!=="svelte-7kkl40"&&(Kt.textContent=Cr),zn=a(e),u(Ot.$$.fragment,e),Nn=a(e),es=p(e,"P",{"data-svelte-h":!0}),i(es)!=="svelte-d3yvzd"&&(es.textContent=Ir),Xn=a(e),ts=p(e,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1i751j2"&&(ts.innerHTML=$r),An=a(e),ss=p(e,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-y5achn"&&(ss.textContent=xr),Yn=a(e),$s=p(e,"P",{}),T($s).forEach(s),this.h()},h(){y(w,"name","hf:doc:metadata"),y(w,"content",JSON.stringify(ip)),y(V,"id","finetuning-du-speecht5"),y(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(V,"href","#finetuning-du-speecht5"),y(f,"class","relative group"),y(B,"id","prparation"),y(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(B,"href","#prparation"),y(b,"class","relative group"),y(G,"id","le-jeu-de-donnes"),y(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(G,"href","#le-jeu-de-donnes"),y(v,"class","relative group"),y(z,"id","prtraitement-des-donnes"),y(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(z,"href","#prtraitement-des-donnes"),y(C,"class","relative group"),y(N,"id","nettoyage-du-texte-pour-la-tokenisation-de-speecht5"),y(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(N,"href","#nettoyage-du-texte-pour-la-tokenisation-de-speecht5"),y(I,"class","relative group"),y(X,"id","les-locuteurs"),y(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(X,"href","#les-locuteurs"),y($,"class","relative group"),y(A,"class","flex justify-center"),y(Y,"id","enchssement-des-locuteurs"),y(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(Y,"href","#enchssement-des-locuteurs"),y(x,"class","relative group"),y(E,"id","traitement-du-jeu-de-donnes"),y(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(E,"href","#traitement-du-jeu-de-donnes"),y(Z,"class","relative group"),y(Q,"class","flex justify-center"),y(R,"id","assembleur-de-donnes"),y(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(R,"href","#assembleur-de-donnes"),y(g,"class","relative group"),y(q,"id","entraner-le-modle"),y(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(q,"href","#entraner-le-modle"),y(k,"class","relative group"),y(H,"id","infrence"),y(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(H,"href","#infrence"),y(_,"class","relative group")},m(e,t){h(document.head,w),l(e,F,t),l(e,j,t),l(e,ns,t),l(e,f,t),h(f,V),h(V,Js),c(S,Js,null),h(f,On),h(f,as),l(e,Zs,t),l(e,L,t),l(e,gs,t),l(e,b,t),h(b,B),h(B,hs),c(P,hs,null),h(b,ea),h(b,rs),l(e,ks,t),c(D,e,t),l(e,_s,t),c(W,e,t),l(e,Vs,t),l(e,K,t),l(e,Bs,t),c(O,e,t),l(e,Ws,t),l(e,ee,t),l(e,Gs,t),c(te,e,t),l(e,zs,t),l(e,v,t),h(v,G),h(G,Ts),c(se,Ts,null),h(v,ta),h(v,ps),l(e,Ns,t),l(e,le,t),l(e,Xs,t),l(e,ne,t),l(e,As,t),l(e,ae,t),l(e,Ys,t),c(re,e,t),l(e,Es,t),l(e,pe,t),l(e,Qs,t),c(ie,e,t),l(e,Rs,t),l(e,oe,t),l(e,qs,t),c(ue,e,t),l(e,Hs,t),l(e,C,t),h(C,z),h(z,ws),c(ce,ws,null),h(C,sa),h(C,is),l(e,Fs,t),l(e,Me,t),l(e,Ss,t),c(de,e,t),l(e,Ls,t),l(e,I,t),h(I,N),h(N,js),c(me,js,null),h(I,la),h(I,os),l(e,Ps,t),l(e,ye,t),l(e,Ds,t),c(Je,e,t),l(e,Ks,t),l(e,he,t),l(e,Os,t),c(Te,e,t),l(e,el,t),l(e,we,t),l(e,tl,t),c(je,e,t),l(e,sl,t),l(e,Ue,t),l(e,ll,t),l(e,fe,t),l(e,nl,t),l(e,be,t),l(e,al,t),c(ve,e,t),l(e,rl,t),l(e,Ce,t),l(e,pl,t),c(Ie,e,t),l(e,il,t),l(e,$e,t),l(e,ol,t),c(xe,e,t),l(e,ul,t),l(e,Ze,t),l(e,cl,t),c(ge,e,t),l(e,Ml,t),l(e,ke,t),l(e,dl,t),l(e,$,t),h($,X),h(X,Us),c(_e,Us,null),h($,na),h($,us),l(e,ml,t),l(e,Ve,t),l(e,yl,t),c(Be,e,t),l(e,Jl,t),l(e,We,t),l(e,hl,t),c(Ge,e,t),l(e,Tl,t),l(e,A,t),l(e,wl,t),l(e,ze,t),l(e,jl,t),c(Ne,e,t),l(e,Ul,t),l(e,Xe,t),l(e,fl,t),c(Ae,e,t),l(e,bl,t),l(e,Ye,t),l(e,vl,t),c(Ee,e,t),l(e,Cl,t),l(e,Qe,t),l(e,Il,t),c(Re,e,t),l(e,$l,t),l(e,qe,t),l(e,xl,t),c(He,e,t),l(e,Zl,t),l(e,Fe,t),l(e,gl,t),l(e,Se,t),l(e,kl,t),l(e,x,t),h(x,Y),h(Y,fs),c(Le,fs,null),h(x,aa),h(x,cs),l(e,_l,t),l(e,Pe,t),l(e,Vl,t),l(e,De,t),l(e,Bl,t),c(Ke,e,t),l(e,Wl,t),l(e,Oe,t),l(e,Gl,t),l(e,et,t),l(e,zl,t),l(e,Z,t),h(Z,E),h(E,bs),c(tt,bs,null),h(Z,ra),h(Z,Ms),l(e,Nl,t),l(e,st,t),l(e,Xl,t),c(lt,e,t),l(e,Al,t),l(e,nt,t),l(e,Yl,t),c(at,e,t),l(e,El,t),l(e,rt,t),l(e,Ql,t),c(pt,e,t),l(e,Rl,t),l(e,it,t),l(e,ql,t),c(ot,e,t),l(e,Hl,t),l(e,ut,t),l(e,Fl,t),c(ct,e,t),l(e,Sl,t),l(e,Mt,t),l(e,Ll,t),c(dt,e,t),l(e,Pl,t),l(e,Q,t),l(e,Dl,t),l(e,mt,t),l(e,Kl,t),l(e,yt,t),l(e,Ol,t),c(Jt,e,t),l(e,en,t),l(e,ht,t),l(e,tn,t),c(Tt,e,t),l(e,sn,t),l(e,wt,t),l(e,ln,t),c(jt,e,t),l(e,nn,t),l(e,Ut,t),l(e,an,t),c(ft,e,t),l(e,rn,t),l(e,g,t),h(g,R),h(R,vs),c(bt,vs,null),h(g,pa),h(g,ds),l(e,pn,t),l(e,vt,t),l(e,on,t),c(Ct,e,t),l(e,un,t),l(e,It,t),l(e,cn,t),c($t,e,t),l(e,Mn,t),l(e,k,t),h(k,q),h(q,Cs),c(xt,Cs,null),h(k,ia),h(k,ms),l(e,dn,t),l(e,Zt,t),l(e,mn,t),c(gt,e,t),l(e,yn,t),l(e,kt,t),l(e,Jn,t),c(_t,e,t),l(e,hn,t),l(e,Vt,t),l(e,Tn,t),c(Bt,e,t),l(e,wn,t),l(e,Wt,t),l(e,jn,t),c(Gt,e,t),l(e,Un,t),l(e,zt,t),l(e,fn,t),c(Nt,e,t),l(e,bn,t),l(e,Xt,t),l(e,vn,t),c(At,e,t),l(e,Cn,t),l(e,_,t),h(_,H),h(H,Is),c(Yt,Is,null),h(_,oa),h(_,ys),l(e,In,t),l(e,Et,t),l(e,$n,t),c(Qt,e,t),l(e,xn,t),l(e,Rt,t),l(e,Zn,t),c(qt,e,t),l(e,gn,t),l(e,Ht,t),l(e,kn,t),c(Ft,e,t),l(e,_n,t),l(e,St,t),l(e,Vn,t),c(Lt,e,t),l(e,Bn,t),l(e,Pt,t),l(e,Wn,t),c(Dt,e,t),l(e,Gn,t),l(e,Kt,t),l(e,zn,t),c(Ot,e,t),l(e,Nn,t),l(e,es,t),l(e,Xn,t),l(e,ts,t),l(e,An,t),l(e,ss,t),l(e,Yn,t),l(e,$s,t),En=!0},p(e,[t]){const ls={};t&2&&(ls.$$scope={dirty:t,ctx:e}),W.$set(ls)},i(e){En||(M(S.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(W.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(re.$$.fragment,e),M(ie.$$.fragment,e),M(ue.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(me.$$.fragment,e),M(Je.$$.fragment,e),M(Te.$$.fragment,e),M(je.$$.fragment,e),M(ve.$$.fragment,e),M(Ie.$$.fragment,e),M(xe.$$.fragment,e),M(ge.$$.fragment,e),M(_e.$$.fragment,e),M(Be.$$.fragment,e),M(Ge.$$.fragment,e),M(Ne.$$.fragment,e),M(Ae.$$.fragment,e),M(Ee.$$.fragment,e),M(Re.$$.fragment,e),M(He.$$.fragment,e),M(Le.$$.fragment,e),M(Ke.$$.fragment,e),M(tt.$$.fragment,e),M(lt.$$.fragment,e),M(at.$$.fragment,e),M(pt.$$.fragment,e),M(ot.$$.fragment,e),M(ct.$$.fragment,e),M(dt.$$.fragment,e),M(Jt.$$.fragment,e),M(Tt.$$.fragment,e),M(jt.$$.fragment,e),M(ft.$$.fragment,e),M(bt.$$.fragment,e),M(Ct.$$.fragment,e),M($t.$$.fragment,e),M(xt.$$.fragment,e),M(gt.$$.fragment,e),M(_t.$$.fragment,e),M(Bt.$$.fragment,e),M(Gt.$$.fragment,e),M(Nt.$$.fragment,e),M(At.$$.fragment,e),M(Yt.$$.fragment,e),M(Qt.$$.fragment,e),M(qt.$$.fragment,e),M(Ft.$$.fragment,e),M(Lt.$$.fragment,e),M(Dt.$$.fragment,e),M(Ot.$$.fragment,e),En=!0)},o(e){d(S.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(W.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(ie.$$.fragment,e),d(ue.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(Je.$$.fragment,e),d(Te.$$.fragment,e),d(je.$$.fragment,e),d(ve.$$.fragment,e),d(Ie.$$.fragment,e),d(xe.$$.fragment,e),d(ge.$$.fragment,e),d(_e.$$.fragment,e),d(Be.$$.fragment,e),d(Ge.$$.fragment,e),d(Ne.$$.fragment,e),d(Ae.$$.fragment,e),d(Ee.$$.fragment,e),d(Re.$$.fragment,e),d(He.$$.fragment,e),d(Le.$$.fragment,e),d(Ke.$$.fragment,e),d(tt.$$.fragment,e),d(lt.$$.fragment,e),d(at.$$.fragment,e),d(pt.$$.fragment,e),d(ot.$$.fragment,e),d(ct.$$.fragment,e),d(dt.$$.fragment,e),d(Jt.$$.fragment,e),d(Tt.$$.fragment,e),d(jt.$$.fragment,e),d(ft.$$.fragment,e),d(bt.$$.fragment,e),d(Ct.$$.fragment,e),d($t.$$.fragment,e),d(xt.$$.fragment,e),d(gt.$$.fragment,e),d(_t.$$.fragment,e),d(Bt.$$.fragment,e),d(Gt.$$.fragment,e),d(Nt.$$.fragment,e),d(At.$$.fragment,e),d(Yt.$$.fragment,e),d(Qt.$$.fragment,e),d(qt.$$.fragment,e),d(Ft.$$.fragment,e),d(Lt.$$.fragment,e),d(Dt.$$.fragment,e),d(Ot.$$.fragment,e),En=!1},d(e){e&&(s(F),s(j),s(ns),s(f),s(Zs),s(L),s(gs),s(b),s(ks),s(_s),s(Vs),s(K),s(Bs),s(Ws),s(ee),s(Gs),s(zs),s(v),s(Ns),s(le),s(Xs),s(ne),s(As),s(ae),s(Ys),s(Es),s(pe),s(Qs),s(Rs),s(oe),s(qs),s(Hs),s(C),s(Fs),s(Me),s(Ss),s(Ls),s(I),s(Ps),s(ye),s(Ds),s(Ks),s(he),s(Os),s(el),s(we),s(tl),s(sl),s(Ue),s(ll),s(fe),s(nl),s(be),s(al),s(rl),s(Ce),s(pl),s(il),s($e),s(ol),s(ul),s(Ze),s(cl),s(Ml),s(ke),s(dl),s($),s(ml),s(Ve),s(yl),s(Jl),s(We),s(hl),s(Tl),s(A),s(wl),s(ze),s(jl),s(Ul),s(Xe),s(fl),s(bl),s(Ye),s(vl),s(Cl),s(Qe),s(Il),s($l),s(qe),s(xl),s(Zl),s(Fe),s(gl),s(Se),s(kl),s(x),s(_l),s(Pe),s(Vl),s(De),s(Bl),s(Wl),s(Oe),s(Gl),s(et),s(zl),s(Z),s(Nl),s(st),s(Xl),s(Al),s(nt),s(Yl),s(El),s(rt),s(Ql),s(Rl),s(it),s(ql),s(Hl),s(ut),s(Fl),s(Sl),s(Mt),s(Ll),s(Pl),s(Q),s(Dl),s(mt),s(Kl),s(yt),s(Ol),s(en),s(ht),s(tn),s(sn),s(wt),s(ln),s(nn),s(Ut),s(an),s(rn),s(g),s(pn),s(vt),s(on),s(un),s(It),s(cn),s(Mn),s(k),s(dn),s(Zt),s(mn),s(yn),s(kt),s(Jn),s(hn),s(Vt),s(Tn),s(wn),s(Wt),s(jn),s(Un),s(zt),s(fn),s(bn),s(Xt),s(vn),s(Cn),s(_),s(In),s(Et),s($n),s(xn),s(Rt),s(Zn),s(gn),s(Ht),s(kn),s(_n),s(St),s(Vn),s(Bn),s(Pt),s(Wn),s(Gn),s(Kt),s(zn),s(Nn),s(es),s(Xn),s(ts),s(An),s(ss),s(Yn),s($s)),s(w),m(S),m(P),m(D,e),m(W,e),m(O,e),m(te,e),m(se),m(re,e),m(ie,e),m(ue,e),m(ce),m(de,e),m(me),m(Je,e),m(Te,e),m(je,e),m(ve,e),m(Ie,e),m(xe,e),m(ge,e),m(_e),m(Be,e),m(Ge,e),m(Ne,e),m(Ae,e),m(Ee,e),m(Re,e),m(He,e),m(Le),m(Ke,e),m(tt),m(lt,e),m(at,e),m(pt,e),m(ot,e),m(ct,e),m(dt,e),m(Jt,e),m(Tt,e),m(jt,e),m(ft,e),m(bt),m(Ct,e),m($t,e),m(xt),m(gt,e),m(_t,e),m(Bt,e),m(Gt,e),m(Nt,e),m(At,e),m(Yt),m(Qt,e),m(qt,e),m(Ft,e),m(Lt,e),m(Dt,e),m(Ot,e)}}}const ip={local:"finetuning-du-speecht5",sections:[{local:"prparation",title:"Préparation"},{local:"le-jeu-de-donnes",title:"Le jeu de données"},{local:"prtraitement-des-donnes",sections:[{local:"nettoyage-du-texte-pour-la-tokenisation-de-speecht5",title:"Nettoyage du texte pour la tokenisation de SpeechT5"},{local:"les-locuteurs",title:"Les locuteurs"},{local:"enchssement-des-locuteurs",title:"Enchâssement des locuteurs"},{local:"traitement-du-jeu-de-donnes",title:"Traitement du jeu de données"},{local:"assembleur-de-donnes",title:"Assembleur de données"}],title:"Prétraitement des données "},{local:"entraner-le-modle",title:"Entraîner le modèle"},{local:"infrence",title:"Inférence"}],title:"Finetuning du SpeechT5"};function op(xs){return Kr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yp extends ep{constructor(w){super(),tp(this,w,op,pp,Dr,{})}}export{yp as component};
