import{s as De,n as Pe,o as Ke}from"../chunks/scheduler.f7e1785c.js";import{S as Oe,i as el,g as M,s as n,u,A as ll,h as i,f as s,c as a,j as P,v as p,y as o,k as H,o as K,a as t,w as r,d as c,t as d,x as j}from"../chunks/index.815a732f.js";import{I as sl}from"../chunks/IconCopyLink.e7937f56.js";import{C as m}from"../chunks/CodeBlock.c6e8b464.js";function tl(Ge){let y,O,V,ee,U,h,L,T,ke,X,$e="Charger et explorer un jeu de données audio",le,w,xe=`Dans ce cours, nous utiliserons la bibliothèque 🤗 <em>Datasets</em> pour travailler avec des jeux de données audio.
🤗 <em>Datasets</em> est une bibliothèque open-source permettant de télécharger et de préparer des jeux de données à partir de toutes les modalités, y compris l’audio.
La bibliothèque offre un accès facile à une sélection inégalée de jeux de données d’apprentissage automatique accessibles sur Hugging Face Hub.
De plus, 🤗 <em>Datasets</em> comprend de multiples fonctionnalités adaptées aux jeux de données audio simplifiant le travail avec de tels jeux de données pour les chercheurs et les praticiens.
Pour commencer à utiliser des jeux de données audio, assurez-vous que la 🤗 <em>Datasets</em> est installée :`,se,b,te,A,Ee=`L’une des principales caractéristiques déterminantes de 🤗 <em>Datasets</em>  est la possibilité de télécharger et de préparer un jeu de données en une seule ligne de code Python à l’aide de la fonction <code>load_dataset()</code>.
Chargeons et explorons un jeu de données audio appelé <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, qui contient des enregistrements de personnes posant des questions à un système bancaire électronique dans plusieurs langues et dialectes.
Pour charger le jeu de données MINDS-14, nous devons copier l’identifiant du jeu de données sur le Hub (<code>PolyAI/minds14</code>) et le transmettre à la fonction <code>load_dataset</code>.
Nous préciserons également que nous ne nous intéressons qu’au sous-ensemble australien (‘en-AU’) des données, et le limiterons à la division de l’entraînement :`,ne,f,ae,C,Ze="<strong>Sortie :</strong>",Me,I,ie,g,Be=`Le jeu de données contient 654 fichiers audio, chacun étant accompagné d’une transcription, d’une traduction en anglais et d’une étiquette indiquant l’intention derrière la requête de la personne.
La colonne audio contient les données audio brutes. Examinons de plus près l’un des exemples:`,oe,v,ue,q,Qe="<strong>Sortie :</strong>",pe,k,re,G,We="Vous remarquerez peut-être que la colonne audio contient plusieurs caractéristiques :",ce,$,_e=`<li><code>path</code> : le chemin d’accès au fichier audio (<code>*.wav</code> dans ce cas).</li> <li><code>array</code>: les données audio décodées, représentées sous la forme d’un tableau NumPy à 1 dimension.</li> <li><code>sampling_rate</code> : taux d’échantillonnage du fichier audio (8 000 Hz dans cet exemple).
Le <code>intent_class</code> est une catégorie de classification de l’enregistrement audio. Pour convertir ce nombre en une chaîne significative, nous pouvons utiliser la méthode <code>int2str()</code>:</li>`,de,x,je,E,Re="<strong>Sortie :</strong>",me,Z,ye,B,ze=`Si vous regardez la fonction de transcription, vous pouvez voir que le fichier audio a effectivement enregistré une personne posant une question sur le paiement d’une facture.
Si vous envisagez d’entraîner un classifieur audio sur ce sous-ensemble de données, vous n’aurez pas nécessairement besoin de toutes les caractéristiques.
Par exemple, le <code>lang_id</code> aura la même valeur pour tous les exemples et ne sera pas utile.
Les <code>english_transcription</code> dupliqueront probablement la <code>transcription</code> de ce sous-ensemble, afin que nous puissions les supprimer en toute sécurité.`,Ue,Q,Se="Vous pouvez facilement supprimer les caractéristiques non pertinentes à l’aide de la méthode <code>remove_columns</code> de 🤗 <em>Datasets</em> :",he,W,Je,_,Fe="<strong>Sortie :</strong>",Te,R,we,z,Ye="Maintenant que nous avons chargé et inspecté le contenu brut du jeu de données, écoutons quelques exemples ! Nous utiliserons les fonctionnalités <code>Blocs</code> et <code>Audio</code> de <em>Gradio</em> pour décoder quelques échantillons aléatoires du jeu de données:",be,S,Ae,F,Ne="Si vous le souhaitez, vous pouvez également visualiser certains des exemples. Traçons la forme d’onde pour le premier exemple.",fe,Y,Ce,J,He='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',Ie,N,Xe=`Essayez ! Téléchargez un autre dialecte ou une autre langue du jeu de données MINDS-14, écoutez et visualisez quelques exemples pour avoir une idée des variations du jeu de données.
Vous pouvez trouver la liste complète des langues disponibles <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">ici</a>.`,ge,D,ve;return T=new sl({}),b=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]"}}),f=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`}}),I=new m({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`}}),v=new m({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`}}),k=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`}}),x=new m({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`}}),Z=new m({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>'}}),W=new m({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`}}),R=new m({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>'}}),S=new m({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`}}),Y=new m({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`}}),{c(){y=M("meta"),O=n(),V=M("p"),ee=n(),U=M("h1"),h=M("a"),L=M("span"),u(T.$$.fragment),ke=n(),X=M("span"),X.textContent=$e,le=n(),w=M("p"),w.innerHTML=xe,se=n(),u(b.$$.fragment),te=n(),A=M("p"),A.innerHTML=Ee,ne=n(),u(f.$$.fragment),ae=n(),C=M("p"),C.innerHTML=Ze,Me=n(),u(I.$$.fragment),ie=n(),g=M("p"),g.textContent=Be,oe=n(),u(v.$$.fragment),ue=n(),q=M("p"),q.innerHTML=Qe,pe=n(),u(k.$$.fragment),re=n(),G=M("p"),G.textContent=We,ce=n(),$=M("ul"),$.innerHTML=_e,de=n(),u(x.$$.fragment),je=n(),E=M("p"),E.innerHTML=Re,me=n(),u(Z.$$.fragment),ye=n(),B=M("p"),B.innerHTML=ze,Ue=n(),Q=M("p"),Q.innerHTML=Se,he=n(),u(W.$$.fragment),Je=n(),_=M("p"),_.innerHTML=Fe,Te=n(),u(R.$$.fragment),we=n(),z=M("p"),z.innerHTML=Ye,be=n(),u(S.$$.fragment),Ae=n(),F=M("p"),F.textContent=Ne,fe=n(),u(Y.$$.fragment),Ce=n(),J=M("div"),J.innerHTML=He,Ie=n(),N=M("p"),N.innerHTML=Xe,ge=n(),D=M("p"),this.h()},l(e){const l=ll("svelte-1phssyn",document.head);y=i(l,"META",{name:!0,content:!0}),l.forEach(s),O=a(e),V=i(e,"P",{}),P(V).forEach(s),ee=a(e),U=i(e,"H1",{class:!0});var qe=P(U);h=i(qe,"A",{id:!0,class:!0,href:!0});var Ve=P(h);L=i(Ve,"SPAN",{});var Le=P(L);p(T.$$.fragment,Le),Le.forEach(s),Ve.forEach(s),ke=a(qe),X=i(qe,"SPAN",{"data-svelte-h":!0}),o(X)!=="svelte-umzhx"&&(X.textContent=$e),qe.forEach(s),le=a(e),w=i(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-18l4dc2"&&(w.innerHTML=xe),se=a(e),p(b.$$.fragment,e),te=a(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-19ww6hu"&&(A.innerHTML=Ee),ne=a(e),p(f.$$.fragment,e),ae=a(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-dbzevp"&&(C.innerHTML=Ze),Me=a(e),p(I.$$.fragment,e),ie=a(e),g=i(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1dg8v72"&&(g.textContent=Be),oe=a(e),p(v.$$.fragment,e),ue=a(e),q=i(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-dbzevp"&&(q.innerHTML=Qe),pe=a(e),p(k.$$.fragment,e),re=a(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1p7dink"&&(G.textContent=We),ce=a(e),$=i(e,"UL",{"data-svelte-h":!0}),o($)!=="svelte-1hxtpp7"&&($.innerHTML=_e),de=a(e),p(x.$$.fragment,e),je=a(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-dbzevp"&&(E.innerHTML=Re),me=a(e),p(Z.$$.fragment,e),ye=a(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-19cohpx"&&(B.innerHTML=ze),Ue=a(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-hekgx8"&&(Q.innerHTML=Se),he=a(e),p(W.$$.fragment,e),Je=a(e),_=i(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-dbzevp"&&(_.innerHTML=Fe),Te=a(e),p(R.$$.fragment,e),we=a(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-rbxail"&&(z.innerHTML=Ye),be=a(e),p(S.$$.fragment,e),Ae=a(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-11t53jt"&&(F.textContent=Ne),fe=a(e),p(Y.$$.fragment,e),Ce=a(e),J=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-1ym6zda"&&(J.innerHTML=He),Ie=a(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-big3u0"&&(N.innerHTML=Xe),ge=a(e),D=i(e,"P",{}),P(D).forEach(s),this.h()},h(){H(y,"name","hf:doc:metadata"),H(y,"content",JSON.stringify(nl)),H(h,"id","charger-et-explorer-un-jeu-de-donnes-audio"),H(h,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),H(h,"href","#charger-et-explorer-un-jeu-de-donnes-audio"),H(U,"class","relative group"),H(J,"class","flex justify-center")},m(e,l){K(document.head,y),t(e,O,l),t(e,V,l),t(e,ee,l),t(e,U,l),K(U,h),K(h,L),r(T,L,null),K(U,ke),K(U,X),t(e,le,l),t(e,w,l),t(e,se,l),r(b,e,l),t(e,te,l),t(e,A,l),t(e,ne,l),r(f,e,l),t(e,ae,l),t(e,C,l),t(e,Me,l),r(I,e,l),t(e,ie,l),t(e,g,l),t(e,oe,l),r(v,e,l),t(e,ue,l),t(e,q,l),t(e,pe,l),r(k,e,l),t(e,re,l),t(e,G,l),t(e,ce,l),t(e,$,l),t(e,de,l),r(x,e,l),t(e,je,l),t(e,E,l),t(e,me,l),r(Z,e,l),t(e,ye,l),t(e,B,l),t(e,Ue,l),t(e,Q,l),t(e,he,l),r(W,e,l),t(e,Je,l),t(e,_,l),t(e,Te,l),r(R,e,l),t(e,we,l),t(e,z,l),t(e,be,l),r(S,e,l),t(e,Ae,l),t(e,F,l),t(e,fe,l),r(Y,e,l),t(e,Ce,l),t(e,J,l),t(e,Ie,l),t(e,N,l),t(e,ge,l),t(e,D,l),ve=!0},p:Pe,i(e){ve||(c(T.$$.fragment,e),c(b.$$.fragment,e),c(f.$$.fragment,e),c(I.$$.fragment,e),c(v.$$.fragment,e),c(k.$$.fragment,e),c(x.$$.fragment,e),c(Z.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(S.$$.fragment,e),c(Y.$$.fragment,e),ve=!0)},o(e){d(T.$$.fragment,e),d(b.$$.fragment,e),d(f.$$.fragment,e),d(I.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(x.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(S.$$.fragment,e),d(Y.$$.fragment,e),ve=!1},d(e){e&&(s(O),s(V),s(ee),s(U),s(le),s(w),s(se),s(te),s(A),s(ne),s(ae),s(C),s(Me),s(ie),s(g),s(oe),s(ue),s(q),s(pe),s(re),s(G),s(ce),s($),s(de),s(je),s(E),s(me),s(ye),s(B),s(Ue),s(Q),s(he),s(Je),s(_),s(Te),s(we),s(z),s(be),s(Ae),s(F),s(fe),s(Ce),s(J),s(Ie),s(N),s(ge),s(D)),s(y),j(T),j(b,e),j(f,e),j(I,e),j(v,e),j(k,e),j(x,e),j(Z,e),j(W,e),j(R,e),j(S,e),j(Y,e)}}}const nl={local:"charger-et-explorer-un-jeu-de-donnes-audio",title:"Charger et explorer un jeu de données audio"};function al(Ge){return Ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pl extends Oe{constructor(y){super(),el(this,y,al,tl,De,{})}}export{pl as component};
