import{s as Ot,o as Kt}from"../chunks/scheduler.f7e1785c.js";import{S as es,i as ts,g as r,s as l,u as p,A as ss,h as o,f as s,c as a,j as f,v as d,y as i,k as u,o as c,a as n,w as M,d as m,t as h,x as j,m as ns,n as ls}from"../chunks/index.815a732f.js";import{T as as}from"../chunks/Tip.1258ac78.js";import{I as mt}from"../chunks/IconCopyLink.e7937f56.js";import{C as J}from"../chunks/CodeBlock.c6e8b464.js";function rs(be){let y;return{c(){y=ns(`💡 Quelques informations sur le rééchantillonnage: Si un signal audio a été échantillonné à 8 kHz, de sorte qu'il a 8000 lectures d'échantillon par seconde, nous savons que l'audio ne contient aucune fréquence supérieure à 4 kHz. 
Ceci est garanti par le théorème d'échantillonnage de Nyquist. Pour cette raison, nous pouvons être certains qu'entre les points d'échantillonnage, le signal continu d'origine fait toujours une courbe lisse.
L'augmentation du prélèvement vers un taux d'échantillonnage plus élevé consiste alors à calculer des valeurs d'échantillonnage supplémentaires qui se situent entre les valeurs existantes, en approximant cette courbe. 
Le sous-échantillonnage, cependant, nécessite que nous filtrons d'abord toutes les fréquences qui seraient supérieures à la nouvelle limite de Nyquist, avant d'estimer les nouveaux points d'échantillonnage. 
En d'autres termes, vous ne pouvez pas sous-échantillonner d'un facteur 2x en jetant simplement tous les autres échantillons - cela créera des distorsions dans le signal appelées alias. 
Faire un rééchantillonnage correct est délicat et mieux laissé à des bibliothèques bien testées telles que librosa ou 🤗 *Datasets*.`)},l(T){y=ls(T,`💡 Quelques informations sur le rééchantillonnage: Si un signal audio a été échantillonné à 8 kHz, de sorte qu'il a 8000 lectures d'échantillon par seconde, nous savons que l'audio ne contient aucune fréquence supérieure à 4 kHz. 
Ceci est garanti par le théorème d'échantillonnage de Nyquist. Pour cette raison, nous pouvons être certains qu'entre les points d'échantillonnage, le signal continu d'origine fait toujours une courbe lisse.
L'augmentation du prélèvement vers un taux d'échantillonnage plus élevé consiste alors à calculer des valeurs d'échantillonnage supplémentaires qui se situent entre les valeurs existantes, en approximant cette courbe. 
Le sous-échantillonnage, cependant, nécessite que nous filtrons d'abord toutes les fréquences qui seraient supérieures à la nouvelle limite de Nyquist, avant d'estimer les nouveaux points d'échantillonnage. 
En d'autres termes, vous ne pouvez pas sous-échantillonner d'un facteur 2x en jetant simplement tous les autres échantillons - cela créera des distorsions dans le signal appelées alias. 
Faire un rééchantillonnage correct est délicat et mieux laissé à des bibliothèques bien testées telles que librosa ou 🤗 *Datasets*.`)},m(T,$){n(T,y,$)},d(T){T&&s(y)}}}function os(be){let y,T,$,ge,U,g,Je,_,ht,he,Jt="Prétraitement d'un jeu de données audio",Ce,B,Tt=`Le chargement d’un jeu de données avec 🤗 <em>Datasets</em> n’est que la moitié du plaisir.
Si vous prévoyez de l’utiliser pour entraîner un modèle ou pour exécuter l’inférence, vous devrez d’abord prétraiter les données. En général, cela impliquera les étapes suivantes:`,Ae,k,Ut="<li>Rééchantillonnage des données audio</li> <li>Filtrage du jeu de données</li> <li>Conversion des données audio en entrée attendue du modèle</li>",Ie,v,C,Te,z,jt,je,vt="Rééchantillonnage des données audio",qe,R,wt=`La fonction <code>load_dataset</code> télécharge des exemples audio avec le taux d’échantillonnage avec lequel ils ont été publiés.
Ce n’est pas toujours le taux d’échantillonnage attendu par un modèle que vous prévoyez d’entraîner ou d’utiliser pour l’inférence.
S’il existe un écart entre les taux d’échantillonnage, vous pouvez rééchantillonner l’audio à la fréquence d’échantillonnage attendue du modèle.
La plupart des modèles pré-entraînés disponibles ont été pré-entraînés sur des jeux de données audio à une fréquence d’échantillonnage de 16 kHz.
Lorsque nous avons exploré le jeu de données MINDS-14, vous avez peut-être remarqué qu’il est échantillonné à 8 kHz, ce qui signifie que nous devrons probablement le suréchantillonner.
Pour ce faire, utilisez la méthode <code>cast_column</code> de 🤗 Datasets.
Cette opération ne modifie pas l’audio sur place, mais plutôt les signaux aux jeux de données pour rééchantillonner les exemples audio à la volée lorsqu’ils sont chargés.
Le code suivant définira la fréquence d’échantillonnage à 16 kHz :`,xe,G,$e,Z,bt="Rechargez le premier exemple audio dans le jeu de données MINDS-14 et vérifiez qu’il a été rééchantillonné à la « fréquence d’échantillonnage » souhaitée :",_e,N,Be,V,gt="<strong>Sortie :</strong>",ke,W,ze,E,Ct="Vous remarquerez peut-être que les valeurs de tableau sont maintenant également différentes. C’est parce que nous avons maintenant deux fois plus de valeurs d’amplitude pour chacune d’entre elles que nous avions auparavant.",Re,A,Ge,w,I,Ue,H,yt,ye,At="Filtrage du jeu de données",Ze,X,It=`Vous devrez peut-être filtrer les données en fonction de certains critères. L’un des cas courants consiste à limiter les exemples audio à une certaine durée.
Par exemple, nous pourrions vouloir filtrer tous les exemples de plus de 20 secondes pour éviter les erreurs de mémoire insuffisante lors de l’entraînement d’un modèle.
Nous pouvons le faire en utilisant la  méthode <code>filter</code> de 🤗 <em>Datasets</em> et en lui passant une fonction avec une logique de filtrage. Commençons par écrire une fonction qui indique quels exemples conserver et lesquels rejeter.
Cette fonction, <code>is_audio_length_in_range&#39;, renvoie </code>True<code>si un échantillon est inférieur à 20s et</code>False\` s’il est plus long que 20s.`,Ne,Y,Ve,Q,qt=`La fonction de filtrage peut être appliquée à la colonne d’un jeu de données, mais nous n’avons pas de colonne avec une durée de piste audio dans ce jeu de données.
Cependant, nous pouvons en créer un, filtrer en fonction des valeurs de cette colonne, puis le supprimer.`,We,S,Ee,L,xt="<strong>Sortie :</strong>",He,F,Xe,D,$t="Nous pouvons vérifier que le jeu de données a été filtré de 654 exemples à 624.",Ye,b,q,ve,P,ft,fe,_t="Prétraitement des données audio",Qe,O,Bt=`L’un des aspects les plus difficiles de l’utilisation d’ensembles de données audio consiste à préparer les données dans le bon format pour la formation des modèles.
Comme vous l’avez vu, les données audio brutes se présentent sous la forme d’un tableau de valeurs d’échantillon.
Cependant, les modèles pré-entraînés, que vous les utilisiez pour l’inférence ou que vous souhaitiez les finetuner pour votre tâche, s’attendent à ce que les données brutes soient converties en fonctionnalités d’entrée.
Les exigences pour les caractéristiques d’entrée peuvent varier d’un modèle à l’autre. Elles dépendent de l’architecture du modèle et des données avec lesquelles il a été pré-entraîné.
La bonne nouvelle est que, pour chaque modèle audio pris en charge, 🤗 <em>Transformers</em> offrent une classe d’extracteur de caractéristiques qui peut convertir les données audio brutes en caractéristiques d’entrée attendues par le modèle.`,Se,K,kt=`Alors, que fait un extracteur de caractéristiques avec les données audio brutes ? Jetons un coup d’œil à l’extracteur de caractéristiques de <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper</a> pour comprendre certaines transformations d’extraction de caractéristiques courantes.
Whisper est un modèle pré-entraîné pour la reconnaissance vocale automatique (ASR) publié en septembre 2022 par Alec Radford et al. d’OpenAI.
Tout d’abord, l’extracteur de fonction Whisper pave / tronque un batch d’exemples audio de sorte que tous les exemples ont une longueur d’entrée de 30s.
Les exemples plus courts sont complétés à 30s en ajoutant des zéros à la fin de la séquence (les zéros dans un signal audio correspondent à l’absence de signal ou au silence). Les exemples de plus de 30 ans sont tronqués à 30 s.
Étant donné que tous les éléments du batch sont rembourrés/tronqués à une longueur maximale dans l’espace d’entrée, il n’y a pas besoin d’un masque d’attention.
Whisper est unique à cet égard, la plupart des autres modèles audio nécessitent un masque d’attention qui détaille où les séquences ont été rembourrées, et donc où elles doivent être ignorées dans le mécanisme d’auto-attention.
Whisper est entraîné pour fonctionner sans masque d’attention et déduire directement des signaux vocaux où ignorer les entrées.
La deuxième opération effectuée par l’extracteur de fonctions Whisper consiste à convertir les matrices audio rembourrées en spectrogrammes log-mel.
Ces spectrogrammes décrivent comment les fréquences d’un signal changent au fil du temps, exprimées sur l’échelle mel et mesurées en décibels (la partie log) pour rendre les fréquences et les amplitudes plus représentatives de l’audition humaine.
Toutes ces transformations peuvent être appliquées à vos données audio brutes avec quelques lignes de code.
Allons de l’avant et chargeons l’extracteur de caractéristiques à partir du <em>checkpoint</em> de Whisper pré-entraîné pour être prêt pour nos données audio:`,Le,ee,Fe,te,zt="Ensuite, vous pouvez écrire une fonction pour pré-traiter un seul exemple audio en le faisant passer par le <code>feature_extractor</code>.",De,se,Pe,ne,Rt="Nous pouvons appliquer la fonction de préparation des données à tous nos exemples d’entraînement en utilisant la méthode <code>map</code> de 🤗 <em>Datasets</em> :",Oe,le,Ke,ae,Gt="<strong>Sortie :</strong>",et,re,tt,oe,Zt=`Aussi simple que cela, nous avons maintenant des spectrogrammes log-mel comme <code>input_features</code> dans le jeu de données.
Visualisons-le pour l’un des exemples de <code>minds</code> :`,st,ie,nt,x,Nt='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',lt,ue,Vt="Vous pouvez maintenant voir à quoi ressemble l’entrée audio du modèle Whisper après le prétraitement.",at,pe,Wt=`La classe d’extracteur de caractéristiques du modèle se charge de transformer les données audio brutes au format attendu par le modèle. Cependant, de nombreuses tâches impliquant l’audio sont multimodales, par exemple la reconnaissance vocale.
Dans de tels cas, 🤗 <em>Transformers</em> offrent également des tokeniseurs spécifiques au modèle pour traiter les entrées de texte. Pour une plongée approfondie dans les tokeniseurs, veuillez vous référer à notre <a href="https://huggingface.co/learn/nlp-course/fr/chapter2/4" rel="nofollow">cours de NLP</a>.`,rt,de,Et=`Vous pouvez charger séparément l’extracteur de caractéristiques et le tokeniseur pour Whisper et d’autres modèles multimodaux, ou vous pouvez charger les deux via un processeur.
Pour rendre les choses encore plus simples, utilisez <code>AutoProcessor</code> pour charger l’extracteur de caractéristiques et le processeur d’un modèle à partir d’un <em>checkpoint</em>, comme ceci :`,ot,ce,it,Me,Ht=`Nous avons illustré ici les étapes fondamentales de préparation des données. Bien entendu, les données personnalisées peuvent nécessiter un prétraitement plus complexe.
Dans ce cas, vous pouvez étendre la fonction <code>prepare_dataset</code> pour effectuer n’importe quel type de transformations de données personnalisées.
Avec 🤗 <em>Datasets</em>, si vous pouvez l’écrire en tant que fonction Python, vous pouvez l’appliquer à votre jeu de données !`,ut,we,pt;return _=new mt({}),z=new mt({}),G=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`}}),N=new J({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]'}}),W=new J({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RCUwQQ==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}
`}}),A=new as({props:{$$slots:{default:[rs]},$$scope:{ctx:be}}}),H=new mt({}),Y=new J({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`}}),S=new J({props:{code:"JTIzJTIwVXRpbGlzZXolMjBsaWJyb3NhJTIwcG91ciUyMG9idGVuaXIlMjBsYSUyMGR1ciVDMyVBOWUlMjBkZSUyMGwnZXhlbXBsZSUyMCVDMyVBMCUyMHBhcnRpciUyMGR1JTIwZmljaGllciUyMGF1ZGlvJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKHBhdGglM0R4KSUyMGZvciUyMHglMjBpbiUyMG1pbmRzJTVCJTIycGF0aCUyMiU1RCU1RCUwQW1pbmRzJTIwJTNEJTIwbWluZHMuYWRkX2NvbHVtbiglMjJkdXJhdGlvbiUyMiUyQyUyMG5ld19jb2x1bW4pJTBBJTBBJTIzJTIwdXRpbGlzZXIlMjBsYSUyMG0lQzMlQTl0aG9kZSUyMCU2MGZpbHRlciU2MCUyMGRlJTIwJUYwJTlGJUE0JTk3JTIwRGF0YXNldHMlMjBwb3VyJTIwYXBwbGlxdWVyJTIwbGElMjBmb25jdGlvbiUyMGRlJTIwZmlsdHJhZ2UlMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmZpbHRlcihpc19hdWRpb19sZW5ndGhfaW5fcmFuZ2UlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBJTBBJTIzJTIwc3VwcHJpbWVyJTIwbGElMjBjb2xvbm5lJTIwZCdhc3Npc3RhbmNlJTIwdGVtcG9yYWlyZSUwQW1pbmRzJTIwJTNEJTIwbWluZHMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBbWluZHM=",highlighted:`<span class="hljs-comment"># Utilisez librosa pour obtenir la durée de l&#x27;exemple à partir du fichier audio</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># utiliser la méthode \`filter\` de 🤗 Datasets pour appliquer la fonction de filtrage</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># supprimer la colonne d&#x27;assistance temporaire</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`}}),F=new J({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>'}}),P=new mt({}),ee=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`}}),se=new J({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`}}),le=new J({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`}}),re=new J({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`}}),ie=new J({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`}}),ce=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`}}),{c(){y=r("meta"),T=l(),$=r("p"),ge=l(),U=r("h1"),g=r("a"),Je=r("span"),p(_.$$.fragment),ht=l(),he=r("span"),he.textContent=Jt,Ce=l(),B=r("p"),B.innerHTML=Tt,Ae=l(),k=r("ul"),k.innerHTML=Ut,Ie=l(),v=r("h2"),C=r("a"),Te=r("span"),p(z.$$.fragment),jt=l(),je=r("span"),je.textContent=vt,qe=l(),R=r("p"),R.innerHTML=wt,xe=l(),p(G.$$.fragment),$e=l(),Z=r("p"),Z.textContent=bt,_e=l(),p(N.$$.fragment),Be=l(),V=r("p"),V.innerHTML=gt,ke=l(),p(W.$$.fragment),ze=l(),E=r("p"),E.textContent=Ct,Re=l(),p(A.$$.fragment),Ge=l(),w=r("h2"),I=r("a"),Ue=r("span"),p(H.$$.fragment),yt=l(),ye=r("span"),ye.textContent=At,Ze=l(),X=r("p"),X.innerHTML=It,Ne=l(),p(Y.$$.fragment),Ve=l(),Q=r("p"),Q.textContent=qt,We=l(),p(S.$$.fragment),Ee=l(),L=r("p"),L.innerHTML=xt,He=l(),p(F.$$.fragment),Xe=l(),D=r("p"),D.textContent=$t,Ye=l(),b=r("h2"),q=r("a"),ve=r("span"),p(P.$$.fragment),ft=l(),fe=r("span"),fe.textContent=_t,Qe=l(),O=r("p"),O.innerHTML=Bt,Se=l(),K=r("p"),K.innerHTML=kt,Le=l(),p(ee.$$.fragment),Fe=l(),te=r("p"),te.innerHTML=zt,De=l(),p(se.$$.fragment),Pe=l(),ne=r("p"),ne.innerHTML=Rt,Oe=l(),p(le.$$.fragment),Ke=l(),ae=r("p"),ae.innerHTML=Gt,et=l(),p(re.$$.fragment),tt=l(),oe=r("p"),oe.innerHTML=Zt,st=l(),p(ie.$$.fragment),nt=l(),x=r("div"),x.innerHTML=Nt,lt=l(),ue=r("p"),ue.textContent=Vt,at=l(),pe=r("p"),pe.innerHTML=Wt,rt=l(),de=r("p"),de.innerHTML=Et,ot=l(),p(ce.$$.fragment),it=l(),Me=r("p"),Me.innerHTML=Ht,ut=l(),we=r("p"),this.h()},l(e){const t=ss("svelte-1phssyn",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(s),T=a(e),$=o(e,"P",{}),f($).forEach(s),ge=a(e),U=o(e,"H1",{class:!0});var me=f(U);g=o(me,"A",{id:!0,class:!0,href:!0});var Xt=f(g);Je=o(Xt,"SPAN",{});var Yt=f(Je);d(_.$$.fragment,Yt),Yt.forEach(s),Xt.forEach(s),ht=a(me),he=o(me,"SPAN",{"data-svelte-h":!0}),i(he)!=="svelte-g8h4dm"&&(he.textContent=Jt),me.forEach(s),Ce=a(e),B=o(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-mdqbw0"&&(B.innerHTML=Tt),Ae=a(e),k=o(e,"UL",{"data-svelte-h":!0}),i(k)!=="svelte-yk9hcg"&&(k.innerHTML=Ut),Ie=a(e),v=o(e,"H2",{class:!0});var dt=f(v);C=o(dt,"A",{id:!0,class:!0,href:!0});var Qt=f(C);Te=o(Qt,"SPAN",{});var St=f(Te);d(z.$$.fragment,St),St.forEach(s),Qt.forEach(s),jt=a(dt),je=o(dt,"SPAN",{"data-svelte-h":!0}),i(je)!=="svelte-spq1j2"&&(je.textContent=vt),dt.forEach(s),qe=a(e),R=o(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-ivzlq3"&&(R.innerHTML=wt),xe=a(e),d(G.$$.fragment,e),$e=a(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-538ngx"&&(Z.textContent=bt),_e=a(e),d(N.$$.fragment,e),Be=a(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-dbzevp"&&(V.innerHTML=gt),ke=a(e),d(W.$$.fragment,e),ze=a(e),E=o(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-164hhon"&&(E.textContent=Ct),Re=a(e),d(A.$$.fragment,e),Ge=a(e),w=o(e,"H2",{class:!0});var ct=f(w);I=o(ct,"A",{id:!0,class:!0,href:!0});var Lt=f(I);Ue=o(Lt,"SPAN",{});var Ft=f(Ue);d(H.$$.fragment,Ft),Ft.forEach(s),Lt.forEach(s),yt=a(ct),ye=o(ct,"SPAN",{"data-svelte-h":!0}),i(ye)!=="svelte-1t98h0z"&&(ye.textContent=At),ct.forEach(s),Ze=a(e),X=o(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-mbvv6"&&(X.innerHTML=It),Ne=a(e),d(Y.$$.fragment,e),Ve=a(e),Q=o(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-8vpyeu"&&(Q.textContent=qt),We=a(e),d(S.$$.fragment,e),Ee=a(e),L=o(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-dbzevp"&&(L.innerHTML=xt),He=a(e),d(F.$$.fragment,e),Xe=a(e),D=o(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-tdnd34"&&(D.textContent=$t),Ye=a(e),b=o(e,"H2",{class:!0});var Mt=f(b);q=o(Mt,"A",{id:!0,class:!0,href:!0});var Dt=f(q);ve=o(Dt,"SPAN",{});var Pt=f(ve);d(P.$$.fragment,Pt),Pt.forEach(s),Dt.forEach(s),ft=a(Mt),fe=o(Mt,"SPAN",{"data-svelte-h":!0}),i(fe)!=="svelte-1k0cenz"&&(fe.textContent=_t),Mt.forEach(s),Qe=a(e),O=o(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-9jm202"&&(O.innerHTML=Bt),Se=a(e),K=o(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-18oi0yw"&&(K.innerHTML=kt),Le=a(e),d(ee.$$.fragment,e),Fe=a(e),te=o(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-iag9pm"&&(te.innerHTML=zt),De=a(e),d(se.$$.fragment,e),Pe=a(e),ne=o(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-1le6nsz"&&(ne.innerHTML=Rt),Oe=a(e),d(le.$$.fragment,e),Ke=a(e),ae=o(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-dbzevp"&&(ae.innerHTML=Gt),et=a(e),d(re.$$.fragment,e),tt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-ojjqz9"&&(oe.innerHTML=Zt),st=a(e),d(ie.$$.fragment,e),nt=a(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(x)!=="svelte-csckl"&&(x.innerHTML=Nt),lt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-y12i6c"&&(ue.textContent=Vt),at=a(e),pe=o(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-19a55if"&&(pe.innerHTML=Wt),rt=a(e),de=o(e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-1sqx47z"&&(de.innerHTML=Et),ot=a(e),d(ce.$$.fragment,e),it=a(e),Me=o(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-172ihj8"&&(Me.innerHTML=Ht),ut=a(e),we=o(e,"P",{}),f(we).forEach(s),this.h()},h(){u(y,"name","hf:doc:metadata"),u(y,"content",JSON.stringify(is)),u(g,"id","prtraitement-dun-jeu-de-donnes-audio"),u(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(g,"href","#prtraitement-dun-jeu-de-donnes-audio"),u(U,"class","relative group"),u(C,"id","rchantillonnage-des-donnes-audio"),u(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(C,"href","#rchantillonnage-des-donnes-audio"),u(v,"class","relative group"),u(I,"id","filtrage-du-jeu-de-donnes"),u(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(I,"href","#filtrage-du-jeu-de-donnes"),u(w,"class","relative group"),u(q,"id","prtraitement-des-donnes-audio"),u(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(q,"href","#prtraitement-des-donnes-audio"),u(b,"class","relative group"),u(x,"class","flex justify-center")},m(e,t){c(document.head,y),n(e,T,t),n(e,$,t),n(e,ge,t),n(e,U,t),c(U,g),c(g,Je),M(_,Je,null),c(U,ht),c(U,he),n(e,Ce,t),n(e,B,t),n(e,Ae,t),n(e,k,t),n(e,Ie,t),n(e,v,t),c(v,C),c(C,Te),M(z,Te,null),c(v,jt),c(v,je),n(e,qe,t),n(e,R,t),n(e,xe,t),M(G,e,t),n(e,$e,t),n(e,Z,t),n(e,_e,t),M(N,e,t),n(e,Be,t),n(e,V,t),n(e,ke,t),M(W,e,t),n(e,ze,t),n(e,E,t),n(e,Re,t),M(A,e,t),n(e,Ge,t),n(e,w,t),c(w,I),c(I,Ue),M(H,Ue,null),c(w,yt),c(w,ye),n(e,Ze,t),n(e,X,t),n(e,Ne,t),M(Y,e,t),n(e,Ve,t),n(e,Q,t),n(e,We,t),M(S,e,t),n(e,Ee,t),n(e,L,t),n(e,He,t),M(F,e,t),n(e,Xe,t),n(e,D,t),n(e,Ye,t),n(e,b,t),c(b,q),c(q,ve),M(P,ve,null),c(b,ft),c(b,fe),n(e,Qe,t),n(e,O,t),n(e,Se,t),n(e,K,t),n(e,Le,t),M(ee,e,t),n(e,Fe,t),n(e,te,t),n(e,De,t),M(se,e,t),n(e,Pe,t),n(e,ne,t),n(e,Oe,t),M(le,e,t),n(e,Ke,t),n(e,ae,t),n(e,et,t),M(re,e,t),n(e,tt,t),n(e,oe,t),n(e,st,t),M(ie,e,t),n(e,nt,t),n(e,x,t),n(e,lt,t),n(e,ue,t),n(e,at,t),n(e,pe,t),n(e,rt,t),n(e,de,t),n(e,ot,t),M(ce,e,t),n(e,it,t),n(e,Me,t),n(e,ut,t),n(e,we,t),pt=!0},p(e,[t]){const me={};t&2&&(me.$$scope={dirty:t,ctx:e}),A.$set(me)},i(e){pt||(m(_.$$.fragment,e),m(z.$$.fragment,e),m(G.$$.fragment,e),m(N.$$.fragment,e),m(W.$$.fragment,e),m(A.$$.fragment,e),m(H.$$.fragment,e),m(Y.$$.fragment,e),m(S.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(re.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),pt=!0)},o(e){h(_.$$.fragment,e),h(z.$$.fragment,e),h(G.$$.fragment,e),h(N.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(H.$$.fragment,e),h(Y.$$.fragment,e),h(S.$$.fragment,e),h(F.$$.fragment,e),h(P.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),pt=!1},d(e){e&&(s(T),s($),s(ge),s(U),s(Ce),s(B),s(Ae),s(k),s(Ie),s(v),s(qe),s(R),s(xe),s($e),s(Z),s(_e),s(Be),s(V),s(ke),s(ze),s(E),s(Re),s(Ge),s(w),s(Ze),s(X),s(Ne),s(Ve),s(Q),s(We),s(Ee),s(L),s(He),s(Xe),s(D),s(Ye),s(b),s(Qe),s(O),s(Se),s(K),s(Le),s(Fe),s(te),s(De),s(Pe),s(ne),s(Oe),s(Ke),s(ae),s(et),s(tt),s(oe),s(st),s(nt),s(x),s(lt),s(ue),s(at),s(pe),s(rt),s(de),s(ot),s(it),s(Me),s(ut),s(we)),s(y),j(_),j(z),j(G,e),j(N,e),j(W,e),j(A,e),j(H),j(Y,e),j(S,e),j(F,e),j(P),j(ee,e),j(se,e),j(le,e),j(re,e),j(ie,e),j(ce,e)}}}const is={local:"prtraitement-dun-jeu-de-donnes-audio",sections:[{local:"rchantillonnage-des-donnes-audio",title:"Rééchantillonnage des données audio"},{local:"filtrage-du-jeu-de-donnes",title:"Filtrage du jeu de données"},{local:"prtraitement-des-donnes-audio",title:"Prétraitement des données audio"}],title:"Prétraitement d'un jeu de données audio"};function us(be){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends es{constructor(y){super(),ts(this,y,us,os,Ot,{})}}export{hs as component};
