import{s as Ul,o as fl}from"../chunks/scheduler.b8dd6794.js";import{S as Tl,i as wl,g as M,s as a,u as o,A as Cl,h as p,f as l,c as n,j as d,v as u,y as i,k as r,o as m,a as s,w as y,d as c,t as j,x as h,m as Al,n as Il}from"../chunks/index.6bf4cb26.js";import{T as bl}from"../chunks/Tip.c449353f.js";import{I as xe}from"../chunks/IconCopyLink.0ecb1fb3.js";import{C as U}from"../chunks/CodeBlock.e774b03f.js";function vl(kt){let J;return{c(){J=Al("💡 리샘플링에 대한 배경 정보: 만약 오디오 신호가 8 kHz로 샘플링 되었다면(즉, 초당 8000개의 샘플이 있다면) 4 kHz보다 높은 주파수는 없음을 알 수 있습니다. 나이퀴스트 샘플링 정리(Nyquist sampling theorem)에 의해서 말이죠. 이 덕분에 우린 샘플링 지점들간의 원래의 연속적인 신호는 항상 부드러운 커브임을 확신할 수 있는 것입니다. 더 높은 샘플링 속도로의 업샘플링은 이 커브를 근사하여 기존 점들 사이의 값을 찾아내면 됩니다. 그러나 다운샘플링 같은 경우, 새로운 샘플을 결정하기전에 새로운 나이퀴스트 한계보다 높은 주파수를 먼저 걸러내는 작업이 필요할 겁니다. 다시 말해, 2배의 다운샘플링 같은 경우 이에 맞춰 단순히 샘플들을 버리는 것으로는 왜곡이 생길 수 있습니다. 이 왜곡을 alias라고 합니다. 이렇듯 리샘플링을 올바르게 하기란 꽤 까다로우므로 librosa나 🤗 Datasets같은 잘 테스트된 라이브러리를 쓰는편이 낫습니다.")},l(f){J=Il(f,"💡 리샘플링에 대한 배경 정보: 만약 오디오 신호가 8 kHz로 샘플링 되었다면(즉, 초당 8000개의 샘플이 있다면) 4 kHz보다 높은 주파수는 없음을 알 수 있습니다. 나이퀴스트 샘플링 정리(Nyquist sampling theorem)에 의해서 말이죠. 이 덕분에 우린 샘플링 지점들간의 원래의 연속적인 신호는 항상 부드러운 커브임을 확신할 수 있는 것입니다. 더 높은 샘플링 속도로의 업샘플링은 이 커브를 근사하여 기존 점들 사이의 값을 찾아내면 됩니다. 그러나 다운샘플링 같은 경우, 새로운 샘플을 결정하기전에 새로운 나이퀴스트 한계보다 높은 주파수를 먼저 걸러내는 작업이 필요할 겁니다. 다시 말해, 2배의 다운샘플링 같은 경우 이에 맞춰 단순히 샘플들을 버리는 것으로는 왜곡이 생길 수 있습니다. 이 왜곡을 alias라고 합니다. 이렇듯 리샘플링을 올바르게 하기란 꽤 까다로우므로 librosa나 🤗 Datasets같은 잘 테스트된 라이브러리를 쓰는편이 낫습니다.")},m(f,k){s(f,J,k)},d(f){f&&l(J)}}}function xl(kt){let J,f,k,Bt,T,I,bt,B,$e,wt,ge="오디오 데이터셋 전처리하기",gt,g,Ze="🤗 Datasets을 이용하여 데이터셋을 불러오는건 재미의 반에 불과합니다. 모델을 학습시키거나 추론(inference)을 실행하기 위해선 먼저 데이터를 전처리해야할 것입니다. 일반적으로 이는 다음의 단계를 거칩니다:",Zt,Z,Re="<li>오디오 데이터 리샘플링</li> <li>데이터셋 필터링</li> <li>오디오 데이터를 모델의 입력에 맞게 변환</li>",Rt,w,b,vt,R,_e,Ct,Ge="오디오 데이터 리샘플링하기",Gt,G,We="<code>load_dataset</code> 함수는 오디오 데이터를 게시된(published) 샘플링 속도에 맞춰 다운로드합니다. 이 샘플링 속도는 여러분이 계획한 학습 혹은 추론을 위한 샘플링 속도가 아닐 수 있습니다. 이렇게 샘플링 속도간 불일치가 있다면, 모델이 기대하는 샘플링 속도에 맞춰 리샘플링을 할 수 있습니다.",Wt,W,Ne=`대부분의 사전 학습된 모델들은 16 kHz의 샘플링 속도를 가진 오디오 데이터셋에 대하여 사전학습이 이뤄져있습니다.
여러분이 MINDS-14 데이터셋을 살펴보신다면 8 kHz로 샘플링된것을 알 수 있을겁니다. 업샘플링이 필요하다는 뜻이죠.`,Nt,N,Ee="이를 위해, 🤗 Datasets의 <code>cast_column</code> 메소드를 써봅시다. 이 연산은 오디오를 in-place로 변경하는 것이 아니라 오디오 데이터들이 불러와질때 즉석에서 리샘플링되도록 데이터셋에 신호를 보냅니다. 다음의 코드는 샘플링 속도를 16 kHz로 설정합니다:",Et,E,Ht,H,He="MINDS-14 데이터셋의 첫번째 오디오 예제를 다시 불러와 원하는 <code>sampling_rate</code>으로 리샘플링 되었는지 확인해 보겠습니다:",Xt,X,zt,z,Xe="<strong>Output:</strong>",Vt,V,Yt,Y,ze="여러분은 아마 배열의 값들 역시 달라졌음을 눈치채셨을 겁니다. 이는 기존에 비해 진폭값들의 갯수가 전부 두배로 늘어났기 때문입니다.",Qt,v,qt,C,x,xt,Q,ke,At,Ve="데이터셋 필터링하기",St,q,Ye="여러분은 데이터를 어떤 기준에 맞춰 필터링해야할 때도 있을겁니다. 흔한 경우로는 오디오 데이터를 특정 길이에 맞춰 제한하는 경우가 있을 수 있습니다. 예를 들어, 모델 학습시 out-of-memory 에러를 피하기 위해 20초 보다 긴 모든 데이터를 필터링하길 원할 수도 있습니다.",Ft,S,Qe="🤗 Datasets의 <code>filter</code> 메소드에 필터링 로직을 짠 함수를 집어넣어 쓴다면 이를 수행할 수 있습니다. 한번 어떤 데이터를 쓸지 또는 버릴지를 알려주는 함수를 작성해 이를 써봅시다. 함수 <code>is_audio_length_in_range</code>는 만약 샘플이 20초보다 짧다면 <code>True</code>를 그렇지 않다면 <code>False</code>를 반환합니다.",Lt,F,Dt,L,qe="필터링 함수는 데이터셋의 컬럼에 적용될 수 있지만 이 데이터셋엔 오디오 트랙 길이가 없습니다. 그러나 우린 새로 이런 컬럼을 만들 수 있으니 새로 만든 후 이 컬럼의 값에 필터를 적용하고 최종적으로는 다시 지워봅시다.",Pt,D,Ot,P,Se="<strong>Output:</strong>",Kt,O,te,K,Fe="데이터셋의 숫자가 654개에서 624개로 감소한것을 확인하실 수 있습니다.",ee,A,$,$t,tt,Be,It,Le="오디오 데이터 전처리하기",le,et,De="오디오 데이터셋을 준비할 때 가장 어려운점 중 하나는 모델 학습에 맞는 형식을 갖추는 것입니다. 여러분이 앞서 보셧듯, 원시 오디오 데이터는 샘플값들의 배열로 제공됩니다. 그러나, 사전 학습된 모델같은 경우(이를 추론을 위해 쓰든 파인튜닝을 위해 쓰든) 이런 원시 데이터를 입력 feature에 맞춰야합니다. 이런 입력 feature의 요구사항은 모델마다 다를 수 있습니다. 이는 모델의 구조와 어떤 데이터로 사전학습이 이뤄졌는지에 달려있습니다. 좋은 소식은 🤗 Transformers는 지원하는 모든 모델에 대해 원시 데이터를 모델이 원하는 입력 feature로 바꿔주는 feature extractor 클래스를 제공한다는 것입니다.",se,lt,Pe='이 feature extractor는 그럼 원시 데이터로 무엇을 하는 걸까요? 일반적인 feature extraction 변환을 이해하기 위해 <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper</a>의 feature extractor를 살펴보겠습니다. Whisper는 자동 음성 인식(ASR)을 위해 사전 학습된 모델로 2022년 9월에 OpenAI의 Alec Radford와 공동 연구자들이 발표했습니다.',ae,st,Oe=`첫번째로, Whisper의 feature extractor는 모든 데이터가 30초의 길이를 갖도록 덧붙이거나(pad) 자릅니다(truncate). 30초 보다 짧은 데이터는 시퀀스의 끝에 0을 붙여 길이를 늘립니다(오디오 신호에서 0은 신호 없음 혹은 무음과 같습니다). 30초 보다 긴 데이터는 30초가 되도록 자릅니다.
배치의 모든 요소가 input space의 최대 길이에 맞춰 덧붙여지거나 잘렸으므로 별도의 attention mask는 필요 없습니다. 이런 점에서 Whisper는 특별한데, 대부분의 다른 오디오 모델들은 self-attention 메커니즘에서 어느 부분을 무시해야하는지를 알려주기 위해 시퀀스의 어디가 덧붙여졌는지 알려주는 attention mask가 필요하기 때문입니다. Whisper는 attention mask 없이 작동하도록 훈련되어 음성 신호에서 직접 입력의 어느 부분을 무시해야 하는지를 추론합니다.`,ne,at,Ke="Whisper feature extractor가 수행하는 두번째 작업은 덧붙여진 오디오 배열들을 로그-멜 스펙트로그램으로 바꾸는 것입니다. 아시다시피, 이 스펙트로그램은 신호의 주파수가 시간에 따라 어떻게 변하는지를 멜 스케일에 맞춰 데시벨(로그 부분)로 측정하여 주파수와 진폭이 사람의 청각 시스템을 더 잘 표현하도록 합니다.",Me,nt,tl="이 모든 변환은 몇 줄의 코드로 여러분의 원시 데이터에 적용될 수 있습니다. 사전 학습된 Whisper의 체크포인트에서 feature extractor를 불러와 오디오 데이터에 사용할 준비를 해봅시다:",pe,Mt,ie,pt,el="다음으로, <code>feature_extractor</code>를 통해 각각의 오디오 데이터를 전처리할 함수를 작성할 수 있습니다.",re,it,oe,rt,ll="🤗 Datasets의 <code>map</code> 메소드를 이용하여 모든 학습 데이터에 적용시킬 수 있습니다:",ue,ot,me,ut,sl="<strong>Output:</strong>",ye,mt,ce,yt,al="이렇게 간단히, 로그-멜 스펙트로그램을 데이터셋의 <code>input_features</code>에 저장할 수 있습니다.",je,ct,nl="<code>minds</code> 데이터셋 중 하나를 시각화해봅시다:",he,jt,Je,_,Ml='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',de,ht,pl="이제 전처리 후 Whisper 모델에 대한 오디오 입력이 어떻게 보이는지 확인하실 수 있습니다.",Ue,Jt,il='모델의 feature extractor 클래스는 원시 데이터를 모델이 원하는 포맷으로 변경하는 작업을 처리합니다. 그러나, 대개의 오디오 작업은(예를 들어, 음성 인식) multimodal입니다. 이런 경우 🤗 Transformers는 텍스트 입력을 처리하기 위해 모델별 토크나이저(tokenizer)를 제공합니다. 토크나이저에 대해 더 자세히 알고 싶으시다면 <a href="https://huggingface.co/course/chapter2/4" rel="nofollow">NLP 코스</a>를 참고하세요.',fe,dt,rl="Whisper와 다른 multimodal 모델에 대해 각각의 feature extractor와 토크나이저를 별도로 불러오거나, 이른바 processor를 통해 한번에 불러올 수도 있습니다. 더 간단히 다음의 코드처럼 <code>AutoProcessor</code>로 체크포인트에서 모델의 feature extractor와 processor를 불러올 수도 있습니다:",Te,Ut,we,ft,ol=`여기에서는 기본적인 데이터 준비 단계를 설명했습니다. 물론 커스텀 데이터는 더 복잡한 전처리가 필요할 수도 있습니다.
이 경우, 여러분은 어떤 종류의 커스텀 데이터도 변환이 가능하도록 <code>prepare_dataset</code> 함수를 확장할 수 있습니다. 🤗 Datasets과 함께라면, 여러분은 파이썬 함수로 작성 할 수만 있다면 여러분의 데이터에 이를 적용시킬 수 있을겁니다!`,Ce,_t,Ae;return B=new xe({}),R=new xe({}),E=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`}}),X=new U({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]'}}),V=new U({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`}}),v=new bl({props:{$$slots:{default:[vl]},$$scope:{ctx:kt}}}),Q=new xe({}),F=new U({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`}}),D=new U({props:{code:"JTIzJTIwdXNlJTIwbGlicm9zYSUyMHRvJTIwZ2V0JTIwZXhhbXBsZSdzJTIwZHVyYXRpb24lMjBmcm9tJTIwdGhlJTIwYXVkaW8lMjBmaWxlJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKGZpbGVuYW1lJTNEeCklMjBmb3IlMjB4JTIwaW4lMjBtaW5kcyU1QiUyMnBhdGglMjIlNUQlNUQlMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmFkZF9jb2x1bW4oJTIyZHVyYXRpb24lMjIlMkMlMjBuZXdfY29sdW1uKSUwQSUwQSUyMyUyMHVzZSUyMCVGMCU5RiVBNCU5NyUyMERhdGFzZXRzJyUyMCU2MGZpbHRlciU2MCUyMG1ldGhvZCUyMHRvJTIwYXBwbHklMjB0aGUlMjBmaWx0ZXJpbmclMjBmdW5jdGlvbiUwQW1pbmRzJTIwJTNEJTIwbWluZHMuZmlsdGVyKGlzX2F1ZGlvX2xlbmd0aF9pbl9yYW5nZSUyQyUyMGlucHV0X2NvbHVtbnMlM0QlNUIlMjJkdXJhdGlvbiUyMiU1RCklMEElMEElMjMlMjByZW1vdmUlMjB0aGUlMjB0ZW1wb3JhcnklMjBoZWxwZXIlMjBjb2x1bW4lMEFtaW5kcyUyMCUzRCUyMG1pbmRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMmR1cmF0aW9uJTIyJTVEKSUwQW1pbmRz",highlighted:`<span class="hljs-comment"># use librosa to get example&#x27;s duration from the audio file</span>
new_column = [librosa.get_duration(filename=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># use 🤗 Datasets&#x27; \`filter\` method to apply the filtering function</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># remove the temporary helper column</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`}}),O=new U({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>'}}),tt=new xe({}),Mt=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`}}),it=new U({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`}}),ot=new U({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`}}),mt=new U({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`}}),jt=new U({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`}}),Ut=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`}}),{c(){J=M("meta"),f=a(),k=M("p"),Bt=a(),T=M("h1"),I=M("a"),bt=M("span"),o(B.$$.fragment),$e=a(),wt=M("span"),wt.textContent=ge,gt=a(),g=M("p"),g.textContent=Ze,Zt=a(),Z=M("ul"),Z.innerHTML=Re,Rt=a(),w=M("h2"),b=M("a"),vt=M("span"),o(R.$$.fragment),_e=a(),Ct=M("span"),Ct.textContent=Ge,Gt=a(),G=M("p"),G.innerHTML=We,Wt=a(),W=M("p"),W.textContent=Ne,Nt=a(),N=M("p"),N.innerHTML=Ee,Et=a(),o(E.$$.fragment),Ht=a(),H=M("p"),H.innerHTML=He,Xt=a(),o(X.$$.fragment),zt=a(),z=M("p"),z.innerHTML=Xe,Vt=a(),o(V.$$.fragment),Yt=a(),Y=M("p"),Y.textContent=ze,Qt=a(),o(v.$$.fragment),qt=a(),C=M("h2"),x=M("a"),xt=M("span"),o(Q.$$.fragment),ke=a(),At=M("span"),At.textContent=Ve,St=a(),q=M("p"),q.textContent=Ye,Ft=a(),S=M("p"),S.innerHTML=Qe,Lt=a(),o(F.$$.fragment),Dt=a(),L=M("p"),L.textContent=qe,Pt=a(),o(D.$$.fragment),Ot=a(),P=M("p"),P.innerHTML=Se,Kt=a(),o(O.$$.fragment),te=a(),K=M("p"),K.textContent=Fe,ee=a(),A=M("h2"),$=M("a"),$t=M("span"),o(tt.$$.fragment),Be=a(),It=M("span"),It.textContent=Le,le=a(),et=M("p"),et.textContent=De,se=a(),lt=M("p"),lt.innerHTML=Pe,ae=a(),st=M("p"),st.textContent=Oe,ne=a(),at=M("p"),at.textContent=Ke,Me=a(),nt=M("p"),nt.textContent=tl,pe=a(),o(Mt.$$.fragment),ie=a(),pt=M("p"),pt.innerHTML=el,re=a(),o(it.$$.fragment),oe=a(),rt=M("p"),rt.innerHTML=ll,ue=a(),o(ot.$$.fragment),me=a(),ut=M("p"),ut.innerHTML=sl,ye=a(),o(mt.$$.fragment),ce=a(),yt=M("p"),yt.innerHTML=al,je=a(),ct=M("p"),ct.innerHTML=nl,he=a(),o(jt.$$.fragment),Je=a(),_=M("div"),_.innerHTML=Ml,de=a(),ht=M("p"),ht.textContent=pl,Ue=a(),Jt=M("p"),Jt.innerHTML=il,fe=a(),dt=M("p"),dt.innerHTML=rl,Te=a(),o(Ut.$$.fragment),we=a(),ft=M("p"),ft.innerHTML=ol,Ce=a(),_t=M("p"),this.h()},l(t){const e=Cl("svelte-1phssyn",document.head);J=p(e,"META",{name:!0,content:!0}),e.forEach(l),f=n(t),k=p(t,"P",{}),d(k).forEach(l),Bt=n(t),T=p(t,"H1",{class:!0});var Tt=d(T);I=p(Tt,"A",{id:!0,class:!0,href:!0});var ul=d(I);bt=p(ul,"SPAN",{});var ml=d(bt);u(B.$$.fragment,ml),ml.forEach(l),ul.forEach(l),$e=n(Tt),wt=p(Tt,"SPAN",{"data-svelte-h":!0}),i(wt)!=="svelte-wftlwy"&&(wt.textContent=ge),Tt.forEach(l),gt=n(t),g=p(t,"P",{"data-svelte-h":!0}),i(g)!=="svelte-ya88xm"&&(g.textContent=Ze),Zt=n(t),Z=p(t,"UL",{"data-svelte-h":!0}),i(Z)!=="svelte-olz9v0"&&(Z.innerHTML=Re),Rt=n(t),w=p(t,"H2",{class:!0});var Ie=d(w);b=p(Ie,"A",{id:!0,class:!0,href:!0});var yl=d(b);vt=p(yl,"SPAN",{});var cl=d(vt);u(R.$$.fragment,cl),cl.forEach(l),yl.forEach(l),_e=n(Ie),Ct=p(Ie,"SPAN",{"data-svelte-h":!0}),i(Ct)!=="svelte-a0jpg"&&(Ct.textContent=Ge),Ie.forEach(l),Gt=n(t),G=p(t,"P",{"data-svelte-h":!0}),i(G)!=="svelte-zodz6y"&&(G.innerHTML=We),Wt=n(t),W=p(t,"P",{"data-svelte-h":!0}),i(W)!=="svelte-11vzx2x"&&(W.textContent=Ne),Nt=n(t),N=p(t,"P",{"data-svelte-h":!0}),i(N)!=="svelte-10xsk1v"&&(N.innerHTML=Ee),Et=n(t),u(E.$$.fragment,t),Ht=n(t),H=p(t,"P",{"data-svelte-h":!0}),i(H)!=="svelte-g9ssah"&&(H.innerHTML=He),Xt=n(t),u(X.$$.fragment,t),zt=n(t),z=p(t,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1mvdyro"&&(z.innerHTML=Xe),Vt=n(t),u(V.$$.fragment,t),Yt=n(t),Y=p(t,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-d80rar"&&(Y.textContent=ze),Qt=n(t),u(v.$$.fragment,t),qt=n(t),C=p(t,"H2",{class:!0});var be=d(C);x=p(be,"A",{id:!0,class:!0,href:!0});var jl=d(x);xt=p(jl,"SPAN",{});var hl=d(xt);u(Q.$$.fragment,hl),hl.forEach(l),jl.forEach(l),ke=n(be),At=p(be,"SPAN",{"data-svelte-h":!0}),i(At)!=="svelte-boljbj"&&(At.textContent=Ve),be.forEach(l),St=n(t),q=p(t,"P",{"data-svelte-h":!0}),i(q)!=="svelte-13lalkv"&&(q.textContent=Ye),Ft=n(t),S=p(t,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1b59bty"&&(S.innerHTML=Qe),Lt=n(t),u(F.$$.fragment,t),Dt=n(t),L=p(t,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1sl3hyy"&&(L.textContent=qe),Pt=n(t),u(D.$$.fragment,t),Ot=n(t),P=p(t,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1mvdyro"&&(P.innerHTML=Se),Kt=n(t),u(O.$$.fragment,t),te=n(t),K=p(t,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1h3nix2"&&(K.textContent=Fe),ee=n(t),A=p(t,"H2",{class:!0});var ve=d(A);$=p(ve,"A",{id:!0,class:!0,href:!0});var Jl=d($);$t=p(Jl,"SPAN",{});var dl=d($t);u(tt.$$.fragment,dl),dl.forEach(l),Jl.forEach(l),Be=n(ve),It=p(ve,"SPAN",{"data-svelte-h":!0}),i(It)!=="svelte-14i46ab"&&(It.textContent=Le),ve.forEach(l),le=n(t),et=p(t,"P",{"data-svelte-h":!0}),i(et)!=="svelte-1n8hncz"&&(et.textContent=De),se=n(t),lt=p(t,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-1eslxg3"&&(lt.innerHTML=Pe),ae=n(t),st=p(t,"P",{"data-svelte-h":!0}),i(st)!=="svelte-19412bd"&&(st.textContent=Oe),ne=n(t),at=p(t,"P",{"data-svelte-h":!0}),i(at)!=="svelte-1lpqin1"&&(at.textContent=Ke),Me=n(t),nt=p(t,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-1pdcnlk"&&(nt.textContent=tl),pe=n(t),u(Mt.$$.fragment,t),ie=n(t),pt=p(t,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-snr1i6"&&(pt.innerHTML=el),re=n(t),u(it.$$.fragment,t),oe=n(t),rt=p(t,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-1y4bo99"&&(rt.innerHTML=ll),ue=n(t),u(ot.$$.fragment,t),me=n(t),ut=p(t,"P",{"data-svelte-h":!0}),i(ut)!=="svelte-1mvdyro"&&(ut.innerHTML=sl),ye=n(t),u(mt.$$.fragment,t),ce=n(t),yt=p(t,"P",{"data-svelte-h":!0}),i(yt)!=="svelte-1qmv2tx"&&(yt.innerHTML=al),je=n(t),ct=p(t,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-d4dgla"&&(ct.innerHTML=nl),he=n(t),u(jt.$$.fragment,t),Je=n(t),_=p(t,"DIV",{class:!0,"data-svelte-h":!0}),i(_)!=="svelte-csckl"&&(_.innerHTML=Ml),de=n(t),ht=p(t,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-538kx9"&&(ht.textContent=pl),Ue=n(t),Jt=p(t,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-15c8axx"&&(Jt.innerHTML=il),fe=n(t),dt=p(t,"P",{"data-svelte-h":!0}),i(dt)!=="svelte-15pli7h"&&(dt.innerHTML=rl),Te=n(t),u(Ut.$$.fragment,t),we=n(t),ft=p(t,"P",{"data-svelte-h":!0}),i(ft)!=="svelte-1t0u2ng"&&(ft.innerHTML=ol),Ce=n(t),_t=p(t,"P",{}),d(_t).forEach(l),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",JSON.stringify($l)),r(I,"id","preprocessing-an-audio-dataset"),r(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(I,"href","#preprocessing-an-audio-dataset"),r(T,"class","relative group"),r(b,"id","resampling-the-audio-data"),r(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(b,"href","#resampling-the-audio-data"),r(w,"class","relative group"),r(x,"id","filtering-the-dataset"),r(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(x,"href","#filtering-the-dataset"),r(C,"class","relative group"),r($,"id","pre-processing-audio-data"),r($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($,"href","#pre-processing-audio-data"),r(A,"class","relative group"),r(_,"class","flex justify-center")},m(t,e){m(document.head,J),s(t,f,e),s(t,k,e),s(t,Bt,e),s(t,T,e),m(T,I),m(I,bt),y(B,bt,null),m(T,$e),m(T,wt),s(t,gt,e),s(t,g,e),s(t,Zt,e),s(t,Z,e),s(t,Rt,e),s(t,w,e),m(w,b),m(b,vt),y(R,vt,null),m(w,_e),m(w,Ct),s(t,Gt,e),s(t,G,e),s(t,Wt,e),s(t,W,e),s(t,Nt,e),s(t,N,e),s(t,Et,e),y(E,t,e),s(t,Ht,e),s(t,H,e),s(t,Xt,e),y(X,t,e),s(t,zt,e),s(t,z,e),s(t,Vt,e),y(V,t,e),s(t,Yt,e),s(t,Y,e),s(t,Qt,e),y(v,t,e),s(t,qt,e),s(t,C,e),m(C,x),m(x,xt),y(Q,xt,null),m(C,ke),m(C,At),s(t,St,e),s(t,q,e),s(t,Ft,e),s(t,S,e),s(t,Lt,e),y(F,t,e),s(t,Dt,e),s(t,L,e),s(t,Pt,e),y(D,t,e),s(t,Ot,e),s(t,P,e),s(t,Kt,e),y(O,t,e),s(t,te,e),s(t,K,e),s(t,ee,e),s(t,A,e),m(A,$),m($,$t),y(tt,$t,null),m(A,Be),m(A,It),s(t,le,e),s(t,et,e),s(t,se,e),s(t,lt,e),s(t,ae,e),s(t,st,e),s(t,ne,e),s(t,at,e),s(t,Me,e),s(t,nt,e),s(t,pe,e),y(Mt,t,e),s(t,ie,e),s(t,pt,e),s(t,re,e),y(it,t,e),s(t,oe,e),s(t,rt,e),s(t,ue,e),y(ot,t,e),s(t,me,e),s(t,ut,e),s(t,ye,e),y(mt,t,e),s(t,ce,e),s(t,yt,e),s(t,je,e),s(t,ct,e),s(t,he,e),y(jt,t,e),s(t,Je,e),s(t,_,e),s(t,de,e),s(t,ht,e),s(t,Ue,e),s(t,Jt,e),s(t,fe,e),s(t,dt,e),s(t,Te,e),y(Ut,t,e),s(t,we,e),s(t,ft,e),s(t,Ce,e),s(t,_t,e),Ae=!0},p(t,[e]){const Tt={};e&2&&(Tt.$$scope={dirty:e,ctx:t}),v.$set(Tt)},i(t){Ae||(c(B.$$.fragment,t),c(R.$$.fragment,t),c(E.$$.fragment,t),c(X.$$.fragment,t),c(V.$$.fragment,t),c(v.$$.fragment,t),c(Q.$$.fragment,t),c(F.$$.fragment,t),c(D.$$.fragment,t),c(O.$$.fragment,t),c(tt.$$.fragment,t),c(Mt.$$.fragment,t),c(it.$$.fragment,t),c(ot.$$.fragment,t),c(mt.$$.fragment,t),c(jt.$$.fragment,t),c(Ut.$$.fragment,t),Ae=!0)},o(t){j(B.$$.fragment,t),j(R.$$.fragment,t),j(E.$$.fragment,t),j(X.$$.fragment,t),j(V.$$.fragment,t),j(v.$$.fragment,t),j(Q.$$.fragment,t),j(F.$$.fragment,t),j(D.$$.fragment,t),j(O.$$.fragment,t),j(tt.$$.fragment,t),j(Mt.$$.fragment,t),j(it.$$.fragment,t),j(ot.$$.fragment,t),j(mt.$$.fragment,t),j(jt.$$.fragment,t),j(Ut.$$.fragment,t),Ae=!1},d(t){t&&(l(f),l(k),l(Bt),l(T),l(gt),l(g),l(Zt),l(Z),l(Rt),l(w),l(Gt),l(G),l(Wt),l(W),l(Nt),l(N),l(Et),l(Ht),l(H),l(Xt),l(zt),l(z),l(Vt),l(Yt),l(Y),l(Qt),l(qt),l(C),l(St),l(q),l(Ft),l(S),l(Lt),l(Dt),l(L),l(Pt),l(Ot),l(P),l(Kt),l(te),l(K),l(ee),l(A),l(le),l(et),l(se),l(lt),l(ae),l(st),l(ne),l(at),l(Me),l(nt),l(pe),l(ie),l(pt),l(re),l(oe),l(rt),l(ue),l(me),l(ut),l(ye),l(ce),l(yt),l(je),l(ct),l(he),l(Je),l(_),l(de),l(ht),l(Ue),l(Jt),l(fe),l(dt),l(Te),l(we),l(ft),l(Ce),l(_t)),l(J),h(B),h(R),h(E,t),h(X,t),h(V,t),h(v,t),h(Q),h(F,t),h(D,t),h(O,t),h(tt),h(Mt,t),h(it,t),h(ot,t),h(mt,t),h(jt,t),h(Ut,t)}}}const $l={local:"preprocessing-an-audio-dataset",sections:[{local:"resampling-the-audio-data",title:"오디오 데이터 리샘플링하기"},{local:"filtering-the-dataset",title:"데이터셋 필터링하기"},{local:"pre-processing-audio-data",title:"오디오 데이터 전처리하기"}],title:"오디오 데이터셋 전처리하기"};function _l(kt){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gl extends Tl{constructor(J){super(),wl(this,J,_l,xl,Ul,{})}}export{Gl as component};
