import{s as za,n as Xa,o as qa}from"../chunks/scheduler.f7e1785c.js";import{S as Da,i as Oa,g as p,s as a,u as J,m as Q,H as ws,A as Pa,h as M,f as e,c as n,j as b,y as i,v as U,n as V,E as rs,k as j,o as m,a as s,w as y,d as T,t as h,x as o}from"../chunks/index.815a732f.js";import{I as _a}from"../chunks/IconCopyLink.e7937f56.js";import{C as w}from"../chunks/CodeBlock.c6e8b464.js";function Ka(bs){let d,jt,wt,dt,C,Cs="Предварительно обученные модели для распознавания речи",ut,R,fs=`В этом разделе мы рассмотрим, как с помощью <code>pipeline()</code> использовать предварительно обученные модели для распознавания речи.
В <a href="../chapter2/asr_pipeline">Разделе 2</a> мы представили <code>pipeline()</code> как простой способ выполнения задач распознавания речи с предварительной
и последующей обработкой “под капотом” и возможностью быстро экспериментировать с любой предварительно обученной контрольной точкой модели на Hugging Face Hub.
В этом разделе мы углубимся в изучение различных характеристик моделей распознавания речи и рассмотрим, как их можно использовать для решения различных задач.`,It,k,xs="Как подробно описано в Разделе 3, модели распознавания речи в целом относятся к одной из двух категорий:",bt,G,Es="<li>Connectionist Temporal Classification (CTC) или Коннекционистская Временная Классификация: модели состящие только из энкодера, с головой линейного классификатора в вершине модели.</li> <li>Sequence-to-sequence (Seq2Seq) или последовательность-в-последовательность: модели включающие в себя как энкодер, так и декодер с механизмом перекрестного внимания между ними (cross-attention).</li>",Ct,g,Ss=`До 2022 года более популярной из двух архитектур была CTC, а такие модели, работающие только с энкодером, как Wav2Vec2, HuBERT и XLSR, совершили прорыв в парадигме
предварительного обучения/дообучения в задачах с речью. Крупные корпорации, такие как Meta и Microsoft, предварительно обучали энкодер на огромных объемах
неразмеченных аудиоданных в течение многих дней или недель. Затем пользователи могли взять предварительно обученную контрольную точку и дообучить ее с помощью
головы CTC всего на <strong>10 минутах</strong> размеченных речевых данных для достижения высоких результатов в последующей задаче распознавания речи.`,ft,F,Bs=`Однако модели CTC имеют свои недостатки. Присоединение простого линейного слоя к кодирующему устройству дает небольшую и быструю модель в целом, но она может
быть подвержена фонетическим ошибкам в написании. Ниже мы продемонстрируем это на примере модели Wav2Vec2.`,xt,u,f,rt,H,ms,yt,vs="Анализ моделей CTC",Et,$,Qs=`Загрузим небольшой фрагмент набора данных <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> чтобы продемонстрировать возможности Wav2Vec2
по транскрибации речи:`,St,W,Bt,Z,Vs="<strong>Output:</strong>",vt,_,Qt,N,Rs="Мы можем выбрать один из 73 аудиообразцов и просмотреть его, а также транскрипцию:",Vt,Y,Rt,A,ks="<strong>Output:</strong>",kt,L,Gt,z,Gs=`Хорошо! Рождество и запеченная в духовке говядина, звучит здорово! 🎄 Сформировав выборку данных, мы теперь загружаем
дообученную контрольную точку в <code>pipeline()</code>. Для этого мы будем использовать официальную контрольную точку <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a>
дообученную на 100 часах данных LibriSpeech:`,gt,X,Ft,q,gs=`Далее мы возьмем пример из набора данных и передадим его исходные данные в конвейер. Поскольку <code>pipeline</code> <em>поглощает</em> любой словарь, который мы ему
передаем (то есть его нельзя использовать повторно), мы будем передавать копию данных. Таким образом, мы можем безопасно повторно использовать один
и тот же аудиообразец в следующих примерах:`,Ht,D,$t,O,Fs="<strong>Output:</strong>",Wt,P,Zt,K,Hs=`Видно, что модель Wav2Vec2 неплохо справляется с транскрибацией данного образца - на первый взгляд, все выглядит в целом корректно.
Давайте поставим целевое значение (target) и прогноз/предсказание модели (prediction) рядом и выделим различия:`,_t,ll,Nt,tl,$s="Сравнивая целевой текст с предсказанной транскрибацией, мы видим, что все слова <em>звучат</em> правильно, но некоторые написаны не совсем точно. Например:",Yt,el,Ws="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",At,sl,Zs=`Это подчеркивает недостаток модели CTC. Модель CTC - это, по сути, “только акустическая” модель: она состоит из энкодера, который формирует представления
скрытых состояний из аудиовходов, и линейного слоя, который отображает скрытые состояния в символы:`,Lt,al,_s=`Это означает, что система практически полностью основывает свое предсказание на акустических данных (фонетических звуках аудиозаписи) и поэтому склонна
транскрибировать аудиозапись фонетическим способом (например, <em>CHRISTMAUS</em>). В нем меньше внимания уделяется языковому моделирующему контексту предыдущих
и последующих букв, поэтому он склонен к фонетическим ошибкам в написании. Более интеллектуальная модель определила бы, что <em>CHRISTMAUS</em> не является
правильным словом в английском словаре, и исправила бы его на <em>CHRISTMAS</em>, когда делала бы свои предсказания. Кроме того, в нашем прогнозировании отсутствуют
два важных признака - регистр и пунктуация, что ограничивает полезность транскрибации модели для реальных приложений.`,zt,I,x,mt,nl,cs,Tt,Ns="Переход к Seq2Seq",Xt,pl,Ys=`Модели Seq2Seq! Как было описано в Разделе 3, модели Seq2Seq состоят из энкодера и декодера, связанных между собой механизмом перекрестного внимания.
Энкодер играет ту же роль, что и раньше, вычисляя представления скрытых состояний аудиовходов, а декодер - роль <strong>языковой модели</strong>. Декодер обрабатывает
всю последовательность представлений скрытых состояний, полученных от энкодера, и формирует соответствующие текстовые транскрипции. Имея глобальный контекст
входного аудиосигнала, декодер может использовать контекст языкового моделирования при составлении своих прогнозов, исправляя орфографические ошибки
“на лету” и тем самым обходя проблему фонетических прогнозов.`,qt,Ml,As="У моделей Seq2Seq есть два недостатка:",Dt,il,Ls="<li>Они изначально медленнее декодируют, поскольку процесс декодирования происходит по одному шагу за раз, а не все сразу</li> <li>Они более требовательны к данным, для достижения сходимости им требуется значительно больше обучающих данных</li>",Ot,Jl,zs=`В частности, узким местом в развитии архитектур Seq2Seq для задач с речью является потребность в больших объемах обучающих данных. Размеченные речевые данные
труднодоступны, самые большие аннотированные базы данных на тот момент составляли всего 10 000 часов. Все изменилось в 2022 году после выхода <strong>Whisper</strong>.
Whisper - это предварительно обученная модель для распознавания речи, опубликованная в <a href="https://openai.com/blog/whisper/" rel="nofollow">Сентябре 2022</a> авторами Alec Radford
и др. из компании OpenAI. В отличие от предшественников CTC, которые обучались исключительно на <strong>неразмеченных</strong> аудиоданных, Whisper предварительно обучен
на огромном количестве <strong>размеченных</strong> данных аудиотранскрипции, а именно на 680 000 часов.`,Pt,Ul,Xs=`Это на порядок больше данных, чем неразмеченные аудиоданные, использованные для обучения Wav2Vec 2.0 (60 000 часов). Более того, 117 000 часов этих данных,
предназначенных для предварительного обучения, являются мультиязычными (или “не английскими”) данными. В результате контрольные точки могут быть применены
к более чем 96 языкам, многие из которых считаются <em>низкоресурсными</em>, т.е. не имеющими большого корпуса данных, пригодных для обучения.`,Kt,yl,qs=`При масштабировании на 680 000 часов аннотированных данных для предварительного обучения модели Whisper демонстрируют высокую способность к обобщению
на многие наборы данных и области. Предварительно обученные контрольные точки достигают результатов, конкурентоспособных с state-of-the-art pipe systems,
с коэффициентом ошибок в словах (WER) около 3% на подмножестве чистых тестов LibriSpeech и новым рекордом на TED-LIUM с WER 4,7%
(см. табл. 8 <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper paper</a>).`,le,Tl,Ds=`Особое значение имеет способность Whisper работать с длинными аудиообразцами, устойчивость к входным шумам и возможность предсказывать транскрипцию с
использованием падежей и пунктуации. Это делает его перспективным для использования в реальных системах распознавания речи.`,te,hl,Os=`В оставшейся части этого раздела будет показано, как использовать предварительно обученные модели Whisper для распознавания речи с помощью 🤗 Transformers.
Во многих ситуациях предварительно обученные контрольные точки Whisper обладают высокой производительностью и дают отличные результаты, поэтому мы
рекомендуем вам попробовать использовать предварительно обученные контрольные точки в качестве первого шага к решению любой задачи распознавания речи.
Благодаря дообучению предварительно обученные контрольные точки могут быть адаптированы для конкретных наборов данных и языков с целью дальнейшего
улучшения результатов. Как это сделать, мы продемонстрируем в следующем подразделе, посвященном [дообучению] (fine-tuning).`,ee,ol,Ps=`Контрольные точки модели Whisper доступны в пяти конфигурациях с различными размерами модели. Наименьшие по параметрам четыре модели обучаются либо
только на английском, либо на многоязычных данных. Самая большая по параметрам контрольная точка была обучена только на мультиязычных данных.
Все девять предварительно обученных контрольных точек доступны на <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a>. Контрольные
точки приведены в следующей таблице со ссылками на модели на Hugging Face Hub. “VRAM” обозначает объем памяти GPU, необходимый для работы модели с
минимальным размером пакета = 1. “Rel Speed” - относительная скорость контрольной точки по сравнению с самой большой моделью. На основе этой информации
можно выбрать контрольную точку, наиболее подходящую для вашего оборудования.`,se,wl,Ks='<thead><tr><th>Size</th> <th>Parameters</th> <th>VRAM / GB</th> <th>Rel Speed</th> <th>English-only</th> <th>Multilingual</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',ae,rl,la=`Загрузим контрольную точку <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a>, которая по размеру сопоставима с контрольной точкой Wav2Vec2, которую
мы использовали ранее. Предваряя наш переход к многоязычному распознаванию речи, загрузим многоязычный вариант базовой контрольной точки. Мы также загрузим
модель на GPU, если он доступен, или на CPU в противном случае. В последствии <code>pipeline()</code> позаботится о перемещении всех входов/выходов с CPU на GPU по мере
необходимости:`,ne,ml,pe,cl,ta=`Отлично! Теперь давайте транскрибируем аудиозапись, как и раньше. Единственное изменение - это передача дополнительного аргумента <code>max_new_tokens</code>, который
указывает модели максимальное количество токенов, которые нужно генерировать при предсказании:`,Me,jl,ie,dl,ea="<strong>Output:</strong>",Je,ul,Ue,Il,sa=`Достаточно легко! Первое, на что вы обратите внимание, - это наличие как регистра, так и знаков препинания. Это сразу же делает транскрипцию более удобной для
чтения по сравнению с транскрипцией из Wav2Vec2, не содержащей ни регистра, ни пунктуации. Давайте поместим транскрипцию рядом с целевой меткой:`,ye,bl,Te,Cl,aa=`Whisper проделал большую работу по исправлению фонетических ошибок, которые мы видели в Wav2Vec2 - и <em>Christmas</em>, и <em>roast</em> написаны правильно.
Мы видим, что модель все еще испытывает трудности с <em>SIMILES</em>, которое неправильно транскрибируется как <em>similarly</em>, но на этот раз предсказание
является правильным словом из английского словаря. Использование контрольной точки Whisper большего размера позволяет еще больше снизить количество
ошибок в транскрибированном тексте, но при этом требует больше вычислений и увеличивает время транскрибации.`,he,fl,na=`Нам обещали модель, способную работать с 96 языками, так что оставим пока распознавание английской речи и пойдем по миру 🌎! Набор данных <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a>
(MLS) представляет собой многоязычный аналог набора данных LibriSpeech, содержащий размеченные аудиоданные на шести языках. Мы загрузим одну
образец из испанской части набора данных MLS, используя режим <em>streaming</em>, чтобы не загружать весь набор данных:`,oe,xl,we,El,pa="Снова посмотрим текстовую транскрипцию и прослушаем аудиофрагмент:",re,Sl,me,Bl,Ma="<strong>Output:</strong>",ce,vl,je,Ql,ia=`Это целевой текст, на который мы ориентируемся в нашей транскрипции Whisper. Хотя теперь мы знаем, что, вероятно, можем сделать это лучше,
поскольку наша модель будет предсказывать также пунктуацию и регистр, которые в выводе примера отсутствуют. Передадим образец звука в конвейер для
получения предсказания текста. Следует отметить, что конвейер <em>потребует</em> словарь аудиовходов, который мы вводим, то есть словарь не может
быть использован повторно. Чтобы обойти эту проблему, мы будем передавать <em>копию</em> аудиообразца, что позволит нам повторно использовать тот же самый
аудиообразец в последующих примерах кода:`,de,Vl,ue,Rl,Ja="<strong>Output:</strong>",Ie,kl,be,Gl,Ua=`Отлично - это очень похоже на наш целевой текст (возможно, даже лучше, поскольку в нем есть пунктуация и регистр!). Обратите внимание, что мы передали
<code>&quot;task&quot;</code> в качестве аргумента <em>генерируемого ключевого слова</em> (generate kwarg). Передача ключу <code>&quot;task&quot;</code> значения <code>&quot;transcribe&quot;</code> заставляет Whisper
выполнять задачу <em>распознавания речи</em>, при которой аудиозапись транскрибируется на том же языке, на котором была произнесена речь. Whisper также
способен выполнять тесно связанную с задачу - <em>перевода речи</em>, когда аудиозапись на испанском языке может быть переведена в текст на английском.
Для этого мы передаем ключу <code>&quot;task&quot;</code> значение <code>&quot;translate&quot;</code>:`,Ce,gl,fe,Fl,ya="<strong>Output:</strong>",xe,Hl,Ee,$l,Ta=`Теперь, когда мы знаем, что можем переключаться между распознаванием речи и ее переводом, мы можем выбирать задачу в зависимости от наших потребностей.
Либо мы распознаем звук на языке X в текст на том же языке X (например, испанский звук в испанский текст), либо переводим с любого языка X в текст
на английском языке (например, испанский звук в английский текст).`,Se,Wl,ha=`Подробнее о том, как аргумент <code>&quot;task&quot;</code> используется для управления свойствами генерируемого текста, см. в <a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">карточке модели</a>
для базовой модели Whisper.`,Be,E,oa="Длинноформатная транскрипция и временные метки",ve,Zl,wa=`Пока мы были сосредоточены на транскрибации коротких аудиофрагментов длительностью менее 30 секунд. Мы уже упоминали, что одной из привлекательных
сторон Whisper является возможность работы с длинными аудиофрагментами. В этой части раздела мы рассмотрим эту задачу!`,Qe,_l,ra=`Создадим длинный аудиофайл путем конкатенации последовательных выборок из набора данных MLS. Поскольку набор данных MLS формируется путем разбиения
длинных записей аудиокниг на более короткие сегменты, конкатенация образцов является одним из способов реконструкции более длинных отрывков аудиокниг.
Следовательно, результирующий звук должен быть когерентным по всей выборке.`,Ve,Nl,ma="Мы установим целевую длительность звука в 5 минут и прекратим конкатенацию сэмплов, как только достигнем этого значения:",Re,Yl,ke,Al,ca="<strong>Output:</strong>",Ge,Ll,ge,zl,ja=`Отлично! Осталось транскрибировать 5 минут 17 секунд аудиозаписи. При передаче такого длинного аудиофрагмента непосредственно в модель
возникают две проблемы:`,Fe,Xl,da="<li>Whisper изначально рассчитан на работу с 30-секундными образцами: все, что короче 30 секунд, заполняется тишиной, все, что длиннее 30 секунд, усекается до 30 секунд путем вырезания лишнего звука, поэтому если мы передадим наш звук напрямую, то получим транскрипцию только первых 30 секунд</li> <li>Память в сети трансформера зависит от квадрата длины последовательности: удвоение длины входного сигнала увеличивает потребность в памяти в четыре раза, поэтому передача очень длинных аудиофайлов обязательно приведет к ошибке “вне памяти” (out-of-memory)</li>",He,ql,ua=`Длинная транскрибация в 🤗 Transformers осуществляется путем <em>фрагментации</em> (от англ. chunking) входного аудио на более мелкие и управляемые фрагменты.
Каждый фрагмент имеет небольшое наложение с предыдущим. Это позволяет нам точно соединять фрагменты на границах,
так как мы можем найти наложение между фрагментами и соответствующим образом объединить транскрипции:`,$e,S,Ia='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',We,r,js,Ze,Na='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',_e,Ne,Ya='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Ye,ht,ba="нестационарный",ds,Ae,Aa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Le,ze,La='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Xe,ot,Ca="пакетировать",us,B,fa="посте из блога",Is,qe,Dl,xa=`Для активации длинных транскрипций необходимо добавить один дополнительный аргумент при вызове конвейера. Этот аргумент, <code>chunk_length_s</code>,
определяет длину фрагментов в секундах. Для Whisper оптимальной является 30-секундная длина фрагментов, поскольку она соответствует длине
входного сигнала, ожидаемого Whisper.`,De,Ol,Ea=`Чтобы активизировать пакетную обработку, необходимо передать конвейеру аргумент <code>batch_size</code>. Если собрать все это воедино,
то транскрибация длинного аудиообразца с использованием чанкинга и батчинга может быть выполнена следующим образом:`,Oe,Pl,Pe,Kl,Sa="<strong>Output:</strong>",Ke,lt,ls,tt,Ba=`Мы не будем приводить здесь весь результат, поскольку он довольно длинный (всего 312 слов)! На графическом процессоре V100
с памятью 16 Гбайт выполнение приведенной выше строки займет примерно 3,45 секунды, что весьма неплохо для 317-секундного аудиообразца.
На CPU ожидается около 30 секунд.`,ts,et,va=`Whisper также способен предсказывать <em>временные метки</em> на уровне фрагментов для аудиоданных. Эти временные метки указывают на время начала
и окончания короткого отрывка аудиозаписи и особенно полезны для выравнивания транскрипции с входным аудиосигналом. Предположим, мы хотим
создать субтитры для видео - нам нужны эти временные метки, чтобы знать, какая часть транскрипции соответствует определенному
сегменту видео, чтобы отобразить правильную транскрипцию для этого времени.`,es,st,Qa=`Активировать предсказание временных меток очень просто, достаточно установить аргумент <code>return_timestamps=True</code>. Временные метки совместимы
с методами фрагментирования и пакетирования, которые мы использовали ранее, поэтому мы можем просто добавить аргумент timestamp к нашему
предыдущему вызову:`,ss,at,as,nt,Va="<strong>Output:</strong>",ns,pt,ps,Mt,Ra="И вуаля! У нас есть предсказанный текст и соответствующие временные метки.",Ms,v,ka="Итоги",is,it,Ga=`Whisper - это сильная предварительно обученная модель для распознавания и перевода речи. По сравнению с Wav2Vec2, он обладает более
высокой точностью транскрибации, при этом выходные данные содержат знаки препинания и регистр. Он может использоваться для транскрибации
речи на английском и 96 других языках, как на коротких аудиофрагментах, так и на более длинных за счет <em>фрагментирования</em>. Эти качества делают
его подходящей моделью для многих задач распознавания речи и перевода без необходимости дообучения. Метод <code>pipeline()</code> обеспечивает простой
способ выполнения выводов в виде однострочных вызовов API с контролем над генерируемыми предсказаниями.`,Js,Jt,ga=`В то время как модель Whisper демонстрирует отличные результаты на многих языках с большим количеством ресурсов, она имеет более низкую
точность транскрибации и перевода на языках с малым количеством ресурсов, т.е. на языках с меньшим количеством доступных обучающих данных.
Кроме того, существуют различия в результатах работы с разными акцентами и диалектами некоторых языков, включая более низкую точность для
носителей разных полов, рас, возрастов и других демографических критериев (например, <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper paper</a>).`,Us,Ut,Fa=`Для повышения производительности при работе с языками, акцентами или диалектами, не имеющими достаточного количества ресурсов, мы можем взять
предварительно обученную модель Whisper и обучить ее на небольшом корпусе данных, подобранных соответствующим образом, в процессе,
называемом <em>дообучением</em>. Мы покажем, что всего десять часов дополнительных данных позволяют повысить производительность модели Whisper более
чем на 100% на языке с низким уровнем ресурсов. В следующей секции мы рассмотрим процесс выбора набора данных для дообучения модели.`,ys,ct,Ts;return H=new _a({}),W=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`}}),_=new w({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`}}),Y=new w({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),L=new w({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND'}}),X=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`}}),D=new w({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())'}}),P=new w({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>'}}),ll=new w({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`}}),nl=new _a({}),ml=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`}}),jl=new w({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)'}}),ul=new w({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}'}}),bl=new w({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`}}),xl=new w({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`}}),Sl=new w({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`}}),vl=new w({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado'}}),Vl=new w({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})'}}),kl=new w({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}'}}),gl=new w({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})'}}),Hl=new w({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>'}}),Yl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># преобразование из минут в секунды (* 60) в число выборок (* частота дискретизации)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># итерируемся по нашему потоковому набору данных, конкатенируя выборки до тех пор, пока мы не достигнем нашей цели</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># что у нас получилось?</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`}}),Ll=new w({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds'}}),Pl=new w({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`}}),lt=new w({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`}}),at=new w({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`}}),pt=new w({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`}}),{c(){d=p("meta"),jt=a(),wt=p("p"),dt=a(),C=p("h1"),C.textContent=Cs,ut=a(),R=p("p"),R.innerHTML=fs,It=a(),k=p("p"),k.textContent=xs,bt=a(),G=p("ol"),G.innerHTML=Es,Ct=a(),g=p("p"),g.innerHTML=Ss,ft=a(),F=p("p"),F.textContent=Bs,xt=a(),u=p("h2"),f=p("a"),rt=p("span"),J(H.$$.fragment),ms=a(),yt=p("span"),yt.textContent=vs,Et=a(),$=p("p"),$.innerHTML=Qs,St=a(),J(W.$$.fragment),Bt=a(),Z=p("p"),Z.innerHTML=Vs,vt=a(),J(_.$$.fragment),Qt=a(),N=p("p"),N.textContent=Rs,Vt=a(),J(Y.$$.fragment),Rt=a(),A=p("p"),A.innerHTML=ks,kt=a(),J(L.$$.fragment),Gt=a(),z=p("p"),z.innerHTML=Gs,gt=a(),J(X.$$.fragment),Ft=a(),q=p("p"),q.innerHTML=gs,Ht=a(),J(D.$$.fragment),$t=a(),O=p("p"),O.innerHTML=Fs,Wt=a(),J(P.$$.fragment),Zt=a(),K=p("p"),K.textContent=Hs,_t=a(),J(ll.$$.fragment),Nt=a(),tl=p("p"),tl.innerHTML=$s,Yt=a(),el=p("ul"),el.innerHTML=Ws,At=a(),sl=p("p"),sl.textContent=Zs,Lt=a(),al=p("p"),al.innerHTML=_s,zt=a(),I=p("h2"),x=p("a"),mt=p("span"),J(nl.$$.fragment),cs=a(),Tt=p("span"),Tt.textContent=Ns,Xt=a(),pl=p("p"),pl.innerHTML=Ys,qt=a(),Ml=p("p"),Ml.textContent=As,Dt=a(),il=p("ol"),il.innerHTML=Ls,Ot=a(),Jl=p("p"),Jl.innerHTML=zs,Pt=a(),Ul=p("p"),Ul.innerHTML=Xs,Kt=a(),yl=p("p"),yl.innerHTML=qs,le=a(),Tl=p("p"),Tl.textContent=Ds,te=a(),hl=p("p"),hl.textContent=Os,ee=a(),ol=p("p"),ol.innerHTML=Ps,se=a(),wl=p("table"),wl.innerHTML=Ks,ae=a(),rl=p("p"),rl.innerHTML=la,ne=a(),J(ml.$$.fragment),pe=a(),cl=p("p"),cl.innerHTML=ta,Me=a(),J(jl.$$.fragment),ie=a(),dl=p("p"),dl.innerHTML=ea,Je=a(),J(ul.$$.fragment),Ue=a(),Il=p("p"),Il.textContent=sa,ye=a(),J(bl.$$.fragment),Te=a(),Cl=p("p"),Cl.innerHTML=aa,he=a(),fl=p("p"),fl.innerHTML=na,oe=a(),J(xl.$$.fragment),we=a(),El=p("p"),El.textContent=pa,re=a(),J(Sl.$$.fragment),me=a(),Bl=p("p"),Bl.innerHTML=Ma,ce=a(),J(vl.$$.fragment),je=a(),Ql=p("p"),Ql.innerHTML=ia,de=a(),J(Vl.$$.fragment),ue=a(),Rl=p("p"),Rl.innerHTML=Ja,Ie=a(),J(kl.$$.fragment),be=a(),Gl=p("p"),Gl.innerHTML=Ua,Ce=a(),J(gl.$$.fragment),fe=a(),Fl=p("p"),Fl.innerHTML=ya,xe=a(),J(Hl.$$.fragment),Ee=a(),$l=p("p"),$l.textContent=Ta,Se=a(),Wl=p("p"),Wl.innerHTML=ha,Be=a(),E=p("h2"),E.textContent=oa,ve=a(),Zl=p("p"),Zl.textContent=wa,Qe=a(),_l=p("p"),_l.textContent=ra,Ve=a(),Nl=p("p"),Nl.textContent=ma,Re=a(),J(Yl.$$.fragment),ke=a(),Al=p("p"),Al.innerHTML=ca,Ge=a(),J(Ll.$$.fragment),ge=a(),zl=p("p"),zl.textContent=ja,Fe=a(),Xl=p("ol"),Xl.innerHTML=da,He=a(),ql=p("p"),ql.innerHTML=ua,$e=a(),S=p("div"),S.innerHTML=Ia,We=a(),r=p("p"),js=Q("Преимущество фрагментирования аудиообразцов на части заключается в том, что нам не нужен результат транскрибации небольшого фрагмента аудиосигнала "),Ze=new ws(!1),_e=Q(`
для транскрибации последующего фрагмента `),Ne=new ws(!1),Ye=Q(`. Соединение выполняется после того, как мы
транскрибировали все фрагменты на границах фрагментов, поэтому не имеет значения, в каком порядке мы их транскрибируем. Алгоритм полностью `),ht=p("strong"),ht.textContent=ba,ds=Q(`,
поэтому мы можем даже обрабатывать фрагмент `),Ae=new ws(!1),Le=Q(" одновременно с фрагментом "),ze=new ws(!1),Xe=Q("! Это позволяет нам "),ot=p("em"),ot.textContent=Ca,us=Q(` (от англ. batch) фрагменты
и прогонять их через модель параллельно, обеспечивая значительное ускорение вычислений по сравнению с их последовательной транскрибацией. Более подробно
о фрагментированни в 🤗 Transformers можно прочитать в `),B=p("a"),B.textContent=fa,Is=Q("."),qe=a(),Dl=p("p"),Dl.innerHTML=xa,De=a(),Ol=p("p"),Ol.innerHTML=Ea,Oe=a(),J(Pl.$$.fragment),Pe=a(),Kl=p("p"),Kl.innerHTML=Sa,Ke=a(),J(lt.$$.fragment),ls=a(),tt=p("p"),tt.textContent=Ba,ts=a(),et=p("p"),et.innerHTML=va,es=a(),st=p("p"),st.innerHTML=Qa,ss=a(),J(at.$$.fragment),as=a(),nt=p("p"),nt.innerHTML=Va,ns=a(),J(pt.$$.fragment),ps=a(),Mt=p("p"),Mt.textContent=Ra,Ms=a(),v=p("h2"),v.textContent=ka,is=a(),it=p("p"),it.innerHTML=Ga,Js=a(),Jt=p("p"),Jt.innerHTML=ga,Us=a(),Ut=p("p"),Ut.innerHTML=Fa,ys=a(),ct=p("p"),this.h()},l(l){const t=Pa("svelte-1phssyn",document.head);d=M(t,"META",{name:!0,content:!0}),t.forEach(e),jt=n(l),wt=M(l,"P",{}),b(wt).forEach(e),dt=n(l),C=M(l,"H1",{id:!0,"data-svelte-h":!0}),i(C)!=="svelte-1uticbz"&&(C.textContent=Cs),ut=n(l),R=M(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1gtvm8h"&&(R.innerHTML=fs),It=n(l),k=M(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-6jcjni"&&(k.textContent=xs),bt=n(l),G=M(l,"OL",{"data-svelte-h":!0}),i(G)!=="svelte-bjelpo"&&(G.innerHTML=Es),Ct=n(l),g=M(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1vky12r"&&(g.innerHTML=Ss),ft=n(l),F=M(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1vi57w3"&&(F.textContent=Bs),xt=n(l),u=M(l,"H2",{class:!0});var hs=b(u);f=M(hs,"A",{id:!0,class:!0,href:!0});var Ha=b(f);rt=M(Ha,"SPAN",{});var $a=b(rt);U(H.$$.fragment,$a),$a.forEach(e),Ha.forEach(e),ms=n(hs),yt=M(hs,"SPAN",{"data-svelte-h":!0}),i(yt)!=="svelte-1hjkhp0"&&(yt.textContent=vs),hs.forEach(e),Et=n(l),$=M(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-5khewd"&&($.innerHTML=Qs),St=n(l),U(W.$$.fragment,l),Bt=n(l),Z=M(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1mvdyro"&&(Z.innerHTML=Vs),vt=n(l),U(_.$$.fragment,l),Qt=n(l),N=M(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1ibu3ww"&&(N.textContent=Rs),Vt=n(l),U(Y.$$.fragment,l),Rt=n(l),A=M(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1mvdyro"&&(A.innerHTML=ks),kt=n(l),U(L.$$.fragment,l),Gt=n(l),z=M(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-aibedu"&&(z.innerHTML=Gs),gt=n(l),U(X.$$.fragment,l),Ft=n(l),q=M(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-i8aadp"&&(q.innerHTML=gs),Ht=n(l),U(D.$$.fragment,l),$t=n(l),O=M(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1mvdyro"&&(O.innerHTML=Fs),Wt=n(l),U(P.$$.fragment,l),Zt=n(l),K=M(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-htuiqs"&&(K.textContent=Hs),_t=n(l),U(ll.$$.fragment,l),Nt=n(l),tl=M(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-10h19k1"&&(tl.innerHTML=$s),Yt=n(l),el=M(l,"UL",{"data-svelte-h":!0}),i(el)!=="svelte-11mc7qy"&&(el.innerHTML=Ws),At=n(l),sl=M(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-qu6mk6"&&(sl.textContent=Zs),Lt=n(l),al=M(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-sq2gy5"&&(al.innerHTML=_s),zt=n(l),I=M(l,"H2",{class:!0});var os=b(I);x=M(os,"A",{id:!0,class:!0,href:!0});var Wa=b(x);mt=M(Wa,"SPAN",{});var Za=b(mt);U(nl.$$.fragment,Za),Za.forEach(e),Wa.forEach(e),cs=n(os),Tt=M(os,"SPAN",{"data-svelte-h":!0}),i(Tt)!=="svelte-kzbzkf"&&(Tt.textContent=Ns),os.forEach(e),Xt=n(l),pl=M(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1i2fk02"&&(pl.innerHTML=Ys),qt=n(l),Ml=M(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-1ifxb88"&&(Ml.textContent=As),Dt=n(l),il=M(l,"OL",{"data-svelte-h":!0}),i(il)!=="svelte-71blpy"&&(il.innerHTML=Ls),Ot=n(l),Jl=M(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-1qrj0ya"&&(Jl.innerHTML=zs),Pt=n(l),Ul=M(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-15998yu"&&(Ul.innerHTML=Xs),Kt=n(l),yl=M(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-1qtehni"&&(yl.innerHTML=qs),le=n(l),Tl=M(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-el2qut"&&(Tl.textContent=Ds),te=n(l),hl=M(l,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-1j2fp4v"&&(hl.textContent=Os),ee=n(l),ol=M(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1bqbmak"&&(ol.innerHTML=Ps),se=n(l),wl=M(l,"TABLE",{"data-svelte-h":!0}),i(wl)!=="svelte-leifmh"&&(wl.innerHTML=Ks),ae=n(l),rl=M(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-7zg689"&&(rl.innerHTML=la),ne=n(l),U(ml.$$.fragment,l),pe=n(l),cl=M(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-1ilagb0"&&(cl.innerHTML=ta),Me=n(l),U(jl.$$.fragment,l),ie=n(l),dl=M(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-1mvdyro"&&(dl.innerHTML=ea),Je=n(l),U(ul.$$.fragment,l),Ue=n(l),Il=M(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-cuywh6"&&(Il.textContent=sa),ye=n(l),U(bl.$$.fragment,l),Te=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-18d7cq3"&&(Cl.innerHTML=aa),he=n(l),fl=M(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1bh6i43"&&(fl.innerHTML=na),oe=n(l),U(xl.$$.fragment,l),we=n(l),El=M(l,"P",{"data-svelte-h":!0}),i(El)!=="svelte-1q4wmmh"&&(El.textContent=pa),re=n(l),U(Sl.$$.fragment,l),me=n(l),Bl=M(l,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-1mvdyro"&&(Bl.innerHTML=Ma),ce=n(l),U(vl.$$.fragment,l),je=n(l),Ql=M(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-14g7j7g"&&(Ql.innerHTML=ia),de=n(l),U(Vl.$$.fragment,l),ue=n(l),Rl=M(l,"P",{"data-svelte-h":!0}),i(Rl)!=="svelte-1mvdyro"&&(Rl.innerHTML=Ja),Ie=n(l),U(kl.$$.fragment,l),be=n(l),Gl=M(l,"P",{"data-svelte-h":!0}),i(Gl)!=="svelte-j49oek"&&(Gl.innerHTML=Ua),Ce=n(l),U(gl.$$.fragment,l),fe=n(l),Fl=M(l,"P",{"data-svelte-h":!0}),i(Fl)!=="svelte-1mvdyro"&&(Fl.innerHTML=ya),xe=n(l),U(Hl.$$.fragment,l),Ee=n(l),$l=M(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-iwrqcj"&&($l.textContent=Ta),Se=n(l),Wl=M(l,"P",{"data-svelte-h":!0}),i(Wl)!=="svelte-17xpsvz"&&(Wl.innerHTML=ha),Be=n(l),E=M(l,"H2",{id:!0,"data-svelte-h":!0}),i(E)!=="svelte-iihfiy"&&(E.textContent=oa),ve=n(l),Zl=M(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-z1wxhe"&&(Zl.textContent=wa),Qe=n(l),_l=M(l,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-1dkwyap"&&(_l.textContent=ra),Ve=n(l),Nl=M(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-1tfnh52"&&(Nl.textContent=ma),Re=n(l),U(Yl.$$.fragment,l),ke=n(l),Al=M(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-1mvdyro"&&(Al.innerHTML=ca),Ge=n(l),U(Ll.$$.fragment,l),ge=n(l),zl=M(l,"P",{"data-svelte-h":!0}),i(zl)!=="svelte-wptioh"&&(zl.textContent=ja),Fe=n(l),Xl=M(l,"OL",{"data-svelte-h":!0}),i(Xl)!=="svelte-1too0g5"&&(Xl.innerHTML=da),He=n(l),ql=M(l,"P",{"data-svelte-h":!0}),i(ql)!=="svelte-zc3x59"&&(ql.innerHTML=ua),$e=n(l),S=M(l,"DIV",{class:!0,"data-svelte-h":!0}),i(S)!=="svelte-dbmn5s"&&(S.innerHTML=Ia),We=n(l),r=M(l,"P",{});var c=b(r);js=V(c,"Преимущество фрагментирования аудиообразцов на части заключается в том, что нам не нужен результат транскрибации небольшого фрагмента аудиосигнала "),Ze=rs(c,!1),_e=V(c,`
для транскрибации последующего фрагмента `),Ne=rs(c,!1),Ye=V(c,`. Соединение выполняется после того, как мы
транскрибировали все фрагменты на границах фрагментов, поэтому не имеет значения, в каком порядке мы их транскрибируем. Алгоритм полностью `),ht=M(c,"STRONG",{"data-svelte-h":!0}),i(ht)!=="svelte-1n450gz"&&(ht.textContent=ba),ds=V(c,`,
поэтому мы можем даже обрабатывать фрагмент `),Ae=rs(c,!1),Le=V(c," одновременно с фрагментом "),ze=rs(c,!1),Xe=V(c,"! Это позволяет нам "),ot=M(c,"EM",{"data-svelte-h":!0}),i(ot)!=="svelte-x1261k"&&(ot.textContent=Ca),us=V(c,` (от англ. batch) фрагменты
и прогонять их через модель параллельно, обеспечивая значительное ускорение вычислений по сравнению с их последовательной транскрибацией. Более подробно
о фрагментированни в 🤗 Transformers можно прочитать в `),B=M(c,"A",{href:!0,rel:!0,"data-svelte-h":!0}),i(B)!=="svelte-vrtp4c"&&(B.textContent=fa),Is=V(c,"."),c.forEach(e),qe=n(l),Dl=M(l,"P",{"data-svelte-h":!0}),i(Dl)!=="svelte-rnzic7"&&(Dl.innerHTML=xa),De=n(l),Ol=M(l,"P",{"data-svelte-h":!0}),i(Ol)!=="svelte-575eay"&&(Ol.innerHTML=Ea),Oe=n(l),U(Pl.$$.fragment,l),Pe=n(l),Kl=M(l,"P",{"data-svelte-h":!0}),i(Kl)!=="svelte-1mvdyro"&&(Kl.innerHTML=Sa),Ke=n(l),U(lt.$$.fragment,l),ls=n(l),tt=M(l,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-n1n71v"&&(tt.textContent=Ba),ts=n(l),et=M(l,"P",{"data-svelte-h":!0}),i(et)!=="svelte-1w5bf9x"&&(et.innerHTML=va),es=n(l),st=M(l,"P",{"data-svelte-h":!0}),i(st)!=="svelte-1gr2r2y"&&(st.innerHTML=Qa),ss=n(l),U(at.$$.fragment,l),as=n(l),nt=M(l,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-1mvdyro"&&(nt.innerHTML=Va),ns=n(l),U(pt.$$.fragment,l),ps=n(l),Mt=M(l,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-1glad5k"&&(Mt.textContent=Ra),Ms=n(l),v=M(l,"H2",{id:!0,"data-svelte-h":!0}),i(v)!=="svelte-rkfx5b"&&(v.textContent=ka),is=n(l),it=M(l,"P",{"data-svelte-h":!0}),i(it)!=="svelte-z1aoca"&&(it.innerHTML=Ga),Js=n(l),Jt=M(l,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-kz3n2j"&&(Jt.innerHTML=ga),Us=n(l),Ut=M(l,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-1ciho6b"&&(Ut.innerHTML=Fa),ys=n(l),ct=M(l,"P",{}),b(ct).forEach(e),this.h()},h(){j(d,"name","hf:doc:metadata"),j(d,"content",JSON.stringify(ln)),j(C,"id",""),j(f,"id","ctc"),j(f,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(f,"href","#ctc"),j(u,"class","relative group"),j(x,"id","seq2seq"),j(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(x,"href","#seq2seq"),j(I,"class","relative group"),j(E,"id",""),j(S,"class","flex justify-center"),Ze.a=_e,Ne.a=Ye,Ae.a=Le,ze.a=Xe,j(B,"href","https://huggingface.co/blog/asr-chunking"),j(B,"rel","nofollow"),j(v,"id","")},m(l,t){m(document.head,d),s(l,jt,t),s(l,wt,t),s(l,dt,t),s(l,C,t),s(l,ut,t),s(l,R,t),s(l,It,t),s(l,k,t),s(l,bt,t),s(l,G,t),s(l,Ct,t),s(l,g,t),s(l,ft,t),s(l,F,t),s(l,xt,t),s(l,u,t),m(u,f),m(f,rt),y(H,rt,null),m(u,ms),m(u,yt),s(l,Et,t),s(l,$,t),s(l,St,t),y(W,l,t),s(l,Bt,t),s(l,Z,t),s(l,vt,t),y(_,l,t),s(l,Qt,t),s(l,N,t),s(l,Vt,t),y(Y,l,t),s(l,Rt,t),s(l,A,t),s(l,kt,t),y(L,l,t),s(l,Gt,t),s(l,z,t),s(l,gt,t),y(X,l,t),s(l,Ft,t),s(l,q,t),s(l,Ht,t),y(D,l,t),s(l,$t,t),s(l,O,t),s(l,Wt,t),y(P,l,t),s(l,Zt,t),s(l,K,t),s(l,_t,t),y(ll,l,t),s(l,Nt,t),s(l,tl,t),s(l,Yt,t),s(l,el,t),s(l,At,t),s(l,sl,t),s(l,Lt,t),s(l,al,t),s(l,zt,t),s(l,I,t),m(I,x),m(x,mt),y(nl,mt,null),m(I,cs),m(I,Tt),s(l,Xt,t),s(l,pl,t),s(l,qt,t),s(l,Ml,t),s(l,Dt,t),s(l,il,t),s(l,Ot,t),s(l,Jl,t),s(l,Pt,t),s(l,Ul,t),s(l,Kt,t),s(l,yl,t),s(l,le,t),s(l,Tl,t),s(l,te,t),s(l,hl,t),s(l,ee,t),s(l,ol,t),s(l,se,t),s(l,wl,t),s(l,ae,t),s(l,rl,t),s(l,ne,t),y(ml,l,t),s(l,pe,t),s(l,cl,t),s(l,Me,t),y(jl,l,t),s(l,ie,t),s(l,dl,t),s(l,Je,t),y(ul,l,t),s(l,Ue,t),s(l,Il,t),s(l,ye,t),y(bl,l,t),s(l,Te,t),s(l,Cl,t),s(l,he,t),s(l,fl,t),s(l,oe,t),y(xl,l,t),s(l,we,t),s(l,El,t),s(l,re,t),y(Sl,l,t),s(l,me,t),s(l,Bl,t),s(l,ce,t),y(vl,l,t),s(l,je,t),s(l,Ql,t),s(l,de,t),y(Vl,l,t),s(l,ue,t),s(l,Rl,t),s(l,Ie,t),y(kl,l,t),s(l,be,t),s(l,Gl,t),s(l,Ce,t),y(gl,l,t),s(l,fe,t),s(l,Fl,t),s(l,xe,t),y(Hl,l,t),s(l,Ee,t),s(l,$l,t),s(l,Se,t),s(l,Wl,t),s(l,Be,t),s(l,E,t),s(l,ve,t),s(l,Zl,t),s(l,Qe,t),s(l,_l,t),s(l,Ve,t),s(l,Nl,t),s(l,Re,t),y(Yl,l,t),s(l,ke,t),s(l,Al,t),s(l,Ge,t),y(Ll,l,t),s(l,ge,t),s(l,zl,t),s(l,Fe,t),s(l,Xl,t),s(l,He,t),s(l,ql,t),s(l,$e,t),s(l,S,t),s(l,We,t),s(l,r,t),m(r,js),Ze.m(Na,r),m(r,_e),Ne.m(Ya,r),m(r,Ye),m(r,ht),m(r,ds),Ae.m(Aa,r),m(r,Le),ze.m(La,r),m(r,Xe),m(r,ot),m(r,us),m(r,B),m(r,Is),s(l,qe,t),s(l,Dl,t),s(l,De,t),s(l,Ol,t),s(l,Oe,t),y(Pl,l,t),s(l,Pe,t),s(l,Kl,t),s(l,Ke,t),y(lt,l,t),s(l,ls,t),s(l,tt,t),s(l,ts,t),s(l,et,t),s(l,es,t),s(l,st,t),s(l,ss,t),y(at,l,t),s(l,as,t),s(l,nt,t),s(l,ns,t),y(pt,l,t),s(l,ps,t),s(l,Mt,t),s(l,Ms,t),s(l,v,t),s(l,is,t),s(l,it,t),s(l,Js,t),s(l,Jt,t),s(l,Us,t),s(l,Ut,t),s(l,ys,t),s(l,ct,t),Ts=!0},p:Xa,i(l){Ts||(T(H.$$.fragment,l),T(W.$$.fragment,l),T(_.$$.fragment,l),T(Y.$$.fragment,l),T(L.$$.fragment,l),T(X.$$.fragment,l),T(D.$$.fragment,l),T(P.$$.fragment,l),T(ll.$$.fragment,l),T(nl.$$.fragment,l),T(ml.$$.fragment,l),T(jl.$$.fragment,l),T(ul.$$.fragment,l),T(bl.$$.fragment,l),T(xl.$$.fragment,l),T(Sl.$$.fragment,l),T(vl.$$.fragment,l),T(Vl.$$.fragment,l),T(kl.$$.fragment,l),T(gl.$$.fragment,l),T(Hl.$$.fragment,l),T(Yl.$$.fragment,l),T(Ll.$$.fragment,l),T(Pl.$$.fragment,l),T(lt.$$.fragment,l),T(at.$$.fragment,l),T(pt.$$.fragment,l),Ts=!0)},o(l){h(H.$$.fragment,l),h(W.$$.fragment,l),h(_.$$.fragment,l),h(Y.$$.fragment,l),h(L.$$.fragment,l),h(X.$$.fragment,l),h(D.$$.fragment,l),h(P.$$.fragment,l),h(ll.$$.fragment,l),h(nl.$$.fragment,l),h(ml.$$.fragment,l),h(jl.$$.fragment,l),h(ul.$$.fragment,l),h(bl.$$.fragment,l),h(xl.$$.fragment,l),h(Sl.$$.fragment,l),h(vl.$$.fragment,l),h(Vl.$$.fragment,l),h(kl.$$.fragment,l),h(gl.$$.fragment,l),h(Hl.$$.fragment,l),h(Yl.$$.fragment,l),h(Ll.$$.fragment,l),h(Pl.$$.fragment,l),h(lt.$$.fragment,l),h(at.$$.fragment,l),h(pt.$$.fragment,l),Ts=!1},d(l){l&&(e(jt),e(wt),e(dt),e(C),e(ut),e(R),e(It),e(k),e(bt),e(G),e(Ct),e(g),e(ft),e(F),e(xt),e(u),e(Et),e($),e(St),e(Bt),e(Z),e(vt),e(Qt),e(N),e(Vt),e(Rt),e(A),e(kt),e(Gt),e(z),e(gt),e(Ft),e(q),e(Ht),e($t),e(O),e(Wt),e(Zt),e(K),e(_t),e(Nt),e(tl),e(Yt),e(el),e(At),e(sl),e(Lt),e(al),e(zt),e(I),e(Xt),e(pl),e(qt),e(Ml),e(Dt),e(il),e(Ot),e(Jl),e(Pt),e(Ul),e(Kt),e(yl),e(le),e(Tl),e(te),e(hl),e(ee),e(ol),e(se),e(wl),e(ae),e(rl),e(ne),e(pe),e(cl),e(Me),e(ie),e(dl),e(Je),e(Ue),e(Il),e(ye),e(Te),e(Cl),e(he),e(fl),e(oe),e(we),e(El),e(re),e(me),e(Bl),e(ce),e(je),e(Ql),e(de),e(ue),e(Rl),e(Ie),e(be),e(Gl),e(Ce),e(fe),e(Fl),e(xe),e(Ee),e($l),e(Se),e(Wl),e(Be),e(E),e(ve),e(Zl),e(Qe),e(_l),e(Ve),e(Nl),e(Re),e(ke),e(Al),e(Ge),e(ge),e(zl),e(Fe),e(Xl),e(He),e(ql),e($e),e(S),e(We),e(r),e(qe),e(Dl),e(De),e(Ol),e(Oe),e(Pe),e(Kl),e(Ke),e(ls),e(tt),e(ts),e(et),e(es),e(st),e(ss),e(as),e(nt),e(ns),e(ps),e(Mt),e(Ms),e(v),e(is),e(it),e(Js),e(Jt),e(Us),e(Ut),e(ys),e(ct)),e(d),o(H),o(W,l),o(_,l),o(Y,l),o(L,l),o(X,l),o(D,l),o(P,l),o(ll,l),o(nl),o(ml,l),o(jl,l),o(ul,l),o(bl,l),o(xl,l),o(Sl,l),o(vl,l),o(Vl,l),o(kl,l),o(gl,l),o(Hl,l),o(Yl,l),o(Ll,l),o(Pl,l),o(lt,l),o(at,l),o(pt,l)}}}const ln={local:"",sections:[{local:"ctc",title:"Анализ моделей CTC"},{local:"seq2seq",title:"Переход к Seq2Seq"},{local:"",title:"Длинноформатная транскрипция и временные метки"},{local:"",title:"Итоги"}],title:"Предварительно обученные модели для распознавания речи"};function tn(bs){return qa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pn extends Da{constructor(d){super(),Oa(this,d,tn,Ka,za,{})}}export{pn as component};
