import{s as Da,o as za,n as Fa}from"../chunks/scheduler.f7e1785c.js";import{S as Ha,i as Sa,g as p,s as n,u as y,A as qa,h as M,f as e,c as a,j as h,v as J,y as i,k as w,o as u,a as s,w as c,d as j,t as T,x as m}from"../chunks/index.815a732f.js";import{T as La}from"../chunks/Tip.1258ac78.js";import{I as rn}from"../chunks/IconCopyLink.e7937f56.js";import{C as U}from"../chunks/CodeBlock.c6e8b464.js";function Pa(Lt){let r,W=`В нашем примере мы будем использовать около 40 часов обучающих данных. Если вы хотите повторить этот процесс, используя бесплатный тарифный план Google Colab,
необходимо уменьшить объем обучающих данных примерно до 10-15 часов и сократить количество шагов обучения.`;return{c(){r=p("p"),r.textContent=W},l(o){r=M(o,"P",{"data-svelte-h":!0}),i(r)!=="svelte-1ywpoki"&&(r.textContent=W)},m(o,Yt){s(o,r,Yt)},p:Fa,d(o){o&&e(r)}}}function Ka(Lt){let r,W,o,Yt,d,I,Ft,g,mn,Nt,un="Дообучение SpeechT5",Pt,E,on=`Теперь, когда вы знакомы с задачей преобразования текста в речь и внутренним устройством модели SpeechT5, которая была предварительно обучена
на англоязычных данных, давайте посмотрим, как мы можем дообучить ее для другого языка.`,Kt,C,f,Ht,X,Un,Dt,hn="House-keeping",Ot,Y,dn="Если вы хотите воспроизвести этот пример, убедитесь, что у вас есть графический процессор. В блокноте это можно проверить с помощью следующей команды:",le,N,te,k,ee,D,Cn="Вам также понадобятся некоторые дополнительные зависимости:",se,z,ne,F,bn="Наконец, не забудьте войти в свою учетную запись Hugging Face, чтобы загрузить свою модель и поделиться ею с сообществом:",ae,H,pe,Z,In="Набор данных",Me,S,fn=`В данном примере мы возьмем подмножество голландского (<code>nl</code>) языка из датасета <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a>.
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> - это обширный многоязычный речевой корпус, состоящий из данных,
полученных из записей мероприятий Европейского парламента 2009-2020 гг. Он содержит маркированные данные аудио-транскрипций для 15 европейских языков.
Хотя мы будем использовать подмножество голландского языка, вы можете выбрать другое подмножество.`,ie,q,kn=`Это набор данных автоматического распознавания речи (ASR), поэтому, как уже говорилось, он не является наиболее подходящим
вариантом для обучения TTS-моделей. Однако для данного упражнения этого будет вполне достаточно.`,ye,L,Zn="Давайте загрузим данные:",Je,P,ce,K,xn="<strong>Output:</strong>",je,O,Te,ll,Rn=`20968 примеров должно быть достаточно для дообучения. Для SpeechT5 требуется, чтобы частота дискретизации аудиоданных составляла 16 кГц, поэтому
убедимся, что примеры в наборе данных соответствуют этому требованию:`,me,tl,Ue,x,$n="Препроцессинг данных",we,el,An=`Начнем с определения используемой контрольной точки модели и загрузки соответствующего процессора, содержащего как токенизатор,
так и экстрактор признаков, которые понадобятся нам для подготовки данных к обучению:`,re,sl,ue,b,R,St,nl,wn,zt,Qn="Очистка текста для токенизации SpeechT5",oe,al,_n="Во-первых, для подготовки текста нам понадобится часть процессора - токенизатор, поэтому возьмем его:",he,pl,de,Ml,vn="Рассмотрим пример:",Ce,il,be,yl,Vn="<strong>Output:</strong>",Ie,Jl,fe,cl,Gn=`Можно заметить, что примеры из датасета содержат признаки <code>raw_text</code> и <code>normalized_text</code>. При выборе признака
в качестве входного текста важно знать, что в токенизаторе SpeechT5 нет токенов для чисел. В <code>normalized_text</code>
числа записываются в виде текста. Таким образом, он лучше подходит, и в качестве входного текста следует использовать <code>normalized_text</code>.`,ke,jl,Bn=`Поскольку SpeechT5 обучалась на английском языке, она может не распознать некоторые символы в голландском наборе данных. Если
оставить все как есть, то эти символы будут преобразованы в токены <code>&lt;unk&gt;</code>. Однако в голландском языке некоторые символы, например <code>à</code>, используются
для выделения слогов. Чтобы сохранить смысл текста, можно заменить этот символ на обычное <code>a</code>.`,Ze,Tl,Wn=`Чтобы выявить неподдерживаемые токены, извлечем все уникальные символы из датасета с помощью <code>SpeechT5Tokenizer</code>, который
работает с символами как с токенами. Для этого напишем функцию отображения <code>extract_all_chars</code>, которая объединяет
транскрипции из всех примеров в одну строку и преобразует ее в набор символов. [NL]
Обязательно задайте <code>batched=True</code> и <code>batch_size=-1</code> в <code>dataset.map()</code>, чтобы все транскрипции были доступны сразу для
функции отображения.`,xe,ml,Re,Ul,gn=`Теперь у вас есть два набора символов: один со словарем из датасета, другой - со словарем из токенизатора.
Для выявления неподдерживаемых символов в наборе данных можно взять разность между этими двумя наборами. Полученный набор
будет содержать символы, которые есть в наборе данных, но отсутствуют в токенизаторе.`,$e,wl,Ae,rl,En="<strong>Output:</strong>",Qe,ul,_e,ol,Xn=`Для работы с неподдерживаемыми символами, выявленными на предыдущем этапе, можно определить функцию, которая сопоставляет эти символы с допустимыми токенами.
Заметим, что пробелы уже заменены на <code>▁</code> в токенизаторе и не нуждаются в отдельной обработке.`,ve,hl,Ve,dl,Yn="Теперь, когда мы разобрались со специальными символами в тексте, пришло время переключить внимание на аудио данные.",Ge,$,Nn="Дикторы",Be,Cl,Dn=`Набор данных VoxPopuli включает речь нескольких дикторов, но сколько дикторов представлено в наборе? Чтобы
определить это, мы можем подсчитать количество уникальных дикторов и количество примеров, которые каждый диктор вносит в набор данных.
Учитывая, что всего в наборе данных 20 968 примеров, эта информация позволит нам лучше понять распределение
дикторов и примеров в данных.`,We,bl,ge,Il,zn="Построив гистограмму, можно получить представление о том, сколько данных имеется для каждого диктора.",Ee,fl,Xe,A,Fn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',Ye,kl,Hn=`Гистограмма показывает, что примерно треть дикторов в наборе данных имеет менее 100 примеров, в то время как
около десяти дикторов имеют более 500 примеров. Чтобы повысить эффективность обучения и сбалансировать набор данных, мы можем ограничить
данные дикторами, имеющими от 100 до 400 примеров.`,Ne,Zl,De,xl,Sn="Проверим, сколько осталось дикторов:",ze,Rl,Fe,$l,qn="<strong>Output:</strong>",He,Al,Se,Ql,Ln="Посмотрим, сколько осталось примеров:",qe,_l,Le,vl,Pn="<strong>Output:</strong>",Pe,Vl,Ke,Gl,Kn="В результате вы получаете чуть менее 10 000 примеров из примерно 40 уникальных дикторов, что должно быть вполне достаточно.",Oe,Bl,On=`Отметим, что некоторые дикторы с небольшим количеством примеров могут иметь больше аудиофайлов, если примеры длинные. Однако
определение общего объема аудиозаписей для каждого диктора требует сканирования всего датасета, что является
трудоемким процессом, включающим загрузку и декодирование каждого аудиофайла. Поэтому в данном случае мы решили пропустить этот этап.`,ls,Q,la="Эмбеддинги диктора",ts,Wl,ta=`Для того чтобы модель TTS могла различать несколько дикторов, необходимо создать эмбеддинги диктора для каждого примера.
Эмбеддинги дикторов - это дополнительный вход для модели, который фиксирует характеристики голоса конкретного диктора.
Для создания эмбеддингов диктора используется предварительно обученная модель <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
от SpeechBrain.`,es,gl,ea=`Создадим функцию <code>create_speaker_embedding()</code>, которая принимает входную волновую форму звука и выдает 512-элементный вектор,
содержащий соответствующие эмбеддинги диктора.`,ss,El,ns,Xl,sa=`Важно отметить, что модель <code>speechbrain/spkrec-xvect-voxceleb</code> была обучена на английской речи из датасета VoxCeleb,
в то время как учебные примеры в данном руководстве представлены на голландском языке. Хотя мы считаем, что данная модель все равно будет генерировать разумные эмбеддинги диктора
для нашего голландского датасета, это предположение может быть справедливо не во всех случаях.`,as,Yl,na=`Для получения оптимальных результатов необходимо сначала обучить модель X-вектора на целевой речи. Это позволит модели
лучше улавливать уникальные речевые особенности, присущие голландскому языку. Если вы хотите обучить свою собственную X-векторную модель,
то в качестве примера можно использовать <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">этот скрипт</a>.`,ps,_,aa="Обработка датасета",Ms,Nl,pa=`Наконец, обработаем данные в тот формат, который ожидает модель. Создадим функцию <code>prepare_dataset</code>, которая принимает
один пример и использует объект <code>SpeechT5Processor</code> для токенизации входного текста и загрузки целевого аудио в лог-мел спектрограмму.
Она также должна добавлять эмбеддинги диктора в качестве дополнительного входного сигнала.`,is,Dl,ys,zl,Ma="Проверить правильность обработки можно на одном из примеров:",Js,Fl,cs,Hl,ia="<strong>Output:</strong>",js,Sl,Ts,ql,ya="Эмбеддинги диктора должны представлять собой 512-элементный вектор:",ms,Ll,Us,Pl,Ja="<strong>Output:</strong>",ws,Kl,rs,Ol,ca="Метки должны представлять собой лог-мел спектрограмму с 80 мел бинами.",us,lt,os,v,ja='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',hs,tt,Ta=`Примечание: Если данная спектрограмма кажется вам непонятной, то это может быть связано с тем, что вы привыкли располагать низкие частоты
внизу, а высокие - вверху графика. Однако при построении спектрограмм в виде изображения с помощью библиотеки matplotlib ось y
переворачивается, и спектрограммы выглядят перевернутыми.`,ds,et,ma="Теперь необходимо применить функцию препроцессинга ко всему набору данных. Это займет от 5 до 10 минут.",Cs,st,bs,nt,Ua=`Появится предупреждение о том, что длина некоторых примеров в датасете превышает максимальную длину входных данных, которую может обработать модель (600 лексем).
Удалите эти примеры из датасета. Здесь мы идем еще дальше и для того, чтобы увеличить размер батча, удаляем все, что превышает 200 токенов.`,Is,at,fs,pt,wa="<strong>Output:</strong>",ks,Mt,Zs,it,ra="Затем создадим базовое разделение на тренировочную и тестовую части:",xs,yt,Rs,V,ua="Коллатор данных",$s,Jt,oa=`Для того чтобы объединить несколько примеров в батч, необходимо определить пользовательский коллатор данных. Этот коллатор будет дополнять более короткие последовательности токенами,
гарантируя, что все примеры будут иметь одинаковую длину. Для меток спектрограммы дополняемая части заменяются на специальное значение <code>-100</code>.
Это специальное значение указывает модели игнорировать эту часть спектрограммы при расчете потерь спектрограммы.`,As,ct,Qs,jt,ha=`В SpeechT5 входная информация для декодера уменьшается в 2 раза. Другими словами, отбрасывается каждый второй
временной шаг из целевой последовательности.Затем декодер предсказывает последовательность, которая в два раза длиннее. Поскольку исходная длина
целевой последовательности [NL] может быть нечетной, коллатор данных обязательно округляет максимальную длину батча до значения [NL], кратного 2.`,_s,Tt,vs,G,da="Обучение модели",Vs,mt,Ca="Загрузите предварительно обученную модель из той же контрольной точки, которая использовалась для загрузки процессора:",Gs,Ut,Bs,wt,ba=`Опция <code>use_cache=True</code> несовместима с использованием градиентных контрольных точек. Отключите ее для обучения и снова включите кэш для генерации,
чтобы ускорить  инференс:`,Ws,rt,gs,ut,Ia=`Определим аргументы обучения. Здесь мы не вычисляем никаких оценочных метрик в процессе обучения,
мы поговорим об оценке позже в этой главе. Вместо этого мы будем рассматривать только потери:`,Es,ot,Xs,ht,fa="Инстанцируем объект <code>Trainer</code> и передаем ему модель, набор данных и коллатор данных.",Ys,dt,Ns,Ct,ka=`И с этим мы готовы приступить к обучению! Обучение займет несколько часов. В зависимости от используемого GPU
возможно, что при начале обучения возникнет ошибка CUDA “out-of-memory”. В этом случае можно уменьшить
размер <code>per_device_train_batch_size</code> постепенно в 2 раза и увеличить <code>gradient_accumulation_steps</code> в 2 раза, чтобы компенсировать это.`,Ds,bt,zs,It,Za="Push the final model to the 🤗 Hub:",Fs,ft,Hs,B,xa="Инференс",Ss,kt,Ra=`После того как модель дообучена, ее можно использовать для инференса! Загрузите модель из 🤗 Hub (убедитесь, что в
следующем фрагменте кода используется имя вашей учетной записи):`,qs,Zt,Ls,xt,$a="Выберем пример, здесь мы возьмем пример из тестового набора данных. Получаем эмбеддинги диктора.",Ps,Rt,Ks,$t,Aa="Определим некоторый входной текст и токенизируем его.",Os,At,ln,Qt,Qa="Выполним препроцессинг входного текста:",tn,_t,en,vt,_a="Инстанцируем вокодер и сгенерируем речь:",sn,Vt,nn,Gt,va="Готовы послушать результат?",an,Bt,pn,Wt,Va=`Получение удовлетворительных результатов с помощью этой модели на новом языке может оказаться непростой задачей. Качество эмбеддингов диктора
может быть существенным фактором. Поскольку SpeechT5 была предварительно обучена на английских x-векторах, она показывает наилучшие результаты
при использовании эмбеддингов английских дикторов. Если синтезированная речь звучит плохо, попробуйте использовать другие эмбеддинги диктора.`,Mn,gt,Ga=`Увеличение продолжительности обучения, вероятно, также повысит качество результатов. Несмотря на это, речь явно голландская, а не английская, и в ней
передаются особенности голоса говорящего (сравните с оригинальным аудио в примере).
Еще один момент, с которым можно поэкспериментировать, - это настройка модели. Например, попробуйте использовать <code>config.reduction_factor = 1</code>, чтобы
посмотреть, улучшит ли это результаты.`,yn,Et,Ba="В следующем разделе мы расскажем о том, как мы оцениваем модели преобразования текста в речь.",Jn,qt,cn;return g=new rn({}),X=new rn({}),N=new U({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi"}}),k=new La({props:{warning:!0,$$slots:{default:[Pa]},$$scope:{ctx:Lt}}}),z=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate"}}),H=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),P=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`}}),O=new U({props:{code:"MjA5Njg=",highlighted:"20968"}}),tl=new U({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))'}}),sl=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`}}),nl=new rn({}),pl=new U({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer"}}),il=new U({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]'}}),Jl=new U({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`}}),ml=new U({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`}}),wl=new U({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab"}}),ul=new U({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}"}}),hl=new U({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`}}),bl=new U({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`}}),fl=new U({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`}}),Zl=new U({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`}}),Rl=new U({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))'}}),Al=new U({props:{code:"NDI=",highlighted:"42"}}),_l=new U({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)'}}),Vl=new U({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>'}}),El=new U({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`}}),Dl=new U({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># strip off the batch dimension</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`}}),Fl=new U({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`}}),Sl=new U({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]'}}),Ll=new U({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape'}}),Kl=new U({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)'}}),lt=new U({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`}}),st=new U({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)'}}),at=new U({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`}}),Mt=new U({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>'}}),yt=new U({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)'}}),ct=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># not used during fine-tuning</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># also add in the speaker embeddings</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`}}),Tt=new U({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)"}}),Ut=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`}}),rt=new U({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjAlRDAlQkUlRDElODIlRDAlQkElRDAlQkIlRDElOEUlRDElODclRDAlQjglRDElODIlRDElOEMlMjAlRDAlQkElRDElOEQlRDElODglMjAlRDAlQjIlRDAlQkUlMjAlRDAlQjIlRDElODAlRDAlQjUlRDAlQkMlRDElOEYlMjAlRDAlQkUlRDAlQjElRDElODMlRDElODclRDAlQjUlRDAlQkQlRDAlQjglRDElOEYlMkMlMjAlRDElODIlRDAlQjAlRDAlQkElMjAlRDAlQkElRDAlQjAlRDAlQkElMjAlRDAlQkUlRDAlQkQlMjAlRDAlQkQlRDAlQjUlRDElODElRDAlQkUlRDAlQjIlRDAlQkMlRDAlQjUlRDElODElRDElODIlRDAlQjglRDAlQkMlMjAlRDElODElMjAlRDAlQjMlRDElODAlRDAlQjAlRDAlQjQlRDAlQjglRDAlQjUlRDAlQkQlRDElODIlRDAlQkQlRDElOEIlRDAlQkMlRDAlQjglMjAlRDAlQkElRDAlQkUlRDAlQkQlRDElODIlRDElODAlRDAlQkUlRDAlQkIlRDElOEMlRDAlQkQlRDElOEIlRDAlQkMlRDAlQjglMjAlRDElODIlRDAlQkUlRDElODclRDAlQkElRDAlQjAlRDAlQkMlRDAlQjglMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjAlRDAlQjclRDAlQjAlRDAlQjQlRDAlQjAlRDAlQkQlRDAlQjglRDAlQkMlMjAlRDElOEYlRDAlQjclRDElOEIlRDAlQkElMjAlRDAlQjglMjAlRDAlQjclRDAlQjAlRDAlQjQlRDAlQjAlRDElODclRDElODMlMjAlRDAlQjQlRDAlQkIlRDElOEYlMjAlRDAlQjMlRDAlQjUlRDAlQkQlRDAlQjUlRDElODAlRDAlQjAlRDElODYlRDAlQjglRDAlQjglMjAlRDAlQjglMjAlRDElODElRDAlQkQlRDAlQkUlRDAlQjIlRDAlQjAlMjAlRDAlQjIlRDAlQkElRDAlQkIlRDElOEUlRDElODclRDAlQjglRDAlQkMlMjAlRDAlQkElRDElOEQlRDElODglMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># отключить кэш во время обучения, так как он несовместим с градиентными контрольными точками</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># заданим язык и задачу для генерации и снова включим кэш</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`}}),ot=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`}}),dt=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`}}),bt=new U({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()"}}),ft=new U({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()"}}),Zt=new U({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`}}),Rt=new U({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`}}),At=new U({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>'}}),_t=new U({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)'}}),Vt=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`}}),Bt=new U({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`}}),{c(){r=p("meta"),W=n(),o=p("p"),Yt=n(),d=p("h1"),I=p("a"),Ft=p("span"),y(g.$$.fragment),mn=n(),Nt=p("span"),Nt.textContent=un,Pt=n(),E=p("p"),E.textContent=on,Kt=n(),C=p("h2"),f=p("a"),Ht=p("span"),y(X.$$.fragment),Un=n(),Dt=p("span"),Dt.textContent=hn,Ot=n(),Y=p("p"),Y.textContent=dn,le=n(),y(N.$$.fragment),te=n(),y(k.$$.fragment),ee=n(),D=p("p"),D.textContent=Cn,se=n(),y(z.$$.fragment),ne=n(),F=p("p"),F.textContent=bn,ae=n(),y(H.$$.fragment),pe=n(),Z=p("h2"),Z.textContent=In,Me=n(),S=p("p"),S.innerHTML=fn,ie=n(),q=p("p"),q.textContent=kn,ye=n(),L=p("p"),L.textContent=Zn,Je=n(),y(P.$$.fragment),ce=n(),K=p("p"),K.innerHTML=xn,je=n(),y(O.$$.fragment),Te=n(),ll=p("p"),ll.textContent=Rn,me=n(),y(tl.$$.fragment),Ue=n(),x=p("h2"),x.textContent=$n,we=n(),el=p("p"),el.textContent=An,re=n(),y(sl.$$.fragment),ue=n(),b=p("h3"),R=p("a"),St=p("span"),y(nl.$$.fragment),wn=n(),zt=p("span"),zt.textContent=Qn,oe=n(),al=p("p"),al.textContent=_n,he=n(),y(pl.$$.fragment),de=n(),Ml=p("p"),Ml.textContent=vn,Ce=n(),y(il.$$.fragment),be=n(),yl=p("p"),yl.innerHTML=Vn,Ie=n(),y(Jl.$$.fragment),fe=n(),cl=p("p"),cl.innerHTML=Gn,ke=n(),jl=p("p"),jl.innerHTML=Bn,Ze=n(),Tl=p("p"),Tl.innerHTML=Wn,xe=n(),y(ml.$$.fragment),Re=n(),Ul=p("p"),Ul.textContent=gn,$e=n(),y(wl.$$.fragment),Ae=n(),rl=p("p"),rl.innerHTML=En,Qe=n(),y(ul.$$.fragment),_e=n(),ol=p("p"),ol.innerHTML=Xn,ve=n(),y(hl.$$.fragment),Ve=n(),dl=p("p"),dl.textContent=Yn,Ge=n(),$=p("h3"),$.textContent=Nn,Be=n(),Cl=p("p"),Cl.textContent=Dn,We=n(),y(bl.$$.fragment),ge=n(),Il=p("p"),Il.textContent=zn,Ee=n(),y(fl.$$.fragment),Xe=n(),A=p("div"),A.innerHTML=Fn,Ye=n(),kl=p("p"),kl.textContent=Hn,Ne=n(),y(Zl.$$.fragment),De=n(),xl=p("p"),xl.textContent=Sn,ze=n(),y(Rl.$$.fragment),Fe=n(),$l=p("p"),$l.innerHTML=qn,He=n(),y(Al.$$.fragment),Se=n(),Ql=p("p"),Ql.textContent=Ln,qe=n(),y(_l.$$.fragment),Le=n(),vl=p("p"),vl.innerHTML=Pn,Pe=n(),y(Vl.$$.fragment),Ke=n(),Gl=p("p"),Gl.textContent=Kn,Oe=n(),Bl=p("p"),Bl.textContent=On,ls=n(),Q=p("h3"),Q.textContent=la,ts=n(),Wl=p("p"),Wl.innerHTML=ta,es=n(),gl=p("p"),gl.innerHTML=ea,ss=n(),y(El.$$.fragment),ns=n(),Xl=p("p"),Xl.innerHTML=sa,as=n(),Yl=p("p"),Yl.innerHTML=na,ps=n(),_=p("h3"),_.textContent=aa,Ms=n(),Nl=p("p"),Nl.innerHTML=pa,is=n(),y(Dl.$$.fragment),ys=n(),zl=p("p"),zl.textContent=Ma,Js=n(),y(Fl.$$.fragment),cs=n(),Hl=p("p"),Hl.innerHTML=ia,js=n(),y(Sl.$$.fragment),Ts=n(),ql=p("p"),ql.textContent=ya,ms=n(),y(Ll.$$.fragment),Us=n(),Pl=p("p"),Pl.innerHTML=Ja,ws=n(),y(Kl.$$.fragment),rs=n(),Ol=p("p"),Ol.textContent=ca,us=n(),y(lt.$$.fragment),os=n(),v=p("div"),v.innerHTML=ja,hs=n(),tt=p("p"),tt.textContent=Ta,ds=n(),et=p("p"),et.textContent=ma,Cs=n(),y(st.$$.fragment),bs=n(),nt=p("p"),nt.textContent=Ua,Is=n(),y(at.$$.fragment),fs=n(),pt=p("p"),pt.innerHTML=wa,ks=n(),y(Mt.$$.fragment),Zs=n(),it=p("p"),it.textContent=ra,xs=n(),y(yt.$$.fragment),Rs=n(),V=p("h3"),V.textContent=ua,$s=n(),Jt=p("p"),Jt.innerHTML=oa,As=n(),y(ct.$$.fragment),Qs=n(),jt=p("p"),jt.textContent=ha,_s=n(),y(Tt.$$.fragment),vs=n(),G=p("h2"),G.textContent=da,Vs=n(),mt=p("p"),mt.textContent=Ca,Gs=n(),y(Ut.$$.fragment),Bs=n(),wt=p("p"),wt.innerHTML=ba,Ws=n(),y(rt.$$.fragment),gs=n(),ut=p("p"),ut.textContent=Ia,Es=n(),y(ot.$$.fragment),Xs=n(),ht=p("p"),ht.innerHTML=fa,Ys=n(),y(dt.$$.fragment),Ns=n(),Ct=p("p"),Ct.innerHTML=ka,Ds=n(),y(bt.$$.fragment),zs=n(),It=p("p"),It.textContent=Za,Fs=n(),y(ft.$$.fragment),Hs=n(),B=p("h2"),B.textContent=xa,Ss=n(),kt=p("p"),kt.textContent=Ra,qs=n(),y(Zt.$$.fragment),Ls=n(),xt=p("p"),xt.textContent=$a,Ps=n(),y(Rt.$$.fragment),Ks=n(),$t=p("p"),$t.textContent=Aa,Os=n(),y(At.$$.fragment),ln=n(),Qt=p("p"),Qt.textContent=Qa,tn=n(),y(_t.$$.fragment),en=n(),vt=p("p"),vt.textContent=_a,sn=n(),y(Vt.$$.fragment),nn=n(),Gt=p("p"),Gt.textContent=va,an=n(),y(Bt.$$.fragment),pn=n(),Wt=p("p"),Wt.textContent=Va,Mn=n(),gt=p("p"),gt.innerHTML=Ga,yn=n(),Et=p("p"),Et.textContent=Ba,Jn=n(),qt=p("p"),this.h()},l(l){const t=qa("svelte-1phssyn",document.head);r=M(t,"META",{name:!0,content:!0}),t.forEach(e),W=a(l),o=M(l,"P",{}),h(o).forEach(e),Yt=a(l),d=M(l,"H1",{class:!0});var Xt=h(d);I=M(Xt,"A",{id:!0,class:!0,href:!0});var Wa=h(I);Ft=M(Wa,"SPAN",{});var ga=h(Ft);J(g.$$.fragment,ga),ga.forEach(e),Wa.forEach(e),mn=a(Xt),Nt=M(Xt,"SPAN",{"data-svelte-h":!0}),i(Nt)!=="svelte-1gvw6ta"&&(Nt.textContent=un),Xt.forEach(e),Pt=a(l),E=M(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-8bltl"&&(E.textContent=on),Kt=a(l),C=M(l,"H2",{class:!0});var jn=h(C);f=M(jn,"A",{id:!0,class:!0,href:!0});var Ea=h(f);Ht=M(Ea,"SPAN",{});var Xa=h(Ht);J(X.$$.fragment,Xa),Xa.forEach(e),Ea.forEach(e),Un=a(jn),Dt=M(jn,"SPAN",{"data-svelte-h":!0}),i(Dt)!=="svelte-luv5jt"&&(Dt.textContent=hn),jn.forEach(e),Ot=a(l),Y=M(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-izsfon"&&(Y.textContent=dn),le=a(l),J(N.$$.fragment,l),te=a(l),J(k.$$.fragment,l),ee=a(l),D=M(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-xcyd0c"&&(D.textContent=Cn),se=a(l),J(z.$$.fragment,l),ne=a(l),F=M(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1n5cqib"&&(F.textContent=bn),ae=a(l),J(H.$$.fragment,l),pe=a(l),Z=M(l,"H2",{id:!0,"data-svelte-h":!0}),i(Z)!=="svelte-xskrv6"&&(Z.textContent=In),Me=a(l),S=M(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1wrmkii"&&(S.innerHTML=fn),ie=a(l),q=M(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-wlzddh"&&(q.textContent=kn),ye=a(l),L=M(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-tndgny"&&(L.textContent=Zn),Je=a(l),J(P.$$.fragment,l),ce=a(l),K=M(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1mvdyro"&&(K.innerHTML=xn),je=a(l),J(O.$$.fragment,l),Te=a(l),ll=M(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1qhkgx9"&&(ll.textContent=Rn),me=a(l),J(tl.$$.fragment,l),Ue=a(l),x=M(l,"H2",{id:!0,"data-svelte-h":!0}),i(x)!=="svelte-1uz277e"&&(x.textContent=$n),we=a(l),el=M(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-hacnda"&&(el.textContent=An),re=a(l),J(sl.$$.fragment,l),ue=a(l),b=M(l,"H3",{class:!0});var Tn=h(b);R=M(Tn,"A",{id:!0,class:!0,href:!0});var Ya=h(R);St=M(Ya,"SPAN",{});var Na=h(St);J(nl.$$.fragment,Na),Na.forEach(e),Ya.forEach(e),wn=a(Tn),zt=M(Tn,"SPAN",{"data-svelte-h":!0}),i(zt)!=="svelte-15d348r"&&(zt.textContent=Qn),Tn.forEach(e),oe=a(l),al=M(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-pxsz1o"&&(al.textContent=_n),he=a(l),J(pl.$$.fragment,l),de=a(l),Ml=M(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-hhmg0u"&&(Ml.textContent=vn),Ce=a(l),J(il.$$.fragment,l),be=a(l),yl=M(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-1mvdyro"&&(yl.innerHTML=Vn),Ie=a(l),J(Jl.$$.fragment,l),fe=a(l),cl=M(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-4zb4lk"&&(cl.innerHTML=Gn),ke=a(l),jl=M(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-okgqir"&&(jl.innerHTML=Bn),Ze=a(l),Tl=M(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-1ysmakp"&&(Tl.innerHTML=Wn),xe=a(l),J(ml.$$.fragment,l),Re=a(l),Ul=M(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-1frt52r"&&(Ul.textContent=gn),$e=a(l),J(wl.$$.fragment,l),Ae=a(l),rl=M(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1mvdyro"&&(rl.innerHTML=En),Qe=a(l),J(ul.$$.fragment,l),_e=a(l),ol=M(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-fg573h"&&(ol.innerHTML=Xn),ve=a(l),J(hl.$$.fragment,l),Ve=a(l),dl=M(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-138gm4p"&&(dl.textContent=Yn),Ge=a(l),$=M(l,"H3",{id:!0,"data-svelte-h":!0}),i($)!=="svelte-1ngrosv"&&($.textContent=Nn),Be=a(l),Cl=M(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-t1t9qy"&&(Cl.textContent=Dn),We=a(l),J(bl.$$.fragment,l),ge=a(l),Il=M(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-7t0xxj"&&(Il.textContent=zn),Ee=a(l),J(fl.$$.fragment,l),Xe=a(l),A=M(l,"DIV",{class:!0,"data-svelte-h":!0}),i(A)!=="svelte-1uufiik"&&(A.innerHTML=Fn),Ye=a(l),kl=M(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-15je7j5"&&(kl.textContent=Hn),Ne=a(l),J(Zl.$$.fragment,l),De=a(l),xl=M(l,"P",{"data-svelte-h":!0}),i(xl)!=="svelte-u7eqkn"&&(xl.textContent=Sn),ze=a(l),J(Rl.$$.fragment,l),Fe=a(l),$l=M(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-1mvdyro"&&($l.innerHTML=qn),He=a(l),J(Al.$$.fragment,l),Se=a(l),Ql=M(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-z9bfhb"&&(Ql.textContent=Ln),qe=a(l),J(_l.$$.fragment,l),Le=a(l),vl=M(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-1mvdyro"&&(vl.innerHTML=Pn),Pe=a(l),J(Vl.$$.fragment,l),Ke=a(l),Gl=M(l,"P",{"data-svelte-h":!0}),i(Gl)!=="svelte-1ps1iiz"&&(Gl.textContent=Kn),Oe=a(l),Bl=M(l,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-139qbcw"&&(Bl.textContent=On),ls=a(l),Q=M(l,"H3",{id:!0,"data-svelte-h":!0}),i(Q)!=="svelte-1roreet"&&(Q.textContent=la),ts=a(l),Wl=M(l,"P",{"data-svelte-h":!0}),i(Wl)!=="svelte-p3m4km"&&(Wl.innerHTML=ta),es=a(l),gl=M(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-taqkhq"&&(gl.innerHTML=ea),ss=a(l),J(El.$$.fragment,l),ns=a(l),Xl=M(l,"P",{"data-svelte-h":!0}),i(Xl)!=="svelte-e3airu"&&(Xl.innerHTML=sa),as=a(l),Yl=M(l,"P",{"data-svelte-h":!0}),i(Yl)!=="svelte-1i0w5jk"&&(Yl.innerHTML=na),ps=a(l),_=M(l,"H3",{id:!0,"data-svelte-h":!0}),i(_)!=="svelte-1xu5yek"&&(_.textContent=aa),Ms=a(l),Nl=M(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-12dg9zu"&&(Nl.innerHTML=pa),is=a(l),J(Dl.$$.fragment,l),ys=a(l),zl=M(l,"P",{"data-svelte-h":!0}),i(zl)!=="svelte-vyoyt2"&&(zl.textContent=Ma),Js=a(l),J(Fl.$$.fragment,l),cs=a(l),Hl=M(l,"P",{"data-svelte-h":!0}),i(Hl)!=="svelte-1mvdyro"&&(Hl.innerHTML=ia),js=a(l),J(Sl.$$.fragment,l),Ts=a(l),ql=M(l,"P",{"data-svelte-h":!0}),i(ql)!=="svelte-2nvf42"&&(ql.textContent=ya),ms=a(l),J(Ll.$$.fragment,l),Us=a(l),Pl=M(l,"P",{"data-svelte-h":!0}),i(Pl)!=="svelte-1mvdyro"&&(Pl.innerHTML=Ja),ws=a(l),J(Kl.$$.fragment,l),rs=a(l),Ol=M(l,"P",{"data-svelte-h":!0}),i(Ol)!=="svelte-1ycajx1"&&(Ol.textContent=ca),us=a(l),J(lt.$$.fragment,l),os=a(l),v=M(l,"DIV",{class:!0,"data-svelte-h":!0}),i(v)!=="svelte-j4o1b8"&&(v.innerHTML=ja),hs=a(l),tt=M(l,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-12yxndm"&&(tt.textContent=Ta),ds=a(l),et=M(l,"P",{"data-svelte-h":!0}),i(et)!=="svelte-1cx65z4"&&(et.textContent=ma),Cs=a(l),J(st.$$.fragment,l),bs=a(l),nt=M(l,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-4c0nlh"&&(nt.textContent=Ua),Is=a(l),J(at.$$.fragment,l),fs=a(l),pt=M(l,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-1mvdyro"&&(pt.innerHTML=wa),ks=a(l),J(Mt.$$.fragment,l),Zs=a(l),it=M(l,"P",{"data-svelte-h":!0}),i(it)!=="svelte-12kqf3u"&&(it.textContent=ra),xs=a(l),J(yt.$$.fragment,l),Rs=a(l),V=M(l,"H3",{id:!0,"data-svelte-h":!0}),i(V)!=="svelte-1sqhthq"&&(V.textContent=ua),$s=a(l),Jt=M(l,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-av8zr0"&&(Jt.innerHTML=oa),As=a(l),J(ct.$$.fragment,l),Qs=a(l),jt=M(l,"P",{"data-svelte-h":!0}),i(jt)!=="svelte-100fe39"&&(jt.textContent=ha),_s=a(l),J(Tt.$$.fragment,l),vs=a(l),G=M(l,"H2",{id:!0,"data-svelte-h":!0}),i(G)!=="svelte-5lhtfy"&&(G.textContent=da),Vs=a(l),mt=M(l,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-1xuk540"&&(mt.textContent=Ca),Gs=a(l),J(Ut.$$.fragment,l),Bs=a(l),wt=M(l,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-1tqkg0a"&&(wt.innerHTML=ba),Ws=a(l),J(rt.$$.fragment,l),gs=a(l),ut=M(l,"P",{"data-svelte-h":!0}),i(ut)!=="svelte-1haaffx"&&(ut.textContent=Ia),Es=a(l),J(ot.$$.fragment,l),Xs=a(l),ht=M(l,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-1pvbr9r"&&(ht.innerHTML=fa),Ys=a(l),J(dt.$$.fragment,l),Ns=a(l),Ct=M(l,"P",{"data-svelte-h":!0}),i(Ct)!=="svelte-1uviv04"&&(Ct.innerHTML=ka),Ds=a(l),J(bt.$$.fragment,l),zs=a(l),It=M(l,"P",{"data-svelte-h":!0}),i(It)!=="svelte-hefgo2"&&(It.textContent=Za),Fs=a(l),J(ft.$$.fragment,l),Hs=a(l),B=M(l,"H2",{id:!0,"data-svelte-h":!0}),i(B)!=="svelte-1k3c3kn"&&(B.textContent=xa),Ss=a(l),kt=M(l,"P",{"data-svelte-h":!0}),i(kt)!=="svelte-jls05p"&&(kt.textContent=Ra),qs=a(l),J(Zt.$$.fragment,l),Ls=a(l),xt=M(l,"P",{"data-svelte-h":!0}),i(xt)!=="svelte-18xrhu4"&&(xt.textContent=$a),Ps=a(l),J(Rt.$$.fragment,l),Ks=a(l),$t=M(l,"P",{"data-svelte-h":!0}),i($t)!=="svelte-1vadpfy"&&($t.textContent=Aa),Os=a(l),J(At.$$.fragment,l),ln=a(l),Qt=M(l,"P",{"data-svelte-h":!0}),i(Qt)!=="svelte-sfvde1"&&(Qt.textContent=Qa),tn=a(l),J(_t.$$.fragment,l),en=a(l),vt=M(l,"P",{"data-svelte-h":!0}),i(vt)!=="svelte-1otseb5"&&(vt.textContent=_a),sn=a(l),J(Vt.$$.fragment,l),nn=a(l),Gt=M(l,"P",{"data-svelte-h":!0}),i(Gt)!=="svelte-eothhd"&&(Gt.textContent=va),an=a(l),J(Bt.$$.fragment,l),pn=a(l),Wt=M(l,"P",{"data-svelte-h":!0}),i(Wt)!=="svelte-188hwef"&&(Wt.textContent=Va),Mn=a(l),gt=M(l,"P",{"data-svelte-h":!0}),i(gt)!=="svelte-ygi586"&&(gt.innerHTML=Ga),yn=a(l),Et=M(l,"P",{"data-svelte-h":!0}),i(Et)!=="svelte-s2kks0"&&(Et.textContent=Ba),Jn=a(l),qt=M(l,"P",{}),h(qt).forEach(e),this.h()},h(){w(r,"name","hf:doc:metadata"),w(r,"content",JSON.stringify(Oa)),w(I,"id","speecht5"),w(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(I,"href","#speecht5"),w(d,"class","relative group"),w(f,"id","housekeeping"),w(f,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(f,"href","#housekeeping"),w(C,"class","relative group"),w(Z,"id",""),w(x,"id",""),w(R,"id","speecht5"),w(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(R,"href","#speecht5"),w(b,"class","relative group"),w($,"id",""),w(A,"class","flex justify-center"),w(Q,"id",""),w(_,"id",""),w(v,"class","flex justify-center"),w(V,"id",""),w(G,"id",""),w(B,"id","")},m(l,t){u(document.head,r),s(l,W,t),s(l,o,t),s(l,Yt,t),s(l,d,t),u(d,I),u(I,Ft),c(g,Ft,null),u(d,mn),u(d,Nt),s(l,Pt,t),s(l,E,t),s(l,Kt,t),s(l,C,t),u(C,f),u(f,Ht),c(X,Ht,null),u(C,Un),u(C,Dt),s(l,Ot,t),s(l,Y,t),s(l,le,t),c(N,l,t),s(l,te,t),c(k,l,t),s(l,ee,t),s(l,D,t),s(l,se,t),c(z,l,t),s(l,ne,t),s(l,F,t),s(l,ae,t),c(H,l,t),s(l,pe,t),s(l,Z,t),s(l,Me,t),s(l,S,t),s(l,ie,t),s(l,q,t),s(l,ye,t),s(l,L,t),s(l,Je,t),c(P,l,t),s(l,ce,t),s(l,K,t),s(l,je,t),c(O,l,t),s(l,Te,t),s(l,ll,t),s(l,me,t),c(tl,l,t),s(l,Ue,t),s(l,x,t),s(l,we,t),s(l,el,t),s(l,re,t),c(sl,l,t),s(l,ue,t),s(l,b,t),u(b,R),u(R,St),c(nl,St,null),u(b,wn),u(b,zt),s(l,oe,t),s(l,al,t),s(l,he,t),c(pl,l,t),s(l,de,t),s(l,Ml,t),s(l,Ce,t),c(il,l,t),s(l,be,t),s(l,yl,t),s(l,Ie,t),c(Jl,l,t),s(l,fe,t),s(l,cl,t),s(l,ke,t),s(l,jl,t),s(l,Ze,t),s(l,Tl,t),s(l,xe,t),c(ml,l,t),s(l,Re,t),s(l,Ul,t),s(l,$e,t),c(wl,l,t),s(l,Ae,t),s(l,rl,t),s(l,Qe,t),c(ul,l,t),s(l,_e,t),s(l,ol,t),s(l,ve,t),c(hl,l,t),s(l,Ve,t),s(l,dl,t),s(l,Ge,t),s(l,$,t),s(l,Be,t),s(l,Cl,t),s(l,We,t),c(bl,l,t),s(l,ge,t),s(l,Il,t),s(l,Ee,t),c(fl,l,t),s(l,Xe,t),s(l,A,t),s(l,Ye,t),s(l,kl,t),s(l,Ne,t),c(Zl,l,t),s(l,De,t),s(l,xl,t),s(l,ze,t),c(Rl,l,t),s(l,Fe,t),s(l,$l,t),s(l,He,t),c(Al,l,t),s(l,Se,t),s(l,Ql,t),s(l,qe,t),c(_l,l,t),s(l,Le,t),s(l,vl,t),s(l,Pe,t),c(Vl,l,t),s(l,Ke,t),s(l,Gl,t),s(l,Oe,t),s(l,Bl,t),s(l,ls,t),s(l,Q,t),s(l,ts,t),s(l,Wl,t),s(l,es,t),s(l,gl,t),s(l,ss,t),c(El,l,t),s(l,ns,t),s(l,Xl,t),s(l,as,t),s(l,Yl,t),s(l,ps,t),s(l,_,t),s(l,Ms,t),s(l,Nl,t),s(l,is,t),c(Dl,l,t),s(l,ys,t),s(l,zl,t),s(l,Js,t),c(Fl,l,t),s(l,cs,t),s(l,Hl,t),s(l,js,t),c(Sl,l,t),s(l,Ts,t),s(l,ql,t),s(l,ms,t),c(Ll,l,t),s(l,Us,t),s(l,Pl,t),s(l,ws,t),c(Kl,l,t),s(l,rs,t),s(l,Ol,t),s(l,us,t),c(lt,l,t),s(l,os,t),s(l,v,t),s(l,hs,t),s(l,tt,t),s(l,ds,t),s(l,et,t),s(l,Cs,t),c(st,l,t),s(l,bs,t),s(l,nt,t),s(l,Is,t),c(at,l,t),s(l,fs,t),s(l,pt,t),s(l,ks,t),c(Mt,l,t),s(l,Zs,t),s(l,it,t),s(l,xs,t),c(yt,l,t),s(l,Rs,t),s(l,V,t),s(l,$s,t),s(l,Jt,t),s(l,As,t),c(ct,l,t),s(l,Qs,t),s(l,jt,t),s(l,_s,t),c(Tt,l,t),s(l,vs,t),s(l,G,t),s(l,Vs,t),s(l,mt,t),s(l,Gs,t),c(Ut,l,t),s(l,Bs,t),s(l,wt,t),s(l,Ws,t),c(rt,l,t),s(l,gs,t),s(l,ut,t),s(l,Es,t),c(ot,l,t),s(l,Xs,t),s(l,ht,t),s(l,Ys,t),c(dt,l,t),s(l,Ns,t),s(l,Ct,t),s(l,Ds,t),c(bt,l,t),s(l,zs,t),s(l,It,t),s(l,Fs,t),c(ft,l,t),s(l,Hs,t),s(l,B,t),s(l,Ss,t),s(l,kt,t),s(l,qs,t),c(Zt,l,t),s(l,Ls,t),s(l,xt,t),s(l,Ps,t),c(Rt,l,t),s(l,Ks,t),s(l,$t,t),s(l,Os,t),c(At,l,t),s(l,ln,t),s(l,Qt,t),s(l,tn,t),c(_t,l,t),s(l,en,t),s(l,vt,t),s(l,sn,t),c(Vt,l,t),s(l,nn,t),s(l,Gt,t),s(l,an,t),c(Bt,l,t),s(l,pn,t),s(l,Wt,t),s(l,Mn,t),s(l,gt,t),s(l,yn,t),s(l,Et,t),s(l,Jn,t),s(l,qt,t),cn=!0},p(l,[t]){const Xt={};t&2&&(Xt.$$scope={dirty:t,ctx:l}),k.$set(Xt)},i(l){cn||(j(g.$$.fragment,l),j(X.$$.fragment,l),j(N.$$.fragment,l),j(k.$$.fragment,l),j(z.$$.fragment,l),j(H.$$.fragment,l),j(P.$$.fragment,l),j(O.$$.fragment,l),j(tl.$$.fragment,l),j(sl.$$.fragment,l),j(nl.$$.fragment,l),j(pl.$$.fragment,l),j(il.$$.fragment,l),j(Jl.$$.fragment,l),j(ml.$$.fragment,l),j(wl.$$.fragment,l),j(ul.$$.fragment,l),j(hl.$$.fragment,l),j(bl.$$.fragment,l),j(fl.$$.fragment,l),j(Zl.$$.fragment,l),j(Rl.$$.fragment,l),j(Al.$$.fragment,l),j(_l.$$.fragment,l),j(Vl.$$.fragment,l),j(El.$$.fragment,l),j(Dl.$$.fragment,l),j(Fl.$$.fragment,l),j(Sl.$$.fragment,l),j(Ll.$$.fragment,l),j(Kl.$$.fragment,l),j(lt.$$.fragment,l),j(st.$$.fragment,l),j(at.$$.fragment,l),j(Mt.$$.fragment,l),j(yt.$$.fragment,l),j(ct.$$.fragment,l),j(Tt.$$.fragment,l),j(Ut.$$.fragment,l),j(rt.$$.fragment,l),j(ot.$$.fragment,l),j(dt.$$.fragment,l),j(bt.$$.fragment,l),j(ft.$$.fragment,l),j(Zt.$$.fragment,l),j(Rt.$$.fragment,l),j(At.$$.fragment,l),j(_t.$$.fragment,l),j(Vt.$$.fragment,l),j(Bt.$$.fragment,l),cn=!0)},o(l){T(g.$$.fragment,l),T(X.$$.fragment,l),T(N.$$.fragment,l),T(k.$$.fragment,l),T(z.$$.fragment,l),T(H.$$.fragment,l),T(P.$$.fragment,l),T(O.$$.fragment,l),T(tl.$$.fragment,l),T(sl.$$.fragment,l),T(nl.$$.fragment,l),T(pl.$$.fragment,l),T(il.$$.fragment,l),T(Jl.$$.fragment,l),T(ml.$$.fragment,l),T(wl.$$.fragment,l),T(ul.$$.fragment,l),T(hl.$$.fragment,l),T(bl.$$.fragment,l),T(fl.$$.fragment,l),T(Zl.$$.fragment,l),T(Rl.$$.fragment,l),T(Al.$$.fragment,l),T(_l.$$.fragment,l),T(Vl.$$.fragment,l),T(El.$$.fragment,l),T(Dl.$$.fragment,l),T(Fl.$$.fragment,l),T(Sl.$$.fragment,l),T(Ll.$$.fragment,l),T(Kl.$$.fragment,l),T(lt.$$.fragment,l),T(st.$$.fragment,l),T(at.$$.fragment,l),T(Mt.$$.fragment,l),T(yt.$$.fragment,l),T(ct.$$.fragment,l),T(Tt.$$.fragment,l),T(Ut.$$.fragment,l),T(rt.$$.fragment,l),T(ot.$$.fragment,l),T(dt.$$.fragment,l),T(bt.$$.fragment,l),T(ft.$$.fragment,l),T(Zt.$$.fragment,l),T(Rt.$$.fragment,l),T(At.$$.fragment,l),T(_t.$$.fragment,l),T(Vt.$$.fragment,l),T(Bt.$$.fragment,l),cn=!1},d(l){l&&(e(W),e(o),e(Yt),e(d),e(Pt),e(E),e(Kt),e(C),e(Ot),e(Y),e(le),e(te),e(ee),e(D),e(se),e(ne),e(F),e(ae),e(pe),e(Z),e(Me),e(S),e(ie),e(q),e(ye),e(L),e(Je),e(ce),e(K),e(je),e(Te),e(ll),e(me),e(Ue),e(x),e(we),e(el),e(re),e(ue),e(b),e(oe),e(al),e(he),e(de),e(Ml),e(Ce),e(be),e(yl),e(Ie),e(fe),e(cl),e(ke),e(jl),e(Ze),e(Tl),e(xe),e(Re),e(Ul),e($e),e(Ae),e(rl),e(Qe),e(_e),e(ol),e(ve),e(Ve),e(dl),e(Ge),e($),e(Be),e(Cl),e(We),e(ge),e(Il),e(Ee),e(Xe),e(A),e(Ye),e(kl),e(Ne),e(De),e(xl),e(ze),e(Fe),e($l),e(He),e(Se),e(Ql),e(qe),e(Le),e(vl),e(Pe),e(Ke),e(Gl),e(Oe),e(Bl),e(ls),e(Q),e(ts),e(Wl),e(es),e(gl),e(ss),e(ns),e(Xl),e(as),e(Yl),e(ps),e(_),e(Ms),e(Nl),e(is),e(ys),e(zl),e(Js),e(cs),e(Hl),e(js),e(Ts),e(ql),e(ms),e(Us),e(Pl),e(ws),e(rs),e(Ol),e(us),e(os),e(v),e(hs),e(tt),e(ds),e(et),e(Cs),e(bs),e(nt),e(Is),e(fs),e(pt),e(ks),e(Zs),e(it),e(xs),e(Rs),e(V),e($s),e(Jt),e(As),e(Qs),e(jt),e(_s),e(vs),e(G),e(Vs),e(mt),e(Gs),e(Bs),e(wt),e(Ws),e(gs),e(ut),e(Es),e(Xs),e(ht),e(Ys),e(Ns),e(Ct),e(Ds),e(zs),e(It),e(Fs),e(Hs),e(B),e(Ss),e(kt),e(qs),e(Ls),e(xt),e(Ps),e(Ks),e($t),e(Os),e(ln),e(Qt),e(tn),e(en),e(vt),e(sn),e(nn),e(Gt),e(an),e(pn),e(Wt),e(Mn),e(gt),e(yn),e(Et),e(Jn),e(qt)),e(r),m(g),m(X),m(N,l),m(k,l),m(z,l),m(H,l),m(P,l),m(O,l),m(tl,l),m(sl,l),m(nl),m(pl,l),m(il,l),m(Jl,l),m(ml,l),m(wl,l),m(ul,l),m(hl,l),m(bl,l),m(fl,l),m(Zl,l),m(Rl,l),m(Al,l),m(_l,l),m(Vl,l),m(El,l),m(Dl,l),m(Fl,l),m(Sl,l),m(Ll,l),m(Kl,l),m(lt,l),m(st,l),m(at,l),m(Mt,l),m(yt,l),m(ct,l),m(Tt,l),m(Ut,l),m(rt,l),m(ot,l),m(dt,l),m(bt,l),m(ft,l),m(Zt,l),m(Rt,l),m(At,l),m(_t,l),m(Vt,l),m(Bt,l)}}}const Oa={local:"speecht5",sections:[{local:"housekeeping",title:"House-keeping"},{local:"",title:"Набор данных"},{local:"",sections:[{local:"speecht5",title:"Очистка текста для токенизации SpeechT5"},{local:"",title:"Дикторы"},{local:"",title:"Эмбеддинги диктора"},{local:"",title:"Обработка датасета"},{local:"",title:"Коллатор данных"}],title:"Препроцессинг данных "},{local:"",title:"Обучение модели"},{local:"",title:"Инференс"}],title:"Дообучение SpeechT5"};function lp(Lt){return za(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pp extends Ha{constructor(r){super(),Sa(this,r,lp,Ka,Da,{})}}export{pp as component};
