import{s as st,n as et,o as Mt}from"../chunks/scheduler.f7e1785c.js";import{S as nt,i as at,g as a,s as M,u as i,A as pt,h as p,f as s,c as n,j as tt,y as j,v as y,k as Zl,o as jt,a as e,w as u,d as o,t as c,x as U}from"../chunks/index.815a732f.js";import{C as m}from"../chunks/CodeBlock.c6e8b464.js";function it(Bl){let J,P,L,O,d,ql="Загрузка и изучение аудио набора данных",K,r,El=`В этом курсе мы будем использовать библиотеку 🤗 Datasets для работы с наборами аудиоданных. 🤗 Datasets - это библиотека с открытым исходным кодом для
загрузки и подготовки наборов данных всех модальностей, включая аудио. Библиотека предоставляет легкий доступ к беспрецедентному
подборке наборов данных машинного обучения, публично доступных на Hugging Face Hub. Кроме того, 🤗 Datasets содержит множество
функций, предназначенных для работы с аудиоданными, которые упрощают работу с ними как для исследователей, так и для практиков.`,ll,w,Ql="Для начала работы с наборами аудиоданных необходимо убедиться, что у вас установлена библиотека 🤗 Datasets:",tl,h,sl,A,Wl=`Одной из ключевых особенностей 🤗 Datasets является возможность загрузки и подготовки набора данных всего одной строкой
Python-кода с помощью функции <code>load_dataset()</code>.`,el,C,_l=`Давайте загрузим и исследуем набор аудиоданных под названием <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, который содержит
записи людей, задающих вопросы системе дистанционного банковского обслуживания на нескольких языках и диалектах.`,Ml,b,xl=`Для загрузки набора данных MINDS-14 нам необходимо скопировать идентификатор набора данных на хабе (<code>PolyAI/minds14</code>) и передать его
в функцию <code>load_dataset</code>. Мы также укажем, что нас интересует только австралийское подмножество (<code>en-AU</code>)
данных, и ограничим его частью набора данных предназначенной для обучения:`,nl,I,al,f,Rl="<strong>Output:</strong>",pl,G,jl,k,Fl=`Набор содержит 654 аудиофайла, каждый из которых сопровождается транскрипцией, переводом на английский язык и меткой,
указывающей на намерение человека, сделавшего запрос. В столбце audio содержатся необработанные аудиоданные. Рассмотрим подробнее
на одном из примеров:`,il,g,yl,v,Yl="<strong>Output:</strong>",ul,$,ol,Z,Hl="Вы  можете заметить, что столбец аудио содержит несколько параметров. Вот что они собой представляют:",cl,B,Nl="<li><code>path</code>: путь к аудиофайлу (в данном случае <code>*.wav</code>).</li> <li><code>array</code>: Декодированные аудиоданные, представленные в виде одномерного массива NumPy.</li> <li><code>sampling_rate</code>. Частота дискретизации аудиофайла (в данном примере 8 000 Гц).</li>",Ul,q,Sl=`Класс <code>intent_class</code> - это классификационная категория аудиозаписи. Для преобразования этого числа в осмысленную строку
можно использовать метод <code>int2str()</code>:`,ml,E,Jl,Q,Xl="<strong>Output:</strong>",dl,W,Tl,_,zl=`Если посмотреть на транскрипцию, то можно увидеть, что в аудиофайле действительно записан человек, задающий вопрос
об оплате счета.`,rl,x,Vl=`Если вы планируете обучать аудиоклассификатор на этом подмножестве данных, то, возможно, вам не обязательно понадобятся все признаки. Например,
<code>lang_id</code> будет иметь одно и то же значение для всех примеров и не будет полезен. Параметр <code>english_transcription</code>, скорее всего, будет
дублировать <code>transcription</code> в этом подмножестве, поэтому их можно смело удалить.`,wl,R,Ll="Удалить нерелевантные признаки можно с помощью метода 🤗 Datasets <code>remove_columns</code>:",hl,F,Al,Y,Dl="<strong>Output:</strong>",Cl,H,bl,N,Pl=`Теперь, когда мы загрузили и осмотрели необработанное содержимое набора данных, давайте прослушаем несколько примеров! Мы воспользуемся функциями <code>Blocks</code>
и <code>Audio</code> из <code>Gradio</code> для декодирования нескольких случайных образцов из набора данных:`,Il,S,fl,X,Ol="При желании можно также визуализировать некоторые примеры. Построим форму волны для первого примера.",Gl,z,kl,T,Kl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',gl,V,lt=`Попробуйте! Загрузите другой диалект или язык из набора данных MINDS-14, прослушайте и визуализируйте несколько примеров, чтобы получить представление
о вариативности всего набора данных. Полный список доступных языков можно найти <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">здесь</a>.`,vl,D,$l;return h=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]"}}),I=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`}}),G=new m({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`}}),g=new m({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`}}),$=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`}}),E=new m({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`}}),W=new m({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>'}}),F=new m({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`}}),H=new m({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>'}}),S=new m({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`}}),z=new m({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`}}),{c(){J=a("meta"),P=M(),L=a("p"),O=M(),d=a("h1"),d.textContent=ql,K=M(),r=a("p"),r.textContent=El,ll=M(),w=a("p"),w.textContent=Ql,tl=M(),i(h.$$.fragment),sl=M(),A=a("p"),A.innerHTML=Wl,el=M(),C=a("p"),C.innerHTML=_l,Ml=M(),b=a("p"),b.innerHTML=xl,nl=M(),i(I.$$.fragment),al=M(),f=a("p"),f.innerHTML=Rl,pl=M(),i(G.$$.fragment),jl=M(),k=a("p"),k.textContent=Fl,il=M(),i(g.$$.fragment),yl=M(),v=a("p"),v.innerHTML=Yl,ul=M(),i($.$$.fragment),ol=M(),Z=a("p"),Z.textContent=Hl,cl=M(),B=a("ul"),B.innerHTML=Nl,Ul=M(),q=a("p"),q.innerHTML=Sl,ml=M(),i(E.$$.fragment),Jl=M(),Q=a("p"),Q.innerHTML=Xl,dl=M(),i(W.$$.fragment),Tl=M(),_=a("p"),_.textContent=zl,rl=M(),x=a("p"),x.innerHTML=Vl,wl=M(),R=a("p"),R.innerHTML=Ll,hl=M(),i(F.$$.fragment),Al=M(),Y=a("p"),Y.innerHTML=Dl,Cl=M(),i(H.$$.fragment),bl=M(),N=a("p"),N.innerHTML=Pl,Il=M(),i(S.$$.fragment),fl=M(),X=a("p"),X.textContent=Ol,Gl=M(),i(z.$$.fragment),kl=M(),T=a("div"),T.innerHTML=Kl,gl=M(),V=a("p"),V.innerHTML=lt,vl=M(),D=a("p"),this.h()},l(l){const t=pt("svelte-1phssyn",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(s),P=n(l),L=p(l,"P",{}),tt(L).forEach(s),O=n(l),d=p(l,"H1",{id:!0,"data-svelte-h":!0}),j(d)!=="svelte-qakubj"&&(d.textContent=ql),K=n(l),r=p(l,"P",{"data-svelte-h":!0}),j(r)!=="svelte-1407nk3"&&(r.textContent=El),ll=n(l),w=p(l,"P",{"data-svelte-h":!0}),j(w)!=="svelte-jvig6b"&&(w.textContent=Ql),tl=n(l),y(h.$$.fragment,l),sl=n(l),A=p(l,"P",{"data-svelte-h":!0}),j(A)!=="svelte-19l0nc5"&&(A.innerHTML=Wl),el=n(l),C=p(l,"P",{"data-svelte-h":!0}),j(C)!=="svelte-y6lghn"&&(C.innerHTML=_l),Ml=n(l),b=p(l,"P",{"data-svelte-h":!0}),j(b)!=="svelte-1p95sde"&&(b.innerHTML=xl),nl=n(l),y(I.$$.fragment,l),al=n(l),f=p(l,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1mvdyro"&&(f.innerHTML=Rl),pl=n(l),y(G.$$.fragment,l),jl=n(l),k=p(l,"P",{"data-svelte-h":!0}),j(k)!=="svelte-z2d4pj"&&(k.textContent=Fl),il=n(l),y(g.$$.fragment,l),yl=n(l),v=p(l,"P",{"data-svelte-h":!0}),j(v)!=="svelte-1mvdyro"&&(v.innerHTML=Yl),ul=n(l),y($.$$.fragment,l),ol=n(l),Z=p(l,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-1d20a7n"&&(Z.textContent=Hl),cl=n(l),B=p(l,"UL",{"data-svelte-h":!0}),j(B)!=="svelte-19j7ei3"&&(B.innerHTML=Nl),Ul=n(l),q=p(l,"P",{"data-svelte-h":!0}),j(q)!=="svelte-15rxufv"&&(q.innerHTML=Sl),ml=n(l),y(E.$$.fragment,l),Jl=n(l),Q=p(l,"P",{"data-svelte-h":!0}),j(Q)!=="svelte-1mvdyro"&&(Q.innerHTML=Xl),dl=n(l),y(W.$$.fragment,l),Tl=n(l),_=p(l,"P",{"data-svelte-h":!0}),j(_)!=="svelte-uf721q"&&(_.textContent=zl),rl=n(l),x=p(l,"P",{"data-svelte-h":!0}),j(x)!=="svelte-1j19fbi"&&(x.innerHTML=Vl),wl=n(l),R=p(l,"P",{"data-svelte-h":!0}),j(R)!=="svelte-8iyemc"&&(R.innerHTML=Ll),hl=n(l),y(F.$$.fragment,l),Al=n(l),Y=p(l,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-1mvdyro"&&(Y.innerHTML=Dl),Cl=n(l),y(H.$$.fragment,l),bl=n(l),N=p(l,"P",{"data-svelte-h":!0}),j(N)!=="svelte-1q7cy5s"&&(N.innerHTML=Pl),Il=n(l),y(S.$$.fragment,l),fl=n(l),X=p(l,"P",{"data-svelte-h":!0}),j(X)!=="svelte-ovtdpu"&&(X.textContent=Ol),Gl=n(l),y(z.$$.fragment,l),kl=n(l),T=p(l,"DIV",{class:!0,"data-svelte-h":!0}),j(T)!=="svelte-1ym6zda"&&(T.innerHTML=Kl),gl=n(l),V=p(l,"P",{"data-svelte-h":!0}),j(V)!=="svelte-1un66iu"&&(V.innerHTML=lt),vl=n(l),D=p(l,"P",{}),tt(D).forEach(s),this.h()},h(){Zl(J,"name","hf:doc:metadata"),Zl(J,"content",JSON.stringify(yt)),Zl(d,"id",""),Zl(T,"class","flex justify-center")},m(l,t){jt(document.head,J),e(l,P,t),e(l,L,t),e(l,O,t),e(l,d,t),e(l,K,t),e(l,r,t),e(l,ll,t),e(l,w,t),e(l,tl,t),u(h,l,t),e(l,sl,t),e(l,A,t),e(l,el,t),e(l,C,t),e(l,Ml,t),e(l,b,t),e(l,nl,t),u(I,l,t),e(l,al,t),e(l,f,t),e(l,pl,t),u(G,l,t),e(l,jl,t),e(l,k,t),e(l,il,t),u(g,l,t),e(l,yl,t),e(l,v,t),e(l,ul,t),u($,l,t),e(l,ol,t),e(l,Z,t),e(l,cl,t),e(l,B,t),e(l,Ul,t),e(l,q,t),e(l,ml,t),u(E,l,t),e(l,Jl,t),e(l,Q,t),e(l,dl,t),u(W,l,t),e(l,Tl,t),e(l,_,t),e(l,rl,t),e(l,x,t),e(l,wl,t),e(l,R,t),e(l,hl,t),u(F,l,t),e(l,Al,t),e(l,Y,t),e(l,Cl,t),u(H,l,t),e(l,bl,t),e(l,N,t),e(l,Il,t),u(S,l,t),e(l,fl,t),e(l,X,t),e(l,Gl,t),u(z,l,t),e(l,kl,t),e(l,T,t),e(l,gl,t),e(l,V,t),e(l,vl,t),e(l,D,t),$l=!0},p:et,i(l){$l||(o(h.$$.fragment,l),o(I.$$.fragment,l),o(G.$$.fragment,l),o(g.$$.fragment,l),o($.$$.fragment,l),o(E.$$.fragment,l),o(W.$$.fragment,l),o(F.$$.fragment,l),o(H.$$.fragment,l),o(S.$$.fragment,l),o(z.$$.fragment,l),$l=!0)},o(l){c(h.$$.fragment,l),c(I.$$.fragment,l),c(G.$$.fragment,l),c(g.$$.fragment,l),c($.$$.fragment,l),c(E.$$.fragment,l),c(W.$$.fragment,l),c(F.$$.fragment,l),c(H.$$.fragment,l),c(S.$$.fragment,l),c(z.$$.fragment,l),$l=!1},d(l){l&&(s(P),s(L),s(O),s(d),s(K),s(r),s(ll),s(w),s(tl),s(sl),s(A),s(el),s(C),s(Ml),s(b),s(nl),s(al),s(f),s(pl),s(jl),s(k),s(il),s(yl),s(v),s(ul),s(ol),s(Z),s(cl),s(B),s(Ul),s(q),s(ml),s(Jl),s(Q),s(dl),s(Tl),s(_),s(rl),s(x),s(wl),s(R),s(hl),s(Al),s(Y),s(Cl),s(bl),s(N),s(Il),s(fl),s(X),s(Gl),s(kl),s(T),s(gl),s(V),s(vl),s(D)),s(J),U(h,l),U(I,l),U(G,l),U(g,l),U($,l),U(E,l),U(W,l),U(F,l),U(H,l),U(S,l),U(z,l)}}}const yt={local:"",title:"Загрузка и изучение аудио набора данных"};function ut(Bl){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mt extends nt{constructor(J){super(),at(this,J,ut,it,st,{})}}export{mt as component};
