import{s as Vs,o as As,n as Tt}from"../chunks/scheduler.9bc65507.js";import{S as Xs,i as Ys,g as i,s as n,r as p,A as Qs,h as d,f as t,c as s,j as T,u as h,x as m,k as x,y as r,a,v as u,d as g,t as f,w as _}from"../chunks/index.707bf1b6.js";import{T as Qn}from"../chunks/Tip.c2ecdbf4.js";import{D as M}from"../chunks/Docstring.17db21ae.js";import{C as wt}from"../chunks/CodeBlock.54a9f38d.js";import{E as en}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as Ks}from"../chunks/PipelineTag.44585822.js";import{H as Z}from"../chunks/Heading.342b1fa6.js";function er(F){let c,w="Examples:",b,v,y;return v=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERldHJDb25maWclMkMlMjBEZXRyTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwREVUUiUyMGZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRGV0ckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXRyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrConfig, DetrModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DETR facebook/detr-resnet-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DetrConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/detr-resnet-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=i("p"),c.textContent=w,b=n(),p(v.$$.fragment)},l(l){c=d(l,"P",{"data-svelte-h":!0}),m(c)!=="svelte-kvfsh7"&&(c.textContent=w),b=s(l),h(v.$$.fragment,l)},m(l,D){a(l,c,D),a(l,b,D),u(v,l,D),y=!0},p:Tt,i(l){y||(g(v.$$.fragment,l),y=!0)},o(l){f(v.$$.fragment,l),y=!1},d(l){l&&(t(c),t(b)),_(v,l)}}}function tr(F){let c,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=w},l(b){c=d(b,"P",{"data-svelte-h":!0}),m(c)!=="svelte-fincs2"&&(c.innerHTML=w)},m(b,v){a(b,c,v)},p:Tt,d(b){b&&t(c)}}}function or(F){let c,w="Examples:",b,v,y;return v=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERldHJNb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMERldHJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEElMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMjBmb3IlMjB0aGUlMjBtb2RlbCUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwdGhlJTIwbGFzdCUyMGhpZGRlbiUyMHN0YXRlcyUyMGFyZSUyMHRoZSUyMGZpbmFsJTIwcXVlcnklMjBlbWJlZGRpbmdzJTIwb2YlMjB0aGUlMjBUcmFuc2Zvcm1lciUyMGRlY29kZXIlMEElMjMlMjB0aGVzZSUyMGFyZSUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9xdWVyaWVzJTJDJTIwaGlkZGVuX3NpemUpJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DetrModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrModel.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the last hidden states are the final query embeddings of the Transformer decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># these are of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">100</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){c=i("p"),c.textContent=w,b=n(),p(v.$$.fragment)},l(l){c=d(l,"P",{"data-svelte-h":!0}),m(c)!=="svelte-kvfsh7"&&(c.textContent=w),b=s(l),h(v.$$.fragment,l)},m(l,D){a(l,c,D),a(l,b,D),u(v,l,D),y=!0},p:Tt,i(l){y||(g(v.$$.fragment,l),y=!0)},o(l){f(v.$$.fragment,l),y=!1},d(l){l&&(t(c),t(b)),_(v,l)}}}function nr(F){let c,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=w},l(b){c=d(b,"P",{"data-svelte-h":!0}),m(c)!=="svelte-fincs2"&&(c.innerHTML=w)},m(b,v){a(b,c,v)},p:Tt,d(b){b&&t(c)}}}function sr(F){let c,w="Examples:",b,v,y;return v=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERldHJGb3JPYmplY3REZXRlY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMERldHJGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwY29udmVydCUyMG91dHB1dHMlMjAoYm91bmRpbmclMjBib3hlcyUyMGFuZCUyMGNsYXNzJTIwbG9naXRzKSUyMHRvJTIwUGFzY2FsJTIwVk9DJTIwZm9ybWF0JTIwKHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXgpJTBBdGFyZ2V0X3NpemVzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QmltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCU1RCklMEFyZXN1bHRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19vYmplY3RfZGV0ZWN0aW9uKG91dHB1dHMlMkMlMjB0aHJlc2hvbGQlM0QwLjklMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCJTBBJTIwJTIwJTIwJTIwMCUwQSU1RCUwQSUwQWZvciUyMHNjb3JlJTJDJTIwbGFiZWwlMkMlMjBib3glMjBpbiUyMHppcChyZXN1bHRzJTVCJTIyc2NvcmVzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmxhYmVscyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjBib3glMjAlM0QlMjAlNUJyb3VuZChpJTJDJTIwMiklMjBmb3IlMjBpJTIwaW4lMjBib3gudG9saXN0KCklNUQlMEElMjAlMjAlMjAlMjBwcmludCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyRGV0ZWN0ZWQlMjAlN0Jtb2RlbC5jb25maWcuaWQybGFiZWwlNUJsYWJlbC5pdGVtKCklNUQlN0QlMjB3aXRoJTIwY29uZmlkZW5jZSUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjIlN0Jyb3VuZChzY29yZS5pdGVtKCklMkMlMjAzKSU3RCUyMGF0JTIwbG9jYXRpb24lMjAlN0Jib3glN0QlMjIlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DetrForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.998</span> at location [<span class="hljs-number">40.16</span>, <span class="hljs-number">70.81</span>, <span class="hljs-number">175.55</span>, <span class="hljs-number">117.98</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.996</span> at location [<span class="hljs-number">333.24</span>, <span class="hljs-number">72.55</span>, <span class="hljs-number">368.33</span>, <span class="hljs-number">187.66</span>]
Detected couch <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.995</span> at location [-<span class="hljs-number">0.02</span>, <span class="hljs-number">1.15</span>, <span class="hljs-number">639.73</span>, <span class="hljs-number">473.76</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.999</span> at location [<span class="hljs-number">13.24</span>, <span class="hljs-number">52.05</span>, <span class="hljs-number">314.02</span>, <span class="hljs-number">470.93</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.999</span> at location [<span class="hljs-number">345.4</span>, <span class="hljs-number">23.85</span>, <span class="hljs-number">640.37</span>, <span class="hljs-number">368.72</span>]`,wrap:!1}}),{c(){c=i("p"),c.textContent=w,b=n(),p(v.$$.fragment)},l(l){c=d(l,"P",{"data-svelte-h":!0}),m(c)!=="svelte-kvfsh7"&&(c.textContent=w),b=s(l),h(v.$$.fragment,l)},m(l,D){a(l,c,D),a(l,b,D),u(v,l,D),y=!0},p:Tt,i(l){y||(g(v.$$.fragment,l),y=!0)},o(l){f(v.$$.fragment,l),y=!1},d(l){l&&(t(c),t(b)),_(v,l)}}}function rr(F){let c,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=w},l(b){c=d(b,"P",{"data-svelte-h":!0}),m(c)!=="svelte-fincs2"&&(c.innerHTML=w)},m(b,v){a(b,c,v)},p:Tt,d(b){b&&t(c)}}}function ar(F){let c,w="Examples:",b,v,y;return v=new wt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> io
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DetrForSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.image_transforms <span class="hljs-keyword">import</span> rgb_to_id

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50-panoptic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrForSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50-panoptic&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use the \`post_process_panoptic_segmentation\` method of the \`image_processor\` to retrieve post-processed panoptic segmentation maps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Segmentation results are returned as a list of dictionaries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = image_processor.post_process_panoptic_segmentation(outputs, target_sizes=[(<span class="hljs-number">300</span>, <span class="hljs-number">500</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A tensor of shape (height, width) where each value denotes a segment id, filled with -1 if no segment is found</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>panoptic_seg = result[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get prediction score and segment_id to class_id mapping of each segment</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>panoptic_segments_info = result[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segments_info&quot;</span>]`,wrap:!1}}),{c(){c=i("p"),c.textContent=w,b=n(),p(v.$$.fragment)},l(l){c=d(l,"P",{"data-svelte-h":!0}),m(c)!=="svelte-kvfsh7"&&(c.textContent=w),b=s(l),h(v.$$.fragment,l)},m(l,D){a(l,c,D),a(l,b,D),u(v,l,D),y=!0},p:Tt,i(l){y||(g(v.$$.fragment,l),y=!0)},o(l){f(v.$$.fragment,l),y=!1},d(l){l&&(t(c),t(b)),_(v,l)}}}function ir(F){let c,w,b,v,y,l,D,Kt,he,Kn=`The DETR model was proposed in <a href="https://arxiv.org/abs/2005.12872" rel="nofollow">End-to-End Object Detection with Transformers</a> by
Nicolas Carion, Francisco Massa, Gabriel Synnaeve, Nicolas Usunier, Alexander Kirillov and Sergey Zagoruyko. DETR
consists of a convolutional backbone followed by an encoder-decoder Transformer which can be trained end-to-end for
object detection. It greatly simplifies a lot of the complexity of models like Faster-R-CNN and Mask-R-CNN, which use
things like region proposals, non-maximum suppression procedure and anchor generation. Moreover, DETR can also be
naturally extended to perform panoptic segmentation, by simply adding a mask head on top of the decoder outputs.`,eo,ue,es="The abstract from the paper is the following:",to,ge,ts=`<em>We present a new method that views object detection as a direct set prediction problem. Our approach streamlines the
detection pipeline, effectively removing the need for many hand-designed components like a non-maximum suppression
procedure or anchor generation that explicitly encode our prior knowledge about the task. The main ingredients of the
new framework, called DEtection TRansformer or DETR, are a set-based global loss that forces unique predictions via
bipartite matching, and a transformer encoder-decoder architecture. Given a fixed small set of learned object queries,
DETR reasons about the relations of the objects and the global image context to directly output the final set of
predictions in parallel. The new model is conceptually simple and does not require a specialized library, unlike many
other modern detectors. DETR demonstrates accuracy and run-time performance on par with the well-established and
highly-optimized Faster RCNN baseline on the challenging COCO object detection dataset. Moreover, DETR can be easily
generalized to produce panoptic segmentation in a unified manner. We show that it significantly outperforms competitive
baselines.</em>`,oo,fe,os='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/facebookresearch/detr" rel="nofollow">here</a>.',no,_e,so,be,ns='Here’s a TLDR explaining how <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> works:',ro,ve,ss=`First, an image is sent through a pre-trained convolutional backbone (in the paper, the authors use
ResNet-50/ResNet-101). Let’s assume we also add a batch dimension. This means that the input to the backbone is a
tensor of shape <code>(batch_size, 3, height, width)</code>, assuming the image has 3 color channels (RGB). The CNN backbone
outputs a new lower-resolution feature map, typically of shape <code>(batch_size, 2048, height/32, width/32)</code>. This is
then projected to match the hidden dimension of the Transformer of DETR, which is <code>256</code> by default, using a
<code>nn.Conv2D</code> layer. So now, we have a tensor of shape <code>(batch_size, 256, height/32, width/32).</code> Next, the
feature map is flattened and transposed to obtain a tensor of shape <code>(batch_size, seq_len, d_model)</code> =
<code>(batch_size, width/32*height/32, 256)</code>. So a difference with NLP models is that the sequence length is actually
longer than usual, but with a smaller <code>d_model</code> (which in NLP is typically 768 or higher).`,ao,ye,rs=`Next, this is sent through the encoder, outputting <code>encoder_hidden_states</code> of the same shape (you can consider
these as image features). Next, so-called <strong>object queries</strong> are sent through the decoder. This is a tensor of shape
<code>(batch_size, num_queries, d_model)</code>, with <code>num_queries</code> typically set to 100 and initialized with zeros.
These input embeddings are learnt positional encodings that the authors refer to as object queries, and similarly to
the encoder, they are added to the input of each attention layer. Each object query will look for a particular object
in the image. The decoder updates these embeddings through multiple self-attention and encoder-decoder attention layers
to output <code>decoder_hidden_states</code> of the same shape: <code>(batch_size, num_queries, d_model)</code>. Next, two heads
are added on top for object detection: a linear layer for classifying each object query into one of the objects or “no
object”, and a MLP to predict bounding boxes for each query.`,io,we,as=`The model is trained using a <strong>bipartite matching loss</strong>: so what we actually do is compare the predicted classes +
bounding boxes of each of the N = 100 object queries to the ground truth annotations, padded up to the same length N
(so if an image only contains 4 objects, 96 annotations will just have a “no object” as class and “no bounding box” as
bounding box). The <a href="https://en.wikipedia.org/wiki/Hungarian_algorithm" rel="nofollow">Hungarian matching algorithm</a> is used to find
an optimal one-to-one mapping of each of the N queries to each of the N annotations. Next, standard cross-entropy (for
the classes) and a linear combination of the L1 and <a href="https://giou.stanford.edu/" rel="nofollow">generalized IoU loss</a> (for the
bounding boxes) are used to optimize the parameters of the model.`,co,Te,is=`DETR can be naturally extended to perform panoptic segmentation (which unifies semantic segmentation and instance
segmentation). <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> adds a segmentation mask head on top of
<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a>. The mask head can be trained either jointly, or in a two steps process,
where one first trains a <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> model to detect bounding boxes around both
“things” (instances) and “stuff” (background things like trees, roads, sky), then freeze all the weights and train only
the mask head for 25 epochs. Experimentally, these two approaches give similar results. Note that predicting boxes is
required for the training to be possible, since the Hungarian matching is computed using distances between boxes.`,lo,xe,mo,De,ds=`<li>DETR uses so-called <strong>object queries</strong> to detect objects in an image. The number of queries determines the maximum
number of objects that can be detected in a single image, and is set to 100 by default (see parameter
<code>num_queries</code> of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a>). Note that it’s good to have some slack (in COCO, the
authors used 100, while the maximum number of objects in a COCO image is ~70).</li> <li>The decoder of DETR updates the query embeddings in parallel. This is different from language models like GPT-2,
which use autoregressive decoding instead of parallel. Hence, no causal attention mask is used.</li> <li>DETR adds position embeddings to the hidden states at each self-attention and cross-attention layer before projecting
to queries and keys. For the position embeddings of the image, one can choose between fixed sinusoidal or learned
absolute position embeddings. By default, the parameter <code>position_embedding_type</code> of
<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> is set to <code>&quot;sine&quot;</code>.</li> <li>During training, the authors of DETR did find it helpful to use auxiliary losses in the decoder, especially to help
the model output the correct number of objects of each class. If you set the parameter <code>auxiliary_loss</code> of
<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> to <code>True</code>, then prediction feedforward neural networks and Hungarian losses
are added after each decoder layer (with the FFNs sharing parameters).</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<em>num_boxes</em> variable in the <em>DetrLoss</em> class of <em>modeling_detr.py</em>. When training on multiple nodes, this should be
set to the average number of target boxes across all nodes, as can be seen in the original implementation <a href="https://github.com/facebookresearch/detr/blob/a54b77800eb8e64e3ad0d8237789fcbf2f8350c5/models/detr.py#L227-L232" rel="nofollow">here</a>.</li> <li><a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> and <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> can be initialized with
any convolutional backbone available in the <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm library</a>.
Initializing with a MobileNet backbone for example can be done by setting the <code>backbone</code> attribute of
<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> to <code>&quot;tf_mobilenetv3_small_075&quot;</code>, and then initializing the model with that
config.</li> <li>DETR resizes the input images such that the shortest side is at least a certain amount of pixels while the longest is
at most 1333 pixels. At training time, scale augmentation is used such that the shortest side is randomly set to at
least 480 and at most 800 pixels. At inference time, the shortest side is set to 800. One can use
<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> to prepare images (and optional annotations in COCO format) for the
model. Due to this resizing, images in a batch can have different sizes. DETR solves this by padding images up to the
largest size in a batch, and by creating a pixel mask that indicates which pixels are real/which are padding.
Alternatively, one can also define a custom <code>collate_fn</code> in order to batch images together, using
<code>~transformers.DetrImageProcessor.pad_and_create_pixel_mask</code>.</li> <li>The size of the images will determine the amount of memory being used, and will thus determine the <code>batch_size</code>.
It is advised to use a batch size of 2 per GPU. See <a href="https://github.com/facebookresearch/detr/issues/150" rel="nofollow">this Github thread</a> for more info.</li>`,po,Me,cs="There are three ways to instantiate a DETR model (depending on what you prefer):",ho,je,ls="Option 1: Instantiate DETR with pre-trained weights for entire model",uo,$e,go,ke,ms="Option 2: Instantiate DETR with randomly initialized weights for Transformer, but pre-trained weights for backbone",fo,Fe,_o,Ce,ps="Option 3: Instantiate DETR with randomly initialized weights for backbone + Transformer",bo,ze,vo,Ie,hs="As a summary, consider the following table:",yo,Je,us='<thead><tr><th>Task</th> <th>Object detection</th> <th>Instance segmentation</th> <th>Panoptic segmentation</th></tr></thead> <tbody><tr><td><strong>Description</strong></td> <td>Predicting bounding boxes and class labels around objects in an image</td> <td>Predicting masks around objects (i.e. instances) in an image</td> <td>Predicting masks around both objects (i.e. instances) as well as “stuff” (i.e. background things like trees and roads) in an image</td></tr> <tr><td><strong>Model</strong></td> <td><a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a></td> <td><a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a></td> <td><a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a></td></tr> <tr><td><strong>Example dataset</strong></td> <td>COCO detection</td> <td>COCO detection, COCO panoptic</td> <td>COCO panoptic</td></tr> <tr><td><strong>Format of annotations to provide to</strong> <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a></td> <td>{‘image_id’: <code>int</code>, ‘annotations’: <code>List[Dict]</code>} each Dict being a COCO object annotation</td> <td>{‘image_id’: <code>int</code>, ‘annotations’: <code>List[Dict]</code>}  (in case of COCO detection) or {‘file_name’: <code>str</code>, ‘image_id’: <code>int</code>, ‘segments_info’: <code>List[Dict]</code>} (in case of COCO panoptic)</td> <td>{‘file_name’: <code>str</code>, ‘image_id’: <code>int</code>, ‘segments_info’: <code>List[Dict]</code>} and masks_path (path to directory containing PNG files of the masks)</td></tr> <tr><td><strong>Postprocessing</strong> (i.e. converting the output of the model to Pascal VOC format)</td> <td><code>post_process()</code></td> <td><code>post_process_segmentation()</code></td> <td><code>post_process_segmentation()</code>, <code>post_process_panoptic()</code></td></tr> <tr><td><strong>evaluators</strong></td> <td><code>CocoEvaluator</code> with <code>iou_types=&quot;bbox&quot;</code></td> <td><code>CocoEvaluator</code> with <code>iou_types=&quot;bbox&quot;</code> or <code>&quot;segm&quot;</code></td> <td><code>CocoEvaluator</code> with <code>iou_tupes=&quot;bbox&quot;</code> or <code>&quot;segm&quot;</code>, <code>PanopticEvaluator</code></td></tr></tbody>',wo,Ne,gs=`In short, one should prepare the data either in COCO detection or COCO panoptic format, then use
<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> to create <code>pixel_values</code>, <code>pixel_mask</code> and optional
<code>labels</code>, which can then be used to train (or fine-tune) a model. For evaluation, one should first convert the
outputs of the model using one of the postprocessing methods of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a>. These can
be be provided to either <code>CocoEvaluator</code> or <code>PanopticEvaluator</code>, which allow you to calculate metrics like
mean Average Precision (mAP) and Panoptic Quality (PQ). The latter objects are implemented in the <a href="https://github.com/facebookresearch/detr" rel="nofollow">original repository</a>. See the <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/DETR" rel="nofollow">example notebooks</a> for more info regarding evaluation.`,To,Oe,xo,Ue,fs="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with DETR.",Do,qe,Mo,Ee,_s='<li>All example notebooks illustrating fine-tuning <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> and <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> on a custom dataset an be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/DETR" rel="nofollow">here</a>.</li> <li>See also: <a href="../tasks/object_detection">Object detection task guide</a></li>',jo,Ze,bs="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",$o,Re,ko,C,Pe,tn,xt,vs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrModel">DetrModel</a>. It is used to instantiate a DETR
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DETR
<a href="https://huggingface.co/facebook/detr-resnet-50" rel="nofollow">facebook/detr-resnet-50</a> architecture.`,on,Dt,ys=`Configuration objects inherit from <a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,nn,B,sn,G,Le,rn,Mt,ws='Instantiate a <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> (or a derived class) from a pre-trained backbone model configuration.',Fo,We,Co,j,Se,an,jt,Ts="Constructs a Detr image processor.",dn,V,He,cn,$t,xs="Preprocess an image or a batch of images so that it can be used by the model.",ln,A,Be,mn,kt,Ds=`Converts the raw output of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,pn,X,Ge,hn,Ft,Ms='Converts the output of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',un,Y,Ve,gn,Ct,js='Converts the output of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into instance segmentation predictions. Only supports PyTorch.',fn,Q,Ae,_n,zt,$s=`Converts the output of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into image panoptic segmentation predictions. Only supports
PyTorch.`,zo,Xe,Io,$,Ye,bn,K,Qe,vn,It,ks="Preprocess an image or a batch of images.",yn,ee,Ke,wn,Jt,Fs=`Converts the raw output of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,Tn,te,et,xn,Nt,Cs='Converts the output of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',Dn,oe,tt,Mn,Ot,zs='Converts the output of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into instance segmentation predictions. Only supports PyTorch.',jn,ne,ot,$n,Ut,Is=`Converts the output of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into image panoptic segmentation predictions. Only supports
PyTorch.`,Jo,nt,No,W,st,kn,qt,Js=`Base class for outputs of the DETR encoder-decoder model. This class adds one attribute to Seq2SeqModelOutput,
namely an optional stack of intermediate decoder activations, i.e. the output of each decoder layer, each of them
gone through a layernorm. This is useful when training the model with auxiliary decoding losses.`,Oo,S,rt,Fn,Et,Ns='Output type of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a>.',Uo,H,at,Cn,Zt,Os='Output type of <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>.',qo,it,Eo,z,dt,zn,Rt,Us=`The bare DETR Model (consisting of a backbone and encoder-decoder Transformer) outputting raw hidden-states without
any specific head on top.`,In,Pt,qs=`This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Jn,Lt,Es=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Nn,O,ct,On,Wt,Zs='The <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrModel">DetrModel</a> forward method, overrides the <code>__call__</code> special method.',Un,se,qn,re,Zo,lt,Ro,I,mt,En,St,Rs=`DETR Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on top, for tasks
such as COCO detection.`,Zn,Ht,Ps=`This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Rn,Bt,Ls=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pn,U,pt,Ln,Gt,Ws='The <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Wn,ae,Sn,ie,Po,ht,Lo,J,ut,Hn,Vt,Ss=`DETR Model (consisting of a backbone and encoder-decoder Transformer) with a segmentation head on top, for tasks
such as COCO panoptic.`,Bn,At,Hs=`This model inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Gn,Xt,Bs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Vn,q,gt,An,Yt,Gs='The <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Xn,de,Yn,ce,Wo,Qt,So;return y=new Z({props:{title:"DETR",local:"detr",headingTag:"h1"}}),D=new Z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),_e=new Z({props:{title:"How DETR works",local:"how-detr-works",headingTag:"h2"}}),xe=new Z({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),$e=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERldHJGb3JPYmplY3REZXRlY3Rpb24lMEElMEFtb2RlbCUyMCUzRCUyMERldHJGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)`,wrap:!1}}),Fe=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERldHJDb25maWclMkMlMjBEZXRyRm9yT2JqZWN0RGV0ZWN0aW9uJTBBJTBBY29uZmlnJTIwJTNEJTIwRGV0ckNvbmZpZygpJTBBbW9kZWwlMjAlM0QlMjBEZXRyRm9yT2JqZWN0RGV0ZWN0aW9uKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrConfig, DetrForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>config = DetrConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrForObjectDetection(config)`,wrap:!1}}),ze=new wt({props:{code:"Y29uZmlnJTIwJTNEJTIwRGV0ckNvbmZpZyh1c2VfcHJldHJhaW5lZF9iYWNrYm9uZSUzREZhbHNlKSUwQW1vZGVsJTIwJTNEJTIwRGV0ckZvck9iamVjdERldGVjdGlvbihjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>config = DetrConfig(use_pretrained_backbone=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrForObjectDetection(config)`,wrap:!1}}),Oe=new Z({props:{title:"Resources",local:"resources",headingTag:"h2"}}),qe=new Ks({props:{pipeline:"object-detection"}}),Re=new Z({props:{title:"DetrConfig",local:"transformers.DetrConfig",headingTag:"h2"}}),Pe=new M({props:{name:"class transformers.DetrConfig",anchor:"transformers.DetrConfig",parameters:[{name:"use_timm_backbone",val:" = True"},{name:"backbone_config",val:" = None"},{name:"num_channels",val:" = 3"},{name:"num_queries",val:" = 100"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"encoder_layerdrop",val:" = 0.0"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"init_xavier_std",val:" = 1.0"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"backbone",val:" = 'resnet50'"},{name:"use_pretrained_backbone",val:" = True"},{name:"backbone_kwargs",val:" = None"},{name:"dilation",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"mask_loss_coefficient",val:" = 1"},{name:"dice_loss_coefficient",val:" = 1"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DetrConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <a href="/docs/transformers/v4.38.1/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DetrConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>use_timm_backbone</code> is set to <code>False</code> in which
case it will default to <code>ResNetConfig()</code>.`,name:"backbone_config"},{anchor:"transformers.DetrConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.DetrConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrModel">DetrModel</a> can
detect in a single image. For COCO, we recommend 100 queries.`,name:"num_queries"},{anchor:"transformers.DetrConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.DetrConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.DetrConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.DetrConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.DetrConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.DetrConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.DetrConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.DetrConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.DetrConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.DetrConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.DetrConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.DetrConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.DetrConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.DetrConfig.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the encoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.DetrConfig.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.DetrConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.DetrConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.DetrConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;resnet50&quot;</code>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DetrConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>True</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DetrConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.DetrConfig.dilation",description:`<strong>dilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to replace stride with dilation in the last convolutional block (DC5). Only supported when
<code>use_timm_backbone</code> = <code>True</code>.`,name:"dilation"},{anchor:"transformers.DetrConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.DetrConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.DetrConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.DetrConfig.mask_loss_coefficient",description:`<strong>mask_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the Focal loss in the panoptic segmentation loss.`,name:"mask_loss_coefficient"},{anchor:"transformers.DetrConfig.dice_loss_coefficient",description:`<strong>dice_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the DICE/F-1 loss in the panoptic segmentation loss.`,name:"dice_loss_coefficient"},{anchor:"transformers.DetrConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.DetrConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.DetrConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/configuration_detr.py#L36"}}),B=new en({props:{anchor:"transformers.DetrConfig.example",$$slots:{default:[er]},$$scope:{ctx:F}}}),Le=new M({props:{name:"from_backbone_config",anchor:"transformers.DetrConfig.from_backbone_config",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DetrConfig.from_backbone_config.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/configuration_detr.py#L255",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig"
>DetrConfig</a></p>
`}}),We=new Z({props:{title:"DetrImageProcessor",local:"transformers.DetrImageProcessor",headingTag:"h2"}}),Se=new M({props:{name:"class transformers.DetrImageProcessor",anchor:"transformers.DetrImageProcessor",parameters:[{name:"format",val:": Union = <AnnotationFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"do_pad",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;coco_detection&quot;</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.DetrImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s <code>(height, width)</code> dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DetrImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Can be overridden by the <code>size</code> parameter
in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.DetrImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.DetrImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DetrImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DetrImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to True) &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.DetrImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DetrImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.DetrImageProcessor.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the DETR model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.DetrImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code> will pad the images in the batch to the largest height and width in the batch.
Padding will be applied to the bottom and right of the image with zeros.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/image_processing_detr.py#L743"}}),He=new M({props:{name:"preprocess",anchor:"transformers.DetrImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"annotations",val:": Union = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": Union = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Union = None"},{name:"do_normalize",val:": Optional = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_pad",val:": Optional = None"},{name:"format",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DetrImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.DetrImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.DetrImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.DetrImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DetrImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.DetrImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.DetrImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.DetrImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.DetrImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DetrImageProcessor.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_convert_annotations) &#x2014;
Whether to convert the annotations to the format expected by the model. Converts the bounding
boxes from the format <code>(top_left_x, top_left_y, width, height)</code> to <code>(center_x, center_y, width, height)</code>
and in relative coordinates.`,name:"do_convert_annotations"},{anchor:"transformers.DetrImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.DetrImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.DetrImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image. If <code>True</code> will pad the images in the batch to the largest image in the batch
and create a pixel mask. Padding will be applied to the bottom and right of the image with zeros.`,name:"do_pad"},{anchor:"transformers.DetrImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotationFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.DetrImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.DetrImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DetrImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/image_processing_detr.py#L1152"}}),Be=new M({props:{name:"post_process_object_detection",anchor:"transformers.DetrImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": Union = None"}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.DetrImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/image_processing_detr.py#L1673",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ge=new M({props:{name:"post_process_semantic_segmentation",anchor:"transformers.DetrImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": List = None"}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
A list of tuples (<code>Tuple[int, int]</code>) containing the target size (height, width) of each image in the
batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/image_processing_detr.py#L1726",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),Ve=new M({props:{name:"post_process_instance_segmentation",anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": Optional = None"},{name:"return_coco_annotation",val:": Optional = False"}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Defaults to <code>False</code>. If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE)
format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/image_processing_detr.py#L1774",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ae=new M({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": Optional = None"},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
The outputs from <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>.`,name:"outputs"},{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/image_processing_detr.py#L1858",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized to
the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Xe=new Z({props:{title:"DetrFeatureExtractor",local:"transformers.DetrFeatureExtractor",headingTag:"h2"}}),Ye=new M({props:{name:"class transformers.DetrFeatureExtractor",anchor:"transformers.DetrFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/feature_extraction_detr.py#L36"}}),Qe=new M({props:{name:"__call__",anchor:"transformers.DetrFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/image_processing_utils.py#L549"}}),Ke=new M({props:{name:"post_process_object_detection",anchor:"transformers.DetrFeatureExtractor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": Union = None"}],parametersDescription:[{anchor:"transformers.DetrFeatureExtractor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrFeatureExtractor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/image_processing_detr.py#L1673",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),et=new M({props:{name:"post_process_semantic_segmentation",anchor:"transformers.DetrFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": List = None"}],parametersDescription:[{anchor:"transformers.DetrFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
A list of tuples (<code>Tuple[int, int]</code>) containing the target size (height, width) of each image in the
batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/image_processing_detr.py#L1726",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),tt=new M({props:{name:"post_process_instance_segmentation",anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": Optional = None"},{name:"return_coco_annotation",val:": Optional = False"}],parametersDescription:[{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Defaults to <code>False</code>. If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE)
format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/image_processing_detr.py#L1774",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ot=new M({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": Optional = None"},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
The outputs from <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>.`,name:"outputs"},{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/image_processing_detr.py#L1858",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized to
the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),nt=new Z({props:{title:"DETR specific outputs",local:"transformers.models.detr.modeling_detr.DetrModelOutput",headingTag:"h2"}}),st=new M({props:{name:"class transformers.models.detr.modeling_detr.DetrModelOutput",anchor:"transformers.models.detr.modeling_detr.DetrModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"intermediate_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"encoder_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.intermediate_hidden_states",description:`<strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, sequence_length, hidden_size)</code>, <em>optional</em>, returned when <code>config.auxiliary_loss=True</code>) &#x2014;
Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.`,name:"intermediate_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/modeling_detr.py#L99"}}),rt=new M({props:{name:"class transformers.models.detr.modeling_detr.DetrObjectDetectionOutput",anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"loss_dict",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"pred_boxes",val:": FloatTensor = None"},{name:"auxiliary_outputs",val:": Optional = None"},{name:"last_hidden_state",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) &#x2014;
Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.`,name:"loss"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.loss_dict",description:`<strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary containing the individual losses. Useful for logging.`,name:"loss_dict"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) &#x2014;
Classification logits (including no-object) for all queries.`,name:"logits"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.pred_boxes",description:`<strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) &#x2014;
Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_object_detection">post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.`,name:"pred_boxes"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.auxiliary_outputs",description:`<strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) &#x2014;
Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.`,name:"auxiliary_outputs"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/modeling_detr.py#L139"}}),at=new M({props:{name:"class transformers.models.detr.modeling_detr.DetrSegmentationOutput",anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"loss_dict",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"pred_boxes",val:": FloatTensor = None"},{name:"pred_masks",val:": FloatTensor = None"},{name:"auxiliary_outputs",val:": Optional = None"},{name:"last_hidden_state",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) &#x2014;
Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.`,name:"loss"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.loss_dict",description:`<strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary containing the individual losses. Useful for logging.`,name:"loss_dict"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) &#x2014;
Classification logits (including no-object) for all queries.`,name:"logits"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.pred_boxes",description:`<strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) &#x2014;
Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_object_detection">post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.`,name:"pred_boxes"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.pred_masks",description:`<strong>pred_masks</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height/4, width/4)</code>) &#x2014;
Segmentation masks logits for all queries. See also
<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_instance_segmentation">post_process_instance_segmentation()</a>
<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> to evaluate semantic, instance and panoptic
segmentation masks respectively.`,name:"pred_masks"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.auxiliary_outputs",description:`<strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) &#x2014;
Optional, only returned when auxiliary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.`,name:"auxiliary_outputs"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/modeling_detr.py#L202"}}),it=new Z({props:{title:"DetrModel",local:"transformers.DetrModel",headingTag:"h2"}}),dt=new M({props:{name:"class transformers.DetrModel",anchor:"transformers.DetrModel",parameters:[{name:"config",val:": DetrConfig"}],parametersDescription:[{anchor:"transformers.DetrModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/modeling_detr.py#L1301"}}),ct=new M({props:{name:"forward",anchor:"transformers.DetrModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DetrModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2FeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DetrModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DetrModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DetrModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DetrModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DetrModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DetrModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DetrModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DetrModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/modeling_detr.py#L1342",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrModelOutput"
>transformers.models.detr.modeling_detr.DetrModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig"
>DetrConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, sequence_length, hidden_size)</code>, <em>optional</em>, returned when <code>config.auxiliary_loss=True</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrModelOutput"
>transformers.models.detr.modeling_detr.DetrModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new Qn({props:{$$slots:{default:[tr]},$$scope:{ctx:F}}}),re=new en({props:{anchor:"transformers.DetrModel.forward.example",$$slots:{default:[or]},$$scope:{ctx:F}}}),lt=new Z({props:{title:"DetrForObjectDetection",local:"transformers.DetrForObjectDetection",headingTag:"h2"}}),mt=new M({props:{name:"class transformers.DetrForObjectDetection",anchor:"transformers.DetrForObjectDetection",parameters:[{name:"config",val:": DetrConfig"}],parametersDescription:[{anchor:"transformers.DetrForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/modeling_detr.py#L1469"}}),pt=new M({props:{name:"forward",anchor:"transformers.DetrForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DetrForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2FeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DetrForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DetrForObjectDetection.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DetrForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DetrForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DetrForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DetrForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DetrForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DetrForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DetrForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/modeling_detr.py#L1502",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrObjectDetectionOutput"
>transformers.models.detr.modeling_detr.DetrObjectDetectionOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig"
>DetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrObjectDetectionOutput"
>transformers.models.detr.modeling_detr.DetrObjectDetectionOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ae=new Qn({props:{$$slots:{default:[nr]},$$scope:{ctx:F}}}),ie=new en({props:{anchor:"transformers.DetrForObjectDetection.forward.example",$$slots:{default:[sr]},$$scope:{ctx:F}}}),ht=new Z({props:{title:"DetrForSegmentation",local:"transformers.DetrForSegmentation",headingTag:"h2"}}),ut=new M({props:{name:"class transformers.DetrForSegmentation",anchor:"transformers.DetrForSegmentation",parameters:[{name:"config",val:": DetrConfig"}],parametersDescription:[{anchor:"transformers.DetrForSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/modeling_detr.py#L1642"}}),gt=new M({props:{name:"forward",anchor:"transformers.DetrForSegmentation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DetrForSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2FeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DetrForSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DetrForSegmentation.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DetrForSegmentation.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DetrForSegmentation.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DetrForSegmentation.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DetrForSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DetrForSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DetrForSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DetrForSegmentation.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss, DICE/F-1 loss and Focal loss. List of dicts, each
dictionary containing at least the following 3 keys: &#x2018;class_labels&#x2019;, &#x2018;boxes&#x2019; and &#x2018;masks&#x2019; (the class labels,
bounding boxes and segmentation masks of an image in the batch respectively). The class labels themselves
should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code>, the boxes a
<code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code> and the masks a
<code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, height, width)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/detr/modeling_detr.py#L1672",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrSegmentationOutput"
>transformers.models.detr.modeling_detr.DetrSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig"
>DetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>pred_masks</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height/4, width/4)</code>) — Segmentation masks logits for all queries. See also
<a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_semantic_segmentation"
>post_process_semantic_segmentation()</a> or
<a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_instance_segmentation"
>post_process_instance_segmentation()</a>
<a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_panoptic_segmentation"
>post_process_panoptic_segmentation()</a> to evaluate semantic, instance and panoptic
segmentation masks respectively.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxiliary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrSegmentationOutput"
>transformers.models.detr.modeling_detr.DetrSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new Qn({props:{$$slots:{default:[rr]},$$scope:{ctx:F}}}),ce=new en({props:{anchor:"transformers.DetrForSegmentation.forward.example",$$slots:{default:[ar]},$$scope:{ctx:F}}}),{c(){c=i("meta"),w=n(),b=i("p"),v=n(),p(y.$$.fragment),l=n(),p(D.$$.fragment),Kt=n(),he=i("p"),he.innerHTML=Kn,eo=n(),ue=i("p"),ue.textContent=es,to=n(),ge=i("p"),ge.innerHTML=ts,oo=n(),fe=i("p"),fe.innerHTML=os,no=n(),p(_e.$$.fragment),so=n(),be=i("p"),be.innerHTML=ns,ro=n(),ve=i("p"),ve.innerHTML=ss,ao=n(),ye=i("p"),ye.innerHTML=rs,io=n(),we=i("p"),we.innerHTML=as,co=n(),Te=i("p"),Te.innerHTML=is,lo=n(),p(xe.$$.fragment),mo=n(),De=i("ul"),De.innerHTML=ds,po=n(),Me=i("p"),Me.textContent=cs,ho=n(),je=i("p"),je.textContent=ls,uo=n(),p($e.$$.fragment),go=n(),ke=i("p"),ke.textContent=ms,fo=n(),p(Fe.$$.fragment),_o=n(),Ce=i("p"),Ce.textContent=ps,bo=n(),p(ze.$$.fragment),vo=n(),Ie=i("p"),Ie.textContent=hs,yo=n(),Je=i("table"),Je.innerHTML=us,wo=n(),Ne=i("p"),Ne.innerHTML=gs,To=n(),p(Oe.$$.fragment),xo=n(),Ue=i("p"),Ue.textContent=fs,Do=n(),p(qe.$$.fragment),Mo=n(),Ee=i("ul"),Ee.innerHTML=_s,jo=n(),Ze=i("p"),Ze.textContent=bs,$o=n(),p(Re.$$.fragment),ko=n(),C=i("div"),p(Pe.$$.fragment),tn=n(),xt=i("p"),xt.innerHTML=vs,on=n(),Dt=i("p"),Dt.innerHTML=ys,nn=n(),p(B.$$.fragment),sn=n(),G=i("div"),p(Le.$$.fragment),rn=n(),Mt=i("p"),Mt.innerHTML=ws,Fo=n(),p(We.$$.fragment),Co=n(),j=i("div"),p(Se.$$.fragment),an=n(),jt=i("p"),jt.textContent=Ts,dn=n(),V=i("div"),p(He.$$.fragment),cn=n(),$t=i("p"),$t.textContent=xs,ln=n(),A=i("div"),p(Be.$$.fragment),mn=n(),kt=i("p"),kt.innerHTML=Ds,pn=n(),X=i("div"),p(Ge.$$.fragment),hn=n(),Ft=i("p"),Ft.innerHTML=Ms,un=n(),Y=i("div"),p(Ve.$$.fragment),gn=n(),Ct=i("p"),Ct.innerHTML=js,fn=n(),Q=i("div"),p(Ae.$$.fragment),_n=n(),zt=i("p"),zt.innerHTML=$s,zo=n(),p(Xe.$$.fragment),Io=n(),$=i("div"),p(Ye.$$.fragment),bn=n(),K=i("div"),p(Qe.$$.fragment),vn=n(),It=i("p"),It.textContent=ks,yn=n(),ee=i("div"),p(Ke.$$.fragment),wn=n(),Jt=i("p"),Jt.innerHTML=Fs,Tn=n(),te=i("div"),p(et.$$.fragment),xn=n(),Nt=i("p"),Nt.innerHTML=Cs,Dn=n(),oe=i("div"),p(tt.$$.fragment),Mn=n(),Ot=i("p"),Ot.innerHTML=zs,jn=n(),ne=i("div"),p(ot.$$.fragment),$n=n(),Ut=i("p"),Ut.innerHTML=Is,Jo=n(),p(nt.$$.fragment),No=n(),W=i("div"),p(st.$$.fragment),kn=n(),qt=i("p"),qt.textContent=Js,Oo=n(),S=i("div"),p(rt.$$.fragment),Fn=n(),Et=i("p"),Et.innerHTML=Ns,Uo=n(),H=i("div"),p(at.$$.fragment),Cn=n(),Zt=i("p"),Zt.innerHTML=Os,qo=n(),p(it.$$.fragment),Eo=n(),z=i("div"),p(dt.$$.fragment),zn=n(),Rt=i("p"),Rt.textContent=Us,In=n(),Pt=i("p"),Pt.innerHTML=qs,Jn=n(),Lt=i("p"),Lt.innerHTML=Es,Nn=n(),O=i("div"),p(ct.$$.fragment),On=n(),Wt=i("p"),Wt.innerHTML=Zs,Un=n(),p(se.$$.fragment),qn=n(),p(re.$$.fragment),Zo=n(),p(lt.$$.fragment),Ro=n(),I=i("div"),p(mt.$$.fragment),En=n(),St=i("p"),St.textContent=Rs,Zn=n(),Ht=i("p"),Ht.innerHTML=Ps,Rn=n(),Bt=i("p"),Bt.innerHTML=Ls,Pn=n(),U=i("div"),p(pt.$$.fragment),Ln=n(),Gt=i("p"),Gt.innerHTML=Ws,Wn=n(),p(ae.$$.fragment),Sn=n(),p(ie.$$.fragment),Po=n(),p(ht.$$.fragment),Lo=n(),J=i("div"),p(ut.$$.fragment),Hn=n(),Vt=i("p"),Vt.textContent=Ss,Bn=n(),At=i("p"),At.innerHTML=Hs,Gn=n(),Xt=i("p"),Xt.innerHTML=Bs,Vn=n(),q=i("div"),p(gt.$$.fragment),An=n(),Yt=i("p"),Yt.innerHTML=Gs,Xn=n(),p(de.$$.fragment),Yn=n(),p(ce.$$.fragment),Wo=n(),Qt=i("p"),this.h()},l(e){const o=Qs("svelte-u9bgzb",document.head);c=d(o,"META",{name:!0,content:!0}),o.forEach(t),w=s(e),b=d(e,"P",{}),T(b).forEach(t),v=s(e),h(y.$$.fragment,e),l=s(e),h(D.$$.fragment,e),Kt=s(e),he=d(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1619prt"&&(he.innerHTML=Kn),eo=s(e),ue=d(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-vfdo9a"&&(ue.textContent=es),to=s(e),ge=d(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-s87elr"&&(ge.innerHTML=ts),oo=s(e),fe=d(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1gw5wuz"&&(fe.innerHTML=os),no=s(e),h(_e.$$.fragment,e),so=s(e),be=d(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1m16xo7"&&(be.innerHTML=ns),ro=s(e),ve=d(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-x01cd0"&&(ve.innerHTML=ss),ao=s(e),ye=d(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-i2avyi"&&(ye.innerHTML=rs),io=s(e),we=d(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-351ubi"&&(we.innerHTML=as),co=s(e),Te=d(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-hg8zfo"&&(Te.innerHTML=is),lo=s(e),h(xe.$$.fragment,e),mo=s(e),De=d(e,"UL",{"data-svelte-h":!0}),m(De)!=="svelte-3ipkb"&&(De.innerHTML=ds),po=s(e),Me=d(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-5tif3l"&&(Me.textContent=cs),ho=s(e),je=d(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-ixg096"&&(je.textContent=ls),uo=s(e),h($e.$$.fragment,e),go=s(e),ke=d(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-14rhv4g"&&(ke.textContent=ms),fo=s(e),h(Fe.$$.fragment,e),_o=s(e),Ce=d(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1hfzzjq"&&(Ce.textContent=ps),bo=s(e),h(ze.$$.fragment,e),vo=s(e),Ie=d(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1e3p89m"&&(Ie.textContent=hs),yo=s(e),Je=d(e,"TABLE",{"data-svelte-h":!0}),m(Je)!=="svelte-q9x3g0"&&(Je.innerHTML=us),wo=s(e),Ne=d(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-njpdz4"&&(Ne.innerHTML=gs),To=s(e),h(Oe.$$.fragment,e),xo=s(e),Ue=d(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-5jc6k6"&&(Ue.textContent=fs),Do=s(e),h(qe.$$.fragment,e),Mo=s(e),Ee=d(e,"UL",{"data-svelte-h":!0}),m(Ee)!=="svelte-1yl577"&&(Ee.innerHTML=_s),jo=s(e),Ze=d(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-1xesile"&&(Ze.textContent=bs),$o=s(e),h(Re.$$.fragment,e),ko=s(e),C=d(e,"DIV",{class:!0});var N=T(C);h(Pe.$$.fragment,N),tn=s(N),xt=d(N,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-n35vh7"&&(xt.innerHTML=vs),on=s(N),Dt=d(N,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-1m96fjf"&&(Dt.innerHTML=ys),nn=s(N),h(B.$$.fragment,N),sn=s(N),G=d(N,"DIV",{class:!0});var ft=T(G);h(Le.$$.fragment,ft),rn=s(ft),Mt=d(ft,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1kn2aea"&&(Mt.innerHTML=ws),ft.forEach(t),N.forEach(t),Fo=s(e),h(We.$$.fragment,e),Co=s(e),j=d(e,"DIV",{class:!0});var k=T(j);h(Se.$$.fragment,k),an=s(k),jt=d(k,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-19j0nu1"&&(jt.textContent=Ts),dn=s(k),V=d(k,"DIV",{class:!0});var _t=T(V);h(He.$$.fragment,_t),cn=s(_t),$t=d(_t,"P",{"data-svelte-h":!0}),m($t)!=="svelte-jgz2ra"&&($t.textContent=xs),_t.forEach(t),ln=s(k),A=d(k,"DIV",{class:!0});var bt=T(A);h(Be.$$.fragment,bt),mn=s(bt),kt=d(bt,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-1jce2cd"&&(kt.innerHTML=Ds),bt.forEach(t),pn=s(k),X=d(k,"DIV",{class:!0});var vt=T(X);h(Ge.$$.fragment,vt),hn=s(vt),Ft=d(vt,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-1ksegqk"&&(Ft.innerHTML=Ms),vt.forEach(t),un=s(k),Y=d(k,"DIV",{class:!0});var yt=T(Y);h(Ve.$$.fragment,yt),gn=s(yt),Ct=d(yt,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-1m3nrn0"&&(Ct.innerHTML=js),yt.forEach(t),fn=s(k),Q=d(k,"DIV",{class:!0});var Ho=T(Q);h(Ae.$$.fragment,Ho),_n=s(Ho),zt=d(Ho,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-17o3n9y"&&(zt.innerHTML=$s),Ho.forEach(t),k.forEach(t),zo=s(e),h(Xe.$$.fragment,e),Io=s(e),$=d(e,"DIV",{class:!0});var E=T($);h(Ye.$$.fragment,E),bn=s(E),K=d(E,"DIV",{class:!0});var Bo=T(K);h(Qe.$$.fragment,Bo),vn=s(Bo),It=d(Bo,"P",{"data-svelte-h":!0}),m(It)!=="svelte-khengj"&&(It.textContent=ks),Bo.forEach(t),yn=s(E),ee=d(E,"DIV",{class:!0});var Go=T(ee);h(Ke.$$.fragment,Go),wn=s(Go),Jt=d(Go,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1jce2cd"&&(Jt.innerHTML=Fs),Go.forEach(t),Tn=s(E),te=d(E,"DIV",{class:!0});var Vo=T(te);h(et.$$.fragment,Vo),xn=s(Vo),Nt=d(Vo,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-1ksegqk"&&(Nt.innerHTML=Cs),Vo.forEach(t),Dn=s(E),oe=d(E,"DIV",{class:!0});var Ao=T(oe);h(tt.$$.fragment,Ao),Mn=s(Ao),Ot=d(Ao,"P",{"data-svelte-h":!0}),m(Ot)!=="svelte-1m3nrn0"&&(Ot.innerHTML=zs),Ao.forEach(t),jn=s(E),ne=d(E,"DIV",{class:!0});var Xo=T(ne);h(ot.$$.fragment,Xo),$n=s(Xo),Ut=d(Xo,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-17o3n9y"&&(Ut.innerHTML=Is),Xo.forEach(t),E.forEach(t),Jo=s(e),h(nt.$$.fragment,e),No=s(e),W=d(e,"DIV",{class:!0});var Yo=T(W);h(st.$$.fragment,Yo),kn=s(Yo),qt=d(Yo,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-1ya2yj5"&&(qt.textContent=Js),Yo.forEach(t),Oo=s(e),S=d(e,"DIV",{class:!0});var Qo=T(S);h(rt.$$.fragment,Qo),Fn=s(Qo),Et=d(Qo,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-6ceprt"&&(Et.innerHTML=Ns),Qo.forEach(t),Uo=s(e),H=d(e,"DIV",{class:!0});var Ko=T(H);h(at.$$.fragment,Ko),Cn=s(Ko),Zt=d(Ko,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-16f2hux"&&(Zt.innerHTML=Os),Ko.forEach(t),qo=s(e),h(it.$$.fragment,e),Eo=s(e),z=d(e,"DIV",{class:!0});var R=T(z);h(dt.$$.fragment,R),zn=s(R),Rt=d(R,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-esnh0n"&&(Rt.textContent=Us),In=s(R),Pt=d(R,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-93kjft"&&(Pt.innerHTML=qs),Jn=s(R),Lt=d(R,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-hswkmf"&&(Lt.innerHTML=Es),Nn=s(R),O=d(R,"DIV",{class:!0});var le=T(O);h(ct.$$.fragment,le),On=s(le),Wt=d(le,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-1sd6k77"&&(Wt.innerHTML=Zs),Un=s(le),h(se.$$.fragment,le),qn=s(le),h(re.$$.fragment,le),le.forEach(t),R.forEach(t),Zo=s(e),h(lt.$$.fragment,e),Ro=s(e),I=d(e,"DIV",{class:!0});var P=T(I);h(mt.$$.fragment,P),En=s(P),St=d(P,"P",{"data-svelte-h":!0}),m(St)!=="svelte-dw6bi4"&&(St.textContent=Rs),Zn=s(P),Ht=d(P,"P",{"data-svelte-h":!0}),m(Ht)!=="svelte-93kjft"&&(Ht.innerHTML=Ps),Rn=s(P),Bt=d(P,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-hswkmf"&&(Bt.innerHTML=Ls),Pn=s(P),U=d(P,"DIV",{class:!0});var me=T(U);h(pt.$$.fragment,me),Ln=s(me),Gt=d(me,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-nqd1a3"&&(Gt.innerHTML=Ws),Wn=s(me),h(ae.$$.fragment,me),Sn=s(me),h(ie.$$.fragment,me),me.forEach(t),P.forEach(t),Po=s(e),h(ht.$$.fragment,e),Lo=s(e),J=d(e,"DIV",{class:!0});var L=T(J);h(ut.$$.fragment,L),Hn=s(L),Vt=d(L,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-1yivh9f"&&(Vt.textContent=Ss),Bn=s(L),At=d(L,"P",{"data-svelte-h":!0}),m(At)!=="svelte-93kjft"&&(At.innerHTML=Hs),Gn=s(L),Xt=d(L,"P",{"data-svelte-h":!0}),m(Xt)!=="svelte-hswkmf"&&(Xt.innerHTML=Bs),Vn=s(L),q=d(L,"DIV",{class:!0});var pe=T(q);h(gt.$$.fragment,pe),An=s(pe),Yt=d(pe,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-77xqnn"&&(Yt.innerHTML=Gs),Xn=s(pe),h(de.$$.fragment,pe),Yn=s(pe),h(ce.$$.fragment,pe),pe.forEach(t),L.forEach(t),Wo=s(e),Qt=d(e,"P",{}),T(Qt).forEach(t),this.h()},h(){x(c,"name","hf:doc:metadata"),x(c,"content",dr),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){r(document.head,c),a(e,w,o),a(e,b,o),a(e,v,o),u(y,e,o),a(e,l,o),u(D,e,o),a(e,Kt,o),a(e,he,o),a(e,eo,o),a(e,ue,o),a(e,to,o),a(e,ge,o),a(e,oo,o),a(e,fe,o),a(e,no,o),u(_e,e,o),a(e,so,o),a(e,be,o),a(e,ro,o),a(e,ve,o),a(e,ao,o),a(e,ye,o),a(e,io,o),a(e,we,o),a(e,co,o),a(e,Te,o),a(e,lo,o),u(xe,e,o),a(e,mo,o),a(e,De,o),a(e,po,o),a(e,Me,o),a(e,ho,o),a(e,je,o),a(e,uo,o),u($e,e,o),a(e,go,o),a(e,ke,o),a(e,fo,o),u(Fe,e,o),a(e,_o,o),a(e,Ce,o),a(e,bo,o),u(ze,e,o),a(e,vo,o),a(e,Ie,o),a(e,yo,o),a(e,Je,o),a(e,wo,o),a(e,Ne,o),a(e,To,o),u(Oe,e,o),a(e,xo,o),a(e,Ue,o),a(e,Do,o),u(qe,e,o),a(e,Mo,o),a(e,Ee,o),a(e,jo,o),a(e,Ze,o),a(e,$o,o),u(Re,e,o),a(e,ko,o),a(e,C,o),u(Pe,C,null),r(C,tn),r(C,xt),r(C,on),r(C,Dt),r(C,nn),u(B,C,null),r(C,sn),r(C,G),u(Le,G,null),r(G,rn),r(G,Mt),a(e,Fo,o),u(We,e,o),a(e,Co,o),a(e,j,o),u(Se,j,null),r(j,an),r(j,jt),r(j,dn),r(j,V),u(He,V,null),r(V,cn),r(V,$t),r(j,ln),r(j,A),u(Be,A,null),r(A,mn),r(A,kt),r(j,pn),r(j,X),u(Ge,X,null),r(X,hn),r(X,Ft),r(j,un),r(j,Y),u(Ve,Y,null),r(Y,gn),r(Y,Ct),r(j,fn),r(j,Q),u(Ae,Q,null),r(Q,_n),r(Q,zt),a(e,zo,o),u(Xe,e,o),a(e,Io,o),a(e,$,o),u(Ye,$,null),r($,bn),r($,K),u(Qe,K,null),r(K,vn),r(K,It),r($,yn),r($,ee),u(Ke,ee,null),r(ee,wn),r(ee,Jt),r($,Tn),r($,te),u(et,te,null),r(te,xn),r(te,Nt),r($,Dn),r($,oe),u(tt,oe,null),r(oe,Mn),r(oe,Ot),r($,jn),r($,ne),u(ot,ne,null),r(ne,$n),r(ne,Ut),a(e,Jo,o),u(nt,e,o),a(e,No,o),a(e,W,o),u(st,W,null),r(W,kn),r(W,qt),a(e,Oo,o),a(e,S,o),u(rt,S,null),r(S,Fn),r(S,Et),a(e,Uo,o),a(e,H,o),u(at,H,null),r(H,Cn),r(H,Zt),a(e,qo,o),u(it,e,o),a(e,Eo,o),a(e,z,o),u(dt,z,null),r(z,zn),r(z,Rt),r(z,In),r(z,Pt),r(z,Jn),r(z,Lt),r(z,Nn),r(z,O),u(ct,O,null),r(O,On),r(O,Wt),r(O,Un),u(se,O,null),r(O,qn),u(re,O,null),a(e,Zo,o),u(lt,e,o),a(e,Ro,o),a(e,I,o),u(mt,I,null),r(I,En),r(I,St),r(I,Zn),r(I,Ht),r(I,Rn),r(I,Bt),r(I,Pn),r(I,U),u(pt,U,null),r(U,Ln),r(U,Gt),r(U,Wn),u(ae,U,null),r(U,Sn),u(ie,U,null),a(e,Po,o),u(ht,e,o),a(e,Lo,o),a(e,J,o),u(ut,J,null),r(J,Hn),r(J,Vt),r(J,Bn),r(J,At),r(J,Gn),r(J,Xt),r(J,Vn),r(J,q),u(gt,q,null),r(q,An),r(q,Yt),r(q,Xn),u(de,q,null),r(q,Yn),u(ce,q,null),a(e,Wo,o),a(e,Qt,o),So=!0},p(e,[o]){const N={};o&2&&(N.$$scope={dirty:o,ctx:e}),B.$set(N);const ft={};o&2&&(ft.$$scope={dirty:o,ctx:e}),se.$set(ft);const k={};o&2&&(k.$$scope={dirty:o,ctx:e}),re.$set(k);const _t={};o&2&&(_t.$$scope={dirty:o,ctx:e}),ae.$set(_t);const bt={};o&2&&(bt.$$scope={dirty:o,ctx:e}),ie.$set(bt);const vt={};o&2&&(vt.$$scope={dirty:o,ctx:e}),de.$set(vt);const yt={};o&2&&(yt.$$scope={dirty:o,ctx:e}),ce.$set(yt)},i(e){So||(g(y.$$.fragment,e),g(D.$$.fragment,e),g(_e.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(Fe.$$.fragment,e),g(ze.$$.fragment,e),g(Oe.$$.fragment,e),g(qe.$$.fragment,e),g(Re.$$.fragment,e),g(Pe.$$.fragment,e),g(B.$$.fragment,e),g(Le.$$.fragment,e),g(We.$$.fragment,e),g(Se.$$.fragment,e),g(He.$$.fragment,e),g(Be.$$.fragment,e),g(Ge.$$.fragment,e),g(Ve.$$.fragment,e),g(Ae.$$.fragment,e),g(Xe.$$.fragment,e),g(Ye.$$.fragment,e),g(Qe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(ot.$$.fragment,e),g(nt.$$.fragment,e),g(st.$$.fragment,e),g(rt.$$.fragment,e),g(at.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(ct.$$.fragment,e),g(se.$$.fragment,e),g(re.$$.fragment,e),g(lt.$$.fragment,e),g(mt.$$.fragment,e),g(pt.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(ht.$$.fragment,e),g(ut.$$.fragment,e),g(gt.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),So=!0)},o(e){f(y.$$.fragment,e),f(D.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(Fe.$$.fragment,e),f(ze.$$.fragment,e),f(Oe.$$.fragment,e),f(qe.$$.fragment,e),f(Re.$$.fragment,e),f(Pe.$$.fragment,e),f(B.$$.fragment,e),f(Le.$$.fragment,e),f(We.$$.fragment,e),f(Se.$$.fragment,e),f(He.$$.fragment,e),f(Be.$$.fragment,e),f(Ge.$$.fragment,e),f(Ve.$$.fragment,e),f(Ae.$$.fragment,e),f(Xe.$$.fragment,e),f(Ye.$$.fragment,e),f(Qe.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(st.$$.fragment,e),f(rt.$$.fragment,e),f(at.$$.fragment,e),f(it.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(lt.$$.fragment,e),f(mt.$$.fragment,e),f(pt.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(ht.$$.fragment,e),f(ut.$$.fragment,e),f(gt.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),So=!1},d(e){e&&(t(w),t(b),t(v),t(l),t(Kt),t(he),t(eo),t(ue),t(to),t(ge),t(oo),t(fe),t(no),t(so),t(be),t(ro),t(ve),t(ao),t(ye),t(io),t(we),t(co),t(Te),t(lo),t(mo),t(De),t(po),t(Me),t(ho),t(je),t(uo),t(go),t(ke),t(fo),t(_o),t(Ce),t(bo),t(vo),t(Ie),t(yo),t(Je),t(wo),t(Ne),t(To),t(xo),t(Ue),t(Do),t(Mo),t(Ee),t(jo),t(Ze),t($o),t(ko),t(C),t(Fo),t(Co),t(j),t(zo),t(Io),t($),t(Jo),t(No),t(W),t(Oo),t(S),t(Uo),t(H),t(qo),t(Eo),t(z),t(Zo),t(Ro),t(I),t(Po),t(Lo),t(J),t(Wo),t(Qt)),t(c),_(y,e),_(D,e),_(_e,e),_(xe,e),_($e,e),_(Fe,e),_(ze,e),_(Oe,e),_(qe,e),_(Re,e),_(Pe),_(B),_(Le),_(We,e),_(Se),_(He),_(Be),_(Ge),_(Ve),_(Ae),_(Xe,e),_(Ye),_(Qe),_(Ke),_(et),_(tt),_(ot),_(nt,e),_(st),_(rt),_(at),_(it,e),_(dt),_(ct),_(se),_(re),_(lt,e),_(mt),_(pt),_(ae),_(ie),_(ht,e),_(ut),_(gt),_(de),_(ce)}}}const dr='{"title":"DETR","local":"detr","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"How DETR works","local":"how-detr-works","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DetrConfig","local":"transformers.DetrConfig","sections":[],"depth":2},{"title":"DetrImageProcessor","local":"transformers.DetrImageProcessor","sections":[],"depth":2},{"title":"DetrFeatureExtractor","local":"transformers.DetrFeatureExtractor","sections":[],"depth":2},{"title":"DETR specific outputs","local":"transformers.models.detr.modeling_detr.DetrModelOutput","sections":[],"depth":2},{"title":"DetrModel","local":"transformers.DetrModel","sections":[],"depth":2},{"title":"DetrForObjectDetection","local":"transformers.DetrForObjectDetection","sections":[],"depth":2},{"title":"DetrForSegmentation","local":"transformers.DetrForSegmentation","sections":[],"depth":2}],"depth":1}';function cr(F){return As(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class br extends Xs{constructor(c){super(),Ys(this,c,cr,ir,Vs,{})}}export{br as component};
