import{S as Cr,i as _r,s as Zr,e as n,k as c,w as y,t as r,M as $r,c as o,d as l,m as M,a as p,x as w,h as i,b as T,G as a,g as t,y as u,q as J,o as f,B as d,v as kr}from"../../chunks/vendor-hf-doc-builder.js";import{T as Oe}from"../../chunks/Tip-hf-doc-builder.js";import{I as el}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{C as j}from"../../chunks/CodeBlock-hf-doc-builder.js";function Gr(Z){let m,b,h,U;return{c(){m=n("p"),b=r("This tutorial is also available as a Jupyter Notebook "),h=n("a"),U=r("here"),this.h()},l(_){m=o(_,"P",{});var I=p(m);b=i(I,"This tutorial is also available as a Jupyter Notebook "),h=o(I,"A",{href:!0,rel:!0});var C=p(h);U=i(C,"here"),C.forEach(l),I.forEach(l),this.h()},h(){T(h,"href","https://github.com/huggingface/notebooks/blob/main/examples/accelerate_examples/simple_cv_example.ipynb"),T(h,"rel","nofollow")},m(_,I){t(_,m,I),a(m,b),a(m,h),a(h,U)},d(_){_&&l(m)}}}function vr(Z){let m,b;return{c(){m=n("p"),b=r("CUDA can\u2019t be initialized more than once on a multi-GPU system. It\u2019s fine to debug in the notebook and have calls to CUDA, but in order to finally train a full cleanup and restart will need to be performed.")},l(h){m=o(h,"P",{});var U=p(m);b=i(U,"CUDA can\u2019t be initialized more than once on a multi-GPU system. It\u2019s fine to debug in the notebook and have calls to CUDA, but in order to finally train a full cleanup and restart will need to be performed."),U.forEach(l)},m(h,U){t(h,m,U),a(m,b)},d(h){h&&l(m)}}}function Wr(Z){let m,b;return{c(){m=n("p"),b=r("The code has been split up to allow for explainations on each section. A full version that can be copy and pasted will be available at the end")},l(h){m=o(h,"P",{});var U=p(m);b=i(U,"The code has been split up to allow for explainations on each section. A full version that can be copy and pasted will be available at the end"),U.forEach(l)},m(h,U){t(h,m,U),a(m,b)},d(h){h&&l(m)}}}function Ar(Z){let m,b,h,U,_;return{c(){m=n("p"),b=r(`If training on the TPU, your training loop should take in the model as a parameter and it should be instantiated
outside of the training loop function. See the `),h=n("a"),U=r("TPU best practices"),_=r(`
to learn why`),this.h()},l(I){m=o(I,"P",{});var C=p(m);b=i(C,`If training on the TPU, your training loop should take in the model as a parameter and it should be instantiated
outside of the training loop function. See the `),h=o(C,"A",{href:!0});var G=p(h);U=i(G,"TPU best practices"),G.forEach(l),_=i(C,`
to learn why`),C.forEach(l),this.h()},h(){T(h,"href","../concept_guides/training_tpu")},m(I,C){t(I,m,C),a(m,b),a(m,h),a(h,U),a(m,_)},d(I){I&&l(m)}}}function Br(Z){let m,b;return{c(){m=n("p"),b=r("You build the model here so that the seed also controls the new weight initialization")},l(h){m=o(h,"P",{});var U=p(m);b=i(U,"You build the model here so that the seed also controls the new weight initialization"),U.forEach(l)},m(h,U){t(h,m,U),a(m,b)},d(h){h&&l(m)}}}function gr(Z){let m,b;return{c(){m=n("p"),b=r("There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the prepare method.")},l(h){m=o(h,"P",{});var U=p(m);b=i(U,"There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the prepare method."),U.forEach(l)},m(h,U){t(h,m,U),a(m,b)},d(h){h&&l(m)}}}function Er(Z){let m,b,h,U,_;return{c(){m=n("p"),b=r("Notice how the "),h=n("code"),U=r("node_rank"),_=r(" has changed")},l(I){m=o(I,"P",{});var C=p(m);b=i(C,"Notice how the "),h=o(C,"CODE",{});var G=p(h);U=i(G,"node_rank"),G.forEach(l),_=i(C," has changed"),C.forEach(l)},m(I,C){t(I,m,C),a(m,b),a(m,h),a(h,U),a(m,_)},d(I){I&&l(m)}}}function Nr(Z){let m,b,h,U,_,I,C,G,ht,fs,ll,yt,ds,V,Ts,g,F,Vl,ce,wt,Fl,ut,Us,sl,Jt,bs,Me,js,v,ft,Ql,dt,Tt,al,Ut,bt,Is,tl,jt,Cs,Q,_s,me,Zs,E,z,zl,he,It,Sl,Ct,$s,k,_t,xl,Zt,$t,Hl,kt,Gt,Pl,vt,Wt,ks,nl,At,Gs,ye,Bt,we,gt,vs,ue,Ws,ol,Et,As,Je,Bs,fe,gs,S,Nt,Dl,Yt,Xt,Es,de,Ns,Te,Ys,rl,Rt,Xs,Ue,Rs,x,Vt,Kl,Ft,Qt,Vs,be,Fs,il,zt,Qs,je,zs,pl,St,Ss,Ie,xs,W,xt,ql,Ht,Pt,Ll,Dt,Kt,Hs,Ce,Ps,cl,qt,Ds,_e,Ks,N,H,Ol,Ze,Lt,es,Ot,qs,P,en,Ml,ln,sn,Ls,ml,an,Os,D,ea,$e,la,K,tn,hl,nn,on,sa,q,aa,yl,rn,ta,ke,na,L,oa,wl,pn,ra,Ge,ia,ul,cn,pa,ve,ca,Jl,Mn,Ma,We,ma,fl,mn,ha,Ae,ya,O,hn,dl,yn,wn,wa,ee,ua,Be,Ja,Tl,un,fa,ge,da,Ul,Jn,Ta,Ee,Ua,bl,fn,ba,Ne,ja,jl,dn,Ia,le,Tn,Il,Un,bn,Ca,Ye,_a,se,jn,Cl,In,Cn,Za,Xe,$a,_l,_n,ka,Re,Ga,Y,ae,ls,Ve,Zn,ss,$n,va,te,kn,Zl,Gn,vn,Wa,ne,Wn,$l,An,Bn,Aa,Fe,Ba,Qe,ga,kl,gn,Ea,Gl,En,Na,ze,Ya,vl,Nn,Xa,oe,Ra,Se,Va,Wl,Yn,Fa,xe,Qa,Al,Xn,za,He,Sa,Bl,Rn,xa,X,re,as,Pe,Vn,ts,Fn,Ha,$,Qn,ns,zn,Sn,os,xn,Hn,rs,Pn,Dn,is,Kn,qn,Pa,R,ie,ps,De,Ln,cs,On,Da,gl,eo,Ka,A,El,lo,Nl,so,ao,Ke,to,Ms,no,oo,ro,ms,io,qa;return I=new el({}),V=new Oe({props:{$$slots:{default:[Gr]},$$scope:{ctx:Z}}}),ce=new el({}),Me=new j({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config"}}),Q=new Oe({props:{warning:!0,$$slots:{default:[vr]},$$scope:{ctx:Z}}}),me=new j({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMHdyaXRlX2Jhc2ljX2NvbmZpZyUwQSUwQXdyaXRlX2Jhc2ljX2NvbmZpZygpJTIwJTIwJTIzJTIwV3JpdGUlMjBhJTIwY29uZmlnJTIwZmlsZSUwQW9zLl9leGl0KDAwKSUyMCUyMCUyMyUyMFJlc3RhcnQlMjB0aGUlMjBub3RlYm9vaw==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()  <span class="hljs-comment"># Write a config file</span>
os._exit(<span class="hljs-number">00</span>)  <span class="hljs-comment"># Restart the notebook</span>`}}),he=new el({}),ue=new j({props:{code:"aW1wb3J0JTIwb3MlMkMlMjByZSUyQyUyMHRvcmNoJTJDJTIwUElMJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZnJvbSUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlciUyMGltcG9ydCUyME9uZUN5Y2xlTFIlMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMkMlMjBEYXRhc2V0JTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDb21wb3NlJTJDJTIwUmFuZG9tUmVzaXplZENyb3AlMkMlMjBSZXNpemUlMkMlMjBUb1RlbnNvciUwQSUwQWZyb20lMjBhY2NlbGVyYXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3IlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMHNldF9zZWVkJTBBZnJvbSUyMHRpbW0lMjBpbXBvcnQlMjBjcmVhdGVfbW9kZWw=",highlighted:`<span class="hljs-keyword">import</span> os, re, torch, PIL
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> torch.optim.lr_scheduler <span class="hljs-keyword">import</span> OneCycleLR
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader, Dataset
<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> Compose, RandomResizedCrop, Resize, ToTensor

<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed
<span class="hljs-keyword">from</span> timm <span class="hljs-keyword">import</span> create_model`}}),Je=new j({props:{code:"aW1wb3J0JTIwb3MlMEElMEFkYXRhX2RpciUyMCUzRCUyMCUyMi4uJTJGLi4lMkZpbWFnZXMlMjIlMEFmbmFtZXMlMjAlM0QlMjBvcy5saXN0ZGlyKGRhdGFfZGlyKSUwQWZuYW1lJTIwJTNEJTIwZm5hbWVzJTVCMCU1RCUwQXByaW50KGZuYW1lKQ==",highlighted:`<span class="hljs-keyword">import</span> os

data_dir = <span class="hljs-string">&quot;../../images&quot;</span>
fnames = os.listdir(data_dir)
fname = fnames[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(fname)`}}),fe=new j({props:{code:"YmVhZ2xlXzMyLmpwZw==",highlighted:"beagle_32.jpg"}}),de=new j({props:{code:"aW1wb3J0JTIwcmUlMEElMEElMEFkZWYlMjBleHRyYWN0X2xhYmVsKGZuYW1lKSUzQSUwQSUyMCUyMCUyMCUyMHN0ZW0lMjAlM0QlMjBmbmFtZS5zcGxpdChvcy5wYXRoLnNlcCklNUItMSU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlLnNlYXJjaChyJTIyJTVFKC4qKV8lNUNkJTJCJTVDLmpwZyUyNCUyMiUyQyUyMHN0ZW0pLmdyb3VwcygpJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> re


<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_label</span>(<span class="hljs-params">fname</span>):
    stem = fname.split(os.path.sep)[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">return</span> re.search(<span class="hljs-string">r&quot;^(.*)_\\d+\\.jpg$&quot;</span>, stem).groups()[<span class="hljs-number">0</span>]`}}),Te=new j({props:{code:"ZXh0cmFjdF9sYWJlbChmbmFtZSk=",highlighted:"extract_label(fname)"}}),Ue=new j({props:{code:"JTIyYmVhZ2xlJTIy",highlighted:'<span class="hljs-string">&quot;beagle&quot;</span>'}}),be=new j({props:{code:"Y2xhc3MlMjBQZXRzRGF0YXNldChEYXRhc2V0KSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBmaWxlX25hbWVzJTJDJTIwaW1hZ2VfdHJhbnNmb3JtJTNETm9uZSUyQyUyMGxhYmVsX3RvX2lkJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZpbGVfbmFtZXMlMjAlM0QlMjBmaWxlX25hbWVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pbWFnZV90cmFuc2Zvcm0lMjAlM0QlMjBpbWFnZV90cmFuc2Zvcm0lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxhYmVsX3RvX2lkJTIwJTNEJTIwbGFiZWxfdG9faWQlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2xlbl9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbGVuKHNlbGYuZmlsZV9uYW1lcyklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2dldGl0ZW1fXyhzZWxmJTJDJTIwaWR4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZuYW1lJTIwJTNEJTIwc2VsZi5maWxlX25hbWVzJTVCaWR4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmF3X2ltYWdlJTIwJTNEJTIwUElMLkltYWdlLm9wZW4oZm5hbWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjByYXdfaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmltYWdlX3RyYW5zZm9ybSUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2VsZi5pbWFnZV90cmFuc2Zvcm0oaW1hZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWwlMjAlM0QlMjBleHRyYWN0X2xhYmVsKGZuYW1lKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc2VsZi5sYWJlbF90b19pZCUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsJTIwJTNEJTIwc2VsZi5sYWJlbF90b19pZCU1QmxhYmVsJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwbGFiZWwlN0Q=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PetsDataset</span>(<span class="hljs-title class_ inherited__">Dataset</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, file_names, image_transform=<span class="hljs-literal">None</span>, label_to_id=<span class="hljs-literal">None</span></span>):
        self.file_names = file_names
        self.image_transform = image_transform
        self.label_to_id = label_to_id

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.file_names)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
        fname = self.file_names[idx]
        raw_image = PIL.Image.<span class="hljs-built_in">open</span>(fname)
        image = raw_image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)
        <span class="hljs-keyword">if</span> self.image_transform <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            image = self.image_transform(image)
        label = extract_label(fname)
        <span class="hljs-keyword">if</span> self.label_to_id <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            label = self.label_to_id[label]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;image&quot;</span>: image, <span class="hljs-string">&quot;label&quot;</span>: label}`}}),je=new j({props:{code:"Zm5hbWVzJTIwJTNEJTIwJTVCb3MucGF0aC5qb2luKCUyMi4uJTJGLi4lMkZpbWFnZXMlMjIlMkMlMjBmbmFtZSklMjBmb3IlMjBmbmFtZSUyMGluJTIwZm5hbWVzJTIwaWYlMjBmbmFtZS5lbmRzd2l0aCglMjIuanBnJTIyKSU1RA==",highlighted:'fnames = [os.path.join(<span class="hljs-string">&quot;../../images&quot;</span>, fname) <span class="hljs-keyword">for</span> fname <span class="hljs-keyword">in</span> fnames <span class="hljs-keyword">if</span> fname.endswith(<span class="hljs-string">&quot;.jpg&quot;</span>)]'}}),Ie=new j({props:{code:"YWxsX2xhYmVscyUyMCUzRCUyMCU1QmV4dHJhY3RfbGFiZWwoZm5hbWUpJTIwZm9yJTIwZm5hbWUlMjBpbiUyMGZuYW1lcyU1RCUwQWlkX3RvX2xhYmVsJTIwJTNEJTIwbGlzdChzZXQoYWxsX2xhYmVscykpJTBBaWRfdG9fbGFiZWwuc29ydCgpJTBBbGFiZWxfdG9faWQlMjAlM0QlMjAlN0JsYmwlM0ElMjBpJTIwZm9yJTIwaSUyQyUyMGxibCUyMGluJTIwZW51bWVyYXRlKGlkX3RvX2xhYmVsKSU3RA==",highlighted:`all_labels = [extract_label(fname) <span class="hljs-keyword">for</span> fname <span class="hljs-keyword">in</span> fnames]
id_to_label = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_labels))
id_to_label.sort()
label_to_id = {lbl: i <span class="hljs-keyword">for</span> i, lbl <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(id_to_label)}`}}),Ce=new j({props:{code:"ZGVmJTIwZ2V0X2RhdGFsb2FkZXJzKGJhdGNoX3NpemUlM0ElMjBpbnQlMjAlM0QlMjA2NCklM0ElMEElMjAlMjAlMjAlMjAlMjJCdWlsZHMlMjBhJTIwc2V0JTIwb2YlMjBkYXRhbG9hZGVycyUyMHdpdGglMjBhJTIwYmF0Y2hfc2l6ZSUyMiUwQSUyMCUyMCUyMCUyMHJhbmRvbV9wZXJtJTIwJTNEJTIwbnAucmFuZG9tLnBlcm11dGF0aW9uKGxlbihmbmFtZXMpKSUwQSUyMCUyMCUyMCUyMGN1dCUyMCUzRCUyMGludCgwLjglMjAqJTIwbGVuKGZuYW1lcykpJTBBJTIwJTIwJTIwJTIwdHJhaW5fc3BsaXQlMjAlM0QlMjByYW5kb21fcGVybSU1QiUzQWN1dCU1RCUwQSUyMCUyMCUyMCUyMGV2YWxfc3BsaXQlMjAlM0QlMjByYW5kb21fcGVybSU1QmN1dCUzQSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEZvciUyMHRyYWluaW5nJTIwYSUyMHNpbXBsZSUyMFJhbmRvbVJlc2l6ZWRDcm9wJTIwd2lsbCUyMGJlJTIwdXNlZCUwQSUyMCUyMCUyMCUyMHRyYWluX3RmbSUyMCUzRCUyMENvbXBvc2UoJTVCUmFuZG9tUmVzaXplZENyb3AoKDIyNCUyQyUyMDIyNCklMkMlMjBzY2FsZSUzRCgwLjUlMkMlMjAxLjApKSUyQyUyMFRvVGVuc29yKCklNUQpJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUyMCUzRCUyMFBldHNEYXRhc2V0KCU1QmZuYW1lcyU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjB0cmFpbl9zcGxpdCU1RCUyQyUyMGltYWdlX3RyYW5zZm9ybSUzRHRyYWluX3RmbSUyQyUyMGxhYmVsX3RvX2lkJTNEbGFiZWxfdG9faWQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRm9yJTIwZXZhbHVhdGlvbiUyMGElMjBkZXRlcm1pbmlzdGljJTIwUmVzaXplJTIwd2lsbCUyMGJlJTIwdXNlZCUwQSUyMCUyMCUyMCUyMGV2YWxfdGZtJTIwJTNEJTIwQ29tcG9zZSglNUJSZXNpemUoKDIyNCUyQyUyMDIyNCkpJTJDJTIwVG9UZW5zb3IoKSU1RCklMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlMjAlM0QlMjBQZXRzRGF0YXNldCglNUJmbmFtZXMlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwZXZhbF9zcGxpdCU1RCUyQyUyMGltYWdlX3RyYW5zZm9ybSUzRGV2YWxfdGZtJTJDJTIwbGFiZWxfdG9faWQlM0RsYWJlbF90b19pZCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJbnN0YW50aWF0ZSUyMGRhdGFsb2FkZXJzJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIodHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBudW1fd29ya2VycyUzRDQpJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihldmFsX2RhdGFzZXQlMkMlMjBzaHVmZmxlJTNERmFsc2UlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyMColMjAyJTJDJTIwbnVtX3dvcmtlcnMlM0Q0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_dataloaders</span>(<span class="hljs-params">batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    <span class="hljs-string">&quot;Builds a set of dataloaders with a batch_size&quot;</span>
    random_perm = np.random.permutation(<span class="hljs-built_in">len</span>(fnames))
    cut = <span class="hljs-built_in">int</span>(<span class="hljs-number">0.8</span> * <span class="hljs-built_in">len</span>(fnames))
    train_split = random_perm[:cut]
    eval_split = random_perm[cut:]

    <span class="hljs-comment"># For training a simple RandomResizedCrop will be used</span>
    train_tfm = Compose([RandomResizedCrop((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>), scale=(<span class="hljs-number">0.5</span>, <span class="hljs-number">1.0</span>)), ToTensor()])
    train_dataset = PetsDataset([fnames[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> train_split], image_transform=train_tfm, label_to_id=label_to_id)

    <span class="hljs-comment"># For evaluation a deterministic Resize will be used</span>
    eval_tfm = Compose([Resize((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)), ToTensor()])
    eval_dataset = PetsDataset([fnames[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> eval_split], image_transform=eval_tfm, label_to_id=label_to_id)

    <span class="hljs-comment"># Instantiate dataloaders</span>
    train_dataloader = DataLoader(train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=batch_size, num_workers=<span class="hljs-number">4</span>)
    eval_dataloader = DataLoader(eval_dataset, shuffle=<span class="hljs-literal">False</span>, batch_size=batch_size * <span class="hljs-number">2</span>, num_workers=<span class="hljs-number">4</span>)
    <span class="hljs-keyword">return</span> train_dataloader, eval_dataloader`}}),_e=new j({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlciUyMGltcG9ydCUyMENvc2luZUFubmVhbGluZ0xS",highlighted:'<span class="hljs-keyword">from</span> torch.optim.lr_scheduler <span class="hljs-keyword">import</span> CosineAnnealingLR'}}),Ze=new el({}),D=new Oe({props:{$$slots:{default:[Wr]},$$scope:{ctx:Z}}}),$e=new j({props:{code:"ZGVmJTIwdHJhaW5pbmdfbG9vcChtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyJTJDJTIwc2VlZCUzQSUyMGludCUyMCUzRCUyMDQyJTJDJTIwYmF0Y2hfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDY0KSUzQSUwQSUyMCUyMCUyMCUyMHNldF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0RtaXhlZF9wcmVjaXNpb24p",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_loop</span>(<span class="hljs-params">mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>, seed: <span class="hljs-built_in">int</span> = <span class="hljs-number">42</span>, batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    set_seed(seed)
    accelerator = Accelerator(mixed_precision=mixed_precision)`}}),q=new Oe({props:{warning:!0,$$slots:{default:[Ar]},$$scope:{ctx:Z}}}),ke=new j({props:{code:"JTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMGdldF9kYXRhbG9hZGVycyhiYXRjaF9zaXplKSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RsZW4obGFiZWxfdG9faWQpKQ==",highlighted:`    train_dataloader, eval_dataloader = get_dataloaders(batch_size)
    model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))`}}),L=new Oe({props:{$$slots:{default:[Br]},$$scope:{ctx:Z}}}),Ge=new j({props:{code:"JTIwJTIwJTIwJTIwZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhcmFtJTIwaW4lMjBtb2RlbC5nZXRfY2xhc3NpZmllcigpLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlMjAlM0QlMjBUcnVl",highlighted:`    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
        param.requires_grad = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.get_classifier().parameters():
        param.requires_grad = <span class="hljs-literal">True</span>`}}),ve=new j({props:{code:"JTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMHRvcmNoLnRlbnNvcihtb2RlbC5kZWZhdWx0X2NmZyU1QiUyMm1lYW4lMjIlNUQpJTVCTm9uZSUyQyUyMCUzQSUyQyUyME5vbmUlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwc3RkJTIwJTNEJTIwdG9yY2gudGVuc29yKG1vZGVsLmRlZmF1bHRfY2ZnJTVCJTIyc3RkJTIyJTVEKSU1Qk5vbmUlMkMlMjAlM0ElMkMlMjBOb25lJTJDJTIwTm9uZSU1RA==",highlighted:`    mean = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;mean&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
    std = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;std&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]`}}),We=new j({props:{code:"JTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMG1lYW4udG8oYWNjZWxlcmF0b3IuZGV2aWNlKSUwQSUyMCUyMCUyMCUyMHN0ZCUyMCUzRCUyMHN0ZC50byhhY2NlbGVyYXRvci5kZXZpY2Up",highlighted:`    mean = mean.to(accelerator.device)
    std = std.to(accelerator.device)`}}),Ae=new j({props:{code:"JTIwJTIwJTIwJTIwb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbShwYXJhbXMlM0Rtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTIlMjAlMkYlMjAyNSklMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBPbmVDeWNsZUxSKG9wdGltaXplciUzRG9wdGltaXplciUyQyUyMG1heF9sciUzRDNlLTIlMkMlMjBlcG9jaHMlM0Q1JTJDJTIwc3RlcHNfcGVyX2Vwb2NoJTNEbGVuKHRyYWluX2RhdGFsb2FkZXIpKQ==",highlighted:`    optimizer = torch.optim.Adam(params=model.parameters(), lr=<span class="hljs-number">3e-2</span> / <span class="hljs-number">25</span>)
    lr_scheduler = OneCycleLR(optimizer=optimizer, max_lr=<span class="hljs-number">3e-2</span>, epochs=<span class="hljs-number">5</span>, steps_per_epoch=<span class="hljs-built_in">len</span>(train_dataloader))`}}),ee=new Oe({props:{$$slots:{default:[gr]},$$scope:{ctx:Z}}}),Be=new j({props:{code:"JTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMEElMjAlMjAlMjAlMjAp",highlighted:`    model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
    )`}}),ge=new j({props:{code:"JTIwJTIwJTIwJTIwZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKDUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwudHJhaW4oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwKGJhdGNoJTVCJTIyaW1hZ2UlMjIlNUQlMjAtJTIwbWVhbiklMjAlMkYlMjBzdGQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmNyb3NzX2VudHJvcHkob3V0cHV0cyUyQyUyMGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        model.train()
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            outputs = model(inputs)
            loss = torch.nn.functional.cross_entropy(outputs, batch[<span class="hljs-string">&quot;label&quot;</span>])
            accelerator.backward(loss)
            optimizer.step()
            lr_scheduler.step()
            optimizer.zero_grad()`}}),Ee=new j({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwuZXZhbCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTNEJTIwMA==",highlighted:`        model.<span class="hljs-built_in">eval</span>()
        accurate = <span class="hljs-number">0</span>
        num_elems = <span class="hljs-number">0</span>`}}),Ne=new j({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMChiYXRjaCU1QiUyMmltYWdlJTIyJTVEJTIwLSUyMG1lYW4pJTIwJTJGJTIwc3RkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmFyZ21heChkaW0lM0QtMSk=",highlighted:`        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            <span class="hljs-keyword">with</span> torch.no_grad():
                outputs = model(inputs)
            predictions = outputs.argmax(dim=-<span class="hljs-number">1</span>)`}}),Ye=new j({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGVfcHJlZHMlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXIocHJlZGljdGlvbnMpJTIwJTNEJTNEJTIwYWNjZWxlcmF0b3IuZ2F0aGVyKGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTJCJTNEJTIwYWNjdXJhdGVfcHJlZHMuc2hhcGUlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlMkIlM0QlMjBhY2N1cmF0ZV9wcmVkcy5sb25nKCkuc3VtKCk=",highlighted:`            accurate_preds = accelerator.gather(predictions) == accelerator.gather(batch[<span class="hljs-string">&quot;label&quot;</span>])
            num_elems += accurate_preds.shape[<span class="hljs-number">0</span>]
            accurate += accurate_preds.long().<span class="hljs-built_in">sum</span>()`}}),Xe=new j({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9tZXRyaWMlMjAlM0QlMjBhY2N1cmF0ZS5pdGVtKCklMjAlMkYlMjBudW1fZWxlbXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5wcmludChmJTIyZXBvY2glMjAlN0JlcG9jaCU3RCUzQSUyMCU3QjEwMCUyMColMjBldmFsX21ldHJpYyUzQS4yZiU3RCUyMik=",highlighted:`        eval_metric = accurate.item() / num_elems
        accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;epoch <span class="hljs-subst">{epoch}</span>: <span class="hljs-subst">{<span class="hljs-number">100</span> * eval_metric:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`}}),Re=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_loop</span>(<span class="hljs-params">mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>, seed: <span class="hljs-built_in">int</span> = <span class="hljs-number">42</span>, batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    set_seed(seed)
    <span class="hljs-comment"># Initialize accelerator</span>
    accelerator = Accelerator(mixed_precision=mixed_precision)
    <span class="hljs-comment"># Build dataloaders</span>
    train_dataloader, eval_dataloader = get_dataloaders(batch_size)

    <span class="hljs-comment"># Instantiate the model (you build the model here so that the seed also controls new weight initaliziations)</span>
    model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))

    <span class="hljs-comment"># Freeze the base model</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
        param.requires_grad = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.get_classifier().parameters():
        param.requires_grad = <span class="hljs-literal">True</span>

    <span class="hljs-comment"># You can normalize the batches of images to be a bit faster</span>
    mean = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;mean&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
    std = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;std&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]

    <span class="hljs-comment"># To make these constants available on the active device, set it to the accelerator device</span>
    mean = mean.to(accelerator.device)
    std = std.to(accelerator.device)

    <span class="hljs-comment"># Intantiate the optimizer</span>
    optimizer = torch.optim.Adam(params=model.parameters(), lr=<span class="hljs-number">3e-2</span> / <span class="hljs-number">25</span>)

    <span class="hljs-comment"># Instantiate the learning rate scheduler</span>
    lr_scheduler = OneCycleLR(optimizer=optimizer, max_lr=<span class="hljs-number">3e-2</span>, epochs=<span class="hljs-number">5</span>, steps_per_epoch=<span class="hljs-built_in">len</span>(train_dataloader))

    <span class="hljs-comment"># Prepare everything</span>
    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the</span>
    <span class="hljs-comment"># prepare method.</span>
    model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
    )

    <span class="hljs-comment"># Now you train the model</span>
    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        model.train()
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            outputs = model(inputs)
            loss = torch.nn.functional.cross_entropy(outputs, batch[<span class="hljs-string">&quot;label&quot;</span>])
            accelerator.backward(loss)
            optimizer.step()
            lr_scheduler.step()
            optimizer.zero_grad()

        model.<span class="hljs-built_in">eval</span>()
        accurate = <span class="hljs-number">0</span>
        num_elems = <span class="hljs-number">0</span>
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            <span class="hljs-keyword">with</span> torch.no_grad():
                outputs = model(inputs)
            predictions = outputs.argmax(dim=-<span class="hljs-number">1</span>)
            accurate_preds = accelerator.gather(predictions) == accelerator.gather(batch[<span class="hljs-string">&quot;label&quot;</span>])
            num_elems += accurate_preds.shape[<span class="hljs-number">0</span>]
            accurate += accurate_preds.long().<span class="hljs-built_in">sum</span>()

        eval_metric = accurate.item() / num_elems
        <span class="hljs-comment"># Use accelerator.print to print only on the main process.</span>
        accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;epoch <span class="hljs-subst">{epoch}</span>: <span class="hljs-subst">{<span class="hljs-number">100</span> * eval_metric:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`}}),Ve=new el({}),Fe=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlcg==",highlighted:'<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher'}}),Qe=new j({props:{code:"YXJncyUyMCUzRCUyMCglMjJmcDE2JTIyJTJDJTIwNDIlMkMlMjA2NCklMEFub3RlYm9va19sYXVuY2hlcih0cmFpbmluZ19sb29wJTJDJTIwYXJncyUyQyUyMG51bV9wcm9jZXNzZXMlM0QyKQ==",highlighted:`args = (<span class="hljs-string">&quot;fp16&quot;</span>, <span class="hljs-number">42</span>, <span class="hljs-number">64</span>)
notebook_launcher(training_loop, args, num_processes=<span class="hljs-number">2</span>)`}}),ze=new j({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIodHJhaW5pbmdfbG9vcCUyQyUyMGFyZ3MlMkMlMjBtYXN0ZXJfYWRkciUzRCUyMjE3Mi4zMS40My44JTIyJTJDJTIwbm9kZV9yYW5rJTNEMCUyQyUyMG51bV9ub2RlcyUzRDIlMkMlMjBudW1fcHJvY2Vzc2VzJTNEOCk=",highlighted:'notebook_launcher(training_loop, args, master_addr=<span class="hljs-string">&quot;172.31.43.8&quot;</span>, node_rank=<span class="hljs-number">0</span>, num_nodes=<span class="hljs-number">2</span>, num_processes=<span class="hljs-number">8</span>)'}}),oe=new Oe({props:{$$slots:{default:[Er]},$$scope:{ctx:Z}}}),Se=new j({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIodHJhaW5pbmdfbG9vcCUyQyUyMGFyZ3MlMkMlMjBtYXN0ZXJfYWRkciUzRCUyMjE3Mi4zMS40My44JTIyJTJDJTIwbm9kZV9yYW5rJTNEMSUyQyUyMG51bV9ub2RlcyUzRDIlMkMlMjBudW1fcHJvY2Vzc2VzJTNEOCk=",highlighted:'notebook_launcher(training_loop, args, master_addr=<span class="hljs-string">&quot;172.31.43.8&quot;</span>, node_rank=<span class="hljs-number">1</span>, num_nodes=<span class="hljs-number">2</span>, num_processes=<span class="hljs-number">8</span>)'}}),xe=new j({props:{code:"bW9kZWwlMjAlM0QlMjBjcmVhdGVfbW9kZWwoJTIycmVzbmV0NTBkJTIyJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRGxlbihsYWJlbF90b19pZCkpJTBBJTBBYXJncyUyMCUzRCUyMChtb2RlbCUyQyUyMCUyMmZwMTYlMjIlMkMlMjA0MiUyQyUyMDY0KSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDgp",highlighted:`model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))

args = (model, <span class="hljs-string">&quot;fp16&quot;</span>, <span class="hljs-number">42</span>, <span class="hljs-number">64</span>)
notebook_launcher(training_loop, args, num_processes=<span class="hljs-number">8</span>)`}}),He=new j({props:{code:"TGF1bmNoaW5nJTIwdHJhaW5pbmclMjBvbiUyMDIlMjBHUFVzLiUwQWVwb2NoJTIwMCUzQSUyMDg4LjEyJTBBZXBvY2glMjAxJTNBJTIwOTEuNzMlMEFlcG9jaCUyMDIlM0ElMjA5Mi41OCUwQWVwb2NoJTIwMyUzQSUyMDkzLjkwJTBBZXBvY2glMjA0JTNBJTIwOTQuNzE=",highlighted:`Launching training on <span class="hljs-number">2</span> GPUs.
epoch <span class="hljs-number">0</span>: <span class="hljs-number">88.12</span>
epoch <span class="hljs-number">1</span>: <span class="hljs-number">91.73</span>
epoch <span class="hljs-number">2</span>: <span class="hljs-number">92.58</span>
epoch <span class="hljs-number">3</span>: <span class="hljs-number">93.90</span>
epoch <span class="hljs-number">4</span>: <span class="hljs-number">94.71</span>`}}),Pe=new el({}),De=new el({}),{c(){m=n("meta"),b=c(),h=n("h1"),U=n("a"),_=n("span"),y(I.$$.fragment),C=c(),G=n("span"),ht=r("Launching Multi-GPU Training from a Jupyter Environment"),fs=c(),ll=n("p"),yt=r(`This tutorial teaches you how to fine tune a computer vision model with \u{1F917} Accelerate from a Jupyter Notebook on a distributed system.
You will also learn how to setup a few requirements needed for ensuring your environment is configured properly, your data has been prepared properly, and finally how to launch training.`),ds=c(),y(V.$$.fragment),Ts=c(),g=n("h2"),F=n("a"),Vl=n("span"),y(ce.$$.fragment),wt=c(),Fl=n("span"),ut=r("Configuring the Environment"),Us=c(),sl=n("p"),Jt=r("Before any training can be performed, a \u{1F917} Accelerate config file must exist in the system. Usually this can be done by running the following in a terminal and answering the prompts:"),bs=c(),y(Me.$$.fragment),js=c(),v=n("p"),ft=r("However, if general defaults are fine and you are "),Ql=n("em"),dt=r("not"),Tt=r(" running on a TPU, \u{1F917}Accelerate has a utility to quickly write your GPU configuration into a config file via "),al=n("a"),Ut=r("utils.write_basic_config()"),bt=r("."),Is=c(),tl=n("p"),jt=r("The following code will restart Jupyter after writing the configuration, as CUDA code was called to perform this."),Cs=c(),y(Q.$$.fragment),_s=c(),y(me.$$.fragment),Zs=c(),E=n("h2"),z=n("a"),zl=n("span"),y(he.$$.fragment),It=c(),Sl=n("span"),Ct=r("Preparing the Dataset and Model"),$s=c(),k=n("p"),_t=r("Next you should prepare your dataset. As mentioned at earlier, great care should be taken when preparing the "),xl=n("code"),Zt=r("DataLoaders"),$t=r(" and model to make sure that "),Hl=n("strong"),kt=r("nothing"),Gt=r(" is put on "),Pl=n("em"),vt=r("any"),Wt=r(" GPU."),ks=c(),nl=n("p"),At=r("If you do, it is recommended to put that specific code into a function and call that from within the notebook launcher interface, which will be shown later."),Gs=c(),ye=n("p"),Bt=r("Make sure the dataset is downloaded based on the directions "),we=n("a"),gt=r("here"),vs=c(),y(ue.$$.fragment),Ws=c(),ol=n("p"),Et=r("First you need to create a function to extract the class name based on a filename:"),As=c(),y(Je.$$.fragment),Bs=c(),y(fe.$$.fragment),gs=c(),S=n("p"),Nt=r("In the case here, the label is "),Dl=n("code"),Yt=r("beagle"),Xt=r(". Using regex you can extract the label from the filename:"),Es=c(),y(de.$$.fragment),Ns=c(),y(Te.$$.fragment),Ys=c(),rl=n("p"),Rt=r("And you can see it properly returned the right name for our file:"),Xs=c(),y(Ue.$$.fragment),Rs=c(),x=n("p"),Vt=r("Next a "),Kl=n("code"),Ft=r("Dataset"),Qt=r(" class should be made to handle grabbing the image and the label:"),Vs=c(),y(be.$$.fragment),Fs=c(),il=n("p"),zt=r(`Now to build the dataset. Outside the training function you can find and declare all the filenames and labels and use them as references inside the
launched function:`),Qs=c(),y(je.$$.fragment),zs=c(),pl=n("p"),St=r("Next gather all the labels:"),Ss=c(),y(Ie.$$.fragment),xs=c(),W=n("p"),xt=r("Next, you should make a "),ql=n("code"),Ht=r("get_dataloaders"),Pt=r(` function that will return your built dataloaders for you. As mentioned earlier, if data is automatically
sent to the GPU or a TPU device when building your `),Ll=n("code"),Dt=r("DataLoaders"),Kt=r(", they must be built using this method."),Hs=c(),y(Ce.$$.fragment),Ps=c(),cl=n("p"),qt=r("Finally, you should import the scheduler to be used later:"),Ds=c(),y(_e.$$.fragment),Ks=c(),N=n("h2"),H=n("a"),Ol=n("span"),y(Ze.$$.fragment),Lt=c(),es=n("span"),Ot=r("Writing the Training Function"),qs=c(),P=n("p"),en=r("Now you can build the training loop. "),Ml=n("a"),ln=r("notebook_launcher()"),sn=r(" works by passing in a function to call that will be ran across the distributed system."),Ls=c(),ml=n("p"),an=r("Here is a basic training loop for the animal classification problem:"),Os=c(),y(D.$$.fragment),ea=c(),y($e.$$.fragment),la=c(),K=n("p"),tn=r("First you should set the seed and create an "),hl=n("a"),nn=r("Accelerator"),on=r(" object as early in the training loop as possible."),sa=c(),y(q.$$.fragment),aa=c(),yl=n("p"),rn=r("Next you should build your dataloaders and create your model:"),ta=c(),y(ke.$$.fragment),na=c(),y(L.$$.fragment),oa=c(),wl=n("p"),pn=r(`As you are performing transfer learning in this example, the encoder of the model starts out frozen so the head of the model can be
trained only initially:`),ra=c(),y(Ge.$$.fragment),ia=c(),ul=n("p"),cn=r("Normalizing the batches of images will make training a little faster:"),pa=c(),y(ve.$$.fragment),ca=c(),Jl=n("p"),Mn=r("To make these constants available on the active device, you should set it to the Accelerator\u2019s device:"),Ma=c(),y(We.$$.fragment),ma=c(),fl=n("p"),mn=r("Next instantiate the rest of the PyTorch classes used for training:"),ha=c(),y(Ae.$$.fragment),ya=c(),O=n("p"),hn=r("Before passing everything to "),dl=n("a"),yn=r("prepare()"),wn=r("."),wa=c(),y(ee.$$.fragment),ua=c(),y(Be.$$.fragment),Ja=c(),Tl=n("p"),un=r("Now train the model:"),fa=c(),y(ge.$$.fragment),da=c(),Ul=n("p"),Jn=r(`The evaluation loop will look slightly different compared to the training loop. The number of elements passed as well as the overall
total accuracy of each batch will be added to two constants:`),Ta=c(),y(Ee.$$.fragment),Ua=c(),bl=n("p"),fn=r("Next you have the rest of your standard PyTorch loop:"),ba=c(),y(Ne.$$.fragment),ja=c(),jl=n("p"),dn=r("Before finally the last major difference."),Ia=c(),le=n("p"),Tn=r(`When performing distributed evaluation, the predictions and labels need to be passed through
`),Il=n("a"),Un=r("gather()"),bn=r(" so that all of the data is available on the current device and a properly calculated metric can be achieved:"),Ca=c(),y(Ye.$$.fragment),_a=c(),se=n("p"),jn=r("Now you just need to calculate the actual metric for this problem, and you can print it on the main process using "),Cl=n("a"),In=r("print()"),Cn=r(":"),Za=c(),y(Xe.$$.fragment),$a=c(),_l=n("p"),_n=r("A full version of this training loop is available below:"),ka=c(),y(Re.$$.fragment),Ga=c(),Y=n("h2"),ae=n("a"),ls=n("span"),y(Ve.$$.fragment),Zn=c(),ss=n("span"),$n=r("Using the notebook_launcher"),va=c(),te=n("p"),kn=r("All that\u2019s left is to use the "),Zl=n("a"),Gn=r("notebook_launcher()"),vn=r("."),Wa=c(),ne=n("p"),Wn=r("You pass in the function, the arguments (as a tuple), and the number of processes to train on. (See the "),$l=n("a"),An=r("documentation"),Bn=r(" for more information)"),Aa=c(),y(Fe.$$.fragment),Ba=c(),y(Qe.$$.fragment),ga=c(),kl=n("p"),gn=r("In the case of running on multiple nodes, you need to set up a Jupyter session at each node and run the launching cell at the same time."),Ea=c(),Gl=n("p"),En=r("For an environment containing 2 nodes (computers) with 8 GPUs each and the main computer with an IP address of \u201C172.31.43.8\u201D, it would look like so:"),Na=c(),y(ze.$$.fragment),Ya=c(),vl=n("p"),Nn=r("And in the second Jupyter session on the other machine:"),Xa=c(),y(oe.$$.fragment),Ra=c(),y(Se.$$.fragment),Va=c(),Wl=n("p"),Yn=r("In the case of running on the TPU, it would look like so:"),Fa=c(),y(xe.$$.fragment),Qa=c(),Al=n("p"),Xn=r("As it\u2019s running it will print the progress as well as state how many devices you ran on. This tutorial was ran with two GPUs:"),za=c(),y(He.$$.fragment),Sa=c(),Bl=n("p"),Rn=r("And that\u2019s it!"),xa=c(),X=n("h2"),re=n("a"),as=n("span"),y(Pe.$$.fragment),Vn=c(),ts=n("span"),Fn=r("Debugging"),Ha=c(),$=n("p"),Qn=r("A common issue when running the "),ns=n("code"),zn=r("notebook_launcher"),Sn=r(` is receiving a CUDA has already been initialized issue. This usually stems
from an import or prior code in the notebook that makes a call to the PyTorch `),os=n("code"),xn=r("torch.cuda"),Hn=r(` sublibrary. To help narrow down what went wrong,
you can launch the `),rs=n("code"),Pn=r("notebook_launcher"),Dn=r(" with "),is=n("code"),Kn=r("ACCELERATE_DEBUG_MODE=yes"),qn=r(` in your environment and an additional check
will be made when spawning that a regular process can be created and utilize CUDA without issue. (Your CUDA code can still be ran afterwards).`),Pa=c(),R=n("h2"),ie=n("a"),ps=n("span"),y(De.$$.fragment),Ln=c(),cs=n("span"),On=r("Conclusion"),Da=c(),gl=n("p"),eo=r("This notebook showed how to perform distributed training from inside of a Jupyter Notebook. Some key notes to remember:"),Ka=c(),A=n("ul"),El=n("li"),lo=r("Make sure to save any code that use CUDA (or CUDA imports) for the function passed to "),Nl=n("a"),so=r("notebook_launcher()"),ao=c(),Ke=n("li"),to=r("Set the "),Ms=n("code"),no=r("num_processes"),oo=r(" to be the number of devices used for training (such as number of GPUs, CPUs, TPUs, etc)"),ro=c(),ms=n("li"),io=r("If using the TPU, declare your model outside the training loop function"),this.h()},l(e){const s=$r('[data-svelte="svelte-1phssyn"]',document.head);m=o(s,"META",{name:!0,content:!0}),s.forEach(l),b=M(e),h=o(e,"H1",{class:!0});var qe=p(h);U=o(qe,"A",{id:!0,class:!0,href:!0});var hs=p(U);_=o(hs,"SPAN",{});var ys=p(_);w(I.$$.fragment,ys),ys.forEach(l),hs.forEach(l),C=M(qe),G=o(qe,"SPAN",{});var ws=p(G);ht=i(ws,"Launching Multi-GPU Training from a Jupyter Environment"),ws.forEach(l),qe.forEach(l),fs=M(e),ll=o(e,"P",{});var us=p(ll);yt=i(us,`This tutorial teaches you how to fine tune a computer vision model with \u{1F917} Accelerate from a Jupyter Notebook on a distributed system.
You will also learn how to setup a few requirements needed for ensuring your environment is configured properly, your data has been prepared properly, and finally how to launch training.`),us.forEach(l),ds=M(e),w(V.$$.fragment,e),Ts=M(e),g=o(e,"H2",{class:!0});var Le=p(g);F=o(Le,"A",{id:!0,class:!0,href:!0});var Js=p(F);Vl=o(Js,"SPAN",{});var Mo=p(Vl);w(ce.$$.fragment,Mo),Mo.forEach(l),Js.forEach(l),wt=M(Le),Fl=o(Le,"SPAN",{});var mo=p(Fl);ut=i(mo,"Configuring the Environment"),mo.forEach(l),Le.forEach(l),Us=M(e),sl=o(e,"P",{});var ho=p(sl);Jt=i(ho,"Before any training can be performed, a \u{1F917} Accelerate config file must exist in the system. Usually this can be done by running the following in a terminal and answering the prompts:"),ho.forEach(l),bs=M(e),w(Me.$$.fragment,e),js=M(e),v=o(e,"P",{});var Yl=p(v);ft=i(Yl,"However, if general defaults are fine and you are "),Ql=o(Yl,"EM",{});var yo=p(Ql);dt=i(yo,"not"),yo.forEach(l),Tt=i(Yl," running on a TPU, \u{1F917}Accelerate has a utility to quickly write your GPU configuration into a config file via "),al=o(Yl,"A",{href:!0});var wo=p(al);Ut=i(wo,"utils.write_basic_config()"),wo.forEach(l),bt=i(Yl,"."),Yl.forEach(l),Is=M(e),tl=o(e,"P",{});var uo=p(tl);jt=i(uo,"The following code will restart Jupyter after writing the configuration, as CUDA code was called to perform this."),uo.forEach(l),Cs=M(e),w(Q.$$.fragment,e),_s=M(e),w(me.$$.fragment,e),Zs=M(e),E=o(e,"H2",{class:!0});var La=p(E);z=o(La,"A",{id:!0,class:!0,href:!0});var Jo=p(z);zl=o(Jo,"SPAN",{});var fo=p(zl);w(he.$$.fragment,fo),fo.forEach(l),Jo.forEach(l),It=M(La),Sl=o(La,"SPAN",{});var To=p(Sl);Ct=i(To,"Preparing the Dataset and Model"),To.forEach(l),La.forEach(l),$s=M(e),k=o(e,"P",{});var pe=p(k);_t=i(pe,"Next you should prepare your dataset. As mentioned at earlier, great care should be taken when preparing the "),xl=o(pe,"CODE",{});var Uo=p(xl);Zt=i(Uo,"DataLoaders"),Uo.forEach(l),$t=i(pe," and model to make sure that "),Hl=o(pe,"STRONG",{});var bo=p(Hl);kt=i(bo,"nothing"),bo.forEach(l),Gt=i(pe," is put on "),Pl=o(pe,"EM",{});var jo=p(Pl);vt=i(jo,"any"),jo.forEach(l),Wt=i(pe," GPU."),pe.forEach(l),ks=M(e),nl=o(e,"P",{});var Io=p(nl);At=i(Io,"If you do, it is recommended to put that specific code into a function and call that from within the notebook launcher interface, which will be shown later."),Io.forEach(l),Gs=M(e),ye=o(e,"P",{});var po=p(ye);Bt=i(po,"Make sure the dataset is downloaded based on the directions "),we=o(po,"A",{href:!0,rel:!0});var Co=p(we);gt=i(Co,"here"),Co.forEach(l),po.forEach(l),vs=M(e),w(ue.$$.fragment,e),Ws=M(e),ol=o(e,"P",{});var _o=p(ol);Et=i(_o,"First you need to create a function to extract the class name based on a filename:"),_o.forEach(l),As=M(e),w(Je.$$.fragment,e),Bs=M(e),w(fe.$$.fragment,e),gs=M(e),S=o(e,"P",{});var Oa=p(S);Nt=i(Oa,"In the case here, the label is "),Dl=o(Oa,"CODE",{});var Zo=p(Dl);Yt=i(Zo,"beagle"),Zo.forEach(l),Xt=i(Oa,". Using regex you can extract the label from the filename:"),Oa.forEach(l),Es=M(e),w(de.$$.fragment,e),Ns=M(e),w(Te.$$.fragment,e),Ys=M(e),rl=o(e,"P",{});var $o=p(rl);Rt=i($o,"And you can see it properly returned the right name for our file:"),$o.forEach(l),Xs=M(e),w(Ue.$$.fragment,e),Rs=M(e),x=o(e,"P",{});var et=p(x);Vt=i(et,"Next a "),Kl=o(et,"CODE",{});var ko=p(Kl);Ft=i(ko,"Dataset"),ko.forEach(l),Qt=i(et," class should be made to handle grabbing the image and the label:"),et.forEach(l),Vs=M(e),w(be.$$.fragment,e),Fs=M(e),il=o(e,"P",{});var Go=p(il);zt=i(Go,`Now to build the dataset. Outside the training function you can find and declare all the filenames and labels and use them as references inside the
launched function:`),Go.forEach(l),Qs=M(e),w(je.$$.fragment,e),zs=M(e),pl=o(e,"P",{});var vo=p(pl);St=i(vo,"Next gather all the labels:"),vo.forEach(l),Ss=M(e),w(Ie.$$.fragment,e),xs=M(e),W=o(e,"P",{});var Xl=p(W);xt=i(Xl,"Next, you should make a "),ql=o(Xl,"CODE",{});var Wo=p(ql);Ht=i(Wo,"get_dataloaders"),Wo.forEach(l),Pt=i(Xl,` function that will return your built dataloaders for you. As mentioned earlier, if data is automatically
sent to the GPU or a TPU device when building your `),Ll=o(Xl,"CODE",{});var Ao=p(Ll);Dt=i(Ao,"DataLoaders"),Ao.forEach(l),Kt=i(Xl,", they must be built using this method."),Xl.forEach(l),Hs=M(e),w(Ce.$$.fragment,e),Ps=M(e),cl=o(e,"P",{});var Bo=p(cl);qt=i(Bo,"Finally, you should import the scheduler to be used later:"),Bo.forEach(l),Ds=M(e),w(_e.$$.fragment,e),Ks=M(e),N=o(e,"H2",{class:!0});var lt=p(N);H=o(lt,"A",{id:!0,class:!0,href:!0});var go=p(H);Ol=o(go,"SPAN",{});var Eo=p(Ol);w(Ze.$$.fragment,Eo),Eo.forEach(l),go.forEach(l),Lt=M(lt),es=o(lt,"SPAN",{});var No=p(es);Ot=i(No,"Writing the Training Function"),No.forEach(l),lt.forEach(l),qs=M(e),P=o(e,"P",{});var st=p(P);en=i(st,"Now you can build the training loop. "),Ml=o(st,"A",{href:!0});var Yo=p(Ml);ln=i(Yo,"notebook_launcher()"),Yo.forEach(l),sn=i(st," works by passing in a function to call that will be ran across the distributed system."),st.forEach(l),Ls=M(e),ml=o(e,"P",{});var Xo=p(ml);an=i(Xo,"Here is a basic training loop for the animal classification problem:"),Xo.forEach(l),Os=M(e),w(D.$$.fragment,e),ea=M(e),w($e.$$.fragment,e),la=M(e),K=o(e,"P",{});var at=p(K);tn=i(at,"First you should set the seed and create an "),hl=o(at,"A",{href:!0});var Ro=p(hl);nn=i(Ro,"Accelerator"),Ro.forEach(l),on=i(at," object as early in the training loop as possible."),at.forEach(l),sa=M(e),w(q.$$.fragment,e),aa=M(e),yl=o(e,"P",{});var Vo=p(yl);rn=i(Vo,"Next you should build your dataloaders and create your model:"),Vo.forEach(l),ta=M(e),w(ke.$$.fragment,e),na=M(e),w(L.$$.fragment,e),oa=M(e),wl=o(e,"P",{});var Fo=p(wl);pn=i(Fo,`As you are performing transfer learning in this example, the encoder of the model starts out frozen so the head of the model can be
trained only initially:`),Fo.forEach(l),ra=M(e),w(Ge.$$.fragment,e),ia=M(e),ul=o(e,"P",{});var Qo=p(ul);cn=i(Qo,"Normalizing the batches of images will make training a little faster:"),Qo.forEach(l),pa=M(e),w(ve.$$.fragment,e),ca=M(e),Jl=o(e,"P",{});var zo=p(Jl);Mn=i(zo,"To make these constants available on the active device, you should set it to the Accelerator\u2019s device:"),zo.forEach(l),Ma=M(e),w(We.$$.fragment,e),ma=M(e),fl=o(e,"P",{});var So=p(fl);mn=i(So,"Next instantiate the rest of the PyTorch classes used for training:"),So.forEach(l),ha=M(e),w(Ae.$$.fragment,e),ya=M(e),O=o(e,"P",{});var tt=p(O);hn=i(tt,"Before passing everything to "),dl=o(tt,"A",{href:!0});var xo=p(dl);yn=i(xo,"prepare()"),xo.forEach(l),wn=i(tt,"."),tt.forEach(l),wa=M(e),w(ee.$$.fragment,e),ua=M(e),w(Be.$$.fragment,e),Ja=M(e),Tl=o(e,"P",{});var Ho=p(Tl);un=i(Ho,"Now train the model:"),Ho.forEach(l),fa=M(e),w(ge.$$.fragment,e),da=M(e),Ul=o(e,"P",{});var Po=p(Ul);Jn=i(Po,`The evaluation loop will look slightly different compared to the training loop. The number of elements passed as well as the overall
total accuracy of each batch will be added to two constants:`),Po.forEach(l),Ta=M(e),w(Ee.$$.fragment,e),Ua=M(e),bl=o(e,"P",{});var Do=p(bl);fn=i(Do,"Next you have the rest of your standard PyTorch loop:"),Do.forEach(l),ba=M(e),w(Ne.$$.fragment,e),ja=M(e),jl=o(e,"P",{});var Ko=p(jl);dn=i(Ko,"Before finally the last major difference."),Ko.forEach(l),Ia=M(e),le=o(e,"P",{});var nt=p(le);Tn=i(nt,`When performing distributed evaluation, the predictions and labels need to be passed through
`),Il=o(nt,"A",{href:!0});var qo=p(Il);Un=i(qo,"gather()"),qo.forEach(l),bn=i(nt," so that all of the data is available on the current device and a properly calculated metric can be achieved:"),nt.forEach(l),Ca=M(e),w(Ye.$$.fragment,e),_a=M(e),se=o(e,"P",{});var ot=p(se);jn=i(ot,"Now you just need to calculate the actual metric for this problem, and you can print it on the main process using "),Cl=o(ot,"A",{href:!0});var Lo=p(Cl);In=i(Lo,"print()"),Lo.forEach(l),Cn=i(ot,":"),ot.forEach(l),Za=M(e),w(Xe.$$.fragment,e),$a=M(e),_l=o(e,"P",{});var Oo=p(_l);_n=i(Oo,"A full version of this training loop is available below:"),Oo.forEach(l),ka=M(e),w(Re.$$.fragment,e),Ga=M(e),Y=o(e,"H2",{class:!0});var rt=p(Y);ae=o(rt,"A",{id:!0,class:!0,href:!0});var er=p(ae);ls=o(er,"SPAN",{});var lr=p(ls);w(Ve.$$.fragment,lr),lr.forEach(l),er.forEach(l),Zn=M(rt),ss=o(rt,"SPAN",{});var sr=p(ss);$n=i(sr,"Using the notebook_launcher"),sr.forEach(l),rt.forEach(l),va=M(e),te=o(e,"P",{});var it=p(te);kn=i(it,"All that\u2019s left is to use the "),Zl=o(it,"A",{href:!0});var ar=p(Zl);Gn=i(ar,"notebook_launcher()"),ar.forEach(l),vn=i(it,"."),it.forEach(l),Wa=M(e),ne=o(e,"P",{});var pt=p(ne);Wn=i(pt,"You pass in the function, the arguments (as a tuple), and the number of processes to train on. (See the "),$l=o(pt,"A",{href:!0});var tr=p($l);An=i(tr,"documentation"),tr.forEach(l),Bn=i(pt," for more information)"),pt.forEach(l),Aa=M(e),w(Fe.$$.fragment,e),Ba=M(e),w(Qe.$$.fragment,e),ga=M(e),kl=o(e,"P",{});var nr=p(kl);gn=i(nr,"In the case of running on multiple nodes, you need to set up a Jupyter session at each node and run the launching cell at the same time."),nr.forEach(l),Ea=M(e),Gl=o(e,"P",{});var or=p(Gl);En=i(or,"For an environment containing 2 nodes (computers) with 8 GPUs each and the main computer with an IP address of \u201C172.31.43.8\u201D, it would look like so:"),or.forEach(l),Na=M(e),w(ze.$$.fragment,e),Ya=M(e),vl=o(e,"P",{});var rr=p(vl);Nn=i(rr,"And in the second Jupyter session on the other machine:"),rr.forEach(l),Xa=M(e),w(oe.$$.fragment,e),Ra=M(e),w(Se.$$.fragment,e),Va=M(e),Wl=o(e,"P",{});var ir=p(Wl);Yn=i(ir,"In the case of running on the TPU, it would look like so:"),ir.forEach(l),Fa=M(e),w(xe.$$.fragment,e),Qa=M(e),Al=o(e,"P",{});var pr=p(Al);Xn=i(pr,"As it\u2019s running it will print the progress as well as state how many devices you ran on. This tutorial was ran with two GPUs:"),pr.forEach(l),za=M(e),w(He.$$.fragment,e),Sa=M(e),Bl=o(e,"P",{});var cr=p(Bl);Rn=i(cr,"And that\u2019s it!"),cr.forEach(l),xa=M(e),X=o(e,"H2",{class:!0});var ct=p(X);re=o(ct,"A",{id:!0,class:!0,href:!0});var Mr=p(re);as=o(Mr,"SPAN",{});var mr=p(as);w(Pe.$$.fragment,mr),mr.forEach(l),Mr.forEach(l),Vn=M(ct),ts=o(ct,"SPAN",{});var hr=p(ts);Fn=i(hr,"Debugging"),hr.forEach(l),ct.forEach(l),Ha=M(e),$=o(e,"P",{});var B=p($);Qn=i(B,"A common issue when running the "),ns=o(B,"CODE",{});var yr=p(ns);zn=i(yr,"notebook_launcher"),yr.forEach(l),Sn=i(B,` is receiving a CUDA has already been initialized issue. This usually stems
from an import or prior code in the notebook that makes a call to the PyTorch `),os=o(B,"CODE",{});var wr=p(os);xn=i(wr,"torch.cuda"),wr.forEach(l),Hn=i(B,` sublibrary. To help narrow down what went wrong,
you can launch the `),rs=o(B,"CODE",{});var ur=p(rs);Pn=i(ur,"notebook_launcher"),ur.forEach(l),Dn=i(B," with "),is=o(B,"CODE",{});var Jr=p(is);Kn=i(Jr,"ACCELERATE_DEBUG_MODE=yes"),Jr.forEach(l),qn=i(B,` in your environment and an additional check
will be made when spawning that a regular process can be created and utilize CUDA without issue. (Your CUDA code can still be ran afterwards).`),B.forEach(l),Pa=M(e),R=o(e,"H2",{class:!0});var Mt=p(R);ie=o(Mt,"A",{id:!0,class:!0,href:!0});var fr=p(ie);ps=o(fr,"SPAN",{});var dr=p(ps);w(De.$$.fragment,dr),dr.forEach(l),fr.forEach(l),Ln=M(Mt),cs=o(Mt,"SPAN",{});var Tr=p(cs);On=i(Tr,"Conclusion"),Tr.forEach(l),Mt.forEach(l),Da=M(e),gl=o(e,"P",{});var Ur=p(gl);eo=i(Ur,"This notebook showed how to perform distributed training from inside of a Jupyter Notebook. Some key notes to remember:"),Ur.forEach(l),Ka=M(e),A=o(e,"UL",{});var Rl=p(A);El=o(Rl,"LI",{});var co=p(El);lo=i(co,"Make sure to save any code that use CUDA (or CUDA imports) for the function passed to "),Nl=o(co,"A",{href:!0});var br=p(Nl);so=i(br,"notebook_launcher()"),br.forEach(l),co.forEach(l),ao=M(Rl),Ke=o(Rl,"LI",{});var mt=p(Ke);to=i(mt,"Set the "),Ms=o(mt,"CODE",{});var jr=p(Ms);no=i(jr,"num_processes"),jr.forEach(l),oo=i(mt," to be the number of devices used for training (such as number of GPUs, CPUs, TPUs, etc)"),mt.forEach(l),ro=M(Rl),ms=o(Rl,"LI",{});var Ir=p(ms);io=i(Ir,"If using the TPU, declare your model outside the training loop function"),Ir.forEach(l),Rl.forEach(l),this.h()},h(){T(m,"name","hf:doc:metadata"),T(m,"content",JSON.stringify(Yr)),T(U,"id","launching-multigpu-training-from-a-jupyter-environment"),T(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(U,"href","#launching-multigpu-training-from-a-jupyter-environment"),T(h,"class","relative group"),T(F,"id","configuring-the-environment"),T(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(F,"href","#configuring-the-environment"),T(g,"class","relative group"),T(al,"href","/docs/accelerate/main/en/package_reference/utilities#accelerate.commands.config.default.write_basic_config"),T(z,"id","preparing-the-dataset-and-model"),T(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(z,"href","#preparing-the-dataset-and-model"),T(E,"class","relative group"),T(we,"href","https://github.com/huggingface/accelerate/tree/main/examples#simple-vision-example"),T(we,"rel","nofollow"),T(H,"id","writing-the-training-function"),T(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(H,"href","#writing-the-training-function"),T(N,"class","relative group"),T(Ml,"href","/docs/accelerate/main/en/package_reference/launchers#accelerate.notebook_launcher"),T(hl,"href","/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator"),T(dl,"href","/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare"),T(Il,"href","/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.gather"),T(Cl,"href","/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.print"),T(ae,"id","using-the-notebooklauncher"),T(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(ae,"href","#using-the-notebooklauncher"),T(Y,"class","relative group"),T(Zl,"href","/docs/accelerate/main/en/package_reference/launchers#accelerate.notebook_launcher"),T($l,"href","../package_reference/launchers"),T(re,"id","debugging"),T(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(re,"href","#debugging"),T(X,"class","relative group"),T(ie,"id","conclusion"),T(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),T(ie,"href","#conclusion"),T(R,"class","relative group"),T(Nl,"href","/docs/accelerate/main/en/package_reference/launchers#accelerate.notebook_launcher")},m(e,s){a(document.head,m),t(e,b,s),t(e,h,s),a(h,U),a(U,_),u(I,_,null),a(h,C),a(h,G),a(G,ht),t(e,fs,s),t(e,ll,s),a(ll,yt),t(e,ds,s),u(V,e,s),t(e,Ts,s),t(e,g,s),a(g,F),a(F,Vl),u(ce,Vl,null),a(g,wt),a(g,Fl),a(Fl,ut),t(e,Us,s),t(e,sl,s),a(sl,Jt),t(e,bs,s),u(Me,e,s),t(e,js,s),t(e,v,s),a(v,ft),a(v,Ql),a(Ql,dt),a(v,Tt),a(v,al),a(al,Ut),a(v,bt),t(e,Is,s),t(e,tl,s),a(tl,jt),t(e,Cs,s),u(Q,e,s),t(e,_s,s),u(me,e,s),t(e,Zs,s),t(e,E,s),a(E,z),a(z,zl),u(he,zl,null),a(E,It),a(E,Sl),a(Sl,Ct),t(e,$s,s),t(e,k,s),a(k,_t),a(k,xl),a(xl,Zt),a(k,$t),a(k,Hl),a(Hl,kt),a(k,Gt),a(k,Pl),a(Pl,vt),a(k,Wt),t(e,ks,s),t(e,nl,s),a(nl,At),t(e,Gs,s),t(e,ye,s),a(ye,Bt),a(ye,we),a(we,gt),t(e,vs,s),u(ue,e,s),t(e,Ws,s),t(e,ol,s),a(ol,Et),t(e,As,s),u(Je,e,s),t(e,Bs,s),u(fe,e,s),t(e,gs,s),t(e,S,s),a(S,Nt),a(S,Dl),a(Dl,Yt),a(S,Xt),t(e,Es,s),u(de,e,s),t(e,Ns,s),u(Te,e,s),t(e,Ys,s),t(e,rl,s),a(rl,Rt),t(e,Xs,s),u(Ue,e,s),t(e,Rs,s),t(e,x,s),a(x,Vt),a(x,Kl),a(Kl,Ft),a(x,Qt),t(e,Vs,s),u(be,e,s),t(e,Fs,s),t(e,il,s),a(il,zt),t(e,Qs,s),u(je,e,s),t(e,zs,s),t(e,pl,s),a(pl,St),t(e,Ss,s),u(Ie,e,s),t(e,xs,s),t(e,W,s),a(W,xt),a(W,ql),a(ql,Ht),a(W,Pt),a(W,Ll),a(Ll,Dt),a(W,Kt),t(e,Hs,s),u(Ce,e,s),t(e,Ps,s),t(e,cl,s),a(cl,qt),t(e,Ds,s),u(_e,e,s),t(e,Ks,s),t(e,N,s),a(N,H),a(H,Ol),u(Ze,Ol,null),a(N,Lt),a(N,es),a(es,Ot),t(e,qs,s),t(e,P,s),a(P,en),a(P,Ml),a(Ml,ln),a(P,sn),t(e,Ls,s),t(e,ml,s),a(ml,an),t(e,Os,s),u(D,e,s),t(e,ea,s),u($e,e,s),t(e,la,s),t(e,K,s),a(K,tn),a(K,hl),a(hl,nn),a(K,on),t(e,sa,s),u(q,e,s),t(e,aa,s),t(e,yl,s),a(yl,rn),t(e,ta,s),u(ke,e,s),t(e,na,s),u(L,e,s),t(e,oa,s),t(e,wl,s),a(wl,pn),t(e,ra,s),u(Ge,e,s),t(e,ia,s),t(e,ul,s),a(ul,cn),t(e,pa,s),u(ve,e,s),t(e,ca,s),t(e,Jl,s),a(Jl,Mn),t(e,Ma,s),u(We,e,s),t(e,ma,s),t(e,fl,s),a(fl,mn),t(e,ha,s),u(Ae,e,s),t(e,ya,s),t(e,O,s),a(O,hn),a(O,dl),a(dl,yn),a(O,wn),t(e,wa,s),u(ee,e,s),t(e,ua,s),u(Be,e,s),t(e,Ja,s),t(e,Tl,s),a(Tl,un),t(e,fa,s),u(ge,e,s),t(e,da,s),t(e,Ul,s),a(Ul,Jn),t(e,Ta,s),u(Ee,e,s),t(e,Ua,s),t(e,bl,s),a(bl,fn),t(e,ba,s),u(Ne,e,s),t(e,ja,s),t(e,jl,s),a(jl,dn),t(e,Ia,s),t(e,le,s),a(le,Tn),a(le,Il),a(Il,Un),a(le,bn),t(e,Ca,s),u(Ye,e,s),t(e,_a,s),t(e,se,s),a(se,jn),a(se,Cl),a(Cl,In),a(se,Cn),t(e,Za,s),u(Xe,e,s),t(e,$a,s),t(e,_l,s),a(_l,_n),t(e,ka,s),u(Re,e,s),t(e,Ga,s),t(e,Y,s),a(Y,ae),a(ae,ls),u(Ve,ls,null),a(Y,Zn),a(Y,ss),a(ss,$n),t(e,va,s),t(e,te,s),a(te,kn),a(te,Zl),a(Zl,Gn),a(te,vn),t(e,Wa,s),t(e,ne,s),a(ne,Wn),a(ne,$l),a($l,An),a(ne,Bn),t(e,Aa,s),u(Fe,e,s),t(e,Ba,s),u(Qe,e,s),t(e,ga,s),t(e,kl,s),a(kl,gn),t(e,Ea,s),t(e,Gl,s),a(Gl,En),t(e,Na,s),u(ze,e,s),t(e,Ya,s),t(e,vl,s),a(vl,Nn),t(e,Xa,s),u(oe,e,s),t(e,Ra,s),u(Se,e,s),t(e,Va,s),t(e,Wl,s),a(Wl,Yn),t(e,Fa,s),u(xe,e,s),t(e,Qa,s),t(e,Al,s),a(Al,Xn),t(e,za,s),u(He,e,s),t(e,Sa,s),t(e,Bl,s),a(Bl,Rn),t(e,xa,s),t(e,X,s),a(X,re),a(re,as),u(Pe,as,null),a(X,Vn),a(X,ts),a(ts,Fn),t(e,Ha,s),t(e,$,s),a($,Qn),a($,ns),a(ns,zn),a($,Sn),a($,os),a(os,xn),a($,Hn),a($,rs),a(rs,Pn),a($,Dn),a($,is),a(is,Kn),a($,qn),t(e,Pa,s),t(e,R,s),a(R,ie),a(ie,ps),u(De,ps,null),a(R,Ln),a(R,cs),a(cs,On),t(e,Da,s),t(e,gl,s),a(gl,eo),t(e,Ka,s),t(e,A,s),a(A,El),a(El,lo),a(El,Nl),a(Nl,so),a(A,ao),a(A,Ke),a(Ke,to),a(Ke,Ms),a(Ms,no),a(Ke,oo),a(A,ro),a(A,ms),a(ms,io),qa=!0},p(e,[s]){const qe={};s&2&&(qe.$$scope={dirty:s,ctx:e}),V.$set(qe);const hs={};s&2&&(hs.$$scope={dirty:s,ctx:e}),Q.$set(hs);const ys={};s&2&&(ys.$$scope={dirty:s,ctx:e}),D.$set(ys);const ws={};s&2&&(ws.$$scope={dirty:s,ctx:e}),q.$set(ws);const us={};s&2&&(us.$$scope={dirty:s,ctx:e}),L.$set(us);const Le={};s&2&&(Le.$$scope={dirty:s,ctx:e}),ee.$set(Le);const Js={};s&2&&(Js.$$scope={dirty:s,ctx:e}),oe.$set(Js)},i(e){qa||(J(I.$$.fragment,e),J(V.$$.fragment,e),J(ce.$$.fragment,e),J(Me.$$.fragment,e),J(Q.$$.fragment,e),J(me.$$.fragment,e),J(he.$$.fragment,e),J(ue.$$.fragment,e),J(Je.$$.fragment,e),J(fe.$$.fragment,e),J(de.$$.fragment,e),J(Te.$$.fragment,e),J(Ue.$$.fragment,e),J(be.$$.fragment,e),J(je.$$.fragment,e),J(Ie.$$.fragment,e),J(Ce.$$.fragment,e),J(_e.$$.fragment,e),J(Ze.$$.fragment,e),J(D.$$.fragment,e),J($e.$$.fragment,e),J(q.$$.fragment,e),J(ke.$$.fragment,e),J(L.$$.fragment,e),J(Ge.$$.fragment,e),J(ve.$$.fragment,e),J(We.$$.fragment,e),J(Ae.$$.fragment,e),J(ee.$$.fragment,e),J(Be.$$.fragment,e),J(ge.$$.fragment,e),J(Ee.$$.fragment,e),J(Ne.$$.fragment,e),J(Ye.$$.fragment,e),J(Xe.$$.fragment,e),J(Re.$$.fragment,e),J(Ve.$$.fragment,e),J(Fe.$$.fragment,e),J(Qe.$$.fragment,e),J(ze.$$.fragment,e),J(oe.$$.fragment,e),J(Se.$$.fragment,e),J(xe.$$.fragment,e),J(He.$$.fragment,e),J(Pe.$$.fragment,e),J(De.$$.fragment,e),qa=!0)},o(e){f(I.$$.fragment,e),f(V.$$.fragment,e),f(ce.$$.fragment,e),f(Me.$$.fragment,e),f(Q.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(Je.$$.fragment,e),f(fe.$$.fragment,e),f(de.$$.fragment,e),f(Te.$$.fragment,e),f(Ue.$$.fragment,e),f(be.$$.fragment,e),f(je.$$.fragment,e),f(Ie.$$.fragment,e),f(Ce.$$.fragment,e),f(_e.$$.fragment,e),f(Ze.$$.fragment,e),f(D.$$.fragment,e),f($e.$$.fragment,e),f(q.$$.fragment,e),f(ke.$$.fragment,e),f(L.$$.fragment,e),f(Ge.$$.fragment,e),f(ve.$$.fragment,e),f(We.$$.fragment,e),f(Ae.$$.fragment,e),f(ee.$$.fragment,e),f(Be.$$.fragment,e),f(ge.$$.fragment,e),f(Ee.$$.fragment,e),f(Ne.$$.fragment,e),f(Ye.$$.fragment,e),f(Xe.$$.fragment,e),f(Re.$$.fragment,e),f(Ve.$$.fragment,e),f(Fe.$$.fragment,e),f(Qe.$$.fragment,e),f(ze.$$.fragment,e),f(oe.$$.fragment,e),f(Se.$$.fragment,e),f(xe.$$.fragment,e),f(He.$$.fragment,e),f(Pe.$$.fragment,e),f(De.$$.fragment,e),qa=!1},d(e){l(m),e&&l(b),e&&l(h),d(I),e&&l(fs),e&&l(ll),e&&l(ds),d(V,e),e&&l(Ts),e&&l(g),d(ce),e&&l(Us),e&&l(sl),e&&l(bs),d(Me,e),e&&l(js),e&&l(v),e&&l(Is),e&&l(tl),e&&l(Cs),d(Q,e),e&&l(_s),d(me,e),e&&l(Zs),e&&l(E),d(he),e&&l($s),e&&l(k),e&&l(ks),e&&l(nl),e&&l(Gs),e&&l(ye),e&&l(vs),d(ue,e),e&&l(Ws),e&&l(ol),e&&l(As),d(Je,e),e&&l(Bs),d(fe,e),e&&l(gs),e&&l(S),e&&l(Es),d(de,e),e&&l(Ns),d(Te,e),e&&l(Ys),e&&l(rl),e&&l(Xs),d(Ue,e),e&&l(Rs),e&&l(x),e&&l(Vs),d(be,e),e&&l(Fs),e&&l(il),e&&l(Qs),d(je,e),e&&l(zs),e&&l(pl),e&&l(Ss),d(Ie,e),e&&l(xs),e&&l(W),e&&l(Hs),d(Ce,e),e&&l(Ps),e&&l(cl),e&&l(Ds),d(_e,e),e&&l(Ks),e&&l(N),d(Ze),e&&l(qs),e&&l(P),e&&l(Ls),e&&l(ml),e&&l(Os),d(D,e),e&&l(ea),d($e,e),e&&l(la),e&&l(K),e&&l(sa),d(q,e),e&&l(aa),e&&l(yl),e&&l(ta),d(ke,e),e&&l(na),d(L,e),e&&l(oa),e&&l(wl),e&&l(ra),d(Ge,e),e&&l(ia),e&&l(ul),e&&l(pa),d(ve,e),e&&l(ca),e&&l(Jl),e&&l(Ma),d(We,e),e&&l(ma),e&&l(fl),e&&l(ha),d(Ae,e),e&&l(ya),e&&l(O),e&&l(wa),d(ee,e),e&&l(ua),d(Be,e),e&&l(Ja),e&&l(Tl),e&&l(fa),d(ge,e),e&&l(da),e&&l(Ul),e&&l(Ta),d(Ee,e),e&&l(Ua),e&&l(bl),e&&l(ba),d(Ne,e),e&&l(ja),e&&l(jl),e&&l(Ia),e&&l(le),e&&l(Ca),d(Ye,e),e&&l(_a),e&&l(se),e&&l(Za),d(Xe,e),e&&l($a),e&&l(_l),e&&l(ka),d(Re,e),e&&l(Ga),e&&l(Y),d(Ve),e&&l(va),e&&l(te),e&&l(Wa),e&&l(ne),e&&l(Aa),d(Fe,e),e&&l(Ba),d(Qe,e),e&&l(ga),e&&l(kl),e&&l(Ea),e&&l(Gl),e&&l(Na),d(ze,e),e&&l(Ya),e&&l(vl),e&&l(Xa),d(oe,e),e&&l(Ra),d(Se,e),e&&l(Va),e&&l(Wl),e&&l(Fa),d(xe,e),e&&l(Qa),e&&l(Al),e&&l(za),d(He,e),e&&l(Sa),e&&l(Bl),e&&l(xa),e&&l(X),d(Pe),e&&l(Ha),e&&l($),e&&l(Pa),e&&l(R),d(De),e&&l(Da),e&&l(gl),e&&l(Ka),e&&l(A)}}}const Yr={local:"launching-multigpu-training-from-a-jupyter-environment",sections:[{local:"configuring-the-environment",title:"Configuring the Environment"},{local:"preparing-the-dataset-and-model",title:"Preparing the Dataset and Model"},{local:"writing-the-training-function",title:"Writing the Training Function"},{local:"using-the-notebooklauncher",title:"Using the notebook_launcher"},{local:"debugging",title:"Debugging "},{local:"conclusion",title:"Conclusion"}],title:"Launching Multi-GPU Training from a Jupyter Environment"};function Xr(Z){return kr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zr extends Cr{constructor(m){super();_r(this,m,Xr,Nr,Zr,{})}}export{zr as default,Yr as metadata};
