import{s as ht,n as wt,o as Mt}from"../chunks/scheduler.d627b047.js";import{S as gt,i as bt,g as s,s as i,r as p,A as yt,h as o,f as l,c as n,j as ct,u as r,x as u,k as ut,l as $t,y as Tt,a,v as m,d,t as f,w as c}from"../chunks/index.73c51727.js";import{C as h}from"../chunks/CodeBlock.5f78c87f.js";import{H as M,E as _t}from"../chunks/index.ae6fdc64.js";function Ut(Qe){let w,ne,ae,se,b,oe,y,Se=`The notebooks and scripts in this examples show how to use Low Rank Adaptation (LoRA) to fine-tune models in a memory efficient manner. Most of PEFT methods supported in peft library but note that some PEFT methods such as Prompt tuning are not supported.
For more information on LoRA, see the <a href="https://huggingface.co/papers/2106.09685" rel="nofollow">original paper</a>.`,pe,$,ze='Here’s an overview of the <code>peft</code>-enabled notebooks and scripts in the <a href="https://github.com/huggingface/trl/tree/main/examples" rel="nofollow">trl repository</a>:',re,T,De='<thead><tr><th>File</th> <th>Task</th> <th>Description</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/rl_training.py" rel="nofollow"><code>stack_llama/rl_training.py</code></a></td> <td>RLHF</td> <td>Distributed fine-tuning of the 7b parameter LLaMA models with a learned reward model and <code>peft</code>.</td></tr> <tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/reward_modeling.py" rel="nofollow"><code>stack_llama/reward_modeling.py</code></a></td> <td>Reward Modeling</td> <td>Distributed training of the 7b parameter LLaMA reward model with <code>peft</code>.</td></tr> <tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>stack_llama/supervised_finetuning.py</code></a></td> <td>SFT</td> <td>Distributed instruction/supervised fine-tuning of the 7b parameter LLaMA model with <code>peft</code>.</td></tr></tbody>',me,_,de,U,qe=`Note: peft is in active development, so we install directly from their Github page.
Peft also relies on the latest version of transformers.`,fe,Z,ce,J,Ke='Note: if you don’t want to log with <code>wandb</code> remove <code>log_with=&quot;wandb&quot;</code> in the scripts/notebooks. You can also replace it with your favourite experiment tracker that’s <a href="https://huggingface.co/docs/accelerate/usage_guides/tracking" rel="nofollow">supported by <code>accelerate</code></a>.',ue,v,he,C,Oe="Simply declare a <code>PeftConfig</code> object in your script and pass it through <code>.from_pretrained</code> to load the TRL+PEFT model.",we,j,Me,W,et="And if you want to load your model in 8bit precision:",ge,H,be,L,tt="… or in 4bit precision:",ye,G,$e,x,Te,k,lt="The <code>trl</code> library is powered by <code>accelerate</code>. As such it is best to configure and launch trainings with the following commands:",_e,B,Ue,N,Ze,F,at="You can scale up to as many GPUs as you want, as long as you are able to fit the training process in a single device. The only tweak you need to apply is to load the model as follows:",Je,A,ve,R,it="And if you want to load your model in 8bit precision:",Ce,I,je,Y,nt="… or in 4bit precision:",We,P,He,V,st="Finally, make sure that the rewards are computed on correct device as well, for that you can use <code>ppo_trainer.model.current_device</code>.",Le,E,Ge,X,ot=`The <code>trl</code> library also supports naive pipeline parallelism (NPP) for large models (&gt;60B models). This is a simple way to parallelize the model across multiple GPUs.
This paradigm, termed as “Naive Pipeline Parallelism” (NPP) is a simple way to parallelize the model across multiple GPUs. We load the model and the adapters across multiple GPUs and the activations and gradients will be naively communicated across the GPUs. This supports <code>int8</code> models as well as other <code>dtype</code> models.`,xe,g,pt='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/trl-npp.png"/>',ke,Q,Be,S,rt='Simply load your model with a custom <code>device_map</code> argument on the <code>from_pretrained</code> to split your model across multiple devices. Check out this <a href="https://github.com/huggingface/blog/blob/main/accelerate-large-models.md" rel="nofollow">nice tutorial</a> on how to properly create a <code>device_map</code> for your model.',Ne,z,mt="Also make sure to have the <code>lm_head</code> module on the first GPU device as it may throw an error if it is not on the first device. As this time of writing, you need to install the <code>main</code> branch of <code>accelerate</code>: <code>pip install git+https://github.com/huggingface/accelerate.git@main</code> and <code>peft</code>: <code>pip install git+https://github.com/huggingface/peft.git@main</code>.",Fe,D,Ae,q,dt="Although <code>trl</code> library is powered by <code>accelerate</code>, you should run your training script in a single process. Note that we do not support Data Parallelism together with NPP yet.",Re,K,Ie,O,Ye,ee,ft="You can easily fine-tune Llama2 model using <code>SFTTrainer</code> and the official script! For example to fine-tune llama2-7b on the Guanaco dataset, run (tested on a single NVIDIA T4-16GB):",Pe,te,Ve,le,Ee,ie,Xe;return b=new M({props:{title:"Examples of using peft with trl to finetune 8-bit models with Low Rank Adaption (LoRA)",local:"examples-of-using-peft-with-trl-to-finetune-8-bit-models-with-low-rank-adaption-lora",headingTag:"h1"}}),_=new M({props:{title:"Installation",local:"installation",headingTag:"h2"}}),Z=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRybCU1QnBlZnQlNUQlMEFwaXAlMjBpbnN0YWxsJTIwYml0c2FuZGJ5dGVzJTIwbG9yYWxpYiUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQlNDBtYWluJTBBJTIzb3B0aW9uYWwlM0ElMjB3YW5kYiUwQXBpcCUyMGluc3RhbGwlMjB3YW5kYg==",highlighted:`pip install trl[peft]
pip install bitsandbytes loralib
pip install git+https://github.com/huggingface/transformers.git@main
<span class="hljs-comment">#optional: wandb</span>
pip install wandb`,wrap:!1}}),v=new M({props:{title:"How to use it?",local:"how-to-use-it",headingTag:"h2"}}),j=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZWRiZWVjaGluZyUyRmdwdC1uZW8tMTI1TS1pbWRiJTIyJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead

model_id = <span class="hljs-string">&quot;edbeeching/gpt-neo-125M-imdb&quot;</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLMWithValueHead.from_pretrained(
    model_id, 
    peft_config=lora_config,
)`,wrap:!1}}),H=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    load_in_8bit=<span class="hljs-literal">True</span>,
    peft_config=lora_config,
)`,wrap:!1}}),G=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_4bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),x=new M({props:{title:"Launch scripts",local:"launch-scripts",headingTag:"h2"}}),B=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMCUyMyUyMHdpbGwlMjBwcm9tcHQlMjB5b3UlMjB0byUyMGRlZmluZSUyMHRoZSUyMHRyYWluaW5nJTIwY29uZmlndXJhdGlvbiUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjBleGFtcGxlcyUyRnNjcmlwdHMlMkZwcG8ucHklMjAtLXVzZV9wZWZ0JTIwJTIzJTIwbGF1bmNoJTYwZXMlMjB0cmFpbmluZw==",highlighted:'accelerate config <span class="hljs-comment"># will prompt you to define the training configuration</span>\naccelerate launch examples/scripts/ppo.py --use_peft <span class="hljs-comment"># launch`es training</span>',wrap:!1}}),N=new M({props:{title:"Using trl + peft and Data Parallelism",local:"using-trl--peft-and-data-parallelism",headingTag:"h2"}}),A=new h({props:{code:"JTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
...

lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
)`,wrap:!1}}),I=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_8bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),P=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_4bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),E=new M({props:{title:"Naive pipeline parallelism (NPP) for large models (>60B models)",local:"naive-pipeline-parallelism-npp-for-large-models-60b-models",headingTag:"h2"}}),Q=new M({props:{title:"How to use NPP?",local:"how-to-use-npp",headingTag:"h3"}}),D=new M({props:{title:"Launch scripts",local:"launch-scripts",headingTag:"h3"}}),K=new h({props:{code:"cHl0aG9uJTIwUEFUSF9UT19TQ1JJUFQ=",highlighted:"python PATH_TO_SCRIPT",wrap:!1}}),O=new M({props:{title:"Fine-tuning Llama-2 model",local:"fine-tuning-llama-2-model",headingTag:"h2"}}),te=new h({props:{code:"cHl0aG9uJTIwdHJsJTJGc2NyaXB0cyUyRnNmdC5weSUyMC0tb3V0cHV0X2RpciUyMHNmdF9vcGVuYXNzaXN0YW50LWd1YW5hY28lMjAlMjAtLW1vZGVsX25hbWUlMjBtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMC0tZGF0YXNldF9uYW1lJTIwdGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjAtLWxvYWRfaW5fNGJpdCUyMC0tdXNlX3BlZnQlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDI=",highlighted:"python trl/scripts/sft.py --output_dir sft_openassistant-guanaco  --model_name meta-llama/Llama-2-7b-hf --dataset_name timdettmers/openassistant-guanaco --load_in_4bit --use_peft --per_device_train_batch_size 4 --gradient_accumulation_steps 2",wrap:!1}}),le=new _t({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/peft_integration.md"}}),{c(){w=s("meta"),ne=i(),ae=s("p"),se=i(),p(b.$$.fragment),oe=i(),y=s("p"),y.innerHTML=Se,pe=i(),$=s("p"),$.innerHTML=ze,re=i(),T=s("table"),T.innerHTML=De,me=i(),p(_.$$.fragment),de=i(),U=s("p"),U.textContent=qe,fe=i(),p(Z.$$.fragment),ce=i(),J=s("p"),J.innerHTML=Ke,ue=i(),p(v.$$.fragment),he=i(),C=s("p"),C.innerHTML=Oe,we=i(),p(j.$$.fragment),Me=i(),W=s("p"),W.textContent=et,ge=i(),p(H.$$.fragment),be=i(),L=s("p"),L.textContent=tt,ye=i(),p(G.$$.fragment),$e=i(),p(x.$$.fragment),Te=i(),k=s("p"),k.innerHTML=lt,_e=i(),p(B.$$.fragment),Ue=i(),p(N.$$.fragment),Ze=i(),F=s("p"),F.textContent=at,Je=i(),p(A.$$.fragment),ve=i(),R=s("p"),R.textContent=it,Ce=i(),p(I.$$.fragment),je=i(),Y=s("p"),Y.textContent=nt,We=i(),p(P.$$.fragment),He=i(),V=s("p"),V.innerHTML=st,Le=i(),p(E.$$.fragment),Ge=i(),X=s("p"),X.innerHTML=ot,xe=i(),g=s("div"),g.innerHTML=pt,ke=i(),p(Q.$$.fragment),Be=i(),S=s("p"),S.innerHTML=rt,Ne=i(),z=s("p"),z.innerHTML=mt,Fe=i(),p(D.$$.fragment),Ae=i(),q=s("p"),q.innerHTML=dt,Re=i(),p(K.$$.fragment),Ie=i(),p(O.$$.fragment),Ye=i(),ee=s("p"),ee.innerHTML=ft,Pe=i(),p(te.$$.fragment),Ve=i(),p(le.$$.fragment),Ee=i(),ie=s("p"),this.h()},l(e){const t=yt("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),ne=n(e),ae=o(e,"P",{}),ct(ae).forEach(l),se=n(e),r(b.$$.fragment,e),oe=n(e),y=o(e,"P",{"data-svelte-h":!0}),u(y)!=="svelte-pudqgq"&&(y.innerHTML=Se),pe=n(e),$=o(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1mehpt8"&&($.innerHTML=ze),re=n(e),T=o(e,"TABLE",{"data-svelte-h":!0}),u(T)!=="svelte-5tx68h"&&(T.innerHTML=De),me=n(e),r(_.$$.fragment,e),de=n(e),U=o(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-1xrpojm"&&(U.textContent=qe),fe=n(e),r(Z.$$.fragment,e),ce=n(e),J=o(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-vkwr34"&&(J.innerHTML=Ke),ue=n(e),r(v.$$.fragment,e),he=n(e),C=o(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-hndmna"&&(C.innerHTML=Oe),we=n(e),r(j.$$.fragment,e),Me=n(e),W=o(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-lllysa"&&(W.textContent=et),ge=n(e),r(H.$$.fragment,e),be=n(e),L=o(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-fsazu1"&&(L.textContent=tt),ye=n(e),r(G.$$.fragment,e),$e=n(e),r(x.$$.fragment,e),Te=n(e),k=o(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1dq9zm0"&&(k.innerHTML=lt),_e=n(e),r(B.$$.fragment,e),Ue=n(e),r(N.$$.fragment,e),Ze=n(e),F=o(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-5gjozh"&&(F.textContent=at),Je=n(e),r(A.$$.fragment,e),ve=n(e),R=o(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-lllysa"&&(R.textContent=it),Ce=n(e),r(I.$$.fragment,e),je=n(e),Y=o(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-fsazu1"&&(Y.textContent=nt),We=n(e),r(P.$$.fragment,e),He=n(e),V=o(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-bxfofv"&&(V.innerHTML=st),Le=n(e),r(E.$$.fragment,e),Ge=n(e),X=o(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1wvtyh7"&&(X.innerHTML=ot),xe=n(e),g=o(e,"DIV",{style:!0,"data-svelte-h":!0}),u(g)!=="svelte-kmxeea"&&(g.innerHTML=pt),ke=n(e),r(Q.$$.fragment,e),Be=n(e),S=o(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-baerbw"&&(S.innerHTML=rt),Ne=n(e),z=o(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-pr8lox"&&(z.innerHTML=mt),Fe=n(e),r(D.$$.fragment,e),Ae=n(e),q=o(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-qlesp3"&&(q.innerHTML=dt),Re=n(e),r(K.$$.fragment,e),Ie=n(e),r(O.$$.fragment,e),Ye=n(e),ee=o(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-98ab3u"&&(ee.innerHTML=ft),Pe=n(e),r(te.$$.fragment,e),Ve=n(e),r(le.$$.fragment,e),Ee=n(e),ie=o(e,"P",{}),ct(ie).forEach(l),this.h()},h(){ut(w,"name","hf:doc:metadata"),ut(w,"content",Zt),$t(g,"text-align","center")},m(e,t){Tt(document.head,w),a(e,ne,t),a(e,ae,t),a(e,se,t),m(b,e,t),a(e,oe,t),a(e,y,t),a(e,pe,t),a(e,$,t),a(e,re,t),a(e,T,t),a(e,me,t),m(_,e,t),a(e,de,t),a(e,U,t),a(e,fe,t),m(Z,e,t),a(e,ce,t),a(e,J,t),a(e,ue,t),m(v,e,t),a(e,he,t),a(e,C,t),a(e,we,t),m(j,e,t),a(e,Me,t),a(e,W,t),a(e,ge,t),m(H,e,t),a(e,be,t),a(e,L,t),a(e,ye,t),m(G,e,t),a(e,$e,t),m(x,e,t),a(e,Te,t),a(e,k,t),a(e,_e,t),m(B,e,t),a(e,Ue,t),m(N,e,t),a(e,Ze,t),a(e,F,t),a(e,Je,t),m(A,e,t),a(e,ve,t),a(e,R,t),a(e,Ce,t),m(I,e,t),a(e,je,t),a(e,Y,t),a(e,We,t),m(P,e,t),a(e,He,t),a(e,V,t),a(e,Le,t),m(E,e,t),a(e,Ge,t),a(e,X,t),a(e,xe,t),a(e,g,t),a(e,ke,t),m(Q,e,t),a(e,Be,t),a(e,S,t),a(e,Ne,t),a(e,z,t),a(e,Fe,t),m(D,e,t),a(e,Ae,t),a(e,q,t),a(e,Re,t),m(K,e,t),a(e,Ie,t),m(O,e,t),a(e,Ye,t),a(e,ee,t),a(e,Pe,t),m(te,e,t),a(e,Ve,t),m(le,e,t),a(e,Ee,t),a(e,ie,t),Xe=!0},p:wt,i(e){Xe||(d(b.$$.fragment,e),d(_.$$.fragment,e),d(Z.$$.fragment,e),d(v.$$.fragment,e),d(j.$$.fragment,e),d(H.$$.fragment,e),d(G.$$.fragment,e),d(x.$$.fragment,e),d(B.$$.fragment,e),d(N.$$.fragment,e),d(A.$$.fragment,e),d(I.$$.fragment,e),d(P.$$.fragment,e),d(E.$$.fragment,e),d(Q.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),Xe=!0)},o(e){f(b.$$.fragment,e),f(_.$$.fragment,e),f(Z.$$.fragment,e),f(v.$$.fragment,e),f(j.$$.fragment,e),f(H.$$.fragment,e),f(G.$$.fragment,e),f(x.$$.fragment,e),f(B.$$.fragment,e),f(N.$$.fragment,e),f(A.$$.fragment,e),f(I.$$.fragment,e),f(P.$$.fragment,e),f(E.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),Xe=!1},d(e){e&&(l(ne),l(ae),l(se),l(oe),l(y),l(pe),l($),l(re),l(T),l(me),l(de),l(U),l(fe),l(ce),l(J),l(ue),l(he),l(C),l(we),l(Me),l(W),l(ge),l(be),l(L),l(ye),l($e),l(Te),l(k),l(_e),l(Ue),l(Ze),l(F),l(Je),l(ve),l(R),l(Ce),l(je),l(Y),l(We),l(He),l(V),l(Le),l(Ge),l(X),l(xe),l(g),l(ke),l(Be),l(S),l(Ne),l(z),l(Fe),l(Ae),l(q),l(Re),l(Ie),l(Ye),l(ee),l(Pe),l(Ve),l(Ee),l(ie)),l(w),c(b,e),c(_,e),c(Z,e),c(v,e),c(j,e),c(H,e),c(G,e),c(x,e),c(B,e),c(N,e),c(A,e),c(I,e),c(P,e),c(E,e),c(Q,e),c(D,e),c(K,e),c(O,e),c(te,e),c(le,e)}}}const Zt='{"title":"Examples of using peft with trl to finetune 8-bit models with Low Rank Adaption (LoRA)","local":"examples-of-using-peft-with-trl-to-finetune-8-bit-models-with-low-rank-adaption-lora","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"How to use it?","local":"how-to-use-it","sections":[],"depth":2},{"title":"Launch scripts","local":"launch-scripts","sections":[],"depth":2},{"title":"Using trl + peft and Data Parallelism","local":"using-trl--peft-and-data-parallelism","sections":[],"depth":2},{"title":"Naive pipeline parallelism (NPP) for large models (>60B models)","local":"naive-pipeline-parallelism-npp-for-large-models-60b-models","sections":[{"title":"How to use NPP?","local":"how-to-use-npp","sections":[],"depth":3},{"title":"Launch scripts","local":"launch-scripts","sections":[],"depth":3}],"depth":2},{"title":"Fine-tuning Llama-2 model","local":"fine-tuning-llama-2-model","sections":[],"depth":2}],"depth":1}';function Jt(Qe){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends gt{constructor(w){super(),bt(this,w,Jt,Ut,ht,{})}}export{Ht as component};
