import{s as fe,n as Te,o as he}from"../chunks/scheduler.d627b047.js";import{S as be,i as we,g as y,s,r,A as Ue,h as c,f as l,c as n,j as ue,u as i,x as k,k as Je,y as Ze,a,v as o,d as m,t as d,w as p}from"../chunks/index.73c51727.js";import{C as F}from"../chunks/CodeBlock.5f78c87f.js";import{H as G,E as je}from"../chunks/index.ae6fdc64.js";function Re(ie){let M,$,z,_,u,N,J,oe="TRL is designed with modularity in mind so that users to be able to efficiently customize the training loop for their needs. Below are some examples on how you can apply and test different techniques.  Note: Although these examples use the DPOTrainer, the customization applies to most (if not all) trainers.",v,f,Y,T,me="By default, the <code>DPOTrainer</code> creates a <code>torch.optim.AdamW</code> optimizer. You can create and define a different optimizer and pass it to <code>DPOTrainer</code> as follows:",A,h,H,b,S,w,de="You can also play with your training by adding learning rate schedulers.",D,U,L,Z,q,j,pe="Another tool you can use for more memory efficient fine-tuning is to share layers between the reference model and the model you want to train.",P,R,x,g,O,W,ye="Since <code>trl</code> supports all keyword arguments when loading a model from <code>transformers</code> using <code>from_pretrained</code>, you can also leverage <code>load_in_8bit</code> from <code>transformers</code> for more memory efficient fine-tuning.",K,C,ce='Read more about 8-bit model loading in <code>transformers</code> <a href="https://huggingface.co/docs/transformers/en/peft#load-in-8bit-or-4bit" rel="nofollow">here</a>.',ee,B,te,X,le,Q,Me="When training large models, you should better handle the CUDA cache by iteratively clearing it. To do so, simply pass <code>optimize_cuda_cache=True</code> to <code>DPOConfig</code>:",ae,I,se,V,ne,E,re;return u=new G({props:{title:"Training customization",local:"training-customization",headingTag:"h1"}}),f=new G({props:{title:"Use different optimizers and schedulers",local:"use-different-optimizers-and-schedulers",headingTag:"h2"}}),h=new F({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0b3JjaCUyMGltcG9ydCUyMG9wdGltJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMERQT0NvbmZpZyUyQyUyMERQT1RyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjIuNS0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi41LTAuNUItSW5zdHJ1Y3QlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGdWx0cmFmZWVkYmFja19iaW5hcml6ZWQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBEUE9Db25maWcob3V0cHV0X2RpciUzRCUyMlF3ZW4yLjUtMC41Qi1EUE8lMjIpJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uU0dEKG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNEdHJhaW5pbmdfYXJncy5sZWFybmluZ19yYXRlKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVycyUzRChvcHRpbWl6ZXIlMkMlMjBOb25lKSUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> optim
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
training_args = DPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2.5-0.5B-DPO&quot;</span>)

optimizer = optim.SGD(model.parameters(), lr=training_args.learning_rate)

trainer = DPOTrainer(
    model=model,
    args=training_args,
    train_dataset=dataset,
    tokenizer=tokenizer,
    optimizers=(optimizer, <span class="hljs-literal">None</span>),
)
trainer.train()`,wrap:!1}}),b=new G({props:{title:"Add a learning rate scheduler",local:"add-a-learning-rate-scheduler",headingTag:"h3"}}),U=new F({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0b3JjaCUyMGltcG9ydCUyMG9wdGltJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMERQT0NvbmZpZyUyQyUyMERQT1RyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjIuNS0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi41LTAuNUItSW5zdHJ1Y3QlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGdWx0cmFmZWVkYmFja19iaW5hcml6ZWQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBEUE9Db25maWcob3V0cHV0X2RpciUzRCUyMlF3ZW4yLjUtMC41Qi1EUE8lMjIpJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0R0cmFpbmluZ19hcmdzLmxlYXJuaW5nX3JhdGUpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwb3B0aW0ubHJfc2NoZWR1bGVyLlN0ZXBMUihvcHRpbWl6ZXIlMkMlMjBzdGVwX3NpemUlM0QzMCUyQyUyMGdhbW1hJTNEMC4xKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVycyUzRChvcHRpbWl6ZXIlMkMlMjBscl9zY2hlZHVsZXIpJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> optim
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
training_args = DPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2.5-0.5B-DPO&quot;</span>)

optimizer = optim.AdamW(model.parameters(), lr=training_args.learning_rate)
lr_scheduler = optim.lr_scheduler.StepLR(optimizer, step_size=<span class="hljs-number">30</span>, gamma=<span class="hljs-number">0.1</span>)

trainer = DPOTrainer(
    model=model,
    args=training_args,
    train_dataset=dataset,
    tokenizer=tokenizer,
    optimizers=(optimizer, lr_scheduler),
)
trainer.train()`,wrap:!1}}),Z=new G({props:{title:"Memory efficient fine-tuning by sharing layers",local:"memory-efficient-fine-tuning-by-sharing-layers",headingTag:"h2"}}),R=new F({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBjcmVhdGVfcmVmZXJlbmNlX21vZGVsJTJDJTIwRFBPQ29uZmlnJTJDJTIwRFBPVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi41LTAuNUItSW5zdHJ1Y3QlMjIpJTBBcmVmX21vZGVsJTIwJTNEJTIwY3JlYXRlX3JlZmVyZW5jZV9tb2RlbChtb2RlbCUyQyUyMG51bV9zaGFyZWRfbGF5ZXJzJTNENiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjIuNS0wLjVCLUluc3RydWN0JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydHJsLWxpYiUyRnVsdHJhZmVlZGJhY2tfYmluYXJpemVkJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTElMjUlNUQlMjIpJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyhvdXRwdXRfZGlyJTNEJTIyUXdlbjIuNS0wLjVCLURQTyUyMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwcmVmX21vZGVsJTNEcmVmX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> create_reference_model, DPOConfig, DPOTrainer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
ref_model = create_reference_model(model, num_shared_layers=<span class="hljs-number">6</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train[:1%]&quot;</span>)
training_args = DPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2.5-0.5B-DPO&quot;</span>)

trainer = DPOTrainer(
    model=model,
    ref_model=ref_model,
    args=training_args,
    train_dataset=dataset,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),g=new G({props:{title:"Pass 8-bit reference models",local:"pass-8-bit-reference-models",headingTag:"h2"}}),B=new F({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBEUE9Db25maWclMkMlMjBEUE9UcmFpbmVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLjUtMC41Qi1JbnN0cnVjdCUyMiklMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBcmVmX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi41LTAuNUItSW5zdHJ1Y3QlMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEJTIwcXVhbnRpemF0aW9uX2NvbmZpZyklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjIuNS0wLjVCLUluc3RydWN0JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydHJsLWxpYiUyRnVsdHJhZmVlZGJhY2tfYmluYXJpemVkJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwRFBPQ29uZmlnKG91dHB1dF9kaXIlM0QlMjJRd2VuMi41LTAuNUItRFBPJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByZWZfbW9kZWwlM0RyZWZfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
ref_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>, quantization_config= quantization_config)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
training_args = DPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2.5-0.5B-DPO&quot;</span>)

trainer = DPOTrainer(
    model=model,
    ref_model=ref_model,
    args=training_args,
    train_dataset=dataset,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),X=new G({props:{title:"Use the CUDA cache optimizer",local:"use-the-cuda-cache-optimizer",headingTag:"h2"}}),I=new F({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyguLi4lMkMlMjBvcHRpbWl6ZV9jdWRhX2NhY2hlJTNEVHJ1ZSk=",highlighted:'training_args = DPOConfig(..., optimize_cuda_cache=<span class="hljs-literal">True</span>)',wrap:!1}}),V=new je({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/customization.md"}}),{c(){M=y("meta"),$=s(),z=y("p"),_=s(),r(u.$$.fragment),N=s(),J=y("p"),J.textContent=oe,v=s(),r(f.$$.fragment),Y=s(),T=y("p"),T.innerHTML=me,A=s(),r(h.$$.fragment),H=s(),r(b.$$.fragment),S=s(),w=y("p"),w.textContent=de,D=s(),r(U.$$.fragment),L=s(),r(Z.$$.fragment),q=s(),j=y("p"),j.textContent=pe,P=s(),r(R.$$.fragment),x=s(),r(g.$$.fragment),O=s(),W=y("p"),W.innerHTML=ye,K=s(),C=y("p"),C.innerHTML=ce,ee=s(),r(B.$$.fragment),te=s(),r(X.$$.fragment),le=s(),Q=y("p"),Q.innerHTML=Me,ae=s(),r(I.$$.fragment),se=s(),r(V.$$.fragment),ne=s(),E=y("p"),this.h()},l(e){const t=Ue("svelte-u9bgzb",document.head);M=c(t,"META",{name:!0,content:!0}),t.forEach(l),$=n(e),z=c(e,"P",{}),ue(z).forEach(l),_=n(e),i(u.$$.fragment,e),N=n(e),J=c(e,"P",{"data-svelte-h":!0}),k(J)!=="svelte-13e1rz9"&&(J.textContent=oe),v=n(e),i(f.$$.fragment,e),Y=n(e),T=c(e,"P",{"data-svelte-h":!0}),k(T)!=="svelte-mc250"&&(T.innerHTML=me),A=n(e),i(h.$$.fragment,e),H=n(e),i(b.$$.fragment,e),S=n(e),w=c(e,"P",{"data-svelte-h":!0}),k(w)!=="svelte-gsqx31"&&(w.textContent=de),D=n(e),i(U.$$.fragment,e),L=n(e),i(Z.$$.fragment,e),q=n(e),j=c(e,"P",{"data-svelte-h":!0}),k(j)!=="svelte-hswwhh"&&(j.textContent=pe),P=n(e),i(R.$$.fragment,e),x=n(e),i(g.$$.fragment,e),O=n(e),W=c(e,"P",{"data-svelte-h":!0}),k(W)!=="svelte-orby5n"&&(W.innerHTML=ye),K=n(e),C=c(e,"P",{"data-svelte-h":!0}),k(C)!=="svelte-11ft3oj"&&(C.innerHTML=ce),ee=n(e),i(B.$$.fragment,e),te=n(e),i(X.$$.fragment,e),le=n(e),Q=c(e,"P",{"data-svelte-h":!0}),k(Q)!=="svelte-xeg2g6"&&(Q.innerHTML=Me),ae=n(e),i(I.$$.fragment,e),se=n(e),i(V.$$.fragment,e),ne=n(e),E=c(e,"P",{}),ue(E).forEach(l),this.h()},h(){Je(M,"name","hf:doc:metadata"),Je(M,"content",ge)},m(e,t){Ze(document.head,M),a(e,$,t),a(e,z,t),a(e,_,t),o(u,e,t),a(e,N,t),a(e,J,t),a(e,v,t),o(f,e,t),a(e,Y,t),a(e,T,t),a(e,A,t),o(h,e,t),a(e,H,t),o(b,e,t),a(e,S,t),a(e,w,t),a(e,D,t),o(U,e,t),a(e,L,t),o(Z,e,t),a(e,q,t),a(e,j,t),a(e,P,t),o(R,e,t),a(e,x,t),o(g,e,t),a(e,O,t),a(e,W,t),a(e,K,t),a(e,C,t),a(e,ee,t),o(B,e,t),a(e,te,t),o(X,e,t),a(e,le,t),a(e,Q,t),a(e,ae,t),o(I,e,t),a(e,se,t),o(V,e,t),a(e,ne,t),a(e,E,t),re=!0},p:Te,i(e){re||(m(u.$$.fragment,e),m(f.$$.fragment,e),m(h.$$.fragment,e),m(b.$$.fragment,e),m(U.$$.fragment,e),m(Z.$$.fragment,e),m(R.$$.fragment,e),m(g.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(I.$$.fragment,e),m(V.$$.fragment,e),re=!0)},o(e){d(u.$$.fragment,e),d(f.$$.fragment,e),d(h.$$.fragment,e),d(b.$$.fragment,e),d(U.$$.fragment,e),d(Z.$$.fragment,e),d(R.$$.fragment,e),d(g.$$.fragment,e),d(B.$$.fragment,e),d(X.$$.fragment,e),d(I.$$.fragment,e),d(V.$$.fragment,e),re=!1},d(e){e&&(l($),l(z),l(_),l(N),l(J),l(v),l(Y),l(T),l(A),l(H),l(S),l(w),l(D),l(L),l(q),l(j),l(P),l(x),l(O),l(W),l(K),l(C),l(ee),l(te),l(le),l(Q),l(ae),l(se),l(ne),l(E)),l(M),p(u,e),p(f,e),p(h,e),p(b,e),p(U,e),p(Z,e),p(R,e),p(g,e),p(B,e),p(X,e),p(I,e),p(V,e)}}}const ge='{"title":"Training customization","local":"training-customization","sections":[{"title":"Use different optimizers and schedulers","local":"use-different-optimizers-and-schedulers","sections":[{"title":"Add a learning rate scheduler","local":"add-a-learning-rate-scheduler","sections":[],"depth":3}],"depth":2},{"title":"Memory efficient fine-tuning by sharing layers","local":"memory-efficient-fine-tuning-by-sharing-layers","sections":[],"depth":2},{"title":"Pass 8-bit reference models","local":"pass-8-bit-reference-models","sections":[],"depth":2},{"title":"Use the CUDA cache optimizer","local":"use-the-cuda-cache-optimizer","sections":[],"depth":2}],"depth":1}';function We(ie){return he(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends be{constructor(M){super(),we(this,M,We,Re,fe,{})}}export{Ie as component};
