import{s as os,o as ms,n as ps}from"../chunks/scheduler.182ea377.js";import{S as rs,i as Ms,g as i,s as a,r,A as cs,h as p,f as s,c as n,j as ns,u as M,x as o,k as is,y as ds,a as t,v as c,d,t as h,w as u,m as hs,n as us}from"../chunks/index.abf12888.js";import{T as jl}from"../chunks/Tip.230e2334.js";import{C as g}from"../chunks/CodeBlock.57fe6e13.js";import{D as ys}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as U}from"../chunks/Heading.16916d63.js";function Js(j){let m,J="You may have noticed that we set <code>guidance_scale=1.0</code>, which disables classifer-free-guidance. This is because the LCM-LoRA is trained with guidance, so the batch size does not have to be doubled in this case. This leads to a faster inference time, with the drawback that negative prompts don’t have any effect on the denoising process.",y,w,b="You can also use guidance with LCM-LoRA, but due to the nature of training the model is very sensitve to the <code>guidance_scale</code> values, high values can lead to artifacts in the generated images. In our experiments, we found that the best values are in the range of [1.0, 2.0].";return{c(){m=i("p"),m.innerHTML=J,y=a(),w=i("p"),w.innerHTML=b},l(f){m=p(f,"P",{"data-svelte-h":!0}),o(m)!=="svelte-x2r697"&&(m.innerHTML=J),y=n(f),w=p(f,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1sl97s7"&&(w.innerHTML=b)},m(f,T){t(f,m,T),t(f,y,T),t(f,w,T)},p:ps,d(f){f&&(s(m),s(y),s(w))}}}function ws(j){let m,J="You can get different results based on your prompt and the image you provide. To get the best results, we recommend trying different values for <code>num_inference_steps</code>, <code>strength</code>, and <code>guidance_scale</code> parameters and choose the best one.";return{c(){m=i("p"),m.innerHTML=J},l(y){m=p(y,"P",{"data-svelte-h":!0}),o(m)!=="svelte-18pswq"&&(m.innerHTML=J)},m(y,w){t(y,m,w)},p:ps,d(y){y&&s(m)}}}function fs(j){let m;return{c(){m=hs("The inference parameters in this example might not work for all examples, so we recommend you to try different values for `num_inference_steps`, `guidance_scale`, `controlnet_conditioning_scale` and `cross_attention_kwargs` parameters and choose the best one.")},l(J){m=us(J,"The inference parameters in this example might not work for all examples, so we recommend you to try different values for `num_inference_steps`, `guidance_scale`, `controlnet_conditioning_scale` and `cross_attention_kwargs` parameters and choose the best one.")},m(J,y){t(J,m,y)},d(J){J&&s(m)}}}function Ts(j){let m,J,y,w,b,f,T,je,G,Zl="Latent Consistency Models (LCM) enable quality image generation in typically 2-4 steps making it possible to use diffusion models in almost real-time settings.",Ze,C,Wl='From the <a href="https://latent-consistency-models.github.io/" rel="nofollow">official website</a>:',We,B,Il="<p>LCMs can be distilled from any pre-trained Stable Diffusion (SD) in only 4,000 training steps (~32 A100 GPU Hours) for generating high quality 768 x 768 resolution images in 2~4 steps or even one step, significantly accelerating text-to-image generation. We employ LCM to distill the Dreamshaper-V7 version of SD in just 4,000 training iterations.</p>",Ie,R,Gl='For a more technical overview of LCMs, refer to <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">the paper</a>.',Ge,k,Cl=`However, each model needs to be distilled separately for latent consistency distillation. The core idea with LCM-LoRA is to train just a few adapter layers, the adapter being LoRA in this case.
This way, we don’t have to train the full model and keep the number of trainable parameters manageable. The resulting LoRAs can then be applied to any fine-tuned version of the model without distilling them separately.
Additionally, the LoRAs can be applied to image-to-image, ControlNet/T2I-Adapter, inpainting, AnimateDiff etc.
The LCM-LoRA can also be combined with other LoRAs to generate styled images in very few steps (4-8).`,Ce,_,Bl='LCM-LoRAs are available for <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">stable-diffusion-v1-5</a>, <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stable-diffusion-xl-base-1.0</a>, and the <a href="https://huggingface.co/segmind/SSD-1B" rel="nofollow">SSD-1B</a> model. All the checkpoints can be found in this <a href="https://huggingface.co/collections/latent-consistency/latent-consistency-models-loras-654cdd24e111e16f0865fba6" rel="nofollow">collection</a>.',Be,v,Rl='For more details about LCM-LoRA, refer to <a href="https://huggingface.co/papers/2311.05556" rel="nofollow">the technical report</a>.',Re,E,kl="This guide shows how to perform inference with LCM-LoRAs for",ke,Q,_l="<li>text-to-image</li> <li>image-to-image</li> <li>combined with styled LoRAs</li> <li>ControlNet/T2I-Adapter</li> <li>inpainting</li> <li>AnimateDiff</li>",_e,V,vl=`Before going through this guide, we’ll take a look at the general workflow for performing inference with LCM-LoRAs.
LCM-LoRAs are similar to other Stable Diffusion LoRAs so they can be used with any <a href="/docs/diffusers/v0.26.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> that supports LoRAs.`,ve,L,El='<li>Load the task specific pipeline and model.</li> <li>Set the scheduler to <a href="/docs/diffusers/v0.26.1/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>.</li> <li>Load the LCM-LoRA weights for the model.</li> <li>Reduce the <code>guidance_scale</code> between <code>[1.0, 2.0]</code> and set the <code>num_inference_steps</code> between [4, 8].</li> <li>Perform inference with the pipeline with the usual parameters.</li>',Ee,N,Ql="Let’s look at how we can perform inference with LCM-LoRAs for different tasks.",Qe,Y,Vl='First, make sure you have <a href="https://github.com/huggingface/peft" rel="nofollow">peft</a> installed, for better LoRA support.',Ve,X,Le,S,Ne,F,Ll='You’ll use the <a href="/docs/diffusers/v0.26.1/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> with the scheduler: <a href="/docs/diffusers/v0.26.1/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a> and then load the LCM-LoRA. Together with the LCM-LoRA and the scheduler, the pipeline enables a fast inference workflow overcoming the slow iterative nature of diffusion models.',Ye,$,Xe,x,Nl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdxl_t2i.png"/>',Se,H,Yl="Notice that we use only 4 steps for generation which is way less than what’s typically used for standard SDXL.",Fe,Z,$e,A,xe,z,Xl='As mentioned above, the LCM-LoRA can be applied to any fine-tuned version of the model without having to distill them separately. Let’s look at how we can perform inference with a fine-tuned model. In this example, we’ll use the <a href="https://huggingface.co/Linaqruf/animagine-xl" rel="nofollow">animagine-xl</a> model, which is a fine-tuned version of the SDXL model for generating anime.',He,q,Ae,D,Sl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdxl_t2i_finetuned.png"/>',ze,P,qe,K,Fl='LCM-LoRA can be applied to image-to-image tasks too. Let’s look at how we can perform image-to-image generation with LCMs. For this example we’ll use the <a href="https://huggingface.co/Lykon/dreamshaper-7" rel="nofollow">dreamshaper-7</a> model and the LCM-LoRA for <code>stable-diffusion-v1-5 </code>.',De,O,Pe,ee,$l='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdv1-5_i2i.png"/>',Ke,W,Oe,le,el,se,xl=`LCM-LoRA can be combined with other LoRAs to generate styled-images in very few steps (4-8). In the following example, we’ll use the LCM-LoRA with the <a href="TheLastBen/Papercut_SDXL">papercut LoRA</a>.
To learn more about how to combine LoRAs, refer to <a href="https://huggingface.co/docs/diffusers/tutorials/using_peft_for_inference#combine-multiple-adapters" rel="nofollow">this guide</a>.`,ll,te,sl,ae,Hl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdx_lora_mix.png"/>',tl,ne,al,ie,Al="Let’s look at how we can perform inference with ControlNet/T2I-Adapter and LCM-LoRA.",nl,pe,il,oe,zl="For this example, we’ll use the SD-v1-5 model and the LCM-LoRA for SD-v1-5 with canny ControlNet.",pl,me,ol,re,ql='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdv1-5_controlnet.png"/>',ml,I,rl,Me,Ml,ce,Dl='This example shows how to use the LCM-LoRA with the <a href="TencentARC/t2i-adapter-canny-sdxl-1.0">Canny T2I-Adapter</a> and SDXL.',cl,de,dl,he,Pl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdxl_t2iadapter.png"/>',hl,ue,ul,ye,Kl="LCM-LoRA can be used for inpainting as well.",yl,Je,Jl,we,Ol='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdv1-5_inpainting.png"/>',wl,fe,fl,Te,es=`<code>AnimateDiff</code> allows you to animate images using Stable Diffusion models. To get good results, we need to generate multiple frames (16-24), and doing this with standard SD models can be very slow.
LCM-LoRA can be used to speed up the process significantly, as you just need to do 4-8 steps for each frame. Let’s look at how we can perform animation with LCM-LoRA and AnimateDiff.`,Tl,be,bl,Ue,ls='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdv1-5_animatediff.gif"/>',Ul,ge,gl;return b=new ys({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/inference_with_lcm_lora.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inference_with_lcm_lora.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inference_with_lcm_lora.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/inference_with_lcm_lora.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inference_with_lcm_lora.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inference_with_lcm_lora.ipynb"}]}}),T=new U({props:{title:"Performing inference with LCM-LoRA",local:"performing-inference-with-lcm-lora",headingTag:"h1"}}),X=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwcGVmdA==",highlighted:"pip install -U peft",wrap:!1}}),S=new U({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),$=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMHNldCUyMHNjaGVkdWxlciUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBsb2FkJTIwTENNLUxvUkElMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkeGwlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU2VsZi1wb3J0cmFpdCUyMG9pbCUyMHBhaW50aW5nJTJDJTIwYSUyMGJlYXV0aWZ1bCUyMGN5Ym9yZyUyMHdpdGglMjBnb2xkZW4lMjBoYWlyJTJDJTIwOGslMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuMCUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set scheduler</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load LCM-LoRA</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>)

prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">42</span>)
image = pipe(
    prompt=prompt, num_inference_steps=<span class="hljs-number">4</span>, generator=generator, guidance_scale=<span class="hljs-number">1.0</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Z=new jl({props:{$$slots:{default:[Js]},$$scope:{ctx:j}}}),A=new U({props:{title:"Inference with a fine-tuned model",local:"inference-with-a-fine-tuned-model",headingTag:"h3"}}),q=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwTENNU2NoZWR1bGVyJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJMaW5hcXJ1ZiUyRmFuaW1hZ2luZS14bCUyMiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMHNldCUyMHNjaGVkdWxlciUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBsb2FkJTIwTENNLUxvUkElMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkeGwlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZmFjZSUyMGZvY3VzJTJDJTIwY3V0ZSUyQyUyMG1hc3RlcnBpZWNlJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjAxZ2lybCUyQyUyMGdyZWVuJTIwaGFpciUyQyUyMHN3ZWF0ZXIlMkMlMjBsb29raW5nJTIwYXQlMjB2aWV3ZXIlMkMlMjB1cHBlciUyMGJvZHklMkMlMjBiZWFuaWUlMkMlMjBvdXRkb29ycyUyQyUyMG5pZ2h0JTJDJTIwdHVydGxlbmVjayUyMiUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjAlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Linaqruf/animagine-xl&quot;</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set scheduler</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load LCM-LoRA</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>)

prompt = <span class="hljs-string">&quot;face focus, cute, masterpiece, best quality, 1girl, green hair, sweater, looking at viewer, upper body, beanie, outdoors, night, turtleneck&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt, num_inference_steps=<span class="hljs-number">4</span>, generator=generator, guidance_scale=<span class="hljs-number">1.0</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),P=new U({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),O=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMkMlMjBMQ01TY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyTHlrb24lMkZkcmVhbXNoYXBlci03JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwc2V0JTIwc2NoZWR1bGVyJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBMQ01TY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQSUyMyUyMGxvYWQlMjBMQ00tTG9SQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0cyUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEElMEElMjMlMjBwYXNzJTIwcHJvbXB0JTIwYW5kJTIwaW1hZ2UlMjB0byUyMHBpcGVsaW5lJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMCklMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDElMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNiUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set scheduler</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load LCM-LoRA</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>)

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)
prompt = <span class="hljs-string">&quot;Astronauts in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt,
    image=init_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
    strength=<span class="hljs-number">0.6</span>,
    generator=generator
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),W=new jl({props:{$$slots:{default:[ws]},$$scope:{ctx:j}}}),le=new U({props:{title:"Combine with styled LoRAs",local:"combine-with-styled-loras",headingTag:"h2"}}),te=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMHNldCUyMHNjaGVkdWxlciUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBsb2FkJTIwTG9SQXMlMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkeGwlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJsY20lMjIpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJUaGVMYXN0QmVuJTJGUGFwZXJjdXRfU0RYTCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIycGFwZXJjdXQuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJwYXBlcmN1dCUyMiklMEElMEElMjMlMjBDb21iaW5lJTIwTG9SQXMlMEFwaXBlLnNldF9hZGFwdGVycyglNUIlMjJsY20lMjIlMkMlMjAlMjJwYXBlcmN1dCUyMiU1RCUyQyUyMGFkYXB0ZXJfd2VpZ2h0cyUzRCU1QjEuMCUyQyUyMDAuOCU1RCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJwYXBlcmN1dCUyQyUyMGElMjBjdXRlJTIwZm94JTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDElMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set scheduler</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load LoRAs</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;TheLastBen/Papercut_SDXL&quot;</span>, weight_name=<span class="hljs-string">&quot;papercut.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;papercut&quot;</span>)

<span class="hljs-comment"># Combine LoRAs</span>
pipe.set_adapters([<span class="hljs-string">&quot;lcm&quot;</span>, <span class="hljs-string">&quot;papercut&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>])

prompt = <span class="hljs-string">&quot;papercut, a cute fox&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">1</span>, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ne=new U({props:{title:"ControlNet/T2I-Adapter",local:"controlnett2i-adapter",headingTag:"h2"}}),pe=new U({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),me=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    controlnet=controlnet,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set scheduler</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load LCM-LoRA</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>)

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    <span class="hljs-string">&quot;the mona lisa&quot;</span>,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1.5</span>,
    controlnet_conditioning_scale=<span class="hljs-number">0.8</span>,
    cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: <span class="hljs-number">1</span>},
    generator=generator,
).images[<span class="hljs-number">0</span>]
make_image_grid([canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),I=new jl({props:{$$slots:{default:[fs]},$$scope:{ctx:j}}}),Me=new U({props:{title:"T2I-Adapter",local:"t2i-adapter",headingTag:"h3"}}),de=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLAdapterPipeline, T2IAdapter, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># Prepare image</span>
<span class="hljs-comment"># Detect the canny map in low resolution to avoid high-frequency details</span>
image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/Adapter/t2iadapter/resolve/main/figs_SDXLV1.0/org_canny.jpg&quot;</span>
).resize((<span class="hljs-number">384</span>, <span class="hljs-number">384</span>))

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

<span class="hljs-comment"># load adapter</span>
adapter = T2IAdapter.from_pretrained(<span class="hljs-string">&quot;TencentARC/t2i-adapter-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, varient=<span class="hljs-string">&quot;fp16&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe = StableDiffusionXLAdapterPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, 
    adapter=adapter,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>, 
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set scheduler</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load LCM-LoRA</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>)

prompt = <span class="hljs-string">&quot;Mystical fairy in real, magic, 4k picture, high quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;extra digit, fewer digits, cropped, worst quality, low quality, glitch, deformed, mutated, ugly, disfigured&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1.5</span>, 
    adapter_conditioning_scale=<span class="hljs-number">0.8</span>, 
    adapter_conditioning_factor=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
make_image_grid([canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ue=new U({props:{title:"Inpainting",local:"inpainting",headingTag:"h2"}}),Je=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set scheduler</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load LCM-LoRA</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>)

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

<span class="hljs-comment"># generator = torch.Generator(&quot;cuda&quot;).manual_seed(92)</span>
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt,
    image=init_image,
    mask_image=mask_image,
    generator=generator,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">4</span>, 
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),fe=new U({props:{title:"AnimateDiff",local:"animatediff",headingTag:"h2"}}),be=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW90aW9uQWRhcHRlciUyQyUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTJDJTIwTENNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZGlmZnVzZXJzJTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNSUyMiklMEFwaXBlJTIwJTNEJTIwQW5pbWF0ZURpZmZQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZnJhbmtqb3NodWElMkZ0b29ueW91X2JldGE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMHNldCUyMHNjaGVkdWxlciUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBsb2FkJTIwTENNLUxvUkElMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmxjbSUyMiklMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmd1b3l3dyUyRmFuaW1hdGVkaWZmLW1vdGlvbi1sb3JhLXpvb20taW4lMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIybW90aW9uLWxvcmElMjIpJTBBJTBBcGlwZS5zZXRfYWRhcHRlcnMoJTVCJTIybGNtJTIyJTJDJTIwJTIybW90aW9uLWxvcmElMjIlNUQlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QlNUIwLjU1JTJDJTIwMS4yJTVEKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmJlc3QlMjBxdWFsaXR5JTJDJTIwbWFzdGVycGllY2UlMkMlMjAxZ2lybCUyQyUyMGxvb2tpbmclMjBhdCUyMHZpZXdlciUyQyUyMGJsdXJyeSUyMGJhY2tncm91bmQlMkMlMjB1cHBlciUyMGJvZHklMkMlMjBjb250ZW1wb3JhcnklMkMlMjBkcmVzcyUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBZnJhbWVzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENSUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMS4yNSUyQyUwQSUyMCUyMCUyMCUyMGNyb3NzX2F0dGVudGlvbl9rd2FyZ3MlM0QlN0IlMjJzY2FsZSUyMiUzQSUyMDElN0QlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMjQlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMEEpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;diffusers/animatediff-motion-adapter-v1-5&quot;</span>)
pipe = AnimateDiffPipeline.from_pretrained(
    <span class="hljs-string">&quot;frankjoshua/toonyou_beta6&quot;</span>,
    motion_adapter=adapter,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set scheduler</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load LCM-LoRA</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-in&quot;</span>, weight_name=<span class="hljs-string">&quot;diffusion_pytorch_model.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;motion-lora&quot;</span>)

pipe.set_adapters([<span class="hljs-string">&quot;lcm&quot;</span>, <span class="hljs-string">&quot;motion-lora&quot;</span>], adapter_weights=[<span class="hljs-number">0.55</span>, <span class="hljs-number">1.2</span>])

prompt = <span class="hljs-string">&quot;best quality, masterpiece, 1girl, looking at viewer, blurry background, upper body, contemporary, dress&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
frames = pipe(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">5</span>,
    guidance_scale=<span class="hljs-number">1.25</span>,
    cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: <span class="hljs-number">1</span>},
    num_frames=<span class="hljs-number">24</span>,
    generator=generator
).frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),{c(){m=i("meta"),J=a(),y=i("p"),w=a(),r(b.$$.fragment),f=a(),r(T.$$.fragment),je=a(),G=i("p"),G.textContent=Zl,Ze=a(),C=i("p"),C.innerHTML=Wl,We=a(),B=i("blockquote"),B.innerHTML=Il,Ie=a(),R=i("p"),R.innerHTML=Gl,Ge=a(),k=i("p"),k.textContent=Cl,Ce=a(),_=i("p"),_.innerHTML=Bl,Be=a(),v=i("p"),v.innerHTML=Rl,Re=a(),E=i("p"),E.textContent=kl,ke=a(),Q=i("ul"),Q.innerHTML=_l,_e=a(),V=i("p"),V.innerHTML=vl,ve=a(),L=i("ul"),L.innerHTML=El,Ee=a(),N=i("p"),N.textContent=Ql,Qe=a(),Y=i("p"),Y.innerHTML=Vl,Ve=a(),r(X.$$.fragment),Le=a(),r(S.$$.fragment),Ne=a(),F=i("p"),F.innerHTML=Ll,Ye=a(),r($.$$.fragment),Xe=a(),x=i("p"),x.innerHTML=Nl,Se=a(),H=i("p"),H.textContent=Yl,Fe=a(),r(Z.$$.fragment),$e=a(),r(A.$$.fragment),xe=a(),z=i("p"),z.innerHTML=Xl,He=a(),r(q.$$.fragment),Ae=a(),D=i("p"),D.innerHTML=Sl,ze=a(),r(P.$$.fragment),qe=a(),K=i("p"),K.innerHTML=Fl,De=a(),r(O.$$.fragment),Pe=a(),ee=i("p"),ee.innerHTML=$l,Ke=a(),r(W.$$.fragment),Oe=a(),r(le.$$.fragment),el=a(),se=i("p"),se.innerHTML=xl,ll=a(),r(te.$$.fragment),sl=a(),ae=i("p"),ae.innerHTML=Hl,tl=a(),r(ne.$$.fragment),al=a(),ie=i("p"),ie.textContent=Al,nl=a(),r(pe.$$.fragment),il=a(),oe=i("p"),oe.textContent=zl,pl=a(),r(me.$$.fragment),ol=a(),re=i("p"),re.innerHTML=ql,ml=a(),r(I.$$.fragment),rl=a(),r(Me.$$.fragment),Ml=a(),ce=i("p"),ce.innerHTML=Dl,cl=a(),r(de.$$.fragment),dl=a(),he=i("p"),he.innerHTML=Pl,hl=a(),r(ue.$$.fragment),ul=a(),ye=i("p"),ye.textContent=Kl,yl=a(),r(Je.$$.fragment),Jl=a(),we=i("p"),we.innerHTML=Ol,wl=a(),r(fe.$$.fragment),fl=a(),Te=i("p"),Te.innerHTML=es,Tl=a(),r(be.$$.fragment),bl=a(),Ue=i("p"),Ue.innerHTML=ls,Ul=a(),ge=i("p"),this.h()},l(e){const l=cs("svelte-u9bgzb",document.head);m=p(l,"META",{name:!0,content:!0}),l.forEach(s),J=n(e),y=p(e,"P",{}),ns(y).forEach(s),w=n(e),M(b.$$.fragment,e),f=n(e),M(T.$$.fragment,e),je=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-2fpkx0"&&(G.textContent=Zl),Ze=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-d9zkw1"&&(C.innerHTML=Wl),We=n(e),B=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(B)!=="svelte-9ngsrn"&&(B.innerHTML=Il),Ie=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-yzou0e"&&(R.innerHTML=Gl),Ge=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-sqxks"&&(k.textContent=Cl),Ce=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-121irgb"&&(_.innerHTML=Bl),Be=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1op1l2i"&&(v.innerHTML=Rl),Re=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1pmm8o2"&&(E.textContent=kl),ke=n(e),Q=p(e,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-1utl29a"&&(Q.innerHTML=_l),_e=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-177nar1"&&(V.innerHTML=vl),ve=n(e),L=p(e,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-n7eyqi"&&(L.innerHTML=El),Ee=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-19h4utp"&&(N.textContent=Ql),Qe=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-qd8sxg"&&(Y.innerHTML=Vl),Ve=n(e),M(X.$$.fragment,e),Le=n(e),M(S.$$.fragment,e),Ne=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1i03faz"&&(F.innerHTML=Ll),Ye=n(e),M($.$$.fragment,e),Xe=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-zmq986"&&(x.innerHTML=Nl),Se=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-n61tgz"&&(H.textContent=Yl),Fe=n(e),M(Z.$$.fragment,e),$e=n(e),M(A.$$.fragment,e),xe=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-15rr98x"&&(z.innerHTML=Xl),He=n(e),M(q.$$.fragment,e),Ae=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-19vr4c5"&&(D.innerHTML=Sl),ze=n(e),M(P.$$.fragment,e),qe=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-2suklx"&&(K.innerHTML=Fl),De=n(e),M(O.$$.fragment,e),Pe=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-zt9d3e"&&(ee.innerHTML=$l),Ke=n(e),M(W.$$.fragment,e),Oe=n(e),M(le.$$.fragment,e),el=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1ueo85e"&&(se.innerHTML=xl),ll=n(e),M(te.$$.fragment,e),sl=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-9tzi4"&&(ae.innerHTML=Hl),tl=n(e),M(ne.$$.fragment,e),al=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-db61xh"&&(ie.textContent=Al),nl=n(e),M(pe.$$.fragment,e),il=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1cso8xy"&&(oe.textContent=zl),pl=n(e),M(me.$$.fragment,e),ol=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-11lx81y"&&(re.innerHTML=ql),ml=n(e),M(I.$$.fragment,e),rl=n(e),M(Me.$$.fragment,e),Ml=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-5l31pr"&&(ce.innerHTML=Dl),cl=n(e),M(de.$$.fragment,e),dl=n(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-iuzcjf"&&(he.innerHTML=Pl),hl=n(e),M(ue.$$.fragment,e),ul=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-fhcmt1"&&(ye.textContent=Kl),yl=n(e),M(Je.$$.fragment,e),Jl=n(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1t65w1d"&&(we.innerHTML=Ol),wl=n(e),M(fe.$$.fragment,e),fl=n(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-13othel"&&(Te.innerHTML=es),Tl=n(e),M(be.$$.fragment,e),bl=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-zceinn"&&(Ue.innerHTML=ls),Ul=n(e),ge=p(e,"P",{}),ns(ge).forEach(s),this.h()},h(){is(m,"name","hf:doc:metadata"),is(m,"content",bs)},m(e,l){ds(document.head,m),t(e,J,l),t(e,y,l),t(e,w,l),c(b,e,l),t(e,f,l),c(T,e,l),t(e,je,l),t(e,G,l),t(e,Ze,l),t(e,C,l),t(e,We,l),t(e,B,l),t(e,Ie,l),t(e,R,l),t(e,Ge,l),t(e,k,l),t(e,Ce,l),t(e,_,l),t(e,Be,l),t(e,v,l),t(e,Re,l),t(e,E,l),t(e,ke,l),t(e,Q,l),t(e,_e,l),t(e,V,l),t(e,ve,l),t(e,L,l),t(e,Ee,l),t(e,N,l),t(e,Qe,l),t(e,Y,l),t(e,Ve,l),c(X,e,l),t(e,Le,l),c(S,e,l),t(e,Ne,l),t(e,F,l),t(e,Ye,l),c($,e,l),t(e,Xe,l),t(e,x,l),t(e,Se,l),t(e,H,l),t(e,Fe,l),c(Z,e,l),t(e,$e,l),c(A,e,l),t(e,xe,l),t(e,z,l),t(e,He,l),c(q,e,l),t(e,Ae,l),t(e,D,l),t(e,ze,l),c(P,e,l),t(e,qe,l),t(e,K,l),t(e,De,l),c(O,e,l),t(e,Pe,l),t(e,ee,l),t(e,Ke,l),c(W,e,l),t(e,Oe,l),c(le,e,l),t(e,el,l),t(e,se,l),t(e,ll,l),c(te,e,l),t(e,sl,l),t(e,ae,l),t(e,tl,l),c(ne,e,l),t(e,al,l),t(e,ie,l),t(e,nl,l),c(pe,e,l),t(e,il,l),t(e,oe,l),t(e,pl,l),c(me,e,l),t(e,ol,l),t(e,re,l),t(e,ml,l),c(I,e,l),t(e,rl,l),c(Me,e,l),t(e,Ml,l),t(e,ce,l),t(e,cl,l),c(de,e,l),t(e,dl,l),t(e,he,l),t(e,hl,l),c(ue,e,l),t(e,ul,l),t(e,ye,l),t(e,yl,l),c(Je,e,l),t(e,Jl,l),t(e,we,l),t(e,wl,l),c(fe,e,l),t(e,fl,l),t(e,Te,l),t(e,Tl,l),c(be,e,l),t(e,bl,l),t(e,Ue,l),t(e,Ul,l),t(e,ge,l),gl=!0},p(e,[l]){const ss={};l&2&&(ss.$$scope={dirty:l,ctx:e}),Z.$set(ss);const ts={};l&2&&(ts.$$scope={dirty:l,ctx:e}),W.$set(ts);const as={};l&2&&(as.$$scope={dirty:l,ctx:e}),I.$set(as)},i(e){gl||(d(b.$$.fragment,e),d(T.$$.fragment,e),d(X.$$.fragment,e),d(S.$$.fragment,e),d($.$$.fragment,e),d(Z.$$.fragment,e),d(A.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(W.$$.fragment,e),d(le.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(I.$$.fragment,e),d(Me.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(Je.$$.fragment,e),d(fe.$$.fragment,e),d(be.$$.fragment,e),gl=!0)},o(e){h(b.$$.fragment,e),h(T.$$.fragment,e),h(X.$$.fragment,e),h(S.$$.fragment,e),h($.$$.fragment,e),h(Z.$$.fragment,e),h(A.$$.fragment,e),h(q.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(W.$$.fragment,e),h(le.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(I.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(Je.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),gl=!1},d(e){e&&(s(J),s(y),s(w),s(f),s(je),s(G),s(Ze),s(C),s(We),s(B),s(Ie),s(R),s(Ge),s(k),s(Ce),s(_),s(Be),s(v),s(Re),s(E),s(ke),s(Q),s(_e),s(V),s(ve),s(L),s(Ee),s(N),s(Qe),s(Y),s(Ve),s(Le),s(Ne),s(F),s(Ye),s(Xe),s(x),s(Se),s(H),s(Fe),s($e),s(xe),s(z),s(He),s(Ae),s(D),s(ze),s(qe),s(K),s(De),s(Pe),s(ee),s(Ke),s(Oe),s(el),s(se),s(ll),s(sl),s(ae),s(tl),s(al),s(ie),s(nl),s(il),s(oe),s(pl),s(ol),s(re),s(ml),s(rl),s(Ml),s(ce),s(cl),s(dl),s(he),s(hl),s(ul),s(ye),s(yl),s(Jl),s(we),s(wl),s(fl),s(Te),s(Tl),s(bl),s(Ue),s(Ul),s(ge)),s(m),u(b,e),u(T,e),u(X,e),u(S,e),u($,e),u(Z,e),u(A,e),u(q,e),u(P,e),u(O,e),u(W,e),u(le,e),u(te,e),u(ne,e),u(pe,e),u(me,e),u(I,e),u(Me,e),u(de,e),u(ue,e),u(Je,e),u(fe,e),u(be,e)}}}const bs='{"title":"Performing inference with LCM-LoRA","local":"performing-inference-with-lcm-lora","sections":[{"title":"Text-to-image","local":"text-to-image","sections":[{"title":"Inference with a fine-tuned model","local":"inference-with-a-fine-tuned-model","sections":[],"depth":3}],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Combine with styled LoRAs","local":"combine-with-styled-loras","sections":[],"depth":2},{"title":"ControlNet/T2I-Adapter","local":"controlnett2i-adapter","sections":[{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"T2I-Adapter","local":"t2i-adapter","sections":[],"depth":3}],"depth":2},{"title":"Inpainting","local":"inpainting","sections":[],"depth":2},{"title":"AnimateDiff","local":"animatediff","sections":[],"depth":2}],"depth":1}';function Us(j){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends rs{constructor(m){super(),Ms(this,m,Us,Ts,os,{})}}export{Cs as component};
