import{s as re,o as pe,n as oe}from"../chunks/scheduler.182ea377.js";import{S as me,i as fe,g as r,s as l,r as U,A as ce,h as p,f as n,c as o,j as ae,u as x,x as u,k as se,y as de,a as s,v as C,d as I,t as j,w as H}from"../chunks/index.abf12888.js";import{T as ie}from"../chunks/Tip.230e2334.js";import{C as le}from"../chunks/CodeBlock.57fe6e13.js";import{H as q}from"../chunks/Heading.16916d63.js";function ue(E){let a,m='In many cases, optimizing for speed or memory leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on inference speed, but you can learn more about preserving memory in the <a href="memory">Reduce memory usage</a> guide.';return{c(){a=r("p"),a.innerHTML=m},l(i){a=p(i,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1dpd5a8"&&(a.innerHTML=m)},m(i,f){s(i,a,f)},p:oe,d(i){i&&n(a)}}}function he(E){let a,m='Don’t use <a href="https://pytorch.org/docs/stable/amp.html#torch.autocast" rel="nofollow"><code>torch.autocast</code></a> in any of the pipelines as it can lead to black images and is always slower than pure float16 precision.';return{c(){a=r("p"),a.innerHTML=m},l(i){a=p(i,"P",{"data-svelte-h":!0}),u(a)!=="svelte-19ow5yd"&&(a.innerHTML=m)},m(i,f){s(i,a,f)},p:oe,d(i){i&&n(a)}}}function we(E){let a,m,i,f,h,Z,w,Q='There are several ways to optimize 🤗 Diffusers for inference speed. As a general rule of thumb, we recommend using either <a href="xformers">xFormers</a> or <code>torch.nn.functional.scaled_dot_product_attention</code> in PyTorch 2.0 for their memory-efficient attention.',L,c,P,$,Y="The results below are obtained from generating a single 512x512 image from the prompt <code>a photo of an astronaut riding a horse on mars</code> with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect.",W,T,A="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",B,y,F,g,K='On Ampere and later CUDA devices, matrix multiplications and convolutions can use the <a href="https://blogs.nvidia.com/blog/2020/05/14/tensorfloat-32-precision-format/" rel="nofollow">TensorFloat-32 (TF32)</a> mode for faster, but slightly less accurate computations. By default, PyTorch enables TF32 mode for convolutions but not matrix multiplications. Unless your network requires full float32 precision, we recommend enabling TF32 for matrix multiplications. It can significantly speeds up computations with typically negligible loss in numerical accuracy.',R,b,k,J,O='You can learn more about TF32 in the <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_one#tf32" rel="nofollow">Mixed precision training</a> guide.',S,M,z,_,ee="To save GPU memory and get more speed, try loading and running the model weights directly in half-precision or float16:",D,v,N,d,V,G,X;return h=new q({props:{title:"Speed up inference",local:"speed-up-inference",headingTag:"h1"}}),c=new ie({props:{$$slots:{default:[ue]},$$scope:{ctx:E}}}),y=new q({props:{title:"Use TensorFloat-32",local:"use-tensorfloat-32",headingTag:"h2"}}),b=new le({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5iYWNrZW5kcy5jdWRhLm1hdG11bC5hbGxvd190ZjMyJTIwJTNEJTIwVHJ1ZQ==",highlighted:`<span class="hljs-keyword">import</span> torch

torch.backends.cuda.matmul.allow_tf32 = <span class="hljs-literal">True</span>`,wrap:!1}}),M=new q({props:{title:"Half-precision weights",local:"half-precision-weights",headingTag:"h2"}}),v=new le({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),d=new ie({props:{warning:!0,$$slots:{default:[he]},$$scope:{ctx:E}}}),{c(){a=r("meta"),m=l(),i=r("p"),f=l(),U(h.$$.fragment),Z=l(),w=r("p"),w.innerHTML=Q,L=l(),U(c.$$.fragment),P=l(),$=r("p"),$.innerHTML=Y,W=l(),T=r("table"),T.innerHTML=A,B=l(),U(y.$$.fragment),F=l(),g=r("p"),g.innerHTML=K,R=l(),U(b.$$.fragment),k=l(),J=r("p"),J.innerHTML=O,S=l(),U(M.$$.fragment),z=l(),_=r("p"),_.textContent=ee,D=l(),U(v.$$.fragment),N=l(),U(d.$$.fragment),V=l(),G=r("p"),this.h()},l(e){const t=ce("svelte-u9bgzb",document.head);a=p(t,"META",{name:!0,content:!0}),t.forEach(n),m=o(e),i=p(e,"P",{}),ae(i).forEach(n),f=o(e),x(h.$$.fragment,e),Z=o(e),w=p(e,"P",{"data-svelte-h":!0}),u(w)!=="svelte-1ee6byd"&&(w.innerHTML=Q),L=o(e),x(c.$$.fragment,e),P=o(e),$=p(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1iu9895"&&($.innerHTML=Y),W=o(e),T=p(e,"TABLE",{"data-svelte-h":!0}),u(T)!=="svelte-1osaemz"&&(T.innerHTML=A),B=o(e),x(y.$$.fragment,e),F=o(e),g=p(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-sgc3mn"&&(g.innerHTML=K),R=o(e),x(b.$$.fragment,e),k=o(e),J=p(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-ahb0o9"&&(J.innerHTML=O),S=o(e),x(M.$$.fragment,e),z=o(e),_=p(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-rv9wu9"&&(_.textContent=ee),D=o(e),x(v.$$.fragment,e),N=o(e),x(d.$$.fragment,e),V=o(e),G=p(e,"P",{}),ae(G).forEach(n),this.h()},h(){se(a,"name","hf:doc:metadata"),se(a,"content",$e)},m(e,t){de(document.head,a),s(e,m,t),s(e,i,t),s(e,f,t),C(h,e,t),s(e,Z,t),s(e,w,t),s(e,L,t),C(c,e,t),s(e,P,t),s(e,$,t),s(e,W,t),s(e,T,t),s(e,B,t),C(y,e,t),s(e,F,t),s(e,g,t),s(e,R,t),C(b,e,t),s(e,k,t),s(e,J,t),s(e,S,t),C(M,e,t),s(e,z,t),s(e,_,t),s(e,D,t),C(v,e,t),s(e,N,t),C(d,e,t),s(e,V,t),s(e,G,t),X=!0},p(e,[t]){const te={};t&2&&(te.$$scope={dirty:t,ctx:e}),c.$set(te);const ne={};t&2&&(ne.$$scope={dirty:t,ctx:e}),d.$set(ne)},i(e){X||(I(h.$$.fragment,e),I(c.$$.fragment,e),I(y.$$.fragment,e),I(b.$$.fragment,e),I(M.$$.fragment,e),I(v.$$.fragment,e),I(d.$$.fragment,e),X=!0)},o(e){j(h.$$.fragment,e),j(c.$$.fragment,e),j(y.$$.fragment,e),j(b.$$.fragment,e),j(M.$$.fragment,e),j(v.$$.fragment,e),j(d.$$.fragment,e),X=!1},d(e){e&&(n(m),n(i),n(f),n(Z),n(w),n(L),n(P),n($),n(W),n(T),n(B),n(F),n(g),n(R),n(k),n(J),n(S),n(z),n(_),n(D),n(N),n(V),n(G)),n(a),H(h,e),H(c,e),H(y,e),H(b,e),H(M,e),H(v,e),H(d,e)}}}const $e='{"title":"Speed up inference","local":"speed-up-inference","sections":[{"title":"Use TensorFloat-32","local":"use-tensorfloat-32","sections":[],"depth":2},{"title":"Half-precision weights","local":"half-precision-weights","sections":[],"depth":2}],"depth":1}';function Te(E){return pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends me{constructor(a){super(),fe(this,a,Te,we,re,{})}}export{_e as component};
