import{s as rt,n as ot,o as it}from"../chunks/scheduler.6062bdaf.js";import{S as pt,i as dt,g as r,s as a,r as p,A as mt,h as o,f as s,c as n,j as at,u as d,x as i,k as nt,y as ct,a as l,v as m,d as c,t as h,w as u}from"../chunks/index.4bca734e.js";import{C as D}from"../chunks/CodeBlock.fa01571c.js";import{H as q}from"../chunks/Heading.723dceba.js";function ht(xe){let f,ee,K,te,y,se,M,Ve="You want to add a new model for <code>Better Transformer</code>, the fast path of PyTorch Transformer API? Check this guideline!",le,b,ae,w,Ee=`In theory, any model that has a transformer encoder layer, similar to the classic encoder described in the <a href="https://arxiv.org/abs/1706.03762" rel="nofollow">“Attention Is All You Need”</a> paper should be supported.
More specifically, a model that has an encoder block with a MultiHead-Attention module (with pre or post-attention layer norm) should be convertible to its <code>BetterTransformer</code> equivalent. The conditions can be summarized as follows:`,ne,T,ze='<li>Use classic Multi Head attention module (for example, <a href="https://arxiv.org/abs/2006.03654" rel="nofollow">DeBERTa</a> cannot be supported)</li> <li>Use either <code>gelu</code> or <code>relu</code> activation function</li> <li>Have an even number of attention heads</li> <li>Do not use any attention bias (for eg <code>T5</code> uses attention bias, therefore cannot be supported)</li> <li><code>eps</code> must be equal between the first and second layer norms for each layer</li>',re,j,oe,_,ie,U,Re="First, go to <code>optimum/bettertransformer/__init__.py</code> and you’ll see the dictionary <code>BetterTransformerManager.MODEL_MAPPING</code>. This should contain the mapping between a model type, and the <code>Tuple[str, BetterTransformerBaseLayer]</code> composed of the name of the <code>nn.Module</code> that can be converted to its <code>BetterTransformer</code> equivalent, and effectively the equivalent <code>BetterTransformer</code> layer class.",pe,J,Ne="Let us try to do it step by step for <code>Bert</code>, first we need to identify the layers that needs to be replaced:",de,$,me,C,Qe="You can clearly see that the layers that need to be replaced are the <code>BertLayer</code> modules since they contain the whole encoder layer module.",ce,g,he,v,Ae=`Check that the identified module is not already copied from another module (by inspecting the source code in <a href="https://github.com/huggingface/transformers" rel="nofollow"><code>transformers</code></a> and checking that the class definition does not start with <code># Copied from ...</code>) - and if not, create a class in <code>bettertransformer/models/encoder_model.py</code>.
Start with those lines:`,ue,k,fe,B,Fe="Now, make sure to fill all the necessary attributes, the list of attributes are:",ye,I,Xe="<li><code>in_proj_weight</code></li> <li><code>in_proj_bias</code></li> <li><code>out_proj_weight</code></li> <li><code>out_proj_bias</code></li> <li><code>linear1_weight</code></li> <li><code>linear1_bias</code></li> <li><code>linear2_weight</code></li> <li><code>linear2_bias</code></li> <li><code>norm1_eps</code></li> <li><code>norm1_weight</code></li> <li><code>norm1_bias</code></li> <li><code>norm2_weight</code></li> <li><code>norm2_bias</code></li> <li><code>num_heads</code></li> <li><code>embed_dim</code></li>",Me,Z,Se='Note that these attributes correspond to all the components that are necessary to run a Transformer Encoder module, check the figure 1 on the <a href="https://arxiv.org/pdf/1706.03762.pdf" rel="nofollow">“Attention Is All You Need”</a> paper.',be,L,Ye='Once you filled all these attributes (sometimes the <code>query</code>, <code>key</code> and <code>value</code> layers needs to be “contigufied”, check the <a href="https://github.com/huggingface/optimum/blob/main/optimum/bettertransformer/models/encoder_models.py" rel="nofollow"><code>modeling_encoder.py</code></a> file to understand more.)',we,G,Pe="Make sure also to add the lines:",Te,H,je,W,_e,x,De="First of all, start with the line <code>super().forward_checker()</code>, this is needed so that the parent class can run all the safety checkers before.",Ue,V,qe="After the first forward pass, the hidden states needs to be <em>nested</em> using the attention mask. Once they are nested, the attention mask is not needed anymore, therefore can be set to <code>None</code>. This is how the forward pass is built for <code>Bert</code>, these lines should remain pretty much similar accross models, but sometimes the shapes of the attention masks are different across models.",Je,E,$e,z,Ke="Once the <code>hidden_states</code> are nested, call <code>torch._transformer_encoder_layer_fwd</code> using the right arguments as follows:",Ce,R,ge,N,Oe="At the last layer, it is important to “un-nest” the hidden_states so that it can be processed by the next modules, this is done in these lines:",ve,Q,ke,A,et="Also make sure to return a <code>tuple</code> to follow the convention of <code>transformers</code>.",Be,F,tt="The best way to reproduce this experiment on your own model is to try it by get some inspiration from the provided modeling scripts. Of course, we will be happy to help you converting your model if you open an issue or a Pull Request on <code>optimum</code>!",Ie,X,Ze,S,st="As a last step, make sure to update the <code>BetterTransformerManager.MODEL_MAPPING</code> dictionary in <code>optimum/bettertransformer/__init__.py</code> with the correct names, and you should be ready to convert your model. For example, for Bert that would be:",Le,Y,Ge,P,lt='Try it out with the conversion method that is presented in the <a href="../tutorials/convert">tutorials sections</a>!',He,O,We;return y=new q({props:{title:"Adding BetterTransformer support for new architectures",local:"adding-bettertransformer-support-for-new-architectures",headingTag:"h1"}}),b=new q({props:{title:"Models that should be supported",local:"models-that-should-be-supported",headingTag:"h2"}}),j=new q({props:{title:"How to convert a model into its BetterTransformer format?",local:"how-to-convert-a-model-into-its-bettertransformer-format",headingTag:"h2"}}),_=new q({props:{title:"Step 1: Identifying the source layer to change",local:"step-1-identifying-the-source-layer-to-change",headingTag:"h3"}}),$=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFwcmludChtb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model)
...
          (LayerNorm): LayerNorm((<span class="hljs-number">768</span>,), eps=<span class="hljs-number">1e-12</span>, elementwise_affine=<span class="hljs-literal">True</span>)
          (dropout): Dropout(p=<span class="hljs-number">0.1</span>, inplace=<span class="hljs-literal">False</span>)
        )
      )
      (<span class="hljs-number">11</span>): BertLayer(
        (attention): BertAttention(
          (self): BertSelfAttention(
            (query): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
            (key): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
            (value): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
            (dropout): Dropout(p=<span class="hljs-number">0.1</span>, inplace=<span class="hljs-literal">False</span>)
          )
          (output): BertSelfOutput(
            (dense): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
            (LayerNorm): LayerNorm((<span class="hljs-number">768</span>,), eps=<span class="hljs-number">1e-12</span>, elementwise_affine=<span class="hljs-literal">True</span>)
            (dropout): Dropout(p=<span class="hljs-number">0.1</span>, inplace=<span class="hljs-literal">False</span>)
          )
        )
        (intermediate): BertIntermediate(
          (dense): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">3072</span>, bias=<span class="hljs-literal">True</span>)
          (intermediate_act_fn): GELUActivation()
        )
        (output): BertOutput(
          (dense): Linear(in_features=<span class="hljs-number">3072</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
          (LayerNorm): LayerNorm((<span class="hljs-number">768</span>,), eps=<span class="hljs-number">1e-12</span>, elementwise_affine=<span class="hljs-literal">True</span>)
          (dropout): Dropout(p=<span class="hljs-number">0.1</span>, inplace=<span class="hljs-literal">False</span>)
        )
      )
    )
  )
  (pooler): BertPooler(
    (dense): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
    (activation): Tanh()
  )
)`,wrap:!1}}),g=new q({props:{title:"Step 2: Building the xxxLayerBetterTransformer module",local:"step-2-building-the-xxxlayerbettertransformer-module",headingTag:"h3"}}),k=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwLi5iYXNlJTIwaW1wb3J0JTIwQmV0dGVyVHJhbnNmb3JtZXJCYXNlTGF5ZXIlMEElMEElMEFjbGFzcyUyMEJlcnRMYXllckJldHRlclRyYW5zZm9ybWVyKEJldHRlclRyYW5zZm9ybWVyQmFzZUxheWVyKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBiZXJ0X2xheWVyJTJDJTIwY29uZmlnKSUzQSUwQS4uLg==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> ..base <span class="hljs-keyword">import</span> BetterTransformerBaseLayer


<span class="hljs-keyword">class</span> <span class="hljs-title class_">BertLayerBetterTransformer</span>(<span class="hljs-title class_ inherited__">BetterTransformerBaseLayer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, bert_layer, config</span>):
...`,wrap:!1}}),H=new D({props:{code:"c2VsZi5pc19sYXN0X2xheWVyJTIwJTNEJTIwRmFsc2UlMEFzZWxmLnZhbGlkYXRlX2JldHRlcnRyYW5zZm9ybWVyKCk=",highlighted:`self.is_last_layer = <span class="hljs-literal">False</span>
self.validate_bettertransformer()`,wrap:!1}}),W=new q({props:{title:"Step 3: Building the forward pass",local:"step-3-building-the-forward-pass",headingTag:"h3"}}),E=new D({props:{code:"c3VwZXIoKS5mb3J3YXJkX2NoZWNrZXIoKSUwQSUwQWlmJTIwaGlkZGVuX3N0YXRlcy5pc19uZXN0ZWQlM0ElMEElMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUyMCUzRCUyME5vbmUlMEElMEFpZiUyMGF0dGVudGlvbl9tYXNrJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwYXR0ZW50aW9uJTIwbWFzayUyMGNvbWVzJTIwaW4lMjB3aXRoJTIwdmFsdWVzJTIwMCUyMGFuZCUyMC1pbmYuJTIwd2UlMjBjb252ZXJ0JTIwdG8lMjB0b3JjaC5ubi5UcmFuc2Zvcm1lckVuY29kZXIlMjBzdHlsZSUyMGJvb2wlMjBtYXNrJTBBJTIwJTIwJTIwJTIwJTIzJTIwMC0lM0VmYWxzZS0lM0VrZWVwJTIwdGhpcyUyMHRva2VuJTIwLWluZi0lM0V0cnVlLSUzRW1hc2slMjB0aGlzJTIwdG9rZW4lMEElMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUyMCUzRCUyMGF0dGVudGlvbl9tYXNrLmJvb2woKSUwQSUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTIwJTNEJTIwdG9yY2gucmVzaGFwZShhdHRlbnRpb25fbWFzayUyQyUyMChhdHRlbnRpb25fbWFzay5zaGFwZSU1QjAlNUQlMkMlMjBhdHRlbnRpb25fbWFzay5zaGFwZSU1Qi0xJTVEKSklMEElMjAlMjAlMjAlMjBzZXFsZW4lMjAlM0QlMjBhdHRlbnRpb25fbWFzay5zaGFwZSU1QjElNUQlMEElMjAlMjAlMjAlMjBsZW5ndGhzJTIwJTNEJTIwdG9yY2guc3VtKH5hdHRlbnRpb25fbWFzayUyQyUyMDEpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBhbGwoJTVCbCUyMCUzRCUzRCUyMHNlcWxlbiUyMGZvciUyMGwlMjBpbiUyMGxlbmd0aHMlNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHRvcmNoLl9uZXN0ZWRfdGVuc29yX2Zyb21fbWFzayhoaWRkZW5fc3RhdGVzJTJDJTIwfmF0dGVudGlvbl9tYXNrKSUwQSUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTIwJTNEJTIwTm9uZQ==",highlighted:`<span class="hljs-built_in">super</span>().forward_checker()

<span class="hljs-keyword">if</span> hidden_states.is_nested:
    attention_mask = <span class="hljs-literal">None</span>

<span class="hljs-keyword">if</span> attention_mask <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># attention mask comes in with values 0 and -inf. we convert to torch.nn.TransformerEncoder style bool mask</span>
    <span class="hljs-comment"># 0-&gt;false-&gt;keep this token -inf-&gt;true-&gt;mask this token</span>
    attention_mask = attention_mask.<span class="hljs-built_in">bool</span>()
    attention_mask = torch.reshape(attention_mask, (attention_mask.shape[<span class="hljs-number">0</span>], attention_mask.shape[-<span class="hljs-number">1</span>]))
    seqlen = attention_mask.shape[<span class="hljs-number">1</span>]
    lengths = torch.<span class="hljs-built_in">sum</span>(~attention_mask, <span class="hljs-number">1</span>)
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">all</span>([l == seqlen <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> lengths]):
        hidden_states = torch._nested_tensor_from_mask(hidden_states, ~attention_mask)
    attention_mask = <span class="hljs-literal">None</span>`,wrap:!1}}),R=new D({props:{code:"aGlkZGVuX3N0YXRlcyUyMCUzRCUyMHRvcmNoLl90cmFuc2Zvcm1lcl9lbmNvZGVyX2xheWVyX2Z3ZCglMEElMjAlMjAlMjAlMjBoaWRkZW5fc3RhdGVzJTJDJTBBJTIwJTIwJTIwJTIwc2VsZi5lbWJlZF9kaW0lMkMlMEElMjAlMjAlMjAlMjBzZWxmLm51bV9oZWFkcyUyQyUwQSUyMCUyMCUyMCUyMHNlbGYuaW5fcHJval93ZWlnaHQlMkMlMEElMjAlMjAlMjAlMjBzZWxmLmluX3Byb2pfYmlhcyUyQyUwQSUyMCUyMCUyMCUyMHNlbGYub3V0X3Byb2pfd2VpZ2h0JTJDJTBBJTIwJTIwJTIwJTIwc2VsZi5vdXRfcHJval9iaWFzJTJDJTBBJTIwJTIwJTIwJTIwc2VsZi51c2VfZ2VsdSUyQyUwQSUyMCUyMCUyMCUyMHNlbGYubm9ybV9maXJzdCUyQyUwQSUyMCUyMCUyMCUyMHNlbGYubm9ybTFfZXBzJTJDJTBBJTIwJTIwJTIwJTIwc2VsZi5ub3JtMV93ZWlnaHQlMkMlMEElMjAlMjAlMjAlMjBzZWxmLm5vcm0xX2JpYXMlMkMlMEElMjAlMjAlMjAlMjBzZWxmLm5vcm0yX3dlaWdodCUyQyUwQSUyMCUyMCUyMCUyMHNlbGYubm9ybTJfYmlhcyUyQyUwQSUyMCUyMCUyMCUyMHNlbGYubGluZWFyMV93ZWlnaHQlMkMlMEElMjAlMjAlMjAlMjBzZWxmLmxpbmVhcjFfYmlhcyUyQyUwQSUyMCUyMCUyMCUyMHNlbGYubGluZWFyMl93ZWlnaHQlMkMlMEElMjAlMjAlMjAlMjBzZWxmLmxpbmVhcjJfYmlhcyUyQyUwQSUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTJDJTBBKQ==",highlighted:`hidden_states = torch._transformer_encoder_layer_fwd(
    hidden_states,
    self.embed_dim,
    self.num_heads,
    self.in_proj_weight,
    self.in_proj_bias,
    self.out_proj_weight,
    self.out_proj_bias,
    self.use_gelu,
    self.norm_first,
    self.norm1_eps,
    self.norm1_weight,
    self.norm1_bias,
    self.norm2_weight,
    self.norm2_bias,
    self.linear1_weight,
    self.linear1_bias,
    self.linear2_weight,
    self.linear2_bias,
    attention_mask,
)`,wrap:!1}}),Q=new D({props:{code:"aWYlMjBoaWRkZW5fc3RhdGVzLmlzX25lc3RlZCUyMGFuZCUyMHNlbGYuaXNfbGFzdF9sYXllciUzQSUwQSUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMjAlM0QlMjBoaWRkZW5fc3RhdGVzLnRvX3BhZGRlZF90ZW5zb3IoMC4wKSUwQXJldHVybiUyMChoaWRkZW5fc3RhdGVzJTJDKQ==",highlighted:`<span class="hljs-keyword">if</span> hidden_states.is_nested <span class="hljs-keyword">and</span> self.is_last_layer:
    hidden_states = hidden_states.to_padded_tensor(<span class="hljs-number">0.0</span>)
<span class="hljs-keyword">return</span> (hidden_states,)`,wrap:!1}}),X=new q({props:{title:"Step 4: Sanity check!",local:"step-4-sanity-check",headingTag:"h3"}}),Y=new D({props:{code:"TU9ERUxfTUFQUElORyUyMCUzRCUyMCU3QiUwQSUyMCUyMC4uLiUwQSUyMCUyMCUyMmJlcnQlMjIlM0ElMjAoJTIyQmVydExheWVyJTIyJTJDJTIwQmVydExheWVyQmV0dGVyVHJhbnNmb3JtZXIpJTJDJTBBJTIwJTIwLi4uJTBBJTdE",highlighted:`MODEL_MAPPING = {
  <span class="hljs-params">...</span>
  <span class="hljs-string">&quot;bert&quot;</span>: (<span class="hljs-string">&quot;BertLayer&quot;</span>, BertLayerBetterTransformer),
  <span class="hljs-params">...</span>
}`,wrap:!1}}),{c(){f=r("meta"),ee=a(),K=r("p"),te=a(),p(y.$$.fragment),se=a(),M=r("p"),M.innerHTML=Ve,le=a(),p(b.$$.fragment),ae=a(),w=r("p"),w.innerHTML=Ee,ne=a(),T=r("ul"),T.innerHTML=ze,re=a(),p(j.$$.fragment),oe=a(),p(_.$$.fragment),ie=a(),U=r("p"),U.innerHTML=Re,pe=a(),J=r("p"),J.innerHTML=Ne,de=a(),p($.$$.fragment),me=a(),C=r("p"),C.innerHTML=Qe,ce=a(),p(g.$$.fragment),he=a(),v=r("p"),v.innerHTML=Ae,ue=a(),p(k.$$.fragment),fe=a(),B=r("p"),B.textContent=Fe,ye=a(),I=r("ul"),I.innerHTML=Xe,Me=a(),Z=r("p"),Z.innerHTML=Se,be=a(),L=r("p"),L.innerHTML=Ye,we=a(),G=r("p"),G.textContent=Pe,Te=a(),p(H.$$.fragment),je=a(),p(W.$$.fragment),_e=a(),x=r("p"),x.innerHTML=De,Ue=a(),V=r("p"),V.innerHTML=qe,Je=a(),p(E.$$.fragment),$e=a(),z=r("p"),z.innerHTML=Ke,Ce=a(),p(R.$$.fragment),ge=a(),N=r("p"),N.textContent=Oe,ve=a(),p(Q.$$.fragment),ke=a(),A=r("p"),A.innerHTML=et,Be=a(),F=r("p"),F.innerHTML=tt,Ie=a(),p(X.$$.fragment),Ze=a(),S=r("p"),S.innerHTML=st,Le=a(),p(Y.$$.fragment),Ge=a(),P=r("p"),P.innerHTML=lt,He=a(),O=r("p"),this.h()},l(e){const t=mt("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(s),ee=n(e),K=o(e,"P",{}),at(K).forEach(s),te=n(e),d(y.$$.fragment,e),se=n(e),M=o(e,"P",{"data-svelte-h":!0}),i(M)!=="svelte-fjb411"&&(M.innerHTML=Ve),le=n(e),d(b.$$.fragment,e),ae=n(e),w=o(e,"P",{"data-svelte-h":!0}),i(w)!=="svelte-1mz23z"&&(w.innerHTML=Ee),ne=n(e),T=o(e,"UL",{"data-svelte-h":!0}),i(T)!=="svelte-150t55z"&&(T.innerHTML=ze),re=n(e),d(j.$$.fragment,e),oe=n(e),d(_.$$.fragment,e),ie=n(e),U=o(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1uu4te"&&(U.innerHTML=Re),pe=n(e),J=o(e,"P",{"data-svelte-h":!0}),i(J)!=="svelte-tebxht"&&(J.innerHTML=Ne),de=n(e),d($.$$.fragment,e),me=n(e),C=o(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1u5h2cp"&&(C.innerHTML=Qe),ce=n(e),d(g.$$.fragment,e),he=n(e),v=o(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1xokngn"&&(v.innerHTML=Ae),ue=n(e),d(k.$$.fragment,e),fe=n(e),B=o(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-uvge3w"&&(B.textContent=Fe),ye=n(e),I=o(e,"UL",{"data-svelte-h":!0}),i(I)!=="svelte-1288vg4"&&(I.innerHTML=Xe),Me=n(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-36itom"&&(Z.innerHTML=Se),be=n(e),L=o(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1juctzg"&&(L.innerHTML=Ye),we=n(e),G=o(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-ox6xuq"&&(G.textContent=Pe),Te=n(e),d(H.$$.fragment,e),je=n(e),d(W.$$.fragment,e),_e=n(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-b1r4nj"&&(x.innerHTML=De),Ue=n(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-u6wtm1"&&(V.innerHTML=qe),Je=n(e),d(E.$$.fragment,e),$e=n(e),z=o(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-k6rck4"&&(z.innerHTML=Ke),Ce=n(e),d(R.$$.fragment,e),ge=n(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-w3i56c"&&(N.textContent=Oe),ve=n(e),d(Q.$$.fragment,e),ke=n(e),A=o(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-3l1x7l"&&(A.innerHTML=et),Be=n(e),F=o(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1yfg992"&&(F.innerHTML=tt),Ie=n(e),d(X.$$.fragment,e),Ze=n(e),S=o(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1g75he3"&&(S.innerHTML=st),Le=n(e),d(Y.$$.fragment,e),Ge=n(e),P=o(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-aqcdsq"&&(P.innerHTML=lt),He=n(e),O=o(e,"P",{}),at(O).forEach(s),this.h()},h(){nt(f,"name","hf:doc:metadata"),nt(f,"content",ut)},m(e,t){ct(document.head,f),l(e,ee,t),l(e,K,t),l(e,te,t),m(y,e,t),l(e,se,t),l(e,M,t),l(e,le,t),m(b,e,t),l(e,ae,t),l(e,w,t),l(e,ne,t),l(e,T,t),l(e,re,t),m(j,e,t),l(e,oe,t),m(_,e,t),l(e,ie,t),l(e,U,t),l(e,pe,t),l(e,J,t),l(e,de,t),m($,e,t),l(e,me,t),l(e,C,t),l(e,ce,t),m(g,e,t),l(e,he,t),l(e,v,t),l(e,ue,t),m(k,e,t),l(e,fe,t),l(e,B,t),l(e,ye,t),l(e,I,t),l(e,Me,t),l(e,Z,t),l(e,be,t),l(e,L,t),l(e,we,t),l(e,G,t),l(e,Te,t),m(H,e,t),l(e,je,t),m(W,e,t),l(e,_e,t),l(e,x,t),l(e,Ue,t),l(e,V,t),l(e,Je,t),m(E,e,t),l(e,$e,t),l(e,z,t),l(e,Ce,t),m(R,e,t),l(e,ge,t),l(e,N,t),l(e,ve,t),m(Q,e,t),l(e,ke,t),l(e,A,t),l(e,Be,t),l(e,F,t),l(e,Ie,t),m(X,e,t),l(e,Ze,t),l(e,S,t),l(e,Le,t),m(Y,e,t),l(e,Ge,t),l(e,P,t),l(e,He,t),l(e,O,t),We=!0},p:ot,i(e){We||(c(y.$$.fragment,e),c(b.$$.fragment,e),c(j.$$.fragment,e),c(_.$$.fragment,e),c($.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(H.$$.fragment,e),c(W.$$.fragment,e),c(E.$$.fragment,e),c(R.$$.fragment,e),c(Q.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),We=!0)},o(e){h(y.$$.fragment,e),h(b.$$.fragment,e),h(j.$$.fragment,e),h(_.$$.fragment,e),h($.$$.fragment,e),h(g.$$.fragment,e),h(k.$$.fragment,e),h(H.$$.fragment,e),h(W.$$.fragment,e),h(E.$$.fragment,e),h(R.$$.fragment,e),h(Q.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),We=!1},d(e){e&&(s(ee),s(K),s(te),s(se),s(M),s(le),s(ae),s(w),s(ne),s(T),s(re),s(oe),s(ie),s(U),s(pe),s(J),s(de),s(me),s(C),s(ce),s(he),s(v),s(ue),s(fe),s(B),s(ye),s(I),s(Me),s(Z),s(be),s(L),s(we),s(G),s(Te),s(je),s(_e),s(x),s(Ue),s(V),s(Je),s($e),s(z),s(Ce),s(ge),s(N),s(ve),s(ke),s(A),s(Be),s(F),s(Ie),s(Ze),s(S),s(Le),s(Ge),s(P),s(He),s(O)),s(f),u(y,e),u(b,e),u(j,e),u(_,e),u($,e),u(g,e),u(k,e),u(H,e),u(W,e),u(E,e),u(R,e),u(Q,e),u(X,e),u(Y,e)}}}const ut='{"title":"Adding BetterTransformer support for new architectures","local":"adding-bettertransformer-support-for-new-architectures","sections":[{"title":"Models that should be supported","local":"models-that-should-be-supported","sections":[],"depth":2},{"title":"How to convert a model into its BetterTransformer format?","local":"how-to-convert-a-model-into-its-bettertransformer-format","sections":[{"title":"Step 1: Identifying the source layer to change","local":"step-1-identifying-the-source-layer-to-change","sections":[],"depth":3},{"title":"Step 2: Building the xxxLayerBetterTransformer module","local":"step-2-building-the-xxxlayerbettertransformer-module","sections":[],"depth":3},{"title":"Step 3: Building the forward pass","local":"step-3-building-the-forward-pass","sections":[],"depth":3},{"title":"Step 4: Sanity check!","local":"step-4-sanity-check","sections":[],"depth":3}],"depth":2}],"depth":1}';function ft(xe){return it(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends pt{constructor(f){super(),dt(this,f,ft,ht,rt,{})}}export{Tt as component};
