import{s as It,o as zt,n as _t}from"../chunks/scheduler.37c15a92.js";import{S as Vt,i as vt,g as i,s as l,r as p,A as At,h as o,f as t,c as a,j as Qt,u as c,x as r,k as $t,y as Bt,a as n,v as h,d as y,t as M,w as J}from"../chunks/index.2bf4358c.js";import{T as Zt}from"../chunks/Tip.363c041f.js";import{Y as Xt}from"../chunks/Youtube.1e50a667.js";import{C as u}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Wt}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as Se}from"../chunks/Heading.8ada512a.js";function Nt(Vs){let w,f="⚠️ Training a tokenizer is not the same as training a model! Model training uses stochastic gradient descent to make the loss a little bit smaller for each batch. It’s randomized by nature (meaning you have to set some seeds to get the same results when doing the same training twice). Training a tokenizer is a statistical process that tries to identify which subwords are the best to pick for a given corpus, and the exact rules used to pick them depend on the tokenization algorithm. It’s deterministic, meaning you always get the same results when training with the same algorithm on the same corpus.";return{c(){w=i("p"),w.textContent=f},l(m){w=o(m,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1w10tsl"&&(w.textContent=f)},m(m,zs){n(m,w,zs)},p:_t,d(m){m&&t(w)}}}function Gt(Vs){let w,f,m,zs,T,vs,g,As,j,qe='If a language model is not available in the language you are interested in, or if your corpus is very different from the one your language model was trained on, you will most likely want to retrain the model from scratch using a tokenizer adapted to your data. That will require training a new tokenizer on your dataset. But what exactly does that mean? When we first looked at tokenizers in <a href="/course/chapter2">Chapter 2</a>, we saw that most Transformer models use a <em>subword tokenization algorithm</em>. To identify which subwords are of interest and occur most frequently in the corpus at hand, the tokenizer needs to take a hard look at all the texts in the corpus — a process we call <em>training</em>. The exact rules that govern this training depend on the type of tokenizer used, and we’ll go over the three main algorithms later in this chapter.',Bs,x,Zs,d,Xs,U,Ws,b,Fe="There’s a very simple API in 🤗 Transformers that you can use to train a new tokenizer with the same characteristics as an existing one: <code>AutoTokenizer.train_new_from_iterator()</code>. To see this in action, let’s say we want to train GPT-2 from scratch, but in a language other than English. Our first task will be to gather lots of data in that language in a training corpus. To provide examples everyone will be able to understand, we won’t use a language like Russian or Chinese here, but rather a specialized English language: Python code.",Ns,k,Le='The <a href="https://github.com/huggingface/datasets" rel="nofollow">🤗 Datasets</a> library can help us assemble a corpus of Python source code. We’ll use the usual <code>load_dataset()</code> function to download and cache the <a href="https://huggingface.co/datasets/code_search_net" rel="nofollow">CodeSearchNet</a> dataset. This dataset was created for the <a href="https://wandb.ai/github/CodeSearchNet/benchmark" rel="nofollow">CodeSearchNet challenge</a> and contains millions of functions from open source libraries on GitHub in several programming languages. Here, we will load the Python part of this dataset:',Gs,C,Es,Q,Pe="We can have a look at the training split to see which columns we have access to:",Ds,$,Hs,I,Rs,z,Ke="We can see the dataset separates docstrings from code and suggests a tokenization of both. Here. we’ll just use the <code>whole_func_string</code> column to train our tokenizer. We can look at an example of one these functions by indexing into the <code>train</code> split:",Ys,_,Ss,V,Oe="which should print the following:",qs,v,Fs,A,st="The first thing we need to do is transform the dataset into an <em>iterator</em> of lists of texts — for instance, a list of list of texts. Using lists of texts will enable our tokenizer to go faster (training on batches of texts instead of processing individual texts one by one), and it should be an iterator if we want to avoid having everything in memory at once. If your corpus is huge, you will want to take advantage of the fact that 🤗 Datasets does not load everything into RAM but stores the elements of the dataset on disk.",Ls,B,et="Doing the following would create a list of lists of 1,000 texts each, but would load everything in memory:",Ps,Z,Ks,X,tt="Using a Python generator, we can avoid Python loading anything into memory until it’s actually necessary. To create such a generator, you just to need to replace the brackets with parentheses:",Os,W,se,N,nt="This line of code doesn’t fetch any elements of the dataset; it just creates an object you can use in a Python <code>for</code> loop. The texts will only be loaded when you need them (that is, when you’re at the step of the <code>for</code> loop that requires them), and only 1,000 texts at a time will be loaded. This way you won’t exhaust all your memory even if you are processing a huge dataset.",ee,G,lt="The problem with a generator object is that it can only be used once. So, instead of this giving us the list of the first 10 digits twice:",te,E,ne,D,at="we get them once and then an empty list:",le,H,ae,R,it="That’s why we define a function that returns a generator instead:",ie,Y,oe,S,ot="You can also define your generator inside a <code>for</code> loop by using the <code>yield</code> statement:",re,q,pe,F,rt="which will produce the exact same generator as before, but allows you to use more complex logic than you can in a list comprehension.",ce,L,he,P,pt="Now that we have our corpus in the form of an iterator of batches of texts, we are ready to train a new tokenizer. To do this, we first need to load the tokenizer we want to pair with our model (here, GPT-2):",ye,K,Me,O,ct="Even though we are going to train a new tokenizer, it’s a good idea to do this to avoid starting entirely from scratch. This way, we won’t have to specify anything about the tokenization algorithm or the special tokens we want to use; our new tokenizer will be exactly the same as GPT-2, and the only thing that will change is the vocabulary, which will be determined by the training on our corpus.",Je,ss,ht="First let’s have a look at how this tokenizer would treat an example function:",ue,es,we,ts,me,ns,yt="This tokenizer has a few special symbols, like <code>Ġ</code> and <code>Ċ</code>, which denote spaces and newlines, respectively. As we can see, this is not too efficient: the tokenizer returns individual tokens for each space, when it could group together indentation levels (since having sets of four or eight spaces is going to be very common in code). It also split the function name a bit weirdly, not being used to seeing words with the <code>_</code> character.",de,ls,Mt="Let’s train a new tokenizer and see if it solves those issues. For this, we’ll use the method <code>train_new_from_iterator()</code>:",fe,as,Te,is,Jt="This command might take a bit of time if your corpus is very large, but for this dataset of 1.6 GB of texts it’s  blazing fast (1 minute 16 seconds on an AMD Ryzen 9 3900X CPU with 12 cores).",ge,os,ut='Note that <code>AutoTokenizer.train_new_from_iterator()</code> only works if the tokenizer you are using is a “fast” tokenizer. As you’ll see in the next section, the 🤗 Transformers library contains two types of tokenizers: some are written purely in Python and others (the fast ones) are backed by the 🤗 Tokenizers library, which is written in the <a href="https://www.rust-lang.org" rel="nofollow">Rust</a> programming language. Python is the language most often used for data science and deep learning applications, but when anything needs to be parallelized to be fast, it has to be written in another language. For instance, the matrix multiplications that are at the core of the model computation are written in CUDA, an optimized C library for GPUs.',je,rs,wt='Training a brand new tokenizer in pure Python would be excruciatingly slow, which is why we developed the 🤗 Tokenizers library. Note that just as you didn’t have to learn the CUDA language to be able to execute your model on a batch of inputs on a GPU, you won’t need to learn Rust to use a fast tokenizer. The 🤗 Tokenizers library provides Python bindings for many methods that internally call some piece of code in Rust; for example, to parallelize the training of your new tokenizer or, as we saw in <a href="/course/chapter3">Chapter 3</a>, the tokenization of a batch of inputs.',xe,ps,mt='Most of the Transformer models have a fast tokenizer available (there are some exceptions that you can check <a href="https://huggingface.co/transformers/#supported-frameworks" rel="nofollow">here</a>), and the <code>AutoTokenizer</code> API always selects the fast tokenizer for you if it’s available. In the next section we’ll take a look at some of the other special features fast tokenizers have, which will be really useful for tasks like token classification and question answering. Before diving into that, however, let’s try our brand new tokenizer on the previous example:',Ue,cs,be,hs,ke,ys,dt="Here we again see the special symbols <code>Ġ</code> and <code>Ċ</code> that denote spaces and newlines, but we can also see that our tokenizer learned some tokens that are highly specific to a corpus of Python functions: for example, there is a <code>ĊĠĠĠ</code> token that represents an indentation, and a <code>Ġ&quot;&quot;&quot;</code> token that represents the three quotes that start a docstring. The tokenizer also correctly split the function name on <code>_</code>. This is quite a compact representation; comparatively, using the plain English tokenizer on the same example will give us a longer sentence:",Ce,Ms,Qe,Js,$e,us,ft="Let’s look at another example:",Ie,ws,ze,ms,_e,ds,Tt="In addition to the token corresponding to an indentation, here we can also see a token for a double indentation: <code>ĊĠĠĠĠĠĠĠ</code>. The special Python words like <code>class</code>, <code>init</code>, <code>call</code>, <code>self</code>, and <code>return</code> are each tokenized as one token, and we can see that as well as splitting on <code>_</code> and <code>.</code> the tokenizer correctly splits even camel-cased names: <code>LinearLayer</code> is tokenized as <code>[&quot;ĠLinear&quot;, &quot;Layer&quot;]</code>.",Ve,fs,ve,Ts,gt="To make sure we can use it later, we need to save our new tokenizer. Like for models, this is done with the <code>save_pretrained()</code> method:",Ae,gs,Be,js,jt="This will create a new folder named <em>code-search-net-tokenizer</em>, which will contain all the files the tokenizer needs to be reloaded. If you want to share this tokenizer with your colleagues and friends, you can upload it to the Hub by logging into your account. If you’re working in a notebook, there’s a convenience function to help you with this:",Ze,xs,Xe,Us,xt="This will display a widget where you can enter your Hugging Face login credentials. If you aren’t working in a notebook, just type the following line in your terminal:",We,bs,Ne,ks,Ut="Once you’ve logged in, you can push your tokenizer by executing the following command:",Ge,Cs,Ee,Qs,bt="This will create a new repository in your namespace with the name <code>code-search-net-tokenizer</code>, containing the tokenizer file. You can then load the tokenizer from anywhere with the <code>from_pretrained()</code> method:",De,$s,He,Is,kt='You’re now all set for training a language model from scratch and fine-tuning it on your task at hand! We’ll get to that in <a href="/course/chapter7">Chapter 7</a>, but first, in the rest of this chapter we’ll take a closer look at fast tokenizers and explore in detail what actually happens when we call the method <code>train_new_from_iterator()</code>.',Re,_s,Ye;return T=new Se({props:{title:"Training a new tokenizer from an old one",local:"training-a-new-tokenizer-from-an-old-one",headingTag:"h1"}}),g=new Wt({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"}]}}),x=new Xt({props:{id:"DJimQynXZsQ"}}),d=new Zt({props:{warning:!0,$$slots:{default:[Nt]},$$scope:{ctx:Vs}}}),U=new Se({props:{title:"Assembling a corpus",local:"assembling-a-corpus",headingTag:"h2"}}),C=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwVGhpcyUyMGNhbiUyMHRha2UlMjBhJTIwZmV3JTIwbWludXRlcyUyMHRvJTIwbG9hZCUyQyUyMHNvJTIwZ3JhYiUyMGElMjBjb2ZmZWUlMjBvciUyMHRlYSUyMHdoaWxlJTIweW91JTIwd2FpdCElMEFyYXdfZGF0YXNldHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyY29kZV9zZWFyY2hfbmV0JTIyJTJDJTIwJTIycHl0aG9uJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># This can take a few minutes to load, so grab a coffee or tea while you wait!</span>
raw_datasets = load_dataset(<span class="hljs-string">&quot;code_search_net&quot;</span>, <span class="hljs-string">&quot;python&quot;</span>)`,wrap:!1}}),$=new u({props:{code:"cmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),I=new u({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidyZXBvc2l0b3J5X25hbWUnJTJDJTIwJ2Z1bmNfcGF0aF9pbl9yZXBvc2l0b3J5JyUyQyUyMCdmdW5jX25hbWUnJTJDJTIwJ3dob2xlX2Z1bmNfc3RyaW5nJyUyQyUyMCdsYW5ndWFnZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3N0cmluZyclMkMlMjAnZnVuY19jb2RlX3Rva2VucyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3N0cmluZyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3Rva2VucyclMkMlMjAnc3BsaXRfbmFtZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3VybCclMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQxMjE3OCUwQSU3RCk=",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;repository_name&#x27;</span>, <span class="hljs-string">&#x27;func_path_in_repository&#x27;</span>, <span class="hljs-string">&#x27;func_name&#x27;</span>, <span class="hljs-string">&#x27;whole_func_string&#x27;</span>, <span class="hljs-string">&#x27;language&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_string&#x27;</span>, <span class="hljs-string">&#x27;func_code_tokens&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_string&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_tokens&#x27;</span>, <span class="hljs-string">&#x27;split_name&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_url&#x27;</span>
    ],
    num_rows: <span class="hljs-number">412178</span>
})`,wrap:!1}}),_=new u({props:{code:"cHJpbnQocmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlNUIxMjM0NTYlNUQlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">123456</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>])',wrap:!1}}),v=new u({props:{code:"ZGVmJTIwaGFuZGxlX3NpbXBsZV9yZXNwb25zZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwc2VsZiUyQyUyMHRpbWVvdXRfbXMlM0ROb25lJTJDJTIwaW5mb19jYiUzRERFRkFVTFRfTUVTU0FHRV9DQUxMQkFDSyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBY2NlcHRzJTIwbm9ybWFsJTIwcmVzcG9uc2VzJTIwZnJvbSUyMHRoZSUyMGRldmljZS4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGltZW91dF9tcyUzQSUyMFRpbWVvdXQlMjBpbiUyMG1pbGxpc2Vjb25kcyUyMHRvJTIwd2FpdCUyMGZvciUyMGVhY2glMjByZXNwb25zZS4lMEElMjAlMjAlMjAlMjAlMjAlMjBpbmZvX2NiJTNBJTIwT3B0aW9uYWwlMjBjYWxsYmFjayUyMGZvciUyMHRleHQlMjBzZW50JTIwZnJvbSUyMHRoZSUyMGJvb3Rsb2FkZXIuJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyME9LQVklMjBwYWNrZXQncyUyMG1lc3NhZ2UuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5fYWNjZXB0X3Jlc3BvbnNlcygnT0tBWSclMkMlMjBpbmZvX2NiJTJDJTIwdGltZW91dF9tcyUzRHRpbWVvdXRfbXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_simple_responses</span>(<span class="hljs-params">
      self, timeout_ms=<span class="hljs-literal">None</span>, info_cb=DEFAULT_MESSAGE_CALLBACK</span>):
    <span class="hljs-string">&quot;&quot;&quot;Accepts normal responses from the device.

    Args:
      timeout_ms: Timeout in milliseconds to wait for each response.
      info_cb: Optional callback for text sent from the bootloader.

    Returns:
      OKAY packet&#x27;s message.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> self._accept_responses(<span class="hljs-string">&#x27;OKAY&#x27;</span>, info_cb, timeout_ms=timeout_ms)`,wrap:!1}}),Z=new u({props:{code:"JTIzJTIwRG9uJ3QlMjB1bmNvbW1lbnQlMjB0aGUlMjBmb2xsb3dpbmclMjBsaW5lJTIwdW5sZXNzJTIweW91ciUyMGRhdGFzZXQlMjBpcyUyMHNtYWxsISUwQSUyMyUyMHRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMCU1QnJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTVE",highlighted:`<span class="hljs-comment"># Don&#x27;t uncomment the following line unless your dataset is small!</span>
<span class="hljs-comment"># training_corpus = [raw_datasets[&quot;train&quot;][i: i + 1000][&quot;whole_func_string&quot;] for i in range(0, len(raw_datasets[&quot;train&quot;]), 1000)]</span>`,wrap:!1}}),W=new u({props:{code:"dHJhaW5pbmdfY29ycHVzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBKQ==",highlighted:`training_corpus = (
    raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
)`,wrap:!1}}),E=new u({props:{code:"Z2VuJTIwJTNEJTIwKGklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCkpJTBBcHJpbnQobGlzdChnZW4pKSUwQXByaW50KGxpc3QoZ2VuKSk=",highlighted:`gen = (i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))`,wrap:!1}}),H=new u({props:{code:"JTVCMCUyQyUyMDElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUwQSU1QiU1RA==",highlighted:`[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]
[]`,wrap:!1}}),Y=new u({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUwQXRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMGdldF90cmFpbmluZ19jb3JwdXMoKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">return</span> (
        raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
    )


training_corpus = get_training_corpus()`,wrap:!1}}),q=new u({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwc3RhcnRfaWR4JTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKGRhdGFzZXQpJTJDJTIwMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVzJTIwJTNEJTIwZGF0YXNldCU1QnN0YXJ0X2lkeCUyMCUzQSUyMHN0YXJ0X2lkeCUyMCUyQiUyMDEwMDAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMHNhbXBsZXMlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    dataset = raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]
    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        samples = dataset[start_idx : start_idx + <span class="hljs-number">1000</span>]
        <span class="hljs-keyword">yield</span> samples[<span class="hljs-string">&quot;whole_func_string&quot;</span>]`,wrap:!1}}),L=new Se({props:{title:"Training a new tokenizer",local:"training-a-new-tokenizer",headingTag:"h2"}}),K=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFvbGRfdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

old_tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),es=new u({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCcnJ2RlZiUyMGFkZF9udW1iZXJzKGElMkMlMjBiKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFkZCUyMHRoZSUyMHR3byUyMG51bWJlcnMlMjAlNjBhJTYwJTIwYW5kJTIwJTYwYiU2MC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwJTJCJTIwYicnJyUwQSUwQXRva2VucyUyMCUzRCUyMG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSklMEF0b2tlbnM=",highlighted:`example = <span class="hljs-string">&#x27;&#x27;&#x27;def add_numbers(a, b):
    &quot;&quot;&quot;Add the two numbers \`a\` and \`b\`.&quot;&quot;&quot;
    return a + b&#x27;&#x27;&#x27;</span>

tokens = old_tokenizer.tokenize(example)
tokens`,wrap:!1}}),ts=new u({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCduJyUyQyUyMCd1bWJlcnMnJTJDJTIwJygnJTJDJTIwJ2EnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwYiclMkMlMjAnKSUzQSclMkMlMjAnJUM0JThBJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAlMjIlMjIlMjInJTJDJTIwJ0FkZCclMkMlMjAnJUM0JUEwdGhlJyUyQyUyMCclQzQlQTB0d28nJTJDJTBBJTIwJyVDNCVBMG51bWJlcnMnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYSclMkMlMjAnJTYwJyUyQyUyMCclQzQlQTBhbmQnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYiclMkMlMjAnJTYwJyUyQyUyMCcuJTIyJyUyQyUyMCclMjIlMjInJTJDJTIwJyVDNCU4QSclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;umbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>,\n <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;.&quot;&#x27;</span>, <span class="hljs-string">&#x27;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),as=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwb2xkX3Rva2VuaXplci50cmFpbl9uZXdfZnJvbV9pdGVyYXRvcih0cmFpbmluZ19jb3JwdXMlMkMlMjA1MjAwMCk=",highlighted:'tokenizer = old_tokenizer.train_new_from_iterator(training_corpus, <span class="hljs-number">52000</span>)',wrap:!1}}),cs=new u({props:{code:"dG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuaXplKGV4YW1wbGUpJTBBdG9rZW5z",highlighted:`tokens = tokenizer.tokenize(example)
tokens`,wrap:!1}}),hs=new u({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCdudW1iZXJzJyUyQyUyMCcoJyUyQyUyMCdhJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMGInJTJDJTIwJyklM0EnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwJTIyJTIyJTIyJyUyQyUyMCdBZGQnJTJDJTIwJyVDNCVBMHRoZSclMkMlMjAnJUM0JUEwdHdvJyUyQyUyMCclQzQlQTBudW1iZXJzJyUyQyUyMCclQzQlQTAlNjAnJTJDJTBBJTIwJ2EnJTJDJTIwJyU2MCclMkMlMjAnJUM0JUEwYW5kJyUyQyUyMCclQzQlQTAlNjAnJTJDJTIwJ2InJTJDJTIwJyU2MC4lMjIlMjIlMjInJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;numbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>, <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>,\n <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`.&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),Ms=new u({props:{code:"cHJpbnQobGVuKHRva2VucykpJTBBcHJpbnQobGVuKG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSkpKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(tokens))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(old_tokenizer.tokenize(example)))`,wrap:!1}}),Js=new u({props:{code:"MjclMEEzNg==",highlighted:`<span class="hljs-number">27</span>
<span class="hljs-number">36</span>`,wrap:!1}}),ws=new u({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCUyMiUyMiUyMmNsYXNzJTIwTGluZWFyTGF5ZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53ZWlnaHQlMjAlM0QlMjB0b3JjaC5yYW5kbihpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iaWFzJTIwJTNEJTIwdG9yY2guemVyb3Mob3V0cHV0X3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIweCUyMCU0MCUyMHNlbGYud2VpZ2h0cyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQXRva2VuaXplci50b2tlbml6ZShleGFtcGxlKQ==",highlighted:`example = <span class="hljs-string">&quot;&quot;&quot;class LinearLayer():
    def __init__(self, input_size, output_size):
        self.weight = torch.randn(input_size, output_size)
        self.bias = torch.zeros(output_size)

    def __call__(self, x):
        return x @ self.weights + self.bias
    &quot;&quot;&quot;</span>
tokenizer.tokenize(example)`,wrap:!1}}),ms=new u({props:{code:"JTVCJ2NsYXNzJyUyQyUyMCclQzQlQTBMaW5lYXInJTJDJTIwJ0xheWVyJyUyQyUyMCcoKSUzQSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBkZWYnJTJDJTIwJyVDNCVBMF9fJyUyQyUyMCdpbml0JyUyQyUyMCdfXygnJTJDJTIwJ3NlbGYnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwaW5wdXQnJTJDJTIwJ18nJTJDJTIwJ3NpemUnJTJDJTIwJyUyQyclMkMlMEElMjAnJUM0JUEwb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ3dlaWdodCclMkMlMjAnJUM0JUEwJTNEJyUyQyUyMCclQzQlQTB0b3JjaCclMkMlMjAnLiclMkMlMjAncmFuZG4nJTJDJTIwJygnJTJDJTIwJ2lucHV0JyUyQyUyMCdfJyUyQyUwQSUyMCdzaXplJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMG91dHB1dCclMkMlMjAnXyclMkMlMjAnc2l6ZSclMkMlMjAnKSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCdiaWFzJyUyQyUyMCclQzQlQTAlM0QnJTJDJTIwJyVDNCVBMHRvcmNoJyUyQyUyMCcuJyUyQyUyMCd6ZXJvcyclMkMlMjAnKCclMkMlMEElMjAnb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJyUyQyUyMCclQzQlOEElQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMGRlZiclMkMlMjAnJUM0JUEwX18nJTJDJTIwJ2NhbGwnJTJDJTIwJ19fKCclMkMlMjAnc2VsZiclMkMlMjAnJTJDJyUyQyUyMCclQzQlQTB4JyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTBBJTIwJyVDNCVBMHJldHVybiclMkMlMjAnJUM0JUEweCclMkMlMjAnJUM0JUEwJTQwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCd3ZWlnaHRzJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ2JpYXMnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCVDNCVBMCclNUQ=",highlighted:`[<span class="hljs-string">&#x27;class&#x27;</span>, <span class="hljs-string">&#x27;ĠLinear&#x27;</span>, <span class="hljs-string">&#x27;Layer&#x27;</span>, <span class="hljs-string">&#x27;():&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;init&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġinput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>,
 <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;randn&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;input&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>,
 <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;zeros&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>,
 <span class="hljs-string">&#x27;output&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;call&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>,
 <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;Ġ@&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weights&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠ&#x27;</span>]`,wrap:!1}}),fs=new Se({props:{title:"Saving the tokenizer",local:"saving-the-tokenizer",headingTag:"h2"}}),gs=new u({props:{code:"dG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:'tokenizer.save_pretrained(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),xs=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),bs=new u({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Cs=new u({props:{code:"dG9rZW5pemVyLnB1c2hfdG9faHViKCUyMmNvZGUtc2VhcmNoLW5ldC10b2tlbml6ZXIlMjIp",highlighted:'tokenizer.push_to_hub(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),$s=new u({props:{code:"JTIzJTIwUmVwbGFjZSUyMCUyMmh1Z2dpbmdmYWNlLWNvdXJzZSUyMiUyMGJlbG93JTIwd2l0aCUyMHlvdXIlMjBhY3R1YWwlMjBuYW1lc3BhY2UlMjB0byUyMHVzZSUyMHlvdXIlMjBvd24lMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJodWdnaW5nZmFjZS1jb3Vyc2UlMkZjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:`<span class="hljs-comment"># Replace &quot;huggingface-course&quot; below with your actual namespace to use your own tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;huggingface-course/code-search-net-tokenizer&quot;</span>)`,wrap:!1}}),{c(){w=i("meta"),f=l(),m=i("p"),zs=l(),p(T.$$.fragment),vs=l(),p(g.$$.fragment),As=l(),j=i("p"),j.innerHTML=qe,Bs=l(),p(x.$$.fragment),Zs=l(),p(d.$$.fragment),Xs=l(),p(U.$$.fragment),Ws=l(),b=i("p"),b.innerHTML=Fe,Ns=l(),k=i("p"),k.innerHTML=Le,Gs=l(),p(C.$$.fragment),Es=l(),Q=i("p"),Q.textContent=Pe,Ds=l(),p($.$$.fragment),Hs=l(),p(I.$$.fragment),Rs=l(),z=i("p"),z.innerHTML=Ke,Ys=l(),p(_.$$.fragment),Ss=l(),V=i("p"),V.textContent=Oe,qs=l(),p(v.$$.fragment),Fs=l(),A=i("p"),A.innerHTML=st,Ls=l(),B=i("p"),B.textContent=et,Ps=l(),p(Z.$$.fragment),Ks=l(),X=i("p"),X.textContent=tt,Os=l(),p(W.$$.fragment),se=l(),N=i("p"),N.innerHTML=nt,ee=l(),G=i("p"),G.textContent=lt,te=l(),p(E.$$.fragment),ne=l(),D=i("p"),D.textContent=at,le=l(),p(H.$$.fragment),ae=l(),R=i("p"),R.textContent=it,ie=l(),p(Y.$$.fragment),oe=l(),S=i("p"),S.innerHTML=ot,re=l(),p(q.$$.fragment),pe=l(),F=i("p"),F.textContent=rt,ce=l(),p(L.$$.fragment),he=l(),P=i("p"),P.textContent=pt,ye=l(),p(K.$$.fragment),Me=l(),O=i("p"),O.textContent=ct,Je=l(),ss=i("p"),ss.textContent=ht,ue=l(),p(es.$$.fragment),we=l(),p(ts.$$.fragment),me=l(),ns=i("p"),ns.innerHTML=yt,de=l(),ls=i("p"),ls.innerHTML=Mt,fe=l(),p(as.$$.fragment),Te=l(),is=i("p"),is.textContent=Jt,ge=l(),os=i("p"),os.innerHTML=ut,je=l(),rs=i("p"),rs.innerHTML=wt,xe=l(),ps=i("p"),ps.innerHTML=mt,Ue=l(),p(cs.$$.fragment),be=l(),p(hs.$$.fragment),ke=l(),ys=i("p"),ys.innerHTML=dt,Ce=l(),p(Ms.$$.fragment),Qe=l(),p(Js.$$.fragment),$e=l(),us=i("p"),us.textContent=ft,Ie=l(),p(ws.$$.fragment),ze=l(),p(ms.$$.fragment),_e=l(),ds=i("p"),ds.innerHTML=Tt,Ve=l(),p(fs.$$.fragment),ve=l(),Ts=i("p"),Ts.innerHTML=gt,Ae=l(),p(gs.$$.fragment),Be=l(),js=i("p"),js.innerHTML=jt,Ze=l(),p(xs.$$.fragment),Xe=l(),Us=i("p"),Us.textContent=xt,We=l(),p(bs.$$.fragment),Ne=l(),ks=i("p"),ks.textContent=Ut,Ge=l(),p(Cs.$$.fragment),Ee=l(),Qs=i("p"),Qs.innerHTML=bt,De=l(),p($s.$$.fragment),He=l(),Is=i("p"),Is.innerHTML=kt,Re=l(),_s=i("p"),this.h()},l(s){const e=At("svelte-u9bgzb",document.head);w=o(e,"META",{name:!0,content:!0}),e.forEach(t),f=a(s),m=o(s,"P",{}),Qt(m).forEach(t),zs=a(s),c(T.$$.fragment,s),vs=a(s),c(g.$$.fragment,s),As=a(s),j=o(s,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ge9o4k"&&(j.innerHTML=qe),Bs=a(s),c(x.$$.fragment,s),Zs=a(s),c(d.$$.fragment,s),Xs=a(s),c(U.$$.fragment,s),Ws=a(s),b=o(s,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1h1d1jb"&&(b.innerHTML=Fe),Ns=a(s),k=o(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-d4p7ba"&&(k.innerHTML=Le),Gs=a(s),c(C.$$.fragment,s),Es=a(s),Q=o(s,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-12bpn2p"&&(Q.textContent=Pe),Ds=a(s),c($.$$.fragment,s),Hs=a(s),c(I.$$.fragment,s),Rs=a(s),z=o(s,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ttcdha"&&(z.innerHTML=Ke),Ys=a(s),c(_.$$.fragment,s),Ss=a(s),V=o(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1go55zn"&&(V.textContent=Oe),qs=a(s),c(v.$$.fragment,s),Fs=a(s),A=o(s,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1w4rq2j"&&(A.innerHTML=st),Ls=a(s),B=o(s,"P",{"data-svelte-h":!0}),r(B)!=="svelte-n3iewp"&&(B.textContent=et),Ps=a(s),c(Z.$$.fragment,s),Ks=a(s),X=o(s,"P",{"data-svelte-h":!0}),r(X)!=="svelte-z3gyd6"&&(X.textContent=tt),Os=a(s),c(W.$$.fragment,s),se=a(s),N=o(s,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1m62zsw"&&(N.innerHTML=nt),ee=a(s),G=o(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-y43dl1"&&(G.textContent=lt),te=a(s),c(E.$$.fragment,s),ne=a(s),D=o(s,"P",{"data-svelte-h":!0}),r(D)!=="svelte-nyttr1"&&(D.textContent=at),le=a(s),c(H.$$.fragment,s),ae=a(s),R=o(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1ja5i79"&&(R.textContent=it),ie=a(s),c(Y.$$.fragment,s),oe=a(s),S=o(s,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1ujnh8r"&&(S.innerHTML=ot),re=a(s),c(q.$$.fragment,s),pe=a(s),F=o(s,"P",{"data-svelte-h":!0}),r(F)!=="svelte-15t5zhk"&&(F.textContent=rt),ce=a(s),c(L.$$.fragment,s),he=a(s),P=o(s,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1if3zzd"&&(P.textContent=pt),ye=a(s),c(K.$$.fragment,s),Me=a(s),O=o(s,"P",{"data-svelte-h":!0}),r(O)!=="svelte-gfsdsz"&&(O.textContent=ct),Je=a(s),ss=o(s,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-1whi783"&&(ss.textContent=ht),ue=a(s),c(es.$$.fragment,s),we=a(s),c(ts.$$.fragment,s),me=a(s),ns=o(s,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1n6ojb6"&&(ns.innerHTML=yt),de=a(s),ls=o(s,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-1wg3w1a"&&(ls.innerHTML=Mt),fe=a(s),c(as.$$.fragment,s),Te=a(s),is=o(s,"P",{"data-svelte-h":!0}),r(is)!=="svelte-1s55tci"&&(is.textContent=Jt),ge=a(s),os=o(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-1cil686"&&(os.innerHTML=ut),je=a(s),rs=o(s,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-9eiphm"&&(rs.innerHTML=wt),xe=a(s),ps=o(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-kzj4vn"&&(ps.innerHTML=mt),Ue=a(s),c(cs.$$.fragment,s),be=a(s),c(hs.$$.fragment,s),ke=a(s),ys=o(s,"P",{"data-svelte-h":!0}),r(ys)!=="svelte-1si8jb2"&&(ys.innerHTML=dt),Ce=a(s),c(Ms.$$.fragment,s),Qe=a(s),c(Js.$$.fragment,s),$e=a(s),us=o(s,"P",{"data-svelte-h":!0}),r(us)!=="svelte-1hvz582"&&(us.textContent=ft),Ie=a(s),c(ws.$$.fragment,s),ze=a(s),c(ms.$$.fragment,s),_e=a(s),ds=o(s,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-1anhj7k"&&(ds.innerHTML=Tt),Ve=a(s),c(fs.$$.fragment,s),ve=a(s),Ts=o(s,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-ot264x"&&(Ts.innerHTML=gt),Ae=a(s),c(gs.$$.fragment,s),Be=a(s),js=o(s,"P",{"data-svelte-h":!0}),r(js)!=="svelte-1oaabmx"&&(js.innerHTML=jt),Ze=a(s),c(xs.$$.fragment,s),Xe=a(s),Us=o(s,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-mgkzhm"&&(Us.textContent=xt),We=a(s),c(bs.$$.fragment,s),Ne=a(s),ks=o(s,"P",{"data-svelte-h":!0}),r(ks)!=="svelte-gbhb1u"&&(ks.textContent=Ut),Ge=a(s),c(Cs.$$.fragment,s),Ee=a(s),Qs=o(s,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-eipxyz"&&(Qs.innerHTML=bt),De=a(s),c($s.$$.fragment,s),He=a(s),Is=o(s,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-1r3xq8e"&&(Is.innerHTML=kt),Re=a(s),_s=o(s,"P",{}),Qt(_s).forEach(t),this.h()},h(){$t(w,"name","hf:doc:metadata"),$t(w,"content",Et)},m(s,e){Bt(document.head,w),n(s,f,e),n(s,m,e),n(s,zs,e),h(T,s,e),n(s,vs,e),h(g,s,e),n(s,As,e),n(s,j,e),n(s,Bs,e),h(x,s,e),n(s,Zs,e),h(d,s,e),n(s,Xs,e),h(U,s,e),n(s,Ws,e),n(s,b,e),n(s,Ns,e),n(s,k,e),n(s,Gs,e),h(C,s,e),n(s,Es,e),n(s,Q,e),n(s,Ds,e),h($,s,e),n(s,Hs,e),h(I,s,e),n(s,Rs,e),n(s,z,e),n(s,Ys,e),h(_,s,e),n(s,Ss,e),n(s,V,e),n(s,qs,e),h(v,s,e),n(s,Fs,e),n(s,A,e),n(s,Ls,e),n(s,B,e),n(s,Ps,e),h(Z,s,e),n(s,Ks,e),n(s,X,e),n(s,Os,e),h(W,s,e),n(s,se,e),n(s,N,e),n(s,ee,e),n(s,G,e),n(s,te,e),h(E,s,e),n(s,ne,e),n(s,D,e),n(s,le,e),h(H,s,e),n(s,ae,e),n(s,R,e),n(s,ie,e),h(Y,s,e),n(s,oe,e),n(s,S,e),n(s,re,e),h(q,s,e),n(s,pe,e),n(s,F,e),n(s,ce,e),h(L,s,e),n(s,he,e),n(s,P,e),n(s,ye,e),h(K,s,e),n(s,Me,e),n(s,O,e),n(s,Je,e),n(s,ss,e),n(s,ue,e),h(es,s,e),n(s,we,e),h(ts,s,e),n(s,me,e),n(s,ns,e),n(s,de,e),n(s,ls,e),n(s,fe,e),h(as,s,e),n(s,Te,e),n(s,is,e),n(s,ge,e),n(s,os,e),n(s,je,e),n(s,rs,e),n(s,xe,e),n(s,ps,e),n(s,Ue,e),h(cs,s,e),n(s,be,e),h(hs,s,e),n(s,ke,e),n(s,ys,e),n(s,Ce,e),h(Ms,s,e),n(s,Qe,e),h(Js,s,e),n(s,$e,e),n(s,us,e),n(s,Ie,e),h(ws,s,e),n(s,ze,e),h(ms,s,e),n(s,_e,e),n(s,ds,e),n(s,Ve,e),h(fs,s,e),n(s,ve,e),n(s,Ts,e),n(s,Ae,e),h(gs,s,e),n(s,Be,e),n(s,js,e),n(s,Ze,e),h(xs,s,e),n(s,Xe,e),n(s,Us,e),n(s,We,e),h(bs,s,e),n(s,Ne,e),n(s,ks,e),n(s,Ge,e),h(Cs,s,e),n(s,Ee,e),n(s,Qs,e),n(s,De,e),h($s,s,e),n(s,He,e),n(s,Is,e),n(s,Re,e),n(s,_s,e),Ye=!0},p(s,[e]){const Ct={};e&2&&(Ct.$$scope={dirty:e,ctx:s}),d.$set(Ct)},i(s){Ye||(y(T.$$.fragment,s),y(g.$$.fragment,s),y(x.$$.fragment,s),y(d.$$.fragment,s),y(U.$$.fragment,s),y(C.$$.fragment,s),y($.$$.fragment,s),y(I.$$.fragment,s),y(_.$$.fragment,s),y(v.$$.fragment,s),y(Z.$$.fragment,s),y(W.$$.fragment,s),y(E.$$.fragment,s),y(H.$$.fragment,s),y(Y.$$.fragment,s),y(q.$$.fragment,s),y(L.$$.fragment,s),y(K.$$.fragment,s),y(es.$$.fragment,s),y(ts.$$.fragment,s),y(as.$$.fragment,s),y(cs.$$.fragment,s),y(hs.$$.fragment,s),y(Ms.$$.fragment,s),y(Js.$$.fragment,s),y(ws.$$.fragment,s),y(ms.$$.fragment,s),y(fs.$$.fragment,s),y(gs.$$.fragment,s),y(xs.$$.fragment,s),y(bs.$$.fragment,s),y(Cs.$$.fragment,s),y($s.$$.fragment,s),Ye=!0)},o(s){M(T.$$.fragment,s),M(g.$$.fragment,s),M(x.$$.fragment,s),M(d.$$.fragment,s),M(U.$$.fragment,s),M(C.$$.fragment,s),M($.$$.fragment,s),M(I.$$.fragment,s),M(_.$$.fragment,s),M(v.$$.fragment,s),M(Z.$$.fragment,s),M(W.$$.fragment,s),M(E.$$.fragment,s),M(H.$$.fragment,s),M(Y.$$.fragment,s),M(q.$$.fragment,s),M(L.$$.fragment,s),M(K.$$.fragment,s),M(es.$$.fragment,s),M(ts.$$.fragment,s),M(as.$$.fragment,s),M(cs.$$.fragment,s),M(hs.$$.fragment,s),M(Ms.$$.fragment,s),M(Js.$$.fragment,s),M(ws.$$.fragment,s),M(ms.$$.fragment,s),M(fs.$$.fragment,s),M(gs.$$.fragment,s),M(xs.$$.fragment,s),M(bs.$$.fragment,s),M(Cs.$$.fragment,s),M($s.$$.fragment,s),Ye=!1},d(s){s&&(t(f),t(m),t(zs),t(vs),t(As),t(j),t(Bs),t(Zs),t(Xs),t(Ws),t(b),t(Ns),t(k),t(Gs),t(Es),t(Q),t(Ds),t(Hs),t(Rs),t(z),t(Ys),t(Ss),t(V),t(qs),t(Fs),t(A),t(Ls),t(B),t(Ps),t(Ks),t(X),t(Os),t(se),t(N),t(ee),t(G),t(te),t(ne),t(D),t(le),t(ae),t(R),t(ie),t(oe),t(S),t(re),t(pe),t(F),t(ce),t(he),t(P),t(ye),t(Me),t(O),t(Je),t(ss),t(ue),t(we),t(me),t(ns),t(de),t(ls),t(fe),t(Te),t(is),t(ge),t(os),t(je),t(rs),t(xe),t(ps),t(Ue),t(be),t(ke),t(ys),t(Ce),t(Qe),t($e),t(us),t(Ie),t(ze),t(_e),t(ds),t(Ve),t(ve),t(Ts),t(Ae),t(Be),t(js),t(Ze),t(Xe),t(Us),t(We),t(Ne),t(ks),t(Ge),t(Ee),t(Qs),t(De),t(He),t(Is),t(Re),t(_s)),t(w),J(T,s),J(g,s),J(x,s),J(d,s),J(U,s),J(C,s),J($,s),J(I,s),J(_,s),J(v,s),J(Z,s),J(W,s),J(E,s),J(H,s),J(Y,s),J(q,s),J(L,s),J(K,s),J(es,s),J(ts,s),J(as,s),J(cs,s),J(hs,s),J(Ms,s),J(Js,s),J(ws,s),J(ms,s),J(fs,s),J(gs,s),J(xs,s),J(bs,s),J(Cs,s),J($s,s)}}}const Et='{"title":"Training a new tokenizer from an old one","local":"training-a-new-tokenizer-from-an-old-one","sections":[{"title":"Assembling a corpus","local":"assembling-a-corpus","sections":[],"depth":2},{"title":"Training a new tokenizer","local":"training-a-new-tokenizer","sections":[],"depth":2},{"title":"Saving the tokenizer","local":"saving-the-tokenizer","sections":[],"depth":2}],"depth":1}';function Dt(Vs){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends Vt{constructor(w){super(),vt(this,w,Dt,Gt,It,{})}}export{Pt as component};
