import{s as Ba,o as xa,n as Re}from"../chunks/scheduler.37c15a92.js";import{S as Za,i as Ga,g as u,s as t,r as p,A as Va,h as J,f as a,c as n,j as Ia,u as r,x as y,k as $a,y as Wa,a as l,v as o,d,t as c,w as m}from"../chunks/index.2bf4358c.js";import{T as ke}from"../chunks/Tip.363c041f.js";import{Y as ka}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ra}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as Ss}from"../chunks/Heading.8ada512a.js";function Ca(b){let i,j='✎ Por defecto, 🤗 Datasets va a descomprimir los archivos necesarios para cargar un dataset. Si quieres ahorrar espacio de almacenamiento, puedes usar <code>DownloadConfig(delete_extracted=True)</code> al argumento <code>download_config</code> de <code>load_dataset()</code>. Revisa la <a href="https://huggingface.co/docs/datasets/package_reference/builder_classes#datasets.DownloadConfig" rel="nofollow">documentación</a> para más detalles.';return{c(){i=u("p"),i.innerHTML=j},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1vcz8if"&&(i.innerHTML=j)},m(M,h){l(M,i,h)},p:Re,d(M){M&&a(i)}}}function Ea(b){let i,j='✏️ <strong>¡Inténtalo!</strong> Escoge alguno de los <a href="https://mystic.the-eye.eu/public/AI/pile_preliminary_components/" rel="nofollow">subconjuntos</a> del <em>Pile</em> que sea más grande que la RAM de tu computador portátil o de escritorio, cárgalo con 🤗 Datasets y mide la cantidad de RAM utilizada. Recuerda que para tener una medición precisa, tienes que hacerlo en un nuevo proceso. Puedes encontrar los tamaños de cada uno de los subconjuntos sin comprimir en la Tabla 1 del <a href="https://arxiv.org/abs/2101.00027" rel="nofollow">paper de <em>Pile</em></a>.';return{c(){i=u("p"),i.innerHTML=j},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1udxpjd"&&(i.innerHTML=j)},m(M,h){l(M,i,h)},p:Re,d(M){M&&a(i)}}}function Xa(b){let i,j='💡 En los cuadernos de Jupyter también puedes medir el tiempo de ejecución de las celdas usando <a href="https://ipython.readthedocs.io/en/stable/interactive/magics.html#magic-timeit" rel="nofollow"><code>%%timeit</code></a>.';return{c(){i=u("p"),i.innerHTML=j},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1pb1ytq"&&(i.innerHTML=j)},m(M,h){l(M,i,h)},p:Re,d(M){M&&a(i)}}}function va(b){let i,j="💡 Para acelerar la tokenización con <em>streaming</em> puedes definir <code>batched=True</code>, como lo vimos en la sección anterior. Esto va a procesar los ejemplos lote por lote. Recuerda que el tamaño por defecto de los lotes es 1.000 y puede ser especificado con el argumento <code>batch_size</code>.";return{c(){i=u("p"),i.innerHTML=j},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-e5qad3"&&(i.innerHTML=j)},m(M,h){l(M,i,h)},p:Re,d(M){M&&a(i)}}}function Na(b){let i,j='✏️ <strong>¡Inténtalo!</strong> Usa alguno de los corpus grandes de Common Crawl como <a href="https://huggingface.co/datasets/mc4" rel="nofollow"><code>mc4</code></a> u <a href="https://huggingface.co/datasets/oscar" rel="nofollow"><code>oscar</code></a> para crear un dataset <em>streaming</em> multilenguaje que represente las proporciones de lenguajes hablados en un país de tu elección. Por ejemplo, los 4 lenguajes nacionales en Suiza son alemán, francés, italiano y romanche, así que podrías crear un corpus suizo al hacer un muestreo de Oscar de acuerdo con su proporción de lenguaje.';return{c(){i=u("p"),i.innerHTML=j},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-19fsbe0"&&(i.innerHTML=j)},m(M,h){l(M,i,h)},p:Re,d(M){M&&a(i)}}}function _a(b){let i,j,M,h,$,Ce,B,Ee,x,Ds="Hoy en día es común que tengas que trabajar con dataset de varios GB, especialmente si planeas pre-entrenar un transformador como BERT o GPT-2 desde ceros. En estos casos, <em>solamente cargar</em> los datos puede ser un desafío. Por ejemplo, el corpus de WebText utilizado para preentrenar GPT-2 consiste de más de 8 millones de documentos y 40 GB de texto. ¡Cargarlo en la RAM de tu computador portátil le va a causar un paro cardíaco!",Xe,Z,qs="Afortunadamente, 🤗 Datasets está diseñado para superar estas limitaciones: te libera de problemas de manejo de memoria al tratar los datasets como archivos <em>proyectados en memoria</em> (<em>memory-mapped</em>) y de límites de almacenamiento al hacer <em>streaming</em> de las entradas en un corpus.",ve,G,Ne,V,Ls='En esta sección vamos a explorar estas funcionalidades de 🤗 Datasets con un corpus enorme de 825 GB conocido como el <a href="https://pile.eleuther.ai" rel="nofollow">Pile</a>. ¡Comencemos!',_e,W,ze,k,Ps='El <em>Pile</em> es un corpus de textos en inglés creado por <a href="https://www.eleuther.ai" rel="nofollow">EleutherAI</a> para entrenar modelos de lenguaje de gran escala. Incluye una selección diversa de datasets que abarca artículos científicos, repositorios de código de Github y texto filtrado de la web. El corpus de entrenamiento está disponible en <a href="https://mystic.the-eye.eu/public/AI/pile/" rel="nofollow">partes de 14 GB</a> y también puedes descargar varios de los <a href="https://mystic.the-eye.eu/public/AI/pile_preliminary_components/" rel="nofollow">componentes individuales</a>. Arranquemos viendo el dataset de los abstracts de PubMed, un corpus de abstracts de 15 millones de publicaciones biomédicas en <a href="https://pubmed.ncbi.nlm.nih.gov/" rel="nofollow">PubMed</a>. Este dataset está en formato <a href="https://jsonlines.org" rel="nofollow">JSON Lines</a> y está comprimido con la librería <code>zstandard</code>, así que primero tenemos que instalarla:',Qe,R,Ye,C,Os='A continuación, podemos cargar el dataset usando el método para archivos remotos que aprendimos en la <a href="/course/chapter5/2">sección 2</a>:',He,E,Fe,X,Ae,v,Ks="Como podemos ver, hay 15.518.009 filas y dos columnas en el dataset, ¡un montón!",Se,f,De,N,ea="Veamos el contenido del primer ejemplo:",qe,_,Le,z,Pe,Q,sa="Ok, esto parece el abstract de un artículo médico. Ahora miremos cuánta RAM hemos usado para cargar el dataset.",Oe,Y,Ke,H,aa='Una forma simple de medir el uso de memoria en Python es con la librería <a href="https://psutil.readthedocs.io/en/latest/" rel="nofollow"><code>psutil</code></a>, que se puede instalar con <code>pip</code> así:',es,F,ss,A,la="Esta librería contiene una clase <code>Process</code> que nos permite revisar el uso de memoria del proceso actual:",as,S,ls,D,ts,q,ta="El atributo <code>rss</code> se refiere al <em>resident set size</em>, que es la fracción de memoria que un proceso ocupa en RAM. Esta medición también incluye la memoria usada por el intérprete de Python y las librerías que hemos cargado, así que la cantidad real de memoria usada para cargar el dataset es un poco más pequeña. A modo de comparación, veamos qué tan grande es el dataset en disco, usando el atributo <code>dataset_size</code>. Dado que el resultado está expresado en bytes, tenemos que convertirlo manualmente en gigabytes:",ns,L,is,P,ps,O,na="Bien, a pesar de que el archivo es de casi 20 GB, ¡podemos cargarlo y acceder a su contenido con mucha menos RAM!",rs,w,os,K,ia='Si estás familiarizado con Pandas, este resultado puede ser sorprendente por la famosa <a href="https://wesmckinney.com/blog/apache-arrow-pandas-internals/" rel="nofollow">regla de Wes Kinney</a> que indica que típicamente necesitas de 5 a 10 veces la RAM que el tamaño del archivo de tu dataset. ¿Cómo resuelve entonces 🤗 Datasets este problema de manejo de memoria? 🤗 Datasets trata cada dataset como un <a href="https://en.wikipedia.org/wiki/Memory-mapped_file" rel="nofollow">archivo proyectado en memoria</a>, lo que permite un mapeo entre la RAM y el sistema de almacenamiento de archivos, que le permite a la librería acceder y operar los elementos del dataset sin necesidad de tenerlos cargados completamente en memoria.',ds,ee,pa='Los archivos proyectados en memoria también pueden ser compartidos por múltiples procesos, lo que habilita la paralelización de métodos como <code>Dataset.map()</code> sin que sea obligatorio mover o copiar el dataset. Internamente, estas capacidades se logran gracias al formato de memoria <a href="https://arrow.apache.org" rel="nofollow">Apache Arrow</a> y la librería <a href="https://arrow.apache.org/docs/python/index.html" rel="nofollow"><code>pyarrow</code></a>, que permiten la carga y procesamiento de datos a gran velocidad. (Para ahondar más en Apache Arrow y algunas comparaciones con Pandas, revisa el <a href="https://towardsdatascience.com/apache-arrow-read-dataframe-with-zero-memory-69634092b1a" rel="nofollow">blog de Dejan Simic</a>). Para verlo en acción, ejecutemos un test de velocidad iterando sobre todos los elementos del dataset de abstracts de PubMed:',cs,se,ms,ae,Ms,le,ra="Aquí usamos el módulo <code>timeit</code> de Python para medir el tiempo de ejecución que se toma <code>code_snippet</code>. Típicamemente, puedes iterar a lo largo de un dataset a una velocidad de unas cuantas décimas de un GB por segundo. Esto funciona muy bien para la gran mayoría de aplicaciones, pero algunas veces tendrás que trabajar con un dataset que es tan grande para incluso almacenarse en el disco de tu computador. Por ejemplo, si quisieramos descargar el <em>Pile</em> completo ¡necesitaríamos 825 GB de almacenamiento libre! Para trabajar con esos casos, 🤗 Datasets puede trabajar haciendo <em>streaming</em>, lo que permite la descarga y acceso a los elementos sobre la marcha, sin necesidad de descargar todo el dataset. Veamos cómo funciona:",us,U,Js,te,ys,ne,oa="Para habilitar el <em>streaming</em> basta con pasar el argumento <code>streaming=True</code> a la función <code>load_dataset()</code>. Por ejemplo, carguemos el dataset de abstracts de PubMed de nuevo, pero en modo <em>streaming</em>.",Ts,ie,js,pe,da="En vez del <code>Dataset</code> común y corriente que nos hemos encontrado en el resto del capítulo, el objeto devuelto con <code>streaming=True</code> es un <code>IterableDataset</code>. Como su nombre lo indica, para acceder a los elementos de un <code>IterableDataset</code> tenemos que iterar sobre él. Podemos acceder al primer elemento de nuestro dataset de la siguiente manera:",hs,re,bs,oe,fs,de,ca='Los elementos de un dataset <em>streamed</em> pueden ser procesados sobre la marcha usando <code>IterableDataset.map()</code>, lo que puede servirte si tienes que tokenizar los inputs. El proceso es exactamente el mismo que el que usamos para tokenizar nuestro dataset en el <a href="/course/chapter3">Capítulo 3</a>, con la única diferencia de que los outputs se devuelven uno por uno.',ws,ce,Us,me,gs,g,Is,Me,ma="También puedes aleatorizar el orden de un dataset <em>streamed</em> usando <code>IterableDataset.shuffle()</code>, pero a diferencia de <code>Dataset.shuffle()</code> esto sólo afecta a los elementos en un <code>buffer_size</code> determinado:",$s,ue,Bs,Je,xs,ye,Ma="En este ejemplo, seleccionamos un ejemplo aleatorio de los primeros 10.000 ejemplos en el buffer. Apenas se accede a un ejemplo, su lugar en el buffer se llena con el siguiente ejemplo en el corpus (i.e., el ejemplo número 10.001). También puedes seleccionar elementos de un dataset <em>streamed</em> usando las funciones <code>IterableDataset.take()</code> y <code>IterableDataset.skip()</code>, que funcionan de manera similar a <code>Dataset.select()</code>. Por ejemplo, para seleccionar los 5 primeros ejemplos en el dataset de abstracts de PubMed podemos hacer lo siguiente:",Zs,Te,Gs,je,Vs,he,ua="También podemos usar la función <code>IterableDataset.skip()</code> para crear conjuntos de entrenamiento y validación de un dataset ordenado aleatoriamente así:",Ws,be,ks,fe,Ja="Vamos a repasar la exploración del <em>streaming</em> de datasets con una aplicación común: combinar múltiples datasets para crear un solo corpus. 🤗 Datasets provee una función <code>interleave_datasets()</code> que convierte una lista de objetos <code>IterableDataset</code> en un solo <code>IterableDataset</code>, donde la lista de elementos del nuevo dataset se obtiene al alternar entre los ejemplos originales. Esta función es particularmente útil cuando quieres combinar datasets grandes, así que como ejemplo hagamos <em>streaming</em> del conjunto FreeLaw del <em>Pile</em>, que es un dataset de 51 GB con opiniones legales de las cortes en Estados Unidos.",Rs,we,Cs,Ue,Es,ge,ya="Este dataset es lo suficientemente grande como para llevar al límite la RAM de la mayoría de computadores portátiles. Sin embargo, ¡podemos cargarla y acceder a el sin esfuerzo! Ahora combinemos los ejemplos de FreeLaw y PubMed usando la función <code>interleave_datasets()</code>:",Xs,Ie,vs,$e,Ns,Be,Ta="Usamos la función <code>islice()</code> del módulo <code>itertools</code> de Python para seleccionar los primeros dos ejemplos del dataset combinado y podemos ver que corresponden con los primeros dos ejemplos de cada uno de los dos datasets de origen.",_s,xe,ja="Finalmente, si quieres hacer <em>streaming</em> del <em>Pile</em> de 825 GB en su totalidad, puedes usar todos los archivos preparados de la siguiente manera:",zs,Ze,Qs,Ge,Ys,I,Hs,Ve,ha="Ya tienes todas las herramientas para cargar y procesar datasets de todas las formas y tamaños, pero a menos que seas muy afortunado, llegará un punto en tu camino de PLN en el que tendrás que crear el dataset tu mismo para resolver tu problema particular. De esto hablaremos en la siguiente sección.",Fs,We,As;return $=new Ss({props:{title:"¿Big data? 🤗 ¡Datasets al rescate!",local:"big-data--datasets-al-rescate",headingTag:"h1"}}),B=new Ra({props:{chapter:5,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"}]}}),G=new ka({props:{id:"JwISwTCPPWo"}}),W=new Ss({props:{title:"¿Qué es el Pile?",local:"qué-es-el-pile",headingTag:"h2"}}),R=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjB6c3RhbmRhcmQ=",highlighted:"!pip install zstandard",wrap:!1}}),E=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwRXN0byUyMHRvbWElMjBhbGd1bm9zJTIwbWludXRvcyUyMHBhcmElMjBlamVjdXRhcnNlJTJDJTIwYXMlQzMlQUQlMjBxdWUlMjB2ZSUyMHBvciUyMHVuJTIwdGUlMjBvJTIwdW4lMjBjYWYlQzMlQTklMjBtaWVudHJhcyUyMGVzcGVyYXMlMjAlM0EpJTBBZGF0YV9maWxlcyUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGbXlzdGljLnRoZS1leWUuZXUlMkZwdWJsaWMlMkZBSSUyRnBpbGVfcHJlbGltaW5hcnlfY29tcG9uZW50cyUyRlBVQk1FRF90aXRsZV9hYnN0cmFjdHNfMjAxOV9iYXNlbGluZS5qc29ubC56c3QlMjIlMEFwdWJtZWRfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJqc29uJTIyJTJDJTIwZGF0YV9maWxlcyUzRGRhdGFfZmlsZXMlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXB1Ym1lZF9kYXRhc2V0",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Esto toma algunos minutos para ejecutarse, así que ve por un te o un café mientras esperas :)</span>
data_files = <span class="hljs-string">&quot;https://mystic.the-eye.eu/public/AI/pile_preliminary_components/PUBMED_title_abstracts_2019_baseline.jsonl.zst&quot;</span>
pubmed_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>)
pubmed_dataset`,wrap:!1}}),X=new T({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidtZXRhJyUyQyUyMCd0ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTU1MTgwMDklMEElN0Qp",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;meta&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>],
    num_rows: <span class="hljs-number">15518009</span>
})`,wrap:!1}}),f=new ke({props:{$$slots:{default:[Ca]},$$scope:{ctx:b}}}),_=new T({props:{code:"cHVibWVkX2RhdGFzZXQlNUIwJTVE",highlighted:'pubmed_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),z=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>}`,wrap:!1}}),Y=new Ss({props:{title:"La magia de la proyección en memoria",local:"la-magia-de-la-proyección-en-memoria",headingTag:"h2"}}),F=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwc3V0aWw=",highlighted:"!pip install psutil",wrap:!1}}),S=new T({props:{code:"aW1wb3J0JTIwcHN1dGlsJTBBJTBBJTIzJTIwUHJvY2Vzcy5tZW1vcnlfaW5mbyUyMGVzdCVDMyVBMSUyMGV4cHJlc2FkbyUyMGVuJTIwYnl0ZXMlMkMlMjBhcyVDMyVBRCUyMHF1ZSUyMGxvJTIwY29udmVydGltb3MlMjBlbiUyMG1lZ2FieXRlcyUwQXByaW50KGYlMjJSQU0lMjB1c2VkJTNBJTIwJTdCcHN1dGlsLlByb2Nlc3MoKS5tZW1vcnlfaW5mbygpLnJzcyUyMCUyRiUyMCgxMDI0JTIwKiUyMDEwMjQpJTNBLjJmJTdEJTIwTUIlMjIp",highlighted:`<span class="hljs-keyword">import</span> psutil

<span class="hljs-comment"># Process.memory_info está expresado en bytes, así que lo convertimos en megabytes</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;RAM used: <span class="hljs-subst">{psutil.Process().memory_info().rss / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>):<span class="hljs-number">.2</span>f}</span> MB&quot;</span>)`,wrap:!1}}),D=new T({props:{code:"UkFNJTIwdXNlZCUzQSUyMDU2NzguMzMlMjBNQg==",highlighted:'RAM used: <span class="hljs-number">5678.33</span> MB',wrap:!1}}),L=new T({props:{code:"cHJpbnQoZiUyMk51bWJlciUyMG9mJTIwZmlsZXMlMjBpbiUyMGRhdGFzZXQlMjAlM0ElMjAlN0JwdWJtZWRfZGF0YXNldC5kYXRhc2V0X3NpemUlN0QlMjIpJTBBc2l6ZV9nYiUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0LmRhdGFzZXRfc2l6ZSUyMCUyRiUyMCgxMDI0KiozKSUwQXByaW50KGYlMjJEYXRhc2V0JTIwc2l6ZSUyMChjYWNoZSUyMGZpbGUpJTIwJTNBJTIwJTdCc2l6ZV9nYiUzQS4yZiU3RCUyMEdCJTIyKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Number of files in dataset : <span class="hljs-subst">{pubmed_dataset.dataset_size}</span>&quot;</span>)
size_gb = pubmed_dataset.dataset_size / (<span class="hljs-number">1024</span>**<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Dataset size (cache file) : <span class="hljs-subst">{size_gb:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),P=new T({props:{code:"TnVtYmVyJTIwb2YlMjBmaWxlcyUyMGluJTIwZGF0YXNldCUyMCUzQSUyMDIwOTc5NDM3MDUxJTBBRGF0YXNldCUyMHNpemUlMjAoY2FjaGUlMjBmaWxlKSUyMCUzQSUyMDE5LjU0JTIwR0I=",highlighted:`Number of files <span class="hljs-keyword">in</span> dataset : <span class="hljs-number">20979437051</span>
Dataset size (cache file) : <span class="hljs-number">19.54</span> GB`,wrap:!1}}),w=new ke({props:{$$slots:{default:[Ea]},$$scope:{ctx:b}}}),se=new T({props:{code:"aW1wb3J0JTIwdGltZWl0JTBBJTBBY29kZV9zbmlwcGV0JTIwJTNEJTIwJTIyJTIyJTIyYmF0Y2hfc2l6ZSUyMCUzRCUyMDEwMDAlMEElMEFmb3IlMjBpZHglMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4ocHVibWVkX2RhdGFzZXQpJTJDJTIwYmF0Y2hfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwcHVibWVkX2RhdGFzZXQlNUJpZHglM0FpZHglMjAlMkIlMjBiYXRjaF9zaXplJTVEJTBBJTIyJTIyJTIyJTBBJTBBdGltZSUyMCUzRCUyMHRpbWVpdC50aW1laXQoc3RtdCUzRGNvZGVfc25pcHBldCUyQyUyMG51bWJlciUzRDElMkMlMjBnbG9iYWxzJTNEZ2xvYmFscygpKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJJdGVyYXRlZCUyMG92ZXIlMjAlN0JsZW4ocHVibWVkX2RhdGFzZXQpJTdEJTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAlN0JzaXplX2diJTNBLjFmJTdEJTIwR0IpJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjBmJTIyJTdCdGltZSUzQS4xZiU3RHMlMkMlMjBpLmUuJTIwJTdCc2l6ZV9nYiUyRnRpbWUlM0EuM2YlN0QlMjBHQiUyRnMlMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> timeit

code_snippet = <span class="hljs-string">&quot;&quot;&quot;batch_size = 1000

for idx in range(0, len(pubmed_dataset), batch_size):
    _ = pubmed_dataset[idx:idx + batch_size]
&quot;&quot;&quot;</span>

time = timeit.timeit(stmt=code_snippet, number=<span class="hljs-number">1</span>, <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>())
<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;Iterated over <span class="hljs-subst">{<span class="hljs-built_in">len</span>(pubmed_dataset)}</span> examples (about <span class="hljs-subst">{size_gb:<span class="hljs-number">.1</span>f}</span> GB) in &quot;</span>
    <span class="hljs-string">f&quot;<span class="hljs-subst">{time:<span class="hljs-number">.1</span>f}</span>s, i.e. <span class="hljs-subst">{size_gb/time:<span class="hljs-number">.3</span>f}</span> GB/s&quot;</span>
)`,wrap:!1}}),ae=new T({props:{code:"J0l0ZXJhdGVkJTIwb3ZlciUyMDE1NTE4MDA5JTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAxOS41JTIwR0IpJTIwaW4lMjA2NC4ycyUyQyUyMGkuZS4lMjAwLjMwNCUyMEdCJTJGcyc=",highlighted:'<span class="hljs-string">&#x27;Iterated over 15518009 examples (about 19.5 GB) in 64.2s, i.e. 0.304 GB/s&#x27;</span>',wrap:!1}}),U=new ke({props:{$$slots:{default:[Xa]},$$scope:{ctx:b}}}),te=new Ss({props:{title:"Haciendo streaming de datasets",local:"haciendo-streaming-de-datasets",headingTag:"h2"}}),ie=new T({props:{code:"cHVibWVkX2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUlMEEp",highlighted:`pubmed_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>
)`,wrap:!1}}),re=new T({props:{code:"bmV4dChpdGVyKHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkKSk=",highlighted:'<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pubmed_dataset_streamed))',wrap:!1}}),oe=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>}`,wrap:!1}}),ce=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLm1hcChsYW1iZGElMjB4JTNBJTIwdG9rZW5pemVyKHglNUIlMjJ0ZXh0JTIyJTVEKSklMEFuZXh0KGl0ZXIodG9rZW5pemVkX2RhdGFzZXQpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
tokenized_dataset = pubmed_dataset_streamed.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: tokenizer(x[<span class="hljs-string">&quot;text&quot;</span>]))
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(tokenized_dataset))`,wrap:!1}}),me=new T({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjAlNUIxMDElMkMlMjA0OTU4JTJDJTIwNTE3OCUyQyUyMDQzMjglMkMlMjA2Nzc5JTJDJTIwLi4uJTVEJTJDJTIwJ2F0dGVudGlvbl9tYXNrJyUzQSUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwLi4uJTVEJTdE",highlighted:'{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">4958</span>, <span class="hljs-number">5178</span>, <span class="hljs-number">4328</span>, <span class="hljs-number">6779</span>, ...], <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ...]}',wrap:!1}}),g=new ke({props:{$$slots:{default:[va]},$$scope:{ctx:b}}}),ue=new T({props:{code:"c2h1ZmZsZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLnNodWZmbGUoYnVmZmVyX3NpemUlM0QxMF8wMDAlMkMlMjBzZWVkJTNENDIpJTBBbmV4dChpdGVyKHNodWZmbGVkX2RhdGFzZXQpKQ==",highlighted:`shuffled_dataset = pubmed_dataset_streamed.shuffle(buffer_size=<span class="hljs-number">10_000</span>, seed=<span class="hljs-number">42</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(shuffled_dataset))`,wrap:!1}}),Je=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MTA3OTklMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnUmFuZG9taXplZCUyMHN0dWR5JTIwb2YlMjBkb3NlJTIwb3IlMjBzY2hlZHVsZSUyMG1vZGlmaWNhdGlvbiUyMG9mJTIwZ3JhbnVsb2N5dGUlMjBjb2xvbnktc3RpbXVsYXRpbmclMjBmYWN0b3IlMjBpbiUyMHBsYXRpbnVtLWJhc2VkJTIwY2hlbW90aGVyYXB5JTIwZm9yJTIwZWxkZXJseSUyMHBhdGllbnRzJTIwd2l0aCUyMGx1bmclMjBjYW5jZXIlMjAuLi4nJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11410799</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Randomized study of dose or schedule modification of granulocyte colony-stimulating factor in platinum-based chemotherapy for elderly patients with lung cancer ...&#x27;</span>}`,wrap:!1}}),Te=new T({props:{code:"ZGF0YXNldF9oZWFkJTIwJTNEJTIwcHVibWVkX2RhdGFzZXRfc3RyZWFtZWQudGFrZSg1KSUwQWxpc3QoZGF0YXNldF9oZWFkKQ==",highlighted:`dataset_head = pubmed_dataset_streamed.take(<span class="hljs-number">5</span>)
<span class="hljs-built_in">list</span>(dataset_head)`,wrap:!1}}),je=new T({props:{code:"JTVCJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24lMjAuLi4nJTdEJTJDJTBBJTIwJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzUlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnQ2xpbmljYWwlMjBzaWducyUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjB3aXRoJTIwYWN1dGUlMjBsb3dlciUyMHJlc3BpcmF0b3J5JTIwaW5mZWN0aW9uJTNBJTIwaW5kaWNhdG9ycyUyMG9mJTIwb3h5Z2VuJTIwdGhlcmFweSUyMC4uLiclN0QlMkMlMEElMjAlN0InbWV0YSclM0ElMjAlN0IncG1pZCclM0ElMjAxMTQwOTU3NiUyQyUyMCdsYW5ndWFnZSclM0ElMjAnZW5nJyU3RCUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCUyMkh5cG94YWVtaWElMjBpbiUyMGNoaWxkcmVuJTIwd2l0aCUyMHNldmVyZSUyMHBuZXVtb25pYSUyMGluJTIwUGFwdWElMjBOZXclMjBHdWluZWElMjAuLi4lMjIlN0QlMkMlMEElMjAlN0InbWV0YSclM0ElMjAlN0IncG1pZCclM0ElMjAxMTQwOTU3NyUyQyUyMCdsYW5ndWFnZSclM0ElMjAnZW5nJyU3RCUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCdPeHlnZW4lMjBjb25jZW50cmF0b3JzJTIwYW5kJTIwY3lsaW5kZXJzJTIwLi4uJyU3RCUyQyUwQSUyMCU3QidtZXRhJyUzQSUyMCU3QidwbWlkJyUzQSUyMDExNDA5NTc4JTJDJTIwJ2xhbmd1YWdlJyUzQSUyMCdlbmcnJTdEJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJ094eWdlbiUyMHN1cHBseSUyMGluJTIwcnVyYWwlMjBhZnJpY2ElM0ElMjBhJTIwcGVyc29uYWwlMjBleHBlcmllbmNlJTIwLi4uJyU3RCU1RA==",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409575</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Clinical signs of hypoxaemia in children with acute lower respiratory infection: indicators of oxygen therapy ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409576</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot;Hypoxaemia in children with severe pneumonia in Papua New Guinea ...&quot;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409577</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen concentrators and cylinders ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409578</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen supply in rural africa: a personal experience ...&#x27;</span>}]`,wrap:!1}}),be=new T({props:{code:"JTIzJTIwU2FsdGElMjBsYXMlMjBwcmltZXJhcyUyMDEwMDAlMjBtdWVzdHJhcyUyMGUlMjBpbmNsdXllJTIwZWwlMjByZXN0byUyMGVuJTIwZWwlMjBjb25qdW50byUyMGRlJTIwZW50cmVuYW1pZW50byUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBzaHVmZmxlZF9kYXRhc2V0LnNraXAoMTAwMCklMEElMjMlMjBUb21hJTIwbGFzJTIwcHJpbWVyYXMlMjAxMDAwJTIwbXVlc3RyYXMlMjBwYXJhJTIwZWwlMjBjb25qdW50byUyMGRlJTIwdmFsaWRhY2klQzMlQjNuJTBBdmFsaWRhdGlvbl9kYXRhc2V0JTIwJTNEJTIwc2h1ZmZsZWRfZGF0YXNldC50YWtlKDEwMDAp",highlighted:`<span class="hljs-comment"># Salta las primeras 1000 muestras e incluye el resto en el conjunto de entrenamiento</span>
train_dataset = shuffled_dataset.skip(<span class="hljs-number">1000</span>)
<span class="hljs-comment"># Toma las primeras 1000 muestras para el conjunto de validación</span>
validation_dataset = shuffled_dataset.take(<span class="hljs-number">1000</span>)`,wrap:!1}}),we=new T({props:{code:"bGF3X2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfZmlsZXMlM0QlMjJodHRwcyUzQSUyRiUyRm15c3RpYy50aGUtZXllLmV1JTJGcHVibGljJTJGQUklMkZwaWxlX3ByZWxpbWluYXJ5X2NvbXBvbmVudHMlMkZGcmVlTGF3X09waW5pb25zLmpzb25sLnpzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTBBKSUwQW5leHQoaXRlcihsYXdfZGF0YXNldF9zdHJlYW1lZCkp",highlighted:`law_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>,
    data_files=<span class="hljs-string">&quot;https://mystic.the-eye.eu/public/AI/pile_preliminary_components/FreeLaw_Opinions.jsonl.zst&quot;</span>,
    split=<span class="hljs-string">&quot;train&quot;</span>,
    streaming=<span class="hljs-literal">True</span>,
)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(law_dataset_streamed))`,wrap:!1}}),Ue=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
  <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
  <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}`,wrap:!1}}),Ie=new T({props:{code:"ZnJvbSUyMGl0ZXJ0b29scyUyMGltcG9ydCUyMGlzbGljZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGludGVybGVhdmVfZGF0YXNldHMlMEElMEFjb21iaW5lZF9kYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJwdWJtZWRfZGF0YXNldF9zdHJlYW1lZCUyQyUyMGxhd19kYXRhc2V0X3N0cmVhbWVkJTVEKSUwQWxpc3QoaXNsaWNlKGNvbWJpbmVkX2RhdGFzZXQlMkMlMjAyKSk=",highlighted:`<span class="hljs-keyword">from</span> itertools <span class="hljs-keyword">import</span> islice
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> interleave_datasets

combined_dataset = interleave_datasets([pubmed_dataset_streamed, law_dataset_streamed])
<span class="hljs-built_in">list</span>(islice(combined_dataset, <span class="hljs-number">2</span>))`,wrap:!1}}),$e=new T({props:{code:"JTVCJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24lMjAuLi4nJTdEJTJDJTBBJTIwJTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdEJTVE",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
   <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
   <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}]`,wrap:!1}}),Ze=new T({props:{code:"YmFzZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRm15c3RpYy50aGUtZXllLmV1JTJGcHVibGljJTJGQUklMkZwaWxlJTJGJTIyJTBBZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYWluJTIyJTNBJTIwJTVCYmFzZV91cmwlMjAlMkIlMjAlMjJ0cmFpbiUyRiUyMiUyMCUyQiUyMGYlMjIlN0JpZHglM0EwMmQlN0QuanNvbmwuenN0JTIyJTIwZm9yJTIwaWR4JTIwaW4lMjByYW5nZSgzMCklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2YWxpZGF0aW9uJTIyJTNBJTIwYmFzZV91cmwlMjAlMkIlMjAlMjJ2YWwuanNvbmwuenN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGVzdCUyMiUzQSUyMGJhc2VfdXJsJTIwJTJCJTIwJTIydGVzdC5qc29ubC56c3QlMjIlMkMlMEElN0QlMEFwaWxlX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFuZXh0KGl0ZXIocGlsZV9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpKQ==",highlighted:`base_url = <span class="hljs-string">&quot;https://mystic.the-eye.eu/public/AI/pile/&quot;</span>
data_files = {
    <span class="hljs-string">&quot;train&quot;</span>: [base_url + <span class="hljs-string">&quot;train/&quot;</span> + <span class="hljs-string">f&quot;<span class="hljs-subst">{idx:02d}</span>.jsonl.zst&quot;</span> <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">30</span>)],
    <span class="hljs-string">&quot;validation&quot;</span>: base_url + <span class="hljs-string">&quot;val.jsonl.zst&quot;</span>,
    <span class="hljs-string">&quot;test&quot;</span>: base_url + <span class="hljs-string">&quot;test.jsonl.zst&quot;</span>,
}
pile_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pile_dataset[<span class="hljs-string">&quot;train&quot;</span>]))`,wrap:!1}}),Ge=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BpbGVfc2V0X25hbWUnJTNBJTIwJ1BpbGUtQ0MnJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJ0l0JTIwaXMlMjBkb25lJTJDJTIwYW5kJTIwc3VibWl0dGVkLiUyMFlvdSUyMGNhbiUyMHBsYXklMjAlRTIlODAlOUNTdXJ2aXZhbCUyMG9mJTIwdGhlJTIwVGFzdGllc3QlRTIlODAlOUQlMjBvbiUyMEFuZHJvaWQlMkMlMjBhbmQlMjBvbiUyMHRoZSUyMHdlYi4uLiclN0Q=",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pile_set_name&#x27;</span>: <span class="hljs-string">&#x27;Pile-CC&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;It is done, and submitted. You can play “Survival of the Tastiest” on Android, and on the web...&#x27;</span>}`,wrap:!1}}),I=new ke({props:{$$slots:{default:[Na]},$$scope:{ctx:b}}}),{c(){i=u("meta"),j=t(),M=u("p"),h=t(),p($.$$.fragment),Ce=t(),p(B.$$.fragment),Ee=t(),x=u("p"),x.innerHTML=Ds,Xe=t(),Z=u("p"),Z.innerHTML=qs,ve=t(),p(G.$$.fragment),Ne=t(),V=u("p"),V.innerHTML=Ls,_e=t(),p(W.$$.fragment),ze=t(),k=u("p"),k.innerHTML=Ps,Qe=t(),p(R.$$.fragment),Ye=t(),C=u("p"),C.innerHTML=Os,He=t(),p(E.$$.fragment),Fe=t(),p(X.$$.fragment),Ae=t(),v=u("p"),v.textContent=Ks,Se=t(),p(f.$$.fragment),De=t(),N=u("p"),N.textContent=ea,qe=t(),p(_.$$.fragment),Le=t(),p(z.$$.fragment),Pe=t(),Q=u("p"),Q.textContent=sa,Oe=t(),p(Y.$$.fragment),Ke=t(),H=u("p"),H.innerHTML=aa,es=t(),p(F.$$.fragment),ss=t(),A=u("p"),A.innerHTML=la,as=t(),p(S.$$.fragment),ls=t(),p(D.$$.fragment),ts=t(),q=u("p"),q.innerHTML=ta,ns=t(),p(L.$$.fragment),is=t(),p(P.$$.fragment),ps=t(),O=u("p"),O.textContent=na,rs=t(),p(w.$$.fragment),os=t(),K=u("p"),K.innerHTML=ia,ds=t(),ee=u("p"),ee.innerHTML=pa,cs=t(),p(se.$$.fragment),ms=t(),p(ae.$$.fragment),Ms=t(),le=u("p"),le.innerHTML=ra,us=t(),p(U.$$.fragment),Js=t(),p(te.$$.fragment),ys=t(),ne=u("p"),ne.innerHTML=oa,Ts=t(),p(ie.$$.fragment),js=t(),pe=u("p"),pe.innerHTML=da,hs=t(),p(re.$$.fragment),bs=t(),p(oe.$$.fragment),fs=t(),de=u("p"),de.innerHTML=ca,ws=t(),p(ce.$$.fragment),Us=t(),p(me.$$.fragment),gs=t(),p(g.$$.fragment),Is=t(),Me=u("p"),Me.innerHTML=ma,$s=t(),p(ue.$$.fragment),Bs=t(),p(Je.$$.fragment),xs=t(),ye=u("p"),ye.innerHTML=Ma,Zs=t(),p(Te.$$.fragment),Gs=t(),p(je.$$.fragment),Vs=t(),he=u("p"),he.innerHTML=ua,Ws=t(),p(be.$$.fragment),ks=t(),fe=u("p"),fe.innerHTML=Ja,Rs=t(),p(we.$$.fragment),Cs=t(),p(Ue.$$.fragment),Es=t(),ge=u("p"),ge.innerHTML=ya,Xs=t(),p(Ie.$$.fragment),vs=t(),p($e.$$.fragment),Ns=t(),Be=u("p"),Be.innerHTML=Ta,_s=t(),xe=u("p"),xe.innerHTML=ja,zs=t(),p(Ze.$$.fragment),Qs=t(),p(Ge.$$.fragment),Ys=t(),p(I.$$.fragment),Hs=t(),Ve=u("p"),Ve.textContent=ha,Fs=t(),We=u("p"),this.h()},l(e){const s=Va("svelte-u9bgzb",document.head);i=J(s,"META",{name:!0,content:!0}),s.forEach(a),j=n(e),M=J(e,"P",{}),Ia(M).forEach(a),h=n(e),r($.$$.fragment,e),Ce=n(e),r(B.$$.fragment,e),Ee=n(e),x=J(e,"P",{"data-svelte-h":!0}),y(x)!=="svelte-1f54zhv"&&(x.innerHTML=Ds),Xe=n(e),Z=J(e,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-d2mhm9"&&(Z.innerHTML=qs),ve=n(e),r(G.$$.fragment,e),Ne=n(e),V=J(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-i1zyge"&&(V.innerHTML=Ls),_e=n(e),r(W.$$.fragment,e),ze=n(e),k=J(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-11cis2"&&(k.innerHTML=Ps),Qe=n(e),r(R.$$.fragment,e),Ye=n(e),C=J(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1dwk9ms"&&(C.innerHTML=Os),He=n(e),r(E.$$.fragment,e),Fe=n(e),r(X.$$.fragment,e),Ae=n(e),v=J(e,"P",{"data-svelte-h":!0}),y(v)!=="svelte-jezns1"&&(v.textContent=Ks),Se=n(e),r(f.$$.fragment,e),De=n(e),N=J(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1yptpo5"&&(N.textContent=ea),qe=n(e),r(_.$$.fragment,e),Le=n(e),r(z.$$.fragment,e),Pe=n(e),Q=J(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-19647cu"&&(Q.textContent=sa),Oe=n(e),r(Y.$$.fragment,e),Ke=n(e),H=J(e,"P",{"data-svelte-h":!0}),y(H)!=="svelte-1hggqvf"&&(H.innerHTML=aa),es=n(e),r(F.$$.fragment,e),ss=n(e),A=J(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-q3e312"&&(A.innerHTML=la),as=n(e),r(S.$$.fragment,e),ls=n(e),r(D.$$.fragment,e),ts=n(e),q=J(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-1yzomxf"&&(q.innerHTML=ta),ns=n(e),r(L.$$.fragment,e),is=n(e),r(P.$$.fragment,e),ps=n(e),O=J(e,"P",{"data-svelte-h":!0}),y(O)!=="svelte-gbjr33"&&(O.textContent=na),rs=n(e),r(w.$$.fragment,e),os=n(e),K=J(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-1caqt7j"&&(K.innerHTML=ia),ds=n(e),ee=J(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-lono31"&&(ee.innerHTML=pa),cs=n(e),r(se.$$.fragment,e),ms=n(e),r(ae.$$.fragment,e),Ms=n(e),le=J(e,"P",{"data-svelte-h":!0}),y(le)!=="svelte-1bm8p1s"&&(le.innerHTML=ra),us=n(e),r(U.$$.fragment,e),Js=n(e),r(te.$$.fragment,e),ys=n(e),ne=J(e,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-1q944vj"&&(ne.innerHTML=oa),Ts=n(e),r(ie.$$.fragment,e),js=n(e),pe=J(e,"P",{"data-svelte-h":!0}),y(pe)!=="svelte-1g710sv"&&(pe.innerHTML=da),hs=n(e),r(re.$$.fragment,e),bs=n(e),r(oe.$$.fragment,e),fs=n(e),de=J(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-13wilwe"&&(de.innerHTML=ca),ws=n(e),r(ce.$$.fragment,e),Us=n(e),r(me.$$.fragment,e),gs=n(e),r(g.$$.fragment,e),Is=n(e),Me=J(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-1xcnytx"&&(Me.innerHTML=ma),$s=n(e),r(ue.$$.fragment,e),Bs=n(e),r(Je.$$.fragment,e),xs=n(e),ye=J(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-11axkfp"&&(ye.innerHTML=Ma),Zs=n(e),r(Te.$$.fragment,e),Gs=n(e),r(je.$$.fragment,e),Vs=n(e),he=J(e,"P",{"data-svelte-h":!0}),y(he)!=="svelte-8b249"&&(he.innerHTML=ua),Ws=n(e),r(be.$$.fragment,e),ks=n(e),fe=J(e,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-air9qn"&&(fe.innerHTML=Ja),Rs=n(e),r(we.$$.fragment,e),Cs=n(e),r(Ue.$$.fragment,e),Es=n(e),ge=J(e,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-1pb4ctq"&&(ge.innerHTML=ya),Xs=n(e),r(Ie.$$.fragment,e),vs=n(e),r($e.$$.fragment,e),Ns=n(e),Be=J(e,"P",{"data-svelte-h":!0}),y(Be)!=="svelte-v77nbg"&&(Be.innerHTML=Ta),_s=n(e),xe=J(e,"P",{"data-svelte-h":!0}),y(xe)!=="svelte-1yvx41e"&&(xe.innerHTML=ja),zs=n(e),r(Ze.$$.fragment,e),Qs=n(e),r(Ge.$$.fragment,e),Ys=n(e),r(I.$$.fragment,e),Hs=n(e),Ve=J(e,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-clgpvd"&&(Ve.textContent=ha),Fs=n(e),We=J(e,"P",{}),Ia(We).forEach(a),this.h()},h(){$a(i,"name","hf:doc:metadata"),$a(i,"content",za)},m(e,s){Wa(document.head,i),l(e,j,s),l(e,M,s),l(e,h,s),o($,e,s),l(e,Ce,s),o(B,e,s),l(e,Ee,s),l(e,x,s),l(e,Xe,s),l(e,Z,s),l(e,ve,s),o(G,e,s),l(e,Ne,s),l(e,V,s),l(e,_e,s),o(W,e,s),l(e,ze,s),l(e,k,s),l(e,Qe,s),o(R,e,s),l(e,Ye,s),l(e,C,s),l(e,He,s),o(E,e,s),l(e,Fe,s),o(X,e,s),l(e,Ae,s),l(e,v,s),l(e,Se,s),o(f,e,s),l(e,De,s),l(e,N,s),l(e,qe,s),o(_,e,s),l(e,Le,s),o(z,e,s),l(e,Pe,s),l(e,Q,s),l(e,Oe,s),o(Y,e,s),l(e,Ke,s),l(e,H,s),l(e,es,s),o(F,e,s),l(e,ss,s),l(e,A,s),l(e,as,s),o(S,e,s),l(e,ls,s),o(D,e,s),l(e,ts,s),l(e,q,s),l(e,ns,s),o(L,e,s),l(e,is,s),o(P,e,s),l(e,ps,s),l(e,O,s),l(e,rs,s),o(w,e,s),l(e,os,s),l(e,K,s),l(e,ds,s),l(e,ee,s),l(e,cs,s),o(se,e,s),l(e,ms,s),o(ae,e,s),l(e,Ms,s),l(e,le,s),l(e,us,s),o(U,e,s),l(e,Js,s),o(te,e,s),l(e,ys,s),l(e,ne,s),l(e,Ts,s),o(ie,e,s),l(e,js,s),l(e,pe,s),l(e,hs,s),o(re,e,s),l(e,bs,s),o(oe,e,s),l(e,fs,s),l(e,de,s),l(e,ws,s),o(ce,e,s),l(e,Us,s),o(me,e,s),l(e,gs,s),o(g,e,s),l(e,Is,s),l(e,Me,s),l(e,$s,s),o(ue,e,s),l(e,Bs,s),o(Je,e,s),l(e,xs,s),l(e,ye,s),l(e,Zs,s),o(Te,e,s),l(e,Gs,s),o(je,e,s),l(e,Vs,s),l(e,he,s),l(e,Ws,s),o(be,e,s),l(e,ks,s),l(e,fe,s),l(e,Rs,s),o(we,e,s),l(e,Cs,s),o(Ue,e,s),l(e,Es,s),l(e,ge,s),l(e,Xs,s),o(Ie,e,s),l(e,vs,s),o($e,e,s),l(e,Ns,s),l(e,Be,s),l(e,_s,s),l(e,xe,s),l(e,zs,s),o(Ze,e,s),l(e,Qs,s),o(Ge,e,s),l(e,Ys,s),o(I,e,s),l(e,Hs,s),l(e,Ve,s),l(e,Fs,s),l(e,We,s),As=!0},p(e,[s]){const ba={};s&2&&(ba.$$scope={dirty:s,ctx:e}),f.$set(ba);const fa={};s&2&&(fa.$$scope={dirty:s,ctx:e}),w.$set(fa);const wa={};s&2&&(wa.$$scope={dirty:s,ctx:e}),U.$set(wa);const Ua={};s&2&&(Ua.$$scope={dirty:s,ctx:e}),g.$set(Ua);const ga={};s&2&&(ga.$$scope={dirty:s,ctx:e}),I.$set(ga)},i(e){As||(d($.$$.fragment,e),d(B.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(E.$$.fragment,e),d(X.$$.fragment,e),d(f.$$.fragment,e),d(_.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(F.$$.fragment,e),d(S.$$.fragment,e),d(D.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(w.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(U.$$.fragment,e),d(te.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(oe.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(g.$$.fragment,e),d(ue.$$.fragment,e),d(Je.$$.fragment,e),d(Te.$$.fragment,e),d(je.$$.fragment,e),d(be.$$.fragment,e),d(we.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d($e.$$.fragment,e),d(Ze.$$.fragment,e),d(Ge.$$.fragment,e),d(I.$$.fragment,e),As=!0)},o(e){c($.$$.fragment,e),c(B.$$.fragment,e),c(G.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(E.$$.fragment,e),c(X.$$.fragment,e),c(f.$$.fragment,e),c(_.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),c(F.$$.fragment,e),c(S.$$.fragment,e),c(D.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(w.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(U.$$.fragment,e),c(te.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(oe.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(g.$$.fragment,e),c(ue.$$.fragment,e),c(Je.$$.fragment,e),c(Te.$$.fragment,e),c(je.$$.fragment,e),c(be.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(Ie.$$.fragment,e),c($e.$$.fragment,e),c(Ze.$$.fragment,e),c(Ge.$$.fragment,e),c(I.$$.fragment,e),As=!1},d(e){e&&(a(j),a(M),a(h),a(Ce),a(Ee),a(x),a(Xe),a(Z),a(ve),a(Ne),a(V),a(_e),a(ze),a(k),a(Qe),a(Ye),a(C),a(He),a(Fe),a(Ae),a(v),a(Se),a(De),a(N),a(qe),a(Le),a(Pe),a(Q),a(Oe),a(Ke),a(H),a(es),a(ss),a(A),a(as),a(ls),a(ts),a(q),a(ns),a(is),a(ps),a(O),a(rs),a(os),a(K),a(ds),a(ee),a(cs),a(ms),a(Ms),a(le),a(us),a(Js),a(ys),a(ne),a(Ts),a(js),a(pe),a(hs),a(bs),a(fs),a(de),a(ws),a(Us),a(gs),a(Is),a(Me),a($s),a(Bs),a(xs),a(ye),a(Zs),a(Gs),a(Vs),a(he),a(Ws),a(ks),a(fe),a(Rs),a(Cs),a(Es),a(ge),a(Xs),a(vs),a(Ns),a(Be),a(_s),a(xe),a(zs),a(Qs),a(Ys),a(Hs),a(Ve),a(Fs),a(We)),a(i),m($,e),m(B,e),m(G,e),m(W,e),m(R,e),m(E,e),m(X,e),m(f,e),m(_,e),m(z,e),m(Y,e),m(F,e),m(S,e),m(D,e),m(L,e),m(P,e),m(w,e),m(se,e),m(ae,e),m(U,e),m(te,e),m(ie,e),m(re,e),m(oe,e),m(ce,e),m(me,e),m(g,e),m(ue,e),m(Je,e),m(Te,e),m(je,e),m(be,e),m(we,e),m(Ue,e),m(Ie,e),m($e,e),m(Ze,e),m(Ge,e),m(I,e)}}}const za='{"title":"¿Big data? 🤗 ¡Datasets al rescate!","local":"big-data--datasets-al-rescate","sections":[{"title":"¿Qué es el Pile?","local":"qué-es-el-pile","sections":[],"depth":2},{"title":"La magia de la proyección en memoria","local":"la-magia-de-la-proyección-en-memoria","sections":[],"depth":2},{"title":"Haciendo streaming de datasets","local":"haciendo-streaming-de-datasets","sections":[],"depth":2}],"depth":1}';function Qa(b){return xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class La extends Za{constructor(i){super(),Ga(this,i,Qa,_a,Ba,{})}}export{La as component};
