import{s as mn,o as hn,n as Fs}from"../chunks/scheduler.37c15a92.js";import{S as wn,i as In,g as e,s as t,r as j,m as Cn,H as xn,A as gn,h as y,f as a,c as p,j as fa,u as i,x as U,n as dn,E as bn,k as Un,y as Tn,a as n,v as c,d as J,t as r,w as o}from"../chunks/index.2bf4358c.js";import{T as Ps}from"../chunks/Tip.363c041f.js";import{Y as fn}from"../chunks/Youtube.1e50a667.js";import{C as u}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as qn}from"../chunks/CourseFloatingBanner.33a4139d.js";import{H as da}from"../chunks/Heading.8ada512a.js";function $n(w){let M,m="💡 本節深入介紹 WordPiece,甚至展示完整的實現。如果您只想大致瞭解標記化算法,可以跳到最後。";return{c(){M=e("p"),M.textContent=m},l(T){M=y(T,"P",{"data-svelte-h":!0}),U(M)!=="svelte-1t4qjho"&&(M.textContent=m)},m(T,h){n(T,M,h)},p:Fs,d(T){T&&a(M)}}}function kn(w){let M,m="⚠️ Google 從未開源 WordPiece 訓練算法的實現,因此以下是我們基於已發表文獻的最佳猜測。它可能不是 100% 準確的。";return{c(){M=e("p"),M.textContent=m},l(T){M=y(T,"P",{"data-svelte-h":!0}),U(M)!=="svelte-1yp1g49"&&(M.textContent=m)},m(T,h){n(T,M,h)},p:Fs,d(T){T&&a(M)}}}function An(w){let M,m="✏️ <strong>現在輪到你了!</strong> 下一個合併規則是什麼？";return{c(){M=e("p"),M.innerHTML=m},l(T){M=y(T,"P",{"data-svelte-h":!0}),U(M)!=="svelte-2zg7ut"&&(M.innerHTML=m)},m(T,h){n(T,M,h)},p:Fs,d(T){T&&a(M)}}}function Qn(w){let M,m="✏️ <strong>現在輪到你了!</strong> <code>&quot;pugs&quot;</code> 將被如何標記?";return{c(){M=e("p"),M.innerHTML=m},l(T){M=y(T,"P",{"data-svelte-h":!0}),U(M)!=="svelte-1j91x4t"&&(M.innerHTML=m)},m(T,h){n(T,M,h)},p:Fs,d(T){T&&a(M)}}}function zn(w){let M,m="💡 在同一語料庫上使用 <code>train_new_from_iterator()</code> 不會產生完全相同的詞彙表。這是因為 🤗 Tokenizers 庫沒有為訓練實現 WordPiece(因為我們不完全確定它的內部結構),而是使用 BPE。";return{c(){M=e("p"),M.innerHTML=m},l(T){M=y(T,"P",{"data-svelte-h":!0}),U(M)!=="svelte-1n8t7vg"&&(M.innerHTML=m)},m(T,h){n(T,M,h)},p:Fs,d(T){T&&a(M)}}}function Bn(w){let M,m,T,h,b,Ks,f,Ls,q,qa="WordPiece 是 Google 為預訓練 BERT 而開發的標記化算法。此後,它在不少基於 BERT 的 Transformer 模型中得到重用,例如 DistilBERT、MobileBERT、Funnel Transformers 和 MPNET。它在訓練方面與 BPE 非常相似,但實際標記化的方式不同。",Os,$,sl,I,ll,k,al,C,nl,A,$a="與 BPE 一樣,WordPiece 從一個小詞彙表開始,包括模型使用的特殊標記和初始字母表。因為它通過添加前綴來識別子詞 (如同 <code>##</code> 對於 BERT),每個單詞最初是通過將該前綴添加到單詞內的所有字符來拆分的。所以,例如 <code>&quot;word&quot;</code> ,像這樣拆分:",tl,Q,pl,z,ka="因此,初始字母表包含出現在單詞開頭的所有字符以及出現在單詞內部的以 WordPiece 前綴開頭的字符。",Ml,B,ba,el,un='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mrow><mi mathvariant="normal">s</mi><mi mathvariant="normal">c</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi></mrow><mo>=</mo><mo stretchy="false">(</mo><mrow><mi mathvariant="normal">f</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">q</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">p</mi><mi mathvariant="normal">a</mi><mi mathvariant="normal">i</mi><mi mathvariant="normal">r</mi></mrow><mo stretchy="false">)</mo><mi mathvariant="normal">/</mi><mo stretchy="false">(</mo><mrow><mi mathvariant="normal">f</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">q</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">i</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">s</mi><mi mathvariant="normal">t</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">l</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">m</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">n</mi><mi mathvariant="normal">t</mi></mrow><mo>×</mo><mrow><mi mathvariant="normal">f</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">q</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">s</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">c</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">n</mi><mi mathvariant="normal">d</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">l</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">m</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">n</mi><mi mathvariant="normal">t</mi></mrow><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathrm{score} = (\\mathrm{freq\\_of\\_pair}) / (\\mathrm{freq\\_of\\_first\\_element} \\times \\mathrm{freq\\_of\\_second\\_element})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord"><span class="mord mathrm">score</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.06em;vertical-align:-0.31em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathrm">freq_of_pair</span></span><span class="mclose">)</span><span class="mord">/</span><span class="mopen">(</span><span class="mord"><span class="mord mathrm">freq_of_first_element</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.06em;vertical-align:-0.31em;"></span><span class="mord"><span class="mord mathrm">freq_of_second_element</span></span><span class="mclose">)</span></span></span></span></span>',yl,v,Aa="通過將配對的頻率除以其每個部分的頻率的乘積, 該算法優先合併單個部分在詞彙表中頻率較低的對。例如,它不一定會合並 <code>(&quot;un&quot;, &quot;##able&quot;)</code> 即使這對在詞彙表中出現的頻率很高,因為 <code>&quot;un&quot;</code> 和 <code>&quot;##able&quot;</code> 很可能每個詞都出現在很多其他詞中並且出現頻率很高。相比之下,像 <code>(&quot;hu&quot;, &quot;##gging&quot;)</code> 可能會更快地合併 (假設 “hugging” 經常出現在詞彙表中),因為 <code>&quot;hu&quot;</code> 和 <code>&quot;##gging&quot;</code> 這兩個詞單獨出現地頻率可能較低。",jl,Z,Qa="讓我們看看我們在 BPE 訓練示例中使用的相同詞彙:",il,N,cl,_,za="這裡的拆分將是:",Jl,E,rl,S,Ba="所以最初的詞彙將是 <code>[&quot;b&quot;, &quot;h&quot;, &quot;p&quot;, &quot;##g&quot;, &quot;##n&quot;, &quot;##s&quot;, &quot;##u&quot;]</code> (如果我們暫時忘記特殊標記)。最頻繁的一對是 <code>(&quot;##u&quot;, &quot;##g&quot;)</code> (目前20次),但 <code>&quot;##u&quot;</code> 單獨出現的頻率非常高,所以它的分數不是最高的(它是 1 / 36)。所有帶有 <code>&quot;##u&quot;</code> 的對實際上都有相同的分數(1 / 36),所以分數最高的對是 <code>(&quot;##g&quot;, &quot;##s&quot;)</code> — 唯一沒有 <code>&quot;##u&quot;</code> 的對— 1 / 20,所以學習的第一個合併是 <code>(&quot;##g&quot;, &quot;##s&quot;) -&gt; (&quot;##gs&quot;)</code>。",ol,G,va="請注意,當我們合併時,我們刪除了兩個標記之間的 <code>##</code>,所以我們添加 <code>&quot;##gs&quot;</code> 到詞彙表中,並在語料庫的單詞中應用該合併:",Ul,V,Tl,H,Za="在這一點中, <code>&quot;##u&quot;</code> 是在所有可能的對中,因此它們最終都具有相同的分數。假設在這種情況下,第一對被合併, <code>(&quot;h&quot;, &quot;##u&quot;) -&gt; &quot;hu&quot;</code>。這使得我們:",ul,X,ml,W,Na="然後下一個最高的分數由 <code>(&quot;hu&quot;, &quot;##g&quot;)</code> 和 <code>(&quot;hu&quot;, &quot;##gs&quot;)</code> 共享(1/15,與其他所有對的 1/21 相比),因此合併得分最高的第一對:",hl,R,wl,Y,_a="我們繼續這樣處理,直到達到我們所需的詞彙量。",Il,x,Cl,D,xl,P,Ea="WordPiece 和 BPE 中的標記化的不同在於 WordPiece 只保存最終詞彙,而不是學習的合併規則。從要標記的單詞開始,WordPiece 找到詞彙表中最長的子詞,然後對其進行拆分。例如,如果我們使用上面例子中學到的詞彙,對於單詞 <code>&quot;hugs&quot;</code>,詞彙表中從頭開始的最長子詞是 <code>&quot;hug&quot;</code>,所以我們在那裡拆分並得到 <code>[&quot;hug&quot;, &quot;##s&quot;]</code>。 然後我們繼續使用詞彙表中的 <code>&quot;##s&quot;</code>,因此 <code>&quot;hugs&quot;</code> 的標記化是 <code>[&quot;hug&quot;, &quot;##s&quot;]</code>.",gl,F,Sa="使用 BPE, 我們將按順序應用學習到的合併並將其標記為 <code>[&quot;hu&quot;, &quot;##gs&quot;]</code>,所以編碼不同。",dl,K,Ga="再舉一個例子,讓我們看看 <code>&quot;bugs&quot;</code> 將如何被標記化。 <code>&quot;b&quot;</code> 是從詞彙表中單詞開頭開始的最長子詞,所以我們在那裡拆分並得到 <code>[&quot;b&quot;, &quot;##ugs&quot;]</code>。然後 <code>&quot;##u&quot;</code> 是詞彙表中從 <code>&quot;##ugs&quot;</code> 開始的最長的子詞,所以我們在那裡拆分並得到 <code>[&quot;b&quot;, &quot;##u, &quot;##gs&quot;]</code>。最後, <code>&quot;##gs&quot;</code> 在詞彙表中,所以最後一個列表是 <code>&quot;bugs&quot;</code> 的標記化。",bl,L,Va="當分詞達到無法在詞彙表中找到子詞的階段時, 整個詞被標記為未知 — 例如, <code>&quot;mug&quot;</code> 將被標記為 <code>[&quot;[UNK]&quot;]</code>,就像 <code>&quot;bum&quot;</code> (即使我們可以以 <code>&quot;b&quot;</code> 和 <code>&quot;##u&quot;</code> 開始, <code>&quot;##m&quot;</code> 不在詞彙表中,由此產生的標記將只是 <code>[&quot;[UNK]&quot;]</code>, 不是 <code>[&quot;b&quot;, &quot;##u&quot;, &quot;[UNK]&quot;]</code>)。這是與 BPE 的另一個區別,BPE 只會將不在詞彙表中的單個字符分類為未知。",fl,g,ql,O,$l,ss,Ha="現在讓我們看一下 WordPiece 算法的實現。與 BPE 一樣,這只是教學,你將無法在大型語料庫中使用它。",kl,ls,Xa="我們將使用與 BPE 示例中相同的語料庫:",Al,as,Ql,ns,Wa="首先,我們需要將語料庫預先標記為單詞。由於我們正在複製 WordPiece 標記器 (如 BERT),因此我們將使用 <code>bert-base-cased</code> 標記器用於預標記化:",zl,ts,Bl,ps,Ra="然後我們在進行預標記化時計算語料庫中每個單詞的頻率:",vl,Ms,Zl,es,Nl,ys,Ya="正如我們之前看到的,字母表是由單詞的所有第一個字母組成的唯一集合,以及出現在前綴為 <code>##</code> 的其他字母:",_l,js,El,is,Sl,cs,Da="我們還在該詞彙表的開頭添加了模型使用的特殊標記。在使用 BERT 的情況下,它是列表 <code>[&quot;[PAD]&quot;, &quot;[UNK]&quot;, &quot;[CLS]&quot;, &quot;[SEP]&quot;, &quot;[MASK]&quot;]</code>:",Gl,Js,Vl,rs,Pa="接下來我們需要拆分每個單詞, 所有不是第一個字母的字母都以 <code>##</code> 為前綴:",Hl,os,Xl,Us,Fa="現在我們已經準備好訓練了,讓我們編寫一個函數來計算每對的分數。我們需要在訓練的每個步驟中使用它:",Wl,Ts,Rl,us,Ka="讓我們來看看這個字典在初始拆分後的一部分:",Yl,ms,Dl,hs,Pl,ws,La="現在,找到得分最高的對只需要一個快速循環:",Fl,Is,Kl,Cs,Ll,xs,Oa="所以第一個要學習的合併是 <code>(&#39;a&#39;, &#39;##b&#39;) -&gt; &#39;ab&#39;</code>, 並且我們添加 <code>&#39;ab&#39;</code> 到詞彙表中:",Ol,gs,sa,ds,sn="要繼續接下來的步驟,我們需要在我們的 <code>拆分</code> 字典中應用該合併。讓我們為此編寫另一個函數:",la,bs,aa,fs,ln="我們可以看看第一次合併的結果:",na,qs,ta,$s,pa,ks,an="現在我們有了循環所需的一切,直到我們學會了我們想要的所有合併。我們的目標詞彙量為70:",Ma,As,ea,Qs,nn="然後我們可以查看生成的詞彙表:",ya,zs,ja,Bs,ia,vs,tn="正如我們所看到的,與 BPE 相比,這個標記器將單詞的一部分作為標記學習得更快一些。",ca,d,Ja,Zs,pn="為了對新文本進行分詞,我們對其進行預分詞、拆分,然後對每個單詞應用分詞算法。也就是說,我們從第一個詞的開頭尋找最大的子詞並將其拆分,然後我們在第二部分重複這個過程,對於該詞的其餘部分和文本中的以下詞,依此類推:",ra,Ns,oa,_s,Mn="讓我們用詞彙表中的一個單詞和另一個不在詞彙表中的單詞進行測試:",Ua,Es,Ta,Ss,ua,Gs,en="現在,讓我們編寫一個標記文本的函數:",ma,Vs,ha,Hs,yn="我們可以在任何文本上嘗試:",wa,Xs,Ia,Ws,Ca,Rs,jn="這就是 WordPiece 算法的全部內容!現在讓我們來看看 Unigram。",xa,Ds,ga;return b=new da({props:{title:"WordPiece 標記化",local:"wordpiece-標記化",headingTag:"h1"}}),f=new qn({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section6.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section6.ipynb"}]}}),$=new fn({props:{id:"qpv6ms_t_1A"}}),I=new Ps({props:{$$slots:{default:[$n]},$$scope:{ctx:w}}}),k=new da({props:{title:"訓練算法",local:"訓練算法",headingTag:"h2"}}),C=new Ps({props:{warning:!0,$$slots:{default:[kn]},$$scope:{ctx:w}}}),Q=new u({props:{code:"dyUyMCUyMyUyM28lMjAlMjMlMjNyJTIwJTIzJTIzZA==",highlighted:"w ##o ##r ##d",wrap:!1}}),N=new u({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),E=new u({props:{code:"KCUyMmglMjIlMjAlMjIlMjMlMjN1JTIyJTIwJTIyJTIzJTIzZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM24lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNnJTIyJTIwJTIyJTIzJTIzcyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-number">5</span>)',wrap:!1}}),V=new u({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIycCUyMiUyQyUyMCUyMiUyMyUyM2clMjIlMkMlMjAlMjIlMjMlMjNuJTIyJTJDJTIwJTIyJTIzJTIzcyUyMiUyQyUyMCUyMiUyMyUyM3UlMjIlMkMlMjAlMjIlMjMlMjNncyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjIlMjMlMjN1JTIyJTIwJTIyJTIzJTIzbiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjIlMjMlMjN1JTIyJTIwJTIyJTIzJTIzZ3MlMjIlMkMlMjA1KQ==",highlighted:`Vocabulary: [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>]
Corpus: (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),X=new u({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIycCUyMiUyQyUyMCUyMiUyMyUyM2clMjIlMkMlMjAlMjIlMjMlMjNuJTIyJTJDJTIwJTIyJTIzJTIzcyUyMiUyQyUyMCUyMiUyMyUyM3UlMjIlMkMlMjAlMjIlMjMlMjNncyUyMiUyQyUyMCUyMmh1JTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1JTIyJTIwJTIyJTIzJTIzZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM24lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHUlMjIlMjAlMjIlMjMlMjNncyUyMiUyQyUyMDUp",highlighted:`Vocabulary: [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-string">&quot;hu&quot;</span>]
Corpus: (<span class="hljs-string">&quot;hu&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hu&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),R=new u({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIycCUyMiUyQyUyMCUyMiUyMyUyM2clMjIlMkMlMjAlMjIlMjMlMjNuJTIyJTJDJTIwJTIyJTIzJTIzcyUyMiUyQyUyMCUyMiUyMyUyM3UlMjIlMkMlMjAlMjIlMjMlMjNncyUyMiUyQyUyMCUyMmh1JTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM24lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHUlMjIlMjAlMjIlMjMlMjNncyUyMiUyQyUyMDUp",highlighted:`Vocabulary: [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
Corpus: (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hu&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),x=new Ps({props:{$$slots:{default:[An]},$$scope:{ctx:w}}}),D=new da({props:{title:"標記化算法",local:"標記化算法",headingTag:"h2"}}),g=new Ps({props:{$$slots:{default:[Qn]},$$scope:{ctx:w}}}),O=new da({props:{title:"實現 WordPiece",local:"實現-wordpiece",headingTag:"h2"}}),as=new u({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBjb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),ts=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)`,wrap:!1}}),Ms=new u({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBd29yZF9mcmVxcw==",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)
<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

word_freqs`,wrap:!1}}),es=new u({props:{code:"ZGVmYXVsdGRpY3QoJTBBJTIwJTIwJTIwJTIwaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCdpcyclM0ElMjAyJTJDJTIwJ3RoZSclM0ElMjAxJTJDJTIwJ0h1Z2dpbmcnJTNBJTIwMSUyQyUyMCdGYWNlJyUzQSUyMDElMkMlMjAnQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJ2NoYXB0ZXInJTNBJTIwMSUyQyUyMCdhYm91dCclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJ3Rva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJ3NlY3Rpb24nJTNBJTIwMSUyQyUyMCdzaG93cyclM0ElMjAxJTJDJTIwJ3NldmVyYWwnJTNBJTIwMSUyQyUyMCd0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCdhbGdvcml0aG1zJyUzQSUyMDElMkMlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnJTJDJyUzQSUyMDElMkMlMjAneW91JyUzQSUyMDElMkMlMjAnd2lsbCclM0ElMjAxJTJDJTIwJ2JlJyUzQSUyMDElMkMlMjAnYWJsZSclM0ElMjAxJTJDJTIwJ3RvJyUzQSUyMDElMkMlMjAndW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJ2hvdyclM0ElMjAxJTJDJTIwJ3RoZXknJTNBJTIwMSUyQyUyMCdhcmUnJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCd0cmFpbmVkJyUzQSUyMDElMkMlMjAnYW5kJyUzQSUyMDElMkMlMjAnZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCd0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(
    <span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;is&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;the&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Hugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Face&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Course&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;chapter&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;about&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;tokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;section&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;shows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;several&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;tokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;algorithms&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;you&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;will&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;be&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;able&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;to&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;understand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;how&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;they&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;are&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;trained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;and&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;generate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;tokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),js=new u({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwd29yZCU1QjAlNUQlMjBub3QlMjBpbiUyMGFscGhhYmV0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxwaGFiZXQuYXBwZW5kKHdvcmQlNUIwJTVEKSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCU1QjElM0ElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGYlMjIlMjMlMjMlN0JsZXR0ZXIlN0QlMjIlMjBub3QlMjBpbiUyMGFscGhhYmV0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxwaGFiZXQuYXBwZW5kKGYlMjIlMjMlMjMlN0JsZXR0ZXIlN0QlMjIpJTBBJTBBYWxwaGFiZXQuc29ydCgpJTBBYWxwaGFiZXQlMEElMEFwcmludChhbHBoYWJldCk=",highlighted:`alphabet = []
<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">if</span> word[<span class="hljs-number">0</span>] <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
        alphabet.append(word[<span class="hljs-number">0</span>])
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word[<span class="hljs-number">1</span>:]:
        <span class="hljs-keyword">if</span> <span class="hljs-string">f&quot;##<span class="hljs-subst">{letter}</span>&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(<span class="hljs-string">f&quot;##<span class="hljs-subst">{letter}</span>&quot;</span>)

alphabet.sort()
alphabet

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),is=new u({props:{code:"JTVCJyUyMyUyM2EnJTJDJTIwJyUyMyUyM2InJTJDJTIwJyUyMyUyM2MnJTJDJTIwJyUyMyUyM2QnJTJDJTIwJyUyMyUyM2UnJTJDJTIwJyUyMyUyM2YnJTJDJTIwJyUyMyUyM2cnJTJDJTIwJyUyMyUyM2gnJTJDJTIwJyUyMyUyM2knJTJDJTIwJyUyMyUyM2snJTJDJTIwJyUyMyUyM2wnJTJDJTIwJyUyMyUyM20nJTJDJTIwJyUyMyUyM24nJTJDJTIwJyUyMyUyM28nJTJDJTIwJyUyMyUyM3AnJTJDJTIwJyUyMyUyM3InJTJDJTIwJyUyMyUyM3MnJTJDJTBBJTIwJyUyMyUyM3QnJTJDJTIwJyUyMyUyM3UnJTJDJTIwJyUyMyUyM3YnJTJDJTIwJyUyMyUyM3cnJTJDJTIwJyUyMyUyM3knJTJDJTIwJyUyMyUyM3onJTJDJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAncyclMkMlMjAndCclMkMlMjAndSclMkMlMEElMjAndyclMkMlMjAneSclNUQ=",highlighted:`[<span class="hljs-string">&#x27;##a&#x27;</span>, <span class="hljs-string">&#x27;##b&#x27;</span>, <span class="hljs-string">&#x27;##c&#x27;</span>, <span class="hljs-string">&#x27;##d&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;##f&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##k&#x27;</span>, <span class="hljs-string">&#x27;##l&#x27;</span>, <span class="hljs-string">&#x27;##m&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##p&#x27;</span>, <span class="hljs-string">&#x27;##r&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>,
 <span class="hljs-string">&#x27;##t&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##v&#x27;</span>, <span class="hljs-string">&#x27;##w&#x27;</span>, <span class="hljs-string">&#x27;##y&#x27;</span>, <span class="hljs-string">&#x27;##z&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>,
 <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>]`,wrap:!1}}),Js=new u({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTIwJTJCJTIwYWxwaGFiZXQuY29weSgp",highlighted:'vocab = [<span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>] + alphabet.copy()',wrap:!1}}),os=new u({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwd29yZCUzQSUyMCU1QmMlMjBpZiUyMGklMjAlM0QlM0QlMjAwJTIwZWxzZSUyMGYlMjIlMjMlMjMlN0JjJTdEJTIyJTIwZm9yJTIwaSUyQyUyMGMlMjBpbiUyMGVudW1lcmF0ZSh3b3JkKSU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMjBpbiUyMHdvcmRfZnJlcXMua2V5cygpJTBBJTdE",highlighted:`splits = {
    word: [c <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">f&quot;##<span class="hljs-subst">{c}</span>&quot;</span> <span class="hljs-keyword">for</span> i, c <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(word)]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()
}`,wrap:!1}}),Ts=new u({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX3Njb3JlcyhzcGxpdHMpJTNBJTBBJTIwJTIwJTIwJTIwbGV0dGVyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBkZWZhdWx0ZGljdChpbnQpJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyQyUyMGZyZXElMjBpbiUyMHdvcmRfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXRzJTVCd29yZCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHNwbGl0KSUyMCUzRCUzRCUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsZXR0ZXJfZnJlcXMlNUJzcGxpdCU1QjAlNUQlNUQlMjAlMkIlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxldHRlcl9mcmVxcyU1QnNwbGl0JTVCaSU1RCU1RCUyMCUyQiUzRCUyMGZyZXElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTVCcGFpciU1RCUyMCUyQiUzRCUyMGZyZXElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsZXR0ZXJfZnJlcXMlNUJzcGxpdCU1Qi0xJTVEJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXIlM0ElMjBmcmVxJTIwJTJGJTIwKGxldHRlcl9mcmVxcyU1QnBhaXIlNUIwJTVEJTVEJTIwKiUyMGxldHRlcl9mcmVxcyU1QnBhaXIlNUIxJTVEJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzY29yZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_scores</span>(<span class="hljs-params">splits</span>):
    letter_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            letter_freqs[split[<span class="hljs-number">0</span>]] += freq
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            letter_freqs[split[i]] += freq
            pair_freqs[pair] += freq
        letter_freqs[split[-<span class="hljs-number">1</span>]] += freq

    scores = {
        pair: freq / (letter_freqs[pair[<span class="hljs-number">0</span>]] * letter_freqs[pair[<span class="hljs-number">1</span>]])
        <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items()
    }
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),ms=new u({props:{code:"cGFpcl9zY29yZXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfc2NvcmVzKHNwbGl0cyklMEFmb3IlMjBpJTJDJTIwa2V5JTIwaW4lMjBlbnVtZXJhdGUocGFpcl9zY29yZXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX3Njb3JlcyU1QmtleSU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjBpZiUyMGklMjAlM0UlM0QlMjA1JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`pair_scores = compute_pair_scores(splits)
<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_scores.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_scores[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),hs=new u({props:{code:"KCdUJyUyQyUyMCclMjMlMjNoJyklM0ElMjAwLjEyNSUwQSgnJTIzJTIzaCclMkMlMjAnJTIzJTIzaScpJTNBJTIwMC4wMzQwOTA5MDkwOTA5MDkwOSUwQSgnJTIzJTIzaSclMkMlMjAnJTIzJTIzcycpJTNBJTIwMC4wMjcyNzI3MjcyNzI3MjcyNyUwQSgnaSclMkMlMjAnJTIzJTIzcycpJTNBJTIwMC4xJTBBKCd0JyUyQyUyMCclMjMlMjNoJyklM0ElMjAwLjAzNTcxNDI4NTcxNDI4NTcxJTBBKCclMjMlMjNoJyUyQyUyMCclMjMlMjNlJyklM0ElMjAwLjAxMTkwNDc2MTkwNDc2MTkwNA==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>): <span class="hljs-number">0.125</span>
(<span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>): <span class="hljs-number">0.03409090909090909</span>
(<span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>): <span class="hljs-number">0.02727272727272727</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>): <span class="hljs-number">0.1</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>): <span class="hljs-number">0.03571428571428571</span>
(<span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>): <span class="hljs-number">0.011904761904761904</span>`,wrap:!1}}),Is=new u({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X3Njb3JlJTIwJTNEJTIwTm9uZSUwQWZvciUyMHBhaXIlMkMlMjBzY29yZSUyMGluJTIwcGFpcl9zY29yZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X3Njb3JlJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfc2NvcmUlMjAlM0MlMjBzY29yZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfc2NvcmUlMjAlM0QlMjBzY29yZSUwQSUwQXByaW50KGJlc3RfcGFpciUyQyUyMG1heF9zY29yZSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_score = <span class="hljs-literal">None</span>
<span class="hljs-keyword">for</span> pair, score <span class="hljs-keyword">in</span> pair_scores.items():
    <span class="hljs-keyword">if</span> max_score <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_score &lt; score:
        best_pair = pair
        max_score = score

<span class="hljs-built_in">print</span>(best_pair, max_score)`,wrap:!1}}),Cs=new u({props:{code:"KCdhJyUyQyUyMCclMjMlMjNiJyklMjAwLjI=",highlighted:'(<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;##b&#x27;</span>) <span class="hljs-number">0.2</span>',wrap:!1}}),gs=new u({props:{code:"dm9jYWIuYXBwZW5kKCUyMmFiJTIyKQ==",highlighted:'vocab.append(<span class="hljs-string">&quot;ab&quot;</span>)',wrap:!1}}),bs=new u({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lcmdlJTIwJTNEJTIwYSUyMCUyQiUyMGIlNUIyJTNBJTVEJTIwaWYlMjBiLnN0YXJ0c3dpdGgoJTIyJTIzJTIzJTIyKSUyMGVsc2UlMjBhJTIwJTJCJTIwYiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCbWVyZ2UlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                merge = a + b[<span class="hljs-number">2</span>:] <span class="hljs-keyword">if</span> b.startswith(<span class="hljs-string">&quot;##&quot;</span>) <span class="hljs-keyword">else</span> a + b
                split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),qs=new u({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjJhJTIyJTJDJTIwJTIyJTIzJTIzYiUyMiUyQyUyMHNwbGl0cyklMEFzcGxpdHMlNUIlMjJhYm91dCUyMiU1RA==",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;##b&quot;</span>, splits)
splits[<span class="hljs-string">&quot;about&quot;</span>]`,wrap:!1}}),$s=new u({props:{code:"JTVCJ2FiJyUyQyUyMCclMjMlMjNvJyUyQyUyMCclMjMlMjN1JyUyQyUyMCclMjMlMjN0JyU1RA==",highlighted:'[<span class="hljs-string">&#x27;ab&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##t&#x27;</span>]',wrap:!1}}),As=new u({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDcwJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9zY29yZXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyQyUyMG1heF9zY29yZSUyMCUzRCUyMCUyMiUyMiUyQyUyME5vbmUlMEElMjAlMjAlMjAlMjBmb3IlMjBwYWlyJTJDJTIwc2NvcmUlMjBpbiUyMHNjb3Jlcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtYXhfc2NvcmUlMjBpcyUyME5vbmUlMjBvciUyMG1heF9zY29yZSUyMCUzQyUyMHNjb3JlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9wYWlyJTIwJTNEJTIwcGFpciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9zY29yZSUyMCUzRCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG5ld190b2tlbiUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlNUIwJTVEJTIwJTJCJTIwYmVzdF9wYWlyJTVCMSU1RCU1QjIlM0ElNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGJlc3RfcGFpciU1QjElNUQuc3RhcnRzd2l0aCglMjIlMjMlMjMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHZvY2FiLmFwcGVuZChuZXdfdG9rZW4p",highlighted:`vocab_size = <span class="hljs-number">70</span>
<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    scores = compute_pair_scores(splits)
    best_pair, max_score = <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, score <span class="hljs-keyword">in</span> scores.items():
        <span class="hljs-keyword">if</span> max_score <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_score &lt; score:
            best_pair = pair
            max_score = score
    splits = merge_pair(*best_pair, splits)
    new_token = (
        best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>][<span class="hljs-number">2</span>:]
        <span class="hljs-keyword">if</span> best_pair[<span class="hljs-number">1</span>].startswith(<span class="hljs-string">&quot;##&quot;</span>)
        <span class="hljs-keyword">else</span> best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    )
    vocab.append(new_token)`,wrap:!1}}),zs=new u({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Bs=new u({props:{code:"JTVCJyU1QlBBRCU1RCclMkMlMjAnJTVCVU5LJTVEJyUyQyUyMCclNUJDTFMlNUQnJTJDJTIwJyU1QlNFUCU1RCclMkMlMjAnJTVCTUFTSyU1RCclMkMlMjAnJTIzJTIzYSclMkMlMjAnJTIzJTIzYiclMkMlMjAnJTIzJTIzYyclMkMlMjAnJTIzJTIzZCclMkMlMjAnJTIzJTIzZSclMkMlMjAnJTIzJTIzZiclMkMlMjAnJTIzJTIzZyclMkMlMjAnJTIzJTIzaCclMkMlMjAnJTIzJTIzaSclMkMlMjAnJTIzJTIzayclMkMlMEElMjAnJTIzJTIzbCclMkMlMjAnJTIzJTIzbSclMkMlMjAnJTIzJTIzbiclMkMlMjAnJTIzJTIzbyclMkMlMjAnJTIzJTIzcCclMkMlMjAnJTIzJTIzciclMkMlMjAnJTIzJTIzcyclMkMlMjAnJTIzJTIzdCclMkMlMjAnJTIzJTIzdSclMkMlMjAnJTIzJTIzdiclMkMlMjAnJTIzJTIzdyclMkMlMjAnJTIzJTIzeSclMkMlMjAnJTIzJTIzeiclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUwQSUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCclMjMlMjNmdSclMkMlMjAnRmEnJTJDJTIwJ0ZhYyclMkMlMjAnJTIzJTIzY3QnJTJDJTIwJyUyMyUyM2Z1bCclMkMlMjAnJTIzJTIzZnVsbCclMkMlMjAnJTIzJTIzZnVsbHknJTJDJTBBJTIwJ1RoJyUyQyUyMCdjaCclMkMlMjAnJTIzJTIzaG0nJTJDJTIwJ2NoYSclMkMlMjAnY2hhcCclMkMlMjAnY2hhcHQnJTJDJTIwJyUyMyUyM3RobSclMkMlMjAnSHUnJTJDJTIwJ0h1ZyclMkMlMjAnSHVnZyclMkMlMjAnc2gnJTJDJTIwJ3RoJyUyQyUyMCdpcyclMkMlMjAnJTIzJTIzdGhtcyclMkMlMjAnJTIzJTIzemEnJTJDJTIwJyUyMyUyM3phdCclMkMlMEElMjAnJTIzJTIzdXQnJTVE",highlighted:`[<span class="hljs-string">&#x27;[PAD]&#x27;</span>, <span class="hljs-string">&#x27;[UNK]&#x27;</span>, <span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;[MASK]&#x27;</span>, <span class="hljs-string">&#x27;##a&#x27;</span>, <span class="hljs-string">&#x27;##b&#x27;</span>, <span class="hljs-string">&#x27;##c&#x27;</span>, <span class="hljs-string">&#x27;##d&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;##f&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##k&#x27;</span>,
 <span class="hljs-string">&#x27;##l&#x27;</span>, <span class="hljs-string">&#x27;##m&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##p&#x27;</span>, <span class="hljs-string">&#x27;##r&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>, <span class="hljs-string">&#x27;##t&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##v&#x27;</span>, <span class="hljs-string">&#x27;##w&#x27;</span>, <span class="hljs-string">&#x27;##y&#x27;</span>, <span class="hljs-string">&#x27;##z&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>,
 <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;##fu&#x27;</span>, <span class="hljs-string">&#x27;Fa&#x27;</span>, <span class="hljs-string">&#x27;Fac&#x27;</span>, <span class="hljs-string">&#x27;##ct&#x27;</span>, <span class="hljs-string">&#x27;##ful&#x27;</span>, <span class="hljs-string">&#x27;##full&#x27;</span>, <span class="hljs-string">&#x27;##fully&#x27;</span>,
 <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;ch&#x27;</span>, <span class="hljs-string">&#x27;##hm&#x27;</span>, <span class="hljs-string">&#x27;cha&#x27;</span>, <span class="hljs-string">&#x27;chap&#x27;</span>, <span class="hljs-string">&#x27;chapt&#x27;</span>, <span class="hljs-string">&#x27;##thm&#x27;</span>, <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;Hug&#x27;</span>, <span class="hljs-string">&#x27;Hugg&#x27;</span>, <span class="hljs-string">&#x27;sh&#x27;</span>, <span class="hljs-string">&#x27;th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;##thms&#x27;</span>, <span class="hljs-string">&#x27;##za&#x27;</span>, <span class="hljs-string">&#x27;##zat&#x27;</span>,
 <span class="hljs-string">&#x27;##ut&#x27;</span>]`,wrap:!1}}),d=new Ps({props:{$$slots:{default:[zn]},$$scope:{ctx:w}}}),Ns=new u({props:{code:"ZGVmJTIwZW5jb2RlX3dvcmQod29yZCklM0ElMEElMjAlMjAlMjAlMjB0b2tlbnMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjB3aGlsZSUyMGxlbih3b3JkKSUyMCUzRSUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwbGVuKHdvcmQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2hpbGUlMjBpJTIwJTNFJTIwMCUyMGFuZCUyMHdvcmQlNUIlM0FpJTVEJTIwbm90JTIwaW4lMjB2b2NhYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAtJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlMjIlNUJVTkslNUQlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbnMuYXBwZW5kKHdvcmQlNUIlM0FpJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmQlMjAlM0QlMjB3b3JkJTVCaSUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHdvcmQpJTIwJTNFJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmQlMjAlM0QlMjBmJTIyJTIzJTIzJTdCd29yZCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2Vucw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_word</span>(<span class="hljs-params">word</span>):
    tokens = []
    <span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(word) &gt; <span class="hljs-number">0</span>:
        i = <span class="hljs-built_in">len</span>(word)
        <span class="hljs-keyword">while</span> i &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> word[:i] <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> vocab:
            i -= <span class="hljs-number">1</span>
        <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;[UNK]&quot;</span>]
        tokens.append(word[:i])
        word = word[i:]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(word) &gt; <span class="hljs-number">0</span>:
            word = <span class="hljs-string">f&quot;##<span class="hljs-subst">{word}</span>&quot;</span>
    <span class="hljs-keyword">return</span> tokens`,wrap:!1}}),Es=new u({props:{code:"cHJpbnQoZW5jb2RlX3dvcmQoJTIySHVnZ2luZyUyMikpJTBBcHJpbnQoZW5jb2RlX3dvcmQoJTIySE9nZ2luZyUyMikp",highlighted:`<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;Hugging&quot;</span>))
<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;HOgging&quot;</span>))`,wrap:!1}}),Ss=new u({props:{code:"JTVCJ0h1Z2cnJTJDJTIwJyUyMyUyM2knJTJDJTIwJyUyMyUyM24nJTJDJTIwJyUyMyUyM2cnJTVEJTBBJTVCJyU1QlVOSyU1RCclNUQ=",highlighted:`[<span class="hljs-string">&#x27;Hugg&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>]
[<span class="hljs-string">&#x27;[UNK]&#x27;</span>]`,wrap:!1}}),Vs=new u({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBlbmNvZGVkX3dvcmRzJTIwJTNEJTIwJTVCZW5jb2RlX3dvcmQod29yZCklMjBmb3IlMjB3b3JkJTIwaW4lMjBwcmVfdG9rZW5pemVkX3RleHQlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzdW0oZW5jb2RlZF93b3JkcyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    encoded_words = [encode_word(word) <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(encoded_words, [])`,wrap:!1}}),Xs=new u({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBjb3Vyc2UhJTIyKQ==",highlighted:'tokenize(<span class="hljs-string">&quot;This is the Hugging Face course!&quot;</span>)',wrap:!1}}),Ws=new u({props:{code:"JTVCJ1RoJyUyQyUyMCclMjMlMjNpJyUyQyUyMCclMjMlMjNzJyUyQyUyMCdpcyclMkMlMjAndGgnJTJDJTIwJyUyMyUyM2UnJTJDJTIwJ0h1Z2cnJTJDJTIwJyUyMyUyM2knJTJDJTIwJyUyMyUyM24nJTJDJTIwJyUyMyUyM2cnJTJDJTIwJ0ZhYyclMkMlMjAnJTIzJTIzZSclMkMlMjAnYyclMkMlMjAnJTIzJTIzbyclMkMlMjAnJTIzJTIzdSclMkMlMjAnJTIzJTIzciclMkMlMjAnJTIzJTIzcyclMkMlMEElMjAnJTIzJTIzZSclMkMlMjAnJTVCVU5LJTVEJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;th&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;Hugg&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>, <span class="hljs-string">&#x27;Fac&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##r&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>,
 <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;[UNK]&#x27;</span>]`,wrap:!1}}),{c(){M=e("meta"),m=t(),T=e("p"),h=t(),j(b.$$.fragment),Ks=t(),j(f.$$.fragment),Ls=t(),q=e("p"),q.textContent=qa,Os=t(),j($.$$.fragment),sl=t(),j(I.$$.fragment),ll=t(),j(k.$$.fragment),al=t(),j(C.$$.fragment),nl=t(),A=e("p"),A.innerHTML=$a,tl=t(),j(Q.$$.fragment),pl=t(),z=e("p"),z.textContent=ka,Ml=t(),B=e("p"),ba=Cn(`然後,再次像 BPE 一樣,WordPiece 學習合併規則。主要區別在於選擇要合併的對的方式。WordPiece 不是選擇最頻繁的對，而是使用以下公式計算每對的分數:
`),el=new xn(!1),yl=t(),v=e("p"),v.innerHTML=Aa,jl=t(),Z=e("p"),Z.textContent=Qa,il=t(),j(N.$$.fragment),cl=t(),_=e("p"),_.textContent=za,Jl=t(),j(E.$$.fragment),rl=t(),S=e("p"),S.innerHTML=Ba,ol=t(),G=e("p"),G.innerHTML=va,Ul=t(),j(V.$$.fragment),Tl=t(),H=e("p"),H.innerHTML=Za,ul=t(),j(X.$$.fragment),ml=t(),W=e("p"),W.innerHTML=Na,hl=t(),j(R.$$.fragment),wl=t(),Y=e("p"),Y.textContent=_a,Il=t(),j(x.$$.fragment),Cl=t(),j(D.$$.fragment),xl=t(),P=e("p"),P.innerHTML=Ea,gl=t(),F=e("p"),F.innerHTML=Sa,dl=t(),K=e("p"),K.innerHTML=Ga,bl=t(),L=e("p"),L.innerHTML=Va,fl=t(),j(g.$$.fragment),ql=t(),j(O.$$.fragment),$l=t(),ss=e("p"),ss.textContent=Ha,kl=t(),ls=e("p"),ls.textContent=Xa,Al=t(),j(as.$$.fragment),Ql=t(),ns=e("p"),ns.innerHTML=Wa,zl=t(),j(ts.$$.fragment),Bl=t(),ps=e("p"),ps.textContent=Ra,vl=t(),j(Ms.$$.fragment),Zl=t(),j(es.$$.fragment),Nl=t(),ys=e("p"),ys.innerHTML=Ya,_l=t(),j(js.$$.fragment),El=t(),j(is.$$.fragment),Sl=t(),cs=e("p"),cs.innerHTML=Da,Gl=t(),j(Js.$$.fragment),Vl=t(),rs=e("p"),rs.innerHTML=Pa,Hl=t(),j(os.$$.fragment),Xl=t(),Us=e("p"),Us.textContent=Fa,Wl=t(),j(Ts.$$.fragment),Rl=t(),us=e("p"),us.textContent=Ka,Yl=t(),j(ms.$$.fragment),Dl=t(),j(hs.$$.fragment),Pl=t(),ws=e("p"),ws.textContent=La,Fl=t(),j(Is.$$.fragment),Kl=t(),j(Cs.$$.fragment),Ll=t(),xs=e("p"),xs.innerHTML=Oa,Ol=t(),j(gs.$$.fragment),sa=t(),ds=e("p"),ds.innerHTML=sn,la=t(),j(bs.$$.fragment),aa=t(),fs=e("p"),fs.textContent=ln,na=t(),j(qs.$$.fragment),ta=t(),j($s.$$.fragment),pa=t(),ks=e("p"),ks.textContent=an,Ma=t(),j(As.$$.fragment),ea=t(),Qs=e("p"),Qs.textContent=nn,ya=t(),j(zs.$$.fragment),ja=t(),j(Bs.$$.fragment),ia=t(),vs=e("p"),vs.textContent=tn,ca=t(),j(d.$$.fragment),Ja=t(),Zs=e("p"),Zs.textContent=pn,ra=t(),j(Ns.$$.fragment),oa=t(),_s=e("p"),_s.textContent=Mn,Ua=t(),j(Es.$$.fragment),Ta=t(),j(Ss.$$.fragment),ua=t(),Gs=e("p"),Gs.textContent=en,ma=t(),j(Vs.$$.fragment),ha=t(),Hs=e("p"),Hs.textContent=yn,wa=t(),j(Xs.$$.fragment),Ia=t(),j(Ws.$$.fragment),Ca=t(),Rs=e("p"),Rs.textContent=jn,xa=t(),Ds=e("p"),this.h()},l(s){const l=gn("svelte-u9bgzb",document.head);M=y(l,"META",{name:!0,content:!0}),l.forEach(a),m=p(s),T=y(s,"P",{}),fa(T).forEach(a),h=p(s),i(b.$$.fragment,s),Ks=p(s),i(f.$$.fragment,s),Ls=p(s),q=y(s,"P",{"data-svelte-h":!0}),U(q)!=="svelte-1mzl2c"&&(q.textContent=qa),Os=p(s),i($.$$.fragment,s),sl=p(s),i(I.$$.fragment,s),ll=p(s),i(k.$$.fragment,s),al=p(s),i(C.$$.fragment,s),nl=p(s),A=y(s,"P",{"data-svelte-h":!0}),U(A)!=="svelte-1fm3qp2"&&(A.innerHTML=$a),tl=p(s),i(Q.$$.fragment,s),pl=p(s),z=y(s,"P",{"data-svelte-h":!0}),U(z)!=="svelte-13gh3wp"&&(z.textContent=ka),Ml=p(s),B=y(s,"P",{});var Ys=fa(B);ba=dn(Ys,`然後,再次像 BPE 一樣,WordPiece 學習合併規則。主要區別在於選擇要合併的對的方式。WordPiece 不是選擇最頻繁的對，而是使用以下公式計算每對的分數:
`),el=bn(Ys,!1),Ys.forEach(a),yl=p(s),v=y(s,"P",{"data-svelte-h":!0}),U(v)!=="svelte-70nhht"&&(v.innerHTML=Aa),jl=p(s),Z=y(s,"P",{"data-svelte-h":!0}),U(Z)!=="svelte-bupd07"&&(Z.textContent=Qa),il=p(s),i(N.$$.fragment,s),cl=p(s),_=y(s,"P",{"data-svelte-h":!0}),U(_)!=="svelte-1fxfxxy"&&(_.textContent=za),Jl=p(s),i(E.$$.fragment,s),rl=p(s),S=y(s,"P",{"data-svelte-h":!0}),U(S)!=="svelte-1j0m9wg"&&(S.innerHTML=Ba),ol=p(s),G=y(s,"P",{"data-svelte-h":!0}),U(G)!=="svelte-1q8fdrn"&&(G.innerHTML=va),Ul=p(s),i(V.$$.fragment,s),Tl=p(s),H=y(s,"P",{"data-svelte-h":!0}),U(H)!=="svelte-cwk676"&&(H.innerHTML=Za),ul=p(s),i(X.$$.fragment,s),ml=p(s),W=y(s,"P",{"data-svelte-h":!0}),U(W)!=="svelte-1119244"&&(W.innerHTML=Na),hl=p(s),i(R.$$.fragment,s),wl=p(s),Y=y(s,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-i1ba9t"&&(Y.textContent=_a),Il=p(s),i(x.$$.fragment,s),Cl=p(s),i(D.$$.fragment,s),xl=p(s),P=y(s,"P",{"data-svelte-h":!0}),U(P)!=="svelte-4g6qo2"&&(P.innerHTML=Ea),gl=p(s),F=y(s,"P",{"data-svelte-h":!0}),U(F)!=="svelte-vt6nkx"&&(F.innerHTML=Sa),dl=p(s),K=y(s,"P",{"data-svelte-h":!0}),U(K)!=="svelte-nquh0a"&&(K.innerHTML=Ga),bl=p(s),L=y(s,"P",{"data-svelte-h":!0}),U(L)!=="svelte-1wtfode"&&(L.innerHTML=Va),fl=p(s),i(g.$$.fragment,s),ql=p(s),i(O.$$.fragment,s),$l=p(s),ss=y(s,"P",{"data-svelte-h":!0}),U(ss)!=="svelte-11ua671"&&(ss.textContent=Ha),kl=p(s),ls=y(s,"P",{"data-svelte-h":!0}),U(ls)!=="svelte-1vt0tqm"&&(ls.textContent=Xa),Al=p(s),i(as.$$.fragment,s),Ql=p(s),ns=y(s,"P",{"data-svelte-h":!0}),U(ns)!=="svelte-1nesya3"&&(ns.innerHTML=Wa),zl=p(s),i(ts.$$.fragment,s),Bl=p(s),ps=y(s,"P",{"data-svelte-h":!0}),U(ps)!=="svelte-16ge37"&&(ps.textContent=Ra),vl=p(s),i(Ms.$$.fragment,s),Zl=p(s),i(es.$$.fragment,s),Nl=p(s),ys=y(s,"P",{"data-svelte-h":!0}),U(ys)!=="svelte-eeu2p8"&&(ys.innerHTML=Ya),_l=p(s),i(js.$$.fragment,s),El=p(s),i(is.$$.fragment,s),Sl=p(s),cs=y(s,"P",{"data-svelte-h":!0}),U(cs)!=="svelte-juopub"&&(cs.innerHTML=Da),Gl=p(s),i(Js.$$.fragment,s),Vl=p(s),rs=y(s,"P",{"data-svelte-h":!0}),U(rs)!=="svelte-z4e8h1"&&(rs.innerHTML=Pa),Hl=p(s),i(os.$$.fragment,s),Xl=p(s),Us=y(s,"P",{"data-svelte-h":!0}),U(Us)!=="svelte-13t1fgg"&&(Us.textContent=Fa),Wl=p(s),i(Ts.$$.fragment,s),Rl=p(s),us=y(s,"P",{"data-svelte-h":!0}),U(us)!=="svelte-1gv0rei"&&(us.textContent=Ka),Yl=p(s),i(ms.$$.fragment,s),Dl=p(s),i(hs.$$.fragment,s),Pl=p(s),ws=y(s,"P",{"data-svelte-h":!0}),U(ws)!=="svelte-6i8pro"&&(ws.textContent=La),Fl=p(s),i(Is.$$.fragment,s),Kl=p(s),i(Cs.$$.fragment,s),Ll=p(s),xs=y(s,"P",{"data-svelte-h":!0}),U(xs)!=="svelte-r0s2qh"&&(xs.innerHTML=Oa),Ol=p(s),i(gs.$$.fragment,s),sa=p(s),ds=y(s,"P",{"data-svelte-h":!0}),U(ds)!=="svelte-1qax4vx"&&(ds.innerHTML=sn),la=p(s),i(bs.$$.fragment,s),aa=p(s),fs=y(s,"P",{"data-svelte-h":!0}),U(fs)!=="svelte-jw1a3u"&&(fs.textContent=ln),na=p(s),i(qs.$$.fragment,s),ta=p(s),i($s.$$.fragment,s),pa=p(s),ks=y(s,"P",{"data-svelte-h":!0}),U(ks)!=="svelte-vwwfxv"&&(ks.textContent=an),Ma=p(s),i(As.$$.fragment,s),ea=p(s),Qs=y(s,"P",{"data-svelte-h":!0}),U(Qs)!=="svelte-yjr042"&&(Qs.textContent=nn),ya=p(s),i(zs.$$.fragment,s),ja=p(s),i(Bs.$$.fragment,s),ia=p(s),vs=y(s,"P",{"data-svelte-h":!0}),U(vs)!=="svelte-dbdj0g"&&(vs.textContent=tn),ca=p(s),i(d.$$.fragment,s),Ja=p(s),Zs=y(s,"P",{"data-svelte-h":!0}),U(Zs)!=="svelte-gmo5qc"&&(Zs.textContent=pn),ra=p(s),i(Ns.$$.fragment,s),oa=p(s),_s=y(s,"P",{"data-svelte-h":!0}),U(_s)!=="svelte-azegfe"&&(_s.textContent=Mn),Ua=p(s),i(Es.$$.fragment,s),Ta=p(s),i(Ss.$$.fragment,s),ua=p(s),Gs=y(s,"P",{"data-svelte-h":!0}),U(Gs)!=="svelte-1343j6i"&&(Gs.textContent=en),ma=p(s),i(Vs.$$.fragment,s),ha=p(s),Hs=y(s,"P",{"data-svelte-h":!0}),U(Hs)!=="svelte-1qyiyb2"&&(Hs.textContent=yn),wa=p(s),i(Xs.$$.fragment,s),Ia=p(s),i(Ws.$$.fragment,s),Ca=p(s),Rs=y(s,"P",{"data-svelte-h":!0}),U(Rs)!=="svelte-1jn7a4o"&&(Rs.textContent=jn),xa=p(s),Ds=y(s,"P",{}),fa(Ds).forEach(a),this.h()},h(){Un(M,"name","hf:doc:metadata"),Un(M,"content",vn),el.a=null},m(s,l){Tn(document.head,M),n(s,m,l),n(s,T,l),n(s,h,l),c(b,s,l),n(s,Ks,l),c(f,s,l),n(s,Ls,l),n(s,q,l),n(s,Os,l),c($,s,l),n(s,sl,l),c(I,s,l),n(s,ll,l),c(k,s,l),n(s,al,l),c(C,s,l),n(s,nl,l),n(s,A,l),n(s,tl,l),c(Q,s,l),n(s,pl,l),n(s,z,l),n(s,Ml,l),n(s,B,l),Tn(B,ba),el.m(un,B),n(s,yl,l),n(s,v,l),n(s,jl,l),n(s,Z,l),n(s,il,l),c(N,s,l),n(s,cl,l),n(s,_,l),n(s,Jl,l),c(E,s,l),n(s,rl,l),n(s,S,l),n(s,ol,l),n(s,G,l),n(s,Ul,l),c(V,s,l),n(s,Tl,l),n(s,H,l),n(s,ul,l),c(X,s,l),n(s,ml,l),n(s,W,l),n(s,hl,l),c(R,s,l),n(s,wl,l),n(s,Y,l),n(s,Il,l),c(x,s,l),n(s,Cl,l),c(D,s,l),n(s,xl,l),n(s,P,l),n(s,gl,l),n(s,F,l),n(s,dl,l),n(s,K,l),n(s,bl,l),n(s,L,l),n(s,fl,l),c(g,s,l),n(s,ql,l),c(O,s,l),n(s,$l,l),n(s,ss,l),n(s,kl,l),n(s,ls,l),n(s,Al,l),c(as,s,l),n(s,Ql,l),n(s,ns,l),n(s,zl,l),c(ts,s,l),n(s,Bl,l),n(s,ps,l),n(s,vl,l),c(Ms,s,l),n(s,Zl,l),c(es,s,l),n(s,Nl,l),n(s,ys,l),n(s,_l,l),c(js,s,l),n(s,El,l),c(is,s,l),n(s,Sl,l),n(s,cs,l),n(s,Gl,l),c(Js,s,l),n(s,Vl,l),n(s,rs,l),n(s,Hl,l),c(os,s,l),n(s,Xl,l),n(s,Us,l),n(s,Wl,l),c(Ts,s,l),n(s,Rl,l),n(s,us,l),n(s,Yl,l),c(ms,s,l),n(s,Dl,l),c(hs,s,l),n(s,Pl,l),n(s,ws,l),n(s,Fl,l),c(Is,s,l),n(s,Kl,l),c(Cs,s,l),n(s,Ll,l),n(s,xs,l),n(s,Ol,l),c(gs,s,l),n(s,sa,l),n(s,ds,l),n(s,la,l),c(bs,s,l),n(s,aa,l),n(s,fs,l),n(s,na,l),c(qs,s,l),n(s,ta,l),c($s,s,l),n(s,pa,l),n(s,ks,l),n(s,Ma,l),c(As,s,l),n(s,ea,l),n(s,Qs,l),n(s,ya,l),c(zs,s,l),n(s,ja,l),c(Bs,s,l),n(s,ia,l),n(s,vs,l),n(s,ca,l),c(d,s,l),n(s,Ja,l),n(s,Zs,l),n(s,ra,l),c(Ns,s,l),n(s,oa,l),n(s,_s,l),n(s,Ua,l),c(Es,s,l),n(s,Ta,l),c(Ss,s,l),n(s,ua,l),n(s,Gs,l),n(s,ma,l),c(Vs,s,l),n(s,ha,l),n(s,Hs,l),n(s,wa,l),c(Xs,s,l),n(s,Ia,l),c(Ws,s,l),n(s,Ca,l),n(s,Rs,l),n(s,xa,l),n(s,Ds,l),ga=!0},p(s,[l]){const Ys={};l&2&&(Ys.$$scope={dirty:l,ctx:s}),I.$set(Ys);const cn={};l&2&&(cn.$$scope={dirty:l,ctx:s}),C.$set(cn);const Jn={};l&2&&(Jn.$$scope={dirty:l,ctx:s}),x.$set(Jn);const rn={};l&2&&(rn.$$scope={dirty:l,ctx:s}),g.$set(rn);const on={};l&2&&(on.$$scope={dirty:l,ctx:s}),d.$set(on)},i(s){ga||(J(b.$$.fragment,s),J(f.$$.fragment,s),J($.$$.fragment,s),J(I.$$.fragment,s),J(k.$$.fragment,s),J(C.$$.fragment,s),J(Q.$$.fragment,s),J(N.$$.fragment,s),J(E.$$.fragment,s),J(V.$$.fragment,s),J(X.$$.fragment,s),J(R.$$.fragment,s),J(x.$$.fragment,s),J(D.$$.fragment,s),J(g.$$.fragment,s),J(O.$$.fragment,s),J(as.$$.fragment,s),J(ts.$$.fragment,s),J(Ms.$$.fragment,s),J(es.$$.fragment,s),J(js.$$.fragment,s),J(is.$$.fragment,s),J(Js.$$.fragment,s),J(os.$$.fragment,s),J(Ts.$$.fragment,s),J(ms.$$.fragment,s),J(hs.$$.fragment,s),J(Is.$$.fragment,s),J(Cs.$$.fragment,s),J(gs.$$.fragment,s),J(bs.$$.fragment,s),J(qs.$$.fragment,s),J($s.$$.fragment,s),J(As.$$.fragment,s),J(zs.$$.fragment,s),J(Bs.$$.fragment,s),J(d.$$.fragment,s),J(Ns.$$.fragment,s),J(Es.$$.fragment,s),J(Ss.$$.fragment,s),J(Vs.$$.fragment,s),J(Xs.$$.fragment,s),J(Ws.$$.fragment,s),ga=!0)},o(s){r(b.$$.fragment,s),r(f.$$.fragment,s),r($.$$.fragment,s),r(I.$$.fragment,s),r(k.$$.fragment,s),r(C.$$.fragment,s),r(Q.$$.fragment,s),r(N.$$.fragment,s),r(E.$$.fragment,s),r(V.$$.fragment,s),r(X.$$.fragment,s),r(R.$$.fragment,s),r(x.$$.fragment,s),r(D.$$.fragment,s),r(g.$$.fragment,s),r(O.$$.fragment,s),r(as.$$.fragment,s),r(ts.$$.fragment,s),r(Ms.$$.fragment,s),r(es.$$.fragment,s),r(js.$$.fragment,s),r(is.$$.fragment,s),r(Js.$$.fragment,s),r(os.$$.fragment,s),r(Ts.$$.fragment,s),r(ms.$$.fragment,s),r(hs.$$.fragment,s),r(Is.$$.fragment,s),r(Cs.$$.fragment,s),r(gs.$$.fragment,s),r(bs.$$.fragment,s),r(qs.$$.fragment,s),r($s.$$.fragment,s),r(As.$$.fragment,s),r(zs.$$.fragment,s),r(Bs.$$.fragment,s),r(d.$$.fragment,s),r(Ns.$$.fragment,s),r(Es.$$.fragment,s),r(Ss.$$.fragment,s),r(Vs.$$.fragment,s),r(Xs.$$.fragment,s),r(Ws.$$.fragment,s),ga=!1},d(s){s&&(a(m),a(T),a(h),a(Ks),a(Ls),a(q),a(Os),a(sl),a(ll),a(al),a(nl),a(A),a(tl),a(pl),a(z),a(Ml),a(B),a(yl),a(v),a(jl),a(Z),a(il),a(cl),a(_),a(Jl),a(rl),a(S),a(ol),a(G),a(Ul),a(Tl),a(H),a(ul),a(ml),a(W),a(hl),a(wl),a(Y),a(Il),a(Cl),a(xl),a(P),a(gl),a(F),a(dl),a(K),a(bl),a(L),a(fl),a(ql),a($l),a(ss),a(kl),a(ls),a(Al),a(Ql),a(ns),a(zl),a(Bl),a(ps),a(vl),a(Zl),a(Nl),a(ys),a(_l),a(El),a(Sl),a(cs),a(Gl),a(Vl),a(rs),a(Hl),a(Xl),a(Us),a(Wl),a(Rl),a(us),a(Yl),a(Dl),a(Pl),a(ws),a(Fl),a(Kl),a(Ll),a(xs),a(Ol),a(sa),a(ds),a(la),a(aa),a(fs),a(na),a(ta),a(pa),a(ks),a(Ma),a(ea),a(Qs),a(ya),a(ja),a(ia),a(vs),a(ca),a(Ja),a(Zs),a(ra),a(oa),a(_s),a(Ua),a(Ta),a(ua),a(Gs),a(ma),a(ha),a(Hs),a(wa),a(Ia),a(Ca),a(Rs),a(xa),a(Ds)),a(M),o(b,s),o(f,s),o($,s),o(I,s),o(k,s),o(C,s),o(Q,s),o(N,s),o(E,s),o(V,s),o(X,s),o(R,s),o(x,s),o(D,s),o(g,s),o(O,s),o(as,s),o(ts,s),o(Ms,s),o(es,s),o(js,s),o(is,s),o(Js,s),o(os,s),o(Ts,s),o(ms,s),o(hs,s),o(Is,s),o(Cs,s),o(gs,s),o(bs,s),o(qs,s),o($s,s),o(As,s),o(zs,s),o(Bs,s),o(d,s),o(Ns,s),o(Es,s),o(Ss,s),o(Vs,s),o(Xs,s),o(Ws,s)}}}const vn='{"title":"WordPiece 標記化","local":"wordpiece-標記化","sections":[{"title":"訓練算法","local":"訓練算法","sections":[],"depth":2},{"title":"標記化算法","local":"標記化算法","sections":[],"depth":2},{"title":"實現 WordPiece","local":"實現-wordpiece","sections":[],"depth":2}],"depth":1}';function Zn(w){return hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xn extends wn{constructor(M){super(),In(this,M,Zn,Bn,mn,{})}}export{Xn as component};
