import{s as ft,o as yt,n as ut}from"../chunks/scheduler.182ea377.js";import{S as ht,i as Mt,g as a,s as n,r as c,A as bt,h as p,f as l,c as s,j as ct,u as d,x as m,k as ie,y as wt,a as i,v as u,d as f,t as y,w as h}from"../chunks/index.abf12888.js";import{T as dt}from"../chunks/Tip.230e2334.js";import{C as b}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ut}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as Se}from"../chunks/Heading.16916d63.js";function Tt(le){let o,M="🔒 By loading a community pipeline from the Hugging Face Hub, you are trusting that the code you are loading is safe. Make sure to inspect the code online before loading and running it automatically!";return{c(){o=a("p"),o.textContent=M},l(r){o=p(r,"P",{"data-svelte-h":!0}),m(o)!=="svelte-154jbq5"&&(o.textContent=M)},m(r,w){i(r,o,w)},p:ut,d(r){r&&l(o)}}}function gt(le){let o,M='In steps 4 and 5, the custom <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">UNet</a> and <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">pipeline</a> implementation must match the format shown in their files for this example to work.';return{c(){o=a("p"),o.innerHTML=M},l(r){o=p(r,"P",{"data-svelte-h":!0}),m(o)!=="svelte-ptu9pr"&&(o.innerHTML=M)},m(r,w){i(r,o,w)},p:ut,d(r){r&&l(o)}}}function Jt(le){let o,M,r,w,V,se,v,oe,j,ae,$,Qe='Community pipelines are any <a href="/docs/diffusers/v0.26.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class that are different from the original implementation as specified in their paper (for example, the <a href="/docs/diffusers/v0.26.1/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> corresponds to the <a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Text-to-Image Generation with ControlNet Conditioning</a> paper). They provide additional functionality or extend the original implementation of a pipeline.',pe,C,Fe='There are many cool community pipelines like <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#speech-to-image" rel="nofollow">Speech to Image</a> or <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#composable-stable-diffusion" rel="nofollow">Composable Stable Diffusion</a>, and you can find all the official community pipelines <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">here</a>.',me,W,Le='To load any community pipeline on the Hub, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you’d like to load the pipeline weights and components from. For example, the example below loads a dummy pipeline from <a href="https://huggingface.co/hf-internal-testing/diffusers-dummy-pipeline/blob/main/pipeline.py" rel="nofollow"><code>hf-internal-testing/diffusers-dummy-pipeline</code></a> and the pipeline weights and components from <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a>:',re,U,ce,k,de,G,ze='Loading an official community pipeline is similar, but you can mix loading weights from an official repository id and pass pipeline components directly. The example below loads the community <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#clip-guided-stable-diffusion" rel="nofollow">CLIP Guided Stable Diffusion</a> pipeline, and you can pass the CLIP model components directly to it:',ue,B,fe,x,Ye='For more information about community pipelines, take a look at the <a href="custom_pipeline_examples">Community pipelines</a> guide for how to use them and if you’re interested in adding a community pipeline check out the <a href="contribute_pipeline">How to contribute a community pipeline</a> guide!',ye,I,he,R,Pe="Community components allow users to build pipelines that may have customized components that are not a part of Diffusers. If your pipeline has custom components that Diffusers doesn’t already support, you need to provide their implementations as Python modules. These customized components could be a VAE, UNet, and scheduler. In most cases, the text encoder is imported from the Transformers library. The pipeline code itself can also be customized.",Me,H,qe="This section shows how users should use community components to build a community pipeline.",be,E,De='You’ll use the <a href="https://huggingface.co/showlab/show-1-base" rel="nofollow">showlab/show-1-base</a> pipeline checkpoint as an example. So, let’s start loading the components:',we,N,Ae="<li>Import and load the text encoder from Transformers:</li>",Ue,X,Te,T,Oe="<li>Load a scheduler:</li>",ge,S,Je,g,Ke="<li>Load an image processor:</li>",_e,Q,Ze,J,Ve,_,et='<li>Now you’ll load a <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">custom UNet</a>, which in this example, has already been implemented in the <code>showone_unet_3d_condition.py</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">script</a> for your convenience. You’ll notice the <code>UNet3DConditionModel</code> class name is changed to <code>ShowOneUNet3DConditionModel</code> because <a href="/docs/diffusers/v0.26.1/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> already exists in Diffusers. Any components needed for the <code>ShowOneUNet3DConditionModel</code> class should be placed in the <code>showone_unet_3d_condition.py</code> script.</li>',ve,F,tt="Once this is done, you can initialize the UNet:",je,L,$e,Z,lt='<li>Finally, you’ll load the custom pipeline code. For this example, it has already been created for you in the <code>pipeline_t2v_base_pixel.py</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/pipeline_t2v_base_pixel.py" rel="nofollow">script</a>. This script contains a custom <code>TextToVideoIFPipeline</code> class for generating videos from text. Just like the custom UNet, any code needed for the custom pipeline to work should go in the <code>pipeline_t2v_base_pixel.py</code> script.</li>',Ce,z,it="Once everything is in place, you can initialize the <code>TextToVideoIFPipeline</code> with the <code>ShowOneUNet3DConditionModel</code>:",We,Y,ke,P,nt="Push the pipeline to the Hub to share with the community!",Ge,q,Be,D,st="After the pipeline is successfully pushed, you need a couple of changes:",xe,A,ot='<li>Change the <code>_class_name</code> attribute in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/model_index.json#L2" rel="nofollow"><code>model_index.json</code></a> to <code>&quot;pipeline_t2v_base_pixel&quot;</code> and <code>&quot;TextToVideoIFPipeline&quot;</code>.</li> <li>Upload <code>showone_unet_3d_condition.py</code> to the <code>unet</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">directory</a>.</li> <li>Upload <code>pipeline_t2v_base_pixel.py</code> to the pipeline base <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">directory</a>.</li>',Ie,O,at="To run inference, simply add the <code>trust_remote_code</code> argument while initializing the pipeline to handle all the “magic” behind the scenes.",Re,K,He,ee,pt='As an additional reference example, you can refer to the repository structure of <a href="https://huggingface.co/stabilityai/japanese-stable-diffusion-xl/" rel="nofollow">stabilityai/japanese-stable-diffusion-xl</a>, that makes use of the <code>trust_remote_code</code> feature:',Ee,te,Ne,ne,Xe;return V=new Se({props:{title:"Load community pipelines and components",local:"load-community-pipelines-and-components",headingTag:"h1"}}),v=new Ut({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"}]}}),j=new Se({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h2"}}),U=new dt({props:{warning:!0,$$slots:{default:[Tt]},$$scope:{ctx:le}}}),k=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1kdW1teS1waXBlbGluZSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;hf-internal-testing/diffusers-dummy-pipeline&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),B=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),I=new Se({props:{title:"Community components",local:"community-components",headingTag:"h2"}}),X=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFwaXBlX2lkJTIwJTNEJTIwJTIyc2hvd2xhYiUyRnNob3ctMS1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5EncoderModel

pipe_id = <span class="hljs-string">&quot;showlab/show-1-base&quot;</span>
tokenizer = T5Tokenizer.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
text_encoder = T5EncoderModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)`,wrap:!1}}),S=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

scheduler = DPMSolverMultistepScheduler.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),Q=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBDTElQRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMmZlYXR1cmVfZXh0cmFjdG9yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor

feature_extractor = CLIPFeatureExtractor.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;feature_extractor&quot;</span>)`,wrap:!1}}),J=new dt({props:{warning:!0,$$slots:{default:[gt]},$$scope:{ctx:le}}}),L=new b({props:{code:"ZnJvbSUyMHNob3dvbmVfdW5ldF8zZF9jb25kaXRpb24lMjBpbXBvcnQlMjBTaG93T25lVU5ldDNEQ29uZGl0aW9uTW9kZWwlMEElMEF1bmV0JTIwJTNEJTIwU2hvd09uZVVOZXQzRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZChwaXBlX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> showone_unet_3d_condition <span class="hljs-keyword">import</span> ShowOneUNet3DConditionModel

unet = ShowOneUNet3DConditionModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),Y=new b({props:{code:"ZnJvbSUyMHBpcGVsaW5lX3Qydl9iYXNlX3BpeGVsJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9JRlBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFRleHRUb1ZpZGVvSUZQaXBlbGluZSglMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3IlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byhkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnRvcmNoX2R0eXBlJTIwJTNEJTIwdG9yY2guZmxvYXQxNg==",highlighted:`<span class="hljs-keyword">from</span> pipeline_t2v_base_pixel <span class="hljs-keyword">import</span> TextToVideoIFPipeline
<span class="hljs-keyword">import</span> torch

pipeline = TextToVideoIFPipeline(
    unet=unet,
    text_encoder=text_encoder,
    tokenizer=tokenizer,
    scheduler=scheduler,
    feature_extractor=feature_extractor
)
pipeline = pipeline.to(device=<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.torch_dtype = torch.float16`,wrap:!1}}),q=new b({props:{code:"cGlwZWxpbmUucHVzaF90b19odWIoJTIyY3VzdG9tLXQydi1waXBlbGluZSUyMik=",highlighted:'pipeline.push_to_hub(<span class="hljs-string">&quot;custom-t2v-pipeline&quot;</span>)',wrap:!1}}),K=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIlM0NjaGFuZ2UtdXNlcm5hbWUlM0UlMkYlM0NjaGFuZ2UtaWQlM0UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaGVsbG8lMjIlMEElMEElMjMlMjBUZXh0JTIwZW1iZWRzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMG5lZ2F0aXZlX2VtYmVkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQocHJvbXB0KSUwQSUwQSUyMyUyMEtleWZyYW1lcyUyMGdlbmVyYXRpb24lMjAoOHg2NHg0MCUyQyUyMDJmcHMpJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOS4wJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwdCUyMiUwQSkuZnJhbWVz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;&lt;change-username&gt;/&lt;change-id&gt;&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;hello&quot;</span>

<span class="hljs-comment"># Text embeds</span>
prompt_embeds, negative_embeds = pipeline.encode_prompt(prompt)

<span class="hljs-comment"># Keyframes generation (8x64x40, 2fps)</span>
video_frames = pipeline(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    num_frames=<span class="hljs-number">8</span>,
    height=<span class="hljs-number">40</span>,
    width=<span class="hljs-number">64</span>,
    num_inference_steps=<span class="hljs-number">2</span>,
    guidance_scale=<span class="hljs-number">9.0</span>,
    output_type=<span class="hljs-string">&quot;pt&quot;</span>
).frames`,wrap:!1}}),te=new b({props:{code:"JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRmphcGFuZXNlLXN0YWJsZS1kaWZmdXNpb24teGwlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBpZiUyMHVzaW5nJTIwdG9yY2glMjAlM0MlMjAyLjAlMEElMjMlMjBwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiVFNiU5RiVCNCVFNyU4QSVBQyVFMyU4MCU4MSVFMyU4MiVBQiVFMyU4MyVBOSVFMyU4MyU5NSVFMyU4MyVBQiVFMyU4MiVBMiVFMyU4MyVCQyVFMyU4MyU4OCUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBB",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/japanese-stable-diffusion-xl&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># if using torch &lt; 2.0</span>
<span class="hljs-comment"># pipeline.enable_xformers_memory_efficient_attention()</span>

prompt = <span class="hljs-string">&quot;柴犬、カラフルアート&quot;</span>

image = pipeline(prompt=prompt).images[<span class="hljs-number">0</span>]
`,wrap:!1}}),{c(){o=a("meta"),M=n(),r=a("p"),w=n(),c(V.$$.fragment),se=n(),c(v.$$.fragment),oe=n(),c(j.$$.fragment),ae=n(),$=a("p"),$.innerHTML=Qe,pe=n(),C=a("p"),C.innerHTML=Fe,me=n(),W=a("p"),W.innerHTML=Le,re=n(),c(U.$$.fragment),ce=n(),c(k.$$.fragment),de=n(),G=a("p"),G.innerHTML=ze,ue=n(),c(B.$$.fragment),fe=n(),x=a("p"),x.innerHTML=Ye,ye=n(),c(I.$$.fragment),he=n(),R=a("p"),R.textContent=Pe,Me=n(),H=a("p"),H.textContent=qe,be=n(),E=a("p"),E.innerHTML=De,we=n(),N=a("ol"),N.innerHTML=Ae,Ue=n(),c(X.$$.fragment),Te=n(),T=a("ol"),T.innerHTML=Oe,ge=n(),c(S.$$.fragment),Je=n(),g=a("ol"),g.innerHTML=Ke,_e=n(),c(Q.$$.fragment),Ze=n(),c(J.$$.fragment),Ve=n(),_=a("ol"),_.innerHTML=et,ve=n(),F=a("p"),F.textContent=tt,je=n(),c(L.$$.fragment),$e=n(),Z=a("ol"),Z.innerHTML=lt,Ce=n(),z=a("p"),z.innerHTML=it,We=n(),c(Y.$$.fragment),ke=n(),P=a("p"),P.textContent=nt,Ge=n(),c(q.$$.fragment),Be=n(),D=a("p"),D.textContent=st,xe=n(),A=a("ol"),A.innerHTML=ot,Ie=n(),O=a("p"),O.innerHTML=at,Re=n(),c(K.$$.fragment),He=n(),ee=a("p"),ee.innerHTML=pt,Ee=n(),c(te.$$.fragment),Ne=n(),ne=a("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(l),M=s(e),r=p(e,"P",{}),ct(r).forEach(l),w=s(e),d(V.$$.fragment,e),se=s(e),d(v.$$.fragment,e),oe=s(e),d(j.$$.fragment,e),ae=s(e),$=p(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-3430bh"&&($.innerHTML=Qe),pe=s(e),C=p(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-10en0rk"&&(C.innerHTML=Fe),me=s(e),W=p(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1mmnk2f"&&(W.innerHTML=Le),re=s(e),d(U.$$.fragment,e),ce=s(e),d(k.$$.fragment,e),de=s(e),G=p(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1yyre8w"&&(G.innerHTML=ze),ue=s(e),d(B.$$.fragment,e),fe=s(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1ho2g1z"&&(x.innerHTML=Ye),ye=s(e),d(I.$$.fragment,e),he=s(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1vh7uou"&&(R.textContent=Pe),Me=s(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-phpvnj"&&(H.textContent=qe),be=s(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-7sknw0"&&(E.innerHTML=De),we=s(e),N=p(e,"OL",{"data-svelte-h":!0}),m(N)!=="svelte-8ccbl9"&&(N.innerHTML=Ae),Ue=s(e),d(X.$$.fragment,e),Te=s(e),T=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(T)!=="svelte-1rtkhjg"&&(T.innerHTML=Oe),ge=s(e),d(S.$$.fragment,e),Je=s(e),g=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(g)!=="svelte-o9t4x9"&&(g.innerHTML=Ke),_e=s(e),d(Q.$$.fragment,e),Ze=s(e),d(J.$$.fragment,e),Ve=s(e),_=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(_)!=="svelte-1vt5uqu"&&(_.innerHTML=et),ve=s(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-4yol19"&&(F.textContent=tt),je=s(e),d(L.$$.fragment,e),$e=s(e),Z=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(Z)!=="svelte-1m9qhhm"&&(Z.innerHTML=lt),Ce=s(e),z=p(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1jpprmd"&&(z.innerHTML=it),We=s(e),d(Y.$$.fragment,e),ke=s(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-14lz5yb"&&(P.textContent=nt),Ge=s(e),d(q.$$.fragment,e),Be=s(e),D=p(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-azdq2p"&&(D.textContent=st),xe=s(e),A=p(e,"OL",{"data-svelte-h":!0}),m(A)!=="svelte-7wsjmh"&&(A.innerHTML=ot),Ie=s(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-xpz58c"&&(O.innerHTML=at),Re=s(e),d(K.$$.fragment,e),He=s(e),ee=p(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1cmjoh5"&&(ee.innerHTML=pt),Ee=s(e),d(te.$$.fragment,e),Ne=s(e),ne=p(e,"P",{}),ct(ne).forEach(l),this.h()},h(){ie(o,"name","hf:doc:metadata"),ie(o,"content",_t),ie(T,"start","2"),ie(g,"start","3"),ie(_,"start","4"),ie(Z,"start","5")},m(e,t){wt(document.head,o),i(e,M,t),i(e,r,t),i(e,w,t),u(V,e,t),i(e,se,t),u(v,e,t),i(e,oe,t),u(j,e,t),i(e,ae,t),i(e,$,t),i(e,pe,t),i(e,C,t),i(e,me,t),i(e,W,t),i(e,re,t),u(U,e,t),i(e,ce,t),u(k,e,t),i(e,de,t),i(e,G,t),i(e,ue,t),u(B,e,t),i(e,fe,t),i(e,x,t),i(e,ye,t),u(I,e,t),i(e,he,t),i(e,R,t),i(e,Me,t),i(e,H,t),i(e,be,t),i(e,E,t),i(e,we,t),i(e,N,t),i(e,Ue,t),u(X,e,t),i(e,Te,t),i(e,T,t),i(e,ge,t),u(S,e,t),i(e,Je,t),i(e,g,t),i(e,_e,t),u(Q,e,t),i(e,Ze,t),u(J,e,t),i(e,Ve,t),i(e,_,t),i(e,ve,t),i(e,F,t),i(e,je,t),u(L,e,t),i(e,$e,t),i(e,Z,t),i(e,Ce,t),i(e,z,t),i(e,We,t),u(Y,e,t),i(e,ke,t),i(e,P,t),i(e,Ge,t),u(q,e,t),i(e,Be,t),i(e,D,t),i(e,xe,t),i(e,A,t),i(e,Ie,t),i(e,O,t),i(e,Re,t),u(K,e,t),i(e,He,t),i(e,ee,t),i(e,Ee,t),u(te,e,t),i(e,Ne,t),i(e,ne,t),Xe=!0},p(e,[t]){const mt={};t&2&&(mt.$$scope={dirty:t,ctx:e}),U.$set(mt);const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),J.$set(rt)},i(e){Xe||(f(V.$$.fragment,e),f(v.$$.fragment,e),f(j.$$.fragment,e),f(U.$$.fragment,e),f(k.$$.fragment,e),f(B.$$.fragment,e),f(I.$$.fragment,e),f(X.$$.fragment,e),f(S.$$.fragment,e),f(Q.$$.fragment,e),f(J.$$.fragment,e),f(L.$$.fragment,e),f(Y.$$.fragment,e),f(q.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),Xe=!0)},o(e){y(V.$$.fragment,e),y(v.$$.fragment,e),y(j.$$.fragment,e),y(U.$$.fragment,e),y(k.$$.fragment,e),y(B.$$.fragment,e),y(I.$$.fragment,e),y(X.$$.fragment,e),y(S.$$.fragment,e),y(Q.$$.fragment,e),y(J.$$.fragment,e),y(L.$$.fragment,e),y(Y.$$.fragment,e),y(q.$$.fragment,e),y(K.$$.fragment,e),y(te.$$.fragment,e),Xe=!1},d(e){e&&(l(M),l(r),l(w),l(se),l(oe),l(ae),l($),l(pe),l(C),l(me),l(W),l(re),l(ce),l(de),l(G),l(ue),l(fe),l(x),l(ye),l(he),l(R),l(Me),l(H),l(be),l(E),l(we),l(N),l(Ue),l(Te),l(T),l(ge),l(Je),l(g),l(_e),l(Ze),l(Ve),l(_),l(ve),l(F),l(je),l($e),l(Z),l(Ce),l(z),l(We),l(ke),l(P),l(Ge),l(Be),l(D),l(xe),l(A),l(Ie),l(O),l(Re),l(He),l(ee),l(Ee),l(Ne),l(ne)),l(o),h(V,e),h(v,e),h(j,e),h(U,e),h(k,e),h(B,e),h(I,e),h(X,e),h(S,e),h(Q,e),h(J,e),h(L,e),h(Y,e),h(q,e),h(K,e),h(te,e)}}}const _t='{"title":"Load community pipelines and components","local":"load-community-pipelines-and-components","sections":[{"title":"Community pipelines","local":"community-pipelines","sections":[],"depth":2},{"title":"Community components","local":"community-components","sections":[],"depth":2}],"depth":1}';function Zt(le){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends ht{constructor(o){super(),Mt(this,o,Zt,Jt,ft,{})}}export{kt as component};
