import{s as qs,o as ks,n as Q}from"../chunks/scheduler.9bc65507.js";import{S as Zs,i as Gs,g as p,s,r as u,A as Is,h as m,f as l,c as i,j as Cs,u as f,x as d,k as Ee,y as zs,a,v as h,d as c,t as g,w as b}from"../chunks/index.707bf1b6.js";import{T as B}from"../chunks/Tip.c2ecdbf4.js";import{C as _}from"../chunks/CodeBlock.54a9f38d.js";import{H as I}from"../chunks/Heading.342b1fa6.js";import{H as pn,a as Ye}from"../chunks/HfOption.6d864328.js";function Qs(U){let n,y='Interested in adding a new quantization method to Transformers? Read the <a href="./hf_quantizer">HfQuantizer</a> guide to learn how!';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-px0yfi"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Bs(U){let n,y='Try AWQ quantization with this <a href="https://colab.research.google.com/drive/1HzZH89yAXJaZgwJDhQj9LqSBux932BvY" rel="nofollow">notebook</a>!';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1yzcfmc"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Ws(U){let n,y="Fused modules cannot be combined with other optimization techniques such as FlashAttention-2.";return{c(){n=p("p"),n.textContent=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-hwgpn3"&&(n.textContent=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Vs(U){let n,y='To enable fused modules for supported architectures, create an <a href="/docs/transformers/main/en/main_classes/quantization#transformers.AwqConfig">AwqConfig</a> and set the parameters <code>fuse_max_seq_len</code> and <code>do_fuse=True</code>. The <code>fuse_max_seq_len</code> parameter is the total sequence length and it should include the context length and the expected generation length. You can set it to a larger value to be safe.',o,M,r='For example, to fuse the AWQ modules of the <a href="https://huggingface.co/TheBloke/Mistral-7B-OpenOrca-AWQ" rel="nofollow">TheBloke/Mistral-7B-OpenOrca-AWQ</a> model.',T,v,C;return v=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXdxQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMlRoZUJsb2tlJTJGTWlzdHJhbC03Qi1PcGVuT3JjYS1BV1ElMjIlMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQXdxQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGJpdHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZnVzZV9tYXhfc2VxX2xlbiUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMGRvX2Z1c2UlM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpLnRvKDAp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AwqConfig, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;TheBloke/Mistral-7B-OpenOrca-AWQ&quot;</span>

quantization_config = AwqConfig(
    bits=<span class="hljs-number">4</span>,
    fuse_max_seq_len=<span class="hljs-number">512</span>,
    do_fuse=<span class="hljs-literal">True</span>,
)

model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config).to(<span class="hljs-number">0</span>)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=s(),M=p("p"),M.innerHTML=r,T=s(),u(v.$$.fragment)},l(w){n=m(w,"P",{"data-svelte-h":!0}),d(n)!=="svelte-cvz4de"&&(n.innerHTML=y),o=i(w),M=m(w,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1zxz2i"&&(M.innerHTML=r),T=i(w),f(v.$$.fragment,w)},m(w,q){a(w,n,q),a(w,o,q),a(w,M,q),a(w,T,q),h(v,w,q),C=!0},p:Q,i(w){C||(c(v.$$.fragment,w),C=!0)},o(w){g(v.$$.fragment,w),C=!1},d(w){w&&(l(n),l(o),l(M),l(T)),b(v,w)}}}function Fs(U){let n,y='For architectures that don’t support fused modules yet, you need to create a custom fusing mapping to define which modules need to be fused with the <code>modules_to_fuse</code> parameter. For example, to fuse the AWQ modules of the <a href="https://huggingface.co/TheBloke/Yi-34B-AWQ" rel="nofollow">TheBloke/Yi-34B-AWQ</a> model.',o,M,r,T,v="The parameter <code>modules_to_fuse</code> should include:",C,w,q="<li><code>&quot;attention&quot;</code>: The names of the attention layers to fuse in the following order: query, key, value and output projection layer. If you don’t want to fuse these layers, pass an empty list.</li> <li><code>&quot;layernorm&quot;</code>: The names of all the LayerNorm layers you want to replace with a custom fused LayerNorm. If you don’t want to fuse these layers, pass an empty list.</li> <li><code>&quot;mlp&quot;</code>: The names of the MLP layers you want to fuse into a single MLP layer in the order: (gate (dense, layer, post-attention) / up / down layers).</li> <li><code>&quot;use_alibi&quot;</code>: If your model uses ALiBi positional embedding.</li> <li><code>&quot;num_attention_heads&quot;</code>: The number of attention heads.</li> <li><code>&quot;num_key_value_heads&quot;</code>: The number of key value heads that should be used to implement Grouped Query Attention (GQA). If <code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if <code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA), otherwise GQA is used.</li> <li><code>&quot;hidden_size&quot;</code>: The dimension of the hidden representations.</li>",Z;return M=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXdxQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMlRoZUJsb2tlJTJGWWktMzRCLUFXUSUyMiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBBd3FDb25maWcoJTBBJTIwJTIwJTIwJTIwYml0cyUzRDQlMkMlMEElMjAlMjAlMjAlMjBmdXNlX21heF9zZXFfbGVuJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19mdXNlJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXR0ZW50aW9uJTIyJTNBJTIwJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGF5ZXJub3JtJTIyJTNBJTIwJTVCJTIybG4xJTIyJTJDJTIwJTIybG4yJTIyJTJDJTIwJTIybm9ybSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1scCUyMiUzQSUyMCU1QiUyMmdhdGVfcHJvaiUyMiUyQyUyMCUyMnVwX3Byb2olMjIlMkMlMjAlMjJkb3duX3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfYWxpYmklMjIlM0ElMjBGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV9hdHRlbnRpb25faGVhZHMlMjIlM0ElMjA1NiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV9rZXlfdmFsdWVfaGVhZHMlMjIlM0ElMjA4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGlkZGVuX3NpemUlMjIlM0ElMjA3MTY4JTBBJTIwJTIwJTIwJTIwJTdEJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpLnRvKDAp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AwqConfig, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;TheBloke/Yi-34B-AWQ&quot;</span>

quantization_config = AwqConfig(
    bits=<span class="hljs-number">4</span>,
    fuse_max_seq_len=<span class="hljs-number">512</span>,
    modules_to_fuse={
        <span class="hljs-string">&quot;attention&quot;</span>: [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
        <span class="hljs-string">&quot;layernorm&quot;</span>: [<span class="hljs-string">&quot;ln1&quot;</span>, <span class="hljs-string">&quot;ln2&quot;</span>, <span class="hljs-string">&quot;norm&quot;</span>],
        <span class="hljs-string">&quot;mlp&quot;</span>: [<span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>],
        <span class="hljs-string">&quot;use_alibi&quot;</span>: <span class="hljs-literal">False</span>,
        <span class="hljs-string">&quot;num_attention_heads&quot;</span>: <span class="hljs-number">56</span>,
        <span class="hljs-string">&quot;num_key_value_heads&quot;</span>: <span class="hljs-number">8</span>,
        <span class="hljs-string">&quot;hidden_size&quot;</span>: <span class="hljs-number">7168</span>
    }
)

model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config).to(<span class="hljs-number">0</span>)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=s(),u(M.$$.fragment),r=s(),T=p("p"),T.innerHTML=v,C=s(),w=p("ul"),w.innerHTML=q},l(j){n=m(j,"P",{"data-svelte-h":!0}),d(n)!=="svelte-ecilwg"&&(n.innerHTML=y),o=i(j),f(M.$$.fragment,j),r=i(j),T=m(j,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1divolh"&&(T.innerHTML=v),C=i(j),w=m(j,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-ln3msn"&&(w.innerHTML=q)},m(j,k){a(j,n,k),a(j,o,k),h(M,j,k),a(j,r,k),a(j,T,k),a(j,C,k),a(j,w,k),Z=!0},p:Q,i(j){Z||(c(M.$$.fragment,j),Z=!0)},o(j){g(M.$$.fragment,j),Z=!1},d(j){j&&(l(n),l(o),l(r),l(T),l(C),l(w)),b(M,j)}}}function Xs(U){let n,y,o,M;return n=new Ye({props:{id:"fuse",option:"supported architectures",$$slots:{default:[Vs]},$$scope:{ctx:U}}}),o=new Ye({props:{id:"fuse",option:"unsupported architectures",$$slots:{default:[Fs]},$$scope:{ctx:U}}}),{c(){u(n.$$.fragment),y=s(),u(o.$$.fragment)},l(r){f(n.$$.fragment,r),y=i(r),f(o.$$.fragment,r)},m(r,T){h(n,r,T),a(r,y,T),h(o,r,T),M=!0},p(r,T){const v={};T&2&&(v.$$scope={dirty:T,ctx:r}),n.$set(v);const C={};T&2&&(C.$$scope={dirty:T,ctx:r}),o.$set(C)},i(r){M||(c(n.$$.fragment,r),c(o.$$.fragment,r),M=!0)},o(r){g(n.$$.fragment,r),g(o.$$.fragment,r),M=!1},d(r){r&&l(y),b(n,r),b(o,r)}}}function Rs(U){let n,y="Note this feature is supported on AMD GPUs.";return{c(){n=p("p"),n.textContent=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-147si7w"&&(n.textContent=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function xs(U){let n,y='Try GPTQ quantization with PEFT in this <a href="https://colab.research.google.com/drive/1_TIrmuKOFhuRRiTWN94iLKUFu6ZX4ceb?usp=sharing" rel="nofollow">notebook</a> and learn more about it’s details in this <a href="https://huggingface.co/blog/gptq-integration" rel="nofollow">blog post</a>!';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1tfpiad"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Ls(U){let n,y='Depending on your hardware, it can take some time to quantize a model from scratch. It can take ~5 minutes to quantize the <a href="https://huggingface.co/facebook/opt-350m" rel="nofollow">facebook/opt-350m</a> model on a free-tier Google Colab GPU, but it’ll take ~4 hours to quantize a 175B parameter model on a NVIDIA A100. Before you quantize a model, it is a good idea to check the Hub if a GPTQ-quantized version of the model already exists.';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-jdzahk"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Ns(U){let n,y="Only 4-bit models are supported, and we recommend deactivating the ExLlama kernels if you’re finetuning a quantized model with PEFT.";return{c(){n=p("p"),n.textContent=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-14ppi1y"&&(n.textContent=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function As(U){let n,y;return n=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlM0UwLjM3LjA=",highlighted:"pip install transformers accelerate bitsandbytes&gt;0.37.0",wrap:!1}}),{c(){u(n.$$.fragment)},l(o){f(n.$$.fragment,o)},m(o,M){h(n,o,M),y=!0},p:Q,i(o){y||(c(n.$$.fragment,o),y=!0)},o(o){g(n.$$.fragment,o),y=!1},d(o){b(n,o)}}}function Hs(U){let n,y;return n=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUwQXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjBhY2NlbGVyYXRlJTBBcGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRyYW5zZm9ybWVycw==",highlighted:`pip install bitsandbytes&gt;=0.39.0
pip install --upgrade accelerate
pip install --upgrade transformers`,wrap:!1}}),{c(){u(n.$$.fragment)},l(o){f(n.$$.fragment,o)},m(o,M){h(n,o,M),y=!0},p:Q,i(o){y||(c(n.$$.fragment,o),y=!0)},o(o){g(n.$$.fragment,o),y=!1},d(o){b(n,o)}}}function Es(U){let n,y,o,M;return n=new Ye({props:{id:"bnb",option:"8-bit",$$slots:{default:[As]},$$scope:{ctx:U}}}),o=new Ye({props:{id:"bnb",option:"4-bit",$$slots:{default:[Hs]},$$scope:{ctx:U}}}),{c(){u(n.$$.fragment),y=s(),u(o.$$.fragment)},l(r){f(n.$$.fragment,r),y=i(r),f(o.$$.fragment,r)},m(r,T){h(n,r,T),a(r,y,T),h(o,r,T),M=!0},p(r,T){const v={};T&2&&(v.$$scope={dirty:T,ctx:r}),n.$set(v);const C={};T&2&&(C.$$scope={dirty:T,ctx:r}),o.$set(C)},i(r){M||(c(n.$$.fragment,r),c(o.$$.fragment,r),M=!0)},o(r){g(n.$$.fragment,r),g(o.$$.fragment,r),M=!1},d(r){r&&l(y),b(n,r),b(o,r)}}}function Ys(U){let n,y="Quantizing a model in 8-bit halves the memory-usage, and for large models, set <code>device_map=&quot;auto&quot;</code> to efficiently use the GPUs available:",o,M,r,T,v="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter if you want:",C,w,q,Z,j='Once a model is quantized to 8-bit, you can’t push the quantized weights to the Hub unless you’re using the latest version of Transformers and bitsandbytes. If you have the latest versions, then you can push the 8-bit model to the Hub with the <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization config.json file is pushed first, followed by the quantized model weights.',k,$,G;return M=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_8bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),w=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyKSUwQW1vZGVsXzhiaXQubW9kZWwuZGVjb2Rlci5sYXllcnMlNUItMSU1RC5maW5hbF9sYXllcl9ub3JtLndlaWdodC5kdHlwZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_8bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, torch_dtype=torch.float32)
model_8bit.model.decoder.layers[-<span class="hljs-number">1</span>].final_layer_norm.weight.dtype`,wrap:!1}}),$=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbS01NjBtJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbS01NjBtJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMmJsb29tLTU2MG0tOGJpdCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>)

model.push_to_hub(<span class="hljs-string">&quot;bloom-560m-8bit&quot;</span>)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=s(),u(M.$$.fragment),r=s(),T=p("p"),T.innerHTML=v,C=s(),u(w.$$.fragment),q=s(),Z=p("p"),Z.innerHTML=j,k=s(),u($.$$.fragment)},l(J){n=m(J,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1dz8xeq"&&(n.innerHTML=y),o=i(J),f(M.$$.fragment,J),r=i(J),T=m(J,"P",{"data-svelte-h":!0}),d(T)!=="svelte-kfzkum"&&(T.innerHTML=v),C=i(J),f(w.$$.fragment,J),q=i(J),Z=m(J,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-951rn"&&(Z.innerHTML=j),k=i(J),f($.$$.fragment,J)},m(J,z){a(J,n,z),a(J,o,z),h(M,J,z),a(J,r,z),a(J,T,z),a(J,C,z),h(w,J,z),a(J,q,z),a(J,Z,z),a(J,k,z),h($,J,z),G=!0},p:Q,i(J){G||(c(M.$$.fragment,J),c(w.$$.fragment,J),c($.$$.fragment,J),G=!0)},o(J){g(M.$$.fragment,J),g(w.$$.fragment,J),g($.$$.fragment,J),G=!1},d(J){J&&(l(n),l(o),l(r),l(T),l(C),l(q),l(Z),l(k)),b(M,J),b(w,J),b($,J)}}}function Ps(U){let n,y="Quantizing a model in 4-bit reduces your memory-usage by 4x, and for large models, set <code>device_map=&quot;auto&quot;</code> to efficiently use the GPUs available:",o,M,r,T,v="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter if you want:",C,w,q,Z,j="If you have <code>bitsandbytes&gt;=0.41.3</code>, you can serialize 4-bit models and push them on Hugging Face Hub. Simply call <code>model.push_to_hub()</code> after loading it in 4-bit precision. You can also save the serialized 4-bit models locally with <code>model.save_pretrained()</code> command.",k;return M=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_4bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),w=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF80Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyKSUwQW1vZGVsXzRiaXQubW9kZWwuZGVjb2Rlci5sYXllcnMlNUItMSU1RC5maW5hbF9sYXllcl9ub3JtLndlaWdodC5kdHlwZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_4bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>, torch_dtype=torch.float32)
model_4bit.model.decoder.layers[-<span class="hljs-number">1</span>].final_layer_norm.weight.dtype`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=s(),u(M.$$.fragment),r=s(),T=p("p"),T.innerHTML=v,C=s(),u(w.$$.fragment),q=s(),Z=p("p"),Z.innerHTML=j},l($){n=m($,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1b6jp1p"&&(n.innerHTML=y),o=i($),f(M.$$.fragment,$),r=i($),T=m($,"P",{"data-svelte-h":!0}),d(T)!=="svelte-kfzkum"&&(T.innerHTML=v),C=i($),f(w.$$.fragment,$),q=i($),Z=m($,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1pmx2wb"&&(Z.innerHTML=j)},m($,G){a($,n,G),a($,o,G),h(M,$,G),a($,r,G),a($,T,G),a($,C,G),h(w,$,G),a($,q,G),a($,Z,G),k=!0},p:Q,i($){k||(c(M.$$.fragment,$),c(w.$$.fragment,$),k=!0)},o($){g(M.$$.fragment,$),g(w.$$.fragment,$),k=!1},d($){$&&(l(n),l(o),l(r),l(T),l(C),l(q),l(Z)),b(M,$),b(w,$)}}}function Ss(U){let n,y,o,M;return n=new Ye({props:{id:"bnb",option:"8-bit",$$slots:{default:[Ys]},$$scope:{ctx:U}}}),o=new Ye({props:{id:"bnb",option:"4-bit",$$slots:{default:[Ps]},$$scope:{ctx:U}}}),{c(){u(n.$$.fragment),y=s(),u(o.$$.fragment)},l(r){f(n.$$.fragment,r),y=i(r),f(o.$$.fragment,r)},m(r,T){h(n,r,T),a(r,y,T),h(o,r,T),M=!0},p(r,T){const v={};T&2&&(v.$$scope={dirty:T,ctx:r}),n.$set(v);const C={};T&2&&(C.$$scope={dirty:T,ctx:r}),o.$set(C)},i(r){M||(c(n.$$.fragment,r),c(o.$$.fragment,r),M=!0)},o(r){g(n.$$.fragment,r),g(o.$$.fragment,r),M=!1},d(r){r&&l(y),b(n,r),b(o,r)}}}function Ds(U){let n,y="Training with 8-bit and 4-bit weights are only supported for training <em>extra</em> parameters.";return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-of9sym"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Ks(U){let n,y='Learn more about the details of 8-bit quantization in this <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blog post</a>!';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1bb05fp"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Os(U){let n,y='Try 4-bit quantization in this <a href="https://colab.research.google.com/drive/1ge2F1QSK8Q7h0hn3YKuBCOAS0bK8E0wf" rel="nofollow">notebook</a> and learn more about it’s details in this <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">blog post</a>.';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-rme94c"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function ti(U){let n,y,o,M,r,T,v,C="Quantization techniques focus on representing data with less information while also trying to not lose too much accuracy. This often means converting a data type to represent the same information with fewer bits. For example, if your model weights are stored as 32-bit floating points and they’re quantized to 16-bit floating points, this halves the model size which makes it easier to store and reduces memory-usage. Lower precision can also speedup inference because it takes less time to perform calculations with fewer bits.",w,q,Z="Transformers supports several quantization schemes to help you run inference with large language models (LLMs) and finetune adapters on quantized models. This guide will show you how to use Activation-aware Weight Quantization (AWQ), AutoGPTQ, and bitsandbytes.",j,k,$,G,J,z,mn='Try AQLM on <a href="https://colab.research.google.com/drive/1-xZmBRXT5Fm3Ghn4Mwa2KRypORXb855X?usp=sharing" rel="nofollow">Google Colab</a>!',Se,tt,dn='Additive Quantization of Language Models (<a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and take advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes.',De,et,un="Inference support for AQLM is realised in the <code>aqlm</code> library. Make sure to install it to run the models (note aqlm works only with python&gt;=3.10):",Ke,lt,Oe,at,fn="The library provides efficient kernels for both GPU and CPU inference and training.",tl,nt,hn='The instructions on how to quantize models yourself, as well as all the relevant code can be found in the corresponding GitHub <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',el,st,ll,it,cn='Starting with version <code>aqlm 1.0.2</code>, AQLM supports Parameter-Efficient Fine-Tuning in a form of <a href="https://huggingface.co/docs/peft/package_reference/lora" rel="nofollow">LoRA</a> integrated into the <a href="https://huggingface.co/blog/peft" rel="nofollow">PEFT</a> library.',al,ot,nl,rt,gn="AQLM quantization setpus vary mainly on the number of codebooks used as well as codebook sizes in bits. The most popular setups, as well as inference kernels they support are:",sl,pt,bn="<thead><tr><th>Kernel</th> <th>Number of codebooks</th> <th>Codebook size, bits</th> <th>Notation</th> <th>Accuracy</th> <th>Speedup</th> <th>Fast GPU inference</th> <th>Fast CPU inference</th></tr></thead> <tbody><tr><td>Triton</td> <td>K</td> <td>N</td> <td>KxN</td> <td>-</td> <td>Up to ~0.7x</td> <td>✅</td> <td>❌</td></tr> <tr><td>CUDA</td> <td>1</td> <td>16</td> <td>1x16</td> <td>Best</td> <td>Up to ~1.3x</td> <td>✅</td> <td>❌</td></tr> <tr><td>CUDA</td> <td>2</td> <td>8</td> <td>2x8</td> <td>OK</td> <td>Up to ~3.0x</td> <td>✅</td> <td>❌</td></tr> <tr><td>Numba</td> <td>K</td> <td>8</td> <td>Kx8</td> <td>Good</td> <td>Up to ~4.0x</td> <td>❌</td> <td>✅</td></tr></tbody>",il,mt,ol,W,rl,dt,Mn='<a href="https://hf.co/papers/2306.00978" rel="nofollow">Activation-aware Weight Quantization (AWQ)</a> doesn’t quantize all the weights in a model, and instead, it preserves a small percentage of weights that are important for LLM performance. This significantly reduces quantization loss such that you can run models in 4-bit precision without experiencing any performance degradation.',pl,ut,yn='There are several libraries for quantizing models with the AWQ algorithm, such as <a href="https://github.com/mit-han-lab/llm-awq" rel="nofollow">llm-awq</a>, <a href="https://github.com/casper-hansen/AutoAWQ" rel="nofollow">autoawq</a> or <a href="https://huggingface.co/docs/optimum/main/en/intel/optimization_inc" rel="nofollow">optimum-intel</a>. Transformers supports loading models quantized with the llm-awq and autoawq libraries. This guide will show you how to load models quantized with autoawq, but the process is similar for llm-awq quantized models.',ml,ft,Tn="Make sure you have autoawq installed:",dl,ht,ul,ct,wn='AWQ-quantized models can be identified by checking the <code>quantization_config</code> attribute in the model’s <a href="https://huggingface.co/TheBloke/zephyr-7B-alpha-AWQ/blob/main/config.json" rel="nofollow">config.json</a> file:',fl,gt,hl,bt,$n='A quantized model is loaded with the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method. If you loaded your model on the CPU, make sure to move it to a GPU device first. Use the <code>device_map</code> parameter to specify where to place the model:',cl,Mt,gl,yt,Jn="Loading an AWQ-quantized model automatically sets other weights to fp16 by default for performance reasons. If you want to load these other weights in a different format, use the <code>torch_dtype</code> parameter:",bl,Tt,Ml,wt,Un='AWQ quantization can also be combined with <a href="perf_infer_gpu_one#flashattention-2">FlashAttention-2</a> to further accelerate inference:',yl,$t,Tl,Jt,wl,Ut,_n='Fused modules offers improved accuracy and performance and it is supported out-of-the-box for AWQ modules for <a href="https://huggingface.co/meta-llama" rel="nofollow">Llama</a> and <a href="https://huggingface.co/mistralai/Mistral-7B-v0.1" rel="nofollow">Mistral</a> architectures, but you can also fuse AWQ modules for unsupported architectures.',$l,V,Jl,F,Ul,_t,_l,vt,vn="Recent versions of <code>autoawq</code> supports exllama-v2 kernels for faster prefill and decoding. To get started, first install the latest version of <code>autoawq</code> by running:",vl,jt,jl,Ct,jn="Get started by passing an <code>AwqConfig()</code> with <code>version=&quot;exllama&quot;</code>.",Cl,qt,ql,X,kl,kt,Zl,R,Gl,Zt,Cn='The <a href="https://github.com/PanQiWei/AutoGPTQ" rel="nofollow">AutoGPTQ</a> library implements the GPTQ algorithm, a post-training quantization technique where each row of the weight matrix is quantized independently to find a version of the weights that minimizes the error. These weights are quantized to int4, but they’re restored to fp16 on the fly during inference. This can save your memory-usage by 4x because the int4 weights are dequantized in a fused kernel rather than a GPU’s global memory, and you can also expect a speedup in inference because using a lower bitwidth takes less time to communicate.',Il,Gt,qn="Before you begin, make sure the following libraries are installed:",zl,It,Ql,zt,kn='To quantize a model (currently only supported for text models), you need to create a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.GPTQConfig">GPTQConfig</a> class and set the number of bits to quantize to, a dataset to calibrate the weights for quantization, and a tokenizer to prepare the dataset.',Bl,Qt,Wl,Bt,Zn="You could also pass your own dataset as a list of strings, but it is highly recommended to use the same dataset from the GPTQ paper.",Vl,Wt,Fl,Vt,Gn='Load a model to quantize and pass the <code>gptq_config</code> to the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> method. Set <code>device_map=&quot;auto&quot;</code> to automatically offload the model to a CPU to help fit the model in memory, and allow the model modules to be moved between the CPU and GPU for quantization.',Xl,Ft,Rl,Xt,In="If you’re running out of memory because a dataset is too large, disk offloading is not supported. If this is the case, try passing the <code>max_memory</code> parameter to allocate the amount of memory to use on your device (GPU and CPU):",xl,Rt,Ll,x,Nl,xt,zn='Once your model is quantized, you can push the model and tokenizer to the Hub where it can be easily shared and accessed. Use the <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method to save the <a href="/docs/transformers/main/en/main_classes/quantization#transformers.GPTQConfig">GPTQConfig</a>:',Al,Lt,Hl,Nt,Qn='You could also save your quantized model locally with the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> method. If the model was quantized with the <code>device_map</code> parameter, make sure to move the entire model to a GPU or CPU before saving it. For example, to save the model on a CPU:',El,At,Yl,Ht,Bn='Reload a quantized model with the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method, and set <code>device_map=&quot;auto&quot;</code> to automatically distribute the model on all available GPUs to load the model faster without using more memory than needed.',Pl,Et,Sl,Yt,Dl,Pt,Wn='<a href="https://github.com/turboderp/exllama" rel="nofollow">ExLlama</a> is a Python/C++/CUDA implementation of the <a href="model_doc/llama">Llama</a> model that is designed for faster inference with 4-bit GPTQ weights (check out these <a href="https://github.com/huggingface/optimum/tree/main/tests/benchmark#gptq-benchmark" rel="nofollow">benchmarks</a>). The ExLlama kernel is activated by default when you create a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.GPTQConfig">GPTQConfig</a> object. To boost inference speed even further, use the <a href="https://github.com/turboderp/exllamav2" rel="nofollow">ExLlamaV2</a> kernels by configuring the <code>exllama_config</code> parameter:',Kl,St,Ol,L,ta,Dt,Vn="The ExLlama kernels are only supported when the entire model is on the GPU. If you’re doing inference on a CPU with AutoGPTQ (version > 0.4.2), then you’ll need to disable the ExLlama kernel. This overwrites the attributes related to the ExLlama kernels in the quantization config of the config.json file.",ea,Kt,la,Ot,aa,te,Fn='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is the easiest option for quantizing a model to 8 and 4-bit. 8-bit quantization multiplies outliers in fp16 with non-outliers in int8, converts the non-outlier values back to fp16, and then adds them together to return the weights in fp16. This reduces the degradative effect outlier values have on a model’s performance. 4-bit quantization compresses a model even further, and it is commonly used with <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> to finetune quantized LLMs.',na,ee,Xn="To use bitsandbytes, make sure you have the following libraries installed:",sa,N,ia,le,Rn='Now you can quantize a model with the <code>load_in_8bit</code> or <code>load_in_4bit</code> parameters in the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method. This works for any model in any modality, as long as it supports loading with Accelerate and contains <code>torch.nn.Linear</code> layers.',oa,A,ra,H,pa,ae,xn="You can check your memory footprint with the <code>get_memory_footprint</code> method:",ma,ne,da,se,Ln='Quantized models can be loaded from the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method without needing to specify the <code>load_in_8bit</code> or <code>load_in_4bit</code> parameters:',ua,ie,fa,oe,ha,E,ca,re,Nn="This section explores some of the specific features of 8-bit models, such as offloading, outlier thresholds, skipping module conversion, and finetuning.",ga,pe,ba,me,An='8-bit models can offload weights between the CPU and GPU to support fitting very large models into memory. The weights dispatched to the CPU are actually stored in <strong>float32</strong>, and aren’t converted to 8-bit. For example, to enable offloading for the <a href="https://huggingface.co/bigscience/bloom-1b7" rel="nofollow">bigscience/bloom-1b7</a> model, start by creating a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ma,de,ya,ue,Hn="Design a custom device map to fit everything on your GPU except for the <code>lm_head</code>, which you’ll dispatch to the CPU:",Ta,fe,wa,he,En="Now load your model with the custom <code>device_map</code> and <code>quantization_config</code>:",$a,ce,Ja,ge,Ua,be,Yn="An “outlier” is a hidden state value greater than a certain threshold, and these values are computed in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5, but beyond that, there is a significant performance penalty. A good default threshold value is 6, but a lower threshold may be needed for more unstable models (small models or finetuning).",_a,Me,Pn='To find the best threshold for your model, we recommend experimenting with the <code>llm_int8_threshold</code> parameter in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',va,ye,ja,Te,Ca,we,Sn='For some models, like <a href="model_doc/jukebox">Jukebox</a>, you don’t need to quantize every module to 8-bit which can actually cause instability. With Jukebox, there are several <code>lm_head</code> modules that should be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',qa,$e,ka,Je,Za,Ue,Dn='With the <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> library, you can finetune large models like <a href="https://huggingface.co/google/flan-t5-large" rel="nofollow">flan-t5-large</a> and <a href="https://huggingface.co/facebook/opt-6.7b" rel="nofollow">facebook/opt-6.7b</a> with 8-bit quantization. You don’t need to pass the <code>device_map</code> parameter for training because it’ll automatically load your model on a GPU. However, you can still customize the device map with the <code>device_map</code> parameter if you want to (<code>device_map=&quot;auto&quot;</code> should only be used for inference).',Ga,_e,Ia,Y,za,ve,Kn="This section explores some of the specific features of 4-bit models, such as changing the compute data type, using the Normal Float 4 (NF4) data type, and using nested quantization.",Qa,je,Ba,Ce,On='To speedup computation, you can change the data type from float32 (the default value) to bf16 using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Wa,qe,Va,ke,Fa,Ze,ts='NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for weights initialized from a normal distribution. You should use NF4 for training 4-bit base models. This can be configured with the <code>bnb_4bit_quant_type</code> parameter in the <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Xa,Ge,Ra,Ie,es="For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> values.",xa,ze,La,Qe,ls='Nested quantization is a technique that can save additional memory at no additional performance cost. This feature performs a second quantization of the already quantized weights to save an addition 0.4 bits/parameter. For example, with nested quantization, you can finetune a <a href="https://huggingface.co/meta-llama/Llama-2-13b" rel="nofollow">Llama-13b</a> model on a 16GB NVIDIA T4 GPU with a sequence length of 1024, a batch size of 1, and enabling gradient accumulation with 4 steps.',Na,Be,Aa,We,Ha,Ve,as='The <a href="https://huggingface.co/docs/optimum/index" rel="nofollow">Optimum</a> library supports quantization for Intel, Furiosa, ONNX Runtime, GPTQ, and lower-level PyTorch quantization functions. Consider using Optimum for quantization if you’re using specific and optimized hardware like Intel CPUs, Furiosa NPUs or a model accelerator like ONNX Runtime.',Ea,Fe,Ya,Xe,ns='To compare the speed, throughput, and latency of each quantization scheme, check the following benchmarks obtained from the <a href="https://github.com/huggingface/optimum-benchmark" rel="nofollow">optimum-benchmark</a> library. The benchmark was run on a NVIDIA A1000 for the <a href="https://huggingface.co/TheBloke/Mistral-7B-v0.1-AWQ" rel="nofollow">TheBloke/Mistral-7B-v0.1-AWQ</a> and <a href="https://huggingface.co/TheBloke/Mistral-7B-v0.1-GPTQ" rel="nofollow">TheBloke/Mistral-7B-v0.1-GPTQ</a> models. These were also tested against the bitsandbytes quantization methods as well as a native fp16 model.',Pa,P,ss='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/forward_memory_plot.png" alt="forward peak memory per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">forward peak memory/batch size</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/generate_memory_plot.png" alt="generate peak memory per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generate peak memory/batch size</figcaption></div>',Sa,S,is='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/generate_throughput_plot.png" alt="generate throughput per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generate throughput/batch size</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/forward_latency_plot.png" alt="forward latency per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">forward latency/batch size</figcaption></div>',Da,Re,os='The benchmarks indicate AWQ quantization is the fastest for inference, text generation, and has the lowest peak memory for text generation. However, AWQ has the largest forward latency per batch size. For a more detailed discussion about the pros and cons of each quantization method, read the <a href="https://huggingface.co/blog/overview-quantization-transformers" rel="nofollow">Overview of natively supported quantization schemes in 🤗 Transformers</a> blog post.',Ka,xe,Oa,Le,rs='The <a href="https://huggingface.co/TheBloke/Mistral-7B-OpenOrca-AWQ" rel="nofollow">TheBloke/Mistral-7B-OpenOrca-AWQ</a> model was benchmarked with <code>batch_size=1</code> with and without fused modules.',tn,D,ps="Unfused module",en,Ne,ms='<thead><tr><th align="right">Batch Size</th> <th align="right">Prefill Length</th> <th align="right">Decode Length</th> <th align="right">Prefill tokens/s</th> <th align="right">Decode tokens/s</th> <th align="left">Memory (VRAM)</th></tr></thead> <tbody><tr><td align="right">1</td> <td align="right">32</td> <td align="right">32</td> <td align="right">60.0984</td> <td align="right">38.4537</td> <td align="left">4.50 GB (5.68%)</td></tr> <tr><td align="right">1</td> <td align="right">64</td> <td align="right">64</td> <td align="right">1333.67</td> <td align="right">31.6604</td> <td align="left">4.50 GB (5.68%)</td></tr> <tr><td align="right">1</td> <td align="right">128</td> <td align="right">128</td> <td align="right">2434.06</td> <td align="right">31.6272</td> <td align="left">4.50 GB (5.68%)</td></tr> <tr><td align="right">1</td> <td align="right">256</td> <td align="right">256</td> <td align="right">3072.26</td> <td align="right">38.1731</td> <td align="left">4.50 GB (5.68%)</td></tr> <tr><td align="right">1</td> <td align="right">512</td> <td align="right">512</td> <td align="right">3184.74</td> <td align="right">31.6819</td> <td align="left">4.59 GB (5.80%)</td></tr> <tr><td align="right">1</td> <td align="right">1024</td> <td align="right">1024</td> <td align="right">3148.18</td> <td align="right">36.8031</td> <td align="left">4.81 GB (6.07%)</td></tr> <tr><td align="right">1</td> <td align="right">2048</td> <td align="right">2048</td> <td align="right">2927.33</td> <td align="right">35.2676</td> <td align="left">5.73 GB (7.23%)</td></tr></tbody>',ln,K,ds="Fused module",an,Ae,us='<thead><tr><th align="right">Batch Size</th> <th align="right">Prefill Length</th> <th align="right">Decode Length</th> <th align="right">Prefill tokens/s</th> <th align="right">Decode tokens/s</th> <th align="left">Memory (VRAM)</th></tr></thead> <tbody><tr><td align="right">1</td> <td align="right">32</td> <td align="right">32</td> <td align="right">81.4899</td> <td align="right">80.2569</td> <td align="left">4.00 GB (5.05%)</td></tr> <tr><td align="right">1</td> <td align="right">64</td> <td align="right">64</td> <td align="right">1756.1</td> <td align="right">106.26</td> <td align="left">4.00 GB (5.05%)</td></tr> <tr><td align="right">1</td> <td align="right">128</td> <td align="right">128</td> <td align="right">2479.32</td> <td align="right">105.631</td> <td align="left">4.00 GB (5.06%)</td></tr> <tr><td align="right">1</td> <td align="right">256</td> <td align="right">256</td> <td align="right">1813.6</td> <td align="right">85.7485</td> <td align="left">4.01 GB (5.06%)</td></tr> <tr><td align="right">1</td> <td align="right">512</td> <td align="right">512</td> <td align="right">2848.9</td> <td align="right">97.701</td> <td align="left">4.11 GB (5.19%)</td></tr> <tr><td align="right">1</td> <td align="right">1024</td> <td align="right">1024</td> <td align="right">3044.35</td> <td align="right">87.7323</td> <td align="left">4.41 GB (5.57%)</td></tr> <tr><td align="right">1</td> <td align="right">2048</td> <td align="right">2048</td> <td align="right">2715.11</td> <td align="right">89.4709</td> <td align="left">5.57 GB (7.04%)</td></tr></tbody>',nn,He,fs='The speed and throughput of fused and unfused modules were also tested with the <a href="https://github.com/huggingface/optimum-benchmark" rel="nofollow">optimum-benchmark</a> library.',sn,O,hs='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/fused_forward_memory_plot.png" alt="generate throughput per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">forward peak memory/batch size</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/fused_generate_throughput_plot.png" alt="forward latency per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generate throughput/batch size</figcaption></div>',on,Pe,rn;return r=new I({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),k=new B({props:{$$slots:{default:[Qs]},$$scope:{ctx:U}}}),G=new I({props:{title:"AQLM",local:"aqlm",headingTag:"h2"}}),lt=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFxbG0lNUJncHUlMkNjcHUlNUQ=",highlighted:"pip install aqlm[gpu,cpu]",wrap:!1}}),st=new I({props:{title:"PEFT",local:"peft",headingTag:"h3"}}),ot=new I({props:{title:"AQLM configurations",local:"aqlm-configurations",headingTag:"h3"}}),mt=new I({props:{title:"AWQ",local:"awq",headingTag:"h2"}}),W=new B({props:{$$slots:{default:[Bs]},$$scope:{ctx:U}}}),ht=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMGF1dG9hd3E=",highlighted:"pip install autoawq",wrap:!1}}),gt=new _({props:{code:"JTdCJTBBJTIwJTIwJTIyX25hbWVfb3JfcGF0aCUyMiUzQSUyMCUyMiUyRndvcmtzcGFjZSUyRnByb2Nlc3MlMkZodWdnaW5nZmFjZWg0X3plcGh5ci03Yi1hbHBoYSUyRnNvdXJjZSUyMiUyQyUwQSUyMCUyMCUyMmFyY2hpdGVjdHVyZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJNaXN0cmFsRm9yQ2F1c2FsTE0lMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAuLi4lMEElMjAlMjAuLi4lMEElMjAlMjAuLi4lMEElMjAlMjAlMjJxdWFudGl6YXRpb25fY29uZmlnJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVhbnRfbWV0aG9kJTIyJTNBJTIwJTIyYXdxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyemVyb19wb2ludCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJncm91cF9zaXplJTIyJTNBJTIwMTI4JTJDJTBBJTIwJTIwJTIwJTIwJTIyYml0cyUyMiUzQSUyMDQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2ZXJzaW9uJTIyJTNBJTIwJTIyZ2VtbSUyMiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_name_or_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/workspace/process/huggingfaceh4_zephyr-7b-alpha/source&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;architectures&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;MistralForCausalLM&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  ...
  ...
  ...
  <span class="hljs-attr">&quot;quantization_config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;quant_method&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;awq&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_point&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;bits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gemm&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Mt=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyVGhlQmxva2UlMkZ6ZXBoeXItN0ItYWxwaGEtQVdRJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUzQTAlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;TheBloke/zephyr-7B-alpha-AWQ&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)`,wrap:!1}}),Tt=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyVGhlQmxva2UlMkZ6ZXBoeXItN0ItYWxwaGEtQVdRJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MzIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;TheBloke/zephyr-7B-alpha-AWQ&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.float32)`,wrap:!1}}),$t=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlRoZUJsb2tlJTJGemVwaHlyLTdCLWFscGhhLUFXUSUyMiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTNBMCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;TheBloke/zephyr-7B-alpha-AWQ&quot;</span>, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)`,wrap:!1}}),Jt=new I({props:{title:"Fused modules",local:"fused-modules",headingTag:"h3"}}),V=new B({props:{warning:!0,$$slots:{default:[Ws]},$$scope:{ctx:U}}}),F=new pn({props:{id:"fuse",options:["supported architectures","unsupported architectures"],$$slots:{default:[Xs]},$$scope:{ctx:U}}}),_t=new I({props:{title:"Exllama-v2 support",local:"exllama-v2-support",headingTag:"h3"}}),jt=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmNhc3Blci1oYW5zZW4lMkZBdXRvQVdRLmdpdA==",highlighted:"pip install git+https://github.com/casper-hansen/AutoAWQ.git",wrap:!1}}),qt=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXdxQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEF3cUNvbmZpZyh2ZXJzaW9uJTNEJTIyZXhsbGFtYSUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJUaGVCbG9rZSUyRk1pc3RyYWwtN0ItSW5zdHJ1Y3QtdjAuMS1BV1ElMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKSUwQSUwQWlucHV0X2lkcyUyMCUzRCUyMHRvcmNoLnJhbmRpbnQoMCUyQyUyMDEwMCUyQyUyMCgxJTJDJTIwMTI4KSUyQyUyMGR0eXBlJTNEdG9yY2gubG9uZyUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKSUwQXByaW50KG91dHB1dC5sb2dpdHMpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyVGhlQmxva2UlMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjEtQVdRJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUoJTIySG93JTIwdG8lMjBtYWtlJTIwYSUyMGNha2UlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMG1heF9sZW5ndGglM0Q1MCUyQyUyMHBhZF90b2tlbl9pZCUzRDUwMjU2KSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, AwqConfig

quantization_config = AwqConfig(version=<span class="hljs-string">&quot;exllama&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;TheBloke/Mistral-7B-Instruct-v0.1-AWQ&quot;</span>,
    quantization_config=quantization_config,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

input_ids = torch.randint(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>, (<span class="hljs-number">1</span>, <span class="hljs-number">128</span>), dtype=torch.long, device=<span class="hljs-string">&quot;cuda&quot;</span>)
output = model(input_ids)
<span class="hljs-built_in">print</span>(output.logits)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;TheBloke/Mistral-7B-Instruct-v0.1-AWQ&quot;</span>)
input_ids = tokenizer.encode(<span class="hljs-string">&quot;How to make a cake&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
output = model.generate(input_ids, do_sample=<span class="hljs-literal">True</span>, max_length=<span class="hljs-number">50</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),X=new B({props:{warning:!0,$$slots:{default:[Rs]},$$scope:{ctx:U}}}),kt=new I({props:{title:"AutoGPTQ",local:"autogptq",headingTag:"h2"}}),R=new B({props:{$$slots:{default:[xs]},$$scope:{ctx:U}}}),It=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMGF1dG8tZ3B0cSUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0uZ2l0JTBBcGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdCUwQXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjBhY2NlbGVyYXRl",highlighted:`pip install auto-gptq
pip install git+https://github.com/huggingface/optimum.git
pip install git+https://github.com/huggingface/transformers.git
pip install --upgrade accelerate`,wrap:!1}}),Qt=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEdQVFFDb25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFncHRxX2NvbmZpZyUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBkYXRhc2V0JTNEJTIyYzQlMjIlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, GPTQConfig

model_id = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, dataset=<span class="hljs-string">&quot;c4&quot;</span>, tokenizer=tokenizer)`,wrap:!1}}),Wt=new _({props:{code:"ZGF0YXNldCUyMCUzRCUyMCU1QiUyMmF1dG8tZ3B0cSUyMGlzJTIwYW4lMjBlYXN5LXRvLXVzZSUyMG1vZGVsJTIwcXVhbnRpemF0aW9uJTIwbGlicmFyeSUyMHdpdGglMjB1c2VyLWZyaWVuZGx5JTIwYXBpcyUyQyUyMGJhc2VkJTIwb24lMjBHUFRRJTIwYWxnb3JpdGhtLiUyMiU1RCUwQWdwdHFfY29uZmlnJTIwJTNEJTIwR1BUUUNvbmZpZyhiaXRzJTNENCUyQyUyMGRhdGFzZXQlM0RkYXRhc2V0JTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`dataset = [<span class="hljs-string">&quot;auto-gptq is an easy-to-use model quantization library with user-friendly apis, based on GPTQ algorithm.&quot;</span>]
gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, dataset=dataset, tokenizer=tokenizer)`,wrap:!1}}),Ft=new _({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEZ3B0cV9jb25maWcp",highlighted:'quantized_model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)',wrap:!1}}),Rt=new _({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBtYXhfbWVtb3J5JTNEJTdCMCUzQSUyMCUyMjMwR2lCJTIyJTJDJTIwMSUzQSUyMCUyMjQ2R2lCJTIyJTJDJTIwJTIyY3B1JTIyJTNBJTIwJTIyMzBHaUIlMjIlN0QlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEZ3B0cV9jb25maWcp",highlighted:'quantized_model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;30GiB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;46GiB&quot;</span>, <span class="hljs-string">&quot;cpu&quot;</span>: <span class="hljs-string">&quot;30GiB&quot;</span>}, quantization_config=gptq_config)',wrap:!1}}),x=new B({props:{warning:!0,$$slots:{default:[Ls]},$$scope:{ctx:U}}}),Lt=new _({props:{code:"cXVhbnRpemVkX21vZGVsLnB1c2hfdG9faHViKCUyMm9wdC0xMjVtLWdwdHElMjIpJTBBdG9rZW5pemVyLnB1c2hfdG9faHViKCUyMm9wdC0xMjVtLWdwdHElMjIp",highlighted:`quantized_model.push_to_hub(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)
tokenizer.push_to_hub(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)`,wrap:!1}}),At=new _({props:{code:"cXVhbnRpemVkX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJvcHQtMTI1bS1ncHRxJTIyKSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyb3B0LTEyNW0tZ3B0cSUyMiklMEElMEElMjMlMjBpZiUyMHF1YW50aXplZCUyMHdpdGglMjBkZXZpY2VfbWFwJTIwc2V0JTBBcXVhbnRpemVkX21vZGVsLnRvKCUyMmNwdSUyMiklMEFxdWFudGl6ZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm9wdC0xMjVtLWdwdHElMjIp",highlighted:`quantized_model.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)

<span class="hljs-comment"># if quantized with device_map set</span>
quantized_model.to(<span class="hljs-string">&quot;cpu&quot;</span>)
quantized_model.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)`,wrap:!1}}),Et=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRm9wdC0xMjVtLWdwdHElMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Yt=new I({props:{title:"ExLlama",local:"exllama",headingTag:"h3"}}),St=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBHUFRRQ29uZmlnJTBBJTBBZ3B0cV9jb25maWclMjAlM0QlMjBHUFRRQ29uZmlnKGJpdHMlM0Q0JTJDJTIwZXhsbGFtYV9jb25maWclM0QlN0IlMjJ2ZXJzaW9uJTIyJTNBMiU3RCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGb3B0LTEyNW0tZ3B0cSUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGdwdHFfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, GPTQConfig

gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, exllama_config={<span class="hljs-string">&quot;version&quot;</span>:<span class="hljs-number">2</span>})
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)`,wrap:!1}}),L=new B({props:{warning:!0,$$slots:{default:[Ns]},$$scope:{ctx:U}}}),Kt=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBHUFRRQ29uZmlnJTBBZ3B0cV9jb25maWclMjAlM0QlMjBHUFRRQ29uZmlnKGJpdHMlM0Q0JTJDJTIwdXNlX2V4bGxhbWElM0RGYWxzZSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGb3B0LTEyNW0tZ3B0cSUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJjcHUlMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEZ3B0cV9jb25maWcp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, GPTQConfig
gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, use_exllama=<span class="hljs-literal">False</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>, device_map=<span class="hljs-string">&quot;cpu&quot;</span>, quantization_config=gptq_config)`,wrap:!1}}),Ot=new I({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h2"}}),N=new pn({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[Es]},$$scope:{ctx:U}}}),A=new pn({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[Ss]},$$scope:{ctx:U}}}),H=new B({props:{warning:!0,$$slots:{default:[Ds]},$$scope:{ctx:U}}}),ne=new _({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),ie=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZibG9vbS01NjBtLThiaXQlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/bloom-560m-8bit&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),oe=new I({props:{title:"8-bit",local:"8-bit",headingTag:"h3"}}),E=new B({props:{$$slots:{default:[Ks]},$$scope:{ctx:U}}}),pe=new I({props:{title:"Offloading",local:"offloading",headingTag:"h4"}}),de=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsbG1faW50OF9lbmFibGVfZnAzMl9jcHVfb2ZmbG9hZCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(llm_int8_enable_fp32_cpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),fe=new _({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLndvcmRfZW1iZWRkaW5ncyUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci53b3JkX2VtYmVkZGluZ3NfbGF5ZXJub3JtJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxtX2hlYWQlMjIlM0ElMjAlMjJjcHUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5oJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLmxuX2YlMjIlM0ElMjAwJTJDJTBBJTdE",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.word_embeddings&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.word_embeddings_layernorm&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;lm_head&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.h&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.ln_f&quot;</span>: <span class="hljs-number">0</span>,
}`,wrap:!1}}),ce=new _({props:{code:"bW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),ge=new I({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h4"}}),ye=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsbG1faW50OF90aHJlc2hvbGQlM0QxMCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),Te=new I({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h4"}}),$e=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbGxtX2ludDhfc2tpcF9tb2R1bGVzJTNEJTVCJTIybG1faGVhZCUyMiU1RCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_skip_modules=[<span class="hljs-string">&quot;lm_head&quot;</span>],
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),Je=new I({props:{title:"Finetuning",local:"finetuning",headingTag:"h4"}}),_e=new I({props:{title:"4-bit",local:"4-bit",headingTag:"h3"}}),Y=new B({props:{$$slots:{default:[Os]},$$scope:{ctx:U}}}),je=new I({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h4"}}),qe=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),ke=new I({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h4"}}),Ge=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW5mNF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBbW9kZWxfbmY0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRG5mNF9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

nf4_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

model_nf4 = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=nf4_config)`,wrap:!1}}),ze=new I({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h4"}}),Be=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQWRvdWJsZV9xdWFudF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsX2RvdWJsZV9xdWFudCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi0xM2IlMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEZG91YmxlX3F1YW50X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

double_quant_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

model_double_quant = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-13b&quot;</span>, quantization_config=double_quant_config)`,wrap:!1}}),We=new I({props:{title:"Optimum",local:"optimum",headingTag:"h2"}}),Fe=new I({props:{title:"Benchmarks",local:"benchmarks",headingTag:"h2"}}),xe=new I({props:{title:"Fused AWQ modules",local:"fused-awq-modules",headingTag:"h3"}}),{c(){n=p("meta"),y=s(),o=p("p"),M=s(),u(r.$$.fragment),T=s(),v=p("p"),v.textContent=C,w=s(),q=p("p"),q.textContent=Z,j=s(),u(k.$$.fragment),$=s(),u(G.$$.fragment),J=s(),z=p("p"),z.innerHTML=mn,Se=s(),tt=p("p"),tt.innerHTML=dn,De=s(),et=p("p"),et.innerHTML=un,Ke=s(),u(lt.$$.fragment),Oe=s(),at=p("p"),at.textContent=fn,tl=s(),nt=p("p"),nt.innerHTML=hn,el=s(),u(st.$$.fragment),ll=s(),it=p("p"),it.innerHTML=cn,al=s(),u(ot.$$.fragment),nl=s(),rt=p("p"),rt.textContent=gn,sl=s(),pt=p("table"),pt.innerHTML=bn,il=s(),u(mt.$$.fragment),ol=s(),u(W.$$.fragment),rl=s(),dt=p("p"),dt.innerHTML=Mn,pl=s(),ut=p("p"),ut.innerHTML=yn,ml=s(),ft=p("p"),ft.textContent=Tn,dl=s(),u(ht.$$.fragment),ul=s(),ct=p("p"),ct.innerHTML=wn,fl=s(),u(gt.$$.fragment),hl=s(),bt=p("p"),bt.innerHTML=$n,cl=s(),u(Mt.$$.fragment),gl=s(),yt=p("p"),yt.innerHTML=Jn,bl=s(),u(Tt.$$.fragment),Ml=s(),wt=p("p"),wt.innerHTML=Un,yl=s(),u($t.$$.fragment),Tl=s(),u(Jt.$$.fragment),wl=s(),Ut=p("p"),Ut.innerHTML=_n,$l=s(),u(V.$$.fragment),Jl=s(),u(F.$$.fragment),Ul=s(),u(_t.$$.fragment),_l=s(),vt=p("p"),vt.innerHTML=vn,vl=s(),u(jt.$$.fragment),jl=s(),Ct=p("p"),Ct.innerHTML=jn,Cl=s(),u(qt.$$.fragment),ql=s(),u(X.$$.fragment),kl=s(),u(kt.$$.fragment),Zl=s(),u(R.$$.fragment),Gl=s(),Zt=p("p"),Zt.innerHTML=Cn,Il=s(),Gt=p("p"),Gt.textContent=qn,zl=s(),u(It.$$.fragment),Ql=s(),zt=p("p"),zt.innerHTML=kn,Bl=s(),u(Qt.$$.fragment),Wl=s(),Bt=p("p"),Bt.textContent=Zn,Vl=s(),u(Wt.$$.fragment),Fl=s(),Vt=p("p"),Vt.innerHTML=Gn,Xl=s(),u(Ft.$$.fragment),Rl=s(),Xt=p("p"),Xt.innerHTML=In,xl=s(),u(Rt.$$.fragment),Ll=s(),u(x.$$.fragment),Nl=s(),xt=p("p"),xt.innerHTML=zn,Al=s(),u(Lt.$$.fragment),Hl=s(),Nt=p("p"),Nt.innerHTML=Qn,El=s(),u(At.$$.fragment),Yl=s(),Ht=p("p"),Ht.innerHTML=Bn,Pl=s(),u(Et.$$.fragment),Sl=s(),u(Yt.$$.fragment),Dl=s(),Pt=p("p"),Pt.innerHTML=Wn,Kl=s(),u(St.$$.fragment),Ol=s(),u(L.$$.fragment),ta=s(),Dt=p("p"),Dt.textContent=Vn,ea=s(),u(Kt.$$.fragment),la=s(),u(Ot.$$.fragment),aa=s(),te=p("p"),te.innerHTML=Fn,na=s(),ee=p("p"),ee.textContent=Xn,sa=s(),u(N.$$.fragment),ia=s(),le=p("p"),le.innerHTML=Rn,oa=s(),u(A.$$.fragment),ra=s(),u(H.$$.fragment),pa=s(),ae=p("p"),ae.innerHTML=xn,ma=s(),u(ne.$$.fragment),da=s(),se=p("p"),se.innerHTML=Ln,ua=s(),u(ie.$$.fragment),fa=s(),u(oe.$$.fragment),ha=s(),u(E.$$.fragment),ca=s(),re=p("p"),re.textContent=Nn,ga=s(),u(pe.$$.fragment),ba=s(),me=p("p"),me.innerHTML=An,Ma=s(),u(de.$$.fragment),ya=s(),ue=p("p"),ue.innerHTML=Hn,Ta=s(),u(fe.$$.fragment),wa=s(),he=p("p"),he.innerHTML=En,$a=s(),u(ce.$$.fragment),Ja=s(),u(ge.$$.fragment),Ua=s(),be=p("p"),be.textContent=Yn,_a=s(),Me=p("p"),Me.innerHTML=Pn,va=s(),u(ye.$$.fragment),ja=s(),u(Te.$$.fragment),Ca=s(),we=p("p"),we.innerHTML=Sn,qa=s(),u($e.$$.fragment),ka=s(),u(Je.$$.fragment),Za=s(),Ue=p("p"),Ue.innerHTML=Dn,Ga=s(),u(_e.$$.fragment),Ia=s(),u(Y.$$.fragment),za=s(),ve=p("p"),ve.textContent=Kn,Qa=s(),u(je.$$.fragment),Ba=s(),Ce=p("p"),Ce.innerHTML=On,Wa=s(),u(qe.$$.fragment),Va=s(),u(ke.$$.fragment),Fa=s(),Ze=p("p"),Ze.innerHTML=ts,Xa=s(),u(Ge.$$.fragment),Ra=s(),Ie=p("p"),Ie.innerHTML=es,xa=s(),u(ze.$$.fragment),La=s(),Qe=p("p"),Qe.innerHTML=ls,Na=s(),u(Be.$$.fragment),Aa=s(),u(We.$$.fragment),Ha=s(),Ve=p("p"),Ve.innerHTML=as,Ea=s(),u(Fe.$$.fragment),Ya=s(),Xe=p("p"),Xe.innerHTML=ns,Pa=s(),P=p("div"),P.innerHTML=ss,Sa=s(),S=p("div"),S.innerHTML=is,Da=s(),Re=p("p"),Re.innerHTML=os,Ka=s(),u(xe.$$.fragment),Oa=s(),Le=p("p"),Le.innerHTML=rs,tn=s(),D=p("figcaption"),D.textContent=ps,en=s(),Ne=p("table"),Ne.innerHTML=ms,ln=s(),K=p("figcaption"),K.textContent=ds,an=s(),Ae=p("table"),Ae.innerHTML=us,nn=s(),He=p("p"),He.innerHTML=fs,sn=s(),O=p("div"),O.innerHTML=hs,on=s(),Pe=p("p"),this.h()},l(t){const e=Is("svelte-u9bgzb",document.head);n=m(e,"META",{name:!0,content:!0}),e.forEach(l),y=i(t),o=m(t,"P",{}),Cs(o).forEach(l),M=i(t),f(r.$$.fragment,t),T=i(t),v=m(t,"P",{"data-svelte-h":!0}),d(v)!=="svelte-1euzkei"&&(v.textContent=C),w=i(t),q=m(t,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1f5pv07"&&(q.textContent=Z),j=i(t),f(k.$$.fragment,t),$=i(t),f(G.$$.fragment,t),J=i(t),z=m(t,"P",{"data-svelte-h":!0}),d(z)!=="svelte-vu1jh7"&&(z.innerHTML=mn),Se=i(t),tt=m(t,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-11fbd25"&&(tt.innerHTML=dn),De=i(t),et=m(t,"P",{"data-svelte-h":!0}),d(et)!=="svelte-1rdkef8"&&(et.innerHTML=un),Ke=i(t),f(lt.$$.fragment,t),Oe=i(t),at=m(t,"P",{"data-svelte-h":!0}),d(at)!=="svelte-6sf1ac"&&(at.textContent=fn),tl=i(t),nt=m(t,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-mrigan"&&(nt.innerHTML=hn),el=i(t),f(st.$$.fragment,t),ll=i(t),it=m(t,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1uurbap"&&(it.innerHTML=cn),al=i(t),f(ot.$$.fragment,t),nl=i(t),rt=m(t,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-14j9yls"&&(rt.textContent=gn),sl=i(t),pt=m(t,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-mgp7ro"&&(pt.innerHTML=bn),il=i(t),f(mt.$$.fragment,t),ol=i(t),f(W.$$.fragment,t),rl=i(t),dt=m(t,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1c5vyni"&&(dt.innerHTML=Mn),pl=i(t),ut=m(t,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-vomabp"&&(ut.innerHTML=yn),ml=i(t),ft=m(t,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1ozln1k"&&(ft.textContent=Tn),dl=i(t),f(ht.$$.fragment,t),ul=i(t),ct=m(t,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1lxz9t"&&(ct.innerHTML=wn),fl=i(t),f(gt.$$.fragment,t),hl=i(t),bt=m(t,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-108eg93"&&(bt.innerHTML=$n),cl=i(t),f(Mt.$$.fragment,t),gl=i(t),yt=m(t,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-19un5li"&&(yt.innerHTML=Jn),bl=i(t),f(Tt.$$.fragment,t),Ml=i(t),wt=m(t,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-ptrt24"&&(wt.innerHTML=Un),yl=i(t),f($t.$$.fragment,t),Tl=i(t),f(Jt.$$.fragment,t),wl=i(t),Ut=m(t,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-jywid1"&&(Ut.innerHTML=_n),$l=i(t),f(V.$$.fragment,t),Jl=i(t),f(F.$$.fragment,t),Ul=i(t),f(_t.$$.fragment,t),_l=i(t),vt=m(t,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1fw2pai"&&(vt.innerHTML=vn),vl=i(t),f(jt.$$.fragment,t),jl=i(t),Ct=m(t,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-in32kr"&&(Ct.innerHTML=jn),Cl=i(t),f(qt.$$.fragment,t),ql=i(t),f(X.$$.fragment,t),kl=i(t),f(kt.$$.fragment,t),Zl=i(t),f(R.$$.fragment,t),Gl=i(t),Zt=m(t,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-sq0x7n"&&(Zt.innerHTML=Cn),Il=i(t),Gt=m(t,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-13c61n1"&&(Gt.textContent=qn),zl=i(t),f(It.$$.fragment,t),Ql=i(t),zt=m(t,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-ur342m"&&(zt.innerHTML=kn),Bl=i(t),f(Qt.$$.fragment,t),Wl=i(t),Bt=m(t,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-1cjo88z"&&(Bt.textContent=Zn),Vl=i(t),f(Wt.$$.fragment,t),Fl=i(t),Vt=m(t,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-13cn5o4"&&(Vt.innerHTML=Gn),Xl=i(t),f(Ft.$$.fragment,t),Rl=i(t),Xt=m(t,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1tle3a0"&&(Xt.innerHTML=In),xl=i(t),f(Rt.$$.fragment,t),Ll=i(t),f(x.$$.fragment,t),Nl=i(t),xt=m(t,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-jjj96e"&&(xt.innerHTML=zn),Al=i(t),f(Lt.$$.fragment,t),Hl=i(t),Nt=m(t,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-l9o6va"&&(Nt.innerHTML=Qn),El=i(t),f(At.$$.fragment,t),Yl=i(t),Ht=m(t,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-42jvja"&&(Ht.innerHTML=Bn),Pl=i(t),f(Et.$$.fragment,t),Sl=i(t),f(Yt.$$.fragment,t),Dl=i(t),Pt=m(t,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1y1pnbl"&&(Pt.innerHTML=Wn),Kl=i(t),f(St.$$.fragment,t),Ol=i(t),f(L.$$.fragment,t),ta=i(t),Dt=m(t,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-m9nw5y"&&(Dt.textContent=Vn),ea=i(t),f(Kt.$$.fragment,t),la=i(t),f(Ot.$$.fragment,t),aa=i(t),te=m(t,"P",{"data-svelte-h":!0}),d(te)!=="svelte-5a92xi"&&(te.innerHTML=Fn),na=i(t),ee=m(t,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-gf36q7"&&(ee.textContent=Xn),sa=i(t),f(N.$$.fragment,t),ia=i(t),le=m(t,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1tamrid"&&(le.innerHTML=Rn),oa=i(t),f(A.$$.fragment,t),ra=i(t),f(H.$$.fragment,t),pa=i(t),ae=m(t,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1bxp667"&&(ae.innerHTML=xn),ma=i(t),f(ne.$$.fragment,t),da=i(t),se=m(t,"P",{"data-svelte-h":!0}),d(se)!=="svelte-17ps4nd"&&(se.innerHTML=Ln),ua=i(t),f(ie.$$.fragment,t),fa=i(t),f(oe.$$.fragment,t),ha=i(t),f(E.$$.fragment,t),ca=i(t),re=m(t,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1yx1x2g"&&(re.textContent=Nn),ga=i(t),f(pe.$$.fragment,t),ba=i(t),me=m(t,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1v0jh01"&&(me.innerHTML=An),Ma=i(t),f(de.$$.fragment,t),ya=i(t),ue=m(t,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-15oy7am"&&(ue.innerHTML=Hn),Ta=i(t),f(fe.$$.fragment,t),wa=i(t),he=m(t,"P",{"data-svelte-h":!0}),d(he)!=="svelte-k1g8c2"&&(he.innerHTML=En),$a=i(t),f(ce.$$.fragment,t),Ja=i(t),f(ge.$$.fragment,t),Ua=i(t),be=m(t,"P",{"data-svelte-h":!0}),d(be)!=="svelte-ur5rgd"&&(be.textContent=Yn),_a=i(t),Me=m(t,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-v5sezx"&&(Me.innerHTML=Pn),va=i(t),f(ye.$$.fragment,t),ja=i(t),f(Te.$$.fragment,t),Ca=i(t),we=m(t,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1ba1s3u"&&(we.innerHTML=Sn),qa=i(t),f($e.$$.fragment,t),ka=i(t),f(Je.$$.fragment,t),Za=i(t),Ue=m(t,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-4nvx4q"&&(Ue.innerHTML=Dn),Ga=i(t),f(_e.$$.fragment,t),Ia=i(t),f(Y.$$.fragment,t),za=i(t),ve=m(t,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-7ob7j"&&(ve.textContent=Kn),Qa=i(t),f(je.$$.fragment,t),Ba=i(t),Ce=m(t,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-15j4whk"&&(Ce.innerHTML=On),Wa=i(t),f(qe.$$.fragment,t),Va=i(t),f(ke.$$.fragment,t),Fa=i(t),Ze=m(t,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-7qr54g"&&(Ze.innerHTML=ts),Xa=i(t),f(Ge.$$.fragment,t),Ra=i(t),Ie=m(t,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1qoc2ct"&&(Ie.innerHTML=es),xa=i(t),f(ze.$$.fragment,t),La=i(t),Qe=m(t,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-l0u9eq"&&(Qe.innerHTML=ls),Na=i(t),f(Be.$$.fragment,t),Aa=i(t),f(We.$$.fragment,t),Ha=i(t),Ve=m(t,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-opujmz"&&(Ve.innerHTML=as),Ea=i(t),f(Fe.$$.fragment,t),Ya=i(t),Xe=m(t,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-10oh9lm"&&(Xe.innerHTML=ns),Pa=i(t),P=m(t,"DIV",{class:!0,"data-svelte-h":!0}),d(P)!=="svelte-10jjm5l"&&(P.innerHTML=ss),Sa=i(t),S=m(t,"DIV",{class:!0,"data-svelte-h":!0}),d(S)!=="svelte-48at03"&&(S.innerHTML=is),Da=i(t),Re=m(t,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-1sm7gom"&&(Re.innerHTML=os),Ka=i(t),f(xe.$$.fragment,t),Oa=i(t),Le=m(t,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-81zmsw"&&(Le.innerHTML=rs),tn=i(t),D=m(t,"FIGCAPTION",{class:!0,"data-svelte-h":!0}),d(D)!=="svelte-grefv0"&&(D.textContent=ps),en=i(t),Ne=m(t,"TABLE",{"data-svelte-h":!0}),d(Ne)!=="svelte-19aactm"&&(Ne.innerHTML=ms),ln=i(t),K=m(t,"FIGCAPTION",{class:!0,"data-svelte-h":!0}),d(K)!=="svelte-1r15bg7"&&(K.textContent=ds),an=i(t),Ae=m(t,"TABLE",{"data-svelte-h":!0}),d(Ae)!=="svelte-19fczbk"&&(Ae.innerHTML=us),nn=i(t),He=m(t,"P",{"data-svelte-h":!0}),d(He)!=="svelte-gu8e8k"&&(He.innerHTML=fs),sn=i(t),O=m(t,"DIV",{class:!0,"data-svelte-h":!0}),d(O)!=="svelte-1ke50ja"&&(O.innerHTML=hs),on=i(t),Pe=m(t,"P",{}),Cs(Pe).forEach(l),this.h()},h(){Ee(n,"name","hf:doc:metadata"),Ee(n,"content",ei),Ee(P,"class","flex gap-4"),Ee(S,"class","flex gap-4"),Ee(D,"class","text-center text-gray-500 text-lg"),Ee(K,"class","text-center text-gray-500 text-lg"),Ee(O,"class","flex gap-4")},m(t,e){zs(document.head,n),a(t,y,e),a(t,o,e),a(t,M,e),h(r,t,e),a(t,T,e),a(t,v,e),a(t,w,e),a(t,q,e),a(t,j,e),h(k,t,e),a(t,$,e),h(G,t,e),a(t,J,e),a(t,z,e),a(t,Se,e),a(t,tt,e),a(t,De,e),a(t,et,e),a(t,Ke,e),h(lt,t,e),a(t,Oe,e),a(t,at,e),a(t,tl,e),a(t,nt,e),a(t,el,e),h(st,t,e),a(t,ll,e),a(t,it,e),a(t,al,e),h(ot,t,e),a(t,nl,e),a(t,rt,e),a(t,sl,e),a(t,pt,e),a(t,il,e),h(mt,t,e),a(t,ol,e),h(W,t,e),a(t,rl,e),a(t,dt,e),a(t,pl,e),a(t,ut,e),a(t,ml,e),a(t,ft,e),a(t,dl,e),h(ht,t,e),a(t,ul,e),a(t,ct,e),a(t,fl,e),h(gt,t,e),a(t,hl,e),a(t,bt,e),a(t,cl,e),h(Mt,t,e),a(t,gl,e),a(t,yt,e),a(t,bl,e),h(Tt,t,e),a(t,Ml,e),a(t,wt,e),a(t,yl,e),h($t,t,e),a(t,Tl,e),h(Jt,t,e),a(t,wl,e),a(t,Ut,e),a(t,$l,e),h(V,t,e),a(t,Jl,e),h(F,t,e),a(t,Ul,e),h(_t,t,e),a(t,_l,e),a(t,vt,e),a(t,vl,e),h(jt,t,e),a(t,jl,e),a(t,Ct,e),a(t,Cl,e),h(qt,t,e),a(t,ql,e),h(X,t,e),a(t,kl,e),h(kt,t,e),a(t,Zl,e),h(R,t,e),a(t,Gl,e),a(t,Zt,e),a(t,Il,e),a(t,Gt,e),a(t,zl,e),h(It,t,e),a(t,Ql,e),a(t,zt,e),a(t,Bl,e),h(Qt,t,e),a(t,Wl,e),a(t,Bt,e),a(t,Vl,e),h(Wt,t,e),a(t,Fl,e),a(t,Vt,e),a(t,Xl,e),h(Ft,t,e),a(t,Rl,e),a(t,Xt,e),a(t,xl,e),h(Rt,t,e),a(t,Ll,e),h(x,t,e),a(t,Nl,e),a(t,xt,e),a(t,Al,e),h(Lt,t,e),a(t,Hl,e),a(t,Nt,e),a(t,El,e),h(At,t,e),a(t,Yl,e),a(t,Ht,e),a(t,Pl,e),h(Et,t,e),a(t,Sl,e),h(Yt,t,e),a(t,Dl,e),a(t,Pt,e),a(t,Kl,e),h(St,t,e),a(t,Ol,e),h(L,t,e),a(t,ta,e),a(t,Dt,e),a(t,ea,e),h(Kt,t,e),a(t,la,e),h(Ot,t,e),a(t,aa,e),a(t,te,e),a(t,na,e),a(t,ee,e),a(t,sa,e),h(N,t,e),a(t,ia,e),a(t,le,e),a(t,oa,e),h(A,t,e),a(t,ra,e),h(H,t,e),a(t,pa,e),a(t,ae,e),a(t,ma,e),h(ne,t,e),a(t,da,e),a(t,se,e),a(t,ua,e),h(ie,t,e),a(t,fa,e),h(oe,t,e),a(t,ha,e),h(E,t,e),a(t,ca,e),a(t,re,e),a(t,ga,e),h(pe,t,e),a(t,ba,e),a(t,me,e),a(t,Ma,e),h(de,t,e),a(t,ya,e),a(t,ue,e),a(t,Ta,e),h(fe,t,e),a(t,wa,e),a(t,he,e),a(t,$a,e),h(ce,t,e),a(t,Ja,e),h(ge,t,e),a(t,Ua,e),a(t,be,e),a(t,_a,e),a(t,Me,e),a(t,va,e),h(ye,t,e),a(t,ja,e),h(Te,t,e),a(t,Ca,e),a(t,we,e),a(t,qa,e),h($e,t,e),a(t,ka,e),h(Je,t,e),a(t,Za,e),a(t,Ue,e),a(t,Ga,e),h(_e,t,e),a(t,Ia,e),h(Y,t,e),a(t,za,e),a(t,ve,e),a(t,Qa,e),h(je,t,e),a(t,Ba,e),a(t,Ce,e),a(t,Wa,e),h(qe,t,e),a(t,Va,e),h(ke,t,e),a(t,Fa,e),a(t,Ze,e),a(t,Xa,e),h(Ge,t,e),a(t,Ra,e),a(t,Ie,e),a(t,xa,e),h(ze,t,e),a(t,La,e),a(t,Qe,e),a(t,Na,e),h(Be,t,e),a(t,Aa,e),h(We,t,e),a(t,Ha,e),a(t,Ve,e),a(t,Ea,e),h(Fe,t,e),a(t,Ya,e),a(t,Xe,e),a(t,Pa,e),a(t,P,e),a(t,Sa,e),a(t,S,e),a(t,Da,e),a(t,Re,e),a(t,Ka,e),h(xe,t,e),a(t,Oa,e),a(t,Le,e),a(t,tn,e),a(t,D,e),a(t,en,e),a(t,Ne,e),a(t,ln,e),a(t,K,e),a(t,an,e),a(t,Ae,e),a(t,nn,e),a(t,He,e),a(t,sn,e),a(t,O,e),a(t,on,e),a(t,Pe,e),rn=!0},p(t,[e]){const cs={};e&2&&(cs.$$scope={dirty:e,ctx:t}),k.$set(cs);const gs={};e&2&&(gs.$$scope={dirty:e,ctx:t}),W.$set(gs);const bs={};e&2&&(bs.$$scope={dirty:e,ctx:t}),V.$set(bs);const Ms={};e&2&&(Ms.$$scope={dirty:e,ctx:t}),F.$set(Ms);const ys={};e&2&&(ys.$$scope={dirty:e,ctx:t}),X.$set(ys);const Ts={};e&2&&(Ts.$$scope={dirty:e,ctx:t}),R.$set(Ts);const ws={};e&2&&(ws.$$scope={dirty:e,ctx:t}),x.$set(ws);const $s={};e&2&&($s.$$scope={dirty:e,ctx:t}),L.$set($s);const Js={};e&2&&(Js.$$scope={dirty:e,ctx:t}),N.$set(Js);const Us={};e&2&&(Us.$$scope={dirty:e,ctx:t}),A.$set(Us);const _s={};e&2&&(_s.$$scope={dirty:e,ctx:t}),H.$set(_s);const vs={};e&2&&(vs.$$scope={dirty:e,ctx:t}),E.$set(vs);const js={};e&2&&(js.$$scope={dirty:e,ctx:t}),Y.$set(js)},i(t){rn||(c(r.$$.fragment,t),c(k.$$.fragment,t),c(G.$$.fragment,t),c(lt.$$.fragment,t),c(st.$$.fragment,t),c(ot.$$.fragment,t),c(mt.$$.fragment,t),c(W.$$.fragment,t),c(ht.$$.fragment,t),c(gt.$$.fragment,t),c(Mt.$$.fragment,t),c(Tt.$$.fragment,t),c($t.$$.fragment,t),c(Jt.$$.fragment,t),c(V.$$.fragment,t),c(F.$$.fragment,t),c(_t.$$.fragment,t),c(jt.$$.fragment,t),c(qt.$$.fragment,t),c(X.$$.fragment,t),c(kt.$$.fragment,t),c(R.$$.fragment,t),c(It.$$.fragment,t),c(Qt.$$.fragment,t),c(Wt.$$.fragment,t),c(Ft.$$.fragment,t),c(Rt.$$.fragment,t),c(x.$$.fragment,t),c(Lt.$$.fragment,t),c(At.$$.fragment,t),c(Et.$$.fragment,t),c(Yt.$$.fragment,t),c(St.$$.fragment,t),c(L.$$.fragment,t),c(Kt.$$.fragment,t),c(Ot.$$.fragment,t),c(N.$$.fragment,t),c(A.$$.fragment,t),c(H.$$.fragment,t),c(ne.$$.fragment,t),c(ie.$$.fragment,t),c(oe.$$.fragment,t),c(E.$$.fragment,t),c(pe.$$.fragment,t),c(de.$$.fragment,t),c(fe.$$.fragment,t),c(ce.$$.fragment,t),c(ge.$$.fragment,t),c(ye.$$.fragment,t),c(Te.$$.fragment,t),c($e.$$.fragment,t),c(Je.$$.fragment,t),c(_e.$$.fragment,t),c(Y.$$.fragment,t),c(je.$$.fragment,t),c(qe.$$.fragment,t),c(ke.$$.fragment,t),c(Ge.$$.fragment,t),c(ze.$$.fragment,t),c(Be.$$.fragment,t),c(We.$$.fragment,t),c(Fe.$$.fragment,t),c(xe.$$.fragment,t),rn=!0)},o(t){g(r.$$.fragment,t),g(k.$$.fragment,t),g(G.$$.fragment,t),g(lt.$$.fragment,t),g(st.$$.fragment,t),g(ot.$$.fragment,t),g(mt.$$.fragment,t),g(W.$$.fragment,t),g(ht.$$.fragment,t),g(gt.$$.fragment,t),g(Mt.$$.fragment,t),g(Tt.$$.fragment,t),g($t.$$.fragment,t),g(Jt.$$.fragment,t),g(V.$$.fragment,t),g(F.$$.fragment,t),g(_t.$$.fragment,t),g(jt.$$.fragment,t),g(qt.$$.fragment,t),g(X.$$.fragment,t),g(kt.$$.fragment,t),g(R.$$.fragment,t),g(It.$$.fragment,t),g(Qt.$$.fragment,t),g(Wt.$$.fragment,t),g(Ft.$$.fragment,t),g(Rt.$$.fragment,t),g(x.$$.fragment,t),g(Lt.$$.fragment,t),g(At.$$.fragment,t),g(Et.$$.fragment,t),g(Yt.$$.fragment,t),g(St.$$.fragment,t),g(L.$$.fragment,t),g(Kt.$$.fragment,t),g(Ot.$$.fragment,t),g(N.$$.fragment,t),g(A.$$.fragment,t),g(H.$$.fragment,t),g(ne.$$.fragment,t),g(ie.$$.fragment,t),g(oe.$$.fragment,t),g(E.$$.fragment,t),g(pe.$$.fragment,t),g(de.$$.fragment,t),g(fe.$$.fragment,t),g(ce.$$.fragment,t),g(ge.$$.fragment,t),g(ye.$$.fragment,t),g(Te.$$.fragment,t),g($e.$$.fragment,t),g(Je.$$.fragment,t),g(_e.$$.fragment,t),g(Y.$$.fragment,t),g(je.$$.fragment,t),g(qe.$$.fragment,t),g(ke.$$.fragment,t),g(Ge.$$.fragment,t),g(ze.$$.fragment,t),g(Be.$$.fragment,t),g(We.$$.fragment,t),g(Fe.$$.fragment,t),g(xe.$$.fragment,t),rn=!1},d(t){t&&(l(y),l(o),l(M),l(T),l(v),l(w),l(q),l(j),l($),l(J),l(z),l(Se),l(tt),l(De),l(et),l(Ke),l(Oe),l(at),l(tl),l(nt),l(el),l(ll),l(it),l(al),l(nl),l(rt),l(sl),l(pt),l(il),l(ol),l(rl),l(dt),l(pl),l(ut),l(ml),l(ft),l(dl),l(ul),l(ct),l(fl),l(hl),l(bt),l(cl),l(gl),l(yt),l(bl),l(Ml),l(wt),l(yl),l(Tl),l(wl),l(Ut),l($l),l(Jl),l(Ul),l(_l),l(vt),l(vl),l(jl),l(Ct),l(Cl),l(ql),l(kl),l(Zl),l(Gl),l(Zt),l(Il),l(Gt),l(zl),l(Ql),l(zt),l(Bl),l(Wl),l(Bt),l(Vl),l(Fl),l(Vt),l(Xl),l(Rl),l(Xt),l(xl),l(Ll),l(Nl),l(xt),l(Al),l(Hl),l(Nt),l(El),l(Yl),l(Ht),l(Pl),l(Sl),l(Dl),l(Pt),l(Kl),l(Ol),l(ta),l(Dt),l(ea),l(la),l(aa),l(te),l(na),l(ee),l(sa),l(ia),l(le),l(oa),l(ra),l(pa),l(ae),l(ma),l(da),l(se),l(ua),l(fa),l(ha),l(ca),l(re),l(ga),l(ba),l(me),l(Ma),l(ya),l(ue),l(Ta),l(wa),l(he),l($a),l(Ja),l(Ua),l(be),l(_a),l(Me),l(va),l(ja),l(Ca),l(we),l(qa),l(ka),l(Za),l(Ue),l(Ga),l(Ia),l(za),l(ve),l(Qa),l(Ba),l(Ce),l(Wa),l(Va),l(Fa),l(Ze),l(Xa),l(Ra),l(Ie),l(xa),l(La),l(Qe),l(Na),l(Aa),l(Ha),l(Ve),l(Ea),l(Ya),l(Xe),l(Pa),l(P),l(Sa),l(S),l(Da),l(Re),l(Ka),l(Oa),l(Le),l(tn),l(D),l(en),l(Ne),l(ln),l(K),l(an),l(Ae),l(nn),l(He),l(sn),l(O),l(on),l(Pe)),l(n),b(r,t),b(k,t),b(G,t),b(lt,t),b(st,t),b(ot,t),b(mt,t),b(W,t),b(ht,t),b(gt,t),b(Mt,t),b(Tt,t),b($t,t),b(Jt,t),b(V,t),b(F,t),b(_t,t),b(jt,t),b(qt,t),b(X,t),b(kt,t),b(R,t),b(It,t),b(Qt,t),b(Wt,t),b(Ft,t),b(Rt,t),b(x,t),b(Lt,t),b(At,t),b(Et,t),b(Yt,t),b(St,t),b(L,t),b(Kt,t),b(Ot,t),b(N,t),b(A,t),b(H,t),b(ne,t),b(ie,t),b(oe,t),b(E,t),b(pe,t),b(de,t),b(fe,t),b(ce,t),b(ge,t),b(ye,t),b(Te,t),b($e,t),b(Je,t),b(_e,t),b(Y,t),b(je,t),b(qe,t),b(ke,t),b(Ge,t),b(ze,t),b(Be,t),b(We,t),b(Fe,t),b(xe,t)}}}const ei='{"title":"Quantization","local":"quantization","sections":[{"title":"AQLM","local":"aqlm","sections":[{"title":"PEFT","local":"peft","sections":[],"depth":3},{"title":"AQLM configurations","local":"aqlm-configurations","sections":[],"depth":3}],"depth":2},{"title":"AWQ","local":"awq","sections":[{"title":"Fused modules","local":"fused-modules","sections":[],"depth":3},{"title":"Exllama-v2 support","local":"exllama-v2-support","sections":[],"depth":3}],"depth":2},{"title":"AutoGPTQ","local":"autogptq","sections":[{"title":"ExLlama","local":"exllama","sections":[],"depth":3}],"depth":2},{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"8-bit","local":"8-bit","sections":[{"title":"Offloading","local":"offloading","sections":[],"depth":4},{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":4},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":4},{"title":"Finetuning","local":"finetuning","sections":[],"depth":4}],"depth":3},{"title":"4-bit","local":"4-bit","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":4},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":4},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Optimum","local":"optimum","sections":[],"depth":2},{"title":"Benchmarks","local":"benchmarks","sections":[{"title":"Fused AWQ modules","local":"fused-awq-modules","sections":[],"depth":3}],"depth":2}],"depth":1}';function li(U){return ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pi extends Zs{constructor(n){super(),Gs(this,n,li,ti,qs,{})}}export{pi as component};
